/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.ingest;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.VersionType;
import org.elasticsearch.ingest.ConfigurationUtils;
import org.elasticsearch.ingest.IngestDocument;
import org.elasticsearch.ingest.Pipeline;
import org.elasticsearch.ingest.PipelineStore;

public class SimulatePipelineRequest
extends ActionRequest
implements ToXContentObject {
    private String id;
    private boolean verbose;
    private BytesReference source;
    private XContentType xContentType;
    private static final Pipeline.Factory PIPELINE_FACTORY = new Pipeline.Factory();
    static final String SIMULATED_PIPELINE_ID = "_simulate_pipeline";

    @Deprecated
    public SimulatePipelineRequest(BytesReference source) {
        this(source, XContentHelper.xContentType(source));
    }

    public SimulatePipelineRequest(BytesReference source, XContentType xContentType) {
        this.source = Objects.requireNonNull(source);
        this.xContentType = Objects.requireNonNull(xContentType);
    }

    SimulatePipelineRequest() {
    }

    @Override
    public ActionRequestValidationException validate() {
        return null;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public BytesReference getSource() {
        return this.source;
    }

    public XContentType getXContentType() {
        return this.xContentType;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.id = in.readOptionalString();
        this.verbose = in.readBoolean();
        this.source = in.readBytesReference();
        this.xContentType = in.getVersion().onOrAfter(Version.V_5_3_0) ? in.readEnum(XContentType.class) : XContentHelper.xContentType(this.source);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeOptionalString(this.id);
        out.writeBoolean(this.verbose);
        out.writeBytesReference(this.source);
        if (out.getVersion().onOrAfter(Version.V_5_3_0)) {
            out.writeEnum(this.xContentType);
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.rawValue((InputStream)this.source.streamInput(), this.xContentType);
        return builder;
    }

    static Parsed parseWithPipelineId(String pipelineId, Map<String, Object> config, boolean verbose, PipelineStore pipelineStore) {
        if (pipelineId == null) {
            throw new IllegalArgumentException("param [pipeline] is null");
        }
        Pipeline pipeline = pipelineStore.get(pipelineId);
        if (pipeline == null) {
            throw new IllegalArgumentException("pipeline [" + pipelineId + "] does not exist");
        }
        List<IngestDocument> ingestDocumentList = SimulatePipelineRequest.parseDocs(config);
        return new Parsed(pipeline, ingestDocumentList, verbose);
    }

    static Parsed parse(Map<String, Object> config, boolean verbose, PipelineStore pipelineStore) throws Exception {
        Map<String, Object> pipelineConfig = ConfigurationUtils.readMap(null, null, config, "pipeline");
        Pipeline pipeline = PIPELINE_FACTORY.create(SIMULATED_PIPELINE_ID, pipelineConfig, pipelineStore.getProcessorFactories());
        List<IngestDocument> ingestDocumentList = SimulatePipelineRequest.parseDocs(config);
        return new Parsed(pipeline, ingestDocumentList, verbose);
    }

    private static List<IngestDocument> parseDocs(Map<String, Object> config) {
        List<Map> docs = ConfigurationUtils.readList(null, null, config, "docs");
        ArrayList<IngestDocument> ingestDocumentList = new ArrayList<IngestDocument>();
        for (Map dataMap : docs) {
            Map<String, Object> document = ConfigurationUtils.readMap(null, null, dataMap, "_source");
            String index = ConfigurationUtils.readStringOrIntProperty(null, null, dataMap, IngestDocument.MetaData.INDEX.getFieldName(), "_index");
            String type = ConfigurationUtils.readStringOrIntProperty(null, null, dataMap, IngestDocument.MetaData.TYPE.getFieldName(), "_type");
            String id = ConfigurationUtils.readStringOrIntProperty(null, null, dataMap, IngestDocument.MetaData.ID.getFieldName(), "_id");
            String routing = ConfigurationUtils.readOptionalStringOrIntProperty(null, null, dataMap, IngestDocument.MetaData.ROUTING.getFieldName());
            String parent = ConfigurationUtils.readOptionalStringOrIntProperty(null, null, dataMap, IngestDocument.MetaData.PARENT.getFieldName());
            Long version = null;
            if (dataMap.containsKey(IngestDocument.MetaData.VERSION.getFieldName())) {
                version = (Long)ConfigurationUtils.readObject(null, null, dataMap, IngestDocument.MetaData.VERSION.getFieldName());
            }
            VersionType versionType = null;
            if (dataMap.containsKey(IngestDocument.MetaData.VERSION_TYPE.getFieldName())) {
                versionType = VersionType.fromString(ConfigurationUtils.readStringProperty(null, null, dataMap, IngestDocument.MetaData.VERSION_TYPE.getFieldName()));
            }
            IngestDocument ingestDocument = new IngestDocument(index, type, id, routing, parent, version, versionType, document);
            ingestDocumentList.add(ingestDocument);
        }
        return ingestDocumentList;
    }

    static class Parsed {
        private final List<IngestDocument> documents;
        private final Pipeline pipeline;
        private final boolean verbose;

        Parsed(Pipeline pipeline, List<IngestDocument> documents, boolean verbose) {
            this.pipeline = pipeline;
            this.documents = Collections.unmodifiableList(documents);
            this.verbose = verbose;
        }

        public Pipeline getPipeline() {
            return this.pipeline;
        }

        public List<IngestDocument> getDocuments() {
            return this.documents;
        }

        public boolean isVerbose() {
            return this.verbose;
        }
    }

    public static final class Fields {
        static final String PIPELINE = "pipeline";
        static final String DOCS = "docs";
        static final String SOURCE = "_source";
    }
}

