/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.support.broadcast;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.function.Supplier;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.NoShardAvailableActionException;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.action.support.TransportActions;
import org.elasticsearch.action.support.broadcast.BroadcastRequest;
import org.elasticsearch.action.support.broadcast.BroadcastResponse;
import org.elasticsearch.action.support.broadcast.BroadcastShardOperationFailedException;
import org.elasticsearch.action.support.broadcast.BroadcastShardRequest;
import org.elasticsearch.action.support.broadcast.BroadcastShardResponse;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.routing.GroupShardsIterator;
import org.elasticsearch.cluster.routing.ShardIterator;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportChannel;
import org.elasticsearch.transport.TransportException;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportRequestHandler;
import org.elasticsearch.transport.TransportResponse;
import org.elasticsearch.transport.TransportResponseHandler;
import org.elasticsearch.transport.TransportService;

public abstract class TransportBroadcastAction<Request extends BroadcastRequest<Request>, Response extends BroadcastResponse, ShardRequest extends BroadcastShardRequest, ShardResponse extends BroadcastShardResponse>
extends HandledTransportAction<Request, Response> {
    protected final ClusterService clusterService;
    protected final TransportService transportService;
    final String transportShardAction;

    protected TransportBroadcastAction(Settings settings, String actionName, ThreadPool threadPool, ClusterService clusterService, TransportService transportService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, Supplier<Request> request, Supplier<ShardRequest> shardRequest, String shardExecutor) {
        super(settings, actionName, threadPool, transportService, actionFilters, indexNameExpressionResolver, request);
        this.clusterService = clusterService;
        this.transportService = transportService;
        this.transportShardAction = actionName + "[s]";
        transportService.registerRequestHandler(this.transportShardAction, shardRequest, shardExecutor, new ShardTransportHandler());
    }

    @Override
    protected void doExecute(Task task, Request request, ActionListener<Response> listener) {
        new AsyncBroadcastAction(this, task, request, listener).start();
    }

    @Override
    protected final void doExecute(Request request, ActionListener<Response> listener) {
        throw new UnsupportedOperationException("the task parameter is required for this operation");
    }

    protected abstract Response newResponse(Request var1, AtomicReferenceArray var2, ClusterState var3);

    protected abstract ShardRequest newShardRequest(int var1, ShardRouting var2, Request var3);

    protected abstract ShardResponse newShardResponse();

    protected abstract ShardResponse shardOperation(ShardRequest var1, Task var2) throws IOException;

    protected abstract GroupShardsIterator<ShardIterator> shards(ClusterState var1, Request var2, String[] var3);

    protected abstract ClusterBlockException checkGlobalBlock(ClusterState var1, Request var2);

    protected abstract ClusterBlockException checkRequestBlock(ClusterState var1, Request var2, String[] var3);

    class ShardTransportHandler
    implements TransportRequestHandler<ShardRequest> {
        ShardTransportHandler() {
        }

        @Override
        public void messageReceived(ShardRequest request, TransportChannel channel, Task task) throws Exception {
            channel.sendResponse((TransportResponse)TransportBroadcastAction.this.shardOperation(request, task));
        }

        @Override
        public final void messageReceived(ShardRequest request, TransportChannel channel) throws Exception {
            throw new UnsupportedOperationException("the task parameter is required");
        }
    }

    protected static class AsyncBroadcastAction {
        private final Task task;
        private final Request request;
        private final ActionListener<Response> listener;
        private final ClusterState clusterState;
        private final DiscoveryNodes nodes;
        private final GroupShardsIterator<ShardIterator> shardsIts;
        private final int expectedOps;
        private final AtomicInteger counterOps = new AtomicInteger();
        private final AtomicReferenceArray shardsResponses;
        final /* synthetic */ TransportBroadcastAction this$0;

        protected AsyncBroadcastAction(Task task, Request request, ActionListener<Response> listener) {
            this.this$0 = this$0;
            this.task = task;
            this.request = request;
            this.listener = listener;
            this.clusterState = this$0.clusterService.state();
            ClusterBlockException blockException = this$0.checkGlobalBlock(this.clusterState, request);
            if (blockException != null) {
                throw blockException;
            }
            String[] concreteIndices = ((TransportBroadcastAction)this$0).indexNameExpressionResolver.concreteIndexNames(this.clusterState, (IndicesRequest)request);
            blockException = this$0.checkRequestBlock(this.clusterState, request, concreteIndices);
            if (blockException != null) {
                throw blockException;
            }
            this.nodes = this.clusterState.nodes();
            ((TransportBroadcastAction)this$0).logger.trace("resolving shards based on cluster state version [{}]", (Object)this.clusterState.version());
            this.shardsIts = this$0.shards(this.clusterState, request, concreteIndices);
            this.expectedOps = this.shardsIts.size();
            this.shardsResponses = new AtomicReferenceArray(this.expectedOps);
        }

        public void start() {
            if (this.shardsIts.size() == 0) {
                try {
                    this.listener.onResponse(this.this$0.newResponse(this.request, new AtomicReferenceArray(0), this.clusterState));
                }
                catch (Exception e) {
                    this.listener.onFailure(e);
                }
                return;
            }
            int shardIndex = -1;
            for (ShardIterator shardIt : this.shardsIts) {
                ++shardIndex;
                ShardRouting shard = shardIt.nextOrNull();
                if (shard != null) {
                    this.performOperation(shardIt, shard, shardIndex);
                    continue;
                }
                this.onOperation(null, shardIt, shardIndex, new NoShardAvailableActionException(shardIt.shardId()));
            }
        }

        protected void performOperation(final ShardIterator shardIt, final ShardRouting shard, final int shardIndex) {
            if (shard == null) {
                this.onOperation(null, shardIt, shardIndex, new NoShardAvailableActionException(shardIt.shardId()));
            } else {
                try {
                    Object shardRequest = this.this$0.newShardRequest(shardIt.size(), shard, this.request);
                    shardRequest.setParentTask(this.this$0.clusterService.localNode().getId(), this.task.getId());
                    DiscoveryNode node = this.nodes.get(shard.currentNodeId());
                    if (node == null) {
                        this.onOperation(shard, shardIt, shardIndex, new NoShardAvailableActionException(shardIt.shardId()));
                    } else {
                        this.this$0.transportService.sendRequest(node, this.this$0.transportShardAction, (TransportRequest)shardRequest, new TransportResponseHandler<ShardResponse>(){

                            @Override
                            public ShardResponse newInstance() {
                                return AsyncBroadcastAction.this.this$0.newShardResponse();
                            }

                            @Override
                            public String executor() {
                                return "same";
                            }

                            @Override
                            public void handleResponse(ShardResponse response) {
                                AsyncBroadcastAction.this.onOperation(shard, shardIndex, response);
                            }

                            @Override
                            public void handleException(TransportException e) {
                                AsyncBroadcastAction.this.onOperation(shard, shardIt, shardIndex, e);
                            }
                        });
                    }
                }
                catch (Exception e) {
                    this.onOperation(shard, shardIt, shardIndex, e);
                }
            }
        }

        protected void onOperation(ShardRouting shard, int shardIndex, ShardResponse response) {
            this.this$0.logger.trace("received response for {}", (Object)shard);
            this.shardsResponses.set(shardIndex, response);
            if (this.expectedOps == this.counterOps.incrementAndGet()) {
                this.finishHim();
            }
        }

        void onOperation(@Nullable ShardRouting shard, ShardIterator shardIt, int shardIndex, Exception e) {
            this.setFailure(shardIt, shardIndex, e);
            ShardRouting nextShard = shardIt.nextOrNull();
            if (nextShard != null) {
                if (e != null && this.this$0.logger.isTraceEnabled() && !TransportActions.isShardNotAvailableException(e)) {
                    this.this$0.logger.trace((Message)new ParameterizedMessage("{}: failed to execute [{}]", shard != null ? shard.shortSummary() : shardIt.shardId(), this.request), (Throwable)e);
                }
                this.performOperation(shardIt, nextShard, shardIndex);
            } else {
                if (this.this$0.logger.isDebugEnabled() && e != null && !TransportActions.isShardNotAvailableException(e)) {
                    this.this$0.logger.debug((Message)new ParameterizedMessage("{}: failed to execute [{}]", shard != null ? shard.shortSummary() : shardIt.shardId(), this.request), (Throwable)e);
                }
                if (this.expectedOps == this.counterOps.incrementAndGet()) {
                    this.finishHim();
                }
            }
        }

        protected void finishHim() {
            try {
                this.listener.onResponse(this.this$0.newResponse(this.request, this.shardsResponses, this.clusterState));
            }
            catch (Exception e) {
                this.listener.onFailure(e);
            }
        }

        void setFailure(ShardIterator shardIt, int shardIndex, Exception e) {
            Object response;
            if (TransportActions.isShardNotAvailableException(e)) {
                return;
            }
            if (!(e instanceof BroadcastShardOperationFailedException)) {
                e = new BroadcastShardOperationFailedException(shardIt.shardId(), (Throwable)e);
            }
            if ((response = this.shardsResponses.get(shardIndex)) == null) {
                this.shardsResponses.set(shardIndex, e);
            }
            if (!(response instanceof Throwable)) {
                return;
            }
            if (TransportActions.isReadOverrideException(e)) {
                this.shardsResponses.set(shardIndex, e);
            }
        }
    }
}

