/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.action;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.Version;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestBuilder;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.TaskOperationFailure;
import org.elasticsearch.action.support.tasks.BaseTasksRequest;
import org.elasticsearch.action.support.tasks.BaseTasksResponse;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.xpack.core.ml.action.OpenJobAction;
import org.elasticsearch.xpack.core.ml.action.util.QueryPage;
import org.elasticsearch.xpack.core.ml.job.config.Job;
import org.elasticsearch.xpack.core.ml.job.config.JobState;
import org.elasticsearch.xpack.core.ml.job.process.autodetect.state.DataCounts;
import org.elasticsearch.xpack.core.ml.job.process.autodetect.state.ModelSizeStats;
import org.elasticsearch.xpack.core.ml.stats.ForecastStats;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;

public class GetJobsStatsAction
extends Action<Request, Response, RequestBuilder> {
    public static final GetJobsStatsAction INSTANCE = new GetJobsStatsAction();
    public static final String NAME = "cluster:monitor/xpack/ml/job/stats/get";
    private static final String DATA_COUNTS = "data_counts";
    private static final String MODEL_SIZE_STATS = "model_size_stats";
    private static final String FORECASTS_STATS = "forecasts_stats";
    private static final String STATE = "state";
    private static final String NODE = "node";

    private GetJobsStatsAction() {
        super(NAME);
    }

    public RequestBuilder newRequestBuilder(ElasticsearchClient client) {
        return new RequestBuilder(client, this);
    }

    public Response newResponse() {
        return new Response();
    }

    public static class Response
    extends BaseTasksResponse
    implements ToXContentObject {
        private QueryPage<JobStats> jobsStats;

        public Response(QueryPage<JobStats> jobsStats) {
            super(Collections.emptyList(), Collections.emptyList());
            this.jobsStats = jobsStats;
        }

        public Response(List<TaskOperationFailure> taskFailures, List<? extends ElasticsearchException> nodeFailures, QueryPage<JobStats> jobsStats) {
            super(taskFailures, nodeFailures);
            this.jobsStats = jobsStats;
        }

        public Response() {
            super(Collections.emptyList(), Collections.emptyList());
        }

        public QueryPage<JobStats> getResponse() {
            return this.jobsStats;
        }

        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.jobsStats = new QueryPage(in, JobStats::new);
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.jobsStats.writeTo(out);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            this.jobsStats.doXContentBody(builder, params);
            builder.endObject();
            return builder;
        }

        public int hashCode() {
            return Objects.hash(this.jobsStats);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            Response other = (Response)((Object)obj);
            return Objects.equals(this.jobsStats, other.jobsStats);
        }

        public final String toString() {
            return Strings.toString((ToXContent)this);
        }

        public static class JobStats
        implements ToXContentObject,
        Writeable {
            private final String jobId;
            private DataCounts dataCounts;
            @Nullable
            private ModelSizeStats modelSizeStats;
            @Nullable
            private ForecastStats forecastStats;
            @Nullable
            private TimeValue openTime;
            private JobState state;
            @Nullable
            private DiscoveryNode node;
            @Nullable
            private String assignmentExplanation;

            public JobStats(String jobId, DataCounts dataCounts, @Nullable ModelSizeStats modelSizeStats, @Nullable ForecastStats forecastStats, JobState state, @Nullable DiscoveryNode node, @Nullable String assignmentExplanation, @Nullable TimeValue opentime) {
                this.jobId = Objects.requireNonNull(jobId);
                this.dataCounts = Objects.requireNonNull(dataCounts);
                this.modelSizeStats = modelSizeStats;
                this.forecastStats = forecastStats;
                this.state = Objects.requireNonNull(state);
                this.node = node;
                this.assignmentExplanation = assignmentExplanation;
                this.openTime = opentime;
            }

            public JobStats(StreamInput in) throws IOException {
                this.jobId = in.readString();
                this.dataCounts = new DataCounts(in);
                this.modelSizeStats = (ModelSizeStats)in.readOptionalWriteable(ModelSizeStats::new);
                this.state = JobState.fromStream(in);
                this.node = (DiscoveryNode)in.readOptionalWriteable(DiscoveryNode::new);
                this.assignmentExplanation = in.readOptionalString();
                this.openTime = in.readOptionalTimeValue();
                if (in.getVersion().onOrAfter(Version.V_6_4_0)) {
                    this.forecastStats = (ForecastStats)in.readOptionalWriteable(ForecastStats::new);
                }
            }

            public String getJobId() {
                return this.jobId;
            }

            public DataCounts getDataCounts() {
                return this.dataCounts;
            }

            public ModelSizeStats getModelSizeStats() {
                return this.modelSizeStats;
            }

            public ForecastStats getForecastStats() {
                return this.forecastStats;
            }

            public JobState getState() {
                return this.state;
            }

            public DiscoveryNode getNode() {
                return this.node;
            }

            public String getAssignmentExplanation() {
                return this.assignmentExplanation;
            }

            public TimeValue getOpenTime() {
                return this.openTime;
            }

            public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
                builder.startObject();
                this.toUnwrappedXContent(builder);
                return builder.endObject();
            }

            public XContentBuilder toUnwrappedXContent(XContentBuilder builder) throws IOException {
                builder.field(Job.ID.getPreferredName(), this.jobId);
                builder.field(GetJobsStatsAction.DATA_COUNTS, (ToXContent)this.dataCounts);
                if (this.modelSizeStats != null) {
                    builder.field(GetJobsStatsAction.MODEL_SIZE_STATS, (ToXContent)this.modelSizeStats);
                }
                if (this.forecastStats != null) {
                    builder.field(GetJobsStatsAction.FORECASTS_STATS, (ToXContent)this.forecastStats);
                }
                builder.field(GetJobsStatsAction.STATE, this.state.toString());
                if (this.node != null) {
                    builder.startObject(GetJobsStatsAction.NODE);
                    builder.field("id", this.node.getId());
                    builder.field("name", this.node.getName());
                    builder.field("ephemeral_id", this.node.getEphemeralId());
                    builder.field("transport_address", this.node.getAddress().toString());
                    builder.startObject("attributes");
                    for (Map.Entry entry : this.node.getAttributes().entrySet()) {
                        builder.field((String)entry.getKey(), (String)entry.getValue());
                    }
                    builder.endObject();
                    builder.endObject();
                }
                if (this.assignmentExplanation != null) {
                    builder.field("assignment_explanation", this.assignmentExplanation);
                }
                if (this.openTime != null) {
                    builder.field("open_time", this.openTime.getStringRep());
                }
                return builder;
            }

            public void writeTo(StreamOutput out) throws IOException {
                out.writeString(this.jobId);
                this.dataCounts.writeTo(out);
                out.writeOptionalWriteable((Writeable)this.modelSizeStats);
                this.state.writeTo(out);
                out.writeOptionalWriteable((Writeable)this.node);
                out.writeOptionalString(this.assignmentExplanation);
                out.writeOptionalTimeValue(this.openTime);
                if (out.getVersion().onOrAfter(Version.V_6_4_0)) {
                    out.writeOptionalWriteable((Writeable)this.forecastStats);
                }
            }

            public int hashCode() {
                return Objects.hash(new Object[]{this.jobId, this.dataCounts, this.modelSizeStats, this.forecastStats, this.state, this.node, this.assignmentExplanation, this.openTime});
            }

            public boolean equals(Object obj) {
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                JobStats other = (JobStats)obj;
                return Objects.equals(this.jobId, other.jobId) && Objects.equals(this.dataCounts, other.dataCounts) && Objects.equals(this.modelSizeStats, other.modelSizeStats) && Objects.equals(this.forecastStats, other.forecastStats) && Objects.equals((Object)this.state, (Object)other.state) && Objects.equals(this.node, other.node) && Objects.equals(this.assignmentExplanation, other.assignmentExplanation) && Objects.equals(this.openTime, other.openTime);
            }
        }
    }

    public static class RequestBuilder
    extends ActionRequestBuilder<Request, Response, RequestBuilder> {
        public RequestBuilder(ElasticsearchClient client, GetJobsStatsAction action) {
            super(client, (Action)action, (ActionRequest)new Request());
        }
    }

    public static class Request
    extends BaseTasksRequest<Request> {
        public static final ParseField ALLOW_NO_JOBS = new ParseField("allow_no_jobs", new String[0]);
        private String jobId;
        private boolean allowNoJobs = true;
        private List<String> expandedJobsIds;

        public Request(String jobId) {
            this.jobId = ExceptionsHelper.requireNonNull(jobId, Job.ID.getPreferredName());
            this.expandedJobsIds = Collections.singletonList(jobId);
        }

        public Request() {
        }

        public List<String> getExpandedJobsIds() {
            return this.expandedJobsIds;
        }

        public void setExpandedJobsIds(List<String> expandedJobsIds) {
            this.expandedJobsIds = expandedJobsIds;
        }

        public void setAllowNoJobs(boolean allowNoJobs) {
            this.allowNoJobs = allowNoJobs;
        }

        public String getJobId() {
            return this.jobId;
        }

        public boolean allowNoJobs() {
            return this.allowNoJobs;
        }

        public boolean match(Task task) {
            return OpenJobAction.JobTaskMatcher.match(task, this.jobId);
        }

        public ActionRequestValidationException validate() {
            return null;
        }

        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.jobId = in.readString();
            this.expandedJobsIds = in.readList(StreamInput::readString);
            if (in.getVersion().onOrAfter(Version.V_6_1_0)) {
                this.allowNoJobs = in.readBoolean();
            }
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.jobId);
            out.writeStringList(this.expandedJobsIds);
            if (out.getVersion().onOrAfter(Version.V_6_1_0)) {
                out.writeBoolean(this.allowNoJobs);
            }
        }

        public int hashCode() {
            return Objects.hash(this.jobId, this.allowNoJobs);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            Request other = (Request)((Object)obj);
            return Objects.equals(this.jobId, other.jobId) && Objects.equals(this.allowNoJobs, other.allowNoJobs);
        }
    }
}

