/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.job.config;

import java.io.IOException;
import java.util.EnumMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.xpack.core.ml.MlParserType;

public class FilterRef
implements ToXContentObject,
Writeable {
    public static final ParseField FILTER_REF_FIELD = new ParseField("filter_ref", new String[0]);
    public static final ParseField FILTER_ID = new ParseField("filter_id", new String[0]);
    public static final ParseField FILTER_TYPE = new ParseField("filter_type", new String[0]);
    public static final ConstructingObjectParser<FilterRef, Void> METADATA_PARSER = new ConstructingObjectParser(FILTER_REF_FIELD.getPreferredName(), true, a -> new FilterRef((String)a[0], (FilterType)((Object)((Object)a[1]))));
    public static final ConstructingObjectParser<FilterRef, Void> CONFIG_PARSER = new ConstructingObjectParser(FILTER_REF_FIELD.getPreferredName(), false, a -> new FilterRef((String)a[0], (FilterType)((Object)((Object)a[1]))));
    public static final Map<MlParserType, ConstructingObjectParser<FilterRef, Void>> PARSERS = new EnumMap<MlParserType, ConstructingObjectParser<FilterRef, Void>>(MlParserType.class);
    private final String filterId;
    private final FilterType filterType;

    public FilterRef(String filterId, FilterType filterType) {
        this.filterId = Objects.requireNonNull(filterId);
        this.filterType = filterType == null ? FilterType.INCLUDE : filterType;
    }

    public FilterRef(StreamInput in) throws IOException {
        this.filterId = in.readString();
        this.filterType = (FilterType)in.readEnum(FilterType.class);
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.filterId);
        out.writeEnum((Enum)this.filterType);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(FILTER_ID.getPreferredName(), this.filterId);
        builder.field(FILTER_TYPE.getPreferredName(), (Object)this.filterType);
        builder.endObject();
        return builder;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof FilterRef)) {
            return false;
        }
        FilterRef other = (FilterRef)obj;
        return Objects.equals(this.filterId, other.filterId) && Objects.equals((Object)this.filterType, (Object)other.filterType);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.filterId, this.filterType});
    }

    public String getFilterId() {
        return this.filterId;
    }

    public FilterType getFilterType() {
        return this.filterType;
    }

    static {
        PARSERS.put(MlParserType.METADATA, METADATA_PARSER);
        PARSERS.put(MlParserType.CONFIG, CONFIG_PARSER);
        for (MlParserType parserType : MlParserType.values()) {
            ConstructingObjectParser<FilterRef, Void> parser = PARSERS.get((Object)parserType);
            assert (parser != null);
            parser.declareString(ConstructingObjectParser.constructorArg(), FILTER_ID);
            parser.declareField(ConstructingObjectParser.optionalConstructorArg(), p -> {
                if (p.currentToken() == XContentParser.Token.VALUE_STRING) {
                    return FilterType.fromString(p.text());
                }
                throw new IllegalArgumentException("Unsupported token [" + p.currentToken() + "]");
            }, FILTER_TYPE, ObjectParser.ValueType.STRING);
        }
    }

    public static enum FilterType {
        INCLUDE,
        EXCLUDE;


        public static FilterType fromString(String value) {
            return FilterType.valueOf(value.toUpperCase(Locale.ROOT));
        }

        public String toString() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }
}

