/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.authc.saml;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.xpack.core.ssl.SSLConfigurationSettings;
import org.elasticsearch.xpack.core.ssl.X509KeyPairSettings;

public class SamlRealmSettings {
    public static final String TYPE = "saml";
    private static final String TRANSIENT_NAMEID_FORMAT = "urn:oasis:names:tc:SAML:2.0:nameid-format:transient";
    private static final String IDP_METADATA_SETTING_PREFIX = "idp.metadata.";
    public static final Setting<String> IDP_ENTITY_ID = Setting.simpleString((String)"idp.entity_id", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    public static final Setting<String> IDP_METADATA_PATH = Setting.simpleString((String)"idp.metadata.path", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    public static final Setting<TimeValue> IDP_METADATA_HTTP_REFRESH = Setting.timeSetting((String)"idp.metadata.http.refresh", (TimeValue)TimeValue.timeValueHours((long)1L), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    public static final Setting<Boolean> IDP_SINGLE_LOGOUT = Setting.boolSetting((String)"idp.use_single_logout", (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    public static final Setting<String> SP_ENTITY_ID = Setting.simpleString((String)"sp.entity_id", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    public static final Setting<String> SP_ACS = Setting.simpleString((String)"sp.acs", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    public static final Setting<String> SP_LOGOUT = Setting.simpleString((String)"sp.logout", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    public static final Setting<String> NAMEID_FORMAT = new Setting("nameid_format", s -> "urn:oasis:names:tc:SAML:2.0:nameid-format:transient", Function.identity(), new Setting.Property[]{Setting.Property.NodeScope});
    public static final Setting<Boolean> NAMEID_ALLOW_CREATE = Setting.boolSetting((String)"nameid.allow_create", (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    public static final Setting<String> NAMEID_SP_QUALIFIER = Setting.simpleString((String)"nameid.sp_qualifier", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    public static final Setting<Boolean> FORCE_AUTHN = Setting.boolSetting((String)"force_authn", (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    public static final Setting<Boolean> POPULATE_USER_METADATA = Setting.boolSetting((String)"populate_user_metadata", (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    public static final AttributeSetting PRINCIPAL_ATTRIBUTE = new AttributeSetting("principal");
    public static final AttributeSetting GROUPS_ATTRIBUTE = new AttributeSetting("groups");
    public static final AttributeSetting DN_ATTRIBUTE = new AttributeSetting("dn");
    public static final AttributeSetting NAME_ATTRIBUTE = new AttributeSetting("name");
    public static final AttributeSetting MAIL_ATTRIBUTE = new AttributeSetting("mail");
    public static final X509KeyPairSettings ENCRYPTION_SETTINGS = new X509KeyPairSettings("encryption.", false);
    public static final Setting<String> ENCRYPTION_KEY_ALIAS = Setting.simpleString((String)"encryption.keystore.alias", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    public static final X509KeyPairSettings SIGNING_SETTINGS = new X509KeyPairSettings("signing.", false);
    public static final Setting<String> SIGNING_KEY_ALIAS = Setting.simpleString((String)"signing.keystore.alias", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    public static final Setting<List<String>> SIGNING_MESSAGE_TYPES = Setting.listSetting((String)"signing.saml_messages", Collections.singletonList("*"), Function.identity(), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    public static final Setting<List<String>> REQUESTED_AUTHN_CONTEXT_CLASS_REF = Setting.listSetting((String)"req_authn_context_class_ref", Collections.emptyList(), Function.identity(), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    public static final Setting<TimeValue> CLOCK_SKEW = Setting.positiveTimeSetting((String)"allowed_clock_skew", (TimeValue)TimeValue.timeValueMinutes((long)3L), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    public static final String SSL_PREFIX = "ssl.";

    private SamlRealmSettings() {
    }

    public static Set<Setting<?>> getSettings() {
        HashSet set = Sets.newHashSet((Object[])new Setting[]{IDP_ENTITY_ID, IDP_METADATA_PATH, IDP_SINGLE_LOGOUT, SP_ENTITY_ID, SP_ACS, SP_LOGOUT, NAMEID_FORMAT, NAMEID_ALLOW_CREATE, NAMEID_SP_QUALIFIER, FORCE_AUTHN, POPULATE_USER_METADATA, CLOCK_SKEW, ENCRYPTION_KEY_ALIAS, SIGNING_KEY_ALIAS, SIGNING_MESSAGE_TYPES, REQUESTED_AUTHN_CONTEXT_CLASS_REF});
        set.addAll(ENCRYPTION_SETTINGS.getAllSettings());
        set.addAll(SIGNING_SETTINGS.getAllSettings());
        set.addAll(SSLConfigurationSettings.withPrefix(SSL_PREFIX).getAllSettings());
        set.addAll(PRINCIPAL_ATTRIBUTE.settings());
        set.addAll(GROUPS_ATTRIBUTE.settings());
        set.addAll(DN_ATTRIBUTE.settings());
        set.addAll(NAME_ATTRIBUTE.settings());
        set.addAll(MAIL_ATTRIBUTE.settings());
        return set;
    }

    public static final class AttributeSetting {
        public static final String ATTRIBUTES_PREFIX = "attributes.";
        public static final String ATTRIBUTE_PATTERNS_PREFIX = "attribute_patterns.";
        private final Setting<String> attribute;
        private final Setting<String> pattern;

        public AttributeSetting(String name) {
            this.attribute = Setting.simpleString((String)(ATTRIBUTES_PREFIX + name), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
            this.pattern = Setting.simpleString((String)(ATTRIBUTE_PATTERNS_PREFIX + name), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
        }

        public Collection<Setting<?>> settings() {
            return Arrays.asList(this.getAttribute(), this.getPattern());
        }

        public String name() {
            return this.getAttribute().getKey();
        }

        public Setting<String> getAttribute() {
            return this.attribute;
        }

        public Setting<String> getPattern() {
            return this.pattern;
        }
    }
}

