/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.execution;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.DocWriteRequest;
import org.elasticsearch.action.admin.indices.refresh.RefreshRequest;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.search.ClearScrollRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchScrollRequest;
import org.elasticsearch.action.support.PlainActionFuture;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.routing.Preference;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.watcher.execution.Wid;
import org.elasticsearch.xpack.core.watcher.watch.Watch;
import org.elasticsearch.xpack.watcher.execution.TriggeredWatch;
import org.elasticsearch.xpack.watcher.watch.WatchStoreUtils;

public class TriggeredWatchStore
extends AbstractComponent {
    private final int scrollSize;
    private final Client client;
    private final TimeValue scrollTimeout;
    private final TriggeredWatch.Parser triggeredWatchParser;
    private final TimeValue defaultBulkTimeout;
    private final TimeValue defaultSearchTimeout;

    public TriggeredWatchStore(Settings settings, Client client, TriggeredWatch.Parser triggeredWatchParser) {
        super(settings);
        this.scrollSize = settings.getAsInt("xpack.watcher.execution.scroll.size", Integer.valueOf(1000));
        this.client = client;
        this.scrollTimeout = settings.getAsTime("xpack.watcher.execution.scroll.timeout", TimeValue.timeValueMinutes((long)5L));
        this.defaultBulkTimeout = settings.getAsTime("xpack.watcher.internal.ops.bulk.default_timeout", TimeValue.timeValueSeconds((long)120L));
        this.defaultSearchTimeout = settings.getAsTime("xpack.watcher.internal.ops.search.default_timeout", TimeValue.timeValueSeconds((long)30L));
        this.triggeredWatchParser = triggeredWatchParser;
    }

    public static boolean validate(ClusterState state) {
        IndexMetaData indexMetaData = WatchStoreUtils.getConcreteIndex(".triggered_watches", state.metaData());
        return indexMetaData == null || indexMetaData.getState() == IndexMetaData.State.OPEN && state.routingTable().index(indexMetaData.getIndex()).allPrimaryShardsActive();
    }

    public void putAll(List<TriggeredWatch> triggeredWatches, ActionListener<BulkResponse> listener) throws IOException {
        if (triggeredWatches.isEmpty()) {
            listener.onResponse((Object)new BulkResponse(new BulkItemResponse[0], 0L));
            return;
        }
        ClientHelper.executeAsyncWithOrigin((ThreadContext)this.client.threadPool().getThreadContext(), (String)"watcher", (ActionRequest)this.createBulkRequest(triggeredWatches, "doc"), listener, (arg_0, arg_1) -> ((Client)this.client).bulk(arg_0, arg_1));
    }

    public BulkResponse putAll(List<TriggeredWatch> triggeredWatches) throws IOException {
        PlainActionFuture future = PlainActionFuture.newFuture();
        this.putAll(triggeredWatches, (ActionListener<BulkResponse>)future);
        return (BulkResponse)future.actionGet(this.defaultBulkTimeout);
    }

    private BulkRequest createBulkRequest(List<TriggeredWatch> triggeredWatches, String docType) throws IOException {
        BulkRequest request = new BulkRequest();
        for (TriggeredWatch triggeredWatch : triggeredWatches) {
            IndexRequest indexRequest = new IndexRequest(".triggered_watches", docType, triggeredWatch.id().value());
            try (XContentBuilder builder = XContentFactory.jsonBuilder();){
                triggeredWatch.toXContent(builder, ToXContent.EMPTY_PARAMS);
                indexRequest.source(builder);
            }
            indexRequest.opType(DocWriteRequest.OpType.CREATE);
            request.add(indexRequest);
        }
        return request;
    }

    public void delete(Wid wid) {
        DeleteRequest request = new DeleteRequest(".triggered_watches", "doc", wid.value());
        try (ThreadContext.StoredContext ignore = ClientHelper.stashWithOrigin((ThreadContext)this.client.threadPool().getThreadContext(), (String)"watcher");){
            this.client.delete(request).actionGet(this.defaultBulkTimeout);
        }
        this.logger.trace("successfully deleted triggered watch with id [{}]", (Object)wid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Collection<TriggeredWatch> findTriggeredWatches(Collection<Watch> watches, ClusterState clusterState) {
        Throwable throwable;
        ThreadContext.StoredContext ignore;
        if (watches.isEmpty()) {
            return Collections.emptyList();
        }
        IndexMetaData indexMetaData = WatchStoreUtils.getConcreteIndex(".triggered_watches", clusterState.metaData());
        if (indexMetaData == null) {
            return Collections.emptyList();
        }
        try (ThreadContext.StoredContext ignore2 = ClientHelper.stashWithOrigin((ThreadContext)this.client.threadPool().getThreadContext(), (String)"watcher");){
            this.client.admin().indices().refresh(new RefreshRequest(new String[]{".triggered_watches"})).actionGet(TimeValue.timeValueSeconds((long)5L));
        }
        catch (IndexNotFoundException e) {
            return Collections.emptyList();
        }
        Set ids = watches.stream().map(Watch::id).collect(Collectors.toSet());
        ArrayList<TriggeredWatch> triggeredWatches = new ArrayList<TriggeredWatch>(ids.size());
        SearchRequest searchRequest = new SearchRequest(new String[]{".triggered_watches"}).scroll(this.scrollTimeout).preference(Preference.LOCAL.toString()).source(new SearchSourceBuilder().size(this.scrollSize).sort((SortBuilder)SortBuilders.fieldSort((String)"_doc")).version(Boolean.valueOf(true)));
        SearchResponse response = null;
        try {
            ignore = ClientHelper.stashWithOrigin((ThreadContext)this.client.threadPool().getThreadContext(), (String)"watcher");
            throwable = null;
            try {
                response = (SearchResponse)this.client.search(searchRequest).actionGet(this.defaultSearchTimeout);
                this.logger.debug("trying to find triggered watches for ids {}: found [{}] docs", ids, (Object)response.getHits().getTotalHits());
                while (response.getHits().getHits().length != 0) {
                    for (SearchHit hit : response.getHits()) {
                        Wid wid = new Wid(hit.getId());
                        if (!ids.contains(wid.watchId())) continue;
                        TriggeredWatch triggeredWatch = this.triggeredWatchParser.parse(hit.getId(), hit.getVersion(), hit.getSourceRef());
                        triggeredWatches.add(triggeredWatch);
                    }
                    SearchScrollRequest request = new SearchScrollRequest(response.getScrollId());
                    request.scroll(this.scrollTimeout);
                    response = (SearchResponse)this.client.searchScroll(request).actionGet(this.defaultSearchTimeout);
                }
                return triggeredWatches;
            }
            catch (Throwable request) {
                throwable = request;
                throw request;
            }
            finally {
                if (ignore != null) {
                    TriggeredWatchStore.$closeResource(throwable, (AutoCloseable)ignore);
                }
            }
        }
        finally {
            if (response != null) {
                ignore = ClientHelper.stashWithOrigin((ThreadContext)this.client.threadPool().getThreadContext(), (String)"watcher");
                throwable = null;
                try {
                    ClearScrollRequest clearScrollRequest = new ClearScrollRequest();
                    clearScrollRequest.addScrollId(response.getScrollId());
                    this.client.clearScroll(clearScrollRequest).actionGet(this.scrollTimeout);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (ignore != null) {
                        TriggeredWatchStore.$closeResource(throwable, (AutoCloseable)ignore);
                    }
                }
            }
        }
    }
}

