/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.notification.slack;

import java.util.Arrays;
import java.util.List;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.SecureSetting;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.xpack.watcher.common.http.HttpClient;
import org.elasticsearch.xpack.watcher.notification.NotificationService;
import org.elasticsearch.xpack.watcher.notification.slack.SlackAccount;

public class SlackService
extends NotificationService<SlackAccount> {
    private static final Setting<String> SETTING_DEFAULT_ACCOUNT = Setting.simpleString((String)"xpack.notification.slack.default_account", (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope});
    private static final Setting.AffixSetting<String> SETTING_URL = Setting.affixKeySetting((String)"xpack.notification.slack.account.", (String)"url", key -> Setting.simpleString((String)key, (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope, Setting.Property.Filtered}), (Setting.AffixSetting[])new Setting.AffixSetting[0]);
    private static final Setting.AffixSetting<SecureString> SETTING_URL_SECURE = Setting.affixKeySetting((String)"xpack.notification.slack.account.", (String)"secure_url", key -> SecureSetting.secureString((String)key, null, (Setting.Property[])new Setting.Property[0]), (Setting.AffixSetting[])new Setting.AffixSetting[0]);
    private static final Setting.AffixSetting<Settings> SETTING_DEFAULTS = Setting.affixKeySetting((String)"xpack.notification.slack.account.", (String)"message_defaults", key -> Setting.groupSetting((String)(key + "."), (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope}), (Setting.AffixSetting[])new Setting.AffixSetting[0]);
    private final HttpClient httpClient;

    public SlackService(Settings settings, HttpClient httpClient, ClusterSettings clusterSettings) {
        super(settings, "slack", clusterSettings, SlackService.getSettings());
        this.httpClient = httpClient;
        clusterSettings.addSettingsUpdateConsumer(SETTING_DEFAULT_ACCOUNT, s -> {});
        clusterSettings.addAffixUpdateConsumer(SETTING_URL, (s, o) -> {}, (s, o) -> {});
        clusterSettings.addAffixUpdateConsumer(SETTING_URL_SECURE, (s, o) -> {}, (s, o) -> {});
        clusterSettings.addAffixUpdateConsumer(SETTING_DEFAULTS, (s, o) -> {}, (s, o) -> {});
        this.reload(settings);
    }

    @Override
    protected SlackAccount createAccount(String name, Settings accountSettings) {
        return new SlackAccount(name, accountSettings, accountSettings, this.httpClient, this.logger);
    }

    public static List<Setting<?>> getSettings() {
        return Arrays.asList(SETTING_URL, SETTING_URL_SECURE, SETTING_DEFAULT_ACCOUNT, SETTING_DEFAULTS);
    }
}

