/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression;

import java.util.Objects;
import org.elasticsearch.common.Strings;
import org.elasticsearch.xpack.sql.expression.Attribute;
import org.elasticsearch.xpack.sql.expression.Expression;
import org.elasticsearch.xpack.sql.expression.ExpressionId;
import org.elasticsearch.xpack.sql.expression.TypedAttribute;
import org.elasticsearch.xpack.sql.tree.Location;
import org.elasticsearch.xpack.sql.tree.NodeInfo;
import org.elasticsearch.xpack.sql.type.DataType;
import org.elasticsearch.xpack.sql.type.EsField;

public class FieldAttribute
extends TypedAttribute {
    private final FieldAttribute parent;
    private final FieldAttribute nestedParent;
    private final String path;
    private final EsField field;

    public FieldAttribute(Location location, String name, EsField field) {
        this(location, null, name, field);
    }

    public FieldAttribute(Location location, FieldAttribute parent, String name, EsField field) {
        this(location, parent, name, field, null, true, null, false);
    }

    public FieldAttribute(Location location, FieldAttribute parent, String name, EsField field, String qualifier, boolean nullable, ExpressionId id, boolean synthetic) {
        super(location, name, field.getDataType(), qualifier, nullable, id, synthetic);
        this.path = parent != null ? parent.name() : "";
        this.parent = parent;
        this.field = field;
        FieldAttribute nestedPar = null;
        if (parent != null) {
            nestedPar = parent.nestedParent;
            if (parent.dataType() == DataType.NESTED) {
                nestedPar = parent;
            }
        }
        this.nestedParent = nestedPar;
    }

    @Override
    protected NodeInfo<FieldAttribute> info() {
        return NodeInfo.create(this, FieldAttribute::new, this.parent, this.name(), this.field, this.qualifier(), this.nullable(), this.id(), this.synthetic());
    }

    public FieldAttribute parent() {
        return this.parent;
    }

    public String path() {
        return this.path;
    }

    public String qualifiedPath() {
        return this.qualifier() != null ? this.qualifier() + (Strings.hasText((String)this.path) ? "." + this.path : "") : this.path;
    }

    public boolean isNested() {
        return this.nestedParent != null;
    }

    public FieldAttribute nestedParent() {
        return this.nestedParent;
    }

    public boolean isInexact() {
        return !this.field.isExact();
    }

    public FieldAttribute exactAttribute() {
        if (!this.field.isExact()) {
            return this.innerField(this.field.getExactField());
        }
        return this;
    }

    private FieldAttribute innerField(EsField type) {
        return new FieldAttribute(this.location(), this, this.name() + "." + type.getName(), type, this.qualifier(), this.nullable(), this.id(), this.synthetic());
    }

    @Override
    protected Expression canonicalize() {
        return new FieldAttribute(this.location(), null, "<none>", this.field, null, true, this.id(), false);
    }

    @Override
    protected Attribute clone(Location location, String name, String qualifier, boolean nullable, ExpressionId id, boolean synthetic) {
        FieldAttribute qualifiedParent = this.parent != null ? (FieldAttribute)this.parent.withQualifier(qualifier) : null;
        return new FieldAttribute(location, qualifiedParent, name, this.field, qualifier, nullable, id, synthetic);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.path);
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && Objects.equals(this.path, ((FieldAttribute)obj).path);
    }

    @Override
    protected String label() {
        return "f";
    }

    public EsField field() {
        return this.field;
    }
}

