/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.template.put;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.elasticsearch.ElasticsearchGenerationException;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.admin.indices.alias.Alias;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingRequest;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.master.MasterNodeRequest;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.collect.MapBuilder;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.DeprecationHandler;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.common.xcontent.json.JsonXContent;
import org.elasticsearch.common.xcontent.support.XContentMapValues;

public class PutIndexTemplateRequest
extends MasterNodeRequest<PutIndexTemplateRequest>
implements IndicesRequest,
ToXContent {
    private static final DeprecationLogger DEPRECATION_LOGGER = new DeprecationLogger(Loggers.getLogger(PutIndexTemplateRequest.class));
    private String name;
    private String cause = "";
    private List<String> indexPatterns;
    private int order;
    private boolean create;
    private Settings settings = Settings.Builder.EMPTY_SETTINGS;
    private Map<String, String> mappings = new HashMap<String, String>();
    private final Set<Alias> aliases = new HashSet<Alias>();
    private Map<String, IndexMetaData.Custom> customs = new HashMap<String, IndexMetaData.Custom>();
    private Integer version;

    public PutIndexTemplateRequest() {
    }

    public PutIndexTemplateRequest(String name) {
        this.name = name;
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.name == null) {
            validationException = ValidateActions.addValidationError("name is missing", validationException);
        }
        if (this.indexPatterns == null || this.indexPatterns.size() == 0) {
            validationException = ValidateActions.addValidationError("index patterns are missing", validationException);
        }
        return validationException;
    }

    public PutIndexTemplateRequest name(String name) {
        this.name = name;
        return this;
    }

    public String name() {
        return this.name;
    }

    public PutIndexTemplateRequest patterns(List<String> indexPatterns) {
        this.indexPatterns = indexPatterns;
        return this;
    }

    public List<String> patterns() {
        return this.indexPatterns;
    }

    public PutIndexTemplateRequest order(int order) {
        this.order = order;
        return this;
    }

    public int order() {
        return this.order;
    }

    public PutIndexTemplateRequest version(Integer version) {
        this.version = version;
        return this;
    }

    public Integer version() {
        return this.version;
    }

    public PutIndexTemplateRequest create(boolean create) {
        this.create = create;
        return this;
    }

    public boolean create() {
        return this.create;
    }

    public PutIndexTemplateRequest settings(Settings settings) {
        this.settings = settings;
        return this;
    }

    public PutIndexTemplateRequest settings(Settings.Builder settings) {
        this.settings = settings.build();
        return this;
    }

    public PutIndexTemplateRequest settings(String source, XContentType xContentType) {
        this.settings = Settings.builder().loadFromSource(source, xContentType).build();
        return this;
    }

    public PutIndexTemplateRequest settings(Map<String, Object> source) {
        try {
            XContentBuilder builder = XContentFactory.contentBuilder(XContentType.JSON);
            builder.map(source);
            this.settings(Strings.toString(builder), XContentType.JSON);
        }
        catch (IOException e) {
            throw new ElasticsearchGenerationException("Failed to generate [" + source + "]", e);
        }
        return this;
    }

    public Settings settings() {
        return this.settings;
    }

    public PutIndexTemplateRequest mapping(String type, String source, XContentType xContentType) {
        return this.mapping(type, new BytesArray(source), xContentType);
    }

    public PutIndexTemplateRequest cause(String cause) {
        this.cause = cause;
        return this;
    }

    public String cause() {
        return this.cause;
    }

    public PutIndexTemplateRequest mapping(String type, XContentBuilder source) {
        return this.mapping(type, BytesReference.bytes(source), source.contentType());
    }

    public PutIndexTemplateRequest mapping(String type, BytesReference source, XContentType xContentType) {
        Objects.requireNonNull(xContentType);
        try {
            this.mappings.put(type, XContentHelper.convertToJson(source, false, false, xContentType));
            return this;
        }
        catch (IOException e) {
            throw new UncheckedIOException("failed to convert source to json", e);
        }
    }

    public PutIndexTemplateRequest mapping(String type, Map<String, Object> source) {
        if (source.size() != 1 || !source.containsKey(type)) {
            source = MapBuilder.newMapBuilder().put(type, source).map();
        }
        try {
            XContentBuilder builder = XContentFactory.contentBuilder(XContentType.JSON);
            builder.map(source);
            return this.mapping(type, builder);
        }
        catch (IOException e) {
            throw new ElasticsearchGenerationException("Failed to generate [" + source + "]", e);
        }
    }

    public PutIndexTemplateRequest mapping(String type, Object ... source) {
        this.mapping(type, PutMappingRequest.buildFromSimplifiedDef(type, source));
        return this;
    }

    public Map<String, String> mappings() {
        return this.mappings;
    }

    public PutIndexTemplateRequest source(XContentBuilder templateBuilder) {
        try {
            return this.source(BytesReference.bytes(templateBuilder), templateBuilder.contentType());
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Failed to build json for template request", e);
        }
    }

    public PutIndexTemplateRequest source(Map templateSource) {
        Map source = templateSource;
        for (Map.Entry entry : source.entrySet()) {
            String name = (String)entry.getKey();
            if (name.equals("template")) {
                if (!(entry.getValue() instanceof String)) continue;
                DEPRECATION_LOGGER.deprecated("Deprecated field [template] used, replaced by [index_patterns]", new Object[0]);
                this.patterns(Collections.singletonList((String)entry.getValue()));
                continue;
            }
            if (name.equals("index_patterns")) {
                if (entry.getValue() instanceof String) {
                    this.patterns(Collections.singletonList((String)entry.getValue()));
                    continue;
                }
                if (entry.getValue() instanceof List) {
                    List<String> elements = ((List)entry.getValue()).stream().map(Object::toString).collect(Collectors.toList());
                    this.patterns(elements);
                    continue;
                }
                throw new IllegalArgumentException("Malformed [template] value, should be a string or a list of strings");
            }
            if (name.equals("order")) {
                this.order(XContentMapValues.nodeIntegerValue(entry.getValue(), this.order()));
                continue;
            }
            if ("version".equals(name)) {
                if (!(entry.getValue() instanceof Integer)) {
                    throw new IllegalArgumentException("Malformed [version] value, should be an integer");
                }
                this.version((Integer)entry.getValue());
                continue;
            }
            if (name.equals("settings")) {
                if (!(entry.getValue() instanceof Map)) {
                    throw new IllegalArgumentException("Malformed [settings] section, should include an inner object");
                }
                this.settings((Map)entry.getValue());
                continue;
            }
            if (name.equals("mappings")) {
                Map mappings = (Map)entry.getValue();
                for (Map.Entry entry1 : mappings.entrySet()) {
                    if (!(entry1.getValue() instanceof Map)) {
                        throw new IllegalArgumentException("Malformed [mappings] section for type [" + (String)entry1.getKey() + "], should include an inner object describing the mapping");
                    }
                    this.mapping((String)entry1.getKey(), (Map)entry1.getValue());
                }
                continue;
            }
            if (name.equals("aliases")) {
                this.aliases((Map)entry.getValue());
                continue;
            }
            Object proto = IndexMetaData.lookupPrototype(name);
            if (proto == null) continue;
            try {
                this.customs.put(name, proto.fromMap((Map)entry.getValue()));
            }
            catch (IOException e) {
                throw new ElasticsearchParseException("failed to parse custom metadata for [{}]", name);
            }
        }
        return this;
    }

    public PutIndexTemplateRequest source(String templateSource, XContentType xContentType) {
        return this.source(XContentHelper.convertToMap(xContentType.xContent(), templateSource, true));
    }

    public PutIndexTemplateRequest source(byte[] source, XContentType xContentType) {
        return this.source(source, 0, source.length, xContentType);
    }

    public PutIndexTemplateRequest source(byte[] source, int offset, int length, XContentType xContentType) {
        return this.source(new BytesArray(source, offset, length), xContentType);
    }

    public PutIndexTemplateRequest source(BytesReference source, XContentType xContentType) {
        return this.source(XContentHelper.convertToMap(source, true, xContentType).v2());
    }

    public PutIndexTemplateRequest custom(IndexMetaData.Custom custom) {
        this.customs.put(custom.type(), custom);
        return this;
    }

    public Map<String, IndexMetaData.Custom> customs() {
        return this.customs;
    }

    public Set<Alias> aliases() {
        return this.aliases;
    }

    public PutIndexTemplateRequest aliases(Map source) {
        try {
            XContentBuilder builder = XContentFactory.jsonBuilder();
            builder.map(source);
            return this.aliases(BytesReference.bytes(builder));
        }
        catch (IOException e) {
            throw new ElasticsearchGenerationException("Failed to generate [" + source + "]", e);
        }
    }

    public PutIndexTemplateRequest aliases(XContentBuilder source) {
        return this.aliases(BytesReference.bytes(source));
    }

    public PutIndexTemplateRequest aliases(String source) {
        return this.aliases(new BytesArray(source));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public PutIndexTemplateRequest aliases(BytesReference source) {
        try (XContentParser parser = XContentHelper.createParser(NamedXContentRegistry.EMPTY, LoggingDeprecationHandler.INSTANCE, source);){
            parser.nextToken();
            while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
                this.alias(Alias.fromXContent(parser));
            }
            PutIndexTemplateRequest putIndexTemplateRequest = this;
            return putIndexTemplateRequest;
        }
        catch (IOException e) {
            throw new ElasticsearchParseException("Failed to parse aliases", (Throwable)e, new Object[0]);
        }
    }

    public PutIndexTemplateRequest alias(Alias alias) {
        this.aliases.add(alias);
        return this;
    }

    @Override
    public String[] indices() {
        return this.indexPatterns.toArray(new String[this.indexPatterns.size()]);
    }

    @Override
    public IndicesOptions indicesOptions() {
        return IndicesOptions.strictExpand();
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.cause = in.readString();
        this.name = in.readString();
        this.indexPatterns = in.getVersion().onOrAfter(Version.V_6_0_0_alpha1) ? in.readList(StreamInput::readString) : Collections.singletonList(in.readString());
        this.order = in.readInt();
        this.create = in.readBoolean();
        this.settings = Settings.readSettingsFromStream(in);
        int size = in.readVInt();
        for (int i = 0; i < size; ++i) {
            String type = in.readString();
            String mappingSource = in.readString();
            if (in.getVersion().before(Version.V_5_3_0)) {
                mappingSource = XContentHelper.convertToJson(new BytesArray(mappingSource), false, false, XContentFactory.xContentType(mappingSource));
            }
            this.mappings.put(type, mappingSource);
        }
        int customSize = in.readVInt();
        for (int i = 0; i < customSize; ++i) {
            String type = in.readString();
            IndexMetaData.Custom customIndexMetaData = IndexMetaData.lookupPrototypeSafe(type).readFrom(in);
            this.customs.put(type, customIndexMetaData);
        }
        int aliasesSize = in.readVInt();
        for (int i = 0; i < aliasesSize; ++i) {
            this.aliases.add(Alias.read(in));
        }
        this.version = in.readOptionalVInt();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.cause);
        out.writeString(this.name);
        if (out.getVersion().onOrAfter(Version.V_6_0_0_alpha1)) {
            out.writeStringList(this.indexPatterns);
        } else {
            out.writeString(this.indexPatterns.size() > 0 ? this.indexPatterns.get(0) : "");
        }
        out.writeInt(this.order);
        out.writeBoolean(this.create);
        Settings.writeSettingsToStream(this.settings, out);
        out.writeVInt(this.mappings.size());
        for (Map.Entry<String, String> entry : this.mappings.entrySet()) {
            out.writeString(entry.getKey());
            out.writeString(entry.getValue());
        }
        out.writeVInt(this.customs.size());
        for (Map.Entry<String, Object> entry : this.customs.entrySet()) {
            out.writeString(entry.getKey());
            ((IndexMetaData.Custom)entry.getValue()).writeTo(out);
        }
        out.writeVInt(this.aliases.size());
        for (Alias alias : this.aliases) {
            alias.writeTo(out);
        }
        out.writeOptionalVInt(this.version);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field("index_patterns", this.indexPatterns);
        builder.field("order", this.order);
        if (this.version != null) {
            builder.field("version", this.version);
        }
        builder.startObject("settings");
        this.settings.toXContent(builder, params);
        builder.endObject();
        builder.startObject("mappings");
        for (Map.Entry<String, String> entry : this.mappings.entrySet()) {
            builder.field(entry.getKey());
            XContentParser parser = JsonXContent.jsonXContent.createParser(NamedXContentRegistry.EMPTY, DeprecationHandler.THROW_UNSUPPORTED_OPERATION, entry.getValue());
            builder.copyCurrentStructure(parser);
        }
        builder.endObject();
        builder.startObject("aliases");
        for (Alias alias : this.aliases) {
            alias.toXContent(builder, params);
        }
        builder.endObject();
        for (Map.Entry entry : this.customs.entrySet()) {
            builder.field((String)entry.getKey(), (ToXContent)entry.getValue(), params);
        }
        return builder;
    }
}

