/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.pdf;

import org.apache.fop.pdf.PDFPages;
import org.apache.fop.pdf.PDFResourceContext;
import org.apache.fop.pdf.PDFResources;
import org.apache.fop.pdf.PDFStream;
import org.apache.fop.pdf.TransitionDictionary;

public class PDFPage
extends PDFResourceContext {
    private String parentRef;
    protected PDFStream contents;
    protected int pagewidth;
    protected int pageheight;
    protected int pageIndex;
    protected int duration = -1;
    protected TransitionDictionary trDictionary = null;

    public PDFPage(PDFResources resources, PDFStream contents, int pageWidth, int pageHeight, int pageIndex) {
        super(resources);
        this.contents = contents;
        this.pagewidth = pageWidth;
        this.pageheight = pageHeight;
        this.pageIndex = pageIndex;
    }

    public PDFPage(PDFResources resources, int pageWidth, int pageHeight, int pageIndex) {
        this(resources, null, pageWidth, pageHeight, pageIndex);
    }

    public void setContents(PDFStream contents) {
        this.contents = contents;
    }

    public void setParent(PDFPages parent) {
        this.parentRef = parent.referencePDF();
    }

    public void setTransition(int dur, TransitionDictionary tr) {
        this.duration = dur;
        this.trDictionary = tr;
    }

    public int getWidth() {
        return this.pagewidth;
    }

    public int getHeight() {
        return this.pageheight;
    }

    public int getPageIndex() {
        return this.pageIndex;
    }

    public String toPDFString() {
        StringBuffer sb = new StringBuffer();
        String box = "[ 0 0 " + this.getWidth() + " " + this.getHeight() + " ]";
        sb = sb.append(this.getObjectID() + "<< /Type /Page\n" + "/Parent " + this.parentRef + "\n" + "/MediaBox " + box + "\n" + "/TrimBox " + box + "\n" + "/BleedBox " + box + "\n" + "/Resources " + this.resources.referencePDF() + "\n" + "/Contents " + this.contents.referencePDF() + "\n");
        if (this.annotList != null) {
            sb = sb.append("/Annots " + this.annotList.referencePDF() + "\n");
        }
        if (this.duration != -1) {
            sb = sb.append("/Dur " + this.duration + "\n");
        }
        if (this.trDictionary != null) {
            sb = sb.append("/Trans << " + this.trDictionary.getDictionary() + " >>\n");
        }
        sb = sb.append(">>\nendobj\n");
        return sb.toString();
    }
}

