/*
 * Decompiled with CFR 0.152.
 */
package com.martiansoftware.nailgun;

import com.martiansoftware.nailgun.Alias;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;

public class AliasManager {
    private Map aliases = new HashMap();

    public AliasManager() {
        try {
            Properties props = new Properties();
            props.load(this.getClass().getClassLoader().getResourceAsStream("com/martiansoftware/nailgun/builtins/builtins.properties"));
            this.loadFromProperties(props);
        }
        catch (IOException e) {
            System.err.println("Unable to load builtins.properties: " + e.getMessage());
        }
    }

    public void loadFromProperties(Properties properties) {
        Iterator<Object> i2 = properties.keySet().iterator();
        while (i2.hasNext()) {
            String key2 = (String)i2.next();
            if (key2.endsWith(".desc")) continue;
            try {
                Class<?> clazz = Class.forName(properties.getProperty(key2));
                String desc = properties.getProperty(key2 + ".desc", "");
                this.addAlias(new Alias(key2, desc, clazz));
            }
            catch (ClassNotFoundException e) {
                System.err.println("Unable to locate class " + properties.getProperty(key2));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAlias(Alias alias) {
        Map map2 = this.aliases;
        synchronized (map2) {
            this.aliases.put(alias.getName(), alias);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set getAliases() {
        TreeSet result2 = new TreeSet();
        Map map2 = this.aliases;
        synchronized (map2) {
            result2.addAll(this.aliases.values());
        }
        return result2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAlias(String aliasName) {
        Map map2 = this.aliases;
        synchronized (map2) {
            this.aliases.remove(aliasName);
        }
    }

    public Alias getAlias(String aliasName) {
        return (Alias)this.aliases.get(aliasName);
    }
}

