/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.listeners;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.listeners.InstructionsListener;
import org.jruby.ir.representations.BasicBlock;

public class InstructionsListenerDecorator
implements List<Instr> {
    private final BasicBlock basicBlock;
    private final List<Instr> instrs;
    private final InstructionsListener listener;

    public InstructionsListenerDecorator(BasicBlock basicBlock, List<Instr> instrs, InstructionsListener listener) {
        this.basicBlock = basicBlock;
        this.instrs = instrs;
        this.listener = listener;
    }

    @Override
    public int size() {
        return this.instrs.size();
    }

    @Override
    public boolean isEmpty() {
        return this.instrs.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.instrs.contains(o);
    }

    @Override
    public Iterator<Instr> iterator() {
        return new InstructionsListIterator();
    }

    @Override
    public Object[] toArray() {
        return this.instrs.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.instrs.toArray(a);
    }

    @Override
    public boolean add(Instr e) {
        int index2 = this.instrs.size() + 1;
        this.listener.instrChanged(this.basicBlock, null, e, index2, InstructionsListener.OperationType.ADD);
        return this.instrs.add(e);
    }

    @Override
    public boolean remove(Object o) {
        int index2 = this.instrs.indexOf(o);
        if (index2 != -1) {
            this.listener.instrChanged(this.basicBlock, (Instr)o, null, index2, InstructionsListener.OperationType.REMOVE);
        }
        return this.instrs.remove(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.instrs.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends Instr> c) {
        int lastIndex = this.instrs.size() - 1;
        return this.addAll(lastIndex, c);
    }

    @Override
    public boolean addAll(int index2, Collection<? extends Instr> c) {
        ListIterator<Instr> iterator = this.listIterator(index2);
        if (c.isEmpty()) {
            return false;
        }
        for (Instr instr : c) {
            iterator.add(instr);
        }
        return true;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean hasChanged = false;
        for (Object item : c) {
            boolean hasRemoved = this.remove(item);
            if (hasChanged) continue;
            hasChanged = hasRemoved;
        }
        return hasChanged;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        boolean hasChanged = false;
        ListIterator<Instr> iterator = this.listIterator();
        while (iterator.hasNext()) {
            int index2 = iterator.nextIndex();
            Instr instr = iterator.next();
            if (c.contains(instr)) continue;
            boolean hasRemoved = this.remove(instr);
            if (hasChanged) continue;
            hasChanged = hasRemoved;
        }
        return hasChanged;
    }

    @Override
    public void clear() {
        this.retainAll(Collections.emptySet());
    }

    @Override
    public Instr get(int index2) {
        return this.instrs.get(index2);
    }

    @Override
    public Instr set(int index2, Instr element) {
        Instr oldElement = this.instrs.get(index2);
        this.listener.instrChanged(this.basicBlock, oldElement, element, index2, InstructionsListener.OperationType.UPDATE);
        return this.instrs.set(index2, element);
    }

    @Override
    public void add(int index2, Instr element) {
        this.listener.instrChanged(this.basicBlock, null, element, index2, InstructionsListener.OperationType.ADD);
        this.instrs.add(index2, element);
    }

    @Override
    public Instr remove(int index2) {
        Instr element = this.instrs.remove(index2);
        this.listener.instrChanged(this.basicBlock, element, null, index2, InstructionsListener.OperationType.REMOVE);
        return element;
    }

    @Override
    public int indexOf(Object o) {
        return this.instrs.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.instrs.lastIndexOf(o);
    }

    @Override
    public ListIterator<Instr> listIterator() {
        return new InstructionsListIterator();
    }

    @Override
    public ListIterator<Instr> listIterator(int index2) {
        InstructionsListIterator iterator = new InstructionsListIterator();
        while (iterator.nextIndex() < index2) {
            iterator.next();
        }
        return iterator;
    }

    @Override
    public List<Instr> subList(int fromIndex, int toIndex) {
        return this.instrs.subList(fromIndex, toIndex);
    }

    private class InstructionsListIterator
    implements ListIterator<Instr> {
        private Instr currentInstr = null;
        private int currentIndex = -1;
        private final ListIterator<Instr> listIterator;

        public InstructionsListIterator() {
            this.listIterator = InstructionsListenerDecorator.this.instrs.listIterator();
        }

        @Override
        public boolean hasNext() {
            return this.listIterator.hasNext();
        }

        @Override
        public Instr next() {
            this.currentInstr = this.listIterator.next();
            ++this.currentIndex;
            return this.currentInstr;
        }

        @Override
        public boolean hasPrevious() {
            return this.listIterator.hasPrevious();
        }

        @Override
        public Instr previous() {
            this.currentInstr = this.listIterator.previous();
            --this.currentIndex;
            return this.currentInstr;
        }

        @Override
        public int nextIndex() {
            int index2 = this.currentIndex + 1;
            return index2 < InstructionsListenerDecorator.this.instrs.size() ? index2 : InstructionsListenerDecorator.this.instrs.size();
        }

        @Override
        public int previousIndex() {
            int index2 = this.currentIndex - 1;
            return index2 > -1 ? index2 : -1;
        }

        @Override
        public void remove() {
            InstructionsListenerDecorator.this.listener.instrChanged(InstructionsListenerDecorator.this.basicBlock, this.currentInstr, null, this.currentIndex, InstructionsListener.OperationType.REMOVE);
            this.listIterator.remove();
        }

        @Override
        public void set(Instr e) {
            InstructionsListenerDecorator.this.listener.instrChanged(InstructionsListenerDecorator.this.basicBlock, this.currentInstr, e, this.currentIndex, InstructionsListener.OperationType.UPDATE);
            this.listIterator.set(e);
        }

        @Override
        public void add(Instr e) {
            InstructionsListenerDecorator.this.listener.instrChanged(InstructionsListenerDecorator.this.basicBlock, (Instr)InstructionsListenerDecorator.this.instrs.get(this.currentIndex + 1), e, this.currentIndex + 1, InstructionsListener.OperationType.ADD);
            this.listIterator.add(e);
        }
    }
}

