/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.internal.impl;

final class PrioritizedComponent<T>
implements Comparable<PrioritizedComponent<?>> {
    private final T component;
    private final Class<?> type;
    private final float priority;
    private final int index;

    PrioritizedComponent(T component, Class<?> type2, float priority, int index2) {
        this.component = component;
        this.type = type2;
        this.priority = priority;
        this.index = index2;
    }

    public T getComponent() {
        return this.component;
    }

    public Class<?> getType() {
        return this.type;
    }

    public float getPriority() {
        return this.priority;
    }

    public boolean isDisabled() {
        return Float.isNaN(this.priority);
    }

    @Override
    public int compareTo(PrioritizedComponent<?> o) {
        int rel = (this.isDisabled() ? 1 : 0) - (o.isDisabled() ? 1 : 0);
        if (rel == 0 && (rel = Float.compare(o.priority, this.priority)) == 0) {
            rel = this.index - o.index;
        }
        return rel;
    }

    public String toString() {
        return this.priority + " (#" + this.index + "): " + String.valueOf(this.component);
    }
}

