/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import org.jruby.Ruby;
import org.jruby.RubyBignum;
import org.jruby.RubyBoolean;
import org.jruby.RubyFixnum;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.anno.JRubyMethod;
import org.jruby.anno.JRubyModule;
import org.jruby.runtime.CallSite;
import org.jruby.runtime.JavaSites;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

@JRubyModule(name={"Comparable"})
public class RubyComparable {
    private static final ThreadContext.RecursiveFunctionEx DEFAULT_INVCMP = new ThreadContext.RecursiveFunctionEx<IRubyObject>(){

        @Override
        public IRubyObject call(ThreadContext context, IRubyObject recv2, IRubyObject other, boolean recur) {
            if (recur || !RubyComparable.sites((ThreadContext)context).respond_to_op_cmp.respondsTo(context, other, other)) {
                return context.nil;
            }
            return RubyComparable.sites((ThreadContext)context).op_cmp.call(context, other, other, recv2);
        }
    };
    private static final CmpRecursive CMP_RECURSIVE = new CmpRecursive();

    public static RubyModule createComparable(Ruby runtime2) {
        RubyModule comparableModule = runtime2.defineModule("Comparable");
        runtime2.setComparable(comparableModule);
        comparableModule.defineAnnotatedMethods(RubyComparable.class);
        return comparableModule;
    }

    public static int cmpint(ThreadContext context, CallSite op_gt2, CallSite op_lt2, IRubyObject val, IRubyObject a, IRubyObject b2) {
        if (val == context.nil) {
            RubyComparable.cmperr(a, b2);
        }
        if (val instanceof RubyFixnum) {
            int asInt2 = RubyNumeric.fix2int((RubyFixnum)val);
            if (asInt2 > 0) {
                return 1;
            }
            if (asInt2 < 0) {
                return -1;
            }
            return 0;
        }
        if (val instanceof RubyBignum) {
            return ((RubyBignum)val).getValue().signum() == -1 ? -1 : 1;
        }
        RubyFixnum zero = RubyFixnum.zero(context.runtime);
        if (op_gt2.call(context, val, val, (IRubyObject)zero).isTrue()) {
            return 1;
        }
        if (op_lt2.call(context, val, val, (IRubyObject)zero).isTrue()) {
            return -1;
        }
        return 0;
    }

    public static int cmpint(ThreadContext context, IRubyObject val, IRubyObject a, IRubyObject b2) {
        JavaSites.ComparableSites sites = RubyComparable.sites(context);
        return RubyComparable.cmpint(context, sites.op_gt, sites.op_lt, val, a, b2);
    }

    public static int cmpAndCmpint(ThreadContext context, IRubyObject a, IRubyObject b2) {
        IRubyObject cmpResult = RubyComparable.sites((ThreadContext)context).op_cmp.call(context, a, a, b2);
        return RubyComparable.cmpint(context, cmpResult, a, b2);
    }

    public static int cmpAndCmpint(ThreadContext context, CallSite op_cmp2, CallSite op_gt2, CallSite op_lt2, IRubyObject a, IRubyObject b2) {
        IRubyObject cmpResult = op_cmp2.call(context, a, a, b2);
        return RubyComparable.cmpint(context, op_gt2, op_lt2, cmpResult, a, b2);
    }

    public static IRubyObject cmperr(IRubyObject recv2, IRubyObject other) {
        IRubyObject target = other.isImmediate() || !other.isNil() && !other.isTrue() && other != recv2.getRuntime().getFalse() ? other.inspect() : other.getType();
        throw recv2.getRuntime().newArgumentError("comparison of " + recv2.getType() + " with " + target + " failed");
    }

    public static IRubyObject invcmp(ThreadContext context, IRubyObject recv2, IRubyObject other) {
        return RubyComparable.invcmp(context, DEFAULT_INVCMP, recv2, other);
    }

    public static IRubyObject invcmp(ThreadContext context, ThreadContext.RecursiveFunctionEx func, IRubyObject recv2, IRubyObject other) {
        IRubyObject result2 = context.safeRecurse(func, recv2, other, "<=>", true);
        if (result2.isNil()) {
            return result2;
        }
        return RubyFixnum.newFixnum(context.runtime, -RubyComparable.cmpint(context, result2, recv2, other));
    }

    @JRubyMethod(name={"=="}, required=1)
    public static IRubyObject op_equal(ThreadContext context, IRubyObject recv2, IRubyObject other) {
        return RubyComparable.callCmpMethod(context, recv2, other, context.fals);
    }

    @Deprecated
    public static IRubyObject op_equal19(ThreadContext context, IRubyObject recv2, IRubyObject other) {
        return RubyComparable.op_equal(context, recv2, other);
    }

    private static IRubyObject callCmpMethod(ThreadContext context, IRubyObject recv2, IRubyObject other, IRubyObject returnValueOnError) {
        Ruby runtime2 = context.runtime;
        if (recv2 == other) {
            return context.tru;
        }
        IRubyObject result2 = context.safeRecurse(CMP_RECURSIVE, other, recv2, "<=>", true);
        if (result2.isNil()) {
            return returnValueOnError;
        }
        return RubyBoolean.newBoolean(runtime2, RubyComparable.cmpint(context, result2, recv2, other) == 0);
    }

    @JRubyMethod(name={">"}, required=1)
    public static RubyBoolean op_gt(ThreadContext context, IRubyObject recv2, IRubyObject other) {
        IRubyObject result2 = RubyComparable.sites((ThreadContext)context).op_cmp.call(context, recv2, recv2, other);
        if (result2.isNil()) {
            RubyComparable.cmperr(recv2, other);
        }
        return RubyBoolean.newBoolean(context.runtime, RubyComparable.cmpint(context, result2, recv2, other) > 0);
    }

    @JRubyMethod(name={">="}, required=1)
    public static RubyBoolean op_ge(ThreadContext context, IRubyObject recv2, IRubyObject other) {
        IRubyObject result2 = RubyComparable.sites((ThreadContext)context).op_cmp.call(context, recv2, recv2, other);
        if (result2.isNil()) {
            RubyComparable.cmperr(recv2, other);
        }
        return RubyBoolean.newBoolean(context.runtime, RubyComparable.cmpint(context, result2, recv2, other) >= 0);
    }

    @JRubyMethod(name={"<"}, required=1)
    public static RubyBoolean op_lt(ThreadContext context, IRubyObject recv2, IRubyObject other) {
        IRubyObject result2 = RubyComparable.sites((ThreadContext)context).op_cmp.call(context, recv2, recv2, other);
        if (result2.isNil()) {
            RubyComparable.cmperr(recv2, other);
        }
        return RubyBoolean.newBoolean(context.runtime, RubyComparable.cmpint(context, result2, recv2, other) < 0);
    }

    public static RubyBoolean op_lt(ThreadContext context, CallSite cmp2, IRubyObject recv2, IRubyObject other) {
        IRubyObject result2 = cmp2.call(context, recv2, recv2, other);
        if (result2.isNil()) {
            RubyComparable.cmperr(recv2, other);
        }
        return RubyBoolean.newBoolean(context.runtime, RubyComparable.cmpint(context, result2, recv2, other) < 0);
    }

    @JRubyMethod(name={"<="}, required=1)
    public static RubyBoolean op_le(ThreadContext context, IRubyObject recv2, IRubyObject other) {
        IRubyObject result2 = RubyComparable.sites((ThreadContext)context).op_cmp.call(context, recv2, recv2, other);
        if (result2.isNil()) {
            RubyComparable.cmperr(recv2, other);
        }
        return RubyBoolean.newBoolean(context.runtime, RubyComparable.cmpint(context, result2, recv2, other) <= 0);
    }

    @JRubyMethod(name={"between?"}, required=2)
    public static RubyBoolean between_p(ThreadContext context, IRubyObject recv2, IRubyObject first2, IRubyObject second2) {
        return context.runtime.newBoolean(RubyComparable.op_lt(context, recv2, first2).isFalse() && RubyComparable.op_gt(context, recv2, second2).isFalse());
    }

    @JRubyMethod(name={"clamp"})
    public static IRubyObject clamp(ThreadContext context, IRubyObject recv2, IRubyObject min2, IRubyObject max2) {
        JavaSites.ComparableSites sites = RubyComparable.sites(context);
        CallSite op_cmp2 = sites.op_cmp;
        CallSite op_gt2 = sites.op_gt;
        CallSite op_lt2 = sites.op_lt;
        if (RubyComparable.cmpAndCmpint(context, op_cmp2, op_gt2, op_lt2, min2, max2) > 0) {
            throw context.runtime.newArgumentError("min argument must be smaller than max argument");
        }
        int c = RubyComparable.cmpAndCmpint(context, op_cmp2, op_gt2, op_lt2, recv2, min2);
        if (c == 0) {
            return recv2;
        }
        if (c < 0) {
            return min2;
        }
        c = RubyComparable.cmpAndCmpint(context, op_cmp2, op_gt2, op_lt2, recv2, max2);
        if (c > 0) {
            return max2;
        }
        return recv2;
    }

    private static JavaSites.ComparableSites sites(ThreadContext context) {
        return context.sites.Comparable;
    }

    private static class CmpRecursive
    implements ThreadContext.RecursiveFunctionEx<IRubyObject> {
        private CmpRecursive() {
        }

        @Override
        public IRubyObject call(ThreadContext context, IRubyObject other, IRubyObject self2, boolean recur) {
            if (recur) {
                return context.nil;
            }
            return RubyComparable.sites((ThreadContext)context).op_cmp.call(context, self2, self2, other);
        }
    }
}

