/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Point2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jdesktop.layout.GroupLayout;
import org.jdesktop.swingx.JXHyperlink;
import org.jdesktop.swingx.JXMapViewer;
import org.jdesktop.swingx.JXNewMapViewer;
import org.jdesktop.swingx.JXPanel;
import org.jdesktop.swingx.mapviewer.DefaultTileFactory;
import org.jdesktop.swingx.mapviewer.GeoPosition;
import org.jdesktop.swingx.mapviewer.Tile;
import org.jdesktop.swingx.mapviewer.TileFactory;
import org.jdesktop.swingx.mapviewer.TileFactoryInfo;
import org.jdesktop.swingx.mapviewer.Waypoint;
import org.jdesktop.swingx.mapviewer.WaypointPainter;
import org.jdesktop.swingx.mapviewer.bmng.CylindricalProjectionTileFactory;
import org.jdesktop.swingx.painter.AbstractPainter;
import org.jdesktop.swingx.painter.CompoundPainter;
import org.jdesktop.swingx.painter.Painter;

public class JXMapKitNewMapViewer
extends JXPanel {
    private boolean miniMapVisible = true;
    private boolean zoomSliderVisible = true;
    private boolean zoomButtonsVisible = true;
    private final boolean sliderReversed = false;
    private DefaultProviders defaultProvider = DefaultProviders.SwingLabsBlueMarble;
    private boolean addressLocationShown = true;
    private boolean dataProviderCreditShown = false;
    private boolean dataProviderLinkShown = false;
    private GeoPosition mapCenterPosition = new GeoPosition(0.0, 0.0);
    private boolean zoomChanging = false;
    private JXHyperlink dataProviderLink;
    private JXMapViewer mainMap;
    private JXMapViewer miniMap;
    private JButton miniMapMaximizeButton;
    private JButton miniMapMinimizeButton;
    private JPanel sliderPanel;
    private JButton zoomInButton;
    private JButton zoomOutButton;
    private JSlider zoomSlider;
    private AbstractPainter dataProviderCreditPainter = new AbstractPainter<JXMapViewer>(false){

        protected void doPaint(Graphics2D g, JXMapViewer map, int width, int height) {
            g.setPaint(Color.WHITE);
            g.drawString("data ", 50, map.getHeight() - 10);
        }
    };
    private WaypointPainter addressLocationPainter = new WaypointPainter(){

        public Set<Waypoint> getWaypoints() {
            HashSet<Waypoint> set = new HashSet<Waypoint>();
            if (JXMapKitNewMapViewer.this.getAddressLocation() != null) {
                set.add(new Waypoint(JXMapKitNewMapViewer.this.getAddressLocation()));
            } else {
                set.add(new Waypoint(0.0, 0.0));
            }
            return set;
        }
    };

    public JXMapKitNewMapViewer() {
        this.initComponents();
        this.setDataProviderCreditShown(false);
        this.setDataProviderLinkShown(false);
        this.zoomSlider.setOpaque(false);
        try {
            ImageIcon minusIcon = new ImageIcon(((Object)((Object)this)).getClass().getResource("/org/jdesktop/swingx/mapviewer/resources/minus.png"));
            this.zoomOutButton.setIcon(minusIcon);
            this.zoomOutButton.setText("");
            ImageIcon plusIcon = new ImageIcon(((Object)((Object)this)).getClass().getResource("/org/jdesktop/swingx/mapviewer/resources/plus.png"));
            this.zoomInButton.setIcon(plusIcon);
            this.zoomInButton.setText("");
        }
        catch (Throwable thr) {
            System.out.println("error: " + thr.getMessage());
            thr.printStackTrace();
        }
        this.setTileFactory(new CylindricalProjectionTileFactory());
        this.mainMap.setRestrictOutsidePanning(true);
        this.miniMap.setRestrictOutsidePanning(true);
        this.setMiniMapVisible(this.miniMapVisible);
        this.rebuildMainMapOverlay();
        this.mainMap.addPropertyChangeListener("center", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                Point2D mapCenter = (Point2D)evt.getNewValue();
                GeoPosition mapPos = JXMapKitNewMapViewer.this.mainMap.getTileFactory().pixelToGeo(mapCenter, JXMapKitNewMapViewer.this.mainMap.getZoom());
                JXMapKitNewMapViewer.this.miniMap.setCenterPosition(mapPos);
            }
        });
        this.mainMap.addPropertyChangeListener("centerPosition", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                JXMapKitNewMapViewer.this.mapCenterPosition = (GeoPosition)evt.getNewValue();
                JXMapKitNewMapViewer.this.miniMap.setCenterPosition(JXMapKitNewMapViewer.this.mapCenterPosition);
                Point2D pt = JXMapKitNewMapViewer.this.miniMap.getTileFactory().geoToPixel(JXMapKitNewMapViewer.this.mapCenterPosition, JXMapKitNewMapViewer.this.miniMap.getZoom());
                JXMapKitNewMapViewer.this.miniMap.setCenter(pt);
            }
        });
        this.mainMap.addPropertyChangeListener("zoom", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                JXMapKitNewMapViewer.this.zoomSlider.setValue(JXMapKitNewMapViewer.this.mainMap.getZoom());
                JXMapKitNewMapViewer.this.miniMap.setZoom(JXMapKitNewMapViewer.this.mainMap.getZoom() + 4);
            }
        });
        this.miniMap.setOverlayPainter((Painter)new Painter<JXMapViewer>(){

            public void paint(Graphics2D g, JXMapViewer map, int width, int height) {
                Rectangle mainMapBounds = JXMapKitNewMapViewer.this.mainMap.getViewportBounds();
                Point2D upperLeft2D = mainMapBounds.getLocation();
                Point2D lowerRight2D = new Point2D.Double(upperLeft2D.getX() + mainMapBounds.getWidth(), upperLeft2D.getY() + mainMapBounds.getHeight());
                GeoPosition upperLeft = JXMapKitNewMapViewer.this.mainMap.getTileFactory().pixelToGeo(upperLeft2D, JXMapKitNewMapViewer.this.mainMap.getZoom());
                GeoPosition lowerRight = JXMapKitNewMapViewer.this.mainMap.getTileFactory().pixelToGeo(lowerRight2D, JXMapKitNewMapViewer.this.mainMap.getZoom());
                upperLeft2D = map.getTileFactory().geoToPixel(upperLeft, map.getZoom());
                lowerRight2D = map.getTileFactory().geoToPixel(lowerRight, map.getZoom());
                g = (Graphics2D)g.create();
                Rectangle rect = map.getViewportBounds();
                g.translate(-rect.x, -rect.y);
                g.setPaint(Color.RED);
                g.drawRect((int)upperLeft2D.getX(), (int)upperLeft2D.getY(), (int)(lowerRight2D.getX() - upperLeft2D.getX()), (int)(lowerRight2D.getY() - upperLeft2D.getY()));
                g.setPaint(new Color(255, 0, 0, 50));
                g.fillRect((int)upperLeft2D.getX(), (int)upperLeft2D.getY(), (int)(lowerRight2D.getX() - upperLeft2D.getX()), (int)(lowerRight2D.getY() - upperLeft2D.getY()));
                g.dispose();
            }
        });
    }

    public void setZoom(int zoom) {
        this.zoomChanging = true;
        this.mainMap.setZoom(zoom);
        this.zoomSlider.setValue(zoom);
        this.zoomChanging = false;
    }

    public Action getZoomOutAction() {
        AbstractAction act = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                JXMapKitNewMapViewer.this.setZoom(JXMapKitNewMapViewer.this.mainMap.getZoom() - 1);
            }
        };
        act.putValue("Name", "-");
        return act;
    }

    public Action getZoomInAction() {
        AbstractAction act = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                JXMapKitNewMapViewer.this.setZoom(JXMapKitNewMapViewer.this.mainMap.getZoom() + 1);
            }
        };
        act.putValue("Name", "+");
        return act;
    }

    private void initComponents() {
        this.mainMap = new JXNewMapViewer();
        this.miniMap = new JXNewMapViewer();
        this.miniMapMinimizeButton = new JButton();
        this.miniMapMaximizeButton = new JButton();
        this.sliderPanel = new JPanel();
        this.zoomOutButton = new JButton();
        this.zoomSlider = new JSlider();
        this.zoomInButton = new JButton();
        this.dataProviderLink = new JXHyperlink();
        this.dataProviderLink.setVisible(false);
        this.setLayout(new GridBagLayout());
        this.mainMap.setName("main");
        this.miniMap.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.miniMap.setMinimumSize(new Dimension(100, 100));
        this.miniMap.setName("mini");
        this.miniMap.setOpaque(false);
        this.miniMap.setPreferredSize(new Dimension(100, 100));
        this.miniMapMinimizeButton.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/org/jdesktop/swingx/mapviewer/resources/minus.png")));
        this.miniMapMinimizeButton.setMargin(new Insets(2, 2, 2, 2));
        this.miniMapMinimizeButton.setMaximumSize(new Dimension(20, 20));
        this.miniMapMinimizeButton.setMinimumSize(new Dimension(20, 20));
        this.miniMapMinimizeButton.setOpaque(false);
        this.miniMapMinimizeButton.setPreferredSize(new Dimension(20, 20));
        this.miniMapMinimizeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JXMapKitNewMapViewer.this.miniMapMinimizeButtonActionPerformed(evt);
            }
        });
        GroupLayout miniMapLayout = new GroupLayout((Container)((Object)this.miniMap));
        this.miniMap.setLayout((LayoutManager)miniMapLayout);
        miniMapLayout.setHorizontalGroup((GroupLayout.Group)miniMapLayout.createParallelGroup(1).add(0, 98, Short.MAX_VALUE).add((GroupLayout.Group)miniMapLayout.createParallelGroup(1).add((GroupLayout.Group)miniMapLayout.createSequentialGroup().addContainerGap(78, Short.MAX_VALUE).add((Component)this.miniMapMinimizeButton, -2, -1, -2).add(0, 0, 0))));
        miniMapLayout.setVerticalGroup((GroupLayout.Group)miniMapLayout.createParallelGroup(1).add(0, 98, Short.MAX_VALUE).add((GroupLayout.Group)miniMapLayout.createParallelGroup(1).add((GroupLayout.Group)miniMapLayout.createSequentialGroup().addContainerGap(78, Short.MAX_VALUE).add((Component)this.miniMapMinimizeButton, -2, -1, -2).add(0, 0, 0))));
        this.miniMapMaximizeButton.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/org/jdesktop/swingx/mapviewer/resources/plus.png")));
        this.miniMapMaximizeButton.setMargin(new Insets(2, 2, 2, 2));
        this.miniMapMaximizeButton.setMaximumSize(new Dimension(20, 20));
        this.miniMapMaximizeButton.setMinimumSize(new Dimension(20, 20));
        this.miniMapMaximizeButton.setOpaque(false);
        this.miniMapMaximizeButton.setPreferredSize(new Dimension(20, 20));
        this.miniMapMaximizeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JXMapKitNewMapViewer.this.miniMapMaximizeButtonActionPerformed(evt);
            }
        });
        this.sliderPanel.setOpaque(false);
        this.sliderPanel.setLayout(new GridBagLayout());
        this.zoomOutButton.setAction(this.getZoomInAction());
        this.zoomOutButton.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/org/jdesktop/swingx/mapviewer/resources/minus.png")));
        this.zoomOutButton.setMargin(new Insets(2, 2, 2, 2));
        this.zoomOutButton.setMaximumSize(new Dimension(20, 20));
        this.zoomOutButton.setMinimumSize(new Dimension(20, 20));
        this.zoomOutButton.setOpaque(false);
        this.zoomOutButton.setPreferredSize(new Dimension(20, 20));
        this.zoomOutButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JXMapKitNewMapViewer.this.zoomOutButtonActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 1.0;
        this.sliderPanel.add((Component)this.zoomOutButton, gridBagConstraints);
        this.zoomSlider.setMajorTickSpacing(1);
        this.zoomSlider.setMaximum(15);
        this.zoomSlider.setMinimum(10);
        this.zoomSlider.setMinorTickSpacing(1);
        this.zoomSlider.setOrientation(1);
        this.zoomSlider.setPaintTicks(true);
        this.zoomSlider.setSnapToTicks(true);
        this.zoomSlider.setMinimumSize(new Dimension(35, 100));
        this.zoomSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                JXMapKitNewMapViewer.this.zoomSliderStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 11;
        this.sliderPanel.add((Component)this.zoomSlider, gridBagConstraints);
        this.zoomInButton.setAction(this.getZoomOutAction());
        this.zoomInButton.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/org/jdesktop/swingx/mapviewer/resources/plus.png")));
        this.zoomInButton.setMargin(new Insets(2, 2, 2, 2));
        this.zoomInButton.setMaximumSize(new Dimension(20, 20));
        this.zoomInButton.setMinimumSize(new Dimension(20, 20));
        this.zoomInButton.setOpaque(false);
        this.zoomInButton.setPreferredSize(new Dimension(20, 20));
        this.zoomInButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JXMapKitNewMapViewer.this.zoomInButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.sliderPanel.add((Component)this.zoomInButton, gridBagConstraints);
        this.dataProviderLink.setText("Copyright");
        GroupLayout mainMapLayout = new GroupLayout((Container)((Object)this.mainMap));
        this.mainMap.setLayout((LayoutManager)mainMapLayout);
        mainMapLayout.setHorizontalGroup((GroupLayout.Group)mainMapLayout.createParallelGroup(1).add((GroupLayout.Group)mainMapLayout.createSequentialGroup().addContainerGap().add((Component)this.sliderPanel, -2, -1, -2).addPreferredGap(0).add((Component)this.dataProviderLink, -2, -1, -2).addPreferredGap(0, 196, Short.MAX_VALUE).add((Component)((Object)this.miniMap), -2, -1, -2)).add((GroupLayout.Group)mainMapLayout.createParallelGroup(1).add((GroupLayout.Group)mainMapLayout.createSequentialGroup().addContainerGap(380, Short.MAX_VALUE).add((Component)this.miniMapMaximizeButton, -2, -1, -2).add(0, 0, 0))));
        mainMapLayout.setVerticalGroup((GroupLayout.Group)mainMapLayout.createParallelGroup(1).add((GroupLayout.Group)mainMapLayout.createSequentialGroup().addContainerGap(69, Short.MAX_VALUE).add((GroupLayout.Group)mainMapLayout.createParallelGroup(1).add(2, (GroupLayout.Group)mainMapLayout.createSequentialGroup().add((GroupLayout.Group)mainMapLayout.createParallelGroup(2).add((Component)this.sliderPanel, -2, -1, -2).add((Component)this.dataProviderLink, -2, -1, -2)).addContainerGap()).add(2, (Component)((Object)this.miniMap), -2, -1, -2))).add((GroupLayout.Group)mainMapLayout.createParallelGroup(1).add((GroupLayout.Group)mainMapLayout.createSequentialGroup().addContainerGap(280, Short.MAX_VALUE).add((Component)this.miniMapMaximizeButton, -2, -1, -2).add(0, 0, 0))));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)((Object)this.mainMap), gridBagConstraints);
    }

    private void zoomInButtonActionPerformed(ActionEvent evt) {
        this.getZoomInAction();
    }

    private void zoomSliderStateChanged(ChangeEvent evt) {
        if (!this.zoomChanging) {
            this.setZoom(this.zoomSlider.getValue());
        }
    }

    private void zoomOutButtonActionPerformed(ActionEvent evt) {
        this.getZoomOutAction();
    }

    private void miniMapMinimizeButtonActionPerformed(ActionEvent evt) {
        this.setMiniMapVisible(false);
    }

    private void miniMapMaximizeButtonActionPerformed(ActionEvent evt) {
        this.setMiniMapVisible(true);
    }

    public boolean isMiniMapVisible() {
        return this.miniMapVisible;
    }

    public void setMiniMapVisible(boolean miniMapVisible) {
        boolean old = this.isMiniMapVisible();
        this.miniMapVisible = miniMapVisible;
        this.miniMapMaximizeButton.setVisible(!miniMapVisible);
        this.miniMapMinimizeButton.setVisible(miniMapVisible);
        this.miniMap.setVisible(miniMapVisible);
        this.firePropertyChange("miniMapVisible", old, this.isMiniMapVisible());
    }

    public boolean isZoomSliderVisible() {
        return this.zoomSliderVisible;
    }

    public void setZoomSliderVisible(boolean zoomSliderVisible) {
        boolean old = this.isZoomSliderVisible();
        this.zoomSliderVisible = zoomSliderVisible;
        this.zoomSlider.setVisible(zoomSliderVisible);
        this.firePropertyChange("zoomSliderVisible", old, this.isZoomSliderVisible());
    }

    public boolean isZoomButtonsVisible() {
        return this.zoomButtonsVisible;
    }

    public void setZoomButtonsVisible(boolean zoomButtonsVisible) {
        boolean old = this.isZoomButtonsVisible();
        this.zoomButtonsVisible = zoomButtonsVisible;
        this.zoomInButton.setVisible(zoomButtonsVisible);
        this.zoomOutButton.setVisible(zoomButtonsVisible);
        this.firePropertyChange("zoomButtonsVisible", old, this.isZoomButtonsVisible());
    }

    public void setTileFactory(TileFactory fact) {
        this.mainMap.setTileFactory(fact);
        this.miniMap.setTileFactory(fact);
        this.zoomSlider.setMinimum(fact.getInfo().getMinimumZoomLevel());
        this.zoomSlider.setMaximum(fact.getInfo().getMaximumZoomLevel());
    }

    public void setCenterPosition(GeoPosition pos) {
        this.mainMap.setCenterPosition(pos);
        this.miniMap.setCenterPosition(pos);
    }

    public GeoPosition getCenterPosition() {
        return this.mainMap.getCenterPosition();
    }

    public GeoPosition getAddressLocation() {
        return this.mainMap.getAddressLocation();
    }

    public void setAddressLocation(GeoPosition pos) {
        this.mainMap.setAddressLocation(pos);
    }

    public JXMapViewer getMainMap() {
        return this.mainMap;
    }

    public JXMapViewer getMiniMap() {
        return this.miniMap;
    }

    public JButton getZoomInButton() {
        return this.zoomInButton;
    }

    public JButton getZoomOutButton() {
        return this.zoomOutButton;
    }

    public JSlider getZoomSlider() {
        return this.zoomSlider;
    }

    public void setAddressLocationShown(boolean b) {
        boolean old = this.isAddressLocationShown();
        this.addressLocationShown = b;
        this.addressLocationPainter.setVisible(b);
        this.firePropertyChange("addressLocationShown", old, b);
        this.repaint();
    }

    public boolean isAddressLocationShown() {
        return this.addressLocationShown;
    }

    public void setDataProviderCreditShown(boolean b) {
        boolean old = this.isDataProviderCreditShown();
        this.dataProviderCreditShown = b;
        this.dataProviderCreditPainter.setVisible(b);
        this.repaint();
        this.firePropertyChange("dataProviderCreditShown", old, b);
    }

    public boolean isDataProviderCreditShown() {
        return this.dataProviderCreditShown;
    }

    public JXHyperlink getDataProviderLink() {
        return this.dataProviderLink;
    }

    public void setDataProviderLinkShown(boolean b) {
        boolean old = this.isDataProviderLinkShown();
        this.dataProviderLinkShown = b;
        this.dataProviderLink.setVisible(b);
        this.repaint();
        this.firePropertyChange("dataProviderLinkShown", old, b);
    }

    public boolean isDataProviderLinkShown() {
        return this.dataProviderLinkShown;
    }

    private void rebuildMainMapOverlay() {
        CompoundPainter cp = new CompoundPainter();
        cp.setCacheable(false);
        cp.setPainters(new Painter[]{this.dataProviderCreditPainter, this.addressLocationPainter});
        this.mainMap.setOverlayPainter((Painter)cp);
    }

    public void setDefaultProvider(DefaultProviders prov) {
        DefaultProviders old = this.defaultProvider;
        this.defaultProvider = prov;
        if (prov == DefaultProviders.SwingLabsBlueMarble) {
            this.setTileFactory(new CylindricalProjectionTileFactory());
            this.setZoom(3);
        }
        if (prov == DefaultProviders.OpenStreetMap) {
            int max = 19;
            TileFactoryInfo info = new TileFactoryInfo("osm", 1, 17, 19, 256, true, true, "http://tile.openstreetmap.org", "x", "y", "z"){

                public String getTileUrl(int x, int y, int zoom) {
                    zoom = 19 - zoom;
                    String url = this.baseURL + "/" + zoom + "/" + x + "/" + y + ".png";
                    return url;
                }
            };
            DefaultTileFactory tf = new DefaultTileFactory(info);
            this.setTileFactory(tf);
            tf = null;
            this.setZoom(11);
            this.setAddressLocation(new GeoPosition(51.5, 0.0));
        }
        this.firePropertyChange("defaultProvider", (Object)old, (Object)prov);
        this.repaint();
    }

    public DefaultProviders getDefaultProvider() {
        return this.defaultProvider;
    }

    public static void main(String ... args) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                JXMapKitNewMapViewer kit = new JXMapKitNewMapViewer();
                kit.setDefaultProvider(DefaultProviders.OpenStreetMap);
                Logger.getLogger(JXMapViewer.class.getName()).setLevel(Level.ALL);
                Logger.getLogger(Tile.class.getName());
                int max = 19;
                TileFactoryInfo info = new TileFactoryInfo("osm", 1, 17, 19, 256, true, true, "http://tile.openstreetmap.org", "x", "y", "z"){

                    public String getTileUrl(int x, int y, int zoom) {
                        zoom = 19 - zoom;
                        String url = this.baseURL + "/" + zoom + "/" + x + "/" + y + ".png";
                        return url;
                    }
                };
                DefaultTileFactory tf = new DefaultTileFactory(info);
                tf.getTileCache().setDiskCacheDir(new File("c:/temp/mapcache"));
                LogManager lm = LogManager.getLogManager();
                Enumeration<String> iter = lm.getLoggerNames();
                while (iter.hasMoreElements()) {
                    Logger l = LogManager.getLogManager().getLogger(iter.nextElement());
                    l.setLevel(Level.ALL);
                }
                kit.setTileFactory(tf);
                kit.setZoom(14);
                kit.setAddressLocation(new GeoPosition(51.5, 0.0));
                kit.getMainMap().setDrawTileBorders(true);
                kit.getMainMap().setRestrictOutsidePanning(true);
                kit.getMainMap().setHorizontalWrapped(false);
                JFrame frame = new JFrame("JXMapKit test");
                frame.setDefaultCloseOperation(3);
                frame.add((Component)((Object)kit));
                frame.pack();
                frame.setSize(500, 300);
                frame.setVisible(true);
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DefaultProviders {
        SwingLabsBlueMarble,
        OpenStreetMap,
        Custom;

    }
}

