/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.jmol.app.jsonkiosk;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javajs.util.Lst;
import javajs.util.P3;
import javajs.util.PT;
import javajs.util.SB;
import naga.ConnectionAcceptor;
import naga.NIOServerSocket;
import naga.NIOService;
import naga.NIOSocket;
import naga.ServerSocketObserverAdapter;
import naga.SocketObserver;
import naga.SocketObserverAdapter;
import naga.packetreader.AsciiLinePacketReader;
import naga.packetwriter.RawPacketWriter;
import org.jmol.script.SV;
import org.jmol.util.Escape;
import org.jmol.util.Logger;
import org.jmol.viewer.Viewer;
import org.openscience.jmol.app.jsonkiosk.JsonNioClient;
import org.openscience.jmol.app.jsonkiosk.JsonNioServer;

public class JsonNioService
extends NIOService
implements JsonNioServer {
    protected String myName;
    protected boolean halt;
    protected boolean isPaused;
    protected long latestMoveTime;
    protected int port;
    private Thread thread;
    private Thread serverThread;
    private NIOSocket inSocket;
    protected NIOSocket outSocket;
    private NIOServerSocket serverSocket;
    Viewer vwr;
    private JsonNioClient client;
    private boolean wasSpinOn;
    private String contentPath = "./%ID%.json";
    private String terminatorMessage = "NEXT_SCRIPT";
    private String resetMessage = "RESET_SCRIPT";
    protected int version = 1;
    private int nFast;
    private float swipeCutoff = 100.0f;
    private int swipeCount = 2;
    private float swipeDelayMs = 3000.0f;
    private long previousMoveTime;
    private long swipeStartTime;
    private float swipeFactor = 30.0f;
    private boolean motionDisabled;
    private boolean contentDisabled;

    @Override
    public void scriptCallback(String msg) {
        if (msg == null) {
            return;
        }
        if (msg.startsWith("banner:")) {
            this.setBanner(msg.substring(7).trim(), false);
        } else if (msg.equals(this.terminatorMessage)) {
            this.sendMessage(null, "!script_terminated!", null);
        } else if (this.contentDisabled && msg.equals(this.resetMessage)) {
            this.client.nioRunContent(null);
        }
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public void send(int port, String msg) {
        try {
            if (port != this.port) {
                if (this.inSocket != null) {
                    this.inSocket.close();
                    if (this.outSocket != null) {
                        this.outSocket.close();
                    }
                }
                if (this.thread != null) {
                    this.thread.interrupt();
                    this.thread = null;
                }
                this.startService(port, this.client, this.vwr, this.myName, 1);
            }
            if (msg.startsWith("Mouse:")) {
                msg = "{\"type\":\"sync\", \"sync\":\"" + msg.substring(6) + "\"}";
            }
            this.sendMessage(null, msg, null);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void startService(int port, JsonNioClient client, Viewer jmolViewer, String name, int version) throws IOException {
        this.version = version;
        this.port = Math.abs(port);
        this.client = client;
        this.vwr = jmolViewer;
        String string = this.myName = name == null ? "" : name;
        if (port < 0) {
            this.startServerService();
            return;
        }
        if (name != null) {
            String s = JsonNioService.getJmolValueAsString(jmolViewer, "NIOcontentPath");
            if (s != "") {
                this.contentPath = s;
            }
            if ((s = JsonNioService.getJmolValueAsString(jmolViewer, "NIOterminatorMessage")) != "") {
                this.terminatorMessage = s;
            }
            if ((s = JsonNioService.getJmolValueAsString(jmolViewer, "NIOresetMessage")) != "") {
                this.resetMessage = s;
            }
            this.setEnabled();
            Logger.info("NIOcontentPath=" + this.contentPath);
            Logger.info("NIOterminatorMessage=" + this.terminatorMessage);
            Logger.info("NIOresetMessage=" + this.resetMessage);
            Logger.info("NIOcontentDisabled=" + this.contentDisabled);
            Logger.info("NIOmotionDisabled=" + this.motionDisabled);
        }
        Logger.info("JsonNioService" + this.myName + " using port " + port);
        if (port != 0) {
            this.inSocket = this.openSocket("127.0.0.1", port);
            this.inSocket.setPacketReader(new AsciiLinePacketReader());
            this.inSocket.setPacketWriter(RawPacketWriter.INSTANCE);
            this.inSocket.listen(new SocketObserver(){

                @Override
                public void connectionOpened(NIOSocket nioSocket) {
                    JsonNioService.this.initialize("out", nioSocket);
                }

                @Override
                public void packetReceived(NIOSocket socket, byte[] packet) {
                    JsonNioService.this.processMessage(packet, null);
                }

                @Override
                public void connectionBroken(NIOSocket nioSocket, Exception exception) {
                    JsonNioService.this.halt = true;
                    Logger.info(Thread.currentThread().getName() + " inSocket connectionBroken");
                }

                @Override
                public void packetSent(NIOSocket arg0, Object arg1) {
                }
            });
            if (version == 1) {
                this.outSocket = this.openSocket("127.0.0.1", port);
                this.outSocket.setPacketReader(new AsciiLinePacketReader());
                this.outSocket.setPacketWriter(RawPacketWriter.INSTANCE);
                this.outSocket.listen(new SocketObserver(){

                    @Override
                    public void connectionOpened(NIOSocket nioSocket) {
                        JsonNioService.this.initialize("in", nioSocket);
                    }

                    @Override
                    public void packetReceived(NIOSocket nioSocket, byte[] packet) {
                        Logger.info("outpacketreceived");
                    }

                    @Override
                    public void connectionBroken(NIOSocket nioSocket, Exception exception) {
                        JsonNioService.this.halt = true;
                        Logger.info(Thread.currentThread().getName() + " outSocket connectionBroken");
                    }

                    @Override
                    public void packetSent(NIOSocket arg0, Object arg1) {
                    }
                });
            }
        }
        if (port != 0) {
            this.thread = new Thread((Runnable)new JsonNioThread(), "JsonNiosThread" + this.myName);
            this.thread.start();
        }
        if (port == 0 && this.contentDisabled) {
            client.nioRunContent(this);
        }
    }

    private void setEnabled() {
        this.contentDisabled = JsonNioService.getJmolValueAsString(this.vwr, "NIOcontentDisabled").equals("true");
        this.motionDisabled = JsonNioService.getJmolValueAsString(this.vwr, "NIOmotionDisabled").equals("true");
    }

    public static String getJmolValueAsString(Viewer vwr, String var) {
        return vwr == null ? "" : "" + vwr.getP(var);
    }

    @Override
    public void close() {
        Logger.info("JsonNioService" + this.myName + " close");
        try {
            this.halt = true;
            super.close();
            if (this.thread != null) {
                this.thread.interrupt();
                this.thread = null;
            }
            if (this.serverThread != null) {
                this.serverThread.interrupt();
                this.serverThread = null;
            }
            if (this.inSocket != null) {
                this.inSocket.close();
            }
            if (this.outSocket != null) {
                this.outSocket.close();
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        if (this.client != null) {
            this.client.nioClosed(this);
        }
    }

    protected void initialize(String role, NIOSocket nioSocket) {
        Logger.info("JsonNioService" + this.myName + " initialize " + role);
        JSONObject json = new JSONObject();
        if (this.version == 1) {
            json.put("magic", "JmolApp");
            json.put("role", role);
        } else {
            json.put("source", "Jmol");
            json.put("type", "login");
        }
        this.sendMessage(json, null, nioSocket);
    }

    private void startServerService() {
        try {
            this.serverSocket = this.openServerSocket(this.port);
            this.serverSocket.listen(new ServerSocketObserverAdapter(){

                @Override
                public void newConnection(NIOSocket nioSocket) {
                    Logger.info(Thread.currentThread().getName() + " Received connection: " + nioSocket);
                    nioSocket.setPacketReader(new AsciiLinePacketReader());
                    nioSocket.setPacketWriter(RawPacketWriter.INSTANCE);
                    nioSocket.listen(new SocketObserverAdapter(){

                        @Override
                        public void packetReceived(NIOSocket socket, byte[] packet) {
                            JsonNioService.this.processMessage(packet, socket);
                        }

                        @Override
                        public void connectionOpened(NIOSocket arg0) {
                        }

                        @Override
                        public void connectionBroken(NIOSocket socket, Exception arg1) {
                            Logger.info("JsonNioService" + JsonNioService.this.myName + " server connection broken");
                            if (socket == JsonNioService.this.outSocket) {
                                JsonNioService.this.outSocket = null;
                            }
                        }
                    });
                }
            });
            this.serverSocket.setConnectionAcceptor(new ConnectionAcceptor(){

                @Override
                public boolean acceptConnection(InetSocketAddress arg0) {
                    boolean isOK = arg0.getAddress().isLoopbackAddress();
                    return isOK;
                }
            });
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this.serverThread != null) {
            this.serverThread.interrupt();
        }
        this.serverThread = new Thread((Runnable)new JsonNioServerThread(), "JsonNioServerThread" + this.myName);
        this.serverThread.start();
    }

    protected void processMessage(byte[] packet, NIOSocket socket) {
        try {
            String msg = new String(packet);
            Logger.info("JNIOS received " + msg);
            if (this.vwr == null) {
                return;
            }
            JSONObject json = new JSONObject(msg);
            if (this.version == 1) {
                if (socket != null && json.has("magic") && json.getString("magic").equals("JmolApp") && json.getString("role").equals("out")) {
                    this.outSocket = socket;
                }
            } else {
                this.outSocket = this.inSocket;
            }
            if (!json.has("type")) {
                return;
            }
            this.processJSON(json, msg);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private void processJSON(JSONObject json, String msg) throws Exception {
        if (json == null) {
            json = new JSONObject(msg);
        }
        int pt = "banner....command...content...move......quit......sync......touch.....".indexOf(json.getString("type"));
        this.setEnabled();
        switch (pt) {
            case 0: {
                if (this.contentDisabled) break;
                this.setBanner((String)(json.has("text") ? json.getString("text") : (json.getString("visibility").equalsIgnoreCase("off") ? null : "")), false);
                break;
            }
            case 10: {
                if (this.contentDisabled) break;
                if (json.containsKey("var") && json.containsKey("data")) {
                    this.vwr.g.setUserVariable(json.get("var").toString(), SV.getVariable(json.get("data")));
                }
                this.sendScript(json.getString("command"));
                break;
            }
            case 20: {
                if (this.contentDisabled) {
                    this.client.nioRunContent(this);
                    break;
                }
                String id = json.getString("id");
                String path = PT.rep(this.contentPath, "%ID%", id).replace('\\', '/');
                File f = new File(path);
                Logger.info("JsonNiosService Setting path to " + f.getAbsolutePath());
                pt = path.lastIndexOf(47);
                path = pt >= 0 ? path.substring(0, pt) : ".";
                JSONObject contentJSON = null;
                try {
                    String line;
                    BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(f), "UTF-8"));
                    SB sb = SB.newN(8192);
                    while ((line = br.readLine()) != null) {
                        sb.append(line).appendC('\n');
                    }
                    br.close();
                    contentJSON = new JSONObject(sb.toString());
                }
                catch (UnsupportedEncodingException br) {
                    // empty catch block
                }
                String script = null;
                if (contentJSON.has("scripts")) {
                    List<JSONObject> scripts = contentJSON.getJSONArray("scripts");
                    int i = scripts.size();
                    while (--i >= 0) {
                        JSONObject scriptInfo = scripts.get(i);
                        if (!scriptInfo.getString("startup").equals("yes")) continue;
                        script = scriptInfo.getString("filename");
                        break;
                    }
                    if (script == null) {
                        throw new Exception("scripts startup:yes not found");
                    }
                } else {
                    script = contentJSON.getString("startup_script");
                }
                Logger.info("JsonNiosService startup_script=" + script);
                this.setBanner("", false);
                this.sendScript("exit");
                this.sendScript("zap;cd \"" + path + "\";script " + script);
                this.setBanner(contentJSON.getString("banner").equals("off") ? null : contentJSON.getString("banner_text"), true);
                break;
            }
            case 30: {
                pt = "rotate....translate.zoom......".indexOf(json.getString("style"));
                if (this.motionDisabled) break;
                if (pt != 0 && !this.isPaused) {
                    this.pauseScript(true);
                }
                long now = this.latestMoveTime = System.currentTimeMillis();
                switch (pt) {
                    case 0: {
                        boolean disallowSpinGesture;
                        float dx = (float)json.getDouble("x");
                        float dy = (float)json.getDouble("y");
                        float dxdy = dx * dx + dy * dy;
                        boolean isFast = dxdy > this.swipeCutoff;
                        boolean bl = disallowSpinGesture = this.vwr.getBooleanProperty("isNavigating") || !this.vwr.getBooleanProperty("allowGestures");
                        if (disallowSpinGesture || isFast || (float)(now - this.swipeStartTime) > this.swipeDelayMs) {
                            msg = null;
                            if (!disallowSpinGesture) {
                                if (isFast) {
                                    if (++this.nFast > this.swipeCount) {
                                        this.swipeStartTime = now;
                                        msg = "Mouse: spinXYBy " + (int)dx + " " + (int)dy + " " + Math.sqrt(dxdy) * (double)this.swipeFactor / (double)(now - this.previousMoveTime);
                                    }
                                } else if (this.nFast > 0) {
                                    this.nFast = 0;
                                    msg = "Mouse: spinXYBy 0 0 0";
                                }
                            }
                            if (msg == null) {
                                msg = "Mouse: rotateXYBy " + dx + " " + dy;
                            }
                            this.syncScript(msg);
                        }
                        this.previousMoveTime = now;
                        break;
                    }
                    case 10: {
                        this.vwr.syncScript("Mouse: translateXYBy " + json.getString("x") + " " + json.getString("y"), "=", 0);
                        break;
                    }
                    case 20: {
                        float zoomFactor = (float)(json.getDouble("scale") / (double)(this.vwr.tm.zmPct / 100.0f));
                        this.syncScript("Mouse: zoomByFactor " + zoomFactor);
                    }
                }
                break;
            }
            case 40: {
                this.halt = true;
                Logger.info("JsonNiosService quitting");
                break;
            }
            case 50: {
                if (this.motionDisabled) break;
                this.syncScript("Mouse: " + json.getString("sync"));
                break;
            }
            case 60: {
                if (this.motionDisabled) break;
                this.vwr.acm.processMultitouchEvent(0, json.getInt("eventType"), json.getInt("touchID"), json.getInt("iData"), P3.new3((float)json.getDouble("x"), (float)json.getDouble("y"), (float)json.getDouble("z")), json.getLong("time"));
            }
        }
    }

    private void sendScript(String script) {
        Logger.info("JsonNiosService sendScript " + script);
        this.vwr.evalStringQuiet(script);
    }

    private void syncScript(String script) {
        Logger.info("JsonNiosService syncScript " + script);
        this.vwr.syncScript(script, "=", 0);
    }

    private void setBanner(String bannerText, boolean andCenter) {
        if (bannerText == null) {
            this.client.setBannerLabel(null);
        } else {
            if (andCenter) {
                bannerText = "<center>" + bannerText + "</center>";
            }
            this.client.setBannerLabel("<html>" + bannerText + "</html>");
        }
    }

    protected void pauseScript(boolean isPause) {
        String script;
        if (isPause) {
            this.wasSpinOn = this.vwr.getBooleanProperty("spinOn");
            script = "pause; save orientation 'JsonNios-save'; spin off";
            this.isPaused = true;
        } else {
            script = "restore orientation 'JsonNios-save' 1; resume; spin " + this.wasSpinOn;
            this.wasSpinOn = false;
        }
        this.isPaused = isPause;
        this.sendScript(script);
    }

    private void sendMessage(JSONObject json, String msg, NIOSocket socket) {
        if (socket == null && (socket = this.outSocket) == null) {
            return;
        }
        try {
            if (json != null) {
                msg = json.toString();
            } else if (msg != null && msg.indexOf("{") != 0) {
                json = new JSONObject();
                if (msg.equalsIgnoreCase("!script_terminated!")) {
                    json.put("type", "script");
                    json.put("event", "done");
                } else {
                    json.put("type", "command");
                    json.put("command", msg);
                }
                msg = json.toString();
            }
            msg = msg + "\r\n";
            Logger.info(Thread.currentThread().getName() + " sending " + msg + " to " + socket);
            socket.write(msg.getBytes("UTF-8"));
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    class JSONObject
    extends Hashtable<String, Object> {
        public JSONObject() {
        }

        JSONObject(String msg) throws Exception {
            SV o = JsonNioService.this.vwr.evaluateExpressionAsVariable(msg);
            if (!(o.value instanceof Map)) {
                throw new Exception("invalid JSON: " + msg);
            }
            this.putAll((Map)o.value);
        }

        public JSONObject(Map<String, Object> map) {
            this.putAll(map);
        }

        boolean has(String key) {
            return this.containsKey(key);
        }

        String getString(String key) throws Exception {
            return this.containsKey(key) ? this.get(key).toString() : null;
        }

        public List<JSONObject> getJSONArray(String key) throws Exception {
            if (!this.has(key)) {
                throw new Exception("JSON key not found:" + key);
            }
            ArrayList<JSONObject> list = new ArrayList<JSONObject>();
            Lst<SV> svlist = ((SV)this.get(key)).getList();
            for (int i = 0; i < svlist.size(); ++i) {
                list.add(new JSONObject((Map)((SV)svlist.get((int)i)).value));
            }
            return list;
        }

        public Object get(String key) {
            Object o = super.get(key);
            return o instanceof SV ? SV.oValue(o) : o;
        }

        public long getLong(String key) throws Exception {
            if (!this.has(key)) {
                throw new Exception("JSON key not found:" + key);
            }
            return Long.parseLong(this.get(key).toString());
        }

        public int getInt(String key) throws Exception {
            if (!this.has(key)) {
                throw new Exception("JSON key not found:" + key);
            }
            return Integer.parseInt(this.get(key).toString());
        }

        public double getDouble(String key) throws Exception {
            if (!this.has(key)) {
                throw new Exception("JSON key not found:" + key);
            }
            return Double.parseDouble(this.get(key).toString());
        }

        @Override
        public synchronized String toString() {
            SB sb = new SB();
            sb.append("{");
            String sep = "";
            for (Map.Entry e : this.entrySet()) {
                sb.append(sep).append(PT.esc((String)e.getKey())).append(":").append(Escape.e(e.getValue()));
                sep = ",";
            }
            return sb.append("}").toString();
        }
    }

    protected class JsonNioServerThread
    implements Runnable {
        protected JsonNioServerThread() {
        }

        @Override
        public void run() {
            Logger.info(Thread.currentThread().getName() + " JsonNioServerSocket on " + JsonNioService.this.port);
            try {
                while (!JsonNioService.this.halt) {
                    JsonNioService.this.selectBlocking();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            JsonNioService.this.close();
        }
    }

    protected class JsonNioThread
    implements Runnable {
        protected JsonNioThread() {
        }

        @Override
        public void run() {
            Logger.info(Thread.currentThread().getName() + " JsonNioSocket on " + JsonNioService.this.port);
            try {
                while (!JsonNioService.this.halt) {
                    JsonNioService.this.selectNonBlocking();
                    long now = System.currentTimeMillis();
                    if (JsonNioService.this.isPaused && now - JsonNioService.this.latestMoveTime > 5000L) {
                        JsonNioService.this.pauseScript(false);
                    }
                    Thread.sleep(50L);
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            JsonNioService.this.close();
        }
    }
}

