/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.events;

import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.jgit.events.ConfigChangedListener;
import org.eclipse.jgit.events.IndexChangedListener;
import org.eclipse.jgit.events.ListenerHandle;
import org.eclipse.jgit.events.RefsChangedListener;
import org.eclipse.jgit.events.RepositoryEvent;
import org.eclipse.jgit.events.RepositoryListener;
import org.eclipse.jgit.events.WorkingTreeModifiedListener;

public class ListenerList {
    private final ConcurrentMap<Class<? extends RepositoryListener>, CopyOnWriteArrayList<ListenerHandle>> lists = new ConcurrentHashMap<Class<? extends RepositoryListener>, CopyOnWriteArrayList<ListenerHandle>>();

    public ListenerHandle addWorkingTreeModifiedListener(WorkingTreeModifiedListener listener) {
        return this.addListener(WorkingTreeModifiedListener.class, listener);
    }

    public ListenerHandle addIndexChangedListener(IndexChangedListener listener) {
        return this.addListener(IndexChangedListener.class, listener);
    }

    public ListenerHandle addRefsChangedListener(RefsChangedListener listener) {
        return this.addListener(RefsChangedListener.class, listener);
    }

    public ListenerHandle addConfigChangedListener(ConfigChangedListener listener) {
        return this.addListener(ConfigChangedListener.class, listener);
    }

    public <T extends RepositoryListener> ListenerHandle addListener(Class<T> type2, T listener) {
        ListenerHandle handle = new ListenerHandle(this, type2, listener);
        this.add(handle);
        return handle;
    }

    public void dispatch(RepositoryEvent event) {
        List list = (List)this.lists.get(event.getListenerType());
        if (list != null) {
            for (ListenerHandle handle : list) {
                event.dispatch(handle.listener);
            }
        }
    }

    private void add(ListenerHandle handle) {
        CopyOnWriteArrayList<ListenerHandle> newList;
        CopyOnWriteArrayList<ListenerHandle> list = (CopyOnWriteArrayList<ListenerHandle>)this.lists.get(handle.type);
        if (list == null && (list = (List)this.lists.putIfAbsent(handle.type, newList = new CopyOnWriteArrayList<ListenerHandle>())) == null) {
            list = newList;
        }
        list.add(handle);
    }

    void remove(ListenerHandle handle) {
        List list = (List)this.lists.get(handle.type);
        if (list != null) {
            list.remove(handle);
        }
    }
}

