# Options documentation

Parameter|Type|Input/Output|Description
|---|---|---|---|
agent|Object|Input|Optional http(s).Agent to be used when fetching resources
cache|Object|Input|Optional cache of external resources
components|Boolean|Input|Command-line flag to indicate unresolve information should be displayed
context|Array|Output|The context stack of associated with errors in a validation step, you normally want the last entry only
debug|Boolean|Input|Flag to enable debug mode, adds specification-extensions
direct|Boolean|Input|Flag to indicate that only the converted OpenApi definition should be returned, not wrapped in options
encoding|String|Input|Encoding to use when reading/writing files
expectFailure|Boolean|Input|Flag to invert the status of a validation step
externals|[Array](externals.md)|Output|Information required to unresolve a resolved definition back into its component parts
fail|Boolean|Input|Command-line flag used by `testRunner`
file|String|Input|Used to pass filename back to `testRunner`
handlers|Object|Input|Map of additional [protocol/scheme handlers](handlers.md), must be functions which return a Promise
help|Boolean|Reserved|Command-line flag to display help
indent|String|Input|Command-line flag to control JSON indenting
jsonschema|String|Input|Path to alternative JSON schema (in JSON or YAML) for validation
laxRefs|Boolean|Input|**No longer has any effect as this is now the default**
laxurls|Boolean|Input|Flag to validation step to ignore empty URLs
nopatch|Boolean|Input|Command-line flag by `testRunner` to unset `patch`
openapi|Object|Output|The OpenApi 3.x definition returned from a conversion step
operationIds|Array[string]|Output|Used by validation to track uniqueness of operationIds
origin|String|Input|The URL of the definition, set by convertUrl method
original|Object|Bi-directional|Used by `testRunner` to round-trip the original definition, set by non-object `ConvertXXX` methods
outfile|String|Input|The output file to write to
output|Boolean|Input|Internal flag to testRunner to write output openapi.yaml files
patch|Boolean|Input|Flag to fix-up minor errors in the source definition before conversion
promise|Object|Internal|Object containing resolve and reject functions for the converter
quiet|Boolean|Input|Command-line flag used by `testRunner`
refmap|Object|Internal|Used as a mapping between old and new `$ref`s.
resolve|Boolean|Input|Flag to enable resolution of external `$ref`s.
stop|Boolean|Input|Command-line flag used by `testRunner`
source|String|Output|The source filename or url of the definition
sourceYaml|Boolean|Output|Flag set if the source string, URL or stream contained a YAML formatted definition
url|String|Input|URL of the original definition, used when reading a file to create `x-origin` extension
valid|Boolean|Output|The result of a validation step
verbose|Boolean|Input|Increase verbosity, e.g. show HTTP GET requests
version|Boolean|Input|Command-line flag to show version information
warnings|Array|Output|Warnings generated by a validation step
warnOnly|Boolean|Input|Do not throw on non-patchable errors, add warning extensions
warnProperty|String|Input|Property name to use for warning extensions, default `x-s2o-warning`
whatwg|Boolean|Input|Enable WHATWG URL parsing in validation step (default false)
yaml|Boolean|Input|Flag to read and write YAML, default JSON
