-module(ssl_srp_primes).

-export([get_srp_params/1, check_srp_params/2]).

-define(PRIME_1024, <<16#EE, 16#AF, 16#0A, 16#B9, 16#AD, 16#B3, 16#8D,
		      16#D6, 16#9C, 16#33, 16#F8, 16#0A, 16#FA, 16#8F,
		      16#C5, 16#E8, 16#60, 16#72, 16#61, 16#87, 16#75,
		      16#FF, 16#3C, 16#0B, 16#9E, 16#A2, 16#31, 16#4C,
		      16#9C, 16#25, 16#65, 16#76, 16#D6, 16#74, 16#DF,
		      16#74, 16#96, 16#EA, 16#81, 16#D3, 16#38, 16#3B,
		      16#48, 16#13, 16#D6, 16#92, 16#C6, 16#E0, 16#E0,
		      16#D5, 16#D8, 16#E2, 16#50, 16#B9, 16#8B, 16#E4,
		      16#8E, 16#49, 16#5C, 16#1D, 16#60, 16#89, 16#DA,
		      16#D1, 16#5D, 16#C7, 16#D7, 16#B4, 16#61, 16#54,
		      16#D6, 16#B6, 16#CE, 16#8E, 16#F4, 16#AD, 16#69,
		      16#B1, 16#5D, 16#49, 16#82, 16#55, 16#9B, 16#29,
		      16#7B, 16#CF, 16#18, 16#85, 16#C5, 16#29, 16#F5,
		      16#66, 16#66, 16#0E, 16#57, 16#EC, 16#68, 16#ED,
		      16#BC, 16#3C, 16#05, 16#72, 16#6C, 16#C0, 16#2F,
		      16#D4, 16#CB, 16#F4, 16#97, 16#6E, 16#AA, 16#9A,
		      16#FD, 16#51, 16#38, 16#FE, 16#83, 16#76, 16#43,
		      16#5B, 16#9F, 16#C6, 16#1D, 16#2F, 16#C0, 16#EB,
		      16#06, 16#E3>>).
-define(GENERATOR_1024, <<2>>).


-define(PRIME_1536, <<16#9D, 16#EF, 16#3C, 16#AF, 16#B9, 16#39, 16#27,
		      16#7A, 16#B1, 16#F1, 16#2A, 16#86, 16#17, 16#A4,
		      16#7B, 16#BB, 16#DB, 16#A5, 16#1D, 16#F4, 16#99,
		      16#AC, 16#4C, 16#80, 16#BE, 16#EE, 16#A9, 16#61,
		      16#4B, 16#19, 16#CC, 16#4D, 16#5F, 16#4F, 16#5F,
		      16#55, 16#6E, 16#27, 16#CB, 16#DE, 16#51, 16#C6,
		      16#A9, 16#4B, 16#E4, 16#60, 16#7A, 16#29, 16#15,
		      16#58, 16#90, 16#3B, 16#A0, 16#D0, 16#F8, 16#43,
		      16#80, 16#B6, 16#55, 16#BB, 16#9A, 16#22, 16#E8,
		      16#DC, 16#DF, 16#02, 16#8A, 16#7C, 16#EC, 16#67,
		      16#F0, 16#D0, 16#81, 16#34, 16#B1, 16#C8, 16#B9,
		      16#79, 16#89, 16#14, 16#9B, 16#60, 16#9E, 16#0B,
		      16#E3, 16#BA, 16#B6, 16#3D, 16#47, 16#54, 16#83,
		      16#81, 16#DB, 16#C5, 16#B1, 16#FC, 16#76, 16#4E,
		      16#3F, 16#4B, 16#53, 16#DD, 16#9D, 16#A1, 16#15,
		      16#8B, 16#FD, 16#3E, 16#2B, 16#9C, 16#8C, 16#F5,
		      16#6E, 16#DF, 16#01, 16#95, 16#39, 16#34, 16#96,
		      16#27, 16#DB, 16#2F, 16#D5, 16#3D, 16#24, 16#B7,
		      16#C4, 16#86, 16#65, 16#77, 16#2E, 16#43, 16#7D,
		      16#6C, 16#7F, 16#8C, 16#E4, 16#42, 16#73, 16#4A,
		      16#F7, 16#CC, 16#B7, 16#AE, 16#83, 16#7C, 16#26,
		      16#4A, 16#E3, 16#A9, 16#BE, 16#B8, 16#7F, 16#8A,
		      16#2F, 16#E9, 16#B8, 16#B5, 16#29, 16#2E, 16#5A,
		      16#02, 16#1F, 16#FF, 16#5E, 16#91, 16#47, 16#9E,
		      16#8C, 16#E7, 16#A2, 16#8C, 16#24, 16#42, 16#C6,
		      16#F3, 16#15, 16#18, 16#0F, 16#93, 16#49, 16#9A,
		      16#23, 16#4D, 16#CF, 16#76, 16#E3, 16#FE, 16#D1,
		      16#35, 16#F9, 16#BB>>).
-define(GENERATOR_1536, <<2>>).

-define(PRIME_2048, <<16#AC, 16#6B, 16#DB, 16#41, 16#32, 16#4A, 16#9A,
		      16#9B, 16#F1, 16#66, 16#DE, 16#5E, 16#13, 16#89,
		      16#58, 16#2F, 16#AF, 16#72, 16#B6, 16#65, 16#19,
		      16#87, 16#EE, 16#07, 16#FC, 16#31, 16#92, 16#94,
		      16#3D, 16#B5, 16#60, 16#50, 16#A3, 16#73, 16#29,
		      16#CB, 16#B4, 16#A0, 16#99, 16#ED, 16#81, 16#93,
		      16#E0, 16#75, 16#77, 16#67, 16#A1, 16#3D, 16#D5,
		      16#23, 16#12, 16#AB, 16#4B, 16#03, 16#31, 16#0D,
		      16#CD, 16#7F, 16#48, 16#A9, 16#DA, 16#04, 16#FD,
		      16#50, 16#E8, 16#08, 16#39, 16#69, 16#ED, 16#B7,
		      16#67, 16#B0, 16#CF, 16#60, 16#95, 16#17, 16#9A,
		      16#16, 16#3A, 16#B3, 16#66, 16#1A, 16#05, 16#FB,
		      16#D5, 16#FA, 16#AA, 16#E8, 16#29, 16#18, 16#A9,
		      16#96, 16#2F, 16#0B, 16#93, 16#B8, 16#55, 16#F9,
		      16#79, 16#93, 16#EC, 16#97, 16#5E, 16#EA, 16#A8,
		      16#0D, 16#74, 16#0A, 16#DB, 16#F4, 16#FF, 16#74,
		      16#73, 16#59, 16#D0, 16#41, 16#D5, 16#C3, 16#3E,
		      16#A7, 16#1D, 16#28, 16#1E, 16#44, 16#6B, 16#14,
		      16#77, 16#3B, 16#CA, 16#97, 16#B4, 16#3A, 16#23,
		      16#FB, 16#80, 16#16, 16#76, 16#BD, 16#20, 16#7A,
		      16#43, 16#6C, 16#64, 16#81, 16#F1, 16#D2, 16#B9,
		      16#07, 16#87, 16#17, 16#46, 16#1A, 16#5B, 16#9D,
		      16#32, 16#E6, 16#88, 16#F8, 16#77, 16#48, 16#54,
		      16#45, 16#23, 16#B5, 16#24, 16#B0, 16#D5, 16#7D,
		      16#5E, 16#A7, 16#7A, 16#27, 16#75, 16#D2, 16#EC,
		      16#FA, 16#03, 16#2C, 16#FB, 16#DB, 16#F5, 16#2F,
		      16#B3, 16#78, 16#61, 16#60, 16#27, 16#90, 16#04,
		      16#E5, 16#7A, 16#E6, 16#AF, 16#87, 16#4E, 16#73,
		      16#03, 16#CE, 16#53, 16#29, 16#9C, 16#CC, 16#04,
		      16#1C, 16#7B, 16#C3, 16#08, 16#D8, 16#2A, 16#56,
		      16#98, 16#F3, 16#A8, 16#D0, 16#C3, 16#82, 16#71,
		      16#AE, 16#35, 16#F8, 16#E9, 16#DB, 16#FB, 16#B6,
		      16#94, 16#B5, 16#C8, 16#03, 16#D8, 16#9F, 16#7A,
		      16#E4, 16#35, 16#DE, 16#23, 16#6D, 16#52, 16#5F,
		      16#54, 16#75, 16#9B, 16#65, 16#E3, 16#72, 16#FC,
		      16#D6, 16#8E, 16#F2, 16#0F, 16#A7, 16#11, 16#1F,
		      16#9E, 16#4A, 16#FF, 16#73>>).
-define(GENERATOR_2048, <<2>>).

-define(PRIME_3072, <<16#FF, 16#FF, 16#FF, 16#FF, 16#FF, 16#FF, 16#FF,
		      16#FF, 16#C9, 16#0F, 16#DA, 16#A2, 16#21, 16#68,
		      16#C2, 16#34, 16#C4, 16#C6, 16#62, 16#8B, 16#80,
		      16#DC, 16#1C, 16#D1, 16#29, 16#02, 16#4E, 16#08,
		      16#8A, 16#67, 16#CC, 16#74, 16#02, 16#0B, 16#BE,
		      16#A6, 16#3B, 16#13, 16#9B, 16#22, 16#51, 16#4A,
		      16#08, 16#79, 16#8E, 16#34, 16#04, 16#DD, 16#EF,
		      16#95, 16#19, 16#B3, 16#CD, 16#3A, 16#43, 16#1B,
		      16#30, 16#2B, 16#0A, 16#6D, 16#F2, 16#5F, 16#14,
		      16#37, 16#4F, 16#E1, 16#35, 16#6D, 16#6D, 16#51,
		      16#C2, 16#45, 16#E4, 16#85, 16#B5, 16#76, 16#62,
		      16#5E, 16#7E, 16#C6, 16#F4, 16#4C, 16#42, 16#E9,
		      16#A6, 16#37, 16#ED, 16#6B, 16#0B, 16#FF, 16#5C,
		      16#B6, 16#F4, 16#06, 16#B7, 16#ED, 16#EE, 16#38,
		      16#6B, 16#FB, 16#5A, 16#89, 16#9F, 16#A5, 16#AE,
		      16#9F, 16#24, 16#11, 16#7C, 16#4B, 16#1F, 16#E6,
		      16#49, 16#28, 16#66, 16#51, 16#EC, 16#E4, 16#5B,
		      16#3D, 16#C2, 16#00, 16#7C, 16#B8, 16#A1, 16#63,
		      16#BF, 16#05, 16#98, 16#DA, 16#48, 16#36, 16#1C,
		      16#55, 16#D3, 16#9A, 16#69, 16#16, 16#3F, 16#A8,
		      16#FD, 16#24, 16#CF, 16#5F, 16#83, 16#65, 16#5D,
		      16#23, 16#DC, 16#A3, 16#AD, 16#96, 16#1C, 16#62,
		      16#F3, 16#56, 16#20, 16#85, 16#52, 16#BB, 16#9E,
		      16#D5, 16#29, 16#07, 16#70, 16#96, 16#96, 16#6D,
		      16#67, 16#0C, 16#35, 16#4E, 16#4A, 16#BC, 16#98,
		      16#04, 16#F1, 16#74, 16#6C, 16#08, 16#CA, 16#18,
		      16#21, 16#7C, 16#32, 16#90, 16#5E, 16#46, 16#2E,
		      16#36, 16#CE, 16#3B, 16#E3, 16#9E, 16#77, 16#2C,
		      16#18, 16#0E, 16#86, 16#03, 16#9B, 16#27, 16#83,
		      16#A2, 16#EC, 16#07, 16#A2, 16#8F, 16#B5, 16#C5,
		      16#5D, 16#F0, 16#6F, 16#4C, 16#52, 16#C9, 16#DE,
		      16#2B, 16#CB, 16#F6, 16#95, 16#58, 16#17, 16#18,
		      16#39, 16#95, 16#49, 16#7C, 16#EA, 16#95, 16#6A,
		      16#E5, 16#15, 16#D2, 16#26, 16#18, 16#98, 16#FA,
		      16#05, 16#10, 16#15, 16#72, 16#8E, 16#5A, 16#8A,
		      16#AA, 16#C4, 16#2D, 16#AD, 16#33, 16#17, 16#0D,
		      16#04, 16#50, 16#7A, 16#33, 16#A8, 16#55, 16#21,
		      16#AB, 16#DF, 16#1C, 16#BA, 16#64, 16#EC, 16#FB,
		      16#85, 16#04, 16#58, 16#DB, 16#EF, 16#0A, 16#8A,
		      16#EA, 16#71, 16#57, 16#5D, 16#06, 16#0C, 16#7D,
		      16#B3, 16#97, 16#0F, 16#85, 16#A6, 16#E1, 16#E4,
		      16#C7, 16#AB, 16#F5, 16#AE, 16#8C, 16#DB, 16#09,
		      16#33, 16#D7, 16#1E, 16#8C, 16#94, 16#E0, 16#4A,
		      16#25, 16#61, 16#9D, 16#CE, 16#E3, 16#D2, 16#26,
		      16#1A, 16#D2, 16#EE, 16#6B, 16#F1, 16#2F, 16#FA,
		      16#06, 16#D9, 16#8A, 16#08, 16#64, 16#D8, 16#76,
		      16#02, 16#73, 16#3E, 16#C8, 16#6A, 16#64, 16#52,
		      16#1F, 16#2B, 16#18, 16#17, 16#7B, 16#20, 16#0C,
		      16#BB, 16#E1, 16#17, 16#57, 16#7A, 16#61, 16#5D,
		      16#6C, 16#77, 16#09, 16#88, 16#C0, 16#BA, 16#D9,
		      16#46, 16#E2, 16#08, 16#E2, 16#4F, 16#A0, 16#74,
		      16#E5, 16#AB, 16#31, 16#43, 16#DB, 16#5B, 16#FC,
		      16#E0, 16#FD, 16#10, 16#8E, 16#4B, 16#82, 16#D1,
		      16#20, 16#A9, 16#3A, 16#D2, 16#CA, 16#FF, 16#FF,
		      16#FF, 16#FF, 16#FF, 16#FF, 16#FF, 16#FF>>).
-define(GENERATOR_3072, <<5>>).

-define(PRIME_4096, <<16#FF, 16#FF, 16#FF, 16#FF, 16#FF, 16#FF, 16#FF,
		      16#FF, 16#C9, 16#0F, 16#DA, 16#A2, 16#21, 16#68,
		      16#C2, 16#34, 16#C4, 16#C6, 16#62, 16#8B, 16#80,
		      16#DC, 16#1C, 16#D1, 16#29, 16#02, 16#4E, 16#08,
		      16#8A, 16#67, 16#CC, 16#74, 16#02, 16#0B, 16#BE,
		      16#A6, 16#3B, 16#13, 16#9B, 16#22, 16#51, 16#4A,
		      16#08, 16#79, 16#8E, 16#34, 16#04, 16#DD, 16#EF,
		      16#95, 16#19, 16#B3, 16#CD, 16#3A, 16#43, 16#1B,
		      16#30, 16#2B, 16#0A, 16#6D, 16#F2, 16#5F, 16#14,
		      16#37, 16#4F, 16#E1, 16#35, 16#6D, 16#6D, 16#51,
		      16#C2, 16#45, 16#E4, 16#85, 16#B5, 16#76, 16#62,
		      16#5E, 16#7E, 16#C6, 16#F4, 16#4C, 16#42, 16#E9,
		      16#A6, 16#37, 16#ED, 16#6B, 16#0B, 16#FF, 16#5C,
		      16#B6, 16#F4, 16#06, 16#B7, 16#ED, 16#EE, 16#38,
		      16#6B, 16#FB, 16#5A, 16#89, 16#9F, 16#A5, 16#AE,
		      16#9F, 16#24, 16#11, 16#7C, 16#4B, 16#1F, 16#E6,
		      16#49, 16#28, 16#66, 16#51, 16#EC, 16#E4, 16#5B,
		      16#3D, 16#C2, 16#00, 16#7C, 16#B8, 16#A1, 16#63,
		      16#BF, 16#05, 16#98, 16#DA, 16#48, 16#36, 16#1C,
		      16#55, 16#D3, 16#9A, 16#69, 16#16, 16#3F, 16#A8,
		      16#FD, 16#24, 16#CF, 16#5F, 16#83, 16#65, 16#5D,
		      16#23, 16#DC, 16#A3, 16#AD, 16#96, 16#1C, 16#62,
		      16#F3, 16#56, 16#20, 16#85, 16#52, 16#BB, 16#9E,
		      16#D5, 16#29, 16#07, 16#70, 16#96, 16#96, 16#6D,
		      16#67, 16#0C, 16#35, 16#4E, 16#4A, 16#BC, 16#98,
		      16#04, 16#F1, 16#74, 16#6C, 16#08, 16#CA, 16#18,
		      16#21, 16#7C, 16#32, 16#90, 16#5E, 16#46, 16#2E,
		      16#36, 16#CE, 16#3B, 16#E3, 16#9E, 16#77, 16#2C,
		      16#18, 16#0E, 16#86, 16#03, 16#9B, 16#27, 16#83,
		      16#A2, 16#EC, 16#07, 16#A2, 16#8F, 16#B5, 16#C5,
		      16#5D, 16#F0, 16#6F, 16#4C, 16#52, 16#C9, 16#DE,
		      16#2B, 16#CB, 16#F6, 16#95, 16#58, 16#17, 16#18,
		      16#39, 16#95, 16#49, 16#7C, 16#EA, 16#95, 16#6A,
		      16#E5, 16#15, 16#D2, 16#26, 16#18, 16#98, 16#FA,
		      16#05, 16#10, 16#15, 16#72, 16#8E, 16#5A, 16#8A,
		      16#AA, 16#C4, 16#2D, 16#AD, 16#33, 16#17, 16#0D,
		      16#04, 16#50, 16#7A, 16#33, 16#A8, 16#55, 16#21,
		      16#AB, 16#DF, 16#1C, 16#BA, 16#64, 16#EC, 16#FB,
		      16#85, 16#04, 16#58, 16#DB, 16#EF, 16#0A, 16#8A,
		      16#EA, 16#71, 16#57, 16#5D, 16#06, 16#0C, 16#7D,
		      16#B3, 16#97, 16#0F, 16#85, 16#A6, 16#E1, 16#E4,
		      16#C7, 16#AB, 16#F5, 16#AE, 16#8C, 16#DB, 16#09,
		      16#33, 16#D7, 16#1E, 16#8C, 16#94, 16#E0, 16#4A,
		      16#25, 16#61, 16#9D, 16#CE, 16#E3, 16#D2, 16#26,
		      16#1A, 16#D2, 16#EE, 16#6B, 16#F1, 16#2F, 16#FA,
		      16#06, 16#D9, 16#8A, 16#08, 16#64, 16#D8, 16#76,
		      16#02, 16#73, 16#3E, 16#C8, 16#6A, 16#64, 16#52,
		      16#1F, 16#2B, 16#18, 16#17, 16#7B, 16#20, 16#0C,
		      16#BB, 16#E1, 16#17, 16#57, 16#7A, 16#61, 16#5D,
		      16#6C, 16#77, 16#09, 16#88, 16#C0, 16#BA, 16#D9,
		      16#46, 16#E2, 16#08, 16#E2, 16#4F, 16#A0, 16#74,
		      16#E5, 16#AB, 16#31, 16#43, 16#DB, 16#5B, 16#FC,
		      16#E0, 16#FD, 16#10, 16#8E, 16#4B, 16#82, 16#D1,
		      16#20, 16#A9, 16#21, 16#08, 16#01, 16#1A, 16#72,
		      16#3C, 16#12, 16#A7, 16#87, 16#E6, 16#D7, 16#88,
		      16#71, 16#9A, 16#10, 16#BD, 16#BA, 16#5B, 16#26,
		      16#99, 16#C3, 16#27, 16#18, 16#6A, 16#F4, 16#E2,
		      16#3C, 16#1A, 16#94, 16#68, 16#34, 16#B6, 16#15,
		      16#0B, 16#DA, 16#25, 16#83, 16#E9, 16#CA, 16#2A,
		      16#D4, 16#4C, 16#E8, 16#DB, 16#BB, 16#C2, 16#DB,
		      16#04, 16#DE, 16#8E, 16#F9, 16#2E, 16#8E, 16#FC,
		      16#14, 16#1F, 16#BE, 16#CA, 16#A6, 16#28, 16#7C,
		      16#59, 16#47, 16#4E, 16#6B, 16#C0, 16#5D, 16#99,
		      16#B2, 16#96, 16#4F, 16#A0, 16#90, 16#C3, 16#A2,
		      16#23, 16#3B, 16#A1, 16#86, 16#51, 16#5B, 16#E7,
		      16#ED, 16#1F, 16#61, 16#29, 16#70, 16#CE, 16#E2,
		      16#D7, 16#AF, 16#B8, 16#1B, 16#DD, 16#76, 16#21,
		      16#70, 16#48, 16#1C, 16#D0, 16#06, 16#91, 16#27,
		      16#D5, 16#B0, 16#5A, 16#A9, 16#93, 16#B4, 16#EA,
		      16#98, 16#8D, 16#8F, 16#DD, 16#C1, 16#86, 16#FF,
		      16#B7, 16#DC, 16#90, 16#A6, 16#C0, 16#8F, 16#4D,
		      16#F4, 16#35, 16#C9, 16#34, 16#06, 16#31, 16#99,
		      16#FF, 16#FF, 16#FF, 16#FF, 16#FF, 16#FF, 16#FF,
		      16#FF>>).
-define(GENERATOR_4096, <<5>>).

-define(PRIME_6144, <<16#FF, 16#FF, 16#FF, 16#FF, 16#FF, 16#FF, 16#FF,
		      16#FF, 16#C9, 16#0F, 16#DA, 16#A2, 16#21, 16#68,
		      16#C2, 16#34, 16#C4, 16#C6, 16#62, 16#8B, 16#80,
		      16#DC, 16#1C, 16#D1, 16#29, 16#02, 16#4E, 16#08,
		      16#8A, 16#67, 16#CC, 16#74, 16#02, 16#0B, 16#BE,
		      16#A6, 16#3B, 16#13, 16#9B, 16#22, 16#51, 16#4A,
		      16#08, 16#79, 16#8E, 16#34, 16#04, 16#DD, 16#EF,
		      16#95, 16#19, 16#B3, 16#CD, 16#3A, 16#43, 16#1B,
		      16#30, 16#2B, 16#0A, 16#6D, 16#F2, 16#5F, 16#14,
		      16#37, 16#4F, 16#E1, 16#35, 16#6D, 16#6D, 16#51,
		      16#C2, 16#45, 16#E4, 16#85, 16#B5, 16#76, 16#62,
		      16#5E, 16#7E, 16#C6, 16#F4, 16#4C, 16#42, 16#E9,
		      16#A6, 16#37, 16#ED, 16#6B, 16#0B, 16#FF, 16#5C,
		      16#B6, 16#F4, 16#06, 16#B7, 16#ED, 16#EE, 16#38,
		      16#6B, 16#FB, 16#5A, 16#89, 16#9F, 16#A5, 16#AE,
		      16#9F, 16#24, 16#11, 16#7C, 16#4B, 16#1F, 16#E6,
		      16#49, 16#28, 16#66, 16#51, 16#EC, 16#E4, 16#5B,
		      16#3D, 16#C2, 16#00, 16#7C, 16#B8, 16#A1, 16#63,
		      16#BF, 16#05, 16#98, 16#DA, 16#48, 16#36, 16#1C,
		      16#55, 16#D3, 16#9A, 16#69, 16#16, 16#3F, 16#A8,
		      16#FD, 16#24, 16#CF, 16#5F, 16#83, 16#65, 16#5D,
		      16#23, 16#DC, 16#A3, 16#AD, 16#96, 16#1C, 16#62,
		      16#F3, 16#56, 16#20, 16#85, 16#52, 16#BB, 16#9E,
		      16#D5, 16#29, 16#07, 16#70, 16#96, 16#96, 16#6D,
		      16#67, 16#0C, 16#35, 16#4E, 16#4A, 16#BC, 16#98,
		      16#04, 16#F1, 16#74, 16#6C, 16#08, 16#CA, 16#18,
		      16#21, 16#7C, 16#32, 16#90, 16#5E, 16#46, 16#2E,
		      16#36, 16#CE, 16#3B, 16#E3, 16#9E, 16#77, 16#2C,
		      16#18, 16#0E, 16#86, 16#03, 16#9B, 16#27, 16#83,
		      16#A2, 16#EC, 16#07, 16#A2, 16#8F, 16#B5, 16#C5,
		      16#5D, 16#F0, 16#6F, 16#4C, 16#52, 16#C9, 16#DE,
		      16#2B, 16#CB, 16#F6, 16#95, 16#58, 16#17, 16#18,
		      16#39, 16#95, 16#49, 16#7C, 16#EA, 16#95, 16#6A,
		      16#E5, 16#15, 16#D2, 16#26, 16#18, 16#98, 16#FA,
		      16#05, 16#10, 16#15, 16#72, 16#8E, 16#5A, 16#8A,
		      16#AA, 16#C4, 16#2D, 16#AD, 16#33, 16#17, 16#0D,
		      16#04, 16#50, 16#7A, 16#33, 16#A8, 16#55, 16#21,
		      16#AB, 16#DF, 16#1C, 16#BA, 16#64, 16#EC, 16#FB,
		      16#85, 16#04, 16#58, 16#DB, 16#EF, 16#0A, 16#8A,
		      16#EA, 16#71, 16#57, 16#5D, 16#06, 16#0C, 16#7D,
		      16#B3, 16#97, 16#0F, 16#85, 16#A6, 16#E1, 16#E4,
		      16#C7, 16#AB, 16#F5, 16#AE, 16#8C, 16#DB, 16#09,
		      16#33, 16#D7, 16#1E, 16#8C, 16#94, 16#E0, 16#4A,
		      16#25, 16#61, 16#9D, 16#CE, 16#E3, 16#D2, 16#26,
		      16#1A, 16#D2, 16#EE, 16#6B, 16#F1, 16#2F, 16#FA,
		      16#06, 16#D9, 16#8A, 16#08, 16#64, 16#D8, 16#76,
		      16#02, 16#73, 16#3E, 16#C8, 16#6A, 16#64, 16#52,
		      16#1F, 16#2B, 16#18, 16#17, 16#7B, 16#20, 16#0C,
		      16#BB, 16#E1, 16#17, 16#57, 16#7A, 16#61, 16#5D,
		      16#6C, 16#77, 16#09, 16#88, 16#C0, 16#BA, 16#D9,
		      16#46, 16#E2, 16#08, 16#E2, 16#4F, 16#A0, 16#74,
		      16#E5, 16#AB, 16#31, 16#43, 16#DB, 16#5B, 16#FC,
		      16#E0, 16#FD, 16#10, 16#8E, 16#4B, 16#82, 16#D1,
		      16#20, 16#A9, 16#21, 16#08, 16#01, 16#1A, 16#72,
		      16#3C, 16#12, 16#A7, 16#87, 16#E6, 16#D7, 16#88,
		      16#71, 16#9A, 16#10, 16#BD, 16#BA, 16#5B, 16#26,
		      16#99, 16#C3, 16#27, 16#18, 16#6A, 16#F4, 16#E2,
		      16#3C, 16#1A, 16#94, 16#68, 16#34, 16#B6, 16#15,
		      16#0B, 16#DA, 16#25, 16#83, 16#E9, 16#CA, 16#2A,
		      16#D4, 16#4C, 16#E8, 16#DB, 16#BB, 16#C2, 16#DB,
		      16#04, 16#DE, 16#8E, 16#F9, 16#2E, 16#8E, 16#FC,
		      16#14, 16#1F, 16#BE, 16#CA, 16#A6, 16#28, 16#7C,
		      16#59, 16#47, 16#4E, 16#6B, 16#C0, 16#5D, 16#99,
		      16#B2, 16#96, 16#4F, 16#A0, 16#90, 16#C3, 16#A2,
		      16#23, 16#3B, 16#A1, 16#86, 16#51, 16#5B, 16#E7,
		      16#ED, 16#1F, 16#61, 16#29, 16#70, 16#CE, 16#E2,
		      16#D7, 16#AF, 16#B8, 16#1B, 16#DD, 16#76, 16#21,
		      16#70, 16#48, 16#1C, 16#D0, 16#06, 16#91, 16#27,
		      16#D5, 16#B0, 16#5A, 16#A9, 16#93, 16#B4, 16#EA,
		      16#98, 16#8D, 16#8F, 16#DD, 16#C1, 16#86, 16#FF,
		      16#B7, 16#DC, 16#90, 16#A6, 16#C0, 16#8F, 16#4D,
		      16#F4, 16#35, 16#C9, 16#34, 16#02, 16#84, 16#92,
		      16#36, 16#C3, 16#FA, 16#B4, 16#D2, 16#7C, 16#70,
		      16#26, 16#C1, 16#D4, 16#DC, 16#B2, 16#60, 16#26,
		      16#46, 16#DE, 16#C9, 16#75, 16#1E, 16#76, 16#3D,
		      16#BA, 16#37, 16#BD, 16#F8, 16#FF, 16#94, 16#06,
		      16#AD, 16#9E, 16#53, 16#0E, 16#E5, 16#DB, 16#38,
		      16#2F, 16#41, 16#30, 16#01, 16#AE, 16#B0, 16#6A,
		      16#53, 16#ED, 16#90, 16#27, 16#D8, 16#31, 16#17,
		      16#97, 16#27, 16#B0, 16#86, 16#5A, 16#89, 16#18,
		      16#DA, 16#3E, 16#DB, 16#EB, 16#CF, 16#9B, 16#14,
		      16#ED, 16#44, 16#CE, 16#6C, 16#BA, 16#CE, 16#D4,
		      16#BB, 16#1B, 16#DB, 16#7F, 16#14, 16#47, 16#E6,
		      16#CC, 16#25, 16#4B, 16#33, 16#20, 16#51, 16#51,
		      16#2B, 16#D7, 16#AF, 16#42, 16#6F, 16#B8, 16#F4,
		      16#01, 16#37, 16#8C, 16#D2, 16#BF, 16#59, 16#83,
		      16#CA, 16#01, 16#C6, 16#4B, 16#92, 16#EC, 16#F0,
		      16#32, 16#EA, 16#15, 16#D1, 16#72, 16#1D, 16#03,
		      16#F4, 16#82, 16#D7, 16#CE, 16#6E, 16#74, 16#FE,
		      16#F6, 16#D5, 16#5E, 16#70, 16#2F, 16#46, 16#98,
		      16#0C, 16#82, 16#B5, 16#A8, 16#40, 16#31, 16#90,
		      16#0B, 16#1C, 16#9E, 16#59, 16#E7, 16#C9, 16#7F,
		      16#BE, 16#C7, 16#E8, 16#F3, 16#23, 16#A9, 16#7A,
		      16#7E, 16#36, 16#CC, 16#88, 16#BE, 16#0F, 16#1D,
		      16#45, 16#B7, 16#FF, 16#58, 16#5A, 16#C5, 16#4B,
		      16#D4, 16#07, 16#B2, 16#2B, 16#41, 16#54, 16#AA,
		      16#CC, 16#8F, 16#6D, 16#7E, 16#BF, 16#48, 16#E1,
		      16#D8, 16#14, 16#CC, 16#5E, 16#D2, 16#0F, 16#80,
		      16#37, 16#E0, 16#A7, 16#97, 16#15, 16#EE, 16#F2,
		      16#9B, 16#E3, 16#28, 16#06, 16#A1, 16#D5, 16#8B,
		      16#B7, 16#C5, 16#DA, 16#76, 16#F5, 16#50, 16#AA,
		      16#3D, 16#8A, 16#1F, 16#BF, 16#F0, 16#EB, 16#19,
		      16#CC, 16#B1, 16#A3, 16#13, 16#D5, 16#5C, 16#DA,
		      16#56, 16#C9, 16#EC, 16#2E, 16#F2, 16#96, 16#32,
		      16#38, 16#7F, 16#E8, 16#D7, 16#6E, 16#3C, 16#04,
		      16#68, 16#04, 16#3E, 16#8F, 16#66, 16#3F, 16#48,
		      16#60, 16#EE, 16#12, 16#BF, 16#2D, 16#5B, 16#0B,
		      16#74, 16#74, 16#D6, 16#E6, 16#94, 16#F9, 16#1E,
		      16#6D, 16#CC, 16#40, 16#24, 16#FF, 16#FF, 16#FF,
		      16#FF, 16#FF, 16#FF, 16#FF, 16#FF>>).
-define(GENERATOR_6144, <<5>>).

-define(PRIME_8192, <<16#FF, 16#FF, 16#FF, 16#FF, 16#FF, 16#FF, 16#FF,
		      16#FF, 16#C9, 16#0F, 16#DA, 16#A2, 16#21, 16#68,
		      16#C2, 16#34, 16#C4, 16#C6, 16#62, 16#8B, 16#80,
		      16#DC, 16#1C, 16#D1, 16#29, 16#02, 16#4E, 16#08,
		      16#8A, 16#67, 16#CC, 16#74, 16#02, 16#0B, 16#BE,
		      16#A6, 16#3B, 16#13, 16#9B, 16#22, 16#51, 16#4A,
		      16#08, 16#79, 16#8E, 16#34, 16#04, 16#DD, 16#EF,
		      16#95, 16#19, 16#B3, 16#CD, 16#3A, 16#43, 16#1B,
		      16#30, 16#2B, 16#0A, 16#6D, 16#F2, 16#5F, 16#14,
		      16#37, 16#4F, 16#E1, 16#35, 16#6D, 16#6D, 16#51,
		      16#C2, 16#45, 16#E4, 16#85, 16#B5, 16#76, 16#62,
		      16#5E, 16#7E, 16#C6, 16#F4, 16#4C, 16#42, 16#E9,
		      16#A6, 16#37, 16#ED, 16#6B, 16#0B, 16#FF, 16#5C,
		      16#B6, 16#F4, 16#06, 16#B7, 16#ED, 16#EE, 16#38,
		      16#6B, 16#FB, 16#5A, 16#89, 16#9F, 16#A5, 16#AE,
		      16#9F, 16#24, 16#11, 16#7C, 16#4B, 16#1F, 16#E6,
		      16#49, 16#28, 16#66, 16#51, 16#EC, 16#E4, 16#5B,
		      16#3D, 16#C2, 16#00, 16#7C, 16#B8, 16#A1, 16#63,
		      16#BF, 16#05, 16#98, 16#DA, 16#48, 16#36, 16#1C,
		      16#55, 16#D3, 16#9A, 16#69, 16#16, 16#3F, 16#A8,
		      16#FD, 16#24, 16#CF, 16#5F, 16#83, 16#65, 16#5D,
		      16#23, 16#DC, 16#A3, 16#AD, 16#96, 16#1C, 16#62,
		      16#F3, 16#56, 16#20, 16#85, 16#52, 16#BB, 16#9E,
		      16#D5, 16#29, 16#07, 16#70, 16#96, 16#96, 16#6D,
		      16#67, 16#0C, 16#35, 16#4E, 16#4A, 16#BC, 16#98,
		      16#04, 16#F1, 16#74, 16#6C, 16#08, 16#CA, 16#18,
		      16#21, 16#7C, 16#32, 16#90, 16#5E, 16#46, 16#2E,
		      16#36, 16#CE, 16#3B, 16#E3, 16#9E, 16#77, 16#2C,
		      16#18, 16#0E, 16#86, 16#03, 16#9B, 16#27, 16#83,
		      16#A2, 16#EC, 16#07, 16#A2, 16#8F, 16#B5, 16#C5,
		      16#5D, 16#F0, 16#6F, 16#4C, 16#52, 16#C9, 16#DE,
		      16#2B, 16#CB, 16#F6, 16#95, 16#58, 16#17, 16#18,
		      16#39, 16#95, 16#49, 16#7C, 16#EA, 16#95, 16#6A,
		      16#E5, 16#15, 16#D2, 16#26, 16#18, 16#98, 16#FA,
		      16#05, 16#10, 16#15, 16#72, 16#8E, 16#5A, 16#8A,
		      16#AA, 16#C4, 16#2D, 16#AD, 16#33, 16#17, 16#0D,
		      16#04, 16#50, 16#7A, 16#33, 16#A8, 16#55, 16#21,
		      16#AB, 16#DF, 16#1C, 16#BA, 16#64, 16#EC, 16#FB,
		      16#85, 16#04, 16#58, 16#DB, 16#EF, 16#0A, 16#8A,
		      16#EA, 16#71, 16#57, 16#5D, 16#06, 16#0C, 16#7D,
		      16#B3, 16#97, 16#0F, 16#85, 16#A6, 16#E1, 16#E4,
		      16#C7, 16#AB, 16#F5, 16#AE, 16#8C, 16#DB, 16#09,
		      16#33, 16#D7, 16#1E, 16#8C, 16#94, 16#E0, 16#4A,
		      16#25, 16#61, 16#9D, 16#CE, 16#E3, 16#D2, 16#26,
		      16#1A, 16#D2, 16#EE, 16#6B, 16#F1, 16#2F, 16#FA,
		      16#06, 16#D9, 16#8A, 16#08, 16#64, 16#D8, 16#76,
		      16#02, 16#73, 16#3E, 16#C8, 16#6A, 16#64, 16#52,
		      16#1F, 16#2B, 16#18, 16#17, 16#7B, 16#20, 16#0C,
		      16#BB, 16#E1, 16#17, 16#57, 16#7A, 16#61, 16#5D,
		      16#6C, 16#77, 16#09, 16#88, 16#C0, 16#BA, 16#D9,
		      16#46, 16#E2, 16#08, 16#E2, 16#4F, 16#A0, 16#74,
		      16#E5, 16#AB, 16#31, 16#43, 16#DB, 16#5B, 16#FC,
		      16#E0, 16#FD, 16#10, 16#8E, 16#4B, 16#82, 16#D1,
		      16#20, 16#A9, 16#21, 16#08, 16#01, 16#1A, 16#72,
		      16#3C, 16#12, 16#A7, 16#87, 16#E6, 16#D7, 16#88,
		      16#71, 16#9A, 16#10, 16#BD, 16#BA, 16#5B, 16#26,
		      16#99, 16#C3, 16#27, 16#18, 16#6A, 16#F4, 16#E2,
		      16#3C, 16#1A, 16#94, 16#68, 16#34, 16#B6, 16#15,
		      16#0B, 16#DA, 16#25, 16#83, 16#E9, 16#CA, 16#2A,
		      16#D4, 16#4C, 16#E8, 16#DB, 16#BB, 16#C2, 16#DB,
		      16#04, 16#DE, 16#8E, 16#F9, 16#2E, 16#8E, 16#FC,
		      16#14, 16#1F, 16#BE, 16#CA, 16#A6, 16#28, 16#7C,
		      16#59, 16#47, 16#4E, 16#6B, 16#C0, 16#5D, 16#99,
		      16#B2, 16#96, 16#4F, 16#A0, 16#90, 16#C3, 16#A2,
		      16#23, 16#3B, 16#A1, 16#86, 16#51, 16#5B, 16#E7,
		      16#ED, 16#1F, 16#61, 16#29, 16#70, 16#CE, 16#E2,
		      16#D7, 16#AF, 16#B8, 16#1B, 16#DD, 16#76, 16#21,
		      16#70, 16#48, 16#1C, 16#D0, 16#06, 16#91, 16#27,
		      16#D5, 16#B0, 16#5A, 16#A9, 16#93, 16#B4, 16#EA,
		      16#98, 16#8D, 16#8F, 16#DD, 16#C1, 16#86, 16#FF,
		      16#B7, 16#DC, 16#90, 16#A6, 16#C0, 16#8F, 16#4D,
		      16#F4, 16#35, 16#C9, 16#34, 16#02, 16#84, 16#92,
		      16#36, 16#C3, 16#FA, 16#B4, 16#D2, 16#7C, 16#70,
		      16#26, 16#C1, 16#D4, 16#DC, 16#B2, 16#60, 16#26,
		      16#46, 16#DE, 16#C9, 16#75, 16#1E, 16#76, 16#3D,
		      16#BA, 16#37, 16#BD, 16#F8, 16#FF, 16#94, 16#06,
		      16#AD, 16#9E, 16#53, 16#0E, 16#E5, 16#DB, 16#38,
		      16#2F, 16#41, 16#30, 16#01, 16#AE, 16#B0, 16#6A,
		      16#53, 16#ED, 16#90, 16#27, 16#D8, 16#31, 16#17,
		      16#97, 16#27, 16#B0, 16#86, 16#5A, 16#89, 16#18,
		      16#DA, 16#3E, 16#DB, 16#EB, 16#CF, 16#9B, 16#14,
		      16#ED, 16#44, 16#CE, 16#6C, 16#BA, 16#CE, 16#D4,
		      16#BB, 16#1B, 16#DB, 16#7F, 16#14, 16#47, 16#E6,
		      16#CC, 16#25, 16#4B, 16#33, 16#20, 16#51, 16#51,
		      16#2B, 16#D7, 16#AF, 16#42, 16#6F, 16#B8, 16#F4,
		      16#01, 16#37, 16#8C, 16#D2, 16#BF, 16#59, 16#83,
		      16#CA, 16#01, 16#C6, 16#4B, 16#92, 16#EC, 16#F0,
		      16#32, 16#EA, 16#15, 16#D1, 16#72, 16#1D, 16#03,
		      16#F4, 16#82, 16#D7, 16#CE, 16#6E, 16#74, 16#FE,
		      16#F6, 16#D5, 16#5E, 16#70, 16#2F, 16#46, 16#98,
		      16#0C, 16#82, 16#B5, 16#A8, 16#40, 16#31, 16#90,
		      16#0B, 16#1C, 16#9E, 16#59, 16#E7, 16#C9, 16#7F,
		      16#BE, 16#C7, 16#E8, 16#F3, 16#23, 16#A9, 16#7A,
		      16#7E, 16#36, 16#CC, 16#88, 16#BE, 16#0F, 16#1D,
		      16#45, 16#B7, 16#FF, 16#58, 16#5A, 16#C5, 16#4B,
		      16#D4, 16#07, 16#B2, 16#2B, 16#41, 16#54, 16#AA,
		      16#CC, 16#8F, 16#6D, 16#7E, 16#BF, 16#48, 16#E1,
		      16#D8, 16#14, 16#CC, 16#5E, 16#D2, 16#0F, 16#80,
		      16#37, 16#E0, 16#A7, 16#97, 16#15, 16#EE, 16#F2,
		      16#9B, 16#E3, 16#28, 16#06, 16#A1, 16#D5, 16#8B,
		      16#B7, 16#C5, 16#DA, 16#76, 16#F5, 16#50, 16#AA,
		      16#3D, 16#8A, 16#1F, 16#BF, 16#F0, 16#EB, 16#19,
		      16#CC, 16#B1, 16#A3, 16#13, 16#D5, 16#5C, 16#DA,
		      16#56, 16#C9, 16#EC, 16#2E, 16#F2, 16#96, 16#32,
		      16#38, 16#7F, 16#E8, 16#D7, 16#6E, 16#3C, 16#04,
		      16#68, 16#04, 16#3E, 16#8F, 16#66, 16#3F, 16#48,
		      16#60, 16#EE, 16#12, 16#BF, 16#2D, 16#5B, 16#0B,
		      16#74, 16#74, 16#D6, 16#E6, 16#94, 16#F9, 16#1E,
		      16#6D, 16#BE, 16#11, 16#59, 16#74, 16#A3, 16#92,
		      16#6F, 16#12, 16#FE, 16#E5, 16#E4, 16#38, 16#77,
		      16#7C, 16#B6, 16#A9, 16#32, 16#DF, 16#8C, 16#D8,
		      16#BE, 16#C4, 16#D0, 16#73, 16#B9, 16#31, 16#BA,
		      16#3B, 16#C8, 16#32, 16#B6, 16#8D, 16#9D, 16#D3,
		      16#00, 16#74, 16#1F, 16#A7, 16#BF, 16#8A, 16#FC,
		      16#47, 16#ED, 16#25, 16#76, 16#F6, 16#93, 16#6B,
		      16#A4, 16#24, 16#66, 16#3A, 16#AB, 16#63, 16#9C,
		      16#5A, 16#E4, 16#F5, 16#68, 16#34, 16#23, 16#B4,
		      16#74, 16#2B, 16#F1, 16#C9, 16#78, 16#23, 16#8F,
		      16#16, 16#CB, 16#E3, 16#9D, 16#65, 16#2D, 16#E3,
		      16#FD, 16#B8, 16#BE, 16#FC, 16#84, 16#8A, 16#D9,
		      16#22, 16#22, 16#2E, 16#04, 16#A4, 16#03, 16#7C,
		      16#07, 16#13, 16#EB, 16#57, 16#A8, 16#1A, 16#23,
		      16#F0, 16#C7, 16#34, 16#73, 16#FC, 16#64, 16#6C,
		      16#EA, 16#30, 16#6B, 16#4B, 16#CB, 16#C8, 16#86,
		      16#2F, 16#83, 16#85, 16#DD, 16#FA, 16#9D, 16#4B,
		      16#7F, 16#A2, 16#C0, 16#87, 16#E8, 16#79, 16#68,
		      16#33, 16#03, 16#ED, 16#5B, 16#DD, 16#3A, 16#06,
		      16#2B, 16#3C, 16#F5, 16#B3, 16#A2, 16#78, 16#A6,
		      16#6D, 16#2A, 16#13, 16#F8, 16#3F, 16#44, 16#F8,
		      16#2D, 16#DF, 16#31, 16#0E, 16#E0, 16#74, 16#AB,
		      16#6A, 16#36, 16#45, 16#97, 16#E8, 16#99, 16#A0,
		      16#25, 16#5D, 16#C1, 16#64, 16#F3, 16#1C, 16#C5,
		      16#08, 16#46, 16#85, 16#1D, 16#F9, 16#AB, 16#48,
		      16#19, 16#5D, 16#ED, 16#7E, 16#A1, 16#B1, 16#D5,
		      16#10, 16#BD, 16#7E, 16#E7, 16#4D, 16#73, 16#FA,
		      16#F3, 16#6B, 16#C3, 16#1E, 16#CF, 16#A2, 16#68,
		      16#35, 16#90, 16#46, 16#F4, 16#EB, 16#87, 16#9F,
		      16#92, 16#40, 16#09, 16#43, 16#8B, 16#48, 16#1C,
		      16#6C, 16#D7, 16#88, 16#9A, 16#00, 16#2E, 16#D5,
		      16#EE, 16#38, 16#2B, 16#C9, 16#19, 16#0D, 16#A6,
		      16#FC, 16#02, 16#6E, 16#47, 16#95, 16#58, 16#E4,
		      16#47, 16#56, 16#77, 16#E9, 16#AA, 16#9E, 16#30,
		      16#50, 16#E2, 16#76, 16#56, 16#94, 16#DF, 16#C8,
		      16#1F, 16#56, 16#E8, 16#80, 16#B9, 16#6E, 16#71,
		      16#60, 16#C9, 16#80, 16#DD, 16#98, 16#ED, 16#D3,
		      16#DF, 16#FF, 16#FF, 16#FF, 16#FF, 16#FF, 16#FF,
		      16#FF, 16#FF>>).
-define(GENERATOR_8192, <<19>>).

get_srp_params(srp_1024) -> {?GENERATOR_1024, ?PRIME_1024};
get_srp_params(srp_1536) -> {?GENERATOR_1536, ?PRIME_1536};
get_srp_params(srp_2048) -> {?GENERATOR_2048, ?PRIME_2048};
get_srp_params(srp_3072) -> {?GENERATOR_3072, ?PRIME_3072};
get_srp_params(srp_4096) -> {?GENERATOR_4096, ?PRIME_4096};
get_srp_params(srp_6144) -> {?GENERATOR_6144, ?PRIME_6144};
get_srp_params(srp_8192) -> {?GENERATOR_8192, ?PRIME_8192}.

check_srp_params(?GENERATOR_1024, ?PRIME_1024) -> ok;
check_srp_params(?GENERATOR_1536, ?PRIME_1536) -> ok;
check_srp_params(?GENERATOR_2048, ?PRIME_2048) -> ok;
check_srp_params(?GENERATOR_3072, ?PRIME_3072) -> ok;
check_srp_params(?GENERATOR_4096, ?PRIME_4096) -> ok;
check_srp_params(?GENERATOR_6144, ?PRIME_6144) -> ok;
check_srp_params(?GENERATOR_8192, ?PRIME_8192) -> ok;
check_srp_params(_Generator, _Prime) ->
    not_accepted.
