/*
 * Decompiled with CFR 0.152.
 */
class Matrix3D {
    float xx = 1.0f;
    float xy;
    float xz;
    float xo;
    float yx;
    float yy = 1.0f;
    float yz;
    float yo;
    float zx;
    float zy;
    float zz = 1.0f;
    float zo;
    static final double pi = 3.14159265;

    Matrix3D() {
    }

    void scale(float f) {
        this.xx *= f;
        this.xy *= f;
        this.xz *= f;
        this.xo *= f;
        this.yx *= f;
        this.yy *= f;
        this.yz *= f;
        this.yo *= f;
        this.zx *= f;
        this.zy *= f;
        this.zz *= f;
        this.zo *= f;
    }

    void scale(float xf, float yf, float zf) {
        this.xx *= xf;
        this.xy *= xf;
        this.xz *= xf;
        this.xo *= xf;
        this.yx *= yf;
        this.yy *= yf;
        this.yz *= yf;
        this.yo *= yf;
        this.zx *= zf;
        this.zy *= zf;
        this.zz *= zf;
        this.zo *= zf;
    }

    void translate(float x, float y, float z) {
        this.xo += x;
        this.yo += y;
        this.zo += z;
    }

    void yrot(double theta) {
        double ct = Math.cos(theta *= 0.017453292500000002);
        double st = Math.sin(theta);
        float Nxx = (float)((double)this.xx * ct + (double)this.zx * st);
        float Nxy = (float)((double)this.xy * ct + (double)this.zy * st);
        float Nxz = (float)((double)this.xz * ct + (double)this.zz * st);
        float Nxo = (float)((double)this.xo * ct + (double)this.zo * st);
        float Nzx = (float)((double)this.zx * ct - (double)this.xx * st);
        float Nzy = (float)((double)this.zy * ct - (double)this.xy * st);
        float Nzz = (float)((double)this.zz * ct - (double)this.xz * st);
        float Nzo = (float)((double)this.zo * ct - (double)this.xo * st);
        this.xo = Nxo;
        this.xx = Nxx;
        this.xy = Nxy;
        this.xz = Nxz;
        this.zo = Nzo;
        this.zx = Nzx;
        this.zy = Nzy;
        this.zz = Nzz;
    }

    void xrot(double theta) {
        double ct = Math.cos(theta *= 0.017453292500000002);
        double st = Math.sin(theta);
        float Nyx = (float)((double)this.yx * ct + (double)this.zx * st);
        float Nyy = (float)((double)this.yy * ct + (double)this.zy * st);
        float Nyz = (float)((double)this.yz * ct + (double)this.zz * st);
        float Nyo = (float)((double)this.yo * ct + (double)this.zo * st);
        float Nzx = (float)((double)this.zx * ct - (double)this.yx * st);
        float Nzy = (float)((double)this.zy * ct - (double)this.yy * st);
        float Nzz = (float)((double)this.zz * ct - (double)this.yz * st);
        float Nzo = (float)((double)this.zo * ct - (double)this.yo * st);
        this.yo = Nyo;
        this.yx = Nyx;
        this.yy = Nyy;
        this.yz = Nyz;
        this.zo = Nzo;
        this.zx = Nzx;
        this.zy = Nzy;
        this.zz = Nzz;
    }

    void zrot(double theta) {
        double ct = Math.cos(theta *= 0.017453292500000002);
        double st = Math.sin(theta);
        float Nyx = (float)((double)this.yx * ct + (double)this.xx * st);
        float Nyy = (float)((double)this.yy * ct + (double)this.xy * st);
        float Nyz = (float)((double)this.yz * ct + (double)this.xz * st);
        float Nyo = (float)((double)this.yo * ct + (double)this.xo * st);
        float Nxx = (float)((double)this.xx * ct - (double)this.yx * st);
        float Nxy = (float)((double)this.xy * ct - (double)this.yy * st);
        float Nxz = (float)((double)this.xz * ct - (double)this.yz * st);
        float Nxo = (float)((double)this.xo * ct - (double)this.yo * st);
        this.yo = Nyo;
        this.yx = Nyx;
        this.yy = Nyy;
        this.yz = Nyz;
        this.xo = Nxo;
        this.xx = Nxx;
        this.xy = Nxy;
        this.xz = Nxz;
    }

    void mult(Matrix3D rhs) {
        float lxx = this.xx * rhs.xx + this.yx * rhs.xy + this.zx * rhs.xz;
        float lxy = this.xy * rhs.xx + this.yy * rhs.xy + this.zy * rhs.xz;
        float lxz = this.xz * rhs.xx + this.yz * rhs.xy + this.zz * rhs.xz;
        float lxo = this.xo * rhs.xx + this.yo * rhs.xy + this.zo * rhs.xz + rhs.xo;
        float lyx = this.xx * rhs.yx + this.yx * rhs.yy + this.zx * rhs.yz;
        float lyy = this.xy * rhs.yx + this.yy * rhs.yy + this.zy * rhs.yz;
        float lyz = this.xz * rhs.yx + this.yz * rhs.yy + this.zz * rhs.yz;
        float lyo = this.xo * rhs.yx + this.yo * rhs.yy + this.zo * rhs.yz + rhs.yo;
        float lzx = this.xx * rhs.zx + this.yx * rhs.zy + this.zx * rhs.zz;
        float lzy = this.xy * rhs.zx + this.yy * rhs.zy + this.zy * rhs.zz;
        float lzz = this.xz * rhs.zx + this.yz * rhs.zy + this.zz * rhs.zz;
        float lzo = this.xo * rhs.zx + this.yo * rhs.zy + this.zo * rhs.zz + rhs.zo;
        this.xx = lxx;
        this.xy = lxy;
        this.xz = lxz;
        this.xo = lxo;
        this.yx = lyx;
        this.yy = lyy;
        this.yz = lyz;
        this.yo = lyo;
        this.zx = lzx;
        this.zy = lzy;
        this.zz = lzz;
        this.zo = lzo;
    }

    void unit() {
        this.xo = 0.0f;
        this.xx = 1.0f;
        this.xy = 0.0f;
        this.xz = 0.0f;
        this.yo = 0.0f;
        this.yx = 0.0f;
        this.yy = 1.0f;
        this.yz = 0.0f;
        this.zo = 0.0f;
        this.zx = 0.0f;
        this.zy = 0.0f;
        this.zz = 1.0f;
    }

    void transform(float[] v, int[] tv, int nvert) {
        float lxx = this.xx;
        float lxy = this.xy;
        float lxz = this.xz;
        float lxo = this.xo;
        float lyx = this.yx;
        float lyy = this.yy;
        float lyz = this.yz;
        float lyo = this.yo;
        float lzx = this.zx;
        float lzy = this.zy;
        float lzz = this.zz;
        float lzo = this.zo;
        int i = nvert * 3;
        while ((i -= 3) >= 0) {
            float x = v[i];
            float y = v[i + 1];
            float z = v[i + 2];
            tv[i] = (int)(x * lxx + y * lxy + z * lxz + lxo);
            tv[i + 1] = (int)(x * lyx + y * lyy + z * lyz + lyo);
            tv[i + 2] = (int)(x * lzx + y * lzy + z * lzz + lzo);
        }
    }

    public String toString() {
        return "[" + this.xo + "," + this.xx + "," + this.xy + "," + this.xz + ";" + this.yo + "," + this.yx + "," + this.yy + "," + this.yz + ";" + this.zo + "," + this.zx + "," + this.zy + "," + this.zz + "]";
    }
}

