/*
 * Copyright (c) 2012, 2018, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2016 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in 
 * http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that
 * (a) this copyright and permission notice appear with all copies 
 * of the Data Files or Software,
 * (b) this copyright and permission notice appear in associated 
 * documentation, and
 * (c) there is clear notice in each modified Data File or in the Software
 * as well as in the documentation associated with the Data File(s) or
 * Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_es extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] Moscow = new String[] {
               "hora est\u00e1ndar de Mosc\u00fa",
               "",
               "hora de verano de Mosc\u00fa",
               "",
               "hora de Mosc\u00fa",
               "",
            };
        final String[] Pakistan = new String[] {
               "hora est\u00e1ndar de Pakist\u00e1n",
               "",
               "hora de verano de Pakist\u00e1n",
               "",
               "hora de Pakist\u00e1n",
               "",
            };
        final String[] Magadan = new String[] {
               "hora est\u00e1ndar de Magad\u00e1n",
               "",
               "hora de verano de Magad\u00e1n",
               "",
               "hora de Magad\u00e1n",
               "",
            };
        final String[] Europe_Central = new String[] {
               "hora est\u00e1ndar de Europa central",
               "CET",
               "hora de verano de Europa central",
               "CEST",
               "hora de Europa central",
               "CET",
            };
        final String[] Acre = new String[] {
               "Hora est\u00e1ndar de Acre",
               "",
               "Hora de verano de Acre",
               "",
               "Hora de Acre",
               "",
            };
        final String[] America_Eastern = new String[] {
               "hora est\u00e1ndar oriental",
               "",
               "hora de verano oriental",
               "",
               "hora oriental",
               "",
            };
        final String[] Lord_Howe = new String[] {
               "hora est\u00e1ndar de Lord Howe",
               "",
               "hora de verano de Lord Howe",
               "",
               "hora de Lord Howe",
               "",
            };
        final String[] New_Zealand = new String[] {
               "hora est\u00e1ndar de Nueva Zelanda",
               "",
               "hora de verano de Nueva Zelanda",
               "",
               "hora de Nueva Zelanda",
               "",
            };
        final String[] Indian_Ocean = new String[] {
               "hora del oc\u00e9ano \u00cdndico",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Yakutsk = new String[] {
               "hora est\u00e1ndar de Yakutsk",
               "",
               "hora de verano de Yakutsk",
               "",
               "hora de Yakutsk",
               "",
            };
        final String[] East_Timor = new String[] {
               "hora de Timor Oriental",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kosrae = new String[] {
               "hora de Kosrae",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Europe_Eastern = new String[] {
               "hora est\u00e1ndar de Europa oriental",
               "EET",
               "hora de verano de Europa oriental",
               "EEST",
               "hora de Europa oriental",
               "EET",
            };
        final String[] Argentina_Western = new String[] {
               "hora est\u00e1ndar de Argentina occidental",
               "",
               "hora de verano de Argentina occidental",
               "",
               "hora de Argentina occidental",
               "",
            };
        final String[] Ponape = new String[] {
               "hora de Pohnpei",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Bolivia = new String[] {
               "hora de Bolivia",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Pierre_Miquelon = new String[] {
               "hora est\u00e1ndar de San Pedro y Miquel\u00f3n",
               "",
               "hora de verano de San Pedro y Miquel\u00f3n",
               "",
               "hora de San Pedro y Miquel\u00f3n",
               "",
            };
        final String[] Indochina = new String[] {
               "hora de Indochina",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Yekaterinburg = new String[] {
               "hora est\u00e1ndar de Ekaterimburgo",
               "",
               "hora de verano de Ekaterimburgo",
               "",
               "hora de Ekaterimburgo",
               "",
            };
        final String[] Maldives = new String[] {
               "hora de Maldivas",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tahiti = new String[] {
               "hora de Tahit\u00ed",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wallis = new String[] {
               "hora de Wallis y Futuna",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Africa_Southern = new String[] {
               "hora de Sud\u00e1frica",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Syowa = new String[] {
               "hora de Syowa",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Line_Islands = new String[] {
               "hora de las Esp\u00f3radas Ecuatoriales",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uzbekistan = new String[] {
               "hora est\u00e1ndar de Uzbekist\u00e1n",
               "",
               "hora de verano de Uzbekist\u00e1n",
               "",
               "hora de Uzbekist\u00e1n",
               "",
            };
        final String[] Mongolia = new String[] {
               "hora est\u00e1ndar de Ul\u00e1n Bator",
               "",
               "hora de verano de Ul\u00e1n Bator",
               "",
               "hora de Ul\u00e1n Bator",
               "",
            };
        final String[] America_Central = new String[] {
               "hora est\u00e1ndar central",
               "",
               "hora de verano central",
               "",
               "hora central",
               "",
            };
        final String[] Niue = new String[] {
               "hora de Niue",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wake = new String[] {
               "hora de la isla Wake",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Falkland = new String[] {
               "hora est\u00e1ndar de las islas Malvinas",
               "",
               "hora de verano de las islas Malvinas",
               "",
               "hora de las islas Malvinas",
               "",
            };
        final String[] Bhutan = new String[] {
               "hora de But\u00e1n",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Apia = new String[] {
               "hora est\u00e1ndar de Apia",
               "",
               "horario de verano de Apia",
               "",
               "hora de Apia",
               "",
            };
        final String[] Nauru = new String[] {
               "hora de Nauru",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kazakhstan_Western = new String[] {
               "hora de Kazajist\u00e1n occidental",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Christmas = new String[] {
               "hora de la Isla de Navidad",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Reunion = new String[] {
               "hora de Reuni\u00f3n",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Cocos = new String[] {
               "hora de las Islas Cocos",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chatham = new String[] {
               "hora est\u00e1ndar de Chatham",
               "",
               "hora de verano de Chatham",
               "",
               "hora de Chatham",
               "",
            };
        final String[] Vostok = new String[] {
               "hora de Vostok",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Argentina = new String[] {
               "hora est\u00e1ndar de Argentina",
               "",
               "hora de verano de Argentina",
               "",
               "hora de Argentina",
               "",
            };
        final String[] Gambier = new String[] {
               "hora de Gambier",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Galapagos = new String[] {
               "hora de Gal\u00e1pagos",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Venezuela = new String[] {
               "hora de Venezuela",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Phoenix_Islands = new String[] {
               "hora de las Islas F\u00e9nix",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Cape_Verde = new String[] {
               "hora est\u00e1ndar de Cabo Verde",
               "",
               "hora de verano de Cabo Verde",
               "",
               "hora de Cabo Verde",
               "",
            };
        final String[] Norfolk = new String[] {
               "hora de la isla Norfolk",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samoa = new String[] {
               "hora est\u00e1ndar de Samoa",
               "",
               "hora de verano de Samoa",
               "",
               "hora de Samoa",
               "",
            };
        final String[] Davis = new String[] {
               "hora de Davis",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Cuba = new String[] {
               "hora est\u00e1ndar de Cuba",
               "",
               "hora de verano de Cuba",
               "",
               "hora de Cuba",
               "",
            };
        final String[] GMT = new String[] {
               "hora del meridiano de Greenwich",
               "GMT",
               "",
               "",
               "",
               "",
            };
        final String[] Philippines = new String[] {
               "hora est\u00e1ndar de Filipinas",
               "",
               "hora de verano de Filipinas",
               "",
               "hora de Filipinas",
               "",
            };
        final String[] French_Southern = new String[] {
               "hora de las Tierras Australes y Ant\u00e1rticas Francesas",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] New_Caledonia = new String[] {
               "hora est\u00e1ndar de Nueva Caledonia",
               "",
               "hora de verano de Nueva Caledonia",
               "",
               "hora de Nueva Caledonia",
               "",
            };
        final String[] Brunei = new String[] {
               "hora de Brun\u00e9i",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Iran = new String[] {
               "hora est\u00e1ndar de Ir\u00e1n",
               "",
               "hora de verano de Ir\u00e1n",
               "",
               "hora de Ir\u00e1n",
               "",
            };
        final String[] Tajikistan = new String[] {
               "hora de Tayikist\u00e1n",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tonga = new String[] {
               "hora est\u00e1ndar de Tonga",
               "",
               "hora de verano de Tonga",
               "",
               "hora de Tonga",
               "",
            };
        final String[] Bangladesh = new String[] {
               "hora est\u00e1ndar de Banglad\u00e9s",
               "",
               "hora de verano de Banglad\u00e9s",
               "",
               "hora de Banglad\u00e9s",
               "",
            };
        final String[] Peru = new String[] {
               "hora est\u00e1ndar de Per\u00fa",
               "",
               "hora de verano de Per\u00fa",
               "",
               "hora de Per\u00fa",
               "",
            };
        final String[] Greenland_Eastern = new String[] {
               "hora est\u00e1ndar de Groenlandia oriental",
               "",
               "hora de verano de Groenlandia oriental",
               "",
               "hora de Groenlandia oriental",
               "",
            };
        final String[] Indonesia_Eastern = new String[] {
               "hora de Indonesia oriental",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kyrgystan = new String[] {
               "hora de Kirguist\u00e1n",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Colombia = new String[] {
               "hora est\u00e1ndar de Colombia",
               "",
               "hora de verano de Colombia",
               "",
               "hora de Colombia",
               "",
            };
        final String[] French_Guiana = new String[] {
               "hora de la Guayana Francesa",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Australia_Eastern = new String[] {
               "hora est\u00e1ndar de Australia oriental",
               "",
               "hora de verano de Australia oriental",
               "",
               "hora de Australia oriental",
               "",
            };
        final String[] Chile = new String[] {
               "hora est\u00e1ndar de Chile",
               "",
               "hora de verano de Chile",
               "",
               "hora de Chile",
               "",
            };
        final String[] Gilbert_Islands = new String[] {
               "hora de las islas Gilbert",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Irkutsk = new String[] {
               "hora est\u00e1ndar de Irkutsk",
               "",
               "hora de verano de Irkutsk",
               "",
               "hora de Irkutsk",
               "",
            };
        final String[] Georgia = new String[] {
               "hora est\u00e1ndar de Georgia",
               "",
               "hora de verano de Georgia",
               "",
               "hora de Georgia",
               "",
            };
        final String[] Choibalsan = new String[] {
               "hora est\u00e1ndar de Choibalsan",
               "",
               "hora de verano de Choibalsan",
               "",
               "hora de Choibalsan",
               "",
            };
        final String[] China = new String[] {
               "hora est\u00e1ndar de China",
               "",
               "hora de verano de China",
               "",
               "hora de China",
               "",
            };
        final String[] Armenia = new String[] {
               "hora est\u00e1ndar de Armenia",
               "",
               "hora de verano de Armenia",
               "",
               "hora de Armenia",
               "",
            };
        final String[] Africa_Central = new String[] {
               "hora de \u00c1frica central",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Japan = new String[] {
               "hora est\u00e1ndar de Jap\u00f3n",
               "",
               "hora de verano de Jap\u00f3n",
               "",
               "hora de Jap\u00f3n",
               "",
            };
        final String[] Taipei = new String[] {
               "hora est\u00e1ndar de Taip\u00e9i",
               "",
               "hora de verano de Taip\u00e9i",
               "",
               "hora de Taip\u00e9i",
               "",
            };
        final String[] Hovd = new String[] {
               "hora est\u00e1ndar de Hovd",
               "",
               "hora de verano de Hovd",
               "",
               "hora de Hovd",
               "",
            };
        final String[] Australia_CentralWestern = new String[] {
               "hora est\u00e1ndar de Australia centroccidental",
               "",
               "hora de verano de Australia centroccidental",
               "",
               "hora de Australia centroccidental",
               "",
            };
        final String[] Sakhalin = new String[] {
               "hora est\u00e1ndar de Sajal\u00edn",
               "",
               "hora de verano de Sajal\u00edn",
               "",
               "hora de Sajal\u00edn",
               "",
            };
        final String[] Paraguay = new String[] {
               "hora est\u00e1ndar de Paraguay",
               "",
               "hora de verano de Paraguay",
               "",
               "hora de Paraguay",
               "",
            };
        final String[] Malaysia = new String[] {
               "hora de Malasia",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mauritius = new String[] {
               "hora est\u00e1ndar de Mauricio",
               "",
               "hora de verano de Mauricio",
               "",
               "hora de Mauricio",
               "",
            };
        final String[] Africa_Eastern = new String[] {
               "hora de \u00c1frica oriental",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Solomon = new String[] {
               "hora de las Islas Salom\u00f3n",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Marshall_Islands = new String[] {
               "hora de las Islas Marshall",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Newfoundland = new String[] {
               "hora est\u00e1ndar de Terranova",
               "",
               "hora de verano de Terranova",
               "",
               "hora de Terranova",
               "",
            };
        final String[] Afghanistan = new String[] {
               "hora de Afganist\u00e1n",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hong_Kong = new String[] {
               "hora est\u00e1ndar de Hong Kong",
               "",
               "hora de verano de Hong Kong",
               "",
               "hora de Hong Kong",
               "",
            };
        final String[] Atlantic = new String[] {
               "hora est\u00e1ndar del Atl\u00e1ntico",
               "",
               "hora de verano del Atl\u00e1ntico",
               "",
               "hora del Atl\u00e1ntico",
               "",
            };
        final String[] Israel = new String[] {
               "hora est\u00e1ndar de Israel",
               "",
               "hora de verano de Israel",
               "",
               "hora de Israel",
               "",
            };
        final String[] Indonesia_Central = new String[] {
               "hora de Indonesia central",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Omsk = new String[] {
               "hora est\u00e1ndar de Omsk",
               "",
               "hora de verano de Omsk",
               "",
               "hora de Omsk",
               "",
            };
        final String[] Seychelles = new String[] {
               "hora de Seychelles",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uruguay = new String[] {
               "hora est\u00e1ndar de Uruguay",
               "",
               "hora de verano de Uruguay",
               "",
               "hora de Uruguay",
               "",
            };
        final String[] Nepal = new String[] {
               "hora de Nepal",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Truk = new String[] {
               "hora de Chuuk",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Vanuatu = new String[] {
               "hora est\u00e1ndar de Vanuatu",
               "",
               "hora de verano de Vanuatu",
               "",
               "hora de Vanuatu",
               "",
            };
        final String[] Novosibirsk = new String[] {
               "hora est\u00e1ndar de Novosibirsk",
               "",
               "hora de verano de Novosibirsk",
               "",
               "hora de Novosibirsk",
               "",
            };
        final String[] Singapore = new String[] {
               "hora de Singapur",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Azores = new String[] {
               "hora est\u00e1ndar de las Azores",
               "",
               "hora de verano de las Azores",
               "",
               "hora de las Azores",
               "",
            };
        final String[] Suriname = new String[] {
               "hora de Surinam",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Krasnoyarsk = new String[] {
               "hora est\u00e1ndar de Krasnoyarsk",
               "",
               "hora de verano de Krasnoyarsk",
               "",
               "hora de Krasnoyarsk",
               "",
            };
        final String[] Myanmar = new String[] {
               "hora de Myanmar (Birmania)",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Amazon = new String[] {
               "hora est\u00e1ndar del Amazonas",
               "",
               "hora de verano del Amazonas",
               "",
               "hora del Amazonas",
               "",
            };
        final String[] Kazakhstan_Eastern = new String[] {
               "hora de Kazajist\u00e1n oriental",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Fiji = new String[] {
               "hora est\u00e1ndar de Fiyi",
               "",
               "hora de verano de Fiyi",
               "",
               "hora de Fiyi",
               "",
            };
        final String[] Kamchatka = new String[] {
               "hora est\u00e1ndar de Kamchatka",
               "",
               "hora de verano de Kamchatka",
               "",
               "hora de Kamchatka",
               "",
            };
        final String[] Tuvalu = new String[] {
               "hora de Tuvalu",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Macquarie = new String[] {
               "hora de la isla Macquarie",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "hora est\u00e1ndar de Haw\u00e1i-Aleutianas",
               "",
               "hora de verano de Haw\u00e1i-Aleutianas",
               "",
               "hora de Haw\u00e1i-Aleutianas",
               "",
            };
        final String[] Australia_Central = new String[] {
               "hora est\u00e1ndar de Australia central",
               "",
               "hora de verano de Australia central",
               "",
               "hora de Australia central",
               "",
            };
        final String[] America_Pacific = new String[] {
               "hora est\u00e1ndar del Pac\u00edfico",
               "",
               "hora de verano del Pac\u00edfico",
               "",
               "hora del Pac\u00edfico",
               "",
            };
        final String[] Turkmenistan = new String[] {
               "hora est\u00e1ndar de Turkmenist\u00e1n",
               "",
               "hora de verano de Turkmenist\u00e1n",
               "",
               "hora de Turkmenist\u00e1n",
               "",
            };
        final String[] Europe_Western = new String[] {
               "hora est\u00e1ndar de Europa occidental",
               "WET",
               "hora de verano de Europa occidental",
               "WEST",
               "hora de Europa occidental",
               "WET",
            };
        final String[] Guyana = new String[] {
               "hora de Guyana",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Pitcairn = new String[] {
               "hora de Pitcairn",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Rothera = new String[] {
               "hora de Rothera",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Palau = new String[] {
               "hora de Palaos",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Azerbaijan = new String[] {
               "hora est\u00e1ndar de Azerbaiy\u00e1n",
               "",
               "hora de verano de Azerbaiy\u00e1n",
               "",
               "hora de Azerbaiy\u00e1n",
               "",
            };
        final String[] Mawson = new String[] {
               "hora de Mawson",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mexico_Pacific = new String[] {
               "hora est\u00e1ndar del Pac\u00edfico de M\u00e9xico",
               "",
               "hora de verano del Pac\u00edfico de M\u00e9xico",
               "",
               "hora del Pac\u00edfico de M\u00e9xico",
               "",
            };
        final String[] Africa_Western = new String[] {
               "hora est\u00e1ndar de \u00c1frica occidental",
               "",
               "hora de verano de \u00c1frica occidental",
               "",
               "hora de \u00c1frica occidental",
               "",
            };
        final String[] South_Georgia = new String[] {
               "hora de Georgia del Sur",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mexico_Northwest = new String[] {
               "hora est\u00e1ndar del noroeste de M\u00e9xico",
               "",
               "hora de verano del noroeste de M\u00e9xico",
               "",
               "hora del noroeste de M\u00e9xico",
               "",
            };
        final String[] Easter = new String[] {
               "hora est\u00e1ndar de la isla de Pascua",
               "",
               "hora de verano de la isla de Pascua",
               "",
               "hora de la isla de Pascua",
               "",
            };
        final String[] DumontDUrville = new String[] {
               "hora de Dumont-d\u2019Urville",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Greenland_Western = new String[] {
               "hora est\u00e1ndar de Groenlandia occidental",
               "",
               "hora de verano de Groenlandia occidental",
               "",
               "hora de Groenlandia occidental",
               "",
            };
        final String[] Ecuador = new String[] {
               "hora de Ecuador",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gulf = new String[] {
               "hora est\u00e1ndar del Golfo",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Korea = new String[] {
               "hora est\u00e1ndar de Corea",
               "",
               "hora de verano de Corea",
               "",
               "hora de Corea",
               "",
            };
        final String[] Australia_Western = new String[] {
               "hora est\u00e1ndar de Australia occidental",
               "",
               "hora de verano de Australia occidental",
               "",
               "hora de Australia occidental",
               "",
            };
        final String[] Indonesia_Western = new String[] {
               "hora de Indonesia occidental",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] America_Mountain = new String[] {
               "hora est\u00e1ndar de las Monta\u00f1as Rocosas",
               "",
               "hora de verano de las Monta\u00f1as Rocosas",
               "",
               "hora de las Monta\u00f1as Rocosas",
               "",
            };
        final String[] Marquesas = new String[] {
               "hora de Marquesas",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Arabian = new String[] {
               "hora est\u00e1ndar de Arabia",
               "",
               "hora de verano de Arabia",
               "",
               "hora de Arabia",
               "",
            };
        final String[] Alaska = new String[] {
               "hora est\u00e1ndar de Alaska",
               "",
               "hora de verano de Alaska",
               "",
               "hora de Alaska",
               "",
            };
        final String[] Vladivostok = new String[] {
               "hora est\u00e1ndar de Vladivostok",
               "",
               "hora de verano de Vladivostok",
               "",
               "hora de Vladivostok",
               "",
            };
        final String[] Chamorro = new String[] {
               "hora est\u00e1ndar de Chamorro",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tokelau = new String[] {
               "hora de Tokelau",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Papua_New_Guinea = new String[] {
               "hora de Pap\u00faa Nueva Guinea",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Noronha = new String[] {
               "hora est\u00e1ndar de Fernando de Noronha",
               "",
               "hora de verano de Fernando de Noronha",
               "",
               "hora de Fernando de Noronha",
               "",
            };
        final String[] Brasilia = new String[] {
               "hora est\u00e1ndar de Brasilia",
               "",
               "hora de verano de Brasilia",
               "",
               "hora de Brasilia",
               "",
            };
        final String[] Anadyr = new String[] {
               "hora est\u00e1ndar de Anadyr",
               "",
               "hora de verano de Anadyr",
               "",
               "hora de Anadyr",
               "",
            };
        final String[] Samara = new String[] {
               "hora est\u00e1ndar de Samara",
               "",
               "hora de verano de Samara",
               "",
               "hora de Samara",
               "",
            };
        final String[] Pyongyang = new String[] {
               "hora de Pyongyang",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] India = new String[] {
               "hora est\u00e1ndar de la India",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Cook = new String[] {
               "hora est\u00e1ndar de las Islas Cook",
               "",
               "hora de verano media de las Islas Cook",
               "",
               "hora de las Islas Cook",
               "",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii_Aleutian },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Africa/Casablanca", Europe_Western },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "UTC",
                new String[] {
                    "",
                    "",
                    "",
                    "",
                    "",
                    "",
                }
            },
            { "Asia/Aden", Arabian },
            { "timezone.excity.America/Phoenix", "Phoenix" },
            { "timezone.excity.Asia/Katmandu", "Katmand\u00fa" },
            { "timezone.excity.America/Antigua", "Antigua" },
            { "timezone.excity.Europe/Ljubljana", "Liubliana" },
            { "Asia/Aqtau", Kazakhstan_Western },
            { "timezone.excity.Pacific/Marquesas", "Marquesas" },
            { "America/El_Salvador", America_Central },
            { "timezone.excity.America/Buenos_Aires", "Buenos Aires" },
            { "Asia/Pontianak", Indonesia_Western },
            { "timezone.excity.America/Danmarkshavn", "Danmarkshavn" },
            { "timezone.excity.America/Anchorage", "Anchorage" },
            { "Africa/Mbabane", Africa_Southern },
            { "Asia/Kuching", Malaysia },
            { "Europe/London",
                new String[] {
                    "hora del meridiano de Greenwich",
                    "GMT",
                    "hora de verano brit\u00e1nica",
                    "",
                    "",
                    "",
                }
            },
            { "timezone.excity.Antarctica/Vostok", "Vostok" },
            { "America/Panama", America_Eastern },
            { "timezone.excity.America/North_Dakota/Beulah", "Beulah, Dakota del Norte" },
            { "timezone.excity.Pacific/Fiji", "Fiyi" },
            { "timezone.excity.Europe/Gibraltar", "Gibraltar" },
            { "Europe/Jersey", GMT },
            { "timezone.excity.Africa/Malabo", "Malabo" },
            { "America/Eirunepe", Acre },
            { "Europe/Luxembourg", Europe_Central },
            { "timezone.excity.Africa/Libreville", "Libreville" },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "timezone.excity.Africa/Dakar", "Dakar" },
            { "Atlantic/St_Helena", GMT },
            { "timezone.excity.Africa/Addis_Ababa", "Addis Abeba" },
            { "timezone.excity.Africa/Kinshasa", "Kinshasa" },
            { "timezone.excity.Asia/Dushanbe", "Dusamb\u00e9" },
            { "Europe/Guernsey", GMT },
            { "America/Grand_Turk", America_Eastern },
            { "Asia/Samarkand", Uzbekistan },
            { "timezone.excity.Europe/Tallinn", "Tallin" },
            { "Asia/Phnom_Penh", Indochina },
            { "Africa/Kigali", Africa_Central },
            { "timezone.excity.Pacific/Guam", "Guam" },
            { "timezone.excity.Europe/Vaduz", "Vaduz" },
            { "America/Argentina/Salta", Argentina },
            { "Africa/Tripoli", Europe_Eastern },
            { "Africa/Banjul", GMT },
            { "timezone.excity.America/Santa_Isabel", "Santa Isabel" },
            { "timezone.excity.Asia/Barnaul", "Barna\u00fal" },
            { "Antarctica/Syowa", Syowa },
            { "timezone.excity.Africa/Maseru", "Maseru" },
            { "Pacific/Palau", Palau },
            { "timezone.excity.Europe/London", "Londres" },
            { "America/Montevideo", Uruguay },
            { "Africa/Windhoek", Africa_Central },
            { "Asia/Karachi", Pakistan },
            { "timezone.excity.Pacific/Pitcairn", "Pitcairn" },
            { "Australia/Perth", Australia_Western },
            { "Asia/Chita", Yakutsk },
            { "Pacific/Easter", Easter },
            { "Antarctica/Davis", Davis },
            { "timezone.excity.Asia/Krasnoyarsk", "Krasnoyarsk" },
            { "Antarctica/McMurdo", New_Zealand },
            { "timezone.excity.America/Nome", "Nome" },
            { "Pacific/Tahiti", Tahiti },
            { "HST", Hawaii_Aleutian },
            { "timezone.excity.America/Vancouver", "Vancouver" },
            { "timezone.excity.America/Matamoros", "Matamoros" },
            { "Africa/Asmera", Africa_Eastern },
            { "Europe/Busingen", Europe_Central },
            { "timezone.excity.Asia/Choibalsan", "Choibalsan" },
            { "timezone.excity.America/Inuvik", "Inuvik" },
            { "Africa/Malabo", Africa_Western },
            { "America/Catamarca", Argentina },
            { "America/Godthab", Greenland_Western },
            { "timezone.excity.America/St_Lucia", "Santa Luc\u00eda" },
            { "timezone.excity.Asia/Novokuznetsk", "Novokuznetsk" },
            { "timezone.excity.Europe/Berlin", "Berl\u00edn" },
            { "Africa/Lagos", Africa_Western },
            { "timezone.excity.Pacific/Midway", "Midway" },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mauritius", Mauritius },
            { "timezone.excity.America/Martinique", "Martinica" },
            { "America/Dawson_Creek", America_Mountain },
            { "America/St_Thomas", Atlantic },
            { "Europe/Zurich", Europe_Central },
            { "Asia/Dili", East_Timor },
            { "timezone.excity.Australia/Perth", "Perth" },
            { "Africa/Bamako", GMT },
            { "timezone.excity.Arctic/Longyearbyen", "Longyearbyen" },
            { "Pacific/Wallis", Wallis },
            { "timezone.excity.America/Tegucigalpa", "Tegucigalpa" },
            { "timezone.excity.Africa/Windhoek", "Windhoek" },
            { "Africa/Lubumbashi", Africa_Central },
            { "timezone.excity.Pacific/Majuro", "Majuro" },
            { "Asia/Choibalsan", Choibalsan },
            { "Asia/Omsk", Omsk },
            { "Europe/Vaduz", Europe_Central },
            { "timezone.excity.Africa/Banjul", "Banjul" },
            { "Asia/Dhaka", Bangladesh },
            { "timezone.excity.Australia/Lindeman", "Lindeman" },
            { "timezone.excity.America/Miquelon", "Miquel\u00f3n" },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "America/Louisville", America_Eastern },
            { "timezone.excity.America/Jujuy", "Jujuy" },
            { "timezone.excity.America/Argentina/Ushuaia", "Ushuaia" },
            { "timezone.excity.America/North_Dakota/Center", "Center, Dakota del Norte" },
            { "timezone.excity.America/Cayenne", "Cayena" },
            { "Pacific/Chatham", Chatham },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "timezone.excity.America/Belize", "Belice" },
            { "Asia/Dushanbe", Tajikistan },
            { "America/Guyana", Guyana },
            { "America/Martinique", Atlantic },
            { "Europe/Berlin", Europe_Central },
            { "timezone.excity.Asia/Bangkok", "Bangkok" },
            { "Europe/Moscow", Moscow },
            { "America/Puerto_Rico", Atlantic },
            { "Pacific/Ponape", Ponape },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Europe/Helsinki", Europe_Eastern },
            { "timezone.excity.America/Montevideo", "Montevideo" },
            { "timezone.excity.Pacific/Johnston", "Johnston" },
            { "America/Cayenne", French_Guiana },
            { "timezone.excity.Europe/Jersey", "Jersey" },
            { "timezone.excity.America/Pangnirtung", "Pangnirtung" },
            { "timezone.excity.Atlantic/South_Georgia", "Georgia del Sur" },
            { "Pacific/Fiji", Fiji },
            { "timezone.excity.Africa/Juba", "Juba" },
            { "America/Rainy_River", America_Central },
            { "Indian/Maldives", Maldives },
            { "SystemV/AST4", Atlantic },
            { "timezone.excity.America/Havana", "La Habana" },
            { "timezone.excity.Europe/Madrid", "Madrid" },
            { "Asia/Oral", Kazakhstan_Western },
            { "timezone.excity.America/Detroit", "Detroit" },
            { "America/Yellowknife", America_Mountain },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "America/Juneau", Alaska },
            { "America/Indiana/Vevay", America_Eastern },
            { "timezone.excity.America/Grenada", "Granada" },
            { "timezone.excity.Asia/Phnom_Penh", "Phnom Penh" },
            { "timezone.excity.Europe/Rome", "Roma" },
            { "timezone.excity.Asia/Hebron", "Hebr\u00f3n" },
            { "Asia/Jakarta", Indonesia_Western },
            { "timezone.excity.Antarctica/Mawson", "Mawson" },
            { "timezone.excity.Asia/Karachi", "Karachi" },
            { "timezone.excity.America/Resolute", "Resolute" },
            { "timezone.excity.Africa/Nouakchott", "Nuakchot" },
            { "timezone.excity.Africa/Bamako", "Bamako" },
            { "timezone.excity.America/Argentina/Salta", "Salta" },
            { "America/Recife", Brasilia },
            { "America/Buenos_Aires", Argentina },
            { "timezone.excity.Asia/Muscat", "Mascate" },
            { "America/Noronha", Noronha },
            { "timezone.excity.Africa/El_Aaiun", "El Aai\u00fan" },
            { "timezone.excity.Australia/Hobart", "Hobart" },
            { "Australia/Adelaide", Australia_Central },
            { "timezone.excity.America/Lima", "Lima" },
            { "timezone.excity.America/North_Dakota/New_Salem", "New Salem, Dakota del Norte" },
            { "timezone.excity.Asia/Atyrau", "Atyrau" },
            { "America/Paramaribo", Suriname },
            { "timezone.excity.Asia/Bishkek", "Bishkek" },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/Mawson", Mawson },
            { "timezone.excity.America/Paramaribo", "Paramaribo" },
            { "Antarctica/Troll", GMT },
            { "timezone.excity.America/Ojinaga", "Ojinaga" },
            { "timezone.excity.Europe/Zurich", "Z\u00farich" },
            { "Europe/Samara", Samara },
            { "America/Antigua", Atlantic },
            { "timezone.excity.America/Sao_Paulo", "S\u00e3o Paulo" },
            { "Pacific/Gambier", Gambier },
            { "Africa/Gaborone", Africa_Central },
            { "Asia/Pyongyang", Pyongyang },
            { "timezone.excity.America/New_York", "Nueva York" },
            { "Asia/Gaza", Europe_Eastern },
            { "timezone.excity.Africa/Accra", "Acra" },
            { "timezone.excity.Etc/Unknown", "ciudad desconocida" },
            { "Asia/Qyzylorda", Kazakhstan_Eastern },
            { "timezone.excity.America/Thule", "Thule" },
            { "timezone.excity.America/Grand_Turk", "Gran Turca" },
            { "America/Yakutat", Alaska },
            { "Europe/Vienna", Europe_Central },
            { "timezone.excity.America/Winnipeg", "Winnipeg" },
            { "timezone.excity.Antarctica/Macquarie", "Macquarie" },
            { "timezone.excity.Europe/Uzhgorod", "\u00dazhgorod" },
            { "timezone.excity.America/Caracas", "Caracas" },
            { "timezone.excity.America/Dawson_Creek", "Dawson Creek" },
            { "timezone.excity.America/Bogota", "Bogot\u00e1" },
            { "timezone.excity.Asia/Baku", "Bak\u00fa" },
            { "timezone.excity.Asia/Hovd", "Hovd" },
            { "timezone.excity.Africa/Harare", "Harare" },
            { "Europe/Tirane", Europe_Central },
            { "timezone.excity.America/Blanc-Sablon", "Blanc-Sablon" },
            { "timezone.excity.Africa/Algiers", "Argel" },
            { "Australia/Broken_Hill", Australia_Central },
            { "Europe/Riga", Europe_Eastern },
            { "timezone.excity.Africa/Khartoum", "Jart\u00fan" },
            { "Africa/Abidjan", GMT },
            { "America/Santarem", Brasilia },
            { "timezone.excity.Asia/Khandyga", "Khandyga" },
            { "EST5EDT", America_Eastern },
            { "Pacific/Guam", Chamorro },
            { "Atlantic/Bermuda", Atlantic },
            { "timezone.excity.Pacific/Galapagos", "Gal\u00e1pagos" },
            { "America/Costa_Rica", America_Central },
            { "America/Dawson", America_Pacific },
            { "Europe/Amsterdam", Europe_Central },
            { "timezone.excity.America/Argentina/Tucuman", "Tucum\u00e1n" },
            { "timezone.excity.America/Rio_Branco", "R\u00edo Branco" },
            { "Africa/Accra", GMT },
            { "timezone.excity.Europe/Ulyanovsk", "Uli\u00e1novsk" },
            { "timezone.excity.Africa/Niamey", "Niamey" },
            { "timezone.excity.Indian/Mayotte", "Mayotte" },
            { "America/Maceio", Brasilia },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Europe/Dublin",
                new String[] {
                    "hora del meridiano de Greenwich",
                    "GMT",
                    "hora de verano de Irlanda",
                    "",
                    "",
                    "",
                }
            },
            { "Pacific/Truk", Truk },
            { "timezone.excity.Africa/Conakry", "Conakry" },
            { "timezone.excity.Asia/Jakarta", "Yakarta" },
            { "America/Jamaica", America_Eastern },
            { "Asia/Bishkek", Kyrgystan },
            { "Atlantic/Stanley", Falkland },
            { "timezone.excity.Europe/Saratov", "Sar\u00e1tov" },
            { "SystemV/CST6", America_Central },
            { "timezone.excity.Pacific/Efate", "Efate" },
            { "timezone.excity.Asia/Aqtobe", "Aktobe" },
            { "Asia/Vladivostok", Vladivostok },
            { "timezone.excity.Atlantic/St_Helena", "Santa Elena" },
            { "Africa/Maputo", Africa_Central },
            { "Africa/El_Aaiun", Europe_Western },
            { "Africa/Ouagadougou", GMT },
            { "timezone.excity.Pacific/Rarotonga", "Rarotonga" },
            { "timezone.excity.Europe/Luxembourg", "Luxemburgo" },
            { "America/Cayman", America_Eastern },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Baghdad", Arabian },
            { "timezone.excity.Asia/Bahrain", "Bar\u00e9in" },
            { "timezone.excity.Indian/Mahe", "Mah\u00e9" },
            { "Europe/San_Marino", Europe_Central },
            { "America/Indiana/Tell_City", America_Central },
            { "timezone.excity.Europe/Isle_of_Man", "Isla de Man" },
            { "Pacific/Saipan", Chamorro },
            { "timezone.excity.America/Curacao", "Curazao" },
            { "timezone.excity.Pacific/Nauru", "Nauru" },
            { "timezone.excity.Pacific/Pago_Pago", "Pago Pago" },
            { "Antarctica/Rothera", Rothera },
            { "timezone.excity.America/Guyana", "Guyana" },
            { "Asia/Damascus", Europe_Eastern },
            { "America/Argentina/San_Luis", Argentina_Western },
            { "timezone.excity.Europe/Paris", "Par\u00eds" },
            { "timezone.excity.Europe/Zagreb", "Zagreb" },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/La_Paz", Bolivia },
            { "timezone.excity.America/Swift_Current", "Swift Current" },
            { "Asia/Manila", Philippines },
            { "Asia/Bangkok", Indochina },
            { "timezone.excity.America/Tortola", "T\u00f3rtola" },
            { "Atlantic/Madeira", Europe_Western },
            { "America/Thunder_Bay", America_Eastern },
            { "timezone.excity.Europe/Budapest", "Budapest" },
            { "timezone.excity.America/Catamarca", "Catamarca" },
            { "timezone.excity.America/Port_of_Spain", "Puerto Espa\u00f1a" },
            { "timezone.excity.Asia/Chita", "Chit\u00e1" },
            { "America/Indiana/Marengo", America_Eastern },
            { "timezone.excity.America/Rankin_Inlet", "Rankin Inlet" },
            { "America/Punta_Arenas",
                new String[] {
                    "",
                    "",
                    "",
                    "",
                    "",
                    "",
                }
            },
            { "timezone.excity.America/Santarem", "Santar\u00e9m" },
            { "timezone.excity.Asia/Tomsk", "Tomsk" },
            { "timezone.excity.Europe/Helsinki", "Helsinki" },
            { "America/Mexico_City", America_Central },
            { "timezone.excity.America/Yakutat", "Yakutat" },
            { "Antarctica/Vostok", Vostok },
            { "Europe/Andorra", Europe_Central },
            { "timezone.excity.Asia/Anadyr", "An\u00e1dyr" },
            { "timezone.excity.Asia/Urumqi", "\u00dcr\u00fcmqi" },
            { "timezone.excity.America/Costa_Rica", "Costa Rica" },
            { "timezone.excity.Africa/Lagos", "Lagos" },
            { "timezone.excity.Africa/Bissau", "Bis\u00e1u" },
            { "America/Matamoros", America_Central },
            { "America/Blanc-Sablon", Atlantic },
            { "Asia/Riyadh", Arabian },
            { "timezone.excity.Africa/Douala", "Duala" },
            { "Europe/Oslo", Europe_Central },
            { "timezone.excity.Africa/Mogadishu", "Mogadiscio" },
            { "timezone.excity.America/Bahia_Banderas", "Bah\u00eda de Banderas" },
            { "timezone.excity.Asia/Jayapura", "Jayapura" },
            { "America/Menominee", America_Central },
            { "timezone.excity.Pacific/Guadalcanal", "Guadalcanal" },
            { "America/Resolute", America_Central },
            { "timezone.excity.Africa/Lome", "Lom\u00e9" },
            { "timezone.excity.America/Nassau", "Nassau" },
            { "Africa/Kampala", Africa_Eastern },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "timezone.excity.Asia/Kuwait", "Kuwait" },
            { "timezone.excity.America/Santo_Domingo", "Santo Domingo" },
            { "America/Edmonton", America_Mountain },
            { "Europe/Podgorica", Europe_Central },
            { "timezone.excity.Europe/Moscow", "Mosc\u00fa" },
            { "Africa/Bujumbura", Africa_Central },
            { "Europe/Minsk", Moscow },
            { "Pacific/Auckland", New_Zealand },
            { "timezone.excity.Asia/Taipei", "Taip\u00e9i" },
            { "Asia/Qatar", Arabian },
            { "Europe/Kiev", Europe_Eastern },
            { "America/Port-au-Prince", America_Eastern },
            { "Europe/Belfast",
                new String[] {
                    "hora del meridiano de Greenwich",
                    "GMT",
                    "hora de verano brit\u00e1nica",
                    "",
                    "",
                    "",
                }
            },
            { "Asia/Ashgabat", Turkmenistan },
            { "timezone.excity.Asia/Dhaka", "Daca" },
            { "America/Nipigon", America_Eastern },
            { "Atlantic/Jan_Mayen", Europe_Central },
            { "America/Fortaleza", Brasilia },
            { "America/Hermosillo", Mexico_Pacific },
            { "timezone.excity.America/Fort_Nelson", "Fort Nelson" },
            { "Africa/Maseru", Africa_Southern },
            { "Africa/Kinshasa", Africa_Western },
            { "Asia/Seoul", Korea },
            { "America/Lima", Peru },
            { "Asia/Brunei", Brunei },
            { "America/Santa_Isabel", Mexico_Northwest },
            { "timezone.excity.Asia/Famagusta", "Famagusta" },
            { "America/Cambridge_Bay", America_Mountain },
            { "Asia/Colombo", India },
            { "Indian/Antananarivo", Africa_Eastern },
            { "America/Vancouver", America_Pacific },
            { "timezone.excity.America/Marigot", "Marigot" },
            { "Africa/Blantyre", Africa_Central },
            { "America/Detroit", America_Eastern },
            { "America/Thule", Atlantic },
            { "timezone.excity.Africa/Lubumbashi", "Lubumbashi" },
            { "Asia/Hong_Kong", Hong_Kong },
            { "timezone.excity.Asia/Ulaanbaatar", "Ul\u00e1n Bator" },
            { "timezone.excity.Antarctica/McMurdo", "McMurdo" },
            { "Asia/Sakhalin", Sakhalin },
            { "timezone.excity.Asia/Novosibirsk", "Novosibirsk" },
            { "Africa/Harare", Africa_Central },
            { "timezone.excity.Asia/Srednekolymsk", "Srednekolimsk" },
            { "America/Nome", Alaska },
            { "timezone.excity.Africa/Nairobi", "Nairobi" },
            { "Europe/Tallinn", Europe_Eastern },
            { "Africa/Johannesburg", Africa_Southern },
            { "timezone.excity.Pacific/Fakaofo", "Fakaofo" },
            { "Africa/Bangui", Africa_Western },
            { "Europe/Astrakhan",
                new String[] {
                    "",
                    "",
                    "",
                    "",
                    "",
                    "",
                }
            },
            { "Africa/Juba", Africa_Eastern },
            { "America/Campo_Grande", Amazon },
            { "America/Belem", Brasilia },
            { "timezone.excity.Asia/Tokyo", "Tokio" },
            { "Asia/Saigon", Indochina },
            { "timezone.excity.Africa/Johannesburg", "Johannesburgo" },
            { "Africa/Timbuktu", GMT },
            { "America/Bahia", Brasilia },
            { "America/Goose_Bay", Atlantic },
            { "timezone.excity.Europe/Dublin", "Dubl\u00edn" },
            { "timezone.excity.Antarctica/Casey", "Casey" },
            { "timezone.excity.Atlantic/Cape_Verde", "Cabo Verde" },
            { "timezone.excity.Africa/Maputo", "Maputo" },
            { "timezone.excity.Africa/Luanda", "Luanda" },
            { "timezone.excity.America/Goose_Bay", "Goose Bay" },
            { "timezone.excity.America/Eirunepe", "Eirunep\u00e9" },
            { "timezone.excity.America/Los_Angeles", "Los \u00c1ngeles" },
            { "MST", America_Mountain },
            { "America/Whitehorse", America_Pacific },
            { "timezone.excity.America/Cuiaba", "Cuiab\u00e1" },
            { "Pacific/Noumea", New_Caledonia },
            { "timezone.excity.Atlantic/Azores", "Azores" },
            { "timezone.excity.Australia/Melbourne", "Melbourne" },
            { "America/Montreal", America_Eastern },
            { "timezone.excity.America/Anguilla", "Anguila" },
            { "timezone.excity.Pacific/Honolulu", "Honolul\u00fa" },
            { "Asia/Makassar", Indonesia_Central },
            { "America/Argentina/San_Juan", Argentina },
            { "Asia/Nicosia", Europe_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "timezone.excity.Australia/Brisbane", "Brisbane" },
            { "timezone.excity.Indian/Antananarivo", "Antananarivo" },
            { "SystemV/MST7MDT", America_Mountain },
            { "timezone.excity.America/Manaus", "Manaos" },
            { "timezone.excity.Asia/Vientiane", "Vienti\u00e1n" },
            { "America/Grenada", Atlantic },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Rangoon", Myanmar },
            { "timezone.excity.Indian/Christmas", "Navidad" },
            { "Asia/Calcutta", India },
            { "America/Argentina/Tucuman", Argentina },
            { "Asia/Kabul", Afghanistan },
            { "Indian/Cocos", Cocos },
            { "timezone.excity.Asia/Aqtau", "Aktau" },
            { "timezone.excity.America/Regina", "Regina" },
            { "SystemV/YST9YDT", Alaska },
            { "America/Merida", America_Central },
            { "America/St_Kitts", Atlantic },
            { "timezone.excity.America/Thunder_Bay", "Thunder Bay" },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Caracas", Venezuela },
            { "Asia/Hebron", Europe_Eastern },
            { "SystemV/PST8PDT", America_Pacific },
            { "Africa/Monrovia", GMT },
            { "Asia/Ust-Nera", Vladivostok },
            { "timezone.excity.America/Louisville", "Louisville" },
            { "timezone.excity.America/Cancun", "Canc\u00fan" },
            { "timezone.excity.Australia/Broken_Hill", "Broken Hill" },
            { "timezone.excity.Europe/Kaliningrad", "Kaliningrado" },
            { "America/North_Dakota/New_Salem", America_Central },
            { "timezone.excity.Pacific/Kiritimati", "Kiritimati" },
            { "Australia/Melbourne", Australia_Eastern },
            { "Asia/Irkutsk", Irkutsk },
            { "America/Shiprock", America_Mountain },
            { "timezone.excity.Europe/Tirane", "Tirana" },
            { "timezone.excity.Europe/Prague", "Praga" },
            { "timezone.excity.Pacific/Tarawa", "Tarawa" },
            { "Europe/Vatican", Europe_Central },
            { "timezone.excity.America/Asuncion", "Asunci\u00f3n" },
            { "Asia/Amman", Europe_Eastern },
            { "Etc/UTC",
                new String[] {
                    "tiempo universal coordinado",
                    "UTC",
                    "",
                    "",
                    "",
                    "",
                }
            },
            { "timezone.excity.Europe/Chisinau", "Chisin\u00e1u" },
            { "timezone.excity.America/Moncton", "Moncton" },
            { "Asia/Singapore", Singapore },
            { "timezone.excity.America/Guatemala", "Guatemala" },
            { "SystemV/EST5EDT", America_Eastern },
            { "Pacific/Guadalcanal", Solomon },
            { "Europe/Athens", Europe_Eastern },
            { "timezone.excity.Europe/Vilnius", "Vilna" },
            { "Europe/Monaco", Europe_Central },
            { "timezone.excity.America/Chicago", "Chicago" },
            { "America/Cuiaba", Amazon },
            { "timezone.excity.Europe/San_Marino", "San Marino" },
            { "Africa/Nairobi", Africa_Eastern },
            { "America/Marigot", Atlantic },
            { "timezone.excity.Asia/Irkutsk", "Irkutsk" },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "Africa/Cairo", Europe_Eastern },
            { "Pacific/Pago_Pago", Samoa },
            { "Pacific/Rarotonga", Cook },
            { "America/Guatemala", America_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "timezone.excity.Europe/Skopje", "Skopie" },
            { "timezone.excity.America/Chihuahua", "Chihuahua" },
            { "America/Belize", America_Central },
            { "America/Managua", America_Central },
            { "America/Indiana/Petersburg", America_Eastern },
            { "Asia/Yerevan", Armenia },
            { "Europe/Brussels", Europe_Central },
            { "timezone.excity.Atlantic/Reykjavik", "Reikiavik" },
            { "timezone.excity.Asia/Kamchatka", "Kamchatka" },
            { "Europe/Warsaw", Europe_Central },
            { "Pacific/Yap", Truk },
            { "timezone.excity.Asia/Yakutsk", "Yakutsk" },
            { "timezone.excity.Africa/Djibouti", "Yibuti" },
            { "America/Tegucigalpa", America_Central },
            { "timezone.excity.America/Recife", "Recife" },
            { "timezone.excity.Pacific/Wallis", "Wallis" },
            { "America/Miquelon", Pierre_Miquelon },
            { "timezone.excity.Africa/Porto-Novo", "Portonovo" },
            { "timezone.excity.Antarctica/Palmer", "Palmer" },
            { "timezone.excity.Asia/Tashkent", "Taskent" },
            { "timezone.excity.America/Argentina/San_Juan", "San Juan" },
            { "timezone.excity.Antarctica/Rothera", "Rothera" },
            { "timezone.excity.Asia/Shanghai", "Shangh\u00e1i" },
            { "timezone.excity.America/Juneau", "Juneau" },
            { "timezone.excity.Pacific/Bougainville", "Bougainville" },
            { "timezone.excity.Pacific/Apia", "Apia" },
            { "Asia/Almaty", Kazakhstan_Eastern },
            { "timezone.excity.America/El_Salvador", "El Salvador" },
            { "Asia/Dubai", Gulf },
            { "Europe/Isle_of_Man", GMT },
            { "America/Araguaina", Brasilia },
            { "timezone.excity.Pacific/Easter", "Isla de Pascua" },
            { "Asia/Novosibirsk", Novosibirsk },
            { "Africa/Tunis", Europe_Central },
            { "Pacific/Fakaofo", Tokelau },
            { "Indian/Comoro", Africa_Eastern },
            { "timezone.excity.Pacific/Niue", "Niue" },
            { "timezone.excity.America/Menominee", "Menominee" },
            { "Pacific/Port_Moresby", Papua_New_Guinea },
            { "timezone.excity.Australia/Lord_Howe", "Lord Howe" },
            { "Indian/Reunion", Reunion },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "timezone.excity.Asia/Magadan", "Magad\u00e1n" },
            { "timezone.excity.Pacific/Wake", "Wake" },
            { "timezone.excity.Atlantic/Canary", "Islas Canarias" },
            { "Africa/Mogadishu", Africa_Eastern },
            { "timezone.excity.America/Glace_Bay", "Glace Bay" },
            { "timezone.excity.Africa/Casablanca", "Casablanca" },
            { "Etc/GMT", GMT },
            { "timezone.excity.America/Kralendijk", "Kralendijk" },
            { "America/Manaus", Amazon },
            { "Africa/Freetown", GMT },
            { "Asia/Macau", China },
            { "Europe/Malta", Europe_Central },
            { "timezone.excity.Asia/Yerevan", "Erev\u00e1n" },
            { "timezone.excity.Europe/Kirov", "K\u00edrov" },
            { "timezone.excity.America/Creston", "Creston" },
            { "timezone.excity.Africa/Cairo", "El Cairo" },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "timezone.excity.Europe/Warsaw", "Varsovia" },
            { "Europe/Skopje", Europe_Central },
            { "Europe/Sarajevo", Europe_Central },
            { "America/Cordoba", Argentina },
            { "America/Regina", America_Central },
            { "Africa/Algiers", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "America/Anguilla", Atlantic },
            { "Europe/Saratov",
                new String[] {
                    "",
                    "",
                    "",
                    "",
                    "",
                    "",
                }
            },
            { "Europe/Gibraltar", Europe_Central },
            { "Africa/Conakry", GMT },
            { "America/Havana", Cuba },
            { "timezone.excity.America/Edmonton", "Edmonton" },
            { "timezone.excity.Africa/Sao_Tome", "Santo Tom\u00e9" },
            { "timezone.excity.America/Dawson", "Dawson" },
            { "timezone.excity.Africa/Abidjan", "Abiy\u00e1n" },
            { "America/Barbados", Atlantic },
            { "timezone.excity.America/Guadeloupe", "Guadalupe" },
            { "timezone.excity.Africa/Freetown", "Freetown" },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "timezone.excity.America/Fortaleza", "Fortaleza" },
            { "timezone.excity.Europe/Vatican", "El Vaticano" },
            { "timezone.excity.Asia/Almaty", "Almaty" },
            { "timezone.excity.Asia/Tbilisi", "Tiflis" },
            { "Pacific/Johnston", Hawaii_Aleutian },
            { "Europe/Ljubljana", Europe_Central },
            { "America/Sao_Paulo", Brasilia },
            { "timezone.excity.Europe/Andorra", "Andorra" },
            { "timezone.excity.Europe/Minsk", "Minsk" },
            { "America/Curacao", Atlantic },
            { "timezone.excity.Africa/Monrovia", "Monrovia" },
            { "America/Guayaquil", Ecuador },
            { "timezone.excity.Africa/Mbabane", "Mbabane" },
            { "timezone.excity.America/Rainy_River", "Rainy River" },
            { "timezone.excity.Asia/Beirut", "Beirut" },
            { "Europe/Chisinau", Europe_Eastern },
            { "America/Rankin_Inlet", America_Central },
            { "Australia/Eucla", Australia_CentralWestern },
            { "timezone.excity.Asia/Pontianak", "Pontianak" },
            { "timezone.excity.America/Adak", "Adak" },
            { "Europe/Zagreb", Europe_Central },
            { "timezone.excity.America/Toronto", "Toronto" },
            { "America/Port_of_Spain", Atlantic },
            { "Asia/Beirut", Europe_Eastern },
            { "timezone.excity.Asia/Baghdad", "Bagdad" },
            { "Pacific/Bougainville",
                new String[] {
                    "",
                    "",
                    "",
                    "",
                    "",
                    "",
                }
            },
            { "Africa/Sao_Tome", Africa_Western },
            { "Indian/Chagos", Indian_Ocean },
            { "timezone.excity.America/Metlakatla", "Metlakatla" },
            { "Asia/Yakutsk", Yakutsk },
            { "Pacific/Galapagos", Galapagos },
            { "timezone.excity.America/Maceio", "Macei\u00f3" },
            { "timezone.excity.America/Guayaquil", "Guayaquil" },
            { "Africa/Ndjamena", Africa_Western },
            { "timezone.excity.America/St_Vincent", "San Vicente" },
            { "timezone.excity.America/Panama", "Panam\u00e1" },
            { "timezone.excity.Europe/Simferopol", "Simfer\u00f3pol" },
            { "timezone.excity.Indian/Kerguelen", "Kerguelen" },
            { "timezone.excity.Europe/Volgograd", "Volgogrado" },
            { "timezone.excity.Europe/Monaco", "M\u00f3naco" },
            { "Asia/Tashkent", Uzbekistan },
            { "Africa/Ceuta", Europe_Central },
            { "timezone.excity.America/La_Paz", "La Paz" },
            { "timezone.excity.Africa/Tripoli", "Tr\u00edpoli" },
            { "America/Swift_Current", America_Central },
            { "timezone.excity.Pacific/Enderbury", "Enderbury" },
            { "timezone.excity.Asia/Pyongyang", "Pyongyang" },
            { "timezone.excity.Europe/Bucharest", "Bucarest" },
            { "America/Metlakatla", Alaska },
            { "timezone.excity.Europe/Athens", "Atenas" },
            { "Africa/Djibouti", Africa_Eastern },
            { "EST", America_Eastern },
            { "Europe/Simferopol", Moscow },
            { "Europe/Sofia", Europe_Eastern },
            { "Africa/Nouakchott", GMT },
            { "timezone.excity.America/Porto_Velho", "Porto Velho" },
            { "Europe/Prague", Europe_Central },
            { "timezone.excity.America/Managua", "Managua" },
            { "America/Kralendijk", Atlantic },
            { "Indian/Christmas", Christmas },
            { "America/Inuvik", America_Mountain },
            { "America/Iqaluit", America_Eastern },
            { "Pacific/Funafuti", Tuvalu },
            { "Antarctica/Macquarie", Macquarie },
            { "timezone.excity.America/Montserrat", "Montserrat" },
            { "America/Moncton", Atlantic },
            { "timezone.excity.Europe/Copenhagen", "Copenhague" },
            { "timezone.excity.Australia/Darwin", "Darwin" },
            { "America/St_Vincent", Atlantic },
            { "PST8PDT", America_Pacific },
            { "timezone.excity.Asia/Jerusalem", "Jerusal\u00e9n" },
            { "Atlantic/Faeroe", Europe_Western },
            { "timezone.excity.Asia/Riyadh", "Riad" },
            { "Europe/Copenhagen", Europe_Central },
            { "timezone.excity.Africa/Bangui", "Bangui" },
            { "timezone.excity.Africa/Lusaka", "Lusaka" },
            { "Atlantic/Azores", Azores },
            { "timezone.excity.Asia/Ust-Nera", "Ust-Nera" },
            { "timezone.excity.Asia/Damascus", "Damasco" },
            { "Pacific/Pitcairn", Pitcairn },
            { "timezone.excity.Pacific/Kosrae", "Kosrae" },
            { "America/Mazatlan", Mexico_Pacific },
            { "Pacific/Nauru", Nauru },
            { "timezone.excity.Africa/Brazzaville", "Brazzaville" },
            { "timezone.excity.America/Argentina/Rio_Gallegos", "R\u00edo Gallegos" },
            { "SystemV/MST7", America_Mountain },
            { "America/Dominica", Atlantic },
            { "timezone.excity.America/Bahia", "Bah\u00eda" },
            { "America/Mendoza", Argentina },
            { "timezone.excity.Asia/Tehran", "Teher\u00e1n" },
            { "timezone.excity.Pacific/Tahiti", "Tahit\u00ed" },
            { "timezone.excity.America/St_Kitts", "San Crist\u00f3bal" },
            { "America/Asuncion", Paraguay },
            { "America/Boise", America_Mountain },
            { "Australia/Currie", Australia_Eastern },
            { "timezone.excity.Africa/Dar_es_Salaam", "Dar es Salaam" },
            { "timezone.excity.America/Monterrey", "Monterrey" },
            { "Pacific/Wake", Wake },
            { "timezone.excity.America/Belem", "Bel\u00e9n" },
            { "Asia/Chongqing", China },
            { "America/Indiana/Knox", America_Central },
            { "timezone.excity.Asia/Saigon", "Ciudad Ho Chi Minh" },
            { "America/North_Dakota/Beulah", America_Central },
            { "timezone.excity.Asia/Makassar", "Makasar" },
            { "Pacific/Apia", Apia },
            { "Pacific/Niue", Niue },
            { "timezone.excity.Asia/Yekaterinburg", "Ekaterimburgo" },
            { "timezone.excity.Europe/Sofia", "Sof\u00eda" },
            { "MST7MDT", America_Mountain },
            { "America/Monterrey", America_Central },
            { "America/Nassau", America_Eastern },
            { "timezone.excity.Europe/Astrakhan", "Astrac\u00e1n" },
            { "timezone.excity.America/Yellowknife", "Yellowknife" },
            { "timezone.excity.Europe/Belgrade", "Belgrado" },
            { "timezone.excity.America/Puerto_Rico", "Puerto Rico" },
            { "timezone.excity.America/Denver", "Denver" },
            { "timezone.excity.Asia/Calcutta", "Calcuta" },
            { "Indian/Mahe", Seychelles },
            { "Asia/Aqtobe", Kazakhstan_Western },
            { "timezone.excity.Asia/Gaza", "Gaza" },
            { "timezone.excity.Africa/Ceuta", "Ceuta" },
            { "Africa/Libreville", Africa_Western },
            { "America/Kentucky/Monticello", America_Eastern },
            { "America/Coral_Harbour", America_Eastern },
            { "Pacific/Marquesas", Marquesas },
            { "timezone.excity.Antarctica/Troll", "Troll" },
            { "America/Aruba", Atlantic },
            { "America/North_Dakota/Center", America_Central },
            { "timezone.excity.Asia/Hong_Kong", "Hong Kong" },
            { "timezone.excity.America/Port-au-Prince", "Puerto Pr\u00edncipe" },
            { "America/Tijuana", America_Pacific },
            { "timezone.excity.Australia/Eucla", "Eucla" },
            { "timezone.excity.America/Mexico_City", "Ciudad de M\u00e9xico" },
            { "timezone.excity.Pacific/Kwajalein", "Kwajalein" },
            { "SystemV/YST9", Gambier },
            { "Africa/Douala", Africa_Western },
            { "America/Chihuahua", Mexico_Pacific },
            { "America/Ojinaga", America_Mountain },
            { "Asia/Hovd", Hovd },
            { "timezone.excity.Europe/Lisbon", "Lisboa" },
            { "timezone.excity.Pacific/Gambier", "Gambier" },
            { "timezone.excity.America/Boise", "Boise" },
            { "America/Santiago", Chile },
            { "timezone.excity.Europe/Zaporozhye", "Zaporiyia" },
            { "Asia/Baku", Azerbaijan },
            { "America/Argentina/Ushuaia", Argentina },
            { "Atlantic/Reykjavik", GMT },
            { "Africa/Brazzaville", Africa_Western },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "timezone.excity.America/Dominica", "Dominica" },
            { "Asia/Taipei", Taipei },
            { "Antarctica/South_Pole", New_Zealand },
            { "timezone.excity.Africa/Kampala", "Kampala" },
            { "timezone.excity.Pacific/Chatham", "Chatham" },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "Antarctica/Palmer",
                new String[] {
                    "",
                    "",
                    "",
                    "",
                    "",
                    "",
                }
            },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "timezone.excity.Asia/Colombo", "Colombo" },
            { "timezone.excity.Pacific/Port_Moresby", "Port Moresby" },
            { "America/Creston", America_Mountain },
            { "timezone.excity.America/Mendoza", "Mendoza" },
            { "Asia/Vientiane", Indochina },
            { "timezone.excity.America/Noronha", "Noronha" },
            { "timezone.excity.Asia/Sakhalin", "Sajal\u00edn" },
            { "Pacific/Kiritimati", Line_Islands },
            { "timezone.excity.America/Nipigon", "Nipigon" },
            { "timezone.excity.Europe/Guernsey", "Guernsey" },
            { "timezone.excity.America/Argentina/San_Luis", "San Luis" },
            { "timezone.excity.Europe/Riga", "Riga" },
            { "timezone.excity.America/Araguaina", "Aragua\u00edna" },
            { "Atlantic/South_Georgia", South_Georgia },
            { "Europe/Lisbon", Europe_Western },
            { "Asia/Harbin", China },
            { "Asia/Novokuznetsk", Krasnoyarsk },
            { "timezone.excity.America/Cordoba", "C\u00f3rdoba" },
            { "timezone.excity.America/Cambridge_Bay", "Cambridge Bay" },
            { "CST6CDT", America_Central },
            { "Atlantic/Canary", Europe_Western },
            { "Asia/Kuwait", Arabian },
            { "SystemV/HST10", Hawaii_Aleutian },
            { "Pacific/Efate", Vanuatu },
            { "Africa/Lome", GMT },
            { "America/Bogota", Colombia },
            { "America/Adak", Hawaii_Aleutian },
            { "Pacific/Norfolk", Norfolk },
            { "timezone.excity.America/Campo_Grande", "Campo Grande" },
            { "timezone.excity.Africa/Blantyre", "Blantyre" },
            { "timezone.excity.Europe/Malta", "Malta" },
            { "Pacific/Tarawa", Gilbert_Islands },
            { "timezone.excity.Australia/Sydney", "S\u00eddney" },
            { "timezone.excity.Asia/Qatar", "Catar" },
            { "timezone.excity.America/Sitka", "Sitka" },
            { "SystemV/EST5", America_Eastern },
            { "timezone.excity.Antarctica/Davis", "Davis" },
            { "America/Santo_Domingo", Atlantic },
            { "timezone.excity.America/Aruba", "Aruba" },
            { "timezone.excity.Asia/Qyzylorda", "Kyzylorda" },
            { "America/Glace_Bay", Atlantic },
            { "Asia/Magadan", Magadan },
            { "SystemV/PST8", Pitcairn },
            { "timezone.excity.Indian/Mauritius", "Mauricio" },
            { "America/St_Barthelemy", Atlantic },
            { "timezone.excity.America/Argentina/La_Rioja", "La Rioja" },
            { "Africa/Luanda", Africa_Western },
            { "timezone.excity.Europe/Mariehamn", "Mariehamn" },
            { "timezone.excity.America/St_Johns", "San Juan de Terranova" },
            { "timezone.excity.America/St_Barthelemy", "San Bartolom\u00e9" },
            { "timezone.excity.America/Santiago", "Santiago de Chile" },
            { "Asia/Muscat", Gulf },
            { "Asia/Bahrain", Arabian },
            { "Europe/Vilnius", Europe_Eastern },
            { "timezone.excity.Asia/Oral", "Oral" },
            { "America/Cancun", America_Eastern },
            { "timezone.excity.Asia/Manila", "Manila" },
            { "Pacific/Kosrae", Kosrae },
            { "Australia/Sydney", Australia_Eastern },
            { "timezone.excity.America/Indianapolis", "Indian\u00e1polis" },
            { "America/St_Lucia", Atlantic },
            { "Europe/Madrid", Europe_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Montserrat", Atlantic },
            { "timezone.excity.Asia/Seoul", "Se\u00fal" },
            { "Australia/Brisbane", Australia_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "timezone.excity.Europe/Busingen", "Busingen" },
            { "Europe/Volgograd", Moscow },
            { "America/Lower_Princes", Atlantic },
            { "timezone.excity.Europe/Istanbul", "Estambul" },
            { "America/Rio_Branco", Acre },
            { "timezone.excity.Europe/Sarajevo", "Sarajevo" },
            { "America/Danmarkshavn", GMT },
            { "timezone.excity.Africa/Ndjamena", "Yamena" },
            { "timezone.excity.America/Punta_Arenas", "Punta Arenas" },
            { "timezone.excity.Africa/Kigali", "Kigali" },
            { "timezone.excity.Asia/Vladivostok", "Vladivostok" },
            { "Africa/Lusaka", Africa_Central },
            { "timezone.excity.Africa/Tunis", "T\u00fanez" },
            { "timezone.excity.Asia/Macau", "Macao" },
            { "America/Argentina/La_Rioja", Argentina },
            { "Africa/Dakar", GMT },
            { "SystemV/CST6CDT", America_Central },
            { "America/Tortola", Atlantic },
            { "America/Porto_Velho", Amazon },
            { "America/Scoresbysund", Greenland_Eastern },
            { "Asia/Kamchatka", Kamchatka },
            { "timezone.excity.Asia/Samarkand", "Samarcanda" },
            { "Africa/Khartoum", Africa_Central },
            { "timezone.excity.Australia/Adelaide", "Adelaida" },
            { "timezone.excity.Asia/Singapore", "Singapur" },
            { "Europe/Belgrade", Europe_Central },
            { "timezone.excity.Europe/Vienna", "Viena" },
            { "Africa/Bissau", GMT },
            { "timezone.excity.America/Cayman", "Caim\u00e1n" },
            { "timezone.excity.Europe/Bratislava", "Bratislava" },
            { "Asia/Tehran", Iran },
            { "timezone.excity.America/Barbados", "Barbados" },
            { "timezone.excity.Asia/Nicosia", "Nicosia" },
            { "timezone.excity.Europe/Kiev", "Kiev" },
            { "timezone.excity.Asia/Dili", "Dili" },
            { "timezone.excity.Asia/Omsk", "Omsk" },
            { "timezone.excity.Africa/Bujumbura", "Bujumbura" },
            { "Pacific/Midway", Samoa },
            { "America/Jujuy", Argentina },
            { "timezone.excity.America/Mazatlan", "Mazatl\u00e1n" },
            { "timezone.excity.Asia/Brunei", "Brun\u00e9i" },
            { "timezone.excity.Atlantic/Faeroe", "Islas Feroe" },
            { "timezone.excity.America/Whitehorse", "Whitehorse" },
            { "timezone.excity.Asia/Kuching", "Kuching" },
            { "timezone.excity.America/Halifax", "Halifax" },
            { "timezone.excity.America/Merida", "M\u00e9rida" },
            { "America/Pangnirtung", America_Eastern },
            { "timezone.excity.Pacific/Palau", "Palaos" },
            { "Asia/Katmandu", Nepal },
            { "timezone.excity.Pacific/Auckland", "Auckland" },
            { "Africa/Niamey", Africa_Western },
            { "timezone.excity.Pacific/Norfolk", "Norfolk" },
            { "Asia/Tbilisi", Georgia },
            { "timezone.excity.Asia/Ashgabat", "Asjabad" },
            { "timezone.excity.Pacific/Tongatapu", "Tongatapu" },
            { "timezone.excity.Antarctica/Syowa", "Syowa" },
            { "timezone.excity.America/Jamaica", "Jamaica" },
            { "timezone.excity.America/Hermosillo", "Hermosillo" },
            { "timezone.excity.Pacific/Funafuti", "Funafuti" },
            { "timezone.excity.Europe/Podgorica", "Podgorica" },
            { "timezone.excity.Indian/Reunion", "Reuni\u00f3n" },
            { "timezone.excity.Pacific/Noumea", "Numea" },
            { "timezone.excity.Asia/Aden", "Ad\u00e9n" },
            { "timezone.excity.Europe/Oslo", "Oslo" },
            { "America/Boa_Vista", Amazon },
            { "Asia/Atyrau", Kazakhstan_Western },
            { "Australia/Darwin", Australia_Central },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Asia/Famagusta",
                new String[] {
                    "",
                    "",
                    "",
                    "",
                    "",
                    "",
                }
            },
            { "Europe/Bratislava", Europe_Central },
            { "timezone.excity.Atlantic/Stanley", "Stanley" },
            { "Pacific/Tongatapu", Tonga },
            { "timezone.excity.Asia/Rangoon", "Yang\u00f3n (Rang\u00fan)" },
            { "timezone.excity.Asia/Thimphu", "Timbu" },
            { "Europe/Ulyanovsk",
                new String[] {
                    "",
                    "",
                    "",
                    "",
                    "",
                    "",
                }
            },
            { "timezone.excity.Asia/Dubai", "Dub\u00e1i" },
            { "Arctic/Longyearbyen", Europe_Central },
            { "timezone.excity.Asia/Kuala_Lumpur", "Kuala Lumpur" },
            { "America/Guadeloupe", Atlantic },
            { "Indian/Kerguelen", French_Southern },
            { "timezone.excity.Africa/Ouagadougou", "Uagadug\u00fa" },
            { "timezone.excity.Africa/Gaborone", "Gaborone" },
            { "Asia/Srednekolymsk",
                new String[] {
                    "",
                    "",
                    "",
                    "",
                    "",
                    "",
                }
            },
            { "Asia/Anadyr", Anadyr },
            { "timezone.excity.Indian/Chagos", "Chagos" },
            { "timezone.excity.Asia/Kabul", "Kabul" },
            { "timezone.excity.America/Iqaluit", "Iqaluit" },
            { "America/Winnipeg", America_Central },
            { "timezone.excity.Europe/Amsterdam", "\u00c1msterdam" },
            { "timezone.excity.Atlantic/Bermuda", "Bermudas" },
            { "timezone.excity.Pacific/Saipan", "Saip\u00e1n" },
            { "timezone.excity.Indian/Cocos", "Cocos" },
            { "timezone.excity.Australia/Currie", "Currie" },
            { "SystemV/AST4ADT", Atlantic },
            { "timezone.excity.Asia/Amman", "Amm\u00e1n" },
            { "America/Toronto", America_Eastern },
            { "timezone.excity.Europe/Brussels", "Bruselas" },
            { "Australia/Lindeman", Australia_Eastern },
            { "timezone.excity.Atlantic/Madeira", "Madeira" },
            { "timezone.excity.Indian/Comoro", "Comoras" },
            { "timezone.excity.America/Boa_Vista", "Boa Vista" },
            { "Pacific/Majuro", Marshall_Islands },
            { "timezone.excity.Europe/Stockholm", "Estocolmo" },
            { "timezone.excity.Europe/Samara", "Samara" },
            { "timezone.excity.America/Tijuana", "Tijuana" },
            { "timezone.excity.Indian/Maldives", "Maldivas" },
        };
        return data;
    }
}
