/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.internal.gtk.OS;

public class URLTransfer
extends ByteArrayTransfer {
    static URLTransfer _instance = new URLTransfer();
    private static final String TEXT_UNICODE = "text/unicode";
    private static final String TEXT_XMOZURL = "text/x-moz-url";
    private static final int TEXT_UNICODE_ID = URLTransfer.registerType("text/unicode");
    private static final int TEXT_XMOZURL_ID = URLTransfer.registerType("text/x-moz-url");

    private URLTransfer() {
    }

    public static URLTransfer getInstance() {
        return _instance;
    }

    @Override
    public void javaToNative(Object object, TransferData transferData) {
        transferData.result = 0;
        if (!this.checkURL(object) || !this.isSupportedType(transferData)) {
            DND.error(2003);
        }
        String string = (String)object;
        int n = string.length();
        char[] cArray = new char[n + 1];
        string.getChars(0, n, cArray, 0);
        int n2 = cArray.length * 2;
        long l = OS.g_malloc(n2);
        if (l == 0L) {
            return;
        }
        OS.memmove(l, cArray, (long)n2);
        transferData.length = n2;
        transferData.format = 8;
        transferData.pValue = l;
        transferData.result = 1;
    }

    @Override
    public Object nativeToJava(TransferData transferData) {
        if (!this.isSupportedType(transferData) || transferData.pValue == 0L) {
            return null;
        }
        int n = transferData.format * transferData.length / 8 / 2 * 2;
        if (n <= 0) {
            return null;
        }
        char[] cArray = new char[n / 2];
        OS.memmove(cArray, transferData.pValue, (long)n);
        String string = new String(cArray);
        int n2 = string.indexOf(0);
        return n2 == -1 ? string : string.substring(0, n2);
    }

    @Override
    protected int[] getTypeIds() {
        return new int[]{TEXT_XMOZURL_ID, TEXT_UNICODE_ID};
    }

    @Override
    protected String[] getTypeNames() {
        return new String[]{TEXT_XMOZURL, TEXT_UNICODE};
    }

    boolean checkURL(Object object) {
        return object != null && object instanceof String && ((String)object).length() > 0;
    }

    @Override
    protected boolean validate(Object object) {
        return this.checkURL(object);
    }
}

