/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.opengl;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.internal.gtk.GdkWindowAttr;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.internal.opengl.glx.GLX;
import org.eclipse.swt.internal.opengl.glx.XVisualInfo;
import org.eclipse.swt.opengl.GLData;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class GLCanvas
extends Canvas {
    long context;
    long xWindow;
    long glWindow;
    XVisualInfo vinfo;
    static final int MAX_ATTRIBUTES = 32;

    public GLCanvas(Composite composite, int n, GLData gLData) {
        super(composite, n);
        if (gLData == null) {
            SWT.error(4);
        }
        int[] nArray = new int[32];
        int n2 = 0;
        nArray[n2++] = 4;
        if (gLData.doubleBuffer) {
            nArray[n2++] = 5;
        }
        if (gLData.stereo) {
            nArray[n2++] = 6;
        }
        if (gLData.redSize > 0) {
            nArray[n2++] = 8;
            nArray[n2++] = gLData.redSize;
        }
        if (gLData.greenSize > 0) {
            nArray[n2++] = 9;
            nArray[n2++] = gLData.greenSize;
        }
        if (gLData.blueSize > 0) {
            nArray[n2++] = 10;
            nArray[n2++] = gLData.blueSize;
        }
        if (gLData.alphaSize > 0) {
            nArray[n2++] = 11;
            nArray[n2++] = gLData.alphaSize;
        }
        if (gLData.depthSize > 0) {
            nArray[n2++] = 12;
            nArray[n2++] = gLData.depthSize;
        }
        if (gLData.stencilSize > 0) {
            nArray[n2++] = 13;
            nArray[n2++] = gLData.stencilSize;
        }
        if (gLData.accumRedSize > 0) {
            nArray[n2++] = 14;
            nArray[n2++] = gLData.accumRedSize;
        }
        if (gLData.accumGreenSize > 0) {
            nArray[n2++] = 15;
            nArray[n2++] = gLData.accumGreenSize;
        }
        if (gLData.accumBlueSize > 0) {
            nArray[n2++] = 16;
            nArray[n2++] = gLData.accumBlueSize;
        }
        if (gLData.accumAlphaSize > 0) {
            nArray[n2++] = 17;
            nArray[n2++] = gLData.accumAlphaSize;
        }
        if (gLData.sampleBuffers > 0) {
            nArray[n2++] = 100000;
            nArray[n2++] = gLData.sampleBuffers;
        }
        if (gLData.samples > 0) {
            nArray[n2++] = 100001;
            nArray[n2++] = gLData.samples;
        }
        nArray[n2++] = 0;
        OS.gtk_widget_realize(this.handle);
        long l = OS.gtk_widget_get_window(this.handle);
        long l2 = OS.GTK_VERSION >= OS.VERSION(2, 24, 0) ? OS.gdk_x11_display_get_xdisplay(OS.gdk_window_get_display(l)) : OS.gdk_x11_drawable_get_xdisplay(l);
        long l3 = GLX.glXChooseVisual(l2, OS.XDefaultScreen(l2), nArray);
        if (l3 == 0L) {
            this.dispose();
            SWT.error(38);
        }
        this.vinfo = new XVisualInfo();
        GLX.memmove(this.vinfo, l3, XVisualInfo.sizeof);
        OS.XFree(l3);
        long l4 = OS.gdk_screen_get_default();
        long l5 = OS.gdk_x11_screen_lookup_visual(l4, this.vinfo.visualid);
        long l6 = gLData.shareContext != null ? gLData.shareContext.context : 0L;
        this.context = GLX.glXCreateContext(l2, this.vinfo, l6, true);
        if (this.context == 0L) {
            SWT.error(2);
        }
        GdkWindowAttr gdkWindowAttr = new GdkWindowAttr();
        gdkWindowAttr.width = 1;
        gdkWindowAttr.height = 1;
        gdkWindowAttr.event_mask = 32526;
        gdkWindowAttr.window_type = 2;
        gdkWindowAttr.visual = l5;
        this.glWindow = OS.gdk_window_new(l, gdkWindowAttr, 64);
        OS.gdk_window_set_user_data(this.glWindow, this.handle);
        if ((n & 0x40000) != 0) {
            OS.gdk_window_set_back_pixmap(l, 0L, false);
        }
        this.xWindow = OS.GTK3 ? OS.gdk_x11_window_get_xid(this.glWindow) : OS.gdk_x11_drawable_get_xid(this.glWindow);
        OS.gdk_window_show(this.glWindow);
        Listener listener = new Listener(){

            @Override
            public void handleEvent(Event event) {
                switch (event.type) {
                    case 9: {
                        int[] nArray = new int[4];
                        GLX.glGetIntegerv(2978, nArray);
                        GLX.glViewport(nArray[0], nArray[1], nArray[2], nArray[3]);
                        break;
                    }
                    case 11: {
                        Rectangle rectangle = DPIUtil.autoScaleUp(GLCanvas.this.getClientArea());
                        OS.gdk_window_move(GLCanvas.this.glWindow, rectangle.x, rectangle.y);
                        OS.gdk_window_resize(GLCanvas.this.glWindow, rectangle.width, rectangle.height);
                        break;
                    }
                    case 12: {
                        long l = OS.gtk_widget_get_window(GLCanvas.this.handle);
                        long l2 = GLCanvas.this.gdk_x11_display_get_xdisplay(l);
                        if (GLCanvas.this.context != 0L) {
                            if (GLX.glXGetCurrentContext() == GLCanvas.this.context) {
                                GLX.glXMakeCurrent(l2, 0L, 0L);
                            }
                            GLX.glXDestroyContext(l2, GLCanvas.this.context);
                            GLCanvas.this.context = 0L;
                        }
                        if (GLCanvas.this.glWindow == 0L) break;
                        OS.gdk_window_destroy(GLCanvas.this.glWindow);
                        GLCanvas.this.glWindow = 0L;
                    }
                }
            }
        };
        this.addListener(11, listener);
        this.addListener(9, listener);
        this.addListener(12, listener);
    }

    public GLData getGLData() {
        this.checkWidget();
        long l = OS.gtk_widget_get_window(this.handle);
        long l2 = this.gdk_x11_display_get_xdisplay(l);
        GLData gLData = new GLData();
        int[] nArray = new int[1];
        GLX.glXGetConfig(l2, this.vinfo, 5, nArray);
        gLData.doubleBuffer = nArray[0] != 0;
        GLX.glXGetConfig(l2, this.vinfo, 6, nArray);
        gLData.stereo = nArray[0] != 0;
        GLX.glXGetConfig(l2, this.vinfo, 8, nArray);
        gLData.redSize = nArray[0];
        GLX.glXGetConfig(l2, this.vinfo, 9, nArray);
        gLData.greenSize = nArray[0];
        GLX.glXGetConfig(l2, this.vinfo, 10, nArray);
        gLData.blueSize = nArray[0];
        GLX.glXGetConfig(l2, this.vinfo, 11, nArray);
        gLData.alphaSize = nArray[0];
        GLX.glXGetConfig(l2, this.vinfo, 12, nArray);
        gLData.depthSize = nArray[0];
        GLX.glXGetConfig(l2, this.vinfo, 13, nArray);
        gLData.stencilSize = nArray[0];
        GLX.glXGetConfig(l2, this.vinfo, 14, nArray);
        gLData.accumRedSize = nArray[0];
        GLX.glXGetConfig(l2, this.vinfo, 15, nArray);
        gLData.accumGreenSize = nArray[0];
        GLX.glXGetConfig(l2, this.vinfo, 16, nArray);
        gLData.accumBlueSize = nArray[0];
        GLX.glXGetConfig(l2, this.vinfo, 17, nArray);
        gLData.accumAlphaSize = nArray[0];
        GLX.glXGetConfig(l2, this.vinfo, 100000, nArray);
        gLData.sampleBuffers = nArray[0];
        GLX.glXGetConfig(l2, this.vinfo, 100001, nArray);
        gLData.samples = nArray[0];
        return gLData;
    }

    public boolean isCurrent() {
        this.checkWidget();
        return GLX.glXGetCurrentContext() == this.context;
    }

    public void setCurrent() {
        this.checkWidget();
        if (GLX.glXGetCurrentContext() == this.context) {
            return;
        }
        long l = OS.gtk_widget_get_window(this.handle);
        long l2 = this.gdk_x11_display_get_xdisplay(l);
        GLX.glXMakeCurrent(l2, this.xWindow, this.context);
    }

    public void swapBuffers() {
        this.checkWidget();
        long l = OS.gtk_widget_get_window(this.handle);
        long l2 = this.gdk_x11_display_get_xdisplay(l);
        GLX.glXSwapBuffers(l2, this.xWindow);
    }

    private long gdk_x11_display_get_xdisplay(long l) {
        long l2 = OS.GTK_VERSION >= OS.VERSION(2, 24, 0) ? OS.gdk_x11_display_get_xdisplay(OS.gdk_window_get_display(l)) : OS.gdk_x11_drawable_get_xdisplay(l);
        return l2;
    }
}

