
if (CMAKE_VERSION VERSION_LESS 2.8.3)
    message(FATAL_ERROR "Qt5GSettings requires at least CMake version 2.8.3")
endif()

get_filename_component(_Qt5GSettings_Qt5GSettings_install_prefix "/build/qt5-gsettings/src/qtgsettings-1.2.0/build/default/install-root" ABSOLUTE)

# For backwards compatibility only. Use Qt5GSettings_VERSION instead.
set(Qt5GSettings_VERSION_STRING "1.2.0")

set(Qt5GSettings_LIBRARIES Qt5GSettings::Qt5GSettings)

macro(_Qt5GSettings_Qt5GSettings_check_file_exists file)
    if(NOT EXISTS "${file}" )
        message(FATAL_ERROR "The imported target \"Qt5GSettings::Qt5GSettings\" references the file
   \"${file}\"
but this file does not exist.  Possible reasons include:
* The file was deleted, renamed, or moved to another location.
* An install or uninstall procedure did not complete successfully.
* The installation package was faulty and contained
   \"${CMAKE_CURRENT_LIST_FILE}\"
but not all the files it references.
")
    endif()
endmacro()

macro(_populate_target_properties Configuration LIB_LOCATION IMPLIB_LOCATION)
    set_property(TARGET Qt5GSettings::Qt5GSettings APPEND PROPERTY IMPORTED_CONFIGURATIONS ${Configuration})

    set(imported_location "${_Qt5GSettings_Qt5GSettings_install_prefix}//usr//usr/lib")
    _Qt5GSettings_Qt5GSettings_check_file_exists(${imported_location})
    set_target_properties(Qt5GSettings::Qt5GSettings PROPERTIES
        "INTERFACE_LINK_LIBRARIES" "${_Qt5GSettings_LIB_DEPENDENCIES}"
        "IMPORTED_LOCATION_${Configuration}" ${imported_location}
        "IMPORTED_SONAME_${Configuration}" "libQt5GSettings.so.1.0.0"
        # For backward compatibility with CMake < 2.8.12
        "IMPORTED_LINK_INTERFACE_LIBRARIES_${Configuration}" "${_Qt5GSettings_LIB_DEPENDENCIES}"
    )
endmacro()

include(CMakeFindDependencyMacro)
find_dependency(Qt5Core "5.8.0")


if (NOT TARGET Qt5GSettings::Qt5GSettings)
    set(_Qt5GSettings_OWN_INCLUDE_DIRS "${_Qt5GSettings_Qt5GSettings_install_prefix}/include" "${_Qt5GSettings_Qt5GSettings_install_prefix}/include/Qt5GSettings")
    set(Qt5GSettings_PRIVATE_INCLUDE_DIRS
        "${_Qt5GSettings_Qt5GSettings_install_prefix}/include/Qt5GSettings/1.2.0"
        "${_Qt5GSettings_Qt5GSettings_install_prefix}/include/Qt5GSettings/1.2.0/Qt5GSettings")

    foreach(_dir ${_Qt5GSettings_OWN_INCLUDE_DIRS})
        _Qt5GSettings_Qt5GSettings_check_file_exists(${_dir})
    endforeach()

    # Only check existence of private includes if the Private component is
    # specified.
    list(FIND Qt5GSettings_FIND_COMPONENTS Private _check_private)
    if (NOT _check_private STREQUAL -1)
        foreach(_dir ${Qt5GSettings_PRIVATE_INCLUDE_DIRS})
            _Qt5GSettings_Qt5GSettings_check_file_exists(${_dir})
        endforeach()
    endif()

    set(Qt5GSettings_INCLUDE_DIRS ${_Qt5GSettings_OWN_INCLUDE_DIRS})
    set(Qt5GSettings_OWN_PRIVATE_INCLUDE_DIRS ${Qt5GSettings_PRIVATE_INCLUDE_DIRS})
    set(Qt5GSettings_DEFINITIONS "")
    set(Qt5GSettings_COMPILE_DEFINITIONS "")
    set(Qt5GSettings_EXECUTABLE_COMPILE_FLAGS "")

    add_library(Qt5GSettings::Qt5GSettings SHARED IMPORTED)

    set_property(TARGET Qt5GSettings::Qt5GSettings PROPERTY
      INTERFACE_INCLUDE_DIRECTORIES ${_Qt5GSettings_OWN_INCLUDE_DIRS})
    set_property(TARGET Qt5GSettings::Qt5GSettings PROPERTY
      INTERFACE_LINK_LIBRARIES "Qt5::Core")

    set(_Qt5GSettings_PRIVATE_DIRS_EXIST TRUE)
    foreach (_Qt5GSettings_PRIVATE_DIR ${Qt5GSettings_OWN_PRIVATE_INCLUDE_DIRS})
        if (NOT EXISTS ${_Qt5GSettings_PRIVATE_DIR})
            set(_Qt5GSettings_PRIVATE_DIRS_EXIST FALSE)
        endif()
    endforeach()

    if (_Qt5GSettings_PRIVATE_DIRS_EXIST)
        add_library(Qt5GSettings::Qt5GSettingsPrivate INTERFACE IMPORTED)
        set_property(TARGET Qt5GSettings::Qt5GSettingsPrivate PROPERTY
            INTERFACE_INCLUDE_DIRECTORIES ${Qt5GSettings_OWN_PRIVATE_INCLUDE_DIRS}
        )
        set(_Qt5GSettings_PRIVATEDEPS)
        foreach(dep ${_Qt5GSettings_LIB_DEPENDENCIES})
            if (TARGET ${dep}Private)
                list(APPEND _Qt5GSettings_PRIVATEDEPS ${dep}Private)
            endif()
        endforeach()
        set_property(TARGET Qt5GSettings::Qt5GSettingsPrivate PROPERTY
            INTERFACE_LINK_LIBRARIES Qt5GSettings::Qt5GSettings ${_Qt5GSettings_PRIVATEDEPS}
        )
    endif()

    _populate_target_properties(DEBUG "libQt5GSettings.so.1.0.0" "" )

    _Qt5GSettings_Qt5GSettings_check_file_exists("${CMAKE_CURRENT_LIST_DIR}/Qt5GSettingsConfigVersion.cmake")
endif()
