/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.visualvm.profiling.presets;

import java.util.regex.Pattern;
import org.netbeans.lib.profiler.filters.GenericFilter;

final class PresetsUtils {
    private static Pattern JAVA_IDENTIFIER_PATTERN;

    PresetsUtils() {
    }

    static String normalizeValue(String value) {
        String[] values = value.split("\\n");
        StringBuilder normalizedValue = new StringBuilder();
        for (int i = 0; i < values.length; ++i) {
            String filterValue = values[i].trim();
            if (i != values.length - 1 && !filterValue.endsWith(",")) {
                filterValue = filterValue + ",";
            }
            normalizedValue.append(filterValue);
        }
        return normalizedValue.toString();
    }

    static boolean isValidJavaValue(String normalizedValue, boolean allowEmpty, boolean acceptArrays) {
        String[] values;
        if (normalizedValue.isEmpty()) {
            return allowEmpty;
        }
        for (String value : values = GenericFilter.values((String)normalizedValue)) {
            boolean hadWildcard = value.endsWith("*");
            if (hadWildcard) {
                value = value.substring(0, value.length() - 1);
            }
            if (value.endsWith("*")) {
                value = value.substring(0, value.length() - 1);
            }
            if (hadWildcard) {
                if (!value.isEmpty() && !value.endsWith(".")) {
                    return false;
                }
            } else if (acceptArrays) {
                int len = value.length();
                while (value.endsWith("[]")) {
                    value = value.substring(0, value.length() - 2);
                }
                if (len - value.length() > 2 && value.isEmpty()) {
                    return false;
                }
            }
            if (value.isEmpty()) continue;
            if (value.endsWith(".")) {
                if (!hadWildcard) {
                    return false;
                }
                value = value.substring(0, value.length() - 1);
            }
            if (PresetsUtils.isValidJavaIdentifier(value)) continue;
            return false;
        }
        return true;
    }

    private static boolean isValidJavaIdentifier(String identifier) {
        if (JAVA_IDENTIFIER_PATTERN == null) {
            String ID_PATTERN = "\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*";
            JAVA_IDENTIFIER_PATTERN = Pattern.compile(ID_PATTERN + "(\\." + ID_PATTERN + ")*");
        }
        return JAVA_IDENTIFIER_PATTERN.matcher(identifier).matches();
    }
}

