/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.openssl.util;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Security;
import java.util.Map;
import org.jruby.ext.openssl.OpenSSL;

public final class CryptoSecurity {
    private CryptoSecurity() {
    }

    public static void disableJceRestrictions() {
        CryptoSecurity.unrestrictSecurity();
        CryptoSecurity.setAllPermissionPolicy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Boolean setAllPermissionPolicy() {
        if (!OpenSSL.javaHotSpot()) {
            return false;
        }
        try {
            Class<?> JceSecurity = Class.forName("javax.crypto.JceSecurity");
            Class<?> CryptoPermissions = Class.forName("javax.crypto.CryptoPermissions");
            Class<?> CryptoAllPermission = Class.forName("javax.crypto.CryptoAllPermission");
            Field defaultPolicy = JceSecurity.getDeclaredField("defaultPolicy");
            defaultPolicy.setAccessible(true);
            Field perms = CryptoPermissions.getDeclaredField("perms");
            perms.setAccessible(true);
            Field INSTANCE = CryptoAllPermission.getDeclaredField("INSTANCE");
            INSTANCE.setAccessible(true);
            Class<Security> clazz = Security.class;
            synchronized (Security.class) {
                PermissionCollection defPolicy = (PermissionCollection)defaultPolicy.get(null);
                Map permsMap = (Map)perms.get(defPolicy);
                if (!permsMap.isEmpty()) {
                    permsMap.clear();
                    defPolicy.add((Permission)INSTANCE.get(null));
                    // ** MonitorExit[var6_8] (shouldn't be in output)
                    return true;
                }
                // ** MonitorExit[var6_8] (shouldn't be in output)
                return false;
            }
        }
        catch (ClassNotFoundException e) {
            OpenSSL.debug("unable un-restrict jce security: ", e);
            return null;
        }
        catch (Exception e) {
            OpenSSL.debug("unable un-restrict jce security: ");
            OpenSSL.debugStackTrace(e);
            return null;
        }
    }

    public static Boolean unrestrictSecurity() {
        if (!OpenSSL.javaHotSpot()) {
            return false;
        }
        if (OpenSSL.javaVersion9(true)) {
            return CryptoSecurity.unrestrictJceSecurity9();
        }
        return CryptoSecurity.unrestrictJceSecurity8();
    }

    static Boolean unrestrictJceSecurity9() {
        try {
            if (Security.getProperty("crypto.policy") == null) {
                Security.setProperty("crypto.policy", "unlimited");
                return true;
            }
            return false;
        }
        catch (Exception e) {
            OpenSSL.debug("unable un-restrict jce security: ", e);
            return null;
        }
    }

    static Boolean unrestrictJceSecurity8() {
        try {
            Class<?> JceSecurity = Class.forName("javax.crypto.JceSecurity");
            Field isRestricted = JceSecurity.getDeclaredField("isRestricted");
            if (Modifier.isFinal(isRestricted.getModifiers())) {
                Field modifiers = Field.class.getDeclaredField("modifiers");
                modifiers.setAccessible(true);
                modifiers.setInt(isRestricted, isRestricted.getModifiers() & 0xFFFFFFEF);
            }
            isRestricted.setAccessible(true);
            if (!isRestricted.getBoolean(null)) {
                isRestricted.setBoolean(null, false);
                return true;
            }
            return false;
        }
        catch (ClassNotFoundException e) {
            OpenSSL.debug("unable un-restrict jce security: ", e);
            return null;
        }
        catch (Exception e) {
            OpenSSL.debug("unable un-restrict jce security: ");
            OpenSSL.debugStackTrace(e);
            return null;
        }
    }
}

