/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.internal.runtime.methods;

import java.lang.invoke.MethodHandle;
import org.jruby.RubyModule;
import org.jruby.internal.runtime.AbstractIRMethod;
import org.jruby.ir.IRMethod;
import org.jruby.ir.IRScope;
import org.jruby.ir.interpreter.InterpreterContext;
import org.jruby.runtime.ArgumentDescriptor;
import org.jruby.runtime.Block;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

public class CompiledIRMethod
extends AbstractIRMethod {
    private final MethodHandle variable;
    private final MethodHandle specific;
    private final int specificArity;

    public CompiledIRMethod(MethodHandle variable, IRScope method2, Visibility visibility, RubyModule implementationClass) {
        this(variable, null, -1, method2, visibility, implementationClass);
    }

    public CompiledIRMethod(MethodHandle variable, MethodHandle specific, int specificArity, IRScope method2, Visibility visibility, RubyModule implementationClass) {
        super(method2, visibility, implementationClass);
        this.variable = variable;
        this.specific = specific;
        this.specificArity = method2.receivesKeywordArgs() ? -1 : specificArity;
        this.method.getStaticScope().determineModule();
        assert (method2.hasExplicitCallProtocol());
        this.setHandle(variable);
    }

    public MethodHandle getHandleFor(int arity2) {
        if (this.specificArity != -1 && arity2 == this.specificArity) {
            return this.specific;
        }
        return null;
    }

    @Override
    public ArgumentDescriptor[] getArgumentDescriptors() {
        return ((IRMethod)this.method).getArgumentDescriptors();
    }

    @Override
    public InterpreterContext ensureInstrsReady() {
        if (this.method instanceof IRMethod) {
            return ((IRMethod)this.method).lazilyAcquireInterpreterContext();
        }
        InterpreterContext ic = this.method.getInterpreterContext();
        return ic;
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, IRubyObject[] args2, Block block) {
        try {
            return this.variable.invokeExact(context, this.staticScope, self2, args2, block, this.implementationClass.getMethodLocation(), name2);
        }
        catch (Throwable t) {
            Helpers.throwException(t);
            return null;
        }
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, Block block) {
        if (this.specificArity != 0) {
            return this.call(context, self2, clazz, name2, IRubyObject.NULL_ARRAY, block);
        }
        try {
            return this.specific.invokeExact(context, this.staticScope, self2, block, this.implementationClass.getMethodLocation(), name2);
        }
        catch (Throwable t) {
            Helpers.throwException(t);
            return null;
        }
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, IRubyObject arg0, Block block) {
        if (this.specificArity != 1) {
            return this.call(context, self2, clazz, name2, new IRubyObject[]{arg0}, block);
        }
        try {
            return this.specific.invokeExact(context, this.staticScope, self2, arg0, block, this.implementationClass.getMethodLocation(), name2);
        }
        catch (Throwable t) {
            Helpers.throwException(t);
            return null;
        }
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, IRubyObject arg0, IRubyObject arg1, Block block) {
        if (this.specificArity != 2) {
            return this.call(context, self2, clazz, name2, new IRubyObject[]{arg0, arg1}, block);
        }
        try {
            return this.specific.invokeExact(context, this.staticScope, self2, arg0, arg1, block, this.implementationClass.getMethodLocation(), name2);
        }
        catch (Throwable t) {
            Helpers.throwException(t);
            return null;
        }
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, Block block) {
        if (this.specificArity != 3) {
            return this.call(context, self2, clazz, name2, new IRubyObject[]{arg0, arg1, arg2}, block);
        }
        try {
            return this.specific.invokeExact(context, this.staticScope, self2, arg0, arg1, arg2, block, this.implementationClass.getMethodLocation(), name2);
        }
        catch (Throwable t) {
            Helpers.throwException(t);
            return null;
        }
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, IRubyObject[] args2) {
        try {
            return this.variable.invokeExact(context, this.staticScope, self2, args2, Block.NULL_BLOCK, this.implementationClass.getMethodLocation(), name2);
        }
        catch (Throwable t) {
            Helpers.throwException(t);
            return null;
        }
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2) {
        if (this.specificArity != 0) {
            return this.call(context, self2, clazz, name2, IRubyObject.NULL_ARRAY, Block.NULL_BLOCK);
        }
        try {
            return this.specific.invokeExact(context, this.staticScope, self2, Block.NULL_BLOCK, this.implementationClass.getMethodLocation(), name2);
        }
        catch (Throwable t) {
            Helpers.throwException(t);
            return null;
        }
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, IRubyObject arg0) {
        if (this.specificArity != 1) {
            return this.call(context, self2, clazz, name2, new IRubyObject[]{arg0}, Block.NULL_BLOCK);
        }
        try {
            return this.specific.invokeExact(context, this.staticScope, self2, arg0, Block.NULL_BLOCK, this.implementationClass.getMethodLocation(), name2);
        }
        catch (Throwable t) {
            Helpers.throwException(t);
            return null;
        }
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, IRubyObject arg0, IRubyObject arg1) {
        if (this.specificArity != 2) {
            return this.call(context, self2, clazz, name2, new IRubyObject[]{arg0, arg1}, Block.NULL_BLOCK);
        }
        try {
            return this.specific.invokeExact(context, this.staticScope, self2, arg0, arg1, Block.NULL_BLOCK, this.implementationClass.getMethodLocation(), name2);
        }
        catch (Throwable t) {
            Helpers.throwException(t);
            return null;
        }
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2) {
        if (this.specificArity != 3) {
            return this.call(context, self2, clazz, name2, new IRubyObject[]{arg0, arg1, arg2}, Block.NULL_BLOCK);
        }
        try {
            return this.specific.invokeExact(context, this.staticScope, self2, arg0, arg1, arg2, Block.NULL_BLOCK, this.implementationClass.getMethodLocation(), name2);
        }
        catch (Throwable t) {
            Helpers.throwException(t);
            return null;
        }
    }

    @Override
    public String getFile() {
        return this.method.getFile();
    }

    @Override
    public int getLine() {
        return this.method.getLine();
    }

    public String toString() {
        return this.getClass().getName() + '@' + Integer.toHexString(this.hashCode()) + ' ' + this.method + ' ' + this.getSignature();
    }
}

