/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.targets;

import com.headius.invokebinder.Signature;
import java.math.BigInteger;
import org.jcodings.Encoding;
import org.jruby.Ruby;
import org.jruby.RubyBignum;
import org.jruby.RubyClass;
import org.jruby.RubyEncoding;
import org.jruby.RubyHash;
import org.jruby.RubyRegexp;
import org.jruby.RubyString;
import org.jruby.compiler.NotCompilableException;
import org.jruby.compiler.impl.SkinnyMethodAdapter;
import org.jruby.ir.IRScope;
import org.jruby.ir.instructions.CallBase;
import org.jruby.ir.runtime.IRRuntimeHelpers;
import org.jruby.ir.targets.ArrayDerefInvokeSite;
import org.jruby.ir.targets.BignumObjectSite;
import org.jruby.ir.targets.Bootstrap;
import org.jruby.ir.targets.ClassData;
import org.jruby.ir.targets.DRegexpObjectSite;
import org.jruby.ir.targets.FixnumObjectSite;
import org.jruby.ir.targets.FloatObjectSite;
import org.jruby.ir.targets.IRBytecodeAdapter;
import org.jruby.ir.targets.IRBytecodeAdapter6;
import org.jruby.ir.targets.JVM;
import org.jruby.ir.targets.NormalInvokeSite;
import org.jruby.ir.targets.RegexpObjectSite;
import org.jruby.ir.targets.SelfInvokeSite;
import org.jruby.ir.targets.SymbolObjectSite;
import org.jruby.org.objectweb.asm.Handle;
import org.jruby.org.objectweb.asm.Label;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallType;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.MethodIndex;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.invokedynamic.VariableSite;
import org.jruby.util.ByteList;
import org.jruby.util.CodegenUtils;
import org.jruby.util.JavaNameMangler;
import org.jruby.util.RegexpOptions;

public class IRBytecodeAdapter7
extends IRBytecodeAdapter6 {
    public IRBytecodeAdapter7(SkinnyMethodAdapter adapter, Signature signature, ClassData classData) {
        super(adapter, signature, classData);
    }

    @Override
    public void pushFixnum(long l) {
        this.loadContext();
        this.adapter.invokedynamic("fixnum", CodegenUtils.sig(JVM.OBJECT, ThreadContext.class), FixnumObjectSite.BOOTSTRAP, l);
    }

    @Override
    public void pushFloat(double d) {
        this.loadContext();
        this.adapter.invokedynamic("flote", CodegenUtils.sig(JVM.OBJECT, ThreadContext.class), FloatObjectSite.BOOTSTRAP, d);
    }

    @Override
    public void pushString(ByteList bl, int cr) {
        this.loadContext();
        this.adapter.invokedynamic("string", CodegenUtils.sig(RubyString.class, ThreadContext.class), Bootstrap.string(), new String(bl.bytes(), RubyEncoding.ISO), bl.getEncoding().toString(), cr);
    }

    @Override
    public void pushFrozenString(ByteList bl, int cr, String file2, int line) {
        this.loadContext();
        this.adapter.invokedynamic("frozen", CodegenUtils.sig(RubyString.class, ThreadContext.class), Bootstrap.fstring(), new String(bl.bytes(), RubyEncoding.ISO), bl.getEncoding().toString(), cr, file2, line);
    }

    @Override
    public void pushByteList(ByteList bl) {
        this.adapter.invokedynamic("bytelist", CodegenUtils.sig(ByteList.class, new Class[0]), Bootstrap.bytelist(), new String(bl.bytes(), RubyEncoding.ISO), bl.getEncoding().toString());
    }

    @Override
    public void pushRegexp(ByteList source2, int options2) {
        this.loadContext();
        this.pushByteList(source2);
        this.adapter.invokedynamic("regexp", CodegenUtils.sig(RubyRegexp.class, ThreadContext.class, ByteList.class), RegexpObjectSite.BOOTSTRAP, options2);
    }

    @Override
    public void pushDRegexp(Runnable callback, RegexpOptions options2, int arity2) {
        if (arity2 > 250) {
            throw new NotCompilableException("dynamic regexp has more than 250 elements");
        }
        String cacheField = null;
        Label done = null;
        if (options2.isOnce()) {
            cacheField = "dregexp" + this.getClassData().callSiteCount.getAndIncrement();
            done = new Label();
            this.adapter.getClassVisitor().visitField(10, cacheField, CodegenUtils.ci(RubyRegexp.class), null, null).visitEnd();
            this.adapter.getstatic(this.getClassData().clsName, cacheField, CodegenUtils.ci(RubyRegexp.class));
            this.adapter.dup();
            this.adapter.ifnonnull(done);
            this.adapter.pop();
        }
        callback.run();
        this.adapter.invokedynamic("dregexp", CodegenUtils.sig(RubyRegexp.class, CodegenUtils.params(ThreadContext.class, RubyString.class, arity2)), DRegexpObjectSite.BOOTSTRAP, options2.toEmbeddedOptions());
        if (done != null) {
            this.adapter.dup();
            this.adapter.putstatic(this.getClassData().clsName, cacheField, CodegenUtils.ci(RubyRegexp.class));
            this.adapter.label(done);
        }
    }

    public void pushSymbol(String sym, Encoding encoding2) {
        this.loadContext();
        this.adapter.invokedynamic("symbol", CodegenUtils.sig(JVM.OBJECT, ThreadContext.class), SymbolObjectSite.BOOTSTRAP, sym, new String(encoding2.getName()));
    }

    @Override
    public void loadRuntime() {
        this.loadContext();
        this.adapter.invokedynamic("runtime", CodegenUtils.sig(Ruby.class, ThreadContext.class), Bootstrap.contextValue(), new Object[0]);
    }

    @Override
    public void pushEncoding(Encoding encoding2) {
        this.loadContext();
        this.adapter.invokedynamic("encoding", CodegenUtils.sig(RubyEncoding.class, ThreadContext.class), Bootstrap.contextValueString(), new String(encoding2.getName()));
    }

    @Override
    public void invokeOther(String file2, int line, String scopeFieldName, CallBase call2, int arity2) {
        String id2 = call2.getId();
        if (arity2 > 250) {
            throw new NotCompilableException("call to `" + id2 + "' has more than " + 250 + " arguments");
        }
        if (call2.isPotentiallyRefined()) {
            super.invokeOther(file2, line, scopeFieldName, call2, arity2);
            return;
        }
        IRBytecodeAdapter.BlockPassType blockPassType = IRBytecodeAdapter.BlockPassType.fromIR(call2);
        if (blockPassType.given()) {
            if (arity2 == -1) {
                this.adapter.invokedynamic("invoke:" + JavaNameMangler.mangleMethodName(id2), CodegenUtils.sig(JVM.OBJECT, CodegenUtils.params(ThreadContext.class, JVM.OBJECT, JVM.OBJECT, JVM.OBJECT_ARRAY, Block.class)), NormalInvokeSite.BOOTSTRAP, blockPassType.literal(), file2, line);
            } else {
                this.adapter.invokedynamic("invoke:" + JavaNameMangler.mangleMethodName(id2), CodegenUtils.sig(JVM.OBJECT, CodegenUtils.params(ThreadContext.class, JVM.OBJECT, arity2 + 2, Block.class)), NormalInvokeSite.BOOTSTRAP, blockPassType.literal(), file2, line);
            }
        } else if (arity2 == -1) {
            this.adapter.invokedynamic("invoke:" + JavaNameMangler.mangleMethodName(id2), CodegenUtils.sig(JVM.OBJECT, CodegenUtils.params(ThreadContext.class, JVM.OBJECT, JVM.OBJECT, JVM.OBJECT_ARRAY)), NormalInvokeSite.BOOTSTRAP, false, file2, line);
        } else {
            this.adapter.invokedynamic("invoke:" + JavaNameMangler.mangleMethodName(id2), CodegenUtils.sig(JVM.OBJECT, CodegenUtils.params(ThreadContext.class, JVM.OBJECT, JVM.OBJECT, JVM.OBJECT, arity2)), NormalInvokeSite.BOOTSTRAP, false, file2, line);
        }
    }

    @Override
    public void invokeArrayDeref(String file2, int line, CallBase call2) {
        this.adapter.invokedynamic("aref", CodegenUtils.sig(JVM.OBJECT, CodegenUtils.params(ThreadContext.class, JVM.OBJECT, JVM.OBJECT, JVM.OBJECT, 1)), ArrayDerefInvokeSite.BOOTSTRAP, file2, line);
    }

    @Override
    public void invokeOtherOneFixnum(String file2, int line, CallBase call2, long fixnum) {
        String id2 = call2.getId();
        if (!MethodIndex.hasFastFixnumOps(id2)) {
            this.pushFixnum(fixnum);
            if (call2.getCallType() == CallType.NORMAL) {
                this.invokeOther(file2, line, null, call2, 1);
            } else {
                this.invokeSelf(file2, line, null, call2, 1);
            }
            return;
        }
        String signature = CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class, IRubyObject.class));
        this.adapter.invokedynamic("fixnumOperator:" + JavaNameMangler.mangleMethodName(id2), signature, Bootstrap.getFixnumOperatorHandle(), fixnum, call2.getCallType().ordinal(), "", 0);
    }

    @Override
    public void invokeOtherOneFloat(String file2, int line, CallBase call2, double flote) {
        String id2 = call2.getId();
        if (!MethodIndex.hasFastFloatOps(id2)) {
            this.pushFloat(flote);
            if (call2.getCallType() == CallType.NORMAL) {
                this.invokeOther(file2, line, null, call2, 1);
            } else {
                this.invokeSelf(file2, line, null, call2, 1);
            }
            return;
        }
        String signature = CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class, IRubyObject.class));
        this.adapter.invokedynamic("floatOperator:" + JavaNameMangler.mangleMethodName(id2), signature, Bootstrap.getFloatOperatorHandle(), flote, call2.getCallType().ordinal(), "", 0);
    }

    @Override
    public void invokeSelf(String file2, int line, String scopeFieldName, CallBase call2, int arity2) {
        String id2 = call2.getId();
        if (arity2 > 250) {
            throw new NotCompilableException("call to `" + id2 + "' has more than " + 250 + " arguments");
        }
        if (call2.isPotentiallyRefined()) {
            super.invokeSelf(file2, line, scopeFieldName, call2, arity2);
            return;
        }
        String action = call2.getCallType() == CallType.FUNCTIONAL ? "callFunctional" : "callVariable";
        IRBytecodeAdapter.BlockPassType blockPassType = IRBytecodeAdapter.BlockPassType.fromIR(call2);
        if (blockPassType != IRBytecodeAdapter.BlockPassType.NONE) {
            if (arity2 == -1) {
                this.adapter.invokedynamic(action + ":" + JavaNameMangler.mangleMethodName(id2), CodegenUtils.sig(JVM.OBJECT, CodegenUtils.params(ThreadContext.class, JVM.OBJECT, JVM.OBJECT, JVM.OBJECT_ARRAY, Block.class)), SelfInvokeSite.BOOTSTRAP, blockPassType.literal(), file2, line);
            } else {
                this.adapter.invokedynamic(action + ":" + JavaNameMangler.mangleMethodName(id2), CodegenUtils.sig(JVM.OBJECT, CodegenUtils.params(ThreadContext.class, JVM.OBJECT, arity2 + 2, Block.class)), SelfInvokeSite.BOOTSTRAP, blockPassType.literal(), file2, line);
            }
        } else if (arity2 == -1) {
            this.adapter.invokedynamic(action + ":" + JavaNameMangler.mangleMethodName(id2), CodegenUtils.sig(JVM.OBJECT, CodegenUtils.params(ThreadContext.class, JVM.OBJECT, JVM.OBJECT, JVM.OBJECT_ARRAY)), SelfInvokeSite.BOOTSTRAP, false, file2, line);
        } else {
            this.adapter.invokedynamic(action + ":" + JavaNameMangler.mangleMethodName(id2), CodegenUtils.sig(JVM.OBJECT, CodegenUtils.params(ThreadContext.class, JVM.OBJECT, JVM.OBJECT, JVM.OBJECT, arity2)), SelfInvokeSite.BOOTSTRAP, false, file2, line);
        }
    }

    @Override
    public void invokeInstanceSuper(String file2, int line, String name2, int arity2, boolean hasClosure, boolean[] splatmap) {
        if (arity2 > 250) {
            throw new NotCompilableException("call to instance super has more than 250 arguments");
        }
        String splatmapString = IRRuntimeHelpers.encodeSplatmap(splatmap);
        if (hasClosure) {
            this.adapter.invokedynamic("invokeInstanceSuper:" + JavaNameMangler.mangleMethodName(name2), CodegenUtils.sig(JVM.OBJECT, CodegenUtils.params(ThreadContext.class, JVM.OBJECT, JVM.OBJECT, RubyClass.class, JVM.OBJECT, arity2, Block.class)), Bootstrap.invokeSuper(), splatmapString, file2, line);
        } else {
            this.adapter.invokedynamic("invokeInstanceSuper:" + JavaNameMangler.mangleMethodName(name2), CodegenUtils.sig(JVM.OBJECT, CodegenUtils.params(ThreadContext.class, JVM.OBJECT, JVM.OBJECT, RubyClass.class, JVM.OBJECT, arity2)), Bootstrap.invokeSuper(), splatmapString, file2, line);
        }
    }

    @Override
    public void invokeClassSuper(String file2, int line, String name2, int arity2, boolean hasClosure, boolean[] splatmap) {
        if (arity2 > 250) {
            throw new NotCompilableException("call to class super has more than 250 arguments");
        }
        String splatmapString = IRRuntimeHelpers.encodeSplatmap(splatmap);
        if (hasClosure) {
            this.adapter.invokedynamic("invokeClassSuper:" + JavaNameMangler.mangleMethodName(name2), CodegenUtils.sig(JVM.OBJECT, CodegenUtils.params(ThreadContext.class, JVM.OBJECT, JVM.OBJECT, RubyClass.class, JVM.OBJECT, arity2, Block.class)), Bootstrap.invokeSuper(), splatmapString, file2, line);
        } else {
            this.adapter.invokedynamic("invokeClassSuper:" + JavaNameMangler.mangleMethodName(name2), CodegenUtils.sig(JVM.OBJECT, CodegenUtils.params(ThreadContext.class, JVM.OBJECT, JVM.OBJECT, RubyClass.class, JVM.OBJECT, arity2)), Bootstrap.invokeSuper(), splatmapString, file2, line);
        }
    }

    @Override
    public void invokeUnresolvedSuper(String file2, int line, String name2, int arity2, boolean hasClosure, boolean[] splatmap) {
        if (arity2 > 250) {
            throw new NotCompilableException("call to unresolved super has more than 250 arguments");
        }
        String splatmapString = IRRuntimeHelpers.encodeSplatmap(splatmap);
        if (hasClosure) {
            this.adapter.invokedynamic("invokeUnresolvedSuper:" + JavaNameMangler.mangleMethodName(name2), CodegenUtils.sig(JVM.OBJECT, CodegenUtils.params(ThreadContext.class, JVM.OBJECT, JVM.OBJECT, RubyClass.class, JVM.OBJECT, arity2, Block.class)), Bootstrap.invokeSuper(), splatmapString, file2, line);
        } else {
            this.adapter.invokedynamic("invokeUnresolvedSuper:" + JavaNameMangler.mangleMethodName(name2), CodegenUtils.sig(JVM.OBJECT, CodegenUtils.params(ThreadContext.class, JVM.OBJECT, JVM.OBJECT, RubyClass.class, JVM.OBJECT, arity2)), Bootstrap.invokeSuper(), splatmapString, file2, line);
        }
    }

    @Override
    public void invokeZSuper(String file2, int line, String name2, int arity2, boolean hasClosure, boolean[] splatmap) {
        if (arity2 > 250) {
            throw new NotCompilableException("call to zsuper has more than 250 arguments");
        }
        String splatmapString = IRRuntimeHelpers.encodeSplatmap(splatmap);
        if (hasClosure) {
            this.adapter.invokedynamic("invokeUnresolvedSuper:" + JavaNameMangler.mangleMethodName(name2), CodegenUtils.sig(JVM.OBJECT, CodegenUtils.params(ThreadContext.class, JVM.OBJECT, JVM.OBJECT, RubyClass.class, JVM.OBJECT, arity2, Block.class)), Bootstrap.invokeSuper(), splatmapString, file2, line);
        } else {
            this.adapter.invokedynamic("invokeUnresolvedSuper:" + JavaNameMangler.mangleMethodName(name2), CodegenUtils.sig(JVM.OBJECT, CodegenUtils.params(ThreadContext.class, JVM.OBJECT, JVM.OBJECT, RubyClass.class, JVM.OBJECT, arity2)), Bootstrap.invokeSuper(), splatmapString, file2, line);
        }
    }

    @Override
    public void pushNil() {
        this.loadContext();
        this.adapter.invokedynamic("nil", CodegenUtils.sig(IRubyObject.class, ThreadContext.class), Bootstrap.contextValue(), new Object[0]);
    }

    @Override
    public void pushBoolean(boolean b2) {
        this.loadContext();
        this.adapter.invokedynamic(b2 ? "True" : "False", CodegenUtils.sig(IRubyObject.class, ThreadContext.class), Bootstrap.contextValue(), new Object[0]);
    }

    @Override
    public void pushBignum(BigInteger bigint) {
        String bigintStr = bigint.toString();
        this.loadContext();
        this.adapter.invokedynamic("bignum", CodegenUtils.sig(RubyBignum.class, ThreadContext.class), BignumObjectSite.BOOTSTRAP, bigintStr);
    }

    @Override
    public void putField(String name2) {
        this.adapter.invokedynamic("ivarSet:" + JavaNameMangler.mangleMethodName(name2), CodegenUtils.sig(Void.TYPE, IRubyObject.class, IRubyObject.class), VariableSite.IVAR_ASM_HANDLE, new Object[0]);
    }

    @Override
    public void getField(String name2) {
        this.adapter.invokedynamic("ivarGet:" + JavaNameMangler.mangleMethodName(name2), CodegenUtils.sig(JVM.OBJECT, IRubyObject.class), VariableSite.IVAR_ASM_HANDLE, new Object[0]);
    }

    @Override
    public void array(int length2) {
        if (length2 > 250) {
            throw new NotCompilableException("literal array has more than 250 elements");
        }
        if (length2 <= 2) {
            super.array(length2);
            return;
        }
        this.adapter.invokedynamic("array", CodegenUtils.sig(JVM.OBJECT, CodegenUtils.params(ThreadContext.class, JVM.OBJECT, length2)), Bootstrap.array(), new Object[0]);
    }

    @Override
    public void hash(int length2) {
        if (length2 > 125) {
            throw new NotCompilableException("literal hash has more than 125 pairs");
        }
        this.adapter.invokedynamic("hash", CodegenUtils.sig(JVM.OBJECT, CodegenUtils.params(ThreadContext.class, JVM.OBJECT, length2 * 2)), Bootstrap.hash(), new Object[0]);
    }

    @Override
    public void kwargsHash(int length2) {
        if (length2 > 125) {
            throw new NotCompilableException("kwargs hash has more than 125 pairs");
        }
        this.adapter.invokedynamic("kwargsHash", CodegenUtils.sig(JVM.OBJECT, CodegenUtils.params(ThreadContext.class, RubyHash.class, JVM.OBJECT, length2 * 2)), Bootstrap.kwargsHash(), new Object[0]);
    }

    @Override
    public void checkpoint() {
        this.loadContext();
        this.adapter.invokedynamic("checkpoint", CodegenUtils.sig(Void.TYPE, ThreadContext.class), Bootstrap.checkpointHandle(), new Object[0]);
    }

    @Override
    public void prepareBlock(Handle handle, org.jruby.runtime.Signature signature, String className) {
        Handle scopeHandle = new Handle(2, this.getClassData().clsName, handle.getName() + "_IRScope", CodegenUtils.ci(IRScope.class), false);
        long encodedSignature = signature.encode();
        this.adapter.invokedynamic(handle.getName(), CodegenUtils.sig(Block.class, ThreadContext.class, IRubyObject.class, DynamicScope.class), Bootstrap.prepareBlock(), handle, scopeHandle, encodedSignature);
    }

    @Override
    public void branchIfNil(Label label2) {
        this.adapter.invokedynamic("isNil", CodegenUtils.sig(Boolean.TYPE, IRubyObject.class), Bootstrap.isNilBoot(), new Object[0]);
        this.adapter.iftrue(label2);
    }

    @Override
    public void branchIfTruthy(Label label2) {
        this.adapter.invokedynamic("isTrue", CodegenUtils.sig(Boolean.TYPE, IRubyObject.class), Bootstrap.isTrueBoot(), new Object[0]);
        this.adapter.iftrue(label2);
    }
}

