;;; Snd tests
;;;
;;;  test 0: constants                          [375]
;;;  test 1: defaults                           [1020]
;;;  test 2: headers                            [1373]
;;;  test 3: variables                          [1687]
;;;  test 4: sndlib                             [2238]
;;;  test 5: simple overall checks              [3970]
;;;  test 6: float-vectors                      [8582]
;;;  test 7: colors                             [8842]
;;;  test 8: clm                                [9326]
;;;  test 9: mix                                [21076]
;;;  test 10: marks                             [22795]
;;;  test 11: dialogs                           [23712]
;;;  test 12: extensions                        [23871]
;;;  test 13: menus, edit lists, hooks, etc     [24108]
;;;  test 14: all together now                  [25413]
;;;  test 15: chan-local vars                   [26217]
;;;  test 16: regularized funcs                 [27879]
;;;  test 17: dialogs and graphics              [31373]
;;;  test 18: save and restore                  [31478]
;;;  test 19: transforms                        [33108]
;;;  test 20: new stuff                         [35157]
;;;  test 21: optimizer                         [36331]
;;;  test 22: with-sound                        [38683]
;;;  test 23: errors                            [41443]
;;;  test 24: s7                                [42838]
;;;  test the end                               [43132]


;;; (set! (hook-functions *load-hook*) (list (lambda (hook) (format *stderr* "loading ~S...~%" (hook 'name)))))

;(set! (*s7* 'gc-stats) #t)
(set! (*s7* 'heap-size) 1024000) ; bigger is slower here
(set! (*s7* 'print-length) 12345)

(when (provided? 'pure-s7)
  (define (make-polar mag ang)
    (if (and (real? mag) (real? ang))
	(complex (* mag (cos ang)) (* mag (sin ang)))
	(error 'wrong-type-arg "make-polar args should be real"))))

(define tests 1)
(define keep-going #f)
(define all-args #f)
(define test-at-random 0)
(define hooked #f)
(define base-length 1000)

(if (<= tests 0) (set! tests 1))

(define (copy-file source dest) (system (string-append "cp " source " " dest)))

(define-expansion (fill-float-vector v body)
  `(let ((len (length ,v)))
     (do ((i 0 (+ i 1)))
	 ((= i len) ,v)
       (float-vector-set! ,v i ,body))))

(define-expansion (outa->fv v body) 
  `(let ((len (length ,v)))
     (set! *output* ,v) 
     (do ((i 0 (+ i 1)))
	 ((= i len) (set! *output* #f) ,v)
       (outa i ,body))))

(if (not (defined? 'snd-test)) (define snd-test -1))
(define full-test (< snd-test 0))
(define total-tests 24)
(if (not (defined? 'with-exit)) (define with-exit (< snd-test 0)))
(define test-number -1)

(define-expansion (snd-display . args)
  `(format *stderr* "~%~A: ~8T;~A" ,(port-line-number) (format #f ,@args)))

(define-expansion (check-edit-tree tree vals name)
  `(check-edit-tree-1 ,tree ,vals ,name ,(port-line-number)))

(define with-big-file #f)
(define big-file-name "/home/bil/zap/sounds/bigger.snd")
(when with-big-file 
  (set! with-big-file (file-exists? big-file-name))
  (if (not with-big-file) (snd-display "no big file")))
(define big-file-framples 0)

(define original-save-dir (or *save-dir* "~/zap/snd"))
(define original-temp-dir (or *temp-dir* "~/zap/tmp"))
(define original-sound-file-extensions (sound-file-extensions))

(unbind-key #\c 4 #t)
;;; clear out old junk!
(if (file-exists? original-save-dir) 
    (system (format #f "rm ~A/snd_*" original-save-dir)))
(if (file-exists? original-temp-dir) 
    (system (format #f "rm ~A/snd_*" original-temp-dir)))
(if (file-exists? "/tmp")
    (begin ; -noinit possibly
      (system "rm /tmp/snd_*")
      (system "rm /tmp/*.snd")))
(if (file-exists? "/var/tmp")
    (begin ; -noinit possibly
      (system "rm /var/tmp/snd_*")
      (system "rm /var/tmp/*.snd")))

(define home-dir (getenv "HOME"))
(define sf-dir "/sf1")

(cond ((file-exists? (string-append home-dir "/cl/oboe.snd")))
      ((file-exists? "/export/home/bil/cl/oboe.snd") (set! home-dir "/export/home/bil"))
      ((file-exists? "/Users/bil/cl/oboe.snd")       (set! home-dir "/Users/bil"))
      ((file-exists? "/users/b/bil/cl/oboe.snd")     (set! home-dir "/users/b/bil"))
      ((file-exists? "/usr/home/bil/cl/oboe.snd")    (set! home-dir "/usr/home/bil")))

(define cwd (string-append (getcwd) "/"))

(define sf-dir1 (string-append home-dir sf-dir "/"))
(unless (file-exists? (string-append sf-dir1 "alaw.wav"))
  (set! sf-dir "/sf")
  (set! sf-dir1 (string-append home-dir sf-dir "/"))
  (unless (file-exists? (string-append sf-dir1 "alaw.wav"))
    (snd-display "can't find sf directory!")
    (set! sf-dir1 #f)))
(set! sf-dir sf-dir1)

(if (not (string=? (getcwd) (string-append home-dir "/cl")))
    (for-each
     (lambda (file)
       (unless (file-exists? file)
	 (format () "copying ~A~%" file)
	 (copy-file (string-append home-dir "/cl/" file) (string-append (getcwd) "/" file))))
     '("4.aiff" "2.snd" "obtest.snd" "oboe.snd" "pistol.snd" "1a.snd" "now.snd" "fyow.snd"
       "storm.snd" "z.snd" "1.snd" "cardinal.snd" "now.snd.scm" "2a.snd" "4a.snd" "zero.snd"
       "loop.scm" "cmn-glyphs.lisp" "bullet.xpm" "mb.snd" "funcs.scm" "trumpet.snd" "1234.snd")))

(for-each mus-sound-preload '("4.aiff" "2.snd" "obtest.snd" "oboe.snd" "pistol.snd" "1a.snd" "now.snd" 
			      "fyow.snd" "storm.snd" "1.snd" "cardinal.snd" "2a.snd"))

;;(setlocale LC_ALL "de_DE")
(set! *with-background-processes* #f)

;; try to get a different random number sequence on each run
(set! (mus-rand-seed) (current-time))

(set! (hook-functions bad-header-hook) ())
(hook-push bad-header-hook (lambda (hook) (set! (hook 'result) #t)))

(define with-motif (provided? 'snd-motif))

(define with-gui (or (provided? 'snd-gtk)
		     (provided? 'snd-motif)))

(if (not with-gui)
    (define y-bounds (dilambda
		      (lambda args (if (string? args) args (list -1.0 1.0))) ; make lint happy...
		      (lambda args (if (string? args) args (list -1.0 1.0))))))

(if (not with-gui)
    (define x-bounds (dilambda
		      (lambda args (if (string? args) args (list 0.0 0.1)))
		      (lambda args (if (string? args) args (list 0.0 0.1))))))

(define real-time get-internal-real-time)
(define (hundred n) (round (* 100 n)))
(define times ())
(define-macro (time a) 
  `(let ((start (real-time))) 
     ,a 
     (let ((val (hundred (- (real-time) start))))
       (set! times (cons (list ',a val) times)))))

(define original-prompt *listener-prompt*)
(set! (show-listener) #t)
(set! (window-x) 600)
(set! (window-y) 10)


(define-expansion (fneq a b)
  `(> (magnitude (- ,a ,b)) .001))

(define-expansion (ffneq a b)
  `(> (magnitude (- ,a ,b)) .01))

(define-expansion (fffneq a b) 
  `(> (magnitude (- ,a ,b)) .1))

(define (cneq a b)
  (> (magnitude (- a b)) .001))

(define-constant (feql a b)
  (let-temporarily (((*s7* 'morally-equal-float-epsilon) .001))
    (morally-equal? a b)))

(define-constant (ffeql a b)
  (let-temporarily (((*s7* 'morally-equal-float-epsilon) .1))
    (morally-equal? a b)))

(define* (mus-arrays-equal? x y (err .001))
  (let-temporarily (((*s7* 'morally-equal-float-epsilon) err))
    (morally-equal? x y)))

(define (mus-arrays-equal?1 v0 v1)
  (mus-arrays-equal? v0 v1 .01))

(define (vmus-arrays-equal? v0 v1)
  (mus-arrays-equal? v0 v1 .00002))

(define (within-.01? b) (< (abs (- 1.0 b)) .01))
(define (very-close? a b) (< (abs (- a b)) .01))

(define (clean-up-sound ind)
   (let ((new-file-name (file-name ind)))
     (close-sound ind)
     (if (file-exists? new-file-name)
	 (delete-file new-file-name))))

(define dismiss-all-dialogs
  (let ((+documentation+ "(dismiss-all-dialogs) hides all dialogs"))
    (lambda ()
      (if (or (provided? 'xm)
	      (provided? 'xg))
	  (for-each
	   (lambda (dialog)
	     (if dialog
		 (if (symbol? (car dialog))
		     (if (provided? 'snd-motif)
			 (if ((*motif* 'XtIsManaged) dialog)
			     ((*motif* 'XtUnmanageChild) dialog))
			 (if (provided? 'snd-gtk)
			     ((*gtk* 'gtk_widget_hide) dialog)))
		     (for-each
		      (lambda (d)
			(if (symbol? (car d))
			    (if (provided? 'snd-motif)
				(if ((*motif* 'XtIsManaged) d)
				    ((*motif* 'XtUnmanageChild) d))
				(if (provided? 'snd-gtk)
				    ((*gtk* 'gtk_widget_hide) d)))))
		      dialog))))
	   (dialog-widgets))))))

(define safe-color (make-color 1 0 0))
(define make-color-with-catch 
  (let ((+documentation+ "make-color but catch 'no-such-color"))
    (lambda (c1 c2 c3)
      (catch 'no-such-color
	(lambda () (make-color c1 c2 c3))
	(lambda args safe-color)))))

(define safe-display-edits 
  (let ((+documentation+ "display-edits but catch all errors"))
    (lambda* (snd chn edpos)
      (catch #t
	(lambda () (display-edits snd chn edpos))
	(lambda args (snd-display "display-edits error: ~A" args))))))

(define timings (make-vector (+ total-tests 1) 0))
(define default-srate *clm-srate*)

(snd-display "~A" (snd-version))
(if (not (defined? 'before-test-hook)) (define before-test-hook (make-hook 'n)))
(if (not (defined? 'after-test-hook)) (define after-test-hook (make-hook 'n)))
(set! (hook-functions before-test-hook) ())
(hook-push before-test-hook (lambda (hook)
			      (let ((n (hook 'n)))
				(set! *clm-srate* default-srate)
				(dismiss-all-dialogs)
				(set! *clipping* #f)
				(set! (mus-clipping) #f) ; this cost me a morning of confusion!
				(set! test-number n)
				(if (> (length timings) n)
				    (set! (timings n) (real-time)))
				(snd-display "test ~D" n))))

(define (clear-save-state-files)
  (for-each forget-region (regions))
  (system (format #f "rm -f ~A/snd_*" (or *save-dir* original-save-dir)))
  (if (file-exists? "/var/tmp") 
      (system "rm -f /var/tmp/snd_save_*"))
  (if (file-exists? "/tmp") 
      (system "rm -f /tmp/snd_save_*"))
  (mus-sound-prune))

(set! (hook-functions after-test-hook) ())
(hook-push after-test-hook
	   (lambda (hook)
	     (let ((n (hook 'n)))
	       (clear-save-state-files)
	       (clear-listener)
	       (set! *ask-about-unsaved-edits* #f)
	       (when (pair? (sounds))
		 (snd-display "end test ~D: open sounds: ~A" n (map short-file-name (sounds)))
		 (for-each close-sound (sounds)))
	       (if (number? (vector-ref timings n))
		   (set! (timings n) (hundred (- (real-time) (vector-ref timings n))))))))

(define overall-start-time (real-time))
(snd-display "~A~%" (strftime "%d-%b %H:%M %Z" (localtime (current-time))))

(define (log-mem tst) 
  (if (> tests 1) (snd-display "test ~D:~D " test-number (+ 1 tst))))

(define-macro (without-errors . func)
  `(catch #t ; but this also squelches syntax errors!
     (lambda ()
       ,@func)
     (lambda args 
       (car args))))

(require snd-hooks.scm snd-ws.scm)

(define* (scale-sound-by scl beg dur snd chn edpos)
  (if (integer? chn)
      (scale-channel scl beg dur snd chn edpos)
      (do ((i 0 (+ i 1)))
	  ((= i (channels snd)))
	(scale-channel scl beg dur snd i))))

(define* (scale-sound-to norm beg dur snd chn)
  (if (integer? chn)
      (let ((mx (maxamp snd chn)))
	(if (not (or (= mx 0.0)
		     (= mx norm)))
	    (scale-channel (/ norm mx) beg dur snd chn)))
      (let ((mx (apply max (maxamp snd #t))))
	(if (not (or (= mx 0.0)
		     (= mx norm)))
	    (do ((nmx (/ norm mx))
		 (i 0 (+ i 1)))
		((= i (channels snd)))
	      (scale-channel nmx beg dur snd i))))))

(define (file->floats file) (samples 0 (framples file) file))

(define* (floats->file v file (srate 22050) (comment ""))
  (if (float-vector? v)
      (begin
	(array->file file v (length v) srate 1)
	file)
      (error 'wrong-type-arg "file->floats: ~A" v)))


(when (and (> (length (script-args)) 0)
	   (> (script-arg) 0))
  (let ((arg (script-arg))
	(args (script-args)))
    (if (not (string=? (args (- arg 1)) "-l")) 
	(snd-display "script-args[~A]: ~A (~A)?" (- arg 1) (args (- arg 1)) args))
    (if (not (string=? (args arg) "snd-test")) 
	(snd-display "script-args[~A]: ~A (~A)?" arg (args arg) args))
    (when (> (length args) (+ 1 arg))
      ;; test-number tests
      (set! snd-test (string->number (args (+ 1 arg))))
      (set! test-at-random 0)
      (set! full-test (< snd-test 0))
      (set! with-exit #t)
      (set! (script-arg) (+ 1 arg))
      (when (> (length (script-args)) (+ arg 2))
	(set! tests (string->number (args (+ arg 2))))
	(set! (script-arg) (+ arg 2))))))

(if (and (provided? 'snd-motif)
	 (provided? 'xm))
    (require snd-snd-motif.scm)
    (if (and (provided? 'snd-gtk)
	     (provided? 'xg))
	(require snd-snd-gtk.scm)))


(define default-file-buffer-size *clm-file-buffer-size*)
					;(set! *clm-file-buffer-size* default-file-buffer-size)

;;; ---------------- test 0: constants ----------------

(define (snd_test_0)
  (if (or (pair? (sounds))
	  (pair? (mixes))
	  (pair? (marks))
	  (pair? (regions)))
      (snd-display "start up: ~A ~A ~A ~A" (sounds) (mixes) (marks) (regions)))
  (do ((lst '(bartlett-hann-window 21
	      bartlett-window 4 
	      blackman10-window 29
	      blackman2-window 6 
	      blackman3-window 7 
	      blackman4-window 8
	      blackman5-window 24
	      blackman6-window 25
	      blackman7-window 26
	      blackman8-window 27
	      blackman9-window 28
	      bohman-window 22
	      cauchy-window 12 
	      channels-combined 1 
	      channels-separate 0 
	      channels-superimposed 2
	      connes-window 18
	      copy-context 0
	      cursor-context 3
	      cursor-cross 0
	      cursor-in-middle 3
	      cursor-in-view 0 
	      cursor-line 1
	      cursor-on-left 1 
	      cursor-on-right 2 
	      dolph-chebyshev-window 16
	      dont-normalize 0
	      dpss-window 35
	      enved-add-point 0
	      enved-amplitude 0 
	      enved-delete-point 1
	      enved-move-point 2
	      enved-spectrum 1
	      enved-srate 2 
	      envelope-exponential 1
	      envelope-linear 0
	      exponential-window 9 
	      flat-top-window 23
	      gaussian-window 14 
	      graph-as-sonogram 1
	      graph-as-spectrogram 2 
	      graph-as-wavogram 3
	      graph-dots 1
	      graph-dots-and-lines 3 
	      graph-filled 2 
	      graph-lines 0 
	      graph-lollipops 4
	      graph-once 0
	      graph-once 0 
	      hamming-window 5
	      hann-poisson-window 17
	      hann-window 1
	      kaiser-window 11 
	      keyboard-no-action 4
	      lisp-graph 2
	      mark-context 4
	      mlt-sine-window 33
	      normalize-by-channel 1
	      normalize-by-sound 2
	      normalize-globally 3
	      papoulis-window 34
	      parzen-window 3
	      poisson-window 13
	      rectangular-window 0 
	      riemann-window 10 
	      rv2-window 30
	      rv3-window 31
	      rv4-window 32
	      samaraki-window 19
	      selection-context 2
	      show-all-axes 1
	      show-all-axes-unlabelled 3
	      show-bare-x-axis 5
	      show-no-axes 0
	      show-x-axis 2
	      show-x-axis-unlabelled 4
	      sinc-window 36
	      speed-control-as-float 0 
	      speed-control-as-ratio 1 
	      speed-control-as-semitone 2 
	      sync-all 1
	      sync-by-sound 2
	      sync-none 0
	      time-graph 0
	      transform-graph 1
	      tukey-window 15 
	      ultraspherical-window 20
	      welch-window 2 
	      x-axis-as-clock 5
	      x-axis-as-percentage 2
	      x-axis-in-beats 3
	      x-axis-in-measures 4
	      x-axis-in-samples 1 
	      x-axis-in-seconds 0 
	      zoom-focus-active 2
	      zoom-focus-left 0
	      zoom-focus-middle 3
	      zoom-focus-right 1 
		  
	      ;; sndlib constants
	      mus-aifc 2
	      mus-aiff 49
	      mus-bicsf 5
	      mus-caff 60
	      mus-ircam 15
	      mus-next 1
	      mus-nist 6
	      mus-raw 12
	      mus-rf64 4
	      mus-riff 3
	      mus-soundfont 26
	      mus-svx 9
	      mus-unknown-header 0
	      mus-voc 10
		  
	      mus-interp-all-pass 3
	      mus-interp-bezier 5
	      mus-interp-hermite 6
	      mus-interp-lagrange 4
	      mus-interp-linear 1
	      mus-interp-none 0
	      mus-interp-sinusoidal 2
		  
	      mus-chebyshev-first-kind 1
	      mus-chebyshev-second-kind 2
		  
	      mus-alaw 6
	      mus-b24int 8
	      mus-bdouble 9
	      mus-bdouble-unscaled 21
	      mus-bfloat 4
	      mus-bfloat-unscaled 19
	      mus-bint 5
	      mus-bintn 17
	      mus-bshort 1
	      mus-byte 3
	      mus-l24int 16
	      mus-ldouble 13
	      mus-ldouble-unscaled 22
	      mus-lfloat 12
	      mus-lfloat-unscaled 20
	      mus-lint 11
	      mus-lintn 18
	      mus-lshort 10
	      mus-mulaw 2
	      mus-ubshort 14
	      mus-ubyte 7
	      mus-ulshort 15
	      mus-unknown-sample 0)
	    (cddr lst)))
      ((null? lst))
    (if (not (= (symbol->value (car lst)) (cadr lst)))
	(snd-display "~A is not ~A (~A)~%" (car lst) (cadr lst) (symbol->value (car lst)))))
  
  (if (not (equal? *region-graph-style* graph-lines))
      (snd-display "region-graph-style set default: ~A" *region-graph-style*))
  (if *ask-about-unsaved-edits*
      (snd-display "ask-about-unsaved-edits set default: ~A" *ask-about-unsaved-edits*))
  (if (not (boolean? *show-full-duration*))
      (snd-display "show-full-duration set default: ~A" *show-full-duration*))
  (if *show-full-range*
      (snd-display "show-full-range set default: ~A" *show-full-range*))
  (if (fneq *initial-beg* 0.0)
      (snd-display "initial-beg set default: ~A" *initial-beg*))
  (if (fneq *initial-dur* 0.1)
      (snd-display "initial-dur set default: ~A" *initial-dur*))
  (if *ask-before-overwrite*
      (snd-display "ask-before-overwrite set default: ~A" *ask-before-overwrite*))
  (if (not *auto-resize*)
      (snd-display "auto-resize set default: ~A" *auto-resize*))
  (if *auto-update*
      (snd-display "auto-update set default: ~A" *auto-update*))
  (if (not (eqv? *channel-style* 1)) 
      (snd-display "channel-style set default: ~A" *channel-style*))
  (if (and (fneq *color-cutoff* 0.003) (fneq *color-cutoff* 0.001))
      (snd-display "color-cutoff set default: ~A" *color-cutoff*))
  (if (not *color-inverted*)
      (snd-display "color-inverted set default: ~A" *color-inverted*))
  (if (fneq *color-scale* 1.0)
      (snd-display "color-scale set default: ~A" *color-scale*))
  (if (fneq *auto-update-interval* 60.0)
      (snd-display "auto-update-interval set default: ~A" *auto-update-interval*))
  (if (fneq *cursor-update-interval* 0.05)
      (snd-display "cursor-update-interval set default: ~A" *cursor-update-interval*))
  (if (not (= *cursor-location-offset* 0))
      (snd-display "cursor-location-offset set default: ~A" *cursor-location-offset*))
  (if (not *dac-combines-channels*)
      (snd-display "dac-combines-channels set default: ~A" *dac-combines-channels*))
  (if (not (eqv? *dac-size* 256)) 
      (snd-display "dac-size set default: ~A" *dac-size*))
  (if *clipping*
      (snd-display "clipping set default: ~A" *clipping*))
  (if (not (eqv? *default-output-chans* 1)) 
      (snd-display "default-output-chans set default: ~A" *default-output-chans*))
  (if (not (or (equal? *default-output-sample-type* mus-bdouble)
	       (equal? *default-output-sample-type* mus-ldouble)))
      (snd-display "default-output-sample-type set default: ~A" *default-output-sample-type*))
  (if (not (eqv? *default-output-srate* 44100)) 
      (snd-display "default-output-srate set default: ~A" *default-output-srate*))
  (if (not (equal? *default-output-header-type* mus-next)) 
      (snd-display "default-output-header-type set default: ~A" *default-output-header-type*))
  (if (not (eqv? *dot-size* 1)) 
      (snd-display "dot-size set default: ~A" *dot-size*))
  (if (not (eqv? *cursor-size* 15)) 
      (snd-display "cursor-size set default: ~A" *cursor-size*))
  (if (not (equal? *cursor-style* cursor-cross)) 
      (snd-display "cursor-style set default: ~A" *cursor-style*))
  (if (not (equal? *tracking-cursor-style* cursor-line)) 
      (snd-display "tracking-cursor-style set default: ~A" *tracking-cursor-style*))
  (if (fneq *enved-base* 1.0)
      (snd-display "enved-base set default: ~A" *enved-base*))
  (if (not (enved-clip?))
      (snd-display "enved-clip? set default: ~A" (enved-clip?)))
  (if (not (enved-filter))
      (snd-display "enved-filter set default: ~A" (enved-filter)))
  (if (not (eqv? *enved-filter-order* 40)) 
      (snd-display "enved-filter-order set default: ~A" *enved-filter-order*))
  (if (enved-in-dB)
      (snd-display "enved-in-dB set default: ~A" (enved-in-dB)))
  (if (not (equal? *enved-style* envelope-linear)) 
      (snd-display "enved-style set default: ~A" *enved-style*))
  (if (fneq *enved-power* 3.0)
      (snd-display "enved-power set default: ~A" *enved-power*))
  (if (not (eqv? *enved-target* 0)) 
      (snd-display "enved-target set default: ~A" *enved-target*))
  (if *enved-wave?*
      (snd-display "enved-wave? set default: ~A" *enved-wave?*))
  (if (and with-gui
	   (pair? (enved-envelope)))
      (snd-display "enved-envelope set default: ~A" (enved-envelope)))
  (if (not (equal? *eps-file* "snd.eps")) 
      (snd-display "eps-file set default: ~A" *eps-file*))
  (if (fneq *eps-bottom-margin* 0.0)
      (snd-display "eps-bottom-margin set default: ~A" *eps-bottom-margin*))
  (if (fneq *eps-left-margin* 0.0)
      (snd-display "eps-left-margin set default: ~A" *eps-left-margin*))
  (if (fneq *eps-size* 1.0)
      (snd-display "eps-size set default: ~A" *eps-size*))
  (if (fneq *fft-window-alpha* 0.0)
      (snd-display "fft-window-alpha set default: ~A" *fft-window-alpha*))
  (if (fneq *fft-window-beta* 0.0)
      (snd-display "fft-window-beta set default: ~A" *fft-window-beta*))
  (if *fft-log-frequency*
      (snd-display "fft-log-frequency set default: ~A" *fft-log-frequency*))
  (if *fft-log-magnitude*
      (snd-display "fft-log-magnitude set default: ~A" *fft-log-magnitude*))
  (if *fft-with-phases*
      (snd-display "fft-with-phases set default: ~A" *fft-with-phases*))
  (if (not (memv *transform-size* '(1024 4096)))
      (snd-display "transform-size set default: ~A" *transform-size*))
  (if (not (equal? *transform-graph-type* graph-once))
      (snd-display "transform-graph-type set default: ~A" *transform-graph-type*))
  (if (not (eqv? *fft-window* 6)) 
      (snd-display "fft-window set default: ~A" *fft-window*))
  (if (not (eqv? *graph-cursor* 34)) 
      (snd-display "graph-cursor set default: ~A" *graph-cursor*))
  (if (not (equal? *graph-style* graph-lines)) 
      (snd-display "graph-style set default: ~A" *graph-style*))
  (if (not *graphs-horizontal*)
      (snd-display "graphs-horizontal set default: ~A" *graphs-horizontal*))
  (if (not (equal? *html-dir* ".")) 
      (snd-display "html-dir set default: ~A" *html-dir*))
  (if (not (equal? *html-program* "firefox")) 
      (snd-display "html-program set default: ~A" *html-program*))
  (if (not *just-sounds*) 
      (snd-display "just-sounds set default: ~A" *just-sounds*))
  (if (not (string? *listener-prompt*)) 
      (snd-display "listener-prompt set default: ~A" *listener-prompt*))
  (if (not (string? *stdin-prompt*)) 
      (snd-display "stdin-prompt set default: ~A" *stdin-prompt*))
  (unless (eqv? *max-transform-peaks* 100)
    (snd-display "max-transform-peaks set default: ~A" *max-transform-peaks*))
  (if (not (eqv? *max-regions* 16)) 
      (snd-display "max-regions set default: ~A" *max-regions*))
  (if (fneq *min-dB* -60.0)
      (snd-display "min-dB set default: ~A" *min-dB*))
  (if (fneq *log-freq-start* 32.0)
      (snd-display "log-freq-start set default: ~A" *log-freq-start*))
  (if (not *selection-creates-region*) 
      (snd-display "selection-creates-region set default: ~A" *selection-creates-region*))
  (if (not (equal? *transform-normalization* normalize-by-channel)) 
      (snd-display "transform-normalization set default: ~A" *transform-normalization*))
  
  (if (and with-motif 
	   (not (eqv? (view-files-sort) 0))) 
      (snd-display "view-files-sort set default: ~A" (view-files-sort)))
  
  (if (not (memv *print-length* '(12 32)))
      (snd-display "print-length set default: ~A" *print-length*))
  (if (not (eqv? *play-arrow-size* 10)) 
      (snd-display "play-arrow-size set default: ~A" *play-arrow-size*))
  (if (not (equal? *save-state-file* "saved-snd.scm")) 
      (snd-display "save-state-file set default: ~A" *save-state-file*))
  (if (not (eqv? *show-axes* 1)) 
      (snd-display "show-axes set default: ~A" *show-axes*))
  (if (not (boolean? *show-transform-peaks*)) 
      (snd-display "show-transform-peaks set default: ~A" *show-transform-peaks*))
  (if (not (boolean? *show-indices*)) 
      (snd-display "show-indices set default: ~A" *show-indices*))
  (if (not *show-marks*)
      (snd-display "show-marks set default: ~A" *show-marks*))
  (if (not *show-mix-waveforms*) 
      (snd-display "show-mix-waveforms set default: ~A" *show-mix-waveforms*))
  (if *show-selection-transform*
      (snd-display "show-selection-transform set default: ~A" *show-selection-transform*))
  (if *show-y-zero*
      (snd-display "show-y-zero set default: ~A" *show-y-zero*))
  (if *show-grid*
      (snd-display "show-grid set default: ~A" *show-grid*))
  (if (fneq *grid-density* 1.0)
      (snd-display "grid-density set default: ~A" *grid-density*))
  (if *show-sonogram-cursor* 
      (snd-display "show-sonogram-cursor set default: ~A" *show-sonogram-cursor*))
  (if (not (eqv? *sinc-width* 10)) 
      (snd-display "sinc-width set default: ~A" *sinc-width*))
  (if (fneq *spectrum-end* 1.0)
      (snd-display "spectrum-end set default: ~A" *spectrum-end*))
  (if (not (eqv? *spectro-hop* 4)) 
      (snd-display "spectro-hop set default: ~A" *spectro-hop*))
  (if (fneq *spectrum-start* 0.0)
      (snd-display "spectrum-start set default: ~A" *spectrum-start*))
  (if (fneq *spectro-x-angle* (if (provided? 'gl) 300.0 90.0))
      (snd-display "spectro-x-angle set default: ~A" *spectro-x-angle*))
  (if (fneq *spectro-x-scale* (if (provided? 'gl) 1.5 1.0))
      (snd-display "spectro-x-scale set default: ~A" *spectro-x-scale*))
  (if (fneq *spectro-y-angle* (if (provided? 'gl) 320.0 0.0))
      (snd-display "spectro-y-angle set default: ~A" *spectro-y-angle*))
  (if (fneq *spectro-y-scale* 1.0)
      (snd-display "spectro-y-scale set default: ~A" *spectro-y-scale*))
  (if (fneq *spectro-z-angle* (if (provided? 'gl) 0.0 358.0))
      (snd-display "spectro-z-angle set default: ~A" *spectro-z-angle*))
  (if (fneq *spectro-z-scale* (if (provided? 'gl) 1.0 0.1))
      (snd-display "spectro-z-scale set default: ~A" *spectro-z-scale*))
  (if (and *temp-dir* (not (equal? *temp-dir* "/home/bil/zap/tmp")))
      (snd-display "temp-dir set default: ~A" *temp-dir*))
  (if (not (equal? *ladspa-dir* "")) 
      (snd-display "ladspa-dir set default: ~A" *ladspa-dir*))
  (if (and *peak-env-dir* (not (equal? *peak-env-dir* "/home/bil/peaks")))
      (snd-display "peak-env-dir set default: ~A" *peak-env-dir*))
  (if (not (member *tiny-font* '("6x12" "Sans 8")))
      (snd-display "tiny-font set default: ~A" *tiny-font*))
  (if (not (equal? *transform-type* fourier-transform)) 
      (snd-display "transform-type set default: ~A" *transform-type*))
  (if (not (eq? *with-file-monitor* #t)) 
      (snd-display "with-file-monitor set default: ~A" *with-file-monitor*))
  (if (not (eqv? *clm-table-size* 512)) 
      (snd-display "clm-table-size set default: ~A" *clm-table-size*))
  (if (not (boolean? *with-verbose-cursor*)) 
      (snd-display "with-verbose-cursor set default: ~A" *with-verbose-cursor*))
  (if (not (boolean? *with-inset-graph*))
      (snd-display "with-inset-graph set default: ~A" *with-inset-graph*))
  (if (not *with-interrupts*)
      (snd-display "with-interrupts set default: ~A" *with-interrupts*))
  (if *remember-sound-state*
      (snd-display "remember-sound-state set default: ~A" *remember-sound-state*))
  (if *with-smpte-label*
      (snd-display "with-smpte-label set default: ~A" *with-smpte-label*))
  (if (not (eq? *with-toolbar* (provided? 'snd-gtk)))
      (snd-display "with-toolbar set default: ~A" *with-toolbar*))
  (if (not *with-tooltips*)
      (snd-display "with-tooltips set default: ~A" *with-tooltips*))
  (if (not (boolean? *with-menu-icons*))
      (snd-display "with-menu-icons set default: ~A" *with-menu-icons*))
  (if *save-as-dialog-src*
      (snd-display "save-as-dialog-src set default: ~A" *save-as-dialog-src*))
  (if *save-as-dialog-auto-comment*
      (snd-display "save-as-dialog-auto-comment set default: ~A" *save-as-dialog-auto-comment*))
  (if (not (boolean? *with-pointer-focus*)) 
      (snd-display "with-pointer-focus set default: ~A" *with-pointer-focus*))
  (if (not (eqv? *wavelet-type* 0)) 
      (snd-display "wavelet-type set default: ~A" *wavelet-type*))
  (if (not (equal? *time-graph-type* graph-once)) 
      (snd-display "time-graph-type set default: ~A" *time-graph-type*))
  (if (not (eqv? *wavo-hop* 3)) 
      (snd-display "wavo-hop set default: ~A" *wavo-hop*))
  (if (not (eqv? *wavo-trace* 64)) 
      (snd-display "wavo-trace set default: ~A" *wavo-trace*))
  (if (not (eqv? *x-axis-style* 0)) 
      (snd-display "x-axis-style set default: ~A" *x-axis-style*))
  (if (fneq *beats-per-minute* 60.0)
      (snd-display "beats-per-minute set default: ~A" *beats-per-minute*))
  (if (not (= *beats-per-measure* 4))
      (snd-display "beats-per-measure set default: ~A" *beats-per-measure*))
  (if (not (eqv? *zero-pad* 0)) 
      (snd-display "zero-pad set default: ~A" *zero-pad*))
  (if (not (null? (zero-pad #t #t)))
      (snd-display "zero-pad #t: ~A" (zero-pad #t #t)))
  (if (not (eqv? *zoom-focus-style* 2)) 
      (snd-display "zoom-focus-style set default: ~A" *zoom-focus-style*))
  (if (not (equal? *sync-style* sync-by-sound)) 
      (snd-display "sync-style set default: ~A" *sync-style*))    
  (if (not (eqv? *mix-waveform-height* 20)) 
      (snd-display "mix-waveform-height set default: ~A" *mix-waveform-height*))
  (if (not (eqv? *mix-tag-width* 6)) 
      (snd-display "mix-tag-width set default: ~A" *mix-tag-width*))
  (if (not (eqv? *mix-tag-height* 14)) 
      (snd-display "mix-tag-height set default: ~A" *mix-tag-height*))
  (if (not (eqv? *mark-tag-width* 10)) 
      (snd-display "mark-tag-width set default: ~A" *mark-tag-width*))
  (if (not (eqv? *mark-tag-height* 4)) 
      (snd-display "mark-tag-height set default: ~A" *mark-tag-height*))
  
  (if (not (equal? *region-graph-style* graph-lines))
      (snd-display "* region-graph-style set default: ~A" *region-graph-style*))
  (if *ask-about-unsaved-edits*
      (snd-display "* ask-about-unsaved-edits set default: ~A" *ask-about-unsaved-edits*))
  (if *show-full-range*
      (snd-display "* show-full-range set default: ~A" *show-full-range*))
  (if (fneq *initial-beg* 0.0)
      (snd-display "* initial-beg set default: ~A" *initial-beg*))
  (if (fneq *initial-dur* 0.1)
      (snd-display "* initial-dur set default: ~A" *initial-dur*))
  (if *ask-before-overwrite*
      (snd-display "* ask-before-overwrite set default: ~A" *ask-before-overwrite*))
  (if (not *auto-resize*) 
      (snd-display "* auto-resize set default: ~A" *auto-resize*))
  (if *auto-update*
      (snd-display "* auto-update set default: ~A" *auto-update*))
  (if (not (eqv? *channel-style* 1)) 
      (snd-display "* channel-style set default: ~A" *channel-style*))
  (if (and (fneq *color-cutoff* 0.003) (fneq *color-cutoff* 0.001))
      (snd-display "* color-cutoff set default: ~A" *color-cutoff*))
  (if (not (eq? *color-inverted* #t)) 
      (snd-display "* color-inverted set default: ~A" *color-inverted*))
  (if (fneq *color-scale* 1.0)
      (snd-display "* color-scale set default: ~A" *color-scale*))
  (if (fneq *auto-update-interval* 60.0)
      (snd-display "* auto-update-interval set default: ~A" *auto-update-interval*))
  (if (fneq *cursor-update-interval* 0.05)
      (snd-display "* cursor-update-interval set default: ~A" *cursor-update-interval*))
  (if (not (= *cursor-location-offset* 0))
      (snd-display "* cursor-location-offset set default: ~A" *cursor-location-offset*))
  (if (not (eq? *dac-combines-channels* #t)) 
      (snd-display "* dac-combines-channels set default: ~A" *dac-combines-channels*))
  (if (not (eqv? *dac-size* 256)) 
      (snd-display "* dac-size set default: ~A" *dac-size*))
  (if *clipping*
      (snd-display "* clipping set default: ~A" *clipping*))
  (if (not (eqv? *default-output-chans* 1)) 
      (snd-display "* default-output-chans set default: ~A" *default-output-chans*))
  (if (not (or (equal? *default-output-sample-type* mus-bdouble)
	       (equal? *default-output-sample-type* mus-ldouble)))
      (snd-display "* default-output-sample-type set default: ~A" *default-output-sample-type*))
  (if (not (eqv? *default-output-srate* 44100)) 
      (snd-display "* default-output-srate set default: ~A" *default-output-srate*))
  (if (not (equal? *default-output-header-type* mus-next)) 
      (snd-display "* default-output-header-type set default: ~A" *default-output-header-type*))
  (if (not (eqv? *dot-size* 1)) 
      (snd-display "* dot-size set default: ~A" *dot-size*))
  (if (not (eqv? *cursor-size* 15)) 
      (snd-display "* cursor-size set default: ~A" *cursor-size*))
  (if (not (equal? *cursor-style* cursor-cross)) 
      (snd-display "* cursor-style set default: ~A" *cursor-style*))
  (if (not (equal? *tracking-cursor-style* cursor-line)) 
      (snd-display "* tracking-cursor-style set default: ~A" *tracking-cursor-style*))
  (if (fneq *enved-base* 1.0)
      (snd-display "* enved-base set default: ~A" *enved-base*))
  (if (not (eqv? *enved-filter-order* 40)) 
      (snd-display "* enved-filter-order set default: ~A" *enved-filter-order*))
  (if (not (equal? *enved-style* envelope-linear)) 
      (snd-display "* enved-style set default: ~A" *enved-style*))
  (if (fneq *enved-power* 3.0)
      (snd-display "* enved-power set default: ~A" *enved-power*))
  (if (not (eqv? *enved-target* 0)) 
      (snd-display "* enved-target set default: ~A" *enved-target*))
  (if *enved-wave?*
      (snd-display "* enved-wave? set default: ~A" *enved-wave?*))
  (if (not (equal? *eps-file* "snd.eps")) 
      (snd-display "* eps-file set default: ~A" *eps-file*))
  (if (fneq *eps-bottom-margin* 0.0)
      (snd-display "* eps-bottom-margin set default: ~A" *eps-bottom-margin*))
  (if (fneq *eps-left-margin* 0.0)
      (snd-display "* eps-left-margin set default: ~A" *eps-left-margin*))
  (if (fneq *eps-size* 1.0)
      (snd-display "* eps-size set default: ~A" *eps-size*))
  (if (fneq *fft-window-alpha* 0.0)
      (snd-display "* fft-window-alpha set default: ~A" *fft-window-alpha*))
  (if (fneq *fft-window-beta* 0.0)
      (snd-display "* fft-window-beta set default: ~A" *fft-window-beta*))
  (if *fft-log-frequency*
      (snd-display "* fft-log-frequency set default: ~A" *fft-log-frequency*))
  (if *fft-log-magnitude*
      (snd-display "* fft-log-magnitude set default: ~A" *fft-log-magnitude*))
  (if *fft-with-phases*
      (snd-display "* fft-with-phases set default: ~A" *fft-with-phases*))
  (if (not (memv *transform-size* '(1024 4096)))
      (snd-display "* transform-size set default: ~A" *transform-size*))
  (if (not (equal? *transform-graph-type* graph-once))
      (snd-display "* transform-graph-type set default: ~A" *transform-graph-type*))
  (if (not (eqv? *fft-window* 6)) 
      (snd-display "* fft-window set default: ~A" *fft-window*))
  (if (not (eqv? *graph-cursor* 34)) 
      (snd-display "* graph-cursor set default: ~A" *graph-cursor*))
  (if (not (equal? *graph-style* graph-lines)) 
      (snd-display "* graph-style set default: ~A" *graph-style*))
  (if (not *graphs-horizontal*) 
      (snd-display "* graphs-horizontal set default: ~A" *graphs-horizontal*))
  (if (not (equal? *html-dir* ".")) 
      (snd-display "* html-dir set default: ~A" *html-dir*))
  (if (not (equal? *html-program* "firefox")) 
      (snd-display "* html-program set default: ~A" *html-program*))
  (if (not *just-sounds*) 
      (snd-display "* just-sounds set default: ~A" *just-sounds*))
  (if (not (eqv? *max-transform-peaks* 100)) 
      (snd-display "* max-transform-peaks set default: ~A" *max-transform-peaks*))
  (if (not (eqv? *max-regions* 16)) 
      (snd-display "* max-regions set default: ~A" *max-regions*))
  (if (fneq *min-dB* -60.0)
      (snd-display "* min-dB set default: ~A" *min-dB*))
  (if (fneq *log-freq-start* 32.0)
      (snd-display "* log-freq-start set default: ~A" *log-freq-start*))
  (if (not (eq? *selection-creates-region* #t)) 
      (snd-display "* selection-creates-region set default: ~A" *selection-creates-region*))
  (if (not (equal? *transform-normalization* normalize-by-channel)) 
      (snd-display "* transform-normalization set default: ~A" *transform-normalization*))
  
  (if (and with-motif 
	   (not (eqv? *view-files-sort* 0)))
      (snd-display "* view-files-sort set default: ~A" *view-files-sort*))
  
  (if (not (eqv? *play-arrow-size* 10)) 
      (snd-display "* play-arrow-size set default: ~A" *play-arrow-size*))
  (if (not (equal? *save-state-file* "saved-snd.scm")) 
      (snd-display "* save-state-file set default: ~A" *save-state-file*))
  (if (not (eqv? *show-axes* 1)) 
      (snd-display "* show-axes set default: ~A" *show-axes*))
  (if (not *show-marks*) 
      (snd-display "* show-marks set default: ~A" *show-marks*))
  (if (not *show-mix-waveforms*) 
      (snd-display "* show-mix-waveforms set default: ~A" *show-mix-waveforms*))
  (if *show-selection-transform*
      (snd-display "* show-selection-transform set default: ~A" *show-selection-transform*))
  (if *show-y-zero*
      (snd-display "* show-y-zero set default: ~A" *show-y-zero*))
  (if *show-grid*
      (snd-display "* show-grid set default: ~A" *show-grid*))
  (if (fneq *grid-density* 1.0)
      (snd-display "* grid-density set default: ~A" *grid-density*))
  (if *show-sonogram-cursor*
      (snd-display "* show-sonogram-cursor set default: ~A" *show-sonogram-cursor*))
  (if (not (eqv? *sinc-width* 10)) 
      (snd-display "* sinc-width set default: ~A" *sinc-width*))
  (if (fneq *spectrum-end* 1.0)
      (snd-display "* spectrum-end set default: ~A" *spectrum-end*))
  (if (not (eqv? *spectro-hop* 4)) 
      (snd-display "* spectro-hop set default: ~A" *spectro-hop*))
  (if (fneq *spectrum-start* 0.0)
      (snd-display "* spectrum-start set default: ~A" *spectrum-start*))
  (if (fneq *spectro-x-angle* (if (provided? 'gl) 300.0 90.0))
      (snd-display "* spectro-x-angle set default: ~A" *spectro-x-angle*))
  (if (fneq *spectro-x-scale* (if (provided? 'gl) 1.5 1.0))
      (snd-display "* spectro-x-scale set default: ~A" *spectro-x-scale*))
  (if (fneq *spectro-y-angle* (if (provided? 'gl) 320.0 0.0))
      (snd-display "* spectro-y-angle set default: ~A" *spectro-y-angle*))
  (if (fneq *spectro-y-scale* 1.0)
      (snd-display "* spectro-y-scale set default: ~A" *spectro-y-scale*))
  (if (fneq *spectro-z-angle* (if (provided? 'gl) 0.0 358.0))
      (snd-display "* spectro-z-angle set default: ~A" *spectro-z-angle*))
  (if (fneq *spectro-z-scale* (if (provided? 'gl) 1.0 0.1))
      (snd-display "* spectro-z-scale set default: ~A" *spectro-z-scale*))
  (if (not (member *tiny-font* '("6x12" "Sans 8")))
      (snd-display "* tiny-font set default: ~A" *tiny-font*))
  (if (not *with-file-monitor*) 
      (snd-display "* with-file-monitor set default: ~A" *with-file-monitor*))
  (if (not *with-interrupts*)
      (snd-display "* with-interrupts set default: ~A" *with-interrupts*))
  (if *remember-sound-state*
      (snd-display "* remember-sound-state set default: ~A" *remember-sound-state*))
  (if *with-smpte-label*
      (snd-display "* with-smpte-label set default: ~A" *with-smpte-label*))
  (if (not (eq? *with-toolbar* (provided? 'snd-gtk)))
      (snd-display "* with-toolbar set default: ~A" *with-toolbar*))
  (if (not *with-tooltips*)
      (snd-display "* with-tooltips set default: ~A" *with-tooltips*))
  (if *save-as-dialog-src*
      (snd-display "* save-as-dialog-src set default: ~A" *save-as-dialog-src*))
  (if *save-as-dialog-auto-comment*
      (snd-display "* save-as-dialog-auto-comment set default: ~A" *save-as-dialog-auto-comment*))
  (if (not (eqv? *wavelet-type* 0)) 
      (snd-display "* wavelet-type set default: ~A" *wavelet-type*))
  (if (not (equal? *time-graph-type* graph-once)) 
      (snd-display "* time-graph-type set default: ~A" *time-graph-type*))
  (if (not (eqv? *wavo-hop* 3)) 
      (snd-display "* wavo-hop set default: ~A" *wavo-hop*))
  (if (not (eqv? *wavo-trace* 64)) 
      (snd-display "* wavo-trace set default: ~A" *wavo-trace*))
  (if (not (eqv? *x-axis-style* 0)) 
      (snd-display "* x-axis-style set default: ~A" *x-axis-style*))
  (if (fneq *beats-per-minute* 60.0)
      (snd-display "* beats-per-minute set default: ~A" *beats-per-minute*))
  (if (not (= *beats-per-measure* 4))
      (snd-display "* beats-per-measure set default: ~A" *beats-per-measure*))
  (if (not (eqv? *zero-pad* 0)) 
      (snd-display "* zero-pad set default: ~A" *zero-pad*))
  (if (not (eqv? *zoom-focus-style* 2)) 
      (snd-display "* zoom-focus-style set default: ~A" *zoom-focus-style*))
  (if (not (equal? *sync-style* sync-by-sound)) 
      (snd-display "* sync-style set default: ~A" *sync-style*))    
  (if (not (eqv? *mix-waveform-height* 20)) 
      (snd-display "* mix-waveform-height set default: ~A" *mix-waveform-height*))
  (if (not (eqv? *mix-tag-width* 6)) 
      (snd-display "* mix-tag-width set default: ~A" *mix-tag-width*))
  (if (not (eqv? *mix-tag-height* 14)) 
      (snd-display "* mix-tag-height set default: ~A" *mix-tag-height*))
  (if (not (eqv? *mark-tag-width* 10)) 
      (snd-display "* mark-tag-width set default: ~A" *mark-tag-width*))
  (if (not (eqv? *mark-tag-height* 4)) 
      (snd-display "* mark-tag-height set default: ~A" *mark-tag-height*))
  
  (if (and with-motif
	   (not (= (view-files-sort) 0)))
      (snd-display "view-files-sort def: ~A" (view-files-sort)))
  
  (let-temporarily ((*mus-max-malloc* (expt 2 36)))
    (if (not (= *mus-max-malloc* (expt 2 36)))
	(snd-display "mus-max-malloc as bignum: ~A" *mus-max-malloc*)))
  
  (let-temporarily ((*mus-max-table-size* (expt 2 36)))
    (if (not (= *mus-max-table-size* (expt 2 36)))
	(snd-display "mus-max-table-size as bignum: ~A" *mus-max-table-size*)))
  
  (if (not (provided? 'snd-gtk))
      (for-each
       (lambda (func name)
	 (let ((val (func)))
	   (set! (func) "8x123")
	   (if (not (and (string? (func))
			 (string=? val (func))))
	       (snd-display "set ~A to bogus value: ~A ~A" name val (func)))))
       (list axis-label-font axis-numbers-font tiny-font peaks-font bold-peaks-font)
       '(axis-label-font axis-numbers-font tiny-font peaks-font bold-peaks-font)))
  
  (set! *ask-about-unsaved-edits* #f)
  (set! *remember-sound-state* #f))



;;; ---------------- test 1: defaults ----------------

(define good-colormap hot-colormap)
(define better-colormap black-and-white-colormap)
(if (and with-gui
	 (not (colormap? good-colormap)))
    (set! good-colormap
	  (call-with-exit
	   (lambda (return)
	     (do ((i 1 (+ i 1)))
		 ((= i 20))
	       (if (colormap? (integer->colormap i))
		   (return (integer->colormap i))))))))
(if (and with-gui
	 (not (colormap? better-colormap)))
    (set! better-colormap
	  (call-with-exit
	   (lambda (return)
	     (do ((i good-colormap (+ i 1)))
		 ((= i 20))
	       (if (colormap? (integer->colormap i))
		   (return (integer->colormap i))))))))

(define (snd_test_1)
  (when with-gui
    (letrec ((test-defaults
	      (lambda (lst)
		(when (pair? lst)
		  (if (and (not (or (equal? (cadr lst) (caddr lst))
				    (and (pair? (caddr lst))
					 (member (cadr lst) (caddr lst)))))
			   (or (not (number? (caddr lst)))
			       (rational? (caddr lst))
			       (fneq (cadr lst) (caddr lst)))) ; right! not my fault!
		      (snd-display "~A is not ~A (~A)" (car lst) (caddr lst) (cadr lst)))
		  (test-defaults (cdddr lst))))))
      
      (for-each close-sound (sounds)) ; in case others opened elsewhere
      (test-defaults
       (list
	'amp-control (without-errors (amp-control)) 'no-such-sound
	'amp-control-bounds (cadr (amp-control-bounds)) 8.0
	'ask-about-unsaved-edits *ask-about-unsaved-edits* #f 
	'ask-before-overwrite *ask-before-overwrite* #f 
	'auto-resize *auto-resize* #t 
	'auto-update *auto-update* #f
	'auto-update-interval *auto-update-interval* 60.0 
	'beats-per-measure *beats-per-measure* 4
	'beats-per-minute *beats-per-minute* 60.0
	'channel-style *channel-style* 1
	'clipping *clipping* #f 
	'clm-table-size *clm-table-size* 512
	'color-cutoff *color-cutoff* '(0.003 0.001)
	'color-inverted *color-inverted* #t
	'color-scale *color-scale* 1.0 
	'colormap *colormap* (list hot-colormap jet-colormap)
	'contrast-control (without-errors (contrast-control)) 'no-such-sound
	'contrast-control-amp *contrast-control-amp* 1.0
	'contrast-control-bounds (cadr (contrast-control-bounds)) 10.0
	'contrast-control? (without-errors (contrast-control?)) 'no-such-sound
	'cursor-location-offset *cursor-location-offset* 0
	'cursor-size *cursor-size* 15
	'cursor-style *cursor-style* cursor-cross
	'cursor-update-interval *cursor-update-interval* 0.05
	'dac-combines-channels *dac-combines-channels* #t
	'dac-size *dac-size* 256 
	'default-output-chans *default-output-chans* 1 
	'default-output-sample-type *default-output-sample-type* mus-ldouble
	'default-output-header-type *default-output-header-type* mus-next
	'default-output-srate *default-output-srate* 44100
	'dot-size *dot-size* 1 
	'enved-base *enved-base* 1.0 
	'enved-clip? (enved-clip?) #t
	'enved-envelope (enved-envelope) ()
	'enved-filter (enved-filter) #t
	'enved-filter-order *enved-filter-order* 40
	'enved-in-dB (enved-in-dB) #f 
	'enved-power *enved-power* 3.0
	'enved-style *enved-style* envelope-linear
	'enved-target *enved-target* 0 
	'enved-wave? *enved-wave?* #f 
	'eps-bottom-margin *eps-bottom-margin* 0.0
	'eps-file *eps-file* "snd.eps" 
	'eps-left-margin *eps-left-margin* 0.0
	'eps-size *eps-size* 1.0
	'expand-control (without-errors (expand-control)) 'no-such-sound
	'expand-control-bounds (cadr (expand-control-bounds)) 20.0
	'expand-control-hop *expand-control-hop* 0.05
	'expand-control-jitter *expand-control-jitter* 0.1
	'expand-control-length *expand-control-length* 0.15
	'expand-control-ramp *expand-control-ramp* 0.4
	'expand-control? (without-errors (expand-control?)) 'no-such-sound
	'fft-log-frequency *fft-log-frequency* #f 
	'fft-log-magnitude *fft-log-magnitude* #f 
	'fft-with-phases *fft-with-phases* #f 
	'fft-window *fft-window* 6 
	'fft-window-alpha *fft-window-alpha* 0.0 
	'fft-window-beta *fft-window-beta* 0.0 
	'filter-control-coeffs (without-errors (filter-control-coeffs)) 'no-such-sound
	'filter-control-envelope (without-errors (filter-control-envelope)) 'no-such-sound
	'filter-control-in-dB *filter-control-in-dB* #f
	'filter-control-in-hz *filter-control-in-hz* #f
	'filter-control-order *filter-control-order* 20
	'filter-control? (without-errors (filter-control?)) 'no-such-sound
	'graph-cursor *graph-cursor* 34
	'graph-style *graph-style* graph-lines
	'graphs-horizontal *graphs-horizontal* #t
	'grid-density *grid-density* 1.0
	'html-dir *html-dir* "."
	'html-program *html-program* "firefox"
	'initial-beg *initial-beg* 0.0
	'initial-dur *initial-dur* 0.1
	'just-sounds *just-sounds* #t
	'ladspa-dir *ladspa-dir* ""
	'peak-env-dir *peak-env-dir* (list "" "/home/bil/peaks")
	'lisp-graph? (without-errors (lisp-graph?)) 'no-such-sound
	'log-freq-start *log-freq-start* 32.0	
	'mark-tag-height *mark-tag-height* 4
	'mark-tag-width *mark-tag-width* 10
	'max-regions *max-regions* 16 
	'max-transform-peaks *max-transform-peaks* 100
	'min-dB *min-dB* -60.0 
	'mix-tag-height *mix-tag-height* 14
	'mix-tag-width *mix-tag-width* 6
	'mix-waveform-height *mix-waveform-height* 20 
	'mus-array-print-length *mus-array-print-length* 8
	'mus-clipping (mus-clipping) #f
	'mus-float-equal-fudge-factor *mus-float-equal-fudge-factor* .0000001
	'play-arrow-size *play-arrow-size* 10
	'print-length *print-length* '(12 32)
	'read-only (without-errors (read-only)) 'no-such-sound
	'region-graph-style *region-graph-style* graph-lines
	'remember-sound-state *remember-sound-state* #f
	'reverb-control-feedback *reverb-control-feedback* 1.09
	'reverb-control-length (without-errors (reverb-control-length)) 'no-such-sound
	'reverb-control-length-bounds (cadr (reverb-control-length-bounds)) 5.0
	'reverb-control-lowpass *reverb-control-lowpass* 0.7
	'reverb-control-scale (without-errors (reverb-control-scale)) 'no-such-sound
	'reverb-control-scale-bounds (cadr (reverb-control-scale-bounds)) 4.0
	'reverb-control? (without-errors (reverb-control?)) 'no-such-sound
	'save-as-dialog-auto-comment *save-as-dialog-auto-comment* #f
	'save-as-dialog-src *save-as-dialog-src* #f
	'save-state-file *save-state-file* "saved-snd.scm" 
	'selection-creates-region *selection-creates-region* #t 
	'show-axes *show-axes* 1
	'show-controls *show-controls* #f
	'show-full-duration *show-full-duration* '(#f #t)
	'show-full-range *show-full-range* #f 
	'show-grid *show-grid* #f 
	'show-indices *show-indices* '(#f #t)
	'show-marks *show-marks* #t 
	'show-mix-waveforms *show-mix-waveforms* #t
	'show-selection-transform *show-selection-transform* #f 
	'show-sonogram-cursor *show-sonogram-cursor* #f 
	'show-transform-peaks *show-transform-peaks* '(#f #t)
	'show-y-zero *show-y-zero* #f 
	'sinc-width *sinc-width* 10 
	'spectrum-end *spectrum-end* 1.0
	'spectro-hop *spectro-hop* 4 
	'spectrum-start *spectrum-start* 0.0 
	'spectro-x-angle *spectro-x-angle* (if (provided? 'gl) 300.0 90.0)
	'spectro-x-scale *spectro-x-scale* (if (provided? 'gl) 1.5 1.0)
	'spectro-y-angle *spectro-y-angle* (if (provided? 'gl) 320.0 0.0)
	'spectro-y-scale *spectro-y-scale* 1.0 
	'spectro-z-angle *spectro-z-angle* (if (provided? 'gl) 0.0 358.0)
	'spectro-z-scale *spectro-z-scale* (if (provided? 'gl) 1.0 0.1)
	'speed-control (without-errors (speed-control)) 'no-such-sound
	'speed-control-bounds (cadr (speed-control-bounds)) 20.0
	'sync (without-errors (sync)) 'no-such-sound
	'sync-style *sync-style* sync-by-sound
	'temp-dir *temp-dir* (list "" "/home/bil/zap/tmp")
	'time-graph-type *time-graph-type* graph-once
	'time-graph? (without-errors (time-graph?)) 'no-such-sound
	'tiny-font *tiny-font* (if (provided? 'snd-motif) "6x12" "Sans 8")
	'tracking-cursor-style *tracking-cursor-style* cursor-line
	'transform-graph-type *transform-graph-type* graph-once
	'transform-graph? (without-errors (transform-graph?)) 'no-such-sound
	'transform-normalization *transform-normalization* normalize-by-channel
	'transform-size *transform-size* *transform-size*
	'transform-type *transform-type* fourier-transform
	'wavelet-type *wavelet-type* 0 
	'wavo-hop *wavo-hop* 3 
	'wavo-trace *wavo-trace* 64 
	'with-mix-tags *with-mix-tags* #t
	'with-relative-panes *with-relative-panes* #t
	'with-verbose-cursor *with-verbose-cursor* '(#f #t)
	'with-inset-graph *with-inset-graph* '(#f #t)
	'with-interrupts *with-interrupts* #t
	'with-smpte-label *with-smpte-label* #f
	'with-toolbar *with-toolbar* '(#f #t)
	'with-tooltips *with-tooltips* #t
	'with-menu-icons *with-menu-icons* '(#f #t)
	'with-pointer-focus *with-pointer-focus* '(#f #t)
	'x-axis-style *x-axis-style* 0 
	'zero-pad *zero-pad* 0
	'zoom-focus-style *zoom-focus-style* 2))
      (if *snd-opened-sound* (snd-display "*snd-opened-sound*: ~A" *snd-opened-sound*))

      (let ((s (open-sound "oboe.snd")))
	(letrec ((test-vars
		  (lambda (lst)
		    (when (pair? lst)
		      (let* ((args (car lst))
			     (name (args 0))
			     (getfnc (symbol->value name))
			     (setfnc (lambda (val) (set! (getfnc) val)))
			     (initval (args 1))
			     (newval (args 2))
			     (star-name (symbol "*" (symbol->string name) "*")))
			(setfnc newval)
			(let ((nowval (symbol->value star-name)))
			  (if (and (not (or (equal? newval nowval)
					    (and (list? newval)
						 (feql newval nowval))))
				   (or (not (number? newval))
				       (rational? newval)
				       (> (abs (- newval nowval)) 0.01)))
			      (snd-display "~A is not ~A (~A)" star-name newval nowval))
			  ;(eval `(set! ,star-name ,initval))
			  (apply set! star-name initval ())
			  (if (not (morally-equal? (getfnc) initval))
			      (snd-display "* ~A is not ~A" name initval))
			  (eval `(set! ,star-name ,newval))
			  (let ((nowval (getfnc)))
			    (if (and (not (or (equal? newval nowval)
					      (and (list? newval)
						   (feql newval nowval))))
				     (or (not (number? newval))
					 (rational? newval)
					 (> (abs (- newval nowval)) 0.01)))
				(snd-display "set! ~A is not ~A (~A)" star-name newval nowval))
			    (setfnc initval))
			  (test-vars (cdr lst))))))))
	  (test-vars 
	   (list
	    (list 'ask-about-unsaved-edits #f #t)
	    (list 'ask-before-overwrite #f #t)
	    (list 'auto-resize #t #f)
	    (list 'auto-update #f #t)
	    (list 'auto-update-interval 60.0 120.0)
	    (list 'beats-per-measure 1 120)
	    (list 'beats-per-minute 30.0 120.0)
	    (list 'channel-style 0 1)
	    (list 'clipping #f #t)
	    (list 'color-cutoff 0.003 0.01)
	    (list 'color-inverted #t #f)
	    (list 'color-scale 1.0 0.5)
	    (list 'contrast-control-amp 1.0 0.5)
	    (list 'cursor-location-offset 0 32768)
	    (list 'cursor-size 15 30)
	    (list 'cursor-style cursor-cross cursor-line)
	    (list 'cursor-update-interval 0.05 0.10)
	    (list 'dac-combines-channels #t #f)
	    (list 'dac-size 256 512)
	    (list 'default-output-chans 1 2)
	    (list 'default-output-header-type mus-next mus-aifc)
	    (list 'default-output-sample-type 1 1)
	    (list 'default-output-srate 22050 44100)
	    (list 'dot-size 1 4)
	    (list 'enved-base 1.0  1.5)
	    (list 'enved-filter-order 40 20)
	    (list 'enved-power 3.0 3.5)
	    (list 'enved-style envelope-linear envelope-exponential)
	    (list 'enved-target 0 1)
	    (list 'enved-wave? #f #t)
	    (list 'eps-bottom-margin 0.0 36.0)
	    (list 'eps-file "snd.eps" "snd-1.eps")
	    (list 'eps-left-margin 0.0 72.0)
	    (list 'eps-size 1.0 2.0)
	    (list 'expand-control-hop 0.05 0.1)
	    (list 'expand-control-jitter 0.1 0.2)
	    (list 'expand-control-length 0.15 0.2)
	    (list 'expand-control-ramp 0.4 0.2)
	    (list 'fft-log-frequency #f #t)
	    (list 'fft-log-magnitude #f #t)
	    (list 'fft-window 6 5)
	    (list 'fft-window-alpha 0.0  1.0)
	    (list 'fft-window-beta 0.0  0.5)
	    (list 'fft-with-phases #f #t)
	    (list 'filter-control-in-dB #f #t)
	    (list 'filter-control-in-hz #f #t)
	    (list 'filter-control-order 20 40)
	    (list 'graph-style 0 1)
	    (list 'grid-density 1.0 0.5)
	    (list 'initial-beg 0.0 1.0)
	    (list 'initial-dur 0.1 1.0)
	    (list 'just-sounds #f #t)
	    (list 'listener-prompt ">" ":")
	    (list 'log-freq-start 32.0 10.0)
	    (list 'mark-tag-height 4 20)
	    (list 'mark-tag-width 10 20)
	    (list 'max-regions 16 6)
	    (list 'max-transform-peaks 100 10)
	    (list 'min-dB -60.0 -90.0)
	    (list 'mix-tag-height 14 20)
	    (list 'mix-tag-width 6 20)
	    (list 'mix-waveform-height 20 40)
	    (list 'play-arrow-size 10 16)
	    (list 'print-length 12 16)
	    (list 'region-graph-style graph-lines graph-lollipops)
	    (list 'reverb-control-decay 1.0 2.0)
	    (list 'reverb-control-feedback 1.09 1.6)
	    (list 'reverb-control-lowpass 0.7 0.9)
	    (list 'selection-creates-region #t #f)
	    (list 'show-axes 1 0)
	    (list 'show-full-duration #f #t)
	    (list 'show-full-range #f #t)
	    (list 'show-grid #f #t)
	    (list 'show-indices #f #t)
	    (list 'show-marks #t #f)
	    (list 'show-mix-waveforms #t #f)
	    (list 'show-selection-transform #f #t)
	    (list 'show-sonogram-cursor #f #t)
	    (list 'show-transform-peaks #f #t)
	    (list 'show-y-zero #f #t)
	    (list 'sinc-width 10 40)
	    (list 'spectro-hop 4 10)
	    (list 'spectro-x-angle (if (provided? 'gl) 300.0 90.0) 60.0)
	    (list 'spectro-x-scale (if (provided? 'gl) 1.5 1.0) 2.0)
	    (list 'spectro-y-angle (if (provided? 'gl) 320.0 0.0) 60.0)
	    (list 'spectro-y-scale 1.0 2.0)
	    (list 'spectro-z-angle (if (provided? 'gl) 0.0 358.0) 60.0)
	    (list 'spectro-z-scale (if (provided? 'gl) 1.0 0.1) 0.2)
	    (list 'spectrum-end 1.0 0.7)
	    (list 'spectrum-start 0.0 0.1)
	    (list 'speed-control-style 0 1)
	    (list 'speed-control-tones 12 18)
	    (list 'stdin-prompt ">" "")
	    (list 'sync-style sync-by-sound sync-all)
	    (list 'time-graph-type graph-once graph-as-wavogram)
	    (list 'tiny-font (if (provided? 'snd-gtk) (values "Sans 8" "Monospace 10") (values "6x12" "9x15")))
	    (list 'tracking-cursor-style cursor-line cursor-cross)
	    (list 'transform-graph-type graph-once graph-as-sonogram)
	    (list 'transform-normalization normalize-by-channel dont-normalize)
	    (list 'transform-size 512 1024)
	    (list 'wavelet-type 0 1)
	    (list 'wavo-hop 3 6)
	    (list 'wavo-trace 64 128)
	    (list 'with-gl (provided? 'gl) #f)
	    (list 'with-relative-panes #t #f)
	    (list 'with-verbose-cursor #f #t)
	    (list 'x-axis-style 0 1)
	    (list 'zero-pad 0 1)
	    (list 'zoom-focus-style 2 1))))
	(close-sound s)))

    (set! *ask-about-unsaved-edits* #f)
    (set! *remember-sound-state* #f)))

(set! (with-mix-tags) #t) ; assumed in test 16(!)
(set! *default-output-sample-type* mus-ldouble)


;;; ---------------- test 2: headers ----------------
(define (snd_test_2)
  (when (string? sf-dir)
    (letrec ((test-headers
	      (lambda (base-files)
		(when (pair? base-files)
		  (let* ((testf (car base-files))
			 (file (string-append sf-dir (testf 0))))
		    (if (not (file-exists? file))
			(snd-display "~A missing?" file)
			(begin
			  (if (not (eqv? (mus-sound-chans file) (testf 1)))
			      (snd-display "~A: chans ~A is not ~A" 
					   (testf 0) 
					   (mus-sound-chans file) 
					   (testf 1)))
			  (if (not (eqv? (mus-sound-srate file) (testf 2)))
			      (snd-display "~A: srate ~A is not ~A" 
					   (testf 0) 
					   (mus-sound-srate file) 
					   (testf 2)))
			  (if (fneq (mus-sound-duration file) (testf 3))
			      (snd-display "~A: duration ~A is not ~A" 
					   (testf 0)
					   (mus-sound-duration file) 
					   (testf 3)))
			  (if (not (or (= (mus-sound-sample-type file) mus-unknown-sample)
				       (= (mus-sound-header-type file) 27)
				       (>= (+ (mus-sound-length file) 1)
					   (* (mus-sound-datum-size file) (mus-sound-duration file) (mus-sound-srate file)
					      (mus-sound-chans file)))))
			      (snd-display "mus-sound-length ~A: ~A (~A)" file
					   (mus-sound-length file)
					   (* (mus-sound-duration file) (mus-sound-srate file) 
					      (mus-sound-chans file) (mus-sound-datum-size file))))
			  (if (fneq (/ (mus-sound-framples file) (mus-sound-srate file)) (mus-sound-duration file))
			      (snd-display "mus-sound-framples ~A: ~A (~A ~A)" file
					   (mus-sound-framples file)
					   (mus-sound-duration file)
					   (/ (mus-sound-framples file) (mus-sound-srate file))))
			  (if (> (abs (- (mus-sound-framples file) (/ (mus-sound-samples file) (mus-sound-chans file)))) 1)
			      (snd-display "mus-sound-samples ~A: ~A ~A" file
					   (mus-sound-samples file)
					   (* (mus-sound-framples file) (mus-sound-chans file))))
			  (if (not (equal? (mus-header-type-name (mus-sound-header-type file)) (testf 4)))
			      (snd-display "~A: type ~A is not ~A" 
					   (testf 0) 
					   (mus-header-type-name (mus-sound-header-type file))
					   (testf 4)))
			  (if (not (equal? (mus-sample-type-name (mus-sound-sample-type file)) (testf 5)))
			      (snd-display "~A: type ~A is not ~A"
					   (testf 0) 
					   (mus-sample-type-name (mus-sound-sample-type file)) 
					   (testf 5)))
			  (let ((lst (mus-sound-loop-info file)))
			    (if (> (length testf) 6)
				(begin
				  (if (not (equal? (car lst) (testf 6))) 
				      (snd-display "~A: loop start: ~A" (car lst) (testf 6)))
				  (if (not (equal? (cadr lst) (testf 7))) 
				      (snd-display "~A: loop end: ~A" (cadr lst) (testf 7))))
				(if (pair? lst)
				    (snd-display "~A thinks it has loop info: ~A" file lst))))
			  (mus-sound-forget file)))
		    (test-headers (cdr base-files)))))))
      
      ;; need to make sure raw defaults are consistent with following tests
      (let ((ind (open-raw-sound :file (string-append sf-dir "addf8.nh") :channels 2 :srate 44100 :sample-type mus-bshort)))
	(if (sound? ind) (close-sound ind)))
      (catch #t
	(lambda ()
	  (if (not (= (mus-sound-header-type (string-append sf-dir "midi60.mid")) -1)) (snd-display "midi60?")))
	(lambda args args))
      (test-headers
       (list
	(list "5_secs.aiff" 1 44100 5.303107 "AIFF" "big endian short (16 bits)")
	(list "8svx-8.snd" 1 22050 1.88766443729401 "SVX8" "signed byte (8 bits)")
	(list "Fnonull.aif" 1 8000 0.00112499995157123 "AIFC" "mulaw (8 bits)")
	(list "Pmiscck.aif" 1 8000 0.00112499995157123 "AIFC" "mulaw (8 bits)")
	(list "Pmiscck.wav" 1 8000 0.00112499995157123 "RIFF" "mulaw (8 bits)")
					;	    (list "Pnossnd.aif" 1 8000 0.0 "AIFC" "mulaw (8 bits)")
	(list "Poffset.aif" 1 8000 0.00112499995157123 "AIFC" "mulaw (8 bits)")
	(list "Porder.aif" 1 8000 0.00112499995157123 "AIFC" "mulaw (8 bits)")
	(list "Ptjunk.aif" 1 8000 0.00112499995157123 "AIFC" "mulaw (8 bits)")
	(list "Ptjunk.wav" 1 8000 0.00112499995157123 "RIFF" "mulaw (8 bits)")
	(list "SINE24-S.WAV" 2 44100 2.0 "RIFF" "little endian int (24 bits)")
	(list "a1.asf" 1 16000 3.73656249046326 "asf" "unknown")
	(list "a2.asf" 1 8000 4.63062477111816 "asf" "unknown")
	(list "addf8.afsp" 1 8000 2.9760000705719 "Sun/Next" "big endian short (16 bits)")
	(list "addf8.d" 1 8000 2.9760000705719 "SPPACK" "big endian short (16 bits)")
	(list "addf8.dwd" 1 8000 2.9760000705719 "DiamondWare" "little endian short (16 bits)")
	(list "addf8.nh" 2 44100 0.269931972026825 "raw (no header)" "big endian short (16 bits)")
	(list "addf8.sd" 1 8000 2.9760000705719 "ESPS" "big endian short (16 bits)")
	(list "addf8.sf_mipseb" 1 8000 2.9760000705719 "IRCAM" "big endian short (16 bits)")
	(list "addf8.sf_sun" 1 8000 2.9760000705719 "IRCAM" "big endian short (16 bits)")
	(list "addf8.sf_vax_b" 1 8000 2.9760000705719 "IRCAM" "big endian short (16 bits)")
	(list "addf8.wav" 1 8000 2.9760000705719 "RIFF" "little endian short (16 bits)")
	(list "aebass.krz" 1 44100 3.0 "Kurzweil 2000" "big endian short (16 bits)")
	(list "aiff-16.snd" 2 44100 0.746666669845581 "AIFF" "big endian short (16 bits)")
	(list "aiff-8.snd" 2 44100 0.746666669845581 "AIFF" "signed byte (8 bits)")
	(list "alaw.aifc" 1 44100 0.0367800444364548 "AIFC" "alaw (8 bits)")
	(list "alaw.wav" 1 11025 8.70666694641113 "RIFF" "alaw (8 bits)")
	(list "astor_basia.mp2" 2 44100 1.02179133892059 "raw (no header)" "big endian short (16 bits)")
	(list "c.asf" 1 8000 21.3681259155273 "asf" "unknown")
	(list "ce-c3.w02" 1 33000 3.88848495483398 "TX-16W" "unknown")
	(list "ce-c4.w03" 1 33000 2.91618180274963 "TX-16W" "unknown")
	(list "ce-d2.w01" 1 33000 3.46439385414124 "TX-16W" "unknown")
	(list "clbonef.wav" 1 22050 2.57832193374634 "RIFF" "little endian float (32 bits)")
	(list "cranker.krz" 1 44100 3.48267579078674 "Kurzweil 2000" "big endian short (16 bits)")
	(list "d40130.aif" 1 10000 0.100000001490116 "AIFF" "big endian short (16 bits)")
	(list "d40130.au" 1 10000 0.100000001490116 "Sun/Next" "big endian short (16 bits)")
	(list "d40130.dsf" 1 8000 0.125 "Delusion" "little endian short (16 bits)")
	(list "d40130.fsm" 1 8000 0.125249996781349 "Farandole" "little endian short (16 bits)")
	(list "d40130.iff" 1 10000 0.100000001490116 "SVX8" "signed byte (8 bits)")
	(list "d40130.pat" 1 10000 0.100000001490116 "Gravis Ultrasound patch" "little endian short (16 bits)")
	(list "d40130.sds" 1 10000 0.100000001490116 "MIDI sample dump" "unknown")
	(list "d40130.sdx" 1 10000 0.100000001490116 "Sample dump" "unsigned little endian short (16 bits)")
	(list "d40130.sf" 1 10000 0.100000001490116 "IRCAM" "little endian short (16 bits)")
	(list "d40130.smp" 1 8000 0.125 "SMP" "little endian short (16 bits)")
	(list "d40130.sou" 1 8000 0.125 "SBStudioII" "little endian short (16 bits)")
	(list "d40130.st3" 1 8000 0.125 "Digiplayer ST3" "unsigned little endian short (16 bits)")
	(list "d40130.uwf" 1 8000 0.125249996781349 "Ultratracker" "little endian short (16 bits)")
	(list "d40130.voc" 1 10000 0.100100003182888 "VOC" "unsigned byte (8 bits)")
	(list "d40130.w00" 1 16000 0.0625 "TX-16W" "unknown")
	(list "d40130.wav" 1 10000 0.100000001490116 "RIFF" "little endian short (16 bits)")
	(list "d43.wav" 1 10000 0.100000001490116 "RIFF" "little endian short (16 bits)")
	(list "digit0v0.aiff" 1 8000 0.560000002384186 "AIFC" "big endian short (16 bits)")
	(list "esps-16.snd" 1 8000 3.09737491607666 "ESPS" "big endian short (16 bits)")
	(list "forest.aiff" 2 44100 3.907143 "AIFF" "big endian short (16 bits)" 24981 144332)
					;	  (list "g721.au" 1 11025 4.35328817367554 "Sun/Next" "unknown")
					;	  (list "g722.aifc" 1 44100 0.0184353739023209 "AIFC" "unknown")
	(list "gong.wve" 1 8000 3.96799993515015 "PSION" "alaw (8 bits)")
	(list "gsm610.wav" 1 11025 1.7687075138092 "RIFF" "unknown")
	(list "inrs-16.snd" 1 8000 2.46399998664856 "INRS" "little endian short (16 bits)")
	(list "kirk.wve" 1 8000 1.40799999237061 "PSION" "alaw (8 bits)")
	(list "loop.aiff" 1 44100 0.0367120169103146 "AIFC" "big endian short (16 bits)" 12 23)
	(list "m.asf" 1 8000 64.9646224975586 "asf" "unknown")
	(list "mary-sun4.sig" 1 8000 4.47612476348877 "Comdisco SPW signal" "big endian double (64 bits)")
	(list "mocksong.wav" 1 11025 7.86956930160522 "RIFF" "little endian short (16 bits)")
	(list "mono24.wav" 1 22050 1.98997735977173 "RIFF" "little endian int (24 bits)")
	(list "msadpcm.wav" 1 11025 4.43501138687134 "RIFF" "unknown")
	(list "n8.snd" 1 44100 0.0367800444364548 "Sun/Next" "signed byte (8 bits)")
	(list "nasahal.aif" 1 11025 9.89841270446777 "AIFF" "signed byte (8 bits)")
	(list "nasahal.avi" 1 11025 10.4327440261841 "AVI" "little endian short (16 bits)")
	(list "nasahal.dig" 1 11025 9.89841270446777 "Sound Designer 1" "big endian short (16 bits)")
	(list "nasahal.ivc" 2 44100 0.449002265930176 "raw (no header)" "big endian short (16 bits)")
	(list "nasahal.pat" 1 11025 3.95410442352295 "Gravis Ultrasound patch" "unsigned byte (8 bits)")
	(list "nasahal.snd" 1 11025 9.89841270446777 "SNDT" "unsigned byte (8 bits)")
	(list "nasahal.svx" 1 11025 9.89841270446777 "SVX8" "signed byte (8 bits)")
	(list "nasahal.v8" 1 8000 13.6412496566772 "Covox V8" "unsigned byte (8 bits)")
	(list "nasahal.voc" 1 11025 9.89941024780273 "VOC" "unsigned byte (8 bits)")
	(list "nasahal.vox" 2 44100 0.224444448947906 "raw (no header)" "big endian short (16 bits)")
	(list "nasahal8.wav" 1 11025 9.89841270446777 "RIFF" "unsigned byte (8 bits)")
	(list "nasahalad.smp" 1 11025 4.94920635223389 "Goldwave sample" "little endian short (16 bits)")
	(list "next-16.snd" 1 22050 1.00004529953003 "Sun/Next" "big endian short (16 bits)")
	(list "next-8.snd" 1 22050 0.226757362484932 "Sun/Next" "signed byte (8 bits)")
	(list "next-dbl.snd" 1 22050 0.226757362484932 "Sun/Next" "big endian double (64 bits)")
	(list "oboe.ldbl" 1 22050 2.30512475967407 "RIFF" "little endian double (64 bits)")
	(list "next-flt.snd" 1 22050 0.226757362484932 "Sun/Next" "big endian float (32 bits)")
	(list "aifc-float.snd" 1 22050 0.226757362484932 "AIFC" "big endian float (32 bits)")
	(list "next-mulaw.snd" 1 8012 2.03295063972473 "Sun/Next" "mulaw (8 bits)")
	(list "next24.snd" 1 44100 0.0367800444364548 "Sun/Next" "big endian int (24 bits)")
	(list "nist-01.wav" 1 16000 2.26912498474121 "NIST" "little endian short (16 bits)")
	(list "nist-10.wav" 1 16000 2.26912498474121 "NIST" "big endian short (16 bits)")
	(list "nist-16.snd" 1 16000 1.02400004863739 "NIST" "big endian short (16 bits)")
	(list "nist-shortpack.wav" 1 16000 4.53824996948242 "NIST" "unknown")
	(list "none.aifc" 1 44100 0.0367800444364548 "AIFC" "big endian short (16 bits)")
	(list "nylon2.wav" 2 22050 1.14376413822174 "RIFF" "unknown")
	(list "o2.adf" 1 44100 0.036780 "CSRE adf" "little endian short (16 bits)")
	(list "o2.avr" 1 44100 0.0183900222182274 "AVR" "big endian short (16 bits)")
	(list "o2.bicsf" 1 44100 0.0367800444364548 "IRCAM" "big endian short (16 bits)")
	(list "o2.mpeg1" 2 44100 0.00709750549867749 "raw (no header)" "big endian short (16 bits)")
	(list "o2.sd2" 2 44100 0.0183900222182274 "raw (no header)" "big endian short (16 bits)")
	(list "o2.sf2" 1 44100 0.0367800444364548 "SoundFont" "little endian short (16 bits)")
	(list "o2.smp" 1 8000 0.202749997377396 "SMP" "little endian short (16 bits)")
	(list "o2.voc" 1 44100 0.0368934236466885 "VOC" "little endian short (16 bits)")
	(list "o2.wave" 1 44100 0.0367800444364548 "RIFF" "little endian short (16 bits)")
	(list "o2_12bit.aiff" 1 44100 0.0367800444364548 "AIFF" "big endian short (16 bits)")
	(list "o2_18bit.aiff" 1 44100 0.0367800444364548 "AIFF" "big endian int (24 bits)")
					;	  (list "o2_711u.wave" 1 44100 0.0367800444364548 "RIFF" "mulaw (8 bits)")
					;	  (list "o2_722.snd" 1 44100 0.0183900222182274 "Sun/Next" "unknown")
					;	  (list "o2_726.aiff" 1 8000 0.0367499999701977 "AIFC" "unknown")
					;	  (list "o2_726.snd" 1 44100 0.0230158735066652 "Sun/Next" "unknown")
					;	  (list "o2_728.aiff" 1 8000 0.0367499999701977 "AIFC" "unknown")
	(list "o2_8.iff" 1 44100 0.0367800444364548 "SVX8" "signed byte (8 bits)")
	(list "o2_8.voc" 1 44100 0.0370294786989689 "VOC" "unsigned byte (8 bits)")
	(list "o2_dvi.wave" 1 44100 0.0232199542224407 "RIFF" "unknown")
	(list "o2_float.bicsf" 1 44100 0.0367800444364548 "IRCAM" "big endian float (32 bits)")
	(list "o2_gsm.aiff" 1 8000 0.0367499999701977 "AIFC" "unknown")
	(list "o2_u8.avr" 1 44100 0.0367800444364548 "AVR" "unsigned byte (8 bits)")
	(list "o2_u8.wave" 1 44100 0.0367800444364548 "RIFF" "unsigned byte (8 bits)")
	(list "o28.mpc" 1 44100 0.036780 "AKAI 4" "little endian short (16 bits)")
					;	  (list "oboe.g721" 1 22050 1.15287983417511 "Sun/Next" "unknown")
					;	  (list "oboe.g723_24" 1 22050 0.864761888980865 "Sun/Next" "unknown")
					;	  (list "oboe.g723_40" 1 22050 1.44126987457275 "Sun/Next" "unknown")
	(list "oboe.kts" 1 22050 2.305125 "Korg" "big endian short (16 bits)")
	(list "oboe.its" 1 22050 2.305125 "Impulse Tracker" "little endian short (16 bits)")
	(list "oboe.sf2" 1 22050 2.30512475967407 "SoundFont" "little endian short (16 bits)")
	(list "oboe.paf" 1 22050 2.305125 "Ensoniq Paris" "big endian short (16 bits)")
	(list "oboe.pf1" 1 22050 2.305125 "Ensoniq Paris" "little endian short (16 bits)")
	(list "oboe.smp" 1 22050 2.305125 "snack SMP" "little endian short (16 bits)")
	(list "oboe.rf64" 1 22050 2.305125 "rf64" "little endian short (16 bits)")
	(list "oboe-be32.caf" 1 22050 2.305125 "caff" "normalized big endian int (32 bits)")
	(list "oboe-bf64.caf" 1 22050 2.305125 "caff" "big endian double (64 bits)")
	(list "oboe-lf32.caf" 1 22050 2.305125 "caff" "little endian float (32 bits)")
	(list "oboe-ulaw.caf" 1 22050 2.305125 "caff" "mulaw (8 bits)")
	(list "oboe.nsp" 1 22050 2.305125 "CSL" "little endian short (16 bits)")
					;	  (list "oboe.nvf" 1 8000 6.353500 "Creative NVF" "unknown")
	(list "oboe-ulaw.voc" 1 22050 2.305669 "VOC" "mulaw (8 bits)")
	(list "oboe-lf32.sf" 1 22050 2.305669 "IRCAM" "little endian float (32 bits)")
	(list "oboe.wfp" 1 22050 2.305125 "Turtle Beach" "little endian short (16 bits)")
	(list "oboe.sox" 1 22050 2.305125 "Sox" "normalized little endian int (32 bits)")
	(list "oki.snd" 2 44100 0.0041950112208724 "raw (no header)" "big endian short (16 bits)")
	(list "oki.wav" 1 44100 0.016780 "RIFF" "unknown")
	(list "orv-dvi-adpcm.wav" 1 44100 1.92725622653961 "RIFF" "unknown")
	(list "riff-16.snd" 1 22050 1.88766443729401 "RIFF" "little endian short (16 bits)")
	(list "riff-8-u.snd" 1 11025 0.506848096847534 "RIFF" "unsigned byte (8 bits)")
	(list "rooster.wve" 1 8000 2.04800009727478 "PSION" "alaw (8 bits)")
	(list "sd1-16.snd" 1 44100 0.400544226169586 "Sound Designer 1" "big endian short (16 bits)")
					;	    (list "segfault.snd" 16777216 576061440 1.24986669902682e-7 "Sun/Next" "unknown")
	(list "sf-16.snd" 1 22050 1.88766443729401 "IRCAM" "big endian short (16 bits)")
	(list "si654.adc" 1 16000 6.71362495422363 "ADC/OGI" "big endian short (16 bits)")
	(list "smp-16.snd" 1 8000 5.2028751373291 "SMP" "little endian short (16 bits)")
	(list "sound.pat" 1 8000 1.95050001144409 "Gravis Ultrasound patch" "unsigned little endian short (16 bits)")
	(list "sound.sap" 1 8000 1.95050001144409 "Goldwave sample" "little endian short (16 bits)")
	(list "sound.sds" 1 8000 1.95050001144409 "MIDI sample dump" "unknown")
	(list "sound.sfr" 1 8000 1.95050001144409 "SRFS" "little endian short (16 bits)")
	(list "sound.v8" 1 8000 1.95050001144409 "Covox V8" "unsigned byte (8 bits)")
	(list "sound.vox" 2 44100 0.044217687100172 "raw (no header)" "big endian short (16 bits)")
	(list "step.omf" 1 11025 8.70666694641113 "OMF" "signed byte (8 bits)")
	(list "step.qt" 1 11025 8.70630359649658 "Quicktime" "unsigned byte (8 bits)")
	(list "sun-16-afsp.snd" 1 8000 2.9760000705719 "Sun/Next" "big endian short (16 bits)")
	(list "sun-mulaw.snd" 1 8000 4.61950016021729 "Sun/Next" "mulaw (8 bits)")
	(list "sw1038t_short.wav" 2 8000 6.0 "NIST" "mulaw (8 bits)")
	(list "swirl.pat" 1 22050 1.0619500875473 "Gravis Ultrasound patch" "unsigned little endian short (16 bits)")
	(list "sy85.snd" 1 8000 5.05600023269653 "Sy-85" "big endian short (16 bits)")
	(list "sy99.snd" 1 8000 4.54400014877319 "Sy-99" "big endian short (16 bits)")
	(list "telephone.wav" 1 16000 2.27881240844727 "NIST" "little endian short (16 bits)")
	(list "trumps22.adp" 1 22050 3.092880 "RIFF" "unknown")
	(list "truspech.wav" 1 8000 1.1599999666214 "RIFF" "unknown")
	(list "ulaw.aifc" 1 44100 0.0367800444364548 "AIFC" "mulaw (8 bits)")
	(list "voc-8-u.snd" 1 8000 1.49937498569489 "VOC" "unsigned byte (8 bits)")
	(list "o28.voc" 1 44100 0.036893 "VOC" "little endian short (16 bits)")
	(list "voxware.wav" 1 8000 0.324000000953674 "RIFF" "unknown")
	(list "wd.w00" 1 8000 0.202749997377396 "Sy-99" "big endian short (16 bits)")
	(list "wd1.smp" 1 8000 0.202749997377396 "SMP" "little endian short (16 bits)")
	(list "wd1.wav" 1 44100 0.0367800444364548 "RIFF" "little endian short (16 bits)")
	(list "wheel.mat" 2 44100 0.145646259188652 "raw (no header)" "big endian short (16 bits)")
	(list "b8.pvf" 1 44100 0.036803 "Portable Voice Format" "signed byte (8 bits)")
	(list "b16.pvf" 1 44100 0.036803 "Portable Voice Format" "big endian short (16 bits)")
	(list "b32.pvf" 1 44100 0.036803 "Portable Voice Format" "big endian int (32 bits)")
	(list "water.voc" 2 32000 42.3463897705078 "VOC" "little endian short (16 bits)")
	(list "wood.dsf" 1 8000 0.202749997377396 "Delusion" "little endian short (16 bits)")
	(list "wood.dvi" 1 22100 0.0278733037412167 "RIFF" "unknown")
	(list "wood.dwd" 1 22100 0.0733936652541161 "DiamondWare" "signed byte (8 bits)")
	(list "wood.fsm" 1 8000 0.202999994158745 "Farandole" "little endian short (16 bits)")
	(list "wood.mad" 1 22100 0.0372398197650909 "RIFF" "unknown")
	(list "wood.maud" 1 44100 0.0183900222182274 "MAUD" "big endian short (16 bits)")
	(list "wood.pat" 1 22100 0.0733936652541161 "Gravis Ultrasound patch" "little endian short (16 bits)")
	(list "wood.riff" 1 44100 0.0367800444364548 "RIFF" "little endian short (16 bits)")
	(list "wood.rifx" 1 44100 0.0367800444364548 "RIFF" "big endian short (16 bits)")
	(list "wood.sds" 1 22100 0.0733936652541161 "MIDI sample dump" "unknown")
	(list "wood.sdx" 1 22100 0.0733936652541161 "Sample dump" "unsigned little endian short (16 bits)")
	(list "wood.sf" 1 44100 0.0367800444364548 "IRCAM" "big endian short (16 bits)")
	(list "wood.sndr" 2 44100 0.0092290248721838 "raw (no header)" "big endian short (16 bits)")
	(list "wood.sndt" 1 44100 0.0367800444364548 "SNDT" "unsigned byte (8 bits)")
	(list "wood.st3" 1 8000 0.202749997377396 "Digiplayer ST3" "unsigned little endian short (16 bits)")
	(list "wood.uwf" 1 8000 0.202999994158745 "Ultratracker" "little endian short (16 bits)")
	(list "wood.w00" 1 16000 0.101374998688698 "TX-16W" "unknown")
	(list "wood12.aiff" 1 44100 0.0367800444364548 "AIFF" "big endian short (16 bits)")
	(list "wood16.dwd" 2 44100 0.0367800444364548 "DiamondWare" "little endian short (16 bits)")
	(list "wood16.wav" 2 44100 0.0367800444364548 "RIFF" "little endian short (16 bits)")
	(list "wood16.nsp" 2 44100 0.0367800444364548 "CSL" "little endian short (16 bits)")
	(list "wood16.smp" 2 44100 0.0367800444364548 "snack SMP" "little endian short (16 bits)")
	(list "wood24.aiff" 1 44100 0.0367800444364548 "AIFF" "big endian int (24 bits)")
	(list "woodblock.aiff" 1 44100 0.0367800444364548 "AIFF" "big endian short (16 bits)")
	(list "woodflt.snd" 1 44100 0.0367800444364548 "Sun/Next" "big endian float (32 bits)")
	(list "RealDrums.sf2" 1 44100 6.39725637435913 "SoundFont" "little endian short (16 bits)")
	(list "32bit.sf" 1 44100 4.6 "IRCAM" "little endian float (32 bits, unscaled)")
	(list "PCM_48_8bit_m.w64" 1 48000 0.375 "SoundForge" "unsigned byte (8 bits)")
	(list "oboe.sf6" 1 22050 2.305125 "SoundForge" "little endian short (16 bits)")
	(list "addf8.24we" 1 8000 2.976000 "RIFF" "little endian int (24 bits)")
	(list "hybrid.snd" 1 44100 4.600000 "BICSF" "big endian float (32 bits)")
	(list "litmanna.sf" 1 44100 .533 "IRCAM" "little endian short (16 bits)")
	(list "M1F1-float64C-AFsp.aif" 2 8000 2.9366 "AIFC" "big endian double (64 bits)")
	(list "MacBoing.wav" 1 11127 0.696 "RIFF" "unsigned byte (8 bits)")
	(list "t15.aiff" 2 44100 135.00 "AIFC" "little endian short (16 bits)")
	(list "tomf8.aud" 1 8000 2.016000 "INRS" "little endian short (16 bits)")
	(list "Xhs001x.nsp" 1 10000 6.017400 "CSL" "little endian short (16 bits)")
	(list "zulu_a4.w11" 1 33000 1.21987879276276 "TX-16W" "unknown" 23342 40042)))
      
      (for-each (lambda (in-name real-name)
		  (if (not (string=? (mus-expand-filename in-name) real-name))
		      (snd-display "mus-expand-filename ~A -> ~A" in-name (mus-expand-filename in-name)))
		  (if (file-exists? "/home/bil/./sf1/o2.voc")
		      (let ((ind (open-sound in-name)))
			(if (not (sound? ind))
			    (snd-display "can't open ~A" in-name)
			    (begin
			      (if (not (string=? (file-name ind) real-name))
				  (snd-display "expand file name ~A: ~A" in-name (file-name ind)))
			      (close-sound ind))))))
		'("/home/bil/./sf1/o2.voc" "~/./sf1/o2.voc" "~/cl/../sf1/o2.voc" "/home/bil/cl/../sf1/o2.voc")
		'("/home/bil/sf1/o2.voc" "/home/bil/sf1/o2.voc" "/home/bil/sf1/o2.voc" "/home/bil/sf1/o2.voc"))
      
      (let ((lst (mus-sound-mark-info (string-append sf-dir "forest.aiff"))))
	(if (not (equal? lst '((4 0) (3 0) (2 144332) (1 24981))))
	    (snd-display "mus-sound-mark-info forest: ~A" lst)))
      (let ((lst (mus-sound-mark-info (string-append sf-dir "traffic.aiff"))))
	(if (not (equal? lst '((4 1) (3 0) (2 171931) (1 99461))))
	    (snd-display "mus-sound-mark-info traffic: ~A" lst))))))



;;; ---------------- test 3: variables ----------------

(define (snd_test_3)
  (let ((ind (open-sound "oboe.snd")))
    (if (and (file-exists? "funcs.scm") 
	     (not (defined? 'swellf)))
	(load "funcs.scm"))
    (let ((td *temp-dir*))
      (catch #t
	     (lambda ()
	       (set! *temp-dir* (string-append home-dir "/test"))
	       (if (not (string=? *temp-dir* (string-append home-dir "/test")))
		   (snd-display "set temp-dir: ~A?" *temp-dir*)))
	     (lambda args args))
	  (set! *temp-dir* (or td "")))
    (if (fneq (sample 1000) 0.0328) (snd-display "sample: ~A?" (sample 1000)))
    
    (when with-gui
      (set! *show-controls* #t)
      
      (let ((wid (enved-dialog) ))
	(if (not (equal? wid ((dialog-widgets) 1)))
	    (snd-display "enved-dialog -> ~A ~A" wid ((dialog-widgets) 1))))
					;(if (not ((dialog-widgets) 1)) (snd-display "enved-dialog?"))
      (set! (enved-envelope) '(0.0 0.0 1.0 1.0 2.0 0.0))
      (if (not (equal? (enved-envelope) '(0.0 0.0 1.0 1.0 2.0 0.0)))
	  (snd-display "set enved-envelope to self: ~A?" (enved-envelope)))
      
      (letrec ((test-vars
		(lambda (lst)
		  (when (pair? lst)
		    (let* ((arg (car lst))
			   (name (car arg))
			   (getfnc (symbol->value name))
			   (setfnc (lambda (val) (set! (getfnc) val))))
		      (let ((initval (cadr arg))
			    (newval (caddr arg)))
			(setfnc newval)
			(let ((nowval (getfnc)))
			  (if (and (not (or (equal? newval nowval)
					    (and (list? newval)
						 (feql newval nowval))))
				   (or (not (number? newval))
				       (rational? newval)
				       (> (abs (- newval nowval)) 0.01)))
			      (snd-display "~A is not ~A (~A)" name newval nowval))
			  (setfnc initval)
			  (set! (getfnc) newval)
			  (let ((nowval (getfnc)))
			    (if (and (not (or (equal? newval nowval)
					      (and (list? newval)
						   (feql newval nowval))))
				     (or (not (number? newval))
					 (rational? newval)
					 (> (abs (- newval nowval)) 0.01)))
				(snd-display "set! ~A is not ~A (~A)" name newval nowval))
			    (setfnc initval))
			  (test-vars (cdr lst)))))))))
	(test-vars 
	 (list

	  (list 'amp-control 1.0 0.5)
	  (list 'amp-control-bounds (list 0.0 8.0) (list 1.0 5.0))
	  (list 'ask-about-unsaved-edits #f #t)
	  (list 'ask-before-overwrite #f #t)
	  (list 'auto-resize #t #f)
	  (list 'auto-update #f #t)
	  (list 'auto-update-interval 60.0 120.0)
	  (list 'beats-per-measure 1 120)
	  (list 'beats-per-minute 30.0 120.0)
	  (list 'channel-style 0 1)
	  (list 'clipping #f #t)
	  (list 'color-cutoff 0.003 0.01)
	  (list 'color-inverted #t #f)
	  (list 'color-scale 1.0 0.5)
	  (list 'colormap good-colormap better-colormap)
	  (list 'contrast-control 0.0 0.5)
	  (list 'contrast-control-amp 1.0 0.5)
	  (list 'contrast-control-bounds (list 0.0 10.0) (list 1.0 5.0))
	  (list 'contrast-control? #f #t)
	  (list 'cursor-location-offset 0 32768)
	  (list 'cursor-size 15 30)
	  (list 'cursor-style cursor-cross cursor-line)
	  (list 'cursor-update-interval 0.05 0.10)
	  (list 'dac-combines-channels #t #f)
	  (list 'dac-size 256 512)
	  (list 'default-output-chans 1 2)
	  (list 'default-output-header-type mus-next mus-aifc)
	  (list 'default-output-sample-type 1 1)
	  (list 'default-output-srate 22050 44100)
	  (list 'dot-size 1 4)
	  (list 'enved-base 1.0  1.5)
	  (list 'enved-clip? #f #t)
	  (list 'enved-filter #t #f)
	  (list 'enved-filter-order 40 20)
	  (list 'enved-in-dB #f #t)
	  (list 'enved-power 3.0 3.5)
	  (list 'enved-style envelope-linear envelope-exponential)
	  (list 'enved-target 0 1)
	  (list 'enved-wave? #f #t)
	  (list 'eps-bottom-margin 0.0 36.0)
	  (list 'eps-file "snd.eps" "snd-1.eps")
	  (list 'eps-left-margin 0.0 72.0)
	  (list 'eps-size 1.0 2.0)
	  (list 'expand-control 1.0 2.0)
	  (list 'expand-control-bounds (list .001 20.0) (list 1.0 2.0))
	  (list 'expand-control-hop 0.05 0.1)
	  (list 'expand-control-jitter 0.1 0.2)
	  (list 'expand-control-length 0.15 0.2)
	  (list 'expand-control-ramp 0.4 0.2)
	  (list 'expand-control? #f #t)
	  (list 'fft-log-frequency #f #t)
	  (list 'fft-log-magnitude #f #t)
	  (list 'fft-window 6 5)
	  (list 'fft-window-alpha 0.0  1.0)
	  (list 'fft-window-beta 0.0  0.5)
	  (list 'fft-with-phases #f #t)
	  (list 'filter-control-envelope (list 0.0 1.0 1.0 1.0) (list 0.0 1.0 1.0 0.0))
	  (list 'filter-control-in-dB #f #t)
	  (list 'filter-control-in-hz #f #t)
	  (list 'filter-control-order 20 40)
	  (list 'filter-control? #f #t)
	  (list 'graph-cursor 34 32)
	  (list 'graph-style 0 1)
	  (list 'grid-density 1.0 0.5)
	  (list 'initial-beg 0.0 1.0)
	  (list 'initial-dur 0.1 1.0)
	  (list 'just-sounds #f #t)
	  (list 'listener-prompt ">" ":")
	  (list 'log-freq-start 32.0 10.0)
	  (list 'mark-tag-height 4 20)
	  (list 'mark-tag-width 10 20)
	  (list 'max-regions 16 6)
	  (list 'max-transform-peaks 100 10)
	  (list 'min-dB -60.0 -90.0)
	  (list 'mix-tag-height 14 20)
	  (list 'mix-tag-width 6 20)
	  (list 'mix-waveform-height 20 40)
	  (list 'mus-clipping #f #t)
	  (list 'play-arrow-size 10 16)
	  (list 'print-length 12 16)
	  (list 'region-graph-style graph-lines graph-lollipops)
	  (list 'reverb-control-decay 1.0 2.0)
	  (list 'reverb-control-feedback 1.09 1.6)
	  (list 'reverb-control-length 1.0 2.0)
	  (list 'reverb-control-length-bounds (list 0.0 5.0) (list 1.0 2.0))
	  (list 'reverb-control-lowpass 0.7 0.9)
	  (list 'reverb-control-scale 0.0 0.2)
	  (list 'reverb-control-scale-bounds (list 0.0 4.0) (list 0.0 0.2))
	  (list 'reverb-control? #f #t)
	  (list 'selection-creates-region #t #f)
	  (list 'show-axes 1 0)
	  (list 'show-full-duration #f #t)
	  (list 'show-full-range #f #t)
	  (list 'show-grid #f #t)
	  (list 'show-indices #f #t)
	  (list 'show-marks #t #f)
	  (list 'show-mix-waveforms #t #f)
	  (list 'show-selection-transform #f #t)
	  (list 'show-sonogram-cursor #f #t)
	  (list 'show-transform-peaks #f #t)
	  (list 'show-y-zero #f #t)
	  (list 'sinc-width 10 40)
	  (list 'spectro-hop 4 10)
	  (list 'spectro-x-angle (if (provided? 'gl) 300.0 90.0) 60.0)
	  (list 'spectro-x-scale (if (provided? 'gl) 1.5 1.0) 2.0)
	  (list 'spectro-y-angle (if (provided? 'gl) 320.0 0.0) 60.0)
	  (list 'spectro-y-scale 1.0 2.0)
	  (list 'spectro-z-angle (if (provided? 'gl) 0.0 358.0) 60.0)
	  (list 'spectro-z-scale (if (provided? 'gl) 1.0 0.1) 0.2)
	  (list 'spectrum-end 1.0 0.7)
	  (list 'spectrum-start 0.0 0.1)
	  (list 'speed-control 1.0 0.5)
	  (list 'speed-control-bounds (list 0.05 20.0) (list 1.0 5.0))
	  (list 'speed-control-style 0 1)
	  (list 'speed-control-tones 12 18)
	  (list 'stdin-prompt "" ">")
	  (list 'sync 0 1)
	  (list 'sync-style sync-by-sound sync-all)
	  (list 'time-graph-type graph-once graph-as-wavogram)
	  (list 'time-graph? #f #t)
	  (list 'tiny-font (if (provided? 'snd-gtk) (values "Sans 8" "Monospace 10") (values "6x12" "9x15")))
	  (list 'tracking-cursor-style cursor-line cursor-cross)
	  (list 'transform-graph-type graph-once graph-as-sonogram)
	  (list 'transform-graph? #f #t)
	  (list 'transform-normalization normalize-by-channel dont-normalize)
	  (list 'transform-size 512 1024)
	  (list 'transform-type fourier-transform autocorrelation)
	  (list 'wavelet-type 0 1)
	  (list 'wavo-hop 3 6)
	  (list 'wavo-trace 64 128)
	  (list 'with-gl (provided? 'gl) #f)
	  (list 'with-mix-tags #t #f)
	  (list 'with-relative-panes #t #f)
	  (list 'with-tracking-cursor #f #t)
	  (list 'with-verbose-cursor #f #t)
	  (list 'x-axis-style 0 1)
	  (list 'zero-pad 0 1)
	  (list 'zoom-focus-style 2 1))))
      
      (set! *ask-about-unsaved-edits* #f)    
      (letrec ((test-bad-args
		(lambda (lst)
		  (if (pair? lst)
		      (let* ((name ((car lst) 0))
			     (getfnc ((car lst) 1))
			     (setfnc (lambda (val) (set! (getfnc) val)))
			     (initval ((car lst) 2))
			     (newvals ((car lst) 3)))
			(for-each
			 (lambda (n)
			   (catch #t 
			     (lambda ()
			       (setfnc n))
			     (lambda args (car args)))
			   (let ((nowval (getfnc)))
			     (if (equal? n nowval)
				 (snd-display "(bad set) ~A = ~A (~A)" name n initval))
			     (setfnc initval)))
			 newvals)
			(test-bad-args (cdr lst)))))))
	(test-bad-args
	 (list
	  (list 'amp-control amp-control 1.0 '(-1.0 123.123))
	  (list 'amp-control-bounds amp-control-bounds (list 0.0 8.0) (list #f (list 0.0) (list 1.0 0.0) 2.0))
	  (list 'channel-style channel-style 0 '(32 -1 1.0))
	  (list 'colormap colormap good-colormap '(321 -123))
	  (list 'color-cutoff color-cutoff 0.003 '(-1.0 123.123))
	  (list 'color-scale color-scale 1.0 '(-32.0 2000.0))
	  (list 'contrast-control contrast-control 0.0 '(-123.123 123.123))
	  (list 'contrast-control-bounds contrast-control-bounds (list 0.0 10.0) (list #f (list 0.0) (list 1.0 0.0) 2.0))
	  (list 'cursor-size cursor-size 15 '(1.123 -2.5))
	  (list 'dac-size dac-size 256 '(-1 0 -123))
	  (list 'dot-size dot-size 1 '(0 -1 -123))
	  (list 'enved-target enved-target 0 '(123 -321))
	  (list 'expand-control expand-control 1.0 '(-1.0 0.0))
	  (list 'expand-control-bounds expand-control-bounds (list 0.001 20.0) (list #f (list 0.0) (list 1.0 0.0) 2.0))
	  (list 'expand-control-hop expand-control-hop 0.05 '(-1.0))
	  (list 'expand-control-length expand-control-length 0.15 '(-1.0 0.0))
	  (list 'expand-control-ramp expand-control-ramp 0.4 '(-1.0 1.0 123.123))
	  (list 'fft-window-alpha fft-window-alpha 0.0  '(-1.0 123.123))
	  (list 'fft-window-beta fft-window-beta 0.0  '(-1.0 123.123))
	  (list 'transform-size transform-size 512 '(-1 0))
	  (list 'zero-pad zero-pad 0 '(-1 -123))
	  (list 'cursor-style cursor-style cursor-cross '(-1))
	  (list 'cursor-style cursor-style cursor-line '(2 123))
	  (list 'tracking-cursor-style tracking-cursor-style cursor-line '(-1))
	  (list 'tracking-cursor-style tracking-cursor-style cursor-line '(2 123))
	  (list 'transform-graph-type transform-graph-type graph-once '(-1 123))
	  (list 'fft-window fft-window 6 '(-1 123))
	  (list 'enved-filter-order enved-filter-order 40 '(-1 0))
	  (list 'filter-control-order filter-control-order 20 '(-10 -1 0))
	  (list 'max-transform-peaks max-transform-peaks 100 '(-1))
	  (list 'max-regions max-regions 16 '(-1 -123))
	  (list 'reverb-control-length reverb-control-length 1.0 '(-1.0))
	  (list 'show-axes show-axes 1 '(-1 123))
	  (list 'sinc-width sinc-width 10 '(-10))
	  (list 'spectrum-end spectrum-end 1.0 '(-1.0))
	  (list 'spectro-hop spectro-hop 4 '(-10 -1 0))
	  (list 'spectrum-start spectrum-start 0.0 '(-1.0))
	  (list 'speed-control speed-control 1.0 '(0.0))
	  (list 'speed-control-bounds speed-control-bounds (list 0.05 20.0) (list #f (list 0.0) (list 1.0 0.0) 2.0))
	  (list 'speed-control-style speed-control-style 0 '(-1 10))
	  (list 'sync-style sync-style sync-by-sound '(-1 123))
	  (list 'transform-type transform-type fourier-transform (list (integer->transform -1) (integer->transform 123)))
	  (list 'wavelet-type wavelet-type 0 '(-1 123))
	  (list 'wavo-hop wavo-hop 1 '(0 -123))
	  (list 'wavo-trace wavo-trace 1 '(0 -123))
	  (list 'x-axis-style x-axis-style 0 '(-1 123))
	  (list 'zoom-focus-style zoom-focus-style 2 '(-1 123)))))
      
      (set! *sync-style* sync-none)
      
      (set! (window-width) 300)
      (set! (window-height) 300)
      (if (<= (window-width) 30)
	  (snd-display "window width: ~A is not 300?" (window-width)))
      (if (<= (window-height) 30)
	  (snd-display "window height: ~A is not 300?" (window-height)))
      (set! *color-scale* 100.0)
      (if (fneq *color-scale* 100.0) (snd-display "color-scale to 100: ~A" *color-scale*))
      
      (if (procedure? (search-procedure))
	  (snd-display "global search procedure: ~A?" (search-procedure)))
      (set! (search-procedure) (lambda (y) (> y .1)))
      (if (not (procedure? (search-procedure)))
	  (snd-display "set global search procedure: ~A?" (search-procedure)))
      (if (not ((search-procedure) .2))
	  (snd-display "search > .1 .2"))
      (if ((search-procedure) .02)
	  (snd-display "search > .1 .02"))
      (set! (search-procedure) (lambda (y) (< y 0.0)))
      (if ((search-procedure) .02)
	  (snd-display "search < 0.0 .02"))
      (set! (search-procedure) #f)
      (if (procedure? (search-procedure))
	  (snd-display "global search procedure after reset: ~A?" (search-procedure)))
      (set! (search-procedure) (lambda (y) (> y .1)))
      (if (not (procedure? (search-procedure)))
	  (snd-display "set global search procedure: ~A?" (search-procedure)))
      
      (set! *enved-filter-order* 5)
      (if (not (= *enved-filter-order* 6)) (snd-display "set enved-filter-order 5: ~A" *enved-filter-order*))
      (when with-gui
	(set! (enved-envelope) 'zero_to_one) ; funcs.scm above
	(if (not (feql (enved-envelope) zero_to_one)) (snd-display "set symbol enved-envelope: ~A ~A" (enved-envelope) zero_to_one))
	(set! (enved-envelope) "mod_down")
	(if (not (feql (enved-envelope) mod_down)) (snd-display "set string enved-envelope: ~A ~A" (enved-envelope) mod_down)))
      (dismiss-all-dialogs))
    (close-sound ind) 
      
    (let ((undef ())
	  (names '(*snd-opened-sound* abort add-colormap add-mark
		       add-player add-sound-file-extension add-source-file-extension add-to-main-menu add-to-menu
		       add-transform after-apply-controls-hook after-edit-hook after-graph-hook after-lisp-graph-hook
		       after-open-hook after-save-as-hook after-save-state-hook after-transform-hook all-pass
		       all-pass? amp-control amp-control-bounds amplitude-modulate
		       apply-controls array->file array-interp as-one-edit ask-about-unsaved-edits
		       ask-before-overwrite asymmetric-fm asymmetric-fm? 
		       auto-resize auto-update auto-update-interval autocorrelate autocorrelation
		       axis-color axis-info axis-label-font axis-numbers-font
		       bad-header-hook bartlett-window bartlett-hann-window basic-color beats-per-measure beats-per-minute
		       before-close-hook before-exit-hook before-save-as-hook before-save-state-hook before-transform-hook
		       bind-key blackman2-window blackman3-window blackman4-window 
		       blackman5-window blackman6-window blackman7-window blackman8-window blackman9-window blackman10-window 
		       bohman-window bold-peaks-font cauchy-window mlt-sine-window
		       cepstrum change-samples-with-origin channel->float-vector channel-amp-envs 
		       channel-properties channel-property channel-style channel-widgets channels channels-combined
		       channels-separate channels-superimposed chans clear-listener
		       clip-hook clipping clm-channel 
		       clm-table-size close-hook close-sound color->list
		       color-cutoff color-orientation-dialog color-hook color-inverted color-scale
		       color? colormap colormap-name colormap-ref colormap-size
		       colormap? comb comb? combined-data-color comment connes-window
		       continue-frample->file continue-sample->file contrast-control contrast-control-amp contrast-control-bounds
		       contrast-control? contrast-enhancement controls->channel convolution convolve
		       convolve-files convolve-selection-with convolve-with convolve? copy-context
		       copy-sampler current-edit-position
		       current-font cursor cursor-color cursor-context cursor-cross
		       cursor-in-middle cursor-in-view cursor-line cursor-location-offset cursor-on-left
		       cursor-on-right cursor-position cursor-size cursor-style cursor-update-interval
		       dac-combines-channels dac-size data-color sample-type
		       data-location data-size db->linear default-output-chans default-output-sample-type
		       default-output-header-type default-output-srate define-envelope degrees->radians delay
		       delay-tick delay? delete-colormap
		       delete-mark delete-marks delete-sample delete-samples delete-samples-and-smooth
		       delete-selection delete-selection-and-smooth delete-transform dialog-widgets disk-kspace
		       display-edits dolph-chebyshev-window dont-normalize
		       dot-product dot-size draw-axes draw-dot draw-dots
		       draw-line draw-lines draw-mark-hook draw-mix-hook draw-string drop-hook
		       during-open-hook edit-fragment edit-header-dialog edit-hook edit-list->function
		       edit-position edit-tree edits edot-product env
		       env-channel env-channel-with-base env-interp env-selection env-sound
		       env? enved-add-point enved-amplitude enved-base enved-clip?
		       enved-delete-point enved-dialog enved-envelope enved-filter enved-filter-order
		       enved-hook enved-in-dB enved-move-point enved-power enved-spectrum
		       enved-srate enved-style enved-target enved-wave? enved-waveform-color
		       envelope-exponential envelope-linear eps-bottom-margin eps-file
		       eps-left-margin eps-size even-multiple even-weight exit exit-hook
		       expand-control expand-control-bounds expand-control-hop expand-control-jitter expand-control-length
		       expand-control-ramp expand-control? exponential-window fft fft-log-frequency
		       fft-log-magnitude fft-window fft-window-alpha fft-window-beta fft-with-phases file->array
		       file->frample file->frample? file->sample file->sample? file->string
		       file-name file-write-date fill-polygon fill-rectangle filter
		       filtered-comb filtered-comb?
		       filter-channel filter-control-coeffs filter-control-envelope filter-control-in-dB filter-control-in-hz
		       filter-control-order filter-control-waveform-color filter-control? filter-selection filter-sound
		       filter? find-dialog find-mark find-sound
		       finish-progress-report fir-filter fir-filter? flat-top-window focus-widget foreground-color
		       forget-region formant formant-bank formant-bank? formant? firmant firmant? 
		       comb-bank comb-bank? all-pass-bank all-pass-bank? filtered-comb-bank filtered-comb-bank?
		       make-comb-bank make-all-pass-bank make-filtered-comb-bank
		       fourier-transform
		       free-player free-sampler gaussian-window gc-off gc-on
		       ;gl-graph->ps glSpectrogram 
		       goto-listener-end granulate granulate?
		       graph graph->ps graph-as-sonogram graph-as-spectrogram graph-as-wavogram
		       graph-color graph-cursor graph-data graph-dots graph-dots-and-lines
		       graph-filled graph-hook graph-lines graph-lollipops graph-once
		       graph-style graphs-horizontal grid-density haar-transform hamming-window
		       hann-poisson-window hann-window header-type help-dialog
		       help-hook hide-widget highlight-color html-dir html-program
		       hz->radians iir-filter iir-filter? in in-any
		       ina inb info-dialog initial-graph-hook
		       insert-file-dialog insert-region insert-sample insert-samples insert-samples-with-origin
		       insert-selection insert-silence insert-sound just-sounds kaiser-window
		       key key-binding key-press-hook keyboard-no-action  peak-env-dir
;		       ladspa-activate ladspa-cleanup ladspa-connect-port ladspa-deactivate ladspa-descriptor ladspa-dir
;		       ladspa-instantiate ladspa-run ladspa-run-adding ladspa-set-run-adding-gain list-ladspa init-ladspa apply-ladspa analyse-ladspa
		       left-sample
		       linear->db lisp-graph lisp-graph-hook lisp-graph-style lisp-graph?
		       listener-click-hook listener-color listener-font
		       listener-prompt listener-selection listener-text-color little-endian? locsig
		       locsig-ref locsig-reverb-ref locsig-reverb-set! locsig-set! locsig-type
		       locsig? log-freq-start main-menu main-widgets make-all-pass
		       make-asymmetric-fm make-moving-average make-moving-max make-moving-norm make-bezier make-color make-comb make-filtered-comb
		       make-convolve make-delay make-env make-fft-window make-file->frample
		       make-file->sample make-filter make-fir-coeffs make-fir-filter make-formant make-firmant make-formant-bank
		       make-granulate make-graph-data make-iir-filter
		       make-locsig make-mix-sampler make-move-sound make-notch make-one-pole make-one-pole-all-pass
		       make-one-zero make-oscil make-phase-vocoder make-player make-polyshape make-polywave
		       make-pulse-train make-rand make-rand-interp make-readin
		       make-region make-region-sampler make-sample->file make-sampler make-sawtooth-wave
		       make-nrxysin make-nrxycos make-rxyk!cos make-rxyk!sin 
		       make-snd->sample make-square-wave
		       make-src make-ssb-am make-ncos make-nsin make-table-lookup
		       make-triangle-wave make-two-pole make-two-zero
		       make-variable-graph make-float-vector make-wave-train 
		       map-channel mark-click-hook mark-color mark-context
		       mark-drag-hook mark-home mark-hook mark-name mark-properties mark-property
		       mark-sample mark-sync mark-sync-max mark-tag-height mark-tag-width
		       mark? marks max-regions max-transform-peaks maxamp
		       maxamp-position menu-widgets min-dB mix
		       mix-amp mix-amp-env mix-click-hook mix-color
		       mix-dialog-mix mix-drag-hook mix-file-dialog mix-length mix-home
		       mix-name mix-position mix-properties mix-property mix-region mix-release-hook mix-sync mix-sync-max
		       mix-sampler? mix-selection mix-speed mix-tag-height
		       mix-tag-width mix-tag-y
		       mix-float-vector mix-waveform-height mix?
		       mixes mouse-click-hook mouse-drag-hook mouse-enter-graph-hook
		       mouse-enter-label-hook mouse-enter-listener-hook mouse-enter-text-hook mouse-leave-graph-hook mouse-leave-label-hook
		       mouse-leave-listener-hook mouse-leave-text-hook mouse-press-hook move-locsig move-sound move-sound? 
		       moving-average moving-average? moving-max moving-max? moving-norm moving-norm?
		       mus-aifc mus-aiff mus-alaw mus-alsa-buffer-size mus-alsa-buffers
		       mus-alsa-capture-device mus-alsa-device mus-alsa-playback-device mus-alsa-squelch-warning mus-apply
		       mus-array-print-length mus-float-equal-fudge-factor 
		       mus-b24int mus-bdouble mus-bdouble-unscaled
		       mus-bfloat mus-bfloat-unscaled mus-bicsf mus-bint mus-bintn
		       mus-bshort mus-byte mus-bytes-per-sample mus-caff mus-channel mus-channels
		       mus-chebyshev-first-kind mus-chebyshev-second-kind mus-clipping mus-close
		       mus-data mus-sample-type->string mus-sample-type-name mus-describe mus-error-hook
		       mus-error-type->string mus-expand-filename mus-feedback mus-feedforward mus-fft
		       mus-file-buffer-size mus-file-clipping mus-file-name
		       mus-frequency mus-generator? mus-header-raw-defaults mus-header-type->string mus-header-type-name
		       mus-hop mus-increment mus-input? mus-interp-all-pass mus-interp-bezier
		       mus-interp-hermite mus-interp-lagrange mus-interp-linear mus-interp-none mus-interp-sinusoidal
		       mus-interp-type mus-interpolate mus-ircam mus-l24int mus-ldouble
		       mus-ldouble-unscaled mus-length mus-lfloat mus-lfloat-unscaled mus-lint
		       mus-lintn mus-location mus-lshort mus-max-malloc mus-max-table-size
		       mus-file-mix mus-mulaw mus-name 
		       mus-next mus-nist mus-offset mus-order mus-oss-set-buffers
		       mus-out-format mus-output? mus-phase mus-ramp
		       mus-rand-seed mus-random mus-raw mus-reset mus-riff
		       mus-run mus-scaler mus-set-formant-radius-and-frequency mus-sound-chans 
		       mus-sound-comment mus-sound-sample-type mus-sound-data-location mus-sound-datum-size
		       mus-sound-duration mus-sound-forget mus-sound-framples mus-sound-header-type mus-sound-length
		       mus-sound-loop-info mus-sound-mark-info mus-sound-maxamp mus-sound-maxamp-exists? mus-sound-path
		       mus-sound-prune mus-sound-report-cache mus-sound-samples
		       mus-sound-srate mus-sound-type-specifier mus-sound-write-date
		       mus-soundfont mus-srate mus-svx mus-ubshort
		       mus-ubyte mus-ulshort mus-unknown-sample mus-unknown-header mus-voc
		       mus-width mus-xcoeff mus-xcoeffs mus-ycoeff mus-ycoeffs
		       name-click-hook new-sound new-sound-dialog new-sound-hook new-widget-hook
		       next-sample normalize-by-channel normalize-by-sound normalize-channel normalize-globally
		       notch notch? odd-multiple odd-weight one-pole one-pole? one-pole-all-pass one-pole-all-pass? 
		       one-zero one-zero? open-file-dialog open-file-dialog-directory open-hook open-raw-sound open-raw-sound-hook
		       open-sound
		       orientation-hook oscil oscil? out-any outa
		       outb outc outd output-comment-hook
		       override-samples-with-origin pad-channel partials->polynomial partials->wave
		       parzen-window pausing peaks peaks-font
		       phase-partials->wave phase-vocoder phase-vocoder-amp-increments phase-vocoder-amps phase-vocoder-freqs
		       phase-vocoder-phase-increments phase-vocoder-phases phase-vocoder? play play-arrow-size
		       play-hook player-home player? players
		       playing poisson-window polar->rectangular polynomial polyshape polywave
		       polyshape? polywave? position->x position->y position-color preferences-dialog
		       previous-sample print-dialog print-length progress-report
		       pulse-train
		       pulse-train? radians->degrees radians->hz
		       ramp-channel rand rand-interp rand-interp? rand?
		       read-mix-sample read-only read-region-sample
		       read-sample readin readin? 
		       rectangular->magnitudes rectangular->polar rectangular-window redo redo-edit
		       region->float-vector region-chans region-home region-framples region-graph-style region-maxamp
		       region-maxamp-position region-position region-sample region-sampler? region-srate
		       region? regions remember-sound-state remove-from-menu status-report
		       reset-controls reset-listener-cursor restore-controls restore-region
		       reverb-control-decay reverb-control-feedback reverb-control-length reverb-control-length-bounds reverb-control-lowpass
		       reverb-control-scale reverb-control-scale-bounds reverb-control? reverse-channel reverse-selection
		       reverse-sound revert-sound riemann-window right-sample ring-modulate
		       rv2-window rv3-window rv4-window 
		       samaraki-window sample sample->file
		       sample->file? sampler-at-end? sampler-home sampler-position
		       sampler? samples samples->seconds sash-color
		       save-controls save-dir save-edit-history save-envelopes save-hook
		       save-listener save-marks save-region save-region-dialog
		       save-selection save-selection-dialog save-sound save-sound-as save-sound-dialog
		       save-state save-state-file save-state-hook sawtooth-wave sawtooth-wave?
		       scale-by scale-channel scale-selection-by scale-selection-to scale-to
		       scan-channel script-arg script-args search-procedure
		       seconds->samples select-all select-channel select-channel-hook select-sound
		       select-sound-hook selected-channel selected-data-color selected-graph-color selected-sound
		       selection-chans selection-color selection-context selection-creates-region
		       selection-framples selection-maxamp selection-maxamp-position selection-member? selection-position
		       selection-srate selection?
		       short-file-name show-all-axes show-all-axes-unlabelled show-bare-x-axis
		       show-axes show-controls show-grid show-indices show-full-duration show-full-range initial-beg initial-dur
		       show-listener show-marks show-mix-waveforms show-no-axes show-selection show-selection-transform
		       show-sonogram-cursor show-transform-peaks show-widget show-x-axis show-x-axis-unlabelled
		       show-y-zero sinc-width nrxysin nrxysin? nrxycos nrxycos? rxyk!cos rxyk!cos? rxyk!sin rxyk!sin? 
		       smooth-channel smooth-selection smooth-sound snd->sample snd->sample?
		       snd-error snd-error-hook snd-gcs snd-help snd-font snd-color
		       snd-print snd-spectrum snd-tempnam snd-url
		       snd-urls snd-version snd-warning snd-warning-hook 
		       sound-file-extensions sound-file? sound-files-in-directory
		       sound-loop-info sound-properties sound-property sound-widgets sound? soundfont-info
		       sounds spectrum-end spectro-hop spectrum-start spectro-x-angle
		       spectro-x-scale spectro-y-angle spectro-y-scale spectro-z-angle spectro-z-scale
		       spectrum speed-control speed-control-as-float speed-control-as-ratio speed-control-as-semitone
		       speed-control-bounds speed-control-style speed-control-tones square-wave square-wave?
		       squelch-update srate src src-channel src-selection
		       src-sound src? ssb-am ssb-am?
		       start-playing start-playing-hook start-playing-selection-hook start-progress-report stdin-prompt
		       stop-player stop-playing stop-playing-hook stop-playing-selection-hook ncos
		       ncos? nsin nsin? swap-channels sync sync-style sync-none sync-all sync-by-sound
		       sync-max syncd-marks table-lookup table-lookup? tap tap?
		       temp-dir text-focus-color time-graph time-graph-style
		       time-graph-type time-graph? tiny-font 
		       tracking-cursor-style transform->float-vector
		       transform-dialog transform-framples transform-graph transform-graph-style transform-graph-type
		       transform-graph? transform-normalization transform-sample transform-size transform-type
		       transform? triangle-wave triangle-wave? tukey-window
		       two-pole two-pole? two-zero two-zero? ultraspherical-window
		       unbind-key  undo undo-edit undo-hook unselect-all update-hook update-lisp-graph
		       update-sound update-time-graph update-transform-graph variable-graph? float-vector
		       float-vector* float-vector+ float-vector->channel
		       float-vector->string float-vector-add!
		       length float-vector-max float-vector-min float-vector-move!
		       float-vector-multiply! float-vector-offset! float-vector-peak float-vector-ref reverse!
		       float-vector-scale! float-vector-set! float-vector-subseq float-vector-subtract! float-vector?
		       walsh-transform
		       wave-train wave-train? wavelet-transform wavelet-type
		       wavo-hop wavo-trace welch-window widget-position
		       widget-size widget-text window-height
		       window-width window-x window-y with-background-processes with-file-monitor with-gl
		       with-mix-tags with-relative-panes with-tracking-cursor with-verbose-cursor 
		       with-inset-graph with-interrupts with-pointer-focus with-smpte-label with-toolbar with-tooltips with-menu-icons
		       save-as-dialog-src save-as-dialog-auto-comment
		       x->position x-axis-as-clock x-axis-as-percentage x-axis-in-beats x-axis-in-measures
		       x-axis-in-samples x-axis-in-seconds x-axis-label x-axis-style x-bounds
		       x-position-slider x-zoom-slider xramp-channel y->position y-axis-label
		       y-bounds y-position-slider y-zoom-slider zero-pad zoom-color
		       zoom-focus-active zoom-focus-left zoom-focus-middle zoom-focus-right zoom-focus-style)))
      (for-each
       (lambda (n)
	 (if (not (defined? n))
	     (set! undef (cons n undef))))
       names)
      (if (pair? undef)
	  (snd-display "undefined: ~A" undef)))))


;;; ---------------- test 4: sndlib ----------------

(if (or (not (provided? 'snd-examp.scm))
	(and (defined? 'ramp) ; why this? protection against funcs?
	     (list? ramp)))
    (load "examp.scm"))

(require snd-mix.scm snd-env.scm)

(define (snd_test_4)
  
  (do ((clmtest 0 (+ 1 clmtest))) 
      ((= clmtest tests)) 
    (log-mem clmtest)
    (clear-listener)

    (let ((mz (mus-sound-maxamp "z.snd")))
      (if (or (not (= (car mz) 0))
	      (fneq (cadr mz) 0.0))
	  (snd-display "mus-sound-maxamp z.snd: ~A (~A ~A)" mz (not (= (car mz) 0)) (fneq (cadr mz) 0.0))))
    (let ((formats (list mus-bshort mus-lshort mus-mulaw mus-alaw mus-byte mus-ubyte mus-bfloat mus-lfloat
			 mus-bint mus-lint mus-bintn mus-lintn mus-b24int mus-l24int mus-bdouble mus-ldouble
			 mus-ubshort mus-ulshort mus-bdouble-unscaled mus-ldouble-unscaled mus-bfloat-unscaled 
			 mus-lfloat-unscaled))
	  (sizes (list 2 2 1 1 1 1 4 4 
		       4 4 4 4 3 3 8 8
		       2 2 8 8 4
		       4)))
      (for-each
       (lambda (frm siz)
	 (if (not (= (mus-bytes-per-sample frm) siz))
	     (snd-display "mus-bytes-per-sample ~A: ~A" (mus-sample-type-name frm) siz)))
       formats
       sizes))
    (if (not (string=? (mus-sample-type->string mus-bshort) "mus-bshort"))
	(snd-display "mus-sample-type->string: ~A" (mus-sample-type->string mus-bshort)))
    (if (not (string=? (mus-header-type->string mus-aifc) "mus-aifc"))
	(snd-display "mus-header-type->string: ~A" (mus-header-type->string mus-aifc)))
    (mus-sound-report-cache "hiho.tmp")
    (let* ((p (open-input-file "hiho.tmp"))
	   (line (read-line p)))
      (if (not (member line '("sound table:" "sound table:\n")))
	  (snd-display "print-cache 1: ~A?" line))
      (close-input-port p)
      (delete-file "hiho.tmp"))
    (let ((chns (mus-sound-chans "oboe.snd")))
      (if (not (= chns 1)) (snd-display "oboe: mus-sound-chans ~D?" chns)))
    (if (= clmtest 0)
	(let ((m1 (mus-sound-maxamp-exists? "oboe.snd")))
	  (if (and m1 (= clmtest 0)) (snd-display "oboe: mus-sound-maxamp-exists before maxamp: ~A" m1))
	  (let ((mal (mus-sound-maxamp "oboe.snd")))
	    (if (fneq (cadr mal) .14724) (snd-display "oboe: mus-sound-maxamp ~F?" (cadr mal)))
	    (if (not (= (car mal) 24971)) (snd-display "oboe: mus-sound-maxamp at ~D?" (car mal))))
	  (if (not (mus-sound-maxamp-exists? "oboe.snd")) 
	      (snd-display "oboe: not mus-sound-maxamp-exists after maxamp: ~A" (mus-sound-maxamp-exists? "oboe.snd")))))
    (let ((dl (mus-sound-data-location "oboe.snd")))
      (if (not (= dl 28)) (snd-display "oboe: mus-sound-data-location ~D (~A)?" dl (= dl 28))))
    (let ((fr (mus-sound-framples "oboe.snd")))
      (if (not (= fr 50828)) (snd-display "oboe: mus-sound-framples ~D?" fr)))
    (let ((smps (mus-sound-samples "oboe.snd")))
      (if (not (= smps 50828)) (snd-display "oboe: mus-sound-samples ~D?" smps)))
    (let ((len (mus-sound-length "oboe.snd")))
      (if (not (= len 101684)) (snd-display "oboe: mus-sound-length ~D?" len)))
    (let ((size (mus-sound-datum-size "oboe.snd")))
      (if (not (= size 2)) (snd-display "oboe: mus-sound-datum-size ~D?" size)))
    (let ((bytes (mus-bytes-per-sample (mus-sound-sample-type "oboe.snd"))))
      (if (not (= bytes 2)) (snd-display "oboe: sound-bytes ~D?" bytes)))
    (let ((sr (mus-sound-srate "oboe.snd")))
      (if (not (= sr 22050)) (snd-display "oboe: mus-sound-srate ~D?" sr)))
    
    (if (= clmtest 0)
	(let ((vals (mus-header-raw-defaults)))
	  (if (not (and (pair? vals)
			(= (length vals) 3)))
	      (snd-display "mus-header-raw-defaults: ~A" vals)
	      (let ((sr (car vals))
		    (chns (cadr vals))
		    (frm (caddr vals)))
		(if (not (= sr 44100)) (snd-display "mus-header-raw-defaults srate: ~A" sr))
		(if (not (= chns 2)) (snd-display "mus-header-raw-defaults chns: ~A" chns))
		(if (not (= frm mus-bshort)) (snd-display "mus-header-raw-defaults format: ~A: ~A" frm (mus-sample-type-name frm)))))))
    (set! (mus-header-raw-defaults) (list 12345 3 mus-bdouble-unscaled))
    (let ((vals (mus-header-raw-defaults)))
      (if (not (and (pair? vals)
		    (= (length vals) 3)))
	  (snd-display "set mus-header-raw-defaults: ~A" vals)
	  (let ((sr (car vals))
		(chns (cadr vals))
		(frm (caddr vals)))
	    (if (not (= sr 12345)) (snd-display "set mus-header-raw-defaults srate: ~A" sr))
	    (if (not (= chns 3)) (snd-display "set mus-header-raw-defaults chns: ~A" chns))
	    (if (not (= frm mus-bdouble-unscaled)) (snd-display "set mus-header-raw-defaults format: ~A: ~A" frm (mus-sample-type-name frm))))))
    (set! (mus-header-raw-defaults) (list 44100 2 mus-bshort))
    
    (let ((str (strftime "%d-%b %H:%M %Z" (localtime (mus-sound-write-date "oboe.snd")))))
      (if (not (string=? str "23-Nov 06:56 PST"))
	  (snd-display "mus-sound-write-date oboe.snd: ~A?" str)))
    (let ((str (strftime "%d-%b %H:%M %Z" (localtime (mus-sound-write-date "pistol.snd")))))
      (if (not (string=? str "23-Nov 06:56 PST"))
	  (snd-display "mus-sound-write-date pistol.snd: ~A?" str)))
    
    (let ((long-file-name (do ((name "test" (string-append name "-test"))
			       (i 0 (+ i 1)))
			      ((= i 10)
			       (string-append name ".snd")))))
      (let ((index (open-sound "oboe.snd")))
	(if (variable-graph? index) (snd-display "variable-graph thinks anything is a graph..."))
	(if (player? index) (snd-display "player? thinks anything is a player..."))
	(if (not (sound? index)) (snd-display "~A is not a sound?" index))
	(if (sound? #f) (snd-display "sound? #f -> #t?"))
	(if (sound? #t) (snd-display "sound? #t -> #t?"))
	(save-sound-as long-file-name index)
	(close-sound index))
      (let ((index (open-sound long-file-name)))
	(if (not (sound? index)) (snd-display "can't find test...snd"))
	(if (or (< (length (file-name index)) (length long-file-name))
		(< (length (short-file-name index)) (length long-file-name)))
	    (snd-display "file-name lengths: ~A ~A ~A"
			 (length (file-name index))
			 (length (short-file-name index))
			 (length long-file-name)))
	(close-sound index))
      (mus-sound-forget long-file-name)
      (delete-file long-file-name))
		       
    (let ((new-path (if (provided? 'osx) "/Users/bil/sf1" "/home/bil/sf1")))
      (let-temporarily ((*mus-sound-path* (list new-path)))
	(let ((ind (catch #t (lambda () (open-sound "o2.bicsf")) (lambda args #f))))
	  (if (not (sound? ind))
	      (snd-display "*mus-sound-path*: ~A~%" ind)
	      (begin
		(close-sound ind)
		(set! (mus-sound-path) (list new-path))
		(set! ind (catch #t (lambda () (open-sound "o2.bicsf")) (lambda args #f)))
		(if (sound? ind)
		    (close-sound ind)
		    (snd-display "(mus-sound-path): ~A~%" ind)))))))
    
    (let ((fsnd (string-append sf-dir "forest.aiff")))
      (when (file-exists? fsnd)
	(system (format #f "cp ~A fmv.snd" fsnd))
	(let ((index (open-sound "fmv.snd")))
	  (if (not (equal? (sound-loop-info index) (mus-sound-loop-info fsnd)))
	      (snd-display "loop-info: ~A ~A" (sound-loop-info index) (mus-sound-loop-info fsnd)))
	  (set! (sound-loop-info index) (list 12000 14000 1 2 3 4))
	  (if (not (equal? (sound-loop-info index) '(12000 14000 1 2 3 4 1 1)))
	      (snd-display "set loop-info: ~A" (sound-loop-info index)))
	  (save-sound-as "fmv1.snd" index :header-type mus-aifc)
	  (close-sound index)
	  (if (not (equal? (mus-sound-loop-info "fmv1.snd") '(12000 14000 1 2 3 4 1 1)))
	      (snd-display "saved loop-info: ~A" (mus-sound-loop-info "fmv1.snd"))))))
    (let ((index (open-sound "oboe.snd")))
      (save-sound-as "fmv.snd" index :header-type mus-aifc)
      (close-sound index))
    (let ((index (open-sound "fmv.snd")))
      (if (not (null? (sound-loop-info index)))
	  (snd-display "null loop-info: ~A" (sound-loop-info index)))
      (set! (sound-loop-info index) (list 1200 1400 4 3 2 1))
      (if (not (equal? (sound-loop-info index) '(1200 1400 4 3 2 1 1 1)))
	  (snd-display "set null loop-info: ~A" (sound-loop-info index)))
      (save-sound-as "fmv1.snd" :sound index :header-type mus-aifc)
      (close-sound index)
      (if (not (equal? (mus-sound-loop-info "fmv1.snd") '(1200 1400 4 3 2 1 1 1)))
	  (snd-display "saved null loop-info: ~A" (mus-sound-loop-info "fmv1.snd"))))
    (let ((index (open-sound "fmv.snd")))
      (set! (sound-loop-info) (list 1200 1400 4 3 2 1 1 0))
      (if (not (equal? (sound-loop-info index) '(1200 1400 0 0 2 1 1 0)))
	  (snd-display "set null loop-info (no mode1): ~A" (sound-loop-info index)))
      (save-sound-as "fmv1.snd" index :header-type mus-aifc)
      (close-sound index)
      (if (not (equal? (mus-sound-loop-info "fmv1.snd") '(1200 1400 0 0 2 1 1 0)))
	  (snd-display "saved null loop-info (no mode1): ~A" (mus-sound-loop-info "fmv1.snd"))))
    
    (for-each 
     (lambda (file&comment)
       (let ((file (car file&comment))
	     (comment (cadr file&comment)))
	 (let ((fsnd (string-append sf-dir file)))
	   (when (file-exists? fsnd)
	     (let ((com (mus-sound-comment fsnd)))
	       (if (not (equal? com comment))
		   (snd-display "mus-sound-comment ~S -> ~A?" file com)))))))
     '(("oboe.snd" "")
       ("nasahal8.wav" "ICRD: 1997-02-22\nIENG: Paul R. Roger\nISFT: Sound Forge 4.0\n")
       ("8svx-8.snd" "File created by Sound Exchange  ") 
       ("sun-16-afsp.snd" "AFspdate:1981/02/11 23:03:34 UTC")
       ("smp-16.snd" "Converted using Sox.                                        ")
       ("d40130.au" "1994 Jesus Villena")
       ("wood.maud" "file written by SOX MAUD-export ")
       ("addf8.sf_mipseb" "date=\"Feb 11 18:03:34 1981\" info=\"Original recorded at 20 kHz, 15-bit D/A, digitally filtered and resampled\" speaker=\"AMK female\" text=\"Add the sum to the product of these three.\" ")
       ("mary-sun4.sig" "MARY HAD A LITTLE LAMB\n")
       ("nasahal.pat" "This patch saved with Sound Forge 3.0.")
       ("next-16.snd" ";Written on Mon 1-Jul-91 at 12:10 PDT  at localhost (NeXT) using Allegro CL and clm of 25-June-91")
       ("wood16.nsp" "Created by Snack   ") 
       ("wood.sdx" "1994 Jesus Villena")
       ("clmcom.aif" "this is a comment") 
       ("anno.aif" "1994 Jesus Villena\n")
       ("telephone.wav" "sample_byte_format -s2 01\nchannel_count -i 1\nsample_count -i 36461\nsample_rate -i 16000\nsample_n_bytes -i 2\nsample_sig_bits -i 16\n")))
    
    (if (not (string? (mus-sound-comment (string-append sf-dir "traffic.aiff"))))
	(snd-display "mus-sound-comment traffic: ~A" (mus-sound-comment (string-append sf-dir "traffic.aiff"))))
    
    (if (not (member (mus-sound-type-specifier "oboe.snd") '(#x646e732e #x2e736e64) =))
	(snd-display "oboe: mus-sound-type-specifier: ~X?" (mus-sound-type-specifier "oboe.snd")))
    (if (not (string=? (strftime "%d-%b-%Y %H:%M" (localtime (file-write-date "oboe.snd"))) "23-Nov-2012 06:56"))
	(snd-display "oboe: file-write-date: ~A?" (strftime "%d-%b-%Y %H:%M" (localtime (file-write-date "oboe.snd")))))
    
    (let ((lasth (do ((i 1 (+ i 1)))
		     ((string=? (mus-header-type-name i) "unknown") i))))
      (if (< lasth 50) (snd-display "header-type[~A] = ~A" lasth (mus-header-type-name lasth))))
    (let ((lasth (do ((i 1 (+ i 1)))
		     ((string=? (mus-sample-type-name i) "unknown") i))))
      (if (< lasth 10) (snd-display "sample-type[~A] = ~A" lasth (mus-sample-type-name lasth))))
    
    (when with-gui
      (set! *transform-normalization* dont-normalize)
      (if (not (= *transform-normalization* dont-normalize))
	  (snd-display "set-transform-normalization none -> ~A" *transform-normalization*))
      (set! *transform-normalization* normalize-globally)
      (if (not (= *transform-normalization* normalize-globally))
	  (snd-display "set-transform-normalization globally -> ~A" *transform-normalization*))
      (set! *transform-normalization* normalize-by-channel)
      (if (not (= *transform-normalization* normalize-by-channel))
	  (snd-display "set-transform-normalization channel -> ~A" *transform-normalization*)))
    
    (let ((ind (new-sound "fmv.snd" 1 22050 mus-ldouble mus-next "set-samples test" 100)))
      (set! (samples 10 3) (make-float-vector 3 .1))
      (if (not (mus-arrays-equal? (channel->float-vector 0 20 ind 0) #r(0 0 0 0 0 0 0 0 0 0 .1 .1 .1 0 0 0 0 0 0 0)))
	  (snd-display "1 set samples 0 for .1: ~A" (channel->float-vector 0 20 ind 0)))
      (set! (samples 20 3 ind 0) (make-float-vector 3 .1))
      (if (not (mus-arrays-equal? (channel->float-vector 10 20 ind 0) #r(.1 .1 .1 0 0 0 0 0 0 0 .1 .1 .1 0 0 0 0 0 0 0)))
	  (snd-display "2 set samples 10 for .1: ~A" (channel->float-vector 10 20 ind 0)))
      (set! (samples 30 3 ind 0 #f "a name") (make-float-vector 3 .1))
      (if (not (mus-arrays-equal? (channel->float-vector 20 20 ind 0) #r(.1 .1 .1 0 0 0 0 0 0 0 .1 .1 .1 0 0 0 0 0 0 0)))
	  (snd-display "3 set samples 20 for .1: ~A" (channel->float-vector 20 20 ind 0)))
      (set! (samples 0 3 ind 0 #f "a name" 0 1) (make-float-vector 3 .2))
      (if (not (mus-arrays-equal? (channel->float-vector 0 20 ind 0) #r(.2 .2 .2 0 0 0 0 0 0 0 .1 .1 .1 0 0 0 0 0 0 0)))
	  (snd-display "4 set samples 0 at 1 for .1: ~A" (channel->float-vector 0 20 ind 0)))
      (if (not (mus-arrays-equal? (channel->float-vector 20 20 ind 0) (make-float-vector 20)))
	  (snd-display "5 set samples 20 at 1 for .1: ~A" (channel->float-vector 0 20 ind 0)))
      (let ((nd (new-sound "fmv1.snd" :channels 2)))
	(float-vector->channel (make-float-vector 10 .5) 0 10 nd 0)
	(float-vector->channel (make-float-vector 10 .3) 0 10 nd 1)
	(save-sound-as "fmv1.snd" nd)
	(close-sound nd))
      (if (not (file-exists? "fmv1.snd")) (snd-display "fmv1 not saved??"))
      (set! (samples 0 10 ind 0 #f "another name" 1) "fmv1.snd")
      (if (not (mus-arrays-equal? (channel->float-vector 0 20 ind 0) #r(.3 .3 .3 .3 .3 .3 .3 .3 .3 .3 .1 .1 .1 0 0 0 0 0 0 0)))
	  (snd-display "6 set samples 0 at 1 for .1: ~A" (channel->float-vector 0 20 ind 0)))
      (set! (samples 5 6 ind 0 #f "another name 7" 0) "fmv1.snd")
      (if (not (mus-arrays-equal? (channel->float-vector 0 20 ind 0) #r(.3 .3 .3 .3 .3 .5 .5 .5 .5 .5 .5 .1 .1 0 0 0 0 0 0 0)))
	  (snd-display "7 set samples 0 at 1 for .1: ~A" (channel->float-vector 0 20 ind 0)))
      (revert-sound ind)
      (set! (samples 0 10 ind 0 #f "another name 8" 1 0 #f) "fmv1.snd")
      (if (not (mus-arrays-equal? (channel->float-vector 0 20 ind 0) #r(.3 .3 .3 .3 .3 .3 .3 .3 .3 .3 0 0 0 0 0 0 0 0 0 0)))
	  (snd-display "8 set samples 0 at 1 for .1: ~A" (channel->float-vector 0 20 ind 0)))
      (set! (samples 10 10 ind 0 #f "another name 9" 0 0) "fmv1.snd")
      (if (not (mus-arrays-equal? (channel->float-vector 0 20 ind 0) #r(0 0 0 0 0 0 0 0 0 0 .5 .5 .5 .5 .5 .5 .5 .5 .5 .5)))
	  (snd-display "9 set samples 0 at 1 for .1: ~A" (channel->float-vector 0 20 ind 0)))
      (set! (samples 20 10) "fmv1.snd")
      (if (not (mus-arrays-equal? (channel->float-vector 10 20 ind 0) (make-float-vector 20 .5)))
	  (snd-display "10 set samples 0 at 1 for .1: ~A" (channel->float-vector 10 20 ind 0)))
      (revert-sound ind)
      (set! (samples 0 10 ind 0 #t "another name" 1 0 #f) "fmv1.snd")
      (if (not (= (framples ind 0) 10)) (snd-display "11 set-samples truncate to ~A" (framples ind 0)))
      (revert-sound ind)
      (delete-file "fmv1.snd")
      
      ;; now try to confuse it
      (let ((tag (catch #t 
		   (lambda () (set! (samples 0 10 ind 0) "fmv1.snd") #f)
		   (lambda args (car args)))))
	(if (not (eq? tag 'no-such-file)) (snd-display "set-samples, no such file: ~A" tag)))
      (let ((nd (new-sound "fmv1.snd" :channels 1)))
	(float-vector->channel (make-float-vector 10 .5) 0 10 nd 0)
	(save-sound-as "fmv1.snd" nd)
	(close-sound nd))
      (let ((tag (catch #t
		   (lambda () (set! (samples 0 10 ind 0 #f "another name" 1) "fmv1.snd") #f) ; chan 1 does not exist
		   (lambda args (car args)))))
	(if (not (eq? tag 'no-such-channel)) (snd-display "set-samples no such channel: ~A" tag)))
      (let ((tag (catch #t
		   (lambda () (set! (samples 0 10 ind 0 #f "another name" -1) "fmv1.snd") #f)
		   (lambda args (car args)))))
	(if (not (eq? tag 'no-such-channel)) (snd-display "set-samples no such channel (-1): ~A" tag)))
      (let ((tag (catch #t
		   (lambda () (set! (samples 0 -10) "fmv1.snd") #f)
		   (lambda args (car args)))))
	(if (not (eq? tag 'wrong-type-arg)) (snd-display "set-samples (-10): ~A" tag)))
      (let ((tag (catch #t
		   (lambda () (set! (samples -10 10) "fmv1.snd") #f)
		   (lambda args (car args)))))
	(if (not (eq? tag 'no-such-sample)) (snd-display "set-samples (beg -10): ~A" tag)))
      (close-sound ind))
    
    (let ((len 100))
      (for-each
       (lambda (type allowed-diff)
	 (let ((v (make-float-vector len)))
	   (copy #r(0.999 -1.0 .1 -.1 .001 -.001 0.0) v)
	   (do ((i 7 (+ i 1)))
	       ((= i len))
	     (let ((val (random 1.9999)))
	       (if (not (>= 2.0 val 0.0))
		   (snd-display "random 2.0 -> ~A?" val))
	       (set! (v i) (- 1.0 val))))
	   (let ((ind (new-sound "test.snd" 1 22050 mus-ldouble mus-next)))
	     (float-vector->channel v 0 len ind 0)
	     (save-sound-as "test1.snd" ind :header-type mus-next :sample-type type)
	     (close-sound ind))
	   (let* ((ind (open-sound "test1.snd"))
		  (v1 (channel->float-vector 0 len ind 0)))
	     (do ((maxdiff 0.0)
		  (maxpos #f)
		  (i 0 (+ i 1)))
		 ((= i len)
		  (if (> maxdiff allowed-diff)
		      (snd-display "[line 2841] ~A: ~A at ~A (~A ~A)" 
				   (mus-sample-type-name type) 
				   maxdiff maxpos 
				   (v maxpos) (v1 maxpos))))
	       (let ((diff (abs (- (v i) (v1 i)))))
		 (when (> diff maxdiff)
		   (set! maxdiff diff)
		   (set! maxpos i))))
	     (close-sound ind))))
       (list mus-bshort   mus-lshort   mus-mulaw   mus-alaw   mus-byte  
	     mus-lfloat   mus-bint     mus-lint    mus-b24int mus-l24int
	     mus-ubshort  mus-ulshort  mus-ubyte   mus-bfloat mus-bdouble 
	     mus-ldouble)
       (list (expt 2 -15) (expt 2 -15) 0.02 0.02 (expt 2 -7)
	     (expt 2 -23) (expt 2 -23) (expt 2 -23) (expt 2 -23) (expt 2 -23) ; assuming sndlib bits=24 here (if int)
	     (expt 2 -15) (expt 2 -15) (expt 2 -7) (expt 2 -23) (expt 2 -23)
	     (expt 2 -23))))
    
    (let* ((ob (view-sound "oboe.snd"))
	   (samp (sample 1000 ob)))
      (let ((old-comment (mus-sound-comment "oboe.snd")))
	(let ((str (string-append "written " 
				  (strftime "%a %d-%b-%Y %H:%M %Z" 
					    (localtime (current-time))))))
	  (set! (comment ob) str)
	  (let ((tag (catch #t
		       (lambda ()
			 (save-sound-as "test.snd" ob :header-type mus-aifc :sample-type mus-bdouble))
		       (lambda args (car args)))))
	    (if (eq? tag 'cannot-save) (snd-display "save-sound-as test.snd write trouble")))
	  (set! *filter-control-in-hz* #t)
	  (let ((ab (open-sound "test.snd")))
	    (if (not (= (header-type ab) mus-aifc)) 
		(snd-display "save-as aifc -> ~A?" (mus-header-type-name (header-type ab))))
	    (if (not (= (mus-sound-header-type "test.snd") mus-aifc)) 
		(snd-display "saved-as aifc -> ~A?" (mus-header-type-name (mus-sound-header-type "test.snd"))))
	    (if (fneq (sample 1000 ab) samp) (snd-display "aifc[1000] = ~A?" (sample 1000 ab)))
	    (if (not (equal? (mus-sound-comment "test.snd") str))
		(snd-display "output-comment: ~A ~A" (mus-sound-comment "test.snd") str))
	    (if (not (equal? (comment ab) str))
		(snd-display "output-comment (comment): ~A ~A" (comment ab) str))
	    (close-sound ab)))
	(if (not (equal? old-comment (mus-sound-comment "oboe.snd")))
	    (snd-display "set-comment overwrote current ~A ~A" old-comment (mus-sound-comment "oboe.snd"))))
      (set! *filter-control-in-hz* #f)
      (save-sound-as "test.snd" ob :header-type mus-raw)
      (let ((ab (open-raw-sound "test.snd" 1 22050 mus-bshort)))
	(if (not (= (header-type ab) mus-raw)) 
	    (snd-display "save-as raw -> ~A?" (mus-header-type-name (header-type ab))))
	(if (not (= (mus-sound-header-type "test.snd") mus-raw)) 
	    (snd-display "saved-as raw -> ~A?" (mus-header-type-name (mus-sound-header-type "test.snd"))))
	(if (fneq (sample 1000 ab) samp) (snd-display "raw[1000] = ~A?" (sample 1000 ab)))
	(close-sound ab))
      (save-sound-as "test.snd" ob :header-type mus-nist :sample-type mus-bint)
      (let ((ab (open-sound "test.snd")))
	(if (not (= (header-type ab) mus-nist)) 
	    (snd-display "save-as nist -> ~A?" (mus-header-type-name (header-type ab))))
	(if (not (= (mus-sound-header-type "test.snd") mus-nist)) 
	    (snd-display "saved-as nist -> ~A?" (mus-header-type-name (mus-sound-header-type "test.snd"))))
	(if (not (= (sample-type ab) mus-bint)) 
	    (snd-display "save-as int -> ~A?" (mus-sample-type-name (sample-type ab))))
	(if (not (= (mus-sound-sample-type "test.snd") mus-bint)) 
	    (snd-display "saved-as int -> ~A?" (mus-sample-type-name (mus-sound-sample-type "test.snd"))))
	(if (fneq (sample 1000 ab) samp) (snd-display "nist[1000] = ~A?" (sample 1000 ab)))
	(close-sound ab))
      (set! (hook-functions output-comment-hook) ())
      (hook-push output-comment-hook
		 (lambda (hook) 
		   (set! (hook 'result) (string-append (hook 'comment) " [written by me]"))))
      (save-sound-as :file "test.snd" :sound ob :header-type mus-riff :sample-type mus-lfloat)
      (set! (hook-functions output-comment-hook) ())
      (let ((ab (open-sound "test.snd")))
	(if (not (= (header-type ab) mus-riff)) 
	    (snd-display "save-as riff -> ~A?" (mus-header-type-name (header-type ab))))
	(if (not (= (mus-sound-header-type "test.snd") mus-riff)) 
	    (snd-display "saved-as riff -> ~A?" (mus-header-type-name (mus-sound-header-type "test.snd"))))
	(if (not (= (sample-type ab) mus-lfloat)) 
	    (snd-display "save-as float -> ~A?" (mus-sample-type-name (sample-type ab))))
	(if (not (= (mus-sound-sample-type "test.snd") mus-lfloat)) 
	    (snd-display "saved-as float -> ~A?" (mus-sample-type-name (mus-sound-sample-type "test.snd"))))
	(if (fneq (sample 1000 ab) samp) (snd-display "riff[1000] = ~A?" (sample 1000 ab)))
	(if (not (equal? (comment ab) 
			 (string-append "written " 
					(strftime "%a %d-%b-%Y %H:%M %Z" (localtime (current-time)))
					" [written by me]")))
	    (snd-display "output-comment-hook: ~A~%(~A)" (comment ab) (mus-sound-comment "test.snd")))
	(close-sound ab))
      (save-sound-as "test.snd" ob :header-type mus-aiff :sample-type mus-b24int)
      (let ((ab (open-sound "test.snd")))
	(if (not (= (header-type ab) mus-aiff)) 
	    (snd-display "save-as aiff -> ~A?" (mus-header-type-name (header-type ab))))
	(if (not (= (mus-sound-header-type "test.snd") mus-aiff)) 
	    (snd-display "saved-as aiff -> ~A?" (mus-header-type-name (mus-sound-header-type "test.snd"))))
	(if (not (= (sample-type ab) mus-b24int))
	    (snd-display "save-as 24-bit -> ~A?" (mus-sample-type-name (sample-type ab))))
	(if (not (= (mus-sound-sample-type "test.snd") mus-b24int))
	    (snd-display "saved-as 24-bit -> ~A?" (mus-sample-type-name (mus-sound-sample-type "test.snd"))))
	(if (fneq (sample 1000 ab) samp) (snd-display "aiff[1000] = ~A?" (sample 1000 ab)))
	(close-sound ab))
      (save-sound-as "test.snd" ob :header-type mus-ircam :sample-type mus-mulaw)
      (let ((ab (open-sound "test.snd")))
	(if (not (= (header-type ab) mus-ircam)) 
	    (snd-display "save-as ircam -> ~A?" (mus-header-type-name (header-type ab))))
	(if (not (= (mus-sound-header-type "test.snd") mus-ircam)) 
	    (snd-display "saved-as ircam -> ~A?" (mus-header-type-name (mus-sound-header-type "test.snd"))))
	(if (not (= (sample-type ab) mus-mulaw))
	    (snd-display "save-as mulaw -> ~A?" (mus-sample-type-name (sample-type ab))))
	(if (not (= (mus-sound-sample-type "test.snd") mus-mulaw))
	    (snd-display "saved-as mulaw -> ~A?" (mus-sample-type-name (mus-sound-sample-type "test.snd"))))
	(if (fneq (sample 1000 ab) samp) (snd-display "ircam[1000] = ~A?" (sample 1000 ab)))
	(close-sound ab))
      (save-sound-as "test.snd" ob :header-type mus-next :sample-type mus-alaw)
      (let ((ab (open-sound "test.snd")))
	(if (not (= (header-type ab) mus-next)) 
	    (snd-display "save-as next -> ~A?" (mus-header-type-name (header-type ab))))
	(if (not (= (mus-sound-header-type "test.snd") mus-next)) 
	    (snd-display "saved-as next -> ~A?" (mus-header-type-name (mus-sound-header-type "test.snd"))))
	(if (not (= (sample-type ab) mus-alaw)) 
	    (snd-display "save-as alaw -> ~A?" (mus-sample-type-name (sample-type ab))))
	(if (not (= (mus-sound-sample-type "test.snd") mus-alaw)) 
	    (snd-display "saved-as alaw -> ~A?" (mus-sample-type-name (mus-sound-sample-type "test.snd"))))
	(if (fneq (sample 1000 ab) samp) (snd-display "next (alaw)[1000] = ~A?" (sample 1000 ab)))
	(close-sound ab))
      (save-sound-as "test.snd" ob :header-type mus-next :sample-type mus-ldouble)
      (let ((ab (open-sound "test.snd")))
	(if (not (= (header-type ab) mus-next)) 
	    (snd-display "save-as dbl next -> ~A?" (mus-header-type-name (header-type ab))))
	(if (not (= (sample-type ab) mus-ldouble)) 
	    (snd-display "save-as dbl -> ~A?" (mus-sample-type-name (sample-type ab))))
	(if (fneq (sample 1000 ab) samp) (snd-display "next (dbl)[1000] = ~A?" (sample 1000 ab)))
	(close-sound ab))
      (save-sound-as "test.snd" ob :header-type mus-next :sample-type mus-bshort)
      (let ((ab (open-sound "test.snd")))
	(if (not (= (header-type ab) mus-next)) 
	    (snd-display "save-as next -> ~A?" (mus-header-type-name (header-type ab))))
	(if (not (= (mus-sound-header-type "test.snd") mus-next)) 
	    (snd-display "saved-as next -> ~A?" (mus-header-type-name (mus-sound-header-type "test.snd"))))
	(if (not (= (sample-type ab) mus-bshort)) 
	    (snd-display "save-as short -> ~A?" (mus-sample-type-name (sample-type ab))))
	(if (not (= (mus-sound-sample-type "test.snd") mus-bshort)) 
	    (snd-display "saved-as short -> ~A?" (mus-sample-type-name (mus-sound-sample-type "test.snd"))))
	(if (fneq (sample 1000 ab) samp) (snd-display "next (short)[1000] = ~A?" (sample 1000 ab)))
	(set! (hook-functions update-hook) ())
	(set! (y-bounds ab 0) (list -3.0 3.0))
	(set! (sample-type ab) mus-lshort)
	(if (not (equal? ab (find-sound "test.snd"))) (set! ab (find-sound "test.snd"))) ; these set!'s can change the index via update-sound
	(if (not (= (sample-type ab) mus-lshort)) (snd-display "set sample-type: ~A?" (mus-sample-type-name (sample-type ab))))
	(when (and with-gui
		   (not (equal? (y-bounds ab 0) '(-3.0 3.0))))
	  (snd-display "set sample type y-bounds: ~A?" (y-bounds ab 0)))
	(set! (y-bounds ab 0) (list 2.0))
	(when (and with-gui
		   (not (equal? (y-bounds ab 0) '(-2.0 2.0))))
	  (snd-display "set sample type y-bounds 1: ~A?" (y-bounds ab 0)))
	(set! (y-bounds ab 0) (list -2.0))
	(when (and with-gui
		   (not (equal? (y-bounds ab 0) '(-2.0 2.0))))
	  (snd-display "set sample type y-bounds -2: ~A?" (y-bounds ab 0)))
	(set! (header-type ab) mus-aifc)
	(if (not (equal? ab (find-sound "test.snd"))) (set! ab (find-sound "test.snd")))
	(if (not (= (header-type ab) mus-aifc)) (snd-display "set header-type: ~A?" (mus-header-type-name (header-type ab))))
	(set! (channels ab) 3)
	(if (not (equal? ab (find-sound "test.snd"))) (set! ab (find-sound "test.snd")))
	(if (not (= (channels ab) 3)) (snd-display "set chans: ~A?" (channels ab)))
	(set! (data-location ab) 1234)
	(if (not (equal? ab (find-sound "test.snd"))) (set! ab (find-sound "test.snd")))
	(if (not (= (data-location ab) 1234)) (snd-display "set data-location: ~A?" (data-location ab)))
	(let-temporarily (((data-size ab) 1234))
	  (if (not (equal? ab (find-sound "test.snd"))) (set! ab (find-sound "test.snd")))
	  (if (not (= (data-size ab) 1234)) (snd-display "set data-size: ~A?" (data-size ab))))
	(set! (srate ab) 12345)
	(if (not (equal? ab (find-sound "test.snd"))) (set! ab (find-sound "test.snd")))
	(if (not (= (srate ab) 12345)) (snd-display "set srate: ~A?" (srate ab)))
	(close-sound ab))
      (save-sound-as "test.snd" ob :header-type mus-next :sample-type mus-bfloat)
      (let ((ab (open-sound "test.snd")))
	(if (not (= (header-type ab) mus-next)) 
	    (snd-display "save-as next -> ~A?" (mus-header-type-name (header-type ab))))
	(if (not (= (mus-sound-header-type "test.snd") mus-next)) 
	    (snd-display "saved-as next -> ~A?" (mus-header-type-name (mus-sound-header-type "test.snd"))))
	(if (not (= (sample-type ab) mus-bfloat)) 
	    (snd-display "save-as float -> ~A?" (mus-sample-type-name (sample-type ab))))
	(if (not (= (mus-sound-sample-type "test.snd") mus-bfloat)) 
	    (snd-display "saved-as float -> ~A?" (mus-sample-type-name (mus-sound-sample-type "test.snd"))))
	(if (fneq (sample 1000 ab) samp) (snd-display "next (float)[1000] = ~A?" (sample 1000 ab)))
	(close-sound ab))
      (save-sound-as "test.snd" ob :header-type mus-next :sample-type mus-ldouble)
      (close-sound ob)
      (let ((ab (open-sound "test.snd")))
	(set! (sample-type) mus-lshort)
	(if (not (equal? ab (find-sound "test.snd"))) (set! ab (find-sound "test.snd")))
	(if (not (= (sample-type) mus-lshort)) (snd-display "set sample-type: ~A?" (mus-sample-type-name (sample-type))))
	(set! (header-type) mus-aifc)
	(if (not (equal? ab (find-sound "test.snd"))) (set! ab (find-sound "test.snd")))
	(if (not (= (header-type) mus-aifc)) (snd-display "set header-type: ~A?" (mus-header-type-name (header-type))))
	(set! (channels) 3)
	(if (not (equal? ab (find-sound "test.snd"))) (set! ab (find-sound "test.snd")))
	(if (not (= (channels) 3)) (snd-display "set chans: ~A?" (channels)))
	(set! (data-location) 1234)
	(if (not (equal? ab (find-sound "test.snd"))) (set! ab (find-sound "test.snd")))
	(if (not (= (data-location) 1234)) (snd-display "set data-location: ~A?" (data-location)))
	(set! (srate) 12345)
	(if (not (equal? ab (find-sound "test.snd"))) (set! ab (find-sound "test.snd")))
	(if (not (= (srate) 12345)) (snd-display "set srate: ~A?" (srate)))
	(close-sound ab)))
    
    (let ((ind (open-sound "2a.snd")))
      (save-sound-as "test.snd" :sample-type mus-l24int :header-type mus-riff :channel 0)
      (let ((ind0 (open-sound "test.snd")))
	(if (not (= (channels ind0) 1)) 
	    (snd-display "save-sound-as :channel 0 chans: ~A" (channels ind0)))
	(if (not (= (sample-type ind0) mus-l24int)) 
	    (snd-display "save-sound-as :channel 0 sample-type: ~A ~A" (sample-type ind0) (mus-sample-type-name (sample-type ind0))))
	(if (not (= (header-type ind0) mus-riff))
	    (snd-display "save-sound-as :channel 0 header-type: ~A ~A" (header-type ind0) (mus-header-type-name (header-type ind0))))
	(if (not (= (srate ind0) (srate ind)))
	    (snd-display "save-sound-as :channel 0 srates: ~A ~A" (srate ind0) (srate ind)))    
	(if (not (= (framples ind0) (framples ind 0)))
	    (snd-display "save-sound-as :channel 0 framples: ~A ~A" (framples ind0) (framples ind 0)))
	(if (fneq (maxamp ind0 0) (maxamp ind 0))
	    (snd-display "save-sound-as :channel 0 maxamps: ~A ~A" (maxamp ind0 0) (maxamp ind 0)))
	(close-sound ind0))
      (save-sound-as "test.snd" :sample-type mus-l24int :header-type mus-riff)
      (let ((ind0 (open-sound "test.snd")))
	(if (not (= (channels ind0) 2)) 
	    (snd-display "save-sound-as chans: ~A" (channels ind0)))
	(if (not (= (sample-type ind0) mus-l24int)) 
	    (snd-display "save-sound-as sample-type: ~A ~A" (sample-type ind0) (mus-sample-type-name (sample-type ind0))))
	(if (not (= (header-type ind0) mus-riff))
	    (snd-display "save-sound-as header-type: ~A ~A" (header-type ind0) (mus-header-type-name (header-type ind0))))
	(if (not (= (srate ind0) (srate ind)))
	    (snd-display "save-sound-as srates: ~A ~A" (srate ind0) (srate ind)))    
	(if (not (= (framples ind0) (framples ind 0)))
	    (snd-display "save-sound-as framples: ~A ~A" (framples ind0) (framples ind 0)))
	(if (fneq (maxamp ind0 0) (maxamp ind 0))
	    (snd-display "save-sound-as maxamps: ~A ~A" (maxamp ind0 0) (maxamp ind 0)))
	(close-sound ind0))
      (save-sound-as "test.snd" :sample-type mus-b24int :header-type mus-aiff)
      (let ((ind0 (open-sound "test.snd")))
	(if (not (= (channels ind0) 2)) 
	    (snd-display "save-sound-as chans: ~A" (channels ind0)))
	(if (not (= (sample-type ind0) mus-b24int)) 
	    (snd-display "save-sound-as sample-type: ~A ~A" (sample-type ind0) (mus-sample-type-name (sample-type ind0))))
	(if (not (= (header-type ind0) mus-aiff))
	    (snd-display "save-sound-as header-type: ~A ~A" (header-type ind0) (mus-header-type-name (header-type ind0))))
	(if (not (= (srate ind0) (srate ind)))
	    (snd-display "save-sound-as srates: ~A ~A" (srate ind0) (srate ind)))    
	(if (not (= (framples ind0) (framples ind 0)))
	    (snd-display "save-sound-as framples: ~A ~A" (framples ind0) (framples ind 0)))
	(if (fneq (maxamp ind0 0) (maxamp ind 0))
	    (snd-display "save-sound-as maxamps: ~A ~A" (maxamp ind0 0) (maxamp ind 0)))
	(close-sound ind0))
      (save-sound-as "test.snd" :sample-type mus-bfloat :header-type mus-aifc :channel 1 :srate 12345)
      (let ((ind0 (open-sound "test.snd")))
	(if (not (= (channels ind0) 1)) 
	    (snd-display "save-sound-as :channel 1 chans: ~A" (channels ind0)))
	(if (not (= (sample-type ind0) mus-bfloat)) 
	    (snd-display "save-sound-as :channel 1 sample-type: ~A ~A" (sample-type ind0) (mus-sample-type-name (sample-type ind0))))
	(if (not (= (header-type ind0) mus-aifc))
	    (snd-display "save-sound-as :channel 1 header-type: ~A ~A" (header-type ind0) (mus-header-type-name (header-type ind0))))
	(if (not (= (srate ind0) 12345))
	    (snd-display "save-sound-as :channel 1 srates: ~A ~A" (srate ind0) (srate ind)))    
	(if (not (= (framples ind0) (framples ind 1)))
	    (snd-display "save-sound-as :channel 1 framples: ~A ~A" (framples ind0) (framples ind 1)))
	(if (fneq (maxamp ind0 0) (maxamp ind 1))
	    (snd-display "save-sound-as :channel 1 maxamps: ~A ~A" (maxamp ind0 0) (maxamp ind 1)))
	(close-sound ind0))
      (save-sound-as "test.snd" :channel 1 :comment "this is a test")
      (let ((ind0 (open-sound "test.snd")))
	(if (not (= (channels ind0) 1)) 
	    (snd-display "save-sound-as :channel 1 (1) chans: ~A" (channels ind0)))
	(if (not (= (sample-type ind0) (sample-type ind)))
	    (snd-display "save-sound-as :channel 1 (1) sample-type: ~A ~A" (sample-type ind0) (mus-sample-type-name (sample-type ind0))))
	(if (not (= (header-type ind0) (header-type ind)))
	    (snd-display "save-sound-as :channel 1 (1) header-type: ~A ~A" (header-type ind0) (mus-header-type-name (header-type ind0))))
	(if (not (= (srate ind0) (srate ind)))
	    (snd-display "save-sound-as :channel 1 (1) srates: ~A ~A" (srate ind0) (srate ind)))    
	(if (not (= (framples ind0) (framples ind 1)))
	    (snd-display "save-sound-as :channel 1 (1) framples: ~A ~A" (framples ind0) (framples ind 1)))
	(if (fneq (maxamp ind0 0) (maxamp ind 1))
	    (snd-display "save-sound-as :channel 1 (1) maxamps: ~A ~A" (maxamp ind0 0) (maxamp ind 1)))
	(if (not (string=? (comment ind0) "this is a test"))
	    (snd-display "save-sound-as :channel 0 (1) comment: ~A" (comment ind0)))
	(close-sound ind0))
      (close-sound ind))
    
    (let ((fsnd (string-append sf-dir "t15.aiff")))
      (if (file-exists? fsnd)
	  (let ((ind (open-sound fsnd)))
	    (if (or (fneq (sample 132300 ind 0) .148)
		    (fneq (sample 132300 ind 1) .126))
		(snd-display "aifc sowt trouble: ~A ~A" (sample 132300 ind 0) (sample 132300 ind 1)))
	    (close-sound ind))))
    (let ((fsnd (string-append sf-dir "M1F1-float64C-AFsp.aif")))
      (if (file-exists? fsnd)
	  (let ((ind (open-sound fsnd)))
	    (if (or (fneq (sample 8000 ind 0) -0.024)
		    (fneq (sample 8000 ind 1) 0.021))
		(snd-display "aifc fl64 trouble: ~A ~A" (sample 8000 ind 0) (sample 8000 ind 1)))
	    (close-sound ind))))
    
    (for-each (lambda (n vals)
		(let ((val (catch #t (lambda () 
				       (list (mus-sound-chans n)
					     (mus-sound-srate n)
					     (mus-sound-framples n)))
				  (lambda args (car args)))))
		  (if (not (or (equal? val vals)
			       (eq? val 'mus-error)))
		      (snd-display "~A: ~A ~A" n val vals))))
	      (list (string-append sf-dir "bad_chans.snd")
		    (string-append sf-dir "bad_srate.snd")
		    (string-append sf-dir "bad_data_format.snd")
		    (string-append sf-dir "bad_chans.aifc")
		    (string-append sf-dir "bad_srate.aifc")
		    (string-append sf-dir "bad_length.aifc")
		    (string-append sf-dir "bad_chans.riff")
		    (string-append sf-dir "bad_srate.riff")
		    (string-append sf-dir "bad_chans.nist")
		    (string-append sf-dir "bad_srate.nist")
		    (string-append sf-dir "bad_length.nist"))
	      '((0 22050 0) 
		(1 0 0) 
		(1 22050 4411) 
		(0 22050 0) 
		(1 0 0) 
		(1 22050 -10) 
		(0 22050 0) 
		(1 0 0) 
		(0 22050 0) 
		(1 0 0) 
		(1 22050 -10)))
    
    (let ((ind (open-sound (string-append "/usr/include/sys/" home-dir "/cl/oboe.snd"))))
      (if (not (and (sound? ind)
		    (string=? (short-file-name ind) "oboe.snd")))
	  (snd-display "open-sound with slashes: ~A ~A" ind (and (sound? ind) (short-file-name ind))))
      (hook-push bad-header-hook (lambda (hook) (set! (hook 'result) #t)))
      (for-each (lambda (n)
		  (catch #t (lambda () 
			      (insert-sound n))
			 (lambda args (car args)))
		  (catch #t (lambda () 
			      (convolve-with n))
			 (lambda args (car args)))
		  (catch #t (lambda () 
			      (mix n))
			 (lambda args (car args)))
		  (catch #t (lambda () 
			      (let ((ind (open-sound n)))
				(if (and (number? ind)
					 (sound? ind))
				    (close-sound ind))))
			 (lambda args (car args))))
		(list (string-append sf-dir "bad_chans.snd")
		      (string-append sf-dir "bad_srate.snd")
		      (string-append sf-dir "bad_chans.aifc")
		      (string-append sf-dir "bad_srate.aifc")
		      (string-append sf-dir "bad_length.aifc")
		      (string-append sf-dir "bad_chans.riff")
		      (string-append sf-dir "bad_srate.riff")
		      (string-append sf-dir "bad_chans.nist")
		      (string-append sf-dir "bad_location.nist")
		      (string-append sf-dir "bad_field.nist")
		      (string-append sf-dir "bad_srate.nist")
		      (string-append sf-dir "bad_length.nist")))
      (close-sound ind))
    
    (for-each close-sound (sounds))
    
    (if (selected-sound)
	(snd-display "selected-sound ~A ~A" (selected-sound) (sounds)))
    
    (if (file-exists? (string-append (or sf-dir "") "a.sf2"))
	(let ((fil (open-sound (string-append (or sf-dir "") "a.sf2"))))
	  (if fil
	      (let ((loops (and fil (soundfont-info))))
		(if (or (null? loops)
			(not (= (caddar loops) 65390))
			(not (= (cadadr loops) 65490)))
		    (snd-display "soundfont-info: ~A?" loops))
		(close-sound fil)))))
    
    (if (file-exists? "fmv5.snd") (delete-file "fmv5.snd"))
    (set! *print-length* 12)
    
    (for-each
     (lambda (file)
       (let ((tag (catch #t
		    (lambda () (open-sound (string-append sf-dir file)))
		    (lambda args args))))
	 (if (not (eq? (car tag) 'mus-error))
	     (snd-display "open-sound ~A: ~A" file tag))))
     '("trunc.snd" "trunc.aiff" "trunc.wav" "trunc.sf" "trunc.voc" "trunc.nist" "bad.wav" 
       "trunc1.aiff" "badform.aiff"))
    
    (hook-push open-raw-sound-hook (lambda (hook) (set! (hook 'result) (list 1 22050 mus-bshort))))
    (let ((ind (open-sound (string-append sf-dir "empty.snd"))))
      (if (not (and (= (sample-type ind) mus-bshort)
		    (= (chans ind) 1)
		    (= (srate ind) 22050)
		    (= (data-location ind) 0)
		    (= (framples ind) 0)))
	  (snd-display "open raw: ~A ~A ~A ~A ~A" (sample-type ind) (chans ind) (srate ind) (data-location ind) (framples ind)))
      (set! (hook-functions open-raw-sound-hook) ())
      (close-sound ind))
    
    (let ((sd (make-float-vector '(1 1))))
      (if (fneq (sd 0 0) 0.0) (snd-display "vector2 ref: ~A" (sd 0 0)))
      (set! (sd 0 0) 1.0)
      (if (fneq (sd 0 0) 1.0) (snd-display "vector2 set: ~A" (sd 0 0)))
      (if (not (morally-equal? sd (let ((sd1 (make-float-vector '(1 1)))) (float-vector-set! sd1 0 0 1.0) sd1)))
	  (snd-display "vector2 set not equal: ~A" sd)))
    
    (let ((sd (make-float-vector '(2 3))))
      (if (fneq (sd 0 0) 0.0) (snd-display "vector2 ref (1): ~A" (sd 0 0)))
      (set! (sd 1 0) 1.0)
      (if (fneq (sd 1 0) 1.0) (snd-display "vector2 set (1 0): ~A" (sd 1 0)))
      (set! (sd 1 2) 2.0)
      (if (fneq (sd 1 2) 2.0) (snd-display "vector2 set (1 2): ~A" (sd 1 2)))
      (if (not (morally-equal? sd (let ((sd1 (make-float-vector '(2 3))))
				    (float-vector-set! sd1 1 0 1.0)
				    (float-vector-set! sd1 1 2 2.0)
				    sd1)))
	  (snd-display "vector2 set (3) not equal: ~A" sd)))
    
    ;; check clipping choices
    (let ((ind (view-sound "oboe.snd")))
      (set! *clipping* #f)
      (scale-channel 10.0)
      (save-sound-as "test.snd" ind :header-type mus-next :sample-type mus-ldouble)
      (undo 1 ind 0)
      (let ((ind1 (open-sound "test.snd")))
	(if (fneq (maxamp ind1 0) (* 10 (maxamp ind 0)))
	    (snd-display "clipping 0: ~A ~A" (maxamp ind1 0) (maxamp ind 0)))
	(close-sound ind1))
      (delete-file "test.snd")
      (set! *clipping* #t)
      (map-channel (lambda (y) (* y 10.0)) 0 #f ind 0)
      (save-sound-as "test.snd" ind :header-type mus-next :sample-type mus-lshort)
      (undo 1 ind 0)
      (let ((ind1 (open-sound "test.snd")))
	(if (fneq (maxamp ind1 0) 1.0)
	    (snd-display "clipping 1: ~A ~A" (maxamp ind1 0) (maxamp ind 0)))
	(close-sound ind1))
      (delete-file "test.snd")
      (set! *clipping* #f)
      (let ((sub (- 1.001 (maxamp ind))))
	(map-channel (lambda (y) (+ y sub)) 0 #f ind 0))
      (save-sound-as "test.snd" ind :header-type mus-next :sample-type mus-lfloat)
      (let ((ind1 (open-sound "test.snd"))
	    (baddy (scan-channel (lambda (y) (< y 0.0)))))
	(if baddy
	    (snd-display "clipping 2: ~A" baddy))
	(close-sound ind1))
      (delete-file "test.snd")
      (set! *clipping* #t)
      (save-sound-as "test.snd" ind :header-type mus-next :sample-type mus-ldouble)
      (let ((ind1 (open-sound "test.snd"))
	    (baddy (scan-channel (lambda (y) (< y 0.0)))))
	(if baddy
	    (snd-display "clipping 3: ~A ~A" baddy (sample baddy)))
	(close-sound ind1))
      (delete-file "test.snd")
      (set! *clipping* #f)
      (close-sound ind))
    (delete-file "fmv.snd")
    
    (set! *clipping* #f)
    (let ((snd (new-sound "test.snd" :sample-type mus-lshort)))
      (pad-channel 0 10)
      (set! (sample 1) 1.0)
      (set! (sample 2) -1.0)
      (set! (sample 3) 0.9999)
      (set! (sample 4) 2.0)
      (set! (sample 5) -2.0)
      (set! (sample 6) 1.3)
      (set! (sample 7) -1.3)
      (set! (sample 8) 1.8)
      (set! (sample 9) -1.8)
      (save-sound snd)
      (close-sound snd))
    (let ((snd (open-sound "test.snd")))
      (let ((data (channel->float-vector 0 10)))
	(if (not (mus-arrays-equal? data #r(0.0 1.0 -1.0 1.0 0.0 0.0 -0.700 0.700 -0.200 0.200)))
	    (snd-display "unclipped 1: ~A" data)))
      (close-sound snd))
    (mus-sound-forget "test.snd")
    
    (set! *clipping* #t)
    (let ((snd (new-sound "test.snd" :sample-type mus-lshort)))
      (pad-channel 0 10)
      (set! (sample 1) 1.0)
      (set! (sample 2) -1.0)
      (set! (sample 3) 0.9999)
      (set! (sample 4) 2.0)
      (set! (sample 5) -2.0)
      (set! (sample 6) 1.3)
      (set! (sample 7) -1.3)
      (set! (sample 8) 1.8)
      (set! (sample 9) -1.8)
      (save-sound snd)
      (close-sound snd))
    (let ((snd (open-sound "test.snd")))
      (let ((data (channel->float-vector 0 10)))
	(if (not (mus-arrays-equal? data #r(0.0 1.0 -1.0 1.0 1.0 -1.0 1.0 -1.0 1.0 -1.000)))
	    (snd-display "clipped: ~A" data)))
      (close-sound snd))
    (set! *clipping* #f)
    
    (let ((test-data (lambda (file beg dur data)
		       (catch #t
			 (lambda ()
			   (let* ((ind (open-sound file))
				  (ndata (channel->float-vector beg dur ind 0)))
			     (if (not (mus-arrays-equal? data ndata))
				 (snd-display "~A: ~A != ~A" file data ndata))
			     (close-sound ind)))
			 (lambda args args)))))
      (test-data (string-append sf-dir "next-dbl.snd") 10 10 #r(0.475 0.491 0.499 0.499 0.492 0.476 0.453 0.423 0.387 0.344))
      (test-data (string-append sf-dir "oboe.ldbl") 1000 10 #r(0.033 0.035 0.034 0.031 0.026 0.020 0.013 0.009 0.005 0.004))
      
      (test-data (string-append sf-dir "next-flt.snd") 10 10 #r(0.475 0.491 0.499 0.499 0.492 0.476 0.453 0.423 0.387 0.344))
      (test-data (string-append sf-dir "clbonef.wav") 1000 10 #r(0.111 0.101 0.070 0.032 -0.014 -0.060 -0.085 -0.108 -0.129 -0.152))
      
      (test-data (string-append sf-dir "next-8.snd") 10 10 #r(0.898 0.945 0.977 0.992 0.992 0.977 0.945 0.906 0.844 0.773))
      (test-data (string-append sf-dir "o2_u8.wave") 1000 10 #r(-0.164 -0.219 -0.258 -0.242 -0.180 -0.102 -0.047 0.0 0.039 0.055))
      
      (test-data (string-append sf-dir "next-16.snd") 1000 10 #r(-0.026 -0.022 -0.024 -0.030 -0.041 -0.048 -0.050 -0.055 -0.048 -0.033))
      (test-data (string-append sf-dir "o2.wave") 1000 10 #r(-0.160 -0.216 -0.254 -0.239 -0.175 -0.102 -0.042 0.005 0.041 0.059))
      
      (test-data (string-append sf-dir "o2_18bit.aiff") 1000 10 #r(-0.160 -0.216 -0.254 -0.239 -0.175 -0.102 -0.042 0.005 0.041 0.059))
      (test-data (string-append sf-dir "o2_12bit.aiff") 1000 10 #r(-0.160 -0.216 -0.254 -0.239 -0.175 -0.102 -0.042 0.005 0.041 0.059))
      
      (test-data (string-append sf-dir "next24.snd") 1000 10 #r(-0.160 -0.216 -0.254 -0.239 -0.175 -0.102 -0.042 0.005 0.041 0.059))
      (test-data (string-append sf-dir "mono24.wav") 1000 10 #r(0.005 0.010 0.016 0.008 -0.007 -0.018 -0.025 -0.021 -0.005 0.001))
      
      (test-data (string-append sf-dir "o2_711u.wave") 1000 10 #r(-0.164 -0.219 -0.254 -0.242 -0.172 -0.103 -0.042 0.005 0.042 0.060))
      (test-data (string-append sf-dir "alaw.wav") 1000 10 #r(-0.024 -0.048 -0.024 0.0 0.008 0.008 0.0 -0.040 -0.064 -0.024))
      
      ;; it is not a bug if these don't match if MUS_SAMPLE_BITS is not 24
      (test-data (string-append sf-dir "b32.pvf") 1000 10 #r(-0.160 -0.216 -0.254 -0.239 -0.175 -0.102 -0.042 0.005 0.041 0.059))
      (test-data (string-append sf-dir "b32.wave") 1000 10 #r(-0.160 -0.216 -0.254 -0.239 -0.175 -0.102 -0.042 0.005 0.041 0.059))
      (test-data (string-append sf-dir "b32.snd") 1000 10 #r(-0.160 -0.216 -0.254 -0.239 -0.175 -0.102 -0.042 0.005 0.041 0.059))
      (test-data (string-append sf-dir "32bit.sf") 1000 10 #r(0.016 0.014 0.013 0.011 0.010 0.010 0.010 0.010 0.012 0.014))
      
      (test-data (string-append sf-dir "nist-shortpack.wav") 10000 10 #r(0.021 0.018 0.014 0.009 0.004 -0.001 -0.004 -0.006 -0.007 -0.008))
      (test-data (string-append sf-dir "wood.sds") 1000 10 #r(-0.160 -0.216 -0.254 -0.239 -0.175 -0.102 -0.042 0.005 0.041 0.059))
      (test-data (string-append sf-dir "mus10.snd") 10000 10 #r(0.004 0.001 0.005 0.009 0.017 0.015 0.008 0.011 0.009 0.012))
      (test-data (string-append sf-dir "ieee-text-16.snd") 1000 10 #r(-0.052 -0.056 -0.069 -0.077 -0.065 -0.049 -0.054 -0.062 -0.066 -0.074))
      (test-data (string-append sf-dir "hcom-16.snd") 10000 10 #r(0.0 0.0 0.0 0.008 0.0 -0.016 -0.016 -0.016 -0.008 0.000))
      (test-data (string-append sf-dir "ce-c3.w02") 1000 10 #r(0.581 0.598 0.596 0.577 0.552 0.530 0.508 0.479 0.449 0.425))
      (test-data (string-append sf-dir "nasahal.avi") 20000 10 #r(0.390 0.120 -0.399 -0.131 0.464 0.189 -0.458 -0.150 0.593 0.439))
      (test-data (string-append sf-dir "oki.wav") 100 10 #r(0.396 0.564 0.677 0.779 0.761 0.540 0.209 -0.100 -0.301 -0.265))
      
      (test-data (string-append sf-dir "trumps22.adp") 5000 10 #r(0.267 0.278 0.309 0.360 0.383 0.414 0.464 0.475 0.486 0.495)))
    
    (let ((errs (list "no error" "no frequency method" "no phase method" "null gen arg to method" "no length method"
		      "no describe method" "no data method" "no scaler method"
		      "memory allocation failed" 
		      "can't open file" "no sample input" "no sample output"
		      "no such channel" "no file name provided" "no location method" "no channel method"
		      "no such fft window" "unknown sample type" "header read failed"
		      "unknown header type" "file descriptors not initialized" "not a sound file" "file closed" "write error"
		      "header write failed" "can't open temp file" "interrupted" "bad envelope"
		      "audio channels not available" "audio srate not available" "audio sample type not available"
		      "no audio input available" "audio configuration not available" 
		      "audio write error" "audio size not available" "audio device not available"
		      "can't close audio" "can't open audio" "audio read error"
		      "can't write audio" "can't read audio" "no audio read permission" 
		      "can't close file" "arg out of range" 
		      "no channels method" "no hop method" "no width method" "no file-name method" "no ramp method" "no run method"
		      "no increment method" "no offset method"
		      "no xcoeff method" "no ycoeff method" "no xcoeffs method" "no ycoeffs method" "no reset" "bad size" "can't convert"
		      "read error"
		      "no feedforward method" "no feedback method" "no interp-type method" "no position method" "no order method" "no copy method"
		      "can't translate"
		      )))
      (do ((len (length errs))
	   (i 0 (+ i 1)))
	    ((or (= i len)
		 (not (string=? (errs i) (mus-error-type->string i))))
	     (if (not (= i len))
		 (snd-display "mus-error-type->string ~D: ~A ~A" i (errs i) (mus-error-type->string i))))))

    (let ((cur-srate (mus-sound-srate "oboe.snd"))
	  (cur-chans (mus-sound-chans "oboe.snd"))
	  (cur-format (mus-sound-sample-type "oboe.snd"))
	  (cur-type (mus-sound-header-type "oboe.snd"))
	  (cur-loc (mus-sound-data-location "oboe.snd"))
	  (cur-samps (mus-sound-samples "oboe.snd")))
      (set! (mus-sound-srate "oboe.snd") (* cur-srate 2))
      (if (not (= (* cur-srate 2) (mus-sound-srate "oboe.snd"))) 
	  (snd-display "set mus-sound-srate: ~A -> ~A" cur-srate (mus-sound-srate "oboe.snd")))
      (set! (mus-sound-samples "oboe.snd") (* cur-samps 2))
      (if (not (= (* cur-samps 2) (mus-sound-samples "oboe.snd"))) 
	  (snd-display "set mus-sound-samples: ~A -> ~A" cur-samps (mus-sound-samples "oboe.snd")))
      (set! (mus-sound-chans "oboe.snd") (* cur-chans 2))
      (if (not (= (* cur-chans 2) (mus-sound-chans "oboe.snd"))) 
	  (snd-display "set mus-sound-chans: ~A -> ~A" cur-chans (mus-sound-chans "oboe.snd")))
      (set! (mus-sound-data-location "oboe.snd") (* cur-loc 2))
      (if (not (= (* cur-loc 2) (mus-sound-data-location "oboe.snd"))) 
	  (snd-display "set mus-sound-data-location: ~A -> ~A" cur-loc (mus-sound-data-location "oboe.snd")))
      (set! (mus-sound-header-type "oboe.snd") mus-nist)
      (if (not (= mus-nist (mus-sound-header-type "oboe.snd"))) 
	  (snd-display "set mus-sound-header-type: ~A -> ~A" cur-type (mus-sound-header-type "oboe.snd")))
      (set! (mus-sound-sample-type "oboe.snd") mus-lintn)
      (if (not (= mus-lintn (mus-sound-sample-type "oboe.snd"))) 
	  (snd-display "set mus-sound-sample-type: ~A -> ~A" cur-format (mus-sound-sample-type "oboe.snd")))
      (set! (mus-sound-srate "oboe.snd") cur-srate)
      (set! (mus-sound-samples "oboe.snd") cur-samps)
      (set! (mus-sound-chans "oboe.snd") cur-chans)
      (set! (mus-sound-data-location "oboe.snd") cur-loc)
      (set! (mus-sound-header-type "oboe.snd") cur-type)
      (set! (mus-sound-sample-type "oboe.snd") cur-format))
    
    (let ((ind (open-sound "oboe.snd")))
      (save-sound-as "test.wave" ind :header-type mus-riff)
      (save-sound-as "test.rf64" ind :header-type mus-rf64)
      (save-sound-as "test.aifc" ind :header-type mus-aifc)
      (close-sound ind)
      
      (for-each
       (lambda (file)
	 (let ((cur-srate (mus-sound-srate file))
	       (cur-chans (mus-sound-chans file))
	       (cur-format (mus-sound-sample-type file))
	       (cur-type (mus-sound-header-type file))
	       (cur-loc (mus-sound-data-location file))
	       (cur-samps (mus-sound-samples file)))
	   (set! (mus-sound-srate file) (* cur-srate 2))
	   (if (not (= (* cur-srate 2) (mus-sound-srate file))) 
	       (snd-display "~A: set mus-sound-srate: ~A -> ~A" file cur-srate (mus-sound-srate file)))
	   (set! (mus-sound-samples file) (* cur-samps 2))
	   (if (not (= (* cur-samps 2) (mus-sound-samples file))) 
	       (snd-display "~A: set mus-sound-samples: ~A -> ~A" file cur-samps (mus-sound-samples file)))
	   (set! (mus-sound-chans file) (* cur-chans 2))
	   (if (not (= (* cur-chans 2) (mus-sound-chans file))) 
	       (snd-display "~A: set mus-sound-chans: ~A -> ~A" file cur-chans (mus-sound-chans file)))
	   (set! (mus-sound-data-location file) (* cur-loc 2))
	   (if (not (= (* cur-loc 2) (mus-sound-data-location file))) 
	       (snd-display "~A: set mus-sound-data-location: ~A -> ~A" file cur-loc (mus-sound-data-location file)))
	   (set! (mus-sound-header-type file) mus-nist)
	   (if (not (= mus-nist (mus-sound-header-type file))) 
	       (snd-display "~A: set mus-sound-header-type: ~A -> ~A" file cur-type (mus-sound-header-type file)))
	   (set! (mus-sound-sample-type file) mus-lintn)
	   (if (not (= mus-lintn (mus-sound-sample-type file))) 
	       (snd-display "~A: set mus-sound-sample-type: ~A -> ~A" file cur-format (mus-sound-sample-type file)))
	   (set! (mus-sound-srate file) cur-srate)
	   (set! (mus-sound-samples file) cur-samps)
	   (set! (mus-sound-chans file) cur-chans)
	   (set! (mus-sound-data-location file) cur-loc)
	   (set! (mus-sound-header-type file) cur-type)
	   (set! (mus-sound-sample-type file) cur-format)))
       '("test.wave" "test.rf64" "test.aifc"))
      
      (for-each 
       (lambda (file)
	 (let ((ind (open-sound file)))
	   (let ((cur-srate (srate ind))
		 (cur-chans (chans ind))
		 (cur-format (sample-type ind))
		 (cur-type (header-type ind))
		 (cur-loc (data-location ind))
		 (cur-samps (framples ind)))
	     (set! (srate ind) (* cur-srate 2))
	     (if (not (= (* cur-srate 2) (srate ind))) 
		 (snd-display "~A: set srate: ~A -> ~A" file cur-srate (srate ind)))
	     (set! (framples ind) (* cur-samps 2))
	     (if (not (= (* cur-samps 2) (framples ind))) 
		 (snd-display "~A: set framples: ~A -> ~A" file cur-samps (framples ind)))
	     (set! (chans ind) (* cur-chans 2)) ; this can change the index
	     (let ((xind (find-sound file)))
	       (if (not (equal? ind xind))
		   (set! ind xind)))
	     (if (not (= (* cur-chans 2) (chans ind))) 
		 (snd-display "~A: set chans: ~A -> ~A" file cur-chans (chans ind)))
	     (set! (data-location ind) (* cur-loc 2))
	     (if (not (= (* cur-loc 2) (data-location ind))) 
		 (snd-display "~A: set data-location: ~A -> ~A" file cur-loc (data-location ind)))
	     (set! (header-type ind) mus-nist)
	     (if (not (= mus-nist (header-type ind))) 
		 (snd-display "~A: set header-type: ~A -> ~A" file cur-type (header-type ind)))
	     (set! (sample-type ind) mus-lintn)
	     (if (not (= mus-lintn (sample-type ind))) 
		 (snd-display "~A: set sample-type: ~A -> ~A" file cur-format (sample-type ind)))
	     (set! (srate ind) cur-srate)
	     (set! (framples ind) cur-samps)
	     (set! (chans ind) cur-chans)
	     (set! (data-location ind) cur-loc)
	     (set! (header-type ind) cur-type)
	     (set! (sample-type ind) cur-format))
	   (close-sound ind))
	 (if (file-exists? file)
	     (delete-file file)))
       '("test.wave" "test.rf64" "test.aifc")))
    
    ;;	  (with-sound (big-file-name :srate 44100 :play #f)
    ;;	    (do ((i 0 (+ i 1))) ((= i 72000))
    ;;	      (fm-violin i .1 440 (+ .01 (* (/ i 72000.0) .9)))))
    
    (when with-big-file
      (let ((probable-framples (floor (* (floor *clm-srate*) 71999.1)))) ; silence as last .9 secs, so it probably wasn't written
	(if (not (= (mus-sound-samples big-file-name) 3175160310))
	    (snd-display "bigger samples: ~A" (mus-sound-samples big-file-name)))
	(if (not (= (mus-sound-framples big-file-name) 3175160310))
	    (snd-display "bigger framples: ~A" (mus-sound-framples big-file-name)))
	(if (not (= (mus-sound-framples big-file-name) probable-framples))
	    (snd-display "bigger framples: ~A (probable: ~A)" (mus-sound-framples big-file-name) probable-framples))
	(if (not (= (mus-sound-length big-file-name) 6350320648))
	    (snd-display "bigger bytes: ~A" (mus-sound-length big-file-name)))
	(if (fneq (mus-sound-duration big-file-name) 71999.1015)
	    (snd-display "bigger dur: ~A" (mus-sound-duration big-file-name)))
	(let ((ind (open-sound big-file-name)))
	  (if (not (= (framples ind) 3175160310)) (snd-display "bigger framples: ~A" (framples ind)))
	  (set! big-file-framples (framples ind))
	  (if (not (= (framples ind) probable-framples)) (snd-display "bigger framples: ~A (probable: ~A)" (framples ind) probable-framples))
	  (if (not (= (framples ind 0 0) big-file-framples)) (snd-display "bigger edpos-framples: ~A" (framples ind)))
	  (let ((m1 (add-mark (* (floor *clm-srate*) 50000) ind)))
	    (if (not (= (mark-sample m1) (* (floor *clm-srate*) 50000))) (snd-display "bigger mark at: ~A" (mark-sample m1)))
	    (set! (mark-sample m1) (* (floor *clm-srate*) 66000))
	    (if (not (= (mark-sample m1) (* (floor *clm-srate*) 66000))) (snd-display "bigger mark to: ~A" (mark-sample m1))))
	  (let ((mx (mix-sound "oboe.snd" (* (floor *clm-srate*) 60000))))
	    (if (not (mix? mx))
		(snd-display "no mix tag from mix-sound")
		(begin
		  (if (not (= (mix-position mx) (* (floor *clm-srate*) 60000))) (snd-display "bigger mix at: ~A" (mix-position mx)))
		  (set! (mix-position mx) (* (floor *clm-srate*) 61000))
		  (if (not (= (mix-position mx) (* (floor *clm-srate*) 61000))) (snd-display "bigger mix to: ~A" (mix-position mx)))))
	    (undo 2))
	  (let ((res (scan-channel (lambda (y) (> (abs y) 0.0)))))
	    (if (or (not (pair? res))
		    (> (cadr res) 100))
		(snd-display "bigger find not 0.0: ~A" res)))
	  (let-temporarily ((*selection-creates-region* #f))
	    (select-all ind)
	    (if (not (= (selection-framples) (framples ind))) (snd-display "bigger select all: ~A ~A" (selection-framples) (framples)))
	    (set! (selection-position) (* (floor *clm-srate*) 50000))
	    (if (not (= (selection-position) (* (floor *clm-srate*) 50000))) (snd-display "bigger select pos: ~A" (selection-position)))
	    (set! (selection-position) 0)
	    (set! (selection-framples) (* (floor *clm-srate*) 65000))
	    (if (not (= (selection-framples) (* (floor *clm-srate*) 65000))) (snd-display "bigger select len: ~A" (selection-framples))))
	  (let ((size 2260597782))   ;(* 44123 51234))
	    (set! (cursor ind) (* (floor *clm-srate*) 50000))
	    (if (not (= (cursor ind) (* (floor *clm-srate*) 50000))) (snd-display "bigger cursor: ~A" (cursor ind)))
	    (let ((m1 (add-mark size ind)))
	      (if (not (= (mark-sample m1) size)) (snd-display "bigger mark at: ~A" (mark-sample m1)))
	      (let ((mid (find-mark size)))
		(if (not (and (number? mid) (= mid m1))) (snd-display "bigger mark seach: ~A ~A" mid m1))))
	    (let* ((msize 2701827782) ;(* 44123 61234)
		   (mx (mix-sound "oboe.snd" msize))
		   (mxd (find-mix msize)))
	      (if (not (and (number? mxd) (= mxd mx))) (snd-display "bigger find-mix ~A ~A" mxd mx)))
	    (set! (cursor ind) size)
	    (if (not (= (cursor ind) size)) (snd-display "bigger cursor 123: ~A" (cursor ind))))
	  (close-sound ind))))
    
    (let ((ind (new-sound "tmp.snd" 1 22050 mus-l24int mus-riff :size 100000)))
      (let-temporarily ((*selection-creates-region* #t))
	(let ((incr (/ 1.0 (framples)))
	      (data (make-float-vector (framples))))
	  (outa->fv data (- (* i incr) 0.5))
	  (float-vector->channel data))
	(save-sound)
	(close-sound ind)))

    (let ((ind (open-sound "tmp.snd")))
      (let ((reg (select-all))
	    (v1 (make-float-vector 100000)))
	(save-selection "tmp1.snd" 22050 mus-l24int mus-next)
	(let ((ind1 (open-sound "tmp1.snd")))
	  (let ((incr (/ 1.0 (framples))))
	    (outa->fv v1 (- (* i incr) 0.5))
	    (let ((v0 (samples 0 100000 ind1 0)))
	      (if (not (mus-arrays-equal? v0 v1))
		  (snd-display "l24 (next) selection not saved correctly? ~A" v0))))
	  (close-sound ind1))
	  
	(save-selection "tmp1.snd" 22050 mus-l24int mus-aifc)
	(let ((ind1 (open-sound "tmp1.snd")))
	  (let ((v0 (samples 0 100000 ind1 0)))
	    (if (not (mus-arrays-equal? v0 v1))
		(snd-display "l24 (aifc) selection not saved correctly? ~A" v0)))
	  (close-sound ind1))
	
	(save-region reg "tmp1.snd" mus-l24int mus-next)
	(let ((ind1 (open-sound "tmp1.snd")))
	  (let ((v0 (samples 0 100000 ind1 0)))
	    (if (not (mus-arrays-equal? v0 v1))
		(snd-display "l24 (next) region not saved correctly? ~A" v0)))
	  (close-sound ind1))
	(delete-file "tmp1.snd")
	(close-sound ind)
	(delete-file "tmp.snd")))
    
    (let ((ind (new-sound "tmp.snd" 1 22050 mus-ldouble mus-next :size 10 :comment #f)))
      (map-channel (lambda (y) 1.0))
      (env-channel '(0 0 .1 .1 .2 .2 .3 .3 .4 .4 .5 .5 .6 .6 .7 .7 .8 .8 .9  .9))
      (if (not (mus-arrays-equal? (channel->float-vector) #r(0.0 0.100 0.200 0.300 0.400 0.500 0.600 0.700 0.800 0.900)))
	  (snd-display "ramp env by .1: ~A" (channel->float-vector)))
      (close-sound ind)))
  
  (set! (hook-functions open-raw-sound-hook) ())
  (hook-push open-raw-sound-hook (lambda (hook) (set! (hook 'result) #t)))
  (set! (hook-functions bad-header-hook) ())
  (hook-push bad-header-hook (lambda (hook) (set! (hook 'result) #t)))
  (if (null? (hook-functions open-raw-sound-hook)) (snd-display "add hook open-raw-sound-hook failed??"))
  (if (null? (hook-functions bad-header-hook)) (snd-display "add hook bad-header-hook failed??"))
  (let ((magic-words (vector ".snd" "FORM" "AIFF" "AIFC" "COMM" "COMT" "INFO" "INST" "inst" "MARK" "SSND"
			     "FVER" "NONE" "ULAW" "ulaw" "ima4" "raw " "sowt" "in32" "in24" "ni23" "fl32"
			     "FL32" "fl64" "twos" "ALAW" "alaw" "APPL" "CLM " "RIFF" "RIFX" "WAVE" "fmt "
			     "data" "fact" "clm " "NIST" "8SVX" "16SV" "Crea" "tive" "SOUN" "D SA" "MPLE"
			     "BODY" "VHDR" "CHAN" "ANNO" "NAME" "2BIT" "HCOM" "FSSD" "%//\n" "%---" "ALaw"
			     "Soun" "MAUD" "MHDR" "MDAT" "mdat" "MThd" "sfbk" "sdta" "shdr" "pdta"
			     "LIST" "GF1P" "ATCH" "$SIG" "NAL_" "GOLD" " SAM" "SRFS" "Diam" "ondW" "CSRE"
			     "SND " "SNIN" "SNDT" "DDSF" "FSMu" "UWFD" "LM89" "SY80" "SY85" "SCRS" "DSPL"
			     "AVI " "strf" "movi" "PRAM" " paf" "fap " "DS16" "HEDR" "HDR8" "SDA_" "SDAB"
			     "SD_B" "NOTE" "file" "=sam" "SU7M" "SU7R" "PVF1" "PVF2" "AUTH" "riff" "TWIN"
			     "IMPS" "SMP1" "Maui" "SDIF")))
    (let ((len (length magic-words))
	  (ctr 0))
      (for-each
       (lambda (magic)
	 (if (null? (hook-functions open-raw-sound-hook)) (snd-display "open-raw-sound-hook cleared??"))
	 (if (null? (hook-functions bad-header-hook)) (snd-display "bad-header-hook cleared??"))
	 (if (file-exists? "test.snd")
	     (delete-file "test.snd"))
	 (mus-sound-forget "test.snd")
	 ;; try random garbage
	 (with-output-to-file "test.snd"
	   (lambda ()
	     (display magic)
	     (do ((i 0 (+ i 1)))
		 ((= i 128))
	       (write (random 1.0)))))
	 (let ((tag (catch #t
		      (lambda ()
			(open-sound "test.snd"))
		      (lambda args (car args)))))
	   (when (and (number? tag)
		      (sound? tag))
	     (snd-display "open-sound garbage ~A: ~A -> ~A?" magic tag (file->string "test.snd"))
	     (if (sound? tag) (close-sound tag))))
	 (delete-file "test.snd")
	 (mus-sound-forget "test.snd")
	 ;; try plausible garbage
	 (with-output-to-file "test.snd"
	   (lambda ()
	     (display magic)
	     (do ((i 0 (+ i 1)))
		 ((= i 128))
	       (write (random 128)))))
	 (let ((tag (catch #t
		      (lambda ()
			(open-sound "test.snd"))
		      (lambda args (car args)))))
	   (when (and (number? tag)
		      (sound? tag))
	     (snd-display "open-sound plausible garbage ~A: ~A?" magic tag)
	     (if (sound? tag) (close-sound tag))))
	 (delete-file "test.snd")
	 (mus-sound-forget "test.snd")
	 ;; write very plausible garbage
	 (with-output-to-file "test.snd"
	   (lambda ()
	     (display magic)
	     (do ((i 1 (+ i 1)))
		 ((= i 12))
	       (display (magic-words (if (< (+ ctr i) len) (+ ctr i) i))))))
	 (let ((tag (catch #t
		      (lambda ()
			(open-sound "test.snd"))
		      (lambda args (car args)))))
	   (when (and (number? tag)
		      (sound? tag))
	     (snd-display "open-sound very plausible garbage ~A: ~A?" magic tag)
	     (if (sound? tag) (close-sound tag))))
	 (set! ctr (+ ctr 1)))
       magic-words)))
  (if (file-exists? "test.snd") (delete-file "test.snd"))
  (mus-sound-forget "test.snd")
  
  (with-output-to-file "test.snd"
    (lambda ()
      (display ".snd")
      (for-each write-byte '(0 0 0 28 0 1 141 24 0 0 0 18 0 0 86 34 0 0 0 1 0 0 0 0 0 1))))
  (if (not (= (mus-sound-sample-type "test.snd") mus-bshort))
      (snd-display "next 18: ~A" (mus-sound-sample-type "test.snd")))
  (delete-file "test.snd")
  (mus-sound-forget "test.snd")
  (with-output-to-file "test.snd"
    (lambda ()
      (display ".snd")
      (for-each write-byte '(0 0 0 4 0 1 141 24 0 0 0 18 0 0 86 34 0 0 0 1 0 0 0 0 0 1))))
  (let ((tag (catch #t
	       (lambda ()
		 (open-sound "test.snd"))
	       (lambda args (car args)))))
    (when (and (number? tag)
	       (sound? tag))
      (snd-display "open-sound next bad location ~A: ~A?" (data-location tag) tag)
      (close-sound tag)))
  (delete-file "test.snd")
  (mus-sound-forget "test.snd")
  
  (let ((make-aifc-file 
	 (lambda (len auth-lo bits)
	   (with-output-to-file "test.aif"
	     (lambda ()
	       (display "FORM")
	       (for-each write-byte '(0 0 0 102))
	       (display "AIFCFVER")
	       (for-each write-byte '(0 0 0 4 162 128 81 64))
	       (display "COMM")
	       (for-each write-byte (list 0 0 0 38 0 1 0 0 0 len 0 bits 64 14 172 68 0 0 0 0 0 0))
	       ;; srate as 80-bit float (sheesh)
	       (display "NONE") ; compression
	       (write-byte #o016) ; pascal string len
	       (display "not compressed")
	       (write-byte #o000)
	       (display "AUTH")
	       (for-each write-byte (list 0 0 0 auth-lo))
	       (display "bil")
	       (write-byte #o000)
	       (display "SSND")
	       (for-each write-byte '(0 0 0 12 0 0 0 0 0 0 0 0 0 65 0 64)))))))
    (if (file-exists? "test.aif") (delete-file "test.aif"))
    (mus-sound-forget "test.aif")
    ;; correct (make-aifc-file #o002 #o004 #o020)
    (make-aifc-file #o102 #o004 #o020)
    
    (catch #t
      (lambda ()
	(let ((ind (open-sound "test.aif")))
	  (if (not (= (framples ind) 2)) (snd-display "bad framples in header: ~A" (framples ind)))
	  (close-sound ind)))
      (lambda args (snd-display "~S" args)))
    (delete-file "test.aif")
    (mus-sound-forget "test.aif")
    (make-aifc-file #o002 #o150 #o020)
    (let ((tag (catch #t
		 (lambda ()
		   (open-sound "test.aif"))
		 (lambda args (car args)))))
      (when (and (number? tag)
		 (sound? tag))
	(snd-display "open-sound aifc no ssnd chunk ~A: ~A?" (data-location tag) tag)
	(close-sound tag)))
    (delete-file "test.aif")
    (mus-sound-forget "test.aif")
    (make-aifc-file #o002 #o000 #o020)
    
    (let ((tag (catch #t
		 (lambda ()
		   (open-sound "test.aif"))
		 (lambda args (car args)))))
      (when (and (number? tag)
		 (sound? tag))
	(snd-display "open-sound aifc 0-len auth chunk ~A: ~A?" (data-location tag) tag)
	(close-sound tag)))
    (delete-file "test.aif")
    (mus-sound-forget "test.aif")
    (make-aifc-file #o002 #o150 #o120)
    (let ((tag (catch #t
		 (lambda ()
		   (open-sound "test.aif"))
		 (lambda args (car args)))))
      (when (and (number? tag)
		 (sound? tag))
	(snd-display "open-sound bits 80 ~A: ~A?" (sample-type tag) tag)
	(close-sound tag)))
    (delete-file "test.aif")
    (mus-sound-forget "test.aif"))
  
  (with-output-to-file "test.aif"
    (lambda ()
      (display "FORM")
      (for-each write-byte '(0 0 0 126))
      (display "AIFCFVER")
      (for-each write-byte '(0 0 0 4 162 128 81 64))
      (display "COMM")
      (for-each write-byte '(0 0 0 38 0 1 0 0 0 2 0 16 64 14 172 68 0 0 0 0 0 0))
      (display "NONE") ; compression
      (write-byte #o016) ; pascal string len
      (display "not compressed")
      (write-byte #o000)
      (display "AUTH")
      (for-each write-byte '(0 0 0 4))
      (display "bil")
      (write-byte #o000)
      (display "ANNO")
      (for-each write-byte '(0 0 0 4))
      (display "cat")
      (write-byte #o000)
      (display "NAME")
      (for-each write-byte '(0 0 0 4))
      (display "dog")
      (write-byte #o000)
      (display "SSND")
      (for-each write-byte '(0 0 0 12 0 0 0 0 0 0 0 0 0 65 0 64))))
  (catch #t
    (lambda ()
      (if (not (= (length (mus-sound-comment "test.aif")) 15))
	  (snd-display "aifc 3 aux comments: ~A?" (mus-sound-comment "test.aif"))))
    (lambda args (snd-display "~S" args)))
  (delete-file "test.aif")
  (mus-sound-forget "test.aif")
  (with-output-to-file "test.aif"
    (lambda ()
      (display "FORM")
      (for-each write-byte '(0 0 0 98))
      (display "AIFC")
      (display "SSND")
      (for-each write-byte '(0 0 0 12 0 0 0 0 0 0 0 0 0 65 0 64))
      (display "COMM")
      (for-each write-byte '(0 0 0 38 0 1 0 0 0 2 0 16 64 14 172 68 0 0 0 0 0 0))
      (display "NONE") ; compression
      (write-byte #o016) ; pascal string len
      (display "not compressed")
      (write-byte #o000)
      (display "COMT")
      (for-each write-byte '(0 0 0 12 0 0 0 0 0 0 0 0))
      (display "bil")
      (write-byte #o000)))
  
  (catch #t
    (lambda ()
      (if (not (string=? (substring (mus-sound-comment "test.aif") 0 3) "bil"))
	  (snd-display "aifc trailing comt comment: ~A?" (mus-sound-comment "test.aif"))))
    (lambda args (snd-display "~S" args)))
  (if (not (= (mus-sound-framples "test.aif") 2))
      (snd-display "aifc trailing comt framples: ~A?" (mus-sound-framples "test.aif")))
  (catch #t
    (lambda ()
      (let ((ind (open-sound "test.aif")))
	(if (or (fneq (sample 0) 0.00198)
		(fneq (sample 1) 0.00195)
		(fneq (sample 2) 0.0)
		(fneq (sample 3) 0.0))
	    (snd-display "aifc trailing comt samps: ~A ~A ~A ~A" (sample 0) (sample 1) (sample 2) (sample 3)))
	(close-sound ind)))
    (lambda args (snd-display "~S" args)))
  (delete-file "test.aif")
  (mus-sound-forget "test.aif")
  (with-output-to-file "test.aif"
    (lambda ()
      (display "FORM")
      (for-each write-byte '(0 0 0 98))
      (display "AIFC")
      (display "SSND")
      (for-each write-byte '(0 0 0 12 0 0 0 0 0 0 0 0 0 65 0 64))
      (display "COMM")
      (for-each write-byte '(0 0 0 38 0 1 0 0 64 66 0 16 64 14 172 68 0 0 0 0 0 0))
      (display "NONE") ; compression
      (write-byte #o016) ; pascal string len
      (display "not compressed")
      (write-byte #o000)
      (display "COMT")
      (for-each write-byte '(0 0 0 12 0 0 0 0 0 0 0 0))
      (display "bil")
      (write-byte #o000)))
  (if (not (and (string? (mus-sound-comment "test.aif"))
		(string=? (substring (mus-sound-comment "test.aif") 0 3) "bil")))
      (snd-display "aifc trailing comt comment: ~A?" (mus-sound-comment "test.aif")))
  (if (not (= (mus-sound-framples "test.aif") 2))
      (snd-display "aifc trailing comt (bogus) framples: ~A?" (mus-sound-framples "test.aif")))
  (catch #t
    (lambda ()
      (let ((ind (open-sound "test.aif")))
	(if (or (fneq (sample 0) 0.00198)
		(fneq (sample 1) 0.00195)
		(fneq (sample 2) 0.0)
		(fneq (sample 3) 0.0))
	    (snd-display "aifc trailing comt samps (bogus frame setting): ~A ~A ~A ~A" (sample 0) (sample 1) (sample 2) (sample 3)))
	(close-sound ind)))
    (lambda args (snd-display "~S" args)))
  (delete-file "test.aif")
  (mus-sound-forget "test.aif")
  (with-output-to-file "test.aif"
    (lambda ()
      (display "FORM")
      (for-each write-byte '(0 0 0 98))
      (display "AIFC")
      (display "SSND")
      (for-each write-byte '(0 0 0 12 0 0 0 0 0 0 0 0 0 65 0 64))
      (display "COMM")
      (for-each write-byte '(0 0 0 38 0 1 0 0 64 66 0 16 64 14 172 68 0 0 0 0 0 0))
      (display "NONE") ; compression
      (write-byte #o016) ; pascal string len
      (display "not compressed")
      (write-byte #o000)
      (display "SSND")
      (for-each write-byte '(0 0 0 12 0 0 0 0 0 0 0 0 0 65 0 64))))
  
  (let ((tag (catch #t
	       (lambda ()
		 (open-sound "test.aif"))
	       (lambda args (car args)))))
    (when (and (number? tag)
	       (sound? tag))
      (snd-display "open-sound aifc 2 ssnd chunks ~A: ~A?" (data-location tag) tag)
      (close-sound tag)))
  (delete-file "test.aif")
  (mus-sound-forget "test.aif")
  
  (with-output-to-file "test.aif"
    (lambda ()
      (display "FORM")
      (for-each write-byte '(0 0 0 32))
      (display "AIFC")
      (display "SSND")
      (for-each write-byte '(0 0 0 12 0 0 0 0 0 0 0 0 0 65 0 64))))
  (let ((tag (catch #t
	       (lambda ()
		 (open-sound "test.aif"))
	       (lambda args (car args)))))
    (unless (eq? tag 'mus-error)
      (snd-display "open-sound aifc no comm chunk ~A?" tag)
      (if (and (number? tag)
	       (sound? tag))
	  (close-sound tag))))
  (delete-file "test.aif")
  (mus-sound-forget "test.aif")
  
  (with-output-to-file "test.aif"
    (lambda ()
					;write AIFC with trailing chunks to try to confuse file->sample
      (display "FORM")
      (for-each write-byte '(0 0 0 126))
      (display "AIFCFVER")
      (for-each write-byte '(0 0 0 4 162 128 81 64))
      (display "COMM")
      (for-each write-byte '(0 0 0 38 0 1 0 0 0 2 0 16 64 14 172 68 0 0 0 0 0 0))
      (display "NONE") ; compression
      (write-byte #o016) ; pascal string len
      (display "not compressed")
      (write-byte #o000)
      (display "SSND")
      (for-each write-byte '(0 0 0 12 0 0 0 0 0 0 0 0 120 65 64 64))
      (display "AUTH")
      (for-each write-byte '(0 0 0 4))
      (display "bil")
      (write-byte #o000)
      (display "ANNO")
      (for-each write-byte '(0 0 0 4))
      (display "cat")
      (write-byte #o000)
      (display "NAME")
      (for-each write-byte '(0 0 0 4))
      (display "dog")
      (write-byte #o000)))
  (catch #t
    (lambda ()
      (let ((gen (make-file->sample "test.aif")))
	(if (fneq (gen 0) 0.93948) (snd-display "file->sample chunked 0: ~A" (gen 0)))
	(if (fneq (gen 1) 0.50195) (snd-display "file->sample chunked 1: ~A" (gen 1)))
	(if (fneq (gen 2) 0.0) (snd-display "file->sample chunked eof: ~A" (gen 2)))
	(if (fneq (gen 3) 0.0) (snd-display "file->sample chunked eof+1: ~A" (gen 3))))
      (let ((file (open-sound "test.aif")))
	(if (not (= (framples file) 2)) (snd-display "chunked framples: ~A" (framples file)))
	(if (fneq (sample 0) 0.93948) (snd-display "file chunked 0: ~A" (sample 0)))
	(if (fneq (sample 1) 0.50195) (snd-display "file chunked 1: ~A" (sample 1)))
	(if (fneq (sample 2) 0.0) (snd-display "file chunked eof: ~A" (sample 2)))
	(if (fneq (sample 3) 0.0) (snd-display "file chunked eof+1: ~A" (sample 3)))
	(close-sound file)))
    (lambda args (snd-display "~S" args)))
  (catch #t
    (lambda ()
      (if (not (= (mus-sound-framples "test.aif") 2)) (snd-display "chunked mus-sound-framples: ~A" (mus-sound-framples "test.aif"))))
    (lambda args (snd-display "~S" args)))
  (delete-file "test.aif")
  (mus-sound-forget "test.aif")
  
  (with-output-to-file "test.aif"
    (lambda ()
					;write AIFC with trailing chunks to try to confuse file->sample
      (display "FORM")
      (for-each write-byte '(0 0 0 126))
      (display "AIFCFVER")
      (for-each write-byte '(0 0 0 4 162 128 81 64))
      (display "SSND")
      (for-each write-byte '(0 0 0 12 0 0 0 0 0 0 0 0 120 65 64 64))
      (display "COMM")
      (for-each write-byte '(0 0 0 38 0 1 0 0 0 2 0 16 64 14 172 68 0 0 0 0 0 0))
      (display "NONE") ; compression
      (write-byte #o016) ; pascal string len
      (display "not compressed")
      (write-byte #o000)
      (display "APPL")
      (for-each write-byte (list 0 0 0 (char->integer #\h)))
      (display "CLM ;Written Mon 02-Nov-98 01:44 CST by root at ockeghem (Linux/X86) using Allegro CL, clm of 20-Oct-98")
      (write-byte #o000)))
  (catch #t
    (lambda ()
      (let ((gen (make-file->sample "test.aif")))
	(if (fneq (gen 0) 0.93948) (snd-display "file->sample chunked 0: ~A" (gen 0)))
	(if (fneq (gen 1) 0.50195) (snd-display "file->sample chunked 1: ~A" (gen 1)))
	(if (fneq (gen 2) 0.0) (snd-display "file->sample chunked eof: ~A" (gen 2)))
	(if (fneq (gen 3) 0.0) (snd-display "file->sample chunked eof+1: ~A" (gen 3))))
      (let ((file (open-sound "test.aif")))
	(if (not (= (framples file) 2)) (snd-display "chunked framples: ~A" (framples file)))
	(if (fneq (sample 0) 0.93948) (snd-display "file chunked 0: ~A" (sample 0)))
	(if (fneq (sample 1) 0.50195) (snd-display "file chunked 1: ~A" (sample 1)))
	(if (fneq (sample 2) 0.0) (snd-display "file chunked eof: ~A" (sample 2)))
	(if (fneq (sample 3) 0.0) (snd-display "file chunked eof+1: ~A" (sample 3)))
	(if (not (equal? (comment) ";Written Mon 02-Nov-98 01:44 CST by root at ockeghem (Linux/X86) using Allegro CL, clm of 20-Oct-98"))
	    (snd-display "chunked appl comment: ~A" (comment)))
	(close-sound file)))
    (lambda args (snd-display "~S" args)))
  (delete-file "test.aif")
  (mus-sound-forget "test.aif")
  
  (with-output-to-file "test.aif"
    (lambda ()
					;write AIFC with trailing chunks to try to confuse file->sample
      (display "FORM")
      (for-each write-byte '(0 0 0 126))
      (display "AIFCFVER")
      (for-each write-byte '(0 0 0 4 162 128 81 64))
      (display "SSND")
      (for-each write-byte '(0 0 0 12 0 0 0 0 0 0 0 0 120 65 64 64))
      (display "COMM")
      (for-each write-byte '(0 0 0 38 0 2 0 0 0 1 0 16 64 14 172 68 0 0 0 0 0 0))
      (display "NONE") ; compression
      (write-byte #o016) ; pascal string len
      (display "not compressed")
      (write-byte #o000)
      (display "APPL")
      (for-each write-byte (list 0 0 0 (char->integer #\h)))
      (display "CLM ;Written Mon 02-Nov-98 01:44 CST by root at ockeghem (Linux/X86) using Allegro CL, clm of 20-Oct-98")
      (write-byte #o000)))
  (catch #t
    (lambda ()
      (let ((gen (make-file->sample "test.aif")))
	(if (fneq (gen 0 0) 0.93948) (snd-display "file->sample chunked 0 0: ~A" (gen 0 0)))
	(if (fneq (gen 0 1) 0.50195) (snd-display "file->sample chunked 0 1: ~A" (gen 0 1)))
	(if (fneq (gen 1 0) 0.0) (snd-display "file->sample chunked eof(stereo): ~A" (gen 1 0)))
	(if (fneq (gen 1 1) 0.0) (snd-display "file->sample chunked eof+1 (stereo): ~A" (gen 1 1))))
      (let ((file (open-sound "test.aif")))
	(if (not (= (framples file) 1)) (snd-display "chunked framples (1): ~A" (framples file)))
	(if (fneq (sample 0 file 0) 0.93948) (snd-display "file chunked 0 0: ~A" (sample 0 file 0)))
	(if (fneq (sample 0 file 1) 0.50195) (snd-display "file chunked 0 1: ~A" (sample 0 file 1)))
	(if (fneq (sample 1 file 0) 0.0) (snd-display "file chunked eof (stereo): ~A" (sample 1 file 0)))
	(if (fneq (sample 1 file 1) 0.0) (snd-display "file chunked eof+1 (stereo): ~A" (sample 1 file 1)))
	(if (not (equal? (comment) ";Written Mon 02-Nov-98 01:44 CST by root at ockeghem (Linux/X86) using Allegro CL, clm of 20-Oct-98"))
	    (snd-display "chunked appl comment (stereo): ~A" (comment)))
	(close-sound file)))
    (lambda args (snd-display "~S" args)))
  (delete-file "test.aif")
  (mus-sound-forget "test.aif")
  
  (let ((files (sound-files-in-directory cwd)))
    (if (null? files) (snd-display "no sound files in ~A?" cwd))
    (let ((files1 (sound-files-in-directory)))
      (if (not (equal? files files1)) (snd-display "different sound files in ~A and default?~%    ~A~%    ~A~%" cwd files files1))
      (let ((files2 (sound-files-in-directory "."))
	    
	    (difference (lambda (a b)
			  (let ((diffs ()))
			    (for-each
			     (lambda (f)
			       (if (not (member f b)) (set! diffs (cons f diffs))))
			     a)
			    (for-each
			     (lambda (f)
			       (if (not (member f a)) (set! diffs (cons f diffs))))
			     b)
			    diffs))))
	
	(if (not (and (equal? files1 files2)
		      (equal? files files2)))
	    (snd-display "sound-files-in-directory dot: ~A~%    ~A~% but ~A" (difference files2 files) files2 files)))))
  
  (set! (hook-functions bad-header-hook) ())
  (set! (hook-functions open-raw-sound-hook) ())
  (if (pair? (sounds)) (for-each close-sound (sounds)))
  
  (let ((ind (new-sound :size 0)))
    (if (not (= (framples ind) 0)) (snd-display "new-sound :size 0 -> ~A framples" (framples ind)))
    (if (fneq (sample 0) 0.0) (snd-display "new-sound :size 0 sample 0: ~A" (sample 0)))
    (clean-up-sound ind))
  (let ((ind (new-sound :size 1)))
    (if (not (= (framples ind) 1)) (snd-display "new-sound :size 1 -> ~A framples" (framples ind)))
    (if (fneq (sample 0) 0.0) (snd-display "new-sound :size 1 sample 0: ~A" (sample 0)))
    (clean-up-sound ind))
  (let ((tag (catch #t
	       (lambda () (new-sound :size -1))
	       (lambda args (car args)))))
    (unless (eq? tag 'out-of-range)
      (snd-display "new-sound :size -1: ~A" tag)
      (if (pair? (sounds)) (for-each close-sound (sounds)))))
  
  (let ((ind (read-ascii (string-append sf-dir "caruso.asc"))))
    (if (not (sound? ind)) 
	(snd-display "read-ascii can't find ~A (~A)" (string-append sf-dir "caruso.asc") (map file-name (sounds)))
	(begin
	  (if (fneq (maxamp ind 0) 0.723) (snd-display "read-ascii maxamp: ~A" (maxamp ind 0)))
	  (if (not (= (framples ind 0) 50000)) (snd-display "read-ascii framples: ~A" (framples ind 0)))
	  (if (not (= (srate ind) 44100)) (snd-display "read-ascii srate: ~A" (srate ind)))
	  (set! (srate ind) 8000)
	  (if (or (not (= (framples ind 0) 50000))
		  (fneq (maxamp ind 0) .723))
	      (snd-display "set srate clobbered new sound: ~A ~A (~A)" (framples ind 0) (maxamp ind 0) (srate ind)))
	  
	  (close-sound ind))))
  
  (let ((ind (open-sound "oboe.snd")))
    (save-sound-as "test space.snd")
    (close-sound ind)
    (set! ind (open-sound "test space.snd"))
    (if (not (string=? (short-file-name ind) "test space.snd"))
	(snd-display "file name with space: ~A" (short-file-name ind)))
    (let ((len (framples ind))
	  (slen (mus-sound-framples "test space.snd")))
      (if (not (= len slen)) (snd-display "spaced filename framples: ~A ~A" len slen)))
    (add-mark 1234 ind 0)
    (save-marks ind) ; should write "test space.marks"
    (close-sound ind))
  (let ((ind (open-sound "test space.snd")))
    (load (string-append cwd "test space.marks"))
    (if (not (find-mark 1234 ind))
	(snd-display "space file name save marks: ~A" (marks ind)))
    (let ((rdf (mus-file-name (make-readin :file "test space.snd"))))
      (if (not (string=? rdf "test space.snd"))
	  (snd-display "file name with space readin: ~A" rdf)))
    (close-sound ind))
  (if (file-exists? "test space.snd")
      (delete-file "test space.snd"))
  (if (file-exists? "test space.marks")
      (delete-file "test space.marks"))
  
  (if (directory? "oboe.snd") (snd-display "directory? oboe.snd!"))
  (if (not (directory? ".")) (snd-display "directory? . #f!"))
  (if (string=? "" (getenv "PATH")) (snd-display "getenv: no PATH?"))
  (if (not (number? (getpid))) (snd-display "getpid: ~A" (getpid)))
  
  (unless (provided? 'gmp)
    (let ((LONG_MAX 2147483647)
	  (LONG_MIN -2147483648))
      (let ((ints (vector 0 1 -1 10 -10 1234 -1234 LONG_MAX LONG_MIN 65536 -65536))
	    (shorts (vector 0 1 -1 10 -10 1234 -1234 32767 -32768 8191 -8191))
	    (longs (vector 0 1 -1 11 -11 LONG_MAX LONG_MIN most-positive-fixnum most-negative-fixnum 1000 -1000))
	    (floats (vector 0.0 1.0 -1.0 0.1 -0.1 10.0 -10.0 1234.0 65536.0 -1234.0 -0.003))
	    (doubles (vector 0.0 1.0 -1.0 0.1 -0.1 10.0 -10.0 1234.0 65536.0 -1234.0 -0.003)))
	(load "binary-io.scm")
	
	(with-output-to-file "idf1.data"
	  (lambda ()
	    
	    (write-lint32 123)
	    (write-bint32 321)
	    
	    (do ((i 0 (+ i 1)))
		((= i 11))
	      (write-lint32 (ints i))
	      (write-bint32 (ints i)))
	    
	    (do ((i 0 (+ i 1)))
		((= i 11))
	      (write-lint16 (shorts i))
	      (write-bint16 (shorts i)))
	    
	    (do ((i 0 (+ i 1)))
		((= i 11))
	      (write-lint64 (longs i))
	      (write-bint64 (longs i)))
	    
	    (do ((i 0 (+ i 1)))
		((= i 11))
	      (write-lfloat32 (floats i))
	      (write-bfloat32 (floats i)))
	    
	    (do ((i 0 (+ i 1)))
		((= i 11))
	      (write-lfloat64 (doubles i))
	      (write-bfloat64 (doubles i)))))
	
	(with-input-from-file "idf1.data" 
	  (let ((testf (lambda (val1 val2 name)
			 (if (not (= val1 val2))
			     (if (not (memq name '(lfloat32 bfloat32)))
				 (snd-display "testf ~A: ~A != ~A~%" name val1 val2)
				 (if (> (abs (- val1 val2)) 1.0e-6)
				     (snd-display "testf ~A: ~A != ~A (~A)~%" name val1 val2 (abs (- val1 val2)))))))))
	    (lambda ()
	      (testf (read-lint32) 123 'lint32)
	      (testf (read-bint32) 321 'bint32)
	      
	      (do ((i 0 (+ i 1)))
		  ((= i 11))
		(testf (read-lint32) (ints i) 'lint32)
		(testf (read-bint32) (ints i) 'bint32))
	      
	      (do ((i 0 (+ i 1)))
		  ((= i 11))
		(testf (read-lint16) (shorts i) 'lint16)
		(testf (read-bint16) (shorts i) 'bint16))
	      
	      (do ((i 0 (+ i 1)))
		  ((= i 11))
		(testf (read-lint64) (longs i) 'lint64)
		(testf (read-bint64) (longs i) 'bint64))
	      
	      (do ((i 0 (+ i 1)))
		  ((= i 11))
		(testf (read-lfloat32) (floats i) 'lfloat32)
		(testf (read-bfloat32) (floats i) 'bfloat32))
	      
	      (do ((i 0 (+ i 1)))
		  ((= i 11))
		(testf (read-lfloat64) (doubles i) 'lfloat64)
		(testf (read-bfloat64) (doubles i) 'bfloat64)))))))))



;;; ---------------- test 5: simple overall checks ----------------

(require snd-selection.scm snd-extensions.scm snd-selection.scm snd-dsp.scm snd-pvoc.scm)
(if with-gui (require snd-edit-menu.scm))

(define (snd_test_5)
  
  (define (string-=? a b)
    (or (string=? a b)
	(and (or (char-position #\- a) 
		 (char-position #\- b))
	     (let ((alen (length a))
		   (blen (length b))
		   (j 0)
		   (happy #t))
	       (do ((b7 (- blen 7))
		    (a7 (- alen 7))
		    (i 0 (+ i 1)))
		   ((or (not happy) 
			(= i alen))
		    (and happy 
			 (= j blen)))
		 (let ((ac (a i))
		       (bc (b j)))
		   (if (char=? ac bc)
		       (set! j (+ j 1))
		       (if (not (and (char=? ac #\-)	
				     (<= i a7)
				     (string=? (substring a i (+ i 6)) "-0.000")))
			   (if (and (char=? bc #\-)
				    (<= j b7)
				    (string=? (substring b j (+ j 6)) "-0.000"))
			       (begin
				 (set! j (+ j 1))
				 (if (not (char=? ac (b j)))
				     (set! happy #f)
				     (set! j (+ j 1))))
			       (set! happy #f))))))))))
    
  (if (playing) (snd-display "dac is running??"))
  (do ((clmtest 0 (+ 1 clmtest))) 
      ((= clmtest tests)) 
    (log-mem clmtest)
    
    (let ((ind (open-sound "oboe.snd")))
      (set! (transform-graph? ind 0) #t)
      (set! (transform-graph-type ind 0) graph-as-sonogram)
      (catch 'no-such-axis
	(lambda ()
	  (set! (y-axis-label ind 0 1) "hiho") #f)
	(lambda args
	  (snd-display "no fft axis: ~A" args)))
      (set! (fft-log-frequency ind 0) #t) ; segfault here originally
      (update-transform-graph ind 0)
      (close-sound ind))
    
    (let ((ind (new-sound "test.snd" :size 10)))
      (float-vector->channel (make-float-vector 10 1.0))
      (env-channel '(0 0 1 1 2 0))
      (let ((data (channel->float-vector)))
	(if (not (mus-arrays-equal? data #r(0.0 0.200 0.400 0.600 0.800 1.0 0.750 0.500 0.250 0.000)))
	    (snd-display "pyr 10: ~A" data)))
      (undo)
      (env-channel '((0 0) (1 1) (2 0)))
      (let ((data (channel->float-vector)))
	(if (not (mus-arrays-equal? data #r(0.0 0.200 0.400 0.600 0.800 1.0 0.750 0.500 0.250 0.000)))
	    (snd-display "pyr 10: ~A" data)))
      (undo)
      (env-channel (make-env '(0 0 1 1 2 0) :length 10))
      (let ((data (channel->float-vector)))
	(if (not (mus-arrays-equal? data #r(0.0 0.200 0.400 0.600 0.800 1.0 0.750 0.500 0.250 0.000)))
	    (snd-display "pyr 10: ~A" data)))
      (undo)
      (close-sound ind))
    
    (for-each
     (lambda (size)
       (let ((ind (new-sound "test.snd" :size size))
	     (incr (/ 1.0 (- size 1)))
	     (e (make-env '(0 0 1 1) :length size)))
	 (float-vector->channel (make-float-vector size 1.0))
	 
	 (ramp-channel 0.0 1.0)
	 (let ((data (channel->float-vector)))
	   (if (or (fneq (data 0) 0.0)
		   (fneq (data (- size 1)) 1.0))
	       (snd-display "ramp-channel ~A end points: ~A ~A" size (data 0) (data (- size 1))))
	   (do ((i 0 (+ i 1)))
	       ((= i size))
	     (let ((val (envelope-interp (* i incr) '(0.0 0.0 1.0 1.0)))
		   (segval (env e)))
	       (if (or (fneq segval val)
		       (fneq (data i) val))
		   (snd-display "ramp-channel ~A of ~A: ramp: ~A, interp: ~A, env: ~A" i size (data i) val segval)))))
	 (undo)
	 (xramp-channel 0.0 1.0 32.0)
	 (let* ((e (make-env '(0 0 1 1) :length size :base 32.0))
		(data (channel->float-vector)))
	   (if (or (fneq (data 0) 0.0)
		   (fneq (data (- size 1)) 1.0))
	       (snd-display "xramp-channel 32 ~A end points: ~A ~A" size (data 0) (data (- size 1))))
	   (do ((i 0 (+ i 1)))
	       ((= i size))
	     (let ((val (envelope-interp (* i incr) '(0.0 0.0 1.0 1.0) 32.0))
		   (segval (env e)))
	       (if (or (fneq segval val)
		       (fneq (data i) val))
		   (snd-display "xramp-channel 32 ~A of ~A: ramp: ~A, interp: ~A, env: ~A" i size (data i) val segval)))))
	 (undo)
	 (xramp-channel 0.0 1.0 0.4)
	 (let* ((e (make-env '(0 0 1 1) :length size :base 0.4))
		(data (channel->float-vector)))
	   (if (or (fneq (data 0) 0.0)
		   (fneq (data (- size 1)) 1.0))
	       (snd-display "xramp-channel .4 ~A end points: ~A ~A" size (data 0) (data (- size 1))))
	   (do ((i 0 (+ i 1)))
	       ((= i size))
	     (let ((val (envelope-interp (* i incr) '(0.0 0.0 1.0 1.0) 0.4))
		   (segval (env e)))
	       (if (or (fneq segval val)
		       (fneq (data i) val))
		   (snd-display "xramp-channel .4 ~A of ~A: ramp: ~A, interp: ~A, env: ~A" i size (data i) val segval)))))
	 (undo)
	 (xramp-channel 1.0 -1.0 8.0)
	 (let* ((e (make-env '(0 1 1 -1) :length size :base 8.0))
		(data (channel->float-vector)))
	   (if (or (fneq (data 0) 1.0)
		   (fneq (data (- size 1)) -1.0))
	       (snd-display "xramp-channel 1 -1 8 ~A end points: ~A ~A" size (data 0) (data (- size 1))))
	   (do ((i 0 (+ i 1)))
	       ((= i size))
	     (let ((segval (env e)))
	       (if (fneq segval (data i))
		   (snd-display "xramp-channel 1 -1 8 ~A of ~A: ramp: ~A, env: ~A" i size (data i) segval)))))
	 (undo)
	 (close-sound ind)))
     '(10 100 1000))
    
    ;; basic edit tree cases
    (let ((ind (new-sound "test.snd")))
      (if (not (= (redo) 0)) (snd-display "redo with no ops: ~A" (redo)))
      (if (not (= (undo) 0)) (snd-display "undo with no ops: ~A" (undo)))
      
      (if (not (string-=? (display-edits) (string-append "
EDITS: 0

 (begin) [0:2]:
   (at 0, cp->sounds[0][0:0, 0.000]) [file: " cwd "test.snd[0]]
   (at 1, end_mark)
")))
	  (snd-display "new 0: ~A" (display-edits)))
      (insert-samples 10 10 (make-float-vector 10))
      (if (not (= (framples) 20)) (snd-display "new 1 framples: ~A" (framples)))
      (if (not (string-=? (display-edits) (string-append "
EDITS: 1

 (begin) [0:2]:
   (at 0, cp->sounds[0][0:0, 0.000]) [file: " cwd "test.snd[0]]
   (at 1, end_mark)

 (insert 1 20) ; insert-samples [1:4]:
   (at 0, cp->sounds[0][0:0, 0.000]) [file: " cwd "test.snd[0]]
   (at 1, cp->sounds[-1][0:8, 0.000])
   (at 10, cp->sounds[1][0:9, 1.000]) [buf: 10] 
   (at 20, end_mark)
")))
	  (snd-display "new 1: ~A" (display-edits)))
      (undo)
      (insert-samples 0 10 (make-float-vector 10))
      (if (not (= (framples) 11)) (snd-display "new 2 framples: ~A" (framples))) ; 11 because there was 1 sample when new-sound created 
      (if (not (string-=? (display-edits) (string-append "
EDITS: 1

 (begin) [0:2]:
   (at 0, cp->sounds[0][0:0, 0.000]) [file: " cwd "test.snd[0]]
   (at 1, end_mark)

 (insert 0 10) ; insert-samples [1:3]:
   (at 0, cp->sounds[1][0:9, 1.000]) [buf: 10] 
   (at 10, cp->sounds[0][0:0, 0.000]) [file: " cwd "test.snd[0]]
   (at 11, end_mark)
")))
	  (snd-display "new 2: ~A" (display-edits)))
      (let ((eds (undo 2)))
	(if (not (= eds 2)) (snd-display "new 3 undo: ~A" eds)))
      (insert-samples 0 10 (make-float-vector 10))
      (if (not (= (framples) 11)) (snd-display "new 3 framples: ~A" (framples)))
      (if (not (string-=? (display-edits) (string-append "
EDITS: 1

 (begin) [0:2]:
   (at 0, cp->sounds[0][0:0, 0.000]) [file: " cwd "test.snd[0]]
   (at 1, end_mark)

 (insert 0 10) ; insert-samples [1:3]:
   (at 0, cp->sounds[1][0:9, 1.000]) [buf: 10] 
   (at 10, cp->sounds[0][0:0, 0.000]) [file: " cwd "test.snd[0]]
   (at 11, end_mark)
")))
	  (snd-display "new 3: ~A" (display-edits)))
      (undo)
      (set! (sample 0) .5)
      (if (not (= (framples) 1)) (snd-display "new 4 framples: ~A" (framples)))
      (if (not (string-=? (display-edits) (string-append "
EDITS: 1

 (begin) [0:2]:
   (at 0, cp->sounds[0][0:0, 0.000]) [file: " cwd "test.snd[0]]
   (at 1, end_mark)

 (set 0 1) ; set-sample 0 0.5000 [1:2]:
   (at 0, cp->sounds[1][0:0, 1.000]) [buf: 1] 
   (at 1, end_mark)
")))
	  (snd-display "new 4: ~A" (display-edits)))      
      (undo)
      
      (set! (samples 0 10) (make-float-vector 10))
      (if (not (= (framples) 10)) (snd-display "new 5 framples: ~A" (framples)))
      (if (not (string-=? (display-edits) (string-append "
EDITS: 1

 (begin) [0:2]:
   (at 0, cp->sounds[0][0:0, 0.000]) [file: " cwd "test.snd[0]]
   (at 1, end_mark)

 (set 0 10) ; set-samples [1:2]:
   (at 0, cp->sounds[1][0:9, 1.000]) [buf: 10] 
   (at 10, end_mark)
")))
	  (snd-display "new 5: ~A" (display-edits)))
      
      (delete-samples 3 4)
      (if (not (= (framples) 6)) (snd-display "new 6 framples: ~A" (framples)))
      (if (not (string-=? (safe-display-edits ind 0 2) "
 (delete 3 4) ; delete-samples 3 4 [2:3]:
   (at 0, cp->sounds[1][0:2, 1.000]) [buf: 10] 
   (at 3, cp->sounds[1][7:9, 1.000]) [buf: 10] 
   (at 6, end_mark)
"))
	  (snd-display "new 6: ~A" (safe-display-edits ind 0 2)))
      
      (set! (samples 1 4) (make-float-vector 4))
      (if (not (= (framples) 6)) (snd-display "new 7 framples: ~A" (framples)))
      (if (not (string-=? (safe-display-edits ind 0 3) "
 (set 1 4) ; set-samples [3:4]:
   (at 0, cp->sounds[1][0:0, 1.000]) [buf: 10] 
   (at 1, cp->sounds[2][0:3, 1.000]) [buf: 4] 
   (at 5, cp->sounds[1][9:9, 1.000]) [buf: 10] 
   (at 6, end_mark)
"))
	  (snd-display "new 7: ~A" (safe-display-edits ind 0 3)))
      (undo 2)
      (insert-samples 2 3 (make-float-vector 3))
      (insert-samples 2 1 (make-float-vector 1))
      (insert-samples 4 1 (make-float-vector 1))
      (insert-samples 15 1 (make-float-vector 1))
      (if (not (= (framples) 16)) (snd-display "new 8 framples: ~A" (framples)))
      (if (not (string-=? (display-edits) (string-append "
EDITS: 5

 (begin) [0:2]:
   (at 0, cp->sounds[0][0:0, 0.000]) [file: " cwd "test.snd[0]]
   (at 1, end_mark)

 (set 0 10) ; set-samples [1:2]:
   (at 0, cp->sounds[1][0:9, 1.000]) [buf: 10] 
   (at 10, end_mark)

 (insert 2 3) ; insert-samples [2:4]:
   (at 0, cp->sounds[1][0:1, 1.000]) [buf: 10] 
   (at 2, cp->sounds[2][0:2, 1.000]) [buf: 3] 
   (at 5, cp->sounds[1][2:9, 1.000]) [buf: 10] 
   (at 13, end_mark)

 (insert 2 1) ; insert-samples [3:5]:
   (at 0, cp->sounds[1][0:1, 1.000]) [buf: 10] 
   (at 2, cp->sounds[3][0:0, 1.000]) [buf: 1] 
   (at 3, cp->sounds[2][0:2, 1.000]) [buf: 3] 
   (at 6, cp->sounds[1][2:9, 1.000]) [buf: 10] 
   (at 14, end_mark)

 (insert 4 1) ; insert-samples [4:7]:
   (at 0, cp->sounds[1][0:1, 1.000]) [buf: 10] 
   (at 2, cp->sounds[3][0:0, 1.000]) [buf: 1] 
   (at 3, cp->sounds[2][0:0, 1.000]) [buf: 3] 
   (at 4, cp->sounds[4][0:0, 1.000]) [buf: 1] 
   (at 5, cp->sounds[2][1:2, 1.000]) [buf: 3] 
   (at 7, cp->sounds[1][2:9, 1.000]) [buf: 10] 
   (at 15, end_mark)

 (insert 15 1) ; insert-samples [5:8]:
   (at 0, cp->sounds[1][0:1, 1.000]) [buf: 10] 
   (at 2, cp->sounds[3][0:0, 1.000]) [buf: 1] 
   (at 3, cp->sounds[2][0:0, 1.000]) [buf: 3] 
   (at 4, cp->sounds[4][0:0, 1.000]) [buf: 1] 
   (at 5, cp->sounds[2][1:2, 1.000]) [buf: 3] 
   (at 7, cp->sounds[1][2:9, 1.000]) [buf: 10] 
   (at 15, cp->sounds[5][0:0, 1.000]) [buf: 1] 
   (at 16, end_mark)
")))
	  (snd-display "new 8: ~A" (display-edits)))
      (delete-samples 2 1)
      (if (not (string-=? (safe-display-edits ind 0 6) "
 (delete 2 1) ; delete-samples 2 1 [6:7]:
   (at 0, cp->sounds[1][0:1, 1.000]) [buf: 10] 
   (at 2, cp->sounds[2][0:0, 1.000]) [buf: 3] 
   (at 3, cp->sounds[4][0:0, 1.000]) [buf: 1] 
   (at 4, cp->sounds[2][1:2, 1.000]) [buf: 3] 
   (at 6, cp->sounds[1][2:9, 1.000]) [buf: 10] 
   (at 14, cp->sounds[5][0:0, 1.000]) [buf: 1] 
   (at 15, end_mark)
"))
	  (snd-display "new 9: ~A" (safe-display-edits ind 0 6)))
      (delete-samples 0 5)
      (if (not (string-=? (safe-display-edits ind 0 7) "
 (delete 0 5) ; delete-samples 0 5 [7:4]:
   (at 0, cp->sounds[2][2:2, 1.000]) [buf: 3] 
   (at 1, cp->sounds[1][2:9, 1.000]) [buf: 10] 
   (at 9, cp->sounds[5][0:0, 1.000]) [buf: 1] 
   (at 10, end_mark)
"))
	  (snd-display "new 10: ~A" (safe-display-edits ind 0 7)))
      (delete-samples 6 4)
      (if (not (string-=? (safe-display-edits ind 0 8) "
 (delete 6 4) ; delete-samples 6 4 [8:3]:
   (at 0, cp->sounds[2][2:2, 1.000]) [buf: 3] 
   (at 1, cp->sounds[1][2:6, 1.000]) [buf: 10] 
   (at 6, end_mark)
"))
	  (snd-display "new 11: ~A" (safe-display-edits ind 0 8)))
      (delete-samples 0 1)
      (if (not (string-=? (safe-display-edits ind 0 9) "
 (delete 0 1) ; delete-samples 0 1 [9:2]:
   (at 0, cp->sounds[1][2:6, 1.000]) [buf: 10] 
   (at 5, end_mark)
"))
	  (snd-display "new 12: ~A" (safe-display-edits ind 0 9)))
      
      (delete-samples 0 5)
      (if (not (string-=? (safe-display-edits ind 0 10) "
 (delete 0 5) ; delete-samples 0 5 [10:1]:
   (at 0, end_mark)
"))
	  (snd-display "new 13: ~A" (safe-display-edits ind 0 10)))
      (delete-samples 0 10)
      (if (not (= (edit-position) 10))
	  (snd-display "no-op delete deleted something! ~A" (display-edits)))
      (insert-samples 0 3 (make-float-vector 3))
      (if (not (string-=? (safe-display-edits ind 0 11) "
 (insert 0 3) ; insert-samples [11:2]:
   (at 0, cp->sounds[6][0:2, 1.000]) [buf: 3] 
   (at 3, end_mark)
"))
	  (snd-display "new 14: ~A" (safe-display-edits ind 0 11)))
      (delete-samples 2 1)
      (if (not (string-=? (safe-display-edits ind 0 12) "
 (delete 2 1) ; delete-samples 2 1 [12:2]:
   (at 0, cp->sounds[6][0:1, 1.000]) [buf: 3] 
   (at 2, end_mark)
"))
	  (snd-display "new 15: ~A" (safe-display-edits ind 0 12)))
      (set! (sample 0) .5)
      (if (not (string-=? (safe-display-edits ind 0 13) "
 (set 0 1) ; set-sample 0 0.5000 [13:3]:
   (at 0, cp->sounds[7][0:0, 1.000]) [buf: 1] 
   (at 1, cp->sounds[6][1:1, 1.000]) [buf: 3] 
   (at 2, end_mark)
"))
	  (snd-display "new 16: ~A" (safe-display-edits ind 0 13)))
      (set! (sample 1) .5)
      (if (not (string-=? (safe-display-edits ind 0 14) "
 (set 1 1) ; set-sample 1 0.5000 [14:3]:
   (at 0, cp->sounds[7][0:0, 1.000]) [buf: 1] 
   (at 1, cp->sounds[8][0:0, 1.000]) [buf: 1] 
   (at 2, end_mark)
"))
	  (snd-display "new 17: ~A" (safe-display-edits ind 0 14)))  
      (map-channel (lambda (y) 1.0) 0 10)
      (if (not (string-=? (safe-display-edits ind 0 15) "
 (set 0 10) ; map-channel [15:2]:
   (at 0, cp->sounds[9][0:9, 1.000]) [buf: 10] 
   (at 10, end_mark)
"))
	  (snd-display "new 18: ~A" (safe-display-edits ind 0 15)))  
      (insert-samples 0 10 (make-float-vector 10))
      (if (not (string-=? (safe-display-edits ind 0 16) "
 (insert 0 10) ; insert-samples [16:3]:
   (at 0, cp->sounds[10][0:9, 1.000]) [buf: 10] 
   (at 10, cp->sounds[9][0:9, 1.000]) [buf: 10] 
   (at 20, end_mark)
"))
	  (snd-display "new 19: ~A" (safe-display-edits ind 0 16)))
      (set! (samples 2 3) (make-float-vector 3))
      (if (not (string-=? (safe-display-edits ind 0 17) "
 (set 2 3) ; set-samples [17:5]:
   (at 0, cp->sounds[10][0:1, 1.000]) [buf: 10] 
   (at 2, cp->sounds[11][0:2, 1.000]) [buf: 3] 
   (at 5, cp->sounds[10][5:9, 1.000]) [buf: 10] 
   (at 10, cp->sounds[9][0:9, 1.000]) [buf: 10] 
   (at 20, end_mark)
"))
	  (snd-display "new 20: ~A" (safe-display-edits ind 0 17)))
      (set! (samples 0 12) (make-float-vector 12))
      (if (not (string-=? (safe-display-edits ind 0 18) "
 (set 0 12) ; set-samples [18:3]:
   (at 0, cp->sounds[12][0:11, 1.000]) [buf: 12] 
   (at 12, cp->sounds[9][2:9, 1.000]) [buf: 10] 
   (at 20, end_mark)
"))
	  (snd-display "new 21: ~A" (safe-display-edits ind 0 18)))
      (set! (samples 30 10) (make-float-vector 10))
      (if (not (string-=? (safe-display-edits ind 0 19) "
 (set 20 21) ; set-samples [19:5]:
   (at 0, cp->sounds[12][0:11, 1.000]) [buf: 12] 
   (at 12, cp->sounds[9][2:9, 1.000]) [buf: 10] 
   (at 20, cp->sounds[-1][0:9, 0.000])
   (at 30, cp->sounds[13][0:9, 1.000]) [buf: 10] 
   (at 40, end_mark)
"))
	  (snd-display "new 21: ~A" (safe-display-edits ind 0 19)))
      (close-sound ind))
    
    ;; scale/ramp
    (let ((ind (new-sound "test.snd")))
      (map-channel (lambda (y) 1.0) 0 10)
      (scale-channel 0.5)
      (if (not (string-=? (safe-display-edits ind 0 2) "
 (scale 0 10) ; scale-channel 0.500 0 #f [2:2]:
   (at 0, cp->sounds[1][0:9, 0.500]) [buf: 10] 
   (at 10, end_mark)
"))
	  (snd-display "scl 0: ~A" (safe-display-edits ind 0 2)))
      (undo)
      (scale-channel 0.5 0 3)
      (if (not (string-=? (safe-display-edits ind 0 2) "
 (scale 0 3) ; scale-channel 0.500 0 3 [2:3]:
   (at 0, cp->sounds[1][0:2, 0.500]) [buf: 10] 
   (at 3, cp->sounds[1][3:9, 1.000]) [buf: 10] 
   (at 10, end_mark)
"))
	  (snd-display "scl 1: ~A" (safe-display-edits ind 0 2)))
      (undo)
      (scale-channel 0.5 5 5)
      (if (not (string-=? (safe-display-edits ind 0 2) "
 (scale 5 5) ; scale-channel 0.500 5 5 [2:3]:
   (at 0, cp->sounds[1][0:4, 1.000]) [buf: 10] 
   (at 5, cp->sounds[1][5:9, 0.500]) [buf: 10] 
   (at 10, end_mark)
"))
	  (snd-display "scl 2: ~A" (safe-display-edits ind 0 2)))
      (undo)
      (scale-channel 0.5 2 4)
      (if (not (string-=? (safe-display-edits ind 0 2) "
 (scale 2 4) ; scale-channel 0.500 2 4 [2:4]:
   (at 0, cp->sounds[1][0:1, 1.000]) [buf: 10] 
   (at 2, cp->sounds[1][2:5, 0.500]) [buf: 10] 
   (at 6, cp->sounds[1][6:9, 1.000]) [buf: 10] 
   (at 10, end_mark)
"))
	  (snd-display "scl 2a: ~A" (safe-display-edits ind 0 2)))
      (undo)
      (scale-channel 0.5 10 10)
      (if (not (= (edit-position) 1))
	  (snd-display "scale beyond end edited? ~A" (display-edits)))
      (scale-channel 0.5 100 10)
      (if (not (= (edit-position) 1))
	  (snd-display "scale way beyond end edited? ~A" (display-edits)))
      (scale-channel 0.5 5 10)
      (if (not (string-=? (safe-display-edits ind 0 2) "
 (scale 5 5) ; scale-channel 0.500 5 5 [2:3]:
   (at 0, cp->sounds[1][0:4, 1.000]) [buf: 10] 
   (at 5, cp->sounds[1][5:9, 0.500]) [buf: 10] 
   (at 10, end_mark)
"))
	  (snd-display "scl 3: ~A" (safe-display-edits ind 0 2)))
      (undo)
      (set! (sample 4) .5)
      (if (not (string-=? (safe-display-edits ind 0 2) "
 (set 4 1) ; set-sample 4 0.5000 [2:4]:
   (at 0, cp->sounds[1][0:3, 1.000]) [buf: 10] 
   (at 4, cp->sounds[2][0:0, 1.000]) [buf: 1] 
   (at 5, cp->sounds[1][5:9, 1.000]) [buf: 10] 
   (at 10, end_mark)
"))
	  (snd-display "scl 4: ~A" (safe-display-edits ind 0 2)))
      (scale-channel 0.5 0 4)
      (if (not (string-=? (safe-display-edits ind 0 3) "
 (scale 0 4) ; scale-channel 0.500 0 4 [3:4]:
   (at 0, cp->sounds[1][0:3, 0.500]) [buf: 10] 
   (at 4, cp->sounds[2][0:0, 1.000]) [buf: 1] 
   (at 5, cp->sounds[1][5:9, 1.000]) [buf: 10] 
   (at 10, end_mark)
"))
	  (snd-display "scl 5: ~A" (safe-display-edits ind 0 3)))
      (scale-channel 0.5 4 1)
      (if (not (string-=? (safe-display-edits ind 0 4) "
 (scale 4 1) ; scale-channel 0.500 4 1 [4:4]:
   (at 0, cp->sounds[1][0:3, 0.500]) [buf: 10] 
   (at 4, cp->sounds[2][0:0, 0.500]) [buf: 1] 
   (at 5, cp->sounds[1][5:9, 1.000]) [buf: 10] 
   (at 10, end_mark)
"))
	  (snd-display "scl 6: ~A" (safe-display-edits ind 0 4)))
      (scale-channel 0.5 0 7)
      (if (not (string-=? (safe-display-edits ind 0 5) "
 (scale 0 7) ; scale-channel 0.500 0 7 [5:5]:
   (at 0, cp->sounds[1][0:3, 0.250]) [buf: 10] 
   (at 4, cp->sounds[2][0:0, 0.250]) [buf: 1] 
   (at 5, cp->sounds[1][5:6, 0.500]) [buf: 10] 
   (at 7, cp->sounds[1][7:9, 1.000]) [buf: 10] 
   (at 10, end_mark)
"))
	  (snd-display "scl 7: ~A" (safe-display-edits ind 0 5)))
      (scale-channel 0.5 1 4)
      (if (not (string-=? (safe-display-edits ind 0 6) "
 (scale 1 4) ; scale-channel 0.500 1 4 [6:6]:
   (at 0, cp->sounds[1][0:0, 0.250]) [buf: 10] 
   (at 1, cp->sounds[1][1:3, 0.125]) [buf: 10] 
   (at 4, cp->sounds[2][0:0, 0.125]) [buf: 1] 
   (at 5, cp->sounds[1][5:6, 0.500]) [buf: 10] 
   (at 7, cp->sounds[1][7:9, 1.000]) [buf: 10] 
   (at 10, end_mark)
"))
	  (snd-display "scl 8: ~A" (safe-display-edits ind 0 6)))
      (undo 4)
      (scale-channel 0.5 1 8)
      (if (not (string-=? (safe-display-edits ind 0 3) "
 (scale 1 8) ; scale-channel 0.500 1 8 [3:6]:
   (at 0, cp->sounds[1][0:0, 1.000]) [buf: 10] 
   (at 1, cp->sounds[1][1:3, 0.500]) [buf: 10] 
   (at 4, cp->sounds[2][0:0, 0.500]) [buf: 1] 
   (at 5, cp->sounds[1][5:8, 0.500]) [buf: 10] 
   (at 9, cp->sounds[1][9:9, 1.000]) [buf: 10] 
   (at 10, end_mark)
"))
	  (snd-display "scl 9: ~A" (safe-display-edits ind 0 3)))
      (undo 2)
      
      (ramp-channel 0.0 1.0)
      (if (not (string-=? (safe-display-edits ind 0 2) "
 (ramp 0 10) ; ramp-channel 0.000 1.000 0 #f [2:2]:
   (at 0, cp->sounds[1][0:9, 1.000, [1]-0.000 -> 1.000]) [buf: 10] 
   (at 10, end_mark)
"))
	  (snd-display "ramp 0: ~A" (safe-display-edits ind 0 2)))
      (scale-channel 0.5)
      (if (not (string-=? (safe-display-edits ind 0 3) "
 (scale 0 10) ; scale-channel 0.500 0 #f [3:2]:
   (at 0, cp->sounds[1][0:9, 0.500, [1]-0.000 -> 1.000]) [buf: 10] 
   (at 10, end_mark)
"))
	  (snd-display "ramp 1: ~A" (safe-display-edits ind 0 3)))
      (undo)
      (scale-channel 0.5 0 5)
      (if (not (string-=? (safe-display-edits ind 0 3) "
 (scale 0 5) ; scale-channel 0.500 0 5 [3:3]:
   (at 0, cp->sounds[1][0:4, 0.500, [1]-0.000 -> 0.444]) [buf: 10] 
   (at 5, cp->sounds[1][5:9, 1.000, [1]0.556 -> 1.000]) [buf: 10] 
   (at 10, end_mark)
"))
	  (snd-display "ramp 2: ~A" (safe-display-edits ind 0 3)))
      (undo)
      (scale-channel 0.5 2 4)
      (if (not (string-=? (safe-display-edits ind 0 3) "
 (scale 2 4) ; scale-channel 0.500 2 4 [3:4]:
   (at 0, cp->sounds[1][0:1, 1.000, [1]-0.000 -> 0.111]) [buf: 10] 
   (at 2, cp->sounds[1][2:5, 0.500, [1]0.222 -> 0.556]) [buf: 10] 
   (at 6, cp->sounds[1][6:9, 1.000, [1]0.667 -> 1.000]) [buf: 10] 
   (at 10, end_mark)
"))
	  (snd-display "ramp 3: ~A" (safe-display-edits ind 0 3)))
      (undo)
      (scale-channel 0.5 5 5)
      (if (not (string-=? (safe-display-edits ind 0 3) "
 (scale 5 5) ; scale-channel 0.500 5 5 [3:3]:
   (at 0, cp->sounds[1][0:4, 1.000, [1]-0.000 -> 0.444]) [buf: 10] 
   (at 5, cp->sounds[1][5:9, 0.500, [1]0.556 -> 1.000]) [buf: 10] 
   (at 10, end_mark)
"))
	  (snd-display "ramp 4: ~A" (safe-display-edits ind 0 3)))
      (undo 2)
      (ramp-channel .2 .6 2 6)
      (if (not (string-=? (safe-display-edits ind 0 2) "
 (ramp 2 6) ; ramp-channel 0.200 0.600 2 6 [2:4]:
   (at 0, cp->sounds[1][0:1, 1.000]) [buf: 10] 
   (at 2, cp->sounds[1][2:7, 1.000, [1]0.200 -> 0.600]) [buf: 10] 
   (at 8, cp->sounds[1][8:9, 1.000]) [buf: 10] 
   (at 10, end_mark)
"))
	  (snd-display "ramp 5: ~A" (safe-display-edits ind 0 2)))
      (scale-channel 0.5 0 5)
      (if (not (string-=? (safe-display-edits ind 0 3) "
 (scale 0 5) ; scale-channel 0.500 0 5 [3:5]:
   (at 0, cp->sounds[1][0:1, 0.500]) [buf: 10] 
   (at 2, cp->sounds[1][2:4, 0.500, [1]0.200 -> 0.360]) [buf: 10] 
   (at 5, cp->sounds[1][5:7, 1.000, [1]0.440 -> 0.600]) [buf: 10] 
   (at 8, cp->sounds[1][8:9, 1.000]) [buf: 10] 
   (at 10, end_mark)
"))
	  (snd-display "ramp 6: ~A" (safe-display-edits ind 0 3)))
      (undo)
      (scale-channel 0.5 2 6)
      (if (not (string-=? (safe-display-edits ind 0 3) "
 (scale 2 6) ; scale-channel 0.500 2 6 [3:4]:
   (at 0, cp->sounds[1][0:1, 1.000]) [buf: 10] 
   (at 2, cp->sounds[1][2:7, 0.500, [1]0.200 -> 0.600]) [buf: 10] 
   (at 8, cp->sounds[1][8:9, 1.000]) [buf: 10] 
   (at 10, end_mark)
"))
	  (snd-display "ramp 7: ~A" (safe-display-edits ind 0 3)))
      (undo)
      (scale-channel 0.5 5 4)
      (if (not (string-=? (safe-display-edits ind 0 3) "
 (scale 5 4) ; scale-channel 0.500 5 4 [3:6]:
   (at 0, cp->sounds[1][0:1, 1.000]) [buf: 10] 
   (at 2, cp->sounds[1][2:4, 1.000, [1]0.200 -> 0.360]) [buf: 10] 
   (at 5, cp->sounds[1][5:7, 0.500, [1]0.440 -> 0.600]) [buf: 10] 
   (at 8, cp->sounds[1][8:8, 0.500]) [buf: 10] 
   (at 9, cp->sounds[1][9:9, 1.000]) [buf: 10] 
   (at 10, end_mark)
"))
	  (snd-display "ramp 8: ~A" (safe-display-edits ind 0 3)))
      (undo)
      (set! (sample 4) .5)
      (if (not (string-=? (safe-display-edits ind 0 3) "
 (set 4 1) ; set-sample 4 0.5000 [3:6]:
   (at 0, cp->sounds[1][0:1, 1.000]) [buf: 10] 
   (at 2, cp->sounds[1][2:3, 1.000, [1]0.200 -> 0.280]) [buf: 10] 
   (at 4, cp->sounds[2][0:0, 1.000]) [buf: 1] 
   (at 5, cp->sounds[1][5:7, 1.000, [1]0.440 -> 0.600]) [buf: 10] 
   (at 8, cp->sounds[1][8:9, 1.000]) [buf: 10] 
   (at 10, end_mark)
"))
	  (snd-display "ramp 9: ~A" (safe-display-edits ind 0 3)))
      (undo)
      (scale-channel 0.5 4 1)
      (if (not (string-=? (safe-display-edits ind 0 3) "
 (scale 4 1) ; scale-channel 0.500 4 1 [3:6]:
   (at 0, cp->sounds[1][0:1, 1.000]) [buf: 10] 
   (at 2, cp->sounds[1][2:3, 1.000, [1]0.200 -> 0.280]) [buf: 10] 
   (at 4, cp->sounds[1][4:4, 0.500, [1]0.360 -> 0.360]) [buf: 10] 
   (at 5, cp->sounds[1][5:7, 1.000, [1]0.440 -> 0.600]) [buf: 10] 
   (at 8, cp->sounds[1][8:9, 1.000]) [buf: 10] 
   (at 10, end_mark)
"))
	  (snd-display "ramp 10: ~A" (safe-display-edits ind 0 3)))
      (undo)
      (delete-sample 4)
      (if (not (string-=? (safe-display-edits ind 0 3) "
 (delete 4 1) ; delete-samples 4 1 [3:5]:
   (at 0, cp->sounds[1][0:1, 1.000]) [buf: 10] 
   (at 2, cp->sounds[1][2:3, 1.000, [1]0.200 -> 0.280]) [buf: 10] 
   (at 4, cp->sounds[1][5:7, 1.000, [1]0.440 -> 0.600]) [buf: 10] 
   (at 7, cp->sounds[1][8:9, 1.000]) [buf: 10] 
   (at 9, end_mark)
"))
	  (snd-display "ramp 11: ~A" (safe-display-edits ind 0 3)))
      (undo)
      (delete-samples 4 2)
      (if (not (string-=? (safe-display-edits ind 0 3) "
 (delete 4 2) ; delete-samples 4 2 [3:5]:
   (at 0, cp->sounds[1][0:1, 1.000]) [buf: 10] 
   (at 2, cp->sounds[1][2:3, 1.000, [1]0.200 -> 0.280]) [buf: 10] 
   (at 4, cp->sounds[1][6:7, 1.000, [1]0.520 -> 0.600]) [buf: 10] 
   (at 6, cp->sounds[1][8:9, 1.000]) [buf: 10] 
   (at 8, end_mark)
"))
	  (snd-display "ramp 12: ~A" (safe-display-edits ind 0 3)))
      (undo)
      (delete-samples 4 3)
      (if (not (string-=? (safe-display-edits ind 0 3) "
 (delete 4 3) ; delete-samples 4 3 [3:5]:
   (at 0, cp->sounds[1][0:1, 1.000]) [buf: 10] 
   (at 2, cp->sounds[1][2:3, 1.000, [1]0.200 -> 0.280]) [buf: 10] 
   (at 4, cp->sounds[1][7:7, 1.000, [1]0.600 -> 0.600]) [buf: 10] 
   (at 5, cp->sounds[1][8:9, 1.000]) [buf: 10] 
   (at 7, end_mark)
"))
	  (snd-display "ramp 13: ~A" (safe-display-edits ind 0 3)))
      (undo)
      (delete-samples 4 4)
      (if (not (string-=? (safe-display-edits ind 0 3) "
 (delete 4 4) ; delete-samples 4 4 [3:4]:
   (at 0, cp->sounds[1][0:1, 1.000]) [buf: 10] 
   (at 2, cp->sounds[1][2:3, 1.000, [1]0.200 -> 0.280]) [buf: 10] 
   (at 4, cp->sounds[1][8:9, 1.000]) [buf: 10] 
   (at 6, end_mark)
"))
	  (snd-display "ramp 14: ~A" (safe-display-edits ind 0 3)))
      (undo)
      (delete-samples 4 5)
      (if (not (string-=? (safe-display-edits ind 0 3) "
 (delete 4 5) ; delete-samples 4 5 [3:4]:
   (at 0, cp->sounds[1][0:1, 1.000]) [buf: 10] 
   (at 2, cp->sounds[1][2:3, 1.000, [1]0.200 -> 0.280]) [buf: 10] 
   (at 4, cp->sounds[1][9:9, 1.000]) [buf: 10] 
   (at 5, end_mark)
"))
	  (snd-display "ramp 15: ~A" (safe-display-edits ind 0 3)))
      (undo)
      (scale-channel 0.5 4 2)
      (if (not (string-=? (safe-display-edits ind 0 3) "
 (scale 4 2) ; scale-channel 0.500 4 2 [3:6]:
   (at 0, cp->sounds[1][0:1, 1.000]) [buf: 10] 
   (at 2, cp->sounds[1][2:3, 1.000, [1]0.200 -> 0.280]) [buf: 10] 
   (at 4, cp->sounds[1][4:5, 0.500, [1]0.360 -> 0.440]) [buf: 10] 
   (at 6, cp->sounds[1][6:7, 1.000, [1]0.520 -> 0.600]) [buf: 10] 
   (at 8, cp->sounds[1][8:9, 1.000]) [buf: 10] 
   (at 10, end_mark)
"))
	  (snd-display "ramp 16: ~A" (safe-display-edits ind 0 3)))
      (undo)
      (pad-channel 4 1)
      (if (not (string-=? (safe-display-edits ind 0 3) "
 (silence 4 1) ; pad-channel [3:6]:
   (at 0, cp->sounds[1][0:1, 1.000]) [buf: 10] 
   (at 2, cp->sounds[1][2:3, 1.000, [1]0.200 -> 0.280]) [buf: 10] 
   (at 4, cp->sounds[-1][0:0, 0.000])
   (at 5, cp->sounds[1][4:7, 1.000, [1]0.360 -> 0.600]) [buf: 10] 
   (at 9, cp->sounds[1][8:9, 1.000]) [buf: 10] 
   (at 11, end_mark)
"))
	  (snd-display "ramp 17: ~A" (safe-display-edits ind 0 3)))
      (close-sound ind))
    
    ;; xramp
    (let ((ind (new-sound "test.snd"))) ; second main let
      (map-channel (lambda (y) 1.0) 0 10)
      (xramp-channel 0.0 1.0 32.0)
      (if (not (string-=? (safe-display-edits ind 0 2) "
 (ramp 0 10) ; xramp-channel 0.000 1.000 32.000 0 #f [2:2]:
   (at 0, cp->sounds[1][0:9, 1.000, [1]0.000 -> 1.000, off: -0.032, scl: 0.032]) [buf: 10] 
   (at 10, end_mark)
"))
	  (snd-display "xramp 1: ~A" (safe-display-edits ind 0 2)))
      (undo)
      (xramp-channel 0.0 1.0 0.325)
      (if (not (string-=? (safe-display-edits ind 0 2) "
 (ramp 0 10) ; xramp-channel 0.000 1.000 0.325 0 #f [2:2]:
   (at 0, cp->sounds[1][0:9, 1.000, [1]0.000 -> 1.000, off: 1.481, scl: -1.481]) [buf: 10] 
   (at 10, end_mark)
"))
	  (snd-display "xramp 2: ~A" (safe-display-edits ind 0 2)))
      (undo)
      (xramp-channel 0.0 1.0 0.0)
      (if (not (string-=? (safe-display-edits ind 0 2) (string-append "
 (scale 0 10) ; scale-channel 0.000 0 #f [2:2]:
   (at 0, cp->sounds[0][0:9, 0.000]) [file: " (getcwd) "/test.snd[0]]
   (at 10, end_mark)
")))
	  (snd-display "xramp 3: ~A" (safe-display-edits ind 0 2)))
      (undo)
      (xramp-channel 0.0 1.0 1.0)
      (if (not (string-=? (safe-display-edits ind 0 2) "
 (ramp 0 10) ; ramp-channel 0.000 1.000 0 #f [2:2]:
   (at 0, cp->sounds[1][0:9, 1.000, [1]-0.000 -> 1.000]) [buf: 10] 
   (at 10, end_mark)
"))
	  (snd-display "xramp 4: ~A" (safe-display-edits ind 0 2)))
      (undo)
      (xramp-channel 0.5 1.5 32.0)
      (if (not (string-=? (safe-display-edits ind 0 2) "
 (ramp 0 10) ; xramp-channel 0.500 1.500 32.000 0 #f [2:2]:
   (at 0, cp->sounds[1][0:9, 1.000, [1]0.500 -> 1.500, off: 0.468, scl: 0.032]) [buf: 10] 
   (at 10, end_mark)
"))
	  (snd-display "xramp 5: ~A" (safe-display-edits ind 0 2)))
      (if (or (fneq (maxamp) 1.5) (fneq (sample 0) 0.5))
	  (snd-display "xramp 5 vals: ~A ~A" (maxamp) (sample 0)))
      (undo)
      (xramp-channel -0.5 1.5 32.0)
      (if (not (string-=? (safe-display-edits ind 0 2) "
 (ramp 0 10) ; xramp-channel -0.500 1.500 32.000 0 #f [2:2]:
   (at 0, cp->sounds[1][0:9, 1.000, [1]-0.500 -> 1.500, off: -0.565, scl: 0.065]) [buf: 10] 
   (at 10, end_mark)
"))
	  (snd-display "xramp 6: ~A" (safe-display-edits ind 0 2)))
      (if (or (fneq (maxamp) 1.5) (fneq (sample 0) -0.5))
	  (snd-display "xramp 6 vals: ~A ~A" (maxamp) (sample 0)))
      (undo)
      (xramp-channel 0.0 1.0 32.0)
      (let ((vals (channel->float-vector)))
	(scale-channel 0.5)
	(if (not (string-=? (safe-display-edits ind 0 3) "
 (scale 0 10) ; scale-channel 0.500 0 #f [3:2]:
   (at 0, cp->sounds[1][0:9, 0.500, [1]0.000 -> 1.000, off: -0.032, scl: 0.032]) [buf: 10] 
   (at 10, end_mark)
"))
	    (snd-display "xramp 7: ~A" (safe-display-edits ind 0 3)))
	(let ((baddy (scan-channel (let ((p (make-one-pole 1.0 -1.0)))
				     (lambda (y) 
				       (fneq y (* 0.5 (float-vector-ref vals (floor (- (one-pole p 1.0) 1.0))))))))))
	  (if baddy (snd-display "trouble in xramp 7: ~A" baddy)))
	(undo)
	(delete-sample 0)
	(if (not (string-=? (safe-display-edits ind 0 3) "
 (delete 0 1) ; delete-samples 0 1 [3:2]:
   (at 0, cp->sounds[1][1:9, 1.000, [1]0.015 -> 1.000, off: -0.032, scl: 0.032]) [buf: 10] 
   (at 9, end_mark)
"))
	    (snd-display "xramp 8: ~A" (safe-display-edits ind 0 3)))
	(let ((baddy (scan-channel (let ((p (make-one-pole 1.0 -1.0)))
				     (lambda (y) 
				       (fneq y (float-vector-ref vals (floor (one-pole p 1.0)))))))))
	  (if baddy (snd-display "trouble in xramp 8: ~A" baddy)))
	(undo)
	(delete-samples 0 2)
	(if (not (string-=? (safe-display-edits ind 0 3) "
 (delete 0 2) ; delete-samples 0 2 [3:2]:
   (at 0, cp->sounds[1][2:9, 1.000, [1]0.037 -> 1.000, off: -0.032, scl: 0.032]) [buf: 10] 
   (at 8, end_mark)
"))
	    (snd-display "xramp 9: ~A" (safe-display-edits ind 0 3)))
	(let ((p (make-one-pole 1.0 -1.0)))
	  (one-pole p 1.0)
	  (let ((baddy (scan-channel (lambda (y) (fneq y (float-vector-ref vals (floor (one-pole p 1.0))))))))
	    (if baddy (snd-display "trouble in xramp 9: ~A" baddy)))))
      (undo)
      (delete-sample 0)
      (delete-sample 0)
      (if (not (string-=? (safe-display-edits ind 0 4) "
 (delete 0 1) ; delete-samples 0 1 [4:2]:
   (at 0, cp->sounds[1][2:9, 1.000, [1]0.037 -> 1.000, off: -0.032, scl: 0.032]) [buf: 10] 
   (at 8, end_mark)
"))
	  (snd-display "xramp 10: ~A" (safe-display-edits ind 0 4)))
      (undo 2)
      (delete-sample 4)
      (if (not (string-=? (safe-display-edits ind 0 3) "
 (delete 4 1) ; delete-samples 4 1 [3:3]:
   (at 0, cp->sounds[1][0:3, 1.000, [1]0.000 -> 0.070, off: -0.032, scl: 0.032]) [buf: 10] 
   (at 4, cp->sounds[1][5:9, 1.000, [1]0.189 -> 1.000, off: -0.032, scl: 0.032]) [buf: 10] 
   (at 9, end_mark)
"))
	  (snd-display "xramp 11: ~A" (safe-display-edits ind 0 3)))
      (undo)
      (delete-samples 4 2)
      (if (not (string-=? (safe-display-edits ind 0 3) "
 (delete 4 2) ; delete-samples 4 2 [3:3]:
   (at 0, cp->sounds[1][0:3, 1.000, [1]0.000 -> 0.070, off: -0.032, scl: 0.032]) [buf: 10] 
   (at 4, cp->sounds[1][6:9, 1.000, [1]0.293 -> 1.000, off: -0.032, scl: 0.032]) [buf: 10] 
   (at 8, end_mark)
"))
	  (snd-display "xramp 12: ~A" (safe-display-edits ind 0 3)))
      (undo)
      (scale-channel 0.5 4 2)
      (if (not (string-=? (safe-display-edits ind 0 3) "
 (scale 4 2) ; scale-channel 0.500 4 2 [3:4]:
   (at 0, cp->sounds[1][0:3, 1.000, [1]0.000 -> 0.070, off: -0.032, scl: 0.032]) [buf: 10] 
   (at 4, cp->sounds[1][4:5, 0.500, [1]0.118 -> 0.189, off: -0.032, scl: 0.032]) [buf: 10] 
   (at 6, cp->sounds[1][6:9, 1.000, [1]0.293 -> 1.000, off: -0.032, scl: 0.032]) [buf: 10] 
   (at 10, end_mark)
"))
	  (snd-display "xramp 13: ~A" (safe-display-edits ind 0 3)))
      (undo)
      (scale-channel 0.5 0 2)
      (if (not (string-=? (safe-display-edits ind 0 3) "
 (scale 0 2) ; scale-channel 0.500 0 2 [3:3]:
   (at 0, cp->sounds[1][0:1, 0.500, [1]0.000 -> 0.015, off: -0.032, scl: 0.032]) [buf: 10] 
   (at 2, cp->sounds[1][2:9, 1.000, [1]0.037 -> 1.000, off: -0.032, scl: 0.032]) [buf: 10] 
   (at 10, end_mark)
"))
	  (snd-display "xramp 14: ~A" (safe-display-edits ind 0 3)))
      (undo)
      (pad-channel 4 2)
      (if (not (string-=? (safe-display-edits ind 0 3) "
 (silence 4 2) ; pad-channel [3:4]:
   (at 0, cp->sounds[1][0:3, 1.000, [1]0.000 -> 0.070, off: -0.032, scl: 0.032]) [buf: 10] 
   (at 4, cp->sounds[-1][0:1, 0.000])
   (at 6, cp->sounds[1][4:9, 1.000, [1]0.118 -> 1.000, off: -0.032, scl: 0.032]) [buf: 10] 
   (at 12, end_mark)
"))
	  (snd-display "xramp 15: ~A" (safe-display-edits ind 0 3)))
      (undo)
      (set! (sample 4) 1.0)
      (if (not (string-=? (safe-display-edits ind 0 3) "
 (set 4 1) ; set-sample 4 1.0000 [3:4]:
   (at 0, cp->sounds[1][0:3, 1.000, [1]0.000 -> 0.070, off: -0.032, scl: 0.032]) [buf: 10] 
   (at 4, cp->sounds[2][0:0, 1.000]) [buf: 1] 
   (at 5, cp->sounds[1][5:9, 1.000, [1]0.189 -> 1.000, off: -0.032, scl: 0.032]) [buf: 10] 
   (at 10, end_mark)
"))
	  (snd-display "xramp 16: ~A" (safe-display-edits ind 0 3)))
      (undo)
      (set! (samples 4 2) (make-float-vector 2))
      (if (not (string-=? (safe-display-edits ind 0 3) "
 (set 4 2) ; set-samples [3:4]:
   (at 0, cp->sounds[1][0:3, 1.000, [1]0.000 -> 0.070, off: -0.032, scl: 0.032]) [buf: 10] 
   (at 4, cp->sounds[2][0:1, 1.000]) [buf: 2] 
   (at 6, cp->sounds[1][6:9, 1.000, [1]0.293 -> 1.000, off: -0.032, scl: 0.032]) [buf: 10] 
   (at 10, end_mark)
"))
	  (snd-display "xramp 17: ~A" (safe-display-edits ind 0 3)))
      (undo)
      (scale-channel 0.5)
      (set! (samples 4 2) (make-float-vector 2))
      (if (not (string-=? (safe-display-edits ind 0 4) "
 (set 4 2) ; set-samples [4:4]:
   (at 0, cp->sounds[1][0:3, 0.500, [1]0.000 -> 0.070, off: -0.032, scl: 0.032]) [buf: 10] 
   (at 4, cp->sounds[2][0:1, 1.000]) [buf: 2] 
   (at 6, cp->sounds[1][6:9, 0.500, [1]0.293 -> 1.000, off: -0.032, scl: 0.032]) [buf: 10] 
   (at 10, end_mark)
"))
	  (snd-display "xramp 18: ~A" (safe-display-edits ind 0 4)))
      (close-sound ind))

    (let ((ind (new-sound "test.snd"))) ; third
      (map-channel (lambda (y) 1.0) 0 100)
      (do ((i 0 (+ i 1)))
	  ((= i 10))
	(scale-channel 0.5 (* i 10) 10))
      (ramp-channel 0.0 1.0)
      (if (not (string=? (safe-display-edits ind 0 12) "
 (ramp 0 100) ; ramp-channel 0.000 1.000 0 #f [12:11]:
   (at 0, cp->sounds[1][0:9, 0.500, [1]0.000 -> 0.091]) [buf: 100] 
   (at 10, cp->sounds[1][10:19, 0.500, [1]0.101 -> 0.192]) [buf: 100] 
   (at 20, cp->sounds[1][20:29, 0.500, [1]0.202 -> 0.293]) [buf: 100] 
   (at 30, cp->sounds[1][30:39, 0.500, [1]0.303 -> 0.394]) [buf: 100] 
   (at 40, cp->sounds[1][40:49, 0.500, [1]0.404 -> 0.495]) [buf: 100] 
   (at 50, cp->sounds[1][50:59, 0.500, [1]0.505 -> 0.596]) [buf: 100] 
   (at 60, cp->sounds[1][60:69, 0.500, [1]0.606 -> 0.697]) [buf: 100] 
   (at 70, cp->sounds[1][70:79, 0.500, [1]0.707 -> 0.798]) [buf: 100] 
   (at 80, cp->sounds[1][80:89, 0.500, [1]0.808 -> 0.899]) [buf: 100] 
   (at 90, cp->sounds[1][90:99, 0.500, [1]0.909 -> 1.000]) [buf: 100] 
   (at 100, end_mark)
"))
	  (snd-display "multi-ramp 1: ~A" (safe-display-edits ind 0 12)))
      (if (fneq (maxamp) 0.5) (snd-display "multi ramp 1 maxamp: ~A" (maxamp)))
      (undo)
      (ramp-channel 0.1 1.0 10 90)
      (if (not (string=? (safe-display-edits ind 0 12) "
 (ramp 10 90) ; ramp-channel 0.100 1.000 10 90 [12:11]:
   (at 0, cp->sounds[1][0:9, 0.500]) [buf: 100] 
   (at 10, cp->sounds[1][10:19, 0.500, [1]0.100 -> 0.191]) [buf: 100] 
   (at 20, cp->sounds[1][20:29, 0.500, [1]0.201 -> 0.292]) [buf: 100] 
   (at 30, cp->sounds[1][30:39, 0.500, [1]0.302 -> 0.393]) [buf: 100] 
   (at 40, cp->sounds[1][40:49, 0.500, [1]0.403 -> 0.494]) [buf: 100] 
   (at 50, cp->sounds[1][50:59, 0.500, [1]0.504 -> 0.596]) [buf: 100] 
   (at 60, cp->sounds[1][60:69, 0.500, [1]0.606 -> 0.697]) [buf: 100] 
   (at 70, cp->sounds[1][70:79, 0.500, [1]0.707 -> 0.798]) [buf: 100] 
   (at 80, cp->sounds[1][80:89, 0.500, [1]0.808 -> 0.899]) [buf: 100] 
   (at 90, cp->sounds[1][90:99, 0.500, [1]0.909 -> 1.000]) [buf: 100] 
   (at 100, end_mark)
"))
	  (snd-display "multi-ramp 2: ~A" (safe-display-edits ind 0 12)))
      (if (fneq (maxamp) 0.5) (snd-display "multi ramp 2 maxamp: ~A" (maxamp)))
      (undo)
      (ramp-channel 0.0 0.9 0 90)
      (if (not (string=? (safe-display-edits ind 0 12) "
 (ramp 0 90) ; ramp-channel 0.000 0.900 0 90 [12:11]:
   (at 0, cp->sounds[1][0:9, 0.500, [1]0.000 -> 0.091]) [buf: 100] 
   (at 10, cp->sounds[1][10:19, 0.500, [1]0.101 -> 0.192]) [buf: 100] 
   (at 20, cp->sounds[1][20:29, 0.500, [1]0.202 -> 0.293]) [buf: 100] 
   (at 30, cp->sounds[1][30:39, 0.500, [1]0.303 -> 0.394]) [buf: 100] 
   (at 40, cp->sounds[1][40:49, 0.500, [1]0.404 -> 0.496]) [buf: 100] 
   (at 50, cp->sounds[1][50:59, 0.500, [1]0.506 -> 0.597]) [buf: 100] 
   (at 60, cp->sounds[1][60:69, 0.500, [1]0.607 -> 0.698]) [buf: 100] 
   (at 70, cp->sounds[1][70:79, 0.500, [1]0.708 -> 0.799]) [buf: 100] 
   (at 80, cp->sounds[1][80:89, 0.500, [1]0.809 -> 0.900]) [buf: 100] 
   (at 90, cp->sounds[1][90:99, 0.500]) [buf: 100] 
   (at 100, end_mark)
"))
	  (snd-display "multi-ramp 3: ~A" (safe-display-edits ind 0 12)))
      (if (fneq (maxamp) 0.5) (snd-display "multi ramp 3 maxamp: ~A" (maxamp)))
      (if (fneq (sample 89) 0.45) (snd-display "multi ramp 3 sample 89: ~A" (sample 89)))
      (if (fneq (sample 90) 0.5) (snd-display "multi ramp 3 sample 90: ~A" (sample 90)))
      (undo)
      (ramp-channel 0.1 0.9 10 80)
      (if (not (string=? (safe-display-edits ind 0 12) "
 (ramp 10 80) ; ramp-channel 0.100 0.900 10 80 [12:11]:
   (at 0, cp->sounds[1][0:9, 0.500]) [buf: 100] 
   (at 10, cp->sounds[1][10:19, 0.500, [1]0.100 -> 0.191]) [buf: 100] 
   (at 20, cp->sounds[1][20:29, 0.500, [1]0.201 -> 0.292]) [buf: 100] 
   (at 30, cp->sounds[1][30:39, 0.500, [1]0.303 -> 0.394]) [buf: 100] 
   (at 40, cp->sounds[1][40:49, 0.500, [1]0.404 -> 0.495]) [buf: 100] 
   (at 50, cp->sounds[1][50:59, 0.500, [1]0.505 -> 0.596]) [buf: 100] 
   (at 60, cp->sounds[1][60:69, 0.500, [1]0.606 -> 0.697]) [buf: 100] 
   (at 70, cp->sounds[1][70:79, 0.500, [1]0.708 -> 0.799]) [buf: 100] 
   (at 80, cp->sounds[1][80:89, 0.500, [1]0.809 -> 0.900]) [buf: 100] 
   (at 90, cp->sounds[1][90:99, 0.500]) [buf: 100] 
   (at 100, end_mark)
"))
	  (snd-display "multi-ramp 4: ~A" (safe-display-edits ind 0 12)))
      (revert-sound)
      (map-channel (lambda (y) 1.0) 0 100)
      (ramp-channel 0.0 1.0)
      (do ((i 0 (+ i 1)))
	  ((= i 10))
	(scale-channel 0.5 (* i 10) 10))
      (if (not (string=? (safe-display-edits ind 0 12) "
 (scale 90 10) ; scale-channel 0.500 90 10 [12:11]:
   (at 0, cp->sounds[1][0:9, 0.500, [1]0.000 -> 0.091]) [buf: 100] 
   (at 10, cp->sounds[1][10:19, 0.500, [1]0.101 -> 0.192]) [buf: 100] 
   (at 20, cp->sounds[1][20:29, 0.500, [1]0.202 -> 0.293]) [buf: 100] 
   (at 30, cp->sounds[1][30:39, 0.500, [1]0.303 -> 0.394]) [buf: 100] 
   (at 40, cp->sounds[1][40:49, 0.500, [1]0.404 -> 0.495]) [buf: 100] 
   (at 50, cp->sounds[1][50:59, 0.500, [1]0.505 -> 0.596]) [buf: 100] 
   (at 60, cp->sounds[1][60:69, 0.500, [1]0.606 -> 0.697]) [buf: 100] 
   (at 70, cp->sounds[1][70:79, 0.500, [1]0.707 -> 0.798]) [buf: 100] 
   (at 80, cp->sounds[1][80:89, 0.500, [1]0.808 -> 0.899]) [buf: 100] 
   (at 90, cp->sounds[1][90:99, 0.500, [1]0.909 -> 1.000]) [buf: 100] 
   (at 100, end_mark)
"))
	  (snd-display "multi-ramp 5: ~A" (safe-display-edits ind 0 12)))
      (close-sound ind))
    
    (let ((ind (open-sound "oboe.snd")))
      (if (not (= (redo 1 ind 0) 0)) (snd-display "open redo with no ops: ~A" (redo)))
      (if (not (= (undo 1 ind 0) 0)) (snd-display "open undo with no ops: ~A" (undo)))
      (set! (cursor) 1000)
      (delete-sample 321)
      (if (not (= (cursor) 999)) (snd-display "delete-sample before cursor: ~A" (cursor)))
      (if (not (= (cursor ind 0 0) 1000)) (snd-display "delete-sample before cursor (0): ~A" (cursor ind 0 0)))
      (undo)
      (if (not (= (cursor) 1000)) (snd-display "delete-sample after cursor undo: ~A" (cursor)))
      (undo -1)
      (if (not (= (cursor) 999)) (snd-display "delete-sample before cursor redo: ~A" (cursor)))
      (redo -1)
      (delete-sample 1321)
      (if (not (= (cursor) 1000)) (snd-display "delete-sample after cursor: ~A" (cursor)))
      (undo)
      (delete-samples 0 100)
      (if (not (= (cursor) 900)) (snd-display "delete-samples before cursor: ~A" (cursor)))
      (undo)
      (delete-samples 1100 100)
      (if (not (= (cursor) 1000)) (snd-display "delete-samples after cursor: ~A" (cursor)))
      (undo)
      (insert-samples 100 100 (make-float-vector 100))
      (if (not (= (cursor) 1100)) (snd-display "insert-samples before cursor: ~A" (cursor)))
      (undo)
      (insert-samples 1100 100 (make-float-vector 100))
      (if (not (= (cursor) 1000)) (snd-display "insert-samples after cursor: ~A" (cursor)))
      (undo)
      (set! (samples 0 100) (make-float-vector 100))
      (if (not (= (cursor) 1000)) (snd-display "set-samples cursor: ~A" (cursor)))
      (set! (show-axes ind 0) show-x-axis-unlabelled)
      (update-time-graph)
      (set! (show-axes ind 0) show-all-axes-unlabelled)
      (update-time-graph)
      (close-sound ind))
    
    (let ((ind (new-sound "test.snd" :size 100)))
      (float-vector->channel (make-float-vector 3 1.0) 10 8)
      (if (fneq (maxamp ind 0) 1.0)
	  (snd-display "float-vector->channel size mismatch maxamp: ~A" (maxamp ind 0)))
      (if (not (mus-arrays-equal? (channel->float-vector 0 20 ind 0)
				  #r(0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 1.0 1.0 1.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0)))
	  (snd-display "float-vector->channel size mismatch: ~A" (channel->float-vector 0 20 ind 0)))
      (revert-sound ind)
      (set! (samples 10 5) (make-float-vector 3 1.0))
      (if (fneq (maxamp ind 0) 1.0)
	  (snd-display "set samples size mismatch maxamp: ~A" (maxamp ind 0)))
      (if (not (mus-arrays-equal? (channel->float-vector 0 20 ind 0)
				  #r(0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 1.0 1.0 1.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0)))
	  (snd-display "set samples size mismatch: ~A" (channel->float-vector 0 20 ind 0)))
      (revert-sound ind)
      (insert-samples 10 8 (make-float-vector 3 1.0) ind 0)
      (if (fneq (maxamp ind 0) 1.0)
	  (snd-display "insert samples size mismatch maxamp: ~A" (maxamp ind 0)))
      (if (not (mus-arrays-equal? (channel->float-vector 0 20 ind 0)
				  #r(0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 1.0 1.0 1.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0)))
	  (snd-display "insert samples size mismatch: ~A" (channel->float-vector 0 20 ind 0)))
      (close-sound ind))
    
    (let ((index (open-sound "oboe.snd")))
      (if (not (string=? (snd-completion " open-so") " open-sound"))
	  (snd-display "completion: ~A" (snd-completion " open-so")))
					;	(if (not (string=? (snd-completion " open-sound") " open-sound"))
					;	    (snd-display "completion: ~A" (snd-completion " open-so")))
      (if (not (string=? (snd-completion " zoom-focus-r") " zoom-focus-right"))
	  (snd-display "completion: ~A" (snd-completion " zoom-focus-r")))
      (play "oboe.snd" :wait #t)
      (play "oboe.snd" :start 12000 :wait #t)
      (play "oboe.snd" :start 12000 :end 15000 :wait #t)
      (play :edit-position (- (edit-position) 1) :wait #t)
      (let-temporarily (((speed-control index) -2.0)
			(*speed-control-style* speed-control-as-semitone)
			((show-controls index) #t))
	(play index :start 12345 :wait #t)
	(set! (speed-control index) 0.5)
	(set! *speed-control-style* speed-control-as-ratio)
	(set! (speed-control index) 0.25))
      (if (<= (disk-kspace "oboe.snd") 0)
	  (snd-display "disk-kspace = ~A" (disk-kspace "oboe.snd")))
      (if (not (= (disk-kspace "/baddy/hiho") -1))
	  (snd-display "disk-kspace of bogus file = ~A" (disk-kspace "/baddy/hiho")))
      (if (not (= (transform-framples) 0)) (snd-display "transform-framples ~A?" (transform-framples)))
      (set! *transform-size* 512)
      
      (set! (transform-graph?) #t)
      (set! (time-graph?) #t)
      
      (when with-gui
	(catch #t
	  (lambda ()
	    (if (not (string=? (x-axis-label) "time")) 
		(snd-display "def time x-axis-label: ~A" (x-axis-label)))
	    (set! (x-axis-label index 0 time-graph) "no time")
	    (if (not (string=? (x-axis-label) "no time")) 
		(snd-display "time x-axis-label: ~A" (x-axis-label index 0 time-graph)))
	    
	    (update-transform-graph)
	    (if (not (string=? (x-axis-label index 0 transform-graph) "frequency")) 
		(snd-display "get fft x-axis-label: ~A" (x-axis-label index 0 transform-graph)))
	    (set! (x-axis-label index 0 transform-graph) "hiho")
	    (update-transform-graph)
	    (if (not (string=? (x-axis-label index 0 transform-graph) "hiho")) 
		(snd-display "set fft x-axis-label: ~A" (x-axis-label index 0 transform-graph)))
	    (set! (x-axis-label index 0 transform-graph) "frequency") ; for later test
	    
	    (graph '(0 0 1 1 2 0) "lisp")
	    (update-lisp-graph)
	    (if (not (string=? (x-axis-label index 0 lisp-graph) "lisp")) 
		(snd-display "def lisp x-axis-label: ~A" (x-axis-label index 0 lisp-graph)))
	    (set! (x-axis-label index 0 lisp-graph) "no lisp")
	    (if (not (string=? (x-axis-label index 0 lisp-graph) "no lisp")) 
		(snd-display "lisp x-axis-label: ~A" (x-axis-label index 0 lisp-graph)))
	    
	    (set! (y-axis-label index 0 time-graph) "no amp")
	    (if (not (string=? (y-axis-label) "no amp"))
		(snd-display "time y-axis-label: ~A" (y-axis-label index 0 time-graph)))
	    (set! (y-axis-label index 0 lisp-graph) "no lamp")
	    (if (not (string=? (y-axis-label index 0 lisp-graph) "no lamp")) 
		(snd-display "lisp y-axis-label: ~A" (y-axis-label index 0 lisp-graph)))
	    (set! (y-axis-label) #f)
	    (set! (y-axis-label index 0) "no amp")
	    (if (not (string=? (y-axis-label) "no amp")) 
		(snd-display "time y-axis-label (time): ~A" (y-axis-label index 0 time-graph)))
	    (set! (y-axis-label index) #f))
	  (lambda args (snd-display "axis label error: ~A" args)))
	
	(when (provided? 'snd-motif)
	  (graph-data (make-float-vector 4) index 0 copy-context #f #f graph-lines #f)
	  (update-lisp-graph))
	(graph #r(0 0 1 1 2 0))
	(do ((i 0 (+ i 1))) 
	    ((= i 32)) 
	  (graph #r(0 1 2)) 
	  (graph (list #r(0 1 2) #r(3 2 1) #r(1 2 3)))
	  (graph (list #r(0 1 2) #r(3 2 1))))
	(set! (x-bounds) (list 0.0 0.01))
	(let ((data (make-graph-data)))
	  (if (float-vector? data)
	      (let ((mid (round (* .5 (length data)))))
		(if (not (= (length data) (- (+ (right-sample) 1) (left-sample))))
		    (snd-display "make-graph-data bounds: ~A ~A -> ~A" (left-sample) (right-sample) (length data)))
		(if (fneq (data mid)
			  (sample (+ (left-sample) mid)))
		    (snd-display "make-graph-data[~D]: ~A ~A" mid (data mid) (sample (+ (left-sample) mid)))))))
	(let ((data (make-graph-data index 0 0 100 199)))
	  (when (float-vector? data)
	    (if (not (= (length data) 100))
		(snd-display "make-graph-data 100:199: ~A" (length data)))
	    (if (fneq (data 50) (sample 50))
		(snd-display "make-graph-data 50: ~A ~A" (data 50) (sample 50)))))
	(set! (x-bounds) (list 0.0 0.1))
	(update-transform-graph)
	(catch 'no-such-axis
	  (lambda ()
	    (if (not (string=? (x-axis-label index 0 transform-graph) "frequency")) 
		(snd-display "def fft x-axis-label: ~A" (x-axis-label index 0 transform-graph)))
	    (set! (x-axis-label index 0 transform-graph) "fourier")
	    (if (not (string=? (x-axis-label index 0 transform-graph) "fourier")) 
		(snd-display "fft x-axis-label: ~A" (x-axis-label index 0 transform-graph)))
	    (set! (x-axis-label) "hiho")
	    
	    (set! (y-axis-label index 0 transform-graph) "spectra")
	    (let ((val (y-axis-label index 0 transform-graph)))
	      (if (not (equal? val "spectra"))
		  (snd-display "fft y-axis-label: ~A" val)))
	    (set! (y-axis-label) "hiho") 
	    #f)
	  (lambda args (snd-display "transform axis not displayed?"))))
      
      (if (and (number? (transform-framples))
	       (= (transform-framples) 0))
	  (snd-display "transform-graph? transform-framples ~A?" (transform-framples)))
      (update-transform-graph)
      (let ((tag (catch #t (lambda () (peaks "/baddy/hiho")) (lambda args (car args)))))
	(if (not (eq? tag 'cant-open-file)) (snd-display "peaks bad file: ~A" tag)))
      (peaks "tmp.peaks")
      (let* ((p (open-input-file "tmp.peaks"))
	     (line (read-line p)))
	(if (not (string=? "Snd: fft peaks" (substring line 0 14)))
	    (snd-display "peaks 1: ~A?" line))
	(read-line p)
	(set! line (read-line p))
	(if (not (member line '(#<eof> "oboe.snd, fft 512 points beginning at sample 0 (0.000 secs), Blackman2"
				       "oboe.snd, fft 512 points beginning at sample 0 (0.000 secs), Blackman2\n")))
	    (snd-display "peaks 2: ~A?" line))
	(close-input-port p))
      (delete-file "tmp.peaks")
      (peaks)
      (if (and (provided? 'xm) 
	       (not (and ((dialog-widgets) 15)
			 ((*motif* 'XtIsManaged) ((dialog-widgets) 15)))))
	  (snd-display "peaks but no help?"))
      (dismiss-all-dialogs)
      (let ((num-transforms 6)
	    (num-transform-graph-types 3))
	(set! (transform-graph? index 0) #t)
	(set! (transform-size index 0) 64)
	(do ((i 0 (+ i 1)))
	    ((= i num-transforms))
	  (set! *transform-type* (integer->transform i))
	  (if (not (transform? (integer->transform i))) (snd-display "transform? ~A?" i))
	  (do ((j 0 (+ j 1)))
	      ((= j num-transform-graph-types))
	    (set! (transform-graph-type index 0) j)
	    (update-transform-graph index 0))))
      (set! *transform-type* fourier-transform)
      (if (not (transform? *transform-type*)) (snd-display "transform? ~A ~A?" *transform-type* fourier-transform))
      (if (not (transform? autocorrelation)) (snd-display "transform? autocorrelation"))
      
      (if (read-only index) (snd-display "read-only open-sound: ~A?" (read-only index)))
      (set! (read-only index) #t)
      (if (not (read-only index)) (snd-display "set-read-only: ~A?" (read-only index)))
      (when with-gui
	(let ((a-ctr 0))
	  (bind-key #\a 0 (lambda () (set! a-ctr 3)))
	  (key (char->integer #\a) 0)
	  (if (not (= a-ctr 3)) (snd-display "bind-key: ~A?" a-ctr))
	  (let ((str (object->string (procedure-source (key-binding (char->integer #\a) 0)) #f)))
	    (if (not (string=? str "(lambda () (set! a-ctr 3))"))
		(snd-display "key-binding: ~A?" str)))
	  (unbind-key (char->integer #\a) 0))
	(key (char->integer #\a) 0))
      (do ((i 0 (+ i 1)))
	  ((= i 5))
	(when (string? *eps-file*)
	  (if (file-exists? *eps-file*)
	      (delete-file *eps-file*))
	  (set! *graph-style* i)
	  (graph->ps)
	  (if (file-exists? *eps-file*)
	      (delete-file *eps-file*)
	      (snd-display "graph->ps: ~A?" *eps-file*))))
      (let ((err (catch 'cannot-print 
		   (lambda () 
		     (graph->ps "/bad/bad.eps"))
		   (lambda args 12345))))
	(if (not (= err 12345)) (snd-display "graph->ps err: ~A?" err)))
      (when with-gui
	(let ((n2 (or (open-sound "2.snd") (open-sound "4.aiff"))))
	  (set! (transform-graph? n2) #t)
	  (set! (channel-style n2) channels-superimposed)
	  (if (not (= (channel-style n2) channels-superimposed)) (snd-display "channel-style->~D: ~A?" channels-superimposed (channel-style n2)))
	  (graph->ps "aaa.eps")
	  (set! (channel-style n2) channels-combined)
	  (if (not (= (channel-style n2) channels-combined)) (snd-display "channel-style->~D: ~A?" channels-combined (channel-style n2)))
	  (graph->ps "aaa.eps")
	  (set! (channel-style n2) channels-separate)
	  (if (not (= (channel-style n2) channels-separate)) (snd-display "channel-style->~D: ~A?" channels-separate (channel-style n2)))
	  (graph->ps "aaa.eps")
	  (close-sound n2)))
      
      (let ((xp (x-position-slider))
	    (yp (y-position-slider))
	    (xz (x-zoom-slider))
	    (yz (y-zoom-slider))
	    (bnds (x-bounds index)))
	(when (= (channels index) 1)
	  (set! (channel-style index) channels-superimposed)
	  (if (not (= (channel-style index) channels-separate)) (snd-display "channel-style[0]->~D: ~A?" channels-separate (channel-style index))))
	(set! (sync index) 32)
	(if (not (= (sync index) 32)) (snd-display "sync->32: ~A?" (sync index)))
	(if (< (sync-max) 32) (snd-display "sync-max 32: ~A" (sync-max)))
	(set! (sync index) 0)
	(set! (channel-sync index 0) 12)
	(if (not (= (channel-sync index 0) 12)) (snd-display "sync-chn->12: ~A?" (channel-sync index 0)))
	(set! (channel-sync index 0) 0)
	(if (fneq xp 0.0) (snd-display "x-position-slider: ~A?" xp))
	(if (fneq yp 0.0) (snd-display "y-position-slider: ~A?" yp))
	(if (and (fneq xz 0.04338) (fneq xz 1.0)) (snd-display "x-zoom-slider: ~A?" xz))
	(if (fneq yz 1.0) (snd-display "y-zoom-slider: ~A?" yz))
	(if (or (fneq (car bnds) 0.0) (and (fneq (cadr bnds) 0.1) (fneq (cadr bnds) 2.305)))
	    (snd-display "x-bounds: ~A?" bnds)))
      
      (if (not (equal? (find-sound "oboe.snd") index)) (snd-display "oboe: index ~D is not ~D?" (find-sound "oboe.snd") index))
      (if (not (sound? index)) (snd-display "oboe: ~D not ok?" index))
      (if (not (= (chans index) 1)) (snd-display "oboe: chans ~D?" (chans index)))
      (if (not (= (channels index) 1)) (snd-display "oboe: channels ~D?" (channels index)))
      (if (not (= (framples index) 50828)) (snd-display "oboe: framples ~D?" (framples index)))
      (if (not (= (srate index) 22050)) (snd-display "oboe: srate ~D?" (srate index)))
      (if (not (= (data-location index) 28)) (snd-display "oboe: location ~D?" (data-location index)))
      (if (not (= (data-size index) 101656)) (snd-display "oboe: size ~D?" (data-size index)))
      (if (not (= (sample-type index) mus-bshort)) (snd-display "oboe: format ~A?" (sample-type index)))
      (if (fneq (maxamp index) .14724) (snd-display "oboe: maxamp ~F?" (maxamp index)))
      (if (not (= (maxamp-position index) 24971)) (snd-display "oboe: maxamp-position ~A?" (maxamp-position index)))
      (if (> (length (comment index)) 0) (snd-display "oboe: comment ~A?" (comment index)))
      (if (not (string=? (short-file-name index) "oboe.snd")) (snd-display "oboe short name: ~S?" (short-file-name index)))
      (let ((matches (count-matches (lambda (a) (> a .125)))))
	(if (not (= matches 1313)) (snd-display "count-matches: ~A?" matches)))
      (let ((spot (scan-channel (lambda (a) (> a .13)))))
	(if (not (eqv? spot 8862)) (snd-display "find: ~A?" spot)))
      (set! (right-sample) 3000) 
      (let ((samp (right-sample)))
	(if (> (abs (- samp 3000)) 1) (snd-display "right-sample: ~A?" samp)))
      (set! (left-sample) 1000) 
      (let ((samp (left-sample)))
	(if (> (abs (- samp 1000)) 1) (snd-display "left-sample: ~A?" samp)))
      (let ((eds (edits)))
	(if (not (= (car eds) 0 (cadr eds)))
	    (snd-display "edits: ~A?" eds))
	(if (not (= (edit-position) (car eds)))
	    (snd-display "edit-position: ~A ~A?" (edit-position) eds)))
      (play index :channel 0 :wait #t)
      
      (if (not *selection-creates-region*) (set! *selection-creates-region* #t))
      (select-all index 0) 
      (let ((r0 (car (regions)))
	    (sel (selection)))
	(if (not (selection?)) (snd-display "selection?"))
	(if (not (selection? sel)) (snd-display "selection? sel"))
	(if (not (region? r0)) (snd-display "region?"))
	(if (not (= (selection-chans) 1)) (snd-display "selection-chans(1): ~A" (selection-chans)))
	(if (not (= (channels sel) 1)) (snd-display "generic selection-chans(1): ~A" (channels sel)))
	(if (not (= (selection-srate) (srate index))) (snd-display "selection-srate: ~A ~A" (selection-srate) (srate index)))
	(if (not (= (srate sel) (srate index))) (snd-display "generic selection-srate: ~A ~A" (srate sel) (srate index)))
	(if (fneq (region-maxamp r0) (maxamp index)) (snd-display "region-maxamp (1): ~A?" (region-maxamp r0)))
	(if (not (= (region-maxamp-position r0) (maxamp-position index)))
	    (snd-display "region-maxamp-position (1): ~A ~A?" (region-maxamp-position r0) (maxamp-position index)))
	(if (fneq (selection-maxamp index 0) (maxamp index)) (snd-display "selection-maxamp (1): ~A?" (selection-maxamp index 0)))
	(if (fneq (maxamp sel index 0) (maxamp index)) (snd-display "generic selection-maxamp (1): ~A?" (maxamp sel index 0)))
	(if (not (= (selection-maxamp-position index 0) (maxamp-position index)))
	    (snd-display "selection-maxamp-position (1): ~A ~A?" (selection-maxamp-position index 0) (maxamp-position index)))
	(save-region r0 "temp.dat")
	(if (file-exists? "temp.dat")
	    (delete-file "temp.dat")
	    (snd-display "save-region file disappeared?"))
	(play r0 :wait #t) ;needs to be #t here or it never gets run
	(if (not (= (length (regions)) 1)) (snd-display "regions: ~A?" (regions)))
	(if (not (selection-member? index)) (snd-display "selection-member?: ~A" (selection-member? index)))
	(if (not (= (region-srate r0) 22050)) (snd-display "region-srate: ~A?" (region-srate r0)))
	(if (not (= (region-chans r0) 1)) (snd-display "region-chans: ~A?" (region-chans r0)))
	(if (not (equal? (region-home r0) '("oboe.snd" 0 50828))) (snd-display "region-home: ~A" (region-home r0))) ; region-home docs say length
	(if (not (= (region-framples r0) 50828)) (snd-display "region-framples: ~A?" (region-framples r0)))
	(if (not (= (selection-framples) 50828)) (snd-display "selection-framples: ~A?" (selection-framples 0)))
	(if (not (= (framples sel) 50828)) (snd-display "generic selection-framples: ~A?" (framples sel)))
	(if (not (= (length sel) 50828)) (snd-display "generic length selection-framples: ~A?" (length sel)))
	(if (not (= (selection-position) 0)) (snd-display "selection-position: ~A?" (selection-position)))
	(if (not (= (region-position r0 0) 0)) (snd-display "region-position: ~A?" (region-position r0 0)))
	(if (fneq (region-maxamp r0) (maxamp index)) (snd-display "region-maxamp: ~A?" (region-maxamp r0)))
	(if (fneq (selection-maxamp index 0) (maxamp index)) (snd-display "selection-maxamp: ~A?" (selection-maxamp index 0)))
	(let ((samps1 (channel->float-vector 0 50827 index 0))
	      (samps2 (region->float-vector r0 0 50828 0))
	      (vr (make-sampler 0 index 0 1)))
	  (if (not (sampler? vr)) (snd-display "~A not sampler?" vr))
	  (if (not (= (sampler-position vr) 0)) (snd-display "initial sampler-position: ~A" (sampler-position vr)))
	  (if (not (equal? (sampler-home vr) (list index 0))) 
	      (snd-display "sampler-home: ~A ~A?" (sampler-home vr) (list index 0)))
	  (if (sampler-at-end? vr) (snd-display "~A init at end?" vr))
	  (let ((err (catch #t
		       (lambda ()
			 (region->float-vector r0 -1 1233))
		       (lambda args (car args)))))
	    (if (not (eq? err 'no-such-sample)) (snd-display "region->float-vector -1: ~A" err)))
	  (let ((err (catch #t
		       (lambda ()
			 (region->float-vector r0 12345678 1))
		       (lambda args (car args)))))
	    ;; should this return 'no-such-sample?
	    (if err (snd-display "region->float-vector 12345678: ~A" err)))
	  (let ((reader-string (object->string vr #f)))
	    (if (not (string=? reader-string "#<sampler: oboe.snd[0: 0] from 0, at 0, forward>"))
		(snd-display "sampler actually got: [~S]" reader-string)))
	  (catch 'break
	    (lambda ()
	      (do ((i 0 (+ i 1)))
		  ((= i 50827))
		(unless (= ((if (odd? i) next-sample read-sample) vr) (samps1 i) (samps2 i))
		  (snd-display "readers disagree at ~D" i)
		  (throw 'break))))
	    (lambda args (car args)))
	  (free-sampler vr)))
      (let ((var (catch #t (lambda () (make-sampler 0 index -1)) (lambda args args))))
	(if (not (eq? (car var) 'no-such-channel))
	    (snd-display "make-sampler bad chan (-1): ~A" var)))
      (let ((var (catch #t (lambda () (make-sampler 0 index 1)) (lambda args args))))
	(if (not (eq? (car var) 'no-such-channel))
	    (snd-display "make-sampler bad chan (1): ~A, ~A" var index)))
      (let ((fd (make-sampler 0)))
	(if (mix-sampler? fd) (snd-display "sampler: mix ~A" fd))
	(if (region-sampler? fd) (snd-display "sampler: region ~A" fd))
	(if (not (sampler? fd)) (snd-display "sampler: normal ~A" fd))
	(if (not (= (sampler-position fd) 0)) (snd-display "sampler: position: ~A" fd))
	(free-sampler fd)
	(let ((str (object->string fd #f)))
	  (if (not (string=? (substring str (- (length str) 16)) "at eof or freed>"))
	      (snd-display "freed sampler: ~A [~A]?" str (substring str (- (length str) 16))))))
      (let* ((reg (car (regions)))
	     (var (catch #t (lambda () (make-region-sampler reg 0 (+ (region-chans reg) 1))) (lambda args args))))
	(if (not (eq? (car var) 'no-such-channel))
	    (snd-display "make-region-sampler bad chan (2): ~A ~A" var (regions)))
	(let ((tag (catch #t (lambda () (make-region-sampler reg 0 0 -2)) (lambda args args))))
	  (if (not (eq? (car tag) 'no-such-direction))
	      (snd-display "make-region-sampler bad dir (-2): ~A" tag))))
      
      (revert-sound index)
      (insert-sample 100 .5 index) 
      (let ((var (catch #t (lambda () (insert-sound "oboe.snd" 0 1)) (lambda args args))))
	(if (not (eq? (car var) 'no-such-channel))
	    (snd-display "insert-sound bad chan (1): ~A" var)))
      (let ((var (catch #t (lambda () (insert-sample -12 1.0)) (lambda args args))))
	(if (not (eq? (car var) 'no-such-sample))
	    (snd-display "insert-sample bad pos: ~A" var)))
      (set! (show-axes index 0) show-no-axes)
      (update-transform-graph index) 
      (update-time-graph index) 
      (if (or (fneq (sample 100) .5)
	      (not (= (framples index) 50829)))
	  (snd-display "insert-sample: ~A ~A?" (sample 100) (framples index)))
      (let ((v0 (make-vector 3 .25))
	    (v1 (make-float-vector 3 .75)))
	(insert-samples 200 3 v0 index) 
	(insert-samples 300 3 v1 index) 
	(if (or (fneq (sample 201) .25)
		(fneq (sample 301) .75)
		(not (= (framples index) 50835)))
	    (snd-display "insert-samples: ~A ~A ~A?" (sample 201) (sample 301) (framples index))))
      (save-sound-as "hiho.snd" index 22050 mus-ldouble mus-next)
      (let ((nindex (view-sound "hiho.snd")))
	(if (fneq (sample 101 nindex) (sample 101 index))
	    (snd-display "save-sound-as: ~A ~A?" (sample 101 nindex) (sample 101 index)))
	(if (not (read-only nindex)) (snd-display "read-only view-sound: ~A?" (read-only nindex)))
	
	(set! (speed-control-style nindex) speed-control-as-semitone)
	(if (not (= (speed-control-style nindex) speed-control-as-semitone))
	    (snd-display "speed-control-style set semi: ~A" (speed-control-style nindex)))
	(set! (speed-control-tones nindex) -8)
	(if (not (= (speed-control-tones nindex) 12))
	    (snd-display "speed-control-tones -8: ~A" (speed-control-tones nindex)))
	(set! (speed-control-tones nindex) 18)
	(if (not (= (speed-control-tones nindex) 18))
	    (snd-display "speed-control-tones 18: ~A" (speed-control-tones nindex)))
	(graph->ps "aaa.eps")
	(close-sound nindex))
      (revert-sound index)
      (set! (sample 50 index) .5) 
      (if (fneq (sample 50) .5) (snd-display "set-sample: ~A?" (sample 50)))
      (let ((v0 (make-vector 3 0.25)))
	(set! (samples 60 3 index) v0) 
	(if (or (fneq (sample 60) .25) (fneq (sample 61) .25))
	    (snd-display "set-samples: ~A ~A ~A?" (sample 60) (sample 61) (sample 62))))
      (set! (samples 10 3 index) (list 0.1 0.2 0.3))
      (if (not (mus-arrays-equal? (channel->float-vector 10 3 index) #r(0.1 0.2 0.3)))
	  (snd-display "set-samples via list: ~A" (channel->float-vector 10 3 index)))
      (revert-sound index)
      (save-sound-as "temporary.snd" index)
      (set! (samples 100000 20000 index) "temporary.snd")
      (if (not (mus-arrays-equal? (channel->float-vector 110000 10) (channel->float-vector 10000 10)))
	  (snd-display "set samples to self: ~A ~A" (channel->float-vector 110000 10) (channel->float-vector 10000 10)))
      (revert-sound index)
      (delete-sample 100 index) 
      (if (not (file-exists? "temporary.snd"))
	  (snd-display "set-samples temp deleted?"))
      (delete-file "temporary.snd")
      (if (not (= (framples index) 50827)) (snd-display "delete-sample: ~A?" (framples index)))
      (delete-samples 0 100 index) 
      (if (not (= (framples index) 50727)) (snd-display "delete-samples: ~A?" (framples index)))
      (revert-sound index)
      (let ((maxa (* 2.0 (maxamp index))))
	(scale-to .5 index) 
	(let ((newmaxa (maxamp index)))
	  (if (fneq newmaxa .5) (snd-display "scale-to: ~A?" newmaxa))
	  (undo 1 index) 
	  (scale-by 2.0 index))
	(let ((newmaxa (maxamp index)))
	  (if (fneq newmaxa maxa) (snd-display "scale-by: ~A?" newmaxa)))
	(revert-sound index)
	(scale-by -1 index)
	(mix "oboe.snd")
	(if (fneq (maxamp index 0) 0.0) (snd-display "invert+mix->~A" (maxamp)))
	(revert-sound index)
	(select-all index) 
	(if (not (= (length (regions)) 2)) (snd-display "regions(2): ~A?" (regions)))
	(scale-selection-to .5)
	(let ((newmaxa (maxamp index)))
	  (if (fneq newmaxa .5) (snd-display "scale-selection-to: ~A?" newmaxa)))
	(revert-sound index)
	(select-all index) 
	(scale-selection-by 2.0)
	(let ((newmaxa (maxamp index)))
	  (if (fneq newmaxa maxa) (snd-display "scale-selection-by: ~A?" newmaxa))
	  (revert-sound index)
	  (with-temporary-selection (lambda () (scale-selection-by 2.0)) 0 (framples) index 0))
	(let ((newmaxa (maxamp index)))
	  (if (fneq newmaxa maxa) (snd-display "with-temporary-selection: ~A?" newmaxa))))
      (revert-sound index)
      (let ((samp999 (sample 999 index 0))
	    (samp1001 (sample 1001 index 0)))
	(with-temporary-selection (lambda () (scale-selection-to 2.0)) 1000 1 index 0)
	(if (fneq (sample 1000 index 0) 2.0) (snd-display "with-temporary-selection 1000: ~A" (sample 1000 index 0)))
	(if (fneq (sample 999 index 0) samp999) (snd-display "with-temporary-selection 999: ~A from ~A" (sample 999 index 0) samp999))
	(if (fneq (sample 1001 index 0) samp1001) (snd-display "with-temporary-selection 1001: ~A from ~A" (sample 1001 index 0) samp1001)))
      (revert-sound index)
      (make-selection 100 199 index 0)
      (let ((old-start (selection-position index 0))
	    (old-len (selection-framples index 0)))
	(with-temporary-selection (lambda () (scale-selection-to 2.0)) 1000 1 index 0)
	(if (not (selection?)) (snd-display "with-temporary-selection restore?"))
	(if (not (selection-member? index 0)) (snd-display "with-temporary-selection not member?"))
	(if (not (= (selection-position index 0) old-start)) (snd-display "with-temporary-selection start: ~A" (selection-position index 0)))
	(if (not (= (selection-framples index 0) old-len)) (snd-display "with-temporary-selection len: ~A" (selection-framples index 0))))
      (unselect-all)
      (if (selection-member? index 0) (snd-display "unselect all ~D 0?" index))
      (revert-sound index)
      (select-all index) 
      (let ((rread (make-region-sampler (car (regions)) 0))
	    (sread (make-sampler 0 index)))
	(let ((rvect (region->float-vector (car (regions)) 0 100))
	      (svect (samples 0 100 index)))
	  (if (fneq (rvect 1) (region-sample (car (regions)) 1))
	      (snd-display "region-sample: ~A ~A?" (region-sample (car (regions)) 1) (rvect 1)))
	  (do ((i 0 (+ i 1)))
	      ((= i 100))
	    (let ((rval (next-sample rread))
		  (sval (next-sample sread)))
	      (if (fneq rval sval) (snd-display "sample-read: ~A ~A?" rval sval))
	      (if (fneq rval (rvect i)) (snd-display "region-samples: ~A ~A?" rval (rvect i)))
	      (if (fneq sval (svect i)) (snd-display "samples: ~A ~A?" sval (svect i))))))
	(free-sampler rread) 
	(let ((val0 (next-sample sread)))
	  (if (sampler-at-end? sread) (snd-display "premature end?"))
	  (previous-sample sread)
	  (let ((val1 (previous-sample sread)))
	    (if (fneq val0 val1) (snd-display "previous-sample: ~A ~A?" val0 val1))))
	(free-sampler sread))
      (revert-sound index)
      (let ((s100 (sample 100))
	    (s40 (sample 40))
	    (len (framples))
	    (addlen (mus-sound-framples "fyow.snd")))
	(set! *cursor-style* cursor-line)
	(set! *cursor-size* 25)
	(set! (cursor index) 50) 
	(if (not (= *cursor-style* cursor-line))
	    (snd-display "cursor-style: ~A? " *cursor-style*))
	(if (not (= *cursor-size* 25))
	    (snd-display "cursor-size: ~A? " *cursor-size*))
	(set! *cursor-style* cursor-cross)
	(set! *cursor-size* 15)
	(set! (cursor index 0) 30) 
	(set! *cursor-style* cursor-line)
	(set! (cursor index 0) 20) 
	(when (and with-gui
		   (provided? 'snd-motif))
	  (set! (cursor-style index 0)
		(lambda (snd chn ax)
		  (let ((point (cursor-position)))
		    (let ((x (car point))
			  (y (cadr point))
			  (size (floor (/ *cursor-size* 2))))
		      (draw-line (- x size) (- y size) (+ x size) (+ y size) snd chn cursor-context #f)    
		      (draw-line (- x size) (+ y size) (+ x size) (- y size) snd chn cursor-context #f)))))
	  (if (not (procedure? (cursor-style index 0))) (snd-display "set cursor-style to proc: ~A" (cursor-style index 0))))
	(set! (cursor index) 50)
	(insert-sound "fyow.snd" (cursor) 0 index 0) 
	(if (or (fneq (sample 40) s40) (not (fneq (sample 100) s100)) (fneq (sample 100) 0.001831))
	    (snd-display "insert-sound: ~A?" (sample 100)))
	(if (not (= (framples) (+ len addlen))) (snd-display "insert-sound len: ~A?" (framples)))
	(save-sound-as "not-temporary.snd")
	(insert-samples 0 100 "not-temporary.snd")
	(set! (cursor index 0 0) (- (framples index 0 0) 2))
	(revert-sound)
	(if (not (= (cursor index 0) (- (framples index 0) 2)))
	    (snd-display "set edpos cursor: ~A ~A ~A" (cursor) (cursor index 0 0) (- (framples index 0 0) 2)))
	(if (file-exists? "not-temporary.snd")
	    (delete-file "not-temporary.snd")
	    (snd-display "insert-samples deleted its file?"))
	(let ((id (make-region 0 99)))
	  (insert-region id 60 index) 
	  (if (not (= (framples) (+ len 100))) (snd-display "insert-region len: ~A?" (framples)))
	  (if (fneq (sample 100) s40) (snd-display "insert-region: ~A ~A?" (sample 100) s40))
	  (save-region id "fmv.snd")
	  (if (not (= (mus-sound-header-type "fmv.snd") mus-next))
	      (snd-display "save-region header: ~A?" (mus-header-type-name (mus-sound-header-type "fmv.snd"))))
	  (if (not (= (mus-sound-sample-type "fmv.snd") mus-out-format))
	      (snd-display "save-region format: ~A?" (mus-sample-type-name (mus-sound-sample-type "fmv.snd"))))
	  (if (not (= (mus-sound-srate "fmv.snd") (region-srate id)))
	      (snd-display "save-region srate: ~A (~A)" (mus-sound-srate "fmv.snd") (region-srate id)))
	  (if (not (= (mus-sound-chans "fmv.snd") (region-chans id)))
	      (snd-display "save-region chans: ~A (~A)" (mus-sound-chans "fmv.snd") (region-chans id)))
	  (if (not (= (mus-sound-framples "fmv.snd") (region-framples id)))
	      (snd-display "save-region length: ~A (~A)" (mus-sound-framples "fmv.snd") (region-framples id)))
	  (if (not (= (region-position id 0) 0))
	      (snd-display "save-region position: ~A" (region-position id 0)))
	  (delete-file "fmv.snd")
	  (save-region id "fmv.snd" mus-lshort mus-riff "this is a comment")
	  (if (not (= (mus-sound-header-type "fmv.snd") mus-riff))
	      (snd-display "save-region riff header: ~A?" (mus-header-type-name (mus-sound-header-type "fmv.snd"))))
	  (if (not (= (mus-sound-sample-type "fmv.snd") mus-lshort))
	      (snd-display "save-region lshort format: ~A?" (mus-sample-type-name (mus-sound-sample-type "fmv.snd"))))
	  (if (not (= (mus-sound-framples "fmv.snd") (region-framples id)))
	      (snd-display "save-region length: ~A (~A)" (mus-sound-framples "fmv.snd") (region-framples id)))
	  (if (not (string=? (mus-sound-comment "fmv.snd") "this is a comment"))
	      (snd-display "save-region comment: ~A" (mus-sound-comment "fmv.snd")))
	  (delete-file "fmv.snd")
	  (save-region id :file "fmv.snd" :header-type mus-riff :sample-type mus-lshort :comment "this is a comment")
	  (if (not (= (mus-sound-header-type "fmv.snd") mus-riff))
	      (snd-display "save-region opt riff header: ~A?" (mus-header-type-name (mus-sound-header-type "fmv.snd"))))
	  (if (not (= (mus-sound-sample-type "fmv.snd") mus-lshort))
	      (snd-display "save-region opt lshort format: ~A?" (mus-sample-type-name (mus-sound-sample-type "fmv.snd"))))
	  (if (not (= (mus-sound-framples "fmv.snd") (region-framples id)))
	      (snd-display "save-region opt length: ~A (~A)" (mus-sound-framples "fmv.snd") (region-framples id)))
	  (if (not (string=? (mus-sound-comment "fmv.snd") "this is a comment"))
	      (snd-display "save-region opt comment: ~A" (mus-sound-comment "fmv.snd")))
	  (delete-file "fmv.snd")
	  (save-region id :comment "this is a comment" :file "fmv.snd" :sample-type mus-lshort :header-type mus-riff)
	  (if (not (= (mus-sound-header-type "fmv.snd") mus-riff))
	      (snd-display "save-region opt1 riff header: ~A?" (mus-header-type-name (mus-sound-header-type "fmv.snd"))))
	  (if (not (= (mus-sound-sample-type "fmv.snd") mus-lshort))
	      (snd-display "save-region opt1 lshort format: ~A?" (mus-sample-type-name (mus-sound-sample-type "fmv.snd"))))
	  (if (not (= (mus-sound-framples "fmv.snd") (region-framples id)))
	      (snd-display "save-region opt1 length: ~A (~A)" (mus-sound-framples "fmv.snd") (region-framples id)))
	  (if (not (string=? (mus-sound-comment "fmv.snd") "this is a comment"))
	      (snd-display "save-region opt1 comment: ~A" (mus-sound-comment "fmv.snd")))
	  (delete-file "fmv.snd")
	  (save-region id "fmv.snd" :sample-type mus-bshort)
	  (if (not (= (mus-sound-header-type "fmv.snd") mus-next))
	      (snd-display "save-region opt2 next header: ~A?" (mus-header-type-name (mus-sound-header-type "fmv.snd"))))
	  (if (not (= (mus-sound-sample-type "fmv.snd") mus-bshort))
	      (snd-display "save-region opt2 bshort format: ~A?" (mus-sample-type-name (mus-sound-sample-type "fmv.snd"))))
	  (delete-file "fmv.snd")))
      (close-sound index))
    (let ((var (catch #t (lambda () (new-sound "hi.snd" :channels 0)) (lambda args args))))
      (if (not (and (pair? var)
		    (eq? (car var) 'out-of-range)))
	  (snd-display "new-sound bad chan: ~A" var)))
    (let ((index (new-sound "fmv.snd" 2 22050 mus-ldouble mus-next "unequal lens")))
      (set! (sync index) 0) ; might be set by choice of graphs
      (insert-silence 0 1000 index 1)
      (if (not (and (= (framples index 0) 1)
		    (= (framples index 1) 1001)))
	  (snd-display "silence 1: ~A ~A" (framples index 0) (framples index 1)))
      (save-sound index)
      (if (not (= (framples index 0) 1001 (framples index 1)))
	  (snd-display "saved silence 1: ~A ~A" (framples index 0) (framples index 1)))
      (if (not (= (mus-sound-framples "fmv.snd") 1001))
	  (snd-display "saved framers silence 1: ~A" (mus-sound-framples "fmv.snd")))
      (let ((v0 (float-vector-peak (channel->float-vector 0 1000 index 0)))
	    (v1 (float-vector-peak (channel->float-vector 0 1000 index 1))))
	(if (fneq v0 0.0)
	    (snd-display "auto-pad 0: ~A" v0))
	(if (fneq v1 0.0)
	    (snd-display "silence 0: ~A" v1)))
      (close-sound index))
    (delete-file "fmv.snd")
    
    (let ((index (new-sound "fmv.snd" 2 22050 mus-ldouble mus-next "unequal lens")))
      (pad-channel 0 1000 index 1)
      (if (not (and (= (framples index 0) 1)
		    (= (framples index 1) 1001)))
	  (snd-display "pad-channel 1: ~A ~A" (framples index 0) (framples index 1)))
      (let ((v0 (float-vector-peak (channel->float-vector 0 1000 index 0)))
	    (v1 (float-vector-peak (channel->float-vector 0 1000 index 1))))
	(if (fneq v0 0.0)
	    (snd-display "pad 0: ~A" v0))
	(if (fneq v1 0.0)
	    (snd-display "pad 1: ~A" v1)))
      (map-channel (lambda (n) 1.0) 0 2 index 0)
      (map-channel (lambda (n) 1.0) 0 1002 index 1)
      (pad-channel 0 1000 index 0 1)
      (if (not (= (framples index 1) 1002))
	  (snd-display "pad-channel ed 1: ~A ~A" (framples index 0) (framples index 1)))
      (close-sound index)
      (delete-file "fmv.snd")
      
      (let ((ind (open-sound "1a.snd")))
	(scale-to 1.0 ind 0)
	(make-selection 1000 2000 ind 0)
	(filter-selection-and-smooth .01 #r(.25 .5 .5 .5 .25))
	(revert-sound ind)
	(close-sound ind)))
    
    (let ((index (new-sound "fmv.snd" 1 22050 mus-bshort mus-ircam "this is a comment")))
      (let ((v0 (make-float-vector 128)))
	(set! (v0 64) .5)
	(set! (v0 127) .5)
	(float-vector->channel v0 0 128 index 0)
	(make-selection 0 126) 
	(smooth-selection)) 
      
      (let ((v0 (channel->float-vector 0 128 index 0)))
	(if (or (fneq (sample 127) .5) (fneq (sample 120) .4962) (fneq (sample 32) 0.07431) (fneq (sample 64) 0.25308))
	    (snd-display "smooth-selection: ~A?" v0))
	(revert-sound index)
	(fill! v0 0.0)
	(set! (v0 10) .5)
	(float-vector->channel v0)
	(select-all) 
	(let-temporarily ((*sinc-width* 40))
	  (src-selection 0.5)))
      
      (let ((v0 (channel->float-vector 0 128 index 0)))
	(if (or (fneq (sample 20) .5) (fneq (sample 30) 0.0) (fneq (sample 17) -.1057) )
	    (snd-display "src-selection: ~A?" v0))
	(unselect-all)
	(if (selection-member?) (snd-display "unselect-all but still a selection?"))
	(unselect-all)
	(revert-sound index)
	(fill! v0 0.0)
	(set! (v0 10) .5)
	(float-vector->channel v0 0)
	(select-all) 
	(filter-selection '(0 0 .1 1 1 0) 40))
      
      (let ((v0 (channel->float-vector 0 128 index 0)))
	(if (or (fneq (sample 29) .1945) (fneq (sample 39) -.0137) (fneq (sample 24) -0.01986))
	    (snd-display "filter-selection: ~A?" v0))
	(revert-sound index)
	(fill! v0 1.0)
	(float-vector->channel v0 0 128 index 0) 
	(select-all) 
	(filter-selection (make-one-zero :a0 .5 :a1 0.0)))
      
      (let ((v0 (channel->float-vector 0 128 index 0)))
	(if (or (fneq (sample 29) .5) (fneq (sample 39) .5) (fneq (sample 24) 0.5))
	    (snd-display "filter-selection one-zero: ~A?" v0))
	(revert-sound index)
	(fill! v0 1.0)
	(float-vector->channel v0 0 128 index 0) 
	(if (file-exists? "fmv5.snd") (delete-file "fmv5.snd"))
	(select-all) 
	(env-selection '(0 0 1 1 2 0) 1.0))
      
      (let ((v0 (channel->float-vector 0 128 index 0)))
	(if (or (fneq (sample 64) 1.0) (fneq (sample 20) .3125) (fneq (sample 119) 0.127))
	    (snd-display "env-selection [len: ~A]: ~A ~A ~A ~A?" (selection-framples) (sample 64) (sample 20) (sample 119) v0))
	(save-selection "fmv5.snd" 22050 mus-bint mus-next "") ;1.0->-1.0 if short
	(revert-sound index)
	(let ((tag (catch #t (lambda () (file->array "/baddy/hiho" 0 0 128 v0)) (lambda args (car args)))))
	  (if (not (eq? tag 'no-such-file)) (snd-display "file->array w/o file: ~A" tag)))
	(let ((tag (catch #t (lambda () (file->array "fmv5.snd" 123 0 128 v0)) (lambda args (car args)))))
	  (if (not (eq? tag 'no-such-channel)) (snd-display "file->array w/o channel: ~A" tag)))
	(file->array "fmv5.snd" 0 0 128 v0) 
	(if (or (fneq (v0 64) 1.0) (fneq (v0 20) .3125) (fneq (v0 119) 0.127))
	    (snd-display "save-selection: ~A ~A ~A ~A?" (v0 64) (v0 20) (v0 119) v0))
	(if (not (= (mus-sound-header-type "fmv5.snd") mus-next))
	    (snd-display "save-selection type: ~A?" (mus-header-type-name (mus-sound-header-type "fmv5.snd"))))
	(if (not (= (mus-sound-sample-type "fmv5.snd") mus-bint))
	    (snd-display "save-selection format: ~A?" (mus-sample-type-name (mus-sound-sample-type "fmv5.snd"))))
	(if (not (= (mus-sound-srate "fmv5.snd") 22050))
	    (snd-display "save-selection srate: ~A?" (mus-sound-srate "fmv5.snd")))
	(fill! v0 0.0)
	(set! (v0 100) .5)
	(set! (v0 2) -.5)
	(float-vector->channel v0 0 128 index 0) 
	(select-all) 
	(without-errors (reverse-selection)) 
	(save-selection "fmv4.snd" 44100 mus-lfloat mus-riff "this is a comment"))
      
      (let ((v0 (channel->float-vector 0 128 index 0)))
	(if (or (fneq (sample 27) 0.5) (fneq (sample 125) -.5))
	    (snd-display "reverse-selection: ~A?" v0))
	(file->array "fmv4.snd" 0 0 128 v0) 
	(if (or (fneq (sample 27) 0.5) (fneq (sample 125) -.5))
	    (snd-display "save reverse-selection: ~A?" v0))
	(if (not (= (mus-sound-header-type "fmv4.snd") mus-riff))
	    (snd-display "save-selection type 1: ~A?" (mus-header-type-name (mus-sound-header-type "fmv4.snd"))))
	(if (not (= (mus-sound-sample-type "fmv4.snd") mus-lfloat))
	    (snd-display "save-selection format 1: ~A?" (mus-sample-type-name (mus-sound-sample-type "fmv4.snd"))))
	(if (not (= (mus-sound-srate "fmv4.snd") 44100))
	    (snd-display "save-selection srate 1: ~A?" (mus-sound-srate "fmv4.snd")))
	(if (not (string=? (mus-sound-comment "fmv4.snd") "this is a comment"))
	    (snd-display "save-selection comment: ~A?" (mus-sound-comment "fmv4.snd")))
	(delete-file "fmv4.snd")
	(save-selection :file "fmv4.snd" :header-type mus-riff :sample-type mus-lfloat :srate 44100 :comment "this is a comment")
	(if (not (= (mus-sound-header-type "fmv4.snd") mus-riff))
	    (snd-display "save-selection opt type 1: ~A?" (mus-header-type-name (mus-sound-header-type "fmv4.snd"))))
	(if (not (= (mus-sound-sample-type "fmv4.snd") mus-lfloat))
	    (snd-display "save-selection opt format 1: ~A?" (mus-sample-type-name (mus-sound-sample-type "fmv4.snd"))))
	(if (not (= (mus-sound-srate "fmv4.snd") 44100))
	    (snd-display "save-selection opt srate 1: ~A?" (mus-sound-srate "fmv4.snd")))
	(if (not (string=? (mus-sound-comment "fmv4.snd") "this is a comment"))
	    (snd-display "save-selection opt comment: ~A?" (mus-sound-comment "fmv4.snd")))
	(delete-file "fmv4.snd")
	(save-selection :file "fmv4.snd" :sample-type mus-bfloat :channel 0)
	(if (not (or (= (mus-sound-header-type "fmv4.snd") mus-next)
		     (= (mus-sound-header-type "fmv4.snd") mus-ircam)))
	    (snd-display "save-selection opt1 type 1: ~A?" (mus-header-type-name (mus-sound-header-type "fmv4.snd"))))
	(if (not (= (mus-sound-sample-type "fmv4.snd") mus-bfloat))
	    (snd-display "save-selection opt1 format 1: ~A?" (mus-sample-type-name (mus-sound-sample-type "fmv4.snd"))))
	(if (not (= (mus-sound-chans "fmv4.snd") 1))
	    (snd-display "save-selection opt1 chans: ~A?" (mus-sound-chans "fmv4.snd")))
	(delete-file "fmv4.snd")
	(revert-sound index)
	(fill! v0 0.0)
	(set! (v0 2) 1.0)
	(let ((v1 (make-float-vector 256)))
	  (copy v0 v1 0 128)
	  (float-vector->channel v1 0 128 index 0))
	(select-all)
	(if (mus-clipping) (set! (mus-clipping) #f))
	(if *clipping* (set! *clipping* #f))
	(convolve-selection-with "fmv5.snd" .5))
      
      (let ((v0 (channel->float-vector 0 128 index 0)))
	(if (fneq (sample 66) -.5) (snd-display "convolve-selection-with: ~A ~A ~A?" (v0 66) (sample 66) v0))
	(close-sound index))
      
      (let ((obind (open-sound "oboe.snd")))
	(when with-gui
	  (let ((vol (maxamp obind))
		(dur (framples)))
	    (set! (amp-control obind) 2.0)
	    (if (fffneq (amp-control obind) 2.0) (snd-display "set amp-control ~A" (amp-control obind)))
	    (reset-controls obind)
	    (if (ffneq (amp-control obind) 1.0) (snd-display "reset amp-control ~A" (amp-control obind)))
	    (set! (amp-control-bounds obind) (list 0.0 4.0))
	    (if (not (equal? (amp-control-bounds obind) '(0.0 4.0))) (snd-display "amp-control-bounds: ~A" (amp-control-bounds)))
	    (set! (amp-control obind) 2.0)
	    (if (eq? (without-errors (apply-controls obind)) 'no-such-sound) (snd-display "apply-controls can't find oboe.snd?"))
	    (let ((newamp (maxamp obind)))
	      (if (> (abs (- (* 2.0 vol) newamp)) .05) (snd-display "apply amp: ~A -> ~A?" vol newamp)))
	    (set! (amp-control-bounds obind) (list 0.0 8.0))
	    (set! (speed-control-bounds obind) (list 1.0 5.0))
	    (if (not (equal? (speed-control-bounds obind) '(1.0 5.0))) (snd-display "speed-control-bounds: ~A" (speed-control-bounds)))
	    (set! (speed-control obind) 0.5)
	    (set! (speed-control-bounds obind) (list .05 20.0))
	    (add-mark 1234)
	    (apply-controls obind)
	    (let ((newdur (framples obind)))
	      (set! (speed-control obind) 1.0)
	      (if (>= (- newdur (* 2.0 dur)) 256) (snd-display "apply speed: ~A -> ~A?" dur newdur))
	      ;; within 256 which is apply's buffer size (it always flushes full buffers) 
	      (set! (contrast-control? obind) #t)
	      (set! (contrast-control-bounds obind) (list 0.5 2.5))
	      (if (not (equal? (contrast-control-bounds obind) '(0.5 2.5))) (snd-display "contrast-control-bounds: ~A" (contrast-control-bounds)))
	      (set! (contrast-control obind) 1.0)
	      (apply-controls obind)
	      (set! (contrast-control-bounds obind) (list 0.0 10.0))
	      (if (not (equal? (contrast-control-bounds obind) '(0.0 10.0))) (snd-display "contrast-control-bounds (2): ~A" (contrast-control-bounds)))
	      (let ((secamp (maxamp obind))
		    (secdur (framples obind)))
		(if (fneq secamp .989) (snd-display "apply contrast: ~A?" secamp))
		(if (not (= secdur newdur)) (snd-display "apply contrast length: ~A -> ~A?" newdur secdur)))))
	  (undo 3 obind)
	  (set! (reverb-control? obind) #t)
	  (set! (reverb-control-scale-bounds obind) (list 0.0 1.0))
	  (if (not (equal? (reverb-control-scale-bounds obind) '(0.0 1.0))) 
	      (snd-display "reverb-control-scale-bounds: ~A" (reverb-control-scale-bounds)))
	  (set! (reverb-control-length-bounds obind) (list 0.0 2.0))
	  (if (not (equal? (reverb-control-length-bounds obind) '(0.0 2.0))) 
	      (snd-display "reverb-control-length-bounds: ~A" (reverb-control-length-bounds)))
	  (set! (reverb-control-scale obind) .2)
	  (let ((nowamp (maxamp obind)))
	    (apply-controls obind)
	    (let ((revamp (maxamp obind))
		  (revdur (framples obind)))
	      (if (ffneq revamp .214) 
		  (snd-display "apply reverb scale: ~A at ~A, scale: ~A previous max: ~A?" 
			       revamp (maxamp-position obind) (reverb-control-scale obind) nowamp))
	      (if (>= (- revdur 50828 (round (* *reverb-control-decay* 22050))) 256) 
		  (snd-display "apply reverb length: ~A?" revdur))))
	  (undo 1 obind)
	  (set! (expand-control? obind) #t)
	  (set! (expand-control-bounds obind) (list 1.0 3.0))
	  (if (not (equal? (expand-control-bounds obind) '(1.0 3.0))) (snd-display "expand-control-bounds: ~A" (expand-control-bounds)))
	  (set! (expand-control obind) 1.5)
	  (apply-controls obind)
	  (let ((expamp (maxamp obind))
		(expdur (framples obind)))
	    (if (> (abs (- expamp .152)) .05) (snd-display "apply expand-control scale: ~A?" expamp))
	    (if (<= expdur (* 1.25 50828)) (snd-display "apply expand-control length: ~A?" expdur))
	    (set! (expand-control-bounds obind) (list 0.001 20.0)))
	  (undo 1 obind)
	  (set! (filter-control? obind) #t)
	  (set! (filter-control-order obind) 40)
	  (set! (filter-control-envelope obind) '(0 0 1 .5 2 0))
	  (apply-controls obind)
	  (let ((fltamp (maxamp obind))
		(fltdur (framples obind)))
	    (if (> (abs (- fltamp .02)) .005) (snd-display "apply filter scale: ~A?" fltamp))
	    (if (> fltdur 51124) (snd-display "apply filter length: ~A?" fltdur))
	    (undo 1 obind)))
	
	(revert-sound obind)
	(make-selection 1000 1000)
	(scale-selection-to .1)
	(scale-selection-by 2.0)
	(make-selection 2000 2001)
	(scale-selection-by 2.0)
	(scale-selection-to .5)
	(make-selection 1000 2001)
	(scale-selection-to .5)
	(scale-selection-by .5)
	(make-selection 2000 2000)
	(scale-selection-by 2.0)
	(scale-selection-to .5)
	(make-selection 1000 1001)
	(scale-selection-to .1)
	(scale-selection-by 2.0)
	(make-selection 999 2002)
	(scale-selection-to 1.0)
	(scale-selection-by .5)
	(let ((tree (edit-tree))
	      (true-tree #((0 0 0 998 1.0 0.0 0.0 0) 
			   (999 0 999 999 0.999969720840454 0.0 0.0 0) 
			   (1000 0 1000 1000 6.09052181243896 0.0 0.0 0) 
			   (1001 0 1001 1001 0.999969720840454 0.0 0.0 0) 
			   (1002 0 1002 1999 0.499984979629517 0.0 0.0 0) 
			   (2000 0 2000 2000 7.54652404785156 0.0 0.0 0) 
			   (2001 0 2001 2001 3.7732629776001 0.0 0.0 0) 
			   (2002 0 2002 2002 0.999969720840454 0.0 0.0 0) 
			   (2003 0 2003 50827 1.0 0.0 0.0 0) 
			   (50828 -2 0 0 0.0 0.0 0.0 0))))
	  (if (not (= (length tree) (length true-tree)))
	      (snd-display "edit trees are not same length: ~A ~A?" (length tree) (length true-tree))
	      (do ((len (length tree))
		   (i 0 (+ i 1)))
		  ((= i len))
		(let ((branch (tree i))
		      (true-branch (true-tree i)))
		  (if (not (and (= (car branch) (car true-branch))
				(= (cadr branch) (cadr true-branch))
				(= (caddr branch) (caddr true-branch))
				(= (cadddr branch) (cadddr true-branch))
				(<= (magnitude (- (branch 4) (true-branch 4))) .001)))
		      (snd-display "edit trees disagree at ~D: ~A ~A" i branch true-branch))))))
	(insert-silence 1001 8)
	(insert-silence 900 50)
	(insert-silence 2005 1)
	(insert-silence 999 2)
	(let ((tree (edit-tree))
	      (true-tree #((0 0 0 899 1.0 0.0 0.0 0) 
			   (900 -1 0 49 0.0 0.0 0.0 0) 
			   (950 0 900 948 1.0 0.0 0.0 0) 
			   (999 -1 0 1 0.0 0.0 0.0 0) 
			   (1001 0 949 998 1.0 0.0 0.0 0) 
			   (1051 0 999 999 0.999969720840454 0.0 0.0 0) 
			   (1052 0 1000 1000 6.09052181243896 0.0 0.0 0) 
			   (1053 -1 0 7 0.0 0.0 0.0 0) 
			   (1061 0 1001 1001 0.999969720840454 0.0 0.0 0)
			   (1062 0 1002 1946 0.499984979629517 0.0 0.0 0) 
			   (2007 -1 0 0 0.0 0.0 0.0 0) 
			   (2008 0 1947 1999 0.499984979629517 0.0 0.0 0) 
			   (2061 0 2000 2000 7.54652404785156 0.0 0.0 0) 
			   (2062 0 2001 2001 3.7732629776001 0.0 0.0 0) 
			   (2063 0 2002 2002 0.999969720840454 0.0 0.0 0) 
			   (2064 0 2003 50827 1.0 0.0 0.0 0) 
			   (50889 -2 0 0 0.0 0.0 0.0 0))))
	  (if (not (= (length tree) (length true-tree)))
	      (snd-display "silenced edit trees are not same length: ~A ~A?" (length tree) (length true-tree))
	      (do ((len (length tree))
		   (i 0 (+ i 1)))
		  ((= i len))
		(let ((branch (tree i))
		      (true-branch (true-tree i)))
		  (if (not (and (= (car branch) (car true-branch))
				(= (cadr branch) (cadr true-branch))
				(= (caddr branch) (caddr true-branch))
				(= (cadddr branch) (cadddr true-branch))
				(<= (magnitude (- (branch 4) (true-branch 4))) .001)))
		      (snd-display "silenced edit trees disagree at ~D: ~A ~A" i branch true-branch))))))
	(if (or (fneq (sample 998) -.03)
		(fneq (sample 999) 0.0)
		(fneq (sample 1000) 0.0)
		(fneq (sample 1001) -.03))
	    (snd-display "insert-silence [999 for 2]: ~A ~A ~A ~A?" (sample 998) (sample 999) (sample 1000) (sample 1001) ))
	(if (or (fneq (sample 2006) -.033)
		(fneq (sample 2007) 0.0)
		(fneq (sample 2008) -.033))
	    (snd-display "insert-silence [2007 for 1]: ~A ~A ~A?" (sample 2006) (sample 2007) (sample 2008)))
	(revert-sound obind)
	(add-mark 1200 obind 0)
	(let ((mark-num (length (marks obind 0))))
	  (scale-by 2.0 obind 0)
	  (let ((mark-now (length (marks obind 0))))
	    (if (not (= mark-num mark-now))
		(snd-display "mark lost after scaling?")))
	  (set! (selection-position) 0)
	  (set! (selection-framples) 100)
	  (scale-selection-to .5)
	  (if (not (= mark-num (length (marks obind 0))))
	      (snd-display "mark lost after selection scaling?")))
	(let ((m1 (add-mark 1000)))
	  (set! (cursor obind 0) 100)
	  (key (char->integer #\u) 4 obind)
	  (key (char->integer #\1) 0 obind)
	  (key (char->integer #\0) 0 obind)
	  (key (char->integer #\0) 0 obind)
	  (key (char->integer #\o) 4 obind)
	  (if (and with-gui (not (= (mark-sample m1) 1100)))
	      (snd-display "mark after zeros: ~D (1100)? " (mark-sample m1))))
	(set! (cursor obind) 0)
	(key (char->integer #\j) 4 obind)
	(if (and with-gui (not (= (cursor obind) 1100))) (snd-display "c-j to ~A" (cursor obind)))
	(add-mark 100)
	(set! (cursor obind) 0)
	(key (char->integer #\u) 4 obind)
	(key (char->integer #\2) 0 obind)
	(key (char->integer #\j) 4 obind)
	(if (and with-gui (not (= (cursor obind) 1100))) (snd-display "c-u 2 c-j ~A" (cursor obind)))
	(key (char->integer #\-) 4 obind)
	(key (char->integer #\j) 4 obind)
	(if (and with-gui (not (= (cursor obind) 100))) (snd-display "c-- c-j ~A" (cursor obind)))
	(revert-sound obind)
	(let ((frs (framples obind)))
	  (make-region 0 999 obind 0)
	  (if (not (selection?)) (snd-display "make-region but no selection? ~A" (selection?)))
	  (delete-selection)
	  (if (not (= (framples obind) (- frs 1000)))
	      (snd-display "delete-selection: ~A?" (framples obind)))
	  (let ((val (sample 0 obind 0)))
	    (undo)
	    (if (fneq (sample 1000) val)
		(snd-display "delete-selection val: ~A ~A" val (sample 1000)))
	    (insert-selection)
	    (let ((var (catch #t (lambda () (insert-selection 0 obind 123)) (lambda args args))))
	      (if (not (eq? (car var) 'no-such-channel))
		  (snd-display "insert-selection bad chan: ~A" var)))
	    (let ((var (catch #t (lambda () (mix-selection 0 obind 123)) (lambda args args))))
	      (if (not (eq? (car var) 'no-such-channel))
		  (snd-display "mix-selection bad chan: ~A" var)))
	    (if (not (= (framples obind) (+ frs 1000)))
		(snd-display "insert-selection: ~A?" (framples obind)))
	    (if (fneq (sample 2000) val)
		(snd-display "insert-selection val: ~A ~A" val (sample 2000))))
	  (let ((val (* 2 (sample 900))))
	    (mix-selection)
	    (if (fneq (sample 900) val)
		(snd-display "mix-selection val: ~A ~A" val (sample 900)))
	    (if (not (= (framples obind) (+ frs 1000)))
		(snd-display "mix-selection len: ~A?" (framples obind)))))
	(close-sound obind))
      
      (let ((ind (open-sound "2.snd")))
	(let ((apply-to-sound 0)
	      (apply-to-selection 2)
	      (len (framples ind)))
	  (set! (sync ind) 1)
	  (set! (speed-control ind) .5)
	  (apply-controls ind apply-to-sound) ; temp 1
	  (if (> (abs (- (framples) (* 2 len))) 256)
	      (snd-display "apply srate .5: ~A ~A" (framples) (* 2 len)))
	  (make-selection 0 (framples))
	  (set! (speed-control ind) .5)
	  (apply-controls ind apply-to-selection) ; temp 2
	  (if (> (abs (- (framples) (* 4 len))) 256)
	      (snd-display "apply srate .5 to selection: ~A ~A" (framples) (* 4 len)))
	  (env-sound '(0 0 1 1) 0 (framples) 32.0) ; temp 3
	  (let ((reg (select-all))) ; make multi-channel region
	    (insert-region reg 0) ; temp 4
	    (insert-selection 0))  ; temp 5
	  (revert-sound ind)
	  (set! (speed-control) .5)
	  (set! (sync ind) 0)
	  (set! (selected-channel ind) 1)
	  (apply-controls ind 1)  ; 1=apply-to-channel
	  (if (> (abs (- (framples ind 1) (* 2 len))) 256)
	      (snd-display "apply srate .5 to chan 1: ~A ~A" (framples ind 1) (* 2 len)))
	  (if (not (= (framples ind 0) len))
	      (snd-display "apply srate .5 but chan 0: ~A ~A" (framples ind 0) len))
	  (set! (speed-control ind) .5)
	  (apply-controls ind apply-to-sound 1000)
	  (make-selection 2000 4000)
	  (set! (speed-control ind) .5)
	  (apply-controls ind apply-to-selection)
	  (set! (selected-channel ind) #f)
	  (if (selected-channel ind) (snd-display "selected-channel #f: ~A" (selected-channel ind)))
	  (close-sound ind))
	
	(let ((ind1 (open-sound "oboe.snd"))
	      (ind2 (open-sound "2.snd")))
	  (let ((mx1 (maxamp ind1 0))
		(mx20 (maxamp ind2 0))
		(mx21 (maxamp ind2 1)))
	    (select-sound ind1)
	    (scale-sound-by 2.0)
	    (let ((nmx (maxamp ind1 0)))
	      (if (fneq (* 2 mx1) nmx) (snd-display "scale-sound-by 2.0: ~A ~A?" mx1 nmx))
	      (if (not (equal? (edit-fragment 1 ind1 0) '("scale-channel 2.000 0 #f" "scale" 0 50828)))
		  (snd-display "scale-sound-by: ~A?" (edit-fragment 1 ind1 0))))
	    (scale-sound-to 0.5)
	    (let ((nmx (maxamp ind1 0)))
	      (if (fneq nmx 0.5) (snd-display "scale-sound-to 0.5: ~A?" nmx))
	      (if (not (equal? (edit-fragment 2 ind1 0) '("scale-channel 1.698 0 #f" "scale" 0 50828)))
		  (snd-display "scale-sound-to: ~A?" (edit-fragment 2 ind1 0))))
	    (scale-sound-by 0.0 0 1000 ind1 0)
	    (let ((nmx (maxamp ind1 0)))
	      (if (fneq 0.5 nmx) (snd-display "scale-sound-by 0.0: ~A ~A?" mx1 nmx))
	      (if (not (equal? (edit-fragment 3 ind1 0) '("scale-channel 0.000 0 1000" "scale" 0 1000)))
		  (snd-display "scale-sound-by 0.0: ~A?" (edit-fragment 3 ind1 0))))
	    (let ((pk (float-vector-peak (channel->float-vector 0 1000 ind1 0))))
	      (if (fneq pk 0.0) (snd-display "scale-sound-by 0.0 [0:1000]: ~A?" pk)))
	    (revert-sound ind1)
	    (let ((oldv (channel->float-vector 12000 10 ind1 0)))
	      (scale-sound-by 2.0 12000 10 ind1 0)
	      (let ((newv (channel->float-vector 12000 10 ind1 0)))
		(do ((i 0 (+ i 1)))
		    ((= i 10))
		  (if (fneq (* 2.0 (oldv i)) (newv i))
		      (snd-display "scale ~D: ~A ~A?" i (oldv i) (newv i)))))
	      (if (not (equal? (edit-fragment 1 ind1 0) '("scale-channel 2.000 12000 10" "scale" 12000 10)))
		  (snd-display "scale-sound-by 2.0 [12000:10]: ~A?" (edit-fragment 1 ind1 0))))
	    (revert-sound ind1)
	    (select-sound ind2)
	    (scale-sound-by 2.0)
	    (let ((nmx (maxamp ind2 0)))
	      (if (fneq (* 2 mx20) nmx) (snd-display "2:0 scale-sound-by 2.0: ~A ~A?" mx20 nmx)))
	    (let ((nmx (maxamp ind2 1)))
	      (if (fneq (* 2 mx21) nmx) (snd-display "2:1 scale-sound-by 2.0: ~A ~A?" mx21 nmx)))
	    (scale-sound-to 0.5)
	    (let ((nmx (max (maxamp ind2 0) (maxamp ind2 1))))
	      (if (fneq nmx 0.5) (snd-display "2 scale-sound-to 0.5: ~A (~A)?" nmx (maxamp ind2))))
	    (scale-sound-by 0.0 0 1000 ind2 1)
	    (if (not (equal? (edit-fragment 3 ind2 1) '("scale-channel 0.000 0 1000" "scale" 0 1000)))
		(snd-display "2:1 scale-sound-by 0.0: ~A?" (edit-fragment 3 ind2 1)))
	    (let ((pk (float-vector-peak (channel->float-vector 0 1000 ind2 1))))
	      (if (fneq pk 0.0) (snd-display "2:1 scale-sound-by 0.0 [0:1000]: ~A?" pk)))
	    (revert-sound ind2)
	    (let ((oldv (channel->float-vector 12000 10 ind2 0)))
	      (scale-sound-by 2.0 12000 10 ind2 0)
	      (let ((newv (channel->float-vector 12000 10 ind2 0)))
		(do ((i 0 (+ i 1)))
		    ((= i 10))
		  (if (fneq (* 2.0 (oldv i)) (newv i))
		      (snd-display "2 scale ~D: ~A ~A?" i (oldv i) (newv i))))))
	    (revert-sound ind2)
	    (set! (sync ind2) 3)
	    (set! (sync ind1) 3)
	    (scale-sound-by 2.0)
	    (let ((nmx (maxamp ind1 0)))
	      (if (fneq mx1 nmx) (snd-display "sync scale-sound-by 2.0: ~A ~A?" mx1 nmx)))
	    (let ((nmx (maxamp ind2 0)))
	      (if (fneq (* 2 mx20) nmx) (snd-display "2:0 sync scale-sound-by 2.0: ~A ~A?" mx20 nmx)))
	    (let ((nmx (maxamp ind2 1)))
	      (if (fneq (* 2 mx21) nmx) (snd-display "2:1 sync scale-sound-by 2.0: ~A ~A?" mx21 nmx)))
	    (scale-sound-to 1.0 20000 40000 ind2 1)
	    (let ((nmx (maxamp ind1 0)))
	      (if (fneq mx1 nmx) (snd-display "sync scale-sound-to 1.0: ~A ~A?" mx1 nmx)))
	    (let ((nmx (maxamp ind2 0)))
	      (if (fneq (* 2 mx20) nmx) (snd-display "2:0 sync scale-sound-to 1.0: ~A ~A?" mx20 nmx)))
	    (let ((nmx (maxamp ind2 1)))
	      (if (fneq nmx 1.0) (snd-display "2:1 sync scale-sound-to 1.0: ~A?" nmx)))
	    
	    (close-sound ind1)
	    (close-sound ind2))))
      
      (let ((ind (open-sound "now.snd")))
	(set! (amp-control ind) .5)
	(if (ffneq (amp-control ind) .5) (snd-display "amp-control (.5): ~A?" (amp-control ind)))
	(set! (amp-control ind 0) .25)
	(if (ffneq (amp-control ind) .5) (snd-display "amp-control after local set (.5): ~A?" (amp-control ind)))
	(if (ffneq (amp-control ind 0) .25) (snd-display "amp-control 0 (.25): ~A?" (amp-control ind 0)))
	(set! (amp-control ind) 1.0)
	(if (ffneq (amp-control ind) 1.0) (snd-display "amp-control (1.0): ~A?" (amp-control ind)))
	(if (ffneq (amp-control ind 0) .25) (snd-display "amp-control 0 after set (.25): ~A?" (amp-control ind 0)))
	(set! (transform-graph? ind 0) #t)
	(set! (transform-graph-type ind 0) graph-as-sonogram)
	(update-transform-graph ind 0)
	(when with-motif
	  (let ((val (transform-framples ind 0)))
	    (if (or (not (pair? val))
		    (fneq (car val) 1.0)
		    (not (= (caddr val) 256)))
		(snd-display "transform-framples: ~A (~A)" val (transform-size ind 0)))))
	(close-sound ind))
      
      (let ((ind (open-sound "4.aiff")))
	(if (ffneq (amp-control ind) 1.0) (snd-display "amp-control upon open (1.0): ~A?" (amp-control ind)))
	(if (ffneq (amp-control ind 2) 1.0) (snd-display "amp-control 2 upon open (1.0): ~A?" (amp-control ind 2)))
	(set! (amp-control ind) .5)
	(if (ffneq (amp-control ind 2) .5) (snd-display "amp-control 2 after global set (.5): ~A?" (amp-control ind 2)))
	(set! (amp-control ind 2) .25)
	(if (ffneq (amp-control ind 2) .25) (snd-display "amp-control 2 (.25): ~A?" (amp-control ind 2)))
	(if (ffneq (amp-control ind 1) .5) (snd-display "amp-control 1 after local set (.5): ~A?" (amp-control ind 1)))
	(let ((after-ran #f))
	  (set! (hook-functions after-apply-controls-hook) ())
	  (hook-push after-apply-controls-hook (lambda (hook) (set! after-ran (hook 'snd))))
	  (apply-controls ind)
	  (if (not (equal? ind after-ran)) (snd-display "after-apply-controls-hook: ~A?" after-ran))
	  (set! (hook-functions after-apply-controls-hook) ()))
	(revert-sound ind)
	(set! (sync ind) 1)
	(scale-to #r(.1 .2))
	(let ((mx (maxamp ind #t)))
	  (if (or (fneq (mx 0) .1)
		  (fneq (mx 1) .2)
		  (fneq (mx 2) .2)
		  (fneq (mx 3) .2))
	      (snd-display "scale to with vector: ~A" mx)))
	(set! (filter-control-envelope ind) '(0 0 1 1))
	(if (not (feql '(0.0 0.0 1.0 1.0) (filter-control-envelope ind))) 
	    (snd-display "set filter-control-envelope: ~A?" (filter-control-envelope ind)))
	(set! (filter-control-order ind) 20)
	(if (not (mus-arrays-equal? (filter-control-coeffs ind)
				    #r(-0.007 0.010 -0.025 0.029 -0.050 0.055 -0.096 0.109 -0.268 0.241 
						  0.241 -0.268 0.109 -0.096 0.055 -0.050 0.029 -0.025 0.010 -0.007)))
	    (snd-display "highpass coeffs: ~A" (filter-control-coeffs ind)))
	(set! (filter-control-envelope ind) '(0 1 1 0))
	(if (not (mus-arrays-equal? (filter-control-coeffs ind)
				    #r(0.003 0.002 0.004 0.002 0.007 0.003 0.014 0.012 0.059 0.394 
						  0.394 0.059 0.012 0.014 0.003 0.007 0.002 0.004 0.002 0.003)))
	    (snd-display "lowpass coeffs: ~A" (filter-control-coeffs ind)))
	(close-sound ind))
      
      (let* ((obind (open-sound "4.aiff"))
	     (amps (maxamp obind #t)))
	(let ((times (maxamp-position obind #t)))
	  (if (not (equal? times '(810071 810071 810071 810071)))
	      (snd-display "4.aiff times: ~A" times)))
	(set! (window-width) (max (window-width) 600))
	(set! (window-height) (max (window-height) 600))
	(set! (x-bounds obind 0) (list 0.0 0.1))
	(set! (show-axes obind 0) show-x-axis)
	(update-time-graph)
	(set! (amp-control obind) 0.1)
	(select-channel 2)
	(if (eq? (without-errors (apply-controls obind 1)) 'no-such-sound) (snd-display "apply-controls can't find 4.aiff?"))
	(let ((newamps (maxamp obind #t)))
	  (if (or (fneq (car amps) (car newamps))
		  (fneq (cadr amps) (cadr newamps))
		  (> (abs (- (* 0.1 (caddr amps)) (caddr newamps))) .05)
		  (fneq (cadddr amps) (cadddr newamps)))
	      (snd-display "apply amps:~%  ~A ->~%  ~A?" amps newamps))
	  (undo 1 obind 2)
	  (set! (amp-control obind) 0.1)
	  (make-region 0 (framples obind) obind 1)
	  (without-errors (apply-controls obind 2))
	  (set! newamps (maxamp obind #t))
	  (if (or (fneq (car amps) (car newamps))
		  (> (abs (- (* 0.1 (cadr amps)) (cadr newamps))) .05)
		  (fneq (caddr amps) (caddr newamps))
		  (fneq (cadddr amps) (cadddr newamps)))
	      (snd-display "apply selection amp:~%  ~A ->~%  ~A?" amps newamps))
	  (when with-gui
	    (let ((axinfo (axis-info obind 0 time-graph)))
	      (let ((losamp (car axinfo))
		    (hisamp (cadr axinfo))
		    (x0 (axinfo 2))
		    (y0 (axinfo 3))
		    (x1 (axinfo 4))
		    (y1 (axinfo 5)))
		(let ((xpos (+ x0 (* .5 (- x1 x0))))
		      (ypos (+ y0 (* .75 (- y1 y0))))
		      (cp-x (lambda (x)
			      (floor (+ (axinfo 10) 
					(* (- x x0) (/ (- (axinfo 12) (axinfo 10)) 
						       (- x1 x0)))))))
		      (cp-y (lambda (y) 
			      (floor (+ (axinfo 13) 
					(* (- y1 y) (/ (- (axinfo 11) (axinfo 13)) 
						       (- y1 y0)))))))
		      (our-x->position 
		       (lambda (ind x) 
			 (let ((ax (axis-info ind 0)))
			   (list
			    (+ (ax 10) 
			       (/ (* (- x (ax 2))
				     (- (ax 12) (ax 10)))
				  (- (ax 4) (ax 2))))
			    (x->position x ind))))))
		  (select-channel 0)
		  (set! (cursor obind) 100)
		  (let ((xy (car (cursor-position obind))))
		    (if (fneq (position->x xy) (/ (cursor obind) (srate obind)))
			(snd-display "cursor-position: ~A ~A ~A?" xy (position->x xy) (/ (cursor obind) (srate obind)))))
		  (if (fneq (position->x (x->position xpos)) xpos)
		      (snd-display "x<->position: ~A ~A?" (position->x (x->position xpos)) xpos))
		  (if (> (abs (- (position->y (y->position ypos)) ypos)) .5)
		      (snd-display "y<->position: ~A ~A?" (position->y (y->position ypos)) ypos))
		  (if (not (= losamp (left-sample obind 0)))
		      (snd-display "axis-info[0 losamp]: ~A ~A?" losamp (left-sample obind 0)))
		  (if (not (= hisamp (right-sample obind 0)))
		      (snd-display "axis-info[1 hisamp]: ~A ~A?" hisamp (right-sample obind 0)))
		  (if (fneq (axinfo 6) 0.0)
		      (snd-display "axis-info[6 xmin]: ~A?" (axinfo 6)))
		  (if (fneq (axinfo 7) -1.0)
		      (snd-display "axis-info[7 ymin]: ~A?" (axinfo 7)))
		  (if (fneq (axinfo 9) 1.0)
		      (snd-display "axis-info[9 ymax]: ~A?" (axinfo 9)))
		  (if (> (abs (apply - (our-x->position obind x0))) 1) 
		      (snd-display "x0->position: ~A?" (our-x->position obind x0)))
		  (if (> (abs (apply - (our-x->position obind x1))) 1) 
		      (snd-display "x1->position: ~A?" (our-x->position obind x1)))
		  (if (> (abs (apply - (our-x->position obind (* 0.5 (+ x0 x1))))) 1)
		      (snd-display "xmid->position: ~A?" (our-x->position obind (* 0.5 (+ x0 x1)))))
		  (unless full-test
		    (if (> (abs (- (x->position xpos) (cp-x xpos))) 1)
			(snd-display "cp-x .5: ~A ~A?" (x->position xpos) (cp-x xpos)))
		    (if (> (abs (- (y->position ypos) (cp-y ypos))) 1)
			(snd-display "cp-y .75: ~A ~A?" (y->position ypos) (cp-y ypos)))
		    (do ((xrange (- x1 x0))
			 (yrange (- y1 y0))
			 (i 0 (+ i 1)))
			((= i 10))
		      (let ((xpos (+ x0 (random xrange)))
			    (ypos (+ y0 (random yrange))))
			(if (> (abs (- (x->position xpos) (cp-x xpos))) 1)
			    (snd-display "cp-x[~A] ~A: ~A ~A?" i xpos (x->position xpos) (cp-x xpos)))
			(if (> (abs (- (y->position ypos) (cp-y ypos))) 1)
			    (snd-display "cp-y[~A] ~A: ~A ~A?" i ypos (y->position ypos) (cp-y ypos)))
			(if (fneq (position->x (cp-x xpos)) xpos)
			    (snd-display "x->position cp-x ~A ~A" xpos (position->x (cp-x xpos))))
			(if (fffneq (position->y (cp-y ypos)) ypos)
			    (snd-display "y->position cp-y ~A ~A" ypos (position->y (cp-y ypos)))))))
		  (set! (left-sample obind 0) 1234)
		  (let ((axob (axis-info obind 0)))
		    (if (not (= 1234 (car axob)))
			(snd-display "axis-info[0 losamp at 1234]: ~A ~A?" (car axob) (left-sample obind 0)))
		    (set! axinfo axob))
		  (set! x0 (axinfo 2))
		  (set! x1 (axinfo 4))
		  (if (> (abs (apply - (our-x->position obind x0))) 1) 
		      (snd-display "x0a->position: ~A?" (our-x->position obind x0)))
		  (if (> (abs (apply - (our-x->position obind x1))) 1) 
		      (snd-display "x1a->position: ~A?" (our-x->position obind x1)))
		  (if (> (abs (apply - (our-x->position obind (* 0.5 (+ x0 x1))))) 1)
		      (snd-display "xmida->position: ~A?" (our-x->position obind (* 0.5 (+ x0 x1)))))
		  (set! (y-bounds obind 0) (list -2.0 3.0))
		  (let ((axob (axis-info obind 0)))
		    (if (fneq (axob 7) -2.0)
			(snd-display "axis-info[7 ymin -2.0]: ~A?" (axob 7)))
		    (if (fneq (axob 9) 3.0)
			(snd-display "axis-info[9 ymax 3.0]: ~A?" (axob 9)))))))
	    (close-sound obind))))
      
      (let* ((ind1 (open-sound "oboe.snd"))
	     (test-orig (lambda (func0 func1 func-name ind1)
			  (let ((v0 (channel->float-vector 12000 10 ind1 0)))
			    (func0)
			    (let ((v1 (channel->float-vector 12000 10 ind1 0)))
			      (if (mus-arrays-equal?1 v0 v1)
				  (snd-display "~A (orig: 0) no change! ~A ~A" func-name v0 v1))
			      (func1)
			      (let ((v2 (channel->float-vector 12000 10 ind1 0)))
				(if (not (mus-arrays-equal?1 v0 v2))
				    (snd-display "~A (orig: 1) ~A ~A" func-name v0 v2))))
			    (revert-sound ind1)))))
  
	(test-orig (lambda () (src-sound 2.0 1.0 ind1)) (lambda () (src-sound 0.5 1.0 ind1)) 'src-sound ind1)
	(test-orig (lambda () (src-channel 2.0)) (lambda () (src-channel 0.5)) 'src-channel ind1)
	(test-orig (lambda () (scale-by 2.0 ind1)) (lambda () (scale-by 0.5 ind1)) 'scale-by ind1)
	(test-orig (lambda () (scale-channel 2.0)) (lambda () (scale-channel 0.5)) 'scale-channel ind1)
	(test-orig (lambda () (reverse-sound ind1)) (lambda () (reverse-sound ind1)) 'reverse-sound ind1)
	(test-orig reverse-channel reverse-channel 'reverse-channel ind1)
	(test-orig (lambda () (env-sound '(0 1.0 1 2.0))) (lambda () (env-sound '(0 1.0 1 0.5))) 'env-sound ind1)
	(test-orig (lambda () (env-sound '(0 1.0 1 2.0 2 1.0))) (lambda () (env-sound '(0 1.0 1 0.5 2 1.0))) 'env-sound ind1)
	(test-orig (lambda () (env-channel (make-env :envelope '(0 1.0 1 2.0) :length (framples))))
		   (lambda () (env-channel (make-env :envelope '((0 1.0) (1 0.5)) :length (framples)))) 'env-channel ind1)
	(test-orig (lambda () (env-channel '(0 1.0 1 2.0)))
		   (lambda () (env-channel '(0 1.0 1 0.5))) 'env-channel ind1)
	(test-orig (lambda () (env-channel (make-env :envelope '(0 2 1 2 2 0.5 3 0.5) :base 0 :length (framples))))
		   (lambda () (env-channel (make-env :envelope '(0 0.5 1 0.5 2 2 3 2) :base 0 :length (framples)))) 'env-channel ind1)
	(test-orig (lambda () (map-channel (lambda (n) (* n 2.0)))) (lambda () (map-channel (lambda (n) (* n 0.5)))) 'map-channel ind1)
	(test-orig (lambda () (map-channel (lambda (n) (* n 2.0)) 1234)) (lambda () (map-channel (lambda (n) (* n 0.5)) 1234)) 'map-channel ind1)
	(test-orig (lambda () (map-channel (lambda (n) (* n 2.0)) 12005 10)) (lambda () (map-channel (lambda (n) (* n 0.5)) 12005 10)) 'map-channel ind1)
	(test-orig (lambda () 
		     (map-channel 
		      (let ((vect (make-float-vector 2))) 
			(lambda (y) 
			  (float-vector-set! vect 0 (float-vector-set! vect 1 (* y 2)))
			  vect))))
		   (lambda () 
		     (map-channel
		      (let ((outp #f))
			(lambda (y) 
			  (and (set! outp (not outp)) (* y 0.5))))))
		   'map-channel ind1)
	(test-orig (lambda () (map-channel (lambda (n) (* n 2.0)))) (lambda () (map-channel (lambda (n) (* n 0.5)))) 'map-channel ind1)
	(test-orig (lambda () (pad-channel 1000 2000 ind1)) (lambda () (delete-samples 1000 2000 ind1)) 'pad-channel ind1)
	(test-orig (lambda () (clm-channel (make-one-zero :a0 2.0 :a1 0.0)))
		   (lambda () (clm-channel (make-one-zero :a0 0.5 :a1 0.0))) 'clm-channel ind1)
	(test-orig (lambda () (clm-channel (make-one-pole :a0 2.0 :b1 0.0)))
		   (lambda () (clm-channel (make-one-pole :a0 0.5 :b1 0.0))) 'clm-channel ind1)
	(test-orig (lambda () (filter-sound (make-one-zero :a0 2.0 :a1 0.0) 2 ind1 0)) 
		   (lambda () (filter-sound (make-one-zero :a0 0.5 :a1 0.0) 2 ind1 0)) 'filter-sound ind1)
	
	(let ((var (catch #t (lambda () (src-sound '(0 0 1 1))) (lambda args args))))
	  (if (not (eq? (car var) 'out-of-range))
	      (snd-display "src-sound env at 0: ~A" var)))
	(let ((var (catch #t (lambda () (src-sound '(0 1 1 -1))) (lambda args args))))
	  (if (not (eq? (car var) 'out-of-range))
	      (snd-display "src-sound env through 0: ~A" var)))
	
	(scale-to 1.0 ind1)
	(let ((v1 (channel->float-vector 12000 10 ind1 0)))
	  (let ((v0 (make-float-vector 10)))
	    (set! (v0 0) 1.0)
	    (array->file "fmv3.snd" v0 10 22050 1))
	  (copy-file "oboe.snd" "fmv4.snd")
	  (convolve-with "fmv3.snd" 1.0 ind1)
	  (convolve-files "fmv4.snd" "fmv3.snd" 1.0 "fmv5.snd")
	  (let ((v2 (channel->float-vector 12000 10 ind1 0)))
	    (if (not (mus-arrays-equal?1 v1 v2))
		(snd-display "~A (orig: 0) ~A ~A" 'convolve-with v1 v2))
	    (file->array "fmv5.snd" 0 12000 10 v2)
	    (if (not (mus-arrays-equal?1 v1 v2))
		(snd-display "convolve-files: (orig: 0) ~A ~A" v1 v2)))
	  (delete-file "fmv3.snd")
	  (delete-file "fmv5.snd"))
	(convolve-files "2.snd" "oboe.snd" 0.5 "fmv5.snd")
	(if (or (fneq (cadr (mus-sound-maxamp "fmv5.snd")) 0.25)
		(fneq (cadddr (mus-sound-maxamp "fmv5.snd")) 0.5))
	    (snd-display "convolve-files stereo: ~A" (mus-sound-maxamp "fmv5.snd")))
	(delete-file "fmv5.snd")
	(scale-to .25 ind1)
	(set! (y-bounds ind1) ())
	(if (and with-gui (not (equal? (y-bounds ind1) '(-.25 .25))))
	    (snd-display "y-bounds (): ~A?" (y-bounds ind1)))
	(revert-sound ind1)
	
	(scale-to 1.0 ind1)
	(let ((v1 (channel->float-vector 12000 10 ind1 0)))
	  (let ((v0 (make-float-vector 10)))
	    (set! (v0 5) 1.0)
	    (array->file "fmv3.snd" v0 10 22050 1))
	  (convolve-with "fmv3.snd" 1.0 ind1)
	  (convolve-files "fmv4.snd" "fmv3.snd" 1.0 "fmv5.snd")
	  (let ((v2 (channel->float-vector 12005 10 ind1 0)))
	    (if (not (mus-arrays-equal?1 v1 v2))
		(snd-display "~A (orig: 2) ~A ~A" 'convolve-with v1 v2))
	    (file->array "fmv5.snd" 0 12005 10 v2)
	    (if (not (mus-arrays-equal?1 v1 v2))
		(snd-display "convolve-files: (orig: 2) ~A ~A" v1 v2)))
	  (delete-file "fmv3.snd")
	  (delete-file "fmv4.snd")
	  (delete-file "fmv5.snd"))
	
	(revert-sound ind1)
	(let-temporarily ((*selection-creates-region* #f))
	  (let ((old-regions (regions)))
	    (select-all ind1)
	    (if (not (equal? old-regions (regions)))
		(snd-display "selection-create-region: ~A -> ~A?" old-regions (regions)))))
	(convolve-selection-with "pistol.snd" (maxamp))
	(let ((data (channel->float-vector 12000 10 ind1 0)))
	  (convolve-with "pistol.snd" (maxamp ind1 0 0) ind1 0 0)
	  (let ((new-data (channel->float-vector 12000 10 ind1 0)))
	    (if (not (mus-arrays-equal?1 data new-data))
		(snd-display "convolve-selection-with: ~A ~A?" data new-data))))
	(revert-sound ind1)
	(make-selection 1000 2000 ind1)
	(let ((ma (maxamp ind1)))
	  (convolve-selection-with "pistol.snd" ma)
	  (if (fneq (maxamp ind1) ma) (snd-display "convolve-selection-with 1000: ~A ~A?" ma (maxamp ind1))))
	(make-selection 1000 2000 ind1)
	(let ((id (make-region)))
	  (if (not (region? id))
	      (snd-display "make-region argless: ~A" id))
	  (if (not (= (region-framples id 0) (selection-framples)))
	      (snd-display "region/selection-framples: ~A ~A (~A)?" (region-framples id 0) (selection-framples) (region-framples id)))
	  (if (fneq (region-sample id 0) (sample 1000 ind1))
	      (snd-display "region-sample from make-region: ~A ~A?" (region-sample id 0) (sample 1000 ind1))))
	(close-sound ind1))
      (let* ((ind (open-sound "2.snd"))
	     (reg (make-region 0 100 ind #t)))
	(if (not (equal? (region-home reg) '("2.snd" 0 101))) 
	    (snd-display "make + region-home: ~A" (region-home reg)))
	(if (not (= (region-chans reg) 2))
	    (snd-display "make-region chan #t: ~A" (region-chans reg)))
	(close-sound ind))
      
      (let ((ind1 (open-sound "2.snd")))
	(let ((v0 (channel->float-vector 12000 10 ind1 0))
	      (v1 (channel->float-vector 12000 10 ind1 1)))
	  (swap-channels ind1)
	  (let ((v2 (channel->float-vector 12000 10 ind1 0))
		(v3 (channel->float-vector 12000 10 ind1 1)))
	    (if (or (mus-arrays-equal? v0 v2)
		    (mus-arrays-equal? v1 v3))
		(snd-display "swap-channels 0: no change! ~A ~A ~A ~A" v0 v2 v1 v3)))
	  (swap-channels ind1)
	  (let ((v2 (channel->float-vector 12000 10 ind1 0))
		(v3 (channel->float-vector 12000 10 ind1 1)))
	    (if (not (and (mus-arrays-equal? v0 v2)
			  (mus-arrays-equal? v1 v3)))
		(snd-display "swap-channels 1: ~A ~A ~A ~A" v0 v2 v1 v3))))
	;; as long as we're here...
	(set! (sync ind1) 0)
	(set! (cursor ind1 0) 100)
	(set! (cursor ind1 1) 200)
	(if (not (and (= (cursor ind1 0) 100)
		      (= (cursor ind1 1) 200)))
	    (snd-display "cursor: ~A ~A?" (cursor ind1 0) (cursor ind1 1)))
	(set! (sync ind1) 1)
	(scale-by '(.5 .25) ind1)
	(scale-by #r(2.0 4.0) ind1)
	(revert-sound ind1)
	(let ((amps (maxamp ind1 #t)))
	  (swap-channels ind1 0 ind1)
	  (let ((newamps (maxamp ind1 #t)))
	    (if (or (fneq (car amps) (cadr newamps))
		    (fneq (cadr amps) (car newamps)))
		(snd-display "swap-channels with cp def: ~A ~A" amps newamps)))
	  (swap-channels ind1 1)
	  (let ((newamps (maxamp ind1 #t)))
	    (if (or (fneq (car amps) (car newamps))
		    (fneq (cadr amps) (cadr newamps)))
		(snd-display "swap-channels with cp def 0: ~A ~A" amps newamps))))
	(close-sound ind1))
      
      (let ((ind1 (open-sound "oboe.snd"))
	    (ind2 (open-sound "2.snd")))
	(let ((ups1 (count-matches (lambda (n) (> n .1)) 0 ind1 0))
	      (ups2 (let ((count 0)
			  (len (framples ind1))
			  (reader (make-sampler 0 ind1)))
		      (do ((i 0 (+ i 1)))
			  ((= i len) count)
			(if (> (next-sample reader) .1)
			    (set! count (+ count 1)))))))
	  (if (not (= ups1 ups2))
	      (snd-display "scan-chan: ~A ~A?" ups1 ups2))
	  (set! ups1 (count-matches (lambda (n) (> n .03)) 0 ind2 0))
	  (set! ups2 (count-matches (lambda (n) (> n .03)) 0 ind2 1))
	  (let ((ups3 (let ((count 0)
			    (len (framples ind2))
			    (reader (make-sampler 0 ind2 0)))
			(do ((i 0 (+ i 1)))
			    ((= i len) count)
			  (if (> (next-sample reader) .03)
			      (set! count (+ count 1))))))
		(ups4 (let ((count 0)
			    (len (framples ind2))
			    (reader (make-sampler 0 ind2 1)))
			(do ((i 0 (+ i 1)))
			    ((= i len) count)
			  (if (> (next-sample reader) .03)
			      (set! count (+ count 1)))))))
	    (if (not (= ups1 ups3))
		(snd-display "2[0] scan-chan: ~A ~A?" ups1 ups3))
	    (if (not (= ups2 ups4))
		(snd-display "2[1] scan-chan: ~A ~A?" ups2 ups4))))
	(close-sound ind1)
	(close-sound ind2))
      
      (let ((ind1 (open-sound "oboe.snd")))
	(let ((len (framples ind1)))
	  (let ((ctr #f))
	    (map-channel (lambda (n)
			   (and (set! ctr (not ctr))
				(* n 2.0))))
	    (if (> (framples ind1) (+ (/ len 2) 1))
		(snd-display "map-channel cut: ~A ~A?" len (framples ind1)))
	    (revert-sound ind1)
	    (set! ctr 0)
	    (map-channel (lambda (n)
			   (or (> (set! ctr (+ ctr 1)) 3) n)))
	    (if (> ctr 4)
		(snd-display "map-channel no-edit count: ~A?" ctr)))
	  (revert-sound ind1)
	  (let ((v1 (make-float-vector 2)))
	    (map-channel (lambda (n)
			   (set! (v1 0) n)
			   (set! (v1 1) (* n 3))
			   v1)))
	  (if (> (abs (- (framples ind1) (* len 2))) 3)
	      (snd-display "map-channel double: ~A ~A?" len (framples ind1))))
	(revert-sound ind1)
	(let ((otime (maxamp-position ind1)))
	  (set! (sample 1234) .9)
	  (let ((ntime (maxamp-position ind1))
		(nval (maxamp ind1))
		(npos (edit-position ind1 0)))
	    (if (not (= ntime 1234)) (snd-display "maxamp-position 1234: ~A" ntime))
	    (let ((ootime (maxamp-position ind1 0 0)))
	      (if (not (= ootime otime)) (snd-display "maxamp-position edpos 0: ~A ~A" otime ootime)))
	    (let ((nntime (maxamp-position ind1 0 npos)))
	      (if (not (= nntime ntime)) (snd-display "maxamp-position edpos ~D: ~A ~A" npos ntime nntime)))
	    (if (fneq nval .9) (snd-display "maxamp .9: ~A" nval)))
	  (set! (sample 1234) 0.0)
	  (env-channel '(0 0 1 1))
	  (if (not (= (maxamp-position) 35062)) (snd-display "env-channel maxamp-position: ~A" (maxamp-position)))
	  (let ((ootime (maxamp-position ind1 0 0)))
	    (if (not (= ootime otime)) (snd-display "maxamp-position edpos 0(1): ~A ~A" otime ootime)))
	  (let ((nntime (maxamp-position ind1 0 1)))
	    (if (not (= nntime 1234)) (snd-display "maxamp-position edpos 1(1): ~A ~A" 1234 nntime)))
	  (let ((nntime (maxamp-position ind1 0 current-edit-position)))
	    (if (not (= nntime 35062)) (snd-display "maxamp-position edpos current: ~A ~A" 35062 nntime))))
	(revert-sound ind1)
	(make-selection 24000 25000)
	(if (not (= (selection-maxamp-position) 971))
	    (snd-display "selection maxamp position: ~A" (selection-maxamp-position)))
	(let ((regp (region-maxamp-position (make-region 24000 25000))))
	  (if (not (= regp 971))
	      (snd-display "region maxamp position: ~A" regp)))
	(close-sound ind1))
      (let ((ind1 (open-sound "oboe.snd"))
	    (test-edpos (lambda (test-func func-name change-thunk ind1)
			  (let ((fr1 (test-func ind1 0))
				(fr2 (test-func ind1 0 0))
				(fr3 (test-func ind1 0 current-edit-position)))
			    (if (not (= fr1 fr2 fr3))
				(snd-display "initial ~A: ~A ~A ~A?" func-name fr1 fr2 fr3))
			    (change-thunk)
			    (let ((fr5 (test-func ind1 0))
				  (fr6 (test-func ind1 0 1))
				  (fr7 (test-func ind1 0 current-edit-position)))
			      (if (not (= fr5 fr6 fr7))
				  (snd-display "~A (edpos 1): ~A ~A ~A?" func-name fr5 fr6 fr7))))
			  (revert-sound ind1))))
	(test-edpos maxamp 'maxamp (lambda () (scale-by 2.0 ind1 0)) ind1)
	(test-edpos framples 'framples (lambda () (src-sound 2.0 1.0 ind1 0)) ind1)
	(let ((ef (lambda* ((snd 0) (chn 0) (edpos current-edit-position))
		    (count-matches (lambda (n1) (> n1 .1)) 0 snd chn edpos))))
	  (test-edpos ef 'count-matches (lambda () (scale-by 2.0 ind1 0)) ind1))
	(let ((ef (lambda* ((snd 0) (chn 0) (edpos current-edit-position))
		    (scan-channel (lambda (n2) (> n2 .1)) 0 #f snd chn edpos))))
	  (test-edpos ef 'find (lambda () (delete-samples 0 100 ind1 0)) ind1))
	(let ((ef (lambda* ((snd 0) (chn 0) (edpos current-edit-position)) 
		    (let ((p (make-one-pole 1.0 -1.0)))
		      (scan-channel (lambda (n3) 
				      (or (> n3 .1) 
					  (not (one-pole p 1.0))))
				    0 (framples snd chn) snd chn edpos)
		      (floor (one-pole p 0.0))))))
	  (test-edpos ef 'scan-chan (lambda () (delete-samples 0 100 ind1 0)) ind1))
	(src-sound 2.0 1.0 ind1 0)
	(undo 1 ind1 0)
	
	(delete-samples 0 10000 ind1 0)
	(save-sound-as "fmv.snd" ind1 :edit-position 0)
	(save-sound-as "fmv1.snd" ind1 :edit-position 1)
	(let ((var (catch #t (lambda () (save-sound-as "fmv2.snd" ind1 :channel 1234)) (lambda args args))))
	  (if (not (eq? (car var) 'no-such-channel))
	      (snd-display "save-sound-as bad chan: ~A" var)))
	(if (not (= (mus-sound-framples "fmv.snd") (framples ind1 0 0)))
	    (snd-display "save-sound-as (edpos): ~A ~A?" (mus-sound-framples "fmv.snd") (framples ind1 0 0)))
	(if (not (= (mus-sound-framples "fmv1.snd") (framples ind1 0 1)))
	    (snd-display "save-sound-as (edpos 1): ~A ~A?" (mus-sound-framples "fmv.snd") (framples ind1 0 1)))
	(if (= (mus-sound-framples "fmv.snd") (framples ind1 0 1))
	    (snd-display "save-sound-as (edpos 1)(2): ~A ~A?" (mus-sound-framples "fmv.snd") (framples ind1 0 1)))
	(let ((ind2 (open-sound "fmv.snd"))
	      (ind3 (open-sound "fmv1.snd")))
	  (if (not (mus-arrays-equal? (channel->float-vector 12000 10 ind1 0 0) (channel->float-vector 12000 10 ind2 0)))
	      (snd-display "save-sound-as (edpos 3): ~A ~A?" (channel->float-vector 12000 10 ind1 0 0) (channel->float-vector 12000 10 ind2 0)))
	  (if (not (mus-arrays-equal? (channel->float-vector 12000 10 ind1 0 1) (channel->float-vector 12000 10 ind3 0)))
	      (snd-display "save-sound-as (edpos 4): ~A ~A?" (channel->float-vector 12000 10 ind1 0 1) (channel->float-vector 12000 10 ind3 0)))
	  (if (mus-arrays-equal? (channel->float-vector 12000 10 ind2 0) (channel->float-vector 12000 10 ind3 0))
	      (snd-display "save-sound-as (edpos 5): ~A ~A?" (channel->float-vector 12000 10 ind2 0) (channel->float-vector 12000 10 ind3 0)))
	  (select-sound ind3)
	  (set! (comment) "hiho")
	  (if (not (string=? (comment) "hiho")) (snd-display "set! comment no index: ~A" (comment)))
	  (close-sound ind2)
	  (close-sound ind3))
	(delete-file "fmv.snd")
	(delete-file "fmv1.snd")
	
  	(let ((test-edpos-1
	       (lambda (test-func func-name ind1)
		 (let ((v0 (channel->float-vector 12000 10 ind1 0)))
		   (test-func ind1 0)
		   (let ((v1 (channel->float-vector 12000 10 ind1 0)))
		     (if (mus-arrays-equal? v0 v1)
			 (snd-display "~A (0) no change! ~A ~A" func-name v0 v1))
		     (test-func ind1 0)
		     (let ((v2 (channel->float-vector 12000 10 ind1 0)))
		       (if (not (mus-arrays-equal? v1 v2))
			   (snd-display "~A (1) ~A ~A" func-name v1 v2)))))
		 (revert-sound ind1))))
	  (test-edpos-1 (lambda (snd pos) (reverse-sound snd 0 pos)) 'reverse-sound ind1)
	  (test-edpos-1 (lambda (snd pos) (env-sound '(0 0 1 1 2 0) 0 20000 1.0 snd 0 pos)) 'env-sound ind1)
	  (test-edpos-1 (lambda (snd pos) (src-sound 0.5 1.0 snd 0 pos)) 'src-sound ind1)
	  (test-edpos-1 (lambda (snd pos) (filter-sound (make-fir-filter 6 #r(.1 .2 .3 .3 .2 .1)) 6 snd 0 pos)) 'filter-sound ind1)
	  (test-edpos-1 (lambda (snd pos) (convolve-with "pistol.snd" .5 snd 0 pos)) 'convolve-with ind1))
	
	(let ((ind (new-sound "fmv.snd")))
	  (let ((v (make-float-vector 2000))
		(e (make-env (list 0.0 0.0 1.0 (* 2000 0.2 pi)) :length 2001)))
	    (fill-float-vector v (sin (env e)))
	    (float-vector->channel v 0 2000 ind 0))
	  (filter-sound '(0 0 .09 0 .1 1 .11 0 1 0) 1024)
	  (if (> (maxamp) .025) (snd-display "filter-sound maxamp 1: ~A" (maxamp)))
	  (undo)
	  (filter-sound '(0 0 .19 0 .2 1 .21 0 1 0) 1024)  
	  (if (< (maxamp) .9) (snd-display "filter-sound maxamp 2: ~A" (maxamp)))
	  (undo)
	  (filter-sound '(0 0 .29 0 .3 1 .31 0 1 0) 1024)  
	  (if (> (maxamp) .02) (snd-display "filter-sound maxamp 3: ~A" (maxamp)))
	  
	  (set! *show-sonogram-cursor* #t) 
	  (set! *with-tracking-cursor* #t) 
	  (if (not *with-tracking-cursor*) (snd-display "with-tracking-cursor set to #t: ~A" *with-tracking-cursor*))
	  
	  (set! *transform-graph-type* graph-as-sonogram) 
	  (play :wait #t)
	  (set! (transform-graph?) #t) 
	  
	  (close-sound ind))
	(close-sound ind1))
      
      (let ((ind (open-sound "1a.snd"))) ; from Anders Vinjar
	(set! (with-tracking-cursor) :track-and-return) 
	(set! (cursor) 2000) 
	(let ((here (cursor))) 
	  (play :start (cursor)) 
	  (if (not (= here 2000 (cursor)))
	      (snd-display "with-tracking-cursor set to :track-and-return: start: ~A, end: ~A" here (cursor))))
	
	(set! (zoom-focus-style) zoom-focus-middle) 
	(when with-motif
	  (set! (x-zoom-slider) .5)
	  (if (fneq (x-position-slider) 0.25) (snd-display "zoom focus middle .5: ~A" (x-position-slider)))
	  (set! (x-zoom-slider) .1)
	  (if (fneq (x-position-slider) 0.45) (snd-display "zoom focus middle .1: ~A" (x-position-slider)))
	  (set! (x-zoom-slider) .9)
	  (if (fneq (x-position-slider) 0.05) (snd-display "zoom focus middle .9: ~A" (x-position-slider)))
	  (set! (zoom-focus-style) zoom-focus-left) 
	  (set! (x-zoom-slider) .1)
	  (if (fneq (x-position-slider) 0.05) (snd-display "zoom focus left .1: ~A" (x-position-slider))))
	
	(close-sound ind))
      
      (let ((ind (open-sound "oboe.snd"))
	    (peak-env-equal? 
	     (lambda (name index e diff)
	       (let ((reader (make-sampler 0 index 0))
		     (e-size (length (car e))))
		 (let ((samps-per-bin (ceiling (/ (framples index) e-size)))
		       (mins (car e))
		       (maxs (cadr e))
		       (happy #t)
		       (data #f))
		   (set! data (make-float-vector samps-per-bin))
		   (do ((e-bin 0 (+ e-bin 1)))
		       ((or (not happy) 
			    (= e-bin e-size))
			happy)
		     (do ((k 0 (+ k 1)))
			 ((= k samps-per-bin))
		       (float-vector-set! data k (next-sample reader)))
		     
		     (let ((mx (float-vector-max data))
			   (mn (float-vector-min data)))
		       (let ((mxdiff (abs (- mx (maxs e-bin))))
			     (mndiff (abs (- mn (mins e-bin)))))
			 (when (or (> mxdiff diff)
				   (> mndiff diff))
			   (snd-display "~A: peak-env-equal? [bin ~D of ~D]: (~,4F to ~,4F), diff: ~,5F" 
					name
					e-bin e-size
					mn mx
					(max mxdiff mndiff))
			   (set! happy #f))))))))))
	
	(let ((mx (maxamp ind 0))
	      (e0 (channel-amp-envs ind 0)))
	  (if (null? e0)
	      (snd-display "no amp env data")
	      (let ((mx1 (float-vector-peak (car e0)))
		    (mx2 (float-vector-peak (cadr e0))))
		(if (fneq mx (max mx1 mx2))
		    (snd-display "amp env max: ~A ~A ~A" mx mx1 mx2))
		(peak-env-equal? "straight peak" ind e0 .0001)
		(scale-by 3.0)
		(let ((e1 (channel-amp-envs ind 0 1)))
		  (let ((mx3 (float-vector-peak (car e1)))
			(mx4 (float-vector-peak (cadr e1))))
		    (if (or (fneq (* 3.0 mx1) mx3)
			    (fneq (* 3.0 mx2) mx4))
			(snd-display "3.0 amp env max: ~A ~A ~A ~A" mx1 mx2 mx3 mx4)))
		  (peak-env-equal? "scaled peak" ind e1 .0001))
		(if (fneq (maxamp ind 0) (* 3 mx)) 
		    (snd-display "maxamp after scale: ~A ~A" mx (maxamp ind 0)))
		(undo)
		(set! (selection-member? #t) #f)
		(set! (selection-member? ind 0) #t)
		(set! (selection-position ind 0) 20000)
		(set! (selection-framples ind 0) 12000)
		(scale-selection-by 3.0)
		(let ((e1 (channel-amp-envs ind 0 1)))
		  (let ((mx3 (float-vector-peak (car e1)))
			(mx4 (float-vector-peak (cadr e1))))
		    (if (or (fneq (* 3.0 mx1) mx3)
			    (fneq (* 3.0 mx2) mx4))
			(snd-display "selection 3.0 amp env max: ~A ~A ~A ~A" mx1 mx2 mx3 mx4))
		    (if (fneq (maxamp ind 0) (* 3 mx)) 
			(snd-display "maxamp after selection scale: ~A ~A" mx (maxamp ind 0))))
		  (peak-env-equal? "selection peak" ind e1 .0001))
		(map-channel abs)
		(let ((e1 (channel-amp-envs ind 0 2)))
		  (let ((mx3 (float-vector-peak (car e1)))
			(mx4 (float-vector-peak (cadr e1))))
		    (if (fneq (* 3.0 mx2) mx4)
			(snd-display "abs selection 3.0 amp env max: ~A ~A ~A ~A" mx1 mx2 mx3 mx4))
		    (if (fneq (maxamp ind 0) (* 3 mx)) 
			(snd-display "maxamp after abs selection scale: ~A ~A" mx (maxamp ind 0)))
		    (if (ffneq mx3 0.03)
			(snd-display "abs max: ~A ~A" mx3 mx4)))
		  (peak-env-equal? "map-channel peak" ind e1 .0001))
		(delete-samples 10000 5000)
		(let ((e1 (channel-amp-envs ind 0)))
		  (let ((mx3 (float-vector-peak (car e1)))
			(mx4 (float-vector-peak (cadr e1))))
		    (if (fneq (* 3.0 mx2) mx4)
			(snd-display "abs selection 3.0 amp env max: ~A ~A ~A ~A" mx1 mx2 mx3 mx4))
		    (if (fneq (maxamp ind 0) (* 3 mx)) 
			(snd-display "maxamp after abs selection scale: ~A ~A" mx (maxamp ind 0)))
		    (if (ffneq mx3 0.03)
			(snd-display "abs max: ~A ~A" mx3 mx4)))
		  (peak-env-equal? "delete peak" ind e1 .0001))
		(scale-selection-by -.333)
		(let ((e1 (channel-amp-envs ind 0 4)))
		  (let ((mx3 (float-vector-peak (car e1))))
		    (if (fneq (maxamp ind 0) mx)
			(snd-display "maxamp after minus abs selection scale: ~A ~A" mx (maxamp ind 0)))
		    (if (fneq (maxamp ind 0) mx3)
			(snd-display "mx3 maxamp after minus abs selection scale: ~A ~A" mx mx3)))
		  (peak-env-equal? "scale-selection peak" ind e1 .0001)))))
	
	(revert-sound ind)
	(ramp-channel 0.0 1.0)
	(peak-env-equal? "ramp-channel peak" ind (channel-amp-envs ind 0 1) .001)
	(undo)
	(env-channel '(0 0 1 1 2 0))
	(peak-env-equal? "env-channel peak" ind (channel-amp-envs ind 0 1) .002)
	(undo)
	(env-channel (make-env '(0 0 1 1 2 0) :scaler 0.5 :length (framples)))
	(peak-env-equal? "scaled env-channel peak" ind (channel-amp-envs ind 0 1) .002)
	(undo)
	(env-channel (make-env '(0 0 1 1 2 0) 0.5 :length (framples)))
	(peak-env-equal? "scaled nokey env-channel peak" ind (channel-amp-envs ind 0 1) .001)
	(undo)
	(env-channel (make-env '(0 0 1 1 2 0) :scaler 0.5 :offset 0.5 :length (framples)))
	(peak-env-equal? "scaled and offset env-channel peak" ind (channel-amp-envs ind 0 1) .001)
	(undo)
	(env-channel (make-env '(0 0 1 1 2 .5 3 0) :base 0.0 :length (framples)))
	(peak-env-equal? "env-channel base 0.0 peak" ind (channel-amp-envs ind 0 1) .001)
	(undo)
	(xramp-channel 0.0 1.0 32.0)
	(peak-env-equal? "xramp 32.0 peak" ind (channel-amp-envs ind 0 1) .008)
	(undo)
	(xramp-channel 0.0 1.0 .032)
	(peak-env-equal? "xramp .032 peak" ind (channel-amp-envs ind 0 1) .004)
	(undo)
	(env-channel (make-env '(0 0 1 1 2 .5 3 0) :base 10.0 :length (framples)))
	(peak-env-equal? "env-channel base 10.0 peak" ind (channel-amp-envs ind 0 1) .003)
	(undo)
	(env-channel (make-env '(0 0 1 1 2 0) :base .10 :length (framples)))
	(peak-env-equal? "env-channel base .1 peak" ind (channel-amp-envs ind 0 1) .003)
	(undo)
	(revert-sound ind)
	(ramp-channel 0.0 1.0)
	(ramp-channel 1.0 0.0)
	(peak-env-equal? "ramp2 peak" ind (channel-amp-envs ind 0 2) .002)
	
	(revert-sound ind)
	(env-channel '(0 0 1 1))
	(env-channel '(0 0 1 1 2 0))
	(peak-env-equal? "env ramp2 peak" ind (channel-amp-envs ind 0 2) .002)
	
	(revert-sound ind)
	(ramp-channel 0.0 1.0 12000 5000)
	(peak-env-equal? "ramp-channel peak" ind (channel-amp-envs ind 0 1) .002)
	(undo)
	(env-channel '(0 0 1 1 2 0) 12000 5000)
	(peak-env-equal? "env-channel peak" ind (channel-amp-envs ind 0 1) .003)
	(undo)
	(env-channel (make-env '(0 0 1 1 2 0) :scaler 0.5 :length 5000) 12000 5000)
	(peak-env-equal? "scaled env-channel peak" ind (channel-amp-envs ind 0 1) .004)
	(undo)
	(env-channel (make-env '(0 0 1 1 2 0) 0.5 :length 5000) 12000 5000)
	(peak-env-equal? "scaled nokey env-channel peak" ind (channel-amp-envs ind 0 1) .004)
	(undo)
	(env-channel (make-env '(0 0 1 1 2 0) :scaler 0.5 :offset 0.5 :length 5000) 12000 5000)
	(peak-env-equal? "scaled and offset env-channel peak" ind (channel-amp-envs ind 0 1) .002)
	(undo)
	(xramp-channel 0.0 1.0 32.0 2000 1000)
	(peak-env-equal? "xramp 32.0 peak (1)" ind (channel-amp-envs ind 0 1) .009)
	(undo)
	(xramp-channel 0.0 1.0 .032 2000 1000)
	(peak-env-equal? "xramp .032 peak (1)" ind (channel-amp-envs ind 0 1) .009)
	(undo)
	(env-channel (make-env '(0 0 1 1 2 .5 3 0) :base 10.0 :length 5000) 12000 5000)
	(peak-env-equal? "env-channel base 10.0 peak" ind (channel-amp-envs ind 0 1) .1)
	;; this can be way off because the envelope is not very closely sampled in this case
	(revert-sound ind)
	(ramp-channel 0.0 1.0)
	(ramp-channel 1.0 0.0 2000 1000)
	(peak-env-equal? "ramp2 peak" ind (channel-amp-envs ind 0 2) .002)
	
	(revert-sound ind)
	(env-channel '(0 0 1 1))
	(env-channel '(0 0 1 1 2 0) 2000 1000)
	(peak-env-equal? "env ramp2 peak" ind (channel-amp-envs ind 0 2) .002)
	
	(revert-sound ind)
	(env-channel '(0 0 1 1))
	(env-channel '(0 0 1 1 2 0))
	(env-channel '(0 0 1 1) 12000 5000)
	(peak-env-equal? "env ramp3 peak" ind (channel-amp-envs ind 0 3) .01)
	
	(revert-sound ind)
	(close-sound ind))
      
      (let ((ind (new-sound "test.snd")))
	(map-channel (lambda (y) 1.0) 0 50001)
	(ramp-channel 0.5 1.0 1000 4000)
	(let ((peaks (channel-amp-envs ind 0)))
	  (let ((mx (cadr peaks))
		(mn (car peaks)))
	    (call-with-exit
	     (lambda (break)
	       (do ((ln (- (length mn) 4))
		    (i 0 (+ i 1)))
		   ((= i ln))
		 (when (< (mn i) 0.5) (snd-display "peak min: ~A ~A" (mn i) i) (break #f))
		 (when (< (mx i) 0.5) (snd-display "peak max: ~A ~A" (mx i) i) (break #f)))))))
	(undo 2)
	(map-channel (lambda (y) -1.0) 0 50001)
	(ramp-channel 0.5 1.0 1000 4000)
	(let ((peaks (channel-amp-envs ind 0)))
	  (let ((mx (cadr peaks))
		(mn (car peaks))
		(happy #t))
	    (do ((ln (- (length mn) 4))
		 (i 0 (+ i 1)))
		((or (not happy) 
		     (= i ln)))
	      (when (> (mn i) -0.5) (snd-display "1 peak min: ~A ~A" (mn i) i) (set! happy #f))
	      (when (> (mx i) -0.5) (snd-display "1 peak max: ~A ~A" (mx i) i) (set! happy #f)))))
	(close-sound ind))
      
      (let ((index (new-sound "fmv.snd" 2 22050 mus-ldouble mus-next "channel tests")))
	(define (test-channel-func func val-func init-val)
	  (do ((len (framples index))
	       (chns (chans index))
	       (val #f)
	       (g-init-val init-val)
	       (k 0 (+ k 1)))
	      ((= k 2))
	    (set! val (val-func len))
	    (set! (sync index) k)
	    (do ((i 0 (+ i 1)))
		((= i chns))
	      (map-channel (lambda (n) 0.0) 0 len index i)
	      (if (scan-channel (lambda (n) (> (abs n) .001)) 0 len index i)
		  (snd-display "init scan: ~A?" (scan-channel (lambda (n) (> (abs n) 0.001))))))
	    ;; now it's cleared
	    (do ((i 0 (+ i 1)))
		((= i chns))
	      (map-channel (lambda (n) g-init-val) 0 len index i)
	      (func 0 len index i)
	      (do ((j 0 (+ j 1)))
		  ((= j chns))
		(let ((vi (channel->float-vector 0 len index j)))
		  (if (= j i)
		      (if (not (mus-arrays-equal? vi val))
			  (snd-display "chan func: ~A ~A" vi val))
		      (if (scan-channel (lambda (n) (> (abs n) .001)) 0 len index j)
			  (snd-display "chan func leaks? ~A ~A: ~A" i j (scan-channel (lambda (n) (> (abs n) 0.001)) 0 len index j))))))
	      (map-channel (lambda (n) 0.0) 0 len index i))
	    (do ((i 0 (+ i 1)))
		((= i chns))
	      (map-channel (lambda (n) g-init-val) 0 len index i)
	      (let ((ed (edit-position index i)))
		(map-channel (lambda (n) (+ g-init-val 1.0)) 0 len index i)
		(func 0 len index i ed)
		(do ((j 0 (+ j 1)))
		    ((= j chns))
		  (let ((vi (channel->float-vector 0 len index j)))
		    (if (= j i)
			(if (not (mus-arrays-equal? vi val))
			    (snd-display "ed chan func: ~A ~A" vi val))
			(if (scan-channel (lambda (n) (> (abs n) 0.001)) 0 len index j)
			    (snd-display "ed chan func leaks? ~A ~A ~A: ~A" i j ed (scan-channel (lambda (n) (> (abs n) 0.001)) 0 len index j))))))
		(map-channel (lambda (n) 0.0) 0 len index i)))
	    (let* ((beg (floor (/ len 3)))
		   (dur beg)
		   (nv (val-func dur)))
	      (fill! val 0.0)
	      (do ((i beg (+ i 1))
		   (j 0 (+ j 1)))
		  ((= j dur))
		(set! (val i) (nv j)))
	      (do ((i 0 (+ i 1)))
		  ((= i chns))
		(map-channel (lambda (n) g-init-val) beg dur index i)
		(func beg dur index i)
		(add-mark beg index i)
		(do ((j 0 (+ j 1)))
		    ((= j chns))
		  (let ((vi (channel->float-vector 0 len index j)))
		    (if (= j i)
			(if (not (mus-arrays-equal? vi val))
			    (snd-display "chan func n: ~A ~A" vi val))
			(if (scan-channel (lambda (n) (> (abs n) 0.001)) 0 len index j)
			    (snd-display "dur chan func leaks? ~A ~A: ~A" i j (scan-channel (lambda (n) (> (abs n) 0.001)) 0 len index j))))))
		(map-channel (lambda (n) 0.0) 0 len index i)))))
	
	(insert-silence 0 10 index 0)
	(insert-silence 0 10 index 1)
	
	(test-channel-func (lambda* (beg dur index chan edpos)
			     (clm-channel (make-env :envelope '(0 0 1 1) :length dur) beg dur index chan edpos))
			   (lambda (dur)
			     (do ((e (make-env :envelope '(0 0 1 1) :length dur))
				  (v (make-float-vector dur))
				  (i 0 (+ i 1)))
				 ((= i dur) v)
			       (set! (v i) (env e))))
			   0.0)
	
	(test-channel-func (lambda* (beg dur index chan edpos)
			     (clm-channel (make-oscil :frequency 0.0 :initial-phase (/ pi 2)) beg dur index chan edpos))
			   (lambda (dur)
			     (make-float-vector dur 1.0))
			   0.0)
	
	(test-channel-func (lambda* (beg dur index chan edpos)
			     (scale-channel 0.5 beg dur index chan edpos))
			   (lambda (dur)
			     (make-float-vector dur .5))
			   1.0)
	
	(test-channel-func (lambda* (beg dur index chan edpos)
			     (env-channel (make-env :envelope '(0 0 1 1) :length dur) beg dur index chan edpos))
			   (lambda (dur)
			     (do ((e (make-env :envelope '(0 0 1 1) :length dur))
				  (v (make-float-vector dur))
				  (i 0 (+ i 1)))
				 ((= i dur) v)
			       (set! (v i) (env e))))
			   1.0)
	
	(test-channel-func (lambda* (beg dur index chan edpos)
			     (env-channel '(0 0 1 1) beg dur index chan edpos))
			   (lambda (dur)
			     (do ((e (make-env :envelope '(0 0 1 1) :length dur))
				  (v (make-float-vector dur))
				  (i 0 (+ i 1)))
				 ((= i dur) v)
			       (set! (v i) (env e))))
			   1.0)
	
	(test-channel-func (lambda* (beg dur index chan edpos)
			     (float-vector->channel (make-float-vector dur -1.0) beg dur index chan))
			   (lambda (dur)
			     (make-float-vector dur -1.0))
			   1.0)
	
	(test-channel-func (lambda* (beg dur index chan edpos)
			     (delete-samples beg dur index chan edpos)
			     (pad-channel beg dur index chan edpos))
			   make-float-vector
			   1.0)
	
	(test-channel-func (lambda* (beg dur index chan edpos)
			     (delete-samples beg dur index chan edpos)
			     (insert-samples beg dur (make-float-vector dur -1.0) index chan edpos))
			   (lambda (dur)
			     (make-float-vector dur -1.0))
			   1.0)
	
	(test-channel-func (lambda* (beg dur index chan edpos)
			     (set! (samples beg dur index chan #f "test-channel" 0 edpos) (make-float-vector dur -1.0)))
			   (lambda (dur)
			     (make-float-vector dur -1.0))
			   1.0)
	
	(test-channel-func (lambda* (beg dur index chan edpos)
			     (env-channel (make-env :envelope '(0 0 1 1) :length dur) beg dur index chan edpos)
			     (reverse-channel beg dur index chan))
			   (lambda (dur)
			     (do ((e (make-env :envelope '(0 1 1 0) :length dur))
				  (v (make-float-vector dur))
				  (i 0 (+ i 1)))
				 ((= i dur) v)
			       (set! (v i) (env e))))
			   1.0)
	
	(test-channel-func (lambda* (beg dur index chan edpos)
			     (env-channel (make-env :envelope '(0 0 1 1) :length dur) beg dur index chan edpos)
			     (set! (sample (+ beg dur) index chan) 1.0)
			     (smooth-channel beg dur index chan)
			     (if (not (= beg 0))
				 (set! (sample (+ beg dur) index chan) 0.0)))
			   (lambda (dur)
			     (do ((v (make-float-vector dur))
				  (ipi (/ pi dur))
				  (i 0 (+ i 1)))
				 ((= i dur) v)
			       (set! (v i) (+ 0.5 (* 0.5 (cos (+ pi (* ipi i))))))))
			   1.0)
	
	(let ((old-max (maxamp index #t))
	      (regdata (map (lambda (n)
			      (catch #t
				(lambda ()
				  (region->float-vector n 0 10))
				(lambda args (float-vector))))
			    (regions)))
	      ;; (old-pos0 (edit-position index 0))
	      ;; (old-pos1 (edit-position index 1))
	      (old-reglen (map region-framples (regions))))
	  (hook-push save-state-hook
		     (lambda (hook)
		       (if (not (string? (hook 'name))) (format *stderr* "save-state-hook name: ~S~%" (hook 'name)))))
	  (if (file-exists? "s61.scm") (delete-file "s61.scm"))
	  (save-state "s61.scm")
	  (close-sound index)
	  (for-each forget-region (regions))
	  (load (string-append cwd "s61.scm"))
	  (if (not (equal? old-reglen (map region-framples (regions))))
	      (snd-display "region-framples after save: ~A ~A" old-reglen (map region-framples (regions))))
	  (catch #t
	    (lambda ()
	      (for-each (lambda (n data)
			  (if (not (mus-arrays-equal? data (region->float-vector n 0 10)))
			      (snd-display "region after save ~A: ~A ~A" n data (region->float-vector n 0 10))))
			(regions)
			regdata))
	    (lambda args (snd-display "region->float-vector: ~A" args)))
	  (set! index (find-sound "fmv.snd"))
	  (if (not (equal? (maxamp index #t) old-max))
	      (snd-display "maxes: ~A ~A" (maxamp index #t) old-max))
	  (if (not (member (edits index) '((275 0) (276 0))))
	      (snd-display "saved channel edits: ~A" (edits index)))
	  
	  (do ((i 0 (+ i 1)))
	      ((= i 10))
	    (let ((pos (random (car (edits index)))))
	      (scale-channel (random 2.0) (random 5) (random 5) index 0 pos)
	      (set! (edit-position index) (floor (* (car (edits index)) .7)))))
	  
	  (close-sound index)
	  (for-each forget-region (regions))
	  (delete-file "s61.scm")
	  (set! (hook-functions save-state-hook) ())))
      
      (let ((index (new-sound "fmv.snd" 2 22050 mus-ldouble mus-next "channel tests"))
	    (v (make-float-vector 10)))
	(let-temporarily ((*sinc-width* 10))
	  (set! (v 0) 1.0)
	  (float-vector->channel v 0 10 index 0)
	  (src-channel 0.5 0 10 index 0)
	  (let ((v (make-float-vector 10))
		(s (make-src :srate 0.5
			     :input (let ((val 1.0))
				      (lambda (dir)
					(let ((rtn val))
					  (set! val 0.0)
					  rtn))))))
	    (set! (v 0) (src s))
	    (do ((i 1 (+ i 1)))
		((= i 10))
	      (set! (v i) (src s)))
	    (if (not (mus-arrays-equal? v (channel->float-vector 0 10 index 0)))
		(snd-display "src-channel: ~A ~A" v (channel->float-vector 0 10 index 0)))
	    (if (not (mus-arrays-equal? (make-float-vector 10) (channel->float-vector 0 10 index 1)))
		(snd-display "src-channel leaks: ~A" (channel->float-vector 0 10 index 1))))
	  (let ((tag (catch #t (lambda () (src-channel 120000.0)) (lambda args args))))
	    (if (not (eq? (car tag) 'mus-error)) (snd-display "src-channel crazy srate: ~A" tag)))
	  (let ((tag (catch #t (lambda () (filter-sound (make-snd->sample))) (lambda args args))))
	    (if (not (eq? (car tag) 'mus-error)) (snd-display "filter-sound + un-run gen: ~A" tag)))
	  (revert-sound index)
	  (float-vector->channel v 0 10 index 1)
	  (float-vector->channel v 10 10 index 1)
	  (src-channel (make-env :envelope '(1 1 2 2) :length 21) 0 20 index 1)
	  (if (not (mus-arrays-equal? (channel->float-vector 0 10 index 1) #r(1.000 -0.000 -0.048 0.068 -0.059 0.022 0.030 -0.100 0.273 0.606)))
	      (snd-display "src-channel env: ~A" (channel->float-vector 0 10 index 1)))
	  (if (not (mus-arrays-equal? (make-float-vector 10) (channel->float-vector 0 10 index 0)))
	      (snd-display "src-channel env leaks: ~A" (channel->float-vector 0 10 index 0)))
	  (revert-sound index)
	  (float-vector->channel v 0 10 index 1)
	  (float-vector->channel v 10 10 index 1)
	  (src-channel '(1 1 2 2) 0 20 index 1) ; end is off above -- should be 19 I think
	  (if (not (mus-arrays-equal? (channel->float-vector 0 10 index 1) #r(1.000 -0.000 -0.051 0.069 -0.056 0.015 0.042 -0.117 0.320 0.568)))
	      (snd-display "src-channel lst: ~A" (channel->float-vector 0 10 index 1)))
	  (if (not (mus-arrays-equal? (make-float-vector 10) (channel->float-vector 0 10 index 0)))
	      (snd-display "src-channel lst leaks: ~A" (channel->float-vector 0 10 index 0)))
	  (close-sound index)))
      
      (let ((ind (new-sound :size 100)))
	(for-each
	 (lambda (sr)
	   (revert-sound ind)
	   (set! (sample 50) .5)
	   (set! (sample 51) -.5)
	   (src-channel sr)
	   (let ((v1 (channel->float-vector)))
	     (revert-sound ind)
	     (set! (sample 50) .5)
	     (set! (sample 51) -.5)
	     (src-channel (+ sr .00001))
	     (let ((v2 (channel->float-vector)))
	       (float-vector-abs! (float-vector-subtract! v1 v2))
	       (do ((sum 0.0)
		    (len (min (length v1) (length v2)))
		    (mx (float-vector-peak v1))
		    (i 0 (+ i 1)))
		   ((= i len)
		    (if (or (> sum .01) ; depends on sinc-width I think
			    (> mx .002))
			(snd-display "src-channel ~A: diff: ~A ~A~%" sr sum mx)))
		 (set! sum (+ sum (float-vector-ref v1 i)))))))
	 '(0.5 0.75 1.0 1.5 2.0))
	(close-sound ind))
      
      (set! *max-regions* (max *max-regions* 8))
      (let ((region2float-vector 
	     (lambda (r c len)
	       (region->float-vector r 0 len c)))
	    (region-to-float-vector 
	     (lambda (r c len)
	       (let ((rs (make-region-sampler r 0 c))
		     (v (make-float-vector len)))
		 (outa->fv v (next-sample rs))))))
	(let* ((ind (open-sound "oboe.snd"))
	       (rid0 (make-region 2000 2020 ind 0))
	       (rid0-data (region2float-vector rid0 0 20)))
	  (scale-sound-by 2.0)
	  (play rid0 :wait #t)
	  (let ((nv (region2float-vector rid0 0 20)))
	    (if (not (mus-arrays-equal? rid0-data nv)) (snd-display "deferred region after scaling:~%  ~A~%  ~A" rid0-data nv)))
	  (let ((nv (region-to-float-vector rid0 0 20)))
	    (if (not (mus-arrays-equal? rid0-data nv)) (snd-display "deferred region after scaling (rs):~%  ~A~%  ~A" rid0-data nv)))
	  (undo)
	  (scale-by 4.0)
	  (play rid0 :wait #t)
	  (let ((nv (region2float-vector rid0 0 20)))
	    (if (not (mus-arrays-equal? rid0-data nv)) (snd-display "file region after scaling:~%  ~A~%  ~A" rid0-data nv)))
	  (let ((nv (region-to-float-vector rid0 0 20)))
	    (if (not (mus-arrays-equal? rid0-data nv)) (snd-display "file region after scaling (rs):~%  ~A~%  ~A" rid0-data nv)))
	  (let* ((rid1 (make-region 2000 2020 ind 0))
		 (rid1-data (region2float-vector rid1 0 20)))
	    (scale-to .5)
	    (let ((nv (region2float-vector rid1 0 20)))
	      (if (not (mus-arrays-equal? rid1-data nv)) (snd-display "deferred region after scale-to:~%  ~A~%  ~A" rid1-data nv)))
	    (close-sound ind)
	    (play rid0 :wait #t)
	    (play rid1 :wait #t)
	    (let ((nv (region2float-vector rid1 0 20)))
	      (if (not (mus-arrays-equal? rid1-data nv)) (snd-display "deferred region after close:~%  ~A~%  ~A" rid1-data nv)))
	    (let ((nv (region2float-vector rid0 0 20)))
	      (if (not (mus-arrays-equal? rid0-data nv)) (snd-display "file region after close:~%  ~A~%  ~A" rid0-data nv))))
	  
	  (for-each
	   (lambda (s1 L1 s2 L2)
	     (set! ind (open-sound "2.snd"))
	     (set! (selection-member? #t) #f)
	     (set! (selection-member? ind 0) #t)
	     (set! (selection-position ind 0) s1)
	     (set! (selection-framples ind 0) L1)
	     (set! (selection-member? ind 1) #t)
	     (set! (selection-position ind 1) s2)
	     (set! (selection-framples ind 1) L2)
	     (let* ((rid2 (make-region))
		    (rid20-data (region2float-vector rid2 0 L1))
		    (rid21-data (region2float-vector rid2 1 L2)))
	       (if (not (= (region-chans rid2) 2)) (snd-display "region-chans of sync'd sound: ~A?" (region-chans rid2)))
	       (swap-channels ind 0 ind 1)
	       (let ((nv (region2float-vector rid2 0 L1)))
		 (if (not (mus-arrays-equal? rid20-data nv)) (snd-display "deferred region after scaling (20):~%  ~A~%  ~A" rid20-data nv)))
	       (let ((nv (region-to-float-vector rid2 0 L1)))
		 (if (not (mus-arrays-equal? rid20-data nv)) (snd-display "deferred region after scaling (20 rs):~%  ~A~%  ~A" rid20-data nv)))
	       (let ((nv (region2float-vector rid2 1 L2)))
		 (if (not (mus-arrays-equal? rid21-data nv)) (snd-display "deferred region after scaling (21):~%  ~A~%  ~A" rid21-data nv)))
	       (let ((nv (region-to-float-vector rid2 1 L2)))
		 (if (not (mus-arrays-equal? rid21-data nv)) (snd-display "deferred region after scaling (21 rs):~%  ~A~%  ~A" rid21-data nv)))
	       (close-sound ind)
	       (let ((nv (region2float-vector rid2 0 L1)))
		 (if (not (mus-arrays-equal? rid20-data nv)) (snd-display "deferred region after scaling (20):~%  ~A~%  ~A" rid20-data nv)))
	       (let ((nv (region-to-float-vector rid2 0 L1)))
		 (if (not (mus-arrays-equal? rid20-data nv)) (snd-display "deferred region after scaling (20 rs):~%  ~A~%  ~A" rid20-data nv)))
	       (let ((nv (region2float-vector rid2 1 L2)))
		 (if (not (mus-arrays-equal? rid21-data nv)) (snd-display "deferred region after scaling (21):~%  ~A~%  ~A" rid21-data nv)))
	       (let ((nv (region-to-float-vector rid2 1 L2)))
		 (if (not (mus-arrays-equal? rid21-data nv)) (snd-display "deferred region after scaling (21 rs):~%  ~A~%  ~A" rid21-data nv)))
	       ))
	   '(2000 2000 2000 0 2000 0 2000)
	   '(20 10 20 20 20 10 20)
	   '(2000 2000 2000 2000 0 2000 0)
	   '(20 20 10 20 20 20 10))))
      
      (let ((ind (open-sound "obtest.snd")))
	(set! (read-only ind) #t)
	(delete-samples 0 1000 ind 0)
	(let ((val (catch #t
		     (lambda ()
		       (save-sound ind))
		     (lambda args args))))
	  (if (sound? val) (snd-display "save-sound read-only: ~A" val))
	  ;(if (not (equal? (edits ind) '(1 0))) (snd-display "read-only ignored? ~A" (edits ind)))
	  )
	(set! (read-only ind) #f)
	(revert-sound ind)
	(let ((tag (catch #t
		     (lambda () (save-sound ind))
		     (lambda args args))))
	  (if (not (sound? tag)) (snd-display "save-sound read-write: ~A" tag)))
	(for-each (lambda (arg) (key arg 4)) (vector (char->integer #\j) (char->integer #\-) (char->integer #\j) 
						     (char->integer #\j) (char->integer #\x)))
	(key (char->integer #\c) 0)
	(catch #t (lambda () (add-mark 123)) (lambda args #f))
	(for-each (lambda (arg) (key arg 4)) (vector (char->integer #\u) (char->integer #\6) (char->integer #\j) 
						     (char->integer #\u) (char->integer #\6) (char->integer #\x)))
	(key (char->integer #\c) 0)
	(close-sound ind))
      
      (let ((ns (new-sound)))
	(unselect-all)
	(do ((v (make-float-vector 1000))
	     (i 0 (+ i 1))
	     (x 0.0 (+ x .001)))
	    ((= i 1000)
	     (float-vector->channel v 0 1000 ns 0))   
	  (set! (v i) x))
	(set! (selection-member? ns 0) #t)
	(set! (selection-position ns 0) 200)
	(set! (selection-framples ns 0) 300)
	(delete-selection-and-smooth)
	(if (not (= (framples ns 0) 700))
	    (snd-display "delete-selection-and-smooth framples: ~A" (framples ns 0)))
	(if (fneq (sample 167 ns 0) 0.167) 
	    (snd-display "delete-selection-and-smooth 167: ~A" (sample 167 ns 0)))
	(if (fneq (sample 234 ns 0) 0.534) 
	    (snd-display "delete-selection-and-smooth 234: ~A" (sample 234 ns 0)))
	(if (fneq (sample 210 ns 0) 0.406) 
	    (snd-display "delete-selection-and-smooth 210: ~A" (sample 210 ns 0)))
	(let ((v1 (channel->float-vector)))
	  (let ((maxdiff 0.0)
		(mindiff 10.0)
		(ls (v1 0)))
	    (do ((i 1 (+ i 1)))
		((= i 700))
	      (let ((diff (- (v1 i) ls)))
		(set! ls (v1 i))
		(set! maxdiff (max maxdiff diff))
		(set! mindiff (min mindiff diff))))
	    (if (< mindiff .0009)
		(snd-display "delete-selection-and-smooth min diff: ~A" mindiff))
	    (if (> maxdiff .007)
		(snd-display "delete-selection-and-smooth max diff: ~A" maxdiff))))
	(close-sound ns))
      
      (let ((ns (new-sound)))
	(do ((v (make-float-vector 1000))
	     (i 0 (+ i 1))
	     (x 0.0 (+ x .001)))
	    ((= i 1000) 
	     (float-vector->channel v 0 1000 ns 0))
	  (set! (v i) x))
	(delete-samples-and-smooth 200 300 ns 0)
	(if (not (= (framples ns 0) 700))
	    (snd-display "delete-samples-and-smooth framples: ~A" (framples ns 0)))
	(if (fneq (sample 167 ns 0) 0.167) 
	    (snd-display "delete-samples-and-smooth 167: ~A" (sample 167 ns 0)))
	(if (fneq (sample 234 ns 0) 0.534) 
	    (snd-display "delete-samples-and-smooth 234: ~A" (sample 234 ns 0)))
	(if (fneq (sample 210 ns 0) 0.406) 
	    (snd-display "delete-samples-and-smooth 210: ~A" (sample 210 ns 0)))
	(let ((v1 (channel->float-vector)))
	  (let ((maxdiff 0.0)
		(mindiff 10.0)
		(ls (v1 0)))
	    (do ((i 1 (+ i 1)))
		((= i 700))
	      (let ((diff (- (v1 i) ls)))
		(set! ls (v1 i))
		(set! maxdiff (max maxdiff diff))
		(set! mindiff (min mindiff diff))))
	    (if (< mindiff .0009)
		(snd-display "delete-samples-and-smooth min diff: ~A" mindiff))
	    (if (> maxdiff .007)
		(snd-display "delete-samples-and-smooth max diff: ~A" maxdiff))))
	(close-sound ns))
      
      (let-temporarily (((hook-functions initial-graph-hook) ())
			(*show-full-duration* #t))
	(let ((ns (open-sound "1.snd")))
	  (let ((ls (left-sample ns 0))
		(rs (right-sample ns 0))
		(fr (framples ns 0)))
	    (when (and with-gui
		       (not (equal? (list fr ls rs) '(220501 0 220501))))
	      (snd-display "show-full-duration 1: ~A" (list fr ls rs)))
	    (close-sound ns)))
	(set! *show-full-duration* #t)
	(let-temporarily ((*initial-beg* 0.0)
			  (*initial-dur* 0.2))
	  (let ((ns (open-sound "1.snd")))
	    (let ((ls (left-sample ns 0))
		  (rs (right-sample ns 0))
		  (fr (framples ns 0)))
	      (when (and with-gui
			 (not (equal? (list fr ls rs) '(220501 0 220501))))
		(snd-display "show-full-duration 2: ~A" (list fr ls rs)))
	      (close-sound ns)))
	  (set! *show-full-duration* #f)
	  (set! *initial-beg* 0.0)
	  (set! *initial-dur* 0.2)
	  (let ((ns (open-sound "1.snd")))
	    (let ((ls (left-sample ns 0))
		  (rs (right-sample ns 0))
		  (fr (framples ns 0)))
	      (if (not (equal? (list fr ls rs) '(220501 0 4410)))
		  (snd-display "show-full-duration 3: ~A" (list fr ls rs)))
	      (close-sound ns)))
	  (set! *initial-beg* 2.0)
	  (set! *initial-dur* 1.0)
	  (let ((ns (open-sound "1.snd")))
	    (let ((ls (left-sample ns 0))
		  (rs (right-sample ns 0))
		  (fr (framples ns 0)))
	      (if (not (equal? (list fr ls rs) '(220501 44100 66150)))
		  (snd-display "show-full-duration 4: ~A" (list fr ls rs)))	  
	      (close-sound ns)))))
      
      (set! *show-full-range* #t)
      (let ((ns (open-sound "1a.snd")))
	(if (or (fneq (car (y-bounds ns 0)) -1.0)
		(fneq (cadr (y-bounds ns 0)) 1.0))
	    (snd-display "show-full-range 1a: ~A" (y-bounds ns 0)))
	(close-sound ns))
      (with-sound ("test.snd" :clipped #f :to-snd #f)
	(fm-violin 0 1 440 3.5))
      (let ((ns (open-sound "test.snd")))
	(when (and with-gui
		   (or (fneq (car (y-bounds ns 0)) -3.5)
		       (fneq (cadr (y-bounds ns 0)) 3.5)))
	  (snd-display "show-full-range 3.5 test: ~A" (y-bounds ns 0)))
	(with-sound ("test.snd" :clipped #f :to-snd #f)
	  (fm-violin 0 1 440 1.5))
	(update-sound ns)
	(when (and with-gui
		   (or (fneq (car (y-bounds ns 0)) -1.5)
		       (fneq (cadr (y-bounds ns 0)) 1.5)))
	  (snd-display "show-full-range 1.5 test: ~A" (y-bounds ns 0)))
	(close-sound ns))
      (set! *show-full-range* #f)
      
      (let-temporarily ((*sync-style* sync-none))
	(let ((ns (open-sound "2.snd")))
	  (if (not (= (sync ns) 0))
	      (snd-display "sync-none open: ~A" (sync ns)))
	  (set! (sync ns) 1)
	  (set! *sync-style* sync-by-sound)
	  (let ((ns1 (open-sound "1a.snd")))
	    (if (or ;(= (sync ns1) 0) ; this default changed 12.9
		 (= (sync ns1) 1)
		 (not (= (sync ns) 1)))
		(snd-display "sync-by-sound open: ~A" (list (sync ns) (sync ns1))))
	    (close-sound ns1))
	  (close-sound ns)))
      
      (let ((ind (view-sound "obtest.snd")))
	(delete-samples 0 1000 ind 0)
	(let ((tag (catch #t
		     (lambda () (save-sound ind))
		     (lambda args args))))
	  (if (integer? tag) (snd-display "save-viewed-sound: ~A" tag))
	  ;(if (not (equal? (edits ind) '(1 0))) (snd-display "view read-only ignored? ~A" (edits ind)))
	  )
	(close-sound ind))
      
      (let ((ind (new-sound "test.snd" 1 22050 mus-ldouble mus-next)))
	(insert-silence 0 150000)
	(map-channel (lambda (y) 0.5))
	(env-sound '(0 0 1 1 2 0))
	(fp 1.0 0.3 20)
	(let-temporarily ((*with-tracking-cursor* #t))
	  (play :wait #t))
	(close-sound ind))
      (let ((ind (new-sound "test.snd" 1 22050 mus-ldouble mus-next)))
	(for-each
	 (lambda (dur)
	   (insert-silence 0 dur)
	   (map-channel (lambda (y) 1.0))
	   (env-sound '(0 0 1 1 2 0))
	   (let ((reader (make-sampler (- (framples) 1) ind 0 -1)))
	     (if (not (= (sampler-position reader) (- (framples) 1))) (snd-display "sampler-position: ~A" (sampler-position reader)))
	     (map-channel (lambda (y) (read-sample reader))))
	   (let ((e (make-env '(0 0 1 1 2 0) :length (+ 1 dur)))
		 (len (framples)))
	     (let ((v0 (make-float-vector len))
		   (v1 (samples 0 len ind 0)))
	       (outa->fv v0 (env e))
	       (if (not (mus-arrays-equal? v0 v1))
		   (snd-display "~%;trouble in reverse read ~A ~A" v0 v1))))
	   (revert-sound))
	 '(150 1500 150000))
	(close-sound ind))
      (let ((ind (new-sound "test.snd" 1 22050 mus-ldouble mus-next)))
	(insert-silence 0 1000)
	(map-channel (lambda (y) 1.0))
	(env-sound '(0 0 1 1 2 0))
	(scale-channel 0.0 100 200)
	(let ((reader (make-sampler (- (framples) 1) ind 0 -1)))
	  (map-channel (lambda (y) (read-sample reader))))
	(let ((e (make-env '(0 0 1 1 2 0) :length 1001))
	      (new-reader (make-sampler 0 ind 0))
	      (len (framples)))
	  (call-with-exit
	   (lambda (quit)
	     (do ((old (env e) (env e))
		  (new (read-sample new-reader) (read-sample new-reader))
		  (i 0 (+ i 1)))
		 ((= i len))
	       (when (or (and (or (> i 900) (<= i 700))
			      (fneq old new))
			 (and (> i 700) (<= i 900)
			      (fneq new 0.0)))
		 (format () "~%;trouble in reverse read 2 at ~D ~A ~A" i old new)
		 (quit))))))
	(close-sound ind))
      (let ((ind (new-sound "test.snd" 1 22050 mus-ldouble mus-next)))
	(insert-silence 0 150000)
	(map-channel (lambda (y) 1.0))
	(let ((edpos (edit-position)))
	  (do ((i 0 (+ i 1)))
	      ((= i 7))
	    (if (= i 5)
		(scale-channel 0.5 1000 12345))
	    (env-sound '(0 0 1 1 2.5 0 3 1 4 0))
	    (case i
	      ((1) (delete-samples 50 100))
	      ((2) (insert-samples 300 100 (make-float-vector 100 0.5)))
	      ((3) (scale-channel 0.0 1000 1000))
	      ((4) (float-vector->channel (make-float-vector 100 0.5) 500 100))
	      ((6) (env-sound '(0 1 1 0) 10000 2000)))
	    (let ((reader (make-sampler (- (framples) 1) ind 0 -1)))
	      (map-channel (lambda (y) (read-sample reader))))
	    (let ((reader (make-sampler (- (framples) 1) ind 0 -1)))
	      (map-channel (lambda (y) (read-sample reader))))
	    (let ((len (framples)))
	      (let ((v0 (samples 0 len ind 0 (- (edit-position ind 0) 2)))
		    (v1 (samples 0 len ind 0)))
		(if (not (mus-arrays-equal? v0 v1))
		    (snd-display "~%;trouble in reverse read ~A ~A" v0 v1))))
	    (set! (edit-position ind 0) edpos)))
	(close-sound ind))
      (let ((reader #f)
	    (last-proc #f))
	(define (scan-again)
	  (and (not (sampler-at-end? reader))
	       (let ((val (last-proc (reader))))
		 (if val 
		     (list val (- (sampler-position reader) 1))
		     (scan-again)))))
	(define* (my-scan-channel proc)
	  (when proc 
	    (set! last-proc proc)
	    (set! reader (make-sampler 0)))
	  (scan-again))
	(let ((ind (open-sound "oboe.snd"))
	      (val #f))
	  (let ((samp (sample 1000)))
	    (set! (cursor ind 0) 1000)
	    (if (fneq (sample) samp)
		(snd-display "sample no args: ~A ~A" (sample) samp)))
	  (set! val (my-scan-channel (lambda (y) (> y .1))))
	  (if (not (equal? val '(#t 4423)))
	      (snd-display "my-scan-chan: ~A" val))
	  (set! val (scan-again))
	  (if (not (equal? val '(#t 4463)))
	      (snd-display "scan-again: ~A" val))
	  (set! (cursor) 1000)
	  (set! (sample) .5)
	  (if (fneq (sample 1000) .5)
	      (snd-display "set sample no arg: ~A ~A" (sample 1000) (sample 0)))
	  (close-sound ind)))
      
      ;; edit-menu.scm tests
      (when (defined? 'selection->new)
	(let ((ind (view-sound "oboe.snd")))
	  (make-selection 1000 1999 ind 0)
	  (let ((newsnd (selection->new)))
	    (if (not (sound? newsnd)) (snd-display "selection->new -> ~A" newsnd))
	    (if (not (= (framples newsnd 0) 1000)) (snd-display "selection->new framples: ~A" (framples newsnd 0)))
	    (if (not (equal? (edits ind 0) '(0 0))) (snd-display "selection->new edited original? ~A" (edits ind 0)))
	    (let ((newfile (file-name newsnd)))
	      (close-sound newsnd)
	      (delete-file newfile)
	      (mus-sound-forget newfile)))
	  (make-selection 1000 1999 ind 0)
	  (let ((newsnd (cut-selection->new)))
	    (if (not (sound? newsnd)) (snd-display "cut-selection->new -> ~A" newsnd))
	    (if (not (= (framples newsnd 0) 1000)) (snd-display "cut-selection->new framples: ~A" (framples newsnd 0)))
	    (if (not (equal? (edits ind 0) '(1 0))) (snd-display "cut-selection->new did not edit original? ~A" (edits ind 0)))
	    (if (not (= (framples ind 0) (- (framples ind 0 0) 1000))) 
		(snd-display "cut-selection->new cut: ~A ~A" (framples ind 0) (- (framples ind 0 0) 1000)))
	    (undo 1 ind 0)
	    (let ((newfile (file-name newsnd)))
	      (close-sound newsnd)
	      (delete-file newfile)
	      (mus-sound-forget newfile)))
	  (make-selection 1000 1999 ind 0)
	  (append-selection)
	  (if (not (= (framples ind 0) (+ (framples ind 0 0) 1000)))
	      (snd-display "append-selection: ~A ~A" (framples ind 0) (framples ind 0 0)))
	  (let ((append-sound (lambda (filename)
				(insert-sound filename (framples)))))
	    (append-sound "oboe.snd")
	    (if (not (= (framples ind 0) (+ (* 2 (framples ind 0 0)) 1000)))
		(snd-display "append-sound: ~A ~A" (framples ind 0) (framples ind 0 0))))
	  (revert-sound ind)
	  (let ((m1 (add-mark 1000))
		(m2 (add-mark 12000)))
	    (trim-front)
	    (if (not (equal? (edits ind 0) '(1 0))) (snd-display "time-front did not edit original? ~A" (edits ind 0)))
	    (if (not (= (framples ind 0) (- (framples ind 0 0) 1000))) 
		(snd-display "trim-front: ~A ~A" (framples ind 0) (- (framples ind 0 0) 1000)))
	    (if (not (= (mark-sample m2) 11000)) (snd-display "trim-front m2: ~A" (mark-sample m2)))
	    (undo 1 ind 0)
	    (trim-back)
	    (if (not (equal? (edits ind 0) '(1 0))) (snd-display "time-back did not edit original? ~A" (edits ind 0)))
	    (if (not (= (framples ind 0) 12001)) (snd-display "trim-back: ~A" (framples ind 0)))
	    (if (not (= (mark-sample m1) 1000)) (snd-display "trim-back m1: ~A" (mark-sample m1))))
	  (undo 1 ind 0)
	  (add-mark 22000)
	  (crop)
	  (if (not (equal? (edits ind 0) '(1 0))) (snd-display "crop did not edit original? ~A" (edits ind 0)))
	  (if (not (= (framples ind 0) 21001)) (snd-display "crop: ~A" (framples ind 0)))
	  (undo 1 ind 0)
	  (close-sound ind)))
      
      (let ((ind (new-sound "test.snd"))
	    (check-maxamp 
	     (lambda (caller-line ind val name)
	       (if (fneq (maxamp ind 0) val) (snd-display "maxamp amp-env ~A: ~A should be ~A" name (maxamp ind) val))
	       (let ((pos (scan-channel (lambda (y) (>= (abs y) (- val .0001)))))
		     (maxpos (maxamp-position ind 0)))
		 (if (not pos) 
		     (snd-display "actual maxamp ~A vals not right" name)
		     (if (not (= maxpos pos))
			 (snd-display "~A: find and maxamp-position disagree: ~A (~A) ~A (~A)" 
				      name pos (sample pos ind 0) maxpos (sample maxpos ind 0))))
		 (let ((info (float-vector-peak-and-location (samples 0 (framples ind) ind))))
		   (let ((mpos (cadr info))
			 (mx (car info)))
		     (if (not (= mpos maxpos))
			 (snd-display "(~D) scan and maxamp-position disagree: ~A ~A" caller-line mpos maxpos))
		     (if (fneq mx val) (snd-display "(~D) actual ~A max: ~A (correct: ~A)" caller-line name mx val))))))))
	(map-channel (lambda (y) 1.0) 0 1001)
	(env-channel (make-env '(0 1 1 1) :scaler .5 :length 1001))
	(check-maxamp 0 ind .5 "simple scaler")

	(let ((check-env-vals 
	       (lambda (name gen)
		 (let ((len (framples))
		       (reader (make-sampler)))
		   (do ((i 0 (+ i 1)))
		       ((or (= i len)
			    (let ((val (env gen))
				  (y (next-sample reader)))
			      (and (fneq val y)
				   (or (snd-display "~%;check-env-vals ~A at ~D: ~A ~A" name i val y)
				       #t))))))))))
	  (check-env-vals "simple scaler" (make-env '(0 1 1 1) :scaler .5 :length 1001))
	  (if (= (edit-position) 2)
	      (undo)
	      (snd-display "env+scl was no-op"))
	  (env-channel (make-env '(0 1 1 1) :offset .5 :length 1001))
	  (check-maxamp 1 ind 1.5 "simple offset")
	  (check-env-vals "simple offset" (make-env '(0 1 1 1) :offset .5 :length 1001))
	  (if (= (edit-position) 2)
	      (undo)
	      (snd-display "env+offset was no-op"))
	  (env-channel (make-env '(0 0 1 1 2 0) :offset .5 :scaler 2.0 :length 1001))
	  (check-maxamp 2 ind 2.5 "off+scl")
	  (check-env-vals "off+scl" (make-env '(0 0 1 1 2 0) :offset .5 :scaler 2.0 :length 1001))
	  (undo)
	  (env-channel (make-env '(0 -0.5 1 0 2 -1) :offset .5 :scaler 2.0 :length 1001))
	  (check-maxamp 3 ind 1.5 "off+scl #2")
	  (let ((mx -12.0))
	    (scan-channel (lambda (y) (not (set! mx (max mx y)))))
	    (if (fneq mx 0.5) (snd-display "non abs max: ~A (correct: 0.5)" mx)))
	  (check-env-vals "off+scl #2" (make-env '(0 -0.5 1 0 2 -1) :offset .5 :scaler 2.0 :length 1001))
	  (undo)
	  (env-sound '(0 .5 1 .75 2 .25) 0 (framples) 32.0)
	  (check-maxamp 4 ind 0.75 "xramp")
	  (check-env-vals "xramp" (make-env '(0 .5 1 .75 2 .25) :base 32.0 :length 1001))
	  (undo)
	  (env-channel-with-base '(0 .5 1 .75 2 .25) 32.0)
	  (check-maxamp 5 ind 0.75 "xramp1")
	  (check-env-vals "xramp1" (make-env '(0 .5 1 .75 2 .25) :base 32.0 :length 1001)))
	(close-sound ind))
      
      (let ((hlb (make-hilbert-transform 8))
	    (data (make-float-vector 20)))
	(do ((i 0 (+ i 1)))
	    ((= i 20))
	  (set! (data i) (hilbert-transform hlb (if (= i 0) 1.0 0.0))))
	(if (not (mus-arrays-equal? data #r(0.0 -0.010 0.0 -0.046 0.0 -0.152 0.0 -0.614 0.0 0.614 0.0 0.152 0.0 0.046 0.0 0.010 0.0 0.0 0.0 0.0)))
	    (snd-display "hilbert-transform 8 impulse response: ~A" data)))
      
      (let ((hlb (make-hilbert-transform 7))
	    (data (make-float-vector 20)))
	(do ((i 0 (+ i 1)))
	    ((= i 20))
	  (set! (data i) (hilbert-transform hlb (if (= i 0) 1.0 0.0))))
	(if (not (mus-arrays-equal? data #r(-0.007 0.0 -0.032 0.0 -0.136 0.0 -0.608 0.0 0.608 0.0 0.136 0.0 0.032 0.0 0.007 0.0 0.0 0.0 0.0 0.0)))
	    (snd-display "hilbert-transform 7 impulse response: ~A" data)))
      
      (let ((ind (new-sound "test.snd")))
	(pad-channel 0 1000)
	(set! (sample 100) 1.0)
	
	(let ((h (make-hilbert-transform 100)))
	  (do ((i 0 (+ i 1))) ((= i 4)) (map-channel (lambda (y) (hilbert-transform h y)))))
	;; now ideally we'd be back to an impulse
	(if (> (abs (- (sample 500) .98)) .01)
	    (snd-display "hilbert impulse: ~A" (sample 500)))
	(set! (sample 500) 0.0)
	(if (> (maxamp ind 0) .02)
	    (snd-display "hilbert sidelobes: ~A" (maxamp ind 0)))
	(scale-channel 0.0)
	(set! (sample 100) 1.0)
	
	(let ((h (make-hilbert-transform 101)))
	  (do ((i 0 (+ i 1))) ((= i 4)) (map-channel (lambda (y) (hilbert-transform h y)))))
	(if (> (abs (- (sample 504) .98)) .01)
	    (snd-display "hilbert 101 impulse: ~A: ~A" (sample 504) (channel->float-vector 498 10)))
	(set! (sample 504) 0.0)
	(if (> (maxamp ind 0) .02)
	    (snd-display "hilbert 101 sidelobes: ~A" (maxamp ind 0)))
	(revert-sound)
	
	(pad-channel 0 1000)
	(set! (sample 100) 1.0)
	(let ((lo (make-lowpass (* .1 pi) 20))
	      (hi (make-highpass (* .1 pi) 20)))
	  (map-channel (lambda (y) (+ (lowpass lo y) (highpass hi y)))))
	(if (fneq (sample 120) 1.0)
	    (snd-display "lowpass+highpass impulse: ~A" (sample 120)))
	(set! (sample 120) 0.0)
	(if (fneq (maxamp ind 0) 0.0)
	    (snd-display "lowpass+highpass sidelobes: ~A" (maxamp ind 0)))
	(undo 2)
	(let ((lo (make-bandpass (* .1 pi) (* .2 pi) 20))
	      (hi (make-bandstop (* .1 pi) (* .2 pi) 20)))
	  (map-channel (lambda (y) (+ (bandpass lo y) (bandstop hi y)))))
	(if (fneq (sample 120) 1.0)
	    (snd-display "bandpass+bandstop impulse: ~A" (sample 120)))
	(set! (sample 120) 0.0)
	(if (fneq (maxamp ind 0) 0.0)
	    (snd-display "bandpass+bandstop sidelobes: ~A" (maxamp ind 0)))
	(close-sound ind))
      
      (let ((ind (new-sound "test.snd"))
	    (make-bandpass-2 
	     (lambda* (flo1 fhi1 flo2 fhi2 (len 30))
	       (let ((f1 (make-bandpass flo1 fhi1 len))
		     (f2 (make-bandpass flo2 fhi2 len)))
		 (float-vector-add! (mus-xcoeffs f1) (mus-xcoeffs f2))
		 f1))))
	(map-channel (lambda (y) (mus-random 1.0)) 0 10000)
	(let ((f2 (make-bandpass-2 (* .12 pi) (* .15 pi) (* .22 pi) (* .25 pi) 100)))
	  (map-channel (lambda (y) (fir-filter f2 y)))
	  (let ((data (channel->float-vector)))
	    (undo)
	    (let ((f1 (make-bandpass (* .12 pi) (* .15 pi) 100))
		  (f2 (make-bandpass (* .22 pi) (* .25 pi) 100)))
	      (map-channel (lambda (y) (+ (fir-filter f1 y) (fir-filter f2 y))))
	      (let ((data1 (channel->float-vector)))
		(float-vector-subtract! data data1)
		(if (> (float-vector-peak data) .00001)
		    (snd-display "fir-filter 2: ~A" (float-vector-peak data))))
	      (undo))))
	(close-sound ind))
      
      (reset-all-hooks)
      
      (let ((ind (new-sound  "test.snd" 1 22050 mus-ldouble mus-next "first ramp re-order tests" 100)))
	(map-channel (lambda (y) 1.0))
	(for-each
	 (lambda (lst)
	   (let ((name (car lst))
		 (try-scale (cadr lst))
		 (f1 (caddr lst))
		 (f2 (cadddr lst))
		 (edpos (edit-position ind 0)))
	     (f1)
	     (let ((v1 (channel->float-vector 0 100 ind 0)))
	       (set! (edit-position ind 0) edpos)
	       (f2)
	       (let ((v2 (channel->float-vector 0 100 ind 0)))
		 (if (not (mus-arrays-equal? v1 v2))
		     (snd-display "env reordering test ~A:~%; ~A~%; ~A" name v1 v2))
		 (set! (edit-position ind 0) edpos)))
	     (if try-scale
		 (begin
		   (scale-by 2.0)
		   (f1)
		   (let ((v1 (channel->float-vector 0 100 ind 0)))
		     (set! (edit-position ind 0) edpos)
		     (f2)
		     (scale-by 2.0)
		     (let ((v2 (channel->float-vector 0 100 ind 0)))
		       (if (not (mus-arrays-equal? v1 v2))
			   (snd-display "scaled (2) env reordering test ~A:~%; ~A~%; ~A" name v1 v2))
		       (set! (edit-position ind 0) edpos)))
		   (f1)
		   (scale-by .5)
		   (let ((v1 (channel->float-vector 0 100 ind 0)))
		     (set! (edit-position ind 0) edpos)
		     (scale-by .5)
		     (f2)
		     (let ((v2 (channel->float-vector 0 100 ind 0)))
		       (if (not (mus-arrays-equal? v1 v2))
			   (snd-display "scaled (.5) env reordering test ~A:~%; ~A~%; ~A" name v1 v2))
		       (set! (edit-position ind 0) edpos)))))))
	 
	 (list (list "ramp-xramp" #t
		     (lambda ()
		       (env-sound '(0 0 1 1 2 0))
		       (env-sound '(0 0 1 1) 0 100 2.0))
		     (lambda ()
		       (env-sound '(0 0 1 1) 0 100 2.0)
		       (env-sound '(0 0 1 1 2 0))))
	       (list "ramp2-xramp (1)" #t
		     (lambda ()
		       (env-sound '(0 0 1 1 2 0))
		       (env-sound '(0 0 1 1 3 0))
		       (env-sound '(0 0 1 1) 0 100 2.0))
		     (lambda ()
		       (env-sound '(0 0 1 1 2 0))
		       (env-sound '(0 0 1 1) 0 100 2.0)
		       (env-sound '(0 0 1 1 3 0))))
	       (list "ramp2-xramp (2)" #t
		     (lambda ()
		       (env-sound '(0 0 1 1 2 0))
		       (env-sound '(0 0 1 1))
		       (env-sound '(0 0 1 1 3 0) 0 100 2.0))
		     (lambda ()
		       (env-sound '(0 0 1 1 3 0) 0 100 2.0)
		       (env-sound '(0 0 1 1 2 0))
		       (env-sound '(0 0 1 1))))
	       (list "xramp2-ramp (1)" #t
		     (lambda ()
		       (env-sound '(0 0 1 1 2 0) 0 100 2.0)
		       (env-sound '(0 0 1 1))
		       (env-sound '(0 0 1 1 3 0) 0 100 3.0))
		     (lambda ()
		       (env-sound '(0 0 1 1 2 0) 0 100 2.0)
		       (env-sound '(0 0 1 1 3 0) 0 100 3.0)
		       (env-sound '(0 0 1 1))))
	       (list "xramp2-ramp (2)" #t
		     (lambda ()
		       (env-sound '(0 0 1 1 2 0) 0 100 2.0)
		       (env-sound '(0 0 1 1 3 0))
		       (env-sound '(0 0 1 1) 0 100 3.0))
		     (lambda ()
		       (env-sound '(0 0 1 1 3 0))
		       (env-sound '(0 0 1 1 2 0) 0 100 2.0)
		       (env-sound '(0 0 1 1) 0 100 3.0)))
	       ))
	(close-sound ind))
      )) ; end of clm-test do loop I think
  
  (let ((ind (open-sound "oboe.snd")))
    ;; simple cases
    
    (as-one-edit
     (lambda ()
       (set! (sample 10) 1.0)))
    (if (fneq (sample 10) 1.0) (snd-display "as-one-edit 1: ~A" (sample 10)))
    (if (not (= (edit-position ind 0) 1)) 
	(snd-display "as-one-edit 1 edpos: ~A" (edit-position ind 0))
	(begin
	  (if (not (equal? (edit-fragment 1 ind 0) '("set-sample 10 1.0000" "set" 10 1)))
	      (snd-display "as-one-edit 1 edlist: ~A" (edit-fragment 1 ind 0)))
	  (if (not (equal? (edit-fragment 0 ind 0) '("" "init" 0 50828)))
	      (snd-display "as-one-edit 1 original edlist: ~A" (edit-fragment 0 ind 0)))))
    
    (revert-sound ind)
    (as-one-edit
     (lambda ()
       (set! (sample 10) 1.0)
       (map-channel (lambda (y) (* y 2.0)) 0 20 ind 0 #f "map-channel as-one-edit")
       (if (not (= (edit-position ind 0) 2)) (snd-display "as-one-edit 2 edpos internal: ~A" (edit-position ind 0))))
     "as-one-edit test-2")
    (if (fneq (sample 10) 2.0) (snd-display "as-one-edit 2: ~A" (sample 10)))
    (if (not (= (edit-position ind 0) 1)) 
	(snd-display "as-one-edit 2 edpos: ~A" (edit-position ind 0))
	(if (not (equal? (edit-fragment 0 ind 0) '("" "init" 0 50828)))
	    (snd-display "as-one-edit 2 original edlist: ~A" (edit-fragment 0 ind 0))))
    
    (revert-sound ind)
    (let ((ind2 (open-sound "2a.snd")))
      (set! (sample 1 ind2 0) 1.0)
      (set! (sample 2 ind2 1) 0.5)
      (set! (selected-sound) ind)
      
      (as-one-edit
       (lambda ()
	 (set! (sample 10 ind 0) 1.0)))
      (if (fneq (sample 10 ind 0) 1.0) (snd-display "as-one-edit 3: ~A" (sample 10 ind 0)))
      (if (not (= (edit-position ind 0) 1)) (snd-display "as-one-edit 3 edpos: ~A" (edit-position ind 0)))
      (if (not (= (edit-position ind2 0) 1)) (snd-display "as-one-edit 3 2 edpos: ~A" (edit-position ind2 0)))
      (if (not (= (edit-position ind2 1) 1)) (snd-display "as-one-edit 3 2 1 edpos: ~A" (edit-position ind2 1)))
      (if (not (equal? (edit-fragment 1 ind 0) '("set-sample 10 1.0000" "set" 10 1)))
	  (snd-display "as-one-edit 3 edlist: ~A" (edit-fragment 1 ind 0)))
      (if (not (equal? (edit-fragment 1 ind2 0) '("set-sample 1 1.0000" "set" 1 1)))
	  (snd-display "as-one-edit 3 2 edlist: ~A" (edit-fragment 1 ind2 0)))
      (if (not (equal? (edit-fragment 1 ind2 1) '("set-sample 2 0.5000" "set" 2 1)))
	  (snd-display "as-one-edit 3 2 1 edlist: ~A" (edit-fragment 1 ind2 1)))
      
      (revert-sound ind)
      
      (as-one-edit    
       (lambda ()
	 (set! (sample 10 ind 0) 1.0)
	 (map-channel (lambda (y) (* y 2.0)) 0 20 ind 0 #f "map-channel as-one-edit 2")
	 (if (not (= (edit-position ind 0) 2)) (snd-display "as-one-edit 4 edpos internal: ~A" (edit-position ind 0))))
       "as-one-edit test-4")
      (if (fneq (sample 10) 2.0) (snd-display "as-one-edit 4: ~A" (sample 10 ind 0)))
      (if (not (= (edit-position ind 0) 1)) 
	  (snd-display "as-one-edit 4 edpos: ~A" (edit-position ind 0)))
      (if (not (equal? (edit-fragment 1 ind2 0) '("set-sample 1 1.0000" "set" 1 1)))
	  (snd-display "as-one-edit 3 2 edlist: ~A" (edit-fragment 1 ind2 0)))
      (if (not (equal? (edit-fragment 1 ind2 1) '("set-sample 2 0.5000" "set" 2 1)))
	  (snd-display "as-one-edit 3 2 1 edlist: ~A" (edit-fragment 1 ind2 1)))
      
      (revert-sound ind)
      (set! (sample 3 ind 0) 1.0)
      
      (as-one-edit
       (lambda ()
	 (set! (sample 10 ind 0) 1.0)
	 (set! (sample 10 ind2 0) 0.5)
	 (set! (sample 10 ind2 1) 0.4)))
      (if (fneq (sample 3 ind 0) 1.0) (snd-display "as-one-edit 5 (3): ~A" (sample 3 ind 0)))
      (if (fneq (sample 10 ind 0) 1.0) (snd-display "as-one-edit 5 (10): ~A" (sample 10 ind 0)))
      (if (fneq (sample 10 ind2 0) 0.5) (snd-display "as-one-edit 5 (2 10): ~A" (sample 10 ind2 0)))
      (if (fneq (sample 10 ind2 1) 0.4) (snd-display "as-one-edit 5 (2 1 10): ~A" (sample 10 ind2 1)))
      (if (not (= (edit-position ind 0) 2)) (snd-display "as-one-edit 5 edpos: ~A" (edit-position ind 0)))
      (if (not (= (edit-position ind2 0) 2)) (snd-display "as-one-edit 5 2 edpos: ~A" (edit-position ind2 0)))
      (if (not (= (edit-position ind2 1) 2)) (snd-display "as-one-edit 5 2 1 edpos: ~A" (edit-position ind2 1)))
      
      (if (not (equal? (edit-fragment 2 ind 0) '("set-sample 10 1.0000" "set" 10 1)))
	  (snd-display "as-one-edit 5 edlist 2: ~A" (edit-fragment 1 ind 0)))
      (if (not (equal? (edit-fragment 1 ind 0) '("set-sample 3 1.0000" "set" 3 1)))
	  (snd-display "as-one-edit 5 edlist 1: ~A" (edit-fragment 1 ind 0)))
      (if (not (equal? (edit-fragment 0 ind 0) '("" "init" 0 50828)))
	  (snd-display "as-one-edit 5 original edlist: ~A" (edit-fragment 0 ind 0)))
      (if (not (equal? (edit-fragment 2 ind2 0) '("set-sample 10 0.5000" "set" 10 1)))
	  (snd-display "as-one-edit 5 edlist 2 1: ~A" (edit-fragment 1 ind2 0)))
      
      (as-one-edit
       (lambda ()
	 (map-channel (lambda (y) (* y 2.0)) 0 20 ind 0 #f "map-channel as-one-edit 6")
	 (map-channel (lambda (y) (* y 2.0)) 0 20 ind2 1 #f "map-channel as-one-edit 6 2 1"))
       "as-one-edit test-6")
      
      
      (if (fneq (sample 3 ind 0) 2.0) (snd-display "as-one-edit 6 (3): ~A" (sample 3 ind 0)))
      (if (fneq (sample 10 ind 0) 2.0) (snd-display "as-one-edit 6 (10): ~A" (sample 10 ind 0)))
      (if (fneq (sample 10 ind2 0) 0.5) (snd-display "as-one-edit 6 (2 10): ~A" (sample 10 ind2 0)))
      (if (fneq (sample 10 ind2 1) 0.8) (snd-display "as-one-edit 6 (2 1 10): ~A" (sample 10 ind2 1)))
      (if (not (= (edit-position ind 0) 3)) (snd-display "as-one-edit 6 edpos: ~A" (edit-position ind 0)))
      (if (not (= (edit-position ind2 0) 2)) (snd-display "as-one-edit 6 2 edpos: ~A" (edit-position ind2 0)))
      (if (not (= (edit-position ind2 1) 3)) (snd-display "as-one-edit 6 2 1 edpos: ~A" (edit-position ind2 1)))
      
      (if (not (equal? (edit-fragment 2 ind 0) '("set-sample 10 1.0000" "set" 10 1)))
	  (snd-display "as-one-edit 5 edlist 2: ~A" (edit-fragment 1 ind 0)))
      (if (not (equal? (edit-fragment 2 ind2 0) '("set-sample 10 0.5000" "set" 10 1)))
	  (snd-display "as-one-edit 5 edlist 2 1: ~A" (edit-fragment 1 ind2 0)))
      (close-sound ind2))
    
    ;; nested cases
    (revert-sound ind)
    
    (as-one-edit
     (lambda ()
       (set! (sample 100) .9)
       (as-one-edit
	(lambda ()
	  (set! (sample 200) .8)
	  (set! (sample 300) .7)))
       (set! (sample 300) .6)))
    (if (or (fneq (sample 100) .9)
	    (fneq (sample 200) .8)
	    (fneq (sample 300) .6))
	(snd-display "nested as-one-edit 7: ~A ~A ~A" (sample 100) (sample 200) (sample 300)))
    (if (not (= (edit-position ind 0) 1))
	(snd-display "nested as-one-edit 7 edpos: ~A" (edit-position ind 0)))
    (when (squelch-update ind 0)
      (snd-display "nested as-one-edit 7 squelch is on")
      (set! (squelch-update) #f))
    (if (not (equal? (edit-fragment 1 ind 0) '("set-sample 300 0.6000" "set" 100 204)))
	(snd-display "as-one-edit 7 edlist: ~A" (edit-fragment 1 ind 0)))
    
    (revert-sound ind)
    (as-one-edit
     (lambda ()
       (set! (sample 100) .9)
       (as-one-edit
	(lambda ()
	  (set! (sample 200) .8)
	  (set! (sample 300) .7)))
       (set! (sample 300) .6))
     "as-one-edit test-8")
    (if (or (fneq (sample 100) .9)
	    (fneq (sample 200) .8)
	    (fneq (sample 300) .6))
	(snd-display "nested as-one-edit 8: ~A ~A ~A" (sample 100) (sample 200) (sample 300)))
    (if (not (= (edit-position ind 0) 1))
	(snd-display "nested as-one-edit 8 edpos: ~A" (edit-position ind 0)))
    (if (not (equal? (edit-fragment 1 ind 0) '("as-one-edit test-8" "set" 100 204)))
	(snd-display "as-one-edit 8 edlist: ~A" (edit-fragment 1 ind 0)))
    
    (revert-sound ind)
    (as-one-edit
     (lambda ()
       (set! (sample 100) .9)
       (as-one-edit
	(lambda ()
	  (set! (sample 200) .8)
	  (set! (sample 300) .7))
	"as-one-edit 9 internal")
       (set! (sample 300) .6))
     "as-one-edit test-9")
    (if (or (fneq (sample 100) .9)
	    (fneq (sample 200) .8)
	    (fneq (sample 300) .6))
	(snd-display "nested as-one-edit 9: ~A ~A ~A" (sample 100) (sample 200) (sample 300)))
    (if (not (= (edit-position ind 0) 1))
	(snd-display "nested as-one-edit 9 edpos: ~A" (edit-position ind 0)))
    (if (not (equal? (edit-fragment 1 ind 0) '("as-one-edit test-9" "set" 100 204)))
	(snd-display "as-one-edit 9 edlist: ~A" (edit-fragment 1 ind 0)))
    
    (revert-sound ind)
    (as-one-edit
     (lambda ()
       (set! (sample 100) .9)
       (as-one-edit
	(lambda ()
	  (set! (sample 200) .8)
	  (as-one-edit
	   (lambda ()
	     (set! (sample 400) .3))
	   "not a name")
	  (set! (sample 300) .7))
	"as-one-edit 10 internal")
       (set! (sample 300) .6))
     "as-one-edit test-10")
    (if (or (fneq (sample 100) .9)
	    (fneq (sample 200) .8)
	    (fneq (sample 300) .6)
	    (fneq (sample 400) .3))
	(snd-display "nested as-one-edit 10: ~A ~A ~A ~A" (sample 100) (sample 200) (sample 300) (sample 400)))
    (if (not (= (edit-position ind 0) 1))
	(snd-display "nested as-one-edit 10 edpos: ~A" (edit-position ind 0)))
    (if (not (equal? (edit-fragment 1 ind 0) '("as-one-edit test-10" "set" 100 305)))
	(snd-display "as-one-edit 10 edlist: ~A" (edit-fragment 1 ind 0)))
    
    ;; try implicit as-one-edits nested
    (revert-sound ind)
    (env-channel-with-base '(0 0 1 1 2 .5 3 .25 4 0) 0.0 0 #f ind 0)
    (if (not (= (edit-position ind 0) 1)) (snd-display "as-one-edit 11 edpos: ~A" (edit-position ind 0)))
    (if (not (equal? (edit-fragment 1 ind 0) 
		     '("env-channel-with-base '(0.000 0.000 1.000 1.000 2.000 0.500 3.000 0.250 4.000 0.000) 0.0000 0 #f" "scale" 0 50830)))
	(snd-display "as-one-edit 11: ~A" (edit-fragment 1 ind 0)))
    
    (revert-sound ind)
    (as-one-edit
     (lambda ()
       (env-channel-with-base '(0 0 1 1 2 .5 3 .25 4 0) 0.0 0 #f ind 0))
     "as-one-edit 12")
    (if (not (= (edit-position ind 0) 1)) (snd-display "as-one-edit 12 edpos: ~A" (edit-position ind 0)))
    (if (not (equal? (edit-fragment 1 ind 0) '("as-one-edit 12" "scale" 0 50830)))
	(snd-display "as-one-edit 12: ~A" (edit-fragment 1 ind 0)))
    
    (revert-sound ind)
    (let ((m1 #f)
	  (m2 #f)
	  (m3 #f)
	  (m4 #f))
      (as-one-edit
       (lambda ()
	 (set! m1 (add-mark 1234 ind 0))
	 (set! (sample 1236 ind 0) .6)
	 (as-one-edit
	  (lambda ()
	    (set! (sample 123 ind 0) .3)
	    (set! m2 (add-mark 1235 ind 0)))
	  "as-one-edit inner 1")
	 (if (not (mark? m1)) (snd-display "as-one-edit stepped on m1: ~A" m1))
	 (if (not (mark? m2)) (snd-display "as-one-edit stepped on m2: ~A" m2))
	 (as-one-edit
	  (lambda ()
	    (set! m3 (add-mark 1238 ind 0))
	    (set! (sample 1238 ind 0) .8))
	  "as-one-edit inner 2")
	 (set! (sample 1239 ind 0) .9)
	 (set! m4 (add-mark 1237 ind 0)))
       "outer as-one-edit")
      (if (not (mark? m1)) (snd-display "second as-one-edit stepped on m1: ~A" m1))
      (if (not (mark? m2)) (snd-display "second as-one-edit stepped on m2: ~A" m2))
      (if (not (mark? m3)) (snd-display "second as-one-edit stepped on m3: ~A" m3))
      (if (not (mark? m4)) (snd-display "second as-one-edit stepped on m4: ~A" m4))
      (if (not (= (mark-sample m1) 1234)) (snd-display "as-one-edit m1 sample: ~A (1234)" (mark-sample m1)))
      (if (not (= (mark-sample m2) 1235)) (snd-display "as-one-edit m2 sample: ~A (1235)" (mark-sample m2)))
      (if (not (= (mark-sample m3) 1238)) (snd-display "as-one-edit m3 sample: ~A (1238)" (mark-sample m3)))
      (if (not (= (mark-sample m4) 1237)) (snd-display "as-one-edit m4 sample: ~A (1237)" (mark-sample m4))))
    (if (not (string=? (display-edits ind 0) (string-append "
EDITS: 1

 (begin) [0:2]:
   (at 0, cp->sounds[0][0:50827, 1.000]) [file: " cwd "oboe.snd[0]]
   (at 50828, end_mark)

 (set 123 1120) ; outer as-one-edit [1:9]:
   (at 0, cp->sounds[0][0:122, 1.000]) [file: " cwd "oboe.snd[0]]
   (at 123, cp->sounds[2][0:0, 1.000]) [buf: 1] 
   (at 124, cp->sounds[0][124:1235, 1.000]) [file: " cwd "oboe.snd[0]]
   (at 1236, cp->sounds[1][0:0, 1.000]) [buf: 1] 
   (at 1237, cp->sounds[0][1237:1237, 1.000]) [file: " cwd "oboe.snd[0]]
   (at 1238, cp->sounds[3][0:0, 1.000]) [buf: 1] 
   (at 1239, cp->sounds[4][0:0, 1.000]) [buf: 1] 
   (at 1240, cp->sounds[0][1240:50827, 1.000]) [file: " cwd "oboe.snd[0]]
   (at 50828, end_mark)
")))
	(snd-display "as-one-edit edits: ~A" (display-edits ind 0)))
    (revert-sound ind)
    
    (let ((m4 #f))
      (let ((m3 #f))
	(let ((m2 #f))
	  (let ((m1 #f))
	    (as-one-edit
	     (lambda ()
	       (set! m1 (mix-float-vector #r(.1 .2 .3) 1234 ind 0))
	       (set! (sample 1236 ind 0) .6)
	       (as-one-edit
		(lambda ()
		  (set! (sample 123 ind 0) .3)
		  (set! m2 (mix-float-vector #r(.1 .2 .3) 1235 ind 0)))
		"as-one-edit inner 1")
	       (if (not (mix? m1)) (snd-display "as-one-edit stepped on m1: ~A" m1))
	       (if (not (mix? m2)) (snd-display "as-one-edit stepped on m2: ~A" m2))
	       (as-one-edit
		(lambda ()
		  (set! m3 (mix-float-vector #r(.1 .2 .3) 1238 ind 0))
		  (set! (sample 1238 ind 0) .8))
		"as-one-edit inner 2")
	       (set! (sample 1239 ind 0) .9)
	       (set! m4 (mix-float-vector #r(.1 .2 .3) 1237 ind 0)))
	     "outer as-one-edit")
	    (if (not (mix? m1)) (snd-display "second as-one-edit stepped on mx1: ~A" m1)))
	  (if (not (mix? m2)) (snd-display "second as-one-edit stepped on mx2: ~A" m2)))
	(if (not (mix? m3)) (snd-display "second as-one-edit stepped on mx3: ~A" m3)))
      (if (not (mix? m4)) (snd-display "second as-one-edit stepped on mx4: ~A" m4))
      (revert-sound ind))
    
    (let ((ind2 #f))
      (as-one-edit
       (lambda ()
	 (set! ind2 (open-sound "pistol.snd"))
	 (set! (sample 100 ind 0) .5)
	 (set! (sample 200 ind2 0) .6))
       "as-one-edit+open")
      (if (not (sound? ind2)) (snd-display "as-one-edit didn't open sound? ~A ~A" ind2 (sounds)))
      (if (not (= (edit-position ind2 0) 1)) (snd-display "edpos as-one-edit opened sound: ~A" (edit-position ind2 0)))
      (if (not (= (edit-position ind 0) 1)) (snd-display "edpos as-one-edit original sound: ~A" (edit-position ind 0)))
      (if (not (equal? (edit-fragment 1 ind 0) '("as-one-edit+open" "set" 100 1)))
	  (snd-display "as-one-edit open sound edlist orig: ~A" (edit-fragment 1 ind 0)))
      (if (not (equal? (edit-fragment 1 ind2 0) '("set-sample 200 0.6000" "set" 200 1)))
	  (snd-display "as-one-edit open sound edlist new: ~A" (edit-fragment 1 ind2 0)))
      
      (as-one-edit
       (lambda ()
	 (set! (sample 200 ind 0) .7)
	 (close-sound ind2))
       "as-one-edit+close")
      (when (sound? ind2) 
	(snd-display "as-one-edit didn't close sound? ~A ~A" ind2 (sounds))
	(close-sound ind2))
      (if (not (= (edit-position ind 0) 2)) (snd-display "edpos as-one-edit close original sound: ~A" (edit-position ind 0)))
      (if (not (string=? (display-edits ind 0) (string-append "
EDITS: 2

 (begin) [0:2]:
   (at 0, cp->sounds[0][0:50827, 1.000]) [file: " cwd "oboe.snd[0]]
   (at 50828, end_mark)

 (set 100 1) ; as-one-edit+open [1:4]:
   (at 0, cp->sounds[0][0:99, 1.000]) [file: " cwd "oboe.snd[0]]
   (at 100, cp->sounds[1][0:0, 1.000]) [buf: 1] 
   (at 101, cp->sounds[0][101:50827, 1.000]) [file: " cwd "oboe.snd[0]]
   (at 50828, end_mark)

 (set 200 1) ; as-one-edit+close [2:6]:
   (at 0, cp->sounds[0][0:99, 1.000]) [file: " cwd "oboe.snd[0]]
   (at 100, cp->sounds[1][0:0, 1.000]) [buf: 1] 
   (at 101, cp->sounds[0][101:199, 1.000]) [file: " cwd "oboe.snd[0]]
   (at 200, cp->sounds[2][0:0, 1.000]) [buf: 1] 
   (at 201, cp->sounds[0][201:50827, 1.000]) [file: " cwd "oboe.snd[0]]
   (at 50828, end_mark)
")))
	  (snd-display "as-one-edit open+close: ~A" (display-edits ind 0))))
    
    (close-sound ind))  
  
  (let ((ind1 (open-sound "oboe.snd"))
	(ind2 #f))
    (as-one-edit 
     (lambda ()
       (set! (sample 100 ind1 0) .5)
       (set! ind2 (open-sound "pistol.snd"))
       (as-one-edit
	(lambda ()
	  (set! (sample 200 ind2 0) .5)
	  (close-sound ind1))
	"inner edit")
       (set! (sample 300 ind2 0) .6))
     "outer edit")
    (if (sound? ind1) (snd-display "as-one-edit close inner: ~A ~A" ind1 (sounds)))
    (if (not (sound? ind2)) (snd-display "as-one-edit open inner: ~A ~A" ind2 (sounds)))
    
    (revert-sound ind2)
    (as-one-edit
     (lambda ()
       (set! ind1 (open-sound "oboe.snd"))
       (as-one-edit
	(lambda ()
	  (set! (sample 200 ind1 0) .5))
	"inner edit")
       (set! (sample 100 ind2 0) .4))
     "outer edit")
    (close-sound ind1)
    (close-sound ind2))
  
  (let ((ind (open-sound "oboe.snd")))
    (let ((tag (catch #t
		 (lambda () (as-one-edit (lambda (oops) #f)))
		 (lambda args (car args)))))
      (if (not (eq? tag 'bad-arity))
	  (snd-display "lambda as-one-edit arg? ~A" tag)))
    (close-sound ind))
  (let ((ind (new-sound  "test.snd" 1 22050 mus-ldouble mus-next "more tests" 10)))
    ;; offset-channel
    (offset-channel .1)
    (if (not (mus-arrays-equal? (channel->float-vector 0 10) (make-float-vector 10 .1)))
	(snd-display "offset-channel (.1): ~A" (channel->float-vector 0 10)))
    (offset-channel -.2 5 5)
    (if (not (mus-arrays-equal? (channel->float-vector 0 10) #r(.1 .1 .1 .1 .1 -.1 -.1 -.1 -.1 -.1)))
	(snd-display "offset-channel (-.1): ~A" (channel->float-vector 0 10)))
    (undo)
    (offset-channel .9 0 10 ind 0)
    (if (not (mus-arrays-equal? (channel->float-vector 0 10) (make-float-vector 10 1.0)))
	(snd-display "offset-channel (1): ~A" (channel->float-vector 0 10)))
    ;; sine-env and sine-ramp...
    (revert-sound ind)
    (map-channel (lambda (y) 1.0))
    (sine-ramp 0.0 1.0)
    (if (not (mus-arrays-equal? (channel->float-vector) #r(0.000 0.024 0.095 0.206 0.345 0.500 0.655 0.794 0.905 0.976)))
	(snd-display "sine-ramp 0 1: ~A" (channel->float-vector)))
    (revert-sound ind)
    (offset-channel 1.0)
    (sine-ramp 1.0 0.0)
    (if (not (mus-arrays-equal? (channel->float-vector) #r(1.000 0.976 0.905 0.794 0.655 0.500 0.345 0.206 0.095 0.024)))
	(snd-display "sine-ramp 1 0: ~A" (channel->float-vector)))
    (close-sound ind))
  (let ((ind (new-sound  "test.snd" 1 22050 mus-ldouble mus-next "sine-env tests" 100)))
    (map-channel (lambda (y) 1.0))
    (sine-env-channel '(0 0 1 1 2 -.5 3 1))
    (if (not (= (edit-position ind 0) 2)) (snd-display "as-one-edit sine-env-channel: ~A" (edit-position ind 0)))
    (revert-sound ind)
    (offset-channel -1.0)
    (sine-env-channel '(0 0 1 1 2 1 3 0) 40 20)
    (if (not (and (mus-arrays-equal? (channel->float-vector 40 20) #r(-0.000 -0.050 -0.188 -0.389 -0.611 -0.812 -0.950 -1.000 -1.000 -1.000
								      -1.000 -1.000 -1.000 -1.000 -1.000 -0.950 -0.812 -0.611 -0.389 -0.188))
		  (mus-arrays-equal? (channel->float-vector 30 10) (make-float-vector 10 -1.0))))
	(snd-display "off+sine-env: ~A ~A" (channel->float-vector 40 20) (channel->float-vector 30 10)))
    (revert-sound ind)
    (scale-by 0.0)
    (dither-channel)
    (let ((mx (maxamp)))
      (if (not (<= 3e-05 mx 0.0001))
	  (snd-display "dithering: ~A" mx)))
    (revert-sound ind)
    (map-channel (ring-mod 10 (list 0 0 1 (hz->radians 100))))
    (osc-formants .99 #r(400.0 800.0 1200.0) #r(400.0 800.0 1200.0) #r(4.0 2.0 3.0))
    (map-channel (zecho .5 .75 6 10.0))
    (map-channel (flecho .5 .9))
    (filtered-env '(0 0 1 1 2 0))
    (map-channel (formant-filter .99 2400))
    (map-channel (comb-filter .8 32))
    (map-channel (zcomb .8 32 '(0 0 1 10)))
    (map-channel (notch-filter .8 32))
    (let ((ind1 (open-sound "now.snd")))
      (select-sound ind1)
      (if (fneq (maxamp) .309) (snd-display "squelch-vowels init: ~A" (maxamp)))
      (squelch-vowels)
      (if (fneq (maxamp) .047) (snd-display "squelch-vowels maxamp: ~A" (maxamp)))
      (select-sound ind)
      (map-channel (cross-synthesis ind1 .5 128 6.0))
      (revert-sound ind1)
      (fft-edit 40 8000)
      (fft-squelch .1)
      (close-sound ind)
      (revert-sound ind1)
      (scramble-channel .01)
      (revert-sound ind1)
      (close-sound ind1)))
  
  (let ((ind (new-sound  "test.snd" 1 22050 mus-ldouble mus-next "special env tests" 100)))
    (map-channel (lambda (y) 1.0))
    
    (blackman4-ramp 0.0 1.0)
    (let ((vals (channel->float-vector)))
      (undo)
      (blackman4-env-channel '(0 0 1 1))
      (let ((new-vals (channel->float-vector)))
	(if (not (mus-arrays-equal? vals new-vals))
	    (snd-display "blackman4-env-channel/ramp: ~A ~A" vals new-vals))))
    (undo)
    (blackman4-ramp 0.0 1.0 0 50)
    (let ((vals (channel->float-vector)))
      (undo)
      (blackman4-env-channel '(0 0 1 1 2 1))
      (let ((new-vals (channel->float-vector)))
	(if (not (mus-arrays-equal? vals new-vals))
	    (snd-display "blackman4-env-channel/ramp 1: ~A ~A" vals new-vals))))
    (undo)
    (blackman4-env-channel '(0 0 1 1 2 -.5 3 0))
    (if (not (mus-arrays-equal? (channel->float-vector 60 10) #r(-0.109 -0.217 -0.313 -0.392 -0.451 -0.488 -0.499 -0.499 -0.499 -0.499)))
	(snd-display "blackman4 to -.5: ~A" (channel->float-vector 60 10)))
    (undo)
      
    (ramp-squared 0.0 1.0)
    (let ((vals (channel->float-vector)))
      (undo)
      (env-squared-channel '(0 0 1 1))
      (let ((new-vals (channel->float-vector)))
	(if (not (mus-arrays-equal? vals new-vals))
	    (snd-display "env-squared/ramp: ~A ~A" vals new-vals))))
    (undo)
    (ramp-squared 0.0 1.0 #t 0 50)
    (let ((vals (channel->float-vector)))
      (undo)
      (env-squared-channel '(0 0 1 1 2 1))
      (let ((new-vals (channel->float-vector)))
	(if (not (mus-arrays-equal? vals new-vals))
	    (snd-display "env-squared/ramp 1: ~A ~A" vals new-vals))))
    (undo)
    (env-squared-channel '(0 0 1 1 2 -.5 3 0))
    (if (not (mus-arrays-equal? (channel->float-vector 60 10) #r(-0.450 -0.466 -0.478 -0.488 -0.494 -0.499 -0.500 -0.500 -0.498 -0.496)))
	(snd-display "env-squared to -.5: ~A" (channel->float-vector 60 10)))
    (undo)
    (env-squared-channel '(0 0 1 1 2 -.5 3 0) #f)
    (if (not (mus-arrays-equal? (channel->float-vector 60 10) #r(-0.004 -0.080 -0.158 -0.240 -0.324 -0.410 -0.500 -0.500 -0.498 -0.496)))
	(snd-display "env-squared unsymmetric to -.5: ~A" (channel->float-vector 60 10)))
    (undo)
      
    (ramp-squared 0.0 1.0)
    (let ((vals (channel->float-vector)))
      (undo)
      (env-expt-channel '(0 0 1 1) 2)
      (let ((new-vals (channel->float-vector)))
	(if (not (mus-arrays-equal? vals new-vals))
	    (snd-display "env-expt2/ramp: ~A ~A" vals new-vals))))
    (undo)
    (env-squared-channel '(0 0 1 1 2 -.5 3 0))
    (let ((vals (channel->float-vector)))
      (undo)
      (env-expt-channel '(0 0 1 1 2 -.5 3 0) 2.0)
      (let ((new-vals (channel->float-vector)))
	(if (not (mus-arrays-equal? vals new-vals))
	    (snd-display "env-expt2/env-squared: ~A ~A" vals new-vals))))
    (undo)
    (env-squared-channel '(0 0 1 1 2 -.5 3 0) #f)
    (let ((vals (channel->float-vector)))
      (undo)
      (env-expt-channel '(0 0 1 1 2 -.5 3 0) 2.0 #f)
      (let ((new-vals (channel->float-vector)))
	(if (not (mus-arrays-equal? vals new-vals))
	    (snd-display "env-expt2/env-squared unsymmetric: ~A ~A" vals new-vals))))
    (undo)
      
    (ramp-expt 0.0 1.0 32.0)
    (let ((vals (channel->float-vector)))
      (undo)
      (env-expt-channel '(0 0 1 1) 32.0)
      (let ((new-vals (channel->float-vector)))
	(if (not (mus-arrays-equal? vals new-vals))
	    (snd-display "env-expt/ramp 32: ~A ~A" vals new-vals))))
    (undo)
    (ramp-expt 0.0 1.0 32.0 #f 0 50)
    (let ((vals (channel->float-vector)))
      (undo)
      (env-expt-channel '(0 0 1 1 2 1) 32.0)
      (let ((new-vals (channel->float-vector)))
	(if (not (mus-arrays-equal? vals new-vals))
	    (snd-display "env-expt/ramp 1 32: ~A ~A" vals new-vals))))
    (undo)
    (ramp-expt 0.0 1.0 .1)
    (let ((vals (channel->float-vector)))
      (undo)
      (env-expt-channel '(0 0 1 1) .1)
      (let ((new-vals (channel->float-vector)))
	(if (not (mus-arrays-equal? vals new-vals))
	    (snd-display "env-expt/ramp .1: ~A ~A" vals new-vals))))
    (undo)
      
    (env-expt-channel '(0 0 1 1 2 -.5 3 0) 12.0)
    (if (not (mus-arrays-equal? (channel->float-vector 30 10) #r(0.319 0.472 0.691 1.000 0.537 0.208 -0.022 -0.182 -0.291 -0.365)))
	(snd-display "env-expt to -.5 12.0: ~A" (channel->float-vector 30 10)))
    (undo)
    (env-expt-channel '(0 0 1 1 2 -.5 3 0) 12.0 #f)
    (if (not (mus-arrays-equal? (channel->float-vector 30 10) #r(0.319 0.472 0.691 1.000 1.000 1.000 1.000 1.000 1.000 1.000)))
	(snd-display "env-expt to -.5 12.0 unsymmetric: ~A" (channel->float-vector 30 10)))
    (undo)
    (close-sound ind))
  
  (let ((ind (new-sound  "test.snd" 1 22050 mus-ldouble mus-next "third ramp re-order tests" 101)))
    (offset-channel 1.0)
    (env-sound '(0 0 1 1))
    (contrast-channel 1.0)
    (let ((reader (make-sampler 0)))
      (do ((i 0 (+ i 1))
	   (val 0.0 (+ val .01)))
	  ((or (= i 100)
	       (let ((y (reader))
		     (ny (sin (+ (* val 0.5 pi) (* 1.0 (sin (* val 2.0 pi)))))))
		 (and (fneq y ny)
		      (or (snd-display "contrast-channel: ~A ~A ~A" val y ny)
			  #t)))))))
    (close-sound ind))
  
  (let ((ind0 (open-sound "oboe.snd"))
	(ind1 (open-sound "pistol.snd")))
    
    (let ((clip (channel-clipped? ind0 0)))
      (if clip (snd-display "channel-clipped? oboe.snd -> ~A" clip)))
    (scale-to 1.5 ind0 0)
    (let ((clip (channel-clipped? ind0 0)))
      (if (not (memv clip '(4502 4503))) (snd-display "channel-clipped after scale: ~A" clip)))
    (revert-sound ind0)
    
    (do ((i 0 (+ i 1))) ((= i 4)) (ramp-channel 0.0 1.0 0 #f ind1 0))
    (make-selection 1000 2000 ind1 0)
    (set! (sync ind0) 1)
    (set! (selected-sound) ind0)
    (env-selection '(0 0 1 1))
    (if (not (and (= (edit-position ind0 0) 0)
		  (= (edit-position ind1 0) 5)))
	(snd-display "selection override of sync field: ~A ~A" (edit-position ind0 0) (edit-position ind1 0)))
    (env-sound '(0 0 1 1 2 0))
    (if (not (and (= (edit-position ind0 0) 1)
		  (= (edit-position ind1 0) 5)))
	(snd-display "sync field over selection: ~A ~A" (edit-position ind0 0) (edit-position ind1 0)))
    
    (close-sound ind1)
    (revert-sound ind0)
    (close-sound ind0))
  
  (let ((s1 (open-sound "oboe.snd")))
    (let ((s2 (copy s1)))
      (if (not (sound? s2))
	  (snd-display "copy sound oboe -> ~A" s2)
	  (begin
	    (if (not (= (srate s1) (srate s2))) (snd-display "copy sounds srates: ~A ~A" (srate s1) (srate s2)))
	    (if (not (= (framples s1) (framples s2))) (snd-display "copy sounds framples: ~A ~A" (framples s1) (framples s2)))
	    (if (not (= (chans s1) (chans s2) 1)) (snd-display "copy sounds chans: ~A ~A" (chans s1) (chans s2)))
	    (let ((d1 (channel->float-vector 0 #f s1))
		  (d2 (channel->float-vector 0 #f s2)))
	      (if (not (mus-arrays-equal? d1 d2))
		  (snd-display "copied sound not equal? ~A?" (float-vector-peak (float-vector-subtract! d0 d1)))))
	    (close-sound s2))))
    (fill! s1 0.0)
    (if (fneq (maxamp s1) 0.0) (snd-display "fill 1 with 0: ~A" (maxamp s1)))
    (fill! s1 0.3)
    (if (fneq (maxamp s1) 0.3) (snd-display "fill 1 with 0.3: ~A" (maxamp s1)))
    (close-sound s1))
  
  (let ((s1 (open-sound "2a.snd")))
    (let ((s2 (copy s1)))
      (if (not (sound? s2))
	  (snd-display "copy sound 2a -> ~A" s2)
	  (begin
	    (if (not (= (srate s1) (srate s2))) (snd-display "copy sounds srates 2: ~A ~A" (srate s1) (srate s2)))
	    (if (not (= (framples s1) (framples s2))) (snd-display "copy sounds framples 2: ~A ~A" (framples s1) (framples s2)))
	    (if (not (= (chans s1) (chans s2) 2)) (snd-display "copy sounds chans 2: ~A ~A" (chans s1) (chans s2)))
	    (let ((d10 (channel->float-vector 0 #f s1 0))
		  (d11 (channel->float-vector 0 #f s1 1))
		  (d20 (channel->float-vector 0 #f s2 0))
		  (d21 (channel->float-vector 0 #f s2 1)))
	      (if (not (mus-arrays-equal? d10 d20))
		  (snd-display "copied sound 2 (0) not equal? ~A?" (float-vector-peak (float-vector-subtract! d10 d20))))
	      (if (not (mus-arrays-equal? d11 d21))
		  (snd-display "copied sound 2 (1) not equal? ~A?" (float-vector-peak (float-vector-subtract! d11 d21)))))
	    (close-sound s2))))
    (fill! s1 0.0)
    (if (fneq (maxamp s1) 0.0) (snd-display "fill 2 with 0: ~A" (maxamp s1)))
    (fill! s1 0.3)
    (if (fneq (maxamp s1) 0.3) (snd-display "fill 2 with 0.3: ~A" (maxamp s1)))
    (close-sound s1))
  
  (for-each close-sound (sounds))
  (unselect-all)
  (let ((snd (open-sound "oboe.snd")))
    (make-selection 1000 2000 snd 0)
    (if (not (selection?)) (snd-display "make-selection for copy failed?"))
    (copy (selection))
    (let ((r1 (channel->float-vector 1000 1000 snd 0)))
      (let* ((snds (sounds))
	     (sel ((if (equal? (car snds) snd) cadr car) snds))
	     (r2 (channel->float-vector 0 1000 sel 0)))
	(if (equal? sel snd)
	    (snd-display "very weird: ~A equal? ~A from ~A (~A ~A ~A)" sel snd snds (car snds) (cadr snds) (equal? (car snds) snd)))
	(if (not (mus-arrays-equal? r1 r2))
	    (snd-display "copied selection not equal? ~A?" (float-vector-peak (float-vector-subtract! r1 r2))))
	(close-sound sel))
      (if (not (selection?))
	  (snd-display "copy selection unselected? ~A" (sounds))
	  (begin
	    (fill! (selection) 0.0)
	    (let ((r1 (float-vector-peak (channel->float-vector 1000 1000 snd 0))))
	      (if (> r1 0.0)
		  (snd-display "fill! selection not 0.0? ~A" r1)))
	    (revert-sound snd)
	    (if (not (selection?))
		(snd-display "revert-sound selection unselected?")
		(begin
		  (fill! (selection) 0.3)
		  (let ((r1 (channel->float-vector 1000 1000 snd 0)))
		    (if (not (and (morally-equal? (float-vector-max r1) 0.3)
				  (morally-equal? (float-vector-min r1) 0.3)))
			(snd-display "fill! selection not 0.3? ~A ~A" (float-vector-min r1) (float-vector-max r1)))))))))
    (for-each close-sound (sounds)))
  
  (let ((snd (open-sound "oboe.snd")))
    (make-selection 1000 2000 snd 0)
    (if (not (selection?)) 
	(snd-display "make-selection failed?")
	(let ((sel-max (maxamp (selection)))
	      (sel-len (length (selection))))
	  (let ((mx (car (selection->mix))))
	    (if (not (mix? mx))
		(snd-display "selection->mix: ~A" mx)
		(let ((mx-rd (make-mix-sampler mx 0))
		      (snd-rd (make-sampler 1000 snd 0))
		      (orig-rd (make-sampler 1000 snd 0 1 0)))
		  (do ((happy #t)
		       (i 0 (+ i 1)))
		      ((or (not happy) 
			   (= i 1000)))
		    (let ((mx-val (mx-rd))
			  (snd-val (snd-rd))
			  (orig-val (orig-rd)))
		      (when (or (fneq mx-val snd-val)
				(fneq snd-val orig-val))
			(set! happy #f)
			(snd-display "selection->mix at ~A: ~A ~A ~A" (+ i 1000) mx-val snd-val orig-val))))
		  (if (not (= (length mx) sel-len 1001)) (snd-display "selection->mix mix length: ~A (~A)" (length mx) sel-len))
		  (if (fneq (maxamp mx) sel-max) (snd-display "selection->mix maxamps: ~A ~A" (maxamp mx) sel-max)))))))
    (for-each close-sound (sounds)))
  
  (let ((snd (open-sound "2.snd")))
    (set! (sync snd) 1)
    ;; make-selection claims it follows the sync field
    (make-selection 2000 3000 snd)
    (if (not (selection?)) 
	(snd-display "make-selection (2) failed?")
	(let ((sel-max (maxamp (selection)))
	      (sel-len (length (selection)))
	      (sel-chns (channels (selection))))
	  (if (not (= sel-chns 2)) (snd-display "make-selection stereo syncd chans: ~A" sel-chns))
	  (if (not (= sel-len 1001)) (snd-display "make-selection stereo length: ~A" sel-len))
	  (let ((mx-list (selection->mix)))
	    (let ((mx0 (car mx-list))
		  (mx1 (cadr mx-list)))
	      (if (not (and (mix? mx0)
			    (mix? mx1)))
		  (snd-display "selection->mix stereo: ~A ~A" mx0 mx1)
		  (let ((mx0-rd (make-mix-sampler mx0 0))
			(mx1-rd (make-mix-sampler mx1 0))
			(snd0-rd (make-sampler 2000 snd 0))
			(snd1-rd (make-sampler 2000 snd 1))
			(orig0-rd (make-sampler 2000 snd 0 1 0))
			(orig1-rd (make-sampler 2000 snd 1 1 0)))
		    (do ((happy #t)
			 (i 0 (+ i 1)))
			((or (not happy) 
			     (= i 1000)))
		      (let ((mx0-val (mx0-rd))
			    (mx1-val (mx1-rd))
			    (snd0-val (snd0-rd))
			    (snd1-val (snd1-rd))
			    (orig0-val (orig0-rd))
			    (orig1-val (orig1-rd)))
			(when (or (fneq mx0-val snd0-val)
				  (fneq snd0-val orig0-val))
			  (set! happy #f)
			  (snd-display "selection->mix stereo 0 at ~A: ~A ~A ~A" (+ i 2000) mx0-val snd0-val orig0-val))
			(when (or (fneq mx1-val snd1-val)
				  (fneq snd1-val orig1-val))
			  (set! happy #f)
			  (snd-display "selection->mix stereo 1 at ~A: ~A ~A ~A" (+ i 2000) mx1-val snd1-val orig1-val))))))
	      (if (not (= (length mx0) (length mx1) sel-len 1001))
		  (snd-display "selection->mix stereo mix length: ~A ~A (~A)" (length mx0) (length mx1) sel-len))
	      (if (fneq (max (maxamp mx0) (maxamp mx1)) sel-max) 
		  (snd-display "selection->mix stereo maxamps: ~A ~A ~A" (maxamp mx0) (maxamp mx1) sel-max))))))
    (for-each close-sound (sounds)))
  
  (let ((ind (new-sound :size 10)))
    (do ((i 0 (+ i 1)))
	((= i 10))
      (set! (sample i ind 0) (* .1 i)))
    (let* ((rd (make-sampler 3 ind 0))
	   (val (read-sample-with-direction rd 1)))
      (if (fneq val .3) (snd-display "read-sample-with-direction 3: ~A" val))
      (read-sample-with-direction rd -1)
      (set! val (read-sample-with-direction rd -1))
      (if (fneq val .2) (snd-display "read-sample-with-direction 2: ~A" val))
      (set! val (read-sample-with-direction rd -1))
      (if (fneq val .1) (snd-display "read-sample-with-direction 1: ~A" val))
      (close-sound ind)))
  
  (clear-save-state-files))


;;; ---------------- test 6: float-vectors ----------------

(define (snd_test_6)
  (do ((clmtest 0 (+ 1 clmtest))) ((= clmtest tests)) 
    (log-mem clmtest)
    (let ((v0 (make-float-vector 10))
	  (v1 (make-float-vector 10)))
      (if (not (= (length v0) 10)) (snd-display "v0 length = ~D?" (length v0)))
      (fill! v0 1.0)
      (fill! v1 0.5)
      (if (morally-equal? v0 v1) (snd-display "float-vector equal? ~A ~A" v0 v1))
      (if (eq? v0 v1) (snd-display "float-vector eq? ~A ~A" v0 v1))
      (if (fneq (float-vector-max v0) 1.0) (snd-display "float-vector max ~A" (float-vector-max v0)))
      (if (fneq (float-vector-min v0) 1.0) (snd-display "float-vector min ~A" (float-vector-min v0)))
      (let ((v3 (make-float-vector 10 0.5))
	    (v4 (make-float-vector 3)))
	(if (not (morally-equal? v3 v1)) (snd-display "float-vector not equal? ~A ~A" v3 v1))
	(if (morally-equal? v4 v1) (snd-display "len diff float-vector equal? ~A ~A" v4 v1))
	(set! (v3 0) 1.0)
	(if (fneq (v3 0) 1.0) (snd-display "set! float-vector-ref: ~A" (v3 0))))
      (let ((vlst (make-float-vector 3)))
	(set! (vlst 1) .1)
	(if (not (feql (map values vlst) '(0.0 0.1 0.0))) (snd-display "vector->list: ~A?" (map values vlst))))
      (let ((v2 (make-float-vector 4)))
	(do ((i 0 (+ i 1)))
	    ((= i 4))
	  (set! (v2 i) i))
	(float-vector-move! v2 3 2 #t)
	(if (or (fneq (v2 3) 2.0) (fneq (v2 2) 1.0))
	    (snd-display "float-vector-move! back: ~A?" v2)))
      
      (if (not (string=? (float-vector->string (float-vector 1.0 2.0)) "(float-vector 1.000 2.000)")) 
	  (snd-display "float-vector->string: ~A" (float-vector->string (float-vector 1.0 2.0))))
      
      (if (not (mus-arrays-equal? #r(4 3 2 1) (reverse! (float-vector 1 2 3 4)))) (snd-display "float-vector-reverse: ~A" (reverse! (float-vector 1 2 3 4))))
      (if (not (mus-arrays-equal? #r(3 2 1) (reverse! (float-vector 1 2 3)))) (snd-display "float-vector-reverse: ~A" (reverse! (float-vector 1 2 3))))
      (if (not (mus-arrays-equal? #r(2 1) (reverse! (float-vector 1 2)))) (snd-display "float-vector-reverse: ~A" (reverse! (float-vector 1 2))))
      (if (not (mus-arrays-equal? #r(1) (reverse! (float-vector 1)))) (snd-display "float-vector-reverse: ~A" (reverse! (float-vector 1))))
      (if (not (mus-arrays-equal? #r(3 2 1) (reverse #r(1 2 3)))) (snd-display "reverse(float-vector): ~A" (reverse #r(1 2 3))))
      (let* ((v #r(3 2 1))
	     (rv (reverse v)))
	(if (not (mus-arrays-equal? rv #r(1 2 3)))
	    (snd-display "reverse(float-vector) -> ~A ~A" v rv)))
      
      (let ((v0 (make-float-vector 3)))
	(let ((var (catch #t (lambda () (v0 10)) (lambda args args))))
	  (if (not (eq? (car var) 'out-of-range))
	      (snd-display "float-vector-ref high index: ~A" var)))
	(let ((var (catch #t (lambda () (set! (v0 10) 1.0)) (lambda args args))))
	  (if (not (eq? (car var) 'out-of-range))
	      (snd-display "float-vector-set! high index: ~A" var)))
	(let ((var (catch #t (lambda () (float-vector-move! v0 10 0 #t)) (lambda args args))))
	  (if (not (eq? (car var) 'out-of-range))
	      (snd-display "float-vector-move! high index: ~A" var)))
	(let ((var (catch #t (lambda () (float-vector-move! v0 0 10 #t)) (lambda args args))))
	  (if (not (eq? (car var) 'out-of-range))
	      (snd-display "float-vector-move! high 2 index: ~A" var)))
	(let ((var (catch #t (lambda () (float-vector-move! v0 -10 0 #f)) (lambda args args))))
	  (if (not (eq? (car var) 'out-of-range))
	      (snd-display "float-vector-move! back high index: ~A" var)))
	(let ((var (catch #t (lambda () (float-vector-move! v0 0 -10 #f)) (lambda args args))))
	  (if (not (eq? (car var) 'out-of-range))
	      (snd-display "float-vector-move! back high 2 index: ~A" var))))
      
      (let ((v #r(0.0 1.0 -2.0 -3.0)))
	(if (not (mus-arrays-equal? (float-vector-abs! v) #r(0.0 1.0 2.0 3.0)))
	    (snd-display "float-vector-abs! ~A" v)))

      ;; float-vector-add! + subvector:
      (let* ((fv #r(1 2 3 4 5))
	     (sv (subvector fv '(4) 1)))
	(float-vector-add! sv fv)
	(if (not (mus-arrays-equal? fv #r(1.0 3.0 6.0 10.0 15.0)))
	    (snd-display "float-vector+subvector: ~A" fv)))
      
      (do ((i 0 (+ i 1)))
	  ((= i 10))
	(if (fneq (v0 i) 1.0) (snd-display "fill v0[~D] = ~F?" i (v0 i)))
	(if (fneq (v1 i) 0.5) (snd-display "preset v1[~D] = ~F?" i (v1 i))))
      (float-vector-add! v0 v1)
      (do ((i 0 (+ i 1)))
	  ((= i 10))
	(if (fneq (v0 i) 1.5) (snd-display "add v0[~D] = ~F?" i (v0 i))))
      (float-vector-subtract! v0 v1)
      (do ((i 0 (+ i 1)))
	  ((= i 10))
	(if (fneq (v0 i) 1.0) (snd-display "subtract v0[~D] = ~F?" i (v0 i))))
      (let ((v2 (copy v0)))
	(do ((i 0 (+ i 1)))
	    ((= i 10))
	  (if (fneq (v2 i) 1.0) (snd-display "copy v0[~D] = ~F?" i (v2 i))))
	(float-vector-scale! v2 5.0)
	(do ((i 0 (+ i 1)))
	    ((= i 10))
	  (if (fneq (v2 i) 5.0) (snd-display "scale v2[~D] = ~F?" i (v2 i))))
	(float-vector-offset! v0 -1.0)
	(do ((i 0 (+ i 1)))
	    ((= i 10))
	  (if (fneq (v0 i) 0.0) (snd-display "offset v0[~D] = ~F?" i (v0 i))))
	(float-vector-multiply! v2 v1)
	(do ((i 0 (+ i 1)))
	    ((= i 10))
	  (if (fneq (v2 i) 2.5) (snd-display "multiply v2[~D] = ~F?" i (v2 i))))
	(if (fneq (float-vector-peak v2) 2.5) (snd-display "v2's peak is ~F?" (float-vector-peak v2)))
	(set! (v2 5) 123.0)
	(if (fneq (float-vector-peak v2) 123.0) (snd-display "v2's set peak is ~F?" (float-vector-peak v2)))
	(let ((vn (make-float-vector 32))
	      (vb (make-float-vector 64))
	      (vs (make-float-vector 3))
	      (vss (make-float-vector 1)))
	  (do ((i 0 (+ i 1)))
	      ((= i 32))
	    (set! (vn i) i))
	  (let ((vnew (float-vector-subseq vn 3)))
	    (if (fneq (vnew 0) 3.0) (snd-display "float-vector-subseq[3:] ~A?" (vnew 0)))
	    (if (not (= (length vnew) 29)) (snd-display "float-vector-subseq[3:] length: ~A?" (length vnew))))
	  (let ((vnew (float-vector-subseq vn 3 8)))
	    (if (fneq (vnew 0) 3.0) (snd-display "float-vector-subseq[3:8] ~A?" (vnew 0)))
	    (if (not (= (length vnew) 6)) (snd-display "float-vector-subseq[3:8] length: ~A?" (length vnew))))
	  (float-vector-subseq vn 3 3 vs)
	  (if (or (fneq (vs 0) 3.0)
		  (fneq (vs 1) 0.0)
		  (fneq (vs 2) 0.0))
	      (snd-display "float-vector-subseq[3:3->vs] ~A?" vs))
	  (float-vector-subseq vn 0 32 vs)
	  (if (not (= (length vs) 3)) (snd-display "float-vector-subseq[0:32->vs] length: ~A?" (length vs)))
	  (float-vector-subseq vn 2 3 vss)
	  (if (fneq (vss 0) 2.0) (snd-display "float-vector-subseq[2:3->vss] ~A?" (vss 0)))
	  (set! (vb 8) 123.0)
	  (float-vector-subseq vn 1 8 vb)
	  (if (fneq (vb 0) 1.0) (snd-display "float-vector-subseq[1:8->vb] ~A?" (vb 0)))
	  (if (fneq (vb 8) 123.0) (snd-display "float-vector-subseq[1:8->vb][8] ~A?" (vb 8))))
	
	(let ((v (make-float-vector 20))
	      (mn 1.0)
	      (mx -1.0))
	  (do ((i 0 (+ i 1)))
	      ((= i 20))
	    (let ((val (mus-random 1.0)))
	      (set! (v i) val)
	      (set! mn (min mn val))
	      (set! mx (max mx val))))
	  (if (fneq (float-vector-min v) mn) (snd-display "float-vector-min ran: ~A ~A" (float-vector-min v) mn))
	  (if (fneq (float-vector-max v) mx) (snd-display "float-vector-max ran: ~A ~A" (float-vector-max v) mx))
	  (if (fneq (float-vector-peak v) (max (abs mn) (abs mx))) (snd-display "float-vector-peak ran: ~A ~A ~A" (float-vector-peak v) mn mx)))
	
	(let ((v1 (make-float-vector 3 .1))
	      (v2 (make-float-vector 4 .2)))
	  (let ((val (float-vector+ (copy v1) v2)))
	    (if (not (mus-arrays-equal? val #r(.3 .3 .3))) (snd-display "float-vector+ .1 .2: ~A" val)))
	  (set! (v1 1) .3)
	  (let ((val (float-vector+ (copy v1) v2)))
	    (if (not (mus-arrays-equal? val #r(.3 .5 .3))) (snd-display "float-vector+ .1 .2 (1): ~A" val)))
	  (let ((val (float-vector+ (copy v1) 2.0)))
	    (if (not (mus-arrays-equal? val #r(2.1 2.3 2.1))) (snd-display "float-vector+ .1 2.0: ~A" val)))
	  (let ((val (float-vector+ 2.0 (copy v1))))
	    (if (not (mus-arrays-equal? val #r(2.1 2.3 2.1))) (snd-display "float-vector+ .1 2.0 (1): ~A" val)))
	  (let ((val (float-vector* 2.0 (copy v1))))
	    (if (not (mus-arrays-equal? val #r(.2 .6 .2))) (snd-display "float-vector* 2.0: ~A" val)))
	  (let ((val (float-vector* (copy v1) 2.0)))
	    (if (not (mus-arrays-equal? val #r(.2 .6 .2))) (snd-display "float-vector* 2.0 (1): ~A" val)))
	  (let ((val (float-vector* (copy v1) v2)))
	    (if (not (mus-arrays-equal? val #r(.02 .06 .02))) (snd-display "float-vector* v1 v2: ~A" val))))
	
	(fill! v0 1.0)
	(do ((i 0 (+ i 1)))
	    ((= i 10))
	  (if (fneq (v0 i) 1.0) (snd-display "map v0[~D] = ~F?" i (v0 i)))))
      
      (if (fneq (#r(1.0 2.0 3.0) 1) 2.0)
	  (snd-display "(float-vector...) = ~A?" (#r(1.0 2.0 3.0) 1)))
      (let ((v1 #r(1 2 3 4)))
	(if (fneq (v1 1) 2.0)
	    (snd-display "(v1 1) = ~A?" (v1 1))))
      
      (when with-gui
	(let ((ind (open-sound "oboe.snd")))
	  (set! (speed-control ind) .5)
	  (play :wait #t)
	  (apply-controls)
	  (revert-sound)
	  (reset-controls ind)
	  ;; try some special cases
	  (apply-controls)
	  (if (not (= (edit-position ind) 0))
	      (snd-display "apply-controls with no:change: ~A: ~A" (edits ind) (edit-tree ind)))
	  (set! (speed-control ind) -1.0)
	  (apply-controls)
	  (if (not (= (edit-position ind) 1))
	      (snd-display "apply-controls with srate -1.0: ~A ~A ~A" (edit-position ind) (edits ind) (edit-tree ind)))
	  (if (> (abs (- (framples ind 0) (framples ind 0 0))) 2)
	      (snd-display "apply-controls srate -1.0 lengths: ~A ~A" (framples ind 0) (framples ind 0 0)))
	  (if (or (fneq (maxamp) .147)
		  (< (abs (sample 9327)) .01))
	      (snd-display "apply-controls srate -1.0 samples: ~A ~A" (maxamp) (sample 9327)))
	  (if (fneq (speed-control ind) 1.0) (snd-display "apply-controls -1.0 -> ~A?" (speed-control ind)))
	  
	  (hook-push after-apply-controls-hook (lambda (hook) 
						 (let ((tag (catch #t 
							      apply-controls 
							      (lambda args args))))
						   (if (not (eq? (car tag) 'cannot-apply-controls))
						       (snd-display "after-apply-controls-hook: recursive attempt apply-controls: ~A" tag)))))
	  (apply-controls)
	  (set! (hook-functions after-apply-controls-hook) ())
	  (revert-sound)
	  (close-sound ind)))
      
      (let ((tag (catch #t
		   (lambda () (float-vector-subseq (make-float-vector 3) 1 0))
		   (lambda args (car args)))))
	(if (not (eq? tag 'out-of-range))
	    (snd-display "float-vector-subseq 1 0: ~A" tag)))
      (let ((v0 (make-float-vector 5 .1))
	    (v1 (make-float-vector 6 .2)))
	(float-vector-add! v0 v1 2)
	(if (not (mus-arrays-equal? v0 #r(.1 .1 .3 .3 .3)))
	    (snd-display "float-vector-add + offset: ~A" v0)))
      
      ;; check s7 stuff with float-vectors
      (let ((v #r(1.0 2.0 3.0)))
	(if (not (string=? (format #f "~{~A~^-~}" v) "1.0-2.0-3.0"))
	    (snd-display "float-vector in format {}: ~S" (format #f "~{~A~^-~}" v)))
	(if (not (= (length v) 3))
	    (snd-display "float-vector s7 len: ~A" (length v)))
	(let ((val (map floor v)))
	  (if (not (equal? val '(1 2 3)))
	      (snd-display "float-vector s7 map: ~A" val)))
	(let ((val 0))
	  (for-each
	   (lambda (x)
	     (set! val (+ val (floor x))))
	   v)
	  (if (not (eqv? val 6))
	      (snd-display "float-vector s7 for-each: ~A" val)))
	(set! v (reverse v))
	(if (not (vmus-arrays-equal? v #r(3.0 2.0 1.0)))
	    (snd-display "float-vector s7 reverse: ~A" v))
	(fill! v 12.0)
	(if (not (vmus-arrays-equal? v #r(12.0 12.0 12.0)))
	    (snd-display "float-vector s7 fill: ~A" (fill! v 12.0))))
      
      (let ((sum 0)) 
	(for-each (lambda (n) (set! sum (+ sum n))) #r(1 2 3))
	(if (not (morally-equal? sum 6.0))
	    (snd-display "object for-each (float-vector): ~A" sum)))
      
      (do ((x #r(0.0))
	   (osc (make-oscil :frequency 440))
	   (e1 (make-env '(0 0 1 1 2 0) :length 100))
	   (i 0 (+ i 1)))
	  ((= i 100))
	(float-vector-set! x 0 (* (env e1) (oscil osc (float-vector-ref x 0)))))
      
      (if (fneq (float-vector-equal? #r(1.0) #r(1.1) .1) .0909)
	  (snd-display "float-vector-equal? 0.0909: ~A" (float-vector-equal? #r(1.0) #r(1.1) .1)))
      (if (float-vector-equal? #r(1.0) #r(1.1) .01)
	  (snd-display "float-vector-equal? #f: ~A" (float-vector-equal? #r(1.0) #r(1.1) .01))))))


;;; ---------------- test 7: colors ----------------

(require snd-rgb.scm)

(define (snd_test_7)
  (when (or (provided? 'snd-gtk)
	    (provided? 'snd-motif))

    (let* ((colormap-error-max 0.0)
	   (cfneq (lambda (a b) (> (abs (- a b)) colormap-error-max)))
	   (old-colormap-size *colormap-size*))
      
      (letrec ((test-color
		(lambda (lst)
		  (if (pair? lst)
		      (let* ((name ((car lst) 0))
			     (getfnc ((car lst) 1))
			     (setfnc (lambda (val) (set! (getfnc) val)))
			     (initval ((car lst) 2)))
			(if (not (color? initval)) (snd-display "~A not color?" initval))
			;; we'll get warnings here if the cell chosen didn't exactly match the one requested -- not a bug
			;; (if (not (equal? (getfnc) initval))
			;;	  (snd-display "~A is not ~A (~A)?" name initval (getfnc)))
			(let ((beige (*rgb* 'beige)))
			  (setfnc beige)
			  (if (not (equal? (getfnc) beige))
			      (snd-display "set-~A is not beige (~A)?" name (getfnc))))
			(setfnc initval)
			(test-color (cdr lst)))))))
	
	(let* ((c1 (catch 'no-such-color
		     (lambda () (make-color 0 0 1))
		     (lambda args #f)))
	       (c2 c1)
	       (c3 (catch 'no-such-color
		     (lambda () (make-color 0 0 1))
		     (lambda args #f))))
	  (if (not (equal? c1 c2)) (snd-display "color not equal? ~A ~A?" c1 c2))
	  (if (not (eq? c1 c2)) (snd-display "color not eq? ~A ~A?" c1 c2))
	  (if (eq? c1 c3) (snd-display "diff color eq? ~A ~A?" c1 c3))
	  (if (not (member (color->list c1) '((0.0 0.0 1.0) (0.0 0.0 1.0 1.0))))
	      (snd-display "color->list: ~A ~A?" c1 (color->list c1))))
	
	(if (not (provided? 'snd-motif))
	    (let* ((c1 (catch 'no-such-color
			 (lambda () (make-color 0 0 1 0.5))
			 (lambda args #f)))
		   (c2 c1)
		   (c3 (catch 'no-such-color
			 (lambda () (make-color 0 0 1 0.5))
			 (lambda args #f))))
	      (if (not (equal? c1 c2)) (snd-display "alpha color not equal? ~A ~A?" c1 c2))
	      (if (not (eq? c1 c2)) (snd-display "alpha color not eq? ~A ~A?" c1 c2))
	      (if (eq? c1 c3) (snd-display "alpha diff color eq? ~A ~A?" c1 c3))
	      (let ((c4 (catch 'no-such-color
			  (lambda () (make-color 0 0 1 0.0))
			  (lambda args #f))))
		(if (equal? c1 c4) (snd-display "alpha color equal? ~A ~A?" c1 c2)))))
	
	(do ((tv (vector '(0.0 0.0 0.0) '(0.0 0.0 0.0) '(0.0 0.0 0.0) '(0.0 1.0 1.0)
			  '(0.0 0.0 7.01915007248035e-4) '(0.0 0.0 0.0) '(0.0 0.0 0.0)
			  '(0.0 0.0 0.49999) '(1.0 0.0 0.0) '(1.0 0.0 0.0) '(0.0 0.0 1.0)
			  '(1.0 0.0 1.0) '(0.0 0.500007629510948 0.4) '(1.0 0.0 0.0)
			  '(1.0 0.0 0.0) '(0.0 0.0 1.0)))
	     (i 0 (+ i 1)))
	    ((not (colormap? (integer->colormap i))))
	  (let ((val (colormap-ref (integer->colormap i) 0))
		(true-val (tv i)))
	    (if (not (feql val true-val))
		(snd-display "colormap-ref ~A: ~A (~A)" i val true-val))))
	(catch #t ; might be undefined var as well as no-such-color
	  (lambda () 
	    (test-color
	     (list
	      (list 'basic-color basic-color ivory2)
	      (list 'cursor-color cursor-color red)
	      (list 'data-color data-color black)
	      (list 'enved-waveform-color enved-waveform-color blue)
	      (list 'filter-control-waveform-color filter-control-waveform-color blue)
	      (list 'graph-color graph-color white)
	      (list 'highlight-color highlight-color ivory1)
	      (list 'listener-color listener-color alice-blue)
	      (list 'listener-text-color listener-text-color black)
	      (list 'mark-color mark-color red)
	      (list 'mix-color mix-color dark-gray)
	      (list 'position-color position-color ivory3)
	      (list 'sash-color sash-color light-green)
	      (list 'selected-data-color selected-data-color black)
	      (list 'selected-graph-color selected-graph-color white)
	      (list 'selection-color selection-color lightsteelblue1)
	      (list 'text-focus-color text-focus-color white)
	      (list 'zoom-color zoom-color ivory4)))
	    
	    (let ((ind (open-sound "oboe.snd")))
	      (set! *selected-data-color* light-green)
	      (set! *data-color* blue)
	      (set! *selected-graph-color* black)
	      (let ((red (make-color-with-catch 1.0 0.0 0.0)))
		(set! (foreground-color ind 0 cursor-context) red)
		(let ((col (color->list (foreground-color ind 0 cursor-context))))
		  (if (not (feql col (color->list red)))
		      (snd-display "set foreground cursor color: ~A ~A" col (color->list red))))
		(set! (foreground-color) blue)
		(let ((col (color->list (foreground-color))))
		  (if (not (feql col (color->list blue)))
		      (snd-display "set foreground-color: ~A ~A" col (color->list blue))))
		(set! (foreground-color ind) red)
		(let ((col (color->list (foreground-color ind))))
		  (if (not (feql col (color->list red)))
		      (snd-display "set foreground-color with ind (red): ~A ~A" col (color->list red))))
		(set! (foreground-color ind) black)
		(let ((col (color->list (foreground-color ind))))
		  (if (not (feql col (color->list black)))
		      (snd-display "set foreground-color with ind (black): ~A ~A" col (color->list black)))))
	      (set! *selected-graph-color* (make-color-with-catch 0.96 0.96 0.86))
	      (set! *data-color* black)
	      (set! *selected-data-color* blue)
	      (set! *graph-color* white)
	      (close-sound ind)))
	  (lambda args args))
	
	(if (not (= (length jet-colormap) *colormap-size*))
	    (snd-display "jet-colormap length: ~A ~A" (length jet-colormap) *colormap-size*))

	(let ((tag (catch #t 
		     (lambda () (colormap-ref jet-colormap))
		     (lambda args (car args)))))
	  (if (not (eq? tag 'wrong-number-of-args)) (snd-display "colormap-ref nil: ~A" tag)))
	(let ((tag (catch #t 
		     (lambda () (jet-colormap))
		     (lambda args (car args)))))
	  (if (not (eq? tag 'wrong-number-of-args)) (snd-display "colormap-apply nil: ~A" tag)))
	(let ((tag (catch #t 
		     jet-colormap
		     (lambda args (car args)))))
	  (if (not (eq? tag 'wrong-type-arg))  ; arg2 to catch not a thunk => wrong type
	      (format *stderr* "colormap-apply nil: ~A" tag)))
	
	(for-each 
	 (lambda (n err)
	   (let ((inv (- 1.0 (/ 1.0 n))))
	     (set! *colormap-size* n)
	     (set! colormap-error-max err)
	     
	     (do ((i 0 (+ i 1))) ((= i 10))
	       (let* ((x (random 1.0))
		      (rgb (colormap-ref bone-colormap x))
		      (rgb1 (bone-colormap x)))
		 (let ((r (if (< x 3/4)
			      (* 7/8 x)
			      (- (* 11/8 x) 3/8)))
		       (g (if (< x 3/8)
			      (* 7/8 x)
			      (if (< x 3/4)
				  (- (* 29/24 x) 1/8)
				  (+ (* 7/8 x) 1/8))))
		       (b (if (< x 3/8)
			      (* 29/24 x)
			      (+ (* 7/8 x) 1/8)))
		       (r1 (rgb 0))
		       (g1 (rgb 1))
		       (b1 (rgb 2))
		       (r2 (rgb1 0))
		       (g2 (rgb1 1))
		       (b2 (rgb1 2)))
		   (if (and (< x inv) 
			    (or (cfneq r r1) 
				(cfneq g g1) 
				(cfneq b b1)
				(cfneq r2 r1) 
				(cfneq g2 g1) 
				(cfneq b2 b1)))
		       (snd-display "bone ~,3F (~,3F): ~{~,3F ~} ~{~,3F ~}" 
				    x (max (abs (- r r1)) (abs (- g g1)) (abs (- b b1))) (list r g b) (list r1 g1 b1))))))
	     
	     (do ((i 0 (+ i 1))) ((= i 10))
	       (let* ((x (random 1.0))
		      (rgb (colormap-ref copper-colormap x)))
		 (let ((r (if (< x 4/5)
			      (* 5/4 x)
			      1.0))
		       (g (* 4/5 x))
		       (b (* 1/2 x))
		       (r1 (rgb 0))
		       (g1 (rgb 1))
		       (b1 (rgb 2)))
		   (if (and (< x inv) (or (cfneq r r1) (cfneq g g1) (cfneq b b1)))
		       (snd-display "copper ~,3F (~,3F): ~{~,3F ~} ~{~,3F ~}" 
				    x (max (abs (- r r1)) (abs (- g g1)) (abs (- b b1))) (list r g b) (list r1 g1 b1))))))
	     
	     (do ((i 0 (+ i 1))) ((= i 10))
	       (let* ((x (random 1.0))
		      (rgb (colormap-ref winter-colormap x)))
		 (let ((r 0.0)
		       (b (- 1.0 (/ x 2.0)))
		       (r1 (rgb 0))
		       (g1 (rgb 1))
		       (b1 (rgb 2)))
		   (if (and (< x inv) (or (cfneq r r1) (cfneq x g1) (cfneq b b1)))
		       (snd-display "winter ~,3F (~,3F): ~{~,3F ~} ~{~,3F ~}" 
				    x (max (abs (- r r1)) (abs (- x g1)) (abs (- b b1))) (list r x b) (list r1 g1 b1))))))
	     
	     (do ((i 0 (+ i 1))) ((= i 10))
	       (let* ((x (random 1.0))
		      (rgb (colormap-ref autumn-colormap x)))
		 (let ((r 1.0)
		       (b 0.0)
		       (r1 (rgb 0))
		       (g1 (rgb 1))
		       (b1 (rgb 2)))
		   (if (and (< x inv) (or (cfneq r r1) (cfneq x g1) (cfneq b b1)))
		       (snd-display "autumn ~,3F (~,3F): ~{~,3F ~} ~{~,3F ~}" 
				    x (max (abs (- r r1)) (abs (- x g1)) (abs (- b b1))) (list r x b) (list r1 g1 b1))))))
	     
	     (do ((i 0 (+ i 1))) ((= i 10))
	       (let* ((x (random 1.0))
		      (rgb (colormap-ref cool-colormap x)))
		 (let ((g (- 1.0 x))
		       (b 1.0)	     
		       (r1 (rgb 0))
		       (g1 (rgb 1))
		       (b1 (rgb 2)))
		   (if (and (< x inv) (or (cfneq x r1) (cfneq g g1) (cfneq b b1)))
		       (snd-display "cool ~,3F (~,3F): ~{~,3F ~} ~{~,3F ~}" 
				    x (max (abs (- x r1)) (abs (- g g1)) (abs (- b b1))) (list x g b) (list r1 g1 b1))))))
	     
	     (do ((i 0 (+ i 1))) ((= i 10))
	       (let* ((x (random 1.0))
		      (rgb (colormap-ref hot-colormap x)))
		 (let ((r (if (< x 3/8)
			      (* 8/3 x)
			      1.0))
		       (g (if (< x 3/8)
			      0.0
			      (if (< x 3/4)
				  (- (* 8/3 x) 1.0)
				  1.0)))
		       (b (if (< x 3/4)
			      0.0
			      (- (* 4 x) 3)))
		       (r1 (rgb 0))
		       (g1 (rgb 1))
		       (b1 (rgb 2)))
		   (if (and (< x inv) (or (cfneq r r1) (cfneq g g1) (cfneq b b1)))
		       (snd-display "hot ~,3F (~,3F): ~{~,3F ~} ~{~,3F ~}" 
				    x (max (abs (- r r1)) (abs (- g g1)) (abs (- b b1))) (list r g b) (list r1 g1 b1))))))
	     
	     (do ((i 0 (+ i 1))) ((= i 10))
	       (let* ((x (random 1.0))
		      (rgb (colormap-ref jet-colormap x)))
		 (let ((r (cond ((< x 3/8) 0.0)
				((< x 5/8) (- (* 4 x) 3/2))
				((< x 7/8) 1.0)
				(else      (+ (* -4 x) 9/2))))
		       (g (cond ((< x 1/8) 0.0)
				((< x 3/8) (- (* 4 x) 1/2))
				((< x 5/8) 1.0)
				((< x 7/8) (+ (* -4 x) 7/2))
				(else      0.0)))
		       (b (cond ((< x 1/8) (+ (* 4 x) 1/2))
				((< x 3/8) 1.0)
				((< x 5/8) (+ (* -4 x) 5/2))
				(else      0.0)))
		       (r1 (rgb 0))
		       (g1 (rgb 1))
		       (b1 (rgb 2)))
		   (if (and (< x inv) (or (cfneq r r1) (cfneq g g1) (cfneq b b1)))
		       (snd-display "jet ~,3F (~,3F): ~{~,3F ~} ~{~,3F ~}" 
				    x (max (abs (- r r1)) (abs (- g g1)) (abs (- b b1))) (list r g b) (list r1 g1 b1))))))
	     
	     (when (colormap? pink-colormap)
	       (do ((i 0 (+ i 1))) ((= i 10))
		 (let* ((x (random 1.0))
			(rgb (colormap-ref pink-colormap x)))
		   (let ((r (if (< x 3/8)
				(* 14/9 x)
				(+ (* 2/3 x) 1/3)))
			 (g (if (< x 3/8)
				(* 2/3 x)
				(if (< x 3/4)
				    (- (* 14/9 x) 1/3)
				    (+ (* 2/3 x) 1/3))))			
			 (b (if (< x 3/4)
				(* 2/3 x)
				(- (* 2 x) 1)))
			 (r1 (rgb 0))
			 (g1 (rgb 1))
			 (b1 (rgb 2)))
		     (if (and (< x inv) (or (cfneq r r1) (cfneq g g1) (cfneq b b1)))
			 (snd-display "pink ~,3F (~,3F): ~{~,3F ~} ~{~,3F ~}" 
				      x (max (abs (- r r1)) (abs (- g g1)) (abs (- b b1))) (list r g b) (list r1 g1 b1)))))))
	     
	     (do ((i 0 (+ i 1))) ((= i 10))
	       (let* ((x (random 1.0))
		      (rgb (colormap-ref spring-colormap x)))
		 (let ((r 1.0)
		       (b (- 1.0 x))
		       (r1 (rgb 0))
		       (g1 (rgb 1))
		       (b1 (rgb 2)))
		   (if (and (< x inv) (or (cfneq r r1) (cfneq x g1) (cfneq b b1)))
		       (snd-display "spring ~,3F (~,3F): ~{~,3F ~} ~{~,3F ~}" 
				    x (max (abs (- r r1)) (abs (- x g1)) (abs (- b b1))) (list r x b) (list r1 g1 b1))))))
	     
	     (do ((i 0 (+ i 1))) ((= i 10))
	       (let* ((x (random 1.0))
		      (rgb (colormap-ref gray-colormap x)))
		 (let ((r1 (rgb 0))
		       (g1 (rgb 1))
		       (b1 (rgb 2)))
		   (if (and (< x inv) (or (cfneq x r1) (cfneq x g1) (cfneq x b1)))
		       (snd-display "gray ~,3F (~,3F): ~{~,3F ~} ~{~,3F ~}" 
				    x (max (abs (- x r1)) (abs (- x g1)) (abs (- x b1))) (list x x x) (list r1 g1 b1))))))
	     
	     (do ((i 0 (+ i 1))) ((= i 10))
	       (let* ((x (random 1.0))
		      (rgb (colormap-ref black-and-white-colormap x)))
		 (let ((r 0.0)
		       (g 0.0)
		       (b 0.0)
		       (r1 (rgb 0))
		       (g1 (rgb 1))
		       (b1 (rgb 2)))
		   (if (and (< x inv) (or (cfneq r r1) (cfneq g g1) (cfneq b b1)))
		       (snd-display "black-and-white ~,3F (~,3F): ~{~,3F ~} ~{~,3F ~}" 
				    x (max (abs (- r r1)) (abs (- g g1)) (abs (- b b1))) (list r g b) (list r1 g1 b1))))))
	     
	     (do ((i 0 (+ i 1))) ((= i 10))
	       (let* ((x (random 1.0))
		      (rgb (colormap-ref summer-colormap x)))
		 (let ((g (+ 0.5 (/ x 2)))
		       (b 0.4)
		       (r1 (rgb 0))
		       (g1 (rgb 1))
		       (b1 (rgb 2)))
		   (if (and (< x inv) (or (cfneq x r1) (cfneq g g1) (cfneq b b1)))
		       (snd-display "summer ~,3F (~,3F): ~{~,3F ~} ~{~,3F ~}" 
				    x (max (abs (- x r1)) (abs (- g g1)) (abs (- b b1))) (list x g b) (list r1 g1 b1))))))
	     
	     (do ((i 0 (+ i 1))) ((= i 10))
	       (let* ((x (random 1.0))
		      (rgb (colormap-ref rainbow-colormap x)))
		 (let ((r (cond ((< x 2/5) 1.0)
				((< x 3/5) (+ (* -5 x) 3))
				((< x 4/5) 0.0)
				(else (- (* 10/3 x) 8/3))))
		       (g (cond ((< x 2/5) (* 5/2 x))
				((< x 3/5) 1.0)
				((< x 4/5) (+ (* -5 x) 4))
				(else 0.0)))
		       (b (cond ((< x 3/5) 0.0)
				((< x 4/5) (- (* 5 x) 3))
				(else 1.0)))
		       (r1 (rgb 0))
		       (g1 (rgb 1))
		       (b1 (rgb 2)))
		   (if (and (< x inv) (or (cfneq r r1) (cfneq g g1) (cfneq b b1)))
		       (snd-display "rainbow ~,3F (~,3F): ~{~,3F ~} ~{~,3F ~}" 
				    x (max (abs (- r r1)) (abs (- g g1)) (abs (- b b1))) (list r g b) (list r1 g1 b1))))))
	     
	     (do ((i 0 (+ i 1))) ((= i 10))
	       (let* ((x (random 1.0))
		      (rgb (colormap-ref prism-colormap x)))
		 (if (not (or (>= x inv)
			      (feql rgb '(1 0 0))
			      (feql rgb '(1 0.5 0))
			      (feql rgb '(1 1 0))
			      (feql rgb '(0 1 0))
			      (feql rgb '(0 0 1))
			      (feql rgb '(0.66670000 0 1))))
		     (snd-display "prism ~A" rgb))))
	     
	     (do ((i 0 (+ i 1))) ((= i 10))
	       (let* ((x (random 1.0))
		      (rgb (colormap-ref flag-colormap x)))
		 (if (not (or (>= x inv)
			      (feql rgb '(1 0 0))
			      (feql rgb '(1 1 1))
			      (feql rgb '(0 0 1))
			      (feql rgb '(0 0 0))))
		     (snd-display "flag: ~A" rgb))))
	     ))
	 '(512 64)
	 '(0.005 0.04))
	
	(let ((ind (add-colormap "white" (lambda (size) (list (make-float-vector size 1.0) (make-float-vector size 1.0) (make-float-vector size 1.0))))))
	  (if (not (colormap? ind))
	      (snd-display "add-colormap ~A: ~A" ind (colormap? ind)))
	  (if (not (feql (colormap-ref ind 0.5) '(1.0 1.0 1.0)))
	      (snd-display "white colormap: ~A" (colormap-ref ind 0.5)))
	  (let ((tag (catch #t (lambda () (set! *colormap* ind)) (lambda args args))))
	    (if (or (eq? tag 'no-such-colormap)
		    (not (equal? *colormap* ind))
		    (not (= (colormap->integer *colormap*) (colormap->integer ind))))
		(snd-display "colormap white: ~A ~A ~A" tag ind *colormap*)))
	  (if (not (string=? (colormap-name ind) "white"))
	      (snd-display "white colormap name: ~A" (colormap-name ind))))
	
	(set! *colormap-size* old-colormap-size)
	(if (not (= *colormap-size* old-colormap-size))
	    (snd-display "set colormap-size: ~A ~A" *colormap-size* old-colormap-size))
	
	(if (not (string=? (colormap-name black-and-white-colormap) "black-and-white"))
	    (snd-display "black-and-white: ~A" (colormap-name black-and-white-colormap)))
	(if (not (string=? (colormap-name gray-colormap) "gray"))
	    (snd-display "gray: ~A" (colormap-name gray-colormap)))
	(if (not (string=? (colormap-name rainbow-colormap) "rainbow"))
	    (snd-display "rainbow: ~A" (colormap-name rainbow-colormap)))
	
	(add-colormap "purple" 
		      (lambda (size) 
			(do ((r (make-float-vector size))
			     (g (make-float-vector size))
			     (b (make-float-vector size))
			     (incr (/ 256.0 size))
			     (er (list 0 60 60 116 128 252 192 252 256 60))
			     (eg (list 0 0  64 0   128 252 192 252 256 0))
			     (eb (list 0 80        128 252 192 0   256 80))
			     (i 0 (+ i 1))
			     (x 0.0))
			    ((= i size)
			     (list r g b))			     
			  (set! (r i) (/ (envelope-interp x er) 256.0))
			  (set! (g i) (/ (envelope-interp x eg) 256.0))
			  (set! (b i) (/ (envelope-interp x eb) 256.0))
			  (set! x (+ x incr)))))

	(add-colormap "sin" 
		      (lambda (size) 
			(do ((r (make-float-vector size))
			     (g (make-float-vector size))
			     (b (make-float-vector size))
			     (incr (/ (* 2 pi) size))
			     (i 0 (+ i 1))
			     (x 0.0))
			    ((= i size)
			     (list r g b))     
			  (set! (r i) (abs (sin (* 1.5 x))))
			  (set! (g i) (abs (sin (* 3.5 x))))
			  (set! (b i) (abs (sin (* 2.5 x))))
			  (set! x (+ x incr)))))

	(add-colormap "another-sin" 
		      (lambda (size) 
			(do ((r (make-float-vector size))
			     (g (make-float-vector size))
			     (b (make-float-vector size))
			     (incr (/ (* 2 pi) size))
			     (i 0 (+ i 1))
			     (x 0.0))
			    ((= i size)
			     (list r g b))     
			  (set! (r i) (abs (sin (* 2.5 x))))
			  (set! (g i) (abs (sin (* 3.5 x))))
			  (set! (b i) (abs (sin (* 4.5 x))))
			  (set! x (+ x incr)))))
	
	(delete-colormap pink-colormap)
	(if (colormap? pink-colormap)
	    (snd-display "delete-colormap ~A: ~A" pink-colormap (colormap? pink-colormap)))
	(let ((tag (catch #t (lambda () (set! *colormap* pink-colormap)) (lambda args args))))
	  (if (or (not (eq? (car tag) 'no-such-colormap))
		  (equal? *colormap* pink-colormap))
	      (snd-display "delete pink colormap: ~A ~A ~A" tag pink-colormap *colormap*)))
	
	(for-each
	 (lambda (n)
	   (set! *colormap-size* n)
	   (do ((n2 (> n 2))
		(n/n (- 1.0 (/ 1.0 n)))
		(i 0 (+ i 1))) 
	       ((= i 10))
	     (let* ((x (random 1.0))
		    (rgb (colormap-ref copper-colormap x)))
	       (let ((r (if (< x 4/5) (* 5/4 x) 1.0))
		     (g (* 4/5 x))
		     (b (* 1/2 x))
		     (r1 (rgb 0))
		     (g1 (rgb 1))
		     (b1 (rgb 2)))
		 (if (and n2 (< x n/n) (or (cfneq r r1) (cfneq g g1) (cfneq b b1)))
		     (snd-display "copper size reset ~A: ~,3F (~,3F): ~{~,3F ~} ~{~,3F ~}" 
				  n x (max (abs (- r r1)) (abs (- g g1)) (abs (- b b1))) (list r g b) (list r1 g1 b1)))))))
	 '(1024 256 2 512))
	(set! *colormap-size* 512)
	
	(set! (hook-functions graph-hook) ())))))


;;; ---------------- test 8: clm ----------------

(require snd-moog.scm snd-poly.scm snd-bird.scm snd-v.scm snd-numerics.scm snd-generators.scm)
(if (defined? 'gsl-roots) (require snd-analog-filter.scm))

;;; -------- scissor-tailed flycatcher
;;;
;;; mix a scissor-tailed flycatcher call into the current sound
;;; see bird.scm for lots more birds


(define scissor 
  (let ((+documentation+ "(scissor beg) is the scissor-tailed flycatcher"))
    (lambda (begin-time) ; test 23 also
      (bigbird begin-time 0.05 1800 1800 .2 
	       '(0 0  40 1  60 1  100 0)
	       '(0 0  25 1  75 1  100 0) 
	       '(1 .5  2 1  3 .5  4 .1  5 .01)))))

(define (snd_test_8)

  (define (copy-test o)
    (let ((p (copy o)))
      (if (not (equal? o p))
	  (snd-display "copy ~A != ~A~%" o p))
      (mus-apply o 1.0)
      (if (equal? o p)
	  (snd-display "copy/run ~A == ~A~%" o p))
      (set! p (mus-copy o))
      (if (not (equal? o p))
	  (snd-display "mus-copy ~A != ~A~%" o p))))
  
  ;; ----------------
  (define array-interp-sound-diff 
    (let ((envelope->float-vector 
	   (lambda (e len)
	     (do ((v (make-float-vector len))
		  (e (make-env e :length len))
		  (i 0 (+ i 1)))
		 ((= i len) v)
	       (set! (v i) (env e))))))
      (lambda* (snd chn)
	(let ((tbl (envelope->float-vector '(0.0 -1.0 1.0 1.0) 1001))
	      (curpos (edit-position snd chn)))
	  (map-channel (lambda (y)
			 (array-interp tbl (+ 500.0 (* y 500)) 1000))
		       0 #f snd chn)
	  
	  (let ((r (make-sampler 0 snd chn 1 curpos))
		(mx 0.0))
	    (scan-channel (lambda (y) 
			    (set! mx (max mx (abs (- y (next-sample r))))))
			  0 #f snd chn)
	    mx)))))
  
  ;; ----------------
  (define make-papoulis-window 
    (let ((+documentation+ "(make-papoulis-window size) returns a papoulis window os the given size"))
      (lambda (n)
	(let ((v (make-float-vector n))
	      (n2 (/ n 2)))
	  (do ((i (- n2) (+ i 1)))
	      ((= i n2))
	    (let* ((ratio (/ i n))
		   (pratio (* 2 pi ratio)))
	      (set! (v (+ i n2)) (+ (/ (abs (sin pratio)) pi)
				    (* (- 1.0 (* 2 (abs ratio)))
				       (cos pratio))))))
	  v))))
      
  ;; ----------------
  (define make-dpss-window 
    (let ((+documentation+ "(make-dpss-window size w) returns a prolate spheriodal (slepian) window of the given size"))
      ;; from Verma, Bilbao, Meng, "The Digital Prolate Spheroidal Window"
      ;; output checked using Julius Smith's dpssw.m, although my "w" is different
      (lambda (n w)
	(let ((mat (make-float-vector (list n n)))
	      (cw (cos (* 2 pi w))))
	  (do ((n-1 (- n 1))
	       (n/2 (* 0.5 (- n 1)))
	       (i 0 (+ i 1)))
	      ((= i n))
	    (let ((n2 (- n/2 i)))
	      (set! (mat i i) (* cw n2 n2))
	      (if (< i n-1)
		  (set! (mat i (+ i 1)) (* 0.5 (+ i 1) (- n-1 i))))
	      (if (> i 0)
		  (set! (mat i (- i 1)) (* 0.5 i (- n i))))))
	  (let ((v (let ((vc (vector-ref (cadr (gsl-eigenvectors mat)) 0))) ; cadr->vector of fv-vectors
		     (copy vc (make-float-vector (length vc)))))
		(pk 0.0))
	    ;; sign of eigenvalue is arbitrary, and eigenvector is scaled to sum to 1.0
	    ;;   but we want peak of 1.0 to serve as fft window
	    (do ((i 0 (+ i 1)))
		((= i n))
	      (if (> (abs (v i)) (abs pk))
		  (set! pk (v i)))) 
	    (float-vector-scale! v (/ 1.0 pk)))))))
  
  ;; ----------------
  (define test-lpc
    (let ((make-sine 
	   (lambda* ((n 16))
	     (do ((data (make-float-vector n))
		  (incr (/ (* 2.0 pi) n))
		  (i 0 (+ i 1))
		  (x 0.0))
		 ((= i n) data) 
	       (set! (data i) (sin x))
	       (set! x (+ x incr)))))
	  
	  (make-sines 
	   (lambda (n) 
	     (do ((data (make-float-vector n))
		  (incr (/ (* 2.0 pi) n))
		  (i 0 (+ i 1))
		  (x 0.0))
		 ((= i n) data) 
	       (set! (data i) (+ (sin x)
				 (* .25 (sin (* 2.0 x)))
				 (* .125 (sin (* 4.0 x)))))
	       (set! x (+ x incr))))))
      (lambda ()
	(let ((vals (lpc-predict #r(0 1 2 3 4 5 6 7) 8 (lpc-coeffs #r(0 1 2 3 4 5 6 7) 8 4) 4 2)))
	  (if (not (mus-arrays-equal? vals #r(7.906 8.557)))
	      (snd-display "predict ramp: ~A" vals)))
	(let ((vals (lpc-predict #r(0 1 2 3 4 5 6 7) 8 (lpc-coeffs #r(0 1 2 3 4 5 6 7) 8 7) 7 2)))
	  (if (not (mus-arrays-equal? vals #r(7.971 8.816))) 
	      (snd-display "predict ramp 1: ~A" vals)))
	(let ((vals (lpc-predict #r(0 1 2 3 4 5 6 7 8 9 10 11 12 13 14) 15 
				 (lpc-coeffs #r(0 1 2 3 4 5 6 7 8 9 10 11 12 13 14) 15 7) 7 5)))
	  (if (not (mus-arrays-equal? vals #r(14.999 15.995 16.980 17.940 18.851)))
	      (snd-display "predict ramp 2: ~A" vals)))
	(let ((vals (lpc-predict #r(0 1 2 3 4 5 6 7 8 9 10 11 12 13 14) 15 
				 (lpc-coeffs #r(0 1 2 3 4 5 6 7 8 9 10 11 12 13 14) 15 14) 14 5)))
	  (if (not (mus-arrays-equal? vals #r(15.000 16.000 16.998 17.991 18.971)))
	      (snd-display "predict ramp 3: ~A" vals)))
	(let ((vals (lpc-predict (make-sine) 16 (lpc-coeffs (make-sine) 16 8) 8 2)))
	  (if (not (mus-arrays-equal? vals #r(0.000 0.383)))
	      (snd-display "predict sine: ~A" vals)))
	(let ((vals (lpc-predict (make-sine) 16 (lpc-coeffs (make-sine) 16 8) 8 8)))
	  (if (not (mus-arrays-equal? vals #r(0.000 0.383 0.707 0.924 1.000 0.924 0.707 0.383)))
	      (snd-display "predict sine 1: ~A" vals)))
	(let ((vals (lpc-predict (make-sines 32) 32 (lpc-coeffs (make-sines 32) 32 8) 8 8)))
	  (if (not (mus-arrays-equal? vals #r(0.000 0.379 0.686 0.880 0.970 1.001 1.022 1.053)))
	      (snd-display "predict sines: ~A" vals)))
	(let ((vals (lpc-predict (make-sines 32) 32 (lpc-coeffs (make-sines 32) 32 16) 16 8)))
	  (if (not (or (mus-arrays-equal? vals #r(0.000 0.379 0.684 0.876 0.961 0.987 1.006 1.046))
		       (mus-arrays-equal? vals #r(0.000 0.379 0.685 0.876 0.961 0.985 0.998 1.029))))
	      (snd-display "predict sines 1: ~A" vals)))
	(let ((vals (lpc-predict (make-sines 32) 32 (lpc-coeffs (make-sines 32) 32 30) 30 4)))
	  (if (not (or (mus-arrays-equal? vals #r(0.000 0.379 0.685 0.878))
		       (mus-arrays-equal? vals #r(0.000 0.379 0.684 0.875)))) ; double float-vectors
	      (snd-display "predict sines 2: ~A" vals)))
	(let ((vals (lpc-predict (make-sines 64) 64 (lpc-coeffs (make-sines 64) 64 32) 32 8)))
	  (if (not (mus-arrays-equal? vals #r(0.000 0.195 0.379 0.545 0.684 0.795 0.875 0.927)))
	      (snd-display "predict sines 3: ~A" vals))))))
  
  ;; ----------------
  (define (test-unclip-channel)
    (let ((ind (new-sound "test.snd" 2 22050 mus-lfloat mus-next "unclip-channel test" 1)))
      (set! (sync ind) 1)
      
      (mix "oboe.snd" 0 0 ind 0 #f)
      (mix "oboe.snd" 0 0 ind 1 #f)
      (let ((scl (/ 1.01 (maxamp ind 0)))
	    (dur (framples ind 0)))
	(scale-channel scl 0 dur ind 0)
	(scale-channel scl 0 dur ind 1))
      
      (let* ((vals (unclip-channel ind 1))
	     (umax (vals 1))
	     (clips (vals 3))
	     (lmax (vals 5)))
	(if (not (= clips 20)) (snd-display "unclip-channel 0 oboe clips: ~A" clips))
	(if (not (= lmax 1)) (snd-display "unclip-channel 0 oboe max len: ~A" lmax))
	(if (fneq umax .999) (snd-display "unclip-channel 0 oboe maxamp: ~A" umax)))
      
      (revert-sound ind)
      (do ((data (make-float-vector 100))
	   (e (make-env '(0 0 1 .8 1.5 1.0 2.0 1.0 2.5 .8 3.5 0) :length 101))
	   (o (make-oscil 1000))
	   (i 0 (+ i 1))) 
	  ((= i 100)
	   (float-vector->channel data 0 100 ind 0)
	   (float-vector->channel data 0 100 ind 1))
	(set! (data i) (* 1.05 (env e) (oscil o))))
      
      (let* ((vals (unclip-channel ind 1))
	     (umax (vals 1))
	     (clips (vals 3))
	     (lmax (vals 5)))
	(if (not (= clips 1)) (snd-display "unclip-channel 1 sine clips: ~A" clips))
	(if (not (= lmax 2)) (snd-display "unclip-channel 1 sine max len: ~A" lmax))
	(if (fneq umax .999) (snd-display "unclip-channel 1 sine maxamp: ~A" umax)))
      
      (revert-sound ind)
      (do ((data (make-float-vector 100))
	   (e (make-env '(0 0 1 .8 1.75 1.0 2.0 1.0 2.25 .8 3.5 0) :length 101))
	   (o (make-oscil 1000))
	   (i 0 (+ i 1)))
	  ((= i 100)
	   (float-vector->channel data 0 100 ind 0)
	   (float-vector->channel data 0 100 ind 1))
	(set! (data i) (* 1.1 (env e) (oscil o))))
      
      (let* ((vals (unclip-channel ind 1))
	     (umax (vals 1))
	     (clips (vals 3))
	     (lmax (vals 5)))
	(if (not (= clips 1)) (snd-display "unclip-channel 2 sine clips: ~A" clips))
	(if (not (= lmax 3)) (snd-display "unclip-channel 2 sine max len: ~A" lmax))
	(if (fneq umax .999) (snd-display "unclip-channel 2 sine maxamp: ~A" umax)))
      
      (revert-sound ind)
      (do ((data (make-float-vector 100))
	   (e (make-env '(0 0 1 .8 1.85 1.0 2.0 1.0 2.15 .8 3.5 0) :length 101))
	   (o1 (make-oscil 1000))
	   (o2 (make-oscil 2000))
	   (i 0 (+ i 1))) 
	    ((= i 100)
	     (float-vector->channel data 0 100 ind 0)
	     (float-vector->channel data 0 100 ind 1))
	(set! (data i) (* 1.2 (env e) (+ (* .75 (oscil o1)) (* .25 (oscil o2))))))
      
      (let* ((vals (unclip-channel ind 1))
	     (umax (vals 1))
	     (clips (vals 3))
	     (lmax (vals 5)))
	(if (not (= clips 1)) (snd-display "unclip-channel 3 sine clips: ~A" clips))
	(if (not (= lmax 1)) (snd-display "unclip-channel 3 sine max len: ~A" lmax))
	(if (fneq umax .999) (snd-display "unclip-channel 3 sine maxamp: ~A" umax)))
      
      (revert-sound ind)
      (do ((data (make-float-vector 100))
	   (e (make-env '(0 0 40 .75 45 1.0 50 1.25 55 1.0 60 .75 100 0.0) :length 101))
	   (o1 (make-oscil 1000))
	   (o2 (make-oscil 2000))
	   (i 0 (+ i 1))) 
	  ((= i 100)
	   (float-vector->channel data 0 100 ind 0)
	   (float-vector->channel data 0 100 ind 1))
	(set! (data i) (* 1.5 (env e) (+ (* .75 (oscil o1)) (* .25 (oscil o2))))))
      
      (let* ((vals (unclip-channel ind 1))
	     (umax (vals 1))
	     (clips (vals 3))
	     (lmax (vals 5)))
	(if (not (= clips 1)) (snd-display "unclip-channel 4 sine clips: ~A" clips))
	(if (not (= lmax 4)) (snd-display "unclip-channel 4 sine max len: ~A" lmax))
	(if (fneq umax .999) (snd-display "unclip-channel 4 sine maxamp: ~A" umax)))
      
      (revert-sound ind)
      (let ((data (make-float-vector 100))
	    (o1 (make-oscil 1000)))
	(do ((i 0 (+ i 1))) 
	    ((= i 100)) 
	  (set! (data i) (* .25 (oscil o1))))
	(let ((true-max (float-vector-peak data)))
	  (set! (data 50) (+ (data 50) 1.25))
	  (float-vector->channel data 0 100 ind 0)
	  (float-vector->channel data 0 100 ind 1)
	  
	  (let* ((vals (unclip-channel ind 1))
		 (umax (vals 1))
		 (clips (vals 3))
		 (lmax (vals 5)))
	    (if (not (= clips 1)) (snd-display "unclip-channel 5 click clips: ~A" clips))
	    (if (not (= lmax 1)) (snd-display "unclip-channel 5 click max len: ~A" lmax))
	    (if (fneq umax true-max) (snd-display "unclip-channel 5 click maxamp: ~A ~A" umax true-max)))))
      
      (revert-sound ind)
      (let ((data (make-float-vector 100))
	    (o1 (make-oscil 1000)))
	(do ((i 0 (+ i 1))) 
	    ((= i 100)) 
	  (set! (data i) (* .25 (oscil o1))))
	(let ((true-max (float-vector-peak data)))
	  (do ((i 49 (+ i 1)))
	      ((= i 51))
	    (set! (data i) (+ (data i) 1.25)))
	  (float-vector->channel data 0 100 ind 0)
	  (float-vector->channel data 0 100 ind 1)
	  
	  (let* ((vals (unclip-channel ind 1))
		 (umax (vals 1))
		 (clips (vals 3))
		 (lmax (vals 5)))
	    (if (not (= clips 1)) (snd-display "unclip-channel 6 click clips: ~A" clips))
	    (if (not (= lmax 2)) (snd-display "unclip-channel 6 click max len: ~A" lmax))
	    (if (fneq umax true-max) (snd-display "unclip-channel 6 click maxamp: ~A ~A" umax true-max)))))
      
      (revert-sound ind)
      (let ((data (make-float-vector 100))
	    (o1 (make-oscil 1000)))
	(do ((i 0 (+ i 1))) 
	    ((= i 100)) 
	  (set! (data i) (* .25 (oscil o1))))
	(let ((true-max (float-vector-peak data)))
	  (do ((i 45 (+ i 1)))
	      ((= i 55))
	    (set! (data i) (+ (data i) 1.25)))
	  (float-vector->channel data 0 100 ind 0)
	  (float-vector->channel data 0 100 ind 1)
	  
	  (let* ((vals (unclip-channel ind 1))
		 (umax (vals 1))
		 (clips (vals 3))
		 (lmax (vals 5)))
	    (if (not (= clips 1)) (snd-display "unclip-channel 7 click clips: ~A" clips))
	    (if (not (= lmax 10)) (snd-display "unclip-channel 7 click max len: ~A" lmax))
	    (if (fneq umax true-max) (snd-display "unclip-channel 7 click maxamp: ~A ~A" umax true-max)))))
      
      (revert-sound ind)
      (let ((data (make-float-vector 100))
	    (o1 (make-oscil 1000))
	    (o2 (make-oscil 2000)))
	(do ((i 0 (+ i 1))) 
	    ((= i 100)) 
	  (set! (data i) (* .25 (+ (oscil o1) (oscil o2)))))
	(let ((true-max (float-vector-peak data)))
	  (do ((i 45 (+ i 1)))
	      ((= i 55))
	    (set! (data i) (+ (data i) 1.25)))
	  (float-vector->channel data 0 100 ind 0)
	  (float-vector->channel data 0 100 ind 1)
	  
	  (let* ((vals (unclip-channel ind 1))
		 (umax (vals 1))
		 (clips (vals 3))
		 (lmax (vals 5)))
	    (if (not (= clips 1)) (snd-display "unclip-channel 8 click clips: ~A" clips))
	    (if (not (= lmax 10)) (snd-display "unclip-channel 8 click max len: ~A" lmax))
	    (if (fneq umax true-max) (snd-display "unclip-channel 8 click maxamp: ~A ~A" umax true-max)))))
      
      (revert-sound ind)
      (let ((data (make-float-vector 200))
	    (o1 (make-oscil 1000))
	    (o2 (make-oscil 2000)))
	(do ((i 0 (+ i 1))) 
	    ((= i 200)) 
	  (set! (data i) (* .25 (+ (oscil o1) (oscil o2)))))
	(let ((true-max (float-vector-peak data)))
	  (do ((i 45 (+ i 1)))
	      ((= i 55))
	    (set! (data i) (+ (data i) 2.0)))
	  (do ((i 75 (+ i 1)))
	      ((= i 85))
	    (set! (data i) (+ (data i) 2.0)))
	  (float-vector->channel data 0 200 ind 0)
	  (float-vector->channel data 0 200 ind 1)
	  
	  (let* ((vals (unclip-channel ind 1))
		 (umax (vals 1))
		 (clips (vals 3))
		 (lmax (vals 5)))
	    (if (not (= clips 2)) (snd-display "unclip-channel 9 collision clips: ~A" clips))
	    (if (not (= lmax 10)) (snd-display "unclip-channel 9 collision max len: ~A" lmax))
	    (if (fneq umax true-max) (snd-display "unclip-channel 9 collision maxamp: ~A ~A" umax true-max)))))
      
      (revert-sound ind)
      (mix "oboe.snd" 0 0 ind 0 #f)
      (mix "oboe.snd" 0 0 ind 1 #f)
      (scale-sound (/ 1.01 (maxamp ind 0)))
      
      (let* ((vals (unclip-channel ind 1))
	     (umax (vals 1))
	     (clips (vals 3))
	     (lmax (vals 5)))
	(if (not (= clips 20)) (snd-display "unclip-channel 10 oboe clips: ~A" clips))
	(if (not (= lmax 1)) (snd-display "unclip-channel 10 oboe max len: ~A" lmax))
	(if (fneq umax 0.999) (snd-display "unclip-channel 10 oboe maxamp: ~A" umax)))
      
      (revert-sound ind)
      (mix "oboe.snd" 0 0 ind 0 #f)
      (mix "oboe.snd" 0 0 ind 1 #f)
      (scale-sound (/ 1.05 (maxamp ind 0)))
      
      (let* ((vals (unclip-channel ind 1))
	     (umax (vals 1))
	     (clips (vals 3))
	     (lmax (vals 5)))
	(if (not (= clips 217)) (snd-display "unclip-channel 11 oboe clips: ~A" clips))
	(if (not (= lmax 2)) (snd-display "unclip-channel 11 oboe max len: ~A" lmax))
	(if (fneq umax 0.999) (snd-display "unclip-channel 11 oboe maxamp: ~A" umax)))
      
      (revert-sound ind)
      (mix "oboe.snd" 0 0 ind 0 #f)
      (mix "oboe.snd" 0 0 ind 1 #f)
      (let ((scl (/ 1.2 (maxamp ind 0))))
	(env-sound (make-env (list 0 0 .48 (/ scl 2) .5 scl .52 (/ scl 2) 1.0 0) :length (framples ind 0))))
      
      (let* ((vals (unclip-channel ind 1))
	     (umax (vals 1))
	     (clips (vals 3))
	     (lmax (vals 5)))
	(if (not (= clips 28)) (snd-display "unclip-channel 12 oboe clips: ~A" clips))
	(if (not (= lmax 3)) (snd-display "unclip-channel 12 oboe max len: ~A" lmax))
	(if (fneq umax 0.999) (snd-display "unclip-channel 12 oboe maxamp: ~A" umax)))
      
      (close-sound ind)))
  
  ;; ----------------
  (define analog-filter-tests
    (let ((sweep->bins 
	   (lambda* (flt (bins 10))
	     (let ((ind (open-sound "sweep.snd")))
	       ((if (mus-generator? flt) clm-channel map-channel) flt)
	       (let ((mx (maxamp))
		     (resp (make-float-vector bins))
		     (size (round (/ 22050 bins)))
		     (data (channel->float-vector)))
		 (do ((i 0 (+ i 1)))
		     ((= i bins))
		   (float-vector-set! resp i (float-vector-peak (subvector data (list size) (* i size)))))
		 (close-sound ind)
		 (list mx resp)))))
	  
	  (filter-response-max 
	   (lambda (f1)
	     (let ((v (make-float-vector 1000)))
	       (set! (v 0) (f1 1.0))
	       (do ((i 1 (+ i 1)))
		   ((= i 1000))
		 (set! (v i) (filter f1 0.0)))
	       (float-vector-peak v))))
	  
	  (filter-equal?   ; equalp in clm2xen is too restrictive
	   (lambda (f1 f2) 
	     (and (= (mus-order f1) (mus-order f2))
		  (mus-arrays-equal? (mus-xcoeffs f1) (mus-xcoeffs f2))
		  (mus-arrays-equal? (mus-ycoeffs f1) (mus-ycoeffs f2))))))
      
      (lambda () 
	;; ---------------- butterworth tests ----------------
	
	(do ((poles (vector #r(1.000 1.414 1.000) ; numerous references provide these tables (y[0] is ignored)
			    #r(1.000 1.848 1.000 1.000 0.765 1.000)
			    #r(1.000 1.932 1.000 1.000 1.414 1.000 1.000 0.518 1.000)
			    #r(1.000 1.962 1.000 1.000 1.663 1.000 1.000 1.111 1.000 1.000 0.390 1.000)
			    #r(1.000 1.975 1.000 1.000 1.782 1.000 1.000 1.414 1.000 1.000 0.908 1.000 1.000 0.313 1.000)))
	     (i 2 (+ i 2))
	     (k 0 (+ k 1)))
	    ((>= i 12))
	  (let ((vals (butterworth-prototype i)))
	    (if (not (mus-arrays-equal? (cadr vals) (poles k)))
		(snd-display "butterworth prototype poles ~A: ~A (~A)" i (cadr vals) (poles k)))
	    (do ((zeros (make-float-vector (* (+ k 1) 3)))
		 (j 2 (+ j 3)))
		((>= j (* (+ k 1) 3))
		 (if (not (mus-arrays-equal? (car vals) zeros))
		     (snd-display "butterworth prototype zeros ~A: ~A (~A)" i (car vals) zeros)))
	      (set! (zeros j) 1.0))))
	
	(do ((cutoff .1 (+ cutoff .1))
	     (m 0 (+ 1 m)))
	    ((= m 3))
	  (do ((clm-cutoff (* *clm-srate* cutoff))
	       (i 2 (+ i 2))
	       (k 1 (+ k 1)))
	      ((= i 16))
	    (let ((local (make-butterworth-lowpass i cutoff))
		  (dsp (make-butter-lp k clm-cutoff)))
	      (if (not (filter-equal? local dsp))
		  (snd-display "butterworth lowpass ~A ~A ~A" cutoff local dsp)))
	    (let ((local (make-butterworth-highpass i cutoff))
		  (dsp (make-butter-hp k clm-cutoff)))
	      (if (not (filter-equal? local dsp))
		  (snd-display "butterworth highpass ~A ~A ~A" cutoff local dsp))))
	  
	  (let ((ind (open-sound "oboe.snd")))
	    (map-channel (make-eliminate-hum 550))
	    (map-channel (make-peaking-2 500 1000 1.0))
	    (map-channel (chordalize))
	    (close-sound ind))
	  
	  (let ((ind (new-sound "sweep.snd" 1 22050 mus-ldouble mus-next #f 22050)))
	    (let ((ph (make-one-pole 1.0 -1.0))
		  (fq (make-one-pole 1.0 -1.0))
		  (incr (/ pi 22050.0)))
	      (map-channel
	       (lambda (y)
		 (* .5 (sin (one-pole ph (one-pole fq incr)))))
	       2)) ; make it look like the old form
	    (save-sound ind)
	    (close-sound ind))
	  
	  (let ((not.5 (lambda (vals) (fneq (car vals) 0.5)))
		(beyond.5 (lambda (vals) (> (abs (- (car vals) .5)) .05))))
	    
	    (let ((vals (sweep->bins (make-butterworth-lowpass 8 .1))))
	      (if (not.5 vals) (snd-display "butterworth lp 8 max: ~A" (car vals)))
	      (if (not (mus-arrays-equal?1 (cadr vals) #r(0.500 0.500 0.359 0.014 0.001 0.000 0.000 0.000 0.000 0.000)))
		  (snd-display "butterworth lp 8 .1 spect: ~A" (cadr vals))))
	    (let ((vals (sweep->bins (make-butterworth-lowpass 12 .25))))
	      (if (not.5 vals) (snd-display "butterworth lp 12 max: ~A" (car vals)))
	      (if (not (mus-arrays-equal?1 (cadr vals) #r(0.500 0.500 0.500 0.500 0.499 0.358 0.010 0.000 0.000 0.000)))
		  (snd-display "butterworth lp 12 .25 spect: ~A" (cadr vals))))
	    (let ((vals (sweep->bins (make-butterworth-lowpass 10 .4))))
	      (if (not.5 vals) (snd-display "butterworth lp 10 max: ~A" (car vals)))
	      (if (not (or (mus-arrays-equal?1 (cadr vals) #r(0.500 0.500 0.500 0.500 0.500 0.500 0.500 0.499 0.361 0.001))
			   (mus-arrays-equal?1 (cadr vals) #r(0.500 0.500 0.500 0.500 0.500 0.500 0.500 0.499 0.360 0.002))))
		  (snd-display "butterworth lp 10 .4 spect: ~A" (cadr vals))))
	    
	    (do ((i 2 (+ i 2)))
		((= i 12))
	      (do ((j .1 (+ j .1)))
		  ((>= j .45))
		(let ((mx (filter-response-max (make-butterworth-lowpass i j))))
		  (if (> mx 1.0)
		      (snd-display "butter low max ~A ~A: ~A" i j mx)))))
	    
	    (let ((vals (sweep->bins (make-butterworth-highpass 8 .1))))
	      (if (not.5 vals) (snd-display "butterworth hp 8 max: ~A" (car vals)))
	      (if (not (mus-arrays-equal?1 (cadr vals) #r(0.001 0.348 0.500 0.500 0.500 0.500 0.500 0.500 0.500 0.500)))
		  (snd-display "butterworth hp 8 .1 spect: ~A" (cadr vals))))
	    (let ((vals (sweep->bins (make-butterworth-highpass 12 .25))))
	      (if (not.5 vals) (snd-display "butterworth hp 12 max: ~A" (car vals)))
	      (if (not (mus-arrays-equal?1 (cadr vals) #r(0.000 0.000 0.000 0.011 0.348 0.500 0.500 0.500 0.500 0.500)))
		  (snd-display "butterworth hp 12 .25 spect: ~A" (cadr vals))))
	    (let ((vals (sweep->bins (make-butterworth-highpass 10 .4))))
	      (if (not.5 vals) (snd-display "butterworth hp 10 max: ~A" (car vals)))
	      (if (not (mus-arrays-equal?1 (cadr vals) #r(0.000 0.000 0.000 0.000 0.000 0.000 0.005 0.343 0.501 0.501)))
		  (snd-display "butterworth hp 10 .4 spect: ~A" (cadr vals))))
	    
	    (let ((vals (sweep->bins (make-butterworth-bandpass 4 .1 .2))))
	      (if (beyond.5 vals) (snd-display "butterworth bp 4 max: ~A" (car vals)))
	      (if (not (mus-arrays-equal?1 (cadr vals) #r(0.028 0.350 0.481 0.479 0.346 0.132 0.038 0.009 0.002 0.000)))
		  (snd-display "butterworth bp 4 .1 .2 spect: ~A" (cadr vals))))
	    (let ((vals (sweep->bins (make-butterworth-bandpass 12 .1 .2))))
	      (if (beyond.5 vals) (snd-display "butterworth bp 12 max: ~A" (car vals)))
	      (if (not (or (mus-arrays-equal?1 (cadr vals) #r(0.006 0.317 0.501 0.500 0.358 0.009 0.000 0.000 0.000 0.000))
			   (mus-arrays-equal?1 (cadr vals) #r(0.012 0.319 0.501 0.500 0.358 0.009 0.000 0.000 0.000 0.000))
			   (mus-arrays-equal?1 (cadr vals) #r(0.000 0.323 0.501 0.500 0.358 0.009 0.000 0.000 0.000 0.000))))
		  (snd-display "butterworth bp 12 .1 .2 spect: ~A" (cadr vals))))
	    (let ((vals (sweep->bins (make-butterworth-bandpass 8 .3 .4))))
	      (if (beyond.5 vals) (snd-display "butterworth bp 8 max: ~A" (car vals)))
	      (if (not (mus-arrays-equal?1 (cadr vals) #r(0.000 0.000 0.000 0.003 0.034 0.344 0.499 0.499 0.353 0.002)))
		  (snd-display "butterworth bp 8 .3 .4 spect: ~A" (cadr vals))))
	    
	    (do ((i 2 (+ i 2)))
		((= i 12))
	      (do ((j .1 (+ j .1)))
		  ((>= j .45))
		(let ((mx (filter-response-max (make-butterworth-highpass i j))))
		  (if (> mx 1.0)
		      (snd-display "butter high max ~A ~A: ~A" i j mx)))))
	    
	    (let ((vals (sweep->bins (make-butterworth-bandstop 4 .1 .2))))
	      (if (beyond.5 vals) (snd-display "butterworth bs 4 max: ~A" (car vals)))
	      (if (not (mus-arrays-equal?1 (cadr vals) #r(0.500 0.500 0.347 0.339 0.481 0.499 0.500 0.500 0.500 0.500)))
		  (snd-display "butterworth bs 4 .1 .2 spect: ~A" (cadr vals))))
	    (let ((vals (sweep->bins (make-butterworth-bandstop 12 .1 .2))))
	      (if (beyond.5 vals) (snd-display "butterworth bs 12 max: ~A" (car vals)))
	      (if (not (or (mus-arrays-equal?1 (cadr vals) #r(0.503 0.503 0.364 0.334 0.500 0.500 0.500 0.500 0.500 0.500))
			   (mus-arrays-equal?1 (cadr vals) #r(0.502 0.503 0.365 0.334 0.500 0.500 0.500 0.500 0.500 0.500))
			   (mus-arrays-equal?1 (cadr vals) #r(0.500 0.500 0.365 0.334 0.500 0.500 0.500 0.500 0.500 0.500))))
		  (snd-display "butterworth bs 12 .1 .2 spect: ~A" (cadr vals))))
	    (let ((vals (sweep->bins (make-butterworth-bandstop 8 .3 .4))))
	      (if (beyond.5 vals) (snd-display "butterworth bs 8 max: ~A" (car vals)))
	      (if (not (mus-arrays-equal?1 (cadr vals) #r(0.500 0.500 0.500 0.500 0.500 0.498 0.354 0.332 0.500 0.500)))
		  (snd-display "butterworth bs 8 .3 .4 spect: ~A" (cadr vals))))
	    
	    
	    ;; ---------------- Chebyshev ----------------
	    
	    ;; ripple .01 .1 1 for 2..10 even
	    
	    (do ((poles-01 (vector #r(1.000 4.456 10.426)
				   #r(1.000 0.822 2.006 1.000 1.984 1.299)
				   #r(1.000 0.343 1.372 1.000 0.937 0.939 1.000 1.280 0.506)
				   #r(1.000 0.189 1.196 1.000 0.537 0.925 1.000 0.804 0.542 1.000 0.948 0.272)
				   #r(1.000 0.119 1.121 1.000 0.347 0.940 1.000 0.540 0.646 1.000 0.680 0.352 1.000 0.754 0.170)))
		 (zeros    (vector #r(0.000 0.000 1.000)
				   #r(0.000 0.000 0.250 0.000 0.000 1.000)
				   #r(0.000 0.000 0.062 0.000 0.000 1.000 0.000 0.000 1.000)
				   #r(0.000 0.000 0.016 0.000 0.000 1.000 0.000 0.000 1.000 0.000 0.000 1.000)
				   #r(0.000 0.000 0.004 0.000 0.000 1.000 0.000 0.000 1.000 0.000 0.000 1.000 0.000 0.000 1.000)))
		 (poles-1  (vector #r(1.000 2.372 3.314)
				   #r(1.000 0.528 1.330 1.000 1.275 0.623)
				   #r(1.000 0.229 1.129 1.000 0.627 0.696 1.000 0.856 0.263)
				   #r(1.000 0.128 1.069 1.000 0.364 0.799 1.000 0.545 0.416 1.000 0.643 0.146)
				   #r(1.000 0.082 1.044 1.000 0.237 0.862 1.000 0.369 0.568 1.000 0.465 0.274 1.000 0.515 0.092)))
		 (poles-10 (vector #r(1.000 1.098 1.103)
				   #r(1.000 0.279 0.987 1.000 0.674 0.279)
				   #r(1.000 0.124 0.991 1.000 0.340 0.558 1.000 0.464 0.125)
				   #r(1.000 0.070 0.994 1.000 0.199 0.724 1.000 0.298 0.341 1.000 0.352 0.070)
				   #r(1.000 0.045 0.996 1.000 0.130 0.814 1.000 0.203 0.521 1.000 0.255 0.227 1.000 0.283 0.045)))
		 (i 2 (+ i 2))
		 (k 0 (+ k 1)))
		((>= i 12))
	      (let ((vals (cadr (chebyshev-prototype i .01))))
		(if (not (mus-arrays-equal?1 vals (poles-01 k)))
		    (snd-display "chebyshev prototype .01 poles ~A: ~A (~A)" i vals (poles-01 k))))
	      (let ((vals (cadr (chebyshev-prototype i .1))))
		(if (not (mus-arrays-equal?1 vals (poles-1 k)))
		    (snd-display "chebyshev prototype .1 poles ~A: ~A (~A)" i vals (poles-1 k))))
	      (let ((vals (chebyshev-prototype i)))
		(if (not (mus-arrays-equal?1 (cadr vals) (poles-10 k)))
		    (snd-display "chebyshev prototype 1 poles ~A: ~A (~A)" i (cadr vals) (poles-10 k)))
		(if (not (mus-arrays-equal? (car vals) (zeros k)))
		    (snd-display "chebyshev prototype .01 zeros ~A: ~A (~A)" i (car vals) (zeros k)))))
	    
	    (let ((vals (sweep->bins (make-chebyshev-lowpass 8 .1))))
	      (if (ffneq (car vals) .51) (snd-display "chebyshev lp 8 max: ~A" (car vals)))
	      (if (not (or (mus-arrays-equal?1 (cadr vals) #r(0.508 0.512 0.468 0.001 0.000 0.000 0.000 0.000 0.000 0.000))
			   (mus-arrays-equal?1 (cadr vals) #r(0.507 0.512 0.467 0.001 0.000 0.000 0.000 0.000 0.000 0.000))
			   (mus-arrays-equal?1 (cadr vals) #r(0.508 0.513 0.469 0.001 0.000 0.000 0.000 0.000 0.000 0.000))
			   (mus-arrays-equal?1 (cadr vals) #r(0.509 0.508 0.465 0.001 0.000 0.000 0.000 0.000 0.000 0.000))))
		  (snd-display "chebyshev lp 8 .1 spect: ~A" (cadr vals))))
	    (let ((vals (sweep->bins (make-chebyshev-lowpass 12 .25))))
	      (if (ffneq (car vals) .51) (snd-display "chebyshev lp 12 max: ~A" (car vals)))
	      (if (not (mus-arrays-equal?1 (cadr vals) #r(0.509 0.500 0.508 0.508 0.507 0.413 0.000 0.000 0.000 0.000)))
		  (snd-display "chebyshev lp 12 .25 spect: ~A" (cadr vals))))
	    (let ((vals (sweep->bins (make-chebyshev-lowpass 10 .4))))
	      (if (ffneq (car vals) .51) (snd-display "chebyshev lp 10 max: ~A" (car vals)))
	      (if (not (mus-arrays-equal?1 (cadr vals) #r(0.465 0.493 0.509 0.508 0.477 0.507 0.508 0.507 0.431 0.000)))
		  (snd-display "chebyshev lp 10 .4 spect: ~A" (cadr vals))))
	    
	    (do ((i 2 (+ i 2)))
		((= i 10))
	      (do ((j .1 (+ j .1)))
		  ((>= j .45))
		(let ((mx (filter-response-max (make-chebyshev-lowpass i j))))
		  (if (> mx 1.0)
		      (snd-display "cheby low max ~A ~A: ~A" i j mx)))))
	    
	    (let ((vals (sweep->bins (make-chebyshev-lowpass 8 .1 .01))))
	      (if (ffneq (car vals) .49) (snd-display "chebyshev lp 8 .1 .01 max: ~A" (car vals)))
	      (if (not (mus-arrays-equal?1 (cadr vals) #r(0.492 0.491 0.483 0.006 0.000 0.000 0.000 0.000 0.000 0.000)))
		  (snd-display "chebyshev lp 8 .1 .01 spect: ~A" (cadr vals))))
	    (let ((vals (sweep->bins (make-chebyshev-lowpass 12 .25 .1))))
	      (if (ffneq (car vals) .49) (snd-display "chebyshev lp 12 .1 max: ~A" (car vals)))
	      (if (not (mus-arrays-equal?1 (cadr vals) #r(0.488 0.488 0.488 0.488 0.487 0.403 0.000 0.000 0.000 0.000)))
		  (snd-display "chebyshev lp 12 .25 .1 spect: ~A" (cadr vals))))
	    (let ((vals (sweep->bins (make-chebyshev-lowpass 10 .4 .001))))
	      (if (ffneq (car vals) .49) (snd-display "chebyshev lp 10 .001 max: ~A" (car vals)))
	      (if (not (mus-arrays-equal?1 (cadr vals) #r(0.497 0.497 0.497 0.497 0.497 0.497 0.497 0.497 0.488 0.000)))
		  (snd-display "chebyshev lp 10 .4 .001 spect: ~A" (cadr vals))))
	    
	    (let ((vals (sweep->bins (make-chebyshev-highpass 8 .1))))
	      (if (ffneq (car vals) .55) (snd-display "chebyshev hp 8 max: ~A" (car vals)))
	      (if (not (mus-arrays-equal?1 (cadr vals) #r(0.000 0.341 0.551 0.509 0.466 0.501 0.509 0.505 0.481 0.461)))
		  (snd-display "chebyshev hp 8 .1 spect: ~A" (cadr vals))))
	    (let ((vals (sweep->bins  (make-chebyshev-highpass 12 .25))))
	      (if (ffneq (car vals) .55) (snd-display "chebyshev hp 12 max: ~A" (car vals)))
	      (if (not (mus-arrays-equal?1 (cadr vals) #r(0.000 0.000 0.000 0.000 0.299 0.554 0.509 0.509 0.500 0.509)))
		  (snd-display "chebyshev hp 12 .25 spect: ~A" (cadr vals))))
	    (let ((vals (cadr (sweep->bins (make-chebyshev-highpass 10 .4)))))
	      (if (not (or (mus-arrays-equal?1 vals #r(0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.297 0.786 0.677))
			   (mus-arrays-equal?1 vals #r(0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.301 0.788 0.660))
			   (mus-arrays-equal?1 vals #r(0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.322 0.861 0.724))
			   (mus-arrays-equal?1 vals #r(0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.262 0.571 0.509))))
		  (snd-display "chebyshev hp 10 .4 spect: ~A" vals)))
	    
	    (let ((vals (sweep->bins (make-chebyshev-highpass 8 .1 .01))))
	      (if (ffneq (car vals) .49) (snd-display "chebyshev hp 8 .1 .01 max: ~A" (car vals)))
	      (if (not (mus-arrays-equal?1 (cadr vals) #r(0.000 0.498 0.498 0.492 0.491 0.492 0.492 0.492 0.491 0.491)))
		  (snd-display "chebyshev hp 8 .1 .01 spect: ~A" (cadr vals))))
	    (let ((vals (sweep->bins (make-chebyshev-highpass 12 .25 .1))))
	      (if (ffneq (car vals) .51) (snd-display "chebyshev hp 12 .1 max: ~A" (car vals)))
	      (if (not (mus-arrays-equal?1 (cadr vals) #r(0.000 0.000 0.000 0.000 0.453 0.516 0.489 0.489 0.488 0.488)))
		  (snd-display "chebyshev hp 12 .25 .1 spect: ~A" (cadr vals))))
	    (let ((vals (sweep->bins (make-chebyshev-highpass 10 .4 .001))))
	      (if (ffneq (car vals) .5) (snd-display "chebyshev hp 10 .001 max: ~A" (car vals)))
	      (if (not (or (mus-arrays-equal?1 (cadr vals) #r(0.000 0.000 0.000 0.000 0.000 0.000 0.002 0.501 0.504 0.504))
			   (mus-arrays-equal?1 (cadr vals) #r(0.000 0.000 0.000 0.000 0.000 0.000 0.002 0.503 0.505 0.504))
			   (mus-arrays-equal?1 (cadr vals) #r(0.000 0.000 0.000 0.000 0.000 0.000 0.002 0.503 0.501 0.497))))
		  (snd-display "chebyshev hp 10 .4 .001 spect: ~A" (cadr vals))))
	    
	    (do ((i 2 (+ i 2)))
		((= i 10))
	      (do ((j .1 (+ j .1)))
		  ((>= j .45))
		(let ((mx (filter-response-max (make-chebyshev-highpass i j))))
		  (if (> mx 1.0)
		      (snd-display "cheby high max ~A ~A: ~A" i j mx)))))
	    
	    (let ((vals (sweep->bins (make-chebyshev-bandpass 4 .1 .2))))
	      (if (beyond.5 vals) (snd-display "chebyshev bp 4 max: ~A" (car vals)))
	      (if (not (mus-arrays-equal?1 (cadr vals) #r(0.009 0.449 0.509 0.505 0.442 0.065 0.013 0.003 0.000 0.000)))
		  (snd-display "chebyshev bp 4 .1 .2 spect: ~A" (cadr vals))))
	    (let ((vals (sweep->bins (make-chebyshev-bandpass 6 .1 .2))))
	      (if (beyond.5 vals) (snd-display "chebyshev bp 6 max: ~A" (car vals)))
	      (if (not (mus-arrays-equal?1 (cadr vals) #r(0.001 0.376 0.505 0.498 0.412 0.011 0.001 0.000 0.000 0.000)))
		  (snd-display "chebyshev bp 6 .1 .2 spect: ~A" (cadr vals))))
	    (let ((vals (sweep->bins (make-chebyshev-bandpass 8 .3 .4))))
	      (if (beyond.5 vals) (snd-display "chebyshev bp 8 max: ~A" (car vals)))
	      (if (not (mus-arrays-equal?1 (cadr vals) #r(0.000 0.000 0.000 0.000 0.002 0.363 0.517 0.513 0.433 0.000)))
		  (snd-display "chebyshev bp 8 .3 .4 spect: ~A" (cadr vals))))
	    (let ((vals (sweep->bins  (make-chebyshev-bandpass 8 .2 .2 .01))))
	      (if (beyond.5 vals) (snd-display "chebyshev bp 10 .2 max: ~A" (car vals)))
	      (if (not (mus-arrays-equal?1 (cadr vals) #r(0.000 0.000 0.015 0.483 0.482 0.021 0.001 0.000 0.000 0.000)))
		  (snd-display "chebyshev bp 10 .2 spect: ~A" (cadr vals))))
	    
	    (let ((vals (sweep->bins (make-chebyshev-bandstop 4 .1 .4))))
	      (if (beyond.5 vals) (snd-display "chebyshev bs 4 max: ~A" (car vals)))
	      (if (not (mus-arrays-equal?1 (cadr vals) #r(0.509 0.505 0.447 0.033 0.006 0.006 0.033 0.445 0.512 0.509)))
		  (snd-display "chebyshev bs 4 .1 .4 spect: ~A" (cadr vals))))
	    (let ((vals (sweep->bins (make-chebyshev-bandstop 8 .1 .4))))
	      (if (> (abs (- (car vals) .51)) .05) (snd-display "chebyshev bs 8 max: ~A" (car vals)))
	      (if (not (or (mus-arrays-equal?1 (cadr vals) #r(0.508 0.512 0.468 0.001 0.000 0.000 0.001 0.345 0.551 0.507))
			   (mus-arrays-equal?1 (cadr vals) #r(0.507 0.512 0.467 0.001 0.000 0.000 0.001 0.344 0.549 0.508))
			   (mus-arrays-equal?1 (cadr vals) #r(0.508 0.513 0.469 0.001 0.000 0.000 0.001 0.345 0.552 0.508))
			   (mus-arrays-equal?1 (cadr vals) #r(0.509 0.508 0.465 0.001 0.000 0.000 0.001 0.343 0.548 0.508))))
		  (snd-display "chebyshev bs 8 .1 .4 spect: ~A" (cadr vals))))
	    (let ((vals (sweep->bins (make-chebyshev-bandstop 8 .1 .4 .01))))
	      (if (beyond.5 vals) (snd-display "chebyshev bs 8 .01 max: ~A" (car vals)))
	      (if (not (mus-arrays-equal?1 (cadr vals) #r(0.492 0.491 0.483 0.006 0.000 0.000 0.006 0.494 0.495 0.492)))
		  (snd-display "chebyshev bs 8 .1 .4 .01 spect: ~A" (cadr vals))))
	    
	    
	    ;; ---------------- inverse-chebyshev ----------------
	    
	    (let ((vals (sweep->bins (make-inverse-chebyshev-lowpass 8 .1))))
	      (if (ffneq (car vals) .51) (snd-display "inverse-chebyshev lp 8 max: ~A" (car vals)))
	      (if (not (or (mus-arrays-equal?1 (cadr vals) #r(0.501 0.496 0.001 0.000 0.001 0.000 0.000 0.000 0.000 0.001))
			   (mus-arrays-equal?1 (cadr vals) #r(0.500 0.498 0.001 0.000 0.001 0.000 0.000 0.000 0.000 0.001))))
		  (snd-display "inverse-chebyshev lp 8 .1 spect: ~A" (cadr vals))))
	    (let ((vals (sweep->bins (make-inverse-chebyshev-lowpass 12 .25))))
	      (if (ffneq (car vals) .51) (snd-display "inverse-chebyshev lp 12 max: ~A" (car vals)))
	      (if (not (mus-arrays-equal?1 (cadr vals) #r(0.500 0.500 0.500 0.500 0.496 0.001 0.001 0.001 0.001 0.001)))
		  (snd-display "inverse-chebyshev lp 12 .25 spect: ~A" (cadr vals))))
	    (let ((vals (sweep->bins (make-inverse-chebyshev-lowpass 10 .4))))
	      (if (ffneq (car vals) .51) (snd-display "inverse-chebyshev lp 10 max: ~A" (car vals)))
	      (if (not (or (mus-arrays-equal?1 (cadr vals) #r(0.500 0.500 0.500 0.500 0.500 0.500 0.500 0.497 0.001 0.001))
			   (mus-arrays-equal?1 (cadr vals) #r(0.500 0.500 0.500 0.500 0.500 0.500 0.500 0.497 0.002 0.002))))
		  (snd-display "inverse-chebyshev lp 10 .4 spect: ~A" (cadr vals))))
	    (let ((vals (sweep->bins (make-inverse-chebyshev-lowpass 10 .4 120))))
	      (if (ffneq (car vals) .51) (snd-display "inverse-chebyshev lp 10 max: ~A" (car vals)))
	      (if (not (mus-arrays-equal?1 (cadr vals) #r(0.501 0.501 0.501 0.501 0.501 0.500 0.345 0.007 0.000 0.000)))
		  (snd-display "inverse-chebyshev lp 10 .4 120 spect: ~A" (cadr vals))))
	    
	    (do ((i 2 (+ i 2)))
		((= i 10))
	      (do ((j .1 (+ j .1)))
		  ((>= j .45))
		(let ((mx (filter-response-max (make-inverse-chebyshev-lowpass i j))))
		  (if (> mx 1.0)
		      (snd-display "inv cheby low max ~A ~A: ~A" i j mx)))))
	    
	    (let ((vals (sweep->bins (make-inverse-chebyshev-highpass 8 .1))))
	      (if (ffneq (car vals) .51) (snd-display "inverse-chebyshev hp 8 max: ~A" (car vals)))
	      (if (not (mus-arrays-equal?1 (cadr vals) #r(0.001 0.001 0.440 0.505 0.505 0.503 0.502 0.501 0.501 0.501)))
		  (snd-display "inverse-chebyshev hp 8 .1 spect: ~A" (cadr vals))))
	    (let ((vals (sweep->bins (make-inverse-chebyshev-highpass 12 .25))))
	      (if (ffneq (car vals) .51) (snd-display "inverse-chebyshev hp 12 max: ~A" (car vals)))
	      (if (not (mus-arrays-equal?1 (cadr vals) #r(0.001 0.001 0.001 0.001 0.001 0.505 0.506 0.503 0.501 0.501)))
		  (snd-display "inverse-chebyshev hp 12 .25 spect: ~A" (cadr vals))))
	    (let ((vals (sweep->bins (make-inverse-chebyshev-highpass 10 .4))))
	      (if (ffneq (car vals) .51) (snd-display "inverse-chebyshev hp 10 .4 max: ~A" (car vals)))
	      (if (not (or (mus-arrays-equal?1 (cadr vals) #r(0.000 0.000 0.000 0.001 0.001 0.001 0.001 0.001 0.503 0.503))
			   (mus-arrays-equal?1 (cadr vals) #r(0.000 0.000 0.000 0.001 0.001 0.001 0.001 0.001 0.505 0.503))
			   (mus-arrays-equal?1 (cadr vals) #r(0.000 0.000 0.000 0.001 0.001 0.001 0.001 0.001 0.509 0.504))))
		  (snd-display "inverse-chebyshev hp 10 .4 spect: ~A" (cadr vals))))
	    (let ((vals (sweep->bins (make-inverse-chebyshev-highpass 10 .1 120))))
	      (if (ffneq (car vals) .51) (snd-display "inverse-chebyshev hp 10 .1 120 max: ~A" (car vals)))
	      (if (not (mus-arrays-equal?1 (cadr vals) #r(0.000 0.000 0.007 0.328 0.502 0.502 0.502 0.501 0.501 0.501)))
		  (snd-display "inverse-chebyshev hp 10 .1 120 spect: ~A" (cadr vals))))
	    
	    (do ((i 2 (+ i 2)))
		((= i 10))
	      (do ((j .1 (+ j .1)))
		  ((>= j .45))
		(let ((mx (filter-response-max (make-inverse-chebyshev-highpass i j))))
		  (if (> mx 1.0)
		      (snd-display "inv cheby high max ~A ~A: ~A" i j mx)))))
	    
	    (let ((vals (sweep->bins (make-inverse-chebyshev-bandpass 10 .1 .2))))
	      (if (beyond.5 vals) (snd-display "inverse-chebyshev bp 4 max: ~A" (car vals)))
	      (if (not (mus-arrays-equal?1 (cadr vals) #r(0.001 0.001 0.498 0.485 0.001 0.001 0.000 0.001 0.000 0.001)))
		  (snd-display "inverse-chebyshev bp 10 .1 .2 spect: ~A" (cadr vals))))
	    (let ((vals (sweep->bins (make-inverse-chebyshev-bandpass 10 .1 .2 30))))
	      (if (beyond.5 vals) (snd-display "inverse-chebyshev bp 6 max: ~A" (car vals)))
	      (if (not (or (mus-arrays-equal?1 (cadr vals) #r(0.026 0.025 0.509 0.505 0.020 0.016 0.012 0.016 0.011 0.016))
			   (mus-arrays-equal?1 (cadr vals) #r(0.030 0.042 0.511 0.505 0.020 0.016 0.012 0.016 0.011 0.016))
			   (mus-arrays-equal?1 (cadr vals) #r(0.022 0.017 0.511 0.505 0.020 0.016 0.012 0.016 0.011 0.016))))
		  (snd-display "inverse-chebyshev bp 10 .1 .2 30 spect: ~A" (cadr vals))))
	    (let ((vals (sweep->bins (make-inverse-chebyshev-bandpass 8 .1 .4))))
	      (if (beyond.5 vals) (snd-display "inverse-chebyshev bp 8 max: ~A" (car vals)))
	      (if (not (mus-arrays-equal?1 (cadr vals) #r(0.001 0.001 0.440 0.506 0.505 0.503 0.502 0.434 0.001 0.001)))
		  (snd-display "inverse-chebyshev bp 8 .1 .4 spect: ~A" (cadr vals))))
	    (let ((vals (sweep->bins (make-inverse-chebyshev-bandpass 8 .3 .4 40))))
	      (if (beyond.5 vals) (snd-display "inverse-chebyshev bp 10 .2 max: ~A" (car vals)))
	      (if (not (mus-arrays-equal?1 (cadr vals) #r(0.002 0.005 0.007 0.007 0.005 0.005 0.503 0.505 0.006 0.005)))
		  (snd-display "inverse-chebyshev bp 10 .2 spect: ~A" (cadr vals))))
	    
	    (let ((vals (sweep->bins (make-inverse-chebyshev-bandstop 4 .1 .4))))
	      (if (beyond.5 vals) (snd-display "inverse-chebyshev bs 4 max: ~A" (car vals)))
	      (if (not (mus-arrays-equal?1 (cadr vals) #r(0.500 0.054 0.001 0.001 0.000 0.000 0.000 0.001 0.055 0.503)))
		  (snd-display "inverse-chebyshev bs 4 .1 .4 spect: ~A" (cadr vals))))
	    (let ((vals (sweep->bins (make-inverse-chebyshev-bandstop 8 .1 .4))))
	      (if (beyond.5 vals) (snd-display "inverse-chebyshev bs 8 max: ~A" (car vals)))
	      (if (not (or (mus-arrays-equal?1 (cadr vals) #r(0.501 0.496 0.001 0.001 0.000 0.000 0.000 0.001 0.507 0.506))
			   (mus-arrays-equal?1 (cadr vals) #r(0.506 0.328 0.000 0.000 0.000 0.000 0.000 0.000 0.268 0.511))
			   (mus-arrays-equal?1 (cadr vals) #r(0.500 0.498 0.001 0.001 0.000 0.000 0.000 0.001 0.507 0.506))))
		  (snd-display "inverse-chebyshev bs 8 .1 .4 spect: ~A" (cadr vals))))
	    (let ((vals (sweep->bins (make-inverse-chebyshev-bandstop 8 .1 .4 90))))
	      (if (beyond.5 vals) (snd-display "inverse-chebyshev bs 8 90 max: ~A" (car vals)))
	      (if (not (or (mus-arrays-equal?1 (cadr vals) #r(0.505 0.325 0.000 0.000 0.000 0.000 0.000 0.000 0.270 0.506))
			   (mus-arrays-equal?1 (cadr vals) #r(0.506 0.328 0.000 0.000 0.000 0.000 0.000 0.000 0.269 0.509))
			   (mus-arrays-equal?1 (cadr vals) #r(0.501 0.327 0.000 0.000 0.000 0.000 0.000 0.000 0.268 0.506))))
		  (snd-display "inverse-chebyshev bs 8 .1 .4 90 spect: ~A" (cadr vals))))
	    
	    
	    ;; ---------------- bessel ----------------
	    
	    ;; checked poly coeff tables, but the prototype has scaling built in
	    
	    (when (provided? 'gsl)
	      (let ((vals (sweep->bins (make-bessel-lowpass 4 .1))))
		(if (not.5 vals) (snd-display "bessel lp 4 .1 max: ~A" (car vals)))
		(if (not (mus-arrays-equal?1 (cadr vals) #r(0.500 0.417 0.209 0.062 0.018 0.005 0.001 0.000 0.000 0.000)))
		    (snd-display "bessel lp 4 .1 spect: ~A" (cadr vals))))
	      (let ((vals (sweep->bins (make-bessel-lowpass 8 .1))))
		(if (not.5 vals) (snd-display "bessel lp 8 max: ~A" (car vals)))
		(if (not (mus-arrays-equal?1 (cadr vals) #r(0.499 0.365 0.116 0.010 0.001 0.000 0.000 0.000 0.000 0.000)))
		    (snd-display "bessel lp 8 .1 spect: ~A" (cadr vals))))
	      (let ((vals (sweep->bins (make-bessel-lowpass 12 .25))))
		(if (not.5 vals) (snd-display "bessel lp 12 max: ~A" (car vals)))
		(if (not (mus-arrays-equal?1 (cadr vals) #r(0.500 0.477 0.410 0.309 0.185 0.063 0.006 0.000 0.000 0.000)))
		    (snd-display "bessel lp 12 .25 spect: ~A" (cadr vals))))
	      (let ((vals (sweep->bins (make-bessel-lowpass 10 .4))))
		(if (not.5 vals) (snd-display "bessel lp 10 max: ~A" (car vals)))
		(if (not (or (mus-arrays-equal?1 (cadr vals) #r(0.500 0.498 0.491 0.479 0.458 0.423 0.364 0.259 0.086 0.001))
			     (mus-arrays-equal?1 (cadr vals) #r(0.500 0.498 0.491 0.479 0.458 0.423 0.364 0.259 0.086 0.002))))
		    (snd-display "bessel lp 10 .4 spect: ~A" (cadr vals))))
	      
	      (do ((i 2 (+ i 2)))
		  ((= i 12))
		(do ((j .1 (+ j .1)))
		    ((>= j .45))
		  (let ((mx (filter-response-max (make-bessel-lowpass i j))))
		    (if (> mx 1.0)
			(snd-display "bess low max ~A ~A: ~A" i j mx)))))
	      
	      (let ((vals (sweep->bins (make-bessel-highpass 8 .1))))
		(if (not.5 vals) (snd-display "bessel hp 8 max: ~A" (car vals)))
		(if (not (mus-arrays-equal?1 (cadr vals) #r(0.001 0.115 0.290 0.386 0.435 0.465 0.483 0.493 0.498 0.500)))
		    (snd-display "bessel hp 8 .1 spect: ~A" (cadr vals))))
	      (let ((vals (sweep->bins (make-bessel-highpass 12 .25))))
		(if (not.5 vals) (snd-display "bessel hp 12 max: ~A" (car vals)))
		(if (not (mus-arrays-equal?1 (cadr vals) #r(0.000 0.000 0.000 0.006 0.063 0.181 0.309 0.410 0.477 0.500)))
		    (snd-display "bessel hp 12 .25 spect: ~A" (cadr vals))))
	      (let ((vals (sweep->bins (make-bessel-highpass 10 .4))))
		(if (ffneq (car vals) .5) (snd-display "bessel hp 10 max: ~A" (car vals)))
		(if (not (mus-arrays-equal?1 (cadr vals) #r(0.000 0.000 0.000 0.000 0.000 0.000 0.004 0.084 0.343 0.499)))
		    (snd-display "bessel hp 10 .4 spect: ~A" (cadr vals))))
	      
	      (let ((vals (sweep->bins (make-bessel-bandpass 4 .1 .2))))
		(if (> (abs (- (car vals) .245)) .05) (snd-display "bessel bp 4 max: ~A" (car vals)))
		(if (not (mus-arrays-equal?1 (cadr vals) #r(0.023 0.176 0.245 0.244 0.179 0.085 0.031 0.008 0.001 0.000)))
		    (snd-display "bessel bp 4 .1 .2 spect: ~A" (cadr vals))))
	      
	      (let ((vals (sweep->bins (make-bessel-bandstop 12 .1 .2))))
		(if (beyond.5 vals) (snd-display "bessel bs 12 max: ~A" (car vals)))
		(if (not (or (mus-arrays-equal?1 (cadr vals) #r(0.498 0.325 0.065 0.066 0.177 0.297 0.389 0.452 0.488 0.500))
			     (mus-arrays-equal?1 (cadr vals) #r(0.499 0.324 0.065 0.066 0.177 0.297 0.389 0.452 0.488 0.500))))
		    (snd-display "bessel bs 12 .1 .2 spect: ~A" (cadr vals))))
	      
	      ;; ---------------- elliptic ----------------
	      
	      (let ((past.5 (lambda (vals) (> (abs (- (car vals) .5)) .1))))
		(let ((vals (sweep->bins (make-elliptic-lowpass 8 .1))))
		  (if (past.5 vals) (snd-display "elliptic lp 8 max: ~A" (car vals)))
		  (if (not (or (mus-arrays-equal?1 (cadr vals) #r(0.500 0.515 0.379 0.000 0.000 0.000 0.000 0.000 0.000 0.000))
			       (mus-arrays-equal?1 (cadr vals) #r(0.500 0.509 0.385 0.000 0.000 0.000 0.000 0.000 0.000 0.000))
			       (mus-arrays-equal?1 (cadr vals) #r(0.499 0.498 0.373 0.000 0.000 0.000 0.000 0.000 0.000 0.000))))
		      (snd-display "elliptic lp 8 .1 spect: ~A" (cadr vals))))
		(let ((vals (sweep->bins (make-elliptic-lowpass 12 .25))))
		  (if (past.5 vals) (snd-display "elliptic lp 12 max: ~A" (car vals)))
		  (if (not (or (mus-arrays-equal?1 (cadr vals) #r(0.476 0.500 0.491 0.499 0.494 0.412 0.003 0.001 0.000 0.000))
			       (mus-arrays-equal?1 (cadr vals) #r(0.476 0.500 0.491 0.499 0.494 0.561 0.004 0.000 0.000 0.000))
			       (mus-arrays-equal?1 (cadr vals) #r(0.476 0.500 0.491 0.499 0.493 0.299 0.006 0.001 0.000 0.000))))
		      (snd-display "elliptic lp 12 .25 spect: ~A" (cadr vals))))
		(let ((vals (sweep->bins (make-elliptic-lowpass 4 .4))))
		  (if (past.5 vals) (snd-display "elliptic lp 4 max: ~A" (car vals)))
		  (if (not (mus-arrays-equal?1 (cadr vals) #r(0.447 0.453 0.462 0.477 0.494 0.500 0.497 0.496 0.445 0.003)))
		      (snd-display "elliptic lp 4 .4 spect: ~A" (cadr vals))))
		(let ((vals (sweep->bins (make-elliptic-lowpass 8 .1 .1))))
		  (if (past.5 vals) (snd-display "elliptic lp 8 .1 max: ~A" (car vals)))
		  (if (not (mus-arrays-equal?1 (cadr vals) #r(0.500 0.499 0.475 0.000 0.000 0.000 0.000 0.000 0.000 0.000)))
		      (snd-display "elliptic lp 8 .1 .1 spect: ~A" (cadr vals))))
		(let ((vals (sweep->bins (make-elliptic-lowpass 8 .1 .1 90))))
		  (if (past.5 vals) (snd-display "elliptic lp 8 .1 90 max: ~A" (car vals)))
		  (if (not (mus-arrays-equal?1 (cadr vals) #r(0.500 0.499 0.475 0.000 0.000 0.000 0.000 0.000 0.000 0.000)))
		      (snd-display "elliptic lp 8 .1 .1 90 spect: ~A" (cadr vals))))
		(let ((vals (sweep->bins (make-elliptic-lowpass 8 .25 .01 90))))
		  (if (past.5 vals) (snd-display "elliptic lp 8 .25 90 max: ~A" (car vals)))
		  (if (not (mus-arrays-equal?1 (cadr vals) #r(0.500 0.500 0.500 0.500 0.499 0.495 0.001 0.000 0.000 0.000)))
		      (snd-display "elliptic lp 8 .25 .1 90 spect: ~A" (cadr vals))))
		
		(let ((vals (sweep->bins (make-elliptic-highpass 4 .1))))
		  (if (past.5 vals) (snd-display "elliptic hp 4 max: ~A" (car vals)))
		  (if (not (mus-arrays-equal?1 (cadr vals) #r(0.004 0.438 0.516 0.499 0.502 0.495 0.478 0.463 0.453 0.447)))
		      (snd-display "elliptic hp 4 .1 spect: ~A" (cadr vals))))
		(let ((vals (cadr (sweep->bins (make-elliptic-highpass 12 .25)))))
		  (if (not (or (mus-arrays-equal?1 vals #r(0.000 0.001 0.001 0.001 0.026 0.934 0.518 0.495 0.503 0.477))
			       (mus-arrays-equal?1 vals #r(0.000 0.001 0.001 0.001 0.033 1.185 0.519 0.495 0.503 0.477))
			       (mus-arrays-equal?1 vals #r(0.000 0.001 0.001 0.001 0.018 0.788 0.520 0.495 0.503 0.477))))
		      (snd-display "elliptic hp 12 .25 spect: ~A" vals)))
		(let ((vals (sweep->bins (make-elliptic-highpass 12 .25 .01 90))))
		  (if (past.5 vals) (snd-display "elliptic hp 12 90 max: ~A" (car vals)))
		  (if (not (mus-arrays-equal?1 (cadr vals) #r(0.000 0.000 0.000 0.000 0.499 0.517 0.503 0.501 0.500 0.500)))
		      (snd-display "elliptic hp 12 .25 90 spect: ~A" (cadr vals))))
		(let ((vals (sweep->bins (make-elliptic-highpass 4 .4))))
		  (if (past.5 vals) (snd-display "elliptic hp 4 max: ~A" (car vals)))
		  (if (not (mus-arrays-equal?1 (cadr vals) #r(0.000 0.000 0.000 0.001 0.001 0.002 0.023 0.447 0.515 0.502)))
		      (snd-display "elliptic hp 4 .4 spect: ~A" (cadr vals))))
		(let ((vals (sweep->bins (make-elliptic-highpass 8 .1 .1))))
		  (if (past.5 vals) (snd-display "elliptic hp 8 .1 max: ~A" (car vals)))
		  (if (not (mus-arrays-equal?1 (cadr vals) #r(0.000 0.478 0.553 0.506 0.499 0.501 0.501 0.499 0.497 0.495)))
		      (snd-display "elliptic hp 8 .1 .1 spect: ~A" (cadr vals))))
		(let ((vals (sweep->bins (make-elliptic-highpass 8 .1 .1 90))))
		  (if (past.5 vals) (snd-display "elliptic hp 8 .1 90 max: ~A" (car vals)))
		  (if (not (mus-arrays-equal?1 (cadr vals) #r(0.000 0.478 0.554 0.506 0.499 0.501 0.501 0.499 0.497 0.495)))
		      (snd-display "elliptic hp 8 .1 .1 90 spect: ~A" (cadr vals))))
		(let ((vals (sweep->bins (make-elliptic-highpass 8 .25 .01 90))))
		  (if (past.5 vals) (snd-display "elliptic hp 8 .25 90 max: ~A" (car vals)))
		  (if (not (mus-arrays-equal?1 (cadr vals) #r(0.000 0.000 0.000 0.001 0.516 0.517 0.507 0.503 0.501 0.500)))
		      (snd-display "elliptic hp 8 .25 .1 90 spect: ~A" (cadr vals))))
		
		(let ((vals (sweep->bins (make-elliptic-bandpass 4 .1 .2 .1))))
		  (if (past.5 vals) (snd-display "elliptic bp 4 max: ~A" (car vals)))
		  (if (not (mus-arrays-equal?1 (cadr vals) #r(0.036 0.546 0.550 0.510 0.501 0.032 0.024 0.009 0.021 0.024)))
		      (snd-display "elliptic bp 4 .1 .2 spect: ~A" (cadr vals))))
		(let ((vals (sweep->bins (make-elliptic-bandpass 6 .1 .2 .1 90))))
		  (if (past.5 vals) (snd-display "elliptic bp 6 max: ~A" (car vals)))
		  (if (not (mus-arrays-equal?1 (cadr vals) #r(0.002 0.511 0.532 0.503 0.492 0.003 0.001 0.001 0.001 0.001)))
		      (snd-display "elliptic bp 6 .1 .2 90 spect: ~A" (cadr vals))))
		
		(let ((vals (sweep->bins (make-elliptic-bandstop 4 .1 .3 .1))))
		  (if (past.5 vals) (snd-display "elliptic bs 4 max: ~A" (car vals)))
		  (if (not (mus-arrays-equal?1 (cadr vals) #r(0.499 0.502 0.498 0.037 0.050 0.540 0.544 0.527 0.526 0.521)))
		      (snd-display "elliptic bs 4 .1 .2 spect: ~A" (cadr vals))))
		(let ((vals (sweep->bins (make-elliptic-bandstop 8 .1 .3 .1 120))))
		  (if (past.5 vals) (snd-display "elliptic bs 8 max: ~A" (car vals)))
		  (if (not (or (mus-arrays-equal?1 (cadr vals) #r(0.500 0.499 0.476 0.000 0.000 0.495 0.526 0.505 0.501 0.501))
			       (mus-arrays-equal?1 (cadr vals) #r(0.500 0.499 0.475 0.000 0.000 0.495 0.526 0.505 0.501 0.501))))
		      (snd-display "elliptic bs 8 .1 .2 spect: ~A" (cadr vals))))
		)))))))
      
  ;; ----------------
  (define poly-roots-tests
    (letrec ((ceql (lambda (a b)
		     (if (null? a)
			 (null? b)
			 (and (not (null? b))
			      (not (or (fneq (real-part (car a)) (real-part (car b)))
				       (fneq (imag-part (car a)) (imag-part (car b)))))
			      (ceql (cdr a) (cdr b)))))))
      (lambda ()
	
	;; degree=0
	(let ((val (poly-roots #r(0.0))))
	  (if (pair? val) (snd-display "poly-roots 0.0: ~A" val)))
	(let ((val (poly-roots #r(12.3))))
	  (if (pair? val) (snd-display "poly-roots 12.3: ~A" val)))
	
	;; degree 0 + x=0
	(let ((val (poly-roots #r(0.0 1.0))))
	  (if (not (ceql val '(0.0))) (snd-display "poly-roots 0.0 1.0: ~A" val)))
	(let ((val (poly-roots #r(0.0 0.0 0.0 121.0))))
	  (if (not (ceql val '(0.0 0.0 0.0))) (snd-display "poly-roots 0.0 0.0 0.0 121.0: ~A" val)))
	
	;; degree=1
	(let ((val (poly-roots #r(-1.0 1.0))))
	  (if (not (ceql val '(1.0))) (snd-display "poly-roots -1.0 1.0: ~A" val)))
	(let ((val (poly-roots #r(-2.0 4.0))))
	  (if (not (ceql val '(0.5))) (snd-display "poly-roots -2.0 4.0: ~A" val)))
	(let ((val (poly-as-vector-roots (vector 0.0-i 1))))
	  (if (not (ceql val '(-0.0+1.0i))) (snd-display "poly-roots: -i 1: ~A" val)))
	
	;; linear x^n
	(let ((val (poly-roots #r(-1.0 0.0 0.0 0.0 1.0))))
	  (if (not (or (ceql val '(0.0-1.0i -1.0 0.0+1.0i 1.0))
		       (ceql val '(1.0 -1.0 0.0+1.0i -0.0-1.0i))))
	      (snd-display "poly-roots -1.0 0.0 0.0 0.0 1.0: ~A" val)))
	(let ((val (poly-roots #r(-16.0 0.0 0.0 0.0 1.0))))
	  (if (not (or (ceql val '(0.0-2.0i -2.0 0.0+2.0i 2.0))
		       (ceql val '(2.0 -2.0 0.0+2.0i -0.0-2.0i))))
	      (snd-display "poly-roots -16.0 0.0 0.0 0.0 1.0: ~A" val)))
	(let ((val (poly-roots #r(-32.0 0 0 0 0 0 0.5))))
	  (if (not (ceql val '(1.0-1.7320i -1.0-1.7320i -2.0 -1.0+1.7320i 1.0+1.7320i 2.0))) (snd-display "poly-roots 32 0 0 0 0 0 0.5: ~A" val)))
	
	;; linear + x=0
	(let ((val (poly-roots #r(0.0 -2.0 4.0))))
	  (if (not (ceql val '(0.0 0.5))) (snd-display "poly-roots 0.0 -2.0 4.0: ~A" val)))
	
	;; degree=2
	(let ((val (poly-roots #r(-1.0 0.0 1.0))))
	  (if (not (ceql val '(1.0 -1.0))) (snd-display "poly-roots -1.0 0.0 1.0: ~A" val)))
	(let ((val (poly-roots #r(15.0 -8.0 1.0))))
	  (if (not (ceql val '(5.0 3.0))) (snd-display "poly-roots 15.0 -8.0 1.0: ~A" val)))
	(let ((val (poly-roots #r(1 -2 1))))
	  (if (not (ceql val '(1.0 1.0))) (snd-display "poly-roots 1 -2 1: ~A" val)))
	(let ((val (poly-as-vector-roots (vector -1 0.0+2i 1))))
	  (if (not (ceql val '(0.0-1.0i 0.0-1.0i))) (snd-display "poly-roots -1 2i 1: ~A" val)))
	(let ((val (poly-roots #r(1 1 5))))
	  (if (not (ceql val '(-0.1+0.43589i -0.1-0.43589i))) (snd-display "poly-roots 1 1 5: ~A" val)))
	
	;; 2 + x=0
	(let ((val (poly-roots #r(0.0 0.0 -1.0 0.0 1.0))))
	  (if (not (ceql val '(0.0 0.0 1.0 -1.0))) (snd-display "poly-roots 0.0 0.0 -1.0 0.0 1.0: ~A" val)))
	
	;; quadratic in x^(n/2)
	(let ((vals (poly-roots #r(1.0 0.0 -2.0 0.0 1.0))))
	  (if (not (or (ceql vals '(-1.0 1.0 -1.0 1.0))
		       (ceql vals '(1.0 1.0 -1.0 -1.0))))
	      (snd-display "poly-roots 1 0 -2 0 1: ~A" vals)))
	(let ((vals (poly-roots #r(64.0 0.0 0.0 -16.0 0.0 0.0 1.0))))
	  (if (not (ceql vals '(-1.0-1.73205i -1.0+1.73205i 2.0 -1.0-1.73205i -1.0+1.73205i 2.0)))
	      (snd-display "poly-roots 64 0 0 -16 0 0 1: ~A" vals)))
	
	;; degree=3
	(let ((val (poly-roots #r(-15.0 23.0 -9.0 1.0))))
	  (if (not (ceql val '(5.0 1.0 3.0))) (snd-display "poly-roots 5 1 3: ~A" val)))
	(let ((val (poly-roots #r(-126 -15 0 1))))
	  (if (not (ceql val '(6.0 -3.0+3.46410i -3.0-3.46410i))) (snd-display "poly-roots -126 -15 0 1: ~A" val)))
	
	(let ((val (poly-roots #r(-1 3 -3 1))))
	  (if (not (ceql val '(1.0 1.0 1.0))) (snd-display "poly-roots -1 3 -3 1: ~A" val))) 
	(let ((val (poly-roots #r(1 -1 -1 1))))
	  (if (not (or (ceql val '(1.0 -1.0 1.0))
		       (ceql val '(-1.0 1.0 1.0))))
	      (snd-display "poly-roots 1 -1 1: ~A" val)))
	(let ((val (poly-roots #r(2 -2 -2 2))))
	  (if (not (or (ceql val '(1.0 -1.0 1.0))
		       (ceql val '(-1.0 1.0 1.0))))
	      (snd-display "poly-roots 2 -2 -2 2: ~A" val)))
	
	(let ((vals (poly-roots #r(-64 0 0 0 0 0 1))))
	  (if (not (ceql vals '(0.999999999999999-1.73205080756888i -1.0-1.73205080756888i -2.0 -1.0+1.73205080756888i 1.0+1.73205080756888i 2.0)))
	      (snd-display "poly-roots 64 6: ~A" vals)))
	(let ((vals (poly-roots #r(64 0 0 -16 0 0 1))))
	  (if (not (ceql vals '(-1.0-1.73205080756888i -1.0+1.73205080756888i 2.0 -1.0-1.73205080756888i -1.0+1.73205080756888i 2.0)))
	      (snd-display "poly-roots 64 16 6: ~A" vals)))
	(do ((i 0 (+ i 1))) ((= i 10)) (poly-roots (float-vector (random 1.0) (random 1.0) (random 1.0))))
	(do ((i 0 (+ i 1))) ((= i 10)) (poly-roots (float-vector (mus-random 1.0) (mus-random 1.0) (mus-random 1.0))))
	
	(let ((vals1 (convolution #r(1 2 3 0 0 0 0 0) #r(1 2 3 0 0 0 0 0) 8))
	      (vals2 (poly* #r(1 2 3 0) #r(1 2 3 0))))
	  (if (not (mus-arrays-equal? vals1 vals2))
	      (snd-display "poly* convolve: ~A ~A" vals1 vals2)))
	
	(let ((random-complex (lambda () (complex (mus-random 1.0) (mus-random 1.0)))))
	  (do ((i 0 (+ i 1))) ((= i 10)) 
	    (poly-as-vector-roots (vector (random-complex) (random-complex))))
	  
	  (do ((i 0 (+ i 1))) ((= i 10)) 
	    (poly-as-vector-roots (vector (random-complex) (random-complex) (random-complex))))
	  
	  (do ((i 0 (+ i 1))) ((= i 10)) 
	    (poly-roots (float-vector (mus-random 1.0) (mus-random 1.0) (mus-random 1.0) (mus-random 1.0))))
	  
	  (do ((i 0 (+ i 1))) ((= i 10)) 
	    (poly-as-vector-roots (vector (random-complex) (random-complex) (random-complex) (random-complex)))))
	
	(do ((i 3 (+ i 1))) ((= i 20)) 
	  (let ((v (make-float-vector i)))
	    (set! (v 0) (mus-random 1.0))
	    (set! (v (- i 1)) 1.0)
	    (poly-roots v)))
	
	(do ((i 3 (+ i 2))) ((= i 21)) 
	  (let ((v (make-float-vector i)))
	    (set! (v 0) (mus-random 1.0))
	    (set! (v (- i 1)) 1.0)
	    (set! (v (/ (- i 1) 2)) 1.0)
	    (poly-roots v)))
	
	(let ((vals (poly-roots #r(1 -1 -1 1))))
	  (if (not (or (ceql vals '(1.0 -1.0 1.0))
		       (ceql vals '(-1.0 1.0 1.0))))
	      (snd-display "poly-roots 1-1-11: ~A" vals)))
	(let ((vals (poly-roots #r(2 -1 -2 1))))
	  (if (not (ceql vals '(2.0 -1.0 1.0))) (snd-display "poly-roots 2-1-21: ~A" vals)))
	(let ((vals (poly-roots #r(-1 1 1 1))))
	  (if (not (ceql vals '(0.543689012692076 -0.771844506346038+1.11514250803994i -0.771844506346038-1.11514250803994i)))
	      (snd-display "poly-roots -1111: ~A" vals)))
	(let ((vals (poly-roots #r(-1 3 -3 1))))
	  (if (not (ceql vals '(1.0 1.0 1.0))) (snd-display "poly-roots -13-31: ~A" vals)))
					;      (let ((vals (poly-roots #r(1 -4 6 -4 1))))
					;	(if (not (ceql vals '(1.0 1.0 1.0 1.0))) (snd-display "poly-roots 1-46-41: ~A" vals)))
	(let ((vals (poly-roots #r(0.5 0 0 1.0))))
	  (if (not (or (ceql vals '(0.396850262992049-0.687364818499302i -0.7937005259841 0.39685026299205+0.687364818499301i))
		       (ceql vals '(0.39685026299205+0.687364818499301i 0.39685026299205-0.687364818499301i -0.7937005259841))
		       (ceql vals '(-7.9370052598409979172089E-1 3.968502629920498958E-1+6.873648184993013E-1i 3.96850262992049E-1-6.873648184993E-1i))))
	      (snd-display "poly-roots 0..5 3: ~A" vals)))
	(let ((vals (poly-roots (poly* (poly* (poly* #r(-1 1) #r(1 1))
					      (poly* #r(-2 1) #r(2 1)))
				       (poly* #r(-3 1) #r(3 1))))))
	  (if (not (ceql vals '(-3.0 3.0 -1.0 1.0 -2.0 2.0)))
	      (snd-display "cube in 2: ~A" vals))))))
  
  ;; -----------------
  (define (test-fm-components)
    (if (and (provided? 'gsl)
	     (not (provided? 'gmp)))
	(let ((str (with-output-to-string
		     (lambda ()
		       (fm-complex-component 1200 1000 100 1.0 4.0 0.0 #f)
		       (fm-cascade-component 2000 2000 500 1.5 50 1.0)))))
      (if (not (string=? str ";fm-complex-component add -0.000-0.010i from J-3(1.0) = -0.020 and I5(4.0) = 0.505
;fm-complex-component add 0.163 from J-2(1.0) = 0.115 and I4(4.0) = 1.416
;fm-complex-component add -0.000+1.469i from J-1(1.0) = -0.440 and I3(4.0) = 3.337
;fm-complex-component add -4.914 from J0(1.0) = 0.765 and I2(4.0) = 6.422
;fm-complex-component add 0.000+4.295i from J1(1.0) = 0.440 and I1(4.0) = 9.759
;fm-complex-component add 1.299 from J2(1.0) = 0.115 and I0(4.0) = 11.302
;fm-complex-component add 0.000-0.191i from J3(1.0) = 0.020 and I-1(4.0) = 9.759
;fm-complex-component add -0.016 from J4(1.0) = 0.002 and I-2(4.0) = 6.422
;fm-cascade-component add 0.512 from J0(1.5) = 0.512 and J0(1.0) = 1.000
"))
	  (snd-display "fm-components are unexpected:~%~S" str)))))
  
  ;; ----------------
  (define fltit
    (let ((+documentation+ "(fltit) returns a time-varying filter: (map-channel (fltit))"))
      (lambda ()
	(let ((flt (make-fir-filter 8 #r(.1 .2 .3 .4 .4 .3 .2 .1))))
	  (do ((xcof (mus-xcoeffs flt)) ; maybe a copy?
	       (es (make-float-vector 8))
	       (i 0 (+ i 1)))
	      ((= i 8)
	       (set! (es 5) 1.00002)
	       (lambda (x)
		 (float-vector-multiply! xcof es)
		 (fir-filter flt x)))
	    (set! (es i) 0.9994)))))) ; something like (+ 1.0 (/ (log 1e-5) (* 0.5 *clm-srate*)))
  
;;; (with-sound ("test.snd") (let ((p (make-pulse-train 1000))) (do ((i 0 (+ i 1))) ((= i 44100)) (outa i (* .5 (pulse-train p))))))
;;; (map-channel (fltit))

  
  ;; ----------------
  (define (freq-sweep dur)
    (let ((ph (make-one-pole 1.0 -1.0))
	  (fq (make-one-pole 1.0 -1.0))
	  (incr (/ pi (* dur 1.05 *clm-srate*)))
	  (len (framples)))
      (do ((data (make-float-vector len))
	   (i 2 (+ i 1)))
	  ((= i len)
	   (float-vector->channel (float-vector-scale! data 0.5)))
	(set! (data i) (sin (one-pole ph (one-pole fq incr)))))))

  
  ;; ----------------
  (define make-ssb-am-1 
    (let ()
      (defgenerator sa1 freq (coscar #f) (sincar #f) (dly #f) (hlb #f))
      (lambda* (freq (order 40))
	(if (even? order) (set! order (+ 1 order)))
	(make-sa1 :freq (abs freq)
		  :coscar (make-oscil freq (* .5 pi))
		  :sincar (make-oscil freq)
		  :dly (make-delay order)
		  :hlb (make-hilbert-transform order)))))
  
  ;; ----------------
  (define* (ssb-am-1 gen y (fm-1 0.0))
    (let* ((ccos (oscil (gen 'coscar) fm-1))
	   (csin (oscil (gen 'sincar) fm-1)))
      ((if (> (gen 'freq) 0.0) - +) 
       (* ccos (delay (gen 'dly) y))
       (* csin (hilbert-transform (gen 'hlb) y)))))
  
  ;; ----------------

  (define (rough-spectrum ind)
    (let ((data (channel->float-vector 0 10000 ind 0))
	  (spect (make-float-vector 10))
	  (g (make-one-pole 1.0 -1.0)))
      (float-vector-multiply! data data)
      (do ((i 0 (+ i 1))
	   (beg 0 (+ beg 1000))
	   (end 999 (+ end 1000)))
	  ((= i 10))
	(mus-reset g)
	(do ((j beg (+ j 1)))
	    ((= j end))
	  (one-pole g (float-vector-ref data j)))
	(float-vector-set! spect i (one-pole g (float-vector-ref data end))))
      (float-vector-scale! spect (/ 1.0 (float-vector-peak spect)))))
  
  ;; ----------------
  (define* (print-and-check gen name desc (desc1 "") (desc2 ""))
    
    (if (not (string=? (mus-name gen) name))
	(snd-display "mus-name ~A: ~A?" name (mus-name gen)))
    (if (not (or (string=? (mus-describe gen) desc)
		 (string=? (mus-describe gen) desc1)
		 (string=? (mus-describe gen) desc2)))
	(snd-display "mus-describe ~A: ~A?" (mus-name gen) (mus-describe gen)))
    (let ((egen gen))
      (if (not (equal? egen gen))
	  (snd-display "equal? ~A: ~A?" gen egen))))
  
  ;; ----------------
  (define (test-gen-equal g0 g1 g2)
    ;; g0 = g1 at start != g2
    
    (let ((g3 g0))
      (if (not (eq? g0 g3))
	  (snd-display "let ~A not eq?~%    ~A~%    ~A" (mus-name g0) g0 g3))
      (if (eq? g0 g1)
	  (snd-display "arg ~A eq?~%    ~A~%    ~A" (mus-name g0) g0 g1))
      (if (not (equal? g0 g1))
	  (snd-display "~A not equal?~%    ~A~%    ~A" (mus-name g0) g0 g1))
      (if (equal? g0 g2)
	  (snd-display "~A equal?~%    ~A~%    ~A" (mus-name g0) g0 g2))
      (g0)
      (g3)
      (g3)
      (if (not (eq? g0 g3))
	  (snd-display "run let ~A not eq?~%    ~A~%    ~A" (mus-name g0) g0 g3))
      (if (eq? g0 g1)
	  (snd-display "arg ~A eq?~%    ~A~%    ~A" (mus-name g0) g0 g1))
      (if (equal? g0 g1)
	  (snd-display "run ~A equal?~%    ~A~%    ~A" (mus-name g0) g0 g1))
      (if (equal? g0 g2)
	  (snd-display "run ~A equal?~%    ~A~%    ~A" (mus-name g0) g0 g2))
      (let ((data (catch #t (lambda () (mus-data g0)) (lambda args #f))))
	(when (float-vector? data)
	  (let ((data4 (catch #t (lambda () (mus-data (copy g0))) (lambda args #f))))
	    (if (not (float-vector? data4)) 
		(snd-display "~A copy -> mus-data ~A?" (mus-name g0) data4)))))))
  
  ;; ----------------
  (define (fm-test gen)
    (if (not (mus-generator? gen)) (snd-display "~A not a gen?" gen))
    (set! (mus-frequency gen) 0.0)
    (set! (mus-phase gen) 0.0)
    (gen 0.0)
    (if (fneq (mus-phase gen) 0.0) (snd-display "~A phase(0): ~A" gen (mus-phase gen)))
    (gen 1.0)
    (if (fneq (mus-phase gen) 1.0) (snd-display "~A phase(1): ~A" gen (mus-phase gen)))
    (gen 0.0)
    (if (fneq (mus-phase gen) 1.0) (snd-display "~A phase(1, 0): ~A" gen (mus-phase gen)))
    (set! (mus-frequency gen) (radians->hz 2.0))
    (if (fneq (mus-increment gen) 2.0) (snd-display "~A increment: ~A" gen (mus-increment gen)))
    (set! (mus-increment gen) 2.0)
    (if (fneq (mus-frequency gen) (radians->hz 2.0)) (snd-display "~A set increment: ~A ~A" gen (mus-increment gen) (hz->radians (mus-frequency gen))))
    (gen 0.0)
    (if (fneq (mus-phase gen) 3.0) (snd-display "~A phase(1, 2): ~A ~A" gen (mus-phase gen) (mus-frequency gen)))
    (gen 1.0)
    (if (fneq (mus-phase gen) 6.0) (snd-display "~A phase(3, 2, 1): ~A ~A" gen (mus-phase gen) (mus-frequency gen)))
    (do ((i 0 (+ i 1))) ((= i 10)) (gen 10.0))
    (if (fneq (mus-phase gen) (- 126 (* 40 pi))) ;(+ 26 (- 100 (* 40 pi)))) ;(+ 26 (- 100 (* 2 pi 20)))
	(snd-display "~A phase (over): ~A ~A" gen (mus-phase gen) (mus-frequency gen)))
    (set! (mus-frequency gen) 0.0)
    (set! (mus-phase gen) 0.0)
    (gen 1234567812345678)
    (gen -1234567812345678)
    (set! (mus-frequency gen) 0.0)
    (set! (mus-phase gen) 0.0)
    (gen -2.0)
    (if (and (fneq (mus-phase gen) -2.0)
	     (fneq (mus-phase gen) (- (* 2 pi) 2.0)))
	(snd-display "phase: ~A freq: ~A" (mus-phase gen) (mus-frequency gen))))
  
  ;; ----------------
  (define* (agc (ramp-speed .001) (window-size 512))
    (let ((maxer (make-moving-max window-size))
	  (mult 1.0))
      (map-channel
       (lambda (y)
	 (let ((this-incr (* (- 0.5 (* mult (moving-max maxer y))) ramp-speed)))
	   (set! mult (+ mult this-incr))
	   (* y mult))))))
  
  ;; ----------------
  (define (numerical-reality-checks)
    ;; a few reality checks from John Burkardt test_values.C
    
    (do ((vals (vector 1.6709637479564564156 1.5707963267948966192 1.4706289056333368229 1.3694384060045658278 1.2661036727794991113 
		       1.1592794807274085998 1.0471975511965977462 0.92729521800161223243 0.79539883018414355549 0.64350110879328438680 
		       0.45102681179626243254 0.00000000000000000000))
	 (args (vector -0.1 0.0 0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0))
	 (max-bad 0.0)
	 (i 0 (+ i 1)))
	((= i 12)
	 (if (> max-bad 1.0e-15)
	     (snd-display "acos: ~A" max-bad)))
      (set! max-bad (max max-bad (abs (- (acos (vector-ref args i))
					 (vector-ref vals i))))))
    
    (do ((vals (vector 0.0000000000000000000 0.14130376948564857735 0.44356825438511518913 0.62236250371477866781 0.75643291085695958624 
		       0.86701472649056510395 0.96242365011920689500 1.3169578969248167086 1.7627471740390860505 1.8115262724608531070 
		       2.0634370688955605467 2.2924316695611776878 2.9932228461263808979 5.2982923656104845907 7.6009022095419886114))
	 (args (vector 1.0 1.01 1.1 1.2 1.3 1.4 1.5 2.0 3.0 3.1415926535897932385 4.0 5.0 10.0 100.0 1000.0))
	 (max-bad 0.0)
	 (i 0 (+ i 1)))
	((= i 15)
	 (if (> max-bad 1.0e-15)
	     (snd-display "acosh: ~A" max-bad)))
      (let ((nval (acosh (vector-ref args i))))
	(set! max-bad (max max-bad (abs (- nval (vector-ref vals i)))))))
    
    (do ((vals (vector -0.10016742116155979635 0.00000000000000000000 0.10016742116155979635 0.20135792079033079146 0.30469265401539750797 
		       0.41151684606748801938 0.52359877559829887308 0.64350110879328438680 0.77539749661075306374 0.92729521800161223243 
		       1.1197695149986341867 1.5707963267948966192))
	 (args (vector -0.1 0.0 0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0))
	 (max-bad 0.0)
	 (i 0 (+ i 1)))
	((= i 12)
	 (if (> max-bad 1.0e-15)
	     (snd-display "asin: ~A" max-bad)))
      (set! max-bad (max max-bad (abs (- (asin (vector-ref args i))
					 (vector-ref vals i))))))
    
    (do ((vals (vector -2.3124383412727526203 -0.88137358701954302523 0.00000000000000000000 0.099834078899207563327 0.19869011034924140647 
		       0.29567304756342243910 0.39003531977071527608 0.48121182505960344750 0.56882489873224753010 0.65266656608235578681 
		       0.73266825604541086415 0.80886693565278246251 0.88137358701954302523 1.4436354751788103425 1.8184464592320668235 
		       2.0947125472611012942 2.3124383412727526203 2.9982229502979697388 5.2983423656105887574 7.6009027095419886115))
	 (args (vector -5.0 -1.0 0.0 0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0 2.0 3.0 4.0 5.0 10.0 100.0 1000.0))
	 (max-bad 0.0)
	 (i 0 (+ i 1)))
	((= i 20))
      (let* ((nval (asinh (vector-ref args i)))
	     (diff (abs (- nval (vector-ref vals i)))))
	(set! max-bad (max max-bad diff))
	(if (> max-bad 1.0e-14)
	    (snd-display "asinh(~A): ~A ~A -> ~A" (vector-ref args i) nval (vector-ref vals i) max-bad))))
    
    (do ((vals (vector 0.00000000000000000000 0.24497866312686415417 0.32175055439664219340 0.46364760900080611621 0.78539816339744830962 
		       1.1071487177940905030 1.2490457723982544258 1.3258176636680324651 1.3734007669450158609 1.4711276743037345919 1.5208379310729538578))
	 (args (vector 0.00000000000000000000 0.25000000000000000000 0.33333333333333333333 0.50000000000000000000 1.0000000000000000000 
		       2.0000000000000000000 3.0000000000000000000 4.0000000000000000000 5.0000000000000000000 10.000000000000000000 20.000000000000000000))
	 (max-bad 0.0)
	 (i 0 (+ i 1)))
	((= i 11)
	 (if (> max-bad 1.0e-15)
	     (snd-display "atan: ~A" max-bad)))
      (set! max-bad (max max-bad (abs (- (atan (vector-ref args i))
					 (vector-ref vals i))))))
    
    (do ((vals (vector -0.54930614433405484570 0.00000000000000000000 0.0010000003333335333335 0.10033534773107558064 0.20273255405408219099 
		       0.30951960420311171547 0.42364893019360180686 0.54930614433405484570 0.69314718055994530942 0.86730052769405319443 
		       1.0986122886681096914 1.4722194895832202300 2.6466524123622461977 3.8002011672502000318 7.2543286192620472067))
	 (args (vector -0.5 0.0 0.001 0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 0.99 0.999 0.999999))
	 (max-bad 0.0)
	 (i 0 (+ i 1)))
	((= i 15))
      (let* ((nval (atanh (vector-ref args i)))
	     (diff (abs (- nval (vector-ref vals i)))))
	(set! max-bad (max max-bad diff))
	(if (> diff 1.0e-10) ; one is > e-11
	    (snd-display "atanh(~A): ~A ~A -> ~A" (vector-ref args i) (vector-ref vals i) nval diff))))
    
    (do ((vals (vector 0.1000000000000000E+01 0.1010025027795146E+01 0.1040401782229341E+01 0.1092045364317340E+01 0.1166514922869803E+01 
		       0.1266065877752008E+01 0.1393725584134064E+01 0.1553395099731217E+01 0.1749980639738909E+01 0.1989559356618051E+01 
		       0.2279585302336067E+01 0.3289839144050123E+01 0.4880792585865024E+01 0.7378203432225480E+01 0.1130192195213633E+02 
		       0.1748117185560928E+02 0.2723987182360445E+02 0.6723440697647798E+02 0.4275641157218048E+03 0.2815716628466254E+04))
	 (args (vector 0.00E+00 0.20E+00 0.40E+00 0.60E+00 0.80E+00 0.10E+01 0.12E+01 0.14E+01 0.16E+01 0.18E+01 0.20E+01 0.25E+01 0.30E+01 
		       0.35E+01 0.40E+01 0.45E+01 0.50E+01 0.60E+01 0.80E+01 
		       0.10E+02))
	 (max-bad 0.0)
	 (i 0 (+ i 1)))
	((= i 20))
      (let* ((nval (bes-i0 (vector-ref args i)))
	     (diff (abs (- nval (vector-ref vals i)))))
	(set! max-bad (max max-bad diff))
	(if (> diff 1.0e-4)
	    (snd-display "bes-i0(~A): ~A ~A -> ~A" (vector-ref args i) (vector-ref vals i) nval diff))))
    
    (do ((vals (vector -0.1775967713143383E+00 -0.3971498098638474E+00 -0.2600519549019334E+00 0.2238907791412357E+00 0.7651976865579666E+00 
		       0.1000000000000000E+01 0.7651976865579666E+00 0.2238907791412357E+00 -0.2600519549019334E+00 -0.3971498098638474E+00 
		       -0.1775967713143383E+00 0.1506452572509969E+00 0.3000792705195556E+00 0.1716508071375539E+00 -0.9033361118287613E-01 
		       -0.2459357644513483E+00 -0.1711903004071961E+00 0.4768931079683354E-01 0.2069261023770678E+00 0.1710734761104587E+00 -0.1422447282678077E-01))
	 (args (vector -5.0E+00 -4.0E+00 -3.0E+00 -2.0E+00 -1.0E+00 0.0E+00 1.0E+00 2.0E+00 3.0E+00 4.0E+00 5.0E+00 6.0E+00 7.0E+00 8.0E+00 
		       9.0E+00 10.0E+00 11.0E+00 12.0E+00 13.0E+00 14.0E+00 15.0E+00))
	 (max-bad 0.0)
	 (i 0 (+ i 1)))
	((= i 21))
      (let* ((nval (bes-j0 (vector-ref args i)))
	     (diff (abs (- nval (vector-ref vals i)))))
	(set! max-bad (max max-bad diff))
	(if (> diff 1.0e-15)
	    (snd-display "bes-j0(~A): ~A ~A -> ~A" (vector-ref args i) (vector-ref vals i) nval diff))))
    
    (do ((vals (vector 0.3275791375914652E+00 0.6604332802354914E-01 -0.3390589585259365E+00 -0.5767248077568734E+00 -0.4400505857449335E+00 
		       0.0000000000000000E+00 0.4400505857449335E+00 0.5767248077568734E+00 0.3390589585259365E+00 -0.6604332802354914E-01 
		       -0.3275791375914652E+00 -0.2766838581275656E+00 -0.4682823482345833E-02 0.2346363468539146E+00 0.2453117865733253E+00 
		       0.4347274616886144E-01 -0.1767852989567215E+00 -0.2234471044906276E+00 -0.7031805212177837E-01 0.1333751546987933E+00 0.2051040386135228E+00))
	 (args (vector -5.0E+00 -4.0E+00 -3.0E+00 -2.0E+00 -1.0E+00 0.0E+00 1.0E+00 2.0E+00 3.0E+00 4.0E+00 5.0E+00 6.0E+00 7.0E+00 8.0E+00 
		       9.0E+00 10.0E+00 11.0E+00 12.0E+00 13.0E+00 14.0E+00 15.0E+00))
	 (max-bad 0.0)
	 (i 0 (+ i 1)))
	((= i 21))
      (let* ((nval (bes-j1 (vector-ref args i)))
	     (diff (abs (- nval (vector-ref vals i)))))
	(set! max-bad (max max-bad diff))
	(if (> diff 1.0e-15)
	    (snd-display "bes-j1(~A): ~A ~A -> ~A" (vector-ref args i) (vector-ref vals i) nval diff))))
    
    (do ((vals (vector 0.1149034849319005E+00 0.3528340286156377E+00 0.4656511627775222E-01 0.2546303136851206E+00 -0.5971280079425882E-01 
		       0.2497577302112344E-03 0.7039629755871685E-02 0.2611405461201701E+00 -0.2340615281867936E+00 -0.8140024769656964E-01 
		       0.2630615123687453E-09 0.2515386282716737E-06 0.1467802647310474E-02 0.2074861066333589E+00 -0.1138478491494694E+00 
		       0.3873503008524658E-24 0.3918972805090754E-18 0.2770330052128942E-10 0.1151336924781340E-04 -0.1167043527595797E+00))
	 (ns (vector 2 2 2 2 2 5 5 5 5 5 10 10 10 10 10 20 20 20 20 20)) 
	 (args (vector 1.0E+00 2.0E+00 5.0E+00 10.0E+00 50.0E+00 1.0E+00 2.0E+00 5.0E+00 10.0E+00 50.0E+00 1.0E+00 2.0E+00 5.0E+00 10.0E+00 
		       50.0E+00 1.0E+00 2.0E+00 5.0E+00 10.0E+00 50.0E+00))
	 (max-bad 0.0)
	 (i 0 (+ i 1)))
	((= i 20))
      (let* ((nval (bes-jn (vector-ref ns i) (vector-ref args i)))
	     (diff (abs (- nval (vector-ref vals i)))))
	(set! max-bad (max max-bad diff))
	(if (> diff 1.0e-15)
	    (snd-display "bes-jn(~A ~A): ~A ~A -> ~A" (vector-ref ns i) (vector-ref args i) (vector-ref vals i) nval diff))))
    
    (do ((vals (vector -0.1534238651350367E+01 0.8825696421567696E-01 0.5103756726497451E+00 0.3768500100127904E+00 -0.1694073932506499E-01 
		       -0.3085176252490338E+00 -0.2881946839815792E+00 -0.2594974396720926E-01 0.2235214893875662E+00 0.2499366982850247E+00 
		       0.5567116728359939E-01 -0.1688473238920795E+00 -0.2252373126343614E+00 -0.7820786452787591E-01 0.1271925685821837E+00 0.2054642960389183E+00))
	 (args (vector 0.1E+00 1.0E+00 2.0E+00 3.0E+00 4.0E+00 5.0E+00 6.0E+00 7.0E+00 8.0E+00 9.0E+00 10.0E+00 11.0E+00 12.0E+00 13.0E+00 14.0E+00 15.0E+00))
	 (max-bad 0.0)
	 (i 0 (+ i 1)))
	((= i 16))
      (let* ((nval (bes-y0 (vector-ref args i)))
	     (diff (abs (- nval (vector-ref vals i)))))
	(set! max-bad (max max-bad diff))
	(if (> diff 1.0e-15)
	    (snd-display "bes-y0(~A): ~A ~A -> ~A" (vector-ref args i) (vector-ref vals i) nval diff))))
    
    (do ((vals (vector -0.6458951094702027E+01 -0.7812128213002887E+00 -0.1070324315409375E+00 0.3246744247918000E+00 0.3979257105571000E+00 
		       0.1478631433912268E+00 -0.1750103443003983E+00 -0.3026672370241849E+00 -0.1580604617312475E+00 0.1043145751967159E+00 
		       0.2490154242069539E+00 0.1637055374149429E+00 -0.5709921826089652E-01 -0.2100814084206935E+00 -0.1666448418561723E+00 0.2107362803687351E-01))
	 (args (vector 0.1E+00 1.0E+00 2.0E+00 3.0E+00 4.0E+00 5.0E+00 6.0E+00 7.0E+00 8.0E+00 9.0E+00 10.0E+00 11.0E+00 12.0E+00 13.0E+00 14.0E+00 15.0E+00))
	 (max-bad 0.0)
	 (i 0 (+ i 1)))
	((= i 16))
      (let* ((nval (bes-y1 (vector-ref args i)))
	     (diff (abs (- nval (vector-ref vals i)))))
	(set! max-bad (max max-bad diff))
	(if (> diff 1.0e-14)
	    (snd-display "bes-y1(~A): ~A ~A -> ~A" (vector-ref args i) (vector-ref vals i) nval diff))))
    
    (do ((vals (vector -0.1650682606816254E+01 -0.6174081041906827E+00 0.3676628826055245E+00 -0.5868082442208615E-02 0.9579316872759649E-01 
		       -0.2604058666258122E+03 -0.9935989128481975E+01 -0.4536948224911019E+00 0.1354030476893623E+00 -0.7854841391308165E-01 
		       -0.1216180142786892E+09 -0.1291845422080393E+06 -0.2512911009561010E+02 -0.3598141521834027E+00 0.5723897182053514E-02 
		       -40816513889983664.0 -0.5933965296914321E+09 -0.1597483848269626E+04 0.1644263394811578E-01))
	 
	 ;; yn(20, 2.0) prints -40816513889983664.0 but I guess due to float inaccuracies (bes-yn 20 2.0) is -40816513889983672.0?
	 
	 (ns (vector 2 2 2 2 2 5 5 5 5 5 10 10 10 10 10 20 20 20 20))
	 (args (vector 1.0E+00 2.0E+00 5.0E+00 10.0E+00 50.0E+00 1.0E+00 2.0E+00 5.0E+00 10.0E+00 50.0E+00 1.0E+00 2.0E+00 5.0E+00 10.0E+00 
		       50.0E+00 2.0E+00 5.0E+00 10.0E+00 50.0E+00))
	 (max-bad 0.0)
	 (i 0 (+ i 1)))
	((= i 19))
      (let* ((nval (bes-yn (vector-ref ns i) (vector-ref args i)))
	     (diff (abs (- nval (vector-ref vals i)))))
	(set! max-bad (max max-bad diff))
	(if (and (> diff 1.0e-6)
		 (not (= i 15))) ; see above
	    (snd-display "bes-yn(~A ~A): ~A ~A -> ~A" (vector-ref ns i) (vector-ref args i) (vector-ref vals i) nval diff))))
    ;; one (20 1.0) is off by a lot but the val is 1e22 
    
    ;; numerics stuff
    (do ((ns (vector 1 6 6 6 15 15 15 15 15 15 15))
	 (ks (vector 0 1 3 5 1  3  5  7  9  11 13))
	 (vals (vector 1 6 20 6 15 455 3003 6435 5005 1365 105))
	 (i 0 (+ i 1)))
	((= i 11))
      (let ((nval (binomial-direct (vector-ref ns i) (vector-ref ks i)))
	    (mval (n-choose-k (vector-ref ns i) (vector-ref ks i))))
	(if (not (= nval mval (vector-ref vals i)))
	    (snd-display "binomial(~A ~A): ~A ~A ~A" (vector-ref ns i) (vector-ref ks i) nval mval (vector-ref vals i)))))
    
    (do ((ls (vector 1 1 1 1 1 2 2 2 3 3 3 3 4 5 6 7 8 9 10))
	 (ms (vector 0 0 0 0 1 0 1 2 0 1 2 3 2 2 3 3 4 4 5))
	 (vals (vector 0.000000 0.500000 0.707107 1.000000 -0.866025 -0.125000 -1.29904  2.25000 -0.437500 -0.324759 5.62500 -9.74278 
		       4.21875 -4.92187  12.7874  116.685 -1050.67 -2078.49  30086.2))
	 (xs (vector 0.0 0.5 0.7071067 1.0  0.5 0.5 0.5 0.5  0.5 0.5 0.5 0.5  0.5 0.5 0.5 0.5  0.5 0.5 0.5))
	 (i 0 (+ i 1)))
	((= i 19))
      (let ((val (plgndr (vector-ref ls i) (vector-ref ms i) (vector-ref xs i))))
	(if (not (and (real? val) 
		      (real? (vector-ref vals i)) 
		      (<= (abs (- val (vector-ref vals i))) 0.1)))
	    (snd-display "plgndr(~A ~A ~A) = ~A (~A)" (vector-ref ls i) (vector-ref ms i) (vector-ref xs i) val (vector-ref vals i)))))
    
    (let ((vals (vector  1.0000000000  0.8000000000  0.2800000000  -0.3520000000 -0.8432000000 -0.9971200000 
			 -0.7521920000 -0.2063872000  0.4219724800  0.8815431680  0.9884965888  0.7000513741  0.1315856097))
	  (ns (vector  0  1  2   3  4  5   6  7  8   9 10 11 	   12))
	  (xs (make-vector 13 0.8)))
      
      (do ((i 0 (+ i 1)))
	  ((= i 13))
	(let ((val (chebyshev (vector-ref ns i) (vector-ref xs i))))
	  (if (fneq val (vector-ref vals i))
	      (snd-display "chebyshev ~A ~A -> ~A ~A" (vector-ref ns i) (vector-ref xs i) val (vector-ref vals i)))))
      
      (do ((i 0 (+ i 1)))
	  ((= i 10))
	(let* ((x (random 10.0))
	       (order (random 10))
	       (val1 (gegenbauer order x 1.0))
	       (val2 (chebyshev order x 2)))
	  (if (fneq val1 val2)
	      (snd-display "gegenbauer/chebyshev (alpha=1) ~A ~A: ~A ~A" order x val1 val2)))))
    
    (let ((as (vector      0.5  0.5  0.5      0.5  0.5  0.5      0.5  0.5  0.5      0.5  0.5  0.0      1.0  2.0  3.0 
			   4.0  5.0  6.0      7.0  8.0  9.0     10.0  3.0  3.0      3.0  3.0  3.0      3.0  3.0  3.0      3.0  3.0  3.0 
			   3.0  3.0  3.0      3.0  3.0))
	  (vals (vector    1.0000000000   0.2000000000  -0.4400000000    -0.2800000000   0.2320000000   0.3075200000 
			   -0.0805760000  -0.2935168000  -0.0395648000     0.2459712000   0.1290720256   0.696706 ; was 0 but explicit formula says 2/n cos(nx)
			   -0.3600000000  -0.0800000000   0.8400000000     2.4000000000   4.6000000000   7.4400000000    10.9200000000  15.0400000000  19.8000000000 
			   25.2000000000  9.0000000000  -0.1612800000 ; was -9 but that is wrong (see G&R explicit formula)
			   -6.6729600000  -8.3750400000  -5.5267200000     0.0000000000   5.5267200000   8.3750400000     6.6729600000   0.1612800000  -9.0000000000  
			   -15.4252800000  -9.6969600000  22.4409600000   100.8892800000 252.0000000000))
	  (ns (vector     0  1  2      3  4  5      6  7  8      9 10  2      2  2  2      2  2  2      2  2  2      2  5  5      5  5  5 
			  5  5  5      5  5  5      5  5  5      5  5))
	  (xs (vector    0.20  0.20  0.20     0.20  0.20  0.20     0.20  0.20  0.20     0.20  0.20  0.40     0.40  0.40  0.40 
			 0.40  0.40  0.40     0.40  0.40  0.40     0.40 -0.50 -0.40    -0.30 -0.20 -0.10     0.00  0.10  0.20 
			 0.30  0.40  0.50     0.60  0.70  0.80     0.90  1.00))
      
	  (g3 (lambda (x alpha)
		(- (* 1/3 alpha x x x (+ 8 (* alpha (+ 12 (* alpha 4)))))
		   (* 2 alpha x (+ alpha 1)))))
	  
	  (g5 (lambda (x alpha)
		(+ (* 1/15 alpha x x x x x (+ 96 (* alpha (+ 200 (* alpha (+ 140 (* alpha (+ 40 (* alpha 4)))))))))
		   (* -1/3 alpha x x x (+ 24 (* alpha (+ 44 (* alpha (+ 24 (* alpha 4)))))))
		   (* alpha x (+ 2 (* alpha (+ 3 alpha))))))))
      
      (do ((i 0 (+ i 1)))
	  ((= i 38))
	(let ((val (gegenbauer (vector-ref ns i) (vector-ref xs i) (vector-ref as i))))
	  (if (fneq val (vector-ref vals i))
	      (snd-display "gegenbauer ~A ~A ~A -> ~A ~A" (vector-ref ns i) (vector-ref xs i) (vector-ref as i) val (vector-ref vals i)))))
      
      (do ((i 0 (+ i 1)))
	  ((= i 10))
	(let* ((x (random 10.0))
	       (alpha (random 3.0))
	       (val1 (gegenbauer 3 x alpha))
	       (val2 (g3 x alpha)))
	  (if (fneq val1 val2)
	      (snd-display "gegenbauer 3 ~A ~A: ~A ~A" x alpha val1 val2))))
      
      (do ((i 0 (+ i 1)))
	  ((= i 10))
	(let* ((x (random 10.0))
	       (alpha (random 3.0))
	       (val1 (gegenbauer 5 x alpha))
	       (val2 (g5 x alpha)))
	  (if (fneq val1 val2)
	      (snd-display "gegenbauer 5 ~A ~A: ~A ~A" x alpha val1 val2))))
      )
    
    (do ((vals (vector     1.0000000000  0.0000000000 -0.5000000000     -0.6666666667 -0.6250000000 -0.4666666667 
			   -0.2569444444 -0.0404761905  0.1539930556      0.3097442681  0.4189459325  0.4801341791 
			   0.4962122235 -0.4455729167  0.8500000000     -3.1666666667 34.3333333333))
	 (ns (vector     0  1  2      3  4  5      6  7  8      9 10 11     12  5  5      5  5))
	 (xs (vector    1.0  1.0  1.0     1.0  1.0  1.0     1.0  1.0  1.0     1.0  1.0  1.0     1.0  0.5  3.0     5.0 10.0))
	 (i 0 (+ i 1)))
	((= i 17))
      (let ((val (laguerre (vector-ref ns i) (vector-ref xs i))))
	(if (fneq val (vector-ref vals i))
	    (snd-display "laguerre ~A ~A -> ~A ~A" (vector-ref ns i) (vector-ref xs i) val (vector-ref vals i)))))
    
    (do ((vals (vector     1.0            10.0           98.0      940.0          8812.0         80600.0 
			   717880.0       6211600.0      52065680.0 ; was off by factor of 10?
			   421271200      3275529760.0   24329873600.0      171237081280.0 41.0          -8.0      3816.0         3041200.0))
	 (ns (vector     0  1  2      3  4  5      6  7  8      9 10 11     12  5  5      5  5))
	 (xs (vector    5.0  5.0  5.0     5.0  5.0  5.0     5.0  5.0  5.0     5.0  5.0  5.0     5.0  0.5  1.0     3.0 10.0))
	 (i 0 (+ i 1)))
	((= i 13))
      (let ((val (hermite (vector-ref ns i) (vector-ref xs i))))
	(if (fneq val (vector-ref vals i))
	    (snd-display "hermite ~A ~A -> ~A ~A" (vector-ref ns i) (vector-ref xs i) val (vector-ref vals i)))))
    
    (do ((i 0 (+ i 1))) 
	((= i 10))
      (let ((lv (legendre-polynomial (let ((v (make-vector 10 0.0))) 
				       (vector-set! v i 1.0) 
				       v) 
				     0.5))
	    (pv (plgndr i 0 0.5)))
	(if (fneq lv pv)
	    (snd-display "lv: ~A, pv: ~A (~A)" lv pv i))))
    
    (let ((pow-x (lambda (pow x)
		   ;; A&S p798
		   (case pow
		     ((0)                  (legendre-polynomial (vector 1) x))
		     ((1)                  (legendre-polynomial (vector 0 1) x))
		     ((2) (* (/ 1.0 3.0)   (legendre-polynomial (vector 1 0 2) x)))
		     ((3) (* (/ 1.0 5.0)   (legendre-polynomial (vector 0 3 0 2) x)))
		     ((4) (* (/ 1.0 35.0)  (legendre-polynomial (vector 7 0 20 0 8) x)))
		     ((5) (* (/ 1.0 63.0)  (legendre-polynomial (vector 0 27 0 28 0 8) x)))
		     ((6) (* (/ 1.0 231.0) (legendre-polynomial (vector 33 0 110 0 72 0 16) x)))
		     (else 'oops)))))
      (for-each
       (lambda (x)
	 (for-each
	  (lambda (pow)
	    (let ((lv (pow-x pow x))
		  (sv (expt x pow)))
	      (if (fneq lv sv)
		  (snd-display "~A ^ ~A = ~A ~A?" x pow lv sv))))
	  '(0 1 2 3 4 5 6)))
       '(2.0 0.5 0.1 -0.5 3.0 0.8)))
    
    (let ((index (find-sound 
		  (with-sound (:scaled-to 0.5) 
		    (do ((i 0 (+ i 1)) 
			 (x 0.0 (+ x .02))) 
			((= i 100)) 
		      (outa i (legendre 20 (cos x))))))))
      (if (fneq (sample 0 index 0) 0.5) (snd-display "legendre(cos(x)) 0: ~A" (sample 0 index 0)))
      (if (fneq (sample 50 index 0) 0.062572978) (snd-display "legendre(cos(x)) 50: ~A" (sample 50 index 0)))
      (close-sound index))
    
    
    (let ((h1 (lambda (x) (* 2 x)))
	  (h2 (lambda (x) (- (* 4 x x) 2)))
	  (h3 (lambda (x) (- (* 8 x x x) (* 12 x))))
	  (h4 (lambda (x) (+ 12 (* x x (- (* x x 16) 48)))))
	  (h5 (lambda (x) (* x (+ 120 (* x x (- (* x x 32) 160))))))
	  (h6 (lambda (x) (- (* x x (+ 720 (* x x (- (* x x 64) 480)))) 120))))
      
      (do ((i 0 (+ i 1)))
	  ((= i 20))
	(let ((x (random 10.0)))
	  (let ((v1 (h1 x))
		(v11 (hermite 1 x))
		(v2 (h2 x))
		(v22 (hermite 2 x))
		(v3 (h3 x))
		(v33 (hermite 3 x))
		(v4 (h4 x))
		(v44 (hermite 4 x))
		(v5 (h5 x))
		(v55 (hermite 5 x))
		(v6 (h6 x))
		(v66 (hermite 6 x)))
	    (cond ((fneq v1 v11) (snd-display "hermite 1 ~A: ~A ~A" x v1 v11))
		  ((fneq v2 v22) (snd-display "hermite 2 ~A: ~A ~A" x v2 v22))
		  ((fneq v3 v33) (snd-display "hermite 3 ~A: ~A ~A" x v3 v33))
		  ((fneq v4 v44) (snd-display "hermite 4 ~A: ~A ~A" x v4 v44))
		  ((fneq v5 v55) (snd-display "hermite 5 ~A: ~A ~A" x v5 v55))
		  ((fneq v6 v66) (snd-display "hermite 6 ~A: ~A ~A" x v6 v66)))))))
    
    (let ((lg1 (lambda (x) (- 1 x)))
	  (lg2 (lambda (x) (+ 1 (* x (- (* x 0.5) 2)))))
	  (lag1 (lambda (x a) (- (+ 1 a) x)))
	  (lag2 (lambda (x a) (* 0.5 (+ (* x x) 
					(* -2 x (+ a 2))
					(* (+ a 1) (+ a 2))))))
	  (lag3 (lambda (x a) (* (/ -1.0 6.0) (- (+ (* x x x) 
						    (* -3 x x (+ a 3)) 
						    (* 3 x (+ a 2) (+ a 3)))
						 (* (+ a 1) (+ a 2) (+ a 3)))))))
      (let ((x (random 10.0))
	    (a (random 1.0)))
	(let ((v1 (laguerre 1 x))
	      (v11 (lg1 x))
	      (v2 (laguerre 2 x))
	      (v22 (lg2 x))
	      (va1 (lag1 x a))
	      (va11 (laguerre 1 x a))
	      (va2 (lag2 x a))
	      (va22 (laguerre 2 x a))
	      (va3 (lag3 x a))
	      (va33 (laguerre 3 x a)))
	  (cond ((fneq v1 v11)   (snd-display "laguerre 1 ~A: ~A ~A" x v1 v11))
		((fneq v2 v22)   (snd-display "laguerre 2 ~A: ~A ~A" x v2 v22))
		((fneq va1 va11) (snd-display "laguerre 1a ~A ~A: ~A ~A" x a va1 va11))
		((fneq va2 va22) (snd-display "laguerre 2a ~A ~A: ~A ~A" x a va2 va22))
		((fneq va3 va33) (snd-display "laguerre 3a ~A ~A: ~A ~A" x a va3 va33)))))))
  
  ;; ----------------
  ;; start of test
  
  (do ((clmtest 0 (+ 1 clmtest))) ((= clmtest tests))
    
    (log-mem clmtest)
    (numerical-reality-checks)

    ;; numerics.scm existence checks
    (if (not (= (factorial 3) 6)) (snd-display "factorial 3: ~A" (factorial 3)))
    (if (not (= (n-choose-k 10 6) 210 (binomial-direct 10 6))) (snd-display "binomial: 210 ~A ~A" (n-choose-k 10 6) (binomial-direct 10 6)))
    (if (not (= (n-choose-k 10 9) 10 (binomial-direct 10 9))) (snd-display "binomial: 10 ~A ~A" (n-choose-k 10 9) (binomial-direct 10 9)))
    (if (fneq (legendre 3 1.0) 1.0) (snd-display "legendre: ~A" (legendre 3 1.0)))
    (if (fneq (gegenbauer 3 1.0) -0.6599949977336302) (snd-display "gegenbauer: ~A" (gegenbauer 3 1.0)))
    (if (fneq (chebyshev 3 1.0) 1.0) (snd-display "chebyshev: ~A" (chebyshev 3 1.0)))
    (if (fneq (hermite 3 1.0) -4.0) (snd-display "hermite: ~A" (hermite 3 1.0)))
    (if (fneq (laguerre 3 1.0) -0.6666666666666666) (snd-display "laguerre: ~A" (laguerre 3 1.0)))
    (if (fneq (Si 1.0) 0.9460830708394717) (snd-display "Si: ~A" (Si 1.0)))
    (if (fneq (Ci 1.0) 0.3374039233633503) (snd-display "Ci: ~A" (Ci 1.0)))
    (if (fneq (bernoulli-poly 1 1.0) 0.5) (snd-display "bernoulli-poly: ~A" (bernoulli-poly 1 1.0)))
    (let ((val1 (sin-m*pi/n 1 4369)) ;(* 257 17)))
	  (val2 (sin-m*pi/n 2 15)))  ;(* 3 5))))
      (let ((num1 (eval val1))
	    (num2 (eval val2)))
	(if (fneq num1 0.0007190644044087482) ; (sin (/ (* 1 pi) (* 257 17)))
	    (snd-display "sin-m*pi/n 1 (* 257 17): ~A" num1))
	(if (fneq num2 0.4067366430758002)    ; (sin (/ (* 2 pi) 15))
	    (snd-display "sin-m*pi/n 2 (* 3 5): ~A" num2))))
    (let ((vals (sin-nx-peak 100)))
      (if (or (fneq (car vals) 1.999876644816418)
	      (fneq (cadr vals) 1.555089933857112))
	  (snd-display "sin-nx-peak 100: ~A" vals)))
    ;(if (not (= (exptmod 3 100 5) 1)) (snd-display "exptmod 3 100 5: ~A" (exptmod 3 100 5)))
    
    (set! *clm-srate* 22050)
    (let ((samps (seconds->samples 1.0))
	  (secs (samples->seconds 22050)))
      (if (not (= samps 22050)) (snd-display "seconds->samples: ~A" samps))
      (if (fneq secs 1.0) (snd-display "samples->seconds: ~A" secs)))
    (set! *clm-file-buffer-size* default-file-buffer-size)
    (let ((var (catch #t (lambda () (set! *clm-file-buffer-size* #f)) (lambda args args))))
      (if (not (eq? (car var) 'wrong-type-arg))
	  (snd-display "mus-file-buffer-size bad size: ~A" var)))
    (set! *clm-file-buffer-size* 128)
    (if (not (= *clm-file-buffer-size* 128)) (snd-display "mus-file-buffer-size: ~D?" *clm-file-buffer-size*))
    (set! *clm-file-buffer-size* default-file-buffer-size)
    
    (if (not (member *mus-array-print-length* '(8 12 32) =))
	(snd-display "mus-array-print-length: ~D?" *mus-array-print-length*))
    (set! *mus-array-print-length* 32)
    (if (not (= *mus-array-print-length* 32)) (snd-display "set mus-array-print-length: ~D?" *mus-array-print-length*))
    (set! *mus-array-print-length* 8)
    
    (if (> (abs (- *mus-float-equal-fudge-factor* 0.0000001)) 0.00000001)
	(snd-display "mus-float-equal-fudge-factor: ~A?" *mus-float-equal-fudge-factor*))
    (let-temporarily ((*mus-float-equal-fudge-factor* .1))
      (if (fneq *mus-float-equal-fudge-factor* .1) 
	  (snd-display "set mus-float-equal-fudge-factor: ~A?" *mus-float-equal-fudge-factor*)))
    
    (if (fneq *clm-srate* 22050.0) (snd-display "mus-srate: ~F?" *clm-srate*))
    (if (fneq (hz->radians 1.0) 2.84951704088598e-4) (snd-display "hz->radians: ~F?" (hz->radians 1.0)))
    (if (fneq (radians->hz 2.84951704088598e-4) 1.0) (snd-display "radians->hz: ~F?" (radians->hz 2.84951704088598e-4)))
    (if (fneq (radians->degrees 1.0) 57.2957801818848) (snd-display "radians->degrees: ~F?" (radians->degrees 1.0)))
    (if (fneq (degrees->radians 57.2957801818848) 1.0) (snd-display "degrees->radians: ~F?" (degrees->radians 57.2957801818848)))
    (if (fneq (linear->db .25) -12.0411996841431) (snd-display "linear->db: ~F?" (linear->db .25)))
    (if (fneq (db->linear -12.0411996841431) .25) (snd-display "db->linear: ~F?" (db->linear -12.0411996841431)))

    (if (fneq (odd-weight 0.0) 0.0) (snd-display "odd-weight 0.0: ~F?" (odd-weight 0.0)))
    (if (fneq (odd-weight 2.0) 0.0) (snd-display "odd-weight 2.0: ~F?" (odd-weight 2.0)))
    (if (fneq (odd-weight 1.0) 1.0) (snd-display "odd-weight 1.0: ~F?" (odd-weight 1.0)))
    (if (fneq (odd-weight 1.5) 0.5) (snd-display "odd-weight 1.5: ~F?" (odd-weight 1.5)))
    (if (fneq (odd-weight 2.5) 0.5) (snd-display "odd-weight 2.5: ~F?" (odd-weight 2.5)))
    (if (fneq (odd-weight 2.1) 0.1) (snd-display "odd-weight 2.1: ~F?" (odd-weight 2.1)))
    (if (fneq (odd-weight 2.9) 0.9) (snd-display "odd-weight 2.9: ~F?" (odd-weight 2.9)))
    (if (fneq (odd-weight 1.1) 0.9) (snd-display "odd-weight 1.1: ~F?" (odd-weight 1.1)))
    (if (fneq (odd-weight 1.9) 0.1) (snd-display "odd-weight 1.9: ~F?" (odd-weight 1.9)))

    (if (fneq (even-weight 0.0) 1.0) (snd-display "even-weight 0.0: ~F?" (even-weight 0.0)))
    (if (fneq (even-weight 2.0) 1.0) (snd-display "even-weight 2.0: ~F?" (even-weight 2.0)))
    (if (fneq (even-weight 1.0) 0.0) (snd-display "even-weight 1.0: ~F?" (even-weight 1.0)))
    (if (fneq (even-weight 1.5) 0.5) (snd-display "even-weight 1.5: ~F?" (even-weight 1.5)))
    (if (fneq (even-weight 2.5) 0.5) (snd-display "even-weight 2.5: ~F?" (even-weight 2.5)))
    (if (fneq (even-weight 2.1) 0.9) (snd-display "even-weight 2.1: ~F?" (even-weight 2.1)))
    (if (fneq (even-weight 2.9) 0.1) (snd-display "even-weight 2.9: ~F?" (even-weight 2.9)))
    (if (fneq (even-weight 1.1) 0.1) (snd-display "even-weight 1.1: ~F?" (even-weight 1.1)))
    (if (fneq (even-weight 1.9) 0.9) (snd-display "even-weight 1.9: ~F?" (even-weight 1.9)))

    (if (fneq (odd-multiple 0.0 2.0) 2.0) (snd-display "odd-multiple 0.0: ~F?" (odd-multiple 0.0 2.0)))
    (if (fneq (odd-multiple 2.0 2.0) 6.0) (snd-display "odd-multiple 2.0: ~F?" (odd-multiple 2.0 2.0)))
    (if (fneq (odd-multiple 1.0 2.0) 2.0) (snd-display "odd-multiple 1.0: ~F?" (odd-multiple 1.0 2.0)))
    (if (fneq (odd-multiple 1.5 2.0) 2.0) (snd-display "odd-multiple 1.5: ~F?" (odd-multiple 1.5 2.0)))
    (if (fneq (odd-multiple 2.5 2.0) 6.0) (snd-display "odd-multiple 2.5: ~F?" (odd-multiple 2.5 2.0)))
    (if (fneq (odd-multiple 2.1 2.0) 6.0) (snd-display "odd-multiple 2.1: ~F?" (odd-multiple 2.1 2.0)))
    (if (fneq (odd-multiple 2.9 2.0) 6.0) (snd-display "odd-multiple 2.9: ~F?" (odd-multiple 2.9 2.0)))
    (if (fneq (odd-multiple 1.1 2.0) 2.0) (snd-display "odd-multiple 1.1: ~F?" (odd-multiple 1.1 2.0)))
    (if (fneq (odd-multiple 1.9 2.0) 2.0) (snd-display "odd-multiple 1.9: ~F?" (odd-multiple 1.9 2.0)))

    (if (fneq (even-multiple 0.0 2.0) 0.0) (snd-display "even-multiple 0.0: ~F?" (even-multiple 0.0 2.0)))
    (if (fneq (even-multiple 2.0 2.0) 4.0) (snd-display "even-multiple 2.0: ~F?" (even-multiple 2.0 2.0)))
    (if (fneq (even-multiple 1.0 2.0) 4.0) (snd-display "even-multiple 1.0: ~F?" (even-multiple 1.0 2.0)))
    (if (fneq (even-multiple 1.5 2.0) 4.0) (snd-display "even-multiple 1.5: ~F?" (even-multiple 1.5 2.0)))
    (if (fneq (even-multiple 2.5 2.0) 4.0) (snd-display "even-multiple 2.5: ~F?" (even-multiple 2.5 2.0)))
    (if (fneq (even-multiple 2.1 2.0) 4.0) (snd-display "even-multiple 2.1: ~F?" (even-multiple 2.1 2.0)))
    (if (fneq (even-multiple 2.9 2.0) 4.0) (snd-display "even-multiple 2.9: ~F?" (even-multiple 2.9 2.0)))
    (if (fneq (even-multiple 1.1 2.0) 4.0) (snd-display "even-multiple 1.1: ~F?" (even-multiple 1.1 2.0)))
    (if (fneq (even-multiple 1.9 2.0) 4.0) (snd-display "even-multiple 1.9: ~F?" (even-multiple 1.9 2.0)))

    (if (fneq (ring-modulate .4 .5) .2) (snd-display "ring-modulate: ~F?" (ring-modulate .4 .5)))
    (if (fneq (amplitude-modulate 1.0 .5 .4) .7) (snd-display "amplitude-modulate: ~F?" (amplitude-modulate 1.0 .5 .4)))
    (if (fneq (contrast-enhancement 0.1 0.75) (sin (+ (* 0.1 (/ pi 2)) (* .75 (sin (* 0.1 2.0 pi))))))
	(snd-display "contrast-enhancement: ~F (0.562925306221587)" (contrast-enhancement 0.1 0.75)))
    (if (fneq (contrast-enhancement 1.0) 1.0) (snd-display "contrast-enhancement opt: ~A" (contrast-enhancement 1.0)))
    (let ((lv0 (partials->polynomial #r(1 1 2 1) mus-chebyshev-first-kind)))
      (if (not (mus-arrays-equal? lv0 #r(-1.000 1.000 2.000) .001)) (snd-display "partials->polynomial(1): ~A?" lv0)))
    (let ((lv1 (partials->polynomial '(1 1 2 1) mus-chebyshev-second-kind)))
      (if (not (mus-arrays-equal? lv1 #r(1.000 2.000 0.0) .001)) (snd-display "partials->polynomial(2): ~A?" lv1)))
    (let ((lv2 (partials->polynomial '(1 1 2 1 3 1 5 1) mus-chebyshev-first-kind)))
      (if (not (mus-arrays-equal? lv2 #r(-1.000 3.000 2.000 -16.000 0.000 16.000) .001)) (snd-display "partials->polynomial(3): ~A?" lv2)))
    (let ((lv3 (partials->polynomial '(1 1 2 1 3 1 5 1) mus-chebyshev-second-kind)))
      (if (not (mus-arrays-equal? lv3 #r(1.000 2.000 -8.000 0.000 16.000 0.000) .001)) (snd-display "partials->polynomial(4): ~A?" lv3)))
    (let ((lv4 (partials->polynomial '(1 1 2 .5 3 .1 6 .01) mus-chebyshev-first-kind)))
      (if (not (mus-arrays-equal? lv4 #r(-0.510 0.700 1.180 0.400 -0.480 0.000 0.320) .001)) (snd-display "partials->polynomial(5): ~A?" lv4)))
    (let ((lv5 (partials->polynomial '(1 1 2 .5 3 .1 6 .01) mus-chebyshev-second-kind)))
      (if (not (mus-arrays-equal? lv5 #r(0.900 1.060 0.400 -0.320 0.000 0.320 0.000) .001)) (snd-display "partials->polynomial(6): ~A?" lv5)))
    (let ((lv6 (partials->polynomial #r(1 9 2 3 3 5 4 7 5 1))))
      (if (not (mus-arrays-equal? lv6 #r(4.000 -1.000 -50.000 0.000 56.000 16.000))) (snd-display "partials->polynomial(7): ~A?" lv6)))
    (let ((lv7 (partials->polynomial '(7 1))))
      (if (not (mus-arrays-equal? lv7 #r(0.000 -7.000 0.000 56.000 0.000 -112.000 0.000 64.000))) (snd-display "partials->polynomial(8): ~A?" lv7))
      (let ((lv7a (partials->polynomial '(7 1) mus-chebyshev-first-kind)))
	(if (not (mus-arrays-equal? lv7 lv7a)) (snd-display "partials->polynomial kind=1? ~A ~A" lv7 lv7a)))
      (if (fneq (polynomial lv7 1.0) (cosh (* 7 (acosh 1.0)))) 
	  (snd-display "ccosh cheb 7 1.0: ~A ~A" (polynomial lv7 1.0) (cosh (* 7 (acosh 1.0)))))
      (if (fneq (polynomial lv7 1.0) (cos (* 7 (acos 1.0)))) 
	  (snd-display "cos cheb 7 1.0: ~A ~A" (polynomial lv7 1.0) (cos (* 7 (acos 1.0)))))  
      (do ((lv8 (partials->polynomial '(7 1) mus-chebyshev-second-kind))
	   (sa (sin (acos 0.5)))
	   (ca (sin (* 7 (acos 0.5))))
	   (i 0 (+ i 1)))
	  ((= i 10))
	(let* ((val (mus-random 1.0))
	       (aval (acos val)))
	  (if (fneq (polynomial lv7 val) (cosh (* 7 (acosh val)))) 
	      (snd-display "ccosh cheb 7 ~A: ~A ~A" val (polynomial lv7 val) (cosh (* 7 (acosh val)))))
	  (if (fneq (polynomial lv7 val) (cos (* 7 aval)))
	      (snd-display "cos cheb 7 ~A: ~A ~A" val (polynomial lv7 val) (cos (* 7 aval))))
	  (if (fneq (polynomial lv8 val) (/ (sin (* 7 aval)) (sin aval)))
	      (snd-display "acos cheb 7 ~A: ~A ~A" val (polynomial lv8 val) (/ (sin (* 7 aval)) (sin aval)))))
	(if (not (mus-arrays-equal? lv8 #r(-1.000 0.000 24.000 0.000 -80.000 0.000 64.000 0.000))) (snd-display "partials->polynomial(9): ~A?" lv8))
	(if (fneq (polynomial lv8 0.5) (/ ca sa))
	    (snd-display "acos cheb 7 1.0: ~A ~A" (polynomial lv8 0.5) (/ ca sa)))))
    ;; G&R 8.943 p 984 uses n+1 where we use n in Un? (our numbering keeps harmonics aligned between Tn and Un)
    
    (if (not (mus-arrays-equal? (normalize-partials (list 1 1 2 1)) #r(1.000 0.500 2.000 0.500)))
	(snd-display "normalize-partials 1: ~A" (normalize-partials (list 1 1 2 1))))
    (if (not (mus-arrays-equal? (normalize-partials #r(1 1 2 1)) #r(1.000 0.500 2.000 0.500)))
	(snd-display "normalize-partials 2: ~A" (normalize-partials #r(1 1 2 1))))
    (if (not (mus-arrays-equal? (normalize-partials #r(1 1 2 -1)) #r(1.000 0.500 2.000 -0.500)))
	(snd-display "normalize-partials 3: ~A" (normalize-partials #r(1 1 2 -1))))
    (if (not (mus-arrays-equal? (normalize-partials #r(1 -.1 2 -.1)) #r(1.000 -0.500 2.000 -0.500)))
	(snd-display "normalize-partials 4: ~A" (normalize-partials #r(1 -.1 2 -.1))))
    (if (not (mus-arrays-equal? (normalize-partials #r(0 2 1 1 4 1)) #r(0.000 0.500 1.000 0.250 4.000 0.250)))
	(snd-display "normalize-partials 4: ~A" (normalize-partials #r(0 2 1 1 4 1))))
    
    ;; check phase-quadrature cancellations
    (do ((cos-coeffs (partials->polynomial '(1 1 2 1) mus-chebyshev-first-kind))
	 (sin-coeffs (partials->polynomial #r(1 1 2 1) mus-chebyshev-second-kind))
	 (incr (/ (* 2 pi 440.0) 22050.0))
	 (i 0 (+ i 1))
	 (a 0.0))
	((= i 1100))
      (let ((x (cos a)))
	(let ((y (sin a))
	      (cax (polynomial cos-coeffs x))
	      (sax (polynomial sin-coeffs x)))
	  (let ((upper (- (* (cos (* 2 a)) cax) (* (sin (* 2 a)) y sax)))
		(lower (+ (* (cos (* 2 a)) cax) (* (sin (* 2 a)) y sax)))
		(upper2 (+ (cos (* a 3)) (cos (* a 4))))
		(lower2 (+ 1.0 (cos a))))
	    (if (or (fneq upper upper2)
		    (fneq lower lower2))
		(snd-display "~A ~A, ~A ~A" upper upper2 lower lower2)))))
      (set! a (+ a incr)))
    
    (let ((tag (catch #t (lambda () (harmonicizer 550.0 '(.5 .3 .2) 10)) (lambda args (car args)))))
      (if (not (eq? tag 'no-data)) (snd-display "odd length arg to partials->polynomial: ~A" tag)))
    
    (let ((rdat (make-float-vector 16))
	  (idat (make-float-vector 16))
	  (vdat (make-float-vector 16)))
      (set! (rdat 0) 1.0)
      (set! (vdat 0) 1.0)
      (let ((v0 (spectrum rdat idat (make-fft-window rectangular-window 16) 1)) ;rectangular here to avoid clobbering 0-th data point
	    (v1 (snd-spectrum vdat rectangular-window 16 #t)))
	(do ((i 0 (+ i 1)))
	    ((= i 8)) ;should all be 1.0 (impulse in)
	  (if (fneq (v0 i) (v1 i))
	      (snd-display "spectra not equal 1: ~A ~A" v0 v1))))
      (float-vector-scale! idat 0.0)
      (float-vector-scale! rdat 0.0)
      (set! (rdat 0) 1.0)
      (let ((v0 (spectrum rdat idat (make-fft-window rectangular-window 17) 1)) ;rectangular here to avoid clobbering 0-th data point
	    (v1 (snd-spectrum vdat rectangular-window 16 #t)))
	(do ((i 0 (+ i 1)))
	    ((= i 8)) ;should all be 1.0 (impulse in)
	  (if (fneq (v0 i) (v1 i))
	      (snd-display "spectra not equal 0: ~A ~A" v0 v1))))
      (let ((var (catch #t (lambda () (spectrum rdat idat #f -1)) (lambda args args))))
	(if (or (float-vector? var) 
		(not (eq? (car var) 'out-of-range)))
	    (snd-display "spectrum bad type: ~A" var))))
    
    (let ((rdat (make-float-vector 16))
	  (idat (make-float-vector 16))
	  (xdat (make-float-vector 16))
	  (ydat (make-float-vector 16)))
      (set! (rdat 3) 1.0)
      (set! (xdat 3) 1.0)
      (fft rdat idat 1)
      (mus-fft xdat ydat 16 1)
      (if (fneq (rdat 0) (xdat 0)) (snd-display "ffts: ~A ~A?" rdat xdat))
      (fft rdat idat -1)
      (mus-fft xdat ydat 17 -1) ; mistake is deliberate
      (do ((i 0 (+ i 1)))
	  ((= i 16))
	(if (if (= i 3)
		(or (fneq (rdat i) 16.0) (fneq (xdat i) 16.0))
		(or (fneq (rdat i) 0.0) (fneq (xdat i) 0.0)))
	    (snd-display "fft real[~D]: ~A ~A?" i (rdat i) (xdat i)))
	(if (or (fneq (idat i) 0.0) (fneq (ydat i) 0.0))
	    (snd-display "fft imag[~D]: ~A ~A?" i (idat i) (ydat i))))
      (let ((var (catch #t (lambda () (mus-fft xdat ydat -1 0)) (lambda args args))))
	(if (not (eq? (car var) 'out-of-range))
	    (snd-display "mus-fft bad len: ~A" var))))
    
    (let ((rdat (make-float-vector 20))
	  (idat (make-float-vector 19)))
      (set! (rdat 3) 1.0)
      (mus-fft rdat idat)
      (convolution rdat idat)
      (spectrum rdat idat #f))
    
    (let ((v0 (make-float-vector 10 1.0))
	  (v1 (make-float-vector 10 0.5)))
      (float-vector-multiply! v0 v1)
      (if (fneq (v0 0) 0.5) (snd-display "multiple-arrays: ~F?" (v0 0)))
      (let ((sum (dot-product v0 v1)))
	(if (fneq sum 2.5) (snd-display "dot-product: ~F?" sum)))
      (let ((sum (dot-product v0 v1 10)))
	(if (fneq sum 2.5) (snd-display "dot-product (10): ~F?" sum)))
      (let ((sum (dot-product v0 v1 3)))
	(if (fneq sum 0.75) (snd-display "dot-product (3): ~F?" sum)))
      (fill! v0 0.0)
      (if (fneq (v0 3) 0.0) (snd-display "fill!: ~A?" v0))
      (fill! v0 1.0)
      (fill! v1 0.5)
      (let ((v2 (rectangular->polar v0 v1)))
	(if (fneq (v2 0) 1.118) (snd-display "rectangular->polar: ~A?" v2)))
      (set! (v0 0) 1.0)
      (set! (v1 0) 1.0)
      (rectangular->polar v0 v1)
      (if (or (fneq (v0 0) (sqrt 2.0))
	      (fneq (v1 0) (- (atan 1.0 1.0)))) ;(tan (atan 1.0 1.0)) -> 1.0 
	  (snd-display "rectangular->polar (~A ~A): ~A ~A?" (sqrt 2.0) (- (atan 1.0 1.0)) (v0 0) (v1 0)))
      (polar->rectangular v0 v1)
      (if (or (fneq (v0 0) 1.0)
	      (fneq (v1 0) 1.0))
	  (snd-display "polar->rectangular (1 1): ~A ~A?" (v0 0) (v1 0)))
      
      (let ((ind (open-sound "oboe.snd"))
	    (rl (channel->float-vector 1200 512))
	    (im (make-float-vector 512)))
	(fft rl im 512)
	(let ((rl-copy (copy rl))
	      (im-copy (copy im)))
	  (rectangular->polar rl im)
	  (polar->rectangular rl im)
	  (do ((i 0 (+ i 1)))
	      ((= i 512))
	    (if (or (fneq (rl i) (rl-copy i))
		    (fneq (im i) (im-copy i)))
		(snd-display "polar->rectangular[~D]: ~A ~A ~A ~A" 
			     i 
			     (rl i) (rl-copy i)
			     (im i) (im-copy i)))))
	(close-sound ind)))
    
    (let ((v0 (make-float-vector 8))
	  (v1 (make-float-vector 8)))
      (do ((i 0 (+ i 1))) ((= i 8)) (set! (v0 i) i) (set! (v1 i) (/ (+ i 1))))
      (rectangular->magnitudes v0 v1)
      (if (not (mus-arrays-equal? v0 #r(1.000 1.118 2.028 3.010 4.005 5.003 6.002 7.001)))
	  (snd-display "rectangular->magnitudes v0: ~A" v0)))
    
    (do ((v0 (make-float-vector 8))
	 (v1 (make-float-vector 8))
	 (v2 (make-float-vector 8))
	 (v3 (make-float-vector 8))
	 (i 0 (+ i 1)))
	((= i 8)
	 (rectangular->magnitudes v0 v1)
	 (rectangular->polar v2 v3)
	 (if (not (mus-arrays-equal? v0 v2))
	     (snd-display "rectangular->magnitudes|polar: ~A ~A" v0 v2)))
      (let ((val1 (random 1.0))
	    (val2 (random 1.0)))
	(set! (v0 i) val1)
	(float-vector-set! v2 i val1)
	(float-vector-set! v1 i val2)
	(float-vector-set! v3 i val2)))
    
    (when (defined? 'edot-product) ; needs complex numbers in C
      (let* ((vals (make-float-vector 1 1.0))
	     (v1 (edot-product 0.0 vals)))
	(if (fneq v1 1.0) ; exp 0.0 * 1.0
	    (snd-display "edot a 1.0: ~A" v1))
	(set! (vals 0) 0.0)
	(set! v1 (edot-product 0.0 vals))
	(if (fneq v1 0.0) ; exp 0.0 * 0.0
	    (snd-display "edot b 0.0: ~A" v1))
	(set! vals (make-vector 1 1.0))
	(set! v1 (edot-product 0.0 vals))  
	(if (fneq v1 1.0) ; exp 0.0 * 1.0
	    (snd-display "edot c 1.0: ~A" v1))
	(set! (vals 0) 0.0+i)
	(set! v1 (edot-product 0.0 vals))
	(if (cneq v1 0.0+i)
	    (snd-display "edot i: ~A" v1))
	(set! vals (make-float-vector 4 1.0))
	(set! v1 (edot-product (* 0.25 2 pi) vals))
	(let ((v2 (+ 1 ;(exp (* 0 2 pi))
		     (exp (* 0.25 2 pi))
		     (exp (* 0.5 2 pi))
		     (exp (* 0.75 2 pi)))))
	  (if (fneq v1 v2) (snd-display "edot 4: ~A ~A" v1 v2)))
	(set! vals (make-vector 4 0.0))  
	(do ((i 0 (+ i 1)))
	    ((= i 4))
	  (set! (vals i) (+ i 1.0)))
	(set! v1 (edot-product (* 0.25 2 pi 0.0-i) vals))
	(let ((v2 (+ 1
		     (* 2 (exp (* 0.25 2 pi 0.0-i)))
		     (* 3 (exp (* 0.5 2 pi 0.0-i)))
		     (* 4 (exp (* 0.75 2 pi 0.0-i))))))
	  (if (cneq v1 v2) (snd-display "edot 4 -i: ~A ~A" v1 v2)))
	(do ((i 0 (+ i 1)))
	    ((= i 4))
	  (set! (vals i) (+ i 1.0+i)))
	(set! v1 (edot-product (* 0.25 2 pi 0.0-i) vals))
	(let ((v2 (+ 1+i
		     (* 2+i (exp (* 0.25 2 pi 0.0-i)))
		     (* 3+i (exp (* 0.5 2 pi 0.0-i)))
		     (* 4+i (exp (* 0.75 2 pi 0.0-i))))))
	  (if (cneq v1 v2) (snd-display "edot 4 -i * i: ~A ~A" v1 v2)))))
    
    (let ((v0 (make-float-vector 3)))
      (set! (v0 0) 1.0)
      (set! (v0 1) 0.5)
      (set! (v0 2) 0.1)
      (if (or (fneq (polynomial v0 0.0) 1.0)
	      (fneq (polynomial v0 1.0) 1.6)
	      (fneq (polynomial v0 2.0) 2.4))
	  (snd-display "polynomial: ~A ~A ~A?"
		       (polynomial v0 0.0)
		       (polynomial v0 1.0)
		       (polynomial v0 2.0))))
    (if (fneq (polynomial #r(0.0 2.0) 0.5) 1.0) 
	(snd-display "polynomial 2.0 * 0.5: ~A" (polynomial #r(2.0) 0.5)))
    (let ((var (catch #t (lambda () (polynomial #f 1.0)) (lambda args args))))
      (if (not (eq? (car var) 'wrong-type-arg))
	  (snd-display "polynomial empty coeffs: ~A" var)))
    
    (do ((i 0 (+ i 1)))
	((= i 100))
      (let ((arg1 (- (random 100.0) 50.0))
	    (arg2 (- (random 100.0) 50.0)))
	(let ((val1 (modulo arg1 arg2))
	      (val2 (modulo arg1 arg2)))
	  (if (and (> (abs (- val1 val2)) 1e-8)
		   (> (abs (- (abs (- val1 val2)) (abs arg2))) 1e-8))
	      (snd-display "poly ~A ~A: ~A ~A -> ~A~%" arg1 arg2 val1 val2 (abs (- val1 val2)))))))
    
    (let ((err 0.0)
	  (coeffs #r(1.0 0.0 -.4999999963 0.0 .0416666418 0.0 -.0013888397 0.0 .0000247609 0.0 -.0000002605))
	  (pi2 (* pi 0.5)))
      (let ((new-cos
	     (lambda (x)
	       (let ((xx (abs x)))
		 (if (<= xx pi2)
		     (polynomial coeffs xx)
		     (let ((nxx (modulo xx (* 2 pi))))
		       (cond ((<= nxx pi2)        (polynomial coeffs nxx))
			     ((<= nxx pi)        (- (polynomial coeffs (- pi nxx))))
			     ((< nxx (* 1.5 pi)) (- (polynomial coeffs (- nxx pi))))
			     (else               (polynomial coeffs (- (* 2 pi) nxx))))))))))
	(do ((i 0 (+ i 1))
	     (x -10.0 (+ x .01)))
	    ((= i 2000))
	  (set! err (max err (abs (- (cos x) (new-cos x))))))
	(if (> err 1.1e-7) (snd-display "new-cos poly err: ~A" err))))
    
    (let ((val (poly+ #r(.1 .2 .3) #r(0.0 1.0 2.0 3.0 4.0))))
      (if (not (mus-arrays-equal? val #r(0.100 1.200 2.300 3.000 4.000))) (snd-display "poly+ 1: ~A" val)))
    
    (let ((val (poly+ #r(.1 .2 .3) .5)))
      (if (not (mus-arrays-equal? val #r(0.600 0.200 0.300))) (snd-display "poly+ 2: ~A" val)))
    (let ((val (poly+ .5 #r(.1 .2 .3))))
      (if (not (mus-arrays-equal? val #r(0.600 0.200 0.300))) (snd-display "poly+ 3: ~A" val)))
    
    (let ((val (poly* #r(1 1) #r(-1 1))))
      (if (not (mus-arrays-equal? val #r(-1.000 0.000 1.000 0.000))) (snd-display "poly* 1: ~A" val)))
    (let ((val (poly* #r(-5 1) #r(3 7 2))))
      (if (not (mus-arrays-equal? val #r(-15.000 -32.000 -3.000 2.000 0.000))) (snd-display "poly* 2: ~A" val)))
    (let ((val (poly* #r(-30 -4 2) #r(0.5 1))))
      (if (not (mus-arrays-equal? val #r(-15.000 -32.000 -3.000 2.000 0.000))) (snd-display "poly* 3: ~A" val)))
    (let ((val (poly* #r(-30 -4 2) 0.5)))
      (if (not (mus-arrays-equal? val #r(-15.000 -2.000 1.000))) (snd-display "poly* 4: ~A" val)))
    (let ((val (poly* 2.0 #r(-30 -4 2))))
      (if (not (mus-arrays-equal? val #r(-60.000 -8.000 4.000))) (snd-display "poly* 5: ~A" val)))
    
    (let ((val (poly/ #r(-1.0 0.0 1.0) #r(1.0 1.0))))
      (if (not (and (mus-arrays-equal? (car val) #r(-1.000 1.000 0.000))
		    (mus-arrays-equal? (cadr val) (make-float-vector 3))))
	  (snd-display "poly/ 1: ~A" val)))
    (let ((val (poly/ #r(-15 -32 -3 2) #r(-5 1))))
      (if (not (and (mus-arrays-equal? (car val) #r(3.000 7.000 2.000 0.000))
		    (mus-arrays-equal? (cadr val) (make-float-vector 4))))
	  (snd-display "poly/ 2: ~A" val)))
    (let ((val (poly/ #r(-15 -32 -3 2) #r(3 1))))
      (if (not (and (mus-arrays-equal? (car val) #r(-5.000 -9.000 2.000 0.000))
		    (mus-arrays-equal? (cadr val) (make-float-vector 4))))
	  (snd-display "poly/ 3: ~A" val)))
    (let ((val (poly/ #r(-15 -32 -3 2) #r(.5 1))))
      (if (not (and (mus-arrays-equal? (car val) #r(-30.000 -4.000 2.000 0.000))
		    (mus-arrays-equal? (cadr val) (make-float-vector 4))))
	  (snd-display "poly/ 4: ~A" val)))
    (let ((val (poly/ #r(-15 -32 -3 2) #r(3 7 2))))
      (if (not (and (mus-arrays-equal? (car val) #r(-5.000 1.000 0.000 0.000))
		    (mus-arrays-equal? (cadr val) (make-float-vector 4))))
	  (snd-display "poly/ 5: ~A" val)))
    (let ((val (poly/ #r(-15 -32 -3 2) 2.0)))
      (if (not (mus-arrays-equal? (car val) #r(-7.500 -16.000 -1.500 1.000)))
	  (snd-display "poly/ 6: ~A" val)))
    (let ((val (poly/ #r(-1.0 0.0 0.0 0.0 1.0) #r(1.0 0.0 1.0))))
      (if (not (and (mus-arrays-equal? (car val) #r(-1.0 0.0 1.0 0.0 0.0))
		    (mus-arrays-equal? (cadr val) (make-float-vector 5))))
	  (snd-display "poly/ 7: ~A" val)))
    (let ((val (poly/ #r(-1.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 1.0) #r(1.0 0.0 0.0 0.0 1.0))))
      (if (not (and (mus-arrays-equal? (car val) #r(-1.0 0.0 0.0 0.0 1.0 0.0 0.0 0.0 0.0))
		    (mus-arrays-equal? (cadr val) (make-float-vector 9))))
	  (snd-display "poly/ 8: ~A" val)))
    (let ((val (poly/ #r(-1.0 0.0 1.0) #r(-1.0 0.0 1.0))))
      (if (not (and (mus-arrays-equal? (car val) #r(1.0 0.0 0.0))
		    (mus-arrays-equal? (cadr val) (make-float-vector 3))))
	  (snd-display "poly/ 9: ~A" val)))
    (let ((val (poly/ #r(-1.0 0.0 1.0) #r(2.0 1.0))))
      (if (not (and (mus-arrays-equal? (car val) #r(-2.000 1.000 0.000))
		    (mus-arrays-equal? (cadr val) #r(3.000 0.000 0.000))))
	  (snd-display "poly/ 10: ~A" val)))
    (let ((val (poly/ #r(2 1) #r(-1.0 0.0 1.0))))
      (if (not (and (mus-arrays-equal? (car val) #r(0.0))
		    (mus-arrays-equal? (cadr val) #r(-1.000 0.000 1.000))))
	  (snd-display "poly/ 11: ~A" val)))
    (let ((val (poly/ #r(1 2 3 0 1) #r(0 0 0 1))))
      (if (not (and (mus-arrays-equal? (car val) #r(0.000 1.000 0.000 0.000 0.000))
		    (mus-arrays-equal? (cadr val) #r(1.000 2.000 3.000 0.000 0.000))))
	  (snd-display "poly/ 12: ~A" val)))
    
    (let ((ind (open-sound "1a.snd")))
      (let ((v1 (channel->float-vector 0 100 ind 0))
	    (v2 (channel->float-vector 0 100 ind 0)))
	(let ((vals (car (poly/ v1 v2)))
	      (res (make-float-vector 100)))
	  (set! (res 0) 1.0)
	  (if (not (mus-arrays-equal? vals res))
	      (snd-display "poly1 1a: ~A" vals))))
      (close-sound ind))
    
    (let ((val (poly-derivative #r(0.5 1.0 2.0 4.0))))
      (if (not (mus-arrays-equal? val #r(1.000 4.000 12.000))) (snd-display "poly-derivative: ~A" val)))
    
    (let ((val (poly-reduce #r(1 2 3))))
      (if (not (mus-arrays-equal? val #r(1.000 2.000 3.000))) (snd-display "poly-reduce 1: ~A" val)))
    (let ((val (poly-reduce #r(1 2 3 0 0 0))))
      (if (not (mus-arrays-equal? val #r(1.000 2.000 3.000))) (snd-display "poly-reduce 2: ~A" val)))
    (let ((val (poly-reduce #r(0 0 0 0 1 0))))
      (if (not (mus-arrays-equal? val #r(0.000 0.000 0.000 0.000 1.000))) (snd-display "poly-reduce 3: ~A" val)))
    
    (let ((vals (poly-gcd (poly-reduce (poly* #r(2 1) #r(-3 1))) #r(2 1))))
      (if (not (mus-arrays-equal? vals #r(2.000 1.000))) (snd-display "poly-gcd 1: ~A" vals)))
    (let ((vals (poly-gcd (poly-reduce (poly* #r(2 1) #r(-3 1))) #r(3 1))))
      (if (not (mus-arrays-equal? vals #r(0.000))) (snd-display "poly-gcd 2: ~A" vals)))
    (let ((vals (poly-gcd (poly-reduce (poly* #r(2 1) #r(-3 1))) #r(-3 1))))
      (if (not (mus-arrays-equal? vals #r(-3.000 1.000))) (snd-display "poly-gcd 2: ~A" vals)))
    (let ((vals (poly-gcd (poly-reduce (poly* #r(8 1) (poly* #r(2 1) #r(-3 1)))) #r(-3 1))))
      (if (not (mus-arrays-equal? vals #r(-3.000 1.000))) (snd-display "poly-gcd 3: ~A" vals)))
    (let ((vals (poly-gcd (poly-reduce (poly* #r(8 1) (poly* #r(2 1) #r(-3 1)))) (poly-reduce (poly* #r(8 1) #r(-3 1))))))
      (if (not (mus-arrays-equal? vals #r(-24.000 5.000 1.000))) (snd-display "poly-gcd 4: ~A" vals)))
    (let ((vals (poly-gcd #r(-1 0 1) #r(2 -2 -1 1))))
      (if (not (mus-arrays-equal? vals #r(0.000))) (snd-display "poly-gcd 5: ~A" vals)))
    (let ((vals (poly-gcd #r(2 -2 -1 1) #r(-1 0 1))))
      (if (not (mus-arrays-equal? vals #r(1.000 -1.000))) (snd-display "poly-gcd 6: ~A" vals)))
    (let ((vals (poly-gcd #r(2 -2 -1 1) #r(-2.5 1))))
      (if (not (mus-arrays-equal? vals #r(0.000))) (snd-display "poly-gcd 7: ~A" vals)))
    
    (poly-roots-tests)
    
    (let ((val (poly-as-vector-resultant (vector -1 0 1) (vector 1 -2 1))))
      (if (fneq val 0.0) (snd-display "poly-resultant 0: ~A" val)))
    (let ((val (poly-as-vector-resultant (vector -1 0 2) (vector 1 -2 1))))
      (if (fneq val 1.0) (snd-display "poly-resultant 1: ~A" val)))
    (let ((val (poly-as-vector-resultant (vector -1 0 1) (vector 1 1))))
      (if (fneq val 0.0) (snd-display "poly-resultant 2: ~A" val)))
    (let ((val (poly-as-vector-resultant (vector -1 0 1) (vector 2 1))))
      (if (fneq val 3.0) (snd-display "poly-resultant 3: ~A" val)))
    (let ((val (poly-resultant #r(-1 0 1) #r(1 -2 1))))
      (if (fneq val 0.0) (snd-display "poly-resultant 0: ~A" val)))
    
    (let ((val (poly-as-vector-discriminant (vector -1 0 1))))
      (if (fneq val -4.0) (snd-display "poly-discriminant 0: ~A" val)))
    (let ((val (poly-as-vector-discriminant (vector 1 -2 1))))
      (if (fneq val 0.0) (snd-display "poly-discriminant 1: ~A" val)))
    (let ((val (poly-discriminant (poly-reduce (poly* (poly* #r(-1 1) #r(-1 1)) #r(3 1))))))
      (if (fneq val 0.0) (snd-display "poly-discriminant 2: ~A" val)))
    (let ((val (poly-discriminant (poly-reduce (poly* (poly* (poly* #r(-1 1) #r(-1 1)) #r(3 1)) #r(2 1))))))
      (if (fneq val 0.0) (snd-display "poly-discriminant 3: ~A" val)))
    (let ((val (poly-discriminant (poly-reduce (poly* (poly* (poly* #r(1 1) #r(-1 1)) #r(3 1)) #r(2 1))))))
      (if (fneq val 2304.0) (snd-display "poly-discriminant 4: ~A" val)))
    (let ((val (poly-discriminant (poly-reduce (poly* (poly* (poly* #r(1 1) #r(-1 1)) #r(3 1)) #r(3 1))))))
      (if (fneq val 0.0) (snd-display "poly-discriminant 5: ~A" val)))
    
    
    (let ((v0 (make-float-vector 10)))
      (do ((i 0 (+ i 1))) ((= i 10))
	(set! (v0 i) i))
      (if (fneq (array-interp v0 3.5) 3.5) (snd-display "array-interp: ~F?" (array-interp v0 3.5)))
      (if (fneq (array-interp v0 13.5) 3.5) (snd-display "array-interp(13.5): ~F?" (array-interp v0 13.5)))
      (if (fneq (array-interp v0 -6.5) 3.5) (snd-display "array-interp(-6.5): ~F?" (array-interp v0 -6.5)))
      (if (fneq (array-interp v0 103.6) 3.6) (snd-display "array-interp(103.5): ~F?" (array-interp v0 103.6)))
      (if (fneq (array-interp v0 -106.6) 3.4) (snd-display "array-interp(-106.6): ~F?" (array-interp v0 -106.6)))
      (if (fneq (array-interp v0 -0.5) 4.5) (snd-display "array-interp(-0.5): ~F?" (array-interp v0 -0.5)))
      ;; interpolating between 9 and 0 here (confusing...)
      (if (fneq (array-interp v0 -0.9) 8.1) (snd-display "array-interp(-0.9): ~F?" (array-interp v0 -0.9)))
      (if (fneq (array-interp v0 -0.1) 0.9) (snd-display "array-interp(-0.1): ~F?" (array-interp v0 -0.1)))
      (if (fneq (array-interp v0 9.1) 8.1) (snd-display "array-interp(9.1): ~F?" (array-interp v0 9.1)))
      (if (fneq (array-interp v0 9.9) 0.9) (snd-display "array-interp(9.9): ~F?" (array-interp v0 9.9)))
      (if (fneq (array-interp v0 10.1) 0.1) (snd-display "array-interp(10.1): ~F?" (array-interp v0 10.1)))
      (let ((var (catch #t (lambda () (array-interp v0 1 -10)) (lambda args args))))
	(if (not (eq? (car var) 'out-of-range))
	    (snd-display "array-interp bad index: ~A" var))))
    
    (let ((ind (open-sound "oboe.snd")))
      (let ((diff (array-interp-sound-diff ind 0)))
	(if (> diff .00001) (snd-display "array-interp-sound-diff: ~A" diff)))
      (close-sound ind))
    
    (let ((v0 (make-float-vector 10)))
      (do ((i 0 (+ i 1))) ((= i 10))
	(set! (v0 i) i))
      (let ((val (mus-interpolate mus-interp-linear 1.5 v0)))
	(if (fneq val 1.5) (snd-display "mus-interpolate linear: ~A" val))
	(set! val (mus-interpolate mus-interp-all-pass 1.5 v0))
	(if (fneq val 1.5) (snd-display "mus-interpolate all-pass: ~A" val))
	(set! val (mus-interpolate mus-interp-none 1.5 v0))
	(if (fneq val 1.0) (snd-display "mus-interpolate none: ~A" val))
	(set! val (mus-interpolate mus-interp-hermite 1.5 v0))
	(if (fneq val 1.5) (snd-display "mus-interpolate hermite: ~A" val))
	(set! val (mus-interpolate mus-interp-bezier 1.5 v0))
	(if (fneq val 1.5) (snd-display "mus-interpolate bezier: ~A" val))
	(set! val (mus-interpolate mus-interp-lagrange 1.5 v0))
	(if (fneq val 1.5) (snd-display "mus-interpolate lagrange: ~A" val))
	(do ((i 0 (+ i 1))) ((= i 10)) (set! (v0 i) (sin (* pi (/ i 5)))))
	(set! val (mus-interpolate mus-interp-linear 1.5 v0))
	(if (fneq val 0.7694) (snd-display "mus-interpolate linear sin: ~A" val))
	(set! val (mus-interpolate mus-interp-all-pass 1.5 v0))
	(if (fneq val 0.7694) (snd-display "mus-interpolate all-pass sin: ~A" val))
	(set! val (mus-interpolate mus-interp-none 1.5 v0))
	(if (fneq val 0.5877) (snd-display "mus-interpolate none sin: ~A" val))
	(set! val (mus-interpolate mus-interp-hermite 1.5 v0))
	(if (fneq val 0.8061) (snd-display "mus-interpolate hermite sin: ~A" val))
	(set! val (mus-interpolate mus-interp-bezier 1.5 v0))
	(if (fneq val 0.6959) (snd-display "mus-interpolate bezier sin: ~A" val))
	(set! val (mus-interpolate mus-interp-lagrange 1.5 v0))
	(if (fneq val 0.7975) (snd-display "mus-interpolate lagrange sin: ~A" val))))
    
    (let ((tag (catch #t (lambda () (mus-interpolate 1234 1.0 (make-float-vector 3))) (lambda args (car args)))))
      (if (not (eq? tag 'out-of-range))
	  (snd-display "mus-interpolate 1234: ~A" tag)))
    (let ((tag (catch #t (lambda () (mus-interpolate mus-interp-linear 1.0 (make-float-vector 3) -1)) (lambda args (car args)))))
      (if (not (eq? tag 'out-of-range))
	  (snd-display "mus-interpolate size -1: ~A" tag)))

    ;; this test (for % trouble in C) is from Anders Vinjar, bugfix thanks to Tito Latini
    (let ((d (make-delay 10)))
      (do ((i 0 (+ 1 i)))
	  ((= i 10))
	(delay d i))
      (if (not (mus-arrays-equal? (mus-data d) #r(0.0 1.0 2.0 3.0 4.0 5.0 6.0 7.0 8.0 9.0)))
	  (snd-display "delay data (0..9): ~A~%" (mus-data d)))
      (let ((vals (make-float-vector 10)))
	(do ((i 0 (+ i 1)))
	    ((= i 10))
	  (set! (vals i) (tap d (- i))))
	(if (not (mus-arrays-equal? vals #r(0.0 1.0 2.0 3.0 4.0 5.0 6.0 7.0 8.0 9.0)))
	    (snd-display "delay tapped backwards: ~A~%" vals))
	(do ((i 0 (+ i 1)))
	    ((= i 10))
	  (set! (vals i) (tap d i)))
	(if (not (mus-arrays-equal? vals #r(0.0 9.0 8.0 7.0 6.0 5.0 4.0 3.0 2.0 1.0)))
	    (snd-display "delay tapped forwards: ~A~%" vals))))
    
    (let ((gen1 (make-delay 4 :initial-contents '(1.0 0.5 0.25 0.0)))
	  (gen3 (make-delay 4 :initial-contents #r(1.0 0.5 0.25 0.0))))
      (let ((gen (make-delay 3)))
	(print-and-check gen 
			 "delay" 
			 "delay line[3, step]: [0 0 0]")
	(let ((v0 (make-float-vector 10))
	      (v1 (make-float-vector 10)))
	  (do ((i 0 (+ i 1)))
	      ((= i 10))
	    (set! (v0 i) (delay gen i)))
	  (let ((gen2 (make-delay 3))
		(k 0))
	    (fill-float-vector v1 (let ((val (if (delay? gen2) (delay gen2 k) -1.0)))
				    (set! k (+ k 1)) 
				    val)))
	  (if (not (mus-arrays-equal? v1 v0)) (snd-display "map delay: ~A ~A" v0 v1))
	  (if (not (delay? gen)) (snd-display "~A not delay?" gen))
	  (if (not (= (mus-length gen) 3)) (snd-display "delay length: ~D?" (mus-length gen)))
	  (if (or (fneq (v0 1) 0.0) (fneq (v0 4) 1.0) (fneq (v0 8) 5.0))
	      (snd-display "delay output: ~A" v0))))
      (if (or (fneq (delay gen1) 1.0) 
	      (fneq (delay gen1) 0.5)
	      (fneq (delay gen1) 0.25)
	      (fneq (delay gen1) 0.0))
	  (snd-display "delay with list initial-contents confused"))
      (if (or (fneq (delay gen3) 1.0) 
	      (fneq (delay gen3) 0.5)
	      (fneq (delay gen3) 0.25)
	      (fneq (delay gen3) 0.0))
	  (snd-display "delay with float-vector initial-contents confused")))
    (let ((var (catch #t (lambda () (make-delay 3 :initial-element (make-oscil))) (lambda args args))))
      (if (not (eq? (car var) 'wrong-type-arg))
	  (snd-display "make-delay bad initial element: ~A" var)))
    (let ((var (catch #t (lambda () (make-delay -3)) (lambda args args))))
      (if (not (eq? (car var) 'out-of-range))
	  (snd-display "make-delay bad size: ~A" var)))
    
    (test-gen-equal (let ((d1 (make-delay 3))) (delay d1 1.0) d1) 
		    (let ((d2 (make-delay 3))) (delay d2 1.0) d2)
		    (let ((d3 (make-delay 4))) (delay d3 1.0) d3))
    (test-gen-equal (make-delay 3 :initial-element 1.0) (make-delay 3 :initial-element 1.0) (make-delay 3 :initial-element 0.5))
    (test-gen-equal (make-delay 3 :initial-contents '(1.0 0.0 0.0)) 
		    (make-delay 3 :initial-contents '(1.0 0.0 0.0)) 
		    (make-delay 3 :initial-contents '(1.0 1.0 1.0)))
    
    (let ((gen (make-delay 5)))
      (delay gen 1.0)
      (delay gen 0.0)
      (delay gen 0.5)
      (let ((data (copy (mus-data gen))))
	(float-vector-set! (mus-data gen) 0 0.3)
	(if (fneq ((mus-data gen) 0) 0.3)
	    (snd-display "delay data 0: ~A" ((mus-data gen) 0)))
	(set! (data 0) .75)
	(set! (mus-data gen) data))
      (if (fneq ((mus-data gen) 0) 0.75)
	  (snd-display "delay set data 0: ~A" ((mus-data gen) 0)))
      (delay gen 0.0)
      (delay gen 0.0)
      (let ((val (delay gen 0.0)))
	(if (fneq val 0.75)
	    (snd-display "set delay data: ~A ~A" val (mus-data gen))))
      (if (mus-data (make-oscil))
	  (snd-display "mus-data osc: ~A" (mus-data (make-oscil)))))
    
    (let ((del (make-delay 5 :max-size 8)))
      (delay del 1.0)
      (do ((i 0 (+ i 1))) ((= i 4)) (delay del 0.0))
      (do ((v0 (make-float-vector 5))
	   (i 0 (+ i 1)))
	  ((= i 5)
	   (if (not (mus-arrays-equal? v0 #r(0.600 0.400 0.000 0.000 0.000)))
	       (snd-display "zdelay: ~A" v0)))
	(set! (v0 i) (delay del 0.0 0.4)))
      (delay del 1.0)
      (delay del 0.0 0.4)
      (if (not (string=? (mus-describe del) "delay line[5,8, linear]: [0 0 1 0 0]"))
	  (snd-display "describe zdelay: ~A" (mus-describe del))))
    (let ((tag (catch #t (lambda () (tap (make-oscil))) (lambda args (car args)))))
      (if (not (eq? tag 'wrong-type-arg))
	  (snd-display "tap of oscil: ~A" tag)))
    
    (let ((dly (make-delay 3))
	  (flt (make-one-zero .5 .4))
	  (v (make-float-vector 20)))
      (let ((inval 1.0))
	(fill-float-vector v (let ((res (delay dly (+ inval (* (one-zero flt (tap dly)) .6)))))
			       (set! inval 0.0)
			       res)))
      (if (not (mus-arrays-equal? v #r(0.0 0.0 0.0 1.0 0.0 0.0 0.300 0.240 0.0 0.090 0.144 0.058 0.027 0.065 0.052 0.022 0.026 0.031 0.019 0.013)))
	  (snd-display "tap with low pass: ~A" v)))
    
    (let ((dly (make-delay 3))
	  (v (make-float-vector 20)))
      (let ((inval 1.0))
	(fill-float-vector v (let ((res (delay dly (+ inval (tap dly)))))
			       (set! inval 0.0)
			       res)))
      (if (not (mus-arrays-equal? v #r(0.0 0.0 0.0 1.0 0.0 0.0 1.0 0.0 0.0 1.0 0.0 0.0 1.0 0.0 0.0 1.0 0.0 0.0 1.0 0.0)))
	  (snd-display "simple tap: ~A" v)))
    
    (let ((dly (make-delay 6))
	  (v (make-float-vector 20)))
      (if (not (tap? dly)) (snd-display "tap?: ~A" (tap? dly)))
      (let ((inval 1.0))
	(fill-float-vector v (let ((res (delay dly (+ inval (tap dly -2.0)))))
			       (set! inval 0.0)
			       res)))
      (set! *print-length* (max 20 *print-length*))
      (if (not (mus-arrays-equal? v #r(0.0 0.0 0.0 0.0 0.0 0.0 1.0 0.0 0.0 0.0 1.0 0.0 0.0 0.0 1.0 0.0 0.0 0.0 1.0 0.0)))
	  (snd-display "tap back 2: ~A" v)))
    
    (do ((dly (make-delay 3))
	 (flt (make-one-zero .5 .4))
	 (v (make-float-vector 20))
	 (inval 1.0 0.0)
	 (i 0 (+ i 1)))
	((= i 20)
	 (if (not (mus-arrays-equal? v #r(0.0 0.0 0.0 1.0 0.0 0.0 0.300 0.240 0.0 0.090 0.144 0.058 0.027 0.065 0.052 0.022 0.026 0.031 0.019 0.013)))
	     (snd-display "tap with low pass: ~A" v)))
      (set! (v i) (delay dly (+ inval (* (one-zero flt (tap dly)) .6)))))
    
    (let* ((dly (make-delay 3 :initial-element 32.0))
	   (ddata (mus-data dly)))
      (cond ((not (float-vector? ddata)) (snd-display "delay data not float-vector?"))
	    ((not (= (length ddata) 3))  (snd-display "delay data len not 3: ~A (~A)" (length ddata) ddata))
	    ((fneq (ddata 1) 32.0)       (snd-display "delay [1] 32: ~A" (ddata 1))))
      (let ((tag (catch #t (lambda () (set! (mus-length dly) -1)) (lambda args (car args)))))
	(if (not (eq? tag 'out-of-range)) (snd-display "len to -1 -> ~A" tag)))
      (let ((tag (catch #t (lambda () (set! (mus-length dly) 0)) (lambda args (car args)))))
	(if (not (eq? tag 'out-of-range)) (snd-display "len to 0 -> ~A" tag)))
      (let ((tag (catch #t (lambda () (set! (mus-length dly) 100)) (lambda args (car args)))))
	(if (not (eq? tag 'out-of-range)) (snd-display "len to 100 -> ~A" tag)))
      (let ((tag (catch #t (lambda () (set! ((mus-data dly) 100) .1)) (lambda args (car args)))))
	(if (not (eq? tag 'out-of-range)) (snd-display "data 100 to .1 -> ~A" tag)))
      (set! (mus-data dly) (make-float-vector 32 1.0))
      (set! ddata (mus-data dly))
      (if (not (float-vector? ddata)) (snd-display "set delay data not float-vector?"))
      (if (fneq (ddata 1) 1.0) (snd-display "set delay [1] 1: ~A" (ddata 1)))
      (if (not (= (length ddata) 32)) (snd-display "set delay data len(32): ~A" (length ddata)))
      (let ((tag (catch #t (lambda () (set! (mus-length dly) 100)) (lambda args (car args)))))
	(if (not (eq? tag 'out-of-range)) (snd-display "set len to 100 -> ~A" tag)))
      (let ((tag (catch #t (lambda () (set! (ddata 100) .1)) (lambda args (car args)))))
	(if (not (eq? tag 'out-of-range)) (snd-display "set data 100 to .1 -> ~A" tag))))
    
    (let ((d1 (make-delay 4))
	  (d2 (make-delay 4 :max-size 5 :type mus-interp-linear))
	  (d3 (make-delay 4 :max-size 5 :type mus-interp-all-pass))
	  (d4 (make-delay 4 :max-size 5 :type mus-interp-none))
	  (d5 (make-delay 4 :max-size 4 :type mus-interp-lagrange))
	  (d6 (make-delay 4 :max-size 4 :type mus-interp-hermite))
	  (d7 (make-delay 4 :max-size 4 :type mus-interp-linear))
	  (v1 (make-float-vector 20))
	  (v2 (make-float-vector 20))
	  (v3 (make-float-vector 20))
	  (v4 (make-float-vector 20))
	  (v5 (make-float-vector 20))
	  (v6 (make-float-vector 20))
	  (v7 (make-float-vector 20)))
      (if (not (= (mus-interp-type d1) mus-interp-none)) (snd-display "d1 interp type: ~A" (mus-interp-type d1)))
      (if (not (= (mus-interp-type d2) mus-interp-linear)) (snd-display "d2 interp type: ~A" (mus-interp-type d2)))
      (if (not (= (mus-interp-type d3) mus-interp-all-pass)) (snd-display "d3 interp type: ~A" (mus-interp-type d3)))
      (if (not (= (mus-interp-type d4) mus-interp-none)) (snd-display "d4 interp type: ~A" (mus-interp-type d4)))
      (if (not (= (mus-interp-type d5) mus-interp-lagrange)) (snd-display "d5 interp type: ~A" (mus-interp-type d5)))
      (if (not (= (mus-interp-type d6) mus-interp-hermite)) (snd-display "d6 interp type: ~A" (mus-interp-type d6)))
      (if (not (= (mus-interp-type d7) mus-interp-linear)) (snd-display "d7 interp type: ~A" (mus-interp-type d7)))
      (set! (v1 0) (delay d1 1.0))
      (set! (v2 0) (delay d2 1.0))
      (set! (v3 0) (delay d3 1.0))
      (set! (v4 0) (delay d4 1.0))
      (set! (v5 0) (delay d5 1.0))
      (set! (v6 0) (delay d6 1.0))
      (set! (v7 0) (delay d7 1.0))
      (for-each (lambda (arg) (delay-tick arg 0.0)) (vector d1 d2 d3 d4 d5 d6 d7))
      (do ((i 1 (+ i 1))
	   (j -0.2 (- j 0.2)))
	  ((= i 20))
	(set! (v1 i) (tap d1 j))
	(set! (v2 i) (tap d2 j))
	(set! (v3 i) (tap d3 j))
	(set! (v4 i) (tap d4 j))
	(set! (v5 i) (tap d5 j))
	(set! (v6 i) (tap d6 j))
	(set! (v7 i) (tap d7 j)))
      (set! *print-length* (max 20 *print-length*))
      (if (not (or (mus-arrays-equal? v1 #r(0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 1.0 1.0 1.0 1.0 1.0 0.0 0.0 0.0 0.0 0.0))
		   (mus-arrays-equal? v1 #r(0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 1.0 1.0 1.0 1.0 0.0 0.0 0.0 0.0 0.0))))
	  (snd-display "delay interp none (1): ~A" v1))
      (if (not (mus-arrays-equal? v2 #r(0.0 0.0 0.0 0.0 0.0 0.0 0.200 0.400 0.600 0.800 1.0 0.800 0.600 0.400 0.200 0.0 0.0 0.0 0.0 0.0)))
	  (snd-display "delay interp linear (2): ~A" v2))
      (if (not (mus-arrays-equal? v3 #r(0.000 0.000 0.000 0.000 0.000 1.000 0.000 0.600 0.160 0.168 -0.168 0.334 0.199 0.520 0.696 -0.696 0.557 -0.334 0.134 -0.027)))
	  (snd-display "delay interp all-pass (3): ~A" v3))
      (if (not (or (mus-arrays-equal? v4 #r(0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 1.0 1.0 1.0 1.0 1.0 0.0 0.0 0.0 0.0 0.0))
		   (mus-arrays-equal? v4 #r(0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 1.0 1.0 1.0 1.0 0.0 0.0 0.0 0.0 0.0))))
	  (snd-display "delay interp none (4): ~A" v4))
      (if (not (mus-arrays-equal? v5 #r(0.0 0.0 0.0 0.0 0.0 0.0 0.120 0.280 0.480 0.720 1.000 0.960 0.840 0.640 0.360 0.000 -0.080 -0.120 -0.120 -0.080)))
	  (snd-display "delay interp lagrange (5): ~A" v5))
      (if (not (mus-arrays-equal? v6 #r(0.0 -0.016 -0.048 -0.072 -0.064 0.0 0.168 0.424 0.696 0.912 1.0 0.912 0.696 0.424 0.168 0.0 -0.064 -0.072 -0.048 -0.016)))
	  (snd-display "delay interp hermite (6): ~A" v6))
      (if (not (mus-arrays-equal? v7 #r(0.0 0.0 0.0 0.0 0.0 0.0 0.200 0.400 0.600 0.800 1.0 0.800 0.600 0.400 0.200 0.0 0.0 0.0 0.0 0.0)))
	  (snd-display "delay interp linear (7): ~A" v7)))
    
    (let ((dly1 (make-delay :size 2 :max-size 3))
	  (data (make-float-vector 5))
	  (impulse 1.0))
      (do ((i 0 (+ i 1)))
	  ((= i 5))
	(set! (data i) (delay dly1 impulse 0.4)) ; longer line
	(set! impulse 0.0))
      (if (not (mus-arrays-equal? data #r(0.0 0.0 0.6 0.4 0.0)))
	  (snd-display "delay size 2, max 3, off 0.4: ~A" data))
      
      (set! dly1 (make-delay :size 2 :max-size 3))
      (set! impulse 1.0)
      (do ((i 0 (+ i 1)))
	  ((= i 5))
	(set! (data i) (delay dly1 impulse -0.4)) ; shorter line
	(set! impulse 0.0))
      (if (not (mus-arrays-equal? data #r(0.0 0.4 0.6 0.0 0.0)))
	  (snd-display "delay size 2, max 3, off -0.4: ~A" data))
      
      (set! dly1 (make-delay :size 1 :max-size 2))
      (set! impulse 1.0)
      (do ((i 0 (+ i 1)))
	  ((= i 5))
	(set! (data i) (delay dly1 impulse 0.4))
	(set! impulse 0.0))
      (if (not (mus-arrays-equal? data #r(0.0 0.6 0.4 0.0 0.0)))
	  (snd-display "delay size 1, max 2, off 0.4: ~A" data))
      
      (set! dly1 (make-delay :size 0 :max-size 1))
      (set! impulse 1.0)
      (do ((i 0 (+ i 1)))
	  ((= i 5))
	(set! (data i) (delay dly1 impulse 0.4))
	(set! impulse 0.0))
      (if (not (mus-arrays-equal? data #r(0.6 0.4 0.0 0.0 0.0)))
	  (snd-display "delay size 0, max 1, off 0.4: ~A" data))
      
      (set! dly1 (make-delay :size 0 :max-size 1))
      (let ((val (delay dly1 0.0)))
	(if (fneq val 0.0) (snd-display "initial delay 0 size val: ~A" val)))
      
      (set! dly1 (make-delay :size 0 :max-size 1))
      (set! impulse 1.0)
      (do ((i 0 (+ i 1)))
	  ((= i 5))
	(set! (data i) (delay dly1 impulse -0.4)) ; shorter than 0? should this be an error?
	(set! impulse 0.0))
      (if (not (mus-arrays-equal? data #r(1.4 -0.4 0.0 0.0 0.0))) ; hmmm -- they're asking for undefined values here 
	  (snd-display "delay size 0, max 1, off -0.4: ~A" data))
      
      (set! dly1 (make-delay 0))
      (set! impulse 1.0)
      (do ((i 0 (+ i 1)))
	  ((= i 5))
	(set! (data i) (delay dly1 impulse)) 
	(set! impulse 0.0))
      (if (not (mus-arrays-equal? data #r(1 0 0 0 0)))
	  (snd-display "delay size 0: ~A" data))
      (let ((x (delay dly1 0.5)))
	(if (fneq x 0.5)
	    (snd-display "delay size 0 0.5: ~A" x)))
      )
    
    (let ((gen (make-delay :size 0 :max-size 100))
	  (v (make-float-vector 10)))
      (do ((i 0 (+ i 1)))
	  ((= i 10))
	(set! (v i) (delay gen 0.5 i)))
      (if (not (mus-arrays-equal? v #r(0.500 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000)))
	  (snd-display "delay 0 -> 100: ~A" v))
      (do ((i 9 (- i 1)))
	  ((< i 0))
	(set! (v i) (delay gen 0.5 i)))
      (if (not (mus-arrays-equal? v (make-float-vector 10 0.5)))
	  (snd-display "delay 100 -> 0: ~A" v))
      (mus-reset gen)
      (if (not (mus-arrays-equal? (mus-data gen) (make-float-vector 100)))
	  (snd-display "after reset mus-data delay peak: ~A" (float-vector-peak (mus-data gen))))
      (do ((i 0 (+ i 1)))
	  ((= i 10))
	(set! (v i) (delay gen (if (odd? i) 1.0 0.0) (* i .1))))
      (if (not (mus-arrays-equal? v #r(0.000 0.900 0.000 0.700 0.000 0.500 0.000 0.300 0.000 0.100)))
	  (snd-display "delay 0 -> 100 .1: ~A (~A)" v gen))
      (mus-reset gen)
      (do ((i 0 (+ i 1)))
	  ((= i 10))
	(set! (v i) (delay gen (if (odd? i) 1.0 0.0) (+ 1.0 (* i .1)))))
      (if (not (mus-arrays-equal? v #r(0.000 0.000 0.800 0.300 0.600 0.500 0.400 0.700 0.200 0.900)))
	  (snd-display "delay 0 -> 100 1.1: ~A" v)))
    
    
    (let ((gen (make-all-pass .4 .6 3))
	  (v0 (make-float-vector 10)))
      (print-and-check gen 
		       "all-pass"
		       "all-pass feedback: 0.400, feedforward: 0.600, line[3, step]:[0 0 0]")
      (do ((i 0 (+ i 1)))
	  ((= i 10))
	(set! (v0 i) (all-pass gen 1.0)))
      (let ((gen1 (make-all-pass .4 .6 3))
	    (v1 (make-float-vector 10)))  
	(fill-float-vector v1 (if (all-pass? gen1) (all-pass gen1 1.0) -1.0))
	(if (not (mus-arrays-equal? v1 v0)) (snd-display "map all-pass: ~A ~A" v0 v1)))
      (if (not (all-pass? gen)) (snd-display "~A not all-pass?" gen))
      (if (not (= (mus-length gen) 3)) (snd-display "all-pass length: ~D?" (mus-length gen)))
      (if (not (= (mus-order gen) 3)) (snd-display "all-pass order: ~D?" (mus-order gen)))
      (if (fneq (mus-feedback gen) .4) (snd-display "all-pass feedback: ~F?" (mus-feedback gen)))
      (if (fneq (mus-feedforward gen) .6) (snd-display "all-pass feedforward: ~F?" (mus-feedforward gen)))
      (if (or (fneq (v0 1) 0.6) (fneq (v0 4) 1.84) (fneq (v0 8) 2.336))
	  (snd-display "all-pass output: ~A" v0))
      (set! (mus-feedback gen) 0.5) 
      (if (fneq (mus-feedback gen) .5) (snd-display "all-pass set-feedback: ~F?" (mus-feedback gen)))
      (set! (mus-feedforward gen) 0.5) 
      (if (fneq (mus-feedforward gen) .5) (snd-display "all-pass set-feedforward: ~F?" (mus-feedforward gen))))
    
    (test-gen-equal (let ((d1 (make-all-pass 0.7 0.5 3))) (all-pass d1 1.0) d1)
		    (let ((d2 (make-all-pass 0.7 0.5 3))) (all-pass d2 1.0) d2) 
		    (let ((d3 (make-all-pass 0.7 0.5 4))) (all-pass d3 1.0) d3))
    (test-gen-equal (make-all-pass 0.7 0.5 3 :initial-element 1.0) 
		    (make-all-pass 0.7 0.5 3 :initial-element 1.0) 
		    (make-all-pass 0.7 0.5 3 :initial-element 0.5))
    (test-gen-equal (make-all-pass 0.7 0.5 3 :initial-element 1.0) 
		    (make-all-pass 0.7 0.5 3 :initial-element 1.0) 
		    (make-all-pass 0.5 0.5 3 :initial-element 1.0))
    (test-gen-equal (make-all-pass 0.7 0.5 3 :initial-contents '(1.0 0.0 0.0)) 
		    (make-all-pass 0.7 0.5 3 :initial-contents '(1.0 0.0 0.0)) 
		    (make-all-pass 0.7 0.5 3 :initial-contents '(1.0 1.0 1.0)))
    (let ((err (catch #t (lambda () (make-all-pass :feedback .2 :feedforward .1 :size -1)) (lambda args args))))
      (if (not (eq? (car err) 'out-of-range))
	  (snd-display "make-all-pass bad size error message: ~A" err)))
    
    (let ((gen (make-moving-average 4))
	  (v0 (make-float-vector 10)))
      (print-and-check gen 
		       "moving-average"
		       "moving-average 0.000, line[4]:[0 0 0 0]")
      (do ((i 0 (+ i 1)))
	  ((= i 10))
	(set! (v0 i) (moving-average gen 1.0)))
      (let ((gen1 (make-moving-average 4))
	    (v1 (make-float-vector 10)))  
	(fill-float-vector v1 (if (moving-average? gen1) (moving-average gen1 1.0) -1.0))
	(if (not (mus-arrays-equal? v1 v0)) (snd-display "map average: ~A ~A" v0 v1)))
      (if (not (moving-average? gen)) (snd-display "~A not average?" gen))
      (if (not (= (mus-length gen) 4)) (snd-display "average length: ~D?" (mus-length gen)))
      (if (not (= (mus-order gen) 4)) (snd-display "average order: ~D?" (mus-order gen)))
      (if (or (fneq (v0 1) 0.5) (fneq (v0 4) 1.0) (fneq (v0 8) 1.0))
	  (snd-display "average output: ~A" v0)))
    
    (let* ((gen (make-moving-average 8))
	   (val (moving-average gen)))
      (if (fneq val 0.0) (snd-display "empty average: ~A" val))
      (set! val (moving-average gen 1.0))
      (if (fneq val 0.125) (snd-display "average 1: ~A" val))
      (set! val (moving-average gen 1.0))
      (if (fneq val 0.25) (snd-display "average 2: ~A" val))
      (set! val (moving-average gen 0.5))
      (if (fneq val 0.3125) (snd-display "average 2: ~A" val))
      (do ((i 0 (+ i 1))) ((= i 5)) (set! val (moving-average gen 0.0))) 
      (if (fneq val 0.3125) (snd-display "average 6: ~A" val))
      (set! val (moving-average gen 0.0))
      (if (fneq val 0.1875) (snd-display "average 7: ~A" val))
      (set! val (moving-average gen 0.0))
      (if (fneq val 0.0625) (snd-display "average 8: ~A" val))
      (set! val (moving-average gen 0.0))
      (if (fneq val 0.0) (snd-display "average 9: ~A" val)))

    (let ((val (moving-average (make-moving-average 10 :initial-element .5) 0.5)))
      (if (fneq val 0.5) (snd-display "average initial-element: ~A" val)))
    (let ((val (moving-average (make-moving-average 3 :initial-contents '(1.0 1.0 1.0)) 1.0)))
      (if (fneq val 1.0) (snd-display "average initial-contents: ~A" val)))
    
    (test-gen-equal (let ((d1 (make-moving-average 3 :initial-contents '(0.7 0.5 3)))) (moving-average d1 1.0) d1)
		    (let ((d2 (make-moving-average 3 :initial-contents #r(0.7 0.5 3)))) (moving-average d2 1.0) d2) 
		    (let ((d3 (make-moving-average 4 :initial-contents '(0.7 0.5 0.1 4)))) (moving-average d3 1.0) d3))
    (test-gen-equal (make-moving-average 3 :initial-element 1.0) 
		    (make-moving-average 3 :initial-element 1.0) 
		    (make-moving-average 3 :initial-element 0.5))
    (test-gen-equal (make-moving-average 3 :initial-element 1.0) 
		    (make-moving-average 3 :initial-element 1.0) 
		    (make-moving-average 4 :initial-element 1.0))
    (test-gen-equal (make-moving-average 3 :initial-contents '(1.0 0.0 0.0)) 
		    (make-moving-average 3 :initial-contents '(1.0 0.0 0.0)) 
		    (make-moving-average 3 :initial-contents '(1.0 1.0 1.0)))
    (let ((err (catch #t (lambda () (make-moving-average :size -1)) (lambda args args))))
      (if (not (eq? (car err) 'out-of-range))
	  (snd-display "make-average bad size error message: ~A" err)))
    (let ((err (catch #t (lambda () (make-moving-average :size 0)) (lambda args args))))
      (if (not (eq? (car err) 'out-of-range))
	  (snd-display "make-average size==0 error message: ~A" err)))

    (let ((gen (make-moving-max 4))
	  (v0 (make-float-vector 10))
	  (v1 (make-float-vector 10)))
      (print-and-check gen 
		       "moving-max"
		       "moving-max 0.000, line[4]:[0 0 0 0]")
      (do ((i 0 (+ i 1)))
	  ((= i 10))
	(set! (v0 i) (moving-max gen 1.0)))
      (let ((gen1 (make-moving-max 4)))
	(fill-float-vector v1 (if (moving-max? gen1) (moving-max gen1 1.0) -1.0)))
      (if (not (mus-arrays-equal? v1 v0)) (snd-display "map max: ~A ~A" v0 v1))
      (if (not (moving-max? gen)) (snd-display "~A not max?" gen))
      (if (not (= (mus-length gen) 4)) (snd-display "max length: ~D?" (mus-length gen)))
      (if (not (= (mus-order gen) 4)) (snd-display "max order: ~D?" (mus-order gen)))
      (if (or (fneq (v0 1) 1.0) (fneq (v0 4) 1.0) (fneq (v0 8) 1.0))
	  (snd-display "max output: ~A" v0)))
    
    (let* ((gen (make-moving-max 8))
	   (val (moving-max gen)))
      (if (fneq val 0.0) (snd-display "empty max: ~A" val))
      (set! val (moving-max gen 1.0))
      (if (fneq val 1.0) (snd-display "max 1: ~A" val))
      (set! val (moving-max gen -0.5))
      (if (fneq val 1.0) (snd-display "max 2: ~A" val))
      (set! val (moving-max gen -1.5))
      (if (fneq val 1.5) (snd-display "max 2: ~A" val))
      (do ((i 0 (+ i 1))) ((= i 5)) (set! val (moving-max gen 0.0))) 
      (if (fneq val 1.5) (snd-display "max 6: ~A" val))
      (set! val (moving-max gen 0.0))
      (if (fneq val 1.5) (snd-display "max 7: ~A" val))
      (set! val (moving-max gen 0.0))
      (if (fneq val 1.5) (snd-display "max 8: ~A" val))
      (set! val (moving-max gen 0.0))
      (if (fneq val 0.0) (snd-display "max 9: ~A" val)))

    (let ((val (moving-max (make-moving-max 10 :initial-element .5) 0.5)))
      (if (fneq val 0.5) (snd-display "max initial-element: ~A" val)))
    (let ((val (moving-max (make-moving-max 3 :initial-contents '(1.0 1.0 1.0)) 1.0)))
      (if (fneq val 1.0) (snd-display "max initial-contents: ~A" val)))
    
    (test-gen-equal (let ((d1 (make-moving-max 3 :initial-contents '(0.7 0.5 3)))) (moving-max d1 1.0) d1)
		    (let ((d2 (make-moving-max 3 :initial-contents #r(0.7 0.5 3)))) (moving-max d2 1.0) d2) 
		    (let ((d3 (make-moving-max 4 :initial-contents '(0.7 0.5 0.1 4)))) (moving-max d3 1.0) d3))
    (test-gen-equal (make-moving-max 3 :initial-element 1.0) 
		    (make-moving-max 3 :initial-element 1.0) 
		    (make-moving-max 3 :initial-element 0.5))
    (test-gen-equal (make-moving-max 3 :initial-element 1.0) 
		    (make-moving-max 3 :initial-element 1.0) 
		    (make-moving-max 4 :initial-element 1.0))
    (test-gen-equal (make-moving-max 3 :initial-contents '(1.0 0.0 0.0)) 
		    (make-moving-max 3 :initial-contents '(1.0 0.0 0.0)) 
		    (make-moving-max 3 :initial-contents '(1.0 1.0 1.0)))
    (let ((err (catch #t (lambda () (make-moving-max :size -1)) (lambda args args))))
      (if (not (eq? (car err) 'out-of-range))
	  (snd-display "make-max bad size error message: ~A" err)))
    (let ((err (catch #t (lambda () (make-moving-max :size 0)) (lambda args args))))
      (if (not (eq? (car err) 'out-of-range))
	  (snd-display "make-max size==0 error message: ~A" err)))

    (let ((gen (make-moving-norm 4))
	  (v0 (make-float-vector 10))
	  (v1 (make-float-vector 10)))
      (print-and-check gen 
		       "moving-norm"
		       "moving-norm, max 0.000, y1 5.000, weight 0.800, line[4]:[0 0 0 0]")
      (do ((i 0 (+ i 1)))
	  ((= i 10))
	(set! (v0 i) (moving-norm gen 1.0)))
      (let ((gen1 (make-moving-norm 4)))
	(fill-float-vector v1 (if (moving-norm? gen1) (moving-norm gen1 1.0) -1.0)))
      (if (not (mus-arrays-equal? v1 v0)) (snd-display "map norm: ~A ~A" v0 v1))
      (if (not (moving-norm? gen)) (snd-display "~A not norm?" gen))
      (if (not (= (mus-length gen) 4)) (snd-display "norm length: ~D?" (mus-length gen)))
      (if (not (= (mus-order gen) 4)) (snd-display "norm order: ~D?" (mus-order gen))))
    
    (let* ((gen (make-moving-norm 8))
	   (val (moving-norm gen)))
      (if (fneq val 1.1236) (snd-display "empty norm: ~A" val))
      (set! val (moving-norm gen 1.0))
      (if (fneq val 1.1084) (snd-display "norm 1: ~A" val))
      (set! val (moving-norm gen -0.5))
      (if (fneq val 1.0952) (snd-display "norm 2: ~A" val))
      (set! val (moving-norm gen -1.5))
      (if (fneq val 1.0222) (snd-display "norm 2: ~A" val))
      (do ((i 0 (+ i 1))) ((= i 5)) (set! val (moving-norm gen 0.0))) 
      (if (fneq val 0.8261) (snd-display "norm 6: ~A" val))
      (set! val (moving-norm gen 0.0))
      (if (fneq val 0.8047) (snd-display "norm 7: ~A" val))
      (set! val (moving-norm gen 0.0))
      (if (fneq val 0.7866) (snd-display "norm 8: ~A" val))
      (set! val (moving-norm gen 0.0))
      (if (fneq val 0.8841) (snd-display "norm 9: ~A" val)))

    (let ((val (moving-norm (make-moving-norm 10 :initial-element .5) 0.5)))
      (if (fneq val 1.0476) (snd-display "norm initial-element: ~A" val)))
    (let ((val (moving-norm (make-moving-norm 3 :initial-contents '(1.0 1.0 1.0)) 1.0)))
      (if (fneq val 1.0) (snd-display "norm initial-contents: ~A" val)))
    
    (test-gen-equal (let ((d1 (make-moving-norm 3))) (moving-norm d1 1.0) d1)
		    (let ((d2 (make-moving-norm 3))) (moving-norm d2 1.0) d2) 
		    (let ((d3 (make-moving-norm 4))) (moving-norm d3 1.0) d3))
    (test-gen-equal (make-moving-norm 3 :scaler 1.0) 
		    (make-moving-norm 3 :scaler 1.0) 
		    (make-moving-norm 4 :scaler 1.0))
    (let ((err (catch #t (lambda () (make-moving-norm :size -1)) (lambda args args))))
      (if (not (eq? (car err) 'out-of-range))
	  (snd-display "make-norm bad size error message: ~A" err)))
    (let ((err (catch #t (lambda () (make-moving-norm :size 0)) (lambda args args))))
      (if (not (eq? (car err) 'out-of-range))
	  (snd-display "make-norm size==0 error message: ~A" err)))


    (let ((gen (make-comb .4 3))
	  (v0 (make-float-vector 10))
	  (v1 (make-float-vector 10)))
      (print-and-check gen 
		       "comb"
		       "comb scaler: 0.400, line[3, step]: [0 0 0]")
      (do ((i 0 (+ i 1)))
	  ((= i 10))
	(set! (v0 i) (comb gen 1.0)))
      (let ((gen1 (make-comb .4 3)))
	(fill-float-vector v1 (if (comb? gen1) (comb gen1 1.0) -1.0)))
      (if (not (mus-arrays-equal? v0 v1)) (snd-display "map comb: ~A ~A" v0 v1))
      (if (not (comb? gen)) (snd-display "~A not comb?" gen))
      (if (not (= (mus-length gen) 3)) (snd-display "comb length: ~D?" (mus-length gen)))
      (if (not (= (mus-order gen) 3)) (snd-display "comb order: ~D?" (mus-order gen)))
      (if (fneq (mus-feedback gen) .4) (snd-display "comb feedback: ~F?" (mus-feedback gen)))
      (if (or (fneq (v0 1) 0.0) (fneq (v0 4) 1.0) (fneq (v0 8) 1.4))
	  (snd-display "comb output: ~A" v0)))
    
    (test-gen-equal (let ((d1 (make-comb 0.7 3))) (comb d1 1.0) d1) 
		    (let ((d2 (make-comb 0.7 3))) (comb d2 1.0) d2) 
		    (let ((d3 (make-comb 0.7 4))) (comb d3 1.0) d3))
    (test-gen-equal (make-comb 0.7 3 :initial-element 1.0) 
		    (make-comb 0.7 3 :initial-element 1.0) 
		    (make-comb 0.7 3 :initial-element 0.5))
    (test-gen-equal (make-comb 0.7 3 :initial-element 1.0) 
		    (make-comb 0.7 3 :initial-element 1.0) 
		    (make-comb 0.5 3 :initial-element 1.0))
    (test-gen-equal (make-comb 0.7 3 :initial-contents '(1.0 0.0 0.0)) 
		    (make-comb 0.7 3 :initial-contents '(1.0 0.0 0.0)) 
		    (make-comb 0.7 3 :initial-contents '(1.0 1.0 1.0)))
    
    (let ((del (make-comb 0.0 5 :max-size 8)))
      (comb del 1.0)
      (do ((i 0 (+ i 1))) ((= i 4)) (comb del 0.0))
      (do ((v0 (make-float-vector 5))
	   (i 0 (+ i 1)))
	  ((= i 5)
	   (if (not (mus-arrays-equal? v0 #r(0.600 0.400 0.000 0.000 0.000))) ; this is assuming interpolation in the delay...
	       (snd-display "zcomb: ~A" v0)))
	(set! (v0 i) (comb del 0.0 0.4)))
      (comb del 1.0)
      (comb del 0.0 0.4)
      (if (not (string=? (mus-describe del) "comb scaler: 0.000, line[5,8, linear]: [0 0 1 0 0]"))
	  (snd-display "describe zcomb: ~A" (mus-describe del)))
      (set! (mus-feedback del) 1.0)
      (if (fneq (mus-feedback del) 1.0)
	  (snd-display "comb feedback set: ~A" (mus-feedback del))))
    
    (let ((gen (make-filtered-comb .4 5 :filter (make-one-zero .3 .7))))
      (print-and-check gen 
		       "filtered-comb"
		       "filtered-comb scaler: 0.400, line[5, step]: [0 0 0 0 0], filter: [one-zero a0: 0.300, a1: 0.700, x1: 0.000]")
      (do ((v0 (make-float-vector 20))
	   (val 1.0 0.0)
	   (i 0 (+ i 1)))
	  ((= i 20)
	   (if (not (mus-arrays-equal? v0 #r(0.000 0.000 0.000 0.000 0.000 1.000 0.000 0.000 0.000 0.000 0.120 0.280 0.000 0.000 0.000 0.014 0.067 0.078 0.000 0.000)))
	       (snd-display "filtered-comb: ~A" v0)))
	(set! (v0 i) (filtered-comb gen val)))
      (if (not (filtered-comb? gen)) (snd-display "~A not filtered-comb?" gen))
      (if (not (= (mus-length gen) 5)) (snd-display "filtered-comb length: ~D?" (mus-length gen)))
      (if (not (= (mus-order gen) 5)) (snd-display "filtered-comb order: ~D?" (mus-order gen)))
      (if (fneq (mus-feedback gen) .4) (snd-display "filtered-comb feedback: ~F?" (mus-feedback gen))))
    
    (let ((gen (make-filtered-comb .9 5 :filter (make-one-zero .5 .5)))
	  (v0 (make-float-vector 20)))
      (print-and-check gen 
		       "filtered-comb"
		       "filtered-comb scaler: 0.900, line[5, step]: [0 0 0 0 0], filter: [one-zero a0: 0.500, a1: 0.500, x1: 0.000]")
      (do ((val 1.0 0.0)
	   (i 0 (+ i 1)))
	  ((= i 20))
	(set! (v0 i) (filtered-comb gen val)))
      (if (not (mus-arrays-equal? v0 #r(0.000 0.000 0.000 0.000 0.000 1.000 0.000 0.000 0.000 0.000 0.450 0.450 0.000 0.000 0.000 0.202 0.405 0.202 0.000 0.000)))
	  (snd-display "filtered-comb .5 .5: ~A" v0)))
    
    (let ((gen (make-filtered-comb .9 5 :filter (make-fir-filter 5 #r(.1 .2 .3 .2 .1))))
	  (v0 (make-float-vector 20)))
      (print-and-check gen 
		       "filtered-comb"
		       "filtered-comb scaler: 0.900, line[5, step]: [0 0 0 0 0], filter: [fir-filter order: 5, xs: [0.1 0.2 0.3 0.2 0.1]]")
      (do ((val 1.0 0.0)
	   (i 0 (+ i 1)))
	  ((= i 20))
	(set! (v0 i) (filtered-comb gen val)))
      (if (not (mus-arrays-equal? v0 #r(0.000 0.000 0.000 0.000 0.000 1.000 0.000 0.000 0.000 0.000 0.090 0.180 0.270 0.180 0.090 0.008 0.032 0.081 0.130 0.154)))
	  (snd-display "filtered-comb fir: ~A" v0)))
    
    (test-gen-equal (let ((d1 (make-filtered-comb 0.7 3 :filter (make-one-pole .3 .7)))) (filtered-comb d1 1.0) d1) 
		    (let ((d2 (make-filtered-comb 0.7 3 :filter (make-one-pole .3 .7)))) (filtered-comb d2 1.0) d2) 
		    (let ((d3 (make-filtered-comb 0.7 4 :filter (make-one-pole .3 .7)))) (filtered-comb d3 1.0) d3))
    (test-gen-equal (make-filtered-comb 0.7 3 :initial-element 1.0 :filter (make-one-zero .5 .5)) 
		    (make-filtered-comb 0.7 3 :initial-element 1.0 :filter (make-one-zero .5 .5)) 
		    (make-filtered-comb 0.7 3 :initial-element 0.5 :filter (make-one-zero .5 .5)))
    (test-gen-equal (make-filtered-comb 0.7 3 :initial-element 1.0 :filter (make-one-zero .5 .5)) 
		    (make-filtered-comb 0.7 3 :initial-element 1.0 :filter (make-one-zero .5 .5)) 
		    (make-filtered-comb 0.7 3 :initial-element 1.0 :filter (make-one-zero .25 .75)))
    (test-gen-equal (make-filtered-comb 0.7 3 :initial-contents '(1.0 0.0 0.0) :filter (make-one-zero .5 .5)) 
		    (make-filtered-comb 0.7 3 :initial-contents '(1.0 0.0 0.0) :filter (make-one-zero .5 .5)) 
		    (make-filtered-comb 0.7 3 :initial-contents '(1.0 1.0 1.0) :filter (make-one-zero .5 .5)))
    
    (let ((del (make-filtered-comb 0.0 5 :max-size 8 :filter (make-one-zero .5 .5))))
      (filtered-comb del 1.0)
      (do ((i 0 (+ i 1))) ((= i 4)) (filtered-comb del 0.0))
      (do ((v0 (make-float-vector 5))
	   (i 0 (+ i 1)))
	  ((= i 5)
	   (if (not (mus-arrays-equal? v0 #r(0.600 0.400 0.000 0.000 0.000))) ; this is assuming interpolation in the delay...
	       (snd-display "zfiltered-comb: ~A" v0)))
	(set! (v0 i) (filtered-comb del 0.0 0.4)))
      (filtered-comb del 1.0)
      (filtered-comb del 0.0 0.4)
      (if (not (string=? (mus-describe del)
			 "filtered-comb scaler: 0.000, line[5,8, linear]: [0 0 1 0 0], filter: [one-zero a0: 0.500, a1: 0.500, x1: 0.000]"))
	  (snd-display "describe zfiltered-comb: ~A" (mus-describe del)))
      (set! (mus-feedback del) 1.0)
      (if (fneq (mus-feedback del) 1.0)
	  (snd-display "filtered-comb feedback set: ~A" (mus-feedback del))))
    
    (let ((gen (make-notch .4 3))
	  (v0 (make-float-vector 10)))
      (print-and-check gen "notch" "notch scaler: 0.400, line[3, step]: [0 0 0]")
      (do ((i 0 (+ i 1)))
	  ((= i 10))
	(set! (v0 i) (notch gen 1.0)))
      (let ((v1 (make-float-vector 10)))
	(let ((gen1 (make-notch .4 3)))
	  (fill-float-vector v1 (if (notch? gen1) (notch gen1 1.0) -1.0)))
	(if (not (mus-arrays-equal? v0 v1)) (snd-display "map notch: ~A ~A" v0 v1)))
      (if (not (notch? gen)) (snd-display "~A not notch?" gen))
      (if (not (= (mus-length gen) 3)) (snd-display "notch length: ~D?" (mus-length gen)))
      (if (not (= (mus-order gen) 3)) (snd-display "notch order: ~D?" (mus-order gen)))
      (if (fneq (mus-feedforward gen) .4) (snd-display "notch feedforward: ~F?" (mus-feedforward gen)))
      (if (or (fneq (v0 1) 0.4) (fneq (v0 4) 1.4) (fneq (v0 8) 1.4))
	  (snd-display "notch output: ~A" v0))
      (set! (mus-feedforward gen) 1.0)
      (if (fneq (mus-feedforward gen) 1.0)
	  (snd-display "notch feedforward set: ~A" (mus-feedforward gen))))
    
    (test-gen-equal (let ((d1 (make-notch 0.7 3))) (notch d1 1.0) d1)
		    (let ((d2 (make-notch 0.7 3))) (notch d2 1.0) d2)
		    (let ((d3 (make-notch 0.7 4))) (notch d3 1.0) d3))
    (test-gen-equal (make-notch 0.7 3 :initial-element 1.0) 
		    (make-notch 0.7 3 :initial-element 1.0) 
		    (make-notch 0.7 3 :initial-element 0.5))
    (test-gen-equal (make-notch 0.7 3 :initial-element 1.0) 
		    (make-notch 0.7 3 :initial-element 1.0) 
		    (make-notch 0.5 3 :initial-element 1.0))
    (test-gen-equal (make-notch 0.7 3 :initial-contents '(1.0 0.0 0.0)) 
		    (make-notch 0.7 3 :initial-contents '(1.0 0.0 0.0)) 
		    (make-notch 0.7 3 :initial-contents '(1.0 1.0 1.0)))
    
    ;; make sure all-pass is the same as comb/notch given the appropriate feedback/forward settings
    
    (do ((gen (make-comb 0.5 5))
	 (v0 (make-float-vector 11))
	 (in1 1.0 0.0)
	 (i 0 (+ i 1)))
	((= i 11)
	 (if (not (mus-arrays-equal? v0 #r(0.000 0.000 0.000 0.000 0.000 1.000 0.000 0.000 0.000 0.000 0.500)))
	     (snd-display "comb (5 .5): ~A" v0)))
      (set! (v0 i) (comb gen in1)))
    
    (do ((gen (make-all-pass 0.5 0.0 5))
	 (v0 (make-float-vector 11))
	 (in1 1.0 0.0)
	 (i 0 (+ i 1)))
	((= i 11)
	 (if (not (mus-arrays-equal? v0 #r(0.000 0.000 0.000 0.000 0.000 1.000 0.000 0.000 0.000 0.000 0.500)))
	     (snd-display "all-pass (5 0 .5): ~A" v0)))
      (set! (v0 i) (all-pass gen in1)))
    
    (do ((gen (make-notch 0.5 5))
	 (v0 (make-float-vector 11))
	 (in1 1.0 0.0)
	 (i 0 (+ i 1)))
	((= i 11)
	 (if (not (mus-arrays-equal? v0 #r(0.500 0.000 0.000 0.000 0.000 1.000 0.000 0.000 0.000 0.000 0.000)))
	     (snd-display "notch (5 .5): ~A" v0)))
      (set! (v0 i) (notch gen in1)))
    
    (do ((gen (make-all-pass 0.0 0.5 5))
	 (v0 (make-float-vector 11))
	 (in1 1.0 0.0)
	 (i 0 (+ i 1)))
	((= i 11)
	 (if (not (mus-arrays-equal? v0 #r(0.500 0.000 0.000 0.000 0.000 1.000 0.000 0.000 0.000 0.000 0.000)))
	     (snd-display "all-pass (5 .5 0): ~A" v0)))
      (set! (v0 i) (all-pass gen in1)))
    
    ;; make sure zall-pass is the same as zcomb/znotch given the appropriate feedback/forward and "pm" settings
    
    (do ((gen (make-comb 0.5 5 :max-size 20))
	 (v0 (make-float-vector 11))
	 (in1 1.0 0.0)
	 (i 0 (+ i 1)))
	((= i 11)
	 (if (not (mus-arrays-equal? v0 #r(0.000 0.000 0.000 0.000 0.000 1.000 0.000 0.000 0.000 0.000 0.500)))
	     (snd-display "1comb (5 .5): ~A" v0)))
      (set! (v0 i) (comb gen in1)))
    
    (do ((gen (make-all-pass 0.5 0.0 5 :max-size 20))
	 (v0 (make-float-vector 11))
	 (in1 1.0 0.0)
	 (i 0 (+ i 1)))
	((= i 11)
	 (if (not (mus-arrays-equal? v0 #r(0.000 0.000 0.000 0.000 0.000 1.000 0.000 0.000 0.000 0.000 0.500)))
	     (snd-display "1all-pass (5 0 .5): ~A" v0)))
      (set! (v0 i) (all-pass gen in1)))
    
    (do ((gen (make-notch 0.5 5 :max-size 20))
	 (v0 (make-float-vector 11))
	 (in1 1.0 0.0)
	 (i 0 (+ i 1)))
	((= i 11)
	 (if (not (mus-arrays-equal? v0 #r(0.500 0.000 0.000 0.000 0.000 1.000 0.000 0.000 0.000 0.000 0.000)))
	     (snd-display "1notch (5 .5): ~A" v0)))
      (set! (v0 i) (notch gen in1)))
    
    (do ((gen (make-all-pass 0.0 0.5 5 :max-size 20))
	 (v0 (make-float-vector 11))
	 (in1 1.0 0.0)
	 (i 0 (+ i 1)))
	((= i 11)
	 (if (not (mus-arrays-equal? v0 #r(0.500 0.000 0.000 0.000 0.000 1.000 0.000 0.000 0.000 0.000 0.000)))
	     (snd-display "1all-pass (5 .5 0): ~A" v0)))
      (set! (v0 i) (all-pass gen in1))    )
    ;; now actually use the size difference
    
    (do ((gen (make-comb 0.5 5 :max-size 20))
	 (v0 (make-float-vector 20))
	 (in1 1.0 0.0)
	 (i 0 (+ i 1))
	 (phase 0.0 (+ phase .2)))
	((= i 20)
	 (if (not (mus-arrays-equal? v0 #r(0.000 0.000 0.000 0.000 0.000 0.000 0.800 0.400 0.000 0.000 0.000 0.000 0.000 0.160 0.360 0.200 0.040 0.000 0.000 0.000)))
	     (snd-display "2comb (5 .5): ~A" v0)))
      (set! (v0 i) (comb gen in1 phase)))
    
    (do ((gen (make-all-pass 0.5 0.0 5 :max-size 20))
	 (v0 (make-float-vector 20))
	 (in1 1.0 0.0)
	 (i 0 (+ i 1))
	 (angle 0.0 (+ angle .2)))
	((= i 20)
	 (if (not (mus-arrays-equal? v0 #r(0.000 0.000 0.000 0.000 0.000 0.000 0.800 0.400 0.000 0.000 0.000 0.000 0.000 0.160 0.360 0.200 0.040 0.000 0.000 0.000)))
	     (snd-display "2all-pass (5 0 .5): ~A" v0)))
      (set! (v0 i) (all-pass gen in1 angle)))
    
    (do ((gen (make-notch 0.5 5 :max-size 20))
	 (v0 (make-float-vector 20))
	 (in1 1.0 0.0)
	 (i 0 (+ i 1))
	 (angle 0.0 (+ angle .2)))
	((= i 20)
	 (if (not (mus-arrays-equal? v0 #r(0.500 0.000 0.000 0.000 0.000 0.000 0.800 0.400 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000)))
	     (snd-display "2notch (5 .5): ~A" v0)))
      (set! (v0 i) (notch gen in1 angle)))
    
    (do ((gen (make-all-pass 0.0 0.5 5 :max-size 20))
	 (v0 (make-float-vector 20))
	 (in1 1.0 0.0)
	 (i 0 (+ i 1))
	 (angle 0.0 (+ angle .2)))
	((= i 20)
	 (if (not (mus-arrays-equal? v0 #r(0.500 0.000 0.000 0.000 0.000 0.000 0.800 0.400 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000)))
	     (snd-display "2all-pass (5 .5 0): ~A" v0)))
      (set! (v0 i) (all-pass gen in1 angle)))
    
    (do ((gen (make-comb 0.5 5 :max-size 20))
	 (v0 (make-float-vector 20))
	 (in1 1.0 0.0)
	 (i 0 (+ i 1))
	 (angle 0.0 (- angle .2)))
	((= i 20)
	 (if (not (mus-arrays-equal? v0 #r(0.000 0.000 0.000 0.000 0.800 0.000 0.000 0.160 0.160 0.000 0.080 0.064 0.016 0.035 0.013 0.018 0.007 0.007 0.003 0.002)))
	     (snd-display "3comb (5 .5): ~A" v0)))
      (set! (v0 i) (comb gen in1 angle)))
    
    (do ((gen (make-all-pass 0.5 0.0 5 :max-size 20))
	 (v0 (make-float-vector 20))
	 (in1 1.0 0.0)
	 (i 0 (+ i 1))
	 (angle 0.0 (- angle .2)))
	((= i 20)
	 (if (not (mus-arrays-equal? v0 #r(0.000 0.000 0.000 0.000 0.800 0.000 0.000 0.160 0.160 0.000 0.080 0.064 0.016 0.035 0.013 0.018 0.007 0.007 0.003 0.002)))
	     (snd-display "3all-pass (5 0 .5): ~A" v0)))
      (set! (v0 i) (all-pass gen in1 angle)))
    
    (do ((gen (make-notch 0.5 5 :max-size 20))
	 (v0 (make-float-vector 20))
	 (in1 1.0 0.0)
	 (i 0 (+ i 1))
	 (angle 0.0 (- angle .2)))
	((= i 20)
	 (if (not (mus-arrays-equal? v0 #r(0.500 0.000 0.000 0.000 0.800 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000)))
	     (snd-display "3notch (5 .5): ~A" v0)))
      (set! (v0 i) (notch gen in1 angle)))
    
    (do ((gen (make-all-pass 0.0 0.5 5 :max-size 20))
	 (v0 (make-float-vector 20))
	 (in1 1.0 0.0)
	 (i 0 (+ i 1))
	 (angle 0.0 (- angle .2)))
	((= i 20)
	 (if (not (mus-arrays-equal? v0 #r(0.500 0.000 0.000 0.000 0.800 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000)))
	     (snd-display "3all-pass (5 .5 0): ~A" v0)))
      (set! (v0 i) (all-pass gen in1 angle)))
    
    (do ((gen (make-comb 0.5 5 :max-size 20))
	 (v0 (make-float-vector 20))
	 (in1 1.0 0.0)
	 (i 0 (+ i 1))
	 (angle 0.0 (+ angle .01)))
	((= i 20)
	 (if (not (mus-arrays-equal? v0 #r(0.000 0.000 0.000 0.000 0.000 0.950 0.060 0.000 0.000 0.000 0.428 0.079 0.004 0.000 0.000 0.182 0.067 0.008 0.000 0.000)))
	     (snd-display "4comb (5 .5): ~A" v0)))
      (set! (v0 i) (comb gen in1 angle)))
    
    (do ((gen (make-all-pass 0.5 0.0 5 :max-size 20))
	 (v0 (make-float-vector 20))
	 (in1 1.0 0.0)
	 (i 0 (+ i 1))
	 (angle 0.0 (+ angle .01)))
	((= i 20)
	 (if (not (mus-arrays-equal? v0 #r(0.000 0.000 0.000 0.000 0.000 0.950 0.060 0.000 0.000 0.000 0.428 0.079 0.004 0.000 0.000 0.182 0.067 0.008 0.000 0.000)))
	     (snd-display "4all-pass (5 0 .5): ~A" v0)))
      (set! (v0 i) (all-pass gen in1 angle)))
    
    (do ((gen (make-notch 0.5 5 :max-size 20))
	 (v0 (make-float-vector 20))
	 (in1 1.0 0.0)
	 (i 0 (+ i 1))
	 (angle 0.0 (+ angle .01)))
	((= i 20)
	 (if (not (mus-arrays-equal? v0 #r(0.500 0.000 0.000 0.000 0.000 0.950 0.060 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000)))
	     (snd-display "4notch (5 .5): ~A" v0)))
      (set! (v0 i) (notch gen in1 angle)))
    
    (do ((gen (make-all-pass 0.0 0.5 5 :max-size 20))
	 (v0 (make-float-vector 20))
	 (in1 1.0 0.0)
	 (i 0 (+ i 1))
	 (angle 0.0 (+ angle .01)))
	((= i 20)
	 (if (not (mus-arrays-equal? v0 #r(0.500 0.000 0.000 0.000 0.000 0.950 0.060 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000)))
	     (snd-display "4all-pass (5 .5 0): ~A" v0)))
      (set! (v0 i) (all-pass gen in1 angle)))
    
    ;; now run off either end of the delay line "by accident"
    
    (do ((gen (make-comb 0.5 5 :max-size 10))
	 (v0 (make-float-vector 20))
	 (in1 1.0 0.0)
	 (i 0 (+ i 1))
	 (angle 0.0 (+ angle .5)))
	((= i 20)
	 (if (not (mus-arrays-equal? v0 #r(0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.500 1.000 0.250 0.125 0.094 0.062 0.055 0.047 0.039 0.031 0.029)))
	     (snd-display "5comb (5 .5): ~A" v0)))
      (set! (v0 i) (comb gen in1 angle)))
    
    (do ((gen (make-all-pass 0.5 0.0 5 :max-size 10))
	 (v0 (make-float-vector 20))
	 (in1 1.0 0.0)
	 (i 0 (+ i 1))
	 (angle 0.0 (+ angle .5)))
	((= i 20)
	 (if (not (mus-arrays-equal? v0 #r(0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.500 1.000 0.250 0.125 0.094 0.062 0.055 0.047 0.039 0.031 0.029)))
	     (snd-display "5all-pass (5 0 .5): ~A" v0)))
      (set! (v0 i) (all-pass gen in1 angle)))
    
    (do ((gen (make-notch 0.5 5 :max-size 10))
	 (v0 (make-float-vector 20))
	 (in1 1.0 0.0)
	 (i 0 (+ i 1))
	 (angle 0.0 (+ angle .5)))
	((= i 20)
	 (if (not (mus-arrays-equal? v0 #r(0.500 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.500 1.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000)))
	     (snd-display "5notch (5 .5): ~A" v0)))
      (set! (v0 i) (notch gen in1 angle)))
    
    (do ((gen (make-all-pass 0.0 0.5 5 :max-size 10))
	 (v0 (make-float-vector 20))
	 (in1 1.0 0.0)
	 (i 0 (+ i 1))
	 (angle 0.0 (+ angle .5)))
	((= i 20)
	 (if (not (mus-arrays-equal? v0 #r(0.500 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.500 1.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000)))
	     (snd-display "5all-pass (5 .5 0): ~A" v0)))
      (set! (v0 i) (all-pass gen in1 angle)))
    
    (do ((gen (make-comb 0.5 5 :max-size 10))
	 (v0 (make-float-vector 20))
	 (in1 1.0 0.0)
	 (i 0 (+ i 1))
	 (angle 0.0 (- angle .5)))
	((= i 20)
	 (if (not (mus-arrays-equal? v0 #r(0.000 0.000 0.000 0.500 0.000 0.125 0.000 0.031 0.016 0.004 1.000 0.000 0.250 0.031 0.000 0.012 0.002 0.250 0.125 0.008)))
	     (snd-display "6comb (5 .5): ~A" v0)))
      (set! (v0 i) (comb gen in1 angle)))
    
    (do ((gen (make-all-pass 0.5 0.0 5 :max-size 10))
	 (v0 (make-float-vector 20))
	 (in1 1.0 0.0)
	 (i 0 (+ i 1))
	 (angle 0.0 (- angle .5)))
	((= i 20)
	 (if (not (mus-arrays-equal? v0 #r(0.000 0.000 0.000 0.500 0.000 0.125 0.000 0.031 0.016 0.004 1.000 0.000 0.250 0.031 0.000 0.012 0.002 0.250 0.125 0.008)))
	     (snd-display "6all-pass (5 0 .5): ~A" v0)))
      (set! (v0 i) (all-pass gen in1 angle)))
    
    (do ((gen (make-notch 0.5 5 :max-size 10))
	 (v0 (make-float-vector 20))
	 (in1 1.0 0.0)
	 (i 0 (+ i 1))
	 (angle 0.0 (- angle .5)))
	((= i 20)
	 (if (not (mus-arrays-equal? v0 #r(0.500 0.000 0.000 0.500 0.000 0.000 0.000 0.000 0.000 0.000 1.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000)))
	     (snd-display "6notch (5 .5): ~A" v0)))
      (set! (v0 i) (notch gen in1 angle)))
    
    (do ((gen (make-all-pass 0.0 0.5 5 :max-size 10))
	 (v0 (make-float-vector 20))
	 (in1 1.0 0.0)
	 (i 0 (+ i 1))
	 (angle 0.0 (- angle .5)))
	((= i 20)
	 (if (not (mus-arrays-equal? v0 #r(0.500 0.000 0.000 0.500 0.000 0.000 0.000 0.000 0.000 0.000 1.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000)))
	     (snd-display "6all-pass (5 .5 0): ~A" v0)))
      (set! (v0 i) (all-pass gen in1 angle)))
    
    (do ((gen (make-filtered-comb 0.5 5 :filter (make-one-zero .5 .5)))
	 (v0 (make-float-vector 21))
	 (in1 1.0 0.0)
	 (i 0 (+ i 1)))
	((= i 21)
	 (if (not (mus-arrays-equal? v0 #r(0.000 0.000 0.000 0.000 0.000 1.000 0.000 0.000 0.000 0.000 0.250 0.250 
					   0.000 0.000 0.000 0.062 0.125 0.062 0.000 0.000 0.016)))
	     (snd-display "filtered-comb (5 .5): ~A" v0)))
      (set! (v0 i) (filtered-comb gen in1)))
    
    (do ((gen (make-filtered-comb 0.5 5 :filter (make-one-zero .25 .75)))
	 (v0 (make-float-vector 21))
	 (in1 1.0 0.0)
	 (i 0 (+ i 1)))
	((= i 21)
	 (if (not (mus-arrays-equal? v0 #r(0.000 0.000 0.000 0.000 0.000 1.000 0.000 0.000 0.000 0.000 0.125 0.375 
						 0.000 0.000 0.000 0.016 0.094 0.141 0.000 0.000 0.002)))
	     (snd-display "1filtered-comb (5 .5): ~A" v0)))
      (set! (v0 i) (filtered-comb gen in1)))
    
    (do ((gen (make-filtered-comb 0.5 5 :filter (make-one-zero .25 .75)))
	 (v0 (make-float-vector 21))
	 (in1 1.0 0.0)
	 (i 0 (+ i 1)))
	((= i 21)
	 (if (not (mus-arrays-equal? v0 #r(0.000 0.000 0.000 0.000 0.000 1.000 0.000 0.000 0.000 0.000 0.125 0.375 
						 0.000 0.000 0.000 0.016 0.094 0.141 0.000 0.000 0.002)))
	     (snd-display "1run-filtered-comb (5 .5): ~A" v0)))
      (set! (v0 i) (filtered-comb gen in1)))
    
    (do ((gen (make-filtered-comb 0.5 5 :max-size 20 :filter (make-one-zero .5 .5)))
	 (v0 (make-float-vector 20))
	 (in1 1.0 0.0)
	 (i 0 (+ i 1))
	 (angle 0.0 (+ angle .2)))
	((= i 20)
	 (if (not (mus-arrays-equal? v0 #r(0.000 0.000 0.000 0.000 0.000 0.000 0.800 0.400 0.000 0.000 0.000 0.000 0.000 0.080 0.220 0.300 0.140 0.040 0.000 0.000)))
	     (snd-display "2filtered-comb (5 .5): ~A" v0)))
      (set! (v0 i) (filtered-comb gen in1 angle)))
    
    (do ((gen (make-filtered-comb 0.5 5 :max-size 20 :filter (make-one-zero .5 .5)))
	 (v0 (make-float-vector 20))
	 (in1 1.0 0.0)
	 (i 0 (+ i 1))
	 (angle 0.0 (- angle .2)))
	((= i 20)
	 (if (not (mus-arrays-equal? v0 #r(0.000 0.000 0.000 0.000 0.800 0.000 0.000 0.080 0.200 0.040 0.020 0.068 0.042 0.019 0.026 0.015 0.011 0.009 0.006 0.004)))
	     (snd-display "3filtered-comb (5 .5): ~A" v0)))
      (set! (v0 i) (filtered-comb gen in1 angle)))
    
    (do ((gen (make-filtered-comb 0.5 5 :max-size 20 :filter (make-one-zero .5 .5)))
	 (v0 (make-float-vector 20))
	 (in1 1.0 0.0)
	 (i 0 (+ i 1))
	 (angle 0.0 (+ angle .01)))
	((= i 20)
	 (if (not (mus-arrays-equal? v0 #r(0.000 0.000 0.000 0.000 0.000 0.950 0.060 0.000 0.000 0.000 0.214 0.251 0.043 0.002 0.000 0.045 0.106 0.081 0.023 0.003)))
	     (snd-display "4filtered-comb (5 .5): ~A" v0)))
      (set! (v0 i) (filtered-comb gen in1 angle)))
    
    (let ((gen (make-one-pole .4 .7))
	  (v0 (make-float-vector 10)))
      (print-and-check gen 
		       "one-pole"
		       "one-pole a0: 0.400, b1: 0.700, y1: 0.000")
      (do ((i 0 (+ i 1)))
	  ((= i 10))
	(set! (v0 i) (one-pole gen 1.0)))
      (let ((v1 (make-float-vector 10)))
	(let ((gen1 (make-one-pole .4 .7)))
	  (fill-float-vector v1 (if (one-pole? gen) (one-pole gen1 1.0) -1.0)))
	(if (not (mus-arrays-equal? v0 v1)) (snd-display "map one-pole: ~A ~A" v0 v1)))
      (if (not (one-pole? gen)) (snd-display "~A not one-pole?" gen))
      (if (not (= (mus-order gen) 1)) (snd-display "one-pole order: ~D?" (mus-order gen)))
      (if (fneq (mus-xcoeff gen 0) .4) (snd-display "one-pole a0: ~F?" (mus-xcoeff gen 0)))
      (if (fneq (mus-ycoeff gen 1) .7) (snd-display "one-pole b1: ~F?" (mus-ycoeff gen 1)))
      (if (or (fneq (v0 1) 0.120) (fneq (v0 4) 0.275) (fneq (v0 8) 0.245))
	  (snd-display "one-pole output: ~A" v0))
      (if (fneq (mus-ycoeff gen 1) .7) (snd-display "1p ycoeff 1 .7: ~A" gen))
      (set! (mus-ycoeff gen 1) .1)
      (if (fneq (mus-ycoeff gen 1) .1) (snd-display "1p set ycoeff 1 .1: ~A" gen))
      (if (fneq (mus-xcoeff gen 0) .4) (snd-display "1p xcoeff 0 .4: ~A" gen))
      (set! (mus-xcoeff gen 0) .3)
      (if (fneq (mus-xcoeff gen 0) .3) (snd-display "1p set xcoeff 0 .3: ~A" gen)))
    
    
    (let ((gen (make-one-zero .4 .7))
	  (v0 (make-float-vector 10)))
      (print-and-check gen
		       "one-zero"
		       "one-zero a0: 0.400, a1: 0.700, x1: 0.000")
      (do ((i 0 (+ i 1)))
	  ((= i 10))
	(set! (v0 i) (one-zero gen 1.0)))
      (let ((v1 (make-float-vector 10)))
	(let ((gen1 (make-one-zero .4 .7)))
	  (fill-float-vector v1 (if (one-zero? gen) (one-zero gen1 1.0) -1.0)))
	(if (not (mus-arrays-equal? v0 v1)) (snd-display "map one-zero: ~A ~A" v0 v1)))
      (if (not (one-zero? gen)) (snd-display "~A not one-zero?" gen))
      (if (not (= (mus-order gen) 1)) (snd-display "one-zero order: ~D?" (mus-order gen)))
      (if (fneq (mus-xcoeff gen 0) .4) (snd-display "one-zero a0: ~F?" (mus-xcoeff gen 0)))
      (if (fneq (mus-xcoeff gen 1) .7) (snd-display "one-zero a1: ~F?" (mus-xcoeff gen 1)))
      (if (fneq (v0 1) 1.1) (snd-display "one-zero output: ~A" v0))
      (if (fneq (mus-xcoeff gen 0) .4) (snd-display "1z xcoeff 0 .4: ~A" gen))
      (set! (mus-xcoeff gen 0) .1)
      (if (fneq (mus-xcoeff gen 0) .1) (snd-display "1z set xcoeff 0 .1: ~A" gen)))
    
    (let ((gen (make-two-zero .4 .7 .3))
	  (v0 (make-float-vector 10)))
      (print-and-check gen 
		       "two-zero"
		       "two-zero a0: 0.400, a1: 0.700, a2: 0.300, x1: 0.000, x2: 0.000")
      (do ((i 0 (+ i 1)))
	  ((= i 10))
	(set! (v0 i) (two-zero gen 1.0)))
      (let ((v1 (make-float-vector 10)))
	(let ((gen1 (make-two-zero .4 .7 .3)))
	  (fill-float-vector v1 (if (two-zero? gen1) (two-zero gen1 1.0) -1.0)))
	(if (not (mus-arrays-equal? v0 v1)) (snd-display "map two-zero: ~A ~A" v0 v1)))
      (if (not (two-zero? gen)) (snd-display "~A not two-zero?" gen))
      (if (not (= (mus-order gen) 2)) (snd-display "two-zero order: ~D?" (mus-order gen)))
      (if (fneq (mus-xcoeff gen 0) .4) (snd-display "two-zero a0: ~F?" (mus-xcoeff gen 0)))
      (if (fneq (mus-xcoeff gen 1) .7) (snd-display "two-zero a1: ~F?" (mus-xcoeff gen 1)))
      (if (fneq (mus-xcoeff gen 2) .3) (snd-display "two-zero a2: ~F?" (mus-xcoeff gen 2)))
      (if (or (fneq (v0 1) 1.1) (fneq (v0 8) 1.4)) (snd-display "two-zero output: ~A" v0))
      (if (fneq (mus-xcoeff gen 0) .4) (snd-display "2z xcoeff 0 .4: ~A" gen))
      (set! (mus-xcoeff gen 0) .1)
      (if (fneq (mus-xcoeff gen 0) .1) (snd-display "2z set xcoeff 0 .1: ~A" gen))
      (set! (mus-xcoeff gen 0) 1.0)
      (let ((r (mus-scaler gen)))
	(set! (mus-frequency gen) 500.0)
	(if (ffneq (mus-frequency gen) 500.0) (snd-display "set mus-frequency two-zero: ~A" (mus-frequency gen)))
	(if (fneq (mus-scaler gen) r) (snd-display "set mus-frequency two-zero hit r: ~A" (mus-scaler gen))))
      (set! (mus-scaler gen) .99)
      (if (fneq (mus-scaler gen) .99) (snd-display "set mus-scaler two-zero: ~A" (mus-scaler gen)))
      (if (ffneq (mus-frequency gen) 500.0) (snd-display "set mus-scaler hit freq two-zero: ~A" (mus-frequency gen)))
      (let ((g3 (make-two-zero :radius .99 :frequency 500.0)))
	(if (or (fneq (mus-xcoeff gen 0) (mus-xcoeff g3 0))
		(fneq (mus-xcoeff gen 1) (mus-xcoeff g3 1))
		(fneq (mus-xcoeff gen 2) (mus-xcoeff g3 2)))
	    (snd-display "two-zero setters: ~A ~A" gen g3))))
    
    (let* ((gen (make-two-zero .4 .7 .3))
	   (val (gen 1.0)))
      (if (fneq val .4) (snd-display "2zero->0.4: ~A" val))
      (set! val (gen 0.5))
      (if (fneq val .9) (snd-display "2zero->0.9: ~A" val))
      (set! val (gen 1.0))
      (if (fneq val 1.05) (snd-display "2zero->1.05: ~A" val)))
    
    (let ((gen (make-two-pole .4 .7 .3))
	  (v0 (make-float-vector 10)))
      (print-and-check gen 
		       "two-pole"
		       "two-pole a0: 0.400, b1: 0.700, b2: 0.300, y1: 0.000, y2: 0.000")
      (do ((i 0 (+ i 1)))
	  ((= i 10))
	(set! (v0 i) (two-pole gen 1.0)))
      (let ((v1 (make-float-vector 10)))
	(let ((gen1 (make-two-pole .4 .7 .3)))
	  (fill-float-vector v1 (if (two-pole? gen1) (two-pole gen1 1.0) -1.0)))
	(if (not (mus-arrays-equal? v0 v1)) (snd-display "map two-pole: ~A ~A" v0 v1)))
      (if (not (two-pole? gen)) (snd-display "~A not two-pole?" gen))
      (if (not (= (mus-order gen) 2)) (snd-display "two-pole order: ~D?" (mus-order gen)))
      (if (fneq (mus-xcoeff gen 0) .4) (snd-display "two-pole a0: ~F?" (mus-xcoeff gen 0)))
      (if (fneq (mus-ycoeff gen 1) .7) (snd-display "two-pole b1: ~F?" (mus-ycoeff gen 1)))
      (if (fneq (mus-ycoeff gen 2) .3) (snd-display "two-pole b2: ~F?" (mus-ycoeff gen 2)))
      (if (or (fneq (v0 1) 0.12) (fneq (v0 8) 0.201)) (snd-display "two-pole output: ~A" v0))
      (if (fneq (mus-ycoeff gen 1) .7) (snd-display "2p ycoeff 1 .7: ~A" gen))
      (set! (mus-ycoeff gen 1) .1)
      (if (fneq (mus-ycoeff gen 1) .1) (snd-display "2p set ycoeff 1 .1: ~A" gen))
      (if (fneq (mus-xcoeff gen 0) .4) (snd-display "2p xcoeff 0 .4: ~A" gen))
      (set! (mus-xcoeff gen 0) .3)
      (if (fneq (mus-xcoeff gen 0) .3) (snd-display "2p set xcoeff 0 .3: ~A" gen))
      (set! (mus-xcoeff gen 0) 1.0)
      (let ((r (mus-scaler gen)))
	(set! (mus-frequency gen) 500.0)
	(if (ffneq (mus-frequency gen) 500.0) (snd-display "set mus-frequency two-pole: ~A" (mus-frequency gen)))
	(if (fneq (mus-scaler gen) r) (snd-display "set mus-frequency two-pole hit r: ~A" (mus-scaler gen))))
      (set! (mus-scaler gen) .99)
      (if (fneq (mus-scaler gen) .99) (snd-display "set mus-scaler two-pole: ~A" (mus-scaler gen)))
      (if (ffneq (mus-frequency gen) 500.0) (snd-display "set mus-scaler hit freq two-pole: ~A" (mus-frequency gen)))
      (let ((g3 (make-two-pole :radius .99 :frequency 500.0)))
	(if (or (fneq (mus-xcoeff gen 0) (mus-xcoeff g3 0))
		(fneq (mus-ycoeff gen 1) (mus-ycoeff g3 1))
		(fneq (mus-ycoeff gen 2) (mus-ycoeff g3 2)))
	    (snd-display "two-pole setters: ~A ~A" gen g3))))
    
    (let* ((gen (make-two-pole .4 .7 .3))
	   (val (gen 1.0)))
      (if (fneq val .4) (snd-display "a0->out 2pole: ~A" val))
      (set! val (gen 0.5))
      (if (fneq val -.08) (snd-display "a0->out 2pole (-0.08): ~A" val))
      (set! val (gen 1.0))
      (if (fneq val 0.336) (snd-display "a0->out 2pole (0.336): ~A" val)))
    
    (let ((gen (make-oscil 440.0))
	  (v0 (make-float-vector 10))
	  (v1 (make-float-vector 10)))
      (print-and-check gen 
		       "oscil"
		       "oscil freq: 440.000Hz, phase: 0.000")
      (do ((gen1 (make-oscil 440.0))
	   (i 0 (+ i 1)))
	  ((= i 10))
	(set! (v0 i) (oscil gen 0.0))
	(set! (v1 i) (mus-apply gen1 0.0 0.0)))
      (let ((v2 (make-float-vector 10)))
	(let ((gen2 (make-oscil 440.0)))
	  (fill-float-vector v2 (if (oscil? gen2) (oscil gen2 0.0) -1.0)))
	(if (not (mus-arrays-equal? v0 v2)) (snd-display "map oscil: ~A ~A" v0 v2)))
      (if (not (oscil? gen)) (snd-display "~A not oscil?" gen))
      (if (fneq (mus-phase gen) 1.253787) (snd-display "oscil phase: ~F?" (mus-phase gen)))
      (if (fneq (mus-frequency gen) 440.0) (snd-display "oscil frequency: ~F?" (mus-frequency gen)))
      (if (not (= (mus-length gen) 1)) (snd-display "oscil cosines: ~D?" (mus-length gen)))
      (if (or (fneq (v0 1) 0.125) (fneq (v0 8) 0.843)) (snd-display "oscil output: ~A" v0))
      (set! (mus-phase gen) 0.0)
      (if (fneq (mus-phase gen) 0.0) (snd-display "oscil set-phase: ~F?" (mus-phase gen)))
      (set! (mus-frequency gen) 100.0)
      (if (fneq (mus-frequency gen) 100.0) (snd-display "oscil set-frequency: ~F?" (mus-frequency gen)))
      (do ((i 0 (+ i 1)))
	  ((= i 10))
	(if (fneq (v0 i) (v1 i))
	    (snd-display "mus-apply oscil at ~D: ~A ~A?" i (v0 i) (v1 i))))
      (if (fneq (mus-apply) 0.0)
	  (snd-display "(mus-apply): ~A" (mus-apply))))

    ;; we can't (or don't anyway) guarantee optimized arg order evaluation so:
    (let ((o (make-oscil 1000.0)) 
	  (o1 (make-oscil 1000.0))
	  (v (make-float-vector 10))
	  (x 0.0))
      (do ((i 0 (+ i 1))) 
	  ((= i 10))
	(set! x (oscil o (oscil o1) (oscil o1)))
	(set! (v i) x))
      (let ((o4 (make-oscil 1000.0)) 
	    (o5 (make-oscil 1000.0))
	    (v2 (make-float-vector 10))
	    (x1 0.0)
	    (x2 0.0))
	(do ((i 0 (+ i 1))) 
	    ((= i 10))
	  (set! x1 (oscil o5))
	  (set! x2 (oscil o5))
	  (set! (v2 i) (oscil o4 x2 x1)))
	(let ()
	  (define (hi) 
	    (do ((o2 (make-oscil 1000.0)) 
		 (o3 (make-oscil 1000.0)) 
		 (v1 (make-float-vector 10))
		 (i 0 (+ i 1)))
		((= i 10) v1)
	      (float-vector-set! v1 i (oscil o2 (oscil o3) (oscil o3)))))
	  (hi)
	  (let ((v1 (hi)))
	    (if (not (or (mus-arrays-equal? v v1)
			 (mus-arrays-equal? v2 v1)))
		(format *stderr* ":orig: ~A~%;  v1: ~A~%;  v2: ~A~%" v v1 v2))))))
    (test-fm-components)

    ;; osc-opt
    (let ((g1 (make-oscil 1000))
	  (g2 (make-oscil 1000))
	  (g3 (make-oscil 1000))
	  (g4 (make-oscil 1000))
	  (g5 (make-oscil 1000))
	  (g6 (make-oscil 1000))
	  (x1 1.0)
	  (x2 (hz->radians 100.0))
	  (x4 (hz->radians 5.0)))
      (do ((x1x2 (* x1 x2))
	   (x420 (* 20 x4))
	   (i 0 (+ i 1)))
	  ((= i 50))
	(let ((o1 (oscil g1 x2))
	      (o2 (* 1.0 (oscil g2 x2)))
	      (o3 (oscil g3 x420))
	      (o4 (oscil g4 x420))
	      (o5 (oscil g5 x1x2))
	      (o6 (* 1.0 (oscil g6 x420))))
	  (if (> (abs (- (+ o2 o3 o4 o5 o6) (* 5 o1))) 1e-6)
	      (snd-display "~A: ~1,4F ~1,4F ~1,4F ~1,4F ~1,4F ~1,4F" i o1 o2 o3 o4 o5 o6)))))

    ;; nrxysin-opt)
    (let ((g1 (make-nrxysin 1000 :n 10 :r .9))
	  (g2 (make-nrxysin 1000 :n 10 :r .9))
	  (g3 (make-nrxysin 1000 :n 10 :r .9))
	  (g4 (make-nrxysin 1000 :n 10 :r .9))
	  (g5 (make-nrxysin 1000 :n 10 :r .9))
	  (g6 (make-nrxysin 1000 :n 10 :r .9))
	  (x1 1.0)
	  (x2 (hz->radians 100.0))
	  (x4 (hz->radians 5.0)))
      (do ((x1x2 (* x1 x2))
	   (x420 (* 20 x4))
	   (i 0 (+ i 1)))
	  ((= i 50))
	(let ((o1 (nrxysin g1 x2))
	      (o2 (* 1.0 (nrxysin g2 x2)))
	      (o3 (nrxysin g3 x420))
	      (o4 (nrxysin g4 x420))
	      (o5 (nrxysin g5 x1x2))
	      (o6 (nrxysin g6 x420)))
	  (if (> (abs (- (+ o2 o3 o4 o5 o6) (* 5 o1))) 1e-6)
	      (format () "~A: ~1,4F ~1,4F ~1,4F ~1,4F ~1,4F ~1,4F~%" i o1 o2 o3 o4 o5 o6)))))
  
    ;; polywave-opt
    (let ((g1 (make-polywave 1000 '(1 .5 2 .5)))
	  (g2 (make-polywave 1000 '(1 .5 2 .5)))
	  (g3 (make-polywave 1000 '(1 .5 2 .5)))
	  (g4 (make-polywave 1000 '(1 .5 2 .5)))
	  (g5 (make-polywave 1000 '(1 .5 2 .5)))
	  (g6 (make-polywave 1000 '(1 .5 2 .5)))
	  (x1 1.0)
	  (x2 (hz->radians 100.0))
	  (x4 (hz->radians 5.0)))
      (do ((x1x2 (* x1 x2))
	   (x420 (* 20 x4))
	   (i 0 (+ i 1)))
	  ((= i 50))
	(let ((o1 (polywave g1 x2))
	      (o2 (* 1.0 (polywave g2 x2)))
	      (o3 (polywave g3 x420))
	      (o4 (polywave g4 x420))
	      (o5 (polywave g5 x1x2))
	      (o6 (* 1.0 (polywave g6 x420))))
	  (if (> (abs (- (+ o2 o3 o4 o5 o6) (* 5 o1))) 1e-6)
	      (format () "~A: ~1,4F ~1,4F ~1,4F ~1,4F ~1,4F ~1,4F~%" i o1 o2 o3 o4 o5 o6)))))

    (let ((test-simple-polywave 
	   (lambda (n offset kind)
	     (let ((p (do ((h (if offset (list offset 0) ()))
			   (i 1 (+ i 1)))
			  ((> i n)
			   (make-polywave 400.0 (reverse h) kind))  
			(set! h (cons (* i .1) (cons i h)))))
		   (vp (make-float-vector 200))
		   (vo (make-float-vector 200))
		   (ob (make-oscil-bank
			(apply float-vector (do ((frqs (if offset (list 0.0) ()))
						 (i 1 (+ i 1)))
						((> i n)
						 (reverse frqs))
					      (set! frqs (cons (hz->radians (* i 400.0)) frqs))))
			(let ((phases (make-float-vector (if offset (+ n 1) n)
							 (if (= kind mus-chebyshev-second-kind) 0.0 (/ pi 2)))))
			  (if (and offset (= kind mus-chebyshev-second-kind))
			      (set! (phases 0) (/ pi 2)))
			  phases)
			(apply float-vector (do ((amps (if offset (list offset) ()))
						 (i 1 (+ i 1)))
						((> i n)
						 (reverse amps))  
					      (set! amps (cons (* i .1) amps))))
			#t)))
	       (do ((i 0 (+ i 1)))
		   ((= i 200))
		 (float-vector-set! vp i (polywave p)))
	       (do ((i 0 (+ i 1)))
		   ((= i 200))
		 (float-vector-set! vo i (oscil-bank ob)))
	       (if (not (mus-arrays-equal? vp vo))
		   (format *stderr* ";simple polywave ~A ~A ~A: ~A~%    ~A~%    ~A~%~A ~A~%" 
			   n offset (if (= kind mus-chebyshev-first-kind) 'first 'second)
			   (float-vector-peak (float-vector-subtract! (copy vp) vo))
			   vp vo
			   p ob))
	       
	       (let ((temp 0.0))
		 (do ((i 0 (+ i 1)))
		     ((= i 200))
		   (set! temp (polywave p))
		   (vector-set! vp i temp)
		   (set! (vo i) (oscil-bank ob)))
		 (if (not (mus-arrays-equal? vp vo))
		     (format *stderr* ";simple polywave (temps) ~A ~A ~A: ~A~%    ~A~%    ~A~%~A ~A~%" 
			     n offset (if (= kind mus-chebyshev-first-kind) 'first 'second)
			     (float-vector-peak (float-vector-subtract! (copy vp) vo))
			     vp vo
			     p ob)))
	       
	       (let ((t1 (find-sound (with-sound ("test.snd")
				       (do ((i 0 (+ i 1)))
					   ((= i 200))
					 (outa i (polywave p))))))
		     (t2 (find-sound (with-sound ("tst.snd")
				       (do ((i 0 (+ i 1)))
					   ((= i 200))
					 (outa i (oscil-bank ob)))))))
		 (set! vp (channel->float-vector 0 200 t1 0))
		 (set! vo (channel->float-vector 0 200 t2 0))
		 
		 (if (not (mus-arrays-equal? vp vo))
		     (format *stderr* ";simple polywave (with-sound) n: ~A, offset: ~A, type: ~A (len: ~D ~D): dist: ~A~%    ~A~%    ~A~%~A ~A~%" 
			     n offset (if (= kind mus-chebyshev-first-kind) 'first 'second)
			     (length vp) (length vo)
			     (float-vector-peak (float-vector-subtract! (copy vp) vo))
			     vp vo
			     p ob))
		 (close-sound t1)
		 (close-sound t2))))))
      
      (do ((i 1 (+ i 1)))
	  ((= i 6))
	(test-simple-polywave i #f mus-chebyshev-first-kind)
	(test-simple-polywave i .1 mus-chebyshev-first-kind)
	(test-simple-polywave i #f mus-chebyshev-second-kind)
	(test-simple-polywave i .1 mus-chebyshev-second-kind)))

    (do ((gen1 (make-oscil 100.0))
	 (gen2 (make-oscil -100.0))
	 (mx 0.0)
	 (i 0 (+ i 1)))
	((= i 100)
	 (if (fneq mx 0.0)
	     (snd-display "oscil +-: ~A" mx)))
      (set! mx (max mx (abs (+ (gen1) (gen2))))))
    
    (do ((gen1 (make-oscil 100.0 (* pi 0.5)))
	 (gen2 (make-oscil -100.0 (* pi 0.5)))
	 (mx 0.0)
	 (i 0 (+ i 1)))
	((= i 100)
	 (if (fneq mx 0.0)
	     (snd-display "cosil +-: ~A" mx)))
      (set! mx (max mx (abs (- (gen1) (gen2))))))
    
    (let ((frqs #r(0.0 0.0))
	  (amps #r(0.0 0.0))
	  (phs #r(0.0 0.0)))
      (let ((ob (make-oscil-bank frqs phs amps)))
	(if (not (oscil-bank? ob)) (snd-display "oscil-bank? ~A" ob))
	(if (not (morally-equal? (mus-data ob) phs)) (snd-display "oscil-bank data: ~A ~A" (mus-data ob) phs))
	(let ((x (oscil-bank ob)))
	  (if (not (= x 0.0)) (snd-display "oscil-bank 0.0: ~A~%" x)))
	(set! (amps 0) 0.5)
	(set! (amps 1) 0.2)
	(let ((x (oscil-bank ob)))
	  (if (not (= x 0.0)) (snd-display "oscil-bank 0.0 (amps): ~A~%" x)))
	(set! (frqs 0) .1)
	(set! (frqs 1) .2)
	(oscil-bank ob)
	(let ((x (oscil-bank ob)))
	  (if (not (morally-equal? x 0.08965057448242633)) (snd-display "oscil-bank 0.09: ~A~%" x)))))
    
    (for-each fm-test (vector (make-oscil) (make-nrxysin) (make-nrxycos) (make-square-wave) (make-triangle-wave) (make-ncos)
			      (make-nsin) (make-sawtooth-wave) (make-rand) (make-rand-interp) (make-pulse-train)))
    
    (do ((gen (make-oscil 440.0))
	 (gen1 (make-oscil 440.0))
	 (i 0 (+ i 1)))
	((= i 10))
      (let ((oval (oscil gen .1))
	    (mval (mus-run gen1 .1)))
	(if (fneq oval mval)
	    (snd-display "mus-run ~A but oscil ~A?" mval oval))))
    
    (let ((gen (make-oscil 440.0))
	  (gen1 (make-oscil 440.0))
	  (gen2 (make-oscil 440.0))
	  (gen3 (make-oscil 440.0))
	  (fm-index (hz->radians 440.0))
	  (v0 (make-float-vector 10))
	  (v1 (make-float-vector 10)))
      (do ((i 0 (+ i 1)))
	  ((= i 10))
	(set! (v0 i) (oscil gen (* fm-index (oscil gen1 0.0))))
	(set! (v1 i) (mus-apply gen2 (* fm-index (mus-apply gen3 0.0 0.0)) 0.0)))
      (if (or (fneq (v0 1) 0.125) (fneq (v0 6) 0.830) (fneq (v0 8) 0.987))
	  (snd-display "oscil fm output: ~A" v0))
      (do ((i 0 (+ i 1)))
	  ((= i 10))
	(if (fneq (v0 i) (v1 i))
	    (snd-display "mus-apply fm oscil at ~D: ~A ~A?" i (v0 i) (v1 i)))))
    
    (test-gen-equal (make-oscil 440.0) (make-oscil 440.0) (make-oscil 100.0))
    (test-gen-equal (make-oscil 440.0) (make-oscil 440.0) (make-oscil 440.0 1.0))
    
    (do ((gen (make-oscil 440.0))
	 (gen1 (make-oscil 440.0))
	 (pm-index 2.0)
	 (v0 (make-float-vector 10))
	 (i 0 (+ i 1)))
	((= i 10)
	 (if (or (fneq (v0 1) 0.367) (fneq (v0 6) 0.854) (fneq (v0 8) 0.437))
	     (snd-display "oscil pm output: ~A" v0)))
      (set! (v0 i) (gen 0.0 (* pm-index (gen1 0.0)))))
    
    (do ((gen (make-oscil 440.0))
	 (i 0 (+ i 1)))
	((= i 1100))
      (let ((val1 (sin (mus-phase gen)))
	    (val2 (gen 0.0)))
	(if (fneq val1 val2)
	    (snd-display "oscil: ~A: ~A ~A" i val1 val2))))
    
    (do ((gen (make-oscil 440.0 :initial-phase (* pi 0.5)))
	 (incr (/ (* 2 pi 440.0) 22050.0))
	 (i 0 (+ i 1))
	 (a 0.0))
	((= i 900))
      (let ((val1 (cos a))
	    (val2 (gen 0.0)))
	(if (fneq val1 val2)
	    (snd-display "oscil (cos): ~A: ~A ~A" i val1 val2)))
      (set! a (+ a incr)))
    
    (do ((gen (make-oscil 0.0))
	 (gen1 (make-oscil 40.0))
	 (incr (/ (* 2 pi 40.0) 22050.0))
	 (i 0 (+ i 1))
	 (a 0.0))
	((= i 1100))
      (let ((val1 (sin (sin a)))
	    (val2 (oscil gen 0.0 (oscil gen1 0.0))))
	(if (fneq val1 val2)
	    (snd-display "oscil pm: ~A: ~A ~A" i val1 val2)))
      (set! a (+ a incr)))
    
    (do ((gen (make-oscil 0.0))
	 (gen1 (make-oscil 40.0))
	 (incr (/ (* 2 pi 40.0) 22050.0))
	 (a1 0.0)
	 (i 0 (+ i 1))
	 (a 0.0))
	((= i 100))
      (let ((fm (sin a))
	    (val1 (sin a1))
	    (val2 (oscil gen (oscil gen1 0.0))))
	(set! a1 (+ a1 fm))
	(if (fneq val1 val2)
	    (snd-display "oscil fm: ~A: ~A ~A" i val1 val2))
	(set! a (+ a incr))))
    
    (let ()
      (define (oscil-1-1)
	(let ((osc (make-oscil 440.0))
	      (v1 (make-vector 10 0.0))
	      (v2 (make-vector 10 0.0)))
	  (set! (v1 0) (oscil osc))
	  (set! (v1 1) (oscil osc))
	  (do ((osc (make-oscil 440.0))
	       (i 0 (+ i 1)))
	      ((= i 10))
	    (set! (v2 i) (oscil osc)))
	  (do ((i 2 (+ i 1)))
	      ((= i 10))
	    (set! (v1 i) (oscil osc)))
	  (if (not (equal? v1 v2))
	      (snd-display "oscil-1 shadowing test1: ~A ~A" v1 v2))))
      
      (define oscil-1-2
	(let ((ho-1 (lambda (osc v i)
		      (set! (v i) (oscil osc)))))
	  (lambda ()
	    (let ((o1 (make-oscil 440.0))
		  (o2 (make-oscil 440.0))
		  (v1 (make-vector 10 0.0))
		  (v2 (make-vector 10 0.0)))
	      (ho-1 o1 v1 0)
	      (ho-1 o1 v1 1)
	      (do ((i 0 (+ i 1)))
		  ((= i 10))
		(set! (v2 i) (oscil o2)))
	      (do ((i 2 (+ i 1)))
		  ((= i 10))
		(set! (v1 i) (oscil o1)))
	      (if (not (equal? v1 v2))
		  (snd-display "oscil-1 shadowing test2: ~A ~A" v1 v2))))))
	  
      (define oscil-1-3
	(let ((ho (lambda ()
		    (let ((osc (make-oscil 440.0)))
		      (lambda ()
			(oscil osc))))))
	  (lambda ()
	    (let ((o1 (ho))
		  (v1 (make-vector 10 0.0))
		  (v2 (make-vector 10 0.0)))
	      (set! (v1 0) (o1))
	      (set! (v1 1) (o1))
	      (do ((o2 (ho))
		   (i 0 (+ i 1)))
		  ((= i 10))
		(set! (v2 i) (o2)))
	      (do ((i 2 (+ i 1)))
		  ((= i 10))
		(set! (v1 i) (o1)))
	      (if (not (equal? v1 v2))
		  (snd-display "oscil-1 shadowing test3: ~A ~A" v1 v2))))))
      
      (oscil-1-1)
      (oscil-1-2)
      (oscil-1-3))
    
    
    (let ((var (catch #t (lambda () (mus-location (make-oscil))) (lambda args args))))
      (if (not (eq? (car var) 'mus-error))
	  (snd-display "mus-location bad gen: ~A" var)))
    (let ((var (catch #t (lambda () (set! (mus-location (make-oscil)) 0)) (lambda args args))))
      (if (not (eq? (car var) 'mus-error))
	  (snd-display "set mus-location bad gen: ~A" var)))
    (let ((var (catch #t (lambda () (set! (mus-scaler (make-oscil)) 0)) (lambda args args))))
      (if (not (eq? (car var) 'mus-error))
	  (snd-display "set mus-scaler bad gen: ~A" var)))
    (let ((var (catch #t (lambda () (mus-frequency (make-one-pole))) (lambda args args))))
      (if (not (eq? (car var) 'mus-error))
	  (snd-display "mus-frequency bad gen: ~A" var)))
    (let ((var (catch #t (lambda () (set! (mus-frequency (make-one-pole)) 0)) (lambda args args))))
      (if (not (eq? (car var) 'mus-error))
	  (snd-display "set mus-frequency bad gen: ~A" var)))
    (let ((var (catch #t (lambda () (make-delay 41943040)) ;(* 1024 1024 40)
		      (lambda args args))))
      (if (not (eq? (car var) 'out-of-range))
	  (snd-display "make-delay huge line: ~A" var)))
    (let ((var (catch #t (lambda () (make-delay 32 :max-size 41943040)) ;(* 1024 1024 40))
		      (lambda args args))))
      (if (not (eq? (car var) 'out-of-range))
	  (snd-display "make-delay huge line: ~A" var)))
    
    (let ((size 1000)
	  
	  (test-pm (lambda (beg end freq amp mc-ratio index)
		     (do ((pm (make-oscil (* freq mc-ratio)))
			  (carrier (make-oscil freq))
			  (i beg (+ i 1)))
			 ((= i end))
		       (outa i (* amp (oscil carrier 0.0 (* index (oscil pm))))))))
	  
	  (test-fm (lambda (beg end freq amp mc-ratio index)
		     (do ((fm (make-oscil (* freq mc-ratio) :initial-phase (/ pi 2.0)))
			  (carrier (make-oscil freq))
			  (fm-index (* (hz->radians freq) mc-ratio index))
			  (i beg (+ i 1)))
			 ((= i end))
		       (outa i (* amp (oscil carrier (* fm-index (oscil fm)))))))))
      
      ;; there's an initial-phase confusion here, so by making the srate high and freq low, we minimize uninteresting off-by-1 troubles
      
      (let ((v1 (with-sound ((make-float-vector size) :srate 441000) (test-pm 0 size 20 1 1 1)))
	    (v2 (with-sound ((make-float-vector size) :srate 441000) (test-fm 0 size 20 1 1 1))))
	(if (not (mus-arrays-equal? v1 v2))
	    (snd-display "fm/pm peak diff (1 1): ~A" (float-vector-peak (float-vector-subtract! v1 v2)))))
      
      (do ((i 0 (+ i 1)))
	  ((= i 10))
	(let ((ratio (+ 1 (random 4)))
	      (index (random 2.0)))
	  (let ((v1 (with-sound ((make-float-vector size) :srate 441000) (test-pm 0 size 20 1 ratio index)))
		(v2 (with-sound ((make-float-vector size) :srate 441000) (test-fm 0 size 20 1 ratio index))))
	    (if (not (mus-arrays-equal? v1 v2))
		(snd-display "fm/pm peak diff ~A ~A: ~A" ratio index (float-vector-peak (float-vector-subtract! v1 v2))))))))
    
    (let ((gen (make-ncos 440.0 10))
	  (v0 (make-float-vector 10)))
      (print-and-check gen 
		       "ncos"
		       "ncos freq: 440.000Hz, phase: 0.000, n: 10")
      (do ((i 0 (+ i 1)))
	  ((= i 10))
	(set! (v0 i) (ncos gen 0.0)))
      (let ((v1 (make-float-vector 10)))
	(let ((gen1 (make-ncos 440.0 10)))
	  (fill-float-vector v1 (if (ncos? gen1) (ncos gen1 0.0) -1.0)))
	(if (not (mus-arrays-equal? v0 v1)) (snd-display "map ncos: ~A ~A" v0 v1)))
      (if (not (ncos? gen)) (snd-display "~A not ncos?" gen))
      (if (fneq (mus-phase gen) 1.253787) (snd-display "ncos phase: ~F?" (mus-phase gen)))
      (if (fneq (mus-frequency gen) 440.0) (snd-display "ncos frequency: ~F?" (mus-frequency gen)))
      (if (fneq (mus-scaler gen) .1) (snd-display "ncos scaler: ~F?" (mus-scaler gen)))
      (unless (= (mus-length gen) 10)
	(snd-display "ncos n: ~D?" (mus-length gen)))
      (if (or (fneq (v0 1) 0.722) (fneq (v0 8) -0.143)) (snd-display "ncos output: ~A" v0))
      (set! (mus-scaler gen) .5) (if (fneq (mus-scaler gen) 0.5) (snd-display "ncos set-scaler: ~F?" (mus-scaler gen)))
      (set! (mus-length gen) 5) (if (not (= (mus-length gen) 5)) (snd-display "set ncos n: ~D?" (mus-length gen)))
      (if (fneq (mus-scaler gen) .2) (snd-display "set n->scaler: ~A" (mus-scaler gen))))
    
    (test-gen-equal (make-ncos 440.0 3) (make-ncos 440.0 3) (make-ncos 440.0 5))
    (test-gen-equal (make-ncos 440.0 3) (make-ncos 440.0 3) (make-ncos 400.0 3))
    
    (do ((gen (make-ncos 440 10))
	 (i 0 (+ i 1)))
	((= i 1100))
      (let ((val1 (let ((den (sin (* (mus-phase gen) 0.5))))
		    (if (= 0.0 den)
			1.0
			(min 1.0 (* (mus-scaler gen)
				    (- (/ (sin (* (mus-phase gen)
						  (+ (mus-length gen) 0.5)))
					  (* 2.0 den))
				       0.5))))))
	    (val2 (gen 0.0)))
	(if (> (abs (- val1 val2)) .002)
	    (snd-display "ncos: ~A: ~A ~A" i val1 val2))))
    
    (do ((gen1 (make-ncos 100.0 10))
	 (gen2 (make-ncos -100.0 10))
	 (mx 0.0)
	 (i 0 (+ i 1)))
	((= i 100)
	 (if (fneq mx 0.0)
	     (snd-display "ncos +-: ~A" mx)))
      (set! mx (max mx (abs (- (gen1) (gen2))))))

    (for-each (lambda (n)
		(let ((p (make-ncos 400.0 n))
		      (vp (make-float-vector 200))
		      (vo (make-float-vector 200)))
		  (let ((ob (make-oscil-bank 
			     (apply float-vector (do ((frqs ())
						      (i 1 (+ i 1)))
						     ((> i n)
						      (reverse frqs))  
						   (set! frqs (cons (hz->radians (* i 400.0)) frqs))))
			     (make-float-vector n (/ pi 2.0))
			     (make-float-vector n (mus-scaler p))
			     #t)))
		    (do ((i 0 (+ i 1)))
			((= i 200))
		      (float-vector-set! vp i (ncos p)))
		    (do ((i 0 (+ i 1)))
			((= i 200))
		      (float-vector-set! vo i (oscil-bank ob)))
		    (if (not (mus-arrays-equal? vp vo))
			(format *stderr* ";simple ncos ~A: ~A~%    ~A~%    ~A~%~A ~A~%" 
				n 
				(float-vector-peak (float-vector-subtract! (copy vp) vo))
				vp vo
				p ob)))))
	      '(1 3 10))
    
    (let ((gen (make-nsin 440.0 10))
	  (v0 (make-float-vector 10)))
      (print-and-check gen 
		       "nsin"
		       "nsin freq: 440.000Hz, phase: 0.000, n: 10")
      (do ((i 0 (+ i 1)))
	  ((= i 10))
	(set! (v0 i) (nsin gen 0.0)))
      (let ((v1 (make-float-vector 10)))
	(let ((gen1 (make-nsin 440.0 10))) 
	  (fill-float-vector v1 (if (nsin? gen1) (nsin gen1 0.0) -1.0)))
	(if (not (mus-arrays-equal? v0 v1)) (snd-display "map nsin: ~A ~A" v0 v1)))
      (if (not (nsin? gen)) (snd-display "~A not nsin?" gen))
      (if (fneq (mus-phase gen) 1.253787) (snd-display "nsin phase: ~F?" (mus-phase gen)))
      (if (fneq (mus-frequency gen) 440.0) (snd-display "nsin frequency: ~F?" (mus-frequency gen)))
      (if (fneq (mus-scaler gen) .1315) (snd-display "nsin scaler: ~F?" (mus-scaler gen)))
      (unless (= (mus-length gen) 10)
	(snd-display "nsin n: ~D?" (mus-length gen)))
      (if (or (fneq (v0 1) 0.784) (fneq (v0 8) 0.181)) (snd-display "nsin output: ~A" v0))
      (set! (mus-scaler gen) .5) (if (fneq (mus-scaler gen) 0.5) (snd-display "nsin set-scaler: ~F?" (mus-scaler gen)))
      (set! (mus-length gen) 5) (if (not (= (mus-length gen) 5)) (snd-display "set nsin n: ~D?" (mus-length gen)))
      (if (fneq (mus-scaler gen) .2525) (snd-display "set sines->scaler: ~A" (mus-scaler gen))))
    
    (test-gen-equal (make-nsin 440.0 3) (make-nsin 440.0 3) (make-nsin 440.0 5))
    (test-gen-equal (make-nsin 440.0 3) (make-nsin 440.0 3) (make-nsin 400.0 3))
    
    (do ((gen1 (make-nsin 100.0 10))
	 (gen2 (make-nsin -100.0 10))
	 (mx 0.0)
	 (i 0 (+ i 1)))
	((= i 100)
	 (if (fneq mx 0.0)
	     (snd-display "nsin +-: ~A" mx)))
      (set! mx (max mx (abs (+ (gen1) (gen2))))))

    (for-each (lambda (n)
		(let ((p (make-nsin 400.0 n))
		      (vp (make-float-vector 200))
		      (vo (make-float-vector 200))
		      (parts (apply float-vector
				    (do ((frqs ())
					 (i 1 (+ i 1)))
					((> i n)
					 (reverse frqs))   
				      (set! frqs (cons (hz->radians (* i 400.0)) frqs))))))
		  (let ((ob (make-oscil-bank parts (make-float-vector n) (make-float-vector n (mus-scaler p)) #t)))
		    (do ((i 0 (+ i 1)))
			((= i 200))
		      (float-vector-set! vp i (nsin p)))
		    (do ((i 0 (+ i 1)))
			((= i 200))
		      (float-vector-set! vo i (oscil-bank ob)))
		    (if (not (mus-arrays-equal? vp vo))
			(format *stderr* ";simple nsin ~A: ~A~%    ~A~%    ~A~%~A ~A~%" 
				n 
				(float-vector-peak (float-vector-subtract! (copy vp) vo))
				vp vo
				p ob)))))
	      '(1 3 10))
    
    (let ((gen (make-nrxysin 440.0)))
      (print-and-check gen 
		       "nrxysin"
                       "nrxysin frequency: 440.000, ratio: 1.000, phase: 0.000, n: 1, r: 0.500")
      (let ((v0 (make-float-vector 10)))
	(do ((i 0 (+ i 1)))
	    ((= i 10))
	  (set! (v0 i) (nrxysin gen 0.0)))
	(let ((v1 (make-float-vector 10)))
	  (let ((gen1 (make-nrxysin 440.0)))
	    (fill-float-vector v1 (if (nrxysin? gen1) (nrxysin gen1 0.0) -1.0)))
	  (if (not (mus-arrays-equal? v0 v1)) (snd-display "map nrxysin: ~A ~A" v0 v1))))
      (if (not (nrxysin? gen)) (snd-display "~A not nrxysin?" gen))
      (if (fneq (mus-phase gen) 1.253787) (snd-display "nrxysin phase: ~F?" (mus-phase gen)))
      (if (fneq (mus-frequency gen) 440.0) (snd-display "nrxysin frequency: ~F?" (mus-frequency gen)))
      (if (fneq (mus-scaler gen) 0.5) (snd-display "mus-scaler (a) nrxysin: ~A" (mus-scaler gen)))
      (set! (mus-scaler gen) 0.75)
      (if (fneq (mus-scaler gen) 0.75) (snd-display "mus-scaler (set a) nrxysin: ~A" (mus-scaler gen)))
      (if (not (= (mus-length gen) 1)) (snd-display "mus-length nrxysin: ~A" (mus-length gen)))
      (if (fneq (mus-offset gen) 1.0) (snd-display "mus-offset nrxysin: ~A" (mus-offset gen))))
    
    (test-gen-equal (make-nrxysin 440.0) (make-nrxysin 440.0) (make-nrxysin 100.0))
    (test-gen-equal (make-nrxysin 440.0) (make-nrxysin 440.0) (make-nrxysin 440.0 1.5))
    (test-gen-equal (make-nrxysin 440.0) (make-nrxysin 440.0) (make-nrxysin 440.0 :n 3))
    
    (let ((v1 (make-float-vector 10)))
      (with-sound (v1 :srate 44100)
	(do ((gen (make-nrxysin 1000 :n 10 :r .99))
	     (i 0 (+ i 1)))
	    ((= i 10))
	  (outa i (nrxysin gen))))
      (if (not (mus-arrays-equal? v1 #r(0.000 0.671 0.637 0.186 0.017 0.169 0.202 0.048 0.007 0.105)))
	  (snd-display "ws nrxysin output: ~A" v1)))
    
    
    (let ((gen (make-nrxycos 440.0)))
      (print-and-check gen 
		       "nrxycos"
                       "nrxycos frequency: 440.000, ratio: 1.000, phase: 0.000, n: 1, r: 0.500")
      (let ((v0 (make-float-vector 10)))
	(do ((i 0 (+ i 1)))
	    ((= i 10))
	  (set! (v0 i) (nrxycos gen 0.0)))
	(let ((v1 (make-float-vector 10)))
	  (let ((gen1 (make-nrxycos 440.0))) 
	    (fill-float-vector v1 (if (nrxycos? gen1) (nrxycos gen1 0.0) -1.0)))
	  (if (not (mus-arrays-equal? v0 v1)) (snd-display "map nrxycos: ~A ~A" v0 v1))))
      (if (not (nrxycos? gen)) (snd-display "~A not nrxycos?" gen))
      (if (fneq (mus-phase gen) 1.253787) (snd-display "nrxycos phase: ~F?" (mus-phase gen)))
      (if (fneq (mus-frequency gen) 440.0) (snd-display "nrxycos frequency: ~F?" (mus-frequency gen)))
      (if (fneq (mus-scaler gen) 0.5) (snd-display "mus-scaler (a) nrxycos: ~A" (mus-scaler gen)))
      (set! (mus-scaler gen) 0.75)
      (if (fneq (mus-scaler gen) 0.75) (snd-display "mus-scaler (set a) nrxycos: ~A" (mus-scaler gen)))
      (if (not (= (mus-length gen) 1)) (snd-display "mus-length nrxycos: ~A" (mus-length gen)))
      (if (fneq (mus-offset gen) 1.0) (snd-display "mus-offset nrxycos: ~A" (mus-offset gen))))
    
    (test-gen-equal (make-nrxycos 440.0) (make-nrxycos 440.0) (make-nrxycos 100.0))
    (test-gen-equal (make-nrxycos 440.0) (make-nrxycos 440.0) (make-nrxycos 440.0 1.5))
    (test-gen-equal (make-nrxycos 440.0) (make-nrxycos 440.0) (make-nrxycos 440.0 :n 3))
    
    (let ((v1 (with-sound ((make-float-vector 10) :srate 44100)
			  (do ((gen (make-nrxycos 1000 :n 10 :r .99))
			       (i 0 (+ i 1)))
			      ((= i 10))
			    (outa i (nrxycos gen))))))
      (if (not (mus-arrays-equal? v1 #r(1.000 0.602 -0.067 -0.242 -0.007 0.071 -0.087 -0.128 -0.007 0.012)))
	  (snd-display "ws nrxycos output: ~A" v1)))
    
    (let ((gen (make-asymmetric-fm 440.0))
	  (v0 (make-float-vector 10)))
      (print-and-check gen 
		       "asymmetric-fm"
		       "asymmetric-fm freq: 440.000Hz, phase: 0.000, ratio: 1.000, r: 1.000")
      (do ((i 0 (+ i 1)))
	  ((= i 10))
	(set! (v0 i) (asymmetric-fm gen 0.0)))
      (let ((v1 (make-float-vector 10)))
	(let ((gen1 (make-asymmetric-fm 440.0)))
	  (fill-float-vector v1 (if (asymmetric-fm? gen1) (asymmetric-fm gen1 0.0) -1.0)))
	(if (not (mus-arrays-equal? v0 v1)) (snd-display "map asymmetric-fm: ~A ~A" v0 v1)))
      (if (not (asymmetric-fm? gen)) (snd-display "~A not asymmetric-fm?" gen))
      (if (fneq (mus-phase gen) 1.253787) (snd-display "asymmetric-fm phase: ~F?" (mus-phase gen)))
      (set! (mus-phase gen) 1.0)
      (if (fneq (mus-phase gen) 1.0) (snd-display "set! asymmetric-fm phase: ~F?" (mus-phase gen)))
      (if (fneq (mus-frequency gen) 440.0) (snd-display "asymmetric-fm frequency: ~F?" (mus-frequency gen)))
      (set! (mus-frequency gen) 100.0)
      (if (fneq (mus-frequency gen) 100.0) (snd-display "set! asymmetric-fm frequency: ~F?" (mus-frequency gen)))
      (if (or (fneq (v0 2) 0.969) (fneq (v0 8) .538)) (snd-display "asymmetric-fm output: ~A" v0))
      (if (fneq (mus-scaler gen) 1.0) (snd-display "mus-scaler (r) asymmetric-fm: ~A" (mus-scaler gen)))
      (set! (mus-scaler gen) 0.5)
      (if (fneq (mus-scaler gen) 0.5) (snd-display "mus-scaler (set r) asymmetric-fm: ~A" (mus-scaler gen)))
      (if (fneq (mus-offset gen) 1.0) (snd-display "mus-offset asymmetric-fm: ~A" (mus-offset gen))))
    
    (test-gen-equal (make-asymmetric-fm 440.0) (make-asymmetric-fm 440.0) (make-asymmetric-fm 100.0))
    (test-gen-equal (make-asymmetric-fm 440.0) (make-asymmetric-fm 440.0) (make-asymmetric-fm 440.0 1.0))
    (test-gen-equal (make-asymmetric-fm 440.0) (make-asymmetric-fm 440.0) (make-asymmetric-fm 440.0 0.0 3))
    
    (do ((gen1 (make-asymmetric-fm 1000 0 1.0 0.1))
	 (gen2 (make-oscil 1000 :initial-phase (* 0.5 pi)))
	 (happy #t)
	 (i 0 (+ i 1)))
	((or (not happy) (= i 100)))
      (let ((ss (asymmetric-fm gen1 0.0))
	    (os (oscil gen2 0.0)))
	(when (fneq ss os)
	  (snd-display "asymmetric-fm 1: ~A: os: ~A ss: ~A" i os ss)
	  (set! happy #f))))
    
    (for-each
     (lambda (index)
       (for-each
	(lambda (r)
	  (let ((peak (float-vector-peak (with-sound (:clipped #f :output (make-float-vector 1000))
					    (do ((gen (make-asymmetric-fm 2000.0 :ratio .1 :r r))
						 (i 0 (+ i 1)))
						((= i 1000))
					      (outa i (asymmetric-fm gen index)))))))
	    (if (> (abs (- peak 1.0)) .1)
		(snd-display "asymmetric-fm peak: ~A, index: ~A, r: ~A" peak index r))))
	'(-10.0 -1.5 -0.5 0.5 1.0 1.5 10.0)))
     '(1.0 3.0 10.0))
    
    (let ((float-vector0 (make-float-vector 2048))
	  (float-vector1 (make-float-vector 2048))
	  (gen3 (make-asymmetric-fm 1000 0 1.0 0.2))
	  (gen4 (make-oscil 1000 (* 0.5 pi)))
	  (gen5 (make-oscil 200))
	  (fm1 (hz->radians (* 1.0 .2 1000)))) ; make notions of "index" match
      (do ((i 0 (+ i 1)))
	  ((= i 2048))
	(set! (float-vector0 i) (asymmetric-fm gen3 1.0))
	(set! (float-vector1 i) (oscil gen4 (* fm1 (oscil gen5)))))
      (let ((spectr1 (snd-spectrum float-vector0 rectangular-window 2048 #t))
	    (spectr2 (snd-spectrum float-vector1 rectangular-window 2048 #t))
	    (happy #t))
	(do ((i 1 (+ i 1)))
	    ((or (not happy)
		 (= i 512)))
	  (when (> (abs (- (spectr1 i) (spectr2 i))) .02)
	    (snd-display "asymmetric-fm 2: ~A: ~A ~A" i (spectr1 i) (spectr2 i))
	    (set! happy #f)))))
    
    (let ((gen (make-asymmetric-fm 40.0 0.0 1.0 0.1))
	  (gen1 (make-asyfm :frequency 40.0 :ratio .1 :index 2.0))
	  (incr (/ (* 2 pi 40.0) *clm-srate*))
	  (r 1.0))
      (do ((ratio 0.1)
	   (cr (* 0.5 (- r (/ 1.0 r))))
	   (sr (* 0.5 (+ r (/ 1.0 r))))
	   (i 0 (+ i 1))
	   (a 0.0 (+ a incr)))
	  ((= i 1100))
	(let ((val1 (asymmetric-fm gen 2.0)) ; 1.0=index
	      (val3 (asyfm-J gen1 0.0))
	      (index 2.0)
	      (mth (* ratio a)))
	  (let ((val2 (* (exp (* index cr (+ 1.0 (cos mth))))
			 (cos (+ a (* index sr (sin mth)))))))
	    (if (or (fneq val1 val2)
		    (fneq val1 val3))
		(snd-display "asyfm by hand: ~A: ~A ~A ~A" i val1 val2 val3))))))
    
    (let ((float-vector0 (make-float-vector 2048))
	  (float-vector1 (make-float-vector 2048))
	  (gen3 (make-asymmetric-fm 1000 0 2.0 0.1))
	  (gen4 (make-asymmetric-fm 1000 0 0.5 0.1)))
      (do ((i 0 (+ i 1)))
	  ((= i 2048))
	(set! (float-vector0 i) (asymmetric-fm gen3 2.0))
	(set! (float-vector1 i) (asymmetric-fm gen4 2.0)))
      (let ((spectr1 (snd-spectrum float-vector0 rectangular-window 2048 #t))
	    (s1-loc 0)
	    (s2-loc 0))
	(do ((spectr2 (snd-spectrum float-vector1 rectangular-window 2048 #t))
	     (i 1 (+ i 1)))
	    ((= i 256))
	  (if (within-.01? (spectr1 i)) ;(< (abs (- 1.0 (spectr1 i))) .01) 
	      (set! s1-loc i))
	  (if (within-.01? (spectr2 i)) ;(< (abs (- 1.0 (spectr2 i))) .01) 
	      (set! s2-loc i)))
	(if (> s2-loc s1-loc) (snd-display "asymmetric-fm peaks: ~A ~A" s1-loc s2-loc))
	(let ((center (* 11025/1024 0.5 (+ s1-loc s2-loc)))) ;(* (/ 22050 2048) .5 (+ s1-loc s2-loc))
	  (if (> (abs (- 1000 center)) 60) (snd-display "asymmetric-fm center: ~A" center)))
	(set! (mus-scaler gen3) 0.5)
	(do ((i 0 (+ i 1)))
	    ((= i 2048))
	  (set! (float-vector0 i) (asymmetric-fm gen3 2.0)))
	(set! spectr1 (snd-spectrum float-vector0 rectangular-window 2048 #t))
	(do ((i 1 (+ i 1)))
	    ((= i 256))
	  (if (within-.01? (spectr1 i)) ;(< (abs (- 1.0 (spectr1 i))) .01) 
	      (set! s1-loc i)))
	(if (not (= s2-loc s1-loc)) (snd-display "asymmetric-fm set r peaks: ~A ~A" s1-loc s2-loc))
	(do ((i 0 (+ i 1)))
	    ((= i 2048))
	  (set! (float-vector0 i) (asymmetric-fm gen3 2.0)))
	(snd-spectrum float-vector0 rectangular-window 2048 #t 0.0 #t)
	(do ((i 1 (+ i 1)))
	    ((= i 256))
	  (if (within-.01? (float-vector0 i)) ;(< (abs (- 1.0 (float-vector0 i))) .01) 
	      (set! s1-loc i)))
	(if (not (= s2-loc s1-loc)) (snd-display "asymmetric-fm set r in place peaks: ~A ~A" s1-loc s2-loc))))
    
    (asyfm-I (make-asyfm :frequency 2000 :ratio .1) 0.0)
    
    (do ((i 2 (+ i 1)))
	((= i 40))
      (let ((v (make-float-vector i)))
	(do ((k 0 (+ k 1)))
	    ((= k i))
	  (set! (v k) (expt 1.2 (- k))))
	(do ((f (make-fir-filter i v))
	     (k 0 (+ k 1))
	     (x 1.0 0.0))
	    ((= k i))
	  (let ((val (fir-filter f x))
		(exval (expt 1.2 (- k))))
	    (if (> (abs (- val exval)) 1e-12)
		(format *stderr* ";for-filter ~D at ~D: ~A ~A~%" i k val exval))))))
    
    (let ((f (make-fir-filter 3 #r(1.0 .5 .25)))
	  (v (make-float-vector 10)))
      (set! (v 0) (f 1.0))
      (do ((i 1 (+ i 1)))
	  ((= i 5))
	(set! (v i) (f 0.0)))
      (set! (v 5) (f 1.0))
      (do ((i 6 (+ i 1)))
	  ((= i 10))
	(set! (v i) (f 0.0)))
      (if (not (mus-arrays-equal? v #r(1.0 0.5 .25 0.0 0.0 1.0 0.5 .25 0.0 0.0)))
	  (format *stderr* ";f3: ~A~%" v)))
    
    (let ((f (make-fir-filter 7 #r(.7 .6 .5 .4 .3 .2 .1)))
	  (v (make-float-vector 10)))
      (set! (v 0) (f 1.0))
      (do ((i 1 (+ i 1)))
	  ((= i 10))
	(set! (v i) (f 0.0)))
      (if (not (mus-arrays-equal? v #r(.7 .6 .5 .4 .3 .2 .1 0.0 0.0 0.0)))
	  (format *stderr* ";f7: ~A~%" v)))
    
    
    (let ((f (make-iir-filter 3 #r(1.0 .5 .25)))
	  (v (make-float-vector 10)))
      (set! (v 0) (f 1.0))
      (do ((i 1 (+ i 1)))
	  ((= i 5))
	(set! (v i) (f 0.0)))
      (set! (v 5) (f 1.0))
      (do ((i 6 (+ i 1)))
	  ((= i 10))
	(set! (v i) (f 0.0)))
      (if (not (mus-arrays-equal? v #r(1.0 -0.5 0.0 0.125 -0.0625 1.0 -0.484375 -0.0078125 0.125 -0.060546875)))
	  (format *stderr* ";i3: ~A~%" v)))
    
    
    (let ((f (make-iir-filter 7 #r(.7 .6 .5 .4 .3 .2 .1)))
	  (v (make-float-vector 30)))
      (set! (v 0) (f 1.0))
      (do ((i 1 (+ i 1)))
	  ((= i 30))
	(set! (v i) (f 0.0)))
      (unless (mus-arrays-equal? v #r(1.000000 -0.600000 -0.140000 -0.016000 0.019600 0.032240 0.039256 0.045286 
						 -0.048376 -0.021312 -0.001324 0.006140 0.007033 0.004780 0.000657 -0.005043 
						 -0.002420 0.000256 0.001217 0.001013 0.000350 -0.000292 -0.000579 -0.000219 
						 0.000109 0.000192 0.000115 0.000002 -0.000067 -0.000065))
	(format *stderr* ";i7: ")
	(do ((i 0 (+ i 1)))
	    ((= i 30))
	  (format *stderr* "~,6f " (v i)))
	(format *stderr* "~%")))
    
    (let ((x (make-float-vector 3))
	  (y (make-float-vector 3)))
      (do ((i 0 (+ i 1)))
	  ((= i 3))
	(set! (x i) (expt 1.2 (- i)))
	(set! (y i) (expt 1.5 (- i))))
      
      (let ((f (make-filter 3 x y))
	    (v (make-float-vector 10)))
	(set! (v 0) (f 1.0))
	(do ((i 1 (+ i 1)))
	    ((= i 10))
	  (set! (v i) (f 0.0)))
	(unless (mus-arrays-equal? v #r(1.000000 0.166667 0.138889 -0.166667 0.049383 0.041152 -0.049383 0.014632 0.012193 -0.014632))
	  (format *stderr* ";g3: ")
	  (do ((i 0 (+ i 1)))
	      ((= i 10))
	    (format *stderr* "~,6f " (v i)))
	  (format *stderr* "~%"))))
    
    (let ((x (make-float-vector 9))
	  (y (make-float-vector 9)))
      (do ((i 0 (+ i 1)))
	  ((= i 9))
	(set! (x i) (expt 1.2 (- i)))
	(set! (y i) (expt 1.2 (- i))))
      
      (let ((f (make-filter 9 x y))
	    (v (make-float-vector 30)))
	(set! (v 0) (f 1.0))
	(do ((i 1 (+ i 1)))
	    ((= i 30))
	  (set! (v i) (f 0.0)))
	(unless (mus-arrays-equal? v #r(1.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0
						   0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0))
	  (format *stderr* ";g9: ")
	  (do ((i 0 (+ i 1)))
	      ((= i 30))
	    (format *stderr* "~,6f " (v i)))
	  (format *stderr* "~%"))))
    
    (let ((x (make-float-vector 9))
	  (y (make-float-vector 9)))
      (do ((i 0 (+ i 1)))
	  ((= i 9))
	(set! (x i) (expt 1.2 (- i)))
	(set! (y i) (expt 1.5 (- i))))
      
      (let ((f (make-filter 9 x y))
	    (v (make-float-vector 30)))
	(set! (v 0) (f 1.0))
	(do ((i 1 (+ i 1)))
	    ((= i 30))
	  (set! (v i) (f 0.0)))
	(unless (mus-arrays-equal? v #r(1.000000 0.166667 0.138889 0.115741 0.096451 0.080376 0.066980 0.055816 0.046514 
						   -0.129033 0.004335 0.003613 0.003011 0.002509 0.002091 0.001742 0.001452 0.001210 
						   -0.003356 0.000113 0.000094 0.000078 0.000065 0.000054 0.000045 0.000038 0.000031
						   -0.000087 0.000003 0.000002))
	  (format *stderr* ";g9e: ")
	  (do ((i 0 (+ i 1)))
	      ((= i 30))
	    (format *stderr* "~,6f " (v i)))
	  (format *stderr* "~%"))))

    (let ((x (make-float-vector 8))
	  (y (make-float-vector 8)))
      (do ((i 0 (+ i 1)))
	  ((= i 8))
	(set! (x i) (expt 1.5 (- i)))
	(set! (y i) (expt 1.2 (- i))))
      
      (let ((f (make-filter 8 x y))
	    (v (make-float-vector 30)))
	(set! (v 0) (f 1.0))
	(do ((i 1 (+ i 1)))
	    ((= i 30))
	  (set! (v i) (f 0.0)))
	(unless (mus-arrays-equal? v #r(1.000000 -0.166667 -0.111111 -0.074074 -0.049383 -0.032922 -0.021948 -0.014632 
						   0.183795 -0.038761 -0.025841 -0.017227 -0.011485 -0.007657 -0.005104 -0.003403 
						   0.042745 -0.009015 -0.006010 -0.004007 -0.002671 -0.001781 -0.001187 -0.000791 
						   0.009941 -0.002097 -0.001398 -0.000932 -0.000621 -0.000414))
	  (format *stderr* ";g-8: ")
	  (do ((i 0 (+ i 1)))
	      ((= i 30))
	    (format *stderr* "~,6f " (v i)))
	  (format *stderr* "~%"))))

    (let ((x (make-float-vector 18))
	  (y (make-float-vector 18)))
      (do ((i 0 (+ i 1)))
	  ((= i 18))
	(set! (x i) (expt 1.5 (- i)))
	(set! (y i) (expt 1.2 (- i))))
      
      (let ((f (make-filter 18 x y))
	    (v (make-float-vector 30)))
	(set! (v 0) (f 1.0))
	(do ((i 1 (+ i 1)))
	    ((= i 30))
	  (set! (v i) (f 0.0)))
	(unless (mus-arrays-equal? v #r(1.000000 -0.166667 -0.111111 -0.074074 -0.049383 -0.032922 -0.021948 -0.014632 -0.009755 
						   -0.006503 -0.004335 -0.002890 -0.001927 -0.001285 -0.000856 -0.000571 -0.000381 -0.000254 
						   0.036715 -0.006260 -0.004173 -0.002782 -0.001855 -0.001237 -0.000824 -0.000550 -0.000366 
						   -0.000244 -0.000163 -0.000109))
	  (format *stderr* ";g-18: ")
	  (do ((i 0 (+ i 1)))
	      ((= i 30))
	    (format *stderr* "~,6f " (v i)))
	  (format *stderr* "~%"))))

    (let ((x (make-float-vector 9))
	  (y (make-float-vector 9)))
      (do ((i 0 (+ i 1)))
	  ((= i 9))
	(set! (x i) (expt 1.5 (- i)))
	(set! (y i) (expt 1.2 (- i))))
      
      (let ((f (make-filter 9 x y))
	    (v (make-float-vector 30)))
	(set! (v 0) (f 1.0))
	(do ((i 1 (+ i 1)))
	    ((= i 30))
	  (set! (v i) (f 0.0)))
	(unless (mus-arrays-equal? v #r(1.000000 -0.166667 -0.111111 -0.074074 -0.049383 -0.032922 
						   -0.021948 -0.014632 -0.009755 0.161291 -0.032301 -0.021534 
						   -0.014356 -0.009571 -0.006380 -0.004254 -0.002836 -0.001891 
						   0.031259 -0.006260 -0.004173 -0.002782 -0.001855 -0.001237 
						   -0.000824 -0.000550 -0.000366 0.006058 -0.001213 -0.000809))
	  (format *stderr* ";g-9: ")
	  (do ((i 0 (+ i 1)))
	      ((= i 30))
	    (format *stderr* "~,6f " (v i)))
	  (format *stderr* "~%"))))
    
    
    (let ((gen (make-fir-filter 3 #r(.5 .25 .125)))
	  (v0 (make-float-vector 10)))
      (print-and-check gen 
		       "fir-filter"
		       "fir-filter order: 3, xs: [0.5 0.25 0.125]"
		       )
      (set! (v0 0) (fir-filter gen 1.0))
      (do ((i 1 (+ i 1)))
	  ((= i 10))
	(set! (v0 i) (fir-filter gen 0.0)))
      (let ((v1 (make-float-vector 10)))
	(let ((inp 1.0)
	      (gen1 (make-fir-filter 3 #r(.5 .25 .125))))  
	  (fill-float-vector v1 (let ((val (if (fir-filter? gen1) (fir-filter gen1 inp) -1.0)))
				  (set! inp 0.0)
				  val)))
	(if (not (mus-arrays-equal? v0 v1)) (snd-display "map fir-filter: ~A ~A" v0 v1)))
      (if (not (fir-filter? gen)) (snd-display "~A not fir-filter?" gen))
      (if (not (= (mus-length gen) 3)) (snd-display "fir-filter length: ~D?" (mus-length gen)))
      (if (or (fneq (v0 1) 0.25) (fneq (v0 2) .125)) (snd-display "fir-filter output: ~A" v0))
      (let ((data (mus-xcoeffs gen)))
	(if (fneq (data 1) .25) (snd-display "fir-filter xcoeffs: ~A?" data)))
      (let ((tag (catch #t (lambda () (mus-xcoeff gen 123)) (lambda args (car args)))))
	(if (not (eq? tag 'mus-error))
	    (snd-display "xcoeff 123: ~A" tag)))
      (let ((tag (catch #t (lambda () (mus-ycoeff gen 123)) (lambda args (car args)))))
	(if (not (eq? tag 'mus-error))
	    (snd-display "fir ycoeff 123: ~A" tag))))
    
    (test-gen-equal (let ((f1 (make-fir-filter 3 #r(.5 .25 .125)) )) (fir-filter f1 1.0) f1)
		    (let ((f2 (make-fir-filter 3 #r(.5 .25 .125)) )) (fir-filter f2 1.0) f2)
		    (let ((f3 (make-fir-filter 3 #r(.75 .25 .125)))) (fir-filter f3 1.0) f3))
    (test-gen-equal (let ((f1 (make-fir-filter 3 #r(.5 .25 .125)) )) (fir-filter f1 1.0) f1)
		    (let ((f2 (make-fir-filter 3 #r(.5 .25 .125)) )) (fir-filter f2 1.0) f2)
		    (let ((f3 (make-fir-filter 2 #r(.5 .25)))) (fir-filter f3 1.0) f3))
    
    (let* ((coeffs #r(.1 .2 .3 .4 .4 .3 .2 .1))
	   (flt (make-fir-filter 8 coeffs)))
      (let ((xcof (mus-xcoeffs flt))
	    (es (make-vector 8)))
	(do ((i 0 (+ i 1)))
	    ((= i 8))
	  (set! (es i) (make-env (list 0 (coeffs i) 1 0) :length 102)))
	(set! (es 5) (make-env '(0 .4 1 1) :length 102))
	(let ((data (make-float-vector 100)))
	  (do ((k 0 (+ k 1)))
	      ((= k 100))
	    (set! (data k) (fir-filter flt (if (= (modulo k 12) 0) 1.0 0.0)))
	    (do ((i 0 (+ i 1)))
		((= i 8))
	      (float-vector-set! xcof i (env (vector-ref es i)))))
	  (if (or (fneq (data 1) .2)
		  (fneq (data 10) 0.0)
		  (fneq (data 18) 0.166)
		  (fneq (data 89) 0.923))
	      (snd-display "filter xcoeffs: ~A?" data)))))
    
    (let ((make-f-filter (lambda (coeffs)
			   (list coeffs (make-float-vector (length coeffs)))))
	  (f-filter (lambda (flt x)
		      (let ((coeffs (car flt))
			    (xs (cadr flt)))
			(let ((xlen (length xs)))
			  (float-vector-move! xs (- xlen 1) (- xlen 2) #t)
			  (set! (xs 0) x)
			  (dot-product coeffs xs xlen))))))
      (do ((fir1 (make-fir-filter 3 #r(1.0 0.4 0.1)))
	   (fir2 (make-f-filter #r(1.0 0.4 0.1)))
	   (x 1.0)
	   (happy #t)
	   (i 0 (+ i 1)))
	  ((or (not happy) (= i 10)))
	(let ((val1 (fir-filter fir1 x))
	      (val2 (f-filter fir2 x)))
	  (set! x 0.0)
	  (when (fneq val1 val2)
	    (snd-display "f-filter ~A -> ~A ~A" i val1 val2)
	    (set! happy #f)))))
    
    (let ((gen (make-spencer-filter)))
      (if (not (fir-filter? gen)) 
	  (snd-display "make-spencer-filter returns ~A?" gen)
	  (begin
	    (if (not (= (mus-order gen) 15)) (snd-display "make-spencer-filter order ~A?" (mus-order gen)))
	    (if (not (mus-arrays-equal? (mus-xcoeffs gen) #r(-0.009 -0.019 -0.016 0.009 0.066 0.144 0.209 0.231 0.209 0.144 0.066 0.009 -0.016 -0.019 -0.009)))
		(snd-display "make-spencer-filter coeffs: ~A" (mus-xcoeffs gen))))))
    
    (let ((flt (mus-xcoeffs (make-savitzky-golay-filter 5 2))))
      (if (not (mus-arrays-equal? flt #r(-0.086 0.343 0.486 0.343 -0.086)))
	  (snd-display "sg 5 2: ~A" flt)))
    (let ((flt (mus-xcoeffs (make-savitzky-golay-filter 11 2))))
      (if (not (mus-arrays-equal? flt #r(-0.084 0.021 0.103 0.161 0.196 0.207 0.196 0.161 0.103 0.021 -0.084)))
	  (snd-display "sg 11 2: ~A" flt)))
    (let ((flt (mus-xcoeffs (make-savitzky-golay-filter 11 4))))
      (if (not (mus-arrays-equal? flt #r(0.042 -0.105 -0.023 0.140 0.280 0.333 0.280 0.140 -0.023 -0.105 0.042)))
	  (snd-display "sg 11 4: ~A" flt)))
    (let ((flt (mus-xcoeffs (make-savitzky-golay-filter 25 2))))
      (if (not (mus-arrays-equal? flt #r(-0.049 -0.027 -0.006 0.012 0.028 0.043 0.055 0.066 0.075 0.082 0.086 
						    0.089 0.090 0.089 0.086 0.082 0.075 0.066 0.055 0.043 
						    0.028 0.012 -0.006 -0.027 -0.049)))
	  (snd-display "sg 25 2: ~A" flt)))
    
    (let ((gen (make-iir-filter 3 #r(.5 .25 .125)))
	  (v0 (make-float-vector 10)))
      (print-and-check gen 
		       "iir-filter"
		       "iir-filter order: 3, ys: [0.5 0.25 0.125]"
		       )
      (set! (v0 0) (iir-filter gen 1.0))
      (do ((i 1 (+ i 1)))
	  ((= i 10))
	(set! (v0 i) (iir-filter gen 0.0)))
      (let ((v1 (make-float-vector 10)))
	(let ((inp 1.0)
	      (gen1 (make-iir-filter 3 #r(.5 .25 .125))))  
	  (fill-float-vector v1 (let ((val (if (iir-filter? gen1) (iir-filter gen1 inp) -1.0)))
				  (set! inp 0.0)
				  val)))
	(if (not (mus-arrays-equal? v0 v1)) (snd-display "map iir-filter: ~A ~A" v0 v1)))
      (if (not (iir-filter? gen)) (snd-display "~A not iir-filter?" gen))
      (if (not (= (mus-length gen) 3)) (snd-display "iir-filter length: ~D?" (mus-length gen)))
      (if (or (fneq (v0 1) -0.25) (fneq (v0 2) -.062)) (snd-display "iir-filter output: ~A" v0))
      (let ((data (mus-ycoeffs gen)))
	(if (fneq (data 1) .25) (snd-display "iir-filter ycoeffs: ~A?" data)))
      (let ((tag (catch #t (lambda () (mus-ycoeff gen 123)) (lambda args (car args)))))
	(if (not (eq? tag 'mus-error))
	    (snd-display "ycoeff 123: ~A" tag)))
      (let ((tag (catch #t (lambda () (mus-xcoeff gen 123)) (lambda args (car args)))))
	(if (not (eq? tag 'mus-error))
	    (snd-display "iir xcoeff 123: ~A" tag))))
    
    (test-gen-equal (let ((f1 (make-iir-filter 3 #r(.5 .25 .125)))) (iir-filter f1 1.0) f1)
		    (let ((f2 (make-iir-filter 3 #r(.5 .25 .125)) )) (iir-filter f2 1.0) f2)
		    (let ((f3 (make-iir-filter 3 #r(.75 .25 .125)))) (iir-filter f3 1.0) f3))
    (test-gen-equal (let ((f1 (make-iir-filter 3 #r(.5 .25 .125)) )) (iir-filter f1 1.0) f1)
		    (let ((f2 (make-iir-filter 3 #r(.5 .25 .125)) )) (iir-filter f2 1.0) f2)
		    (let ((f3 (make-iir-filter 2 #r(.5 .25)))) (iir-filter f3 1.0) f3))
    
    (let ((gen (make-filter 3 #r(.5 .25 .125) #r(.5 .25 .125))))
      (print-and-check gen 
		       "filter"
		       "filter order: 3, xs: [0.5 0.25 0.125], ys: [0.5 0.25 0.125]")
      (let ((v0 (make-float-vector 10))
	    (gen2 (make-biquad .1 .2 .3 .4 .5)))
	(set! (v0 0) (filter gen 1.0))
	(do ((i 1 (+ i 1)))
	    ((= i 10))
	  (set! (v0 i) (filter gen 0.0)))
	(let ((v1 (make-float-vector 10))
	      (gen1 (make-filter 3 #r(.5 .25 .125) #r(.5 .25 .125)))
	      (inp 1.0))
	  (fill-float-vector v1 (let ((val (if (filter? gen1) (filter gen1 inp) -1.0)))
				  (set! inp 0.0)
				  val))
	  (if (not (mus-arrays-equal? v0 v1)) (snd-display "map filter: ~A ~A" v0 v1)))
	(if (not (filter? gen)) (snd-display "~A not filter?" gen))
	(if (not (= (mus-length gen) 3)) (snd-display "filter length: ~D?" (mus-length gen)))
	(if (or (fneq (v0 1) 0.125) (fneq (v0 2) .031)) (snd-display "filter output: ~A" v0))
	(if (not (filter? gen2)) (snd-display "make-biquad: ~A" gen2)))
      (let ((xs (mus-xcoeffs gen))
	    (ys (mus-ycoeffs gen)))
	(if (not (and (equal? xs #r(.5 .25 .125))
		      (equal? xs ys)))
	    (snd-display "mus-xcoeffs: ~A ~A?" xs ys))))
    
    (let ((var (catch #t (lambda () (make-filter :order 2 :xcoeffs #r(1.0 0.5) :ycoeffs #r(2.0 1.0 0.5))) (lambda args args))))
      (if (not (eq? (car var) 'mus-error))
	  (snd-display "make-filter bad coeffs: ~A" var)))
    (let ((var (catch #t (lambda () (make-filter :order 0 :xcoeffs #r(1.0 0.5))) (lambda args args))))
      (if (not (eq? (car var) 'out-of-range))
	  (snd-display "make-filter bad order: ~A" var)))
    (let ((var (catch #t (lambda () (make-fir-filter :order 22 :xcoeffs #r(1.0 0.5))) (lambda args args))))
      (if (not (eq? (car var) 'mus-error))
	  (snd-display "make-fir-filter bad coeffs: ~A" var)))
    (let ((var (catch #t (lambda () (make-iir-filter :order 22 :ycoeffs #r(1.0 0.5))) (lambda args args))))
      (if (not (eq? (car var) 'mus-error))
	  (snd-display "make-iir-filter bad coeffs: ~A" var)))
    (let ((var (catch #t (lambda () (make-fir-filter -1)) (lambda args args))))
      (if (not (eq? (car var) 'out-of-range))
	  (snd-display "make-fir-filter bad order: ~A" var)))
    (let ((var (make-filter :order 2 :ycoeffs #r(1.0 0.5))))
      (if (not (iir-filter? var))
	  (snd-display "make-filter with only y: ~A" var)))
    
    (test-gen-equal (let ((f1 (make-filter 3 #r(.5 .25 .125) #r(.5 .25 .125)))) (filter f1 1.0) f1)
		    (let ((f2 (make-filter 3 #r(.5 .25 .125) #r(.5 .25 .125)))) (filter f2 1.0) f2)
		    (let ((f3 (make-filter 3 #r(.5 .25 .125) #r(.5 .5 .5)))) (filter f3 1.0) f3))
    (test-gen-equal (let ((f1 (make-filter 3 #r(.5 .25 .125) #r(.5 .25 .125)))) (filter f1 1.0) f1)
		    (let ((f2 (make-filter 3 #r(.5 .25 .125) #r(.5 .25 .125)))) (filter f2 1.0) f2)
		    (let ((f3 (make-filter 3 #r(.5 .5 .125) #r(.5 .25 .0625)))) (filter f3 1.0) f3))
    
    (let ((fr (mus-length (make-fir-filter 6 #r(0 1 2 3 4 5)))))
      (if (not (= fr 6)) (snd-display "filter-length: ~A" fr)))
    
    (let ((val (cascade->canonical (list #r(1.0 0.0 0.0) #r(1.0 0.5 0.25)))))
      (if (not (mus-arrays-equal? val #r(1.000 0.500 0.250 0.000 0.000)))
	  (snd-display "cas2can 0: ~A" val)))
    (let ((val (cascade->canonical (list #r(1.0 1.0 0.0) #r(1.0 0.5 0.25)))))
      (if (not (mus-arrays-equal? val #r(1.000 1.500 0.750 0.250 0.000)))
	  (snd-display "cas2can 1: ~A" val)))
    
    (let ((val (cascade->canonical (list #r(1 0.8 0) #r(1 1.4 0.65) #r(1 0 0)))))
      (if (not (mus-arrays-equal? val #r(1.000 2.200 1.770 0.520 0.000 0.000 0.000)))
	  (snd-display "cascade->canonical: ~A" val)))
    (let ((val (cascade->canonical (list #r(1 -0.9 0) #r(1 1 0.74) #r(1 -1.6 0.8)))))
      (if (not (mus-arrays-equal? val #r(1.000 -1.500 0.480 -0.330 0.938 -0.533 0.000)))
	  (snd-display "cascade->canonical 1: ~A" val)))
    
    (let ((ind (new-sound "test.snd" 1 22050 mus-ldouble mus-next)))
      (pad-channel 0 10000)
      (freq-sweep .45)
      (let ((sp (rough-spectrum ind)))
	(if (not (or (mus-arrays-equal? sp #r(0.962 0.998 0.998 0.998 0.998 0.999 0.999 0.998 0.997 1.000))
		     (mus-arrays-equal? sp #r(0.963 0.999 0.999 0.999 0.999 0.999 1.000 1.000 0.998 0.997))))
	    (snd-display "initial rough spectrum: ~A" sp)))
      
      (let ((b (make-butter-high-pass 440.0)))
	(let ((v (make-float-vector 10))
	      (d (make-delay 1)))
	  (delay d (filter b 1.0))
	  (fill-float-vector v (delay d (filter b 0.0)))
	  (if (not (mus-arrays-equal? v #r(0.915 -0.162 -0.146 -0.131 -0.117 -0.103 -0.090 -0.078 -0.066 -0.056)))
	      (snd-display "butter high: ~A" v)))
	(set! b (make-butter-high-pass 1000.0))
	(map-channel (lambda (y) (filter b y)))
	(let ((sp (rough-spectrum ind)))
	  (if (not (or (mus-arrays-equal? sp #r(0.150 0.833 0.980 0.994 0.997 0.998 0.999 0.998 0.997 1.000))
		       (mus-arrays-equal? sp #r(0.150 0.833 0.981 0.995 0.998 0.999 1.000 1.000 0.998 0.997))))
	      (snd-display "hp rough spectrum: ~A" sp)))
	(undo))
      
      (let ((b (make-butter-low-pass 440.0)))
	(let ((v (make-float-vector 10))
	      (d (make-delay 1)))
	  (delay d (filter b 1.0))
	  (fill-float-vector v (delay d (filter b 0.0)))
	  (if (not (mus-arrays-equal? v #r(0.004 0.014 0.026 0.035 0.043 0.049 0.053 0.055 0.057 0.057)))
	      (snd-display "butter low: ~A" v)))
	(set! b (make-butter-low-pass 1000.0))
	(map-channel (lambda (y) (filter b y)))
	(let ((sp (rough-spectrum ind)))
	  (if (not (mus-arrays-equal? sp #r(1.000 0.212 0.024 0.005 0.001 0.000 0.000 0.000 0.000 0.000)))
	      (snd-display "lp rough spectrum: ~A" sp)))
	(undo))
      
      (let ((b (make-butter-band-pass 440.0 50.0)))
	(let ((v (make-float-vector 10))
	      (d (make-delay 1)))
	  (delay d (filter b 1.0))
	  (fill-float-vector v (delay d (filter b 0.0)))
	  (if (not (mus-arrays-equal? v #r(0.007 0.014 0.013 0.013 0.012 0.011 0.009 0.008 0.007 0.005)))
	      (snd-display "butter bandpass: ~A" v)))
	(set! b (make-butter-band-pass 1000.0 500.0))
	(map-channel (lambda (y) (filter b y)))
	(let ((sp (rough-spectrum ind)))
	  (if (not (mus-arrays-equal? sp #r(0.888 1.000 0.144 0.056 0.027 0.014 0.008 0.004 0.002 0.000)))
	      (snd-display "bp rough spectrum: ~A" sp)))
	(undo))
      
      (let ((b (make-butter-band-reject 440.0 50.0)))
	(let ((v (make-float-vector 10))
	      (d (make-delay 1)))
	  (delay d (filter b 1.0))
	  (fill-float-vector v (delay d (filter b 0.0)))
	  (if (not (mus-arrays-equal? v #r(0.993 -0.014 -0.013 -0.013 -0.012 -0.011 -0.009 -0.008 -0.007 -0.005)))
	      (snd-display "butter bandstop: ~A" v)))
	(set! b (make-butter-band-reject 1000.0 500.0))
	(map-channel (lambda (y) (filter b y)))
	(let ((sp (rough-spectrum ind)))
	  (if (not (or (mus-arrays-equal? sp #r(0.662 0.687 0.953 0.980 0.989 0.994 0.997 0.997 0.997 1.000))
		       (mus-arrays-equal? sp #r(0.664 0.689 0.955 0.982 0.992 0.996 0.999 1.000 0.999 0.998))))
	      (snd-display "bs rough spectrum: ~A" sp)))
	(undo))
      
      (if (defined? 'gsl-roots) (analog-filter-tests))
      (test-lpc)
      (test-unclip-channel)
      
      (let ((v (spectrum->coeffs 10 #r(0 1.0 0 0 0 0 0 0 1.0 0)))
	    (v1 (make-fir-coeffs 10 #r(0 1.0 0 0 0 0 0 0 1.0 0))))
	(if (not (mus-arrays-equal? v #r(-0.190 -0.118 0.000 0.118 0.190 0.190 0.118 0.000 -0.118 -0.190)))
	    (snd-display "spectrum->coeffs: ~A" v))
	(if (not (mus-arrays-equal? v v1))
	    (snd-display "spectrum->coeffs v make-fir-coeffs: ~A ~A" v v1)))
      
      (let ((notched-spectr (make-float-vector 20)))
	(set! (notched-spectr 2) 1.0) 
	(let ((v (spectrum->coeffs 20 notched-spectr))
	      (v1 (make-fir-coeffs 20 notched-spectr)))
	  (if (not (mus-arrays-equal? v #r(0.095 0.059 -0.000 -0.059 -0.095 -0.095 -0.059 0.000 0.059 0.095 
				  0.095 0.059 0.000 -0.059 -0.095 -0.095 -0.059 -0.000 0.059 0.095)))
	      (snd-display "spectrum->coeffs (notch): ~A" v))
	  (if (not (mus-arrays-equal? v v1))
	      (snd-display "spectrum->coeffs v(2) make-fir-coeffs: ~A ~A" v v1))
	  (let ((flt (make-fir-filter 20 v)))
	    (map-channel (lambda (y) (fir-filter flt y))))))
      (let ((sp (rough-spectrum ind)))
	(if (not (mus-arrays-equal? sp #r(0.007 0.493 1.000 0.068 0.030 0.019 0.014 0.011 0.009 0.009)))
	    (snd-display "sp->coeff rough spectrum: ~A" sp)))
      (undo)
      
      (let ((rspect (make-float-vector 20)))
	(do ((i 0 (+ i 1)))
	    ((= i 20))
	  (set! (rspect i) (random 1.0)))
	(let ((v (spectrum->coeffs 20 rspect))
	      (v1 (make-fir-coeffs 20 rspect)))
	  (if (not (mus-arrays-equal? v v1))
	      (snd-display "spectrum->coeffs v(3) make-fir-coeffs: ~A ~A" v v1))))
      
      (let ((b (make-highpass (hz->radians 1000.0) 10)))
	(let ((v (make-float-vector 20)))
	  (let ((d (make-delay 1)))
	    (delay d (fir-filter b 1.0))
	    (fill-float-vector v (delay d (fir-filter b 0.0))))
	  (if (not (mus-arrays-equal? v #r(-0.001 -0.002 -0.005 -0.011 -0.021 -0.034 -0.049 -0.065 -0.078 -0.087 
					   0.909 -0.087 -0.078 -0.065 -0.049 -0.034 -0.021 -0.011 -0.005 -0.002)))
	      (snd-display "dsp.scm high: ~A" v)))
	(set! b (make-highpass (hz->radians 1000.0) 20))
	(map-channel (lambda (y) (fir-filter b y)))
	(let ((sp (rough-spectrum ind)))
	  (if (not (or (mus-arrays-equal? sp #r(0.053 0.774 0.998 0.997 0.997 0.996 0.996 0.996 0.997 1.000))
		       (mus-arrays-equal? sp #r(0.053 0.776 1.000 0.998 0.998 0.998 0.998 0.998 0.998 1.000))))
	      (snd-display "dsp hp rough spectrum: ~A" sp)))
	(undo))
      
      (let ((b (make-lowpass (hz->radians 1000.0) 10)))
	(let ((v (make-float-vector 20)))
	  (let ((d (make-delay 1)))
	    (delay d (fir-filter b 1.0))
	    (fill-float-vector v (delay d (fir-filter b 0.0))))
	  (if (not (mus-arrays-equal? v #r(0.001 0.002 0.005 0.011 0.021 0.034 0.049 0.065 0.078 0.087 0.091 0.087 0.078 0.065
					   0.049 0.034 0.021 0.011 0.005 0.002)))
	      (snd-display "dsp.scm low: ~A" v)))
	(set! b (make-lowpass (hz->radians 1000.0) 20))
	(map-channel (lambda (y) (fir-filter b y)))
	(let ((sp (rough-spectrum ind)))
	  (if (not (mus-arrays-equal? sp #r(1.000 0.054 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000)))
	      (snd-display "dsp lp rough spectrum: ~A" sp)))
	(undo))
      
      (let ((b (make-bandpass (hz->radians 1500.0) (hz->radians 2000.0) 10)))
	(let ((v (make-float-vector 20)))
	  (let ((d (make-delay 1)))
	    (delay d (fir-filter b 1.0))
	    (fill-float-vector v (delay d (fir-filter b 0.0))))
	  (if (not (mus-arrays-equal? v #r(0.001 -0.001 -0.005 -0.011 -0.017 -0.019 -0.013 0.003 0.022 0.039 0.045
					   0.039 0.022 0.003 -0.013 -0.019 -0.017 -0.011 -0.005 -0.001)))
	      (snd-display "dsp.scm bp: ~A" v)))
	(set! b (make-bandpass (hz->radians 1500.0) (hz->radians 2000.0) 20))
	(map-channel (lambda (y) (fir-filter b y)))
	(let ((sp (rough-spectrum ind)))
	  (if (not (mus-arrays-equal? sp #r(0.010 1.000 0.154 0.000 0.000 0.000 0.000 0.000 0.000 0.000)))
	      (snd-display "dsp bp rough spectrum: ~A" sp)))
	(undo))
      
      (let ((b (make-bandstop (hz->radians 1500.0) (hz->radians 2000.0) 10)))
	(let ((v (make-float-vector 20)))
	  (let ((d (make-delay 1)))
	    (delay d (fir-filter b 1.0))
	    (fill-float-vector v (delay d (fir-filter b 0.0))))
	  (if (not (mus-arrays-equal? v #r(-0.001 0.001 0.005 0.011 0.017 0.019 0.013 -0.003 -0.022 -0.039 0.955
					   -0.039 -0.022 -0.003 0.013 0.019 0.017 0.011 0.005 0.001)))
	      (snd-display "dsp.scm bs: ~A" v)))
	(set! b (make-bandstop (hz->radians 1500.0) (hz->radians 2000.0) 20))
	(map-channel (lambda (y) (fir-filter b y)))
	(let ((sp (rough-spectrum ind)))
	  (if (not (or (mus-arrays-equal? sp #r(0.904 0.425 0.821 0.998 0.997 0.996 0.996 0.996 0.997 1.000))
		       (mus-arrays-equal? sp #r(0.906 0.425 0.822 1.000 0.999 0.998 0.998 0.998 0.998 1.000))))
	      (snd-display "dsp bs rough spectrum: ~A" sp)))
	(undo))
      
      (let ((b (make-differentiator 10)))
	(let ((v (make-float-vector 20)))
	  (let ((d (make-delay 1)))
	    (delay d (fir-filter b 1.0))
	    (fill-float-vector v (delay d (fir-filter b 0.0))))
	  (if (not (mus-arrays-equal? v #r(-0.008 0.011 -0.021 0.039 -0.066 0.108 -0.171 0.270 -0.456 0.977
					   0.000 -0.977 0.456 -0.270 0.171 -0.108 0.066 -0.039 0.021 -0.011)))
	      (snd-display "dsp.scm df: ~A" v)))
	(set! b (make-differentiator 20))
	(map-channel (lambda (y) (fir-filter b y)))
	(let ((sp (rough-spectrum ind)))
	  (if (not (mus-arrays-equal? sp #r(0.004 0.027 0.075 0.147 0.242 0.362 0.506 0.674 0.864 1.000)))
	      (snd-display "dsp df rough spectrum: ~A" sp)))
	(undo))
      
      (let ((b (make-iir-high-pass-2 440.0)))
	(let ((v (make-float-vector 10)))
	  (let ((d (make-delay 1)))
	    (delay d (filter b 1.0))
	    (fill-float-vector v (delay d (filter b 0.0))))
	  (if (not (mus-arrays-equal? v #r(0.915 -0.162 -0.146 -0.131 -0.117 -0.103 -0.090 -0.078 -0.066 -0.056)))
	      (snd-display "iir-2 high: ~A" v)))
	(set! b (make-iir-high-pass-2 1000.0))
	(map-channel (lambda (y) (filter b y)))
	(let ((sp (rough-spectrum ind)))
	  (if (not (or (mus-arrays-equal? sp #r(0.150 0.833 0.980 0.994 0.997 0.998 0.999 0.998 0.997 1.000))
		       (mus-arrays-equal? sp #r(0.150 0.833 0.981 0.995 0.998 0.999 1.000 1.000 0.998 0.997))))
	      (snd-display "iir-2 hp rough spectrum: ~A" sp)))
	(undo))
      
      (let ((b (make-iir-low-pass-2 440.0)))
	(let ((v (make-float-vector 10)))
	  (let ((d (make-delay 1)))
	    (delay d (filter b 1.0))
	    (fill-float-vector v (delay d (filter b 0.0))))
	  (if (not (mus-arrays-equal? v #r(0.004 0.014 0.026 0.035 0.043 0.049 0.053 0.055 0.057 0.057)))
	      (snd-display "iir-2 low: ~A" v)))
	(set! b (make-iir-low-pass-2 1000.0))
	(map-channel (lambda (y) (filter b y)))
	(let ((sp (rough-spectrum ind)))
	  (if (not (mus-arrays-equal? sp #r(1.000 0.212 0.024 0.005 0.001 0.000 0.000 0.000 0.000 0.000)))
	      (snd-display "iir-2 lp rough spectrum: ~A" sp)))
	(undo))
      
      (let ((b (make-iir-band-pass-2 440.0 490.0)))
	(let ((v (make-float-vector 10)))
	  (let ((d (make-delay 1)))
	    (delay d (filter b 1.0))
	    (fill-float-vector v (delay d (filter b 0.0))))
	  (if (not (mus-arrays-equal? v #r(0.007 0.014 0.013 0.013 0.012 0.010 0.009 0.008 0.006 0.004)))
	      (snd-display "iir bp-2 bandpass: ~A" v)))
	(set! b (make-iir-band-pass-2 1000.0 1500.0))
	(map-channel (lambda (y) (filter b y)))
	(let ((sp (rough-spectrum ind)))
	  (if (not (mus-arrays-equal? sp #r(0.239 1.000 0.117 0.041 0.019 0.010 0.005 0.003 0.001 0.000)))
	      (snd-display "iir bp-2 rough spectrum: ~A" sp)))
	(undo))
      
      (let ((b (make-iir-band-stop-2 440.0 500.0)))
	(let ((v (make-float-vector 10)))
	  (let ((d (make-delay 1)))
	    (delay d (filter b 1.0))
	    (fill-float-vector v (delay d (filter b 0.0))))
	  (if (not (mus-arrays-equal? v #r(0.992 -0.017 -0.016 -0.015 -0.014 -0.012 -0.011 -0.009 -0.007 -0.005)))
	      (snd-display "iir-2 bandstop: ~A" v)))
	(set! b (make-iir-band-stop-2 1000.0 1500.0))
	(map-channel (lambda (y) (filter b y)))
	(let ((sp (rough-spectrum ind)))
	  (if (not (or (mus-arrays-equal? sp #r(0.836 0.525 0.943 0.979 0.989 0.994 0.997 0.997 0.997 1.000))
		       (mus-arrays-equal? sp #r(0.838 0.527 0.945 0.981 0.991 0.996 0.999 1.000 0.999 0.998))))
	      (snd-display "iir bs-2 rough spectrum: ~A" sp)))
	(undo))
      
      (let ((b (make-butter-hp 4 440.0)))
	(let ((v (make-float-vector 10)))
	  (let ((d (make-delay 1)))
	    (delay d (filter b 1.0))
	    (fill-float-vector v (delay d (filter b 0.0))))
	  (if (not (or (mus-arrays-equal? v #r(0.725 -0.466 -0.315 -0.196 -0.104 -0.036 0.014 0.047 0.0685 0.0775))
		       (mus-arrays-equal? v #r(0.725 -0.466 -0.315 -0.196 -0.104 -0.035 0.015 0.049 0.070 0.081))
		       (mus-arrays-equal? v #r(0.725 -0.466 -0.315 -0.196 -0.104 -0.035 0.014 0.049 0.069 0.079))))
	      (snd-display "butter hp: ~A" v)))
	(set! b (make-butter-hp 4 1000.0))
	(map-channel (lambda (y) (filter b y)))
	(let ((sp (rough-spectrum ind)))
	  (if (not (or (mus-arrays-equal? sp #r(0.0505 0.982 1.000 1.000 0.998 0.998 0.999 0.998 0.996 0.999))
		       (mus-arrays-equal? sp #r(0.051 0.982 1.000 1.000 0.998 0.998 0.998 0.999 0.997 0.995))
		       (mus-arrays-equal? sp #r(0.051 0.991 1.000 1.000 0.998 0.998 0.999 0.999 0.997 0.995))
		       (mus-arrays-equal? sp #r(0.045 0.970 1.000 1.000 0.998 0.998 0.999 0.999 0.997 0.995))
		       (mus-arrays-equal? sp #r(0.052 0.971 1.000 1.000 0.998 0.998 0.999 0.999 0.997 0.995))))
	      (snd-display "bhp rough spectrum: ~A" sp)))
	(undo))
      
      (let ((b (make-butter-lp 4 440.0)))
	(let ((v (make-float-vector 10)))
	  (let ((d (make-delay 1)))
	    (delay d (filter b 1.0))
	    (fill-float-vector v (delay d (filter b 0.0))))
	  (if (not (mus-arrays-equal? v (make-float-vector 10)))
	      (snd-display "butter lp: ~A" v)))
	(set! b (make-butter-lp 4 1000.0))
	(map-channel (lambda (y) (filter b y)))
	(let ((sp (rough-spectrum ind)))
	  (if (not (or (mus-arrays-equal? sp #r(1.000 0.035 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000))
		       (mus-arrays-equal? sp #r(1.000 0.038 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000))))
	      (snd-display "blp rough spectrum: ~A" sp)))
	(undo))
      
      (let ((b (make-butter-bp 4 440.0 500.0)))
	(let ((v (make-float-vector 10)))
	  (let ((d (make-delay 1)))
	    (delay d (filter b 1.0))
	    (fill-float-vector v (delay d (filter b 0.0))))
	  (if (not (mus-arrays-equal? v (make-float-vector 10)))
	      (snd-display "butter bp: ~A" v)))
	(set! b (make-butter-bp 4 1000.0 1500.0))
	(map-channel (lambda (y) (filter b y)))
	(undo))
      
      (let ((b (make-butter-bs 4 440.0 500.0)))
	(let ((v (make-float-vector 10)))
	  (let ((d (make-delay 1)))
	    (delay d (filter b 1.0))
	    (fill-float-vector v (delay d (filter b 0.0))))
	  (if (not (or (mus-arrays-equal? v #r(0.978 -0.043 -0.041 -0.038 -0.035 -0.031 -0.026 -0.0225 -0.015 -0.0085))
		       (mus-arrays-equal? v #r(0.978 -0.043 -0.041 -0.038 -0.035 -0.031 -0.027 -0.022 -0.017 -0.011))
		       (mus-arrays-equal? v #r(0.978 -0.043 -0.041 -0.038 -0.035 -0.031 -0.027 -0.021 -0.014 -0.011))))
	      (snd-display "butter bs: ~A" v)))
	(set! b (make-butter-bs 4 1000.0 1500.0))
	(map-channel (lambda (y) (filter b y)))
	(undo))
      
      (revert-sound)

    (let ((size 256))
      (let ((x0 (make-float-vector size))	   
	    (x1 (make-float-vector size))	   
	    (x2 (make-float-vector size))
	    (dur 10000))
	(do ((i 0 (+ i 1)))
	    ((= i 12))
	  (let ((val (sin (/ (* 2 pi i) 12.0))))
	    (set! (x1 (- (+ i (/ size 4)) 6)) val)))
	(let ((data (make-float-vector dur))
	      (amp 0.1000))
	  (let ((recompute-samps 30) ;just a quick guess
		(gen1 (make-table-lookup 440.0 :wave x1))
		(gen2 (make-table-lookup 440.0 :wave x2)))
	    (do ((i 0 (+ i 1))
		 (k 0.0)
		 (mass 1.0000)
		 (xspring 0.1000)
		 (damp 0.0000)
		 (kincr (/ 1.0 recompute-samps)))
		((= i dur))
	      (if (>= k 1.0)
		  (begin
		    (set! k 0.0)
		    (vibrating-uniform-circular-string size x0 x1 x2 mass xspring damp))
		  (set! k (+ k kincr)))
	      (let ((g1 (table-lookup gen1))
		    (g2 (table-lookup gen2)))
		(set! (data i) (+ g2 (* k (- g1 g2)))))))
	  (float-vector-scale! data (/ amp (float-vector-peak data)))
	  (float-vector->channel data 0 dur))))
      
      (close-sound ind))
    
    (let ((gen (make-sawtooth-wave 440.0)))
      (print-and-check gen 
		       "sawtooth-wave"
		       "sawtooth-wave freq: 440.000Hz, phase: 3.142, amp: 1.000")
      (let ((v0 (make-float-vector 10)))
	(do ((i 0 (+ i 1)))
	    ((= i 10))
	  (set! (v0 i) (sawtooth-wave gen 0.0)))
	(let ((gen1 (make-sawtooth-wave 440.0))
	      (v1 (make-float-vector 10)))
	  (fill-float-vector v1 (if (sawtooth-wave? gen1) (sawtooth-wave gen1 0.0) -1.0))
	  (if (not (mus-arrays-equal? v0 v1)) (snd-display "map sawtooth: ~A ~A" v0 v1)))
	(if (not (sawtooth-wave? gen)) (snd-display "~A not sawtooth-wave?" gen))
	(if (fneq (mus-phase gen) 4.39538) (snd-display "sawtooth-wave phase: ~F?" (mus-phase gen))) ;starts at pi
	(if (fneq (mus-frequency gen) 440.0) (snd-display "sawtooth-wave frequency: ~F?" (mus-frequency gen)))
	(set! (mus-frequency gen) 100.0)
	(if (fneq (mus-frequency gen) 100.0) (snd-display "set! sawtooth-wave frequency: ~F?" (mus-frequency gen)))
	(if (fneq (mus-scaler gen) 1.0) (snd-display "sawtooth-wave scaler: ~F?" (mus-scaler gen)))
	(set! (mus-scaler gen) 0.5)
	(if (fneq (mus-scaler gen) 0.5) (snd-display "set! sawtooth-wave scaler: ~F?" (mus-scaler gen)))
	(if (or (fneq (v0 1) 0.04) (fneq (v0 8) .319)) (snd-display "sawtooth-wave output: ~A" v0))))
    
    (test-gen-equal (make-sawtooth-wave 440.0) (make-sawtooth-wave 440.0) (make-sawtooth-wave 120.0))
    (test-gen-equal (make-sawtooth-wave 440.0) (make-sawtooth-wave 440.0) (make-sawtooth-wave 440.0 1.0 1.0))
    (test-gen-equal (make-sawtooth-wave 440.0) (make-sawtooth-wave 440.0) (make-sawtooth-wave 440.0 0.5))
    
    (do ((gen1 (make-sawtooth-wave 100.0))
	 (gen2 (make-sawtooth-wave -100.0))
	 (mx 0.0)
	 (i 0 (+ i 1)))
	((= i 100)
	 (if (fneq mx 0.0)
	     (snd-display "sawtooth +-: ~A" mx)))
      (set! mx (max mx (abs (+ (gen1) (gen2))))))
    
    (let ((gen (make-square-wave 440.0)))
      (print-and-check gen 
		       "square-wave"
		       "square-wave freq: 440.000Hz, phase: 0.000, amp: 1.000")
      (let ((v0 (make-float-vector 10)))
	(do ((i 0 (+ i 1)))
	    ((= i 10))
	  (set! (v0 i) (square-wave gen 0.0)))
	(let ((w 1.0)
	      (gen1 (make-square-wave 440.0))
	      (v1 (make-float-vector 10)))
	  (fill-float-vector v1 (begin
				  (set! w (mus-width gen1))
				  (if (square-wave? gen1) (square-wave gen1 0.0) -1.0)))
	  (if (fneq w 0.5) (snd-display "mus-width opt: ~A" w))
	  (if (not (mus-arrays-equal? v0 v1)) (snd-display "map square-wave: ~A ~A" v0 v1)))
	(if (not (square-wave? gen)) (snd-display "~A not square-wave?" gen))
	(if (fneq (mus-phase gen) 1.253787) (snd-display "square-wave phase: ~F?" (mus-phase gen)))
	(if (fneq (mus-frequency gen) 440.0) (snd-display "square-wave frequency: ~F?" (mus-frequency gen)))
	(if (fneq (mus-scaler gen) 1.0) (snd-display "square-wave scaler: ~F?" (mus-scaler gen)))
	(set! (mus-scaler gen) 0.5)
	(if (fneq (mus-scaler gen) 0.5) (snd-display "set! square-wave scaler: ~F?" (mus-scaler gen)))
	(if (fneq (mus-width gen) 0.5) (snd-display "square-wave width: ~A" (mus-width gen)))
	(set! (mus-width gen) 0.75)
	(if (fneq (mus-width gen) 0.75) (snd-display "set! square-wave width: ~A" (mus-width gen)))
	(if (or (fneq (v0 1) 1.0) (fneq (v0 8) 1.0)) (snd-display "square-wave output: ~A" v0))))
    
    (test-gen-equal (make-square-wave 440.0) (make-square-wave 440.0) (make-square-wave 120.0))
    (test-gen-equal (make-square-wave 440.0) (make-square-wave 440.0) (make-square-wave 440.0 1.0 1.0))
    (test-gen-equal (make-square-wave 440.0) (make-square-wave 440.0) (make-square-wave 440.0 0.5))
    
    (let-temporarily ((*clm-srate* 500.0))
      (do ((gen (make-square-wave 100.0 -0.5 (* pi 0.5)))
	   (v0 (make-float-vector 20))
	   (i 0 (+ i 1)))
	  ((= i 20)
	   (if (not (mus-arrays-equal? v0 #r(-0.5 -0.5 0.0 0.0 -0.5 -0.5 -0.5 0.0 0.0 -0.5 -0.5 -0.5 0.0 0.0 -0.5 -0.5 -0.5 0.0 0.0 -0.5)))
	       (snd-display "square-wave -.5: ~A " v0)))
	(set! (v0 i) (gen))))
    
    (let ((gen (make-triangle-wave 440.0))
	  (v0 (make-float-vector 10)))
      (print-and-check gen 
		       "triangle-wave"
		       "triangle-wave freq: 440.000Hz, phase: 0.000, amp: 1.000")
      (do ((i 0 (+ i 1)))
	  ((= i 10))
	(set! (v0 i) (triangle-wave gen 0.0)))
      (let ((gen2 (make-triangle-wave 440.0))
	    (v1 (make-float-vector 10)))
	(fill-float-vector v1 (if (triangle-wave? gen2) (triangle-wave gen2 0.0) -1.0))
	(if (not (mus-arrays-equal? v0 v1)) (snd-display "map triangle-wave: ~A ~A" v0 v1)))
      (if (not (triangle-wave? gen)) (snd-display "~A not triangle-wave?" gen))
      (if (fneq (mus-phase gen) 1.253787) (snd-display "triangle-wave phase: ~F?" (mus-phase gen)))
      (let ((gen1 (mus-phase (make-triangle-wave 440.0 1.0 pi))))
	(if (fneq gen1 pi) (snd-display "init triangle-wave phase: ~F?" gen1)))
      (if (fneq (mus-frequency gen) 440.0) (snd-display "triangle-wave frequency: ~F?" (mus-frequency gen)))
      (if (fneq (mus-scaler gen) 1.0) (snd-display "triangle-wave scaler: ~F?" (mus-scaler gen)))
      (set! (mus-scaler gen) 0.5)
      (if (fneq (mus-scaler gen) 0.5) (snd-display "set! triangle-wave scaler: ~F?" (mus-scaler gen)))
      (if (or (fneq (v0 1) 0.080) (fneq (v0 8) 0.639)) (snd-display "triangle-wave output: ~A" v0)))
    
    (do ((gen1 (make-triangle-wave 100.0))
	 (gen2 (make-triangle-wave -100.0))
	 (mx 0.0)
	 (i 0 (+ i 1)))
	((= i 100)
	 (if (fneq mx 0.0)
	     (snd-display "triangle +-: ~A" mx)))
      (set! mx (max mx (abs (+ (gen1) (gen2))))))
    
    (test-gen-equal (make-triangle-wave 440.0) (make-triangle-wave 440.0) (make-triangle-wave 120.0))
    (test-gen-equal (make-triangle-wave 440.0) (make-triangle-wave 440.0) (make-triangle-wave 440.0 1.0 1.0))
    (test-gen-equal (make-triangle-wave 440.0) (make-triangle-wave 440.0) (make-triangle-wave 440.0 0.5))
    
    (let ((gen (make-pulse-train 440.0))
	  (v0 (make-float-vector 10)))
      (print-and-check gen 
		       "pulse-train"
		       "pulse-train freq: 440.000Hz, phase: 0.000, amp: 1.000")
      (do ((i 0 (+ i 1)))
	  ((= i 10))
	(set! (v0 i) (pulse-train gen 0.0)))
      (let ((gen1 (make-pulse-train 440.0))
	    (v1 (make-float-vector 10)))
	(fill-float-vector v1 (if (pulse-train? gen1) (pulse-train gen1 0.0) -1.0))
	(if (not (mus-arrays-equal? v0 v1)) (snd-display "map pulse-train: ~A ~A" v0 v1)))
      (if (not (pulse-train? gen)) (snd-display "~A not pulse-train?" gen))
      (if (fneq (mus-phase gen) 1.253787) (snd-display "pulse-train phase: ~F?" (mus-phase gen)))
      (if (fneq (mus-frequency gen) 440.0) (snd-display "pulse-train frequency: ~F?" (mus-frequency gen)))
      (if (fneq (mus-scaler gen) 1.0) (snd-display "pulse-train scaler: ~F?" (mus-scaler gen)))
      (set! (mus-scaler gen) 0.5)
      (if (fneq (mus-scaler gen) 0.5) (snd-display "set! pulse-train scaler: ~F?" (mus-scaler gen)))
      (if (or (fneq (v0 0) 1.0) (fneq (v0 8) 0.0)) (snd-display "pulse-train output: ~A" v0)))
    
    (test-gen-equal (make-pulse-train 440.0) (make-pulse-train 440.0) (make-pulse-train 120.0))
    (test-gen-equal (make-pulse-train 440.0) (make-pulse-train 440.0) (make-pulse-train 440.0 1.0 1.0))
    (test-gen-equal (make-pulse-train 440.0) (make-pulse-train 440.0) (make-pulse-train 440.0 0.5))
    
    (let-temporarily ((*clm-srate* 500.0))
      (do ((gen (make-pulse-train 100.0 -0.5 (* pi 0.5)))
	   (v0 (make-float-vector 20))
	   (i 0 (+ i 1)))
	  ((= i 20)
	   (if (not (mus-arrays-equal? v0 #r(0.0 0.0 0.0 0.0 -0.5 0.0 0.0 0.0 0.0 -0.5 0.0 0.0 0.0 0.0 -0.5 0.0 0.0 0.0 0.0 -0.5)))
	       (snd-display "pulse-train -.5: ~A " v0)))
	(set! (v0 i) (gen))))
    
    (let ((gen (make-two-pole 1200.0 .1)))
      (if (not (two-pole? gen)) (snd-display "~A not 2-polar?" gen))
      (if (not (= (mus-order gen) 2)) (snd-display "2-polar order: ~D?" (mus-order gen)))
      (if (fneq (mus-xcoeff gen 0) 1.0) (snd-display "2-polar a0: ~F?" (mus-xcoeff gen 0)))
      (if (fneq (mus-ycoeff gen 1) -.188) (snd-display "2-polar b1: ~F?" (mus-ycoeff gen 1)))
      (if (fneq (mus-ycoeff gen 2) .01) (snd-display "2-polar b2: ~F?" (mus-ycoeff gen 2)))
      (if (fneq (mus-frequency gen) 1200.0) (snd-display "freq 2-polar: ~A" (mus-frequency gen)))
      (if (fneq (mus-scaler gen) 0.1) (snd-display "scaler 2-polar: ~A" (mus-scaler gen))))
    
    (let ((gen (make-two-pole :frequency 1200.0 :radius .1)))
      (if (not (two-pole? gen)) (snd-display "~A not f2-polar?" gen))
      (if (not (= (mus-order gen) 2)) (snd-display "f2-polar order: ~D?" (mus-order gen)))
      (if (fneq (mus-xcoeff gen 0) 1.0) (snd-display "f2-polar a0: ~F?" (mus-xcoeff gen 0)))
      (if (fneq (mus-ycoeff gen 1) -.188) (snd-display "f2-polar b1: ~F?" (mus-ycoeff gen 1)))
      (if (fneq (mus-ycoeff gen 2) .01) (snd-display "f2-polar b2: ~F?" (mus-ycoeff gen 2)))
      (if (fneq (mus-frequency gen) 1200.0) (snd-display "freq f2-polar: ~A" (mus-frequency gen)))
      (if (fneq (mus-scaler gen) 0.1) (snd-display "scaler f2-polar: ~A" (mus-scaler gen))))
    
    (let ((gen (make-two-zero :radius .1 :frequency 1200.0)))
      (if (not (two-zero? gen)) (snd-display "~A not 2-zp?" gen))
      (if (not (= (mus-order gen) 2)) (snd-display "2-zp order: ~D?" (mus-order gen)))
      (if (fneq (mus-xcoeff gen 0) 1.0) (snd-display "2-zp a0: ~F?" (mus-xcoeff gen 0)))
      (if (fneq (mus-xcoeff gen 1) -.188) (snd-display "2-zp a1: ~F?" (mus-xcoeff gen 1)))
      (if (fneq (mus-xcoeff gen 2) .01) (snd-display "2-zp a2: ~F?" (mus-xcoeff gen 2)))
      (if (fneq (mus-frequency gen) 1200.0) (snd-display "freq 2-zp: ~A" (mus-frequency gen)))
      (if (fneq (mus-scaler gen) 0.1) (snd-display "scaler 2-zp: ~A" (mus-scaler gen))))
    
    (let ((gen (make-two-zero 1200.0 .1)))
      (if (not (two-zero? gen)) (snd-display "~A not f2-zp?" gen))
      (if (not (= (mus-order gen) 2)) (snd-display "f2-zp order: ~D?" (mus-order gen)))
      (if (fneq (mus-xcoeff gen 0) 1.0) (snd-display "f2-zp a0: ~F?" (mus-xcoeff gen 0)))
      (if (fneq (mus-xcoeff gen 1) -.188) (snd-display "f2-zp a1: ~F?" (mus-xcoeff gen 1)))
      (if (fneq (mus-xcoeff gen 2) .01) (snd-display "f2-zp a2: ~F?" (mus-xcoeff gen 2)))
      (if (fneq (mus-frequency gen) 1200.0) (snd-display "freq f2-zp: ~A" (mus-frequency gen)))
      (if (fneq (mus-scaler gen) 0.1) (snd-display "scaler f2-zp: ~A" (mus-scaler gen))))
    
    (let ((gen (make-formant 1200.0 0.9))
	  (v0 (make-float-vector 10)))
      (print-and-check gen 
		       "formant"
		       "formant frequency: 1200.000, radius: 0.900")
      (set! (v0 0) (formant gen 1.0))
      (do ((i 1 (+ i 1)))
	  ((= i 10))
	(set! (v0 i) (formant gen 0.0)))
      (let ((gen1 (make-formant 1200.0 0.9))
	    (v1 (make-float-vector 10))
	    (inp 1.0))
	(fill-float-vector v1 (let ((val (if (formant? gen1) (formant gen1 inp) -1.0)))
				(set! inp 0.0)
				val))
	(if (not (mus-arrays-equal? v0 v1)) (snd-display "map formant: ~A ~A" v0 v1)))
      (if (not (formant? gen)) (snd-display "~A not formant?" gen))
      (if (not (= (mus-order gen) 2)) (snd-display "formant order: ~D?" (mus-order gen)))
      (if (fneq (mus-frequency gen) 1200.0) (snd-display "formant frequency: ~F?" (mus-frequency gen)))
      (if (or (fneq (v0 0) .095) (fneq (v0 1) .161)) (snd-display "formant output: ~A" v0))
      (if (fneq (mus-scaler gen) 0.9) (snd-display "formant gain: ~F?" (mus-scaler gen)))
      
      (set! (mus-scaler gen) 2.0)
      (if (fneq (mus-scaler gen) 2.0) (snd-display "formant set gain: ~F?" (mus-scaler gen))))
    
    (test-gen-equal (let ((f1 (make-formant 1200.0 0.9))) (formant f1 1.0) f1)
		    (let ((f2 (make-formant 1200.0 0.9))) (formant f2 1.0) f2)
		    (let ((f3 (make-formant 600.0 0.9))) (formant f3 1.0) f3))
    (test-gen-equal (let ((f1 (make-formant 1200.0 0.9))) (formant f1 1.0) f1)
		    (let ((f2 (make-formant 1200.0 0.9))) (formant f2 1.0) f2)
		    (let ((f3 (make-formant 1200.0 0.99))) (formant f3 1.0) f3))
    (test-gen-equal (let ((f1 (make-formant 1200.0 0.9))) (formant f1 1.0) f1)
		    (let ((f2 (make-formant 1200.0 0.9))) (formant f2 1.0) f2)
		    (let ((f3 (make-formant 1200.0 0.5))) (formant f3 1.0) f3))
    
    (let ((fs (make-vector 2))
	  (f0 (make-formant 1000.0 .1))
	  (f1 (make-formant 100.0 .2))
	  (amps (make-float-vector 2 1.0))
	  (v0 (make-float-vector 10))
	  (v1 (make-float-vector 10)))
      (set! (fs 0) (make-formant 1000.0 .1))
      (set! (fs 1) (make-formant 100.0 .2))
      (set! fs (make-formant-bank fs amps))
      (set! (amps 0) 0.5)
      (set! (amps 1) 0.25)
      (do ((val 1.0 0.0)
	   (i 0 (+ i 1)))
	  ((= i 10))
	(set! (v0 i) (+ (* 0.5 (formant f0 val)) (* 0.25 (formant f1 val))))
	(set! (v1 i) (formant-bank fs val)))
      (if (not (mus-arrays-equal? v0 v1)) (snd-display "formant bank 1: ~A ~A" v0 v1)))
    
    (let ((fs (make-vector 2))
	  (amps (make-float-vector 2 1.0))
	  (v (make-float-vector 5)))
      (set! (fs 0) (make-formant 1000.0 .1))
      (set! (fs 1) (make-formant 100.0 .2))
      (set! fs (make-formant-bank fs amps))
      (set! (amps 0) 0.5)
      (set! (amps 1) 0.25)
      (let ((val 1.0))
	(fill-float-vector v (let ((res (formant-bank fs val))) (set! val 0.0) res))
	(if (not (mus-arrays-equal? v #r(0.368 0.095 -0.346 -0.091 -0.020))) (snd-display "run formant-bank: ~A" v))))
    
    (let ((ob (open-sound "oboe.snd")))
      ;; test courtesy of Anders Vinjar
      (map-channel (let ((frek 300)
			 (amp 0.1000)
			 (R 0.0000)
			 (gain 30.0000)
			 (frek-env '(0 100 1 4000.0))
			 (R-env '(0 0.99 1 0.9)))
		     (let ((filt (make-formant frek R))
			   (fe (make-env :envelope frek-env :length (framples) :offset frek))
			   (re (make-env :envelope R-env :length (framples) :offset R)))
		       (lambda (y)
			 (let ((outval (* gain (formant filt (* amp y)))))
			   (mus-set-formant-radius-and-frequency filt (env re) (env fe))
			   outval)))))
      (play ob :wait #t)  ;; should sound like "whyieee?"
      (close-sound ob))
    
    (let ((gen (make-firmant 1200.0 0.9))
	  (v0 (make-float-vector 10)))
      (print-and-check gen 
		       "firmant"
		       "firmant frequency: 1200.000, radius: 0.900")
      (set! (v0 0) (firmant gen 1.0))
      (do ((i 1 (+ i 1)))
	  ((= i 10))
	(set! (v0 i) (firmant gen 0.0)))
      (let ((inp 1.0)
	    (gen1 (make-firmant 1200.0 0.9))
	    (v1 (make-float-vector 10)))
	(fill-float-vector v1 (let ((val (if (firmant? gen1) (firmant gen1 inp) -1.0)))
				(set! inp 0.0)
				val))
	(if (not (mus-arrays-equal? v0 v1)) (snd-display "map firmant: ~A ~A" v0 v1)))
      (if (not (firmant? gen)) (snd-display "~A not firmant?" gen))
      (if (not (= (mus-order gen) 2)) (snd-display "firmant order: ~D?" (mus-order gen)))
      (if (fneq (mus-frequency gen) 1200.0) (snd-display "firmant frequency: ~F?" (mus-frequency gen)))
      (if (or (fneq (v0 0) .058) (fneq (v0 1) .099)) (snd-display "firmant output: ~A" v0))
      (if (fneq (mus-scaler gen) 0.9) (snd-display "firmant gain: ~F?" (mus-scaler gen)))
      
      (set! (mus-scaler gen) .20)
      (if (fneq (mus-scaler gen) .20) (snd-display "firmant set gain: ~F?" (mus-scaler gen))))
    
    (test-gen-equal (let ((f1 (make-firmant 1200.0 0.9))) (firmant f1 1.0) f1)
		    (let ((f2 (make-firmant 1200.0 0.9))) (firmant f2 1.0) f2)
		    (let ((f3 (make-firmant 600.0 0.9))) (firmant f3 1.0) f3))
    (test-gen-equal (let ((f1 (make-firmant 1200.0 0.9))) (firmant f1 1.0) f1)
		    (let ((f2 (make-firmant 1200.0 0.9))) (firmant f2 1.0) f2)
		    (let ((f3 (make-firmant 1200.0 0.99))) (firmant f3 1.0) f3))
    (test-gen-equal (let ((f1 (make-firmant 1200.0 0.9))) (firmant f1 1.0) f1)
		    (let ((f2 (make-firmant 1200.0 0.9))) (firmant f2 1.0) f2)
		    (let ((f3 (make-firmant 1200.0 0.5))) (firmant f3 1.0) f3))
    
    (let ((gen (make-fft-window hamming-window 16)))
      (if (not (mus-arrays-equal? gen #r(0.080 0.115 0.215 0.364 0.540 0.716 0.865 1.000 1.000 0.865 0.716 0.540 0.364 0.215 0.115 0.080)))
	  (snd-display "hamming window: ~A" gen)))
    (let ((gen (make-fft-window rectangular-window 16)))
      (if (not (mus-arrays-equal? gen (make-float-vector 16 1.0)))
	  (snd-display "rectangular window: ~A" gen)))
    (let ((gen (make-fft-window hann-window 16)))
      (if (not (mus-arrays-equal? gen #r(0.000 0.038 0.146 0.309 0.500 0.691 0.854 1.000 1.000 0.854 0.691 0.500 0.309 0.146 0.038 0.000)))
	  (snd-display "hann window: ~A" gen)))
    (let ((gen (make-fft-window welch-window 16)))
      (if (not (mus-arrays-equal? gen #r(0.000 0.234 0.438 0.609 0.750 0.859 0.938 1.000 1.000 0.938 0.859 0.750 0.609 0.438 0.234 0.000)))
	  (snd-display "welch window: ~A" gen)))
    (let ((gen (make-fft-window connes-window 16)))
      (if (not (mus-arrays-equal? gen #r(0.000 0.055 0.191 0.371 0.562 0.739 0.879 1.000 1.000 0.879 0.739 0.562 0.371 0.191 0.055 0.000)))
	  (snd-display "connes window: ~A" gen)))
    (let ((gen (make-fft-window parzen-window 16)))
      (if (not (mus-arrays-equal? gen #r(0.000 0.125 0.250 0.375 0.500 0.625 0.750 1.000 1.000 0.750 0.625 0.500 0.375 0.250 0.125 0.000)))
	  (snd-display "parzen window: ~A" gen)))
    (let ((gen (make-fft-window bartlett-window 16)))
      (if (not (mus-arrays-equal? gen #r(0.000 0.125 0.250 0.375 0.500 0.625 0.750 1.000 1.000 0.750 0.625 0.500 0.375 0.250 0.125 0.000)))
	  (snd-display "bartlett window: ~A" gen)))
    (let ((gen (make-fft-window blackman2-window 16)))
      (if (not (mus-arrays-equal? gen #r(0.005 0.020 0.071 0.177 0.344 0.558 0.775 1.000 1.000 0.775 0.558 0.344 0.177 0.071 0.020 0.005)))
	  (snd-display "blackman2 window: ~A" gen)))
    (let ((gen (make-fft-window blackman3-window 16)))
      (if (not (mus-arrays-equal? gen #r(0.000 0.003 0.022 0.083 0.217 0.435 0.696 1.000 1.000 0.696 0.435 0.217 0.083 0.022 0.003 0.000)))
	  (snd-display "blackman3 window: ~A" gen)))
    (let ((gen (make-fft-window blackman4-window 16)))
      (if (not (mus-arrays-equal? gen #r(0.002 0.002 0.003 0.017 0.084 0.263 0.562 1.000 1.000 0.562 0.263 0.084 0.017 0.003 0.002 0.002)))
	  (snd-display "blackman4 window: ~A" gen)))
    
    (let ((gen (make-fft-window blackman5-window 16)))
      (if (not (mus-arrays-equal? gen #r(0.000 0.000 0.003 0.022 0.097 0.280 0.574 1.000 1.000 0.574 0.280 0.097 0.022 0.003 0.000 0.000)))
	  (snd-display "blackman5 window: ~A" gen)))
    (let ((gen (make-fft-window blackman6-window 16)))
      (if (not (mus-arrays-equal? gen #r(0.000 0.000 0.001 0.011 0.064 0.223 0.520 1.000 1.000 0.520 0.223 0.064 0.011 0.001 0.000 0.000)))
	  (snd-display "blackman6 window: ~A" gen)))
    (let ((gen (make-fft-window blackman7-window 16)))
      (if (not (mus-arrays-equal? gen #r(0.000 0.000 0.000 0.006 0.042 0.177 0.471 1.000 1.000 0.471 0.177 0.042 0.006 0.000 0.000 0.000)))
	  (snd-display "blackman7 window: ~A" gen)))
    (let ((gen (make-fft-window blackman8-window 16)))
      (if (not (mus-arrays-equal? gen #r(0.000 0.000 0.000 0.003 0.028 0.141 0.426 1.000 1.000 0.426 0.141 0.028 0.003 0.000 0.000 0.000)))
	  (snd-display "blackman8 window: ~A" gen)))
    (let ((gen (make-fft-window blackman9-window 16)))
      (if (not (mus-arrays-equal? gen #r(0.000 0.000 0.000 0.001 0.018 0.112 0.385 1.000 1.000 0.385 0.112 0.018 0.001 0.000 0.000 -0.000)))
	  (snd-display "blackman9 window: ~A" gen)))
    (let ((gen (make-fft-window blackman10-window 16)))
      (if (not (mus-arrays-equal? gen #r(0.000 0.000 0.000 0.001 0.012 0.089 0.349 1.000 1.000 0.349 0.089 0.012 0.001 0.000 0.000 -0.000)))
	  (snd-display "blackman10 window: ~A" gen)))
    (let ((gen (make-fft-window rv2-window 16)))
      (if (not (mus-arrays-equal? gen #r(0.000 0.001 0.021 0.095 0.250 0.478 0.729 1.000 1.000 0.729 0.478 0.250 0.095 0.021 0.001 0.000)))
	  (snd-display "rv2 window: ~A" gen)))
    (let ((gen (make-fft-window rv3-window 16)))
      (if (not (mus-arrays-equal? gen #r(0.000 0.000 0.003 0.029 0.125 0.330 0.622 1.000 1.000 0.622 0.330 0.125 0.029 0.003 0.000 0.000)))
	  (snd-display "rv3 window: ~A" gen)))
    (let ((gen (make-fft-window rv4-window 16)))
      (if (not (mus-arrays-equal? gen #r(0.000 0.000 0.000 0.009 0.062 0.228 0.531 1.000 1.000 0.531 0.228 0.062 0.009 0.000 0.000 0.000)))
	  (snd-display "rv4 window: ~A" gen)))
    
    (let ((gen (make-fft-window exponential-window 16)))
      (if (not (mus-arrays-equal? gen #r(0.000 0.087 0.181 0.283 0.394 0.515 0.646 0.944 0.944 0.646 0.515 0.394 0.283 0.181 0.087 0.000)))
	  (snd-display "exponential window: ~A" gen)))
    (let ((gen (make-fft-window riemann-window 16)))
      (if (not (mus-arrays-equal? gen #r(0.000 0.139 0.300 0.471 0.637 0.784 0.900 1.000 1.000 0.900 0.784 0.637 0.471 0.300 0.139 0.000)))
	  (snd-display "riemann window: ~A" gen)))
    (let ((gen (make-fft-window kaiser-window 16 2.5)))
      (if (not (mus-arrays-equal? gen #r(0.304 0.426 0.550 0.670 0.779 0.871 0.941 1.000 1.000 0.941 0.871 0.779 0.670 0.550 0.426 0.304)))
	  (snd-display "kaiser window: ~A" gen)))
    (let ((gen (make-fft-window cauchy-window 16 2.5)))
      (if (not (mus-arrays-equal? gen #r(0.138 0.173 0.221 0.291 0.390 0.532 0.719 1.000 1.000 0.719 0.532 0.390 0.291 0.221 0.173 0.138)))
	  (snd-display "cauchy window: ~A" gen)))
    (let ((gen (make-fft-window poisson-window 16 2.5)))
      (if (not (mus-arrays-equal? gen #r(0.082 0.112 0.153 0.210 0.287 0.392 0.535 1.000 1.000 0.535 0.392 0.287 0.210 0.153 0.112 0.082)))
	  (snd-display "poisson window: ~A" gen)))
    (let ((gen (make-fft-window gaussian-window 16 1.0)))
      (if (not (mus-arrays-equal? gen #r(0.607 0.682 0.755 0.823 0.882 0.932 0.969 1.000 1.000 0.969 0.932 0.882 0.823 0.755 0.682 0.607)))
	  (snd-display "gaussian window: ~A" gen)))
    (let ((gen (make-fft-window tukey-window 16)))
      (if (not (mus-arrays-equal? gen #r(0.000 0.038 0.146 0.309 0.500 0.691 0.854 1.000 1.000 0.854 0.691 0.500 0.309 0.146 0.038 0.000)))
	  (snd-display "tukey window: ~A" gen)))
    (let ((gen (make-fft-window hann-poisson-window 16)))
      (if (not (mus-arrays-equal? gen #r(0.000 0.038 0.146 0.309 0.500 0.691 0.854 1.000 1.000 0.854 0.691 0.500 0.309 0.146 0.038 0.000)))
	  (snd-display "tukey window: ~A" gen)))
    (let ((gen (make-fft-window bohman-window 16)))
      (if (not (mus-arrays-equal? gen #r(0.000 0.006 0.048 0.151 0.318 0.533 0.755 1.000 1.000 0.755 0.533 0.318 0.151 0.048 0.006 0.000)))
	  (snd-display "bohman window: ~A" gen)))
    
    (for-each
     (lambda (window-data)
       (let ((window (car window-data))
	     (func (caddr window-data))
	     (name (cadr window-data)))
	 (do ((v1 (make-fft-window window 16))
	      (v2 (make-float-vector 16))
	      (incr (/ (* 2 pi) 16.0))
	      (i 0 (+ i 1))
	      (j 15 (- j 1))
	      (ang 0.0))
	     ((> i 8) ; yikes -- even size + smallness = questionable code...
	      (if (not (mus-arrays-equal? v1 v2)) 
		  (snd-display "~A by hand:~%;  mus: ~A~%;  loc: ~A" name v1 v2)))
	   (let ((val (func ang)))
	     (set! (v2 i) val)
	     (set! (v2 j) val))
	   (set! ang (+ ang incr)))))
     (list 
      (list hann-window "hann" (lambda (ang) 
				 (- 0.5 
				    (* 0.5 (cos ang)))))
      
      (list rv2-window "rv2" (lambda (ang) 
			       (+ .375 
				  (* -0.5 (cos ang)) 
				  (* .125 (cos (* 2 ang))))))
      
      (list rv3-window "rv3" (lambda (ang) 
			       (+ (/ 10.0 32.0) 
				  (* (/ -15.0 32.0) (cos ang)) 
				  (* (/ 6.0 32.0) (cos (* 2 ang))) 
				  (* (/ -1.0 32.0) (cos (* 3 ang))))))
      
      (list rv4-window "rv4" (lambda (ang) 
			       (+ (/ 35.0 128.0)
				  (* (/ -56.0 128.0) (cos ang)) 
				  (* (/ 28.0 128.0) (cos (* 2 ang))) 
				  (* (/ -8.0 128.0) (cos (* 3 ang)))
				  (* (/ 1.0 128.0) (cos (* 4 ang))))))
      
      (list hamming-window "hamming" (lambda (ang)
				       (- 0.54
					  (* 0.46 (cos ang)))))
      
      (list blackman2-window "blackman2" (lambda (ang)
					   (+ 0.42323 
					      (* -0.49755 (cos ang)) 
					      (* 0.07922 (cos (* 2 ang))))))
      
      (list blackman3-window "blackman3" (lambda (ang)
					   (+ 0.35875 
					      (* -0.48829 (cos ang)) 
					      (* 0.14128 (cos (* 2 ang))) 
					      (* -0.01168 (cos (* 3 ang))))))
      
      (list blackman4-window "blackman4" (lambda (ang)
					   (+ 0.287333 
					      (* -0.44716 (cos ang))
					      (* 0.20844 (cos (* 2 ang)))
					      (* -0.05190 (cos (* 3 ang)))
					      (* 0.005149 (cos (* 4 ang))))))
      
      (list blackman5-window "blackman5" (lambda (ang)
					   (+ .293557 
					      (* -.451935 (cos ang))
					      (* .201416 (cos (* 2 ang)))
					      (* -.047926 (cos (* 3 ang)))
					      (* .00502619 (cos (* 4 ang)))
					      (* -.000137555 (cos (* 5 ang))))))
      
      (list blackman6-window "blackman6" (lambda (ang)
					   (+ .271220 
					      (* -.433444 (cos ang))
					      (* .218004 (cos (* 2 ang)))
					      (* -.065785 (cos (* 3 ang)))
					      (* .01076186 (cos (* 4 ang)))
					      (* -.000770012 (cos (* 5 ang)))
					      (* .0000136808 (cos (* 6 ang)))))) 
      
      (list blackman7-window "blackman7" (lambda (ang)
					   (+ .253317 
					      (* -.416327 (cos ang))
					      (* .228839 (cos (* 2 ang)))
					      (* -.081575 (cos (* 3 ang)))
					      (* .01773592 (cos (* 4 ang)))
					      (* -.002096702 (cos (* 5 ang)))
					      (* .0001067741 (cos (* 6 ang)))
					      (* -.0000012807(cos (* 7 ang))))))
      
      (list blackman8-window "blackman8" (lambda (ang)
					   (+ .238433 
					      (* -.400554 (cos ang))
					      (* .235824 (cos (* 2 ang)))
					      (* -.095279 (cos (* 3 ang)))
					      (* .02537395 (cos (* 4 ang)))
					      (* -.00415243  (cos (* 5 ang)))
					      (* .0003685604 (cos (* 6 ang)))
					      (* -.0000138435 (cos (* 7 ang)))
					      (* .000000116180(cos (* 8 ang))))))
      
      (list blackman9-window "blackman9" (lambda (ang)
					   (+ .225734 
					      (* -.386012 (cos ang))
					      (* .240129 (cos (* 2 ang)))
					      (* -.107054 (cos (* 3 ang)))
					      (* .03325916 (cos (* 4 ang)))
					      (* -.00687337  (cos (* 5 ang)))
					      (* .0008751673 (cos (* 6 ang)))
					      (* -.0000600859 (cos (* 7 ang)))
					      (* .000001710716 (cos (* 8 ang)))
					      (* -.00000001027272(cos (* 9 ang))))))
      
      (list blackman10-window "blackman10" (lambda (ang)
					     (+ .215153 
						(* -.373135 (cos ang))
						(* .242424 (cos (* 2 ang)))
						(* -.1166907 (cos (* 3 ang)))
						(* .04077422 (cos (* 4 ang)))
						(* -.01000904 (cos (* 5 ang)))
						(* .0016398069 (cos (* 6 ang)))
						(* -.0001651660 (cos (* 7 ang)))
						(* .000008884663 (cos (* 8 ang)))
						(* -.000000193817 (cos (* 9 ang)))
						(* .000000000848248(cos (* 10 ang))))))
      
      (list rectangular-window "rectangular" (lambda (ang) 1.0))
      
      (list bartlett-window "bartlett" (let ((val 0.0)) 
					 (lambda (ang)
					   (let ((result val))
					     (set! val (+ val (/ 1.0 8)))
					     result))))
      
      (list parzen-window "parzen" (let ((i 0))
				     (lambda (ang)
				       (let ((result (- 1.0 (abs (/ (- i 8) 8.0)))))
					 (set! i (+ i 1))
					 result))))
      
      (list welch-window "welch" (let ((i 0)
				       (sqr (lambda (x) (* x x))))
				   (lambda (ang)
				     (let ((result (- 1.0 (sqr (/ (- i 8) 8.0)))))
				       (set! i (+ i 1))
				       result))))
      
      (list flat-top-window "flat-top" (lambda (ang)
					 (+ 0.2156 
					    (* -0.4160 (cos ang))
					    (* 0.2781 (cos (* 2 ang)))
					    (* -0.0836 (cos (* 3 ang)))
					    (* 0.0069 (cos (* 4 ang))))))
      
      (list bohman-window "bohman" (let ((i 0))
				     (lambda (ang)
				       (let ((result (let ((r (/ (- 8 i) 8)))
						       (+ (* (- 1.0 r) (cos (* pi r)))
							  (* (/ 1.0 pi) (sin (* pi r)))))))
					 (set! i (+ i 1))
					 result))))
      
      (list bartlett-hann-window "bartlett-hann" (let ((i 0))
						   (lambda (ang)
						     (let ((result (+ 0.62 
								      (* -0.48 (abs (- (/ i 16.0) 0.5))) 
								      (* 0.38 (cos (* 2 pi (- (/ i 16.0) 0.5)))))))
						       (set! i (+ i 1))
						       result))))
      
      (list connes-window "connes" (let ((i 0)
					 (sqr (lambda (x) (* x x))))
				     (lambda (ang)
				       (let ((result (sqr (- 1.0 (sqr (/ (- i 8) 8.0))))))
					 (set! i (+ i 1))
					 result))))
      
      (list riemann-window "riemann" (let ((i 0))
				       (lambda (ang)
					 (let ((result (if (= 8 i) 
							   1.0
							   (/ (sin (* (/ (* 2 pi) 16.) (- 8 i))) (* (/ (* 2 pi) 16.0) (- 8 i))))))
					   (set! i (+ i 1))
					   result))))
      
      (list exponential-window "exponential" (let ((expsum 1.0))
					       (lambda (ang)
						 (let ((result (- expsum 1.0))) 
						   (set! expsum (* expsum (+ 1.0 (/ (log 2) 8.0))))
						   result))))))
    
    (do ((win (make-fft-window bartlett-hann-window 32))
	 (unhappy #f)
	 (i 0 (+ i 1))) 
	((or unhappy (= i 32)))
      (let ((val (+ 0.62 (* -0.48 (abs (- (/ i 31) 0.5))) (* 0.38 (cos (* 2 pi (- (/ i 31) 0.5)))))))
	(when (> (abs (- val (win i))) .03)
	  (set! unhappy #t)
	  (snd-display "bartlett-hann at ~D: ~A ~A" i val (win i)))))
    (do ((win (make-fft-window flat-top-window 32))
	 (unhappy #f)
      (i 0 (+ i 1))) 
	((or unhappy (= i 32)))
      (let ((val (+ 0.2156 
		    (* -0.4160 (cos (/ (* 2 pi i) 31))) 
		    (* 0.2781 (cos (/ (* 4 pi i) 31))) 
		    (* -0.0836 (cos (/ (* 6 pi i) 31))) 
		    (* 0.0069 (cos (/ (* 8 pi i) 31))))))
	(when (> (abs (- val (win i))) .1) ; error is much less, of course, in a bigger window
	  (set! unhappy #t)
	  (snd-display "flat-top at ~D: ~A ~A" i val (win i)))))
    (catch #t
	   (lambda ()
	     (let ((gen (make-fft-window samaraki-window 16)))
	       (if (not (mus-arrays-equal? gen #r(1.000 0.531 0.559 0.583 0.604 0.620 0.631 0.638 0.640 0.638 0.631 0.620 0.604 0.583 0.559 0.531)))
		   (snd-display "samaraki window: ~A" gen)))
	     (let ((gen (make-fft-window ultraspherical-window 16)))
	       (if (not (mus-arrays-equal? gen #r(1.000 0.033 0.034 0.035 0.036 0.036 0.037 0.037 0.037 0.037 0.037 0.036 0.036 0.035 0.034 0.033)))
		   (snd-display "ultraspherical window: ~A" gen)))
	     (let ((gen (make-fft-window dolph-chebyshev-window 16)))
	       (if (not (mus-arrays-equal? gen #r(1.000 0.033 0.034 0.035 0.036 0.036 0.037 0.037 0.037 0.037 0.037 0.036 0.036 0.035 0.034 0.033)))
		   (snd-display "dolph-chebyshev window: ~A" gen)))
	     
	     (without-errors
	      (let ((gen (make-fft-window dolph-chebyshev-window 16 1.0)))
		(if (not (mus-arrays-equal? gen #r(1.000 0.274 0.334 0.393 0.446 0.491 0.525 0.546 0.553 0.546 0.525 0.491 0.446 0.393 0.334 0.274)))
		    (snd-display "dolph-chebyshev window: ~A" gen))))
	     
	     (let ((val1 (make-fft-window ultraspherical-window 16 0.0 0.0))
		   (val2 (make-fft-window dolph-chebyshev-window 16 0.0)))
	       (if (not (mus-arrays-equal? val1 val2)) (snd-display "ultra/dolph 0: ~A ~A" val1 val2)))  
	     (let ((val1 (make-fft-window ultraspherical-window 16 0.0 1.0))
		   (val2 (make-fft-window samaraki-window 16 0.0)))
	       (if (not (mus-arrays-equal? val1 val2)) (snd-display "ultra/sam 0: ~A ~A" val1 val2)))
	     (let ((val1 (make-fft-window ultraspherical-window 16 0.5 0.0))
		   (val2 (make-fft-window dolph-chebyshev-window 16 0.5)))
	       (if (not (mus-arrays-equal? val1 val2)) (snd-display "ultra/dolph 5: ~A ~A" val1 val2)))  
	     (let ((val1 (make-fft-window ultraspherical-window 16 0.5 1.0))
		   (val2 (make-fft-window samaraki-window 16 0.5)))
	       (if (not (mus-arrays-equal? val1 val2)) (snd-display "ultra/sam 5: ~A ~A" val1 val2)))
	     (let ((val1 (dolph 16 1.0))
		   (val2 (make-fft-window dolph-chebyshev-window 16 1.0)))
	       (if (not (mus-arrays-equal? val1 val2)) (snd-display "dolph/dolph 1: ~A ~A" val1 val2))))
	   (lambda args (snd-display "new windows: ~A" args)))
    
    (when (defined? 'gsl-eigenvectors)
      (let ((win (make-dpss-window 16 .01)))
	(if (not (mus-arrays-equal? win #r(0.964 0.973 0.981 0.987 0.992 0.996 0.999 1.000 1.000 0.999 0.996 0.992 0.987 0.981 0.973 0.964)))
	    (snd-display "make-dpss-window 16 .01: ~A" win)))
      (let ((win (make-dpss-window 16 .1)))
	(if (not (mus-arrays-equal? win #r(0.090 0.193 0.332 0.494 0.664 0.818 0.936 1.000 1.000 0.936 0.818 0.664 0.494 0.332 0.193 0.090)))
	    (snd-display "make-dpss-window 16 .1: ~A" win)))
      (let ((win (make-dpss-window 32 .09)))
	(if (not (mus-arrays-equal? win #r(0.004 0.011 0.025 0.050 0.086 0.138 0.206 0.290 0.388 0.496 0.610 0.722 0.823 0.908 0.968 1.000 
					   1.000 0.968 0.908 0.823 0.722 0.610 0.496 0.388 0.290 0.206 0.138 0.086 0.050 0.025 0.011 0.004)))
	    (snd-display "make-dpss-window 32 .09: ~A" win)))
      
      (for-each
       (lambda (n)
	 (for-each
	  (lambda (beta)
	    (let ((win1 (make-dpss-window n beta))
		  (win2 (make-fft-window dpss-window n beta)))
	      (if (not (mus-arrays-equal? win1 win2))
		  (snd-display "dpss-windows:~%    ~A~%    ~A" win1 win2))))
	  '(.01 .07 .12 .2)))
       '(16 32)))
    
    (let ((win (make-papoulis-window 32)))
      (if (not (mus-arrays-equal? win #r(0.000 0.001 0.006 0.021 0.048 0.091 0.151 0.227 0.318 0.422 0.533 0.647 0.755 0.852 0.930 0.982 
				1.000 0.982 0.930 0.852 0.755 0.647 0.533 0.422 0.318 0.227 0.151 0.091 0.048 0.021 0.006 0.001)))
	  (snd-display "make-papoulis-window 32: ~A" win)))
    
    (for-each
     (lambda (n)
       (let ((win1 (make-papoulis-window n))
	     (win2 (make-fft-window papoulis-window n)))
	 (if (not (mus-arrays-equal? win1 win2))
	     (snd-display "papoulis-windows:~%    ~A~%    ~A" win1 win2))))
     '(32 64 256))
    
    
    (let ((gen (make-env '(0 0 1 1 2 0) :scaler 0.5 :length 11)))
      (print-and-check gen 
		       "env"
		       "env linear, pass: 0 (dur: 11), index: 0, scaler: 0.5000, offset: 0.0000, data: [0 0 1 1 2 0]")
      (if (not (env? gen)) (snd-display "~A not env?" gen))
      (if (fneq (mus-scaler gen) 0.5) (snd-display "env scaler ~F?" (mus-scaler gen)))
      (if (fneq (mus-increment gen) 1.0) (snd-display "env base (1.0): ~A?" (mus-increment gen)))
      (if (not (= (mus-length gen) 11)) (snd-display "env length: ~A" (mus-length gen)))
      (let ((v0 (make-float-vector 10)))
	(do ((i 0 (+ i 1)))
	    ((= i 10))
	  (set! (v0 i) (env gen)))
	(let ((off 123.0)
	      (v1 (make-float-vector 10))
	      (gen1 (make-env '(0 0 1 1 2 0) :scaler 0.5 :length 11)))
	  (fill-float-vector v1 (begin
				  (set! off (mus-offset gen1))
				  (if (env? gen1) (env gen1) -1.0)))
	  (if (fneq off 0.0) (snd-display "mus-offset opt: ~A" off))
	  (if (not (mus-arrays-equal? v0 v1)) (snd-display "map env: ~A ~A" v0 v1)))
	(if (or (fneq (v0 0) 0.0) (fneq (v0 1) .1) (fneq (v0 6) .4))
	    (snd-display "~A output: ~A" gen v0))
	(if (fneq (env-interp 1.6 gen) 0.2) (snd-display "env-interp ~A at 1.6: ~F?" gen (env-interp 1.5 gen)))
	(set! gen (make-env :envelope '(0 1 1 0) :base 32.0 :length 11))
	(if (fneq (mus-increment gen) 32.0) (snd-display "env base (32.0): ~A?" (mus-increment gen)))
	(do ((i 0 (+ i 1)))
	    ((= i 10))
	  (set! (v0 i) (env gen)))
	(if (or (fneq (v0 0) 1.0) (fneq (v0 1) .698) (fneq (v0 8) .032))
	    (snd-display "~A output: ~A" gen v0))
	(set! gen (make-env :envelope '(0 1 1 0) :base .0325 :length 11))
	(if (fneq (mus-increment gen) .0325) (snd-display "env base (.0325): ~A?" (mus-increment gen)))
	(do ((i 0 (+ i 1)))
	    ((= i 10))
	  (set! (v0 i) (env gen)))
	(if (or (fneq (v0 0) 1.0) (fneq (v0 1) .986) (fneq (v0 8) .513))
	    (snd-display "~A output: ~A" gen v0))
	(set! gen (make-env :envelope '(0 1 1 .5 2 0) :base 0.0 :length 11 :offset 1.0))
	(if (fneq (mus-offset gen) 1.0) (snd-display "mus-offset: ~A" (mus-offset gen)))
	(if (fneq (mus-increment gen) 0.0) (snd-display "env base (0.0): ~A?" (mus-increment gen)))
	(do ((i 0 (+ i 1)))
	    ((= i 10))
	  (if (and (= i 3)
		   (not (= (mus-location gen) 3)))
	      (snd-display "env location: ~A?" (mus-location gen)))
	  (set! (v0 i) (env gen)))
	(if (or (fneq (v0 0) 2.0) (fneq (v0 6) 1.5) (fneq (v0 8) 1.5))
	    (snd-display "~A output: ~A" gen v0)))
      (if (fneq (env-interp 1.5 gen) 1.5) (snd-display "env-interp ~A at 1.5: ~F?" gen (env-interp 1.5 gen)))
      (set! (mus-location gen) 6)
      (if (not (= (mus-location gen) 6)) (snd-display "set! mus-location ~A (6)?" (mus-location gen)))
      (let ((val (env gen)))
	(if (fneq val 1.5) (snd-display "set! mus-location 6 -> ~A (1.5)?" val)))
      (set! (mus-location gen) 0)
      (let ((val (env gen)))
	(if (fneq val 2.0) (snd-display "set! mus-location 0 -> ~A (2.0)?" val)))
      (let ((gen (make-env '(0 0 1 -1 2 0) :length 11)))
	(do ((i 0 (+ i 1)))
	    ((= i 5))
	  (let ((val (env gen)))
	    (if (fneq val (/ i -5.0)) (snd-display "neg env: ~D ~A" i val))))
	(do ((i 0 (+ i 1)))
	    ((= i 5))
	  (let ((val (env gen)))
	    (if (fneq val (- (/ i 5.0) 1.0)) (snd-display "neg env: ~D ~A" (+ i 5) val)))))
      (do ((gen (make-env '(0 0 1 -1 2 0) :length 11 :base 0.5))
	   (v #r(0.0 -0.14869 -0.31950 -0.51571 -0.74110 -1.0 -0.74110 -0.51571 -0.31950 -0.14869))
	   (i 0 (+ i 1)))
	  ((= i 10)
	   (mus-apply gen))	     
	(let ((val (env gen)))
	  (if (fneq val (v i)) (snd-display "neg exp env: ~D ~A" i val)))))

    (let ((env-fill (lambda (v e)
		      (do ((i 0 (+ i 1)))
			  ((= i 10))
			(set! (v i) (env e))))))
      
      (let ((v (make-float-vector 10)))
	(let ((e (make-env '(0 0 1 1) :length 10)))
	  (env-fill v e)
	  (if (not (mus-arrays-equal? v #r(0.000 0.111 0.222 0.333 0.444 0.556 0.667 0.778 0.889 1.000)))
	      (snd-display "simple ramp: ~A" v)))
	(let ((v (make-float-vector 10))
	      (e (make-env '(0 0 1 1) :base 0 :length 8)))
	  (env-fill v e)
	  (if (not (mus-arrays-equal? v #r(0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 1.000 1.000)))
	      (snd-display "simple ramp, base 0: ~A" v)))
	(let ((v (make-float-vector 10))
	      (e (make-env '(0 0 1 1 2 .5) :base 0 :length 8)))
	  (env-fill v e)
	  (if (not (mus-arrays-equal? v #r(0.000 0.000 0.000 0.000 1.000 1.000 1.000 1.000 0.500 0.500)))
	      (snd-display "two-step, base 0: ~A" v)))
	(let ((e (make-env '((0 0) (1 1)) :length 10)))
	  (env-fill v e)
	  (if (not (mus-arrays-equal? v #r(0.000 0.111 0.222 0.333 0.444 0.556 0.667 0.778 0.889 1.000)))
	      (snd-display "simple ramp embedded: ~A" v)))
	(let ((e (make-env '(0 1 1 0) :length 10)))
	  (env-fill v e)
	  (if (not (mus-arrays-equal? v #r(1.000 0.889 0.778 0.667 0.556 0.444 0.333 0.222 0.111 0.000)))
	      (snd-display "simple ramp down: ~A" v)))
	(let ((e (make-env '(0 0 1 1 2 0) :length 10)))
	  (env-fill v e)
	  (if (not (mus-arrays-equal? v #r(0.000 0.200 0.400 0.600 0.800 1.000 0.750 0.500 0.250 0.000)))
	      (snd-display "simple pyr: ~A" v)))
	(let ((e (make-env '((0 0) (1 1) (2 0)) :length 10)))
	  (env-fill v e)
	  (if (not (mus-arrays-equal? v #r(0.000 0.200 0.400 0.600 0.800 1.000 0.750 0.500 0.250 0.000)))
	      (snd-display "simple pyr embedded: ~A" v)))
	(let ((e (make-env '(0 0 1 1 2 -.5) :length 10)))
	  (env-fill v e)
	  (if (not (mus-arrays-equal? v #r(0.000 0.200 0.400 0.600 0.800 1.000 0.625 0.250 -0.125 -0.500)))
	      (snd-display "simple pyr -.5: ~A" v)))
	(let ((e (make-env '((0 0) (1 1) (2 -.5)) :length 10)))
	  (env-fill v e)
	  (if (not (mus-arrays-equal? v #r(0.000 0.200 0.400 0.600 0.800 1.000 0.625 0.250 -0.125 -0.500)))
	      (snd-display "simple pyr -.5 embedded: ~A" v)))
	(let ((e (make-env '(0 0 1 1 2 -.5) :length 10)))
	  (env-fill v e)
	  (if (not (mus-arrays-equal? v #r(0.000 0.200 0.400 0.600 0.800 1.000 0.625 0.250 -0.125 -0.500)))
	      (snd-display "simple pyr -.5: ~A" v))))
      
      (let ((v (make-float-vector 10)))
	(let ((e (make-env #r(0 0 1 1) :length 10)))
	  (env-fill v e)
	  (if (not (mus-arrays-equal? v #r(0.000 0.111 0.222 0.333 0.444 0.556 0.667 0.778 0.889 1.000)))
	      (snd-display "simple ramp: ~A" v)))
	(let ((v (make-float-vector 10))
	      (e (make-env #r(0 0 1 1) :base 0 :length 8)))
	  (env-fill v e)
	  (if (not (mus-arrays-equal? v #r(0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 1.000 1.000)))
	      (snd-display "simple ramp, base 0: ~A" v)))
	(let ((v (make-float-vector 10))
	      (e (make-env #r(0 0 1 1 2 .5) :base 0 :length 8)))
	  (env-fill v e)
	  (if (not (mus-arrays-equal? v #r(0.000 0.000 0.000 0.000 1.000 1.000 1.000 1.000 0.500 0.500)))
	      (snd-display "two-step, base 0: ~A" v)))
	(let ((e (make-env #r(0 1 1 0) :length 10)))
	  (env-fill v e)
	  (if (not (mus-arrays-equal? v #r(1.000 0.889 0.778 0.667 0.556 0.444 0.333 0.222 0.111 0.000)))
	      (snd-display "simple ramp down: ~A" v)))
	(let ((e (make-env #r(0 0 1 1 2 0) :length 10)))
	  (env-fill v e)
	  (if (not (mus-arrays-equal? v #r(0.000 0.200 0.400 0.600 0.800 1.000 0.750 0.500 0.250 0.000)))
	      (snd-display "simple pyr: ~A" v)))
	(let ((e (make-env #r(0 0 1 1 2 -.5) :length 10)))
	  (env-fill v e)
	  (if (not (mus-arrays-equal? v #r(0.000 0.200 0.400 0.600 0.800 1.000 0.625 0.250 -0.125 -0.500)))
	      (snd-display "simple pyr -.5: ~A" v)))
	(let ((e (make-env #r(0 0 1 1 2 -.5) :length 10)))
	  (env-fill v e)
	  (if (not (mus-arrays-equal? v #r(0.000 0.200 0.400 0.600 0.800 1.000 0.625 0.250 -0.125 -0.500)))
	      (snd-display "simple pyr -.5: ~A" v))))
      
      (let ((v (make-float-vector 10)))
	(let ((e (make-env #r(0 0 1 1) :length 10)))
	  (env-fill v e)
	  (if (not (mus-arrays-equal? v #r(0.000 0.111 0.222 0.333 0.444 0.556 0.667 0.778 0.889 1.000)))
	      (snd-display "simple ramp: ~A" v)))
	(let ((v (make-float-vector 10))
	      (e (make-env #r(0 0 1 1) :base 0 :length 8)))
	  (env-fill v e)
	  (if (not (mus-arrays-equal? v #r(0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 1.000 1.000)))
	      (snd-display "simple ramp, base 0: ~A" v)))
	(let ((v (make-float-vector 10))
	      (e (make-env #r(0 0 1 1 2 .5) :base 0 :length 8)))
	  (env-fill v e)
	  (if (not (mus-arrays-equal? v #r(0.000 0.000 0.000 0.000 1.000 1.000 1.000 1.000 0.500 0.500)))
	      (snd-display "two-step, base 0: ~A" v)))
	(let ((e (make-env #r(0 1 1 0) :length 10)))
	  (env-fill v e)
	  (if (not (mus-arrays-equal? v #r(1.000 0.889 0.778 0.667 0.556 0.444 0.333 0.222 0.111 0.000)))
	      (snd-display "simple ramp down: ~A" v)))
	(let ((e (make-env #r(0 0 1 1 2 0) :length 10)))
	  (env-fill v e)
	  (if (not (mus-arrays-equal? v #r(0.000 0.200 0.400 0.600 0.800 1.000 0.750 0.500 0.250 0.000)))
	      (snd-display "simple pyr: ~A" v)))
	(let ((e (make-env #r(0 0 1 1 2 -.5) :length 10)))
	  (env-fill v e)
	  (if (not (mus-arrays-equal? v #r(0.000 0.200 0.400 0.600 0.800 1.000 0.625 0.250 -0.125 -0.500)))
	      (snd-display "simple pyr -.5: ~A" v)))
	(let ((e (make-env #r(0 0 1 1 2 -.5) :length 10)))
	  (env-fill v e)
	  (if (not (mus-arrays-equal? v #r(0.000 0.200 0.400 0.600 0.800 1.000 0.625 0.250 -0.125 -0.500)))
	      (snd-display "simple pyr -.5: ~A" v)))))
    
    (let ((e (make-env '(0 0 1 1) :length 10)))
      (if (fneq (env-interp 1.0 e) 1.0) (snd-display "env-interp 0011 at 1: ~A" (env-interp 1.0 e)))
      (if (fneq (env-interp 2.0 e) 1.0) (snd-display "env-interp 0011 at 2: ~A" (env-interp 2.0 e)))
      (if (fneq (env-interp 0.0 e) 0.0) (snd-display "env-interp 0011 at 0: ~A" (env-interp 0.0 e)))
      (if (fneq (env-interp 0.444 e) 0.444) (snd-display "env-interp 0011 at .444: ~A" (env-interp 0.45 e)))
      (mus-reset e)
      (do ((i 0 (+ i 1)))
	  ((= i 10))
	(let ((val (env e)))
	  (if (fneq val (* i .111111)) (snd-display "ramp env over 10: ~A at ~A" val i)))))
    (do ((e (make-env '(0 0 .5 .5 1 1) :base 32 :length 10))
	 (v #r(0.0 0.0243 0.0667 0.1412 0.2716 0.5000 0.5958 0.7090 0.8425 1.0))
	 (i 0 (+ i 1))
	 (x 0.0 (+ x 0.11111)))
	((= i 10))
      (let ((val (env-interp x e)))
	(if (fneq val (v i)) (snd-display "(0 .5 1) env-interp over 10: ~A at ~A (~A)" val i (v i)))))
    (do ((e (make-env '(0 -1.0 1 1) :base 32 :length 10))
	 (v #r(-1.0 -0.9697 -0.9252 -0.8597 -0.7635 -0.6221 -0.4142 -0.1088 0.34017 1.0))
	 (i 0 (+ i 1))
	 (x 0.0 (+ x 0.11111)))
	((= i 10))
      (let ((val (env-interp x e)))
	(if (fneq val (v i)) (snd-display "(-1 1) env-interp over 10: ~A at ~A (~A)" val i (v i)))))
    (do ((e (make-env '(0 -1.0 .5 .5 1 0) :base 32 :length 10))
	 (v #r(-1.0 -0.952 -0.855 -0.661 -0.274 0.5 0.356 0.226 0.107 0.0))
	 (i 0 (+ i 1))
	 (x 0.0 (+ x 0.11111)))
	((= i 10))
      (let ((val (env-interp x e)))
	(if (fneq val (v i)) (snd-display "(-1 .5 0) env-interp over 10: ~A at ~A (~A)" val i (v i)))))
    (do ((e (make-env '(0 0.0 .5 .5 1 -1.0) :base 32 :length 10))
	 (v #r(0.0 0.085 0.177 0.276 0.384 0.5 -0.397 -0.775 -0.933 -1.0))
	 (i 0 (+ i 1))
	 (x 0.0 (+ x 0.11111)))
	((= i 10))
      (let ((val (env-interp x e)))
	(if (fneq val (v i)) (snd-display "(0 .5 -1) env-interp over 10: ~A at ~A (~A)" val i (v i)))))
    (let ((e (make-env '(0 0 1 1) :length 10 :base 4.0)))
      (if (fneq (env-interp 1.0 e) 1.0) (snd-display "env-interp 0011 4 at 1: ~A" (env-interp 1.0 e)))
      (if (fneq (env-interp 0.0 e) 0.0) (snd-display "env-interp 0011 4 at 0: ~A" (env-interp 0.0 e)))
      (if (fneq (env-interp 0.45 e) 0.2839) (snd-display "env-interp 0011 4 at .45: ~A" (env-interp 0.45 e))))
    (let ((e (make-env '(0 0 1 1) :length 10 :base 0.2)))
      (if (fneq (env-interp 1.0 e) 1.0) (snd-display "env-interp 0011 2 at 1: ~A" (env-interp 1.0 e)))
      (if (fneq (env-interp 0.0 e) 0.0) (snd-display "env-interp 0011 2 at 0: ~A" (env-interp 0.0 e)))
      (if (fneq (env-interp 0.45 e) 0.6387) (snd-display "env-interp 0011 2 at .45: ~A" (env-interp 0.45 e))))
    
    (let ((val (let ((e (make-env '(0 0 1 1) :length 10 :offset 2.0))) (set! (mus-offset e) 3.0) (mus-offset e))))
      (if (fneq val 3.0) (snd-display "set mus-offset env: ~A" val)))
    
    (let ((e (make-env '(0 0 1 1 2 0) :length 10))
	  (v (make-float-vector 10)))
      (do ((i 0 (+ i 1)))
	  ((= i 10))
	(set! (v i) (env e)))
      (if (not (mus-arrays-equal? v #r(0.000 0.200 0.400 0.600 0.800 1.000 0.750 0.500 0.250 0.000)))
	  (snd-display "e set off 0: ~A" v))
      (if (not (= (mus-length e) 10)) (snd-display "e set off 0 len: ~A" (mus-length e)))
      (if (fneq (mus-scaler e) 1.0) (snd-display "e set off 0 scl: ~A" (mus-scaler e)))
      (if (fneq (mus-offset e) 0.0) (snd-display "e set off 0 off: ~A" (mus-offset e)))
      (set! (mus-scaler e) 2.0)
      (do ((i 0 (+ i 1)))
	  ((= i 10))
	(set! (v i) (env e)))
      (if (not (mus-arrays-equal? v #r(0.000 0.400 0.800 1.200 1.600 2.000 1.500 1.000 0.500 0.000)))
	  (snd-display "e set off 1: ~A" v))
      (if (not (= (mus-length e) 10)) (snd-display "e set off 1 len: ~A" (mus-length e)))
      (if (fneq (mus-scaler e) 2.0) (snd-display "e set off 1 scl: ~A" (mus-scaler e)))
      (if (fneq (mus-offset e) 0.0) (snd-display "e set off 1 off: ~A" (mus-offset e)))
      (set! (mus-offset e) 1.0)
      (do ((i 0 (+ i 1)))
	  ((= i 10))
	(set! (v i) (env e)))
      (if (not (mus-arrays-equal? v #r(1.000 1.400 1.800 2.200 2.600 3.000 2.500 2.000 1.500 1.000)))
	  (snd-display "e set off 2: ~A" v))
      (if (not (= (mus-length e) 10)) (snd-display "e set off 2 len: ~A" (mus-length e)))
      (if (fneq (mus-scaler e) 2.0) (snd-display "e set off 2 scl: ~A" (mus-scaler e)))
      (if (fneq (mus-offset e) 1.0) (snd-display "e set off 2 off: ~A" (mus-offset e)))
      (set! (mus-length e) 19)
      (do ((i 0 (+ i 1)))
	  ((= i 10))
	(set! (v i) (env e)))
      (if (not (mus-arrays-equal? v #r(1.000 1.222 1.444 1.667 1.889 2.111 2.333 2.556 2.778 3.000)))
	  (snd-display "e set off 3: ~A" v))
      (if (not (= (mus-length e) 19)) (snd-display "e set off 3 len: ~A" (mus-length e)))
      (if (fneq (mus-scaler e) 2.0) (snd-display "e set off 3 scl: ~A" (mus-scaler e)))
      (if (fneq (mus-offset e) 1.0) (snd-display "e set off 3 off: ~A" (mus-offset e))))
    
    (do ((e (make-env #r(0 0 1 1 2 0) :length 10))
	 (v (make-float-vector 10))
	 (i 0 (+ i 1)))
	((= i 10)
	 (if (not (mus-arrays-equal? v #r(0.000 0.200 0.400 0.600 0.800 1.000 0.750 0.500 0.250 0.000)))
	     (snd-display "e from float-vector: ~A" v)))
      (set! (v i) (env e)))
    
    (do ((e1 (make-env '(0 0 1 1) :base 32.0 :length 11))
	 (v #r(0.000 0.013 0.032 0.059 0.097 0.150 0.226 0.333 0.484 0.698 1.00))
	 (i 0 (+ i 1)))
	((> i 10))
      (let ((val (env e1)))
	(if (fneq val (v i))
	    (snd-display "exp env direct (32.0): ~A ~A" val (v i)))))
    
    (do ((e1 (make-env '(0 1 1 2) :base 32.0 :length 11))
	 (v #r(1.000 1.013 1.032 1.059 1.097 1.150 1.226 1.333 1.484 1.698 2.00))
	 (i 0 (+ i 1)))
	((> i 10))
      (let ((val (env e1)))
	(if (fneq val (v i))
	    (snd-display "exp env direct (32.0) offset: ~A ~A" val (v i)))))
    (do ((e1 (make-env '((0 1) (1 2)) :base 32.0 :length 11))
	 (v #r(1.000 1.013 1.032 1.059 1.097 1.150 1.226 1.333 1.484 1.698 2.00))
	 (i 0 (+ i 1)))
	((> i 10))
      (let ((val (env e1)))
	(if (fneq val (v i))
	    (snd-display "exp env direct (32.0) offset embedded: ~A ~A" val (v i)))))
    (do ((e1 (make-env '(0 1 1 2) :base 32.0 :length 11))
	 (v #r(1.000 1.013 1.032 1.059 1.097 1.150 1.226 1.333 1.484 1.698 2.00))
	 (i 0 (+ i 1)))
	((> i 10))
      (let ((val (env e1)))
	(if (fneq val (v i))
	    (snd-display "exp env direct (32.0) offset (and dur): ~A ~A" val (v i)))))
    
    (do ((e1 (make-env '(0 0 1 1) :base 0.032 :length 11))
	 (v #r(0.000 0.301 0.514 0.665 0.772 0.848 0.902 0.940 0.967 0.986 1.0))
	 (i 0 (+ i 1)))
	((> i 10))
      (let ((val (env e1)))
	(if (fneq val (v i))
	    (snd-display "exp env direct (.032): ~A ~A" val (v i)))))
    
    (let ((e1 (make-env '(0 0 1 1) :base .03125 :length 11))
	  (e2 (make-env '(0 0 1 1 2 0) :base 32.0 :length 11))
	  (e3 (make-env '(0 0 .1 1 2 0) :base 1.1 :length 101)))
      (do ((i 0 (+ i 1)))
	  ((= i 10))
	(let ((lv1 (env-interp (* i .1) e1))
	      (lv2 (env e1))
	      (lv3 (env-interp (* i .2) e2))
	      (lv4 (env e2)))
	  (if (ffneq lv1 lv2) (snd-display "env-interp[rmp ~F]: ~A (~A)?" (* .1 i) lv1 lv2))
	  (if (ffneq lv3 lv4) (snd-display "env-interp[pyr ~F]: ~A (~A)?" (* .2 i) lv3 lv4))))
      (do ((i 0 (+ i 1)))
	  ((= i 100))
	(let ((lv5 (env-interp (* i .02) e3))
	      (lv6 (env e3)))
	  (if (ffneq lv5 lv6) (snd-display "env-interp[tri ~F]: ~A (~A)?" (* .02 i) lv5 lv6)))))
    
    (let ((e1 (make-env '(0 0 1 1 2 0) :length 10))
	  (lv1 (make-float-vector 11))
	  (lv2 (make-float-vector 11))
	  (lv3 (make-float-vector 11)))
      (do ((i 0 (+ i 1))) ((= i 11)) (set! (lv1 i) (env e1)))
      (do ((i 0 (+ i 1))) ((= i 11)) (set! (lv2 i) (env e1)))
      (mus-reset e1)
      (do ((i 0 (+ i 1))) ((= i 11)) (set! (lv3 i) (env e1)))
      (if (not (mus-arrays-equal? lv1 lv3)) (snd-display "mus-reset: ~A ~A?" lv1 lv3))
      (if (not (mus-arrays-equal? lv2 (make-float-vector 11))) (snd-display "mus-reset 1: ~A?" lv2)))
    
    (let ((gen (make-env '(0 0 1 1 2 0) :length 11)))
      (do ((i 0 (+ i 1))) ((= i 4)) (env gen))
      (let ((val (env gen)))
	(if (fneq val .8) (snd-display "env(5): ~A?" val))
	(mus-reset gen)
	(do ((i 0 (+ i 1))) ((= i 4)) (env gen))
	(set! val (env gen))
	(if (fneq val .8) (snd-display "mus-reset (via reset): ~A?" val))
	(set! (mus-location gen) 6)
	(let ((val (env gen)))
	  (if (fneq val 0.8) (snd-display "set! mus-location 6 -> ~A (0.8)?" val)))))
    
    (let ((gen (make-env '(0 0 1 1) :base .032 :length 12)))
      (set! (mus-location gen) 5)
      (let ((val (env gen)))
	(if (fneq val 0.817)
	    (snd-display "set env location with base: ~A ~A" val gen))))
    (let ((gen (make-env '(0 0 1 1) :base .032 :length 12)))
      (set! (mus-location gen) 5)
      (let ((val (env gen)))
	(if (fneq val 0.817)
	    (snd-display "set env location with base and dur: ~A ~A" val gen))))
    
    (test-gen-equal (make-env '(0 0 1 1 2 0) :scaler 0.5 :length 10) (make-env '(0 0 1 1 2 0) :scaler 0.5 :length 10) (make-env '(0 0 1 1 2 0) :scaler 0.25 :length 10))
    (test-gen-equal (make-env '(0 0 1 1 2 0) :scaler 0.5 :length 10) (make-env '(0 0 1 1 2 0) :scaler 0.5 :length 10) (make-env '(0 0 1 1 2 0) :scaler 0.5 :length 11))
    (test-gen-equal (make-env '(0 0 1 1 2 0) :scaler 0.5 :length 10) (make-env '(0 0 1 1 2 0) :scaler 0.5 :length 10) (make-env '(0 0 1 1 3 0) :scaler 0.5 :length 10))
    (test-gen-equal (make-env '((0 0) (1 1) (2 0)) :scaler 0.5 :length 10) (make-env '(0 0 1 1 2 0) :scaler 0.5 :length 10) (make-env '((0 0) (1 1) (3 0)) :scaler 0.5 :length 10))
    
    (let ((var (catch #t (lambda () (make-env :envelope ())) (lambda args args))))
      (if (not (memq (car var) '(no-data wrong-type-arg)))
	  (snd-display "make-env null env: ~A" var)))
    (let ((var (catch #t (lambda () (make-env :length 1)) (lambda args args))))
      (if (not (memq (car var) '(no-data wrong-type-arg)))
	  (snd-display "make-env no env: ~A" var)))
    (let ((var (catch #t (lambda () (make-env :envelope '(0 0) :length -1)) (lambda args args))))
      (if (not (eq? (car var) 'out-of-range))
	  (snd-display "make-env bad dur: ~A" var)))
    (let ((var (catch #t (lambda () (make-env :envelope '(0 0) :duration -1.0)) (lambda args args))))
      (if (not (eq? (car var) 'out-of-range))
	  (snd-display "make-env bad duration: ~A" var)))
    (let ((var (catch #t (lambda () (make-env :envelope '(0 0) :base -1.0)) (lambda args args))))
      (if (not (eq? (car var) 'out-of-range))
	  (snd-display "make-env bad base: ~A" var)))
    (let ((var (catch #t (lambda () (make-env :envelope '(1 1 0 0) :length 11)) (lambda args args))))
      (if (not (eq? (car var) 'mus-error))
	  (snd-display "make-env bad env 1 1 0 0: ~A" var)))
    (let ((var (catch #t (lambda () (make-env :envelope '(0 1 -1 0) :length 11)) (lambda args args))))
      (if (not (eq? (car var) 'mus-error))
	  (snd-display "make-env bad env 0 1 -1 0: ~A" var)))
    (let ((var (catch #t (lambda () (make-env :envelope '(0 1 1 0) :length 11 :length 10)) (lambda args args))))
      (if (not (memq (car var) '(mus-error wrong-type-arg)))
	  (snd-display "make-env bad end/dur: ~A" var)))
    (let ((var (catch #t (lambda () (make-env :envelope '(0 0 1 1 2 0 1) :duration 1.0)) (lambda args args))))
      (if (not (memq (car var) '(bad-type wrong-type-arg)))
	  (snd-display "make-env odd length env: ~A" var)))
    (let ((var (catch #t (lambda () (make-env :envelope '("hi" 0 1 1 2 0) :duration 1.0)) (lambda args args))))
      (if (not (eq? (car var) 'wrong-type-arg))
	  (snd-display "make-env env of non-number: ~A" var)))
    
    ;; env-any
    (let* ((env-any-env '(0 0 1 1 2 0.25 3 1 4 0))
	   (env-any-1 (lambda (e func)
			(let* ((pts (mus-data e))
			       (pt (min (* 2 (mus-channels e)) (- (length pts) 4)))
			       (val (/ (- (env e) (mus-offset e)) (mus-scaler e)))
			       (y0 (min (pts (+ pt 1)) (pts (+ pt 3))))
			       (y1 (max (pts (+ pt 1)) (pts (+ pt 3))))
			       (new-val (func (/ (- val y0) (- y1 y0)))))
			  (+ (mus-offset e)
			     (* (mus-scaler e)
				(+ y0
				   (* (- y1 y0) new-val)))))))
	   (sine-env-1 (lambda (e)
			 (env-any-1 e (lambda (y) (* 0.5 (+ 1.0 (sin (* pi (- y 0.5)))))))))
	   (square-env-1 (lambda (e)
			   (env-any-1 e (lambda (y)
					  (* y y)))))
	   
	   (blackman4-env-1 (lambda (e)
			      (env-any-1 e (lambda (y)
					     (let ((cx (cos (* pi y))))
					       (+ 0.084037 (* cx (- (* cx (+ .375696 (* cx (- (* cx .041194) .20762)))) .29145))))))))
	   
	   (multi-expt-env-1 (lambda (e expts)
			       (env-any-1 e (lambda (y)
					      (let ((b (expts (modulo (mus-channels e) (length expts)))))
						(/ (- (expt b y) 1.0) (- b 1.0))))))))
      
      ;; assume sine-env square-env blackman4-env and multi-exp-env are available from generators.scm (8)
      
      (let ((val1 (with-sound ((make-float-vector 20))
		    (do ((e (make-env env-any-env :length 20))
			 (i 0 (+ i 1)))
			((= i 20))
		      (outa i (sine-env e)))))
	    
	    (val2 (with-sound ((make-float-vector 20))
		    (do ((e (make-env env-any-env :length 20))
			 (i 0 (+ i 1)))
			((= i 20))
		      (outa i (sine-env e)))))
	    
	    (val3 (with-sound ((make-float-vector 20))
		    (do ((e (make-env env-any-env :length 20))
			 (i 0 (+ i 1)))
			((= i 20))
		      (outa i (sine-env-1 e))))))
	(if (not (mus-arrays-equal? val1 val2))
	    (snd-display "sine-env straight and run: ~%;  ~A~%;  ~A" val1 val2))
	(if (not (mus-arrays-equal? val1 val3))
	    (snd-display "sine-env straight and scm: ~%;  ~A~%;  ~A" val1 val3)))
      
      
      (let ((val1 (with-sound ((make-float-vector 20))
		    (do ((e (make-env env-any-env :length 20))
			 (i 0 (+ i 1)))
			((= i 20))
		      (outa i (square-env e)))))
	    
	    (val2 (with-sound ((make-float-vector 20))
		    (do ((e (make-env env-any-env :length 20))
			 (i 0 (+ i 1)))
			((= i 20))
		      (outa i (square-env e)))))
	    
	    (val3 (with-sound ((make-float-vector 20))
		    (do ((e (make-env env-any-env :length 20))
			 (i 0 (+ i 1)))
			((= i 20))
		      (outa i (square-env-1 e))))))
	(if (not (mus-arrays-equal? val1 val2))
	    (snd-display "square-env straight and run: ~%;  ~A~%;  ~A" val1 val2))
	(if (not (mus-arrays-equal? val1 val3))
	    (snd-display "square-env straight and scm: ~%;  ~A~%;  ~A" val1 val3)))
      
      (let ((val1 (with-sound ((make-float-vector 20))
		    (do ((e (make-env env-any-env :length 20))
			 (i 0 (+ i 1)))
			((= i 20))
		      (outa i (blackman4-env e)))))
	    
	    (val3 (with-sound ((make-float-vector 20))
		    (do ((e (make-env env-any-env :length 20))
			 (i 0 (+ i 1)))
			((= i 20))
		      (outa i (blackman4-env-1 e))))))
	(if (not (mus-arrays-equal? val1 val3))
	    (snd-display "blackman4-env straight and scm: ~%;  ~A~%;  ~A" val1 val3)))
      
      
      (let ((val1 (with-sound ((make-float-vector 20))
		    (do ((e (make-env env-any-env :length 20))
			 (bases #r(32.0 0.3 1.5))
			 (i 0 (+ i 1)))
			((= i 20))
		      (outa i (multi-expt-env e bases)))))
	    
	    (val2 (with-sound ((make-float-vector 20))
		    (do ((e (make-env env-any-env :length 20))
			 (bases #r(32.0 0.3 1.5))
			 (i 0 (+ i 1)))
			((= i 20))
		      (outa i (multi-expt-env e bases)))))
	    
	    (val3 (with-sound ((make-float-vector 20))
		    (do ((e (make-env env-any-env :length 20))
			 (bases #r(32.0 0.3 1.5))
			 (i 0 (+ i 1)))
			((= i 20))
		      (outa i (multi-expt-env-1 e bases))))))
	(if (not (mus-arrays-equal? val1 val2))
	    (snd-display "multi-expt-env straight and run: ~%;  ~A~%;  ~A" val1 val2))
	(if (not (mus-arrays-equal? val1 val3))
	    (snd-display "multi-expt-env straight and scm: ~%;  ~A~%;  ~A" val1 val3)))
      
      (let ((val1 (with-sound ((make-float-vector 220))
		    (do ((e1 (make-env env-any-env :length 220))
			 (e2 (make-env env-any-env :length 220))
			 (i 0 (+ i 1)))
			((= i 220))
		      (outa i (env-any e1
				       (lambda (y1)
					 (* y1 (env-any e2
							(lambda (y2)
							  y2)))))))))
	    (val2 (with-sound ((make-float-vector 220))
		    (do ((e1 (make-env env-any-env :length 220))
			 (e2 (make-env env-any-env :length 220))
			 (i 0 (+ i 1)))
			((= i 220))
		      (outa i (env-any e1 ; try it with and without "declare"
				       (lambda (y1)
					 (* y1 (env-any e2
							(lambda (y2)
							  y2))))))))))
	(if (not (mus-arrays-equal? val1 val2))
	    (snd-display "env-any recursive: ~%;  ~A~%;  ~A" val1 val2))))
    
    (let ((ind (new-sound :size 20)))
      (select-sound ind)
      (map-channel (lambda (y) 1.0))
      (let ((bumpy (lambda ()
		     (let ((x 0.0) 
			   (xi (/ 1.0 (framples)))
			   (start 0)
			   (end 1))
		       (let ((scl (exp (/ 4.0 (- end start))))) ; normalize it
			 (map-channel (lambda (y) 
					(let ((val (if (not (< start x end))
						       0.0
						       (exp (+ (/ -1.0 (- x start))
							       (/ -1.0 (- end x)))))))
					  (set! x (+ x xi))
					  (* scl val)))))))))
	(bumpy)
	(let ((vals (channel->float-vector)))
	  (if (not (mus-arrays-equal? vals #r(0.0 0.0 0.001 0.021 0.105 0.264 0.467 0.673 0.846 0.960 1.000 0.960 0.846 0.673 0.467 0.264 0.105 0.021 0.001 0.0)))
	      (snd-display "bumpy: ~A" vals))))
      (if (fneq (channel-lp-inf) 1.0) ; just a fancy name for maxamp
	  (snd-display "channel-lp-inf: ~A" (channel-lp-inf)))
      (linear-src-channel 2.0)
      (let ((vals (channel->float-vector)))
	(if (not (mus-arrays-equal? vals #r(0.000 0.001 0.105 0.467 0.846 1.000 0.846 0.467 0.105 0.001)))
	    (snd-display "linear-src-channel: ~A" vals)))
      (let-temporarily ((*clipping* #t))
	(save-sound-as "tst.snd")
	(let ((fvals (file->floats "tst.snd")) 
	      (vals (channel->float-vector)))
	  (if (not (mus-arrays-equal? vals fvals))
	      (snd-display "file->floats: ~A ~A" vals fvals)))
	(mus-sound-forget "tst.snd")
	(delete-file "tst.snd"))
      (let ((hp (make-differentiator)))
	(map-channel (lambda (y)
		       (differentiator hp y))))
      (if (fneq (maxamp) .0013)
	  (snd-display "differentiator: ~A" (maxamp)))
      (revert-sound ind)
      (let ((val (window-rms)))
	(if (fneq val 0.0) (snd-display "window-rms empty: ~A" val))
	(set! (sample 10) 1.0)
	(set! val (window-rms))
	(if (fneq val .218) (snd-display "window-rms 1: ~A" val))
	(let ((vals (window-samples)))
	  (if (or (not (float-vector? vals))
		  (not (= (length vals) 21))
		  (fneq (vals 10) 1.0))
	      (snd-display "window-samples: ~A" vals))))
      (revert-sound ind)
      (clean-up-sound ind))
    
    (let ((gen (make-table-lookup 440.0 :wave (partials->wave '(1 1 2 1))))
	  (v0 (make-float-vector 10))
	  (v1 (make-float-vector 10)))
      (print-and-check gen 
		       "table-lookup"
		       "table-lookup freq: 440.000Hz, phase: 0.000, length: 512, interp: linear")
      (if (not (= (mus-length gen) 512)) (snd-display "table-lookup length: ~A?" (mus-length gen)))
      (let ((gen3 (mus-length (make-table-lookup))))
	(if (not (= gen3 512)) (snd-display "default table-lookup length: ~A?" gen3)))
      (do ((gen1 (make-table-lookup 440.0 :wave (partials->wave '(1 1 2 1) (make-float-vector 512))))
	   (i 0 (+ i 1)))
	  ((= i 10))
	(set! (v0 i) (table-lookup gen 0.0))
	(set! (v1 i) (mus-apply gen1 0.0)))
      (let ((v2 (make-float-vector 10)))
	(let ((gen4 (make-table-lookup 440.0 :wave (partials->wave '(1 1 2 1)))))
	  (fill-float-vector v2 (if (table-lookup? gen4) (table-lookup gen4 0.0) -1.0))
	  (if (not (mus-arrays-equal? v0 v2)) (snd-display "map table-lookup: ~A ~A" v0 v2))
	  (set! gen4 (make-table-lookup 440.0 :wave (partials->wave #r(1 1 2 1))))
	  (fill-float-vector v2 (table-lookup gen4)))
	(if (not (mus-arrays-equal? v0 v2)) (snd-display "map table-lookup (no fm): ~A ~A" v0 v2)))
      (if (not (table-lookup? gen)) (snd-display "~A not table-lookup?" gen))
      (if (not (float-vector? (mus-data gen))) (snd-display "mus-data table-lookup: ~A" (mus-data gen)))
      (if (fneq (mus-phase gen) 1.253787) (snd-display "table-lookup phase: ~F?" (mus-phase gen)))
      (set! (mus-phase gen) 1.0)
      (if (fneq (mus-phase gen) 1.0) (snd-display "set! table-lookup phase: ~F?" (mus-phase gen)))
      (if (fneq (mus-frequency gen) 440.0) (snd-display "table-lookup frequency: ~F?" (mus-frequency gen)))
      (set! (mus-frequency gen) 100.0)
      (if (fneq (mus-frequency gen) 100.0) (snd-display "set! table-lookup frequency: ~F?" (mus-frequency gen)))
      (if (or (fneq (v0 1) 0.373) (fneq (v0 8) 1.75)) (snd-display "table-lookup output: ~A" v0))
      (do ((i 0 (+ i 1)))
	  ((= i 10))
	(if (fneq (v0 i) (v1 i))
	    (snd-display "mus-apply table-lookup at ~D: ~A ~A?" i (v0 i) (v1 i)))))
    
    (let ((gen (make-table-lookup 440.0 :wave (phase-partials->wave (list 1 1 0 2 1 (* pi .5)))))
	  (v0 (make-float-vector 10)))
      (do ((i 0 (+ i 1)))
	  ((= i 10))
	(set! (v0 i) (table-lookup gen 0.0)))
      (if (or (fneq (v0 1) 1.094) (fneq (v0 8) .421)) (snd-display "table-lookup phase output: ~A" v0))
      (if (or (fneq (float-vector-peak (partials->wave '(1 1 2 1))) 1.76035475730896)
	      (fneq (float-vector-peak (partials->wave '(1 1 2 1) #f #t)) 1.0)
	      (fneq (float-vector-peak (partials->wave '(1 1 2 1 3 1 4 1) #f #t)) 1.0))
	  (snd-display "normalized partials?"))
      (set! (mus-data gen) (phase-partials->wave (list 1 1 0 2 1 (* pi .5)) #f #t)))
    
    (let ((tag (catch #t (lambda () (phase-partials->wave '(1 .3 2 .2))) (lambda args (car args)))))
      (if (not (eq? tag 'wrong-type-arg)) (snd-display "bad length arg to phase-partials->wave: ~A" tag)))
    (let ((tag (catch #t (lambda () (phase-partials->wave '("hiho" .3 2 .2))) (lambda args (car args)))))
      (if (not (eq? tag 'wrong-type-arg)) (snd-display "bad harmonic arg to phase-partials->wave: ~A" tag)))
    (let ((tag (catch #t (lambda () (phase-partials->wave ())) (lambda args (car args)))))
      (if (not (eq? tag 'no-data)) (snd-display "nil list to phase-partials->wave: ~A" tag)))
    
    (do ((vals (phase-partials->wave '(1 1 0) (make-float-vector 16) #f))
	 (i 0 (+ i 1)))
	((= i 16))
      (if (fneq (vals i) (sin (/ (* 2 pi i) 16)))
	  (snd-display "phase-partials->wave 1 1 0 at ~D: ~A ~A" i (vals i) (sin (/ (* 2 pi i) 16)))))
    
    (do ((vals (phase-partials->wave (list 1 1 (* .25 pi)) (make-float-vector 16) #f))
	 (i 0 (+ i 1)))
	((= i 16))
      (if (fneq (vals i) (sin (+ (* .25 pi) (/ (* 2 pi i) 16))))
	  (snd-display "phase-partials->wave 1 1 .25 at ~D: ~A ~A" i (vals i) (sin (+ (* .25 pi) (/ (* 2 pi i) 16))))))
    
    (do ((vals (phase-partials->wave #r(1 1 0 2 1 0) (make-float-vector 16) #f))
	 (i 0 (+ i 1)))
	((= i 16))
      (if (fneq (vals i) (+ (sin (/ (* 2 pi i) 16)) (sin (/ (* 4 pi i) 16))))
	  (snd-display "phase-partials->wave 1 1 0 2 1 0 at ~D: ~A ~A" i (vals i) 
		       (+ (sin (/ (* 2 pi i) 16)) (sin (/ (* 4 pi i) 16))))))
    
    (do ((vals (phase-partials->wave (float-vector 1 1 0 2 1 (* .5 pi)) (make-float-vector 16) #f))
	 (i 0 (+ i 1)))
	((= i 16))
      (if (fneq (vals i) (+ (sin (/ (* 2 pi i) 16)) (sin (+ (* .5 pi) (/ (* 4 pi i) 16)))))
	  (snd-display "phase-partials->wave 1 1 0 2 1 .5 at ~D: ~A ~A" i (vals i) 
		       (+ (sin (/ (* 2 pi i) 16)) (sin (+ (* .5 pi) (/ (* 4 pi i) 16)))))))
    
    (test-gen-equal (make-table-lookup 440.0 :wave (partials->wave #r(1 1 2 1)))
		    (make-table-lookup 440.0 :wave (partials->wave '(1 1 2 1)))
		    (make-table-lookup 100.0 :wave (partials->wave '(1 1 2 1))))
    (test-gen-equal (make-table-lookup 440.0 :wave (partials->wave '(1 1 2 1)))
		    (make-table-lookup 440.0 :wave (partials->wave '(1 1 2 1)))
		    (make-table-lookup 440.0 :wave (partials->wave '(1 1 2 .5))))
    (test-gen-equal (make-table-lookup-with-env 440.0 '(0 0 1 1))
		    (make-table-lookup-with-env 440.0 '(0 0 1 1))
		    (make-table-lookup-with-env 440.0 '(0 0 1 1 2 0)))
    (let ((tag (catch #t (lambda () (partials->wave '(.5 .3 .2))) (lambda args (car args)))))
      (if (not (eq? tag 'bad-type)) (snd-display "odd length arg to partials->wave: ~A" tag)))
    
    (let ((hi (mus-length (make-table-lookup :size 256))))
      (if (not (= hi 256)) (snd-display "table-lookup set length: ~A?" hi)))
    (let ((tag (catch #t (lambda () (make-table-lookup :size 0)) (lambda args (car args)))))
      (if (not (eq? tag 'out-of-range)) (snd-display "table-lookup size 0: ~A" tag)))
    
    (do ((gen (make-table-lookup 440.0 :wave (partials->wave '(1 1))))
	 (incr (/ (* 2 pi 440.0) 22050.0))
	 (i 0 (+ i 1))
	 (a 0.0))
	((= i 1100))
      (let ((val1 (sin a))
	    (val2 (gen 0.0)))
	(if (fneq val1 val2)
	    (snd-display "table lookup (1 1): ~A: ~A ~A" i val1 val2)))
      (set! a (+ a incr)))
    
    (do ((gen (make-table-lookup 4.0 :wave (partials->wave '(1 1))))
	 (incr (/ (* 2 pi 4.0) 22050.0))
	 (i 0 (+ i 1))
	 (a 0.0))
	((= i 1100))
      (let ((val1 (sin a))
	    (val2 (gen 0.0)))
	(if (fneq val1 val2)
	    (snd-display "table lookup (1 1) 4: ~A: ~A ~A" i val1 val2)))
      (set! a (+ a incr)))      
    
    (do ((gen (make-table-lookup 440.0 :wave (partials->wave '(1 .75 3 .25))))
	 (incr (/ (* 2 pi 440.0) 22050.0))
	 (i 0 (+ i 1))
	 (a 0.0))
	((= i 1100))
      (let ((val1 (+ (* .75 (sin a)) (* .25 (sin (* 3 a)))))
	    (val2 (gen 0.0)))
	(if (fneq val1 val2)
	    (snd-display "table lookup (1 .75 3 .25): ~A: ~A ~A" i val1 val2)))
      (set! a (+ a incr)))
    
    (do ((gen (make-table-lookup 0.0 :wave (partials->wave '(1 1))))
	 (gen1 (make-table-lookup 40.0 :wave (partials->wave '(1 1))))
	 (incr (/ (* 2 pi 40.0) 22050.0))
	 (a1 0.0)
	 (i 0 (+ i 1))
	 (a 0.0))
	((= i 100))
      (let ((fm (sin a))
	    (val1 (sin a1))
	    (val2 (table-lookup gen (table-lookup gen1 0.0))))
	(set! a1 (+ a1 fm))
	(if (fneq val1 val2)
	    (snd-display "lookup/lookup fm: ~A: ~A ~A" i val1 val2)))
      (set! a (+ a incr)))
    
    (for-each 
     (lambda (args)
       (let ((type (car args))
	     (vals (cadr args)))
	 (let ((tbl1 (make-table-lookup :frequency 0.0 :size 4 :type type)))
	   (float-vector-set! (mus-data tbl1) 1 1.0)
	   (let ((v (make-float-vector 10)))
	     (do ((i 0 (+ i 1)))
		 ((= i 10))
	       (set! (v i) (table-lookup tbl1 (* .1 pi))))
	     (if (not (or (mus-arrays-equal? v vals)
			  (= type mus-interp-all-pass)
			  (and (= type mus-interp-none)
			       (mus-arrays-equal? v #r(0.000 0.000 0.000 0.000 0.000 0.000 1.000 1.000 1.000 1.000)))))
		 (snd-display "tbl interp ~A: ~A" type v))
	     (if (not (= (mus-interp-type tbl1) type)) (snd-display "tbl interp-type (~A): ~A" type (mus-interp-type tbl1)))))))
     (list 
      (list mus-interp-none #r(0.000 0.000 0.000 0.000 0.000 1.000 1.000 1.000 1.000 1.000))
      (list mus-interp-linear #r(0.000 0.200 0.400 0.600 0.800 1.000 0.800 0.600 0.400 0.200))
      (list mus-interp-lagrange #r(0.000 0.120 0.280 0.480 0.720 1.000 0.960 0.840 0.640 0.360))
      (list mus-interp-all-pass #r(1.000 0.000 0.429 0.143 0.095 0.905 0.397 0.830 0.793 0.912))
      (list mus-interp-hermite #r(0.000 0.168 0.424 0.696 0.912 1.000 0.912 0.696 0.424 0.168))))
    ;; this is different if doubles -- not sure whether it's a bug or not
    
    (let ((size 1000)
	  (test-tbl (lambda (beg end freq amp mc-ratio index)
		      (let ((sine (let ((tbl-size 1024))
				    (do ((v (make-float-vector tbl-size))
					 (xp (/ (* 2 pi) tbl-size))
					 (i 0 (+ i 1))
					 (x 0.0))
					((= i tbl-size) v)
				      (set! (v i) (sin x))
				      (set! x (+ x xp))))))
			(do ((fm (make-table-lookup (* mc-ratio freq) :wave sine))
			     (carrier (make-table-lookup freq :wave sine))
			     (i beg (+ i 1)))
			    ((= i end))
			  (outa i (* amp (table-lookup carrier (* index (table-lookup fm)))))))))
	  
	  (test-fm1 (lambda (beg end freq amp mc-ratio index)
		      (do ((fm (make-oscil (* mc-ratio freq)))
			   (carrier (make-oscil freq))
			   (i beg (+ i 1)))
			  ((= i end))
			(outa i (* amp (oscil carrier (* index (oscil fm)))))))))
      
      (let ((v1 (with-sound ((make-float-vector size) :srate 44100) (test-tbl 0 size 200 1 1 1)))
	    (v2 (with-sound ((make-float-vector size) :srate 44100) (test-fm1 0 size 200 1 1 1))))
	(if (and (not (mus-arrays-equal? v1 v2))
		 (> (float-vector-peak (float-vector-subtract! v1 v2)) .002))
	    (snd-display "fm/tbl peak diff (1 1): ~A" (float-vector-peak (float-vector-subtract! v1 v2)))))
      
      (do ((i 0 (+ i 1)))
	  ((= i 10))
	(let ((ratio (+ 1 (random 4)))
	      (index (random 0.1)))
	  (let ((v1 (with-sound ((make-float-vector size) :srate 44100) (test-tbl 0 size 20 1 ratio index)))
		(v2 (with-sound ((make-float-vector size) :srate 44100) (test-fm1 0 size 20 1 ratio index))))
	    (if (and (not (mus-arrays-equal? v1 v2))
		     (> (float-vector-peak (float-vector-subtract! v1 v2)) .002))
		(snd-display "fm/tbl peak diff ~A ~A: ~A" ratio index (float-vector-peak (float-vector-subtract! v1 v2))))))))
    
    
    (let ((gen0 (make-polyshape 440.0 :coeffs (partials->polynomial '(1 1))))
	  (gen (make-polyshape 440.0 :partials '(1 1) :kind mus-chebyshev-first-kind))
	  (v0 (make-float-vector 10)))
      (print-and-check gen 
		       "polyshape"
		       "polyshape freq: 440.000Hz, phase: 0.000, coeffs[2]: [0 1]")
      (if (not (= (mus-length gen) 2)) (snd-display "polyshape length: ~A?" (mus-length gen)))
      (do ((i 0 (+ i 1)))
	  ((= i 10))
	(let ((val0 (polyshape gen0 1.0 0.0))
	      (val (polyshape gen 1.0 0.0)))
	  (if (fneq val val0) (snd-display "polyshape: ~A is not ~F?" val val0))
	  (set! (v0 i) val)))
      (let ((v1 (make-float-vector 10)))
	(let ((gen1 (make-polyshape 440.0)))
	  (fill-float-vector v1 (if (polyshape? gen1) (polyshape gen1 1.0 0.0) -1.0))
	  (if (not (mus-arrays-equal? v0 v1)) (snd-display "map polyshape: ~A ~A" v0 v1))
	  (set! gen1 (make-polyshape 440.0 :coeffs (partials->polynomial '(1 1))))
	  (fill-float-vector v1 (polyshape gen1 1.0)))
	(if (not (mus-arrays-equal? v0 v1)) (snd-display "1 map polyshape: ~A ~A" v0 v1)))
      (if (not (polyshape? gen)) (snd-display "~A not polyshape?" gen))
      (if (fneq (mus-phase gen) 1.253787) (snd-display "polyshape phase: ~F?" (mus-phase gen)))
      (set! (mus-phase gen) 1.0)
      (if (fneq (mus-phase gen) 1.0) (snd-display "set! polyshape phase: ~F?" (mus-phase gen)))
      (if (fneq (mus-frequency gen) 440.0) (snd-display "polyshape frequency: ~F?" (mus-frequency gen)))
      (set! (mus-frequency gen) 100.0)
      (if (fneq (mus-frequency gen) 100.0) (snd-display "polyshape frequency: ~F?" (mus-frequency gen)))
      (if (not (float-vector? (mus-data gen))) (snd-display "mus-data polyshape: ~A" (mus-data gen)))
      (if (or (fneq (v0 1) 0.992) (fneq (v0 8) 0.538)) (snd-display "polyshape output: ~A" v0))
      (set! (mus-data gen0) (make-float-vector 32))
      (set! (mus-length gen0) 32)
      (if (not (= (mus-length gen0) 32)) (snd-display "set mus-length polyshape: ~A" (mus-length gen0))))
    
    (test-gen-equal (make-polyshape 440.0 :partials '(1 1)) 
		    (make-polyshape 440.0) 
		    (make-polyshape 100.0 :partials '(1 1)))
    (test-gen-equal (make-polyshape 440.0 :partials '(1 1)) 
		    (make-polyshape 440.0)
		    (make-polyshape 440.0 :partials '(1 1 2 .5)))
    (test-gen-equal (make-polyshape 440.0 :partials '(1 1)) 
		    (make-polyshape 440.0 :partials #r(1 1))
		    (make-polyshape 440.0 :partials '(1 .5)))
    (test-gen-equal (make-polyshape 440.0 :partials '(1 .1 2 1 3 .5))
		    (make-polyshape 440.0 :partials #r(1 .1 2 1 3 .5))
		    (make-polyshape 440.0 :partials '(1 .1 2 .1 3 .5)))
    
    (do ((gen (make-polyshape 440.0 :partials '(1 1)))
	 (happy #t)
	 (i 0 (+ i 1)))
	((or (not happy) (= i 1100)))
      (let* ((val1 (cos (mus-phase gen)))
	     (val2 (gen 1.0 0.0)))
	(when (fneq val1 val2)
	  (snd-display "polyshaper (1 1) ~A: ~A ~A" i val1 val2)
	  (set! happy #f))))
    
    (do ((gen (make-polyshape 440.0)) ; check default for partials: '(1 1)
	 (happy #t)
	 (i 0 (+ i 1)))
	((or (not happy)
	     (= i 1100)))
      (let* ((val1 (cos (mus-phase gen)))
	     (val2 (gen 1.0 0.0)))
	(when (fneq val1 val2)
	  (snd-display "polyshaper default: '(1 1) ~A: ~A ~A" i val1 val2)
	  (set! happy #f))))
    
    (do ((gen (make-polyshape 440.0 :partials #r(1 1)))
	 (happy #t)
	 (i 0 (+ i 1)))
	((or (not happy) (= i 1100)))
      (let* ((val1 (* .5 (cos (mus-phase gen))))
	     (val2 (gen 0.5 0.0)))
	(when (fneq val1 val2)
	  (snd-display "polyshaper (1 1) .5 index ~A: ~A ~A" i val1 val2)
	  (set! happy #f))))
    
    (let ((var (catch #t (lambda () (make-polyshape 440.0 :coeffs 3.14)) (lambda args args))))
      (if (not (eq? (car var) 'wrong-type-arg))
	  (snd-display "make-polyshape bad coeffs: ~A" var)))
    
    (do ((gen (make-polyshape 0.0 :coeffs (partials->polynomial '(1 1))))
	 (gen1 (make-polyshape 40.0 :coeffs (partials->polynomial '(1 1))))
	 (a1 0.0)
	 (incr (/ (* 2 pi 40.0) 22050.0))
	 (happy #t)
	 (i 0 (+ i 1))
	 (a 0.0))
	((or (not happy) (= i 400)))
      (let ((fm (cos a))
	    (val1 (cos a1))
	    (val2 (polyshape gen 1.0 (polyshape gen1 1.0))))
	(set! a1 (+ a1 fm))
	(when (> (abs (- val1 val2)) .002)
	  (snd-display "polyshape fm: ~A: ~A ~A" i val1 val2)
	  (set! happy #f)))
      (set! a (+ a incr)))
    
    (for-each 
     (lambda (amps name)
       (let ((data1 (make-float-vector 100))
	     (data2 (make-float-vector 100))
	     (data3 (make-float-vector 100))
	     (n (length amps))
	     (incr (hz->radians 1.0)))
	 (do ((i 0 (+ i 1))
	      (angle 0.0 (+ angle incr)))
	     ((= i 100))
	   (float-vector-set! data1 i (mus-chebyshev-t-sum angle amps)))
	 
	 (do ((k 0 (+ k 1))
	      (kincr 0.0 (+ kincr incr)))
	     ((= k n))
	   (do ((i 0 (+ i 1))
		(angle 0.0 (+ angle kincr)))
	       ((= i 100))
	     (float-vector-set! data3 i (cos angle)))
	   (float-vector-scale! data3 (float-vector-ref amps k))
	   (float-vector-add! data2 data3))
	 
	 (let-temporarily ((*mus-float-equal-fudge-factor* .0001))
	   (if (not (mus-arrays-equal? data1 data2))
	       (snd-display "~A: ~A~%~A~%" name data1 data2)))))
     
     (list #r(0.0 1.0)
	   #r(0.0 0.5 0.25 0.25)
	   (make-float-vector 100 0.01)
	   (make-float-vector 1000 0.001))
     '(one-cos
       three-cos
       hundred-cos
       thousand-cos))
    
    (for-each 
     (lambda (amps name)
       (let ((data1 (make-float-vector 100))
	     (data2 (make-float-vector 100))
	     (data3 (make-float-vector 100))
	     (n (length amps))
	     (incr (hz->radians 1.0)))
	 (do ((i 0 (+ i 1))
	      (angle 0.0 (+ angle incr)))
	     ((= i 100))
	   (float-vector-set! data1 i (mus-chebyshev-u-sum angle amps)))
	 
	 (do ((k 0 (+ k 1))
	      (kincr 0.0 (+ kincr incr)))
	     ((= k n))
	   (do ((i 0 (+ i 1))
		(angle 0.0 (+ angle kincr)))
	       ((= i 100))
	     (float-vector-set! data3 i (sin angle)))
	   (float-vector-scale! data3 (float-vector-ref amps k))
	   (float-vector-add! data2 data3))
	 
	 (let-temporarily ((*mus-float-equal-fudge-factor* .0001))
	   (if (not (mus-arrays-equal? data1 data2))
	       (snd-display "~A: ~A~%~A~%" name data1 data2)))))
     
     (list #r(0.0 1.0)
	   #r(0.0 0.5 0.25 0.25)
	   (make-float-vector 100 0.01)
	   (make-float-vector 1000 0.001))
     '(one-sin
       three-sin
       hundred-sin
       thousand-sin))
    
    (for-each 
     (lambda (camps samps name)
       (let ((data1 (make-float-vector 100))
	     (data2 (make-float-vector 100))
	     (data3 (make-float-vector 100))
	     (n (length camps))
	     (incr (hz->radians 1.0)))
	 (do ((i 0 (+ i 1))
	      (angle 0.0 (+ angle incr)))
	     ((= i 100))
	   (float-vector-set! data1 i (mus-chebyshev-tu-sum angle camps samps)))
	 
	 (do ((k 0 (+ k 1))
	      (kincr 0.0 (+ kincr incr)))
	     ((= k n))
	   (do ((i 0 (+ i 1))
		(angle 0.0 (+ angle kincr)))
	       ((= i 100))
	     (float-vector-set! data3 i (sin angle)))
	   (float-vector-scale! data3 (float-vector-ref samps k))
	   (float-vector-add! data2 data3)
	   (do ((i 0 (+ i 1))
		(angle 0.0 (+ angle kincr)))
	       ((= i 100))
	     (float-vector-set! data3 i (cos angle)))
	   (float-vector-scale! data3 (float-vector-ref camps k))
	   (float-vector-add! data2 data3))
	 
	 (let-temporarily ((*mus-float-equal-fudge-factor* .0001))
	   (if (not (mus-arrays-equal? data1 data2))
	       (snd-display "~A: ~A~%~A~%" name data1 data2)))))
     
     (list #r(0.0 1.0)
	   #r(0.0 0.25 0.0 0.25)
	   (make-float-vector 100 .004)
	   (make-float-vector 1000 0.0005))
     (list #r(0.0 0.0)
	   #r(0.0 0.25 0.25 0.0)
	   (make-float-vector 100 .006)
	   (make-float-vector 1000 0.0005))
     '(one-tu
       three-tu
       hundred-tu
       thousand-tu))
    
    ;; polywave
    (let ((gen (make-polywave 440.0 :partials '(1 1) :type mus-chebyshev-first-kind))
	  (v0 (make-float-vector 10)))
      (print-and-check gen 
		       "polywave"
		       "polywave freq: 440.000Hz, phase: 0.000, coeffs[2]: [0 1]")
      (if (not (= (mus-length gen) 2)) (snd-display "polywave length: ~A?" (mus-length gen)))
      
      (do ((gen0 (make-polywave 440.0 '(1 1)))
	   (i 0 (+ i 1)))
	  ((= i 10))
	(let ((val0 (polywave gen0 0.0))
	      (val (polywave gen 0.0)))
	  (if (fneq val val0) (snd-display "polywave: ~A is not ~F?" val val0))
	  (set! (v0 i) val)))
      (let ((gen1 (make-polywave 440.0))
	    (v1 (make-float-vector 10)))  
	(fill-float-vector v1 (if (polywave? gen1) (polywave gen1 0.0) -1.0))
	(if (not (mus-arrays-equal? v0 v1)) (snd-display "map polywave: ~A ~A" v0 v1))
	(set! gen1 (make-polywave 440.0 #r(1 1)))
	(fill-float-vector v1 (polywave gen1))
	(if (not (mus-arrays-equal? v0 v1)) (snd-display "1 map polywave: ~A ~A" v0 v1)))
      (if (not (polywave? gen)) (snd-display "~A not polywave?" gen))
      (if (fneq (mus-phase gen) 1.253787) (snd-display "polywave phase: ~F?" (mus-phase gen)))
      (set! (mus-phase gen) 1.0)
      (if (fneq (mus-phase gen) 1.0) (snd-display "set! polywave phase: ~F?" (mus-phase gen)))
      (if (fneq (mus-frequency gen) 440.0) (snd-display "polywave frequency: ~F?" (mus-frequency gen)))
      (set! (mus-frequency gen) 100.0)
      (if (fneq (mus-frequency gen) 100.0) (snd-display "polywave frequency: ~F?" (mus-frequency gen)))
      (if (not (float-vector? (mus-data gen))) (snd-display "mus-data polywave: ~A" (mus-data gen)))
      (if (or (fneq (v0 1) 0.992) (fneq (v0 8) 0.538)) (snd-display "polywave output: ~A" v0)))
    
    (test-gen-equal (make-polywave 440.0 :partials '(1 1)) 
		    (make-polywave 440.0) 
		    (make-polywave 100.0 :partials '(1 1)))
    (test-gen-equal (make-polywave 440.0 '(1 1)) 
		    (make-polywave 440.0)
		    (make-polywave 440.0 '(1 1 2 .5)))
    (test-gen-equal (make-polywave 440.0 '(1 1)) 
		    (make-polywave 440.0 #r(1 1))
		    (make-polywave 440.0 '(1 .5)))
    (test-gen-equal (make-polywave 440.0 '(1 .1 2 1 3 .5))
		    (make-polywave 440.0 #r(1 .1 2 1 3 .5))
		    (make-polywave 440.0 '(1 .1 2 .1 3 .5)))
    
    (do ((gen (make-polywave 440.0 '(1 1)))
	 (happy #t)
	 (i 0 (+ i 1)))
	((or (not happy) (= i 1100)))
      (let* ((val1 (cos (mus-phase gen)))
	     (val2 (gen 0.0)))
	(when (fneq val1 val2)
	  (snd-display "polywaver (1 1) ~A: ~A ~A" i val1 val2)
	  (set! happy #f))))
    
    (do ((gen (make-polywave 440.0)) ; check default for partials: '(1 1)
	 (happy #t)
	 (i 0 (+ i 1)))
	((or (not happy) (= i 1100)))
      (let* ((val1 (cos (mus-phase gen)))
	     (val2 (gen 0.0)))
	(when (fneq val1 val2)
	  (snd-display "polywaver default: '(1 1) ~A: ~A ~A" i val1 val2)
	  (set! happy #f))))
    
    (let ((gen (make-polywave 440.0 #r(1 1)))
	  (happy #t))
      (set! (mus-scaler gen) 0.5)
      (do ((i 0 (+ i 1)))
	  ((or (not happy) (= i 1100)))
	(let* ((val1 (* .5 (cos (mus-phase gen))))
	       (val2 (gen 0.0)))
	  (when (fneq val1 val2)
	    (snd-display "polywaver (1 1) .5 index ~A: ~A ~A" i val1 val2)
	    (set! happy #f)))))
    
    (let-temporarily ((*clm-srate* 44100))
      (let ((v0 (make-float-vector 4410))
	    (v1 (make-float-vector 4410)))
	(for-each
	 (lambda (k)
	   (let ((gen (make-polywave 100.0 (list 1 0.5 k 0.5)))
		 (incr (/ (* 2.0 pi 100.0) 44100))
		 (kincr (/ (* 2.0 k pi 100.0) 44100)))
	     (do ((i 0 (+ i 1)))
		 ((= i 4410))
	       (set! (v0 i) (polywave gen)))
	     (do ((i 0 (+ i 1))
		  (ph 0.0 (+ ph incr))
		  (kph 0.0 (+ kph kincr)))
		 ((= i 4410))
	       (float-vector-set! v1 i (+ (cos ph) (cos kph)))))
	   (float-vector-scale! v1 0.5)
	   (if (not (mus-arrays-equal? v0 v1))
	       (snd-display "polywave ~D vs cos: ~A" k (float-vector-peak-and-location (float-vector-subtract! v0 v1)))))
       '(2 19 20 29 30 39 40 60 100)))
      
      (for-each
       (lambda (n)
	 (do ((gen1 (make-polywave 100.0 (list n 1.0)))
	      (gen2 (make-oscil (* n 100.0) (/ pi 2)))
	      (happy #t)
	      (i 0 (+ i 1)))
	     ((or (not happy) (= i 1000)))
	   (let ((val1 (polywave gen1))
		 (val2 (oscil gen2)))
	     (when (fneq val1 val2)
	       (set! happy #f)
	       (snd-display "polywave ~A at ~A: ~A ~A" n i val1 val2)))))
       '(1 8 50 128))
      
      (for-each
       (lambda (n)
	 (do ((gen1 (make-polywave 100.0 (list n 1.0) mus-chebyshev-second-kind))
	      (gen2 (make-oscil (* n 100.0)))
	      (happy #t)
	      (i 0 (+ i 1)))
	     ((or (not happy) (= i 1000)))
	   (let ((val1 (polywave gen1))
		 (val2 (oscil gen2)))
	     (when (fneq val1 val2)
	       (set! happy #f)
	       (snd-display "polywave second ~A at ~A: ~A ~A" n i val1 val2)))))
       '(1 8 50 128))
      
      (for-each
       (lambda (n)
	 (do ((gen1 (make-polyshape 100.0 :partials (list n 1.0)))
	      (gen2 (make-oscil (* n 100.0) (/ pi 2)))
	      (happy #t)
	      (i 0 (+ i 1)))
	     ((or (not happy) (= i 1000)))
	   (let ((val1 (polyshape gen1))
		 (val2 (oscil gen2)))
	     (when (fneq val1 val2)
	       (set! happy #f)
	       (snd-display "polyshape ~A at ~A: ~A ~A" n i val1 val2)))))
       '(1 8 16))
      
      (for-each
       (lambda (n)
	 (do ((gen1 (make-polyshape 100.0 :partials (list n 1.0) :kind mus-chebyshev-second-kind))
	      (gen2 (make-oscil (* n 100.0)))
	      (happy #t)
	      (i 0 (+ i 1)))
	     ((or (not happy) (= i 1000)))
	   (let ((val1 (polyshape gen1))
		 (val2 (oscil gen2)))
	     (when (fneq val1 val2)
	       (set! happy #f)
	       (snd-display "polyshape second ~A at ~A: ~A ~A" n i val1 val2)))))
       '(1 8 16))
      
      (for-each
       (lambda (n)
	 (do ((gen1 (make-polywave 100.0 (list n 1.0) mus-chebyshev-first-kind))
	      (gen2 (make-oscil (* n 100.0) (/ pi 2)))
	      (max-dist 0.0)
	      (i 0 (+ i 1)))
	     ((= i 1000)
	      (if (fneq max-dist 0.0)
		  (snd-display "polywave run ~A: ~A" n max-dist)))
	   (let ((val1 (polywave gen1))
		 (val2 (oscil gen2)))
	     (set! max-dist (max max-dist (abs (- val1 val2)))))))
       '(1 3 30 200))
      
      (for-each
       (lambda (n)
	 (do ((gen1 (make-polywave 100.0 (list n 1.0) mus-chebyshev-second-kind))
	      (gen2 (make-oscil (* n 100.0)))
	      (max-dist 0.0)
	      (i 0 (+ i 1)))
	     ((= i 1000)
	      (if (fneq max-dist 0.0)
		  (snd-display "polywave second run ~A: ~A" n max-dist)))
	   (let ((val1 (polywave gen1))
		 (val2 (oscil gen2)))
	     (set! max-dist (max max-dist (abs (- val1 val2)))))))
       '(1 3 30 200))
      
      (for-each
       (lambda (n)
	 (do ((gen1 (make-polyshape 100.0 :partials (list n 1.0) :kind mus-chebyshev-first-kind))
	      (gen2 (make-oscil (* n 100.0) (/ pi 2)))
	      (max-dist 0.0)
	      (i 0 (+ i 1)))
	     ((= i 1000)
	      (if (fneq max-dist 0.0)
		  (snd-display "polyshape run ~A: ~A" n max-dist)))
	   (let ((val1 (polyshape gen1))
		 (val2 (oscil gen2)))
	     (set! max-dist (max max-dist (abs (- val1 val2)))))))
       '(1 3 25))
      
      (for-each
       (lambda (n)
	 (do ((gen1 (make-polyshape 100.0 :partials (list n 1.0) :kind mus-chebyshev-second-kind))
	      (gen2 (make-oscil (* n 100.0)))
	      (max-dist 0.0)
	      (i 0 (+ i 1)))
	     ((= i 1000)
	      (if (fneq max-dist 0.0)
		  (snd-display "polyshape second run ~A: ~A" n max-dist)))
	   (let ((val1 (polyshape gen1))
		 (val2 (oscil gen2)))
	     (set! max-dist (max max-dist (abs (- val1 val2)))))))
       '(1 3 25))
      
      (let* ((gen (make-polywave 100.0 '(1 .9 3 .1 4 0.0)))
	     (vals (mus-data gen)))
	(if (not (and (float-vector? vals)
		      (mus-arrays-equal? vals #r(0.000 0.900 0.000 0.100 0.00))))
	    (snd-display "polywave mus-data: ~A" vals)
	    (begin
	      (float-vector-set! (mus-data gen) 2 .1)
	      (float-vector-set! (mus-data gen) 3 0.0)
	      (do ((happy #t)
		   (gen1 (make-oscil 100.0 (/ pi 2)))
		   (gen2 (make-oscil 200.0 (/ pi 2)))
		   (i 0 (+ i 1)))
		  ((or (not happy) (= i 1000)))
		(let ((val1 (polywave gen))
		      (val2 (+ (* .9 (oscil gen1))
			       (* .1 (oscil gen2)))))
		  (when (fneq val1 val2)
		    (set! happy #f)
		    (snd-display "polywave set mus-data at ~A: ~A ~A" i val1 val2))))))))
    ;; check dc 
    (do ((i 2 (+ i 1)))
	((= i 7))
      (do ((cfs (make-list (* 2 i) 0.1))
	   (k 0 (+ k 2)))
	  ((>= k (length cfs))
	   (let ((val (polywave (make-polywave 100.0 cfs mus-chebyshev-second-kind))))
	     (if (fneq val 0.1)
		 (snd-display "polywave ~D order second 0-coeff: ~A" i val))))
	(set! (cfs k) (/ k 2))))
      
    (do ((i 2 (+ i 1)))
	((= i 7))
      (let ((cfs (make-list (* 2 i) 0.1)))
	(do ((k 0 (+ k 2)))
	    ((>= k (length cfs)))
	  (set! (cfs k) (/ k 2)))
	(let ((val (polywave (make-polywave 100.0 cfs mus-chebyshev-first-kind))))
	  (if (fneq val (* 0.1 i))
	      (snd-display "polywave ~D order first 0-coeff: ~A" i val)))))

    (let ((var (catch #t (lambda () (make-polywave 440.0 3.14)) (lambda args args))))
      (if (not (eq? (car var) 'wrong-type-arg))
	  (snd-display "make-polywave bad coeffs: ~A" var)))
    
    (let ((gen (make-wave-train 440.0 0.0 (make-float-vector 20)))
	  (v0 (make-float-vector 10)))
      (print-and-check gen 
		       "wave-train"
		       "wave-train freq: 440.000Hz, phase: 0.000, size: 20, interp: linear")
      (let ((gen1 (make-wave-train 440.0 0.0 (make-float-vector 20)))
	    (v1 (make-float-vector 10)))
	(do ((i 0 (+ i 1)))
	    ((= i 20))
	  (float-vector-set! (mus-data gen) i (* i .5))
	  (float-vector-set! (mus-data gen1) i ((mus-data gen) i)))
	(if (not (= (length (mus-data gen)) 20)) (snd-display "wave-train data length: ~A?" (length (mus-data gen))))
	(if (not (= (mus-length gen) 20)) (snd-display "wave-train length: ~A?" (mus-length gen)))
	(do ((i 0 (+ i 1)))
	    ((= i 10))
	  (set! (v0 i) (wave-train gen 0.0)))
	(fill-float-vector v1 (if (wave-train? gen1) (wave-train gen1) -1.0))
	(if (not (mus-arrays-equal? v0 v1)) (snd-display "map wave-train: ~A ~A" v0 v1)))
      (if (not (wave-train? gen)) (snd-display "~A not wave-train?" gen))
      (if (fneq (mus-phase gen) 0.0) (snd-display "wave-train phase: ~F?" (mus-phase gen)))
      (set! (mus-phase gen) 1.0)
      (if (fneq (mus-phase gen) 1.0) (snd-display "set wave-train phase: ~F?" (mus-phase gen)))
      (if (fneq (mus-frequency gen) 440.0) (snd-display "wave-train frequency: ~F?" (mus-frequency gen)))
      (set! (mus-frequency gen) 100.0)
      (if (fneq (mus-frequency gen) 100.0) (snd-display "set wave-train freq: ~A" (mus-frequency gen)))
      (if (or (fneq (v0 1) 0.5) (fneq (v0 8) 4.0)) (snd-display "wave-train output: ~A" v0))
      (mus-reset gen)
      (if (fneq (mus-phase gen) 0.0) (snd-display "wt reset phase: ~A" (mus-phase gen)))
      (let ((val (wave-train gen 0.0)))
	(if (fneq val 0.0) (snd-display "wt reset data: ~A" val)))
      (if (not (float-vector? (mus-data gen))) (snd-display "mus-data wave-train: ~A" (mus-data gen)))
      (set! (mus-data gen) (make-float-vector 3)))
    
    (test-gen-equal (make-wave-train 440.0 0.0 (make-float-vector 20)) (make-wave-train 440.0 0.0 (make-float-vector 20)) (make-wave-train 100.0 0.0 (make-float-vector 20)))
    (test-gen-equal (make-wave-train 440.0 0.0 (make-float-vector 20)) (make-wave-train 440.0 0.0 (make-float-vector 20)) (make-wave-train 440.0 1.0 (make-float-vector 20)))
    
    (test-gen-equal (make-wave-train-with-env 440.0 '(0 0 1 1))
		    (make-wave-train-with-env 440.0 (list 0 0 1 1))
		    (make-wave-train-with-env 440.0 '(0 0 1 1 2 0)))
    
    (let ((hi (make-wave-train :size 256)))
      (if (not (= (mus-length hi) 256)) (snd-display "wave-train set length: ~A?" (mus-length hi)))
      (set! (mus-length hi) 128)
      (if (not (= (mus-length hi) 128)) (snd-display "set wave-train set length: ~A?" (mus-length hi))))
    
    (for-each 
     (lambda (args)
       (let ((type (car args))
	     (vals (cadr args)))
	 (let ((tbl1 (make-wave-train :frequency 3000.0 :initial-phase (/ (* 2.0 pi .2) 4) :size 4 :type type)))
	   (float-vector-set! (mus-data tbl1) 1 1.0)
	   (let ((v (make-float-vector 10)))
	     (do ((i 0 (+ i 1)))
		 ((= i 10))
	       (set! (v i) (wave-train tbl1 0.0))) ;(wave-train tbl1 (/ (* 2 pi .2) 4))))
	     (if (not (mus-arrays-equal? v vals))
		 (snd-display "wt tbl interp ~A: ~A ~A" type v (mus-describe tbl1)))
	     (if (not (= (mus-interp-type tbl1) type)) (snd-display "wt tbl interp-type (~A): ~A" type (mus-interp-type tbl1)))))))
     (list 
      (list mus-interp-none #r(0.000 1.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 1.000))
      (list mus-interp-linear #r(0.200 0.800 0.000 0.000 0.000 0.000 0.000 0.000 0.200 0.800))
      (list mus-interp-lagrange #r(0.120 0.960 -0.080 0.000 0.000 0.000 0.000 0.000 0.120 0.960))
      (list mus-interp-hermite #r(0.168 0.912 -0.064 -0.016 0.000 0.000 0.000 0.000 0.168 0.912))))
    
    (let ((tag (catch #t (lambda () (make-wave-train :size 0)) (lambda args (car args)))))
      (if (not (eq? tag 'out-of-range)) (snd-display "wave-train size 0: ~A" tag)))
    
    (let ((ind (new-sound "fmv.snd" :size 10 :comment "line 20501")))
      (if (not (= (framples) 10)) (snd-display "new-sound size(10): ~A" (framples)))
      (map-channel (lambda (y) 1.0) 7 8)
      (if (not (= (framples) 15)) (snd-display "map-channel 7 8: ~A" (framples)))
      (map-channel (lambda (y) 1.0))
      (if (not (= (framples) 15)) (snd-display "map-channel (no dur): ~A" (framples)))
      (revert-sound ind)
      (map-channel (lambda (y) 1.0) 9 10)
      (if (not (= (framples) 19)) (snd-display "map-channel 9 10: ~A" (framples)))
      (if (> (edit-position ind 0) 2) (snd-display "map-channel pad edits: ~A" (edit-position ind 0)))
      (revert-sound ind)
      (map-channel (lambda (y) 1.0) 10 10)
      (if (not (= (framples) 20)) (snd-display "map-channel 10 10: ~A" (framples)))
      (if (> (edit-position ind 0) 2) (snd-display "map-channel pad edits (2): ~A" (edit-position ind 0)))
      (revert-sound ind)
      (map-channel (lambda (y) 1.0) 20 10)
      (if (not (= (framples) 30)) (snd-display "map-channel 20 10: ~A" (framples)))
      (if (> (edit-position ind 0) 2) (snd-display "map-channel pad edits (3): ~A" (edit-position ind 0)))
      (revert-sound ind)
      (if (scan-channel (lambda (y) #f) 30 10) (snd-display "scan-channel past end?"))
      (clean-up-sound ind))
    
    (let ((ind (new-sound :size 1000))
	  (gen (make-wave-train 1000.0 :wave #r(0.0 .1 .2 .3 .4 .5 .6))))
      (map-channel (lambda (y) (wave-train gen)))
      (let ((mx (maxamp)))
	(if (fneq mx 0.6) (snd-display "wt 0 max: ~A" mx)))
      (if (not (mus-arrays-equal? (channel->float-vector 0 30) 
		       #r(0.000 0.100 0.200 0.300 0.400 0.500 0.600 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 
				     0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.100 0.200 0.300 0.400 0.500 0.600)))
	  (snd-display "wt 0 data: ~A" (channel->float-vector 0 30)))
      (if (not (mus-arrays-equal? (channel->float-vector 85 30) 
		       #r(0.000 0.000 0.000 0.000 0.000 0.100 0.200 0.300 0.400 0.500 0.600 0.000 0.000 0.000 0.000 
				     0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.100 0.200 0.300)))
	  (snd-display "wt 0 data 85: ~A" (channel->float-vector 85 30)))
      (undo)
      
      (let ((gen (make-wave-train 1000.0 :initial-phase pi :wave (make-float-vector 10 .1)))) ; initial-phase is confusing in this context!
	(map-channel (lambda (y) (wave-train gen))))
      (let ((mx (maxamp)))
	(if (fneq mx 0.1) (snd-display "wt 1 max: ~A" mx)))
      (if (not (mus-arrays-equal? (channel->float-vector 0 30) 
		       #r(0.100 0.100 0.100 0.100 0.100 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 
				     0.000 0.000 0.000 0.100 0.100 0.100 0.100 0.100 0.100 0.100 0.100 0.100 0.100 0.000 0.000)))
	  (let-temporarily ((*print-length* 32))
	    (snd-display "wt 1 data: ~A" (channel->float-vector 0 30))))
      (undo)
      
      (let ((gen (make-wave-train 2000.0 :wave (make-float-vector 10 .1))))
	(map-channel (lambda (y) (wave-train gen))))
      (let ((mx (maxamp)))
	(if (fneq mx 0.1) (snd-display "wt 2 max: ~A" mx)))
      (if (not (mus-arrays-equal? (channel->float-vector 0 30) 
		       #r(0.100 0.100 0.100 0.100 0.100 0.100 0.100 0.100 0.100 0.100 0.000 0.000 0.100 0.100 0.100 
				     0.100 0.100 0.100 0.100 0.100 0.100 0.100 0.000 0.100 0.100 0.100 0.100 0.100 0.100 0.100)))
	  (snd-display "wt 2 data: ~A" (channel->float-vector 0 30)))
      (if (not (or (mus-arrays-equal? (channel->float-vector 440 30) 
			   #r(0.000 0.100 0.100 0.100 0.100 0.100 0.100 0.100 0.100 0.100 0.100 0.000 0.000 0.100 0.100 
					 0.100 0.100 0.100 0.100 0.100 0.100 0.100 0.100 0.000 0.100 0.100 0.100 0.100 0.100 0.100))
		   ;; if double, round off is just enough different to cause an off-by-1 problem here (and below)
		   (mus-arrays-equal? (channel->float-vector 440 30) 
			   #r(0.000 0.000 0.100 0.100 0.100 0.100 0.100 0.100 0.100 0.100 0.100 0.100 0.000 0.100 0.100 
					 0.100 0.100 0.100 0.100 0.100 0.100 0.100 0.100 0.000 0.100 0.100 0.100 0.100 0.100 0.100))))
	  (snd-display "wt 2 data 440: ~A" (channel->float-vector 440 30)))
      (undo)
      
      (let ((gen (make-wave-train 3000.0 :wave (make-float-vector 10 .1))))
	(map-channel (lambda (y) (wave-train gen))))
      (let ((mx (maxamp)))
	(if (fneq mx 0.2) (snd-display "wt 3 max: ~A" mx)))
      (if (not (mus-arrays-equal? (channel->float-vector 0 30) 
		       #r(0.100 0.100 0.100 0.100 0.100 0.100 0.100 0.100 0.200 0.200 0.100 0.100 0.100 0.100 0.100 
				     0.200 0.200 0.200 0.100 0.100 0.100 0.100 0.100 0.200 0.200 0.100 0.100 0.100 0.100 0.100)))
	  (snd-display "wt 3 data: ~A" (channel->float-vector 0 30)))
      (if (not (mus-arrays-equal? (channel->float-vector 440 30) 
		       #r(0.100 0.200 0.200 0.200 0.100 0.100 0.100 0.100 0.100 0.200 0.200 0.100 0.100 0.100 0.100 
				     0.100 0.200 0.200 0.200 0.100 0.100 0.100 0.100 0.100 0.200 0.200 0.100 0.100 0.100 0.100)))
	  (snd-display "wt 3 data 440: ~A" (channel->float-vector 440 30)))
      (undo)
      
      (let ((gen (make-wave-train 5000.0 :wave (make-float-vector 10 .1))))
	(map-channel (lambda (y) (wave-train gen))))
      (let ((mx (maxamp)))
	(if (fneq mx 0.3) (snd-display "wt 4 max: ~A" mx)))
      (if (not (mus-arrays-equal? (channel->float-vector 0 30) 
		       #r(0.100 0.100 0.100 0.100 0.100 0.200 0.200 0.200 0.200 0.300 0.200 0.200 0.200 0.200 0.300 
				     0.200 0.200 0.200 0.300 0.200 0.200 0.200 0.200 0.300 0.200 0.200 0.200 0.300 0.200 0.200)))
	  (snd-display "wt 4 data: ~A" (channel->float-vector 0 30)))
      (if (not (mus-arrays-equal? (channel->float-vector 440 30) 
		       #r(0.200 0.200 0.300 0.200 0.200 0.200 0.300 0.200 0.200 0.200 0.300 0.300 0.200 0.200 0.200 
				     0.300 0.200 0.200 0.200 0.300 0.200 0.200 0.200 0.200 0.300 0.200 0.200 0.200 0.300 0.200)))
	  (snd-display "wt 4 data 440: ~A" (channel->float-vector 440 30)))
      (undo)
      
      (let ((gen (make-wave-train 1000.0 :wave (make-float-vector 10 .1))))
	(let ((base-freq (mus-frequency gen))
	      (e (make-env '(0 1 1 2) :length 1001)))
	  (map-channel 
	   (lambda (y) 
	     (let ((result (wave-train gen)))
	       (set! (mus-frequency gen) (* base-freq (env e)))
	       result)))))
      (let ((mx (maxamp)))
	(if (fneq mx 0.1) (snd-display "wt 5 max: ~A" mx)))
      (if (not (mus-arrays-equal? (channel->float-vector 0 30) 
				  #r(0.100 0.100 0.100 0.100 0.100 0.100 0.100 0.100 0.100 0.100 0.000 0.000 0.000 0.000 0.000 
						0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.100 0.100 0.100 0.100 0.100 0.100 0.100)))
	  (snd-display "wt 5 data: ~A" (channel->float-vector 0 30)))
      (if (not (mus-arrays-equal? (channel->float-vector 440 30) 
				  #r(0.100 0.100 0.100 0.100 0.100 0.100 0.100 0.100 0.000 0.000 0.000 0.000 0.000 0.000 0.100 
						0.100 0.100 0.100 0.100 0.100 0.100 0.100 0.100 0.100 0.000 0.000 0.000 0.000 0.000 0.100)))
	  (snd-display "wt 5 data 440: ~A" (channel->float-vector 440 30)))
      (if (not (mus-arrays-equal? (channel->float-vector 900 30) 
				  #r(0.100 0.000 0.000 0.100 0.100 0.100 0.100 0.100 0.100 0.100 0.100 0.100 0.100 0.000 0.100 
						0.100 0.100 0.100 0.100 0.100 0.100 0.100 0.100 0.100 0.000 0.000 0.100 0.100 0.100 0.100)))
	  (snd-display "wt 5 data 900: ~A" (channel->float-vector 900 30)))
      (undo)
      
      (let ((gen (make-wave-train 500.0 :wave (make-float-vector 10 .1)))
	    (ctr 0))
	(map-channel 
	 (lambda (y) 
	   (let ((result (wave-train gen)))
	     (if (> ctr 22)
		 (begin
		   (set! ctr 0)
		   (float-vector-scale! (mus-data gen) 1.05))
		 (set! ctr (+ ctr 1)))
	     result))))
      (let ((mx (maxamp)))
	(if (fneq mx 0.704) (snd-display "wt 6 max: ~A" mx)))
      (if (not (mus-arrays-equal? (channel->float-vector 0 30) 
		       #r(0.100 0.100 0.100 0.100 0.100 0.100 0.100 0.100 0.100 0.100 0.000 0.000 0.000 0.000 0.000 
				     0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000)))
	  (snd-display "wt 6 data: ~A" (channel->float-vector 0 30)))
      (if (not (or (mus-arrays-equal? (channel->float-vector 440 30) 
			   #r(0.000 0.241 0.241 0.241 0.241 0.241 0.241 0.241 0.241 0.241 0.241 0.000 0.000 0.000 0.000
					 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000))
		   (mus-arrays-equal? (channel->float-vector 440 30) 
			   #r(0.000 0.000 0.241 0.241 0.241 0.241 0.241 0.241 0.241 0.241 0.241 0.241 0.000 0.000 0.000 0.000
					 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000))))
	  (snd-display "wt 6 data 440: ~A" (channel->float-vector 440 30)))
      (if (not (mus-arrays-equal? (channel->float-vector 900 30) 
		       #r(0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 
				     0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.639 0.639 0.639)))
	  (snd-display "wt 6 data 900: ~A" (channel->float-vector 900 30)))
      (undo)
      (let ((fname (file-name ind)))
	(close-sound ind)
	(delete-file fname)))
    
    (let ((gen (make-readin "oboe.snd" 0 1490))
	  (v0 (make-float-vector 10)))
      (print-and-check gen 
		       "readin"
		       "readin oboe.snd[chan 0], loc: 1490, dir: 1")
      (let ((gen1 (make-readin "oboe.snd" 0 1490))
	    (v1 (make-float-vector 10)))
	(do ((i 0 (+ i 1)))
	    ((= i 10))
	  (set! (v0 i) (readin gen)))
	(fill-float-vector v1 (if (readin? gen1) 
				  (if (= (mus-channel gen1) 0) 
				      (readin gen1) 
				      1.0) 
				  (if (string=? (mus-file-name gen1) "oboe.snd")
				      -1.0
				      1.0)))
	(if (not (mus-arrays-equal? v0 v1)) (snd-display "map readin: ~A ~A" v0 v1)))
      (if (not (readin? gen)) (snd-display "~A not readin?" gen))
      (if (not (mus-input? gen)) (snd-display "~A not input?" gen))
      (if (not (= (mus-length gen) 50828)) (snd-display "readin length: ~A?" (mus-length gen)))
      (if (not (= (mus-channel gen) 0)) (snd-display "readin chan: ~A?" (mus-channel gen)))
      (if (not (string=? (mus-file-name gen) "oboe.snd")) (snd-display "readin mus-file-name: ~A" (mus-file-name gen)))
      (if (or (fneq (v0 1) -0.009) (fneq (v0 7) .029)) (snd-display "readin output: ~A" v0))
      (set! (mus-location gen) 1000)
      (if (not (= (mus-location gen) 1000)) (snd-display "set! mus-location: ~A?" (mus-location gen)))
      (let ((val (readin gen)))
	(if (fneq val 0.033) (snd-display "set! mus-location readin: ~A?" val)))
      (set! (mus-increment gen) -1)
      (if (fneq (mus-increment gen) -1.0) (snd-display "set increment readin: ~A" (mus-increment gen))))
    (let ((tag (catch #t (lambda () (make-readin "/baddy/hiho" 0 124)) (lambda args args))))
      (if (not (eq? (car tag) 'no-such-file)) (snd-display "make-readin w/o file: ~A" tag)))
    (let ((tag (catch #t (lambda () (make-readin "oboe.snd" 123 124)) (lambda args args))))
      (if (not (eq? (car tag) 'out-of-range)) (snd-display "make-readin with bad chan: ~A" tag)))
    
    (test-gen-equal (make-readin "oboe.snd" 0) (make-readin "oboe.snd" 0) (make-readin "oboe.snd" 0 1230))
    (test-gen-equal (make-readin "oboe.snd" 0 :size 512) (make-readin "oboe.snd" 0 :size 512) (make-readin "pistol.snd" 0 :size 512))
    (test-gen-equal (make-readin "2.snd" 1) (make-readin "2.snd" 1) (make-readin "2.snd" 0))
    
    (let ((gen (make-readin "2.snd" 1 :size 1024))
	  (v0 (make-float-vector 10)))
      (print-and-check gen 
		       "readin"
		       "readin 2.snd[chan 1], loc: 0, dir: 1")
      (do ((i 0 (+ i 1)))
	  ((= i 10))
	(set! (v0 i) (readin gen)))
      (if (not (= (mus-channel gen) 1)) (snd-display "readin chan 1: ~A?" (mus-channel gen)))
      (if (or (fneq (v0 1) 0.010) (fneq (v0 7) -.006)) (snd-display "readin 1 output: ~A" v0))
      (print-and-check gen 
		       "readin"
		       "readin 2.snd[chan 1], loc: 10, dir: 1"))
    
    (let ((gen (make-file->sample "oboe.snd"))
	  (v0 (make-float-vector 10)))
      (print-and-check gen 
		       "file->sample"
		       "file->sample \"oboe.snd\"")
      (if (not (mus-input? gen)) (snd-display "~A not input?" gen))
      (if (not (= (mus-length gen) 50828)) (snd-display "file->sample length: ~A?" (mus-length gen)))
      (if (not (string=? (mus-file-name gen) "oboe.snd")) (snd-display "file->sample mus-file-name: ~A" (mus-file-name gen)))
      (do ((i 0 (+ i 1)))
	  ((= i 10))
	(set! (v0 i) (file->sample gen (+ 1490 i))))
      (if (not (file->sample? gen)) (snd-display "~A not file->sample?" gen))
      (if (or (fneq (v0 1) -0.009) (fneq (v0 7) .029)) (snd-display "file->sample output: ~A" v0))
      (if (fneq (mus-increment gen) 0.0) (snd-display "file->sample increment: ~A" (mus-increment gen)))
      (set! (mus-increment gen) 1.0)
      (if (fneq (mus-increment gen) 1.0) (snd-display "file->sample set increment: ~A" (mus-increment gen)))
      (mus-reset gen)) ; a no-op I hope
    
    (let* ((ind (open-sound "oboe.snd"))
	   (gen (make-snd->sample ind))
	   (gen1 (make-snd->sample ind))
	   (v0 (make-float-vector 10)))
      (print-and-check gen 
		       "snd->sample"
		       "snd->sample reading oboe.snd (1 chan) at 0:[no readers]")
      (if (equal? gen gen1) (snd-display "snd->sample eq? not itself?"))
      (if (not (mus-input? gen)) (snd-display "snd->sample ~A not input?" gen))
      (if (not (= (framples ind) (mus-length gen))) (snd-display "snd->sample len: ~A ~A" (framples ind) (mus-length gen)))
      (if (not (string=? (mus-file-name gen) (string-append cwd "oboe.snd")))
	  (snd-display "snd->sample mus-file-name: ~A ~A" (mus-file-name gen) (string-append cwd "oboe.snd")))
      (do ((i 0 (+ i 1)))
	  ((= i 10))
	(set! (v0 i) (snd->sample gen (+ 1490 i))))
      (if (not (snd->sample? gen)) (snd-display "~A not snd->sample?" gen))
      (if (or (fneq (v0 1) -0.009) (fneq (v0 7) .029)) (snd-display "snd->sample output: ~A" v0))
      (if (not (= (mus-channels gen) 1)) (snd-display "snd->sample channels: ~A" (mus-channels gen)))
      (if (not (= (mus-location gen) 1499)) (snd-display "snd->sample location: ~A" (mus-location gen)))
      (do ((i 0 (+ i 1)))
	  ((= i 10))
	(set! (v0 i) (ina (+ 1490 i) gen)))
      (if (or (fneq (v0 1) -0.009) (fneq (v0 7) .029)) (snd-display "snd->sample ina output: ~A" v0))
      (close-sound ind))
    
    (let* ((ind (open-sound "2.snd"))
	   (gen (make-snd->sample ind)))
      (do ((v0 (make-float-vector 10))
	   (i 0 (+ i 1)))
	  ((= i 10))
	(set! (v0 i) (snd->sample gen (+ 1490 i) 0))
	(set! (v0 i) (snd->sample gen (+ 1490 i) 1)))
      (print-and-check gen 
		       "snd->sample"
		       "snd->sample reading 2.snd (2 chans) at 1499:[#<sampler: 2.snd[0: 0] from 1490, at 1500, forward>, #<sampler: 2.snd[1: 0] from 1490, at 1500, forward>]")
      (if (not (mus-input? gen)) (snd-display "snd->sample ~A not input?" gen))
      (if (not (string=? (mus-file-name gen) (string-append cwd "2.snd")))
	  (snd-display "snd->sample mus-file-name: ~A ~A" (mus-file-name gen) (string-append cwd "2.snd")))
      (if (not (snd->sample? gen)) (snd-display "~A not snd->sample?" gen))
      (if (not (= (mus-channels gen) 2)) (snd-display "snd->sample channels (2): ~A" (mus-channels gen)))
      (if (not (= (mus-location gen) 1499)) (snd-display "snd->sample location (2): ~A" (mus-location gen)))
      (close-sound ind))
    
    (let ((gen (make-file->frample "oboe.snd"))
	  (v0 (make-float-vector 10))
	  (g1 #r(0.0)))
      (print-and-check gen 
		       "file->frample"
		       "file->frample \"oboe.snd\""
		       "file->frample \"oboe.snd\"")
      (if (not (mus-input? gen)) (snd-display "~A not input?" gen))
      (if (not (= (mus-length gen) 50828)) (snd-display "file->frample length: ~A?" (mus-length gen)))
      (if (not (string=? (mus-file-name gen) "oboe.snd")) (snd-display "file->frample mus-file-name: ~A" (mus-file-name gen)))
      (do ((i 0 (+ i 1)))
	  ((= i 10))
	(set! (v0 i) ((file->frample gen (+ 1490 i) g1) 0)))
      (if (not (file->frample? gen)) (snd-display "~A not file->frample?" gen))
      (if (or (fneq (v0 1) -0.009) (fneq (v0 7) .029)) (snd-display "file->frample output: ~A" v0)))
    
    (if (file-exists? "fmv.snd") (delete-file "fmv.snd"))
    (if (file-exists? "fmv1.snd") (delete-file "fmv1.snd"))
    (if (file-exists? "fmv2.snd") (delete-file "fmv2.snd"))
    (if (file-exists? "fmv3.snd") (delete-file "fmv3.snd"))
    (let ((gen (make-sample->file "fmv.snd" 2 mus-lshort mus-riff)))
      (print-and-check gen 
		       "sample->file"
		       "sample->file \"fmv.snd\"")
      (if (not (mus-output? gen)) (snd-display "~A not output?" gen))
      (if (not (sample->file? gen)) (snd-display "~A not sample->file?" gen))
      (if (not (= (mus-length gen) *clm-file-buffer-size*)) (snd-display "sample->file length: ~A?" (mus-length gen)))
      (if (not (string=? (mus-file-name gen) "fmv.snd")) (snd-display "sample->file mus-file-name: ~A" (mus-file-name gen)))
      (do ((i 0 (+ i 1)))
	  ((= i 100))
	(sample->file gen i 0 (* i .001))
	(sample->file gen i 1 (* i .01)))
      (outa 50 .015 gen)
      (outb 50 .15 gen)
      (out-any 60 .015 0 gen)
      (out-any 60 .15 1 gen)
      (mus-close gen))
    (let* ((gen (make-file->sample "fmv.snd"))
	   (val0 (in-any 20 0 gen))
	   (val1 (in-any 20 1 gen))
	   (val2 (ina 30 gen))
	   (val3 (inb 30 gen))
	   (val4 (file->sample gen 40 0))
	   (val5 (file->sample gen 40 1))
	   (val6 (in-any 50 0 gen))
	   (val7 (in-any 50 1 gen))
	   (val8 (in-any 60 0 gen))
	   (val9 (in-any 60 1 gen)))
      (print-and-check gen 
		       "file->sample"
		       "file->sample \"fmv.snd\"")
      (if (not (= (mus-channels gen) 2)) (snd-display "make-sample->file chans: ~A?" (mus-channels gen)))
      (if (not (mus-input? gen)) (snd-display "~A not input?" gen))
      (if (or (fneq val0 .02) (fneq val1 .2)) (snd-display "in-any: ~A ~A?" val0 val1))
      (if (or (fneq val2 .03) (fneq val3 .3)) (snd-display "inab: ~A ~A?" val2 val3))
      (if (or (fneq val4 .04) (fneq val5 .4)) (snd-display "sample->file: ~A ~A?" val4 val5))
      (if (or (fneq val6 .065) (fneq val7 .65)) (snd-display "outab: ~A ~A?" val6 val7))
      (if (or (fneq val8 .075) (fneq val9 .75)) (snd-display "out-any: ~A ~A?" val8 val9)))
    
    (let ((gen (make-float-vector 10)))
      (do ((i 0 (+ i 1))
	   (x 0.0 (+ x 0.1)))
	  ((= i 10))
	(outa i x gen))
      (if (not (mus-arrays-equal? gen #r(0 .1 .2 .3 .4 .5 .6 .7 .8 .9)))
	  (snd-display "outa->float-vector ramp: ~A" gen))
      (do ((i 0 (+ i 1))
	   (x 0.0 (+ x 0.1)))
	  ((= i 10))
	(outa i x gen))
      (if (not (mus-arrays-equal? gen (float-vector-scale! #r(0 .1 .2 .3 .4 .5 .6 .7 .8 .9) 2.0)))
	  (snd-display "outa->float-vector ramp 2: ~A" gen))
      (if (not (= (mus-channels gen) 1)) (snd-display "mus-channels float-vector: ~A" (mus-channels gen))))
    
    (let ((gen (make-float-vector '(4 100))))
      (do ((i 0 (+ i 1)))
	  ((= i 10))
	(outa i .1 gen)
	(outb i .2 gen)
	(outc i .3 gen)
	(outd i .4 gen))
      (do ((i 0 (+ i 1)))
	  ((= i 10))
	(outa i .01 gen)
	(outb i .02 gen)
	(outc i .03 gen)
	(outd i .04 gen))
      (mus-close gen) ; should be a no-op
      (do ((i 0 (+ i 1)))
	  ((= i 10))
	(if (or (fneq (ina i gen) .11)
		(fneq (inb i gen) .22)
		(fneq (in-any i 2 gen) .33)
		(fneq (in-any i 3 gen) .44))
	    (snd-display "4-chan sd out/in[~A]: ~A ~A ~A ~A?" i (ina i gen) (inb i gen) (in-any i 2 gen) (in-any i 3 gen))))  
      (if (not (= (mus-channels gen) 4)) (snd-display "mus-channels sd 4: ~A" (mus-channels gen))))
    
    (let ((gen (make-float-vector '(4 100))))
      (do ((i 0 (+ i 1)))
	  ((= i 10))
	(out-any i .1 0 gen)
	(out-any i .2 1 gen)
	(out-any i .3 2 gen)
	(out-any i .4 3 gen))
      (do ((i 0 (+ i 1)))
	  ((= i 10))
	(out-any i .01 0 gen)
	(out-any i .02 1 gen)
	(out-any i .03 2 gen)
	(out-any i .04 3 gen))
      (do ((i 0 (+ i 1)))
	  ((= i 10))
	(if (or (fneq (in-any i 0 gen) .11)
		(fneq (in-any i 1 gen) .22)
		(fneq (in-any i 2 gen) .33)
		(fneq (in-any i 3 gen) .44))
	    (snd-display "4-chan sd out/in-any[~A]: ~A ~A ~A ~A?" i (in-any i 0 gen) (in-any i 1 gen) (in-any i 2 gen) (in-any i 3 gen)))))
    
    (let ((tag (catch #t (let ((gen (make-oscil 440.0)))
			   (lambda () (outa 0 .1 gen)))
		      (lambda args (car args)))))
      (if (not (memq tag '(wrong-type-arg mus-error)))
	  (snd-display "outa -> oscil: ~A" tag)))
    
    (let ((gen (make-sample->file "fmv.snd" 4 mus-lshort mus-riff)))
      (print-and-check gen 
		       "sample->file"
		       "sample->file \"fmv.snd\"")
      (do ((i 0 (+ i 1)))
	  ((= i 10))
	(outa i .1 gen)
	(outb i .2 gen)
	(outc i .3 gen)
	(outd i .4 gen))
      (do ((i 0 (+ i 1)))
	  ((= i 10))
	(outa i .01 gen)
	(outb i .02 gen)
	(outc i .03 gen)
	(outd i .04 gen))
      (mus-close gen))
    (let ((gen (make-file->sample "fmv.snd")))
      (print-and-check gen 
		       "file->sample"
		       "file->sample \"fmv.snd\"")
      (do ((i 0 (+ i 1)))
	  ((= i 10))
	(if (or (fneq (ina i gen) .11)
		(fneq (inb i gen) .22)
		(fneq (in-any i 2 gen) .33)
		(fneq (in-any i 3 gen) .44))
	    (snd-display "4-chan out/in[~A]: ~A ~A ~A ~A?" i (ina i gen) (inb i gen) (in-any i 2 gen) (in-any i 3 gen)))))
    
    (let ((gen (make-sample->file "fmv.snd" 4 mus-lshort mus-riff)))
       (do ((i 0 (+ i 1)))
	   ((= i 10))
	 (outa i .1 gen)
	 (outb i .2 gen)
	 (outc i .3 gen)
	 (outd i .4 gen))
       (do ((i 0 (+ i 1)))
	   ((= i 10))
	 (outa i .01 gen)
	 (outb i .02 gen)
	 (outc i .03 gen)
	 (outd i .04 gen))
      (mus-close gen))
    (let ((gen (make-file->sample "fmv.snd")))
      (do ((i 0 (+ i 1)))
	  ((= i 10))
	(if (or (fneq (ina i gen) .11)
		(fneq (inb i gen) .22)
		(fneq (in-any i 2 gen) .33)
		(fneq (in-any i 3 gen) .44))
	    (snd-display "4-chan out/in[~A]: ~A ~A ~A ~A?" i (ina i gen) (inb i gen) (in-any i 2 gen) (in-any i 3 gen)))))
    
    (let ((var (catch #t (lambda () (make-sample->file "fmv.snd" -1 mus-lshort mus-next)) (lambda args args))))
      (if (not (eq? (car var) 'out-of-range))
	  (snd-display "make-sample->file bad chans: ~A" var)))
    (let ((var (catch #t (lambda () (mus-location (make-oscil))) (lambda args args))))
      (if (not (and (pair? var) (eq? (car var) 'mus-error)))
	  (snd-display "mus-location oscil: ~A" var)))
    (let ((var (catch #t (lambda () (make-sample->file "fmv.snd" 1 -1 mus-next)) (lambda args args))))
      (if (not (eq? (car var) 'out-of-range))
	  (snd-display "make-sample->file bad format: ~A" var)))
    (let ((var (catch #t (lambda () (make-sample->file "fmv.snd" 1 mus-lshort -1)) (lambda args args))))
      (if (not (eq? (car var) 'out-of-range))
	  (snd-display "make-sample->file bad type: ~A" var)))
    
    (do ((v (vector 1.0 0.5 0.25 0.125 0.0))
	 (v1 (make-float-vector 5))
	 (i 0 (+ i 1)))
	((= i 5)
	 (if (not (mus-arrays-equal? v1 #r(1.0 0.5 0.25 0.125 0.0)))
	     (snd-display "vector in-any -> ~A?" v1)))
      (set! (v1 i) (in-any i 0 v)))
    
    (let ((invals (make-float-vector 10)))
      (do ((i 0 (+ i 1)))
	  ((= i 10))
	(float-vector-set! invals i (* i 0.1)))
      (let ((result (with-sound ((make-float-vector 10))
				(do ((i 0 (+ i 1)))
				    ((= i 10))
				  (outa i (ina i invals))))))
	(if (not (mus-arrays-equal? result #r(0.000 0.100 0.200 0.300 0.400 0.500 0.600 0.700 0.800 0.900)))
	    (snd-display "ina from float-vector: ~A" result))))
    
    (let ((invals (make-float-vector 10)))
      (do ((i 0 (+ i 1)))
	  ((= i 10))
	(float-vector-set! invals i (* i 0.1)))
      (let ((result (with-sound ((make-float-vector 10))
				 (do ((i 0 (+ i 1)))
				     ((= i 10))
				   (outa i (ina i invals))))))
	(if (not (mus-arrays-equal? result #r(0.000 0.100 0.200 0.300 0.400 0.500 0.600 0.700 0.800 0.900)))
	    (snd-display "run ina from float-vector: ~A" result))))
    
    (for-each close-sound (sounds))
    
    (let ((vals (float-vector-peak (with-sound ((make-float-vector 4410))
				     (fm-violin 0 .1 440 .1)))))
      (if (fneq vals .1)
	  (snd-display "locsig to float-vector fm-violin peak: ~A" vals)))
    
    (let ((mxs (maxamp (with-sound ((make-float-vector '(2 4410)))
			  (fm-violin 0 .1 440 .1 :degree 30)))))
      (if (fneq mxs 0.0666)
	  (snd-display "locsig to sound-data fm-violin peak: ~A" mxs)))
        
    (let ((gen (make-sample->file "fmv2.snd" 4 mus-bshort mus-aifc)))
      (print-and-check gen 
		       "sample->file"
		       "sample->file \"fmv2.snd\"")
      (if (not (mus-output? gen)) (snd-display "~A not output?" gen))
      (if (not (sample->file? gen)) (snd-display "~A not sample->file?" gen))
      (do ((i 0 (+ i 1)))
	  ((= i 100))
	(sample->file gen i 0 (* i .001))
	(sample->file gen i 1 (* i .01))
	(sample->file gen i 2 (* i .002))
	(sample->file gen i 3 (* i .003)))
      (outa 50 .015 gen)
      (outb 50 .15 gen)
      (outc 50 .02 gen)
      (outd 50 .03 gen)
      (out-any 60 .015 0 gen)
      (out-any 60 .15 1 gen)
      (out-any 60 .02 2 gen)
      (out-any 60 .03 3 gen)
      (mus-close gen))
    (let* ((gen (make-file->sample "fmv2.snd"))
	   (val0 (in-any 20 2 gen))
	   (val1 (in-any 20 3 gen))
	   (val2 (file->sample gen 50 2))
	   (val3 (file->sample gen 50 3))
	   (val4 (file->sample gen 60 2))
	   (val5 (file->sample gen 60 3)))
      (if (not (= (mus-channels gen) 4)) (snd-display "make-file->sample (4) chans: ~A?" (mus-channels gen)))
      (if (not (= (mus-increment gen) 0.0)) (snd-display "file->sample increment: ~A" (mus-increment gen))) ; dir never set in this case
      (if (or (fneq val0 .04) (fneq val1 .06)) (snd-display "in-any(0, 4): ~A ~A?" val0 val1))
      (if (or (fneq val2 .12) (fneq val3 .18)) (snd-display "file->sample(4): ~A ~A?" val2 val3))
      (if (or (fneq val4 .14) (fneq val5 .21)) (snd-display "in-any(4, 4): ~A ~A?" val4 val5)))
    
    (if (file-exists? "fmv.snd") (delete-file "fmv.snd"))
    (mus-sound-forget "fmv.snd")
    (let ((sf (make-sample->file "fmv.snd" 2 mus-bshort mus-next "this is a comment")))
      (do ((i 0 (+ i 1)))
	  ((= i 10))
	(sample->file sf i 0 (* i .1))
	(sample->file sf i 1 (* i .01)))
      (mus-close sf))
    (if (not (= (mus-sound-chans "fmv.snd") 2)) 
	(snd-display "sample->file chans: ~A" (mus-sound-chans "fmv.snd")))
    (if (not (= (mus-sound-framples "fmv.snd") 10)) 
	(snd-display "sample->file framples: ~A" (mus-sound-framples "fmv.snd")))
    (if (not (= (mus-sound-samples "fmv.snd") 20)) 
	(snd-display "sample->file samples: ~A" (mus-sound-samples "fmv.snd")))
    (if (not (= (mus-sound-header-type "fmv.snd") mus-next)) 
	(snd-display "sample->file type: ~A" (mus-header-type-name (mus-sound-header-type "fmv.snd"))))
    (if (not (= (mus-sound-sample-type "fmv.snd") mus-bshort)) 
	(snd-display "sample->file format: ~A" (mus-sample-type-name (mus-sound-sample-type "fmv.snd"))))
    (if (not (string=? (mus-sound-comment "fmv.snd") "this is a comment"))
	(snd-display "sample->file comment: ~A" (mus-sound-comment "fmv.snd")))
    (let ((rd (make-file->sample "fmv.snd"))
	  (happy #t))
      (do ((i 0 (+ i 1)))
	  ((or (not happy) (= i 10)))
	(let ((c0 (file->sample rd i 0))
	      (c1 (file->sample rd i 1)))
	  (when (or (fneq c0 (* i .1))
		    (fneq c1 (* i .01)))
	    (snd-display "sample->file->sample at ~A: ~A ~A" i c0 c1)
	    (set! happy #f))))
      (mus-close rd))

    (let ((sf (continue-sample->file "fmv.snd")))
      (do ((i 0 (+ i 1)))
	  ((= i 10))
	(sample->file sf (+ i 5) 0 (* i -.02))
	(sample->file sf (+ i 5) 1 (* i -.01)))
      (mus-close sf))
    (mus-sound-forget "fmv.snd")
    (if (not (= (mus-sound-chans "fmv.snd") 2)) 
	(snd-display "continue-sample->file chans: ~A" (mus-sound-chans "fmv.snd")))
    (if (not (= (mus-sound-framples "fmv.snd") 15)) 
	(snd-display "continue-sample->file framples: ~A" (mus-sound-framples "fmv.snd")))
    (if (not (= (mus-sound-samples "fmv.snd") 30)) 
	(snd-display "continue-sample->file samples: ~A" (mus-sound-samples "fmv.snd")))
    (if (not (= (mus-sound-header-type "fmv.snd") mus-next)) 
	(snd-display "continue-sample->file type: ~A" (mus-header-type-name (mus-sound-header-type "fmv.snd"))))
    (if (not (= (mus-sound-sample-type "fmv.snd") mus-bshort)) 
	(snd-display "continue-sample->file format: ~A" (mus-sample-type-name (mus-sound-sample-type "fmv.snd"))))
    (if (not (string=? (mus-sound-comment "fmv.snd") "this is a comment"))
	(snd-display "continue-sample->file comment: ~A" (mus-sound-comment "fmv.snd")))
    (let ((ind (open-sound "fmv.snd")))
      (let ((c0 (channel->float-vector 0 15 ind 0))
	    (c1 (channel->float-vector 0 15 ind 1)))
	(if (not (mus-arrays-equal? c0 #r(0.0 0.1 0.2 0.3 0.4 0.5 0.58 0.66 0.74 0.82 -0.1 -0.12 -0.14 -0.16 -0.18)))
	    (snd-display "continue-sample->file (0): ~A" c0))
	(if (not (mus-arrays-equal? c1 #r(0.0 0.01 0.02 0.03 0.04 0.05 0.05 0.05 0.05 0.05 -0.05 -0.06 -0.07 -0.08 -0.09)))
	    (snd-display "continue-sample->file (1): ~A" c1)))
      (close-sound ind))
    (delete-file "fmv.snd")
    (mus-sound-forget "fmv.snd")
    
    (let ((f1 #r(1.0 1.0))
	  (f2 #r(0.0 0.0))
	  (m1 #r(.5 .25 .125 1.0)))
      (let ((result (frample->frample m1 f1 2 f2 2)))
	(if (not (equal? result #r(0.625 1.25)))
	  (snd-display "frample->frample: ~A" result))))

    (let ((f1 #r(1.0 2.0 3.0))
	  (f2 #r(0.0 0.0 0.0))
	  (m1 #r(1.0 2.0 3.0 4.0 5.0 6.0 7.0 8.0 9.0)))
      (let ((result (frample->frample m1 f1 3 f2 3)))
	(if (not (equal? result #r(30.0 36.0 42.0)))
	  (snd-display "frample->frample 1: ~A" result))))

    (let ((sf (make-frample->file "fmv.snd" 2 mus-lfloat mus-riff "this is a comment")))
      (do ((i 0 (+ i 1)))
	  ((= i 10))
	(frample->file sf i (float-vector (* i .1) (* i .01))))
      (mus-close sf))
    (if (not (= (mus-sound-chans "fmv.snd") 2)) 
	(snd-display "frample->file chans: ~A" (mus-sound-chans "fmv.snd")))
    (if (not (= (mus-sound-framples "fmv.snd") 10)) 
	(snd-display "frample->file framples: ~A" (mus-sound-framples "fmv.snd")))
    (if (not (= (mus-sound-samples "fmv.snd") 20)) 
	(snd-display "frample->file samples: ~A" (mus-sound-samples "fmv.snd")))
    (if (not (= (mus-sound-header-type "fmv.snd") mus-riff)) 
	(snd-display "frample->file type: ~A" (mus-header-type-name (mus-sound-header-type "fmv.snd"))))
    (if (not (= (mus-sound-sample-type "fmv.snd") mus-lfloat)) 
	(snd-display "frample->file format: ~A" (mus-sample-type-name (mus-sound-sample-type "fmv.snd"))))
    (if (not (string=? (mus-sound-comment "fmv.snd") "this is a comment"))
	(snd-display "frample->file comment: ~A" (mus-sound-comment "fmv.snd")))
    (let ((rd (make-file->frample "fmv.snd"))
	  (f0 #r(0.0 0.0))
	  (happy #t))
      (do ((i 0 (+ i 1)))
	  ((or (not happy) (= i 10)))
	(file->frample rd i f0)
	(when (or (not (= (mus-length f0) 2))
		  (fneq (f0 0) (* i .1))
		  (fneq (f0 1) (* i .01)))
	  (snd-display "frample->file->frample at ~A: ~A" i f0)
	  (set! happy #f)))
      (mus-close rd))
    (let ((sf (continue-frample->file "fmv.snd")))
      (do ((i 0 (+ i 1)))
	  ((= i 10))
	(frample->file sf (+ i 5) (float-vector (* i -.02) (* i -.01))))
      (mus-close sf))
    (mus-sound-forget "fmv.snd")
    (if (not (= (mus-sound-chans "fmv.snd") 2)) 
	(snd-display "continue-frample->file chans: ~A" (mus-sound-chans "fmv.snd")))
    (if (not (= (mus-sound-framples "fmv.snd") 15)) 
	(snd-display "continue-frample->file framples: ~A" (mus-sound-framples "fmv.snd")))
    (if (not (= (mus-sound-samples "fmv.snd") 30)) 
	(snd-display "continue-frample->file samples: ~A" (mus-sound-samples "fmv.snd")))
    (if (not (= (mus-sound-header-type "fmv.snd") mus-riff)) 
	(snd-display "continue-frample->file type: ~A" (mus-header-type-name (mus-sound-header-type "fmv.snd"))))
    (if (not (= (mus-sound-sample-type "fmv.snd") mus-lfloat)) 
	(snd-display "continue-frample->file format: ~A" (mus-sample-type-name (mus-sound-sample-type "fmv.snd"))))
    (if (not (string=? (mus-sound-comment "fmv.snd") "this is a comment"))
	(snd-display "continue-frample->file comment: ~A" (mus-sound-comment "fmv.snd")))
    (let ((ind (open-sound "fmv.snd")))
      (let ((c0 (channel->float-vector 0 15 ind 0))
	    (c1 (channel->float-vector 0 15 ind 1)))
	(if (not (mus-arrays-equal? c0 #r(0.0 0.1 0.2 0.3 0.4 0.5 0.58 0.66 0.74 0.82 -0.1 -0.12 -0.14 -0.16 -0.18)))
	    (snd-display "continue-frample->file (0): ~A" c0))
	(if (not (mus-arrays-equal? c1 #r(0.0 0.01 0.02 0.03 0.04 0.05 0.05 0.05 0.05 0.05 -0.05 -0.06 -0.07 -0.08 -0.09)))
	    (snd-display "continue-frample->file (1): ~A" c1)))
      (close-sound ind))
    (delete-file "fmv.snd")
    (mus-sound-forget "fmv.snd")
    
    (let ((v0 (make-float-vector 1000)))
      (do ((os (make-oscil 440.0))
	   (i 0 (+ i 1)))
	  ((= i 1000))
	(set! (v0 i) (* .1 (oscil os))))
      (array->file "fmv3.snd" v0 10000 22050 1) ; 10000 deliberate
      (let ((v1 (make-float-vector 1000)))
	(file->array "fmv3.snd" 0 0 1000 v1)
	(do ((i 0 (+ i 1)))
	    ((= i 1000))
	  (if (fneq (v0 i) (v1 i)) 
	      (snd-display "array->file->array: ~A ~A ~A?" i (v0 i) (v1 i)))))
      
      (let ((var (catch #t (lambda () (array->file "fmv3.snd" v0 -1 1000 1)) (lambda args args))))
	(if (not (eq? (car var) 'out-of-range))
	    (snd-display "array->file bad samps: ~A" var)))
      (let ((var (catch #t (lambda () (array->file "/bad/baddy/fmv3.snd" v0 1 1000 1)) (lambda args args))))
	(if (not (eq? (car var) 'mus-error))
	    (snd-display "array->file bad file: ~A" var)))
      (let ((var (catch #t (lambda () (file->array "fmv3.snd" -1 0 -1 v0)) (lambda args args))))
	(if (not (eq? (car var) 'out-of-range))
	    (snd-display "file->array bad samps: ~A" var))))
    
    (let ((gen (make-rand 10000.0))
	  (v0 (make-float-vector 10)))
      (print-and-check gen 
		       "rand"
		       "rand freq: 10000.000Hz, phase: 0.000, amp: 1.000")
      (do ((i 0 (+ i 1)))
	  ((= i 10))
	(set! (v0 i) (rand gen)))
      (if (not (rand? gen)) (snd-display "~A not rand?" gen))
      (if (fneq (mus-phase gen) 3.3624296) (snd-display "rand phase: ~F?" (mus-phase gen)))
      (if (fneq (mus-frequency gen) 10000.0) (snd-display "rand frequency: ~F?" (mus-frequency gen)))
      (set! (mus-scaler gen) 0.5)
      (if (fneq (mus-scaler gen) 0.5) (snd-display "set! mus-scaler rand: ~A" (mus-scaler gen)))
      (if (= (v0 1) (v0 8)) (snd-display "rand output: ~A" v0))
      (mus-reset gen)
      (let ((val (rand gen)))
	(if (zero? val) (snd-display "mus-reset rand: ~A" val))))
    
    (let ((gen (make-rand 10000.0 :envelope '(0 0 1 1)))
	  (v0 (make-float-vector 10)))
      (print-and-check gen 
		       "rand"
		       "rand freq: 10000.000Hz, phase: 0.000, amp: 1.000, with distribution envelope")
      (do ((i 0 (+ i 1)))
	  ((= i 10))
	(set! (v0 i) (rand gen)))
      (if (not (rand? gen)) (snd-display "(dist) ~A not rand?" gen))
      (if (fneq (mus-frequency gen) 10000.0) (snd-display "(dist) rand frequency: ~F?" (mus-frequency gen)))
      (if (= (v0 1) (v0 8)) (snd-display "(dist) rand output: ~A" v0))
      (if (not (and (float-vector? (mus-data gen))
		    (= (mus-length gen) (length (mus-data gen)))
		    (= (mus-length gen) 512)))
	  (snd-display "(dist) rand data: ~A ~A" (mus-length gen) (mus-data gen))))
    
    (let ((gen1 (make-rand 10000.0 :envelope '(0 0 1 1)))
	  (gen2 (make-rand 10000.0 :envelope '(0 1 1 0)))
	  (up1 0)
	  (down1 0)
	  (bad1 0)
	  (up2 0)
	  (down2 0)
	  (bad2 0))
      (do ((i 0 (+ i 1)))
	  ((= i 1000))
	(let ((val1 (rand gen1))
	      (val2 (rand gen2)))
	  (if (>= val1 .5)
	      (set! up1 (+ 1 up1))
	      (if (>= val1 0.0)
		  (set! down1 (+ 1 down1))
		  (set! bad1 (+ 1 bad1))))
	  (if (>= val2 .5)
	      (set! up2 (+ 1 up2))
	      (if (>= val2 0.0)
		  (set! down2 (+ 1 down2))
		  (set! bad2 (+ 1 bad2))))))
      (if (not (and (= bad1 0)
		    (= bad2 0)
		    (<= (* 2 down1) up1)
		    (<= (* 2 up2) down2)))
	  (snd-display " rand dist: ~A ~A ~A, ~A ~A ~A" down1 up1 bad1 down2 up2 bad2)))
    
					;      (test-gen-equal (make-rand 1000) (make-rand 1000) (make-rand 500))
					;      (test-gen-equal (make-rand 1000) (make-rand 1000) (make-rand 1000 0.5))
    
    (do ((gen (make-rand-interp 100.0 0.0))
	 (i 0 (+ i 1)))
	((= i 10))
      (let ((val (rand-interp gen)))
	(if (not (zero? val))
	    (snd-display "rand-interp 0 amp: ~A" val))))

    (let ((gen (make-rand-interp 4000.0))
	  (v0 (make-float-vector 10)))
      (print-and-check gen 
		       "rand-interp"
		       (mus-describe gen))
      (do ((i 0 (+ i 1)))
	  ((= i 10))
	(set! (v0 i) (rand-interp gen 0.0)))
      (if (not (rand-interp? gen)) (snd-display "~A not rand-interp?" gen))
      (if (fneq (mus-phase gen) 5.114882) (snd-display "rand-interp phase: ~F?" (mus-phase gen)))
      (if (fneq (mus-frequency gen) 4000.0) (snd-display "rand-interp frequency: ~F?" (mus-frequency gen)))
      (set! (mus-scaler gen) 0.5)
      (if (fneq (mus-scaler gen) 0.5) (snd-display "set! mus-scaler rand-interp: ~A" (mus-scaler gen)))
      (if (= (v0 1) (v0 8)) (snd-display "rand-interp output: ~A" v0)))
    
    (let ((gen (make-rand-interp 4000.0 :envelope '(-1 1 0 0 1 1)))
	  (v0 (make-float-vector 10)))
      (print-and-check gen 
		       "rand-interp"
		       (mus-describe gen))
      (do ((i 0 (+ i 1)))
	  ((= i 10))
	(set! (v0 i) (rand-interp gen 0.0)))
      (if (not (rand-interp? gen)) (snd-display "(dist) ~A not rand-interp?" gen))
      (if (= (v0 1) (v0 8)) (snd-display "(dist) rand-interp output: ~A" v0))
      (if (not (and (float-vector? (mus-data gen))
		    (= (mus-length gen) (length (mus-data gen)))
		    (= (mus-length gen) 512)))
	  (snd-display "(dist) rand-interp data: ~A ~A" (mus-length gen) (mus-data gen))))
    
    (do ((gen (make-rand 10000.0 1.0))
	 (gen1 (make-rand-interp 10000.0 1.0))
	 (i 0 (+ i 1)))
	((= i 1000))
      (let ((val1 (gen 0.0))
	    (val2 (gen1 0.0)))
	(if (not (>= 1.0 val1 -1.0))
	    (snd-display "rand: ~A ~A" val1 gen))
	(if (not (>= 1.0 val2 -1.0))
	    (snd-display "rand-interp: ~A ~A" val2 gen1))))
  
    (let ((gen (make-rand 10000.0 :distribution (inverse-integrate '(0 0 1 1))))
	  (v0 (make-float-vector 10)))
      (print-and-check gen 
		       "rand"
		       "rand freq: 10000.000Hz, phase: 0.000, amp: 1.000, with distribution envelope")
      (do ((i 0 (+ i 1)))
	  ((= i 10))
	(set! (v0 i) (rand gen)))
      (if (not (rand? gen)) (snd-display "(dist 2) ~A not rand?" gen))
      (if (fneq (mus-frequency gen) 10000.0) (snd-display "(dist 2) rand frequency: ~F?" (mus-frequency gen)))
      (if (= (v0 1) (v0 8)) (snd-display "(dist 2) rand output: ~A" v0))
      (if (not (and (float-vector? (mus-data gen))
		    (= (mus-length gen) (length (mus-data gen)))
		    (= (mus-length gen) 512)))
	  (snd-display "(dist 2) rand data: ~A ~A" (mus-length gen) (mus-data gen))))
    
    (let ((gen1 (make-rand 10000.0 :distribution (inverse-integrate '(0 0 1 1))))
	  (gen2 (make-rand 10000.0 :distribution (inverse-integrate '(0 1 1 0))))
	  (up1 0)
	  (down1 0)
	  (bad1 0)
	  (up2 0)
	  (down2 0)
	  (bad2 0))
      (do ((i 0 (+ i 1)))
	  ((= i 1000))
	(let ((val1 (rand gen1))
	      (val2 (rand gen2)))
	  (if (>= val1 .5)
	      (set! up1 (+ 1 up1))
	      (if (>= val1 0.0)
		  (set! down1 (+ 1 down1))
		  (set! bad1 (+ 1 bad1))))
	  (if (>= val2 .5)
	      (set! up2 (+ 1 up2))
	      (if (>= val2 0.0)
		  (set! down2 (+ 1 down2))
		  (set! bad2 (+ 1 bad2))))))
      (if (not (and (= bad1 0)
		    (= bad2 0)
		    (<= (* 2.5 down1) up1)
		    (<= (* 2.0 up2) down2)))
	  (snd-display " rand dist 2: ~A ~A ~A, ~A ~A ~A" down1 up1 bad1 down2 up2 bad2))) ; 234 766 0, 705 295 0
    
    (let ((ind (new-sound :size 100)))
      (select-sound ind)
      (map-channel (lambda (y) (any-random 1.0 '(0 1 1 1))))
      (let ((place (scan-channel (lambda (y) (not (<= 0.0 y 1.0)))))) ; (or (< y 0.0) (> y 1.0))))))
	(if place (snd-display "any-random 0 to 1: ~A" place)))
      (if (< (maxamp) .5) (snd-display "any-random maxamp: ~A" (maxamp))) ; possible, but extremely unlikely
      (let ((avg 0.0))
	(scan-channel (lambda (y) (set! avg (+ avg y)) #f))
	(if (> (abs (- (/ avg (framples)) .5)) .2) (snd-display "any-random skewed?")))
      (let ((g (gaussian-distribution 1.0))) 
	(map-channel (lambda (y) (any-random 1.0 g))))
      (let ((g (pareto-distribution 1.0))) 
	(map-channel (lambda (y) (any-random 1.0 g))))
      (clean-up-sound ind))
    
    (let ((v1 (inverse-integrate '(-1 1 1 1))))
      (if (fneq (v1 4) -0.984)
	  (snd-display "inverse-integrate -1 to 1 uniform: ~A" v1)))
    (let ((v1 (inverse-integrate '(0 1 1 1))))
      (if (fneq (v1 4) .008)
	  (snd-display "inverse-integrate 0 to 1 uniform: ~A" v1)))
    (let ((v1 (inverse-integrate '(0 1 1 0))))
      (if (fneq (v1 4) .004)
	  (snd-display "inverse-integrate 0 to 1 1 to 0: ~A" v1)))
    (let ((v1 (inverse-integrate '(0 0 .5 1 1 0))))
      (if (fneq (v1 4) .073)
	  (snd-display "inverse-integrate triangle: ~A" v1)))
    (let ((v1 (inverse-integrate (gaussian-envelope 1.0))))
      (if (fneq (v1 4) -0.593)
	  (snd-display "inverse-integrate gaussian: ~A" v1)))
    
    (let ((minp 1.0)
	  (maxp -1.0))
      (do ((i 0 (+ i 1)))
	  ((= i 1100))
	(let ((val1 (mus-random 1.0)))
	  (set! minp (min minp val1))
	  (set! maxp (max maxp val1))
	  (if (not (>= 1.0 val1 -1.0))
	      (snd-display "mus-random: ~A" val1))))
      (if (or (< maxp .9)
	      (> minp -.9))
	  (snd-display "mus-random min/max: ~A ~A" minp maxp))
      (set! minp 12.0)
      (set! maxp -12.0)
      (do ((i 0 (+ i 1)))
	  ((= i 1100))
	(let ((val1 (mus-random 12.0)))
	  (set! minp (min minp val1))
	  (set! maxp (max maxp val1))
	  (if (not (>= 12.0 val1 -12.0))
	      (snd-display "mus-random (12): ~A" val1))))
      (if (or (< maxp 11.0)
	      (> minp -11.0))
	  (snd-display "mus-random (12) min/max: ~A ~A" minp maxp)))
    
    (let ((n 1000) ; chi^2 or mus-random
	   (hits (make-vector 10 0)))
      (do ((i 0 (+ 1 i )))
	  ((= i n))
	(let ((y (floor (+ 5 (mus-random 5.0)))))
	  (set! (hits y) (+ 1 (vector-ref hits y)))))
      (do ((sum 0.0)
	   (p (/ n 10.0))
	   (i 0 (+ i 1)))
	  ((= i 10) 
	   (if (< sum 3.0)
	       (snd-display "mus-random not so random? ~A (chi)" sum)))
	(let ((num (- (vector-ref hits i) p)))
	  (set! sum (+ sum (/ (* num num) p))))))
      ;; (v 10000)
      ;; #(999 1017 1002 1024 1048 971 963 1000 980 996) 5.8
      ;; if less than 3 complain
    
    (let ((n 10000)
	   (hits (make-vector 10 0))
	   (gen (make-rand 22050.0 5)))
      (do ((i 0 (+ 1 i )))
	  ((= i n))
	(let ((y (floor (+ 5 (rand gen)))))
	  (set! (hits y) (+ 1 (vector-ref hits y)))))
      (do ((sum 0.0)
	   (p (/ n 10.0))
	   (i 0 (+ i 1)))
	  ((= i 10)
	   (if (< sum 3.5)
	       (snd-display "rand not so random? ~A (chi)" sum)))
	(let ((num (- (vector-ref hits i) p)))
	  (set! sum (+ sum (/ (* num num) p))))))
      ;; (v1 10000)
      ;; #(979 1015 977 1008 954 1049 997 1020 1015 986) 6.606
    
    (let ((data (make-float-vector 65536)))
      (do ((i 0 (+ i 1)))
	  ((= i 65536))
	(set! (data i) (mus-random 1.0)))
      (let ((ndat (snd-spectrum data rectangular-window 65536 #t 0.0 #f #f)))
	(let ((peak (float-vector-peak ndat))
	      (sum 0.0))
	  (if (> peak 1000.0)
	      (snd-display "mus-random spectral peak: ~A" peak))
	  (do ((i 0 (+ i 1)))
	      ((= i 32768))
	    (set! sum (+ sum (float-vector-ref ndat i))))
	  (if (> (/ sum 32768.0) 200.0)
	      (snd-display "random average: ~A ~A" (/ sum 32768.0) (ndat 0)))))
      (do ((i 0 (+ i 1)))
	  ((= i 65536))
	(set! (data i) (mus-random 1.0)))
      (autocorrelate data)
      (set! (data 0) 0.0)
      (let ((pk (float-vector-peak data)))
	(if (> pk 1000)
	    (snd-display "random autocorrelate peak: ~A" (float-vector-peak data))))
      (let ((sum 0.0))
	(float-vector-abs! data)
	(do ((i 0 (+ i 1)))
	    ((= i 32768))
	  (set! sum (+ sum (float-vector-ref data i))))
	(if (> (/ sum 32768.0) 200.0)
	    (snd-display "random autocorrelate average: ~A" (/ sum 32768.0)))))
    
    (set! (locsig-type) mus-interp-linear)
    (let ((gen1 (make-locsig 60.0 :channels 2)))
      (let ((gen (make-locsig 30.0 :channels 2)))
	(locsig gen 0 1.0)
	(print-and-check gen 
			 "locsig"
			 "locsig chans 2, outn: [0.667 0.333], interp: linear")
	(if (not (locsig? gen)) (snd-display "~A not locsig?" gen))
	(let ((gen2 (make-locsig 60.0 :channels 4)))
	  (if (eq? gen1 gen2) (snd-display "locsig 1 eq? ~A ~A" gen1 gen2))
	  (if (equal? gen gen1) (snd-display "locsig 2 equal? ~A ~A" gen gen1))
	  (if (equal? gen gen2) (snd-display "locsig 3 equal? ~A ~A" gen gen2))
	  (if (or (fneq (locsig-ref gen 0) .667) (fneq (locsig-ref gen 1) .333))
	      (snd-display "locsig ref: ~F ~F?" (locsig-ref gen 0) (locsig-ref gen 1)))
	  (if (not (mus-arrays-equal? (mus-data gen) #r(0.667 0.333)))
	      (snd-display "locsig gen outn: ~A" (mus-data gen)))
	  (if (not (mus-arrays-equal? (mus-data gen1) #r(0.333 0.667)))
	      (snd-display "locsig gen2 outn: ~A" (mus-data gen1)))
	  (if (not (mus-arrays-equal? (mus-data gen2) #r(0.333 0.667 0.000 0.000)))
	      (snd-display "locsig gen2 outn: ~A" (mus-data gen2))))
	(let ((gen200 (mus-data (make-locsig 200.0 :channels 4))))
	  (if (not (mus-arrays-equal? gen200 #r(0.000 0.000 0.778 0.222)))
	      (snd-display "locsig gen200 outn: ~A" gen200)))
	(locsig-set! gen 0 .25)
	(if (not (mus-arrays-equal? (mus-data gen) #r(0.250 0.333)))
	    (snd-display "locsig gen .25 outn: ~A" (mus-data gen)))
	(locsig gen 0 1.0)
	(locsig-set! gen 0 .5)
	(if (not (mus-arrays-equal? (mus-data gen) #r(0.500 0.333)))
	    (snd-display "locsig gen .5 outn: ~A" (mus-data gen)))
	(locsig gen 0 1.0))
      (let ((gen (make-locsig 120.0 2.0 .1 :channels 4)))
	(if (not (mus-arrays-equal? (mus-data gen) #r(0.000 0.333 0.167 0.000)))
	    (snd-display "locsig gen 120 outn: ~A" (mus-data gen)))
	(locsig gen 0 1.0))
      (let ((gen (make-locsig 300.0 2.0 .1 :channels 4)))
	(if (not (mus-arrays-equal? (mus-data gen) #r(0.167 0.000 0.000 0.333)))
	    (snd-display "locsig gen 300 outn: ~A" (mus-data gen)))
	(locsig gen 0 1.0))
      
      (move-locsig gen1 90.0 1.0)
      (if (not (mus-arrays-equal? (mus-data gen1) #r(0.000 1.000)))
	  (snd-display "locsig gen1 90 outn: ~A" (mus-data gen1)))
      (move-locsig gen1 0.0 1.0)
      (if (not (mus-arrays-equal? (mus-data gen1) #r(1.000 0.000)))
	  (snd-display "locsig gen1 0 outn: ~A" (mus-data gen1)))
      (move-locsig gen1 45.0 1.0)
      (if (not (mus-arrays-equal? (mus-data gen1) #r(0.500 0.500)))
	  (snd-display "locsig gen1 45 outn: ~A" (mus-data gen1)))
      (move-locsig gen1 135.0 2.0)
      (if (not (mus-arrays-equal? (mus-data gen1) #r(0.000 0.500)))
	  (snd-display "locsig gen1 135 outn: ~A" (mus-data gen1)))
      (move-locsig gen1 -270.0 3.0)
      (if (not (mus-arrays-equal? (mus-data gen1) #r(0.333 0.0)))
	  (snd-display "locsig gen1 -270 outn: ~A" (mus-data gen1))))
    
    (for-each
     (lambda (chans)
       (let ((loc (make-locsig :channels chans)))
	 (let ((last (make-float-vector chans))
	       (data (mus-data loc)))
	   ;; do a full circle looking for jumps
	   (move-locsig loc -400.0 1.0)
	   (copy data last)
	   (do ((x -400.0 (+ x 10.0)))
	       ((> x 400.0))
	     (move-locsig loc x 1.0)
	     (if (or (< (float-vector-min data) 0.0)
		     (> (float-vector-max data) 1.0))
		 (format () ";locsig, chans: ~D, degree: ~F, ~A~%" chans x data))
	     (let ((diff (float-vector-peak (float-vector-subtract! last data))))
	       (copy data last)
	       (if (> diff .25)
		   (format () ";locsig, increment ~F with deg ~F~%" diff x)))))))
     '(1 2 4 5 8))
    
    (for-each 
     (lambda (chans)
       (let ((m1 (make-locsig :channels chans)))
	 (if (not (= (mus-channels m1) chans (mus-length m1)))
	     (snd-display "locsig ~A chans but: ~A ~A" chans (mus-channels m1) (mus-length m1)))
	 (do ((i 0 (+ i 1)))
	     ((= i chans))
	   (locsig-set! m1 i (* i .1)))
	 (do ((i 0 (+ i 1)))
	     ((= i chans))
	   (if (fneq (locsig-ref m1 i) (* i .1))
	       (snd-display "locsig[~A] = ~A (~A)?" i (locsig-ref m1 i) (* i .1))))))
     '(1 2 4 8))
    
    (let ((var (catch #t (lambda () (make-locsig :channels 0)) (lambda args args))))
      (if (not (memq (car var) '(out-of-range mus-error)))
	  (snd-display "make-locsig bad (0) chans: ~A" var)))
    (let ((var (catch #t (lambda () (make-locsig :channels -2)) (lambda args args))))
      (if (not (eq? (car var) 'out-of-range))
	  (snd-display "make-locsig bad (-2) chans: ~A" var)))
    (let ((var (catch #t (lambda () (make-locsig :output 1)) (lambda args args))))
      (if (not (eq? (car var) 'wrong-type-arg))
	  (snd-display "make-locsig bad output: ~A" var)))
    (let ((var (catch #t (lambda () (locsig-ref (make-locsig) 1)) (lambda args args))))
      (if (and (pair? var)
	       (not (eq? (car var) 'mus-error)))
	  (snd-display "locsig-ref bad chan: ~A" var)))
    (let ((var (catch #t (lambda () (make-locsig :revout 1)) (lambda args args))))
      (if (and (pair? var)
	       (not (eq? (car var) 'wrong-type-arg)))
	  (snd-display "make-locsig bad revout: ~A" var)))
    (let ((var (catch #t (lambda () (locsig-ref (make-locsig 200 :channels 2) -1)) (lambda args args))))
      (if (and (pair? var)
	       (not (eq? (car var) 'mus-error)))
	  (snd-display "locsig-ref bad chan: ~A" var)))
    (let ((var (catch #t (lambda () (locsig-set! (make-locsig) 2 .1)) (lambda args args))))
      (if (and (pair? var)
	       (not (eq? (car var) 'mus-error)))
	  (snd-display "locsig-set! bad chan (2): ~A" var)))
    (let ((var (catch #t (lambda () (locsig-reverb-ref (make-locsig :reverb .1) 2)) (lambda args args))))
      (if (and (pair? var)
	       (not (eq? (car var) 'mus-error)))
	  (snd-display "locsig-reverb-ref bad reverb chan (2): ~A" var)))
    (let ((var (catch #t (lambda () (locsig-reverb-set! (make-locsig :reverb .1) 2 .1)) (lambda args args))))
      (if (and (pair? var)
	       (not (eq? (car var) 'mus-error)))
	  (snd-display "locsig-reverb-set! bad reverb chan (2): ~A" var)))
    
    (let ((locs (make-locsig :channels 8 :degree 0)))
      (move-locsig locs 180 1.0)
      (if (fneq (locsig-ref locs 0) 0.0) (snd-display "move-locsig by jump: ~A" (mus-data locs)))
      (if (not (mus-arrays-equal? (mus-data locs) #r(0.000 0.000 0.000 0.000 1.000 0.000 0.000 0.000)))
	  (snd-display "move-locsig by jump data: ~A" (mus-data locs)))
      (move-locsig locs 120.0 1.0)
      (if (not (mus-arrays-equal? (mus-data locs) #r(0.000 0.000 0.333 0.667 0.000 0.000 0.000 0.000)))
	  (snd-display "move-locsig by jump 120 data: ~A" (mus-data locs)))
      (move-locsig locs -20.0 1.0)
      (if (not (mus-arrays-equal? (mus-data locs) #r(0.556 0.000 0.000 0.000 0.000 0.000 0.000 0.444)))
	  (snd-display "move-locsig by jump -20 data: ~A" (mus-data locs))))
    
    (let ((sf (make-sample->file "fmv4.snd" 8 mus-bshort mus-next "this is a comment"))
	  (sfrev (make-sample->file "fmv4.reverb" 8 mus-bshort mus-next "this is a comment")))
      (let ((locs (make-locsig :channels 8 :degree 0 :distance 1.0 :reverb 0.1 
			       :output sf :revout sfrev :type mus-interp-linear)))
	(if (not (mus-arrays-equal? (mus-data locs) #r(1.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000)))
	    (snd-display "ws not move-locsig by jump data: ~A" (mus-data locs)))
	(if (not (mus-arrays-equal? (mus-xcoeffs locs) #r(0.100 0.000 0.000 0.000 0.0 0.0 0.0 0.0)))
	    (snd-display "ws not move-locsig by jump rev data: ~A" (mus-xcoeffs locs)))
	(move-locsig locs 180 2.0)
	(if (fneq (locsig-ref locs 0) 0.0) (snd-display "ws move-locsig by jump: ~A" (mus-data locs)))
	(if (not (mus-arrays-equal? (mus-data locs) #r(0.000 0.000 0.000 0.000 0.500 0.000 0.000 0.000)))
	    (snd-display "ws move-locsig by jump data: ~A" (mus-data locs)))
	(if (not (mus-arrays-equal? (mus-xcoeffs locs) #r(0.000 0.000 0.000 0.000 0.071 0.000 0.000 0.000)))
	    (snd-display "ws move-locsig by jump rev data: ~A" (mus-xcoeffs locs)))
	(move-locsig locs 120.0 3.0)
	(if (not (mus-arrays-equal? (mus-data locs) #r(0.000 0.000 0.111 0.222 0.000 0.000 0.000 0.000)))
	    (snd-display "ws move-locsig by jump 120 data: ~A" (mus-data locs)))
	(if (not (mus-arrays-equal? (mus-xcoeffs locs) #r(0.000 0.000 0.019 0.038 0.000 0.000 0.000 0.000)))
	    (snd-display "ws move-locsig by jump 120 rev data: ~A" (mus-xcoeffs locs)))
	(move-locsig locs -20.0 4.0)
	(if (not (mus-arrays-equal? (mus-data locs) #r(0.139 0.000 0.000 0.000 0.000 0.000 0.000 0.111)))
	    (snd-display "ws move-locsig by jump -20 data: ~A" (mus-data locs)))
	(if (not (mus-arrays-equal? (mus-xcoeffs locs) #r(0.028 0.000 0.000 0.000 0.000 0.000 0.000 0.022)))
	    (snd-display "ws move-locsig by jump -20 rev data: ~A" (mus-xcoeffs locs))))
      (mus-close sf)
      (mus-close sfrev))
    
    (if (file-exists? "fmv4.snd") (delete-file "fmv4.snd"))
    (if (file-exists? "fmv4.reverb") (delete-file "fmv4.reverb"))
    (mus-sound-prune)
    
    (for-each
     (lambda (ht)
       (let ((ind (find-sound (with-sound (:channels 8)
					  (do ((i 0 (+ i 1)))
					      ((= i 8))
					    (locsig (make-locsig :degree (* i 45) :output *output*) i 0.5))))))
	 (do ((i 0 (+ i 1)))
	     ((= i 8))
	   (let ((samps (channel->float-vector 0 8 ind i)))
	     (do ((k 0 (+ k 1)))
		 ((= k 8))
	       (if (and (= k i) (fneq (samps k) 0.5))
		   (snd-display "8 out ~A chan ~A samp ~A (0.5): ~A" (mus-header-type->string ht) i k (samps k)))
	       (if (and (not (= i k)) (fneq (samps k) 0.0))
		   (snd-display "8 out ~A chan ~A samp ~A (0.0): ~A" (mus-header-type->string ht) i k (samps k))))))
	 (close-sound ind)))
     (list mus-caff mus-aifc mus-next mus-riff mus-rf64))
    
    (let* ((gen (make-frample->file "fmv4.snd" 2 mus-bshort mus-next))
	   (rev (make-frample->file "fmv4.reverb" 1 mus-bshort mus-next))
	   (lc (make-locsig 60.0 :reverb .1 :channels 2 :output gen :revout rev)))
      (do ((i 0 (+ i 1)))
	  ((= i 100))
	(locsig lc i 1.0))
      (if (fneq (locsig-reverb-ref lc 0) .1) (snd-display "locsig reverb ref: ~A?" (locsig-reverb-ref lc 0)))
      (locsig-reverb-set! lc 0 .2)
      (if (fneq (locsig-reverb-ref lc 0) .2) (snd-display "locsig reverb set: ~A?" (locsig-reverb-ref lc 0)))
      (mus-close gen)
      (mus-close rev)
      (let ((v0 (make-float-vector 100))
	    (v1 (make-float-vector 100))
	    (v2 (make-float-vector 100)))
	(file->array "fmv4.snd" 0 0 100 v0)
	(file->array "fmv4.snd" 1 0 100 v1)
	(file->array "fmv4.reverb" 0 0 100 v2)
	(if (fneq (v2 0) .1) (snd-display "locsig reverb: ~A?" v2))
	(if (fneq (* 2 (v0 0)) (v1 0)) (snd-display "locsig direct: ~A ~A?" (v0 0) (v1 0)))))
    
    (let* ((gen (make-frample->file "fmv4.snd" 4 mus-bshort mus-next))
	   (rev (make-frample->file "fmv4.reverb" 4 mus-bshort mus-next))
	   (lc (make-locsig 60.0 :reverb .1 :channels 4 :distance 4.0 :output gen :revout rev)))
      (print-and-check lc
		       "locsig"
		       "locsig chans 4, outn: [0.083 0.167 0.000 0.000], revn: [0.017 0.033 0.000 0.000], interp: linear")
      (do ((i 0 (+ i 1)))
	  ((= i 100))
	(locsig lc i 1.0))
      (do ((i 0 (+ i 1)))
	  ((= i 4))
	(locsig-reverb-set! lc i (* i .1))
	(if (fneq (locsig-reverb-ref lc i) (* i .1))
	    (snd-display "locsig reverb set![~A]: ~A?" i (locsig-reverb-ref lc i))))
      (print-and-check lc
		       "locsig"
		       "locsig chans 4, outn: [0.083 0.167 0.000 0.000], revn: [0.000 0.100 0.200 0.300], interp: linear")
      (if (not (float-vector? (mus-data lc))) (snd-display "out data locsig: ~A" (mus-data lc)))
      (if (not (float-vector? (mus-xcoeffs lc))) (snd-display "rev data locsig: ~A" (mus-xcoeffs lc)))
      (let ((xcs (mus-xcoeffs lc)))
	(if (fneq (mus-xcoeff lc 0) (xcs 0)) (snd-display "locsig xcoeff: ~A ~A" (mus-xcoeff lc 0) (xcs 0)))
	(if (fneq (mus-xcoeff lc 1) .1) (snd-display "locsig xcoeff 1: ~A ~A (.1)" (mus-xcoeff lc 0) (xcs 0))))
      (mus-close gen)
      (mus-close rev))
    
    (print-and-check (make-locsig 160 :channels 4)
		     "locsig"
		     "locsig chans 4, outn: [0.000 0.222 0.778 0.000], interp: linear")
    (print-and-check (make-locsig -200 :channels 4)
		     "locsig"
		     "locsig chans 4, outn: [0.000 0.222 0.778 0.000], interp: linear")
    (print-and-check (make-locsig 160 :channels 4 :distance .5)
		     "locsig"
		     "locsig chans 4, outn: [0.000 0.222 0.778 0.000], interp: linear")
    (print-and-check (make-locsig 320 :channels 4)
		     "locsig"
		     "locsig chans 4, outn: [0.556 0.000 0.000 0.444], interp: linear")
    (print-and-check (make-locsig -40 :channels 4)
		     "locsig"
		     "locsig chans 4, outn: [0.556 0.000 0.000 0.444], interp: linear")
    (print-and-check (make-locsig 320 :channels 2)
		     "locsig"
		     "locsig chans 2, outn: [0.000 1.000], interp: linear")
    (print-and-check (make-locsig -40 :channels 2)
		     "locsig"
		     "locsig chans 2, outn: [1.000 0.000], interp: linear")
    (print-and-check (make-locsig 160 :channels 4 :output (make-float-vector '(4 10)))
		     "locsig"
		     "locsig chans 4, outn: [0.000 0.222 0.778 0.000], interp: linear")
    (print-and-check (make-locsig 0 :channels 1 :output (make-float-vector 10))
		     "locsig"
		     "locsig chans 1, outn: [1.000], interp: linear")
    (let ((locsig-data
	   (lambda (gen)
	     (let ((chans (mus-channels gen)))
	       (do ((dat (make-float-vector chans))
		    (i 0 (+ i 1)))
		   ((= i chans) dat)
		 (set! (dat i) (locsig-ref gen i))))))
	  (gen (make-locsig -.1 :channels 8)))
      (if (not (mus-arrays-equal? (locsig-data gen) #r(0.998 0.000 0.000 0.000 0.000 0.000 0.000 0.002)))
	  (snd-display "locsig -.1(8): ~A" (locsig-data gen)))
      (set! gen (make-locsig -359.9 :channels 8))
      (if (not (mus-arrays-equal? (locsig-data gen) #r(0.998 0.002 0.000 0.000 0.000 0.000 0.000 0.000)))
	  (snd-display "locsig -359.9(8): ~A" (locsig-data gen)))
      (set! gen (make-locsig -359.9 :channels 4))
      (if (not (mus-arrays-equal? (locsig-data gen) #r(0.999 0.001 0.000 0.000)))
	  (snd-display "locsig -359.9(4): ~A" (locsig-data gen)))
      (set! gen (make-locsig -360.1 :channels 8))
      (if (not (mus-arrays-equal? (locsig-data gen) #r(0.998 0.000 0.000 0.000 0.000 0.000 0.000 0.002)))
	  (snd-display "locsig -360.1(8): ~A" (locsig-data gen)))
      (set! gen (make-locsig -700 :channels 8))
      (if (not (mus-arrays-equal? (locsig-data gen) #r(0.556 0.444 0.000 0.000 0.000 0.000 0.000 0.000)))
	  (snd-display "locsig -700(8): ~A" (locsig-data gen)))
      (set! gen (make-locsig -700 :channels 2))
      (if (not (mus-arrays-equal? (locsig-data gen) #r(1.000 0.000)))
	  (snd-display "locsig -700(2): ~A" (locsig-data gen)))
      (set! gen (make-locsig 20 :channels 2))
      (if (not (mus-arrays-equal? (locsig-data gen) #r(0.778 0.222)))
	  (snd-display "locsig 20(2): ~A" (locsig-data gen)))
      (set! gen (make-locsig 123456.0 :channels 8))
      (if (not (mus-arrays-equal? (locsig-data gen) #r(0.467 0.000 0.000 0.000 0.000 0.000 0.000 0.533)))
	  (snd-display "locsig 123456(8): ~A" (locsig-data gen)))
      (set! gen (make-locsig 336.0 :channels 8))
      (if (not (mus-arrays-equal? (locsig-data gen) #r(0.467 0.000 0.000 0.000 0.000 0.000 0.000 0.533)))
	  (snd-display "locsig 336(8): ~A" (locsig-data gen)))
      (set! gen (make-locsig -123456.0 :channels 8))
      (if (not (mus-arrays-equal? (locsig-data gen) #r(0.467 0.533 0.000 0.000 0.000 0.000 0.000 0.000)))
	  (snd-display "locsig -123456(8): ~A" (locsig-data gen)))
      (set! gen (make-locsig 24.0 :channels 8))
      (if (not (mus-arrays-equal? (locsig-data gen) #r(0.467 0.533 0.000 0.000 0.000 0.000 0.000 0.000)))
	  (snd-display "locsig 24(8): ~A" (locsig-data gen))))
    
    (for-each 
     (let ((locsig-scalers 
	    (let ((xmodulo (lambda (a b)
			     (- a (* (floor (/ a b)) b)))))
	      (lambda (chans degree type)
		(if (= chans 1)
		    #r(1.0)
		    (let* ((pos (let ((deg (if (= chans 2)
					       (max 0.0 (min 90.0 degree))
					       (xmodulo degree 360.0)))
				      (degs-per-chan (if (= chans 2)
							 90.0
							 (/ 360.0 chans))))
				  (/ deg degs-per-chan)))
			   (left (floor pos)))
		      (let ((right (xmodulo (+ left 1) chans))
			    (frac (- pos left))
			    (v (make-float-vector chans)))
			(if (= type mus-interp-linear)
			    (begin
			      (set! (v left) (- 1.0 frac))
			      (set! (v right) frac))
			    (let ((ldeg (* (/ pi 2) (- 0.5 frac))))
			      (let ((norm (/ (sqrt 2.0)))
				    (c (cos ldeg))
				    (s (sin ldeg)))
				(set! (v left) (* norm (+ c s)))
				(set! (v right) (* norm (- c s))))))
			v)))))))
       (lambda (rev-chans)
	 
	 (if (file-exists? "test.reverb") (delete-file "test.reverb"))
	 (let ((revfile (and (> rev-chans 0)
			     (make-frample->file "test.reverb" rev-chans mus-bshort mus-next)))
	       (happy #t))
	   (for-each
	    (lambda (type)
	      ;; global type def as well as local par override etc
	      
	      (when happy
		(set! (locsig-type) type)
		(if (not (= (locsig-type) type)) (snd-display "locsig-type: ~A ~A" type (locsig-type)))
		
		(for-each 
		 (lambda (deg)
		   (let ((gen (make-locsig deg :channels 1 :revout revfile :reverb .1 :distance 2.0))
			 (revs (if revfile (locsig-scalers rev-chans deg type))))
		     (if (not (= (mus-channels gen) 1)) (snd-display "locsig ~A: ~A" deg gen))
		     (if (fneq (locsig-ref gen 0) 0.5) (snd-display "locsig scaler[~A] ~A: ~A" type deg (locsig-ref gen 0)))
		     (if revfile
			 (do ((sq (/ .1 (sqrt 2)))
			      (i 0 (+ i 1)))
			     ((or (not happy) (= i rev-chans)))
			   (when (fneq (locsig-reverb-ref gen i) (* sq (revs i)))
			     (snd-display "mono locrev[~A] ~A at ~A: ~A ~A" 
					  type gen deg 
					  (locsig-reverb-ref gen i) 
					  (* sq (revs i)))
			     (set! happy #f))))))
		 '(0.0 45.0 90.0 1234.0))
		
		(for-each
		 (lambda (ltype)
		   (for-each 
		    (lambda (deg)
		      (let ((gen (make-locsig deg :channels 1 :type ltype)))
			(if (not (= (mus-channels gen) 1)) (snd-display "locsig ~A: ~A" deg gen))
			(if (fneq (locsig-ref gen 0) 1.0) (snd-display "locsig[~A] scaler ~A: ~A" ltype deg (locsig-ref gen 0)))))
		    '(0.0 45.0 90.0 1234.0)))
		 (list mus-interp-linear mus-interp-sinusoidal))
		
		(for-each
		 (lambda (chans)
		   (for-each 
		    (lambda (deg)
		      (let ((gen (make-locsig deg :channels chans :revout revfile :reverb .1)))
			(if (not (= (mus-channels gen) chans)) (snd-display "multi locsig ~A: ~A" deg gen))
			(let ((scalers (locsig-scalers chans deg type))
			      (revs (if revfile (locsig-scalers rev-chans deg type))))
			  (do ((i 0 (+ i 1)))
			      ((or (not happy) (= i chans)))
			    (when (fneq (locsig-ref gen i) (scalers i)) 
			      (snd-display "locsig[~A] ~A at ~A: ~A ~A" type gen deg (locsig-ref gen i) (scalers i)) 
			      (set! happy #f)))
			  (if revfile
			      (do ((i 0 (+ i 1)))
				  ((or (not happy) (= i rev-chans)))
				(when (fneq (locsig-reverb-ref gen i) (* .1 (revs i)))
				  (snd-display "locrev[~A] ~A at ~A: ~A ~A" 
					       type gen deg 
					       (locsig-reverb-ref gen i) 
					       (* .1 (revs i)))
				  (set! happy #f)))))))
		    '(0.0 45.0 90.0 120.0 180.0 275.0 315.0 300.0 15.0 1234.0)))
		 '(2 3 4 5 8 12 16 24))
		
		(for-each
		 (lambda (chans)
		   (for-each 
		    (lambda (ltype)
		      (for-each
		       (lambda (deg)
			 (let ((gen (make-locsig deg :channels chans :type ltype :revout revfile :reverb .1)))
			   (if (not (= (mus-channels gen) chans)) (snd-display "stereo locsig ~A: ~A" deg gen))
			   (let ((scalers (locsig-scalers chans deg ltype))
				 (revs (if revfile (locsig-scalers rev-chans deg ltype))))
			     (do ((i 0 (+ i 1)))
				 ((or (not happy) (= i chans)))
			       (when (fneq (locsig-ref gen i) (scalers i)) 
				 (snd-display "locsig[~A] ~A at ~A: ~A ~A" ltype gen deg (locsig-ref gen i) (scalers i))
				 (set! happy #f)))
			     (if revfile
				 (do ((i 0 (+ i 1)))
				     ((or (not happy) (= i rev-chans)))
				   (when (fneq (locsig-reverb-ref gen i) (* .1 (revs i)))
				     (snd-display "locrev[~A] ~A at ~A: ~A ~A" 
						  type gen deg 
						  (locsig-reverb-ref gen i) 
						  (* .1 (revs i)))
				     (set! happy #f)))))))
		       '(0.0 45.0 90.0 120.0 180.0 275.0 315.0 300.0 15.0 1234.0)))
		    (list mus-interp-linear mus-interp-sinusoidal)))
		 '(2 3 4 5 8 12 16 24))))
	    (list mus-interp-linear mus-interp-sinusoidal))
	   (if revfile (mus-close revfile)))))
       '(0 1 2 4))
    
    (set! (locsig-type) mus-interp-linear)
    (let* ((outp (make-float-vector '(1 10)))
	   (gen (make-locsig 0.0 :output outp)))
      (if (not (= (mus-channels gen) 1)) (snd-display "make-locsig->sd chans (1): ~A" (mus-channels gen)))
      (do ((i 0 (+ i 1)))
	  ((= i 10))
	(locsig gen i 1.0))
      (if (not (mus-arrays-equal? (outp 0) (make-float-vector 10 1.0)))
	  (snd-display "locsig->sd chan 0: ~A" (outp 0))))
    
    (let* ((outp (make-float-vector '(2 10)))
	   (gen (make-locsig 0.0 :output outp)))
      (if (not (= (mus-channels gen) 2)) (snd-display "make-locsig->sd chans: ~A" (mus-channels gen)))
      (do ((i 0 (+ i 1)))
	  ((= i 10))
	(locsig gen i 1.0))
      (if (not (mus-arrays-equal? (outp 0) (make-float-vector 10 1.0)))
	  (snd-display "locsig->sd chan 0: ~A" (outp 0)))
      (if (not (mus-arrays-equal? (outp 1) (make-float-vector 10)))
	  (snd-display "locsig->sd chan 1: ~A" (outp 1))))
    
    (let* ((outp (make-float-vector '(2 10)))
	   (gen (make-locsig 45.0 :output outp)))
      (if (not (= (mus-channels gen) 2)) (snd-display "make-locsig->sd chans: ~A" (mus-channels gen)))
      (do ((i 0 (+ i 1)))
	  ((= i 10))
	(locsig gen i 1.0))
      (if (not (mus-arrays-equal? (outp 0) (make-float-vector 10 0.5)))
	  (snd-display "locsig->sd chan 0 (0.5): ~A (~A)" (outp 0) gen))
      (if (not (mus-arrays-equal? (outp 1) (make-float-vector 10 0.5)))
	  (snd-display "locsig->sd chan 1 (0.5): ~A" (outp 1)))
      (do ((i 0 (+ i 1)))
	  ((= i 10))
	(locsig gen i 0.5))
      (if (not (mus-arrays-equal? (outp 0) (make-float-vector 10 0.75)))
	  (snd-display "locsig->sd chan 0 (0.75) (~A): ~A" (outp 0) gen))
      (if (not (mus-arrays-equal? (outp 1) (make-float-vector 10 0.75)))
	  (snd-display "locsig->sd chan 1 (0.75): ~A" (outp 1))))
    
    (let* ((outp (make-float-vector 10))
	   (gen (make-locsig 0.0 :output outp)))
      (if (not (= (mus-channels gen) 1)) (snd-display "make-locsig->float-vector chans: ~A" (mus-channels gen)))
      (do ((i 0 (+ i 1)))
	  ((= i 10))
	(locsig gen i 1.0))
      (if (not (mus-arrays-equal? outp (make-float-vector 10 1.0)))
	  (snd-display "locsig->float-vector chan 0: ~A" outp))
      (do ((i 0 (+ i 1)))
	  ((= i 10))
	(locsig gen i 0.5))
      (if (not (mus-arrays-equal? outp (make-float-vector 10 1.5)))
	  (snd-display "locsig->float-vector chan 0: ~A" outp)))
    
    (let* ((outp (make-float-vector 10))
	   (gen (make-locsig 45.0 :channels 2 :output outp)))
      (if (not (= (mus-channels gen) 2)) (snd-display "make-locsig->float-vector chans (2): ~A" (mus-channels gen)))
      (do ((i 0 (+ i 1)))
	  ((= i 10))
	(locsig gen i 1.0))
      (if (not (mus-arrays-equal? outp (make-float-vector 10 0.5)))
	  (snd-display "locsig(2)->float-vector chan 0: ~A" outp))
      (do ((i 0 (+ i 1)))
	  ((= i 10))
	(locsig gen i 0.5))
      (if (not (mus-arrays-equal? outp (make-float-vector 10 0.75)))
	  (snd-display "locsig(2)->float-vector chan 0: ~A" outp)))
    
    (let* ((outp (make-float-vector '(4 10)))
	   (gen (make-locsig 135.0 :output outp)))
      (if (not (= (mus-channels gen) 4)) (snd-display "make-locsig->sd chans (4): ~A" (mus-channels gen)))
      (do ((i 0 (+ i 1)))
	  ((= i 10))
	(locsig gen i 1.0))
      (if (not (mus-arrays-equal? (outp 0) (make-float-vector 10)))
	  (snd-display "locsig(4)->sd chan 0 (0.5): ~A" (outp 0)))
      (if (not (mus-arrays-equal? (outp 1) (make-float-vector 10 0.5)))
	  (snd-display "locsig(4)->sd chan 1 (0.5) (~A): ~A" (outp 1) gen))
      (if (not (mus-arrays-equal? (outp 2) (make-float-vector 10 0.5)))
	  (snd-display "locsig(4)->sd chan 2 (0.5): ~A" (outp 2)))
      (if (not (mus-arrays-equal? (outp 3) (make-float-vector 10)))
	  (snd-display "locsig(4)->sd chan 3 (0.5): ~A" (outp 3))))

    (set! *mus-array-print-length* 8)
    (let* ((outf1 (make-frample->file "fmv.snd" 1 mus-ldouble mus-next))
	   (outf4 (make-frample->file "fmv1.snd" 4 mus-ldouble mus-next))
	   (revf (make-frample->file "fmv2.snd" 1 mus-ldouble mus-next))
	   (gen1 (make-move-sound (list 0 1000 1 0
					(make-delay 32) 
					(make-env '(0 0 1 1) :length 1001) 
					(make-env '(0 0 1 1) :length 1001)
					(vector (make-delay 32)) 
					(vector (make-env '(0 0 1 1) :length 1001)) 
					#f
					(vector 0 1))
				  outf1))
	   (gen2 (make-move-sound (list 0 1000 4 0
					(make-delay 12) 
					(make-env '(0 0 10 1) :duration 1.0)
					#f
					(make-vector 4 #f)
					(vector (make-env '(0 0 1 1 2 0 3 0 4 0) :duration 1.0)
						(make-env '(0 0 1 0 2 1 3 0 4 0) :duration 1.0)
						(make-env '(0 0 1 0 2 0 3 1 4 0) :duration 1.0)
						(make-env '(0 0 1 0 2 0 3 0 4 1) :duration 1.0))
					#f
					(vector 0 1 2 3))
				  outf4))
	   (gen3 (make-move-sound (list 0 1000 1 1
					(make-delay 32) 
					(make-env '(0 0 1 1) :length 1001) 
					(make-env '(0 0 1 1) :length 1001)
					(vector (make-delay 32)) 
					(vector (make-env '(0 0 1 1) :length 1001)) 
					(vector (make-env '(0 1 1 1) :length 1001))
					(vector 0 1))
				  outf1 revf)))
      
      (print-and-check gen1
		       "move-sound"
		       "move-sound start: 0, end: 1000, out chans 1, rev chans: 0
  doppler delay line[32, step]: [0 0 0 0 0 0 0 0...(0: 0, 0: 0)]
  doppler env linear, pass: 0 (dur: 1001), index: 0, scaler: 1.0000, offset: 0.0000, data: [0 0 1 1]
  global reverb env linear, pass: 0 (dur: 1001), index: 0, scaler: 1.0000, offset: 0.0000, data: [0 0 1 1]
  out_delays[1]:
    [0]: delay line[32, step]: [0 0 0 0 0 0 0 0...(0: 0, 0: 0)]
  out_envs[1]:
    [0]: env linear, pass: 0 (dur: 1001), index: 0, scaler: 1.0000, offset: 0.0000, data: [0 0 1 1]
  rev_envs: nil
  out_map[1]: (0)
  free: arrays: true, gens: false
")
      
      (print-and-check gen2
		       "move-sound"
		       "move-sound start: 0, end: 1000, out chans 4, rev chans: 0
  doppler delay line[12, step]: [0 0 0 0 0 0 0 0...(0: 0, 0: 0)]
  doppler env linear, pass: 0 (dur: 22050), index: 0, scaler: 1.0000, offset: 0.0000, data: [0 0 10 1]
  global reverb null
  out_delays[4]:
    [0]: nil
    [1]: nil
    [2]: nil
    [3]: nil
  out_envs[4]:
    [0]: env linear, pass: 0 (dur: 22050), index: 0, scaler: 1.0000, offset: 0.0000, data: [0 0 1 1 2 0 3 0...(0: 0, 8: 4)]
    [1]: env linear, pass: 0 (dur: 22050), index: 0, scaler: 1.0000, offset: 0.0000, data: [0 0 1 0 2 1 3 0...(0: 0, 8: 4)]
    [2]: env linear, pass: 0 (dur: 22050), index: 0, scaler: 1.0000, offset: 0.0000, data: [0 0 1 0 2 0 3 1...(0: 0, 8: 4)]
    [3]: env linear, pass: 0 (dur: 22050), index: 0, scaler: 1.0000, offset: 0.0000, data: [0 0 1 0 2 0 3 0...(0: 0, 8: 4)]
  rev_envs: nil
  out_map[4]: (0 1 2 3)
  free: arrays: true, gens: false
")
      
      (print-and-check gen3
		       "move-sound"
		       "move-sound start: 0, end: 1000, out chans 1, rev chans: 1
  doppler delay line[32, step]: [0 0 0 0 0 0 0 0...(0: 0, 0: 0)]
  doppler env linear, pass: 0 (dur: 1001), index: 0, scaler: 1.0000, offset: 0.0000, data: [0 0 1 1]
  global reverb env linear, pass: 0 (dur: 1001), index: 0, scaler: 1.0000, offset: 0.0000, data: [0 0 1 1]
  out_delays[1]:
    [0]: delay line[32, step]: [0 0 0 0 0 0 0 0...(0: 0, 0: 0)]
  out_envs[1]:
    [0]: env linear, pass: 0 (dur: 1001), index: 0, scaler: 1.0000, offset: 0.0000, data: [0 0 1 1]
  rev_envs[1]:
    [0]: env linear, pass: 0 (dur: 1001), index: 0, scaler: 1.0000, offset: 0.0000, data: [0 1 1 1]
  out_map[1]: (0)
  free: arrays: true, gens: false
")
      
      (if (not (move-sound? gen1)) (snd-display "move-sound?"))
      (if (equal? gen1 gen2) (snd-display "move-sounds are equal?"))
      (if (not (= (mus-channels gen1) 1)) (snd-display "mus-channels move-sound (1): ~A" (mus-channels gen1)))
      (if (not (= (mus-channels gen2) 4)) (snd-display "mus-channels move-sound (4): ~A" (mus-channels gen2)))
      (mus-reset gen1) ; a no-op
      
      (do ((v (make-float-vector 10))
	   (i 0 (+ i 1)))
	  ((= i 10)
	   (if (not (mus-arrays-equal? v (make-float-vector 10 0.875)))
	       (snd-display "move-sound output: ~A" v)))
	(set! (v i) (+ (move-sound gen1 i 0.5)
		       (gen2 i 0.25)
		       (move-sound gen3 i 0.125))))
      
      (let ((var (catch #t (lambda () (make-move-sound (list 0 1000 1 0 (make-oscil 32) (make-env '(0 0 1 1) :length 1001) 
							     (make-env '(0 0 1 1) :length 1001) (vector (make-delay 32)) 
							     (vector (make-env '(0 0 1 1) :length 1001)) #f (vector 0 1))
						       outf1))
			(lambda args args))))
	(if (not (eq? (car var) 'wrong-type-arg))
	    (snd-display "make-move-sound bad doppler delay: ~A" var)))
      (let ((var (catch #t (lambda () (make-move-sound (list 0 1000 1 0 (make-oscil 32) (make-env '(0 0 1 1) :length 1001) 
							     (make-env '(0 0 1 1) :length 1001) (vector (make-delay 32)))
						       outf1))
			(lambda args args))))
	(if (not (eq? (car var) 'wrong-type-arg))
	    (snd-display "make-move-sound truncated list: ~A" var)))
      (let ((var (catch #t (lambda () (make-move-sound (list 0 1000 1 0 (make-delay 32) (make-env '(0 0 1 1) :length 1001) 
							     #f (vector #f)
							     (vector (make-env '(0 0 1 1) :length 1001)) #f #f)
						       outf1))
			(lambda args args))))
	(if (not (eq? (car var) 'wrong-type-arg))
	    (snd-display "make-move-sound no out map: ~A" var)))
      
      
      (mus-close outf1) 
      (mus-close outf4) 
      (mus-close revf)
      
      (if (file-exists? "fmv.snd") (delete-file "fmv.snd"))
      (if (file-exists? "fmv1.snd") (delete-file "fmv1.snd"))
      (if (file-exists? "fmv2.snd") (delete-file "fmv2.snd"))
      (mus-sound-prune))
    
    (let* ((vo (make-float-vector 1000))
	   (gen1 (make-move-sound (list 0 1000 1 0
					(make-delay 32) 
					(make-env '(0 0 1 1) :length 1001) 
					(make-env '(0 0 1 1) :length 1001)
					(vector (make-delay 32)) 
					(vector (make-env '(0 0 1 1) :length 1001)) 
					#f
					(vector 0 1))
				  vo))
	   (start -1))
      (do ((i 0 (+ i 1)))
	  ((= i 1000))
	(move-sound gen1 i 0.5)
	(if (and (< start 0)
		 (fneq (vo i) 0.0))
	    (set! start i)))
      (if (not (= start 64))
	  (snd-display "move-sound float-vector output start: ~A" start))
      (if (fneq (float-vector-peak vo) 0.484)
	  (snd-display "move-sound float-vector output: ~A" (float-vector-peak vo))))
    
    (let* ((vo (make-float-vector '(1 1000)))
	   (gen1 (make-move-sound (list 0 1000 1 0
					(make-delay 32) 
					(make-env '(0 0 1 1) :length 1001) 
					(make-env '(0 0 1 1) :length 1001)
					(vector (make-delay 32)) 
					(vector (make-env '(0 0 1 1) :length 1001)) 
					#f
					(vector 0 1))
				  vo))
	   (start -1))
      (do ((i 0 (+ i 1)))
	  ((= i 1000))
	(move-sound gen1 i 0.5)
	(if (and (< start 0)
		 (fneq (vo 0 i) 0.0))
	    (set! start i)))
      (if (not (= start 64))
	  (snd-display "move-sound sd output start: ~A" start))
      (if (fneq (maxamp vo) 0.484)
	  (snd-display "move-sound sd output: ~A" (maxamp vo))))
    
    (let* ((vo (make-float-vector 1000))
	   (gen1 (make-move-sound (list 0 1000 1 0
					(make-delay 32) 
					(make-env '(0 0 1 1) :length 1001) 
					(make-env '(0 0 1 1) :length 1001)
					(vector (make-delay 32)) 
					(vector (make-env '(0 0 1 1) :length 1001)) 
					#f
					(vector 0 1))
				  vo))
	   (start -1))
       (do ((i 0 (+ i 1)))
	   ((= i 1000))
	 (move-sound gen1 i 0.5)
	 (if (and (< start 0)
		  (> (abs (vo i)) 0.001))
	     (set! start i)))
      (if (not (= start 64))
	  (snd-display "move-sound opt float-vector output start: ~A" start))
      (if (fneq (float-vector-peak vo) 0.484)
	  (snd-display "move-sound opt float-vector output: ~A" (float-vector-peak vo))))
    
    (let* ((vo (make-float-vector '(1 1000)))
	   (gen1 (make-move-sound (list 0 1000 1 0
					(make-delay 32) 
					(make-env '(0 0 1 1) :length 1001) 
					(make-env '(0 0 1 1) :length 1001)
					(vector (make-delay 32)) 
					(vector (make-env '(0 0 1 1) :length 1001)) 
					#f
					(vector 0 1))
				  vo))
	   (start -1))
       (do ((i 0 (+ i 1)))
	   ((= i 1000))
	 (move-sound gen1 i 0.5)
	 (if (and (< start 0)
		  (> (abs (vo 0 i)) 0.001))
	     (set! start i)))
      (if (not (= start 64))
	  (snd-display "move-sound opt sd output start: ~A" start))
      (if (fneq (maxamp vo) 0.484)
	  (snd-display "move-sound opt sd output: ~A" (maxamp vo))))
    
    (let ((var (catch #t (lambda () (make-src :width -1)) (lambda args args))))
      (if (not (eq? (car var) 'out-of-range))
	  (snd-display "make-src bad width: ~A" var)))
    
    (let ((s1 (make-src (lambda (y) 1.0) 2.0)))
      (for-each (lambda (arg) 
		  (src s1 arg))
		'(25.0 25.0 125.0 -25.0 -125.0)))
    (do ((i 0 (+ i 1)))
	((= i 10))
      (make-src (lambda (y) 1.0) 1.5 :width (+ 5 (* i 10))))
    
    (let ((ctr 0.0))
      (let ((gen (make-src :srate 2.0 :input (lambda (dir) (let ((val ctr)) (set! ctr (+ ctr 1)) val))))
	    (v0 (make-float-vector 10)))
	(do ((i 0 (+ i 1)))
	    ((= i 10))
	  (set! (v0 i) (src gen 0.0)))
	(set! ctr 0.0) ; will be accessed within reset
	(mus-reset gen)
	(do ((i 0 (+ i 1)))
	    ((= i 10))
	  (let ((old-val (v0 i))
		(new-val (src gen 0.0)))
	    (if (fneq old-val new-val)
		(snd-display "reset src ~A ~A ~A" i old-val new-val))))))
    
    (let ()
      (define (so1 s p)
	(src s (env p)))
      
      (let ((s1 (make-src :srate 2.0 :input (make-readin "oboe.snd" 0 10000)))
	    (s2 (make-src :srate 2.0 :input (make-readin "oboe.snd" 0 10000)))
	    (s3 (make-src :srate 2.0 :input (make-readin "oboe.snd" 0 10000)))
	    (e1 (make-env '(0 1 2 0.5) :duration 1000))
	    (e2 (make-env '(0 1 2 0.5) :duration 1000))
	    (e3 (make-env '(0 1 2 0.5) :duration 1000)))
	(do ((i 0 (+ i 1)))
	    ((= i 100))
	  (let ((x1 (src s1 (env e1)))
		(ex2 (env e2)))
	    (let ((x2 (src s2 ex2))
		  (x3 (so1 s3 e3)))
	      (if (not (= x1 x2 x3))
		  (format () "~D ~A ~A ~A~%" i x1 x2 x3)))))))

    (let ((gen (make-granulate :expansion 2.0 :input (make-readin "oboe.snd" 0 4000 1 2048))))
      (print-and-check gen 
		       "granulate"
		       "granulate expansion: 2.000 (551/1102), scaler: 0.600, length: 0.150 secs (3308 samps), ramp: 0.400, jitter: 1.000")
      (let ((rd1b (make-readin :file "oboe.snd" :channel 0 :start 4000 :direction 1 :size *clm-file-buffer-size*))
	    (v0 (make-float-vector 1000)))
	(let ((gen1 (make-granulate :expansion 2.0
				    :input (lambda (dir) (readin rd1b)))))
	  (do ((i 0 (+ i 1)))
	      ((= i 1000))
	    (set! (v0 i) (granulate gen)))
	  (let ((v1 (make-float-vector 1000)))
	    (fill-float-vector v1 (if (granulate? gen1) (granulate gen1) -1.0))
	    (let ((worst (abs (- (float-vector-peak v0) (float-vector-peak v1)))))
	      (if (> worst .01) (snd-display "run granulate: ~A" worst))))
	  (if (equal? gen gen1) (snd-display "granulate equal? ~A ~A" gen gen1)))
	(if (= (float-vector-peak v0) 0.0) (snd-display "granulate output peak: ~F?" (float-vector-peak v0))))
      (if (not (granulate? gen)) (snd-display "~A not granulate?" gen))
      (if (fneq (mus-increment gen) 2.0) (snd-display "granulate increment: ~F?" (mus-increment gen)))
      (if (fneq (mus-scaler gen) 0.6) (snd-display "granulate scaler: ~F?" (mus-scaler gen)))
      (if (ffneq (mus-frequency gen) 0.05) (snd-display "granulate frequency: ~F?" (mus-frequency gen)))
      (if (not (= (mus-ramp gen) 1323)) (snd-display "granulate ramp: ~F?" (mus-ramp gen)))
      (if (not (= (mus-length gen) 3308)) (snd-display "granulate length: ~A?" (mus-length gen)))
      (if (not (= (mus-hop gen) 1102)) (snd-display "granulate hop: ~A?" (mus-hop gen)))
      (set! (mus-hop gen) 1000) (if (not (= (mus-hop gen) 1000)) (snd-display "granulate set-hop: ~A?" (mus-hop gen)))
      (set! (mus-ramp gen) 1000) (if (not (= (mus-ramp gen) 1000)) (snd-display "granulate set-ramp: ~A?" (mus-ramp gen)))
      (set! (mus-length gen) 3000) (if (not (= (mus-length gen) 3000)) (snd-display "granulate set-length: ~A?" (mus-length gen)))
      (set! (mus-increment gen) 3.0)
      (if (> (abs (- (mus-increment gen) 3.0)) .01) (snd-display "granulate set-increment: ~F?" (mus-increment gen)))
      (set! (mus-increment gen) 0.0) ; should be a no-op
      (if (> (abs (- (mus-increment gen) 3.0)) .01) (snd-display "granulate set-increment 0.0: ~F?" (mus-increment gen)))
      (set! (mus-location gen) 1)
      (if (not (= (mus-location gen) 1)) (snd-display "mus-location grn: ~A" (mus-location gen)))
      (set! (mus-frequency gen) .1)
      (if (fneq (mus-frequency gen) .1) (snd-display "set granulate freq: ~A" (mus-frequency gen))))
    (let ((var (catch #t (lambda () (make-granulate :hop 35.0 :length 35.0)) (lambda args args))))
      (if (not (eq? (car var) 'out-of-range))
	  (snd-display "make-granulate bad sizes: ~A" var)))
    
    (let ((ind (new-sound :size 10)))
      (set! (sample 2) .1)
      (set! (sample 6) -.5)
      (let ((vals (map values (make-sampler))))
	(if (not (morally-equal? vals '(0.0 0.0 0.1 0.0 0.0 0.0 -0.5 0.0 0.0 0.0)))
	    (snd-display "rd new: ~A" vals)))
      (close-sound ind))
    (let* ((ind (open-sound "oboe.snd"))
	   (mx (maxamp))
	   (rd (make-sampler 0)))
      (if (not (= (length rd) 50828))
	  (snd-display "sampler (oboe) length: ~A" (length rd)))
      (let ((grn (make-granulate :expansion 2.0
				 :input (lambda (dir) (read-sample rd))
				 :edit (lambda (g)
					 (float-vector-scale! (mus-data g) 2.0)
					 0))))
	(map-channel (lambda (y) (granulate grn)))
	(if (or (< (/ (maxamp) mx) 1.4) (> (/ mx (maxamp)) 2.5))
	    (snd-display "gran edit 2* (0): ~A ~A" mx (maxamp)))
	(undo))
      (let ((grn (make-granulate :expansion 2.0
				 :input (let ((rd (make-sampler 0)))
					  (lambda (dir) 
					    (read-sample rd)))
				 :edit (lambda (g)
					 (float-vector-scale! (mus-data g) 4.0)
					 0))))
	(map-channel (lambda (y) (granulate grn)))
	(if (or (< (/ (maxamp) mx) 3.0) (> (/ mx (maxamp)) 6.0))
	    (snd-display "gran edit 4* (0): ~A ~A" mx (maxamp)))
	(revert-sound ind))
      (let ((grn (make-granulate :expansion 2.0
				 :input (let ((rd (make-sampler 0)))
					  (lambda (dir)
					    (read-sample rd)))
				 :edit (lambda (g)
					 (float-vector-scale! (mus-data g) 2.0)
					 0))))
	(map-channel (lambda (y) (granulate grn)))
	(if (or (< (/ (maxamp) mx) 1.4) (> (/ mx (maxamp)) 2.5))
	    (snd-display "gran edit 2* (1): ~A ~A" mx (maxamp)))
	(undo)
	(let ((grn (make-granulate :expansion 2.0
				   :edit (lambda (g)
					   (float-vector-scale! (mus-data g) 4.0)
					   0)
				   :input (let ((rd (make-sampler 0)))
					    (lambda (dir) 
					      (read-sample rd))))))
	  (map-channel (lambda (y) (granulate grn)))
	  (if (or (< (/ (maxamp) mx) 2.9) (> (/ mx (maxamp)) 6.0))
	      (snd-display "gran edit 4* (1): ~A ~A" mx (maxamp)))
	  (revert-sound ind)))
      (let ((grn (make-granulate :expansion 2.0 
				 :input (make-sampler 0)
				 :edit (lambda (g)
					 (float-vector-scale! (mus-data g) 2.0)
					 0))))
	(map-channel (lambda (y) (granulate grn)))
	(if (or (< (/ (maxamp) mx) 1.4) (> (/ mx (maxamp)) 2.5))
	    (snd-display "gran edit 2* (2): ~A ~A" mx (maxamp)))
	(undo)
	(let ((grn (make-granulate :expansion 2.0
				   :input (let ((rd (make-sampler 0)))
					    (lambda (dir) 
					      (read-sample rd)))
				    :edit (lambda (g)
					    (float-vector-scale! (mus-data g) 4.0) 0))))
	  (map-channel (lambda (y) (granulate grn)))
	  (if (or (< (/ (maxamp) mx) 3.0) (> (/ mx (maxamp)) 6.0))
	      (snd-display "gran edit 4* (2): ~A ~A" mx (maxamp)))))
      (close-sound ind))
    
    (let ((ind (open-sound "oboe.snd")))
      (let ((grn (make-granulate :expansion 2.0 :length .01 :hop .05 :input (let ((rd (make-sampler))) (lambda (dir) (next-sample rd))))))
	(map-channel (lambda (y) (granulate grn)))
	(let ((mx (maxamp)))
	  (if (> mx .2) (snd-display "trouble in granulate len .01 hop .05: ~A" mx))
	  (undo)))
      (let ((grn (make-granulate :expansion 2.0 :length .04 :hop .05 :input (let ((rd (make-sampler))) (lambda (dir) (next-sample rd))))))
	(map-channel (lambda (y) (granulate grn)))
	(let ((mx (maxamp)))
	  (if (> mx .2) (snd-display "trouble in granulate len .04 hop .05: ~A" mx))
	  (undo)))
      (let ((grn (make-granulate :expansion 2.0 :length .01 :hop .25 :input (let ((rd (make-sampler))) (lambda (dir) (next-sample rd))))))
	(map-channel (lambda (y) (granulate grn)))
	(let ((mx (maxamp)))
	  (if (> mx .2) (snd-display "trouble in granulate len .01 hop .25: ~A" mx))
	  (undo)))
      (let ((grn (make-granulate :expansion 2.0 :length .4 :hop .5 :input (let ((rd (make-sampler))) (lambda (dir) (next-sample rd))))))
	(map-channel (lambda (y) (granulate grn)))
	(let ((mx (maxamp)))
	  (if (> mx .2) (snd-display "trouble in granulate len .4 hop .5: ~A" mx))
	  (undo)))
      (close-sound ind))
    
    (let ((ind (new-sound :size 1000)))
      (let ((gen (make-granulate :jitter 0.0 :hop .004 :length .001 :input (lambda (dir) .1))))
	(map-channel (lambda (y) (granulate gen))))
      (let ((mx (maxamp)))
	(if (fneq mx 0.06) (snd-display "gran 0 max: ~A" mx)))
      (if (not (mus-arrays-equal? (channel->float-vector 0 30) 
		       #r(0.000 0.007 0.013 0.020 0.027 0.033 0.040 0.047 0.053 0.060 0.060 0.060 0.060 0.060 0.060 0.053 
				     0.047 0.040 0.033 0.027 0.020 0.013 0.007 0.000 0.000 0.000 0.000 0.000 0.000 0.000)))
	  (snd-display "gran 0 data: ~A" (channel->float-vector 0 30)))
      (if (not (mus-arrays-equal? (channel->float-vector 85 30) 
		       #r(0.000 0.000 0.000 0.000 0.007 0.013 0.020 0.027 0.033 0.040 0.047 0.053 0.060 0.060 0.060 0.060
				     0.060 0.060 0.053 0.047 0.040 0.033 0.027 0.020 0.013 0.007 0.000 0.000 0.000 0.000)))
	  (snd-display "gran 0 data 85: ~A" (channel->float-vector 85 30)))
      (undo)
      
      (let ((gen (make-granulate :jitter 0.0 :hop .002 :length .001 :input (lambda (dir) .1))))
	(map-channel (lambda (y) (granulate gen))))
      (let ((mx (maxamp)))
	(if (fneq mx 0.06) (snd-display "gran 1 max: ~A" mx)))
      (if (not (mus-arrays-equal? (channel->float-vector 0 30) 
		       #r(0.000 0.007 0.013 0.020 0.027 0.033 0.040 0.047 0.053 0.060 0.060 0.060 0.060 0.060 0.060 0.053 
				     0.047 0.040 0.033 0.027 0.020 0.013 0.007 0.000 0.000 0.000 0.000 0.000 0.000 0.000)))
	  (snd-display "gran 1 data: ~A" (channel->float-vector 0 30)))
      (if (not (mus-arrays-equal? (channel->float-vector 40 30) 
		       #r(0.000 0.000 0.000 0.000 0.000 0.007 0.013 0.020 0.027 0.033 0.040 0.047 0.053 0.060 0.060 0.060 
				     0.060 0.060 0.060 0.053 0.047 0.040 0.033 0.027 0.020 0.013 0.007 0.000 0.000 0.000)))
	  (snd-display "gran 1 data 40: ~A" (channel->float-vector 85 30)))
      (undo)
      
      (let ((gen (make-granulate :jitter 0.0 :hop .002 :length .001 :ramp .1 :input (lambda (dir) .1))))
	(map-channel (lambda (y) (granulate gen))))
      (let ((mx (maxamp)))
	(if (fneq mx 0.06) (snd-display "gran 2 max: ~A" mx)))
      (if (not (mus-arrays-equal? (channel->float-vector 0 30) 
		       #r(0.000 0.030 0.060 0.060 0.060 0.060 0.060 0.060 0.060 0.060 0.060 0.060 0.060 0.060 0.060 0.060 
				     0.060 0.060 0.060 0.060 0.060 0.060 0.030 0.000 0.000 0.000 0.000 0.000 0.000 0.000)))
	  (snd-display "gran 2 data: ~A" (channel->float-vector 0 30)))
      (if (not (mus-arrays-equal? (channel->float-vector 40 30) 
		       #r(0.000 0.000 0.000 0.000 0.000 0.030 0.060 0.060 0.060 0.060 0.060 0.060 0.060 0.060 0.060 0.060
				     0.060 0.060 0.060 0.060 0.060 0.060 0.060 0.060 0.060 0.060 0.030 0.000 0.000 0.000)))
	  (snd-display "gran 2 data 40: ~A" (channel->float-vector 40 30)))
      (undo)
      
      (let ((gen (make-granulate :jitter 0.0 :hop .002 :length .001 :ramp .5 :input (lambda (dir) .1))))
	(map-channel (lambda (y) (granulate gen))))
      (let ((mx (maxamp)))
	(if (fneq mx 0.06) (snd-display "gran 3 max: ~A" mx)))
      (if (not (mus-arrays-equal? (channel->float-vector 0 30) 
		       #r(0.000 0.005 0.011 0.016 0.022 0.027 0.033 0.038 0.044 0.049 0.055 0.060 0.060 0.055 0.049 0.044 
				     0.038 0.033 0.027 0.022 0.016 0.011 0.005 0.000 0.000 0.000 0.000 0.000 0.000 0.000)))
	  (snd-display "gran 3 data: ~A" (channel->float-vector 0 30)))
      (if (not (mus-arrays-equal? (channel->float-vector 85 30) 
		       #r(0.000 0.000 0.000 0.000 0.005 0.011 0.016 0.022 0.027 0.033 0.038 0.044 0.049 0.055 0.060 0.060 
				     0.055 0.049 0.044 0.038 0.033 0.027 0.022 0.016 0.011 0.005 0.000 0.000 0.000 0.000)))
	  (snd-display "gran 3 data 85: ~A" (channel->float-vector 85 30)))
      (undo)
      
      (let ((gen (make-granulate :jitter 0.0 :hop .001 :length .001 :ramp .5 :input (lambda (dir) .1))))
	(map-channel (lambda (y) (granulate gen))))
      (let ((mx (maxamp)))
	(if (fneq mx 0.06) (snd-display "gran 4 max: ~A" mx)))
      (if (not (mus-arrays-equal? (channel->float-vector 0 30) 
		       #r(0.000 0.005 0.011 0.016 0.022 0.027 0.033 0.038 0.044 0.049 0.055 0.060 0.060 0.055 0.049 0.044 
				     0.038 0.033 0.027 0.022 0.016 0.011 0.005 0.005 0.011 0.016 0.022 0.027 0.033 0.038)))
	  (snd-display "gran 4 data: ~A" (channel->float-vector 0 30)))
      (if (not (mus-arrays-equal? (channel->float-vector 85 30) 
		       #r(0.022 0.016 0.011 0.005 0.005 0.011 0.016 0.022 0.027 0.033 0.038 0.044 0.049 0.055 0.060 0.060 
				     0.055 0.049 0.044 0.038 0.033 0.027 0.022 0.016 0.011 0.005 0.005 0.011 0.016 0.022)))
	  (snd-display "gran 4 data 85: ~A" (channel->float-vector 85 30)))
      (undo)
      
      (let ((gen (make-granulate :jitter 0.0 :hop .001 :length .001 :ramp .25 :scaler 1.0 :input (lambda (dir) .1))))
	(map-channel (lambda (y) (granulate gen))))
      (let ((mx (maxamp)))
	(if (fneq mx 0.1) (snd-display "gran 5 max: ~A" mx)))
      (if (not (mus-arrays-equal? (channel->float-vector 0 30) 
		       #r(0.000 0.020 0.040 0.060 0.080 0.100 0.100 0.100 0.100 0.100 0.100 0.100 0.100 0.100 0.100 0.100 
				     0.100 0.100 0.100 0.080 0.060 0.040 0.020 0.020 0.040 0.060 0.080 0.100 0.100 0.100)))
	  (snd-display "gran 5 data: ~A" (channel->float-vector 0 30)))
      (if (not (mus-arrays-equal? (channel->float-vector 85 30) 
		       #r(0.080 0.060 0.040 0.020 0.020 0.040 0.060 0.080 0.100 0.100 0.100 0.100 0.100 0.100 0.100 0.100 
				     0.100 0.100 0.100 0.100 0.100 0.100 0.080 0.060 0.040 0.020 0.020 0.040 0.060 0.080)))
	  (snd-display "gran 5 data 85: ~A" (channel->float-vector 85 30)))
      (undo)
      
      (let ((gen (make-granulate :jitter 0.0 :hop .001 :length .002 :ramp .5 :scaler 1.0 :input (lambda (dir) .1))))
	(map-channel (lambda (y) (granulate gen))))
      (let ((mx (maxamp)))
	(if (fneq mx 0.105) (snd-display "gran 6 max: ~A" mx)))
      (if (not (mus-arrays-equal? (channel->float-vector 0 30) 
		       #r(0.000 0.005 0.009 0.014 0.018 0.023 0.027 0.032 0.036 0.041 0.045 0.050 0.055 0.059 0.064 0.068 
				     0.073 0.077 0.082 0.086 0.091 0.095 0.100 0.105 0.105 0.105 0.105 0.105 0.105 0.105)))
	  (snd-display "gran 6 data: ~A" (channel->float-vector 0 30)))
      (if (not (mus-arrays-equal? (channel->float-vector 85 30) (make-float-vector 30 0.105)))
	  (snd-display "gran 6 data 85: ~A" (channel->float-vector 85 30)))
      (undo)
      
      (let ((gen (make-granulate :jitter 0.0 :hop .001 :length .005 :ramp .5 :scaler 1.0 :input (lambda (dir) .1))))
	(map-channel (lambda (y) (granulate gen))))
      (let ((mx (maxamp)))
	(if (fneq mx 0.264) (snd-display "gran 7 max: ~A" mx)))
      (if (not (mus-arrays-equal? (channel->float-vector 0 30) 
		       #r(0.000 0.002 0.004 0.005 0.007 0.009 0.011 0.013 0.015 0.016 0.018 0.020 0.022 0.024 0.025 0.027 
				     0.029 0.031 0.033 0.035 0.036 0.038 0.040 0.044 0.047 0.051 0.055 0.058 0.062 0.065)))
	  (snd-display "gran 7 data: ~A" (channel->float-vector 0 30)))
      (if (not (mus-arrays-equal? (channel->float-vector 85 30) 
		       #r(0.244 0.244 0.244 0.244 0.245 0.247 0.249 0.251 0.253 0.255 0.256 0.258 0.260 0.262 0.264 0.264 
				     0.262 0.260 0.258 0.256 0.255 0.253 0.251 0.249 0.247 0.245 0.245 0.247 0.249 0.251)))
	  (snd-display "gran 7 data 85: ~A" (channel->float-vector 85 30)))
      (undo)
      
      (let ((gen (make-granulate :jitter 0.0 :hop .01 :length .001 :ramp .5 :scaler 1.0 :expansion 2.0 :input (lambda (dir) .1))))
	(map-channel (lambda (y) (granulate gen))))
      (let ((mx (maxamp)))
	(if (fneq mx 0.1) (snd-display "gran 8 max: ~A" mx)))
      (if (not (mus-arrays-equal? (channel->float-vector 0 30) 
		       #r(0.000 0.009 0.018 0.027 0.036 0.045 0.055 0.064 0.073 0.082 0.091 0.100 0.100 0.091 0.082 0.073 
				     0.064 0.055 0.045 0.036 0.027 0.018 0.009 0.000 0.000 0.000 0.000 0.000 0.000 0.000)))
	  (snd-display "gran 8 data: ~A" (channel->float-vector 0 30)))
      (if (not (mus-arrays-equal? (channel->float-vector 220 30) 
		       #r(0.000 0.009 0.018 0.027 0.036 0.045 0.055 0.064 0.073 0.082 0.091 0.100 0.100 0.091 0.082 0.073 
				     0.064 0.055 0.045 0.036 0.027 0.018 0.009 0.000 0.000 0.000 0.000 0.000 0.000 0.000)))
	  (snd-display "gran 8 data 220: ~A" (channel->float-vector 220 30)))
      (undo)
      
      (let ((gen (make-granulate :jitter 0.0 :hop .01 :length .001 :ramp .5 :scaler 1.0 :expansion 0.5 :input (lambda (dir) .1))))
	(map-channel (lambda (y) (granulate gen))))
      (let ((mx (maxamp)))
	(if (fneq mx 0.1) (snd-display "gran 9 max: ~A" mx))) ; same as 8 because expansion hits the input counter
      (if (not (mus-arrays-equal? (channel->float-vector 0 30) 
		       #r(0.000 0.009 0.018 0.027 0.036 0.045 0.055 0.064 0.073 0.082 0.091 0.100 0.100 0.091 0.082 0.073 
				     0.064 0.055 0.045 0.036 0.027 0.018 0.009 0.000 0.000 0.000 0.000 0.000 0.000 0.000)))
	  (snd-display "gran 9 data: ~A" (channel->float-vector 0 30)))
      (if (not (mus-arrays-equal? (channel->float-vector 220 30) 
		       #r(0.000 0.009 0.018 0.027 0.036 0.045 0.055 0.064 0.073 0.082 0.091 0.100 0.100 0.091 0.082 0.073 
				     0.064 0.055 0.045 0.036 0.027 0.018 0.009 0.000 0.000 0.000 0.000 0.000 0.000 0.000)))
	  (snd-display "gran 9 data 220: ~A" (channel->float-vector 220 30)))
      (undo)
      
      (let ((gen (make-granulate :jitter 0.0 :hop .001 :length .005 :ramp .5 :scaler 1.0
				 :input (lambda (dir) .1)
				 :edit (lambda (g)
					 (float-vector-scale! (mus-data g) 2.0)
					 0))))
	(map-channel (lambda (y) (granulate gen))))
      (let ((mx (maxamp)))
	(if (fneq mx (* 2 0.264)) (snd-display "gran 10 max: ~A" mx)))
      (if (not (mus-arrays-equal? (float-vector-scale! (channel->float-vector 0 30) 0.5)
		       #r(0.000 0.002 0.004 0.005 0.007 0.009 0.011 0.013 0.015 0.016 0.018 0.020 0.022 0.024 0.025 0.027 
				     0.029 0.031 0.033 0.035 0.036 0.038 0.040 0.044 0.047 0.051 0.055 0.058 0.062 0.065)))
	  (snd-display "gran 10 data: ~A" (channel->float-vector 0 30)))
      (if (not (mus-arrays-equal? (float-vector-scale! (channel->float-vector 85 30) 0.5)
		       #r(0.244 0.244 0.244 0.244 0.245 0.247 0.249 0.251 0.253 0.255 0.256 0.258 0.260 0.262 0.264 0.264 
				     0.262 0.260 0.258 0.256 0.255 0.253 0.251 0.249 0.247 0.245 0.245 0.247 0.249 0.251)))
	  (snd-display "gran 10 data 85: ~A" (channel->float-vector 85 30)))
      (undo)
      
      (let ((forward #t)
	    (ctr -0.5)
	    (incr .001))
	(let ((f1 (lambda (dir) 
		    (set! ctr (+ ctr incr))))
	      (f2 (lambda (g)
		    (if forward ; no change to data
			(set! forward #f)
			(let ((grain (subvector (mus-data g) (list (mus-length g)))))
			  (set! forward #t)
			  (reverse! grain))) ; should get ramps going up then down across overall rising ramp
		    (mus-length g))))
	  (let ((gen (make-granulate :jitter 0.0 :hop .005 :length .002 :ramp 0.0 :scaler 1.0 :input f1 :edit f2)))
	    (map-channel (lambda (y) (granulate gen))))))
      (let ((mx (maxamp)))
	(if (> mx 0.6) (snd-display "gran 11 max: ~A" mx)))
      (if (not (mus-arrays-equal? (channel->float-vector 0 30)
		       #r(-0.499 -0.498 -0.497 -0.496 -0.495 -0.494 -0.493 -0.492 -0.491 -0.490 -0.489 -0.488 -0.487 -0.486 
				     -0.485 -0.484 -0.483 -0.482 -0.481 -0.480 -0.479 -0.478 -0.477 -0.476 -0.475 -0.474 -0.473 -0.472 -0.471 -0.470)))
	  (snd-display "gran 11 data: ~A" (channel->float-vector 0 30)))
      (if (not (mus-arrays-equal? (channel->float-vector 100 30)
		       #r(0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 -0.345 -0.346 -0.347 -0.348 -0.349 
				     -0.350 -0.351 -0.352 -0.353 -0.354 -0.355 -0.356 -0.357 -0.358 -0.359 -0.360 -0.361 -0.362 -0.363 -0.364)))
	  (snd-display "gran 11 data 100: ~A" (channel->float-vector 100 30)))
      (undo)
      
      (let ((ctr -0.5)
	    (incr .001))
	(let ((gen (make-granulate :jitter 0.0 :hop .005 :length .002 :ramp 0.0 :scaler 1.0
				   :input (lambda (dir) (set! ctr (+ ctr incr))))))
	  (map-channel (lambda (y) (granulate gen)))))
      (let ((mx (maxamp)))
	(if (> mx 0.6) (snd-display "gran 12 max: ~A" mx)))
      (if (not (mus-arrays-equal? (channel->float-vector 0 30)
		       #r(-0.499 -0.498 -0.497 -0.496 -0.495 -0.494 -0.493 -0.492 -0.491 -0.490 -0.489 -0.488 -0.487 -0.486 
				     -0.485 -0.484 -0.483 -0.482 -0.481 -0.480 -0.479 -0.478 -0.477 -0.476 -0.475 -0.474 -0.473 -0.472 -0.471 -0.470)))
	  (snd-display "gran 12 data: ~A" (channel->float-vector 0 30)))
      (if (not (mus-arrays-equal? (channel->float-vector 100 30)
		       #r(0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 -0.389 -0.388 -0.387 -0.386 -0.385 
				     -0.384 -0.383 -0.382 -0.381 -0.380 -0.379 -0.378 -0.377 -0.376 -0.375 -0.374 -0.373 -0.372 -0.371 -0.370)))
	  (snd-display "gran 12 data 100: ~A" (channel->float-vector 100 30)))
      (undo)
      
      (let ((gen (make-granulate :jitter 0.0 :hop .001 :length .005 :ramp .5 :scaler 1.0
				 :input (lambda (dir) .1)
				 :edit (lambda (g)
					 (float-vector-scale! (mus-data g) 2.0)
					 0))))
	(map-channel (lambda (y) (granulate gen))))
      (let ((mx (maxamp)))
	(if (> mx .6) (snd-display "gran 13 max: ~A" mx)))
      (if (not (mus-arrays-equal? (float-vector-scale! (channel->float-vector 0 30) 0.5)
		       #r(0.000 0.002 0.004 0.005 0.007 0.009 0.011 0.013 0.015 0.016 0.018 0.020 0.022 0.024 0.025 0.027 
				     0.029 0.031 0.033 0.035 0.036 0.038 0.040 0.044 0.047 0.051 0.055 0.058 0.062 0.065)))
	  (snd-display "gran 13 data: ~A" (channel->float-vector 0 30)))
      (if (not (mus-arrays-equal? (float-vector-scale! (channel->float-vector 85 30) 0.5)
		       #r(0.244 0.244 0.244 0.244 0.245 0.247 0.249 0.251 0.253 0.255 0.256 0.258 0.260 0.262 0.264 0.264 
				     0.262 0.260 0.258 0.256 0.255 0.253 0.251 0.249 0.247 0.245 0.245 0.247 0.249 0.251)))
	  (snd-display "gran 13 data 85: ~A" (channel->float-vector 85 30)))
      (undo)
      
      (let ((forward #t)
	    (ctr -0.5)
	    (incr .001))
	(let ((gen (make-granulate :jitter 0.0 :hop .005 :length .002 :ramp 0.0 :scaler 1.0
				   :input (lambda (dir) (set! ctr (+ ctr incr)))
				   :edit (lambda (g)
					   (if forward
					       (set! forward #f)
					       (let ((grain (subvector (mus-data g) (list (mus-length g)))))
						 (set! forward #t)
						 (reverse! grain)))
					   (mus-length g)))))
	  (map-channel (lambda (y) (granulate gen)))))
      (let ((mx (maxamp)))
	(if (> mx 0.6) (snd-display "gran 14 max: ~A" mx)))
      (if (not (mus-arrays-equal? (channel->float-vector 0 30)
		       #r(-0.499 -0.498 -0.497 -0.496 -0.495 -0.494 -0.493 -0.492 -0.491 -0.490 -0.489 -0.488 -0.487 -0.486 
				     -0.485 -0.484 -0.483 -0.482 -0.481 -0.480 -0.479 -0.478 -0.477 -0.476 -0.475 -0.474 -0.473 -0.472 -0.471 -0.470)))
	  (snd-display "gran 14 data: ~A" (channel->float-vector 0 30)))
      (if (not (mus-arrays-equal? (channel->float-vector 100 30)
		       #r(0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 -0.345 -0.346 -0.347 -0.348 -0.349 
				     -0.350 -0.351 -0.352 -0.353 -0.354 -0.355 -0.356 -0.357 -0.358 -0.359 -0.360 -0.361 -0.362 -0.363 -0.364)))
	  (snd-display "gran 14 data 100: ~A" (channel->float-vector 100 30)))
      (undo)
      
      (let ((gen (make-granulate :jitter 0.0 :hop .004 :length .001 :ramp 0.0 :input (lambda (dir) .1)))
	    (e (make-env '(0 0 1 .5) :length 1001)))
	(let ((base-ramp-len (mus-length gen)))
	  (map-channel 
	   (lambda (y) 
	     (let ((result (granulate gen)))
	       (set! (mus-ramp gen) (round (* base-ramp-len (env e))))
	       result))))
	(let ((mx (maxamp)))
	  (if (fneq mx 0.06) (snd-display "granf 0 max: ~A" mx)))
	(if (> (abs (- (mus-ramp gen) (* .5 (mus-length gen)))) 1)
	    (snd-display "granf 0 ramp: ~A ~A" (mus-ramp gen) (mus-length gen))))
      (if (not (mus-arrays-equal? (channel->float-vector 0 30) 
		       #r(0.060 0.060 0.060 0.060 0.060 0.060 0.060 0.060 0.060 0.060 0.060 0.060 0.060 0.060 
				     0.060 0.060 0.060 0.060 0.060 0.060 0.060 0.060 0.060 0.000 0.000 0.000 0.000 0.000 0.000 0.000)))
	  (snd-display "granf 0 data: ~A" (channel->float-vector 0 30)))
      (if (not (mus-arrays-equal? (channel->float-vector 440 30) 
		       #r(0.000 0.012 0.024 0.036 0.048 0.060 0.060 0.060 0.060 0.060 0.060 0.060 0.060 0.060 
				     0.060 0.060 0.060 0.060 0.060 0.048 0.036 0.024 0.012 0.000 0.000 0.000 0.000 0.000 0.000 0.000)))
	  (snd-display "granf 0 data 440: ~A" (channel->float-vector 440 30)))
      (if (not (mus-arrays-equal? (channel->float-vector 880 30) 
		       #r(0.000 0.006 0.012 0.018 0.024 0.030 0.036 0.042 0.048 0.054 0.060 0.060 0.060 0.060 
				     0.054 0.048 0.042 0.036 0.030 0.024 0.018 0.012 0.006 0.000 0.000 0.000 0.000 0.000 0.000 0.000)))
	  (snd-display "granf 0 data 880: ~A" (channel->float-vector 880 30)))
      (undo)
      
      (let ((gen (make-granulate :jitter 0.0 :hop .004 :length .001 :ramp 0.0 :input (lambda (dir) .1))))
	(let ((base-hop-len (mus-hop gen))
	      (e (make-env '(0 1 1 .25) :length 1001)))
	  (map-channel 
	   (lambda (y) 
	     (let ((result (granulate gen)))
	       (set! (mus-hop gen) (round (* base-hop-len (env e))))
	       result))))
	(let ((mx (maxamp)))
	  (if (fneq mx 0.06) (snd-display "granf 1 max: ~A" mx)))
	(if (> (abs (- (mus-hop gen) (* .001 *clm-srate*))) 1)
	    (snd-display "granf 1 hop: ~A ~A, ~A ~A" (mus-hop gen) (abs (- (mus-hop gen) (* .001 (srate)))) (srate) *clm-srate*)))
      (if (not (mus-arrays-equal? (channel->float-vector 0 30) 
		       #r(0.060 0.060 0.060 0.060 0.060 0.060 0.060 0.060 0.060 0.060 0.060 0.060 0.060 0.060 
				     0.060 0.060 0.060 0.060 0.060 0.060 0.060 0.060 0.060 0.000 0.000 0.000 0.000 0.000 0.000 0.000)))
	  (snd-display "granf 1 data: ~A" (channel->float-vector 0 30)))
      (if (not (mus-arrays-equal? (channel->float-vector 900 30) 
		       #r(0.060 0.060 0.060 0.060 0.060 0.060 0.060 0.060 0.060 0.060 0.060 0.060 0.000 0.000 
				     0.000 0.000 0.000 0.000 0.060 0.060 0.060 0.060 0.060 0.060 0.060 0.060 0.060 0.060 0.060 0.060)))
	  (snd-display "granf 1 data 900: ~A" (channel->float-vector 900 30)))
      (undo)
      
      (let ((gen (make-granulate :jitter 0.0 :hop .004 :length .001 :ramp 0.0 :input  (lambda (dir) .1))))
	(let ((base-freq (mus-frequency gen))
	      (e (make-env '(0 1 1 .25) :length 1001)))  
	  (map-channel 
	   (lambda (y) 
	     (let ((result (granulate gen)))
	       (set! (mus-frequency gen) (* base-freq (env e)))
	       result))))
	(let ((mx (maxamp)))
	  (if (fneq mx 0.06) (snd-display "granf 2 max: ~A" mx)))
	(if (> (abs (- (mus-hop gen) (* .001 *clm-srate*))) 1)
	    (snd-display "granf 2 hop: ~A" (mus-hop gen))))
      (if (not (mus-arrays-equal? (channel->float-vector 0 30) 
		       #r(0.060 0.060 0.060 0.060 0.060 0.060 0.060 0.060 0.060 0.060 0.060 0.060 0.060 0.060 
				     0.060 0.060 0.060 0.060 0.060 0.060 0.060 0.060 0.060 0.000 0.000 0.000 0.000 0.000 0.000 0.000)))
	  (snd-display "granf 2 data: ~A" (channel->float-vector 0 30)))
      (if (not (mus-arrays-equal? (channel->float-vector 900 30) 
		       #r(0.060 0.060 0.060 0.060 0.060 0.000 0.000 0.000 0.000 0.000 0.000 0.060 0.060 0.060 
				     0.060 0.060 0.060 0.060 0.060 0.060 0.060 0.060 0.060 0.060 0.060 0.060 0.060 0.060 0.060 0.060)))
	  (snd-display "granf 2 data 900: ~A" (channel->float-vector 900 30)))
      (undo)
      
      (let ((gen (make-granulate :jitter 0.0 :hop .002 :length .001 :ramp 0.0 :scaler 1.0 :input (lambda (dir) .1))))
	(map-channel (lambda (y) (granulate gen))))
      (let ((mx (maxamp)))
	(if (fneq mx 0.1) (snd-display "granf 3 max: ~A" mx)))
      (if (not (mus-arrays-equal? (channel->float-vector 0 30) 
		       #r(0.100 0.100 0.100 0.100 0.100 0.100 0.100 0.100 0.100 0.100 0.100 0.100 0.100 0.100 
				     0.100 0.100 0.100 0.100 0.100 0.100 0.100 0.100 0.100 0.000 0.000 0.000 0.000 0.000 0.000 0.000)))
	  (snd-display "gran 3 data: ~A" (channel->float-vector 0 30)))
      (undo)
      
      (let ((gen (make-granulate :jitter 0.0 :hop .004 :length .001 :ramp 0.0 :scaler 1.0 :input (lambda (dir) .1)))
	    (e (make-env '(0 1 1 0.0) :length 1001)))
	(map-channel 
	 (lambda (y) 
	   (let ((result (granulate gen)))
	     (set! (mus-scaler gen) (env e))
	     result))))
      (let ((mx (maxamp)))
	(if (fneq mx 0.1) (snd-display "granf 4 max: ~A" mx)))
      (if (not (mus-arrays-equal? (channel->float-vector 0 30) 
		       #r(0.100 0.100 0.100 0.100 0.100 0.100 0.100 0.100 0.100 0.100 0.100 0.100 0.100 0.100 
				     0.100 0.100 0.100 0.100 0.100 0.100 0.100 0.100 0.100 0.000 0.000 0.000 0.000 0.000 0.000 0.000)))
	  (snd-display "granf 4 data: ~A" (channel->float-vector 0 30)))
      (if (not (mus-arrays-equal? (channel->float-vector 440 30) 
		       #r(0.056 0.056 0.056 0.056 0.056 0.056 0.056 0.056 0.056 0.056 0.056 0.056 0.056 0.056 
				     0.056 0.056 0.056 0.056 0.056 0.056 0.056 0.056 0.056 0.000 0.000 0.000 0.000 0.000 0.000 0.000)))
	  (snd-display "granf 4 data 440: ~A" (channel->float-vector 440 30)))
      (if (not (mus-arrays-equal? (channel->float-vector 900 30) 
		       #r(0.012 0.012 0.012 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 
				     0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000)))
	  (snd-display "granf 4 data 900: ~A" (channel->float-vector 900 30)))
      (undo)
      
      (let ((gen (make-granulate :jitter 0.0 :hop .006 :length .001 :ramp 0.0 :max-size 2200 :input  (lambda (dir) .1)))
	    (e (make-env '(0 1 1 5) :length 1001)))
	(let ((base-len (mus-length gen)))
	  (map-channel 
	   (lambda (y) 
	     (let ((result (granulate gen)))
	       (set! (mus-length gen) (round (* base-len (env e))))
	       result)))
	  (let ((mx (maxamp)))
	    (if (fneq mx 0.06) (snd-display "granf 5 max: ~A" mx)))
	  (if (> (abs (- (mus-length gen) (* 5 base-len))) 10)
	      (snd-display "granf 5 length: ~A ~A" (mus-length gen) (* 5 base-len)))))
      (if (not (mus-arrays-equal? (channel->float-vector 0 30) 
		       #r(0.060 0.060 0.060 0.060 0.060 0.060 0.060 0.060 0.060 0.060 0.060 0.060 0.060 0.060 
				     0.060 0.060 0.060 0.060 0.060 0.060 0.060 0.060 0.060 0.000 0.000 0.000 0.000 0.000 0.000 0.000)))
	  (snd-display "granf 5 data: ~A" (channel->float-vector 0 30)))
      (if (not (mus-arrays-equal? (channel->float-vector 440 30) 
		       #r(0.060 0.060 0.060 0.060 0.060 0.060 0.060 0.060 0.060 0.060 0.060 0.060 0.060 0.060 
				     0.060 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000)))
	  (snd-display "granf 5 data 440: ~A" (channel->float-vector 440 30)))
      (if (not (mus-arrays-equal? (channel->float-vector 800 30) (make-float-vector 30 0.060)))
	  (snd-display "granf 5 data 800: ~A" (channel->float-vector 800 30)))
      (undo)
      
      (let ((gen (make-granulate :jitter 0.0 :hop .006 :length .005 :ramp 0.0 :max-size 2200 :input (lambda (dir) .1)))
	    (e (make-env '(0 1 1 .2) :length 1001)))
	(let ((base-len (mus-length gen)))
	  (map-channel 
	   (lambda (y) 
	     (let ((result (granulate gen)))
	       (set! (mus-length gen) (round (* base-len (env e))))
	       result)))
	  (let ((mx (maxamp)))
	    (if (fneq mx 0.06) (snd-display "granf 6 max: ~A" mx)))
	  (if (> (abs (- (mus-length gen) (* .2 base-len))) 4)
	      (snd-display "granf 6 length: ~A ~A" (mus-length gen) (* .2 base-len)))))
      (if (not (mus-arrays-equal? (channel->float-vector 0 30) (make-float-vector 30 0.060)))
	  (snd-display "granf 6 data: ~A" (channel->float-vector 0 30)))
      (if (not (mus-arrays-equal? (channel->float-vector 820 30) 
		       #r(0.060 0.060 0.060 0.060 0.060 0.060 0.060 0.060 0.060 0.060 0.060 0.060 0.060 0.000 0.000 
				     0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000)))
	  (snd-display "granf 6 data 820: ~A" (channel->float-vector 820 30)))
      (undo)
      
      (let ((max-list (lambda ()
			(let ((pts ()) 
			      (samp 0)
			      (lasty 0.0))
			  (scan-channel (lambda (y) 
					  (if (and (< lasty 0.1)
						   (>= y .1))
					      (set! pts (cons samp pts)))
					  (set! lasty y)
					  (set! samp (+ samp 1))
					  #f)) 
			  (reverse pts)))))
	(let ((gen (make-granulate :jitter 0.0 :hop .01 :length .001 :ramp .5 :scaler 1.0 :expansion 0.5 :input (lambda (dir) .1))))
	  (map-channel (lambda (y) (granulate gen)))
	  (let ((vals (max-list)))
	    (if (not (equal? vals '(11 231 451 671 891)))
		(snd-display "grn jitter 0 max: ~A" vals)))
	  (undo))
	
	(let ((oldvals #f))
	  (let ((gen (make-granulate :jitter 0.3 :hop .01 :length .001 :ramp .5 :scaler 1.0 :expansion 0.5 :input (lambda (dir) .1))))
	    (map-channel (lambda (y) (granulate gen)))
	    ;; (11 232 490 736 982) or whatever
	    (let ((vals (max-list)))
	      (if (equal? vals '(11 231 451 671 891))
		  (snd-display "grn jitter 0.3 max: ~A" vals))
	      (set! oldvals vals))
	    (undo))
	  
	  (let ((gen (make-granulate :jitter 0.3 :hop .01 :length .001 :ramp .5 :scaler 1.0 :expansion 0.5 :input (lambda (dir) .1))))
	    (map-channel (lambda (y) (granulate gen)))
	    (let ((vals (max-list)))
	      (if (equal? vals oldvals)
		  (snd-display "grn jitter 0.3 max: ~A ~A" vals oldvals)))
	    (undo)))
	
	(let ((oldvals #f)
	      (seed 0))
	  (let ((gen (make-granulate :jitter 1.0 :hop .01 :length .001 :ramp .5 :scaler 1.0 :expansion 0.5 :input (lambda (dir) .1))))
	    (set! seed (mus-location gen))
	    (map-channel (lambda (y) (granulate gen))))
	  (set! oldvals (max-list))
	  (undo)
	  
	  (let ((gen (make-granulate :jitter 1.0 :hop .01 :length .001 :ramp .5 :scaler 1.0 :expansion 0.5 :input (lambda (dir) .1))))
	    (set! (mus-location gen) seed)
	    (map-channel (lambda (y) (granulate gen))))
	  (let ((vals (max-list)))
	    (if (not (equal? vals oldvals))
		(snd-display "grn jitter 1.0 max with seed: ~A ~A" vals oldvals)))
	  (undo)))
      
      (let ((fname (file-name ind)))
	(close-sound ind)
	(delete-file fname)
	(when (and with-motif
		   (view-files-dialog #f))
	  (set! (view-files-files (view-files-dialog #f)) ())
	  (if (pair? (view-files-files (view-files-dialog #f)))
	      (snd-display "set vf files list null: ~A" (view-files-files (view-files-dialog #f)))))))
    
    ;; granulate with jitter=0, small hop (comb filter effect)
    (let* ((ind (new-sound "tmp.snd" 1 22050 mus-ldouble mus-next :size 10000))
	   (gen (make-granulate :expansion 20.0
				:input (lambda (dir) .01)
				:length .00995
				:hop .01
				:ramp 0.0
				:scaler 1.0
				:jitter 0.0)))
      (clm-channel gen) ; -> .01 max (stable)
      (if (fneq (maxamp) .01) (snd-display "granulate stable 1: ~A" (maxamp)))
      (let ((minval (scan-channel (lambda (y) (< y .0099)))))
	(if minval (snd-display "granulate stable 1 min: ~A" minval)))
      (undo)
      (set! gen (make-granulate :expansion 20.0
				:input (lambda (dir) .1)
				:length .00995
				:hop .01
				:ramp 0.0
				:scaler 0.5
				:jitter 0.0))
      (clm-channel gen) ; -> .05 max (stable)
      (if (fneq (maxamp) .05) (snd-display "granulate stable 2: ~A" (maxamp)))
      (let ((minval (scan-channel (lambda (y) (< y .0499)))))
	(if minval (snd-display "granulate stable 2 min: ~A" minval)))
      (undo)
      
      (set! gen (make-granulate :expansion 10.0
				:input (lambda (dir) .05)
				:length .099975
				:hop .1
				:ramp 0.0
				:scaler 1.0
				:jitter 0.0))
      (clm-channel gen) ; -> .05 max (stable)
      (if (fneq (maxamp) .05) (snd-display "granulate stable 3: ~A" (maxamp)))
      (let ((minval (scan-channel (lambda (y) (< y .0499)))))
	(if minval (snd-display "granulate stable 3 min: ~A ~A" minval (sample (cadr minval)))))
      (undo)
      
      (let ((ctr -0.0001))
	(set! gen (make-granulate :expansion 2.0
				  :input (lambda (dir) (set! ctr (+ ctr .0001)))
				  :length .01
				  :hop .1
				  :ramp 0.0
				  :scaler 1.0
				  :jitter 0.0))
	(clm-channel gen))
      (if (fneq (maxamp) .462) (snd-display "granulate ramped 4: ~A" (maxamp)))
      (let ((vals (count-matches (lambda (y) (> (abs y) 0.0)))))
	(if (> (abs (- vals 1104)) 10) (snd-display "granulate ramped 4 not 0.0: ~A" vals)))
      (if (not (and (mus-arrays-equal? (channel->float-vector 2203 10)
			    #r(0.000 0.000 0.110 0.110 0.110 0.111 0.111 0.111 0.111 0.111))
		    (mus-arrays-equal? (channel->float-vector 4523 10)
			    #r(0.232 0.232 0.232 0.232 0.232 0.232 0.232 0.232 0.233 0.233))
		    (mus-arrays-equal? (channel->float-vector 8928 10) (make-float-vector 10 0.452))))
	  (snd-display "granulate ramped 4 data off: ~A ~A ~A" 
		       (channel->float-vector 2203 10) (channel->float-vector 4523 10) (channel->float-vector 8928 10)))
      (undo)
      
      (let ((e (make-env '(0 0 1 1) :length 10000)))
	(set! gen (make-granulate :expansion 2.0
				  :input (lambda (dir) (env e))
				  :length .00995
				  :hop .01
				  :ramp 0.0
				  :scaler 1.0
				  :jitter 0.0))
	(clm-channel gen))
      (if (fneq (maxamp) .505) (snd-display "granulate ramped 5: ~A" (maxamp)))
      (let ((mxoff 0.0)
	    (cur 0.0)
	    (incr (/ (maxamp) (framples)))
	    (diff 0.0))
	(scan-channel (lambda (y) 
			(set! diff (abs (- cur y)))
			(set! mxoff (max mxoff diff))
			(set! cur (+ cur incr))
			#f))
	(if (> mxoff .02) (snd-display "granulate ramped 5 mxoff: ~A" mxoff))) ; .0108 actually
      (undo)
      
      (let ((e (make-env '(0 0 1 1) :length 10000)))
	(set! gen (make-granulate :expansion 2.0
				  :input (lambda (dir) (env e))
				  :length .00995
				  :hop .01
				  :ramp 0.5
				  :scaler 1.0
				  :jitter 0.0))
	(clm-channel gen))
      (if (fneq (maxamp) .495) (snd-display "granulate ramped 6: ~A" (maxamp)))
      (if (not (and (mus-arrays-equal? (channel->float-vector 2000 10)
			    #r(0.018 0.019 0.020 0.021 0.022 0.023 0.024 0.025 0.026 0.027))
		    (mus-arrays-equal? (channel->float-vector 8000 10)
			    #r(0.294 0.298 0.301 0.305 0.309 0.313 0.316 0.320 0.324 0.328))))
	  (snd-display "granulate ramped 6 data: ~A ~A"
		       (channel->float-vector 2000 10) (channel->float-vector 8000 10)))
      (undo)
      
      (let ((e (make-env '(0 0 1 1) :length 10000)))
	(set! gen (make-granulate :expansion 2.0
				  :input (lambda (dir) (env e))
				  :length .00995
				  :hop .01
				  :ramp 0.25
				  :scaler 1.0
				  :jitter 0.0))
	(clm-channel gen))
      (if (fneq (maxamp) .505) (snd-display "granulate ramped 7: ~A" (maxamp)))
      (if (not (and (mus-arrays-equal? (channel->float-vector 2000 10)
			    #r(0.037 0.039 0.040 0.042 0.044 0.046 0.048 0.050 0.052 0.054))
		    (mus-arrays-equal? (channel->float-vector 8000 10)
			    #r(0.404 0.404 0.404 0.404 0.404 0.405 0.405 0.405 0.405 0.405))))
	  (snd-display "granulate ramped 7 data: ~A ~A"
		       (channel->float-vector 2000 10) (channel->float-vector 8000 10)))
      (undo)
      
      (let ((e (make-env '(0 0 1 1) :length 10000)))
	(set! gen (make-granulate :expansion 2.0
				  :input (lambda (dir) (env e))
				  :length .05
				  :hop .01
				  :ramp 0.25
				  :scaler 0.1
				  :jitter 0.0))
	(clm-channel gen))
      (if (fneq (maxamp) .201) (snd-display "granulate ramped 7: ~A" (maxamp)))
      (let ((mxoff 0.0)
	    (cur 0.0)
	    (incr (/ (maxamp) (framples)))
	    (diff 0.0))
	(scan-channel (lambda (y) 
			(set! diff (abs (- cur y)))
			(set! mxoff (max mxoff diff))
			(set! cur (+ cur incr))
			#f))
	(if (> mxoff .01) (snd-display "granulate ramped 7 mxoff: ~A" mxoff))) ; .0097 actually
      (undo)
      
      (let ((e (make-env '(0 0 1 1) :length 10000)))
	(set! gen (make-granulate :expansion 2.0
				  :input (lambda (dir) (env e))
				  :length .1
				  :hop .01
				  :ramp 0.1
				  :scaler 0.1
				  :jitter 0.0))
	(clm-channel gen))
      (if (fneq (maxamp) .501) (snd-display "granulate ramped 8: ~A" (maxamp)))
      (let ((cur (sample 2000)))
	(let ((mxoff 0.0)
	      (incr (/ (- (maxamp) cur) (- (framples) 2000)))
	      (diff 0.0))
	  (scan-channel (lambda (y) 
			  (set! diff (abs (- cur y)))
			  (set! mxoff (max mxoff diff))
			  (set! cur (+ cur incr))
			  #f)
			2000)
	  (if (> mxoff .001) (snd-display "granulate ramped 8 mxoff: ~A" mxoff))))
      (undo)
      
      (let ((e (make-env '(0 0 1 1) :length 10000)))
	(set! gen (make-granulate :expansion 2.0
				  :input (lambda (dir) (env e))
				  :length .4
				  :hop .01
				  :ramp 0.4
				  :scaler 0.025
				  :jitter 0.0))
	(clm-channel gen))
      (if (fneq (maxamp) .433) (snd-display "granulate ramped 9: ~A" (maxamp)))
      (undo)
      (close-sound ind))
    
    (let ((v0 (make-float-vector 32))
	  (v1 (make-float-vector 256))
	  (v2 (make-float-vector 256))
	  (v01 (make-float-vector 32))
	  (v11 (make-float-vector 256))
	  (v21 (make-float-vector 256)))
      (do ((i 1 (+ i 1)))
	  ((= i 16))
	(set! (v0 i) (/ 1.0 i))
	(set! (v01 i) (/ 1.0 i)))
      (set! (v1 0) 1.0)
      (set! (v11 0) 1.0)
      (let ((n -1)
	    (n1 -1))
	(let ((gen (make-convolve :filter v0 :input (lambda (dir) (set! n (+ n 1)) (v1 n))))
	      (gen1 (make-convolve :filter v01 :input (lambda (dir) (set! n1 (+ n1 1)) (v11 n1)))))
	  (print-and-check gen 
			   "convolve"
			   "convolve size: 64")
	  (if (not (convolve? gen)) (snd-display "~A not convolve?" gen))
	  (if (equal? gen gen1) (snd-display "convolve equal? ~A ~A" gen gen1))
	  (if (not (= (mus-length gen) 64)) (snd-display "convolve fft len: ~D?" (mus-length gen)))
	  (do ((i 0 (+ i 1)))
	      ((= i 128))
	    (set! (v2 i) (convolve gen)))
	  (fill-float-vector v21 (if (convolve? gen1) (convolve gen1) -1.0))
	  (if (not (mus-arrays-equal? v2 v21)) (snd-display "run gran: ~A ~A" v2 v21))
	  (if (or (fneq (v2 0) 0.0)
		  (fneq (v2 1) 1.0)
		  (fneq (v2 4) 0.25)
		  (fneq (v2 7) 0.143))
	      (snd-display "convolve output: ~A?" v2)))
      
	(convolve-files "oboe.snd" "fyow.snd" .5 "fmv.snd")
	(if (fneq (cadr (mus-sound-maxamp "fmv.snd")) .5) 
	    (snd-display "convolve-files: ~A is not .5?" (cadr (mus-sound-maxamp "fmv.snd"))))
	))

    (let ((flt #r(1.0 0.5 0.1 0.2 0.3 0.4 0.5 1.0))
	  (data #r(0.0 1.0 0.0 0.0 1.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0))
	  (ctr -1))
      (let ((res (make-float-vector 16))
	    (g (make-convolve :filter flt
			      :input (lambda (dir)
				       (set! ctr (+ ctr 1))
				       (data ctr)))))
	(do ((i 0 (+ i 1)))
	    ((= i 16))
	  (set! (res i) (convolve g)))
	(if (not (mus-arrays-equal? res #r(0.0 1.0 0.5 0.1 1.2 0.8 0.5 0.7 1.3 0.4 0.5 1.0 0.0 0.0 0.0 0.0)))
	    (snd-display "convolve: ~A~%" res))))
    
    (let ((ind (new-sound "fmv.snd")))
      (set! (sample 1) .1)
      (save-sound ind)
      (if (not (equal? (edits ind 0) '(0 0)))
	  (snd-display "weird: edits not cleared after save-sound?: ~A" (edits ind 0)))
      (close-sound ind)
      (set! ind (open-sound "fmv.snd"))
      (if (not (= (framples ind 0) 2))
	  (snd-display "save-sound 2 samps: ~A?" (framples ind 0)))
      (if (or (fneq (sample 0) 0.0)
	      (fneq (sample 1) 0.1))
	  (snd-display "save-sound: ~A ~A?" (sample 0) (sample 1)))
      (do ((i 3 (+ i 1)))
	  ((= i 6))
	(set! (sample i) (* i .1))
	(save-sound ind)
	(if (not (equal? (edits ind 0) '(0 0)))
	    (snd-display "weird: edits not cleared after save-sound ~A?: ~A" i (edits ind 0)))
	(close-sound ind)
	(set! ind (open-sound "fmv.snd"))
	(if (not (= (framples ind 0) (+ i 1)))
	    (snd-display "save-sound ~A samps: ~A?" (+ i 1) (framples ind 0)))
	(if (or (fneq (sample 0) 0.0)
		(fneq (sample 1) 0.1)
		(fneq (sample i) (* i 0.1)))
	    (snd-display "save-sound ~A: ~A ~A ~A?" i (sample 0) (sample 1) (sample i))))
      (close-sound ind))
    
    (let ((ind (new-sound "test.snd" :srate 22050 :channels 1 :size 1000)))
      (let ((gen (make-ssb-am 100.0)))
	(map-channel (lambda (y) (ssb-am gen)))
	(if (fneq (maxamp) 0.0) (snd-display "ssb-am 0.0: ~A" (maxamp)))
	(let ((gen1 (make-oscil 220.0)))
	  (map-channel (lambda (y) (* 0.5 (oscil gen1)))))
	(set! gen (make-ssb-am 100.0 100))
	(map-channel (lambda (y) (ssb-am gen y)))
	(delete-samples 0 200)
	(let ((gen1 (make-oscil 320.0 :initial-phase (asin (* 2 (sample 0)))))) ; depends on rising side
	  (map-channel (lambda (y) (- y (* 0.5 (oscil gen1))))))
	(if (> (maxamp) .004) (snd-display "ssb-am cancelled: ~A" (maxamp)))
	(undo 3))
      (let ((gen (make-ssb-am 100.0 100))
	    (hx (hz->radians 50.0)))
	(map-channel (lambda (y) (ssb-am gen y hx))))
      (delete-samples 0 180)
      (let ((gen1 (make-oscil 370.0 :initial-phase (asin (* 2 (sample 0)))))) ; depends on rising side
	(map-channel (lambda (y) (- y (* 0.5 (oscil gen1))))))
      (if (> (maxamp) .004) (snd-display "ssb-am fm cancelled: ~A" (maxamp)))
      (close-sound ind))
    
    (let ((ind (new-sound "test.snd" :srate 22050 :channels 1 :size 1000)))
      (let* ((scl (/ (* 2 pi) 50))
	     (x (- scl)))
	(map-channel (lambda (y) (sin (set! x (+ x scl))))))
      ;; 441 Hz 
      (ssb-bank 441 882 1 100)
      (delete-samples 0 217)
      (let ((gen1 (make-oscil 882.0 :initial-phase (asin (sample 0)))))
	(map-channel (lambda (y) (- y (oscil gen1))))
	(if (> (maxamp) .04) (snd-display "ssb-bank cancelled: ~A" (maxamp))))
      (close-sound ind))
    
    (when *output* 
      (snd-display "*output* ~A" *output*)
      (set! *output* #f))
    
    (let ((nind (new-sound "fmv.snd" 1 22050 mus-bshort mus-aifc "this is a comment")))
      (time (mix-float-vector (with-temp-sound (:output (make-float-vector 22050)) (fm-violin 0 1 440 .1)) 0 nind 0))
      (play nind :wait #t)
      (save-sound nind)
      (if (not (sound? nind)) (snd-display "save sound clobbered ~A?" nind))
      (let ((oboe-index (or (find-sound "oboe.snd") (open-sound "oboe.snd"))))
	(if (equal? oboe-index nind) (snd-display "find-sound found bogus case: ~A" oboe-index))
	(cnvtest oboe-index nind .1) 
	(select-sound nind)
	(select-channel 0)
	(if (not (equal? (selected-sound) nind)) (snd-display "selected-sound: ~A?" (selected-sound)))
	(if (not (= (selected-channel) 0)) (snd-display "selected-channel: ~A?" (selected-channel)))

	(let ((decay-dur 1.0000))
	  (let ((amp-env #f)
		(low-pass #f)
		(volume 0.1000)
		(allpass1 (make-all-pass -0.700 0.700 1051))
		(allpass2 (make-all-pass -0.700 0.700  337))
		(allpass3 (make-all-pass -0.700 0.700  113))
		(comb1 (make-comb 0.742 4799))
		(comb2 (make-comb 0.733 4999))
		(comb3 (make-comb 0.715 5399))
		(comb4 (make-comb 0.697 5801))
		(dur (+ decay-dur (/ (framples) (srate))))
		(outdel (make-delay (seconds->samples .013))))
	    (let ((combs (make-comb-bank (vector comb1 comb2 comb3 comb4)))
		  (allpasses (make-all-pass-bank (vector allpass1 allpass2 allpass3))))
	      (if (or amp-env low-pass)
		  (let ((delf (let ((flt (and low-pass (make-fir-filter 3 #r(0.25 0.5 0.25))))
				    (envA (make-env :envelope (or amp-env '(0 1 1 1)) :scaler volume :duration dur)))
				(if low-pass
				    (lambda (inval)
				      (+ inval (delay outdel (* (env envA) (fir-filter flt (comb-bank combs (all-pass-bank allpasses inval)))))))
				    (lambda (inval)
				      (+ inval (delay outdel (* (env envA) (comb-bank combs (all-pass-bank allpasses inval))))))))))
		    (map-channel delf 0 (round (* dur (srate)))))
		  (map-channel
		   (lambda (inval)
		     (+ inval (delay outdel (* volume (comb-bank combs (all-pass-bank allpasses inval))))))
		   0 (round (* dur (srate))))))))

	(play nind :wait #t)
	(voiced->unvoiced 1.0 256 2.0 2.0) 
	(pulse-voice 80 20.0 1.0 1024 0.01)
	(map-channel (fltit))
	(close-sound oboe-index))
      (if (not (sound? nind)) (snd-display "close sound clobbered ~A?" nind))
      (do ((fr (framples nind 0))
	   (k 0 (+ k 1)))
	  ((= k 10)
	   (if (not (= (framples nind 0) (- fr 1000)))
	       (snd-display "delete-samples: ~A ~A" fr (framples nind 0))))
	(delete-samples 10 100 nind 0)
	(save-sound nind)) ;flush out memory leaks here
      (revert-sound nind)
      (close-sound nind))
    (if (file-exists? "fmv.snd") (delete-file "fmv.snd"))
    
    (let ((nind (new-sound "fmv.snd")))
      (if (not (= (header-type nind) *default-output-header-type*))
	  (snd-display "new-sound default header-type: ~A ~A?"
		       (mus-header-type-name (header-type nind))
		       (mus-header-type-name *default-output-header-type*)))
      (if (not (= (sample-type nind) *default-output-sample-type*))
	  (snd-display "new-sound default sample-type: ~A ~A?"
		       (mus-sample-type-name (sample-type nind))
		       (mus-sample-type-name *default-output-sample-type*)))
      (if (not (= (chans nind) *default-output-chans*))
	  (snd-display "new-sound default chans: ~A ~A?" (chans nind) *default-output-chans*))
      (if (not (= (srate nind) *default-output-srate*))
	  (snd-display "new-sound default srate: ~A ~A?" (srate nind) *default-output-srate*))
      (close-sound nind)
      (if (file-exists? "fmv.snd") (delete-file "fmv.snd")))
    (let ((nind (new-sound "fmv.snd" 1 22050 mus-bshort mus-nist "this is a comment")))
      (set! (sample 0 nind) 1.0) 
      (start-progress-report nind)
      (convolve-with "oboe.snd") 
      (progress-report .1 nind)
      (if (fneq (sample 1000) 0.223) (snd-display "convolve-with: ~A?" (sample 1000)))
      (progress-report .3 nind)
      (revert-sound nind)
      (progress-report .5 nind)
      (set! (sample 200) .0001) 
      (set! (sample 100) 1.0) 
      (progress-report .8 nind)
      (smooth-sound 0 100) 
      (finish-progress-report nind)
      (if (or (fneq (sample 50) .5) (fneq (sample 30) 0.20608) (fneq (sample 90) 0.9755))
	  (snd-display "smooth: ~A ~A ~A?" (sample 50) (sample 30) (sample 90)))
      (undo) 
      (let-temporarily ((*sinc-width* 40))
	(set! (sample 100) 0.5) 
	(if (fneq (sample 100) 0.5) (snd-display "set-sample 100: ~A?" (sample 100)))
	(src-sound .1) )
      (if (or (fneq (sample 1000) 0.5) (fneq (sample 1024) 0.0625) (fneq (sample 1010) 0.0))
	  (snd-display "src-sound: ~A ~A ~A?" (sample 1000) (sample 1024) (sample 1010)))
      (revert-sound)
      (close-sound nind))
    (let ((nind (new-sound "fmv.snd" 1 22050 mus-lshort mus-riff "this is a comment" 22050)))
      (if (not (= (framples nind) 22050)) (snd-display " new-sound initial-length: ~A" (framples nind)))
      (mix "pistol.snd") 
      (map-channel (expsrc 2.0 nind)) 
      (undo) 
      (let ((eds (edits)))
	(if (not (= (car eds) 1 (cadr eds)))
	    (snd-display "undo edits: ~A?" eds))
	(if (not (= (edit-position) (car eds)))
	    (snd-display "undo edit-position: ~A ~A?" (edit-position) eds)))
      (expsnd '(0 1 2 .4)) 
      (map-channel (comb-chord .95 100 .3)) 
      (map-channel (formants .99 900 .02 1800 .01 2700)) 
      (map-channel (moving-formant .99 '(0 1200 1 2400))) 
      (scale-to .3) 
      (let ((eds (edits)))
	(if (not (and (= (car eds) 6) (= (cadr eds) 0)))
	    (snd-display "edits(6): ~A?" eds))
	(if (not (= (edit-position) (car eds)))
	    (snd-display "edit-position(6): ~A ~A?" (edit-position) eds)))
      (set! (edit-position) 1)
      (if (not (= (edit-position) 1))
	  (snd-display "set edit-position(1) ~A?" (edit-position)))
      (set! (edit-position) 4)
      (if (not (= (edit-position) 4))
	  (snd-display "set edit-position(4): ~A?" (edit-position)))
      (revert-sound nind)
      (mix "pistol.snd") 
      (map-channel (zecho .5 .75 6 10.0) 0 65000) 
      (map-channel (am 440)) 
      (add-mark 1200)
      (add-mark 2300)
      (key (char->integer #\x) 4)
      (key (char->integer #\c) 0) ; trigger mark-define-region
      (reverse-sound nind) 
      (revert-sound nind)
      (let ((mid (mix-sound "pistol.snd" 0)))
	(if (and (mix? mid)
		 (not (equal? (mix-home mid) (list (selected-sound) 0 #f 0))))
	    (snd-display "mix-sound mix-home: ~A" (mix-home mid))))
      (hello-dentist 40.0 .1) 
      (fp 1.0 .3 20) 
      (revert-sound nind)
      (enveloped-mix "oboe.snd" 0 '(0 0 1 1 2 0)) 
      (if all-args (pvoc :pitch 0.5 :time 1.0 :snd nind))
      (revert-sound nind)
      (close-sound nind))
    
    (if (and all-args (defined? 'edot-product))
	(let ((ind (new-sound :size 100)))
	  (set! (sample 10) 0.5)
	  (set! (sample 30) -0.8)
	  (stretch-sound-via-dft 2.0 ind 0)
	  (let ((new-len (framples ind 0))
		(len 100))
	    (if (> (abs (- (* 2 len) new-len)) 10)
		(snd-display "stretch-sound-via-dft: ~A ~A" len new-len)))
	  (close-sound ind)))
    
    (let ((make-mix-output (lambda (name i)
			     (if (member i '(0 1) =)
				 name
				 (continue-sample->file name))))
	  (make-mix-input (lambda (name i)
			    (if (member i '(0 2) =)
				name
				(make-file->frample name)))))
      (define (mus-file-mix-1 k . args)
	(let ((outf (make-mix-output "fmv.snd" k)))
	  (apply mus-file-mix outf args)	
	  (if (not (string? outf))
	      (mus-close outf))))

      (do ((k 0 (+ k 1)))
	  ((= k 4))
	(if (file-exists? "fmv.snd") (delete-file "fmv.snd"))
	(if (file-exists? "fmv1.snd") (delete-file "fmv1.snd"))
	(if (file-exists? "fmv2.snd") (delete-file "fmv2.snd"))
	(if (file-exists? "fmv3.snd") (delete-file "fmv3.snd"))
	(let ((v0 (make-float-vector 12 0.1)))
	  (array->file "fmv1.snd" v0 12 22050 1)
	  (fill! v0 0.2)
	  (array->file "fmv2.snd" v0 12 22050 2)
	  (fill! v0 0.3)
	  (array->file "fmv3.snd" v0 12 22050 4)

	  (do ((i 0 (+ i 1))) ((= i 12)) (set! (v0 i) (* i .01)))
	  (array->file "fmv.snd" v0 12 22050 1)
	  (mus-file-mix-1 k (make-mix-input "fmv1.snd" k))
	  (file->array "fmv.snd" 0 0 12 v0)

	  ;; v0: #(0.1 0.11 0.12 0.13 0.14 0.15 0.16 0.17 0.18 0.19 0.2 0.21)
	  (do ((happy #t)
	       (i 0 (+ i 1))) 
	      ((or (not happy) (= i 12)))
	    (when(fneq (v0 i) (+ 0.1 (* i .01))) 
	      (snd-display "~D mus-file-mix(1->1): ~A?" k v0)
	      (set! happy #f)))

	  (mus-file-mix-1 k (make-mix-input "fmv2.snd" k) 3 9 0 #r(0.3 0.0 0.7 0.0))
	  (file->array "fmv.snd" 0 0 12 v0)

	  ;; v0: #(0.1 0.11 0.12 0.33 0.34 0.35 0.36 0.37 0.38 0.19 0.2 0.21)
	  (if (or (fneq (v0 0) .1) (fneq (v0 3) .33) (fneq (v0 9) .19)) (snd-display "~D mus-file-mix(2->1): ~A?" k v0))
	  (mus-file-mix-1 k (make-mix-input "fmv3.snd" k))
	  (file->array "fmv.snd" 0 0 12 v0)

	  ;; ?? v0: #(0.4 0.41 0.42 0.33 0.34 0.35 0.36 0.37 0.38 0.19 0.2 0.21)
	  (if (or (fneq (v0 0) .4) (fneq (v0 3) .33)) (snd-display "~D mus-file-mix(4->1): ~A?" k v0))
	  (let ((vf (make-vector 1)))
	    (let ((e0 (make-env '(0 0 1 1) :length 11))
		  (vf1 (make-vector 1)))
	      (set! (vf 0) vf1)
	      (set! (vf1 0) e0))
	    (mus-file-mix-1 k (make-mix-input "fmv1.snd" k) 0 12 0 #r(1.0) vf)
	    (file->array "fmv.snd" 0 0 12 v0)

	    ;; ?? v0: #(0.4 0.42 0.44000000 0.36 0.38 0.4 0.42 0.44 0.46 0.28 0.3 0.31)
	    (if (or (fneq (v0 0) .4) (fneq (v0 3) .360) (fneq (v0 9) .28)) (snd-display "~D mus-file-mix(env): ~A?" k v0))
	    (mus-file-mix-1 k (make-mix-input "fmv2.snd" k) 0 12 0 (make-float-vector 4 1.0) vf))
	  ;; clm2xen should protect us here
	  (let ((vf (make-vector 2))
		(vf1 (make-vector 2))
		(vf2 (make-vector 2)))
	    (set! (vf 0) vf1)
	    (set! (vf 1) vf2)
	    (set! (vf1 0) (make-env '(0 0 1 1) :length 10))
	    (set! (vf2 1) (make-env '(0 0 1 1) :length 10))
	    (mus-file-mix-1 k (make-mix-input "fmv2.snd" k) 0 12 0 (make-float-vector 4 1.0) vf)
	    (let ((tag (catch #t
			 (lambda ()
			   (set! (vf 0) (make-oscil))
			   (mus-file-mix-1 k (make-mix-input "fmv2.snd" k) 0 12 0 (make-float-vector 4 1.0) vf))
			 (lambda args (car args)))))
	      (if (not (eq? tag 'bad-type))
		  (snd-display "~D mix w oscil-vect: ~A" k tag)))
	    (set! (vf 0) vf1)
	    (set! (vf 1) vf2)
	    (let ((tag (catch #t
			 (lambda ()
			   (set! (vf1 0) (make-oscil))
			   (set! (vf2 1) 0+i)
			   (mus-file-mix-1 k (make-mix-input "fmv2.snd" k) 0 12 0 (make-float-vector 4 1.0) vf))
			 (lambda args (car args)))))
	      (if (not (eq? tag 'bad-type))
		  (snd-display "~D mix w oscil-env: ~A" k tag))))
	  (delete-file "fmv.snd")
	  (do ((i 0 (+ i 1))) ((= i 12)) (set! (v0 i) (* i .01)))
	  (array->file "fmv.snd" v0 12 22050 4)
	  (mus-file-mix-1 k (make-mix-input "fmv1.snd" k))
	  (file->array "fmv.snd" 0 0 3 v0) ; chan 0 start 0 len 3

	  ;; v0: #(0.1 0.14 0.18 0.03 0.04 0.05 0.06 0.070000000 0.08 0.09 0.1 0.11)
	  (if (or (fneq (v0 0) .1) (fneq (v0 2) .18)) (snd-display "~D mus-file-mix(1->4): ~A?" k v0))
	  (mus-file-mix-1 k (make-mix-input "fmv2.snd" k)  0 3 0 #r(0.3 0.0 0.7 0.0))
	  (file->array "fmv.snd" 0 0 3 v0)

	  ;; v0: #(0.3 0.34 0.38 0.03 0.04 0.05 0.06 0.070000000 0.08 0.09 0.1 0.11)
	  (if (or (fneq (v0 0) .3) (fneq (v0 2) .38)) (snd-display "~D mus-file-mix(2->4): ~A?" k v0))
	  (mus-file-mix-1 k (make-mix-input "fmv3.snd" k) 0 2 0)
	  (file->array "fmv.snd" 0 0 3 v0)

	  ;;  v0: #(0.60000000 0.64000000 0.38 0.03 0.04 0.05 0.06 0.070000000 0.08 0.09 0.1 0.11)
	  (if (or (fneq (v0 0) .6) (fneq (v0 2) .38)) (snd-display "~D mus-file-mix(4->4): ~A?" k v0)))
	
	(if (file-exists? "fmv.snd") (delete-file "fmv.snd"))
	(let ((len (mus-sound-framples "oboe.snd")))
	  (array->file "fmv.snd" (make-float-vector 12) 12 22050 1)
	  (mus-file-mix-1 k (make-mix-input "oboe.snd" k))
	  (mus-file-mix-1 k (make-mix-input "oboe.snd" k) 0 len 0 #r(0.5))
	  (let ((egen (make-vector 1))
		(outv (make-vector 1)))
	    (set! (outv 0) egen)
	    (set! (egen 0) (make-env :envelope '(0 0 1 1) :length len))
	    (mus-file-mix-1 k (make-mix-input "oboe.snd" k) 0 len 0 #f outv)
	    (set! (egen 0) (make-env :envelope '(0 1 1 0) :length len))
	    (mus-file-mix-1 k (make-mix-input "oboe.snd" k) 0 len 0 #r(1.0) outv))
	  (let ((ind-oboe (open-sound "oboe.snd"))
		(ind-mix (open-sound "fmv.snd")))
	    (if (not (mus-arrays-equal? (channel->float-vector 1000 10 ind-oboe)
			     (float-vector-scale! (channel->float-vector 1000 10 ind-mix) (/ 1.0 2.5))))
		(snd-display "~D mus-file-mix 1 chan: ~A ~A" k
			     (channel->float-vector 1000 10 ind-oboe)
			     (channel->float-vector 1000 10 ind-mix)))
	    (close-sound ind-oboe)
	    (close-sound ind-mix))
	  (delete-file "fmv.snd")
	  (let ((len (mus-sound-framples "2.snd")))
	    (array->file "fmv.snd" (make-float-vector 12) 12 22050 2)
	    (if (not (= (mus-sound-chans "fmv.snd") 2))
		(snd-display "~D array->file chans? ~A" k (mus-sound-chans "fmv.snd")))
	    (mus-file-mix-1 k (make-mix-input "2.snd" k))
	    (mus-file-mix-1 k (make-mix-input "2.snd" k) 0 len 0 #r(0.5 0.0 0.0 0.5))
	    (let ((egen0 (make-vector 2))
		  (egen1 (make-vector 2))
		  (outv (make-vector 2)))
	      (set! (outv 0) egen0)
	      (set! (outv 1) egen1)
	      (set! (egen0 0) (make-env :envelope '(0 0 1 1) :length len))
	      (set! (egen1 1) (make-env :envelope '(0 0 1 1) :length len))
	      (mus-file-mix-1 k (make-mix-input "2.snd" k) 0 len 0 #f outv)))
	  (let ((ind-mix (open-sound "fmv.snd")))
	    (if (not (= (channels ind-mix) 2))
		(snd-display "~D fmv re-read chans? ~A ~A" k (mus-sound-chans "fmv.snd") (channels ind-mix)))
	    (if (not (mus-arrays-equal? (channel->float-vector 1000 10 ind-mix 0)
			     #r(0.003 0.010 0.012 0.011 0.008 0.004 0.002 0.002 0.007 0.017)))
		(snd-display "~D mus-file-mix 2 chan (2.snd written: ~A): ~A ~A" k
			     (strftime "%d-%b %H:%M %Z" (localtime (mus-sound-write-date "2.snd")))
			     (channel->float-vector 1000 10 ind-mix 0)
			     (channel->float-vector 1000 10 ind-mix 1)))
	    (close-sound ind-mix)
	    (delete-file "fmv.snd")))
	); end do loop
      ); end let
    
    
    (let ()
      ;; someday this should be expanded
      (if (pair? (sounds))
	  (for-each close-sound (sounds)))

      (catch #t (lambda () (mus-file-mix-with-envs rd 0 1000 (float-vector))) (lambda args 'error))
      
      (with-sound ("flat.snd") 
	(do ((i 0 (+ i 1)))
	    ((= i 1000))
	  (outa i 1.0)))
      
      (with-sound ("mix.snd")
	(mus-file-mix-with-envs (vector (make-readin "flat.snd")) 0 1000 #r(0.5) #f #f #f #f))
      
      (let ((ind (find-sound "mix.snd")))
	(if (sound? ind)
	    (if (fneq (sample 100 ind) 0.5)
		(snd-display "mus-file-mix-with-envs 1: ~A" (sample 100 ind)))
	    (snd-display "mus-file-mix-with envs 1: no output? ~A" (map short-file-name (sounds)))))
      
      (with-sound ("mix.snd")
	(mus-file-mix-with-envs (vector (make-readin "flat.snd")) 0 1000 
				#r(0.0) #f
				(vector (make-env '(0 0 1 1) :length 1000))
				#f #f))
      
      (let ((ind (find-sound "mix.snd")))
	(if (sound? ind)
	    (if (fneq (sample 100 ind) 0.1)
		(snd-display "mus-file-mix-with-envs 2: ~A" (sample 100 ind)))
	    (snd-display "mus-file-mix-with envs 2: no output? ~A" (map short-file-name (sounds)))))
      
      (with-sound ("mix.snd" 2 :clipped #f)
	(let ((rd (vector (make-readin "flat.snd") 
			  (make-readin "flat.snd")))
	      (es (vector (make-env '(0 0 1 1) :length 1000 :scaler .1) 
			  (make-env '(0 1 1 0) :length 1000 :scaler .1)
			  (make-env '(0 1 1 1) :length 1000 :scaler .5)
			  (make-env '(0 1 1 1) :length 1000 :scaler -.5))))
	  (mus-file-mix-with-envs rd 0 1000 (make-float-vector 4) #f es #f #f)))
      
      (let ((ind (find-sound "mix.snd")))
	(if (sound? ind)
	    (begin
	      (if (fneq (sample 100 ind 0) 0.51)
		  (snd-display "mus-file-mix-with-envs 3 chan 0: ~A" (sample 100 ind 0)))
	      (if (fneq (sample 100 ind 1) -0.41)
		  (snd-display "mus-file-mix-with-envs 3 chan 1: ~A" (sample 100 ind 1))))
	    (snd-display "mus-file-mix-with envs 3: no output? ~A" (map short-file-name (sounds)))))
      
      (with-sound ("mix.snd" 2 :clipped #f)
	(let ((rd (vector (make-readin "flat.snd")))
	      (es (vector (make-env '(0 0 1 1) :length 1000 :scaler .3) 
			  (make-env '(0 1 1 0) :length 1000 :scaler .4))))
	  (mus-file-mix-with-envs rd 0 1000 (make-float-vector 4) #f es #f #f)))
      
      (let ((ind (find-sound "mix.snd")))
	(if (sound? ind)
	    (begin
	      (if (fneq (sample 100 ind 0) 0.03)
		  (snd-display "mus-file-mix-with-envs 4 chan 0: ~A" (sample 100 ind 0)))
	      (if (fneq (sample 100 ind 1) 0.36)
		  (snd-display "mus-file-mix-with-envs 4 chan 1: ~A" (sample 100 ind 1))))
	    (snd-display "mus-file-mix-with envs 4: no output? ~A" (map short-file-name (sounds)))))
      
      (with-sound ("mix.snd" 1 :clipped #f)
	(let ((rd (vector (make-readin "flat.snd")
			  (make-readin "flat.snd")))
	      (es (vector (make-env '(0 0 1 1) :length 1000 :scaler .3) 
			  (make-env '(0 1 1 0) :length 1000 :scaler .4))))
	  (mus-file-mix-with-envs rd 0 1000 (make-float-vector 4) #f es #f #f)))
      
      (let ((ind (find-sound "mix.snd")))
	(if (sound? ind)
	    (if (fneq (sample 100 ind) 0.39)
		(snd-display "mus-file-mix-with-envs 5: ~A" (sample 100 ind)))
	    (snd-display "mus-file-mix-with envs 5: no output? ~A" (map short-file-name (sounds)))))
      
      (with-sound ("flat.snd") 
	(outa 99 0.5)
	(outa 100 1.0)
	(outa 101 0.5))
      
      (require snd-jcrev.scm)
      
      (with-sound ("mix.snd" :reverb jc-reverb)
	(mus-file-mix-with-envs (vector (make-readin "flat.snd")) 0 1000 #r(0.5) #r(0.1) #f #f #f))
      
      (with-sound ("mix.snd" :reverb jc-reverb)
	(let* ((rd (vector (make-readin "flat.snd") 
			   (make-readin "flat.snd"))) 
	       (srcs (vector (make-src :input (vector-ref rd 0) :srate 2.0)
			     (make-src :input (vector-ref rd 1) :srate 0.5))))
	  (mus-file-mix-with-envs rd 0 1000 #r(1.0 1.0 0.5 0.5) #r(0.1) #f srcs #f)))
      
      (let ((ind (find-sound "mix.snd")))
	(if (sound? ind)
	    (if (fneq (sample 200 ind) 0.5)
		(snd-display "mus-file-mix-with-envs 7: ~A" (sample 200 ind)))
	    (snd-display "mus-file-mix-with envs 7: no output? ~A" (map short-file-name (sounds)))))

      (for-each close-sound (sounds))
      (delete-file "flat.snd")
      (delete-file "mix.snd")
      )


    (let* ((gen (make-phase-vocoder #f 512 4 256 1.0 #f #f #f))
	   (val (catch #t (lambda () (phase-vocoder gen)) (lambda args (car args)))))
      (if (fneq val 0.0) (snd-display "simple no-in pv call: ~A" val))
      (set! val (catch #t (lambda () (set! gen (make-phase-vocoder :fft-size 1234))) (lambda args (car args))))
      (if (not (eq? val 'out-of-range)) (snd-display "pv bad fft: ~A" val))
      )
    
    (let* ((ind (open-sound "oboe.snd"))
	   (pi2 (* 2.0 pi))
	   (reader (make-sampler 0))
	   (pv (make-phase-vocoder (lambda (dir) (next-sample reader))
				   512 4 128 1.0
				   #f ;no change to analysis
				   #f ;no change to edits
				   #f ;no change to synthesis
				   )))
      (if (not (phase-vocoder? pv)) (snd-display "~A not phase-vocoder?" pv))
      (print-and-check pv 
		       "phase-vocoder"
		       "phase-vocoder outctr: 128, interp: 128, filptr: 0, N: 512, D: 128, in_data: nil")
      (let ((val (let ((pv (make-phase-vocoder))) (set! (mus-location pv) 120) (mus-location pv))))
	(if (not (= val 120)) (snd-display "pv set outctr: ~A" val)))
      
      (select-sound ind)
      (map-channel (lambda (val) (phase-vocoder pv)))
      (float-vector-set! (phase-vocoder-amp-increments pv) 0 .1)
      (if (fneq ((phase-vocoder-amp-increments pv) 0) .1)
	  (snd-display "set phase-vocoder-amp-increments: ~A?" ((phase-vocoder-amp-increments pv) 0)))
      (float-vector-set! (phase-vocoder-amps pv) 0 .1)
      (if (fneq ((phase-vocoder-amps pv) 0) .1)
	  (snd-display "set phase-vocoder-amps: ~A?" ((phase-vocoder-amps pv) 0)))
      (float-vector-set! (phase-vocoder-phases pv) 0 .1)
      (if (fneq ((phase-vocoder-phases pv) 0) .1)
	  (snd-display "set phase-vocoder-phases: ~A?" ((phase-vocoder-phases pv) 0)))
      (float-vector-set! (phase-vocoder-phase-increments pv) 0 .1)
      (if (fneq ((phase-vocoder-phase-increments pv) 0) .1)
	  (snd-display "set phase-vocoder-phase-increments: ~A?" ((phase-vocoder-phase-increments pv) 0)))
      (float-vector-set! (phase-vocoder-freqs pv) 0 .1)
      (if (fneq ((phase-vocoder-freqs pv) 0) .1)
	  (snd-display "set phase-vocoder-freqs: ~A?" ((phase-vocoder-freqs pv) 0)))
      (undo 1)
      (free-sampler reader)
      (set! reader (make-sampler 0))
      (let ((edf (let ((lastphases (make-float-vector 512))
		       (diffs (make-float-vector 512)))
		   (lambda (v)
		     ;; new editing func changes pitch
		     (let ((N (mus-length v)) ;mus-increment => interp, mus-data => in-data
			   (D (mus-hop v))
			   (freqs (phase-vocoder-freqs v)))
		       (copy freqs diffs)
		       (float-vector-subtract! diffs lastphases)
		       (copy freqs lastphases)
		       (do ((N2 (floor (/ N 2)))
			    (pscl (/ 1.0 D))
			    (kscl (/ pi2 N))
			    (k 0 (+ k 1))
			    (kx 0.0))
			   ((= k N2))
			 (float-vector-set! freqs k (* 0.5 (+ (* pscl (remainder (float-vector-ref diffs k) pi2)) kx)))
			 (set! kx (+ kx kscl)))
		       #f)))))
	(set! pv (make-phase-vocoder (lambda (dir) (next-sample reader))
				     512 4 128 1.0
				     #f ;no change to analysis
				     edf
				     #f ; no change to synthesis
				     )))
      (map-channel (lambda (val) (phase-vocoder pv)))
      (undo 1)
      (free-sampler reader)
      (set! reader (make-sampler 0))
      (set! pv (make-phase-vocoder (lambda (dir) (next-sample reader))
				   512 4 256 1.0
				   #f ;no change to analysis
				   #f ;no change to edits
				   #f ;no change to synthesis
				   ))
      (let* ((len 1000)
	     (data (make-float-vector len)))
	(fill-float-vector data (phase-vocoder pv))
	(set! (samples 0 len) data))
      (undo 1)
      (free-sampler reader)
      
      (let ((incalls 0)
	    (outcalls 0))
	(set! reader (make-sampler 0))
	(set! pv (make-phase-vocoder (lambda (dir) (next-sample reader))
				     512 4 256 1.0
				     (lambda (v infunc)
				       (set! incalls (+ incalls 1)))
				     #f ;no change to edits
				     (lambda (v)
				       (set! outcalls (+ outcalls 1))
				       0.0)
				     ))
	(let* ((len 1000)
	       (data (make-float-vector len)))
	  (fill-float-vector data (phase-vocoder pv))
	  (set! (samples 0 len) data))
	(undo 1)
	(free-sampler reader)
	(if (or (= incalls 0)
		(= outcalls 0))
	    (snd-display "phase-vocoder incalls: ~A, outcalls: ~A" incalls outcalls)))
      (let ((tag (catch #t 
		   (lambda () (make-phase-vocoder #f 512 4 256 1.0 (lambda (a b c) #f) #f #f)) 
		   (lambda args args))))
	(if (not (memq (car tag) '(wrong-type-arg bad-arity))) (snd-display "make-phase-vocoder bad analyze func: ~A" tag)))
      (let ((tag (catch #t
		   (lambda () (make-phase-vocoder #f 512 4 256 1.0 (lambda (a b) 0.0) (lambda (a b c) #f) #f)) 
		   (lambda args args))))
	(if (not (memq (car tag) '(wrong-type-arg bad-arity))) (snd-display "make-phase-vocoder bad edit func: ~A" tag)))
      (let ((tag (catch #t 
		   (lambda () (make-phase-vocoder #f 512 4 256 1.0 (lambda (a b) 0.0) (lambda (a) #f) (lambda (a b) 0)))
		   (lambda args args))))
	(if (not (memq (car tag) '(wrong-type-arg bad-arity))) (snd-display "make-phase-vocoder bad synthesize func: ~A" tag)))
      (let* ((geno (make-phase-vocoder (lambda (dir) 0.0)))
	     (genx (make-phase-vocoder :input (lambda (dir) 0.0))))
	(if (equal? geno genx) (snd-display "phase-vocoder equal? ~A ~A" geno genx))
	(if (fneq (mus-frequency genx) 1.0) (snd-display "mus-frequency phase-vocoder: ~A" (mus-frequency genx)))
	(set! (mus-frequency genx) 2.0)
	(if (fneq (mus-frequency genx) 2.0) (snd-display "set mus-frequency phase-vocoder: ~A" (mus-frequency genx)))
	(if (fneq (mus-increment genx) 128) (snd-display "mus-increment phase-vocoder: ~A" (mus-increment genx)))
	(set! (mus-increment genx) 256)
	(if (fneq (mus-increment genx) 256) (snd-display "set mus-increment phase-vocoder: ~A" (mus-increment genx)))
	(if (not (= (mus-hop genx) 128)) (snd-display "phase vocoder hop: ~A" (mus-hop genx)))
	(set! (mus-hop genx) 64)
	(if (not (= (mus-hop genx) 64)) (snd-display "set phase vocoder hop: ~A" (mus-hop genx)))
	(if (not (= (mus-length genx) 512)) (snd-display "phase vocoder length: ~A" (mus-length genx))))
      (close-sound ind))
    
    (let-temporarily ((*mus-float-equal-fudge-factor* 1e-5)) ; some phase-vocoder tests
      (let ((ind (new-sound :size 110)))
	(set! (sample 1) 1.0)
	(let ((pv (make-phase-vocoder (let ((rd (make-sampler)))
					(lambda (dir) (next-sample rd)))
				      128 4 32 1.0 #f #f #f)))
	  (map-channel (lambda (y) (phase-vocoder pv)))
	  (let ((v (channel->float-vector 0 50))
		(v0 #r(0.00022 0.00130 0.00382 0.00810 0.01381 0.01960 0.02301 0.02143 0.01421 0.00481 0.0 0.00396 0.01168 0.01231 0.00413 0.00018 0.00704 0.00984 0.00189 0.00197 0.00881 0.00290 0.00151 0.00781 0.00091 0.00404 0.00498 0.00047 0.00641 -0.00017 0.00590 0.00006 0.00492 0.00031 0.00380 0.00052 0.00290 0.00066 0.00219 0.00074 0.00164 0.00076 0.00123 0.00074 0.00092 0.00067 0.00069 0.00058 0.00052 0.00048)))
	    (if (not (or (mus-arrays-equal? v v0)
			 (mus-arrays-equal? (float-vector-scale! v -1.0) v0))) 
		(snd-display "pv 1 diff: ~A" (float-vector-peak (float-vector-subtract! v v0)))))
	  (undo))

	(let ((pv (make-phase-vocoder (let ((rd (make-sampler)))
					(lambda (dir) (next-sample rd)) )
		   128 4 32 2.0 #f #f #f)))
	  (map-channel (lambda (y) (phase-vocoder pv)))
	  (let ((v (channel->float-vector 0 50))
		(v0 #r(0.00044 0.00255 0.00705 0.01285 0.01595 0.01177 0.00281 0.00069 0.00782 0.00702 0.00001 0.00584 0.00385 0.00138 0.00547 0.00035 0.00494 0.00082 0.00305 0.00310 0.00003 0.00380 0.00245 -0.00019 0.00159 0.00348 0.00268 0.00087 -0.00020 -0.00036 -0.00010 0.00012 0.00036 0.00057 0.00075 0.00089 0.00099 0.00105 0.00108 0.00107 0.00104 0.00099 0.00094 0.00087 0.00080 0.00073 0.00066 0.00059 0.00053 0.00047)))
	    (if (not (mus-arrays-equal? v v0))
		(snd-display "pv 2 diff: ~A" (float-vector-peak (float-vector-subtract! v v0)))))
	  (undo))
	
	(let ((pv (make-phase-vocoder (let ((rd (make-sampler)))
					(lambda (dir) (next-sample rd)))
				      128 4 32 0.5 #f #f #f)))
	  (map-channel (lambda (y) (phase-vocoder pv)))
	  (let ((v (channel->float-vector 0 50))
		(v0 #r(0.00011 0.00065 0.00195 0.00428 0.00785 0.01266 0.01845 0.02456 0.02989 0.03305 0.03267 0.02803 0.01970 0.00993 0.00228 0.00009 0.00441 0.01250 0.01858 0.01759 0.00975 0.00160 0.00079 0.00795 0.01454 0.01201 0.00325 0.00024 0.00716 0.01261 0.00704 0.00003 0.00384 0.00962 0.00620 0.00027 0.00196 0.00655 0.00492 0.00040 0.00101 0.00448 0.00375 0.00041 0.00053 0.00305 0.00273 0.00033 0.00029 0.00204)))
	    (if (not (mus-arrays-equal? v v0))
		(snd-display "pv 3 diff: ~A" (float-vector-peak (float-vector-subtract! v v0)))))
	  (undo))
	
	(let ((pv (make-phase-vocoder (let ((rd (make-sampler)))
					(lambda (dir) (next-sample rd)))
				      128 4 64 1.0 #f #f #f)))
	  (map-channel (lambda (y) (phase-vocoder pv)))
	  (let ((v (channel->float-vector 0 100))
		(v0 #r(0.00005 0.00033 0.00098 0.00214 0.00392 0.00633 0.00923 0.01228 0.01495 0.01652 0.01633 0.01401 0.00985 0.00497 0.00114 0.00004 0.00221 0.00625 0.00929 0.00880 0.00488 0.00080 0.00040 0.00397 0.00727 0.00601 0.00162 0.00012 0.00358 0.00630 0.00352 0.00002 0.00217 0.00552 0.00300 -0.00008 0.00299 0.00479 0.00083 0.00098 0.00457 0.00175 0.00033 0.00412 0.00172 0.00039 0.00399 0.00087 0.00118 0.00356 -0.00016 0.00280 0.00169 0.00051 0.00326 -0.00030 0.00301 0.00040 0.00184 0.00144 0.00078 0.00213 0.00015 0.00242 -0.00017 0.00240 -0.00038 0.00230 -0.00049 0.00214 -0.00053 0.00194 -0.00051 0.00172 -0.00047 0.00150 -0.00040 0.00127 -0.00033 0.00106 -0.00025 0.00086 -0.00019 0.00068 -0.00013 0.00052 -0.00008 0.00039 -0.00005 0.00027 -0.00002 0.00017 -0.00001 0.00009 0.0 0.00003 0.0 -0.00002 -0.00001 -0.00006)))
	    (if (not (mus-arrays-equal? v v0))
		(snd-display "pv 4 diff: ~A" (float-vector-peak (float-vector-subtract! v v0)))))
	  (undo))
	
	(set! (sample 10) 1.0)
	(set! (sample 23) 1.0)
	(let ((pv (make-phase-vocoder (let ((rd (make-sampler)))
					(lambda (dir) (next-sample rd)))
				      128 4 32 1.0 #f #f #f)))
	  (map-channel (lambda (y) (phase-vocoder pv)))
	  (let ((v (channel->float-vector 0 100))
		(v0 #r(0.00100 0.00598 0.01756 0.03708 0.06286 0.08826 0.10172 0.09163 0.05680 0.01564 -0.00075 0.02124 0.05164 0.04457 0.00861 0.00529 0.03648 0.02747 -0.00875 0.00936 0.02402 -0.00553 -0.00090 -0.02262 -0.00221 0.06633 -0.03229 0.01861 0.05228 0.00672 0.00885 0.01442 -0.00484 -0.02293 -0.01893 -0.02256 -0.10229 -0.22474 0.31110 0.07597 0.07127 0.03670 0.02583 0.03173 0.02260 0.01550 0.01485 0.03212 -0.00966 0.00779 -0.00964 0.00698 0.01100 0.00468 0.00107 0.00517 0.00469 0.00131 0.00058 0.00530 0.00582 -0.00652 0.00011 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.00000)))
	    (if (not (mus-arrays-equal? v v0))
		(snd-display "pv 5 diff: ~A" (float-vector-peak (float-vector-subtract! v v0)))))
	  (undo))
	
	(set! (sample 40) 1.0)
	(set! (sample 63) 1.0)
	(let  ((pv (make-phase-vocoder (let ((rd (make-sampler)))
					 (lambda (dir) (next-sample rd)))
				       128 4 32 1.0 #f #f #f)))
	  (map-channel (lambda (y) (phase-vocoder pv)))
	  (let ((v (channel->float-vector 0 100))
		(v0 #r(0.00332 0.01977 0.05805 0.12252 0.20738 0.29035 0.33291 0.29696 0.18017 0.04637 -0.00003 0.08250 0.18618 0.15495 0.02775 0.02252 0.13597 0.09767 -0.03116 0.05301 0.10256 -0.05005 0.01966 0.06176 -0.04418 0.04118 -0.11409 -0.04115 -0.05157 -0.11409 0.07815 -0.08155 -0.00536 0.02090 -0.18804 -0.10686 -0.11931 -0.42989 0.39009 0.03157 0.14253 0.05984 0.05439 0.00764 0.02636 -0.02799 -0.01346 -0.01011 -0.04925 -0.02896 -0.07812 -0.07880 -0.11338 -0.13133 -0.41421 0.38140 0.08676 0.07712 0.00983 0.03731 0.01585 0.00108 0.00101 0.00282 -0.01106 -0.00403 -0.02165 -0.02054 -0.02452 -0.02382 -0.03213 -0.02693 -0.03734 -0.03978 -0.04879 -0.07504 -0.09597 -0.31426 0.32995 0.13460 0.04120 0.05029 0.01900 0.02517 0.01163 0.01294 0.00827 0.00576 0.00640 0.00141 0.00489 -0.00057 0.00301 -0.00089 0.00099 0.0 0.0 0.0 0.0 -0.00000)))
	    (if (not (mus-arrays-equal? v v0))
		(snd-display "pv 6 diff: ~A" (float-vector-peak (float-vector-subtract! v v0)))))
	  (close-sound ind))))
      
    (let ()
      (define (pvoc-d beg dur amp size)
	(let ((amps #f) (paincrs #f) (ppincrs #f) (phases #f) (freqs #f))
	  (let ((sr (let ((N2 (floor (/ size 2)))
			  (two-pi (* 2 pi)))
		      (let ((ifunc (let ((osc (make-oscil 1000.0)))
				     (lambda (dir)
				       (oscil osc))))
			    
			    (efunc (let ((lastphases (make-float-vector N2)))
				     (lambda (c)
				       (do ((pscl (/ 1.0 (floor (/ size 4)))) ; overlap = 4
					    (kscl (/ two-pi size))
					    (k 0 (+ k 1))
					    (ks 0.0))
					   ((= k N2) #f)
					 (let* ((freq (freqs k))
						(diff (- freq (lastphases k))))
					   (set! (lastphases k) freq)
					   (if (> diff pi) (set! diff (- diff two-pi)))
					   (if (< diff (- pi)) (set! diff (+ diff two-pi)))
					   (set! (freqs k) (+ (* diff  pscl) ks)))
					 (set! ks (+ ks kscl))))))
			    
			    (sfunc (lambda (c)
				     (float-vector-add! amps paincrs)
				     (float-vector-add! ppincrs freqs)
				     (float-vector-add! phases ppincrs)
				     (do ((sum 0.0)
					  (i 0 (+ i 1)))
					 ((= i N2) sum)
				       (if (> (amps i) .75)
					   (set! sum (+ sum (* (amps i) (if (> (modulo (phases i) two-pi) pi) 1.0 -1.0)))))))))
			(make-phase-vocoder :fft-size size :interp (/ size 4) :overlap 4
					    :edit efunc
					    :synthesize sfunc
					    :input ifunc)))))
	    
	    (set! amps (phase-vocoder-amps sr))
	    (set! paincrs (phase-vocoder-amp-increments sr))
	    (set! ppincrs (phase-vocoder-phase-increments sr))
	    (set! phases (phase-vocoder-phases sr))
	    (set! freqs (phase-vocoder-freqs sr))
	    
	    (do ((end (seconds->samples (+ beg dur)))
		 (i (seconds->samples beg) (+ i 1)))
		((= i end))
	      (outa i (* amp (phase-vocoder sr)))))))
      
      (let ((v (make-float-vector 200)))
	(with-sound (v :srate 44100) (pvoc-d 0 .0025 .2 128))
	(do ((i 55 (+ i 1)))
	    ((= i 65))
	  (if (> (abs (- (v i) .196)) .01)
	      (snd-display "pvoc-d at ~D: ~A~%" i (v i))))
	(do ((i 75 (+ i 1)))
	    ((= i 85))
	  (if (> (abs (+ (v i) .196)) .01)
	      (snd-display "pvoc-d at ~D: ~A~%" i (v i)))))
      )

    (let ((ind (open-sound "oboe.snd")))
      (let ((gen (make-moog-filter 500.0 .1)))
	(if (fneq 500.0 (moog-frequency gen)) (snd-display "moog freq: ~A" (moog-frequency gen))) ; moog-frequency is a separate function
	(if (fneq .1 (gen 'Q)) (snd-display "moog Q: ~A" (gen 'Q)))
;	(if (not (float-vector? (gen 's))) (snd-display "moog state: ~A" (gen 's)))
	(if (fneq 0.0 (gen 'y)) (snd-display "moog A? ~A" (gen 'y)))
	(if (fneq -0.861 (gen 'fc)) (snd-display "moog freqtable: ~A" (gen 'fc)))
	(let ((vals (make-float-vector 20)))
	  (set! (vals 0) (moog-filter gen 1.0))
	  (do ((i 1 (+ i 1)))
	      ((= i 20))
	    (set! (vals i) (moog-filter gen 0.0)))
	  (if (not (mus-arrays-equal? vals #r(0.0    0.0    0.0025 0.0062 0.0120 0.0198 0.0292 0.0398 0.0510 0.0625
				     0.0739 0.0847 0.0946 0.1036 0.1113 0.1177 0.1228 0.1266 0.1290 0.1301)))
	      (snd-display "moog output: ~A" vals))))
      (close-sound ind))
    
    (let ((gen (make-ssb-am 440.0)))
      (print-and-check gen 
		       "ssb-am"
		       "ssb-am shift: up, sin/cos: 439.999975 Hz (0.000000 radians), order: 41"
		       "ssb-am shift: up, sin/cos: 440.000000 Hz (0.000000 radians), order: 41"
		       "ssb-am shift: up, sin/cos: 439.999969 Hz (0.000000 radians), order: 41")
      (let ((gen1 (make-ssb-am 440.0))
	    (v0 (make-float-vector 10))
	    (v1 (make-float-vector 10)))
	(do ((i 0 (+ i 1)))
	    ((= i 10))
	  (set! (v0 i) (ssb-am gen)))
	(fill-float-vector v1 (if (ssb-am? gen1) (ssb-am gen1) -1.0))
	(if (not (mus-arrays-equal? v0 v1)) (snd-display "map ssb-am: ~A ~A" v0 v1)))
      (if (not (ssb-am? gen)) (snd-display "~A not ssb-am?" gen))
      (if (fneq (mus-phase gen) 1.253787) (snd-display "ssb-am phase: ~F?" (mus-phase gen)))
      (if (fneq (mus-frequency gen) 440.0) (snd-display "ssb-am frequency: ~F?" (mus-frequency gen)))
      (if (not (= (mus-order gen) 41)) (snd-display "ssb-am order: ~F?" (mus-order gen)))
      (if (not (= (mus-length gen) 41)) (snd-display "ssb-am length: ~D?" (mus-length gen)))
      (if (not (= (mus-interp-type gen) mus-interp-none)) (snd-display "ssb-am interp type: ~D?" (mus-interp-type gen)))
      (if (fneq (mus-xcoeff gen 0) -0.00124) (snd-display "ssb-am xcoeff 0: ~A" (mus-xcoeff gen 0)))
      (if (fneq (mus-xcoeff gen 1) 0.0) (snd-display "ssb-am xcoeff 1: ~A" (mus-xcoeff gen 1)))
					;	(if (not (float-vector? (mus-data gen))) (snd-display "mus-data ssb-am: ~A" (mus-data gen)))
					;	(if (not (float-vector? (mus-xcoeffs gen))) (snd-display "mus-xcoeffs ssb-am: ~A" (mus-xcoeffs gen)))
      ;; these apparently aren't handled in clm2xen
      )
    
    (test-gen-equal (make-ssb-am 440.0) (make-ssb-am 440.0) (make-ssb-am 500.0))
    
    (let ((o1 (make-ssb-am 400.0))
	  (o2 (make-ssb-am-1 400.0))
	  (happy #t))
      (do ((i 0 (+ i 1)))
	  ((or (not happy) (= i 100)))
	(let* ((inval (sin (* .1 i)))
	       (o1o (ssb-am o1 inval))
	       (o2o (ssb-am-1 o2 inval)))
	  (when (fneq o1o o2o)
	    (snd-display "ssb-am (up): ~A ~A at ~A" o1o o2o i)
	    (set! happy #f)))))
    
    (let ((o1 (make-ssb-am 400.0))
	  (o2 (make-ssb-am-1 400.0))
	  (happy #t))
      (do ((i 0 (+ i 1)))
	  ((or (not happy) (= i 100)))
	(let* ((inval (sin (* .1 i)))
	       (fmval (sin (* .2 i)))
	       (o1o (ssb-am o1 inval fmval))
	       (o2o (ssb-am-1 o2 inval fmval)))
	  (when (fneq o1o o2o)
	    (snd-display "ssb-am + fm (up): ~A ~A at ~A" o1o o2o i)
	    (set! happy #f)))))
    
    (let ((o1 (make-ssb-am -100.0))
	  (o2 (make-ssb-am-1 -100.0))
	  (happy #t))
      (do ((i 0 (+ i 1)))
	  ((or (not happy) (= i 100)))
	(let* ((inval (random 1.0))
	       (o1o (ssb-am o1 inval))
	       (o2o (ssb-am-1 o2 inval)))
	  (when (fneq o1o o2o)
	    (snd-display "ssb-am (down): ~A ~A at ~A" o1o o2o i)
	    (set! happy #f)))))
    
    (let ((o1 (make-ssb-am 1000.0 100))
	  (o2 (make-ssb-am-1 1000.0 100))
	  (happy #t))
      (do ((i 0 (+ i 1)))
	  ((or (not happy) (= i 100)))
	(let* ((inval (random 1.0))
	       (o1o (ssb-am o1 inval))
	       (o2o (ssb-am-1 o2 inval)))
	  (when (fneq o1o o2o)
	    (snd-display "ssb-am (down): ~A ~A at ~A" o1o o2o i)
	    (set! happy #f)))))
    
    (let ((index (open-sound "pistol.snd"))
	  (data (channel->float-vector 0 100)))
      (convolve-with "oboe.snd" #f)
      (let ((scl (maxamp)))
	(convolve-with "oboe.snd" scl index 0 0)
	(if (ffneq (maxamp) scl)
	    (snd-display "convolve-with amps: ~A ~A" (maxamp) scl)))
      (revert-sound index)
      (agc)
      (if (fneq (maxamp index 0) 1.29) (snd-display "agc: ~A" (maxamp index 0)))
      (close-sound index)
      (let ((reader (make-sampler 0 "pistol.snd")))
	(do ((i 0 (+ i 1)))
	    ((= i 10))
	  (if (fneq (data i) (next-sample reader))
	      (snd-display "external reader trouble")))
	(free-sampler reader)))

    (let ((make-procs (vector
		       make-all-pass make-asymmetric-fm make-moving-average make-moving-max make-moving-norm
		       make-comb (lambda () (make-convolve :filter #r(0 1 2))) make-delay (lambda () (make-env '(0 1 1 0) :length 10))
		       (lambda () (make-filter :xcoeffs #r(0 1 2))) (lambda () (make-fir-filter :xcoeffs #r(0 1 2))) 
		       (lambda () (make-filtered-comb :filter (make-one-zero .5 .5)))
		       make-formant make-granulate
		       (lambda () (make-iir-filter :ycoeffs #r(0 1 2))) make-locsig 
		       make-notch make-one-pole (lambda () (make-one-pole-all-pass 1 .5)) make-one-zero make-oscil 
		       make-pulse-train make-rand make-rand-interp make-sawtooth-wave
		       make-square-wave make-src make-table-lookup make-triangle-wave
		       make-two-pole make-two-zero make-wave-train make-polyshape make-phase-vocoder make-ssb-am
		       (lambda () (make-filter :ycoeffs #r(0 1 2)))
		       (lambda () (make-filter :xcoeffs #r(1 2 3) :ycoeffs #r(0 1 2)))))
	  (gen-procs (vector all-pass asymmetric-fm moving-average moving-max moving-norm
			   comb convolve delay env 
			   filter fir-filter filtered-comb formant granulate
			   iir-filter (lambda (gen a) (locsig gen 0 a)) notch one-pole one-pole-all-pass one-zero oscil 
			   pulse-train rand rand-interp sawtooth-wave
			   square-wave (lambda (gen a) (src gen 0.0 a)) table-lookup triangle-wave
			   two-pole two-zero wave-train polyshape phase-vocoder ssb-am
			   filter filter))
	  (ques-procs (list all-pass? asymmetric-fm? moving-average? moving-max? moving-norm?
			    comb? convolve? delay? env? 
			    filter? fir-filter? filtered-comb? formant? granulate?
			    iir-filter? locsig? notch? one-pole? one-pole-all-pass? one-zero? oscil? 
			    pulse-train? rand? rand-interp? sawtooth-wave?
			    square-wave? src? table-lookup? triangle-wave?
			    two-pole? two-zero? wave-train? polyshape? phase-vocoder? ssb-am?
			    filter? filter?))
	  (func-names (list 'all-pass 'asymmetric-fm 'moving-average 'moving-max 'moving-norm
			    'comb 'convolve 'delay 'env 
			    'filter-x 'fir-filter 'filtered-comb 'formant 'granulate
			    'iir-filter 'locsig 'notch 'one-pole 'one-pole-all-pass 'one-zero 'oscil
			    'pulse-train 'rand 'rand-interp 'sawtooth-wave
			    'square-wave 'src 'table-lookup 'triangle-wave
			    'two-pole 'two-zero 'wave-train 'polyshape 'phase-vocoder 'ssb-am
			    'filter-y 'filter-xy))
	  (gen-args (list 0.0 0.0 1.0 1.0 1.0
			  0.0 (lambda (dir) 0.0) 0.0 #f
			  0.0 0.0 0.0 0.0 (lambda (dir) 0.0)
			  0.0 0.0 0.0 0.0 0.0 0.0 0.0
			  0.0 0.0 0.0 0.0
			  0.0 (lambda (dir) 0.0) 0.0 0.0
			  0.0 0.0 0.0 0.0 (lambda (dir) 0.0) 0.0
			  0.0 0.0))
	  (generic-procs (vector mus-channel mus-channels mus-data
			       mus-feedback mus-feedforward mus-frequency mus-hop mus-increment mus-length
			       mus-location mus-order mus-phase mus-ramp mus-scaler mus-xcoeffs mus-ycoeffs))
	  (generic-names (vector 'mus-channel 'mus-channels 'mus-data
			       'mus-feedback 'mus-feedforward 'mus-frequency 'mus-hop 'mus-increment 'mus-length
			       'mus-location 'mus-order 'mus-phase 'mus-ramp 'mus-scaler 'mus-xcoeffs 'mus-ycoeffs)))
      (for-each
       (lambda (make runp ques arg name)
	 (catch #t
	   (lambda ()
	     (let ((gen (make)))
	       (if (not (ques gen)) (snd-display "~A: ~A -> ~A?" name make gen))
	       (let ((tag (catch #t (lambda () (if arg (runp gen arg) (runp gen))) (lambda args args))))
		 (if (not (or (number? tag)
			      (float-vector? tag)))
		     (snd-display "~A: ~A ~A ~A: ~A" name runp gen arg tag)))
	       (for-each
		(lambda (func genname)
		  (let ((tag (catch #t (lambda () (func #f)) (lambda args (car args)))))
		    (if (not (eq? tag 'wrong-type-arg))
			(snd-display "generic func with #f: (~A #f) -> ~A" genname tag)))
		  (let ((g1 (make-oscil))
			(g2 (make-one-pole .1 .9)))
		    (let ((tag (catch #t (lambda () (func g1)) (lambda args (car args)))))
		      (if (and (symbol? tag)
			       (not (eq? tag 'wrong-type-arg))
			       (not (eq? tag 'mus-error)))
			  (snd-display "generic ~A of oscil: ~A" genname tag)))
		    (let ((tag (catch #t (lambda () (func g2)) (lambda args (car args)))))
		      (if (and (symbol? tag)
			       (not (eq? tag 'wrong-type-arg))
			       (not (eq? tag 'mus-error)))
			  (snd-display "generic ~A of delay: ~A" genname tag))))
		  (let ((tag (catch #t (lambda () (func gen)) (lambda args (car args)))))
		    (if (and (not (symbol? tag))
			     (dilambda? func)
			     (or (not (eq? genname 'mus-data))
				 (float-vector? tag)))
			(let ((tag1 (catch #t (lambda () (set! (func gen) tag)) (lambda args (car args)))))
			  (if (and (symbol? tag1)
				   (not (eq? tag1 'mus-error))
				   (not (eq? tag1 'out-of-range)))
			      (snd-display "~A set ~A ~A ~A -> ~A" name genname gen tag tag1))))))
		generic-procs generic-names)
	       (mus-reset gen)))
	   (lambda args #f)))
       make-procs gen-procs ques-procs gen-args func-names)
      
      (let ((make-procs (list
			 make-all-pass make-asymmetric-fm make-moving-average make-moving-max 
			 make-comb 
			 (lambda () (make-filtered-comb :filter (make-one-zero .5 .5)))
			 (lambda () (make-convolve :filter #r(0 1 2) :input (lambda (dir) 1.0))) 
			 make-delay 
			 (lambda () (make-env :length 11 :envelope '(0 1 1 0)))
			 (lambda () (make-filter :xcoeffs #r(0 1 2))) 
			 (lambda () (make-fir-filter :xcoeffs #r(0 1 2))) 
			 (lambda () (make-formant :radius .1 :frequency 440.0)) 
			 (lambda () (make-granulate (lambda (dir) 1.0)))
			 (lambda () (make-iir-filter :ycoeffs #r(0 1 2))) 
			 make-locsig 
			 make-notch 
			 (lambda () (make-one-pole .3 .7))
			 (lambda () (make-one-zero .5 .5))
			 make-oscil 
			 make-pulse-train make-sawtooth-wave
			 make-square-wave 
			 (lambda () (make-table-lookup :wave (make-float-vector 128 .1))) 
			 make-triangle-wave
			 (lambda () (make-two-pole .1 .3 .6)) 
			 (lambda () (make-two-zero .1 .3 .5)) 
			 (lambda () (make-polyshape 440.0 :partials '(1 1)))
			 (lambda () (make-phase-vocoder (lambda (dir) 1.0)))
			 make-ssb-am
			 (lambda () (make-filter :ycoeffs #r(0 1 2)))
			 (lambda () (make-filter :xcoeffs #r(1 2 3) :ycoeffs #r(0 1 2)))))
	    (gen-procs (list all-pass asymmetric-fm moving-average moving-max
			     comb filtered-comb convolve delay 
			     (lambda (gen ignored) (env gen))
			     filter fir-filter formant 
			     granulate
			     iir-filter 
			     (lambda (gen a) (locsig gen 0 1.0))
			     notch one-pole one-zero oscil 
			     pulse-train sawtooth-wave
			     square-wave table-lookup triangle-wave
			     two-pole two-zero polyshape phase-vocoder ssb-am
			     filter filter))
	    (func-names (list 'all-pass 'asymmetric-fm 'moving-average 'moving-max
			      'comb 'filtered-comb 'convolve 'delay 'env 
			      'filter-x 'fir-filter 'formant 'granulate
			      'iir-filter 'locsig 'notch 'one-pole 'one-zero 'oscil 
			      'pulse-train 'sawtooth-wave
			      'square-wave 'table-lookup 'triangle-wave
			      'two-pole 'two-zero 'polyshape 'phase-vocoder 'ssb-am
			      'filter-y 'filter-xy)))
	(for-each
	 (lambda (make runp name)
	   (let ((gen (make))
		 (data (make-float-vector 10))
		 (eloc (memq name '(env locsig)))
		 (pssb (memq name '(polyshape ssb-am))))
	     (set! (data 0) (runp gen 1.0))
	     (do ((i 1 (+ i 1)))
		 ((= i 10))
	       (set! (data i) (runp gen 0.0)))
	     (do ((k 0 (+ k 1)))
		 ((= k 2))
	       (mus-reset gen)
	       (unless eloc
		 (let ((not-zero #f)
		       (k0 (= k 0))
		       (ra (if (= k 0) 'run 'apply)))
		   (let ((first-val (if k0 (runp gen 1.0) (mus-apply gen 1.0 0.0))))
		     (if (not (= (data 0) 0.0)) (set! not-zero #t))
		     (if (fneq (data 0) first-val)
			 (snd-display "[~A] ~A: ~A ~A ~A" ra name 0 (data 0) first-val)))
		   (do ((i 1 (+ i 1)))
		       ((= i 10))
		     (let ((old-val (data i))
			   (new-val (if k0 (runp gen 0.0) (mus-apply gen 0.0 0.0))))
		       (if (not (= old-val 0.0)) (set! not-zero #t))
		       (if (fneq old-val new-val)
			   (snd-display "[~A] ~A: ~A ~A ~A" ra name i old-val new-val))))
		   (if (not (or pssb not-zero))
		       (snd-display "~A not much of a reset test!" name)))))))
	 make-procs gen-procs func-names))
      
      (when (and all-args (= clmtest 0))
	(let ((a1 (list 1.5 "/hiho" (list 0 1) 1234 (make-float-vector 3) (make-color-with-catch .95 .95 .95) #i(0 1) 3/4 'mus-error 0+i (make-delay 32)
			(lambda () #t) (curlet) (make-float-vector '(2 3)) :order 0 1 -1 #f #t #\c 0.0 1.0 -1.0 (vector 0 2)
			() 3 4 2 8 16 32 64 #() '(1 . 2) (expt 2.0 21.5) (expt 2.0 -18.0)))
	      (a2 (list 1.5 "/hiho" (list 0 1) 1234 (make-float-vector 3) (make-color-with-catch .95 .95 .95) #i(0 1) 3/4 'mus-error 0+i (make-delay 32)
			(lambda () #t) (curlet) (make-float-vector '(2 3)) :order 0 1 -1 #f #t #\c 0.0 1.0 -1.0 (vector 0 1)
			() 3 4 2 8 16 32 64 #() '(1 . 2) (expt 2.0 21.5) (expt 2.0 -18.0)))
	      (a3 (list 1.5 "/hiho" (list 0 1) 1234 (make-float-vector 3) #i(0 1) 3/4 'mus-error 0+i
			(lambda () #t) (make-float-vector '(2 3)) :order 0 1 -1 #f #t #\c 0.0 1.0 -1.0 
			() 3 4 64 -64 #() '(1 . 2) (expt 2.0 21.5) (expt 2.0 -18.0)
			(lambda (a) a))))
	  (for-each
	   (lambda (make runp)
	     (catch #t 
	       (lambda ()
		 (let ((gen (make)))
		   ;; run args
		   (for-each 
		    (lambda (arg1)
		      ;; how did this ever work??
		      (catch #t (lambda () (runp gen arg1)) (lambda args (car args)))
		      (for-each
		       (lambda (arg2)
			 (catch #t (lambda () (runp gen arg1 arg2)) (lambda args (car args))))
		       a1))
		    a2)
		   
		   ;; generic args
		   (for-each
		    (lambda (func name)
		      (catch #t
			(lambda ()
			  (let ((default-value (func gen)))
			    (for-each
			     (lambda (arg1)
			       (catch #t
				 (lambda ()
				   (func gen)
				   (set! (func gen) arg1))
				 (lambda args #f)))
			     a3)
			    (if (not (equal? (func gen) default-value))
				(catch #t
				  (lambda ()
				    (set! (func gen) default-value))
				  (lambda args #f)))))
			(lambda args #f)))
		    generic-procs generic-names)
		   (mus-reset gen)))
	       (lambda args (car args))))
	   make-procs gen-procs)
	
	  (let-temporarily ((*clm-srate* 100))
	    (for-each
	     (lambda (n)
	       (set! *clm-srate* n)
	       (for-each 
		(lambda (g name)
		  (let ((tag (catch #t (lambda () (g :frequency 440.0)) (lambda args (car args)))))
		    (if (not (memq tag '(wrong-type-arg out-of-range)))
			(snd-display "key-check ~A: ~A -> ~A" n name tag))))
		(list make-oscil make-asymmetric-fm 
		      make-triangle-wave make-square-wave make-pulse-train make-sawtooth-wave
		      make-rand make-rand-interp)
		'(oscil asymmetric-fm 
			triangle-wave square-wave pusle-train sawtooth-wave
			rand rand-interp)))
	     '(100 1)))
	  
	  (define (tgens)
	    (let ((random-args (vector
				(expt 2.0 21.5) (expt 2.0 -18.0)
				1.5 "/hiho" (list 0 1) 1234 (make-float-vector 3) (make-color-with-catch .1 .2 .3)  #i(0 1) 3/4 0+i (make-delay 32)
				(lambda () 0.0) (lambda (dir) 1.0) (lambda (a b c) 1.0) 0 1 -1 #f #t #\c 0.0 1.0 -1.0 () 32 '(1 . 2)))
		  (gens2 (list make-wave-train make-two-zero make-two-pole make-polywave make-polyshape make-rand-interp make-rand make-notch 
			       make-locsig make-filtered-comb make-fft-window make-env make-delay make-comb make-table-lookup make-moving-norm 
			       make-asymmetric-fm make-all-pass make-square-wave make-sawtooth-wave make-pulse-train make-filter make-triangle-wave 
			       make-moving-max make-moving-average make-ssb-am make-oscil make-one-zero make-one-pole-all-pass make-one-pole 
			       make-iir-filter make-formant make-fir-filter))
		  (gens3 (list make-wave-train make-two-zero make-two-pole make-polywave make-polyshape make-rand-interp make-rand make-notch 
			       make-locsig make-filtered-comb make-fft-window make-env make-delay make-comb make-table-lookup make-moving-norm 
			       make-asymmetric-fm make-all-pass make-square-wave make-sawtooth-wave make-pulse-train make-filter make-triangle-wave 
			       make-moving-max make-moving-average))
		  (gens4 (list make-wave-train make-two-zero make-two-pole make-polywave make-polyshape make-rand-interp make-rand make-notch 
			       make-locsig make-filtered-comb make-fft-window make-env make-delay make-comb make-table-lookup make-moving-norm 
			       make-asymmetric-fm make-all-pass)))

	      (define random-gen
		(lambda (args gs)
		  (for-each
		   (lambda (n)
		     (catch #t
		       (lambda ()
			 (let ((gen (apply n args)))
			   (for-each
			    (lambda (arg)
			      (catch #t
				(lambda ()
				  (gen arg))
				(lambda args #f)))
			    random-args)))
		       (lambda args #f)))
		   gs)))
	      
	      (random-gen () gens2)
	      (let ((a1 (make-list 1 #f))
		    (a2 (make-list 2 #f))
		    (a3 (make-list 3 #f))
		    (a4 (make-list 4 #f)))
		(let ((a22 (cdr a2))
		      (a32 (cdr a3))
		      (a42 (cdr a4))
		      (a33 (cddr a3))
		      (a43 (cddr a4))
		      (a44 (cdddr a4)))
		  (for-each
		   (lambda (arg1)
		     (set-car! a1 arg1)
		     (set-car! a2 arg1)
		     (set-car! a3 arg1)
		     (set-car! a4 arg1)
		     (random-gen a1 gens2)
		     (for-each 
		      (lambda (arg2)
			(set-car! a22 arg2)
			(set-car! a32 arg2)
			(set-car! a42 arg2)
			(random-gen a2 gens2)
			(for-each 
			 (lambda (arg3)
			   (set-car! a33 arg3)
			   (set-car! a43 arg3)
			   (random-gen a3 gens3)
			   (for-each 
			    (lambda (arg4)
			      (set-car! a44 arg4)
			      (random-gen a4 gens4))
			    random-args))
			 random-args))
		      random-args))
		   random-args)))))
	  (tgens))))
      
    (do ((ov (make-float-vector 10))
	 (tv #r(.1 .1 .2 .2 1.5 1.5 1.5 1.5 0.1 0.01))
	 (gen (make-moving-max 4))
	 (iv #r(.1 .05 -.2 .15 -1.5 0.1 0.01 0.001 0.0 0.0))
	 (i 0 (+ i 1)))
	((= i 10)
	 (if (not (mus-arrays-equal? tv ov))
	     (snd-display "moving-max: ~A ~A" ov tv)))
      (set! (ov i) (moving-max gen (iv i))))
    
    (do ((g1 (make-moving-max 10))
	 (i 0 (+ i 1)))
	((= i 1000))
      (let ((val (moving-max g1 (random 1.0)))
	    (pk (float-vector-peak (mus-data g1))))
	(if (not (= pk val)) 
	    (snd-display "moving-max ~A ~A" pk val))))
    
    (let ((odata (make-float-vector 15))
	  (data #r(1.0 0.0 -1.1 1.1001 0.1 -1.1 1.0 1.0 0.5 -0.01 0.02 0.0 0.0 0.0 0.0))
	  (g (make-moving-max 3)))
	(do ((i 0 (+ i 1))) ((= i 15)) (set! (odata i) (moving-max g (data i))))
	(if (not (mus-arrays-equal? odata #r(1.000 1.000 1.100 1.100 1.100 1.100 1.100 1.100 1.000 1.000 0.500 0.020 0.020 0.000 0.000)))
	    (snd-display "moving max odata: ~A" odata))
	(if (= (odata 4) (odata 7))
	    (snd-display "moving-max .0001 offset?")))
      
    (let ((data #r(0.1 -0.2 0.3 0.4 -0.5 0.6 0.7 0.8 -0.9 1.0 0.0 0.0)))
      (let ((odata (make-float-vector 15))
	    (g (make-moving-sum 3)))
	(do ((i 0 (+ i 1))) ((= i 12)) (set! (odata i) (moving-sum g (data i))))
	(if (not (mus-arrays-equal? odata #r(0.100 0.300 0.600 0.900 1.200 1.500 1.800 2.100 2.400 2.700 1.900 1.000 0.000 0.000 0.000)))
	    (snd-display "moving-sum odata: ~A" odata)))
      
      (let ((odata (make-float-vector 15))
	    (g (make-moving-rms 4)))
	(do ((i 0 (+ i 1))) ((= i 12)) (set! (odata i) (moving-rms g (data i))))
	(if (not (mus-arrays-equal? odata #r(0.050 0.112 0.187 0.274 0.367 0.464 0.561 0.660 0.758 0.857 0.783 0.673 0.000 0.000 0.000)))
	    (snd-display "moving-rms odata: ~A" odata)))
      
      (let ((odata (make-float-vector 15))
	    (g (make-moving-length 4)))
	(do ((i 0 (+ i 1))) ((= i 12)) (set! (odata i) (moving-length g (data i))))
	(if (not (mus-arrays-equal? odata #r(0.100 0.224 0.374 0.548 0.735 0.927 1.122 1.319 1.517 1.715 1.565 1.345 0.000 0.000 0.000)))
	    (snd-display "moving-length odata: ~A" odata)))
	
      (let ((ind (new-sound "test.snd" :size 20)))
	(set! (sample 3) 1.0)
	(let ((gen1 (make-weighted-moving-average 4)))
	  (map-channel (lambda (y) (weighted-moving-average gen1 y))))
	(let ((data1 (channel->float-vector))
	      (gen2 (make-fir-filter 4 #r(0.4 0.3 0.2 0.1))))
	  (undo)
	  (map-channel (lambda (y) (fir-filter gen2 y)))
	  (let ((data2 (channel->float-vector)))
	    (if (not (mus-arrays-equal? data1 data2))
		(snd-display "weighted-moving-average and fir:~%;  ~A~%:   ~A" data1 data2)))
	  (undo))
	(close-sound ind))
      
      (let ((odata (make-float-vector 15)))
	(do ((i 0 (+ i 1)))
	    ((= i 10))
	  (set! (data i) (mus-random 0.5)))
	(let ((g (make-moving-length 4)))
	  (do ((i 0 (+ i 1))) ((= i 12)) (set! (odata i) (moving-length g (data i)))))
	(do ((i -3 (+ i 1))
	     (k 0 (+ k 1)))
	    ((= i 8))
	  (do ((sum 0.0)
	       (j 0 (+ j 1)))
	      ((= j 4)
	       (if (fneq (odata k) (sqrt sum)) 
		   (snd-display "moving length ran: ~A ~A" (odata k) (sqrt sum)))) 
	    (if (>= (+ i j) 0)
		(set! sum (+ sum (* (data (+ i j)) (data (+ i j))))))))
	
	(do ((i 0 (+ i 1)))
	    ((= i 10))
	  (set! (data i) (mus-random 0.5)))
	(let ((g (make-moving-sum 4)))
	  (do ((i 0 (+ i 1))) ((= i 12)) (set! (odata i) (moving-sum g (data i)))))
	(do ((i -3 (+ i 1))
	     (k 0 (+ k 1)))
	    ((= i 8))
	  (do ((sum 0.0)
	       (j 0 (+ j 1)))
	      ((= j 4)
	       (if (fneq (odata k) sum) 
		   (snd-display "moving sum ran: ~A ~A" (odata k) sum)))
	    (if (>= (+ i j) 0)
		(set! sum (+ sum (abs (data (+ i j))))))))
	
	(do ((i 0 (+ i 1)))
	    ((= i 10))
	  (set! (data i) (mus-random 0.5)))
	(let ((g (make-moving-rms 4)))
	  (do ((i 0 (+ i 1))) ((= i 12)) (set! (odata i) (moving-rms g (data i)))))
	(do ((i -3 (+ i 1))
	     (k 0 (+ k 1)))
	    ((= i 8))
	  (do ((sum 0.0)
	       (j 0 (+ j 1)))
	      ((= j 4)
	       (if (fneq (odata k) (sqrt (/ sum 4))) 
		   (snd-display "moving rms ran: ~A ~A" (odata k) (sqrt (/ sum 4)))))
	    (if (>= (+ i j) 0)
		(set! sum (+ sum (* (data (+ i j)) (data (+ i j))))))))))
      
    (let ((ind (open-sound "oboe.snd")))
      (harmonicizer 550.0 '(1 .5 2 .3 3 .2) 10)
      (close-sound ind))
    
    (let ((arglist ()))
      (do ((i 0 (+ i 1)))
	  ((= i 16))
	(set! arglist (cons 440.0 (cons :frequency arglist))))
      (set! arglist (reverse arglist))
      (for-each
       (lambda (make name)
	 (let ((tag (catch #t
			   (lambda () (apply make arglist))
			   (lambda args (car args)))))
	   (if (not (memq tag '(mus-error wrong-type-arg)))
	       (snd-display "long arglist to ~A: ~A" name tag))))
       (list make-wave-train make-polyshape make-delay make-moving-average make-moving-max make-moving-norm make-comb make-filtered-comb make-notch
	     make-rand make-rand-interp make-table-lookup make-env
	     make-readin make-locsig make-granulate make-convolve make-phase-vocoder)
       '(make-wave-train make-polyshape make-delay make-moving-average make-moving-max make-moving-norm make-comb make-filtered-comb make-notch
	 make-rand make-rand-interp make-table-lookup make-env
	 make-readin make-locsig make-granulate make-convolve make-phase-vocoder)))
    
    (let ((v1 (make-float-vector 10 .1)))
      
      (let ((g1 (mus-data (make-table-lookup :wave v1))))
	(if (not (eq? v1 g1)) (snd-display "table-lookup data not eq?: ~A ~A" v1 g1))
	(if (not (eqv? v1 g1)) (snd-display "table-lookup data not eqv?: ~A ~A" v1 g1))
	(if (not (morally-equal? v1 g1)) (snd-display "table-lookup data not equal?: ~A ~A" v1 g1))
	(set! (v1 1) .3)
	(if (fneq (g1 1) .3) (snd-display "table-lookup float-vector-set: ~A ~A" (v1 1) (g1 1)))
	(float-vector-set! g1 1 .5)
	(if (fneq (v1 1) .5) (snd-display "table-lookup float-vector-ref: ~A ~A" (v1 1) (g1 1))))
      
      (let ((g1 (mus-data (make-wave-train :wave v1))))
	(if (not (eq? v1 g1)) (snd-display "wave-train data not eq?: ~A ~A" v1 g1))
	(if (not (eqv? v1 g1)) (snd-display "wave-train data not eqv?: ~A ~A" v1 g1))
	(if (not (morally-equal? v1 g1)) (snd-display "wave-train data not equal?: ~A ~A" v1 g1))
	(set! (v1 1) .3)
	(if (fneq (g1 1) .3) (snd-display "wave-train float-vector-set: ~A ~A" (v1 1) (g1 1)))
	(float-vector-set! g1 1 .5)
	(if (fneq (v1 1) .5) (snd-display "wave-train float-vector-ref: ~A ~A" (v1 1) (g1 1))))
      
      (let ((g1 (mus-data (make-polyshape :coeffs v1))))
	(if (not (eq? v1 g1)) (snd-display "polyshape data not eq?: ~A ~A" v1 g1))
	(if (not (eqv? v1 g1)) (snd-display "polyshape data not eqv?: ~A ~A" v1 g1))
	(if (not (morally-equal? v1 g1)) (snd-display "polyshape data not equal?: ~A ~A" v1 g1))
	(set! (v1 1) .3)
	(if (fneq (g1 1) .3) (snd-display "polyshape float-vector-set: ~A ~A" (v1 1) (g1 1)))
	(float-vector-set! g1 1 .5)
	(if (fneq (v1 1) .5) (snd-display "polyshape float-vector-ref: ~A ~A" (v1 1) (g1 1))))
      
      (let ((g1 (mus-data (make-delay :initial-contents v1))))
	(if (not (eq? v1 g1)) (snd-display "delay data not eq?: ~A ~A" v1 g1))
	(if (not (eqv? v1 g1)) (snd-display "delay data not eqv?: ~A ~A" v1 g1))
	(if (not (morally-equal? v1 g1)) (snd-display "delay data not equal?: ~A ~A" v1 g1))
	(set! (v1 1) .3)
	(if (fneq (g1 1) .3) (snd-display "delay float-vector-set: ~A ~A" (v1 1) (g1 1)))
	(float-vector-set! g1 1 .5)
	(if (fneq (v1 1) .5) (snd-display "delay float-vector-ref: ~A ~A" (v1 1) (g1 1))))
      
      (let ((g1 (mus-data (make-filtered-comb :scaler .5 :initial-contents v1 :filter (make-one-zero .1 .2)))))
	(if (not (eq? v1 g1)) (snd-display "filtered-comb data not eq?: ~A ~A" v1 g1))
	(if (not (eqv? v1 g1)) (snd-display "filtered-comb data not eqv?: ~A ~A" v1 g1))
	(if (not (morally-equal? v1 g1)) (snd-display "filtered-comb data not equal?: ~A ~A" v1 g1))
	(set! (v1 1) .3)
	(if (fneq (g1 1) .3) (snd-display "filtered-comb float-vector-set: ~A ~A" (v1 1) (g1 1)))
	(float-vector-set! g1 1 .5)
	(if (fneq (v1 1) .5) (snd-display "filtered-comb float-vector-ref: ~A ~A" (v1 1) (g1 1))))
      
      (let ((g1 (mus-data (make-rand :distribution v1))))
	(if (not (eq? v1 g1)) (snd-display "rand data not eq?: ~A ~A" v1 g1))
	(if (not (eqv? v1 g1)) (snd-display "rand data not eqv?: ~A ~A" v1 g1))
	(if (not (morally-equal? v1 g1)) (snd-display "rand data not equal?: ~A ~A" v1 g1))
	(set! (v1 1) .3)
	(if (fneq (g1 1) .3) (snd-display "rand float-vector-set: ~A ~A" (v1 1) (g1 1)))
	(float-vector-set! g1 1 .5)
	(if (fneq (v1 1) .5) (snd-display "rand float-vector-ref: ~A ~A" (v1 1) (g1 1))))
      
      (let ((g1 (mus-xcoeffs (make-fir-filter :xcoeffs v1))))
	(if (not (eq? v1 g1)) (snd-display "fir-filter xcoeffs not eq?: ~A ~A" v1 g1))
	(if (not (eqv? v1 g1)) (snd-display "fir-filter xcoeffs not eqv?: ~A ~A" v1 g1))
	(if (not (morally-equal? v1 g1)) (snd-display "fir-filter xcoeffs not equal?: ~A ~A" v1 g1))
	(set! (v1 1) .3)
	(if (fneq (g1 1) .3) (snd-display "fir-filter float-vectorset: ~A ~A" (v1 1) (g1 1)))
	(float-vector-set! g1 1 .5)
	(if (fneq (v1 1) .5) (snd-display "fir-filter float-vectorref: ~A ~A" (v1 1) (g1 1))))
      
      (let ((g1 (mus-ycoeffs (make-iir-filter :ycoeffs v1))))
	(if (not (eq? v1 g1)) (snd-display "iir-filter ycoeffs not eq?: ~A ~A" v1 g1))
	(if (not (eqv? v1 g1)) (snd-display "iir-filter ycoeffs not eqv?: ~A ~A" v1 g1))
	(if (not (morally-equal? v1 g1)) (snd-display "iir-filter ycoeffs not equal?: ~A ~A" v1 g1))
	(set! (v1 1) .3)
	(if (fneq (g1 1) .3) (snd-display "iir-filter float-vector-set: ~A ~A" (v1 1) (g1 1)))
	(float-vector-set! g1 1 .5)
	(if (fneq (v1 1) .5) (snd-display "iir-filter float-vector-ref: ~A ~A" (v1 1) (g1 1)))))
    
    (let ((tanh-1 (lambda (x)
		    (* x (+ 1 (* x x (- (* x x (+ 2/15 (* x x (- (* x x (+ 62/2835 (* x x -1382/155925))) 17/315)))) 1/3))))))
	  (tanh-2 (lambda (y)
		    (+ (* 140069/172800 (sin y))
		       (* 13319/241920 (sin (* 3 y)))
		       (* 1973/483840 (sin (* 5 y)))
		       (* 799/1451520 (sin (* 7 y)))
		       (* -71/7257600 (sin (* 9 y)))
		       (* 691/79833600 (sin (* 11 y)))))))
      (for-each
       (lambda (x)
	 (let ((val (tanh (sin x)))
	       (val1 (tanh-1 (sin x)))
	       (val2 (tanh-2 x)))
	   (if (or (fneq val val1)
		   (fneq val1 val2))
	       (snd-display "tanh(~A): ~A ~A ~A" x val val1 val2))))
       '(1.0 0.1 0.1 0.333)))
    
    (if all-args
	(do ((maxerr 0.0)
	     (max-case #f)
	     (cases 0)
	     (n 1 (+ n 1)))
	    ((= n 100)
	     (if (> maxerr 1e-12)
		 (snd-display "sin-m*pi/n (~A cases) max err ~A at ~A~%" cases maxerr max-case)))
	  (do ((m 1 (+ m 1)))
	      ((= m 4))
	    (let ((val (sin (/ (* m pi) n)))
		  (expr (sin-m*pi/n m n)))
	      (if expr 
		  (let ((err (magnitude (- val (eval expr)))))
		    (set! cases (+ cases 1))
		    (when (> err maxerr)
		      (set! maxerr err)
		      (set! max-case (/ m n)))))))))
    
    (let ((tag (catch #t
		      (lambda () (with-sound () (outa -1 .1)))
		      (lambda args (car args)))))
      (if (not (eq? tag 'out-of-range))
	  (snd-display "outa -1 -> ~A" tag)))
    
    (let ((tag (catch #t
		      (lambda () (with-sound ((make-float-vector 10)) (outa -1 .1)))
		      (lambda args (car args)))))
      (if (not (eq? tag 'out-of-range))
	  (snd-display "outa (float-vector) -1 -> ~A" tag)))
    
    (let ((tag (catch #t
		      (lambda () (with-sound ((make-float-vector '(1 10))) (outa -1 .1)))
		      (lambda args (car args)))))
      (if (not (eq? tag 'out-of-range))
	  (snd-display "outa (vector 2) -1 -> ~A" tag)))
    
    (let ((v (with-sound () (catch #t (lambda () 
					 (outa -1 .1))
				   (lambda args 'error)))))
      (when (file-exists? v)
	(if (> (cadr (mus-sound-maxamp v)) 0.0) 
	    (snd-display "outa to file at -1: ~A" v))
	(if (> (mus-sound-chans v) 1)
	    (snd-display "outa to file at -1 chans: ~A" (mus-sound-chans v)))
	(cond ((find-sound v) => close-sound))
	(delete-file v)))
    (let ((v (with-sound ((make-float-vector 10)) (catch #t (lambda () 
							      (outa -1 .1)) 
							(lambda args 'error)))))
      (if (> (float-vector-peak v) 0.0) (snd-display "outa to float-vector at -1: ~A" v)))
    (let ((v (with-sound ((make-float-vector '(1 10))) (catch #t (lambda () 
								       (outa -1 .1)) 
								 (lambda args 'error)))))
      (if (> (maxamp v) 0.0) (snd-display "outa to vector1 at -1: ~A" v)))
    
    (if (not (= (signum 0) 0)) (snd-display "signum 0: ~A" (signum 0)))
    (if (not (= (signum 10) 1)) (snd-display "signum 10: ~A" (signum 10)))
    (if (not (= (signum -32) -1)) (snd-display "signum -32: ~A" (signum -32)))


    (do ((c1 (make-comb .5 3))
	 (c2 (make-comb-bank (vector (make-comb .5 3))))
	 (i 0 (+ i 1))
	 (x 1.0 0.0))
	((= i 20))
      (let ((x0 (comb c1 x))
	    (x1 (comb-bank c2 x)))
	(if (not (morally-equal? x0 x1))
	    (snd-display "(comb .5 3) ~A, comb: ~A, bank: ~A" i x0 x1))))
    
    (do ((c1 (make-comb .5 3))
	 (c2 (make-comb .2 10))
	 (c3 (make-comb-bank (vector (make-comb .5 3)
				     (make-comb .2 10))))
	 (i 0 (+ i 1))
	 (x 1.0 0.0))
	((= i 30))
      (let ((x0 (+ (comb c1 x) (comb c2 x)))
	    (x1 (comb-bank c3 x)))
	(if (not (morally-equal? x0 x1))
	    (snd-display "(comb .5 3) + (comb .2 10) ~A, comb: ~A, bank: ~A" i x0 x1))))
  
    (do ((c1 (make-comb .5 3))
	 (c2 (make-comb .2 10))
	 (c3 (make-comb -.7 11))
	 (c4 (make-comb-bank (vector (make-comb .5 3)
				     (make-comb .2 10)
				     (make-comb -.7 11))))
	 (i 0 (+ i 1))
	 (x 1.0 0.0))
	((= i 40))
      (let ((x0 (+ (comb c1 x) (comb c2 x) (comb c3 x)))
	    (x1 (comb-bank c4 x)))
	(if (not (morally-equal? x0 x1))
	    (snd-display "(comb .5 3) + (comb .2 10) + (comb -.7 11) ~A, comb: ~A, bank: ~A" i x0 x1))))
    
    (do ((c1 (make-all-pass -.5 .5 3))
	 (c2 (make-all-pass-bank (vector (make-all-pass -.5 .5 3))))
	 (i 0 (+ i 1))
	 (x 1.0 0.0))
	((= i 20))
      (let ((x0 (all-pass c1 x))
	    (x1 (all-pass-bank c2 x)))
	(if (not (morally-equal? x0 x1))
	    (snd-display "(all-pass -.5 .5 3) ~A, all-pass: ~A, bank: ~A" i x0 x1))))
    
    (do ((c1 (make-all-pass -.5 .5 3))
	 (c2 (make-all-pass -.2 .2 10))
	 (c3 (make-all-pass-bank (vector (make-all-pass -.5 .5 3)
					 (make-all-pass -.2 .2 10))))
	 (i 0 (+ i 1))
	 (x 1.0 0.0))
	((= i 30))
      (let ((x0 (all-pass c1 (all-pass c2 x)))
	    (x1 (all-pass-bank c3 x)))
	(if (not (morally-equal? x0 x1))
	    (snd-display "(all-pass -.5 .5 3) + (all-pass -.2 .2 10) ~A, all-pass: ~A, bank: ~A" i x0 x1))))
    
    (do ((c1 (make-all-pass -.5 .5 3))
	 (c2 (make-all-pass -.2 .2 10))
	 (c3 (make-all-pass -.7 .1 11))
	 (c4 (make-all-pass-bank (vector (make-all-pass -.5 .5 3)
					 (make-all-pass -.2 .2 10)
					 (make-all-pass -.7 .1 11))))
	 (i 0 (+ i 1))
	 (x 1.0 0.0))
	((= i 40))
      (let ((x0 (all-pass c1 (all-pass c2 (all-pass c3 x))))
	    (x1 (all-pass-bank c4 x)))
	(if (not (morally-equal? x0 x1))
	    (snd-display "(all-pass -.5 .5 3) + (all-pass -.2 .2 10) + (all-pass -.7 .1 11) ~A, all-pass: ~A, bank: ~A" i x0 x1))))
    
    
    (do ((c1 (make-filtered-comb .5 3))
	 (c2 (make-filtered-comb-bank (vector (make-filtered-comb .5 3))))
	 (i 0 (+ i 1))
	 (x 1.0 0.0))
	((= i 20))
      (let ((x0 (filtered-comb c1 x))
	    (x1 (filtered-comb-bank c2 x)))
	(if (not (morally-equal? x0 x1))
	    (snd-display "(filtered-comb .5 3) ~A, filtered-comb: ~A, bank: ~A" i x0 x1))))
    
    (do ((c1 (make-filtered-comb .5 3))
	 (c2 (make-filtered-comb .2 10))
	 (c3 (make-filtered-comb-bank (vector (make-filtered-comb .5 3)
					      (make-filtered-comb .2 10))))
	 (i 0 (+ i 1))
	 (x 1.0 0.0))
	((= i 30))
      (let ((x0 (+ (filtered-comb c1 x) (filtered-comb c2 x)))
	    (x1 (filtered-comb-bank c3 x)))
	(if (not (morally-equal? x0 x1))
	    (snd-display "(filtered-comb .5 3) + (filtered-comb .2 10) ~A, filtered-comb: ~A, bank: ~A" i x0 x1))))
    
    (do ((c1 (make-filtered-comb .5 3))
	 (c2 (make-filtered-comb .2 10))
	 (c3 (make-filtered-comb -.7 11))
	 (c4 (make-filtered-comb-bank (vector (make-filtered-comb .5 3)
					      (make-filtered-comb .2 10)
					      (make-filtered-comb -.7 11))))
	 (i 0 (+ i 1))
	 (x 1.0 0.0))
	((= i 40))
      (let ((x0 (+ (filtered-comb c1 x) (filtered-comb c2 x) (filtered-comb c3 x)))
	    (x1 (filtered-comb-bank c4 x)))
	(if (not (morally-equal? x0 x1))
	    (snd-display "(filtered-comb .5 3) + (filtered-comb .2 10) + (filtered-comb -.7 11) ~A, filtered-comb: ~A, bank: ~A" i x0 x1))))
    
    
    ;; make-formant-bank tests
    (do ((c1 (make-formant 440.0 .5))
	 (c2 (make-formant-bank (vector (make-formant 440.0 .5))))
	 (i 0 (+ i 1))
	 (x 1.0 0.0))
	((= i 40))
      (let ((x0 (formant c1 x))
	    (x1 (formant-bank c2 x)))
	(if (not (morally-equal? x0 x1))
	    (snd-display "(formant 440.0 .5) ~A, formant: ~A, bank: ~A" i x0 x1))))
    
    (do ((c1 (make-formant 440.0 .5))
	 (c2 (make-formant 1000.0 .2))
	 (c3 (make-formant-bank (vector (make-formant 440.0 .5)
					(make-formant 1000.0 .2))))
	 (i 0 (+ i 1))
	 (x 1.0 0.0))
	((= i 40))
      (let ((x0 (+ (formant c1 x) (formant c2 x)))
	    (x1 (formant-bank c3 x)))
	(if (not (morally-equal? x0 x1))
	    (snd-display "(formant 440.0 .5) + (formant 1000.0 .2) ~A, formant: ~A, bank: ~A" i x0 x1))))
    
    (do ((c1 (make-formant 440.0 .5))
	 (c2 (make-formant 1000.0 .2))
	 (c3 (make-formant 34.0 .1))
	 (c4 (make-formant-bank (vector (make-formant 440.0 .5)
					(make-formant 1000.0 .2)
					(make-formant 34.0 .1))))
	 (i 0 (+ i 1))
	 (x 1.0 0.0))
	((= i 40))
      (let ((x0 (+ (formant c1 x) (formant c2 x) (formant c3 x)))
	    (x1 (formant-bank c4 x)))
	(if (not (morally-equal? x0 x1))
	    (snd-display "(formant 440.0 .5) + (formant 1000.0 .2) + (formant 34.0 .1) ~A, formant: ~A, bank: ~A" i x0 x1))))

    (do ((c1 (make-formant 440.0 .75))
	 (c2 (make-formant 1000.0 .75))
	 (c3 (make-formant 34.0 .75))
	 (c4 (make-formant-bank (vector (make-formant 440.0 .75)
					(make-formant 1000.0 .75)
					(make-formant 34.0 .75))))
	 (i 0 (+ i 1))
	 (x 1.0 0.0))
	((= i 40))
      (let ((x0 (+ (formant c1 x) (formant c2 x) (formant c3 x)))
	    (x1 (formant-bank c4 x)))
	(if (not (morally-equal? x0 x1))
	    (snd-display "(formant 440.0 .75) + (formant 1000.0 .75) + (formant 34.0 .75) ~A, formant: ~A, bank: ~A" i x0 x1))))

    (do ((c1 (make-formant 440.0 .5))
	 (c2 (make-formant 1000.0 .2))
	 (c3 (make-formant 34.0 .1))
	 (c4 (make-formant-bank (vector (make-formant 440.0 .5)
					(make-formant 1000.0 .2)
					(make-formant 34.0 .1))
				#r(.5 .3 .4)))
	 (i 0 (+ i 1))
	 (x 1.0 0.0))
	((= i 40))
      (let ((x0 (+ (* .5 (formant c1 x)) (* .3 (formant c2 x)) (* .4 (formant c3 x))))
	    (x1 (formant-bank c4 x)))
	(if (not (morally-equal? x0 x1))
	    (snd-display "fb 3 with amps at ~A, formant: ~A, bank: ~A" i x0 x1))))

    (do ((c1 (make-formant 440.0 .9))
	 (c2 (make-formant 1000.0 .9))
	 (c3 (make-formant 34.0 .9))
	 (c4 (make-formant-bank (vector (make-formant 440.0 .9)
					(make-formant 1000.0 .9)
					(make-formant 34.0 .9))
				#r(.5 .3 .4)))
	 (i 0 (+ i 1))
	 (x 1.0 0.0))
	((= i 40))
      (let ((x0 (+ (* .5 (formant c1 x)) (* .3 (formant c2 x)) (* .4 (formant c3 x))))
	    (x1 (formant-bank c4 x)))
	(if (not (morally-equal? x0 x1))
	    (snd-display "fb 3 with amps c1_c2 at ~A, formant: ~A, bank: ~A" i x0 x1))))

    (do ((c1 (make-formant 440.0 .5))
	 (c2 (make-formant 1000.0 .2))
	 (c3 (make-formant 34.0 .1))
	 (inputs (make-float-vector 3 1.0))
	 (c4 (make-formant-bank (vector (make-formant 440.0 .5)
					(make-formant 1000.0 .2)
					(make-formant 34.0 .1))))
	 (i 0 (+ i 1))
	 (x 1.0 0.0))
	((= i 40))
      (let ((x0 (+ (formant c1 x) (formant c2 x) (formant c3 x)))
	    (x1 (formant-bank c4 inputs)))
	(fill! inputs 0.0)
	(if (not (morally-equal? x0 x1))
	    (snd-display "many (formant 440.0 .5) + (formant 1000.0 .2) + (formant 34.0 .1) ~A, formant: ~A, bank: ~A" i x0 x1))))

    (do ((c1 (make-formant 440.0 .75))
	 (c2 (make-formant 1000.0 .75))
	 (c3 (make-formant 34.0 .75))
	 (inputs (make-float-vector 3 1.0))
	 (c4 (make-formant-bank (vector (make-formant 440.0 .75)
					(make-formant 1000.0 .75)
					(make-formant 34.0 .75))))
	 (i 0 (+ i 1))
	 (x 1.0 0.0))
	((= i 40))
      (let ((x0 (+ (formant c1 x) (formant c2 x) (formant c3 x)))
	    (x1 (formant-bank c4 inputs)))
	(fill! inputs 0.0)
	(if (not (morally-equal? x0 x1))
	    (snd-display "many (formant 440.0 .75) + (formant 1000.0 .75) + (formant 34.0 .75) ~A, formant: ~A, bank: ~A" i x0 x1))))


    (do ((c1 (make-formant 440.0 .5))
	 (c2 (make-formant 1000.0 .2))
	 (c3 (make-formant 34.0 .1))
	 (inputs (make-float-vector 3 1.0))
	 (c4 (make-formant-bank (vector (make-formant 440.0 .5)
					(make-formant 1000.0 .2)
					(make-formant 34.0 .1))
				 #r(.5 .3 .4)))
	 (i 0 (+ i 1))
	 (x 1.0 0.0))
	((= i 40))
      (let ((x0 (+ (* .5 (formant c1 x)) (* .3 (formant c2 x)) (* .4 (formant c3 x))))
	    (x1 (formant-bank c4 inputs)))
	(fill! inputs 0.0)
	(if (not (morally-equal? x0 x1))
	    (snd-display "fb 3 with amps at ~A, formant: ~A, bank: ~A" i x0 x1))))

    (do ((c1 (make-formant 440.0 .9))
	 (c2 (make-formant 1000.0 .9))
	 (c3 (make-formant 34.0 .9))
	 (inputs (make-float-vector 3 1.0))
	 (c4 (make-formant-bank (vector (make-formant 440.0 .9)
					(make-formant 1000.0 .9)
					(make-formant 34.0 .9))
				#r(.5 .3 .4)))
	 (i 0 (+ i 1))
	 (x 1.0 0.0))
	((= i 40))
      (let ((x0 (+ (* .5 (formant c1 x)) (* .3 (formant c2 x)) (* .4 (formant c3 x))))
	    (x1 (formant-bank c4 inputs)))
	(fill! inputs 0.0)
	(if (not (morally-equal? x0 x1))
	    (snd-display "fb 3 with amps c1_c2 at ~A, formant: ~A, bank: ~A" i x0 x1))))

    (do ((c1 (make-formant 440.0 .9))
	 (c2 (make-formant 1000.0 .9))
	 (c3 (make-formant 34.0 .9))
	 (inputs (make-float-vector 3 1.0))
	 (c4 (make-formant-bank (vector (make-formant 440.0 .9)
					(make-formant 1000.0 .9)
					(make-formant 34.0 .9))
				#r(.5 .3 .4)))
	 (i 0 (+ i 1))
	 (x 1.0 0.0)
	 (y 1.0 0.0)
	 (z 1.0 0.0))
	((= i 40))
      (cond ((< i 10)
	     (let ((x0 (+ (* 0.5 (formant c1 x)) (* 0.3 (formant c2 y)) (* 0.4 (formant c3 z))))
		   (x1 (formant-bank c4 inputs)))
	       (fill! inputs 0.0)
	       (if (not (morally-equal? x0 x1))
		   (snd-display "fb 3(1) with amps c1_c2 at ~A, formant: ~A, bank: ~A" i x0 x1))))
	    ((< i 20)
	     (let ((x0 (+ (* 0.5 (formant c1 x)) (* 0.3 (formant c2 y)) (* 0.4 (formant c3 z))))
		   (x1 (formant-bank c4 0.0)))
	       (if (not (morally-equal? x0 x1))
		   (snd-display "fb 3(2) with amps c1_c2 at ~A, formant: ~A, bank: ~A" i x0 x1))))
	    ((< i 30)
	     (set! x 0.5)
	     (set! y 0.25)
	     (set! z 0.125)
	     (set! (inputs 0) x)
	     (set! (inputs 1) y)
	     (set! (inputs 2) z)
	     (let ((x0 (+ (* 0.5 (formant c1 x)) (* 0.3 (formant c2 y)) (* 0.4 (formant c3 z))))
		   (x1 (formant-bank c4 inputs)))
	       (if (not (morally-equal? x0 x1))
		   (snd-display "fb 3(3) with amps c1_c2 at ~A, formant: ~A, bank: ~A" i x0 x1))))
	    (else
	     (set! x 0.25)
	     (set! y 0.25)
	     (set! z 0.25)
	     (let ((x0 (+ (* 0.5 (formant c1 x)) (* 0.3 (formant c2 y)) (* 0.4 (formant c3 z))))
		   (x1 (formant-bank c4 0.25)))
	       (if (not (morally-equal? x0 x1))
		   (snd-display "fb 3(4) with amps c1_c2 at ~A, formant: ~A, bank: ~A" i x0 x1))))))

    (do ((c1 (make-formant 440.0 .9))
	 (c2 (make-formant 1000.0 .9))
	 (c3 (make-formant 34.0 .9))
	 (c4 (make-formant 340.0 .9))
	 (c5 (make-formant 2000.0 .9))
	 (inputs (make-float-vector 5 1.0))
	 (c6 (make-formant-bank (vector (make-formant 440.0 .9)
					(make-formant 1000.0 .9)
					(make-formant 34.0 .9)
					(make-formant 340.0 .9)
					(make-formant 2000.0 .9))))
	 (i 0 (+ i 1))
	 (x 1.0 0.0)
	 (y 1.0 0.0)
	 (z 1.0 0.0)
	 (a 1.0 0.0)
	 (b 1.0 0.0))
	((= i 40))
      (cond ((< i 10)
	     (let ((x0 (+ (formant c1 x) (formant c2 y) (formant c3 z) (formant c4 a) (formant c5 b)))
		   (x1 (formant-bank c6 inputs)))
	       (fill! inputs 0.0)
	       (if (not (morally-equal? x0 x1))
		   (snd-display "fb 5(1) no amps c1_c2 at ~A, formant: ~A, bank: ~A" i x0 x1))))
	    ((< i 20)
	     (let ((x0 (+ (formant c1 x) (formant c2 y) (formant c3 z) (formant c4 a) (formant c5 b)))
		   (x1 (formant-bank c6 0.0)))
	       (if (not (morally-equal? x0 x1))
		   (snd-display "fb 5(2) no amps c1_c2 at ~A, formant: ~A, bank: ~A" i x0 x1))))
	    ((< i 30)
	     (set! x 0.5)
	     (set! y 0.25)
	     (set! z 0.125)
	     (set! a 0.1)
	     (set! b 0.3)
	     (set! (inputs 0) x)
	     (set! (inputs 1) y)
	     (set! (inputs 2) z)
	     (set! (inputs 3) a)
	     (set! (inputs 4) b)
	     (let ((x0 (+ (formant c1 x) (formant c2 y) (formant c3 z) (formant c4 a) (formant c5 b)))
		   (x1 (formant-bank c6 inputs)))
	       (if (not (morally-equal? x0 x1))
		   (snd-display "fb 5(3) no amps c1_c2 at ~A, formant: ~A, bank: ~A" i x0 x1))))
	    (else
	     (set! x 0.25)
	     (set! y 0.25)
	     (set! z 0.25)
	     (set! a 0.25)
	     (set! b 0.25)
	     (let ((x0 (+ (formant c1 x) (formant c2 y) (formant c3 z) (formant c4 a) (formant c5 b)))
		   (x1 (formant-bank c6 0.25)))
	       (if (not (morally-equal? x0 x1))
		   (snd-display "fb 5(4) no amps c1_c2 at ~A, formant: ~A, bank: ~A" i x0 x1))))))
		      
    (set! *clm-srate* 44100)
    (when (file-exists? "jcrev-ip.snd")
      (with-sound (:reverb jc-reverb) (outa 0 .1) (outa 0 .5 *reverb*))
      (let ((s1 (find-sound "test.snd"))
	    (s2 (open-sound "jcrev-ip.snd")))
	(if (not (= (channel-distance s1 0 s2 0) 0.0))
	    (snd-display "jcrev ip: ~A" (channel-distance s1 0 s2 0)))
	(close-sound s1)
	(close-sound s2)))
    
    (when (file-exists? "nrev-ip.snd")
      (with-sound (:reverb nrev) (outa 0 .1) (outa 0 .5 *reverb*))
      (let ((s1 (find-sound "test.snd"))
	    (s2 (open-sound "nrev-ip.snd")))
	(if (not (= (channel-distance s1 0 s2 0) 0.0))
	    (snd-display "nrev ip: ~A" (channel-distance s1 0 s2 0)))
	(close-sound s1)
	(close-sound s2)))
    
    (when (file-exists? "freeverb-ip.snd")
      (with-sound (:reverb freeverb :reverb-data '(:output-gain 3.0)) (outa 0 .5 *reverb*))
      (let ((s1 (find-sound "test.snd"))
	    (s2 (open-sound "freeverb-ip.snd")))
	(if (not (= (channel-distance s1 0 s2 0) 0.0))
	    (snd-display "freeverb ip: ~A" (channel-distance s1 0 s2 0)))
	(close-sound s1)
	(close-sound s2)))
    
    (let ()
      (defgenerator (old-rxyk!sin
		     :make-wrapper (lambda (g)
				     (set! (g 'frequency) (hz->radians (g 'frequency)))
				     g))
	(frequency 0.0) (ratio 1.0) (r 0.5) (angle 0.0) fm)
      
      (define* (old-rxyk!sin gen (fm 0.0))
	(set! (gen 'fm) fm)
	(with-let gen
	  (let* ((x angle)
		 (y (* x ratio)))
	    (set! angle (+ x fm frequency))
	    (/ (* (exp (* r (cos y)))
		  (sin (+ x (* r (sin y)))))
	       (exp (abs r))))))
      
      (defgenerator (old-rxyk!cos
		     :make-wrapper (lambda (g)
				     (set! (g 'frequency) (hz->radians (g 'frequency)))
				     (set! (g 'ar) (/ 1.0 (exp (abs (g 'r)))))
				     g))
	(frequency 0.0) (ratio 1.0) (r 0.5) (angle 0.0) fm ar)
      
      (define* (old-rxyk!cos gen (fm 0.0))
	(set! (gen 'fm) fm)
	(with-let gen
	  (let* ((x angle)
		 (y (* x ratio)))
	    (set! angle (+ x fm frequency))
	    (* (exp (* r (cos y)))
	       (cos (+ x (* r (sin y))))
	       ar))))
      
      (define-macro (define-memoized name&arg . body)
	(let ((arg (cadr name&arg))
	      (memo (gensym "memo")))
	  `(define ,(car name&arg)
	     (let ((,memo (make-hash-table)))
	       (lambda (,arg)
		 (or (,memo ,arg)                             ; check for saved value
		     (set! (,memo ,arg) (begin ,@body)))))))) ; set! returns the new value
      
      (define-memoized (kfactorial n)
	(define (k n m)
	  (if (<= n m)
	      n
	      (* (k n (* 2 m))
		 (k (- n m) (* 2 m)))))
	(if (zero? n)
	    1
	    (k n 1)))
      
      (define (rxyk!cos-direct x y a terms)
	(do ((sum 0.0)
	     (k 0 (+ k 1)))
	    ((= k terms) (/ sum (exp (abs a))))
	  (set! sum (+ sum (* (/ (expt a k) (kfactorial k))
			      (cos (+ x (* k y))))))))
      
      (define (rxyk!sin-direct x y a terms)
	(do ((sum 0.0)
	     (k 0 (+ k 1)))
	    ((= k terms) (/ sum (exp (abs a))))
	  (set! sum (+ sum (* (/ (expt a k) (kfactorial k))
			      (sin (+ x (* k y))))))))
    
      
      (let ((g1 (make-rxyk!cos 100.0))
	    (g2 (make-old-rxyk!cos 100.0))
	    (x3 (hz->radians 100.0)))
	(do ((i 0 (+ i 1))
	     (x 0.0 (+ x x3)))
	    ((= i 100))
	  (let ((v1 (rxyk!cos g1))
		(v2 (old-rxyk!cos g2))
		(v3 (rxyk!cos-direct x x 0.5 12)))
	    (if (or (> (abs (- v1 v2)) 1e-6)
		    (> (abs (- v1 v3)) 1e-6))
		(format () ";rxyk!cos ~A ~A: ~A ~A ~A -> ~A~%" i x v1 v2 v3 (max (abs (- v1 v2)) (abs (- v1 v3))))))))
      
      (let ((g1 (make-rxyk!sin 100.0))
	    (g2 (make-old-rxyk!sin 100.0))
	    (x3 (hz->radians 100.0)))
	(do ((i 0 (+ i 1))
	     (x 0.0 (+ x x3)))
	    ((= i 100))
	  (let ((v1 (rxyk!sin g1))
		(v2 (old-rxyk!sin g2))
		(v3 (rxyk!sin-direct x x 0.5 12)))
	    (if (or (> (abs (- v1 v2)) 1e-6)
		    (> (abs (- v1 v3)) 1e-6))
		(format () ";rxyk!sin ~A ~A: ~A ~A ~A -> ~A~%" i x v1 v2 v3 (max (abs (- v1 v2)) (abs (- v1 v3))))))))
      
      (let ((g1 (make-rxyk!cos 100.0 :ratio 2.0 :r 0.25))
	    (g2 (make-old-rxyk!cos 100.0 :ratio 2.0 :r 0.25)))
	(do ((i 0 (+ i 1)))
	    ((= i 100))
	  (let ((v1 (rxyk!cos g1))
		(v2 (old-rxyk!cos g2)))
	    (if (> (abs (- v1 v2)) 1e-6)
		(format () ";rxyk!cos ratio:2: ~A: ~A ~A -> ~A~%" i v1 v2 (abs (- v1 v2)))))))
      
      (let ((g1 (make-rxyk!sin 100.0 :ratio 2.0 :r 0.25))
	    (g2 (make-old-rxyk!sin 100.0 :ratio 2.0 :r 0.25)))
	(do ((i 0 (+ i 1)))
	    ((= i 100))
	  (let ((v1 (rxyk!sin g1))
		(v2 (old-rxyk!sin g2)))
	    (if (> (abs (- v1 v2)) 1e-6)
		(format () ";rxyk!sin ratio:2: ~A: ~A ~A -> ~A~%" i v1 v2 (abs (- v1 v2)))))))
      
      (let ((g1 (make-rxyk!cos 100.0 :ratio 2.0 :r 0.25))
	    (o1 (make-oscil 400.0))
	    (g2 (make-old-rxyk!cos 100.0 :ratio 2.0 :r 0.25))
	    (o2 (make-oscil 400.0)))
	(do ((i 0 (+ i 1)))
	    ((= i 100))
	  (let ((v1 (rxyk!cos g1 (oscil o1)))
		(v2 (old-rxyk!cos g2 (oscil o2))))
	    (if (> (abs (- v1 v2)) 1e-6)
		(format () ";rxyk!cos fm ~A: ~A ~A -> ~A~%" i v1 v2 (abs (- v1 v2)))))))
      
      (let ((g1 (make-rxyk!sin 100.0 :ratio 2.0 :r 0.25))
	    (o1 (make-oscil 400.0))
	    (g2 (make-old-rxyk!sin 100.0 :ratio 2.0 :r 0.25))
	    (o2 (make-oscil 400.0)))
	(do ((i 0 (+ i 1)))
	    ((= i 100))
	  (let ((v1 (rxyk!sin g1 (oscil o1)))
		(v2 (old-rxyk!sin g2 (oscil o2))))
	    (if (> (abs (- v1 v2)) 1e-6)
		(format () ";rxyk!sin fm ~A: ~A ~A -> ~A~%" i v1 v2 (abs (- v1 v2))))))))

    (let ()
      (defgenerator one-pole-allpass coeff input x1 y1)
      
      (define (one-pole-allpass gen input)
	(set! (gen 'input) input)
	(with-let gen
	  (set! y1 (+ x1 (* coeff (- input y1))))
	  (set! x1 input)
	  y1))
      
      (defgenerator one-pole-allpass-bank coeff input x1 y1 x2 y2 x3 y3 x4 y4 x5 y5 x6 y6 x7 y7 x8 y8) 
      
      (define (one-pole-allpass-bank gen input)
	(set! (gen 'input) input)
	(with-let gen
	  (set! y1 (+ x1 (* coeff (- input y1))))
	  (set! x1 input)
	  
	  (set! y2 (+ x2 (* coeff (- y1 y2))))
	  (set! x2 y1)
	  
	  (set! y3 (+ x3 (* coeff (- y2 y3))))
	  (set! x3 y2)
	  
	  (set! y4 (+ x4 (* coeff (- y3 y4))))
	  (set! x4 y3)
	  
	  (set! y5 (+ x5 (* coeff (- y4 y5))))
	  (set! x5 y4)
	  
	  (set! y6 (+ x6 (* coeff (- y5 y6))))
	  (set! x6 y5)
	  
	  (set! y7 (+ x7 (* coeff (- y6 y7))))
	  (set! x7 y6)
	  
	  (set! y8 (+ x8 (* coeff (- y7 y8))))
	  (set! x8 y7)
	  y8))
      
      (let ((o1 (make-one-pole-all-pass 1 .5))
	    (o2 (make-one-pole-allpass .5)))
	(do ((i 0 (+ i 1))
	     (impulse 1.0 0.0))
	    ((= i 30))
	  (let ((v1 (one-pole-all-pass o1 impulse))
		(v2 (one-pole-allpass o2 impulse)))
	    (if (> (abs (- v1 v2)) 1e-6)
		(format () ";one-pole-all-pass (1) ~A: ~A ~A -> ~A~%" i v1 v2 (abs (- v1 v2)))))))
      
      (let ((o1 (make-one-pole-all-pass 8 .5))
	    (o2 (make-one-pole-allpass-bank .5)))
	(do ((i 0 (+ i 1))
	     (impulse 1.0 0.0))
	    ((= i 30))
	  (let ((v1 (one-pole-all-pass o1 impulse))
		(v2 (one-pole-allpass-bank o2 impulse)))
	    (if (> (abs (- v1 v2)) 1e-6)
		(format () ";one-pole-all-pass (1) ~A: ~A ~A -> ~A~%" i v1 v2 (abs (- v1 v2)))))))
      )

    (let-temporarily ((*clm-srate* 44100))
      (do ((pe (make-pulsed-env '(0 0 1 1 2 0) .0004 2205))
	   (v (make-float-vector 100))
	   (i 0 (+ i 1)))
	  ((= i 100)
	   (if (not (mus-arrays-equal? v #r(0.000 0.125 0.250 0.375 0.500 0.625 0.750 0.875 1.000 0.875 0.750 0.625 0.500 0.375 0.250 0.125 0.000 0.000 0.000 0.000 
					    0.000 0.125 0.250 0.375 0.500 0.625 0.750 0.875 1.000 0.875 0.750 0.625 0.500 0.375 0.250 0.125 0.000 0.000 0.000 0.000 
					    0.000 0.125 0.250 0.375 0.500 0.625 0.750 0.875 1.000 0.875 0.750 0.625 0.500 0.375 0.250 0.125 0.000 0.000 0.000 0.000 
					    0.000 0.125 0.250 0.375 0.500 0.625 0.750 0.875 1.000 0.875 0.750 0.625 0.500 0.375 0.250 0.125 0.000 0.000 0.000 0.000 
					    0.000 0.125 0.250 0.375 0.500 0.625 0.750 0.875 1.000 0.875 0.750 0.625 0.500 0.375 0.250 0.125 0.000 0.000 0.000 0.000)))
	       (snd-display "pulsed-env: ~A" v)))
	(set! (v i) (pulsed-env pe))))

    (for-each copy-test 
      (vector (make-oscil 330.0)
	      (make-ncos 440.0 10)
	      (make-nsin 440.0 10)
	      (make-nrxycos 330.0 0.9 10)
	      (make-nrxysin 330.0 0.9 10)
	      (make-rxyk!cos 440.0)
	      (make-rxyk!sin 440.0)
	      (make-sawtooth-wave 100)
	      (make-pulse-train 100)
	      (make-triangle-wave 100)
	      (make-square-wave 100)
	      (make-one-zero .1 .2)
	      (make-one-pole .1 .2)
	      (make-two-zero .9 .1 .2)
	      (make-two-pole .9 .1 .2)
	      (make-polywave 440.0 '(1 .5 2 .5))
	      (make-polyshape 440.0 :coeffs (partials->polynomial '(1 1.0)))
	      (make-oscil-bank #r(100 200 300) #r(0.0 1.0 2.0) #r(0.5 0.25 0.125))
	      (make-delay 10)
	      (make-comb .7 10)
	      (make-notch .7 10)
	      (make-all-pass .8 .7 10)
	      (make-moving-average 10)
	      (make-moving-norm 10)
	      (make-moving-max 10)
	      (make-comb-bank (vector (make-comb 0.742 99) (make-comb 0.733 49) (make-comb 0.715 53)))
	      (make-all-pass-bank (vector (make-all-pass -0.700 0.700 51) (make-all-pass -0.700 0.700  33) (make-all-pass -0.700 0.700 11)))
	      (make-filtered-comb .4 5 :filter (make-one-zero .3 .7))
	      (make-filtered-comb-bank (vector (make-filtered-comb .5 3) (make-filtered-comb .2 10) (make-filtered-comb -.7 11)))
	      (make-formant 1200.0 0.9)
	      (make-firmant 1200.0 0.9)
	      (make-fir-filter 4 #r(0.4 0.3 0.2 0.1))
	      (make-iir-filter 4 #r(0.4 0.3 0.2 0.1))
	      (make-filter 4 #r(0.4 0.3 0.2 0.1))
	      (make-one-pole-all-pass 8 .5)
	      (make-readin "oboe.snd")
	      (make-env '(0 0 1 1) :length 10)
	      (make-pulsed-env '(0 0 1 1) .001 1000)))
	      
    ;; formant-bank isn't really testing equality yet
    
    (let* ((o (make-rand 100.0))
	   (p (copy o)))
      (if (not (equal? o p))
	  (snd-display "rand copy ~A != ~A~%" o p)))
    
    (let* ((o (make-rand-interp 100.0))
	   (p (copy o)))
      (if (not (equal? o p))
	  (snd-display "rand-interp copy ~A != ~A~%" o p)))
    
    (let* ((v1 (make-float-vector 10 .1))
	   (o (make-rand 100.0 :distribution v1))
	   (p (copy o)))
      (if (not (equal? o p))
	  (snd-display "rand+dist copy ~A != ~A~%" o p))
      
      (let* ((o (make-rand-interp 100.0 :distribution v1))
	     (p (copy o)))
	(if (not (equal? o p))
	    (snd-display "rand-interp+dist copy ~A != ~A~%" o p))))
    
    (let* ((o (make-nssb 440.0))
	   (p (copy o)))
      (if (not (equal? o p))
	  (snd-display "nssb copy ~A != ~A~%" o p))
      (nssb o 1.0)
      (if (equal? o p)
	  (snd-display "nssb copy/run ~A == ~A~%" o p)))
    
    (let* ((o (make-wave-train 100 :wave #r(0.0 0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9)))
	   (p (copy o)))
      (if (not (equal? o p))
	  (snd-display "wave-train copy ~A != ~A~%" o p)))
    
    (let* ((o (make-table-lookup 440.0 :wave #r(0.0 0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9)))
	   (p (copy o)))
      (if (not (equal? o p))
	  (snd-display "table-lookup copy ~A != ~A~%" o p))
      (table-lookup o 1.0)
      (if (equal? o p)
	  (snd-display "table-lookup run ~A == ~A~%" o p)))

    ;; object->let
    (for-each 
     object->let
     (vector 
      (make-polywave 440.0 :partials '(1 1) :type mus-chebyshev-first-kind)
      (make-polyshape 440.0 :coeffs (partials->polynomial '(1 1)))
      (make-move-sound (list 0 1000 1 0
			     (make-delay 32) 
			     (make-env '(0 0 1 1) :length 1001) 
			     (make-env '(0 0 1 1) :length 1001)
			     (vector (make-delay 32)) 
			     (vector (make-env '(0 0 1 1) :length 1001)) 
			     #f
			     (vector 0 1)) (make-float-vector 100))
      (make-phase-vocoder #f 512 4 256 1.0)
      (make-phase-vocoder (lambda (dir) (next-sample reader))
			  512 4 256 1.0
			  (lambda (v infunc)
			    (set! incalls (+ incalls 1)))
			  #f ;no change to edits
			  (lambda (v)
			    (set! outcalls (+ outcalls 1))
			    0.0))
      (make-ssb-am 100.0 8)
      (make-sample->file "fmv.snd" 2 mus-lshort mus-riff)
      (make-frample->file "fmv.snd" 2 mus-lshort mus-riff)
      (make-locsig)
      (make-locsig :reverb .1 :distance 2.0 :degree 46)
      (make-granulate :expansion .5 :scaler .4 :ramp .3)
      (make-rand 100)
      (make-rand-interp 100 :amplitude .1)
      (make-rand-interp 100 :amplitude .1 :envelope '(0 0 1 1))
      (make-rand 100 :amplitude .1 :envelope '(0 0 1 1) :size 8)
      (make-one-pole-all-pass 8 .5)
      (make-pulsed-env '(0 0 1 1 2 0) .0004 2205)
      (make-convolve :filter #r(0 1 2) :input (lambda (dir) 1.0))
      (make-env '(0 0 1 1) :length 11 :scaler .5)
      (make-env '(0 0 1 1) :length 11 :scaler .1 :offset .1 :base 3.0)
      (make-src :srate .5)
      (make-src :srate 2.0 :input (make-readin "oboe.snd" 0 10000))
      (make-file->sample "oboe.snd")
      (make-file->frample"4.aiff")
      (make-readin :file "oboe.snd")
      (make-readin :start 123 :channel 2 :file "4.aiff")
      (make-comb-bank (vector (make-comb .5 3) (make-comb .2 4)))
      (make-all-pass-bank (vector (make-all-pass -.5 .5 3) (make-all-pass -.2 .2 10) (make-all-pass -.7 .1 11)))
      (make-filtered-comb-bank (vector (make-filtered-comb .5 3)))
      (make-wave-train 440.0 0.0 #r(0 0 0))
      (make-table-lookup :wave #r(0 1 2 1 0))
      (make-moving-max 3)
      (make-moving-average 3)
      (make-moving-norm 3 :scaler 0.5)
      (make-filtered-comb .4 5 :filter (make-one-zero .3 .7))
      (make-all-pass .1 .9 3)
      (make-delay 3)
      (make-notch :initial-contents #r(0 1 2 3) :scaler .1 :type 3)
      (make-comb :size 3 :scaler .1)
      (make-formant 1000 .5)
      (make-firmant 1000 .5)
      (make-formant-bank (vector (make-formant 440.0 .5)))
      (make-formant-bank (vector (make-formant 440.0 .5) (make-formant 1000.0 .2) (make-formant 34.0 .1)) #r(.5 .3 .4))
      (make-oscil 440)
      (let ((o (make-oscil 440))) (oscil o) o)
      (make-nsin 100.0 3)
      (make-nsin :n 4 :frequency 100)
      (make-ncos 100.0 3)
      (make-nrxysin :n 3 :frequency 100 :r .1)
      (make-nrxysin :n 4 :frequency 100 :ratio .1)
      (make-nrxycos :n 4 :frequency 100 :ratio .1)
      (make-oscil-bank #r(0.0 0.0) #r(0.0 0.0) #r(0.0 0.0))
      (make-oscil-bank #r(100 200 300) #r(0.0 1.0 2.0) #r(0.5 0.25 0.125))
      (make-rxyk!sin :frequency 100)
      (make-rxyk!cos :frequency 100 :r .1 :ratio .6)
      (make-asymmetric-fm 100)
      (make-asymmetric-fm 100 :r .3 :ratio 2.0)
      (make-square-wave 100 :amplitude .5 :initial-phase 1.0)
      (make-sawtooth-wave 100 :amplitude .25)
      (make-triangle-wave)
      (make-pulse-train 100)
      (make-fir-filter :order 3 :xcoeffs #r(1.0 0.5 0.25))
      (make-iir-filter :order 4 :ycoeffs #r(1.0 0.5 0.25 -0.1))
      (make-filter 3 #r(1.0 0.5 0.2) #r(0.2 0.3 0.4))
      (make-one-zero .3 .2)
      (make-one-pole .3 .2)
      (make-two-zero :frequency 1000 :radius .5)
      (make-two-pole :frequency 1000 :radius .5)
      ))))



;;; ---------------- test 9: mix ----------------

(define (snd_test_9)
  
  (when with-gui
    (do ((test-ctr 0 (+ 1 test-ctr)))
	((= test-ctr tests))
      
      (let ((ind (new-sound "test.snd" :size 10)))
	(let ((v #r(.1 .2 .3)))
	  (let ((id (mix-float-vector v 0)))
	    (let ((nv (channel->float-vector)))
	      (if (not (mus-arrays-equal? nv #r(.1 .2 .3 0 0 0 0 0 0 0)))
		  (snd-display "mix v at 0: ~A" nv)))
	    (let ((eds (edit-tree ind 0)))
	      (if (not (feql eds '((0 0 0 2 0.0 0.0 0.0 3) (3 0 3 9 0.0 0.0 0.0 2) (10 -2 0 0 0.0 0.0 0.0 0))))
		  (snd-display "mix v at 0 eds: ~A" eds)))
	    (if (not (mix? id))
		(snd-display "mix v at 0 id from mix?: ~A" id))
	    (if (fneq (mix-amp id) 1.0) (snd-display "mix v at 0 amp: ~A" (mix-amp id)))
	    (if (fneq (mix-speed id) 1.0) (snd-display "mix v at 0 speed: ~A" (mix-speed id)))
	    (if (not (= (mix-sync id) 0)) (snd-display "mix v at 0 sync: ~A" (mix-sync id)))
	    (if (not (null? (mix-amp-env id))) (snd-display "mix v at 0 amp-env: ~A" (mix-amp-env id)))
	    (if (not (= (mix-position id) 0)) (snd-display "mix v at 0 beg: ~A" (mix-position id)))
	    (if (not (= (mix-length id) 3)) (snd-display "mix v at 0 length: ~A" (mix-length id)))
	    (if (not (string=? (mix-name id) "")) (snd-display "mix v at 0 name: ~A" (mix-name id)))
	    (if (not (null? (mix-properties id))) (snd-display "mix v at 0 properties: ~A" (mix-properties id)))
	    (if (not (equal? (mix-color id) *mix-color*)) (snd-display "mix v at 0 color: ~A" (mix-color id)))
	    (if (not (= (mix-tag-y id) 0)) (snd-display "mix v at 0 tag-y: ~A" (mix-tag-y id)))
	    (let ((sf (make-mix-sampler id))
		  (data (make-float-vector 10)))
	      (do ((i 0 (+ i 1)))
		  ((= i 10))
		(set! (data i) (read-mix-sample sf)))
	      (if (not (mus-arrays-equal? data (channel->float-vector)))
		  (snd-display "mix v at 0 read mix samples: ~A" data))
	      (if (not (sampler-at-end? sf)) (snd-display "mix v at 0 reader not at end?"))
	      (free-sampler sf))
	    (if (not (equal? (mixes ind 0) (list id))) (snd-display "mix v at 0 mixes: ~A" (mixes ind 0)))
	    (if (not (equal? (mix-home id) (list ind 0 #f 0))) (snd-display "mix v at 0 home: ~A" (mix-home id)))
	    (undo))
	  (mix-float-vector v 8)
	  (if (not (= (framples ind 0) 11)) (snd-display "mix v at 8 new len: ~A" (framples ind 0)))
	  (let ((nv (channel->float-vector)))
	    (if (not (mus-arrays-equal? nv #r(0 0 0 0 0 0 0 0 .1 .2 .3)))
		(snd-display "mix v at 8: ~A" nv)))
	  (undo)
	  (mix-float-vector v 3)
	  (if (not (= (framples ind 0) 10)) (snd-display "mix v at 3 new len: ~A" (framples ind 0)))
	  (let ((nv (channel->float-vector)))
	    (if (not (mus-arrays-equal? nv #r(0 0 0 .1 .2 .3 0 0 0 0)))
		(snd-display "mix v at 3: ~A" nv)))
	  (undo))
	(let ((v (make-float-vector 20 .5)))
	  (mix-float-vector v 0)
	  (if (not (= (framples ind 0) 20)) (snd-display "mix v20 at 0 new len: ~A" (framples ind 0))))
	(close-sound ind))
      
      (let ((ind (new-sound "test.snd" :size 100000)))
	(let ((id (car (mix "oboe.snd" 0))))
	  (if (not (mix? id))
	      (snd-display "mix oboe at 0 id from mix?: ~A" id))
	  (if (fneq (mix-amp id) 1.0) (snd-display "mix oboe at 0 amp: ~A" (mix-amp id)))
	  (if (fneq (mix-speed id) 1.0) (snd-display "mix oboe at 0 speed: ~A" (mix-speed id)))
	  (if (not (= (mix-sync id) 0)) (snd-display "mix oboe at 0 sync: ~A" (mix-sync id)))
	  (if (not (null? (mix-amp-env id))) (snd-display "mix oboe at 0 amp-env: ~A" (mix-amp-env id)))
	  (if (not (= (mix-position id) 0)) (snd-display "mix oboe at 0 beg: ~A" (mix-position id)))
	  (if (not (= (mix-length id) 50828)) (snd-display "mix oboe at 0 length: ~A" (mix-length id)))
	  (if (not (string=? (mix-name id) "")) (snd-display "mix oboe at 0 name: ~A" (mix-name id)))
	  (if (not (null? (mix-properties id))) (snd-display "mix oboe at 0 properties: ~A" (mix-properties id)))
	  (if (not (equal? (mix-color id) *mix-color*)) (snd-display "mix oboe at 0 color: ~A" (mix-color id)))
	  (if (not (= (mix-tag-y id) 0)) (snd-display "mix oboe at 0 tag-y: ~A" (mix-tag-y id)))
	  
	  (if (fneq (maxamp ind 0) .14724) (snd-display "mix oboe maxamp: ~A" (maxamp ind 0)))
	  (if (not (equal? (mixes ind 0) (list id))) (snd-display "mix oboe at 0 mixes: ~A" (mixes ind 0)))
	  (if (not (equal? (mix-home id) (list ind 0 "/home/bil/cl/oboe.snd" 0))) (snd-display "mix oboe at 0 home: ~A" (mix-home id))))
	(undo)
	(mix "oboe.snd" 70000)
	(if (not (= (framples ind 0) 120828)) ;(+ 70000 50828)
	    (snd-display "mix oboe at 70k framples: ~A" (framples ind 0)))
	(close-sound ind))
      
      (let ((ind (new-sound "test.snd" :size 10))
	     (v #r(.1 .2 .3)))
	(let ((id (mix-float-vector v 0)))
	  (scale-by 2.0)
	  (if (not (mix? id)) (snd-display "scaled (2) mix not active?"))
	  (let ((nv (channel->float-vector)))
	    (if (not (mus-arrays-equal? nv (float-vector-scale! #r(.1 .2 .3 0 0 0 0 0 0 0) 2.0)))
		(snd-display "mix v at 0 scale-by 2: ~A" nv)))
	  (if (fneq (mix-amp id) 2.0) (snd-display "mix then scale mix amp: ~A" (mix-amp id)))
	  (undo)
	  (delete-sample 1)
	  (if (not (mix? id)) (snd-display "delete hit mix: ~A" (mix? id)))
	  (let ((nv (channel->float-vector)))
	    (if (not (mus-arrays-equal? nv #r(.1 .3 0 0 0 0 0 0 0)))
		(snd-display "mix v at 0 delete .2: ~A" nv)))
	  (revert-sound ind))
	(let ((id (mix-float-vector v 0)))
	  (delete-sample 7)
	  (reverse-sound ind 0)
	  (if (not (mix? id)) (snd-display "reversed mix: ~A" (mix? id)))
	  (let ((nv (channel->float-vector)))
	    (if (not (mus-arrays-equal? nv (reverse! (float-vector .1 .2 .3 0 0 0 0 0 0))))
		(snd-display "mix v at 0 reversed: ~A" nv)))
	  (undo)
	  (if (not (mix? id)) (snd-display "revert reverse mix: ~A" (mix? id)))
	  (map-channel (lambda (y) .1))
	  (if (not (mix? id)) (snd-display "clobbered mix: ~A" (mixes)))
	  (scale-by 2.0)
	  (let ((id (mix-float-vector v 0)))
	    (if (not (mix? id)) (snd-display "mix on scale (2) not active?"))
	    (scale-by 3.0)
	    (if (not (mix? id)) (snd-display "scaled (3) mix not active?"))
	    (let ((nv (channel->float-vector)))
	      (if (not (mus-arrays-equal? nv (float-vector-scale! (float-vector-add! (make-float-vector 9 .2) #r(.1 .2 .3)) 3.0)))
		  (snd-display "mix v at 0 scale-by 2 and 3: ~A" nv))))
	  (revert-sound ind)
	  (map-channel (lambda (y) 1.0))
	  (env-channel '(0 0 1 1 2 0) 0 11)
	  (let ((v #r(.1 .2 .3)))
	    (mix-float-vector v 3)
	    (let ((nv (channel->float-vector)))
	      (if (not (mus-arrays-equal? nv #r(0.0 0.200 0.400 0.700 1.000 1.300 0.800 0.600 0.400 0.200)))
		  (snd-display "mix v at 3 after env: ~A" nv))))
	  (close-sound ind)))
      
      (let* ((ind (new-sound "test.snd" :size 100))
	     (v #r(.1 .2 .3))
	     (id (mix-float-vector v 10)))
	(pad-channel 0 10)
	(if (not (mix? id)) (snd-display "padded mix not active?"))
	(if (not (= (mix-position id) 20)) (snd-display "after pad mix pos: ~A" (mix-position id)))
	(set! (mix-sync id) 2)
	(if (not (= (mix-sync id) 2)) (snd-display "set mix sync 2: ~A" (mix-sync id)))
	(if (and full-test (< (mix-sync-max) 2)) (snd-display "mix-sync-max: ~A" (mix-sync-max)))
	(pad-channel 50 10)
	(if (not (mix? id)) (snd-display "padded 50 mix not active?"))
	(if (not (= (mix-position id) 20)) (snd-display "after pad 50 mix pos: ~A" (mix-position id)))
	(undo 1)
	(let ((id1 (mix-float-vector v 22))
	      (id2 (mix-float-vector v 21)))
	  (let ((vals (channel->float-vector 18 10)))
	    (if (not (mus-arrays-equal? vals #r(0.0 0.0 0.100 0.300 0.600 0.500 0.300 0.0 0.0 0.000)))
		(snd-display "mix 3 vs: ~A" vals)))
	  (if (not (mix? id)) (snd-display "mix 3vs 1 not active?"))
	  (if (not (mix? id1)) (snd-display "mix 3vs 2 not active?"))
	  (if (not (mix? id2)) (snd-display "mix 3vs 3 not active?"))
	  (set! (mix-position id) 10)
	  (let ((vals (channel->float-vector 18 10)))
	    (if (not (mus-arrays-equal? vals #r(0.0 0.0 0.0 0.100 0.300 0.500 0.300 0.0 0.0 0.000)))
		(snd-display "mix 3 vs then move first: ~A" vals))
	    (set! (mix-position id2) 30))
	  (let ((vals (channel->float-vector 18 10)))
	    (if (not (mus-arrays-equal? vals #r(0.0 0.0 0.0 0.0 0.100 0.200 0.300 0.0 0.0 0.000)))
		(snd-display "mix 3 vs then move 2: ~A" vals)))
	  (scale-by 2.0)
	  (if (not (mix? id)) (snd-display "mix 3vs 1 scl not active?"))
	  (if (not (mix? id1)) (snd-display "mix 3vs 2 scl not active?"))
	  (if (not (mix? id2)) (snd-display "mix 3vs 3 scl not active?"))
	  (let ((vals (channel->float-vector 18 10)))
	    (if (not (mus-arrays-equal? vals #r(0.0 0.0 0.0 0.0 0.200 0.400 0.600 0.0 0.0 0.000)))
		(snd-display "mix 3 vs then move 2 scl: ~A" vals)))
	  (delete-sample 15)
	  (if (not (mix? id)) (snd-display "mix 3vs 1 scl del not active?"))
	  (if (not (mix? id1)) (snd-display "mix 3vs 2 scl del not active?"))
	  (if (not (mix? id2)) (snd-display "mix 3vs 3 scl del not active?"))
	  (if (not (= (mix-position id) 10)) (snd-display "mix 3vs etc pos: ~A" (mix-position id)))
	  (if (not (= (mix-position id1) 21)) (snd-display "mix 3vs etc pos 1: ~A" (mix-position id1)))
	  (if (not (= (mix-position id2) 29)) (snd-display "mix 3vs etc pos 2: ~A" (mix-position id2))))
	(close-sound ind))
      
      (let* ((ind (new-sound "test.snd" :size 15))
	     (id (mix-float-vector (make-float-vector 11 1.0) 2)))
	(set! (mix-amp-env id) '(0 0 1 1))
	(let ((vals (channel->float-vector)))
	  (if (not (mus-arrays-equal? vals #r(0 0 0 .1 .2 .3 .4 .5 .6 .7 .8 .9 1.0 0 0)))
	      (snd-display "ramp mix amp env: ~A" vals)))
	(set! (mix-amp-env id) #f)
	(if (pair? (mix-amp-env id)) (snd-display "set mix-amp-env to null: ~A" (mix-amp-env id)))
	(set! (mix-speed id) 0.5)
	(if (not (= (framples) 24)) (snd-display "mix speed lengthens 24: ~A" (framples)))
	(set! (mix-speed id) 1.0)
	(let ((vals (channel->float-vector)))
	  (if (not (mus-arrays-equal? vals #r(0 0 1 1 1 1 1 1 1 1 1 1 1 0 0 0 0 0 0 0 0 0 0 0)))
	      (snd-display "return to mix original index: ~A" vals)))
	(set! (mix-amp-env id) '(0 0 1 1 2 1 3 0))
	(set! (mix-speed id) 0.5)
	(set! (mix-amp-env id) #f)
	(set! (mix-speed id) 1.0)
	(let ((vals (channel->float-vector)))
	  (if (not (mus-arrays-equal? vals #r(0 0 1 1 1 1 1 1 1 1 1 1 1 0 0 0 0 0 0 0 0 0 0 0)))
	      (snd-display "return again to mix original index: ~A" vals)))
	(close-sound ind))
      
      (let ((id (open-sound "oboe.snd")))
	(make-selection 1000 2000 id 0)
	(let ((mix-id (car (mix-selection 3000 id 0))))
	  (set! (mix-amp mix-id) .5)
	  (if (fneq (mix-amp mix-id) .5)
	      (snd-display "mix-amp .5: ~A" (mix-amp mix-id))))
	(scale-by .5)
	(undo)
	(close-sound id))
      (set! *print-length* 30)
      
      (let* ((ind (open-sound "2.snd"))
	     (md (car (mix "1a.snd" 1000 0 ind 1 #t))))
	(if (fneq (maxamp ind 1) .1665) (snd-display "maxamp after mix into chan 2: ~A" (maxamp ind 1)))
	(set! (mix-amp md) 0.0)
	(if (not (and (equal? (edits ind 0) '(0 0))
		      (equal? (edits ind 1) '(2 0))))
	    (snd-display "mix into chan2 zeroed: ~A ~A" (edits ind 0) (edits ind 1)))
	(if (fneq (maxamp ind 1) .066) (snd-display "maxamp after mix zeroed into chan 2: ~A" (maxamp ind 1)))
	(set! (mix-amp md) 0.5)
	(if (fneq (maxamp ind 1) .116) (snd-display "maxamp after mix 0.5 into chan 2: ~A" (maxamp ind 1)))
	(set! (mix-speed md) 2.0)
	(if (fneq (/ (mix-length md) (mus-sound-framples "1a.snd")) 0.5)
	    (snd-display "mix srate chan 2: ~A ~A" (mix-length md) (mus-sound-framples "1a.snd")))
	(update-time-graph)
	(set! (mix-speed md) 0.5)
	(update-time-graph)
	(set! (mix-amp md) 1.0)
	(if (fneq (maxamp ind 1) .166)
	    (snd-display "non-sync mix-speed maxamp: ~A" (maxamp ind 1)))
	(set! (mix-amp-env md) '(0 0 1 1 2 0))
	(update-time-graph)
	(set! (mix-speed md) 1.0)
	(update-time-graph)
	(revert-sound ind)
	(set! (sync ind) 1)
	(let ((m0 (maxamp ind 0))
	      (m1 (maxamp ind 1))
	      (len (framples ind 0)))
	  (set! md (mix "2.snd" 0 #t)) ; should double both chans, no len change
	  (if (or (not (= (framples ind 0) len))
		  (fneq (maxamp ind 0) (* 2 m0))
		  (fneq (maxamp ind 1) (* 2 m1)))
	      (snd-display "mix twice syncd: 0: ~A -> ~A, m1: ~A -> ~A, len: ~A -> ~A"
			   m0 (maxamp ind 0) m1 (maxamp ind 1) len (framples ind 0))))
	(set! (hook-functions mix-release-hook) ())
	(close-sound ind))
      
      (let ((ind (new-sound "fmv.snd" 1 22050 mus-ldouble mus-next "mix tests")))
	(insert-silence 0 20 ind)
	(let ((indout (new-sound "test.snd" 1 22050 mus-ldouble mus-next "mix tests")))
	  (insert-silence 0 10 indout)
	  (set! (sample 2 indout 0) .5)
	  (set! (sample 5 indout 0) .25)
	  (save-sound indout)
	  (close-sound indout))
	(let ((tag (car (mix "test.snd"))))
	  (let ((samps (channel->float-vector 0 20))
		(v (make-float-vector 20)))
	    (set! (v 2) .5)
	    (set! (v 5) .25)
	    (if (not (mus-arrays-equal? samps v))
		(snd-display "mix 1->1: ~A ~A" samps v)))
	  (if (not (mix? tag)) (snd-display "mix 1->1 tag: ~A" tag))
	  (undo))
	(let ((tag (car (mix "test.snd" 5))))
	  (let ((samps (channel->float-vector 0 20))
		(v (make-float-vector 20)))
	    (set! (v 7) .5)
	    (set! (v 10) .25)
	    (if (not (mus-arrays-equal? samps v))
		(snd-display "mix 1->1 at 5: ~A ~A" samps v)))
	  (if (not (mix? tag)) (snd-display "mix 1->1 at 5 tag: ~A" tag))
	  (undo))
	(let ((tag (mix "test.snd" 0 0 ind 0 #f)))
	  (let ((samps (channel->float-vector 0 20))
		(v (make-float-vector 20)))
	    (set! (v 2) .5)
	    (set! (v 5) .25)
	    (if (not (mus-arrays-equal? samps v))
		(snd-display "mix 1->1 at 0 #f: ~A ~A" samps v)))
	  (if (mix? tag) (snd-display "mix 1->1 at 5 #f tag: ~A" tag))
	  (undo))
	(let ((indout (new-sound "test.snd" 2 22050 mus-ldouble mus-next "mix tests")))
	  (insert-silence 0 10 indout 0)
	  (insert-silence 0 10 indout 1)
	  (set! (sample 2 indout 0) .5)
	  (set! (sample 5 indout 0) .25)
	  (set! (sample 2 indout 1) .95)
	  (set! (sample 5 indout 1) .125)
	  (save-sound indout)
	  (close-sound indout))
	(let ((tag (car (mix "test.snd" 0 1))))
	  (let ((samps (channel->float-vector 0 20))
		(v (make-float-vector 20)))
	    (set! (v 2) .95)
	    (set! (v 5) .125)
	    (if (not (mus-arrays-equal? samps v))
		(snd-display "mix 2->1: ~A ~A" samps v)))
	  (if (not (mix? tag)) (snd-display "mix 2->1 tag: ~A" tag))
	  (undo))
	(let ((tag (car (mix "test.snd" 5 1))))
	  (let ((samps (channel->float-vector 0 20))
		(v (make-float-vector 20)))
	    (set! (v 7) .95)
	    (set! (v 10) .125)
	    (if (not (mus-arrays-equal? samps v))
		(snd-display "mix 2->1 at 5: ~A ~A" samps v)))
	  (if (not (mix? tag)) (snd-display "mix 2->1 at 5 tag: ~A" tag))
	  (undo))
	(close-sound ind))

      (let ((ind (new-sound "fmv.snd" 2 22050 mus-ldouble mus-next "mix tests")))
	(insert-silence 0 20 ind 0)
	(insert-silence 0 20 ind 1)
	(let ((tag (car (mix "test.snd" 0 #t))))
	  (let ((v (make-float-vector 20)))
	    (set! (v 2) .95) 
	    (set! (v 5) .125)
	    (let ((samps1 (channel->float-vector 0 20 ind 1)))
	      (if (not (mus-arrays-equal? samps1 v))
		  (snd-display "mix 1->1 (2): ~A ~A" samps1 v)))
	    (set! (v 2) .5)
	    (set! (v 5) .25)
	    (let ((samps0 (channel->float-vector 0 20 ind 0)))
	      (if (not (mus-arrays-equal? samps0 v))
		  (snd-display "mix 1->1 (3): ~A ~A" samps0 v))))
	  (if (not (mix? tag)) (snd-display "mix 1->1 tag: ~A" tag)))
	(undo 1 ind 0)
	(undo 1 ind 1)
	(let ((tag (mix "test.snd" 0 1 ind 1 #f))) ; samp:0, in-chan: 1
	  (let ((samps1 (channel->float-vector 0 20 ind 1))
		(v (make-float-vector 20)))
	    (let ((samps0 (channel->float-vector 0 20 ind 0)))
	      (if (not (mus-arrays-equal? samps0 v))
		  (snd-display "mix 1->1 (4): ~A ~A" samps0 v)))
	    (set! (v 2) .95)
	    (set! (v 5) .125)
	    (if (not (mus-arrays-equal? samps1 v))
		(snd-display "mix 1->1 (5): ~A ~A" samps1 v)))
	  (if (mix? tag) (snd-display "mix 1->1 tag (5): ~A" tag)))
	(undo 1 ind 1)
	(set! (sync ind) 1)
	(mix "test.snd" 0 #t)
	(let ((samps1 (channel->float-vector 0 20 ind 1))
	      (v (make-float-vector 20)))
	  (let ((samps0 (channel->float-vector 0 20 ind 0)))
	    (set! (v 2) .5)
	    (set! (v 5) .25)
	    (if (not (mus-arrays-equal? samps0 v))
		(snd-display "mix 1->1 (6): ~A ~A" samps0 v)))
	  (set! (v 2) .95)
	  (set! (v 5) .125)
	  (if (not (mus-arrays-equal? samps1 v))
	      (snd-display "mix 1->1 (7): ~A ~A" samps1 v)))
	(undo)
	(close-sound ind))
      (delete-file "test.snd")
      (delete-file "fmv.snd")
      
      ;; check ripple_mixes
      (let* ((ind (open-sound "oboe.snd"))
	     (data (channel->float-vector 100 100))
	     (m1 (mix-float-vector data 321 ind 0 #t))
	     (m2 (mix-float-vector data 123 ind 0 #t)))
	(set! (mix-position m1) 500)
	(if (not (= (mix-position m1) 500)) (snd-display "mix-position m1[0]: ~A" (mix-position m1)))
	(if (not (= (mix-position m2) 123)) (snd-display "mix-position m2[0]: ~A" (mix-position m2)))
	(undo)
	(set! (mix-position m2) 500)
	(if (not (= (mix-position m2) 500)) (snd-display "mix-position m2[1]: ~A" (mix-position m2)))
	(if (not (= (mix-position m1) 321)) (snd-display "mix-position m1[1]: ~A" (mix-position m1)))
	(undo)
	(insert-silence 0 100)
	(if (not (= (mix-position m1) 421)) (snd-display "mix-position m1[2]: ~A" (mix-position m1)))
	(if (not (= (mix-position m2) 223)) (snd-display "mix-position m2[2]: ~A" (mix-position m2)))
	(delete-samples 0 50)
	(if (not (= (mix-position m1) 371)) (snd-display "mix-position m1[3]: ~A" (mix-position m1)))
	(if (not (= (mix-position m2) 173)) (snd-display "mix-position m2[3]: ~A" (mix-position m2)))
	(undo 2)
	(set! (mix-position m2) 500)
	(undo)
	(scale-channel 0.5 1000 100)
	(if (not (= (mix-position m2) 123)) (snd-display "mix-position m2[5]: ~A" (mix-position m2)))
	(if (not (= (mix-position m1) 321)) (snd-display "mix-position m1[5]: ~A" (mix-position m1)))
	(undo)
	(set! (mix-position m2) 500)
	(undo)
	(set! (mix-position m2) 500)
	(undo-edit)
	(ramp-channel 0.0 1.0 3000 100)
	(catch #t
	  (lambda ()
	    (if (not (= (mix-position m2) 123)) (snd-display "mix-position m2[7]: ~A" (mix-position m2)))
	    (if (not (= (mix-position m1) 321)) (snd-display "mix-position m1[7]: ~A" (mix-position m1))))
	  (lambda args (snd-display "mix-position trouble: ~A" args)))
	(undo)
	(delay-channel-mixes 200 100 ind 0)
	(if (not (= (mix-position m2) 123)) (snd-display "delay-channel mixes mix-position m2: ~A" (mix-position m2)))
	(if (not (= (mix-position m1) 421)) (snd-display "delay-channel-mixes mix-position m1: ~A" (mix-position m1)))
	(check-mix-tags ind 0)
	(close-sound ind))
      
      ;; check that current console is correct
      (let ((ind (open-sound "storm.snd")))
	(set! (x-bounds) (list 0 80.0))
	(make-selection 1000000 1050000)
	(let ((m1 (car (mix-selection 900000)))
	      (m2 (car (mix-selection 400000))))
	  (as-one-edit (lambda () 
			 (set! (mix-position m1) 0) 
			 (set! (mix-position m2) 1)))
	  (if (not (and (= (mix-position m1) 0)
			(= (mix-position m2) 1)))
	      (snd-display "as-one-edit positions: ~A ~A" (mix-position m1) (mix-position m2)))
	  (undo-channel)
	  (if (not (and (= (mix-position m1) 900000)
			(= (mix-position m2) 400000)))
	      (snd-display "as-one-edit positions after undo: (~A): ~A (~A): ~A" m1 (mix-position m1) m2 (mix-position m2)))
	  (redo-channel)
	  (if (not (and (= (mix-position m1) 0)
			(= (mix-position m2) 1)))
	      (snd-display "as-one-edit positions after redo: ~A ~A" (mix-position m1) (mix-position m2)))
	  (close-sound ind)))
      
      (let ((ind (open-sound "2.snd")))
	(make-selection 0 10000 ind)
	(if (not (= (selection-chans) 2))
	    (snd-display "stereo selection: ~A" (selection-chans)))
	(set! (sync ind) #t)
	(let ((md (car (mix-selection 500 ind))))
	  (if (not (mix? (integer->mix (+ 1 (mix->integer md)))))
	      (snd-display "where is second mix? ~A ~A" md (mixes)))
	  (if (not (= (edit-position ind 0) 1))
	      (snd-display "edit-position 0 after stereo mix selection: ~A" (edit-position ind 0)))
	  (if (not (= (edit-position ind 1) 1))
	      (snd-display "edit-position 1 after stereo mix selection: ~A" (edit-position ind 1)))
	  (set! (sync ind) #f)
	  (undo-edit 1 ind 0)
	  (delete-sample 25 ind 0)
	  (set! (mix-position (integer->mix (+ 1 (mix->integer md)))) 750)
	  (if (not (= (edit-position ind 1) 2))
	      (snd-display "edit-position 1 after stereo mix selection moved: ~A" (edit-position ind 2)))
	  (revert-sound ind)
	  (close-sound ind)))
      
      (let ((ind (new-sound "test.snd"))
	    (v (make-float-vector 20)))
	(do ((i 0 (+ i 1))) ((= i 20)) (set! (v i) (* i .01)))
	(float-vector->channel v)
	(do ((i 0 (+ i 1))) ((= i 20)) (set! (v i) (* i -.01)))
	(let ((mx (mix-float-vector v 10)))
	  (let ((hi (make-mix-sampler mx))
		(ho (make-mix-sampler mx 5))
		(happy #t))
	    (do ((i 0 (+ i 1)))
		((or (not happy) (= i 10)))
	      (let ((ho-val (ho))
		    (hi-val (hi)))
		(when (fneq hi-val (* i -.01))
		  (snd-display "mix-reader at ~A from 0: ~A" i hi-val)
		  (set! happy #f))
		(when (fneq ho-val (* (+ i 5) -.01))
		  (snd-display "mix-reader at ~A from 5: ~A" i ho-val)
		  (set! happy #f))))))
	(revert-sound ind)
	(set! v (make-float-vector 21 0.5))
	(float-vector->channel v)
	(let ((mx (mix-float-vector v 10)))
	  (set! (mix-amp-env mx) '(0 0 1 1))
	  (let ((hi (make-mix-sampler mx 0))
		(ho (make-mix-sampler mx 10))
		(happy #t))
	    (do ((i 0 (+ i 1)))
		((or (not happy) (= i 10)))
	      (let ((ho-val (ho))
		    (hi-val (hi)))
		(when (fneq hi-val (* i .025))
		  (snd-display "mix-reader env'd at ~A from 0: ~A" i hi-val)
		  (set! happy #f))
		(when (fneq ho-val (* (+ i 10) .025))
		  (snd-display "mix-reader env'd at ~A from 10: ~A" i ho-val)
		  (set! happy #f))))))
	(close-sound ind))
      
      (let ((ind (open-sound "oboe.snd"))
	    (id (mix-float-vector (make-float-vector 10 .1))))
	(set! (mix-position id) 100)
	(if (not (and (= (mix-position id) 100)
		      (= (edit-position ind 0) 2)))
	    (snd-display "mix-position init: ~A ~A" (mix-position id) (edit-position ind 0)))
	(set! (mix-position id) 100)
	(if (not (and (= (mix-position id) (mix-position id))
		      (= (edit-position ind 0) 2)))
	    (snd-display "mix-position 2 (no-op): ~A ~A" (mix-position id) (edit-position ind 0)))
	(set! (mix-amp id) 1.0)
	(if (or (fneq (mix-amp id) 1.0)
		(not (= (edit-position ind 0) 2)))
	    (snd-display "mix-amp no-op: ~A ~A" (mix-amp id) (edit-position ind 0)))
	(set! (mix-amp id) 0.5)
	(if (or (fneq (mix-amp id) 0.5)
		(not (= (edit-position ind 0) 3)))
	    (snd-display "mix-amp .5: ~A ~A" (mix-amp id) (edit-position ind 0)))
	(set! (mix-speed id) 1.0)
	(if (or (fneq (mix-speed id) 1.0)
		(not (= (edit-position ind 0) 3)))
	    (snd-display "mix-speed no-op: ~A ~A" (mix-speed id) (edit-position ind 0)))
	(set! (mix-speed id) .5)
	(if (or (fneq (mix-speed id) 0.5)
		(not (= (edit-position ind 0) 4)))
	    (snd-display "mix-speed .5: ~A ~A" (mix-speed id) (edit-position ind 0)))
	(set! (mix-amp-env id) '(0 0 1 1))
	(if (not (= (edit-position ind 0) 5))
	    (snd-display "mix-amp-env init: ~A ~A" (mix-amp-env id) (edit-position ind 0)))
	(set! (mix-amp-env id) '(0 0 1 1))
	(if (not (= (edit-position ind 0) 5))
	    (snd-display "mix-amp-env no-op: ~A ~A" (mix-amp-env id) (edit-position ind 0)))
	(close-sound ind))
      
      (let ((ind (new-sound "test.snd" 1 22050 mus-ldouble mus-next "color-mix tests" 300))
	    (old-color *mix-color*))
	(set! *mix-color* (make-color-with-catch 1 1 0))
	(let ((mix1 (mix-float-vector (make-float-vector 10 .5) 10)))
	  (if (not (and (member (color->list *mix-color*)      '((1.0 1.0 0.0) (1.0 1.0 0.0 1.0)))
			(member (color->list (mix-color mix1)) '((1.0 1.0 0.0) (1.0 1.0 0.0 1.0)))))
	      (snd-display "set mix-color: ~A ~A ~A ~A" 
			   (color->list *mix-color*) (color->lis