/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.CountDown;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.xpack.core.XPackFeatureSet;
import org.elasticsearch.xpack.core.XPackSettings;
import org.elasticsearch.xpack.core.security.SecurityFeatureSetUsage;
import org.elasticsearch.xpack.core.security.user.AnonymousUser;
import org.elasticsearch.xpack.security.Security;
import org.elasticsearch.xpack.security.authc.Realms;
import org.elasticsearch.xpack.security.authc.support.mapper.NativeRoleMappingStore;
import org.elasticsearch.xpack.security.authz.store.CompositeRolesStore;
import org.elasticsearch.xpack.security.transport.filter.IPFilter;

public class SecurityFeatureSet
implements XPackFeatureSet {
    private final Settings settings;
    private final XPackLicenseState licenseState;
    @Nullable
    private final Realms realms;
    @Nullable
    private final CompositeRolesStore rolesStore;
    @Nullable
    private final NativeRoleMappingStore roleMappingStore;
    @Nullable
    private final IPFilter ipFilter;

    @Inject
    public SecurityFeatureSet(Settings settings, @Nullable XPackLicenseState licenseState, @Nullable Realms realms, @Nullable CompositeRolesStore rolesStore, @Nullable NativeRoleMappingStore roleMappingStore, @Nullable IPFilter ipFilter) {
        this.licenseState = licenseState;
        this.realms = realms;
        this.rolesStore = rolesStore;
        this.roleMappingStore = roleMappingStore;
        this.settings = settings;
        this.ipFilter = ipFilter;
    }

    public String name() {
        return "security";
    }

    public String description() {
        return "Security for the Elastic Stack";
    }

    public boolean available() {
        return this.licenseState != null && this.licenseState.isSecurityAvailable();
    }

    public boolean enabled() {
        if (this.licenseState != null) {
            return (Boolean)XPackSettings.SECURITY_ENABLED.get(this.settings) != false && !this.licenseState.isSecurityDisabledByTrialLicense();
        }
        return false;
    }

    public Map<String, Object> nativeCodeInfo() {
        return null;
    }

    public void usage(ActionListener<XPackFeatureSet.Usage> listener) {
        Map<String, Object> sslUsage = SecurityFeatureSet.sslUsage(this.settings);
        Map<String, Object> auditUsage = SecurityFeatureSet.auditUsage(this.settings);
        Map<String, Object> ipFilterUsage = SecurityFeatureSet.ipFilterUsage(this.ipFilter);
        Map<String, Boolean> anonymousUsage = Collections.singletonMap("enabled", AnonymousUser.isAnonymousEnabled((Settings)this.settings));
        AtomicReference rolesUsageRef = new AtomicReference();
        AtomicReference roleMappingUsageRef = new AtomicReference();
        AtomicReference realmsUsageRef = new AtomicReference();
        CountDown countDown = new CountDown(3);
        Runnable doCountDown = () -> {
            if (countDown.countDown()) {
                listener.onResponse((Object)new SecurityFeatureSetUsage(this.available(), this.enabled(), (Map)realmsUsageRef.get(), (Map)rolesUsageRef.get(), (Map)roleMappingUsageRef.get(), sslUsage, auditUsage, ipFilterUsage, anonymousUsage));
            }
        };
        ActionListener rolesStoreUsageListener = ActionListener.wrap(rolesStoreUsage -> {
            rolesUsageRef.set(rolesStoreUsage);
            doCountDown.run();
        }, arg_0 -> listener.onFailure(arg_0));
        ActionListener roleMappingStoreUsageListener = ActionListener.wrap(nativeRoleMappingStoreUsage -> {
            Map<String, Map> usage = Collections.singletonMap("native", nativeRoleMappingStoreUsage);
            roleMappingUsageRef.set(usage);
            doCountDown.run();
        }, arg_0 -> listener.onFailure(arg_0));
        ActionListener realmsUsageListener = ActionListener.wrap(realmsUsage -> {
            realmsUsageRef.set(realmsUsage);
            doCountDown.run();
        }, arg_0 -> listener.onFailure(arg_0));
        if (this.rolesStore == null) {
            rolesStoreUsageListener.onResponse(Collections.emptyMap());
        } else {
            this.rolesStore.usageStats((ActionListener<Map<String, Object>>)rolesStoreUsageListener);
        }
        if (this.roleMappingStore == null) {
            roleMappingStoreUsageListener.onResponse(Collections.emptyMap());
        } else {
            this.roleMappingStore.usageStats((ActionListener<Map<String, Object>>)roleMappingStoreUsageListener);
        }
        if (this.realms == null) {
            realmsUsageListener.onResponse(Collections.emptyMap());
        } else {
            this.realms.usageStats((ActionListener<Map<String, Object>>)realmsUsageListener);
        }
    }

    static Map<String, Object> sslUsage(Settings settings) {
        HashMap<String, Object> map = new HashMap<String, Object>(2);
        map.put("http", Collections.singletonMap("enabled", (Boolean)XPackSettings.HTTP_SSL_ENABLED.get(settings)));
        map.put("transport", Collections.singletonMap("enabled", (Boolean)XPackSettings.TRANSPORT_SSL_ENABLED.get(settings)));
        return map;
    }

    static Map<String, Object> auditUsage(Settings settings) {
        HashMap<String, Object> map = new HashMap<String, Object>(2);
        map.put("enabled", XPackSettings.AUDIT_ENABLED.get(settings));
        map.put("outputs", Security.AUDIT_OUTPUTS_SETTING.get(settings));
        return map;
    }

    static Map<String, Object> ipFilterUsage(@Nullable IPFilter ipFilter) {
        if (ipFilter == null) {
            return IPFilter.DISABLED_USAGE_STATS;
        }
        return ipFilter.usageStats();
    }
}

