/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.action.role;

import java.util.ArrayList;
import java.util.Collection;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.security.action.role.GetRolesRequest;
import org.elasticsearch.xpack.core.security.action.role.GetRolesResponse;
import org.elasticsearch.xpack.core.security.authz.RoleDescriptor;
import org.elasticsearch.xpack.core.security.authz.store.ReservedRolesStore;
import org.elasticsearch.xpack.security.authz.store.NativeRolesStore;

public class TransportGetRolesAction
extends HandledTransportAction<GetRolesRequest, GetRolesResponse> {
    private final NativeRolesStore nativeRolesStore;
    private final ReservedRolesStore reservedRolesStore;

    @Inject
    public TransportGetRolesAction(Settings settings, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, NativeRolesStore nativeRolesStore, TransportService transportService, ReservedRolesStore reservedRolesStore) {
        super(settings, "cluster:admin/xpack/security/role/get", threadPool, transportService, actionFilters, indexNameExpressionResolver, GetRolesRequest::new);
        this.nativeRolesStore = nativeRolesStore;
        this.reservedRolesStore = reservedRolesStore;
    }

    protected void doExecute(GetRolesRequest request, ActionListener<GetRolesResponse> listener) {
        String[] requestedRoles = request.names();
        boolean specificRolesRequested = requestedRoles != null && requestedRoles.length > 0;
        ArrayList<String> rolesToSearchFor = new ArrayList<String>();
        ArrayList<RoleDescriptor> roles = new ArrayList<RoleDescriptor>();
        if (specificRolesRequested) {
            for (String role : requestedRoles) {
                if (ReservedRolesStore.isReserved((String)role)) {
                    RoleDescriptor rd = this.reservedRolesStore.roleDescriptor(role);
                    if (rd != null) {
                        roles.add(rd);
                        continue;
                    }
                    listener.onFailure((Exception)new IllegalStateException("unable to obtain reserved role [" + role + "]"));
                    return;
                }
                rolesToSearchFor.add(role);
            }
        } else {
            roles.addAll(this.reservedRolesStore.roleDescriptors());
        }
        if (specificRolesRequested && rolesToSearchFor.isEmpty()) {
            listener.onResponse((Object)new GetRolesResponse(roles.toArray(new RoleDescriptor[roles.size()])));
        } else {
            String[] roleNames = rolesToSearchFor.toArray(new String[rolesToSearchFor.size()]);
            this.nativeRolesStore.getRoleDescriptors(roleNames, (ActionListener<Collection<RoleDescriptor>>)ActionListener.wrap(foundRoles -> {
                roles.addAll((Collection<RoleDescriptor>)foundRoles);
                listener.onResponse((Object)new GetRolesResponse(roles.toArray(new RoleDescriptor[roles.size()])));
            }, arg_0 -> listener.onFailure(arg_0)));
        }
    }
}

