/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.license;

import org.elasticsearch.common.joda.FormatDateTimeFormatter;
import org.elasticsearch.common.joda.Joda;
import org.joda.time.MutableDateTime;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public class DateUtils {
    private static final FormatDateTimeFormatter formatDateOnlyFormatter = Joda.forPattern((String)"yyyy-MM-dd");
    private static final DateTimeFormatter dateOnlyFormatter = formatDateOnlyFormatter.parser().withZoneUTC();
    private static final DateTimeFormatter dateTimeFormatter = ISODateTimeFormat.dateTime().withZoneUTC();

    public static long endOfTheDay(String date) {
        try {
            return dateTimeFormatter.parseDateTime(date).getMillis();
        }
        catch (IllegalArgumentException ex) {
            MutableDateTime dateTime = dateOnlyFormatter.parseMutableDateTime(date);
            dateTime.millisOfDay().set(dateTime.millisOfDay().getMaximumValue());
            return dateTime.getMillis();
        }
    }

    public static long beginningOfTheDay(String date) {
        try {
            return dateTimeFormatter.parseDateTime(date).getMillis();
        }
        catch (IllegalArgumentException ex) {
            return dateOnlyFormatter.parseDateTime(date).getMillis();
        }
    }
}

