/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.support.single.shard;

import java.io.IOException;
import java.util.function.Supplier;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.NoShardAvailableActionException;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.TransportAction;
import org.elasticsearch.action.support.TransportActions;
import org.elasticsearch.action.support.single.shard.SingleShardRequest;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.ShardsIterator;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.logging.LoggerMessageFormat;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportChannel;
import org.elasticsearch.transport.TransportException;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportRequestHandler;
import org.elasticsearch.transport.TransportResponse;
import org.elasticsearch.transport.TransportResponseHandler;
import org.elasticsearch.transport.TransportService;

public abstract class TransportSingleShardAction<Request extends SingleShardRequest<Request>, Response extends ActionResponse>
extends TransportAction<Request, Response> {
    protected final ClusterService clusterService;
    protected final TransportService transportService;
    final String transportShardAction;
    final String executor;

    protected TransportSingleShardAction(Settings settings, String actionName, ThreadPool threadPool, ClusterService clusterService, TransportService transportService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, Supplier<Request> request, String executor) {
        super(settings, actionName, threadPool, actionFilters, indexNameExpressionResolver, transportService.getTaskManager());
        this.clusterService = clusterService;
        this.transportService = transportService;
        this.transportShardAction = actionName + "[s]";
        this.executor = executor;
        if (!this.isSubAction()) {
            transportService.registerRequestHandler(actionName, request, "same", new TransportHandler());
        }
        transportService.registerRequestHandler(this.transportShardAction, request, executor, new ShardTransportHandler());
    }

    protected boolean isSubAction() {
        return false;
    }

    @Override
    protected void doExecute(Request request, ActionListener<Response> listener) {
        new AsyncSingleAction(this, (SingleShardRequest)request, listener).start();
    }

    protected abstract Response shardOperation(Request var1, ShardId var2) throws IOException;

    protected abstract Response newResponse();

    protected abstract boolean resolveIndex(Request var1);

    protected ClusterBlockException checkGlobalBlock(ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.READ);
    }

    protected ClusterBlockException checkRequestBlock(ClusterState state, InternalRequest request) {
        return state.blocks().indexBlockedException(ClusterBlockLevel.READ, request.concreteIndex());
    }

    protected void resolveRequest(ClusterState state, InternalRequest request) {
    }

    @Nullable
    protected abstract ShardsIterator shards(ClusterState var1, InternalRequest var2);

    protected static class InternalRequest {
        final Request request;
        final String concreteIndex;
        final /* synthetic */ TransportSingleShardAction this$0;

        InternalRequest(Request request, String concreteIndex) {
            this.this$0 = this$0;
            this.request = request;
            this.concreteIndex = concreteIndex;
        }

        public Request request() {
            return this.request;
        }

        public String concreteIndex() {
            return this.concreteIndex;
        }
    }

    private class ShardTransportHandler
    implements TransportRequestHandler<Request> {
        private ShardTransportHandler() {
        }

        @Override
        public void messageReceived(Request request, TransportChannel channel) throws Exception {
            if (TransportSingleShardAction.this.logger.isTraceEnabled()) {
                TransportSingleShardAction.this.logger.trace("executing [{}] on shard [{}]", request, (Object)((SingleShardRequest)request).internalShardId);
            }
            Object response = TransportSingleShardAction.this.shardOperation(request, ((SingleShardRequest)request).internalShardId);
            channel.sendResponse((TransportResponse)response);
        }
    }

    private class TransportHandler
    implements TransportRequestHandler<Request> {
        private TransportHandler() {
        }

        @Override
        public void messageReceived(Request request, final TransportChannel channel) throws Exception {
            TransportSingleShardAction.this.execute(request, new ActionListener<Response>(){

                @Override
                public void onResponse(Response result) {
                    try {
                        channel.sendResponse((TransportResponse)result);
                    }
                    catch (Exception e) {
                        this.onFailure(e);
                    }
                }

                @Override
                public void onFailure(Exception e) {
                    try {
                        channel.sendResponse(e);
                    }
                    catch (Exception e1) {
                        TransportSingleShardAction.this.logger.warn("failed to send response for get", (Throwable)e1);
                    }
                }
            });
        }
    }

    static class AsyncSingleAction {
        private final ActionListener<Response> listener;
        private final ShardsIterator shardIt;
        private final InternalRequest internalRequest;
        private final DiscoveryNodes nodes;
        private volatile Exception lastFailure;
        final /* synthetic */ TransportSingleShardAction this$0;

        private AsyncSingleAction(Request request, ActionListener<Response> listener) {
            this.this$0 = this$0;
            this.listener = listener;
            ClusterState clusterState = this$0.clusterService.state();
            if (((TransportSingleShardAction)this$0).logger.isTraceEnabled()) {
                ((TransportSingleShardAction)this$0).logger.trace("executing [{}] based on cluster state version [{}]", request, (Object)clusterState.version());
            }
            this.nodes = clusterState.nodes();
            ClusterBlockException blockException = this$0.checkGlobalBlock(clusterState);
            if (blockException != null) {
                throw blockException;
            }
            String concreteSingleIndex = this$0.resolveIndex(request) ? ((TransportSingleShardAction)this$0).indexNameExpressionResolver.concreteSingleIndex(clusterState, (IndicesRequest)request).getName() : ((SingleShardRequest)request).index();
            this.internalRequest = new InternalRequest((TransportSingleShardAction)this$0, request, concreteSingleIndex);
            this$0.resolveRequest(clusterState, this.internalRequest);
            blockException = this$0.checkRequestBlock(clusterState, this.internalRequest);
            if (blockException != null) {
                throw blockException;
            }
            this.shardIt = this$0.shards(clusterState, this.internalRequest);
        }

        public void start() {
            if (this.shardIt == null) {
                this.this$0.transportService.sendRequest(this.this$0.clusterService.localNode(), this.this$0.transportShardAction, (TransportRequest)this.internalRequest.request(), new TransportResponseHandler<Response>(){

                    @Override
                    public Response newInstance() {
                        return AsyncSingleAction.this.this$0.newResponse();
                    }

                    @Override
                    public String executor() {
                        return "same";
                    }

                    @Override
                    public void handleResponse(Response response) {
                        AsyncSingleAction.this.listener.onResponse(response);
                    }

                    @Override
                    public void handleException(TransportException exp) {
                        AsyncSingleAction.this.listener.onFailure(exp);
                    }
                });
            } else {
                this.perform(null);
            }
        }

        private void onFailure(ShardRouting shardRouting, Exception e) {
            if (e != null) {
                this.this$0.logger.trace(() -> new ParameterizedMessage("{}: failed to execute [{}]", (Object)shardRouting, this.internalRequest.request()), (Throwable)e);
            }
            this.perform(e);
        }

        private void perform(@Nullable Exception currentFailure) {
            ShardRouting shardRouting;
            Exception lastFailure = this.lastFailure;
            if (lastFailure == null || TransportActions.isReadOverrideException(currentFailure)) {
                lastFailure = currentFailure;
                this.lastFailure = currentFailure;
            }
            if ((shardRouting = this.shardIt.nextOrNull()) == null) {
                Exception failure = lastFailure;
                if (failure == null || TransportActions.isShardNotAvailableException(failure)) {
                    failure = new NoShardAvailableActionException(null, LoggerMessageFormat.format("No shard available for [{}]", this.internalRequest.request()), failure);
                } else {
                    this.this$0.logger.debug(() -> new ParameterizedMessage("{}: failed to execute [{}]", null, this.internalRequest.request()), (Throwable)failure);
                }
                this.listener.onFailure(failure);
                return;
            }
            DiscoveryNode node = this.nodes.get(shardRouting.currentNodeId());
            if (node == null) {
                this.onFailure(shardRouting, new NoShardAvailableActionException(shardRouting.shardId()));
            } else {
                ((SingleShardRequest)this.internalRequest.request()).internalShardId = shardRouting.shardId();
                if (this.this$0.logger.isTraceEnabled()) {
                    this.this$0.logger.trace("sending request [{}] to shard [{}] on node [{}]", this.internalRequest.request(), (Object)((SingleShardRequest)this.internalRequest.request()).internalShardId, (Object)node);
                }
                this.this$0.transportService.sendRequest(node, this.this$0.transportShardAction, (TransportRequest)this.internalRequest.request(), new TransportResponseHandler<Response>(){

                    @Override
                    public Response newInstance() {
                        return AsyncSingleAction.this.this$0.newResponse();
                    }

                    @Override
                    public String executor() {
                        return "same";
                    }

                    @Override
                    public void handleResponse(Response response) {
                        AsyncSingleAction.this.listener.onResponse(response);
                    }

                    @Override
                    public void handleException(TransportException exp) {
                        AsyncSingleAction.this.onFailure(shardRouting, exp);
                    }
                });
            }
        }
    }
}

