/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.metrics.geobounds;

import java.io.IOException;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.geo.GeoPoint;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.search.aggregations.ParsedAggregation;
import org.elasticsearch.search.aggregations.metrics.geobounds.GeoBounds;
import org.elasticsearch.search.aggregations.metrics.geobounds.InternalGeoBounds;

public class ParsedGeoBounds
extends ParsedAggregation
implements GeoBounds {
    private GeoPoint topLeft;
    private GeoPoint bottomRight;
    private static final ObjectParser<ParsedGeoBounds, Void> PARSER = new ObjectParser(ParsedGeoBounds.class.getSimpleName(), true, ParsedGeoBounds::new);
    private static final ConstructingObjectParser<Tuple<GeoPoint, GeoPoint>, Void> BOUNDS_PARSER = new ConstructingObjectParser(ParsedGeoBounds.class.getSimpleName() + "_BOUNDS", true, args -> new Tuple((Object)((GeoPoint)args[0]), (Object)((GeoPoint)args[1])));
    private static final ObjectParser<GeoPoint, Void> GEO_POINT_PARSER = new ObjectParser(ParsedGeoBounds.class.getSimpleName() + "_POINT", true, GeoPoint::new);

    @Override
    public String getType() {
        return "geo_bounds";
    }

    @Override
    public XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.topLeft != null) {
            builder.startObject(InternalGeoBounds.BOUNDS_FIELD.getPreferredName());
            builder.startObject(InternalGeoBounds.TOP_LEFT_FIELD.getPreferredName());
            builder.field(InternalGeoBounds.LAT_FIELD.getPreferredName(), this.topLeft.getLat());
            builder.field(InternalGeoBounds.LON_FIELD.getPreferredName(), this.topLeft.getLon());
            builder.endObject();
            builder.startObject(InternalGeoBounds.BOTTOM_RIGHT_FIELD.getPreferredName());
            builder.field(InternalGeoBounds.LAT_FIELD.getPreferredName(), this.bottomRight.getLat());
            builder.field(InternalGeoBounds.LON_FIELD.getPreferredName(), this.bottomRight.getLon());
            builder.endObject();
            builder.endObject();
        }
        return builder;
    }

    @Override
    public GeoPoint topLeft() {
        return this.topLeft;
    }

    @Override
    public GeoPoint bottomRight() {
        return this.bottomRight;
    }

    public static ParsedGeoBounds fromXContent(XContentParser parser, String name) {
        ParsedGeoBounds geoBounds = (ParsedGeoBounds)PARSER.apply(parser, null);
        geoBounds.setName(name);
        return geoBounds;
    }

    static {
        ParsedGeoBounds.declareAggregationFields(PARSER);
        PARSER.declareObject((agg, bbox) -> {
            agg.topLeft = (GeoPoint)bbox.v1();
            agg.bottomRight = (GeoPoint)bbox.v2();
        }, BOUNDS_PARSER, InternalGeoBounds.BOUNDS_FIELD);
        BOUNDS_PARSER.declareObject(ConstructingObjectParser.constructorArg(), GEO_POINT_PARSER, InternalGeoBounds.TOP_LEFT_FIELD);
        BOUNDS_PARSER.declareObject(ConstructingObjectParser.constructorArg(), GEO_POINT_PARSER, InternalGeoBounds.BOTTOM_RIGHT_FIELD);
        GEO_POINT_PARSER.declareDouble(GeoPoint::resetLat, InternalGeoBounds.LAT_FIELD);
        GEO_POINT_PARSER.declareDouble(GeoPoint::resetLon, InternalGeoBounds.LON_FIELD);
    }
}

