/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.persist;

import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.EntrySource;
import com.unboundid.ldap.sdk.LDAPEntrySource;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.SearchResult;
import com.unboundid.ldap.sdk.persist.LDAPPersistException;
import com.unboundid.ldap.sdk.persist.LDAPPersister;
import com.unboundid.ldap.sdk.persist.PersistMessages;
import com.unboundid.util.Debug;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.io.Closeable;
import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
public final class PersistedObjects<T>
implements Serializable,
Closeable {
    private static final long serialVersionUID = 7430494946944736169L;
    private final EntrySource entrySource;
    private final LDAPPersister<T> persister;

    PersistedObjects(LDAPPersister<T> persister, EntrySource entrySource) {
        this.persister = persister;
        this.entrySource = entrySource;
    }

    public T next() throws LDAPPersistException {
        Entry entry;
        try {
            entry = this.entrySource.nextEntry();
        }
        catch (Exception e) {
            Debug.debugException(e);
            Throwable cause = e.getCause();
            if (cause != null && cause instanceof LDAPException) {
                throw new LDAPPersistException((LDAPException)cause);
            }
            throw new LDAPPersistException(PersistMessages.ERR_OBJECT_SEARCH_RESULTS_ENTRY_SOURCE_EXCEPTION.get(StaticUtils.getExceptionMessage(e)), (Throwable)e);
        }
        if (entry == null) {
            return null;
        }
        return this.persister.decode(entry);
    }

    @Override
    public void close() {
        this.entrySource.close();
    }

    public SearchResult getSearchResult() {
        if (this.entrySource instanceof LDAPEntrySource) {
            return ((LDAPEntrySource)this.entrySource).getSearchResult();
        }
        return null;
    }
}

