/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.otp.ic;

import com.ericsson.otp.erlang.OtpInputStream;
import com.ericsson.otp.erlang.OtpOutputStream;
import com.ericsson.otp.ic.Any;
import com.ericsson.otp.ic.TCKind;

public class TypeCode {
    private TCKind _kind;
    private String _id;
    private String _name;
    private int _length;
    private int _member_count;
    private int _default_index;
    private TypeCode _member_type;
    private TypeCode _discriminator_type;
    private TypeCode _content_type;
    private Any _member_label;
    private boolean extracted;
    private TypeCode[] _members;
    private String[] _member_names;
    private Any[] _member_labels;

    public TypeCode() {
        this.extracted = false;
        this._members = null;
        this._member_names = null;
        this._member_labels = null;
        this._kind = null;
        this._id = null;
        this._name = null;
        this._length = -1;
        this._member_count = -1;
        this._default_index = -1;
        this._member_type = null;
        this._content_type = null;
        this._discriminator_type = null;
        this._member_label = null;
    }

    public TypeCode(TCKind tCKind) {
        this._kind = tCKind;
    }

    public boolean equal(TypeCode typeCode) {
        try {
            TCKind tCKind = typeCode.kind();
            switch (tCKind.value()) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 18: 
                case 23: 
                case 24: 
                case 26: 
                case 27: 
                case 20000: {
                    return tCKind.value() == this._kind.value();
                }
                case 15: {
                    if (typeCode.id().compareTo(this._id) == 0 && typeCode.name().compareTo(this._name) == 0 && typeCode.member_count() == this._member_count) {
                        for (int i = 0; i < this._member_count; ++i) {
                            if (typeCode.member_type(i).equal(this._members[i])) continue;
                            return false;
                        }
                        return true;
                    }
                    return false;
                }
                case 16: {
                    if (typeCode.id().compareTo(this._id) == 0 && typeCode.name().compareTo(this._name) == 0 && typeCode.member_count() == this._member_count && typeCode.discriminator_type().equal(this._discriminator_type)) {
                        for (int i = 0; i < this._member_count; ++i) {
                            if (typeCode.member_type(i).equal(this._members[i]) || typeCode.member_name(i).compareTo(this._member_names[i]) == 0) continue;
                            return false;
                        }
                        return true;
                    }
                    return false;
                }
                case 19: 
                case 20: {
                    return tCKind.value() == this._kind.value() && typeCode.content_type().equal(this._content_type);
                }
                case 17: {
                    if (tCKind.value() == this._kind.value() && typeCode.member_count() == this._member_count) {
                        for (int i = 0; i < this._member_count; ++i) {
                            if (typeCode.member_name(i).compareTo(this._member_names[i]) == 0) continue;
                            return false;
                        }
                        return true;
                    }
                    return false;
                }
                case 0: 
                case 12: 
                case 13: 
                case 14: 
                case 21: 
                case 22: 
                case 25: 
                case 28: {
                    return tCKind.value() == this._kind.value();
                }
            }
            return false;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public TCKind kind() {
        return this._kind;
    }

    public void kind(TCKind tCKind) {
        this._kind = tCKind;
    }

    public static TCKind kind(String string) throws Exception {
        if (string.equals("tk_null")) {
            return TCKind.tk_null;
        }
        if (string.equals("tk_void")) {
            return TCKind.tk_void;
        }
        if (string.equals("tk_short")) {
            return TCKind.tk_short;
        }
        if (string.equals("tk_long")) {
            return TCKind.tk_long;
        }
        if (string.equals("tk_ushort")) {
            return TCKind.tk_ushort;
        }
        if (string.equals("tk_ulong")) {
            return TCKind.tk_ulong;
        }
        if (string.equals("tk_float")) {
            return TCKind.tk_float;
        }
        if (string.equals("tk_double")) {
            return TCKind.tk_double;
        }
        if (string.equals("tk_boolean")) {
            return TCKind.tk_boolean;
        }
        if (string.equals("tk_char")) {
            return TCKind.tk_char;
        }
        if (string.equals("tk_octet")) {
            return TCKind.tk_octet;
        }
        if (string.equals("tk_any")) {
            return TCKind.tk_any;
        }
        if (string.equals("tk_TypeCode")) {
            return TCKind.tk_TypeCode;
        }
        if (string.equals("tk_Principal")) {
            return TCKind.tk_Principal;
        }
        if (string.equals("tk_objref")) {
            return TCKind.tk_objref;
        }
        if (string.equals("tk_struct")) {
            return TCKind.tk_struct;
        }
        if (string.equals("tk_union")) {
            return TCKind.tk_union;
        }
        if (string.equals("tk_enum")) {
            return TCKind.tk_enum;
        }
        if (string.equals("tk_string")) {
            return TCKind.tk_string;
        }
        if (string.equals("tk_sequence")) {
            return TCKind.tk_sequence;
        }
        if (string.equals("tk_array")) {
            return TCKind.tk_array;
        }
        if (string.equals("tk_alias")) {
            return TCKind.tk_alias;
        }
        if (string.equals("tk_except")) {
            return TCKind.tk_except;
        }
        if (string.equals("tk_longlong")) {
            return TCKind.tk_longlong;
        }
        if (string.equals("tk_ulonglong")) {
            return TCKind.tk_ulonglong;
        }
        if (string.equals("tk_longdouble")) {
            return TCKind.tk_longdouble;
        }
        if (string.equals("tk_wchar")) {
            return TCKind.tk_wchar;
        }
        if (string.equals("tk_wstring")) {
            return TCKind.tk_wstring;
        }
        if (string.equals("tk_fixed")) {
            return TCKind.tk_fixed;
        }
        if (string.equals("tk_atom")) {
            return TCKind.tk_atom;
        }
        throw new Exception("BAD KIND");
    }

    public String id() throws Exception {
        if (this._id == null) {
            throw new Exception("BAD KIND");
        }
        return this._id;
    }

    public void id(String string) {
        this._id = string;
    }

    public String name() throws Exception {
        if (this._name == null) {
            throw new Exception("BAD KIND");
        }
        return this._name;
    }

    public void name(String string) {
        this._name = string;
    }

    public int member_count() throws Exception {
        if (this._member_count == -1) {
            throw new Exception("BAD KIND");
        }
        return this._member_count;
    }

    public void member_count(int n) {
        switch (this._kind.value()) {
            case 15: {
                this._members = new TypeCode[n];
                this._member_names = new String[n];
                this._member_count = n;
                break;
            }
            case 16: {
                this._members = new TypeCode[n];
                this._member_names = new String[n];
                this._member_labels = new Any[n];
                this._member_count = n;
                break;
            }
            case 17: {
                this._member_names = new String[n];
                this._member_count = n;
                break;
            }
        }
    }

    public String member_name(int n) throws Exception {
        return this._member_names[n];
    }

    public void member_name(int n, String string) {
        this._member_names[n] = string;
    }

    public TypeCode member_type(int n) throws Exception {
        return this._members[n];
    }

    public void member_type(int n, TypeCode typeCode) {
        this._members[n] = typeCode;
    }

    public Any member_label(int n) throws Exception {
        return this._member_labels[n];
    }

    public void member_label(int n, Any any) {
        this._member_labels[n] = any;
    }

    public TypeCode discriminator_type() throws Exception {
        if (this._discriminator_type == null) {
            throw new Exception("BAD KIND");
        }
        return this._discriminator_type;
    }

    public void discriminator_type(TypeCode typeCode) {
        this._discriminator_type = typeCode;
    }

    public int default_index() throws Exception {
        if (this._default_index == -1) {
            throw new Exception("BAD KIND");
        }
        return this._default_index;
    }

    public void default_index(int n) {
        this._default_index = n;
    }

    public int length() throws Exception {
        if (this._length == -1) {
            throw new Exception("BAD KIND");
        }
        return this._length;
    }

    public void length(int n) {
        this._length = n;
    }

    public TypeCode content_type() throws Exception {
        if (this._content_type == null) {
            throw new Exception("BAD KIND");
        }
        return this._content_type;
    }

    public void content_type(TypeCode typeCode) {
        this._content_type = typeCode;
    }

    public static void marshal(OtpOutputStream otpOutputStream, TypeCode typeCode) throws Exception {
        Object var2_2 = null;
        int n = -1;
        switch (typeCode.kind().value()) {
            case 2: {
                otpOutputStream.write_atom("tk_short");
                break;
            }
            case 4: {
                otpOutputStream.write_atom("tk_ushort");
                break;
            }
            case 3: {
                otpOutputStream.write_atom("tk_long");
                break;
            }
            case 23: {
                otpOutputStream.write_atom("tk_longlong");
                break;
            }
            case 5: {
                otpOutputStream.write_atom("tk_ulong");
                break;
            }
            case 24: {
                otpOutputStream.write_atom("tk_ulonglong");
                break;
            }
            case 6: {
                otpOutputStream.write_atom("tk_float");
                break;
            }
            case 7: {
                otpOutputStream.write_atom("tk_double");
                break;
            }
            case 8: {
                otpOutputStream.write_atom("tk_boolean");
                break;
            }
            case 9: {
                otpOutputStream.write_atom("tk_char");
                break;
            }
            case 26: {
                otpOutputStream.write_atom("tk_wchar");
                break;
            }
            case 10: {
                otpOutputStream.write_atom("tk_octet");
                break;
            }
            case 18: {
                otpOutputStream.write_tuple_head(2);
                otpOutputStream.write_atom("tk_string");
                otpOutputStream.write_ulong((long)typeCode.length());
                break;
            }
            case 27: {
                otpOutputStream.write_tuple_head(2);
                otpOutputStream.write_atom("tk_wstring");
                otpOutputStream.write_ulong((long)typeCode.length());
                break;
            }
            case 15: {
                n = typeCode.member_count();
                otpOutputStream.write_tuple_head(4);
                otpOutputStream.write_atom("tk_struct");
                otpOutputStream.write_string(typeCode.id());
                otpOutputStream.write_string(typeCode.name());
                otpOutputStream.write_list_head(n);
                for (int i = 0; i < n; ++i) {
                    otpOutputStream.write_tuple_head(2);
                    otpOutputStream.write_string(typeCode.member_name(i));
                    TypeCode.marshal(otpOutputStream, typeCode.member_type(i));
                }
                otpOutputStream.write_nil();
                break;
            }
            case 16: {
                n = typeCode.member_count();
                otpOutputStream.write_tuple_head(6);
                otpOutputStream.write_atom("tk_union");
                otpOutputStream.write_string(typeCode.id());
                otpOutputStream.write_string(typeCode.name());
                TypeCode.marshal(otpOutputStream, typeCode.discriminator_type());
                otpOutputStream.write_int(typeCode.default_index());
                otpOutputStream.write_list_head(n);
                for (int i = 0; i < n; ++i) {
                    otpOutputStream.write_tuple_head(3);
                    typeCode.member_label(i).write_value(otpOutputStream);
                    otpOutputStream.write_string(typeCode.member_name(i));
                    TypeCode.marshal(otpOutputStream, typeCode.member_type(i));
                }
                otpOutputStream.write_nil();
                break;
            }
            case 19: {
                otpOutputStream.write_tuple_head(3);
                otpOutputStream.write_atom("tk_sequence");
                TypeCode.marshal(otpOutputStream, typeCode.content_type());
                otpOutputStream.write_int(typeCode.length());
                break;
            }
            case 20: {
                otpOutputStream.write_tuple_head(3);
                otpOutputStream.write_atom("tk_array");
                TypeCode.marshal(otpOutputStream, typeCode.content_type());
                otpOutputStream.write_int(typeCode.length());
                break;
            }
            case 17: {
                n = typeCode.member_count();
                otpOutputStream.write_tuple_head(4);
                otpOutputStream.write_atom("tk_enum");
                otpOutputStream.write_string(typeCode.id());
                otpOutputStream.write_string(typeCode.name());
                otpOutputStream.write_list_head(n);
                for (int i = 0; i < n; ++i) {
                    otpOutputStream.write_string(typeCode.member_name(i));
                }
                otpOutputStream.write_nil();
                break;
            }
            case 11: {
                otpOutputStream.write_atom("tk_any");
                break;
            }
            case 1: {
                otpOutputStream.write_atom("tk_void");
                break;
            }
            default: {
                throw new Exception("Unsupported type");
            }
        }
    }

    public static TypeCode unmarshal(OtpInputStream otpInputStream) throws Exception {
        int n = otpInputStream.peek();
        switch (n) {
            case 100: 
            case 118: 
            case 119: {
                TCKind tCKind = TypeCode.kind(otpInputStream.read_atom());
                switch (tCKind.value()) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 23: 
                    case 24: 
                    case 26: {
                        TypeCode typeCode = new TypeCode();
                        typeCode.kind(tCKind);
                        return typeCode;
                    }
                }
                throw new Exception("Unsupported type");
            }
            case 104: 
            case 105: {
                int n2 = otpInputStream.read_tuple_head();
                n = otpInputStream.peek();
                switch (n) {
                    case 100: 
                    case 118: 
                    case 119: {
                        TCKind tCKind = TypeCode.kind(otpInputStream.read_atom());
                        TypeCode typeCode = new TypeCode();
                        typeCode.kind(tCKind);
                        switch (tCKind.value()) {
                            case 18: {
                                typeCode.length((int)otpInputStream.read_ulong());
                                return typeCode;
                            }
                            case 27: {
                                typeCode.length((int)otpInputStream.read_ulong());
                                return typeCode;
                            }
                            case 15: {
                                typeCode.id(otpInputStream.read_string());
                                typeCode.name(otpInputStream.read_string());
                                n2 = otpInputStream.read_list_head();
                                typeCode.member_count(n2);
                                for (int i = 0; i < n2; ++i) {
                                    otpInputStream.read_tuple_head();
                                    typeCode.member_name(i, otpInputStream.read_string());
                                    typeCode.member_type(i, TypeCode.unmarshal(otpInputStream));
                                }
                                otpInputStream.read_nil();
                                return typeCode;
                            }
                            case 16: {
                                typeCode.id(otpInputStream.read_string());
                                typeCode.name(otpInputStream.read_string());
                                typeCode.discriminator_type(TypeCode.unmarshal(otpInputStream));
                                typeCode.default_index(otpInputStream.read_int());
                                n2 = otpInputStream.read_list_head();
                                typeCode.member_count(n2);
                                for (int i = 0; i < n2; ++i) {
                                    otpInputStream.read_tuple_head();
                                    n = otpInputStream.peek();
                                    Any any = new Any();
                                    TypeCode typeCode2 = new TypeCode();
                                    typeCode2.kind(TCKind.tk_long);
                                    any.type(typeCode2);
                                    switch (n) {
                                        case 107: {
                                            String string = otpInputStream.read_string();
                                            any.insert_string(string);
                                            break;
                                        }
                                        case 100: 
                                        case 118: 
                                        case 119: {
                                            String string = otpInputStream.read_atom();
                                            any.insert_atom(string);
                                            break;
                                        }
                                        default: {
                                            any.insert_long(otpInputStream.read_int());
                                        }
                                    }
                                    typeCode.member_label(i, any);
                                    typeCode.member_name(i, otpInputStream.read_string());
                                    typeCode.member_type(i, TypeCode.unmarshal(otpInputStream));
                                }
                                otpInputStream.read_nil();
                                return typeCode;
                            }
                            case 19: {
                                typeCode.content_type(TypeCode.unmarshal(otpInputStream));
                                typeCode.length(otpInputStream.read_int());
                                return typeCode;
                            }
                            case 20: {
                                typeCode.content_type(TypeCode.unmarshal(otpInputStream));
                                typeCode.length(otpInputStream.read_int());
                                return typeCode;
                            }
                            case 17: {
                                typeCode.id(otpInputStream.read_string());
                                typeCode.name(otpInputStream.read_string());
                                n2 = otpInputStream.read_list_head();
                                typeCode.member_count(n2);
                                for (int i = 0; i < n2; ++i) {
                                    typeCode.member_name(i, otpInputStream.read_string());
                                }
                                otpInputStream.read_nil();
                                return typeCode;
                            }
                        }
                        throw new Exception("Unsupported type");
                    }
                }
                throw new Exception("Unsupported type");
            }
        }
        return null;
    }
}

