/*
 * Decompiled with CFR 0.152.
 */
package org.fibs.geotag.tasks;

import java.util.Vector;
import javax.swing.UIManager;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;
import org.fibs.geotag.GlobalUndoManager;
import org.fibs.geotag.tasks.BackgroundTask;

public abstract class UndoableBackgroundTask<V>
extends BackgroundTask<V>
implements UndoableEdit {
    private static final String UNDO_TEXT_KEY = "AbstractUndoableEdit.undoText";
    private static final String REDO_TEXT_KEY = "AbstractUndoableEdit.redoText";
    private boolean hasBeenDone = true;
    private boolean alive = true;
    private String group;
    private Vector<UndoableEdit> edits = new Vector();

    public UndoableBackgroundTask(String group, String name) {
        super(name);
        this.group = group;
        GlobalUndoManager.getManager().addEdit(this);
    }

    @Override
    public boolean addEdit(UndoableEdit anEdit) {
        if (anEdit.isSignificant()) {
            return false;
        }
        this.edits.add(anEdit);
        return true;
    }

    @Override
    public boolean canRedo() {
        return this.alive && !this.hasBeenDone;
    }

    @Override
    public boolean canUndo() {
        return this.alive && this.hasBeenDone;
    }

    @Override
    public void die() {
        this.alive = false;
    }

    @Override
    public String getPresentationName() {
        String presentationName = "";
        if (this.group != null) {
            presentationName = String.valueOf(presentationName) + this.group + " - ";
        }
        presentationName = String.valueOf(presentationName) + this.getName();
        return presentationName;
    }

    @Override
    public String getRedoPresentationName() {
        String presentationName = String.valueOf(UIManager.getString(REDO_TEXT_KEY)) + ' ' + this.getPresentationName();
        return presentationName;
    }

    @Override
    public String getUndoPresentationName() {
        String presentationName = String.valueOf(UIManager.getString(UNDO_TEXT_KEY)) + ' ' + this.getPresentationName();
        return presentationName;
    }

    @Override
    public boolean isSignificant() {
        return true;
    }

    @Override
    public void redo() {
        if (!this.canRedo()) {
            throw new CannotRedoException();
        }
        for (UndoableEdit edit : this.edits) {
            edit.redo();
        }
        this.hasBeenDone = true;
    }

    @Override
    public boolean replaceEdit(UndoableEdit anEdit) {
        return false;
    }

    @Override
    public void undo() {
        if (!this.canUndo()) {
            throw new CannotUndoException();
        }
        int i = this.edits.size() - 1;
        while (i >= 0) {
            this.edits.get(i).undo();
            --i;
        }
        this.hasBeenDone = false;
    }
}

