/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.function;

import tim.prune.App;
import tim.prune.GenericFunction;
import tim.prune.I18nManager;
import tim.prune.UpdateMessageBroker;
import tim.prune.data.AudioClip;
import tim.prune.data.DataPoint;
import tim.prune.undo.UndoDisconnectMedia;

public class DisconnectAudioFunction
extends GenericFunction {
    public DisconnectAudioFunction(App app) {
        super(app);
    }

    public String getNameKey() {
        return "function.disconnectfrompoint";
    }

    public void begin() {
        AudioClip audioClip = this._app.getTrackInfo().getCurrentAudio();
        if (audioClip != null && audioClip.getDataPoint() != null) {
            DataPoint dataPoint = audioClip.getDataPoint();
            UndoDisconnectMedia undoDisconnectMedia = new UndoDisconnectMedia(dataPoint, false, true, audioClip.getName());
            audioClip.setDataPoint(null);
            dataPoint.setAudio(null);
            UpdateMessageBroker.informSubscribers((byte)4);
            this._app.completeFunction(undoDisconnectMedia, I18nManager.getText("confirm.audio.disconnect"));
        }
    }
}

