/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.platform.base.internal.dependents;

import com.google.common.base.Preconditions;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.gradle.internal.Cast;
import org.gradle.platform.base.internal.BinarySpecInternal;
import org.gradle.platform.base.internal.dependents.DefaultDependentBinariesResolutionResult;
import org.gradle.platform.base.internal.dependents.DefaultDependentBinariesResolvedResult;
import org.gradle.platform.base.internal.dependents.DependentBinariesResolutionResult;
import org.gradle.platform.base.internal.dependents.DependentBinariesResolutionStrategy;
import org.gradle.platform.base.internal.dependents.DependentBinariesResolvedResult;
import org.gradle.platform.base.internal.dependents.DependentBinariesResolver;

public class DefaultDependentBinariesResolver
implements DependentBinariesResolver {
    private final Map<String, DependentBinariesResolutionStrategy> strategies = Maps.newLinkedHashMap();

    @Override
    public void register(DependentBinariesResolutionStrategy strategy) {
        Preconditions.checkNotNull((Object)strategy, (Object)"strategy must not be null");
        this.strategies.put(strategy.getName(), strategy);
    }

    @Override
    public <T extends DependentBinariesResolutionStrategy> T getStrategy(String name, Class<T> type) {
        return (T)((DependentBinariesResolutionStrategy)Cast.cast(type, (Object)this.strategies.get(name)));
    }

    @Override
    public DependentBinariesResolutionResult resolve(BinarySpecInternal target) {
        ArrayList roots = Lists.newArrayList();
        for (DependentBinariesResolutionStrategy strategy : this.strategies.values()) {
            DependentBinariesResolutionResult result = strategy.resolve(target);
            roots.add(result.getRoot());
        }
        return new DefaultDependentBinariesResolutionResult(this.mergeResults(roots));
    }

    private DependentBinariesResolvedResult mergeResults(Collection<DependentBinariesResolvedResult> results) {
        DependentBinariesResolvedResult first = results.iterator().next();
        if (results.size() == 1) {
            return first;
        }
        boolean hasNotBuildables = false;
        boolean hasTestSuites = false;
        LinkedListMultimap index = LinkedListMultimap.create();
        ArrayList allChildren = Lists.newArrayList();
        for (DependentBinariesResolvedResult result : results) {
            if (!result.isBuildable()) {
                hasNotBuildables = true;
            }
            if (result.isTestSuite()) {
                hasTestSuites = true;
            }
            allChildren.addAll(result.getChildren());
            for (DependentBinariesResolvedResult child : result.getChildren()) {
                index.put((Object)child.getId(), (Object)child);
            }
        }
        ArrayList children = Lists.newArrayList();
        for (Collection childResults : index.asMap().values()) {
            children.add(this.mergeResults(childResults));
        }
        return new DefaultDependentBinariesResolvedResult(first.getId(), first.getProjectScopedName(), !hasNotBuildables, hasTestSuites, children);
    }
}

