/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.google.common.collect;

import java.util.Comparator;
import java.util.Map;
import org.jetbrains.kotlin.com.google.common.base.Function;
import org.jetbrains.kotlin.com.google.common.collect.ByFunctionOrdering;
import org.jetbrains.kotlin.com.google.common.collect.ComparatorOrdering;
import org.jetbrains.kotlin.com.google.common.collect.ImmutableList;
import org.jetbrains.kotlin.com.google.common.collect.Maps;
import org.jetbrains.kotlin.com.google.common.collect.NaturalOrdering;
import org.jetbrains.kotlin.com.google.common.collect.ReverseOrdering;
import org.jetbrains.kotlin.com.google.errorprone.annotations.CanIgnoreReturnValue;

public abstract class Ordering<T>
implements Comparator<T> {
    public static <C extends Comparable> Ordering<C> natural() {
        return NaturalOrdering.INSTANCE;
    }

    public static <T> Ordering<T> from(Comparator<T> comparator) {
        return comparator instanceof Ordering ? (Ordering<T>)comparator : new ComparatorOrdering<T>(comparator);
    }

    protected Ordering() {
    }

    public <S extends T> Ordering<S> reverse() {
        return new ReverseOrdering(this);
    }

    public <F> Ordering<F> onResultOf(Function<F, ? extends T> function2) {
        return new ByFunctionOrdering<F, T>(function2, this);
    }

    <T2 extends T> Ordering<Map.Entry<T2, ?>> onKeys() {
        return this.onResultOf(Maps.keyFunction());
    }

    @Override
    @CanIgnoreReturnValue
    public abstract int compare(T var1, T var2);

    @CanIgnoreReturnValue
    public <E extends T> ImmutableList<E> immutableSortedCopy(Iterable<E> elements) {
        return ImmutableList.sortedCopyOf(this, elements);
    }
}

