/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.checkers;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.resolve.SinceKotlinAccessibility;
import org.jetbrains.kotlin.resolve.SinceKotlinUtilKt;
import org.jetbrains.kotlin.resolve.checkers.ClassifierUsageChecker;
import org.jetbrains.kotlin.resolve.checkers.ClassifierUsageCheckerContext;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/ApiVersionClassifierUsageChecker;", "Lorg/jetbrains/kotlin/resolve/checkers/ClassifierUsageChecker;", "()V", "check", "", "targetDescriptor", "Lorg/jetbrains/kotlin/descriptors/ClassifierDescriptor;", "element", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "context", "Lorg/jetbrains/kotlin/resolve/checkers/ClassifierUsageCheckerContext;", "frontend"})
public final class ApiVersionClassifierUsageChecker
implements ClassifierUsageChecker {
    public static final ApiVersionClassifierUsageChecker INSTANCE;

    @Override
    public void check(@NotNull ClassifierDescriptor targetDescriptor, @NotNull PsiElement element, @NotNull ClassifierUsageCheckerContext context) {
        Intrinsics.checkParameterIsNotNull((Object)targetDescriptor, (String)"targetDescriptor");
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        SinceKotlinAccessibility accessibility = SinceKotlinUtilKt.checkSinceKotlinVersionAccessibility(targetDescriptor, context.getLanguageVersionSettings());
        if (accessibility instanceof SinceKotlinAccessibility.NotAccessible) {
            context.getTrace().report(Errors.API_NOT_AVAILABLE.on(element, ((SinceKotlinAccessibility.NotAccessible)accessibility).getVersion().getVersionString(), context.getLanguageVersionSettings().getApiVersion().getVersionString()));
        }
    }

    private ApiVersionClassifierUsageChecker() {
    }

    static {
        ApiVersionClassifierUsageChecker apiVersionClassifierUsageChecker;
        INSTANCE = apiVersionClassifierUsageChecker = new ApiVersionClassifierUsageChecker();
    }
}

