/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.provider.runner;

import javax.annotation.Nullable;
import org.gradle.BuildListener;
import org.gradle.BuildResult;
import org.gradle.api.BuildCancelledException;
import org.gradle.api.Transformer;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.invocation.Gradle;
import org.gradle.initialization.BuildEventConsumer;
import org.gradle.internal.InternalBuildAdapter;
import org.gradle.internal.invocation.BuildAction;
import org.gradle.internal.invocation.BuildActionRunner;
import org.gradle.internal.invocation.BuildController;
import org.gradle.tooling.internal.protocol.InternalBuildActionFailureException;
import org.gradle.tooling.internal.protocol.InternalBuildActionVersion2;
import org.gradle.tooling.internal.protocol.InternalBuildCancelledException;
import org.gradle.tooling.internal.protocol.InternalBuildControllerVersion2;
import org.gradle.tooling.internal.protocol.InternalPhasedAction;
import org.gradle.tooling.internal.protocol.PhasedActionResult;
import org.gradle.tooling.internal.provider.BuildActionResult;
import org.gradle.tooling.internal.provider.ClientProvidedPhasedAction;
import org.gradle.tooling.internal.provider.PhasedBuildActionResult;
import org.gradle.tooling.internal.provider.runner.DefaultBuildController;
import org.gradle.tooling.internal.provider.serialization.PayloadSerializer;

public class ClientProvidedPhasedActionRunner
implements BuildActionRunner {
    public void run(BuildAction action, BuildController buildController) {
        if (!(action instanceof ClientProvidedPhasedAction)) {
            return;
        }
        GradleInternal gradle = buildController.getGradle();
        gradle.getStartParameter().setConfigureOnDemand(false);
        ClientProvidedPhasedAction clientProvidedPhasedAction = (ClientProvidedPhasedAction)action;
        PayloadSerializer payloadSerializer = this.getPayloadSerializer(gradle);
        InternalPhasedAction phasedAction = (InternalPhasedAction)payloadSerializer.deserialize(clientProvidedPhasedAction.getPhasedAction());
        this.addBuildListener(phasedAction, buildController);
        try {
            if (clientProvidedPhasedAction.isRunTasks()) {
                buildController.run();
            } else {
                buildController.configure();
            }
        }
        catch (RuntimeException e) {
            RuntimeException unwrappedException = new PhasedActionExceptionTransformer().transform(e);
            if (unwrappedException == null) {
                throw e;
            }
            buildController.setResult((Object)new BuildActionResult(null, payloadSerializer.serialize((Object)unwrappedException)));
        }
        if (!buildController.hasResult()) {
            buildController.setResult((Object)new BuildActionResult(payloadSerializer.serialize(null), null));
        }
    }

    private void addBuildListener(final InternalPhasedAction phasedAction, BuildController buildController) {
        final GradleInternal gradleInternal = buildController.getGradle();
        gradleInternal.addBuildListener((BuildListener)new InternalBuildAdapter(){

            public void projectsEvaluated(Gradle gradle) {
                this.run(phasedAction.getProjectsLoadedAction(), PhasedActionResult.Phase.PROJECTS_LOADED);
            }

            public void buildFinished(BuildResult result) {
                if (result.getFailure() == null) {
                    this.run(phasedAction.getBuildFinishedAction(), PhasedActionResult.Phase.BUILD_FINISHED);
                }
            }

            private void run(@Nullable InternalBuildActionVersion2<?> action, PhasedActionResult.Phase phase) {
                if (action != null) {
                    BuildActionResult result = ClientProvidedPhasedActionRunner.this.runAction(action, gradleInternal);
                    PhasedBuildActionResult res = new PhasedBuildActionResult(result.result, phase);
                    ClientProvidedPhasedActionRunner.this.getBuildEventConsumer(gradleInternal).dispatch((Object)res);
                }
            }
        });
    }

    private <T> BuildActionResult runAction(InternalBuildActionVersion2<T> action, GradleInternal gradle) {
        Object model;
        DefaultBuildController internalBuildController = new DefaultBuildController(gradle);
        try {
            model = action.execute((InternalBuildControllerVersion2)internalBuildController);
        }
        catch (BuildCancelledException e) {
            throw new InternalBuildCancelledException((Throwable)e);
        }
        catch (RuntimeException e) {
            throw new InternalBuildActionFailureException((Throwable)e);
        }
        PayloadSerializer payloadSerializer = this.getPayloadSerializer(gradle);
        return new BuildActionResult(payloadSerializer.serialize(model), null);
    }

    private PayloadSerializer getPayloadSerializer(GradleInternal gradle) {
        return (PayloadSerializer)gradle.getServices().get(PayloadSerializer.class);
    }

    private BuildEventConsumer getBuildEventConsumer(GradleInternal gradle) {
        return (BuildEventConsumer)gradle.getServices().get(BuildEventConsumer.class);
    }

    class PhasedActionExceptionTransformer
    implements Transformer<RuntimeException, RuntimeException> {
        PhasedActionExceptionTransformer() {
        }

        public RuntimeException transform(RuntimeException e) {
            for (Throwable t = e; t != null; t = t.getCause()) {
                if (!(t instanceof InternalBuildActionFailureException) && !(t instanceof InternalBuildCancelledException)) continue;
                return t;
            }
            return null;
        }
    }
}

