/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.play.internal.run;

import com.google.common.collect.ImmutableSet;
import java.io.File;
import org.gradle.api.Action;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.file.collections.ImmutableFileCollection;
import org.gradle.deployment.internal.Deployment;
import org.gradle.internal.fingerprint.ClasspathFingerprinter;
import org.gradle.internal.hash.HashCode;
import org.gradle.normalization.internal.InputNormalizationStrategy;
import org.gradle.play.internal.run.PlayApplication;
import org.gradle.play.internal.run.PlayRunAdapterV22X;
import org.gradle.play.internal.run.PlayRunSpec;
import org.gradle.play.internal.run.PlayRunWorkerClientProtocol;
import org.gradle.play.internal.run.PlayRunWorkerServerProtocol;
import org.gradle.play.internal.run.PlayWorkerServer;
import org.gradle.play.internal.run.VersionedPlayRunAdapter;
import org.gradle.process.internal.JavaExecHandleBuilder;
import org.gradle.process.internal.worker.WorkerProcess;
import org.gradle.process.internal.worker.WorkerProcessBuilder;
import org.gradle.process.internal.worker.WorkerProcessFactory;

public class PlayApplicationRunner {
    private final WorkerProcessFactory workerFactory;
    private final VersionedPlayRunAdapter adapter;
    private final ClasspathFingerprinter fingerprinter;

    public PlayApplicationRunner(WorkerProcessFactory workerFactory, VersionedPlayRunAdapter adapter, ClasspathFingerprinter fingerprinter) {
        this.workerFactory = workerFactory;
        this.adapter = adapter;
        this.fingerprinter = fingerprinter;
    }

    public PlayApplication start(PlayRunSpec spec, Deployment deployment) {
        WorkerProcess process = PlayApplicationRunner.createWorkerProcess(spec.getProjectPath(), this.workerFactory, spec, this.adapter);
        process.start();
        PlayRunWorkerServerProtocol workerServer = (PlayRunWorkerServerProtocol)process.getConnection().addOutgoing(PlayRunWorkerServerProtocol.class);
        PlayApplication playApplication = new PlayApplication(new PlayClassloaderMonitorDeploymentDecorator(deployment, spec, this.adapter), workerServer, process);
        process.getConnection().addIncoming(PlayRunWorkerClientProtocol.class, (Object)playApplication);
        process.getConnection().connect();
        playApplication.waitForRunning();
        return playApplication;
    }

    private static WorkerProcess createWorkerProcess(File workingDir, WorkerProcessFactory workerFactory, PlayRunSpec spec, VersionedPlayRunAdapter adapter) {
        WorkerProcessBuilder builder = workerFactory.create((Action)new PlayWorkerServer(spec, adapter));
        builder.setBaseName("Gradle Play Worker");
        builder.sharedPackages(new String[]{"org.gradle.play.internal.run"});
        JavaExecHandleBuilder javaCommand = builder.getJavaCommand();
        javaCommand.setWorkingDir(workingDir);
        javaCommand.setMinHeapSize(spec.getForkOptions().getMemoryInitialSize());
        javaCommand.setMaxHeapSize(spec.getForkOptions().getMemoryMaximumSize());
        javaCommand.setJvmArgs(spec.getForkOptions().getJvmArgs());
        return builder.build();
    }

    private class PlayClassloaderMonitorDeploymentDecorator
    implements Deployment {
        private final Deployment delegate;
        private final FileCollection applicationClasspath;
        private final boolean isPlay22;
        private HashCode classpathHash;

        private PlayClassloaderMonitorDeploymentDecorator(Deployment delegate, PlayRunSpec runSpec, VersionedPlayRunAdapter adapter) {
            this.delegate = delegate;
            this.applicationClasspath = this.collectApplicationClasspath(runSpec);
            this.isPlay22 = adapter instanceof PlayRunAdapterV22X;
        }

        private FileCollection collectApplicationClasspath(PlayRunSpec runSpec) {
            ImmutableSet applicationClasspath = ImmutableSet.builder().addAll(runSpec.getChangingClasspath()).add((Object)runSpec.getApplicationJar()).build();
            return ImmutableFileCollection.of((Iterable)applicationClasspath);
        }

        public Deployment.Status status() {
            final Deployment.Status delegateStatus = this.delegate.status();
            if (this.isPlay22) {
                return delegateStatus;
            }
            if (!delegateStatus.hasChanged()) {
                return delegateStatus;
            }
            if (this.applicationClasspathChanged()) {
                return delegateStatus;
            }
            return new Deployment.Status(){

                public Throwable getFailure() {
                    return delegateStatus.getFailure();
                }

                public boolean hasChanged() {
                    return false;
                }
            };
        }

        private boolean applicationClasspathChanged() {
            HashCode oldClasspathHash = this.classpathHash;
            this.classpathHash = PlayApplicationRunner.this.fingerprinter.fingerprint(this.applicationClasspath, InputNormalizationStrategy.NO_NORMALIZATION).getHash();
            return !this.classpathHash.equals((Object)oldClasspathHash);
        }
    }
}

