/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.rules;

import java.util.ArrayList;
import java.util.List;
import org.gradle.api.internal.changedetection.rules.TaskStateChange;
import org.gradle.api.internal.changedetection.rules.TaskStateChangeVisitor;
import org.gradle.api.internal.changedetection.rules.TaskStateChanges;

public class CachingTaskStateChanges
implements TaskStateChanges {
    private final TaskStateChanges delegate;
    private final List<TaskStateChange> cache = new ArrayList<TaskStateChange>();
    private final int maxCachedChanges;
    private boolean cached;
    private boolean overrun;

    public CachingTaskStateChanges(int maxCachedChanges, TaskStateChanges delegate) {
        this.maxCachedChanges = maxCachedChanges;
        this.delegate = delegate;
    }

    @Override
    public boolean accept(TaskStateChangeVisitor visitor) {
        if (this.overrun) {
            return this.delegate.accept(visitor);
        }
        if (this.cached) {
            for (TaskStateChange change : this.cache) {
                if (visitor.visitChange(change)) continue;
                return false;
            }
            return true;
        }
        this.cache.clear();
        boolean acceptedAllChanges = this.delegate.accept(new CachingVisitor(visitor));
        this.cached = acceptedAllChanges && !this.overrun;
        return acceptedAllChanges;
    }

    private class CachingVisitor
    implements TaskStateChangeVisitor {
        private final TaskStateChangeVisitor delegate;
        private int numChanges;

        public CachingVisitor(TaskStateChangeVisitor delegate) {
            this.delegate = delegate;
        }

        @Override
        public boolean visitChange(TaskStateChange change) {
            if (this.numChanges < CachingTaskStateChanges.this.maxCachedChanges) {
                ++this.numChanges;
                CachingTaskStateChanges.this.cache.add(change);
            } else {
                CachingTaskStateChanges.this.overrun = true;
                CachingTaskStateChanges.this.cache.clear();
            }
            return this.delegate.visitChange(change);
        }
    }
}

