/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.properties;

import groovy.lang.GString;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.annotation.Nullable;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.tasks.TaskInputPropertySpec;
import org.gradle.api.internal.tasks.properties.PropertyVisitor;
import org.gradle.internal.Factory;
import org.gradle.util.GUtil;

public class GetInputPropertiesVisitor
extends PropertyVisitor.Adapter {
    private final String beanName;
    private List<TaskInputPropertySpec> inputProperties = new ArrayList<TaskInputPropertySpec>();

    public GetInputPropertiesVisitor(String beanName) {
        this.beanName = beanName;
    }

    @Override
    public void visitInputProperty(TaskInputPropertySpec inputProperty) {
        this.inputProperties.add(inputProperty);
    }

    public Factory<Map<String, Object>> getPropertyValuesFactory() {
        return new Factory<Map<String, Object>>(){

            public Map<String, Object> create() {
                HashMap<String, Object> result = new HashMap<String, Object>();
                for (TaskInputPropertySpec inputProperty : GetInputPropertiesVisitor.this.inputProperties) {
                    String propertyName = inputProperty.getPropertyName();
                    try {
                        Object value = GetInputPropertiesVisitor.prepareValue(inputProperty.getValue());
                        result.put(propertyName, value);
                    }
                    catch (Exception ex) {
                        throw new InvalidUserDataException(String.format("Error while evaluating property '%s' of %s", propertyName, GetInputPropertiesVisitor.this.beanName), (Throwable)ex);
                    }
                }
                return result;
            }
        };
    }

    @Nullable
    private static Object prepareValue(@Nullable Object value) {
        while (value instanceof Callable) {
            Callable callable = (Callable)value;
            value = GUtil.uncheckedCall((Callable)callable);
        }
        if (value instanceof FileCollection) {
            FileCollection fileCollection = (FileCollection)value;
            return fileCollection.getFiles();
        }
        return GetInputPropertiesVisitor.avoidGString(value);
    }

    @Nullable
    private static Object avoidGString(@Nullable Object value) {
        return value instanceof GString ? value.toString() : value;
    }
}

