/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.operations.logging;

import java.io.File;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.internal.operations.logging.BuildOperationLogInfo;
import org.gradle.internal.operations.logging.BuildOperationLogger;
import org.gradle.internal.operations.logging.BuildOperationLoggerFactory;
import org.gradle.internal.operations.logging.DefaultBuildOperationLogger;
import org.gradle.util.GFileUtils;

public class DefaultBuildOperationLoggerFactory
implements BuildOperationLoggerFactory {
    private static final int MAX_FAILURES = 10;
    private final Logger logger;

    DefaultBuildOperationLoggerFactory(Logger logger) {
        this.logger = logger;
    }

    public DefaultBuildOperationLoggerFactory() {
        this(Logging.getLogger(DefaultBuildOperationLoggerFactory.class));
    }

    @Override
    public BuildOperationLogger newOperationLogger(String taskName, File outputDir) {
        File outputFile = this.createOutputFile(outputDir);
        BuildOperationLogInfo configuration = this.createLogInfo(taskName, outputFile, 10);
        return new DefaultBuildOperationLogger(configuration, this.logger, outputFile);
    }

    protected File createOutputFile(File outputDir) {
        GFileUtils.mkdirs((File)outputDir);
        return new File(outputDir, "output.txt");
    }

    protected BuildOperationLogInfo createLogInfo(String taskName, File outputFile, int maximumFailures) {
        BuildOperationLogInfo configuration = this.logger.isDebugEnabled() ? new BuildOperationLogInfo(taskName, outputFile, Integer.MAX_VALUE) : new BuildOperationLogInfo(taskName, outputFile, maximumFailures);
        return configuration;
    }
}

