/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.cli.command;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.springframework.boot.cli.command.Command;
import org.springframework.boot.cli.command.CommandException;
import org.springframework.boot.cli.command.NoArgumentsException;
import org.springframework.boot.cli.command.NoSuchCommandException;
import org.springframework.boot.cli.command.status.ExitStatus;
import org.springframework.boot.cli.util.Log;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class CommandRunner
implements Iterable<Command> {
    private static final Set<CommandException.Option> NO_EXCEPTION_OPTIONS = EnumSet.noneOf(CommandException.Option.class);
    private final String name;
    private final List<Command> commands = new ArrayList<Command>();
    private Class<?>[] optionCommandClasses = new Class[0];
    private Class<?>[] hiddenCommandClasses = new Class[0];

    public CommandRunner(String name) {
        this.name = StringUtils.hasLength((String)name) ? name + " " : "";
    }

    public String getName() {
        return this.name;
    }

    public void addCommands(Iterable<Command> commands) {
        Assert.notNull(commands, (String)"Commands must not be null");
        for (Command command : commands) {
            this.addCommand(command);
        }
    }

    public void addCommand(Command command) {
        Assert.notNull((Object)command, (String)"Command must not be null");
        this.commands.add(command);
    }

    public void setOptionCommands(Class<?> ... commandClasses) {
        Assert.notNull(commandClasses, (String)"CommandClasses must not be null");
        this.optionCommandClasses = commandClasses;
    }

    public void setHiddenCommands(Class<?> ... commandClasses) {
        Assert.notNull(commandClasses, (String)"CommandClasses must not be null");
        this.hiddenCommandClasses = commandClasses;
    }

    public boolean isOptionCommand(Command command) {
        return this.isCommandInstanceOf(command, this.optionCommandClasses);
    }

    private boolean isHiddenCommand(Command command) {
        return this.isCommandInstanceOf(command, this.hiddenCommandClasses);
    }

    private boolean isCommandInstanceOf(Command command, Class<?>[] commandClasses) {
        for (Class<?> commandClass : commandClasses) {
            if (!commandClass.isInstance(command)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Iterator<Command> iterator() {
        return this.getCommands().iterator();
    }

    protected final List<Command> getCommands() {
        return Collections.unmodifiableList(this.commands);
    }

    public Command findCommand(String name) {
        for (Command candidate : this.commands) {
            String candidateName = candidate.getName();
            if (!candidateName.equals(name) && (!this.isOptionCommand(candidate) || !("--" + candidateName).equals(name))) continue;
            return candidate;
        }
        return null;
    }

    public int runAndHandleErrors(String ... args) {
        boolean debug;
        String[] argsWithoutDebugFlags = this.removeDebugFlags(args);
        boolean bl = debug = argsWithoutDebugFlags.length != args.length;
        if (debug) {
            System.setProperty("debug", "true");
        }
        try {
            ExitStatus result = this.run(argsWithoutDebugFlags);
            if (result != null && result.isHangup()) {
                return result.getCode() > 0 ? result.getCode() : 0;
            }
            return 0;
        }
        catch (NoArgumentsException ex) {
            this.showUsage();
            return 1;
        }
        catch (Exception ex) {
            return this.handleError(debug, ex);
        }
    }

    private String[] removeDebugFlags(String[] args) {
        ArrayList<String> rtn = new ArrayList<String>(args.length);
        boolean appArgsDetected = false;
        for (String arg : args) {
            if (("-d".equals(arg) || "--debug".equals(arg)) && !(appArgsDetected |= "--".equals(arg))) continue;
            rtn.add(arg);
        }
        return rtn.toArray(new String[rtn.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ExitStatus run(String ... args) throws Exception {
        if (args.length == 0) {
            throw new NoArgumentsException();
        }
        String commandName = args[0];
        String[] commandArguments = Arrays.copyOfRange(args, 1, args.length);
        Command command = this.findCommand(commandName);
        if (command == null) {
            throw new NoSuchCommandException(commandName);
        }
        this.beforeRun(command);
        try {
            ExitStatus exitStatus = command.run(commandArguments);
            return exitStatus;
        }
        finally {
            this.afterRun(command);
        }
    }

    protected void beforeRun(Command command) {
    }

    protected void afterRun(Command command) {
    }

    private int handleError(boolean debug, Exception ex) {
        Set<CommandException.Option> options = NO_EXCEPTION_OPTIONS;
        if (ex instanceof CommandException && (options = ((CommandException)ex).getOptions()).contains((Object)CommandException.Option.RETHROW)) {
            throw (CommandException)ex;
        }
        boolean couldNotShowMessage = false;
        if (!options.contains((Object)CommandException.Option.HIDE_MESSAGE)) {
            boolean bl = couldNotShowMessage = !this.errorMessage(ex.getMessage());
        }
        if (options.contains((Object)CommandException.Option.SHOW_USAGE)) {
            this.showUsage();
        }
        if (debug || couldNotShowMessage || options.contains((Object)CommandException.Option.STACK_TRACE)) {
            this.printStackTrace(ex);
        }
        return 1;
    }

    protected boolean errorMessage(String message) {
        Log.error(message != null ? message : "Unexpected error");
        return message != null;
    }

    protected void showUsage() {
        Log.infoPrint("usage: " + this.name);
        for (Command command : this.commands) {
            if (!this.isOptionCommand(command)) continue;
            Log.infoPrint("[--" + command.getName() + "] ");
        }
        Log.info("");
        Log.info("       <command> [<args>]");
        Log.info("");
        Log.info("Available commands are:");
        for (Command command : this.commands) {
            if (this.isOptionCommand(command) || this.isHiddenCommand(command)) continue;
            String usageHelp = command.getUsageHelp();
            String description = command.getDescription();
            Log.info(String.format("%n  %1$s %2$-15s%n    %3$s", command.getName(), usageHelp != null ? usageHelp : "", description != null ? description : ""));
        }
        Log.info("");
        Log.info("Common options:");
        Log.info(String.format("%n  %1$s %2$-15s%n    %3$s", "-d, --debug", "Verbose mode", "Print additional status information for the command you are running"));
        Log.info("");
        Log.info("");
        Log.info("See '" + this.name + "help <command>' for more information on a specific command.");
    }

    protected void printStackTrace(Exception ex) {
        Log.error("");
        Log.error(ex);
        Log.error("");
    }
}

