/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.coroutines.internal;

import java.util.Arrays;
import kotlin.Metadata;
import kotlin.PublishedApi;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.internal.ThreadSafeHeapNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000*\u0012\b\u0000\u0010\u0001*\u00020\u0002*\b\u0012\u0004\u0012\u0002H\u00010\u00032\u00060\u0004j\u0002`\u0005B\u0005\u00a2\u0006\u0002\u0010\u0006J\u0015\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00028\u0000H\u0001\u00a2\u0006\u0002\u0010\u0013J\u0013\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0013J!\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00028\u00002\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0017\u00a2\u0006\u0002\u0010\u0018J\u0006\u0010\u0019\u001a\u00020\u0011J\u000f\u0010\u001a\u001a\u0004\u0018\u00018\u0000H\u0001\u00a2\u0006\u0002\u0010\u001bJ\r\u0010\u001c\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\u0002\u0010\u001bJ\u0015\u0010\u001d\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00000\bH\u0002\u00a2\u0006\u0002\u0010\u001eJ\u0013\u0010\u001f\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00028\u0000\u00a2\u0006\u0002\u0010 J\u0015\u0010!\u001a\u00028\u00002\u0006\u0010\"\u001a\u00020\u000eH\u0001\u00a2\u0006\u0002\u0010#J$\u0010$\u001a\u0004\u0018\u00018\u00002\u0012\u0010%\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u000b0&H\u0086\b\u00a2\u0006\u0002\u0010'J\r\u0010(\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\u0002\u0010\u001bJ\u0011\u0010)\u001a\u00020\u00112\u0006\u0010*\u001a\u00020\u000eH\u0082\u0010J\u0011\u0010+\u001a\u00020\u00112\u0006\u0010*\u001a\u00020\u000eH\u0082\u0010J\u0018\u0010,\u001a\u00020\u00112\u0006\u0010*\u001a\u00020\u000e2\u0006\u0010-\u001a\u00020\u000eH\u0002R\u001a\u0010\u0007\u001a\f\u0012\u0006\u0012\u0004\u0018\u00018\u0000\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\tR\u0011\u0010\n\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\fR\u0018\u0010\r\u001a\u00020\u000e8\u0000@\u0000X\u0081\u000e\u00a2\u0006\b\n\u0000\u0012\u0004\b\u000f\u0010\u0006\u00a8\u0006."}, d2={"Lkotlinx/coroutines/internal/ThreadSafeHeap;", "T", "Lkotlinx/coroutines/internal/ThreadSafeHeapNode;", "", "", "Lkotlinx/coroutines/internal/SynchronizedObject;", "()V", "a", "", "[Lkotlinx/coroutines/internal/ThreadSafeHeapNode;", "isEmpty", "", "()Z", "size", "", "size$annotations", "addImpl", "", "node", "(Lkotlinx/coroutines/internal/ThreadSafeHeapNode;)V", "addLast", "addLastIf", "cond", "Lkotlin/Function0;", "(Lkotlinx/coroutines/internal/ThreadSafeHeapNode;Lkotlin/jvm/functions/Function0;)Z", "clear", "firstImpl", "()Lkotlinx/coroutines/internal/ThreadSafeHeapNode;", "peek", "realloc", "()[Lkotlinx/coroutines/internal/ThreadSafeHeapNode;", "remove", "(Lkotlinx/coroutines/internal/ThreadSafeHeapNode;)Z", "removeAtImpl", "index", "(I)Lkotlinx/coroutines/internal/ThreadSafeHeapNode;", "removeFirstIf", "predicate", "Lkotlin/Function1;", "(Lkotlin/jvm/functions/Function1;)Lkotlinx/coroutines/internal/ThreadSafeHeapNode;", "removeFirstOrNull", "siftDownFrom", "i", "siftUpFrom", "swap", "j", "kotlinx-coroutines-core"})
public final class ThreadSafeHeap<T extends ThreadSafeHeapNode & Comparable<? super T>> {
    private T[] a;
    @JvmField
    public volatile int size;

    public final boolean isEmpty() {
        return this.size == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final T peek() {
        T t;
        ThreadSafeHeap lock$iv = this;
        synchronized (lock$iv) {
            t = this.firstImpl();
        }
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final T removeFirstOrNull() {
        T t;
        ThreadSafeHeap lock$iv = this;
        synchronized (lock$iv) {
            t = this.size > 0 ? (T)this.removeAtImpl(0) : null;
        }
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean addLastIf(@NotNull T node, @NotNull Function0<Boolean> cond) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull(node, (String)"node");
        Intrinsics.checkParameterIsNotNull(cond, (String)"cond");
        ThreadSafeHeap lock$iv = this;
        synchronized (lock$iv) {
            boolean bl2;
            if (((Boolean)cond.invoke()).booleanValue()) {
                this.addImpl(node);
                bl2 = true;
            } else {
                bl2 = false;
            }
            bl = bl2;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean remove(@NotNull T node) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull(node, (String)"node");
        ThreadSafeHeap lock$iv = this;
        synchronized (lock$iv) {
            boolean bl2;
            if (node.getIndex() < 0) {
                bl2 = false;
            } else {
                this.removeAtImpl(node.getIndex());
                bl2 = true;
            }
            bl = bl2;
        }
        return bl;
    }

    @PublishedApi
    @Nullable
    public final T firstImpl() {
        return (T)(this.a != null ? this.a[0] : null);
    }

    /*
     * Unable to fully structure code
     */
    @PublishedApi
    @NotNull
    public final T removeAtImpl(int index) {
        block7: {
            v0 = var2_2 = this.size > 0;
            if (!var2_2) {
                var3_4 = "Check failed.";
                throw (Throwable)new IllegalStateException(var3_4.toString());
            }
            if (this.a == null) {
                Intrinsics.throwNpe();
            }
            a = this.a;
            var3_5 = this.size;
            this.size = var3_5 + -1;
            if (index >= this.size) break block7;
            this.swap(index, this.size);
            j = (index - 1) / 2;
            if (index <= 0) ** GOTO lbl-1000
            v1 = a[index];
            if (v1 == null) {
                Intrinsics.throwNpe();
            }
            v2 = (Comparable)v1;
            v3 = a[j];
            if (v3 == null) {
                Intrinsics.throwNpe();
            }
            if (v2.compareTo(v3) < 0) {
                this.swap(index, j);
                this.siftUpFrom(j);
            } else lbl-1000:
            // 2 sources

            {
                this.siftDownFrom(index);
            }
        }
        v4 = a[this.size];
        if (v4 == null) {
            Intrinsics.throwNpe();
        }
        result = v4;
        result.setIndex(-1);
        a[this.size] = null;
        return result;
    }

    @PublishedApi
    public final void addImpl(@NotNull T node) {
        Intrinsics.checkParameterIsNotNull(node, (String)"node");
        ThreadSafeHeapNode[] a = this.realloc();
        int n = this.size;
        this.size = n + 1;
        int i = n;
        a[i] = node;
        node.setIndex(i);
        this.siftUpFrom(i);
    }

    private final void siftUpFrom(int i) {
        while (i > 0) {
            if (this.a == null) {
                Intrinsics.throwNpe();
            }
            T[] a = this.a;
            int j = (i - 1) / 2;
            T t = a[j];
            if (t == null) {
                Intrinsics.throwNpe();
            }
            Comparable comparable = (Comparable)t;
            T t2 = a[i];
            if (t2 == null) {
                Intrinsics.throwNpe();
            }
            if (comparable.compareTo(t2) <= 0) {
                return;
            }
            this.swap(i, j);
            i = j;
        }
        return;
    }

    private final void siftDownFrom(int i) {
        int j;
        while ((j = 2 * i + 1) < this.size) {
            if (this.a == null) {
                Intrinsics.throwNpe();
            }
            T[] a = this.a;
            if (j + 1 < this.size) {
                T t = a[j + 1];
                if (t == null) {
                    Intrinsics.throwNpe();
                }
                Comparable comparable = (Comparable)t;
                T t2 = a[j];
                if (t2 == null) {
                    Intrinsics.throwNpe();
                }
                if (comparable.compareTo(t2) < 0) {
                    ++j;
                }
            }
            T t = a[i];
            if (t == null) {
                Intrinsics.throwNpe();
            }
            Comparable comparable = (Comparable)t;
            T t3 = a[j];
            if (t3 == null) {
                Intrinsics.throwNpe();
            }
            if (comparable.compareTo(t3) <= 0) {
                return;
            }
            this.swap(i, j);
            i = j;
        }
        return;
    }

    private final T[] realloc() {
        Object[] objectArray;
        T[] a = this.a;
        if (a == null) {
            ThreadSafeHeapNode[] threadSafeHeapNodeArray;
            ThreadSafeHeapNode[] it = threadSafeHeapNodeArray = new ThreadSafeHeapNode[4];
            this.a = it;
            objectArray = threadSafeHeapNodeArray;
        } else if (this.size >= a.length) {
            T[] TArray = a;
            int it = this.size * 2;
            T[] TArray2 = Arrays.copyOf(TArray, it);
            Intrinsics.checkExpressionValueIsNotNull(TArray2, (String)"java.util.Arrays.copyOf(this, newSize)");
            TArray = TArray2;
            ThreadSafeHeapNode[] it2 = (ThreadSafeHeapNode[])TArray;
            this.a = it2;
            objectArray = (ThreadSafeHeapNode[])TArray;
        } else {
            objectArray = a;
        }
        return objectArray;
    }

    private final void swap(int i, int j) {
        if (this.a == null) {
            Intrinsics.throwNpe();
        }
        T[] a = this.a;
        T t = a[j];
        if (t == null) {
            Intrinsics.throwNpe();
        }
        T ni = t;
        T t2 = a[i];
        if (t2 == null) {
            Intrinsics.throwNpe();
        }
        T nj = t2;
        a[i] = ni;
        a[j] = nj;
        ni.setIndex(i);
        nj.setIndex(j);
    }
}

