/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.ant;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.apache.ivy.core.IvyContext;
import org.apache.ivy.core.IvyPatternHelper;
import org.apache.ivy.core.event.IvyEvent;
import org.apache.ivy.plugins.trigger.AbstractTrigger;
import org.apache.ivy.plugins.trigger.Trigger;
import org.apache.ivy.util.Message;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.Ant;
import org.apache.tools.ant.taskdefs.Property;

public class AntBuildTrigger
extends AbstractTrigger
implements Trigger {
    private boolean onlyOnce = true;
    private String target = null;
    private Collection builds = new ArrayList();
    private String buildFilePattern;
    private String prefix;

    @Override
    public void progress(IvyEvent ivyEvent) {
        File file = this.getBuildFile(ivyEvent);
        if (file.exists()) {
            if (this.onlyOnce && this.isBuilt(file)) {
                Message.verbose("target build file already built, skipping: " + file);
            } else {
                Ant ant = new Ant();
                Project project = (Project)IvyContext.peekInContextStack("ant-project");
                if (project == null) {
                    project = new Project();
                    project.init();
                }
                ant.setProject(project);
                ant.setTaskName("ant");
                ant.setAntfile(file.getAbsolutePath());
                ant.setInheritAll(false);
                String string = this.getTarget();
                if (string != null) {
                    ant.setTarget(string);
                }
                Map map = ivyEvent.getAttributes();
                for (String string2 : map.keySet()) {
                    String string3 = (String)map.get(string2);
                    if (string3 == null) continue;
                    Property property = ant.createProperty();
                    property.setName(this.prefix == null ? string2 : this.prefix + string2);
                    property.setValue(string3);
                }
                Message.verbose("triggering build: " + file + " target=" + string + " for " + ivyEvent);
                try {
                    ant.execute();
                }
                catch (BuildException buildException) {
                    Message.verbose("Exception occurred while executing target " + string);
                    buildException.printStackTrace();
                    throw buildException;
                }
                this.markBuilt(file);
                Message.debug("triggered build finished: " + file + " target=" + string + " for " + ivyEvent);
            }
        } else {
            Message.verbose("no build file found for dependency, skipping: " + file);
        }
    }

    private void markBuilt(File file) {
        this.builds.add(file.getAbsolutePath());
    }

    private boolean isBuilt(File file) {
        return this.builds.contains(file.getAbsolutePath());
    }

    private File getBuildFile(IvyEvent ivyEvent) {
        return IvyContext.getContext().getSettings().resolveFile(IvyPatternHelper.substituteTokens(this.getBuildFilePattern(), ivyEvent.getAttributes()));
    }

    public String getBuildFilePattern() {
        return this.buildFilePattern;
    }

    public void setAntfile(String string) {
        this.buildFilePattern = string;
    }

    public String getTarget() {
        return this.target;
    }

    public void setTarget(String string) {
        this.target = string;
    }

    public boolean isOnlyonce() {
        return this.onlyOnce;
    }

    public void setOnlyonce(boolean bl) {
        this.onlyOnce = bl;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String string) {
        this.prefix = string;
        if (!string.endsWith(".")) {
            this.prefix = this.prefix + ".";
        }
    }
}

