/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.ant;

import java.io.File;
import org.apache.ivy.ant.IvyPostResolveTask;
import org.apache.ivy.core.IvyPatternHelper;
import org.apache.ivy.core.cache.ResolutionCacheManager;
import org.apache.ivy.core.module.descriptor.Artifact;
import org.apache.ivy.core.resolve.ResolveOptions;
import org.apache.ivy.plugins.report.XmlReportParser;
import org.apache.tools.ant.BuildException;

public class IvyArtifactProperty
extends IvyPostResolveTask {
    private String name;
    private String value;
    private boolean overwrite = false;

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String string) {
        this.value = string;
    }

    public void setOverwrite(boolean bl) {
        this.overwrite = bl;
    }

    @Override
    public void doExecute() throws BuildException {
        this.prepareAndCheck();
        try {
            ResolutionCacheManager resolutionCacheManager = this.getIvyInstance().getResolutionCacheManager();
            String[] stringArray = this.splitConfs(this.getConf());
            String string = this.getResolveId();
            if (string == null) {
                string = ResolveOptions.getDefaultResolveId(this.getResolvedModuleId());
            }
            XmlReportParser xmlReportParser = new XmlReportParser();
            for (int i = 0; i < stringArray.length; ++i) {
                File file = resolutionCacheManager.getConfigurationResolveReportInCache(string, stringArray[i]);
                xmlReportParser.parse(file);
                Artifact[] artifactArray = xmlReportParser.getArtifacts();
                for (int j = 0; j < artifactArray.length; ++j) {
                    Artifact artifact = artifactArray[j];
                    String string2 = IvyPatternHelper.substitute(this.getSettings().substitute(this.getName()), artifact, stringArray[i]);
                    String string3 = IvyPatternHelper.substitute(this.getSettings().substitute(this.getValue()), artifact, stringArray[i]);
                    this.setProperty(string2, string3);
                }
            }
        }
        catch (Exception exception) {
            throw new BuildException("impossible to add artifact properties: " + exception, (Throwable)exception);
        }
    }

    private void setProperty(String string, String string2) {
        if (this.overwrite) {
            this.getProject().setProperty(string, string2);
        } else {
            this.getProject().setNewProperty(string, string2);
        }
    }
}

